-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

function UAB_CopyGroupActions:UabInit(actionsetcode, stancecode, unitgroupcode)
    if not self.uabframes then
        self.uabframes = {}
        self.uabframes.groups = {}

        self.uabframes.okbutton = getglobal(self:GetName().."OK")
        self.uabframes.okbutton:SetScript("OnClick", function(self, button, down) self:GetParent():UabOkOnClick() end)
    
    	local names = {}
    	for key, val in pairs(uab.constants.groupInfo) do
            table.insert(names, key)
    	end

        table.insert(names, "hostile")
    	table.sort(names)
        
        local pframe
        for idx = 1, # names, 1 do
            local frame
            local gname
            local ftext
            
            if names[idx] == "hostile" then
                frame = CreateFrame("CheckButton", self:GetName().."Hostile", self, "OptionsCheckButtonTemplate")
                gname = "hostile"
                ftext = "Hostile"
            else
                local info = uab.constants.groupInfo[names[idx]]

                frame = CreateFrame("CheckButton", self:GetName()..info.name, self, "OptionsCheckButtonTemplate")
                gname = info.name
                ftext = info.displayName
            end

            self.uabframes.groups[gname] = frame
            
            frame:SetWidth(24)
            frame:SetHeight(24)
            frame:ClearAllPoints()
            
            if not pframe then
                frame:SetPoint("TOPLEFT", self, "TOPLEFT", 30, -40)
            else
                frame:SetPoint("TOPLEFT", pframe, "BOTTOMLEFT", 0, 0)
            end
    
            getglobal(frame:GetName().."Text"):SetText(ftext)

            pframe = frame
    	end
    end

    self.uabactionsetcode = actionsetcode
    self.uabstancecode = stancecode
    self.uabunitgroupcode = unitgroupcode

    for _, frame in pairs(self.uabframes.groups) do
        frame:SetChecked(nil)
        frame:Show()
    end

    if self.uabunitgroupcode ~= -1 then
        self.uabframes.groups[uab.constants.unitgroupstatename[self.uabunitgroupcode]]:Hide()
    else
        self.uabframes.groups.hostile:Hide()
    end
end

function UAB_CopyGroupActions:UabOkOnClick()
    local actionsetobj = uab:GetActionSetObj(self.uabactionsetcode)
    local actionsetdata = uab.db.profile.actionsets[actionsetobj:GetName()]
    local stancedata = actionsetdata.stances[self.uabstancecode]
    local currentunitgroupname
    local currentunitgroupdata
    local anycopied = {}

    uab:SetPendingAttributes()

    if self.uabunitgroupcode ~= -1 then
        currentunitgroupname = uab.constants.unitgroupstatename[self.uabunitgroupcode]
    else
        currentunitgroupname = "hostile"
    end

    currentunitgroupdata = stancedata and stancedata[currentunitgroupname]

    for name, frame in pairs(self.uabframes.groups) do
        if frame:GetChecked() then
            if name ~= "hostile" then
                local unitgroupcode = uab.constants.groupInfo[name].code
                table.insert(anycopied, unitgroupcode)

                UAB_ConfigFrameTab2Frame:ClearActionSetStanceUnitGroupActions(self.uabactionsetcode, self.uabstancecode, unitgroupcode)
                
                if currentunitgroupdata then
                    stancedata[name] = uab.CloneTable(currentunitgroupdata)
                end
    
                local newactiondata = stancedata and stancedata[name]
                
                for idx = 1, 24, 1 do
                    if newactiondata and newactiondata[idx] then
                        local wrapper = uabActionWrapper:CreateActionWrapper(newactiondata[idx])
                        actionsetobj:AddAction(self.uabstancecode, unitgroupcode, idx, wrapper)
                    end
                end
            else
                allgroups = true
            
                UAB_ConfigFrameTab2Frame:ClearActionSetStanceUnitGroupActions(self.uabactionsetcode, self.uabstancecode, -1)
                
                if currentunitgroupdata then
                    stancedata[name] = uab.CloneTable(currentunitgroupdata)
                end
    
                local newactiondata = stancedata and stancedata[name]
                
                for idx = 1, 24, 1 do
                    if newactiondata and newactiondata[idx] then
                        local wrapper = uabActionWrapper:CreateActionWrapper(newactiondata[idx], true)
                        actionsetobj:AddHostileAction(self.uabstancecode, idx, wrapper)
                    end
                end
            end
        end
    end

    if allgroups then
        uab:IterateActivatorsCallGlobal(uabConfig.ReApplyASUGLayoutAttributes, { stancecode = self.uabstancecode, actionsetobj = actionsetobj })
    else
        for idx, unitgroupcode in pairs(anycopied) do
            uab:IterateActivatorsCallGlobal(uabConfig.ReApplyASUGLayoutAttributesForUnitGroup, { unitgroupcode = unitgroupcode, stancecode = self.uabstancecode, actionsetobj = actionsetobj })
        end
    end

    uab:ClearPendingAttributes()

    self:Hide()
end

