-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

function UAB_CopyStanceActions:UabInit(actionsetcode, stancecode)
    if not self.uabframes then
        self.uabframes = {}

        self.uabframes.okbutton = getglobal(self:GetName().."OK")
        self.uabframes.okbutton:SetScript("OnClick", function(self, button, down) self:GetParent():UabOkOnClick() end)

        local frame = CreateFrame("CheckButton", self:GetName().."Stance0", self, "OptionsCheckButtonTemplate")
        self.uabframes.stances = {}

        self.uabframes.stances[0] = frame

        frame:SetWidth(24)
        frame:SetHeight(24)
        frame:ClearAllPoints()
        
        frame:SetPoint("TOPLEFT", self, "TOPLEFT", 30, -30)
        getglobal(frame:GetName().."Text"):SetText("Stance 0 (Normal)")
    
        local pframe = frame
    
        for stance = 1, uab.MaxCurrentClassStances(), 1 do
            frame = CreateFrame("CheckButton", self:GetName().."Stance"..stance, self, "OptionsCheckButtonTemplate")

            self.uabframes.stances[stance] = frame
            
            frame:SetWidth(24)
            frame:SetHeight(24)
            frame:ClearAllPoints()
            
            frame:SetPoint("TOPLEFT", pframe, "BOTTOMLEFT", 0, 0)

            local text = "Stance "..stance
            name = uab.GetStanceName(stance)

            if name then
                text = text .. " ("..name..")"
            else
                text = text .. " (N/A)"
            end                
    
            getglobal(frame:GetName().."Text"):SetText(text)
            pframe = frame
    	end
    end

    self.uabactionsetcode = actionsetcode
    self.uabstancecode = stancecode

    for _, frame in pairs(self.uabframes.stances) do
        frame:SetChecked(nil)
        frame:Show()
    end

    self.uabframes.stances[self.uabstancecode]:Hide()
end

function UAB_CopyStanceActions:UabOkOnClick()
    local actionsetobj = uab:GetActionSetObj(self.uabactionsetcode)
    local actionsetdata = uab.db.profile.actionsets[actionsetobj:GetName()]
    local currentstancedata = actionsetdata.stances[self.uabstancecode]
    local anycopied = {}

    uab:SetPendingAttributes()

    for code, frame in pairs(self.uabframes.stances) do
        if frame:GetChecked() then
            table.insert(anycopied, code)

            UAB_ConfigFrameTab2Frame:ClearActionSetStanceActions(self.uabactionsetcode, code)

            if currentstancedata then
                actionsetdata.stances[code] = uab.CloneTable(currentstancedata)
            end

            local newstancedata = actionsetdata.stances[code]

            if newstancedata and newstancedata.hostile then
                for idx = 1, 24, 1 do
                    if newstancedata.hostile[idx] then
                        local wrapper = uabActionWrapper:CreateActionWrapper(newstancedata.hostile[idx], true)
                        actionsetobj:AddHostileAction(code, idx, wrapper)
                    end
                end
            end

            for name, info in pairs(uab.constants.groupInfo) do
                if newstancedata and newstancedata[name] then
                    for idx = 1, 24, 1 do
                        if newstancedata[name][idx] then
                            local wrapper = uabActionWrapper:CreateActionWrapper(newstancedata[name][idx])
                            actionsetobj:AddAction(code, info.code, idx, wrapper)
                        end
                    end
                end
            end
        end
    end

    for idx, stancecode in pairs(anycopied) do
        uab:IterateActivatorsCallGlobal(uabConfig.ReApplyASUGLayoutAttributes, { stancecode = stancecode, actionsetobj = actionsetobj })
    end

    uab:ClearPendingAttributes()

    self:Hide()
end

