-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

function UAB_ActionMessage:UabInit(actionsetcode, stancecode, unitgroupcode, actionindex)
    self.uabframes = {}

    self.uabframes.grouped = getglobal(self:GetName().."Grouped")
    self.uabframes.default = getglobal(self:GetName().."Default")
    self.uabframes.channel = getglobal(self:GetName().."DefaultChannel")
    self.uabframes.ok = getglobal(self:GetName().."OK")
    self.uabframes.ok:SetScript("OnClick", function(self, button, down) UAB_ActionMessage:UabOkOnClick() end)
    
    self.uabcontext = {
        actionsetcode = actionsetcode,
        stancecode = stancecode,
        unitgroupcode = unitgroupcode,
        actionindex = actionindex
    }

    local actionsetobj = uab:GetActionSetObj(actionsetcode)
    local actions = actionsetobj:GetActions(stancecode, unitgroupcode)
    local wrapper = actions[actionindex]
    local msginfo = wrapper:GetMessageInfo()

    if msginfo and msginfo.msg then
        getglobal(self:GetName().."Text"):SetText(msginfo.msg)
    else
        getglobal(self:GetName().."Text"):SetText("")
    end

    getglobal(self:GetName().."Enable"):SetChecked(msginfo and msginfo.enable)

    self.uabcontext.groupMsgChannel = (msginfo and msginfo.groupch) or "Default"
    self.uabcontext.defaultMsgChannel = (msginfo and msginfo.defaultch) or "Self"
    self.uabcontext.chatChannel = (msginfo and msginfo.channel) or "1"

    self:UabInitActionMessageDropdowns()
end

function UAB_ActionMessage:UabInitActionMessageDropdowns()
    UIDropDownMenu_Initialize(self.uabframes.grouped,
        function()
            UAB_ActionMessage:FillActionMessageGrouped()
        end)
	UIDropDownMenu_SetWidth(110, self.uabframes.grouped)
	UIDropDownMenu_SetButtonWidth(24, self.uabframes.grouped)
	UIDropDownMenu_JustifyText("LEFT", self.uabframes.grouped)
    
    UIDropDownMenu_Initialize(self.uabframes.default,
        function()
            UAB_ActionMessage:FillActionMessageDefault()
        end)
	UIDropDownMenu_SetWidth(110, self.uabframes.default)
	UIDropDownMenu_SetButtonWidth(24, self.uabframes.default)
	UIDropDownMenu_JustifyText("LEFT", self.uabframes.default)
    
    UIDropDownMenu_Initialize(self.uabframes.channel,
        function()
            UAB_ActionMessage:FillActionMessageChannel()
        end)
	UIDropDownMenu_SetWidth(110, self.uabframes.channel)
	UIDropDownMenu_SetButtonWidth(24, self.uabframes.channel)
	UIDropDownMenu_JustifyText("LEFT", self.uabframes.channel)
end

function UAB_ActionMessage:FillActionMessageGrouped()
	local options = {}

    table.insert(options, {
            text = "Raid",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageGrouped", arg1 = "Raid" }})
    table.insert(options, {
            text = "Party",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageGrouped", arg1 = "Party" }})
    table.insert(options, {
            text = "Default",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageGrouped", arg1 = "Default" }})
    table.insert(options, {
            text = "None",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageGrouped", arg1 = "None" }})

    local selected = nil

    for index, data in pairs(options) do
        UIDropDownMenu_AddButton(data)
        if data.arg2.arg1 == self.uabcontext.groupMsgChannel then
            selected = data.text
        end
    end

    UIDropDownMenu_SetSelectedName(self.uabframes.grouped, selected)
end

function UAB_ActionMessage:SelectActionMessageGrouped(selector, selection)
    UIDropDownMenu_SetSelectedName(self.uabframes.grouped, selection)
    self.uabcontext.groupMsgChannel = selection
end

function UAB_ActionMessage:FillActionMessageDefault()
	local options = {}
    
    table.insert(options, {
            text = "Say",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageDefault", arg1 = "Say" }})
    table.insert(options, {
            text = "Self",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageDefault", arg1 = "Self" }})
    table.insert(options, {
            text = "Emote",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageDefault", arg1 = "Emote" }})
    table.insert(options, {
            text = "Channel",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageDefault", arg1 = "Channel" }})
    table.insert(options, {
            text = "None",
            func = uab.DropDownSelect,
            arg1 = self,
            arg2 = { func = "SelectActionMessageDefault", arg1 = "None" }})

    local selected = nil

    for index, data in pairs(options) do
        UIDropDownMenu_AddButton(data)
        if data.arg2.arg1 == self.uabcontext.defaultMsgChannel then
            selected = data.text
        end
    end

    UIDropDownMenu_SetSelectedName(self.uabframes.default, selected)
end

function UAB_ActionMessage:SelectActionMessageDefault(selector, selection)
    UIDropDownMenu_SetSelectedName(self.uabframes.default, selection)
    self.uabcontext.defaultMsgChannel = selection
end

function UAB_ActionMessage:FillActionMessageChannel()
	local options = {}

    for channel = 1, 10, 1 do    
        table.insert(options, {
                text = "" .. channel,
                func = uab.DropDownSelect,
                arg1 = self,
                arg2 = { func = "SelectActionMessageChannel", arg1 = "" .. channel }})
    end

    local selected = nil

    for index, data in pairs(options) do
        UIDropDownMenu_AddButton(data)
        if tonumber(data.arg2.arg1) == tonumber(self.uabcontext.chatChannel) then
            selected = data.text
        end
    end

    UIDropDownMenu_SetSelectedName(self.uabframes.channel, selected)
end

function UAB_ActionMessage:SelectActionMessageChannel(selector, selection)
    UIDropDownMenu_SetSelectedName(self.uabframes.channel, selection)
    self.uabcontext.chatChannel = tonumber(selection)
end

function UAB_ActionMessage:UabOkOnClick()
    local enable = getglobal(self:GetName().."Enable"):GetChecked()
    local newmessage = getglobal(self:GetName().."Text"):GetText()
    local msginfo

    if newmessage and newmessage ~= "" then
        msginfo = {
            enable = enable,
            msg = newmessage,
            groupch = self.uabcontext.groupMsgChannel,
            defaultch = self.uabcontext.defaultMsgChannel,
            channel = self.uabcontext.chatChannel
        }
    else
        msginfo = nil
    end

    local actionsetobj = uab:GetActionSetObj(self.uabcontext.actionsetcode)
    local actions = actionsetobj:GetActions(self.uabcontext.stancecode, self.uabcontext.unitgroupcode)
    local wrapper = actions[self.uabcontext.actionindex]

    wrapper:SetMessageInfo(msginfo)

    local dbactionset = uab.db.profile.actionsets[actionsetobj:GetName()]
    local dbstance = dbactionset.stances[self.uabcontext.stancecode]
    local dbgroup = dbstance[uab.constants.unitgroupstatename[self.uabcontext.unitgroupcode]]

    dbgroup[self.uabcontext.actionindex].message = msginfo

    self:Hide()
end

