-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

function UAB_NewActionSet:UabInit(currentactionsetcode)
    self.uabcopyfromactionsetcode = currentactionsetcode
    if not self.uabinitialized then
        self.uabframes = {}
        self.uabframes.okbutton = getglobal(self:GetName().."OK")
        
        self.uabframes.okbutton:SetScript("OnClick", function(self, button, down) UAB_NewActionSet:UabOkOnClick() end)
        self.uabframes.name = getglobal(self:GetName().."Name")
    end
end

function UAB_NewActionSet:UabOkOnClick()
    local newname = self.uabframes.name:GetText()

    uab:SetPendingAttributes()

    if newname and newname ~= "" then
        if not getglobal(self:GetName().."Copy"):GetChecked() then
            self.uabcopyfromactionsetcode = nil
        end

        self.uabnewactionsetcode = uab:CreateNewActionSet(newname)
        
        if self.uabcopyfromactionsetcode then
            --[[
            Duplicate all the actions from the "copyfrom" action set to this
            one.
            --]]

            local newactionsetobj = uab:GetActionSetObj(self.uabnewactionsetcode)
            local newactionsetdata = uab.db.profile.actionsets[newactionsetobj:GetName()]
            local copyfromactionsetobj = uab:GetActionSetObj(self.uabcopyfromactionsetcode)
            local copyfromactionsetdata = uab.db.profile.actionsets[copyfromactionsetobj:GetName()]

            for stance = 0, uab.MaxCurrentClassStances(), 1 do
                uab.ClearTable(newactionsetdata.stances)
                newactionsetdata.stances = uab.CloneTable(copyfromactionsetdata.stances)
                for name, info in pairs(uab.constants.groupInfo) do
                    for idx = 1, 24, 1 do
                        if newactionsetdata.stances[stance] then
                            if newactionsetdata.stances[stance][name] then
                                if newactionsetdata.stances[stance][name][idx] then
                                    local wrapper = uabActionWrapper:CreateActionWrapper(newactionsetdata.stances[stance][name][idx])
                                    newactionsetobj:AddAction(stance, info.code, idx, wrapper)
                                end
                            end
                        end
                    end
                end
            end
        end

        UAB_ConfigFrameTab2Frame:RefreshActionSets()
        uabLayoutManager:AddActionSetOptions()
    end

    uab:ClearPendingAttributes()
    
    self:Hide()
end

