-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 57502 $"):match("%d+")), ("$Date: 2007-12-26 13:54:31 -0500 (Wed, 26 Dec 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
Class to manage the config dialog for the add-on.  Handles all config dialog functionality.
--]]

uabConfig = uab:NewModule("Configuration")

uabConfig.core = uab
uabConfig.configtabs = {}
uabConfig.mixins = {}
uabConfig.mixins.dewdrop = AceLibrary("Dewdrop-2.0")

function uabConfig:OnInitialize()

    local prior_order = self.core.options.args.effectsettings.order
    
    self.core.options.args.configure = {
        type = 'execute',
        name = "Configure",
        desc = "Configure activators and action set buttons",
        order = prior_order + 10,
        func = function()
            UAB_ConfigFrame:Show()
            uabConfig.mixins.dewdrop:Close()
        end,
    }

    self.core.options.args.spacing_config = {
        name = " ",
        type = 'header',
        order = prior_order + 11,
    }
end

function uabConfig:RegisterConfigTabFrame(tabnum, frame)
    self.configtabs[tabnum] = frame
    if not self.firsttab or tabnum < self.firsttab then
        self.firsttab = tabnum
    end
end

function uabConfig:OnEnable()
    for _, frame in pairs(self.configtabs) do
        frame:UabInit()
    end

    self:ActivateTab(self.firsttab)
end

function uabConfig:ActivateTab(tabnum)
    local tabframe

    for idx, frame in pairs(self.configtabs) do
        frame:Hide()

        getglobal("UAB_ConfigFrameTab"..idx):Show()
        getglobal("UAB_ConfigFrameTab"..idx.."Selector"):SetChecked(nil)
        getglobal("UAB_ConfigFrameTab"..idx.."ActiveBarTop"):Hide()
        getglobal("UAB_ConfigFrameTab"..idx.."ActiveBarBottom"):Hide()
        
        if tabnum == idx then
            tabframe = frame
        end
    end

    if tabframe then
        getglobal("UAB_ConfigFrameTab"..tabnum):Show()
        getglobal("UAB_ConfigFrameTab"..tabnum.."Selector"):SetChecked(true)
        getglobal("UAB_ConfigFrameTab"..tabnum.."ActiveBarTop"):Show()
        getglobal("UAB_ConfigFrameTab"..tabnum.."ActiveBarBottom"):Show()
    
        tabframe:Show()
    end
end

function uabConfig.ReApplyASUGLayoutAttributes(activatorobj, params)
    local pending = uab:SetPendingAttributes()

    if activatorobj:HasActionSetForCode(params.actionsetobj.actionsetcode) then
        -- ReApplyLayoutAttributes for all ActivatorStanceUnitGroup instances tied to
        -- this stance for this action set.

        for name, info in pairs(uab.constants.groupInfo) do
            local activatorstanceunitgroupobj = activatorobj:GetUnitGroupObj(params.stancecode, info.code)
    
            activatorstanceunitgroupobj:ReApplyLayoutAttributes()
        end
                
        -- For this stance for every activator tied to this action set, need
        -- to re-apply the "direct cast" / "button cast" settings for every unit group
        -- in this stance.
        for state, data in pairs(uab.state_data) do
            local activatorcode = data.activatorcode
            local stancecode = data.stancecode
            if activatorcode == activatorobj.activatorcode and stancecode == params.stancecode then
                local stanceobj = data.activatorobj:GetStanceObj(stancecode)
                local hostile_count = stanceobj:NumHostileActions()
                local unitgroupcode = uab:GetUnitGroupCode(state)
                local friendly_count = stanceobj:NumActions(unitgroupcode)
        
                for _, ctrlobj in pairs(uab:ActivatorFrameControlObjs(state)) do
                    uab:ApplyDirectCastToActivatorFrameControl(state, ctrlobj, hostile_count, friendly_count)
                end
            end
        end
    end

    if pending then
        uab:ClearPendingAttributes()
    end
end

function uabConfig.ReApplyASUGLayoutAttributesForUnitGroup(activatorobj, params)
    local pending = uab:SetPendingAttributes()

    if activatorobj:HasActionSetForCode(params.actionsetobj.actionsetcode) then
        -- ReApplyLayoutAttributes for all ActivatorStanceUnitGroup instances tied to
        -- this stance for this action set.

        local activatorstanceunitgroupobj = activatorobj:GetUnitGroupObj(params.stancecode, params.unitgroupcode)

        activatorstanceunitgroupobj:ReApplyLayoutAttributes()
                
        -- For this stance for every activator tied to this action set, need
        -- to re-apply the "direct cast" / "button cast" settings for every unit group
        -- in this stance.
        for state, data in pairs(uab.state_data) do
            local activatorcode = data.activatorcode
            local stancecode = data.stancecode
            local unitgroupcode = data.unitgroupcode
            if activatorcode == activatorobj.activatorcode and stancecode == params.stancecode and unitgroupcode == params.unitgroupcode then
                local stanceobj = data.activatorobj:GetStanceObj(stancecode)
                local hostile_count = stanceobj:NumHostileActions()
                local friendly_count = stanceobj:NumActions(unitgroupcode)
        
                for _, ctrlobj in pairs(uab:ActivatorFrameControlObjs(state)) do
                    uab:ApplyDirectCastToActivatorFrameControl(state, ctrlobj, hostile_count, friendly_count)
                end
            end
        end
    end

    if pending then
        uab:ClearPendingAttributes()
    end
end

