-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
Class to manage the config dialog for the add-on.  Handles all config dialog functionality.
--]]

local UAB_ACTIVATOR_LIST_NUM_ROWS = 5
local UAB_ACTIVATOR_LIST_ROW_HEIGHT = 17

local UAB_ASSOCIATEDACTIONSET_LIST_NUM_ROWS = 5
local UAB_ASSOCIATEDACTIONSET_LIST_ROW_HEIGHT = 17

local ActivatorConfigFrame = UAB_ConfigFrameTab1Frame

function ActivatorConfigFrame:UabTabFrameShow()
end
            
function ActivatorConfigFrame:UabTabFrameHide()
end

function ActivatorConfigFrame:UabInit()
    self.uabframes = {}
    self.uabframes.activator = getglobal(self:GetName() .. "Activator")
    self.uabframes.setactivator = getglobal(self:GetName() .. "ActivatorSelect")
    self.uabframes.addassociated = getglobal(self:GetName() .. "Add")
    self.uabframes.removeassociated = getglobal(self:GetName() .. "Remove")

    self.uabframes.setactivator:RegisterForClicks("LeftButtonDown", "RightButtonDown", "MiddleButtonDown", "Button4Down", "Button5Down")
    self.uabframes.setactivator:SetScript("OnClick", function(self, button, down) ActivatorConfigFrame:UabSetActivation(button) end)
    self.uabframes.addassociated:SetScript("OnClick", function(self, button, down) ActivatorConfigFrame:UabAddAssociation() end)
    self.uabframes.removeassociated:SetScript("OnClick", function(self, button, down) ActivatorConfigFrame:UabRemoveAssociation() end)

    self:SetupActivators()
    self:SetupAssociatedActionSets()
    self:SetupNonAssociatedActionSets()

    self:CurrentActivatorChanged()
end

function ActivatorConfigFrame:UabSetActivation(button)
    local modifiers = {}
    
    if ( IsShiftKeyDown() ) then
        modifiers.prefixshift = true
    end

    if ( IsAltKeyDown() ) then
        modifiers.prefixalt = true
    end

    if ( IsControlKeyDown() ) then
        modifiers.prefixctrl = true
    end

    modifiers.button = button

    local frame = getglobal(self:GetName().."Activator")

	for idx = 1, # frame.uabactivatordata, 1 do
        local index = frame.uabactivatordata[idx].index
        local info = uab.constants.activatorInfo[index]

        if info.button == modifiers.button and
            info.prefixshift == modifiers.prefixshift and
            info.prefixalt == modifiers.prefixalt and
            info.prefixctrl == modifiers.prefixctrl then
            self.uabselectedactivatoridx = idx
            break
        end
    end

    local scrollframe = getglobal(frame:GetName().."ScrollFrame")
	local scrollbar = getglobal(scrollframe:GetName().."ScrollBar")
	local offset

    if self.uabselectedactivatoridx < FauxScrollFrame_GetOffset(scrollframe) then
        offset = self.uabselectedactivatoridx-1
    	scrollbar:SetValue(offset*UAB_ACTIVATOR_LIST_ROW_HEIGHT)
        FauxScrollFrame_SetOffset(scrollframe, offset)
    elseif self.uabselectedactivatoridx > (FauxScrollFrame_GetOffset(scrollframe) + UAB_ACTIVATOR_LIST_NUM_ROWS) then
    	offset = (self.uabselectedactivatoridx-UAB_ACTIVATOR_LIST_NUM_ROWS)
    	scrollbar:SetValue(offset*UAB_ACTIVATOR_LIST_ROW_HEIGHT)
        FauxScrollFrame_SetOffset(scrollframe, offset)
    end

    self:CurrentActivatorChanged()
end

function ActivatorConfigFrame:UabAddAssociation()
    if self.uabselectedactivatoridx then
        if self.uabselectedactionsetcode then
            local activatorcode = getglobal(self:GetName().."Activator").uabactivatordata[self.uabselectedactivatoridx].index
            local activatorobj = uab:GetActivatorObj(activatorcode)

            uab:AssociateActivatorToActionSet(activatorcode, self.uabselectedactionsetcode)
            self.uabselectedassociatedactionsetcode = self.uabselectedactionsetcode
            self.uabselectedactionsetcode = nil
            
            self:CurrentActivatorChanged()
            uab:BuildActivatorOptions(true)
        end
    end
end

function ActivatorConfigFrame:UabRemoveAssociation()
    if self.uabselectedactivatoridx then
        if self.uabselectedassociatedactionsetcode then
            local activatorcode = getglobal(self:GetName().."Activator").uabactivatordata[self.uabselectedactivatoridx].index
            local activatorobj = uab:GetActivatorObj(activatorcode)

            uab:DisassociateActivatorToActionSet(activatorcode, self.uabselectedassociatedactionsetcode)
            self.uabselectedactionsetcode = self.uabselectedassociatedactionsetcode
            self.uabselectedassociatedactionsetcode = nil
            
            self:CurrentActivatorChanged()
            uab:BuildActivatorOptions(true)
        end
    end
end

function ActivatorConfigFrame:CurrentActivatorChanged()
    self:BuildAssociatedActionSets()
    self:BuildNonAssociatedActionSets()

    self:RefreshActivators()
    self:RefreshAssociatedActionSets()
    self:RefreshNonAssociatedActionSets()
end

function ActivatorConfigFrame:BuildAssociatedActionSets()
    local frame = getglobal(self:GetName().."AssociatedActionSets")
	local codes = {}
	local sortednames = {}

    for code, _ in pairs(frame.uabactionsetcodes) do
        frame.uabactionsetcodes[code] = nil
    end

    if self.uabselectedactivatoridx then
        local activatorcode = getglobal(self:GetName().."Activator").uabactivatordata[self.uabselectedactivatoridx].index
        local activatorobj = uab:GetActivatorObj(activatorcode)
        local actionsetcodes = activatorobj:GetActionSetCodes()
        
        for code, _ in pairs(actionsetcodes) do
            local actionsetobj = uab:GetActionSetObj(code)

            codes[actionsetobj.name] = code
            table.insert(sortednames, actionsetobj.name)
        end
    end

    table.sort(sortednames)

    for idx = 1, #sortednames, 1 do
        frame.uabactionsetcodes[idx] = { name = sortednames[idx], code = codes[sortednames[idx]] }
    end

    local selectedcode = self.uabselectedassociatedactionsetcode
    self.uabselectedassociatedactionsetcode = nil

    if selectedcode then
        for idx, info in pairs(frame.uabactionsetcodes) do
            if selectedcode == info.code then
                self.uabselectedassociatedactionsetcode = info.code
                break
            end
        end
    end
end

function ActivatorConfigFrame:BuildNonAssociatedActionSets()
    local frame = getglobal(self:GetName().."NonAssociatedActionSets")
	local codes = {}
	local sortednames = {}

    for code, _ in pairs(frame.uabactionsetcodes) do
        frame.uabactionsetcodes[code] = nil
    end

    if self.uabselectedactivatoridx then
        local activatorcode = getglobal(self:GetName().."Activator").uabactivatordata[self.uabselectedactivatoridx].index
        local activatorobj = uab:GetActivatorObj(activatorcode)
        local actionsetcodes = activatorobj:GetActionSetCodes()

        for code, actionsetobj in pairs(uab.actionsetobjs) do
            if not actionsetcodes[code] then
                codes[actionsetobj.name] = code
                table.insert(sortednames, actionsetobj.name)
            end
        end
    end

    table.sort(sortednames)

    for idx = 1, #sortednames, 1 do
        frame.uabactionsetcodes[idx] = { name = sortednames[idx], code = codes[sortednames[idx]] }
    end

    local selectedcode = self.uabselectedactionsetcode
    self.uabselectedactionsetcode = nil

    if selectedcode then
        for idx, info in pairs(frame.uabactionsetcodes) do
            if selectedcode == info.code then
                self.uabselectedactionsetcode = info.code
                break
            end
        end
    end
end

function ActivatorConfigFrame:RefreshActivators()
    local frame = getglobal(self:GetName().."Activator")
    local scrollframe = getglobal(frame:GetName().."ScrollFrame")

	FauxScrollFrame_Update(
		scrollframe,
		#frame.uabactivatordata,
		UAB_ACTIVATOR_LIST_NUM_ROWS,
		UAB_ACTIVATOR_LIST_ROW_HEIGHT)

	for idx = 1, UAB_ACTIVATOR_LIST_NUM_ROWS, 1 do
		local itemIndex = idx + FauxScrollFrame_GetOffset(scrollframe)
        local data = {}
        local rowframe = getglobal(frame:GetName().."Line"..idx)

        if itemIndex <= #frame.uabactivatordata then
            rowframe:Show()

            local highlightframe = getglobal(rowframe:GetName().."Highlight")
            local textframe = getglobal(rowframe:GetName().."NameText")
    
            textframe:SetText(frame.uabactivatordata[itemIndex].name)
            if self.uabselectedactivatoridx == itemIndex then
                highlightframe:Show()
            else
                highlightframe:Hide()
            end
        else
            rowframe:Hide()
        end
	end

    if self.uabselectedactivatoridx then
        local activatorcode = frame.uabactivatordata[self.uabselectedactivatoridx].index
    
        getglobal(self:GetName().."AssociatedActionSets"):Show()
        getglobal(self:GetName().."NonAssociatedActionSets"):Show()
        getglobal(self:GetName().."Remove"):Show()
        getglobal(self:GetName().."Add"):Show()
    else
        getglobal(self:GetName().."AssociatedActionSets"):Hide()
        getglobal(self:GetName().."NonAssociatedActionSets"):Hide()
        getglobal(self:GetName().."Remove"):Hide()
        getglobal(self:GetName().."Add"):Hide()
    end
end

function ActivatorConfigFrame:RefreshAssociatedActionSets()
    local frame = getglobal(self:GetName().."AssociatedActionSets")
    local selectedactionsetcode

    local scrollframe = getglobal(frame:GetName().."ScrollFrame")

    FauxScrollFrame_Update(
        scrollframe,
        #frame.uabactionsetcodes,
        UAB_ASSOCIATEDACTIONSET_LIST_NUM_ROWS,
        UAB_ASSOCIATEDACTIONSET_LIST_ROW_HEIGHT)

    for idx = 1, UAB_ASSOCIATEDACTIONSET_LIST_NUM_ROWS, 1 do
        local itemIndex = idx + FauxScrollFrame_GetOffset(scrollframe)
        local rowframe = getglobal(frame:GetName().."ActionSet"..idx)

        if itemIndex <= #frame.uabactionsetcodes then
            local highlightframe = getglobal(rowframe:GetName().."Highlight")
            local textframe = getglobal(rowframe:GetName().."NameText")
    
            rowframe:Show()

            local actionsetobj = uab:GetActionSetObj(frame.uabactionsetcodes[itemIndex].code)

            textframe:SetText(actionsetobj.name)
            if self.uabselectedassociatedactionsetcode == actionsetobj.actionsetcode then
                highlightframe:Show()
            else
                highlightframe:Hide()
            end
        else
            rowframe:Hide()
        end
    end
    
    if self.uabselectedassociatedactionsetcode then
        getglobal(self:GetName().."Remove"):Enable()
    else
        getglobal(self:GetName().."Remove"):Disable()
    end
end

function ActivatorConfigFrame:RefreshNonAssociatedActionSets()
    local frame = getglobal(self:GetName().."NonAssociatedActionSets")
    local scrollframe = getglobal(frame:GetName().."ScrollFrame")

    FauxScrollFrame_Update(
        scrollframe,
        #frame.uabactionsetcodes,
        UAB_ASSOCIATEDACTIONSET_LIST_NUM_ROWS,
        UAB_ASSOCIATEDACTIONSET_LIST_ROW_HEIGHT)

    for idx = 1, UAB_ASSOCIATEDACTIONSET_LIST_NUM_ROWS, 1 do
        local itemIndex = idx + FauxScrollFrame_GetOffset(scrollframe)
        local rowframe = getglobal(frame:GetName().."ActionSet"..idx)

        if itemIndex <= #frame.uabactionsetcodes then
            local highlightframe = getglobal(rowframe:GetName().."Highlight")
            local textframe = getglobal(rowframe:GetName().."NameText")
    
            rowframe:Show()

            local actionsetobj = uab:GetActionSetObj(frame.uabactionsetcodes[itemIndex].code)

            textframe:SetText(actionsetobj.name)
            if self.uabselectedactionsetcode == actionsetobj.actionsetcode then
                highlightframe:Show()
            else
                highlightframe:Hide()
            end
        else
            rowframe:Hide()
        end
    end
    
    if self.uabselectedactionsetcode then
        getglobal(self:GetName().."Add"):Enable()
    else
        getglobal(self:GetName().."Add"):Disable()
    end
end

function ActivatorConfigFrame:BuildActivators()
    local frame = getglobal(self:GetName().."Activator")
	local names = {}
	local sortednames = {}
    
    for idx, info in pairs(uab.constants.activatorInfo) do
        local name
        
        if info.prefixshift then
            if name then
                name = name .. "+Shift"
            else
                name = "Shift"
            end
        end
        
        if info.prefixctrl then
            if name then
                name = name .. "+Ctrl"
            else
                name = "Ctrl"
            end
        end
        
        if info.prefixalt then
            if name then
                name = name .. "+Alt"
            else
                name = "Alt"
            end
        end

        if name then
            name = name .. " " .. info.button
        else
            name = info.button
        end

        names[name] = idx
        table.insert(sortednames, name)
    end

	table.sort(sortednames)

	for idx = 1, #sortednames, 1 do
        if not frame.uabactivatordata[idx] then
            frame.uabactivatordata[idx] = { name = sortednames[idx], index = names[sortednames[idx]] }
        else
            frame.uabactivatordata[idx].name = sortednames[idx]
            frame.uabactivatordata[idx].index = names[sortednames[idx]]
        end
    end
    
    self.uabselectedactivatoridx = nil
end

local function ActivatorConfigFrameRefreshActivators()
    ActivatorConfigFrame:RefreshActivators()
end

function ActivatorConfigFrame:SetupActivators()
    local frame = getglobal(self:GetName().."Activator")
    
    frame.uabactivatordata = {}

    self:BuildActivators()
    getglobal(frame:GetName().."ScrollFrame"):SetScript("OnVerticalScroll", function() FauxScrollFrame_OnVerticalScroll(UAB_ACTIVATOR_LIST_ROW_HEIGHT, ActivatorConfigFrameRefreshActivators) end)
end

local function ActivatorConfigFrameRefreshNonAssociatedActionSets()
    ActivatorConfigFrame:RefreshNonAssociatedActionSets()
end

function ActivatorConfigFrame:SetupNonAssociatedActionSets()
    local frame = getglobal(self:GetName().."NonAssociatedActionSets")

    frame.uabactionsetcodes = {}
    
    getglobal(frame:GetName().."ScrollFrame"):SetScript("OnVerticalScroll", function() FauxScrollFrame_OnVerticalScroll(UAB_ASSOCIATEDACTIONSET_LIST_ROW_HEIGHT, ActivatorConfigFrameRefreshNonAssociatedActionSets) end)
end

local function ActivatorConfigFrameRefreshAssociatedActionSets()
    ActivatorConfigFrame:RefreshAssociatedActionSets()
end

function ActivatorConfigFrame:SetupAssociatedActionSets()
    local frame = getglobal(self:GetName().."AssociatedActionSets")

    frame.uabactionsetcodes = {}

    getglobal(frame:GetName().."ScrollFrame"):SetScript("OnVerticalScroll", function() FauxScrollFrame_OnVerticalScroll(UAB_ASSOCIATEDACTIONSET_LIST_ROW_HEIGHT, ActivatorConfigFrameRefreshAssociatedActionSets) end)
end

function ActivatorConfigFrame:UabActivatorListEntryButtonOnClick(entryframe)
    self.uabselectedactivatoridx = entryframe:GetID() + FauxScrollFrame_GetOffset(getglobal(self:GetName().."ActivatorScrollFrame"))
    
    self:CurrentActivatorChanged()
end

function ActivatorConfigFrame:UabActionSetListEntryButtonOnClick(entryframe, entryframeparent)
    local id = entryframe:GetID()
    local nonassociatedframe = getglobal(self:GetName().."NonAssociatedActionSets")
    local associatedframe = getglobal(self:GetName().."AssociatedActionSets")
    local scrollframe = getglobal(entryframeparent:GetName().."ScrollFrame")
    local index = id + FauxScrollFrame_GetOffset(scrollframe)
    local code = entryframeparent.uabactionsetcodes and entryframeparent.uabactionsetcodes[index] and entryframeparent.uabactionsetcodes[index].code

    if code then    
        if entryframeparent == nonassociatedframe then
            if self.uabselectedactionsetcode ~= code then
                self.uabselectedactionsetcode = code
            else
                self.uabselectedactionsetcode = nil
            end
    
            self:RefreshNonAssociatedActionSets()
        else
            if self.uabselectedassociatedactionsetcode ~= code then
                self.uabselectedassociatedactionsetcode = code
            else
                self.uabselectedassociatedactionsetcode = nil
            end
    
            self:RefreshAssociatedActionSets()
        end
    end
end

uabConfig:RegisterConfigTabFrame(1, ActivatorConfigFrame)

