-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 17:50:18 -0400 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabFuBarMenu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")

uabFuBarMenu.name = "UnitActionBars"
uabFuBarMenu.hasIcon = "Interface\\CURSOR\\\Cast"
uabFuBarMenu.defaultPosition = "RIGHT"
uabFuBarMenu.defaultMinimapPosition = 90
uabFuBarMenu.hideWithoutStandby = true
uabFuBarMenu.independentProfile = true
uabFuBarMenu.hasNoColor = true
uabFuBarMenu.cannotDetachTooltip = true

function uabFuBarMenu:OnInitialize()
	self.db = uab:AcquireDBNamespace("FuBar")

	uab.options.args.fubar_spacer = {
		order = 79,
		type = "header",
	}
    
	uab.options.args.fubar = {
        order = 80,
        type = "group",
        name = "FuBar Options",
        desc = "Options for the FuBar configuration",
        args = {},
	}
    
    uab.mixins.aceConsole:InjectAceOptionsTable(self, uab.options.args.fubar)
	self.OnMenuRequest = uab.options
end

function uabFuBarMenu:OnTooltipUpdate()
	local cat = uab.mixins.tablet:AddCategory("columns", 1)
	cat:AddLine("header", "Unit Action Bars")

	uab.mixins.tablet:SetHint("|cffeda55fClick|r to bring up waterfall configuration.")
end

function uabFuBarMenu:OnClick()
	if uab.mixins.waterfall then
		uab.mixins.waterfall:Open("UnitActionBars")
	else
		self:Print("Waterfall-1.0 is required to access the General UnitActionBars Configuration Interface.")
	end
end
