-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54567 $"):match("%d+")), ("$Date: 2007-11-13 19:55:31 -0500 (Tue, 13 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActivatorStanceUnitGroupActionButtons = uab.mixins.aceOO.Class()

--[[
This class encapsulates access to all the action sets, and the action buttons within each of
those action sets, for a given activator, stance, and unit group.
--]]
function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:init(activatorcode, stancecode, unitgroupcode, actionsetcode)
	uab.classes.ActivatorStanceUnitGroupActionButtons.super.prototype.init(self)

    self.secureheadercode = -1
    self.activatorcode = activatorcode
    self.stancecode = stancecode
    self.unitgroupcode = unitgroupcode
    self.actionsetcode = actionsetcode
    
    self.actionbuttonobjs = {}
    self.cancelbuttonframecode = "" .. actionsetcode .. "_" .. uab.CalculateState(activatorcode, stancecode, 0, unitgroupcode)
    self.cancelobj = uab.classes.ActionButtonCancel:new(nil, self.cancelbuttonframecode)
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:Dump(dumper)
    dumper:Dump("Activator Stance Unit Group Action Set Action Buttons")
    dumper:IncIndent()
    dumper:Dump("Secure Header Code: "..(self.secureheadercode or "nil"))
    dumper:Dump("Activator Code    : "..self.activatorcode)
    dumper:Dump("Stance Code       : "..self.stancecode)
    dumper:Dump("Unit Group Code   : "..self.unitgroupcode)
    dumper:Dump("Action Set Code   : "..self.actionsetcode)

    dumper:Dump("Cancel Button")
    dumper:IncIndent()    
    self.cancelobj:Dump(dumper)
    dumper:DecIndent()
    
    dumper:Dump("Action Buttons")
    dumper:IncIndent()
    
    for idx, buttonobj in pairs(self.actionbuttonobjs) do
        dumper:Dump("Index: "..idx)
        buttonobj:Dump(dumper)
    end

    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:ApplyPendingAttributes()
    self.cancelobj:ApplyPendingAttributes(secureheadercode)
    for idx, buttonobj in pairs(self.actionbuttonobjs) do
        buttonobj:ApplyPendingAttributes(secureheadercode)
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:SetSecureHeaderFromCode(secureheadercode)
    self.secureheadercode = secureheadercode
    if secureheadercode ~= -1 then
        self.cancelobj:SetSecureHeaderFromCode(secureheadercode)
        for idx, buttonobj in pairs(self.actionbuttonobjs) do
            buttonobj:SetSecureHeaderFromCode(secureheadercode)
        end
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:ReApplyStayOpen()
    for idx, buttonobj in pairs(self.actionbuttonobjs) do
        buttonobj:ReApplyStayOpen(self.activatorcode)
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:SetFriendlyAction(idx, actionobj)
    if not self.actionbuttonobjs[idx] then
        self.actionbuttonobjs[idx] = uab.classes.ActionButton:new(self.activatorcode, self.stancecode, self.unitgroupcode, self.actionsetcode, idx)
        if self.secureheadercode ~= -1 then
            self.actionbuttonobjs[idx]:SetSecureHeaderFromCode(self.secureheadercode)
        end
    end
    
    self.actionbuttonobjs[idx]:SetFriendlyAction(actionobj)
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:ClearFriendlyAction(idx)
    if self.actionbuttonobjs[idx] then
        self.actionbuttonobjs[idx]:ClearFriendlyAction()
        if not self.actionbuttonobjs[idx]:AnyAction() then
            self.actionbuttonobjs[idx]:Release()
            self.actionbuttonobjs[idx] = nil
        end
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:SetHostileAction(idx, actionobj)
    if not self.actionbuttonobjs[idx] then
        self.actionbuttonobjs[idx] = uab.classes.ActionButton:new(self.activatorcode, self.stancecode, self.unitgroupcode, self.actionsetcode, idx)
        if self.secureheadercode ~= -1 then
            self.actionbuttonobjs[idx]:SetSecureHeaderFromCode(self.secureheadercode)
        end
    end
    
    self.actionbuttonobjs[idx]:SetHostileAction(actionobj)
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:ClearHostileAction(idx)
    if self.actionbuttonobjs[idx] then
        self.actionbuttonobjs[idx]:ClearHostileAction()
        if not self.actionbuttonobjs[idx]:AnyAction() then
            self.actionbuttonobjs[idx]:Release()
            self.actionbuttonobjs[idx] = nil
        end
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:PrepareForLayouts()
    for _, buttonobj in pairs(self.actionbuttonobjs) do
        buttonobj:PrepareForLayouts()
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:LayoutsDone()
    for _, buttonobj in pairs(self.actionbuttonobjs) do
        buttonobj:LayoutsDone()
    end
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:GetCancelButton()
    return self.cancelobj
end

function uab.classes.ActivatorStanceUnitGroupActionButtons.prototype:GetActionButtons()
    return self.actionbuttonobjs
end

