-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActivatorStanceUnitGroup = uab.mixins.aceOO.Class()

--[[
This class encapsulates access to all the action sets, and the action buttons within each of
those action sets, for a given activator, stance, and unit group.
--]]
function uab.classes.ActivatorStanceUnitGroup.prototype:init(activatorcode, stancecode, unitgroupcode)
	uab.classes.ActivatorStanceUnitGroup.super.prototype.init(self)

    self.activatorcode = activatorcode
    self.stancecode = stancecode
    self.unitgroupcode = unitgroupcode
    self.secureheadercode = -1
    
    self.actionsetcodes = {}
    self.actionsetactionbuttonobjs = {}
end

function uab.classes.ActivatorStanceUnitGroup.prototype:Dump(dumper)
    dumper:Dump("Activator Stance Unit Group: ")
    dumper:IncIndent()
    dumper:Dump("Activator Code     : "..self.activatorcode)
    dumper:Dump("Stance Code        : "..self.stancecode)
    dumper:Dump("Unit Group Code    : "..self.unitgroupcode)
    dumper:Dump("Secure Header Code : "..self.secureheadercode)

    dumper:Dump("Action Sets")
    dumper:IncIndent()
    for actionsetcode, _ in pairs(self.actionsetcodes) do
        dumper:Dump(uab:GetActionSetObj(actionsetcode):GetName().." ("..actionsetcode..")")
    end
    dumper:DecIndent()

    dumper:Dump("Action Buttons")

    dumper:IncIndent()
    for _, actionbuttonsobj in pairs(self.actionsetactionbuttonobjs) do
        actionbuttonsobj:Dump(dumper)
    end
    dumper:DecIndent()
    
    dumper:DecIndent()
end

function uab.classes.ActivatorStanceUnitGroup.prototype:ApplyPendingAttributes()
    for _, actionbuttonsobj in pairs(self.actionsetactionbuttonobjs) do
        actionbuttonsobj:ApplyPendingAttributes(self.secureheadercode)
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:SetSecureHeaderFromCode(secureheadercode)
    if secureheadercode ~= -1 and secureheadercode ~= self.secureheadercode then
        self.secureheadercode = secureheadercode
    
        for _, actionbuttonsobj in pairs(self.actionsetactionbuttonobjs) do
            actionbuttonsobj:SetSecureHeaderFromCode(self.secureheadercode)
        end
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:ReApplyStayOpen()
    for _, actionbuttonsobj in pairs(self.actionsetactionbuttonobjs) do
        actionbuttonsobj:ReApplyStayOpen()
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:AddActionSetCode(actionsetcode)
    if not self.actionsetcodes[actionsetcode] then
        self.actionsetcodes[actionsetcode] = true
        self.actionsetactionbuttonobjs[actionsetcode] = uab.classes.ActivatorStanceUnitGroupActionButtons:new(self.activatorcode, self.stancecode, self.unitgroupcode, actionsetcode)
        
        if self.secureheadercode ~= -1 then
            self.actionsetactionbuttonobjs[actionsetcode]:SetSecureHeaderFromCode(self.secureheadercode)
        end
        
        local actionsetobj = uab:GetActionSetObj(actionsetcode)

        actionsetobj:AddActionSetButtons(self.stancecode, self.unitgroupcode, self.actionsetactionbuttonobjs[actionsetcode])
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:RemoveActionSetCode(actionsetcode)
    if self.actionsetcodes[actionsetcode] then
        local actionsetobj = uab:GetActionSetObj(actionsetcode)
        
        actionsetobj:RemoveActionSetButtons(self.stancecode, self.unitgroupcode, self.actionsetactionbuttonobjs[actionsetcode])
        
        self.actionsetactionbuttonobjs[actionsetcode] = nil
        self.actionsetcodes[actionsetcode] = nil
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:DoReApplyLayoutAttributes()
    self.needlayout = nil

    local secureheaderobj = uab:GetSecureHeaderObj(self.secureheadercode)
    local layout_states = {}
    local all_states

    for state, data in pairs(uab.state_data) do
        local activatorcode = data.activatorcode
        local stancecode = data.stancecode
        local unitgroupcode = data.unitgroupcode
        local framegroupcode = data.framegroupcode

        if self.activatorcode == activatorcode and
            self.stancecode == stancecode and
            self.unitgroupcode == unitgroupcode then

            local layoutobj = uabLayoutManager:GetLayout(data.layoutmgrname, data.layoutname)

            if not all_states then
                all_states = ""..state
            else
                all_states = all_states .. "," .. state
            end

            if not layout_states[layoutobj] then
                layout_states[layoutobj] = ""..state
            else
                layout_states[layoutobj] = layout_states[layoutobj] .. "," .. state
            end
        end
    end

    for actionsetcode, _ in pairs(self.actionsetcodes) do
        local actionsetobj = uab:GetActionSetObj(actionsetcode)
        local actionbuttonsobj = self.actionsetactionbuttonobjs[actionsetcode]
        local cancelobj = actionbuttonsobj:GetCancelButton()
        local actions = actionbuttonsobj:GetActionButtons()

        cancelobj:PrepareForLayouts()
        actionbuttonsobj:PrepareForLayouts()
        
        -- If the action set has it's own layout, then position it according to
        -- that layout.  This type of layout applies to all states, so we specify
        -- a state of "*".  However, the state drives the positioning of the action
        -- buttons in relation to the parent frame, cursor, or screen.  This means
        -- that in order for the actions to be positioned properly, the positioning
        -- should be consistent for all states.
        
        if actionsetobj:GetLayoutObj() then
            actionsetobj:GetLayoutObj():ArrangeButtons(cancelobj, actions, all_states)
        else
            for layoutobj, states in pairs(layout_states) do
                layoutobj:ArrangeButtons(cancelobj, actions, states)
            end    
        end
    
        actionbuttonsobj:LayoutsDone()
        cancelobj:LayoutsDone()
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:ReApplyLayoutAttributes()
    if self.secureheadercode == -1 then
        self.needlayout = true
    else
        self:DoReApplyLayoutAttributes()
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:NumActions()
    local numactions = 0
    
    for actionsetcode, _ in pairs(self.actionsetcodes) do
        local actionsetobj = uab:GetActionSetObj(actionsetcode)
        local actions = actionsetobj:GetActions(self.stancecode, self.unitgroupcode)
        
        for idx, _ in pairs(actions) do
            numactions = numactions + 1
        end
    end
    
    return numactions
end

function uab.classes.ActivatorStanceUnitGroup.prototype:GetOnlyAction()
    local actionobj = 0
    
    for actionsetcode, _ in pairs(self.actionsetcodes) do
        local actionsetobj = uab:GetActionSetObj(actionsetcode)
        local actions = actionsetobj:GetActions(self.stancecode, self.unitgroupcode)
        
        for idx, actionobj in pairs(actions) do
            return actionobj
        end
    end
end

function uab.classes.ActivatorStanceUnitGroup.prototype:GetSecureHeaderCode()
    return self.secureheadercode
end

function uab.classes.ActivatorStanceUnitGroup.prototype:IsActionSetForCode(actionsetcode)
    return self.actionsetcodes[actionsetcode]
end

