-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActivatorStance = uab.mixins.aceOO.Class()

function uab.classes.ActivatorStance.prototype:init(activatorcode, stancecode)
	uab.classes.ActivatorStance.super.prototype.init(self)

    self.activatorcode = activatorcode
    self.stancecode = stancecode
	self.activatorframecontrolobjs = {}
    self.actionsetcodes = {}
    
    self.unitgroupobjs = {}
    for name, data in pairs(uab.constants.groupInfo) do
        self.unitgroupobjs[data.code] = uab.classes.ActivatorStanceUnitGroup:new(self.activatorcode, self.stancecode, data.code)
    end
end

function uab.classes.ActivatorStance.prototype:Dump(dumper)
    dumper:Dump("Activator Stance: ")
    dumper:IncIndent()
    dumper:Dump("Activator Code : "..self.activatorcode)
    dumper:Dump("Stance Code    : '"..self.stancecode)
    
    dumper:Dump("Action Sets")
    dumper:IncIndent()
    for actionsetcode, _ in pairs(self.actionsetcodes) do
        dumper:Dump(uab:GetActionSetObj(actionsetcode):GetName().." ("..actionsetcode..")")
    end
    dumper:DecIndent()

    dumper:Dump("Frame Controls")
    dumper:IncIndent()
    for frame, framecontrolobj in pairs(self.activatorframecontrolobjs) do
        framecontrolobj:Dump(dumper)
    end
    dumper:DecIndent()
    
    dumper:Dump("Unit Groups")
    dumper:IncIndent()
    for unitgroupcode, unitgroupobj in pairs(self.unitgroupobjs) do
        unitgroupobj:Dump(dumper)
    end
    dumper:DecIndent()
    
    dumper:DecIndent()
end

function uab.classes.ActivatorStance.prototype:ApplyPendingAttributes()
    for frame, afc in pairs(self.activatorframecontrolobjs) do
        afc:ApplyPendingAttributes()
    end
    for _, unitgroupobj in pairs(self.unitgroupobjs) do
        unitgroupobj:ApplyPendingAttributes()
    end
end

function uab.classes.ActivatorStance.prototype:AddActionSetCode(actionsetcode)
    if not self.actionsetcodes[actionsetcode] then
        self.actionsetcodes[actionsetcode] = true
        for unitgroupcode, unitgroupobj in pairs(self.unitgroupobjs) do
            unitgroupobj:AddActionSetCode(actionsetcode)
        end
    end
end

function uab.classes.ActivatorStance.prototype:RemoveActionSetCode(actionsetcode)
    if self.actionsetcodes[actionsetcode] then
        self.actionsetcodes[actionsetcode] = nil
        for unitgroupcode, unitgroupobj in pairs(self.unitgroupobjs) do
            unitgroupobj:RemoveActionSetCode(actionsetcode)
        end
    end
end

function uab.classes.ActivatorStance.prototype:RegisterFrame(frame)
    local fname = frame:GetName() or "Unknown frame (no name)"
    
    local activatorframecontrolobj = uab.classes.ActivatorFrameControl:new(frame, self.activatorcode, self.stancecode)

    self.activatorframecontrolobjs[frame] = activatorframecontrolobj
    uab:NewActivatorFrameControlObj(activatorframecontrolobj)
end

function uab.classes.ActivatorStance.prototype:UnregisterFrame(frame)
    local afcobj = self.activatorframecontrolobjs[frame]
    if afcobj then
        afcobj:Clear()
        uab:RemoveActivatorFrameControlObj(afcobj)
        self.activatorframecontrolobjs[frame] = nil
    end
end

function uab.classes.ActivatorStance.prototype:ReApplyStayOpen()
    for unitgroupcode, unitgroupobj in pairs(self.unitgroupobjs) do
        unitgroupobj:ReApplyStayOpen()
    end
end

function uab.classes.ActivatorStance.prototype:GetActivatorFrameControlForFrame(frame)
    return self.activatorframecontrolobjs[frame]
end

function uab.classes.ActivatorStance.prototype:GetUnitGroupObj(unitgroupcode)
    return self.unitgroupobjs[unitgroupcode]
end

function uab.classes.ActivatorStance.prototype:NumHostileActions()
    local numactions = 0
    
    for code, _ in pairs(self.actionsetcodes) do
        local actionsetobj = uab:GetActionSetObj(code)
        local actionobjs = actionsetobj:GetHostileActions(self.stancecode)
        
        for idx, _ in pairs(actionobjs) do
            numactions = numactions + 1
        end
    end
    
    return numactions
end

function uab.classes.ActivatorStance.prototype:GetOnlyHostileAction()
    for code, _ in pairs(self.actionsetcodes) do
        local actionsetobj = uab:GetActionSetObj(code)
        local actionobjs = actionsetobj:GetHostileActions(self.stancecode)
        
        for idx, data in pairs(actionobjs) do
            return data
        end
    end
end

function uab.classes.ActivatorStance.prototype:NumActions(unitgroupcode)
    return self:GetUnitGroupObj(unitgroupcode):NumActions()
end

function uab.classes.ActivatorStance.prototype:GetOnlyActionForUnitGroup(unitgroupcode)
    return self:GetUnitGroupObj(unitgroupcode):GetOnlyAction()
end

