-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 44165 $"):match("%d+")), ("$Date: 2007-07-19 00:00:44 -0500 (Thu, 19 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActivatorFrameControl = uab.mixins.aceOO.Class()
uab.classes.ActivatorFrameControl.controls = {}
uab.classes.ActivatorFrameControl.state_count = {}

local afc_class = uab.classes.ActivatorFrameControl

function uab.classes.ActivatorFrameControl:FixControls(activatorcodes, unitgroupcodes, framegroupcodes, stancecodes)
    for ctrl, _ in pairs(self.controls) do
        if (activatorcodes == nil or ctrl:MatchesSomeActivator(activatorcodes)) and
            (unitgroupcodes == nil or ctrl:MatchesSomeUnitGroup(unitgroupcodes)) and
            (framegroupcodes == nil or ctrl:MatchesSomeFrameGroup(framegroupcodes)) and
            (stancecodes == nil or ctrl:MatchesSomeStance(stancecodes)) then
            if ctrl.frame:GetParent() ~= ctrl.unitframe then
                ctrl:ResetParent()
            end
        end
    end
end

local function CalculateState(control)
    return uab.CalculateState(control.activatorcode, control.unitgroupcode, control.framegroupcode, control.stancecode)
end

function uab.classes.ActivatorFrameControl.prototype:init(unitframe, activatorcode, stancecode)
    uab.classes.ActivatorFrameControl.super.prototype.init(self)
    
    local fname = unitframe:GetName()
    if not fname then
        fname = "Unknown frame (no name)"
    end

    afc_class.controls[self] = true

    self.pendingattributes = {}
    self.secureheadercode = -1
    self.unitframe = unitframe
    self.activatorcode = activatorcode
    self.stancecode = stancecode
    self.framegroupcode = uabFrameGroup:GetFrameGroupCode(self.unitframe)
    self.unitgroupcode = uabFrameGroup:GetUnitGroupCode(self.unitframe)
    
--    self.unitgroupcode = uab.GetUnitGroupCodeFromUnitFrame(self.unitframe)

    self.state = CalculateState(self)
    if not afc_class.state_count[self.state] then
        afc_class.state_count[self.state] = 0
    end

    local unit = uab.GetFrameUnit(unitframe)
    if not unit then
        unit = "no unit"
    end

    self.state_index = afc_class.state_count[self.state]
    afc_class.state_count[self.state] = afc_class.state_count[self.state] + 1
    
    self.framename = "UAB_AFC_" .. self.state .. "_" .. self.state_index

    self.unitframeattrs = {}
    self.unitframecastattrs = {}
    self.unitframehostilecastattrs = {}

	--[[
	Create the control frame
	--]]
    self.frame = getglobal(self.framename)
    if not self.frame then
        self.frame = CreateFrame("Button", self.framename, nil, "SecureAnchorButtonTemplate")
    end
    self.frame.uabobj = self

    local frame = self.frame

    frame:SetWidth(1)
    frame:SetHeight(1)
    frame:ClearAllPoints()
    frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
    frame:Show()

    uab.SetFrameLevelAndStrata(frame, 1)

    self:SetAttribute(frame, "useparent-unit", true)
    self:SetAttribute(frame, "useparent-unitsuffix", true)
    
    -- Indicate that the secure header frame should reparent to this control frame
    -- and when this happens, the secure header frame should change state to the
    -- state for this ActivatorFrameControl (regardless of what the current state
    -- is for the secure header).

    self:SetAttribute(frame, "childreparent", true)
    self:SetAttribute(frame, "childstate", "^"..self.state)


    frame:SetParent(self.unitframe)
    uab.SetFrameLevelAndStrata(frame, 1)

    self.unitframe:RegisterForClicks("LeftButtonUp", "MiddleButtonUp", "RightButtonUp", "Button4Up", "Button5Up")

--    self.frame:SetScript("OnClick", function(self, button) self.uabobj:PreClick(button) end)

    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    self.statebuttonpostfix = activatorobj:GetStanceButtonPostfix(self.stancecode)
--    self.statebuttonpostfix = activatorobj.buttoncode
    self.hostilestatebuttonpostfix = "hostile_"..self.statebuttonpostfix

    uabFrameGroup:AddActivatorFrameControlForFrameGroup(self.framegroupcode, self)
end

--[[
function uab.classes.ActivatorFrameControl.prototype:PreClick(button)
    local fname = self.unitframe:GetName()
    if not fname then
        fname = "Unknown frame (no name)"
    end

    uab.print("ActivatorFrameControl:PreClick("..button..") : "..fname)
    uab.print("    state="..self.state..", a="..self.activatorcode..", stance="..self.stancecode..", fg="..self.framegroupcode..", ug="..self.unitgroupcode..")")
end
--]]

function uab.classes.ActivatorFrameControl.prototype:Dump(dumper)
    local fname = self.unitframe:GetName() or "Unknown frame (no name)"
    
    dumper:Dump("Control: "..self.framename)
    dumper:IncIndent()
    
    dumper:Dump("Unit Frame               : "..fname)
    dumper:Dump("Activator Code           : "..self.activatorcode)
    dumper:Dump("Stance Code              : "..self.stancecode)
    dumper:Dump("Frame Group Code         : "..self.framegroupcode)
    dumper:Dump("Unit Group Code          : "..self.unitgroupcode)
    dumper:Dump("State                    : "..self.state)
    dumper:Dump("Secure Header Code       : "..self.secureheadercode)
    dumper:Dump("State Index              : "..self.state_index)
    dumper:Dump("Normal Attribute Postfix : "..self.statebuttonpostfix)
    dumper:Dump("Hostile Attribute Postfix: "..self.hostilestatebuttonpostfix)
    if self.positioning then
        dumper:Dump("Positioning")
        dumper:IncIndent()
        dumper:Dump("Relpoint : "..self.positioning.relpoint)
        dumper:Dump("Point    : "..self.positioning.point)
        dumper:Dump("X        : "..self.positioning.x)
        dumper:Dump("Y        : "..self.positioning.y)
        dumper:DecIndent()
    end
    dumper:Dump("Attributes")
    dumper:IncIndent()
    dumper:DumpFrameAttribute(self.frame, "childreparent")
    dumper:DumpFrameAttribute(self.frame, "childstate")
    dumper:DumpFrameAttribute(self.frame, "useparent-unit")
    dumper:DumpFrameAttribute(self.frame, "useparent-unitsuffix")
    dumper:DumpFrameAttribute(self.frame, "anchorchild")
    dumper:DecIndent()
    dumper:Dump("Unit Frame Attributes")
    dumper:IncIndent()
    for name, _ in pairs(self.unitframeattrs) do
        dumper:DumpFrameAttribute(self.unitframe, name)
    end
    for name, _ in pairs(self.unitframecastattrs) do
        dumper:DumpFrameAttribute(self.unitframe, name)
    end
    for name, _ in pairs(self.unitframehostilecastattrs) do
        dumper:DumpFrameAttribute(self.unitframe, name)
    end
    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActivatorFrameControl.prototype:ApplyPendingAttributes()
	for name, val in pairs(self.pendingattributes) do
		for frame, data in pairs(val) do
    		uab.SetFrameAttribute(frame, name, data.val)
            val[frame] = nil
        end
        self.pendingattributes[name] = nil
	end
end

function uab.classes.ActivatorFrameControl.prototype:SetAttribute(frame, attribute, val)
    if uab:IsPendingAttributes() then
        if not self.pendingattributes[attribute] then
            self.pendingattributes[attribute] = {}
        end
        self.pendingattributes[attribute][frame] = { val = val }
    else
        self:ApplyPendingAttributes()
        uab.SetFrameAttribute(frame, attribute, val)
    end
end

function uab.classes.ActivatorFrameControl.prototype:MatchesSomeActivator(activatorcodes)
    return activatorcodes[self.activatorcode]
end

function uab.classes.ActivatorFrameControl.prototype:MatchesSomeUnitGroup(unitgroupcodes)
    return unitgroupcodes[self.unitgroupcode]
end

function uab.classes.ActivatorFrameControl.prototype:MatchesSomeFrameGroup(framegroupcodes)
    return framegroupcodes[self.framegroupcode]
end

function uab.classes.ActivatorFrameControl.prototype:MatchesSomeStance(stancecodes)
    return stancecodes[self.stancecodes]
end

function uab.classes.ActivatorFrameControl.prototype:SetUnitFrameHarmButton()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    local attrcode = activatorobj:GetPrefix().."harmbutton-"..self.statebuttonpostfix

    self.unitframeattrs[attrcode] = self.hostilestatebuttonpostfix
    self:SetAttribute(self.unitframe, attrcode, self.hostilestatebuttonpostfix)
end

function uab.classes.ActivatorFrameControl.prototype:ClearUnitFrameHarmButton()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    local attrcode = activatorobj:GetPrefix().."harmbutton-"..self.statebuttonpostfix

    self.unitframeattrs[attrcode] = nil
    self:SetAttribute(self.unitframe, attrcode, nil)
end
        
function uab.classes.ActivatorFrameControl.prototype:ReApplySetPointAttributes()
    local state_data = uab.state_data[self.state]
    
    if state_data.relpoint ~= "cursor" and state_data.relpoint ~= "screen" then
        self.frame:ClearAllPoints()
        if not self.positioning then
            self.positioning = {}
        end
    
        self.positioning.relpoint = state_data.relpoint
        self.positioning.point = state_data.point
        self.positioning.x = state_data.x
        self.positioning.y = state_data.y
        
        local fname = self.unitframe:GetName()
        if not fname then
            fname = "Unknown frame (no name)"
        end
    
        self.frame:SetPoint(state_data.point, self.unitframe, state_data.relpoint, state_data.x, state_data.y)
    end
end

function uab.classes.ActivatorFrameControl.prototype:SetSecureHeaderFromCode(secureheadercode)
    if secureheadercode ~= -1 then
        self.secureheadercode = secureheadercode
        self:SetAttribute(self.frame, "anchorchild", uab:GetSecureHeaderObj(secureheadercode):GetFrame())
    end
end

function uab.classes.ActivatorFrameControl.prototype:ResetParent()
    local parent = self.frame:GetParent()

    self.unitframe = parent
    self:ReApplySetPointAttributes()
    
    self:ApplyHostileCast()
    self:ApplyFriendlyCast()
end

function uab.classes.ActivatorFrameControl.prototype:Clear()
    self:ClearHostileCast()
    self:ClearFriendlyCast()
    
    self.unitframe = nil
    uabFrameGroup:RemoveActivatorFrameControlForFrameGroup(self.framegroupcode, self)
end

function uab.classes.ActivatorFrameControl.prototype:ClearHostileCast()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    
    for name, val in pairs(self.unitframehostilecastattrs) do
        self.unitframehostilecastattrs[name] = nil
    end

    if self.hostileclickactiontype == "direct" then
        local action = activatorobj:GetOnlyHostileActionForStance(self.stancecode)
        
        --[[
        These actions contain no modifiers.  We need to add our prefix and postfix to them before setting the values
        --]]        
        local attrs = action:GetActionObj():GetAttributes()
        
        for name, val in pairs(attrs) do
            local index = activatorobj:GetPrefix()..name.."-"..self.hostilestatebuttonpostfix
            
            self.unitframehostilecastattrs[index] = nil
            self:SetAttribute(self.unitframe, index, nil)
        end
    else
        self:SetAttribute(self.unitframe, activatorobj:GetPrefix().."type-"..self.hostilestatebuttonpostfix, nil)
        self:SetAttribute(self.unitframe, activatorobj:GetPrefix().."clickbutton-"..self.hostilestatebuttonpostfix, nil)
    end
    
    self.hostileclickactiontype = nil

    self:ClearUnitFrameHarmButton()
end

function uab.classes.ActivatorFrameControl.prototype:ApplyHostileCast()
    if self.hostileclickactiontype then
        if self.hostileclickactiontype == "direct" then
            self:ApplyHostileDirectCast()
        else
            self:ApplyHostileActionButtonCast()
        end
    end
end

function uab.classes.ActivatorFrameControl.prototype:SetHostileDirectCast()
    if self.hostileclickactiontype ~= "direct" then
        self.hostileclickactiontype = "direct"

        self:ApplyHostileDirectCast()
    end
end
    
function uab.classes.ActivatorFrameControl.prototype:ApplyHostileDirectCast()
    for name, val in pairs(self.unitframehostilecastattrs) do
        self.unitframehostilecastattrs[name] = nil
    end

    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    local action = activatorobj:GetOnlyHostileActionForStance(self.stancecode)
    
    --[[
    These actions contain no modifiers.  We need to add our prefix and postfix to them before setting the values
    --]]        
    local attrs = action:GetActionObj():GetAttributes()
    
    for name, val in pairs(attrs) do
        local index = activatorobj:GetPrefix()..name.."-"..self.hostilestatebuttonpostfix
        
        self.unitframehostilecastattrs[index] = val
        self:SetAttribute(self.unitframe, index, val)
    end
    
    self:SetUnitFrameHarmButton()
end

function uab.classes.ActivatorFrameControl.prototype:SetHostileActionButtonCast()
    if self.hostileclickactiontype ~= "actionbutton" then
        self.hostileclickactiontype = "actionbutton"
    end

    -- the action to setup might have changed, so we always need to associate the click-cast with the correct action.
    self:ApplyHostileActionButtonCast()
end
    
function uab.classes.ActivatorFrameControl.prototype:ApplyHostileActionButtonCast()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)

    for name, val in pairs(self.unitframehostilecastattrs) do
        self.unitframehostilecastattrs[name] = nil
    end

    local typeattr = activatorobj:GetPrefix().."type-"..self.hostilestatebuttonpostfix
    local clickattr = activatorobj:GetPrefix().."clickbutton-"..self.hostilestatebuttonpostfix

    self.unitframehostilecastattrs[typeattr] = "click"
    self.unitframehostilecastattrs[clickattr] = self.frame
    
    self:SetAttribute(self.unitframe, typeattr, "click")
    self:SetAttribute(self.unitframe, clickattr, self.frame)
    
    self:SetUnitFrameHarmButton()
end

function uab.classes.ActivatorFrameControl.prototype:ClearFriendlyCast()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    
    for name, val in pairs(self.unitframecastattrs) do
        self.unitframecastattrs[name] = nil
    end

    if self.clickactiontype == "direct" then
        local action = activatorobj:GetOnlyActionForStanceAndUnitGroup(self.stancecode, self.unitgroupcode)
        
        --[[
        These actions contain no modifiers.  We need to add our prefix and postfix to them before setting the values
        --]]        
        local attrs = action:GetActionObj():GetAttributes()
        
    	for name, val in pairs(attrs) do
            local index = activatorobj:GetPrefix()..name.."-"..self.statebuttonpostfix
    		
            self.unitframecastattrs[index] = nil
    		self:SetAttribute(self.unitframe, index, nil)
    	end
    else
        self:SetAttribute(self.unitframe, activatorobj:GetPrefix().."type-"..self.statebuttonpostfix, nil)
        self:SetAttribute(self.unitframe, activatorobj:GetPrefix().."clickbutton-"..self.statebuttonpostfix, nil)
    end
    
    self.clickactiontype = nil
end

function uab.classes.ActivatorFrameControl.prototype:ApplyFriendlyCast()
    if self.clickactiontype then
        if self.clickactiontype == "direct" then
            self:ApplyFriendlyDirectCast()
        else
            self:ApplyFriendlyActionButtonCast()
        end
    end
end

function uab.classes.ActivatorFrameControl.prototype:SetFriendlyDirectCast()
    if self.clickactiontype ~= "direct" then
        self.clickactiontype = "direct"
    end

    -- the action to setup might have changed, so we always need to associate the click-cast with the correct action.
    self:ApplyFriendlyDirectCast()
end

function uab.classes.ActivatorFrameControl.prototype:ApplyFriendlyDirectCast()
    for name, val in pairs(self.unitframecastattrs) do
        self.unitframecastattrs[name] = nil
    end

    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    local action = activatorobj:GetOnlyActionForStanceAndUnitGroup(self.stancecode, self.unitgroupcode)
    
    --[[
    These actions contain no modifiers.  We need to add our prefix and postfix to them before setting the values
    --]]        
    local attrs = action:GetActionObj():GetAttributes()
    
    for name, val in pairs(attrs) do
        local index = activatorobj:GetPrefix()..name.."-"..self.statebuttonpostfix
        
        self.unitframecastattrs[index] = val
        self:SetAttribute(self.unitframe, index, val)
    end
end

function uab.classes.ActivatorFrameControl.prototype:SetFriendlyActionButtonCast()
    if self.clickactiontype ~= "actionbutton" then
        self.clickactiontype = "actionbutton"

        self:ApplyFriendlyActionButtonCast()
    end
end

function uab.classes.ActivatorFrameControl.prototype:ApplyFriendlyActionButtonCast()
    local activatorobj = uab:GetActivatorObj(self.activatorcode)
    
    for name, val in pairs(self.unitframecastattrs) do
        self.unitframecastattrs[name] = nil
    end

    local typeattr = activatorobj:GetPrefix().."type-"..self.statebuttonpostfix
    local clickattr = activatorobj:GetPrefix().."clickbutton-"..self.statebuttonpostfix

    self.unitframecastattrs[typeattr] = "click"
    self.unitframecastattrs[clickattr] = self.frame
    
    self:SetAttribute(self.unitframe, typeattr, "click")
    self:SetAttribute(self.unitframe, clickattr, self.frame)
end

function uab.classes.ActivatorFrameControl.prototype:GetState()
    return self.state
end

