-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.Activator = uab.mixins.aceOO.Class()

function uab.classes.Activator.prototype:init(code)
	uab.classes.Activator.super.prototype.init(self)

    self.pendingattributes = {}
    if code < uab.constants.keyclickactivatorcount then
        self.name = code
    else
        self.name = uab.db.profile.activators[code].name
    end
    
    self.activatorcode = code

    self:SetPrefixAndButtonCode()

    local attr
    for stance = 0, uab.MaxCurrentClassStances(), 1 do
        if attr then
            attr = attr .. ";"
        else
            attr = ""
        end
        
        attr = attr .. stance .. ":" .. self:GetStanceButtonPostfix(stance)
    end

    self.statebuttonattr = attr    
    self.registeredframes = {}
    self.actionsetcodes = {}    
	self.activatorframecontrolobj = {}
    self.stanceobjs = {}
    for stancecode = 0, uab.MaxCurrentClassStances(), 1 do
        self.stanceobjs[stancecode] = uab.classes.ActivatorStance:new(self.activatorcode, stancecode)
    end
end

function uab.classes.Activator.prototype:Dump(dumper)
    dumper:Dump("Activator: "..self.name)
    dumper:IncIndent()
    dumper:Dump("Prefix: '"..self.prefix.."'")
    dumper:Dump("Buttoncode: '"..self.buttoncode.."'")
    dumper:Dump("Code: "..self.activatorcode)

    dumper:Dump("Registered Frame Statebutton attributes")
    dumper:IncIndent()
    for frame, _ in pairs(self.registeredframes) do
        dumper:DumpFrameAttribute(frame, self.prefix.."statebutton"..self.buttoncode)
    end
    dumper:DecIndent()
    
    dumper:Dump("Action Sets")
    dumper:IncIndent()
    for code, _ in pairs(self.actionsetcodes) do
        dumper:Dump("Action Set Code: "..code)
    end
    dumper:DecIndent()

    dumper:Dump("Activator Stances")
    dumper:IncIndent()    
    for stancecode, stanceobj in pairs(self.stanceobjs) do
        stanceobj:Dump(dumper)
    end
    dumper:DecIndent()
    
    dumper:DecIndent()
end

function uab.classes.Activator.prototype:ApplyAllPendingAttributes()
    self:ApplyPendingAttributes()
    for stancecode, stanceobj in pairs(self.stanceobjs) do
        stanceobj:ApplyPendingAttributes()
    end
end

function uab.classes.Activator.prototype:ApplyPendingAttributes()
	for name, val in pairs(self.pendingattributes) do
		for frame, data in pairs(val) do
    		uab.SetFrameAttribute(frame, name, data.val)
            val[frame] = nil
        end
        self.pendingattributes[name] = nil
	end
end

function uab.classes.Activator.prototype:SetAttribute(frame, attribute, val)
    if uab:IsPendingAttributes() then
        if not self.pendingattributes[attribute] then
            self.pendingattributes[attribute] = {}
        end
        self.pendingattributes[attribute][frame] = { val = val }
    else
        self:ApplyPendingAttributes()
        uab.SetFrameAttribute(frame, attribute, val)
    end
end

function uab.classes.Activator.prototype:RegisterFrame(frame)
    self:AddRegisteredFrame(frame)
    
    if self.anyactionsets then
        self:EnableRegisteredFrame(frame)
    end
end

function uab.classes.Activator.prototype:AddRegisteredFrame(frame)
    self.registeredframes[frame] = true
end

function uab.classes.Activator.prototype:EnableAllFrameControls()
    for frame, _ in pairs(self.registeredframes) do
        self:EnableRegisteredFrame(frame)
    end
end

function uab.classes.Activator.prototype:EnableRegisteredFrame(frame)
    -- Register this frame for every stance for the unit group and frame group for this frame
    -- Also, build the statebutton attribute value for this activator.

    local attr
    for stancecode, _ in pairs(self.stanceobjs) do
        self:RegisterFrameForStance(frame, stancecode)
    end
    
    self:SetAttribute(frame, self.prefix.."statebutton"..self.buttoncode, self.statebuttonattr)
end

function uab.classes.Activator.prototype:RegisterFrameForStance(frame, stancecode)
    self.stanceobjs[stancecode]:RegisterFrame(frame)
end

function uab.classes.Activator.prototype:UnregisterFrame(frame)
    self:RemoveRegisteredFrame(frame)
    
    if self.anyactionsets then
        self:DisableRegisteredFrame(frame)
    end
end

function uab.classes.Activator.prototype:RemoveRegisteredFrame(frame)
    self.registeredframes[frame] = nil
end

function uab.classes.Activator.prototype:DisableAllFrameControls()
    for frame, _ in pairs(self.registeredframes) do
        self:DisableRegisteredFrame(frame)
    end
end

function uab.classes.Activator.prototype:DisableRegisteredFrame(frame)
    -- Register this frame for every stance for the unit group and frame group for this frame
    -- Also, build the statebutton attribute value for this activator.

    local attr
    for stancecode, _ in pairs(self.stanceobjs) do
        self:UnregisterFrameForStance(frame, stancecode)
    end
    
    self:SetAttribute(frame, self.prefix.."statebutton"..self.buttoncode, nil)
end

function uab.classes.Activator.prototype:UnregisterFrameForStance(frame, stancecode)
    self.stanceobjs[stancecode]:UnregisterFrame(frame)
end

function uab.classes.Activator.prototype:AddActionSetCode(actionsetcode)
    --[[
    An Activator can be associated with more than one action set.  This method
    adds the action set for the specified code to this activator.
    --]]
    
    if not self.actionsetcodes[actionsetcode] then
        self.actionsetcodes[actionsetcode] = true
        for stancecode, stance in pairs(self.stanceobjs) do
            stance:AddActionSetCode(actionsetcode)
        end
        
        if not self.anyactionsets then
            self.anyactionsets = true
            
            self:EnableAllFrameControls()
        end
    end
end

function uab.classes.Activator.prototype:RemoveActionSetCode(actionsetcode)
    --[[
    An Activator can be associated with more than one action set.  This method
    removes the specified action set for the specified code from this activator.
    --]]
    
    if self.actionsetcodes[actionsetcode] then
        self.actionsetcodes[actionsetcode] = nil
        for stancecode, stance in pairs(self.stanceobjs) do
            stance:RemoveActionSetCode(actionsetcode)
        end

        local found
        for code, _ in pairs(self.actionsetcodes) do
            found = true
            break
        end
        
        if not found then
            self.anyactionsets = nil
            self:DisableAllFrameControls()
        end
    end
end

function uab.classes.Activator.prototype:ReApplyStayOpen()
    for stancecode, stanceobj in pairs(self.stanceobjs) do
        stanceobj:ReApplyStayOpen()
    end
end

function uab.classes.Activator.prototype:GetName()
    return self.name
end

function uab.classes.Activator.prototype:GetPrefix()
    return self.prefix
end

function uab.classes.Activator.prototype:GetStanceButtonPostfix(stancecode)
    local button = "button"..self.buttoncode
    
    return "stance"..stancecode..button
end

function uab.classes.Activator.prototype:HasActionSetForCode(actionsetcode)
    return self.actionsetcodes[actionsetcode]
end

function uab.classes.Activator.prototype:GetActionSetCodes()
    return self.actionsetcodes
end

function uab.classes.Activator.prototype:GetUnitGroupObj(stancecode, unitgroupcode)
    return self.stanceobjs[stancecode]:GetUnitGroupObj(unitgroupcode)
end

function uab.classes.Activator.prototype:GetStanceObj(stancecode)
    return self.stanceobjs[stancecode]
end

function uab.classes.Activator.prototype:GetOnlyHostileActionForStance(stancecode)
    return self.stanceobjs[stancecode]:GetOnlyHostileAction()
end

function uab.classes.Activator.prototype:GetOnlyActionForStanceAndUnitGroup(stancecode, unitgroupcode)
    return self.stanceobjs[stancecode]:GetOnlyActionForUnitGroup(unitgroupcode)
end

function uab.classes.Activator.prototype:GetActivatorFrameControlForFrame(frame, stancecode)
    return self.stanceobjs[stancecode]:GetActivatorFrameControlForFrame(frame)
end

function uab.classes.Activator.prototype:SetPrefixAndButtonCode()
    if self.activatorcode < uab.constants.keyclickactivatorcount then
        local info = uab.constants.activatorInfo[self.activatorcode]
        
    	if info.button == "LeftButton" then
    		self.buttoncode = "1"
    	elseif info.button == "RightButton" then
    		self.buttoncode = "2"
    	elseif info.button == "MiddleButton" then
    		self.buttoncode = "3"
    	elseif info.button == "Button4" then
    		self.buttoncode = "4"
    	else
    		self.buttoncode = "5"
    	end
    
        self.prefix = ""
        
    	if info.prefixshift then
    		self.prefix = "shift-" .. self.prefix
    	end
    	
    	if info.prefixctrl then
    		self.prefix = "ctrl-" .. self.prefix
    	end
    	
    	if info.prefixalt then
    		self.prefix = "alt-" .. self.prefix
    	end
    end
end

