-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActionSetStanceUnitGroup = uab.mixins.aceOO.Class()

function uab.classes.ActionSetStanceUnitGroup.prototype:init(unitgroupcode)
	uab.classes.ActionSetStanceUnitGroup.super.prototype.init(self)

    self.unitgroupcode = unitgroupcode
    self.actionobjs = {}
    self.actionsetactionbuttonobjs = {}
end

function uab.classes.ActionSetStanceUnitGroup.prototype:Dump(dumper)
    dumper:Dump("Action Set Stance Unit Group: ")
    dumper:IncIndent()
    dumper:Dump("Unit Group Code : "..self.unitgroupcode)

    dumper:Dump("Actions")
    dumper:IncIndent()
    
    for _, actionobj in pairs(self.actionobjs) do
        actionobj:Dump(dumper)
    end

    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActionSetStanceUnitGroup.prototype:AddAction(idx, actionobj)
    self.actionobjs[idx] = actionobj
    
    for actionsetactionbuttonobjs, _ in pairs(self.actionsetactionbuttonobjs) do
        actionsetactionbuttonobjs:SetFriendlyAction(idx, actionobj)
    end
end

function uab.classes.ActionSetStanceUnitGroup.prototype:AddActionSetStanceUnitGroupButtons(actionsetactionbuttonobjs)
    self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] = true
    
    --[[
    Since we are adding the specified container for action set buttons to our list
    we need to add each of our actions to his list.
    --]]
    for idx, actionobj in pairs(self.actionobjs) do
        actionsetactionbuttonobjs:SetFriendlyAction(idx, actionobj)
    end
end

function uab.classes.ActionSetStanceUnitGroup.prototype:ClearAction(idx)
    self.actionobjs[idx] = nil
    
    for actionsetactionbuttonobj, _ in pairs(self.actionsetactionbuttonobjs) do
        actionsetactionbuttonobj:ClearFriendlyAction(idx)
    end
end

function uab.classes.ActionSetStanceUnitGroup.prototype:RemoveActionSetStanceUnitGroupButtons(actionsetactionbuttonobjs)
    self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] = nil
    
    --[[
    Since we are removing the specified container for action set buttons from our list
    we need to remove each of our actions from his list.
    --]]
    for idx, _ in pairs(self.actionobjs) do
        actionsetactionbuttonobjs:ClearFriendlyAction(idx)
    end
end

function uab.classes.ActionSetStanceUnitGroup.prototype:GetActions()
    return self.actionobjs
end

