-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActionSetStanceHostile = uab.mixins.aceOO.Class()

function uab.classes.ActionSetStanceHostile.prototype:init()
	uab.classes.ActionSetStanceHostile.super.prototype.init(self)

    self.actionobjs = {}
    self.actionsetactionbuttonobjs = {}
end

function uab.classes.ActionSetStanceHostile.prototype:Dump(dumper)
    dumper:Dump("Action Set Stance Hostile: ")
    dumper:IncIndent()

    dumper:Dump("Actions")
    dumper:IncIndent()
    
    for _, actionobj in pairs(self.actionobjs) do
        actionobj:Dump(dumper)
    end

    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActionSetStanceHostile.prototype:AddAction(idx, actionobj)
    self.actionobjs[idx] = actionobj
    
    for actionsetactionbuttonobjs, _ in pairs(self.actionsetactionbuttonobjs) do
        actionsetactionbuttonobjs:SetHostileAction(idx, actionobj)
    end
end

function uab.classes.ActionSetStanceHostile.prototype:AddActionSetStanceButtons(actionsetactionbuttonobjs)
    if not self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] then
        self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] = true
        
        --[[
        Since we are adding the specified container for action set buttons to our list
        we need to add each of our actions to his list.
        --]]
        for idx, actionobj in pairs(self.actionobjs) do
            actionsetactionbuttonobjs:SetHostileAction(idx, actionobj)
        end
    end
end

function uab.classes.ActionSetStanceHostile.prototype:ClearAction(idx)
    self.actionobjs[idx] = nil
    
    for actionsetactionbuttonobj, _ in pairs(self.actionsetactionbuttonobjs) do
        actionsetactionbuttonobj:ClearHostileAction(idx)
    end
end

function uab.classes.ActionSetStanceHostile.prototype:RemoveActionSetStanceButtons(actionsetactionbuttonobjs)
    if self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] then
        self.actionsetactionbuttonobjs[actionsetactionbuttonobjs] = nil
        
        --[[
        Since we are removing the specified container for action set buttons from our list
        we need to remove each of our actions from his list.
        --]]
        for idx, _ in pairs(self.actionobjs) do
            actionsetactionbuttonobjs:ClearHostileAction(idx)
        end
    end
end

function uab.classes.ActionSetStanceHostile.prototype:GetActions()
    return self.actionobjs
end

