-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActionSetStance = uab.mixins.aceOO.Class()

--[[
This class encapsulates access to all the action sets, and the action buttons within each of
those action sets, for a given activator, stance, and unit group.
--]]
function uab.classes.ActionSetStance.prototype:init(stancecode)
	uab.classes.ActionSetStance.super.prototype.init(self)

    self.stancecode = stancecode
    self.unitgroupobjs = {}
    
    self.hostileactions = uab.classes.ActionSetStanceHostile:new()
    for code, name in pairs(uab.constants.unitgroupstatename) do
        self.unitgroupobjs[code] = uab.classes.ActionSetStanceUnitGroup:new(code)
    end
end

function uab.classes.ActionSetStance.prototype:Dump(dumper)
    dumper:Dump("Action Set Stance: ")
    dumper:IncIndent()
    dumper:Dump("Stance Code : "..self.stancecode)
    dumper:Dump("Unit Groups")
    dumper:IncIndent()

    self.hostileactions:Dump(dumper)
    for _, unitgroupobj in pairs(self.unitgroupobjs) do
        unitgroupobj:Dump(dumper)
    end

    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActionSetStance.prototype:AddHostileAction(idx, actionobj)
    self.hostileactions:AddAction(idx, actionobj)
end

function uab.classes.ActionSetStance.prototype:ClearHostileAction(idx)
    self.hostileactions:ClearAction(idx)
end

function uab.classes.ActionSetStance.prototype:AddAction(unitgroupcode, idx, actionobj)
    self.unitgroupobjs[unitgroupcode]:AddAction(idx, actionobj)
end

function uab.classes.ActionSetStance.prototype:ClearAction(unitgroupcode, idx)
    self.unitgroupobjs[unitgroupcode]:ClearAction(idx)
end

function uab.classes.ActionSetStance.prototype:AddActionSetStanceButtons(unitgroupcode, actionsetactionbuttonobjs)
    self.hostileactions:AddActionSetStanceButtons(actionsetactionbuttonobjs)
    self.unitgroupobjs[unitgroupcode]:AddActionSetStanceUnitGroupButtons(actionsetactionbuttonobjs)
end

function uab.classes.ActionSetStance.prototype:RemoveActionSetStanceButtons(unitgroupcode, actionsetactionbuttonobjs)
    self.unitgroupobjs[unitgroupcode]:RemoveActionSetStanceUnitGroupButtons(actionsetactionbuttonobjs)
    self.hostileactions:RemoveActionSetStanceButtons(actionsetactionbuttonobjs)
end

function uab.classes.ActionSetStance.prototype:GetHostileActions()
    return self.hostileactions:GetActions()
end

function uab.classes.ActionSetStance.prototype:GetActions(unitgroupcode)
    return self.unitgroupobjs[unitgroupcode]:GetActions()
end

