-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.ActionSet = uab.mixins.aceOO.Class()

--[[
This class encapsulates access to all the action sets, and the action buttons within each of
those action sets, for a given activator, stance, and unit group.
--]]
function uab.classes.ActionSet.prototype:init(actionsetcode, name)
	uab.classes.ActionSet.super.prototype.init(self)

    self.actionsetcode = actionsetcode
    self.name = name
    
    self.stanceobjs = {}
    for stance = 0, uab.MaxCurrentClassStances(), 1 do
        self.stanceobjs[stance] = uab.classes.ActionSetStance:new(stance)
    end
end

function uab.classes.ActionSet.prototype:Dump(dumper)
    dumper:Dump("Action Set: ")
    dumper:IncIndent()
    dumper:Dump("Action Set Code : "..self.actionsetcode)
    dumper:Dump("Name            : "..self.name)
    
    if self.layoutmgrname then
        dumper:Dump("Layout Mgr Name : "..self.layoutmgrname)
    else
        dumper:Dump("Layout Mgr Name : nil")
    end
    
    dumper:Dump("Stances")
    dumper:IncIndent()
    
    for _, stanceobj in pairs(self.stanceobjs) do
        stanceobj:Dump(dumper)
    end

    dumper:DecIndent()
    dumper:DecIndent()
end

function uab.classes.ActionSet.prototype:GetName()
    return self.name
end

function uab.classes.ActionSet.prototype:AddHostileAction(stancecode, idx, actionobj)
    self.stanceobjs[stancecode]:AddHostileAction(idx, actionobj)
end

function uab.classes.ActionSet.prototype:ClearHostileAction(stancecode, idx)
    self.stanceobjs[stancecode]:ClearHostileAction(idx)
end

function uab.classes.ActionSet.prototype:AddAction(stancecode, unitgroupcode, idx, actionobj)
    self.stanceobjs[stancecode]:AddAction(unitgroupcode, idx, actionobj)
end

function uab.classes.ActionSet.prototype:ClearAction(stancecode, unitgroupcode, idx)
    self.stanceobjs[stancecode]:ClearAction(unitgroupcode, idx)
end

function uab.classes.ActionSet.prototype:AddActionSetButtons(stancecode, unitgroupcode, actionsetactionbuttonobjs)
    self.stanceobjs[stancecode]:AddActionSetStanceButtons(unitgroupcode, actionsetactionbuttonobjs)
end

function uab.classes.ActionSet.prototype:RemoveActionSetButtons(stancecode, unitgroupcode, actionsetactionbuttonobjs)
    self.stanceobjs[stancecode]:RemoveActionSetStanceButtons(unitgroupcode, actionsetactionbuttonobjs)
end

function uab.classes.ActionSet.prototype:GetHostileActions(stancecode)
    return self.stanceobjs[stancecode]:GetHostileActions()
end

function uab.classes.ActionSet.prototype:GetActions(stancecode, unitgroupcode)
    return self.stanceobjs[stancecode]:GetActions(unitgroupcode)
end

function uab.classes.ActionSet.prototype:SetLayoutManager(layoutmgrname)
    local layoutobj

    layoutobj = layoutmgrname and uabLayoutManager:GetLayout(layoutmgrname, "actions:"..self.name)

    self.layoutmgrname = layoutmgrname
    self.layoutobj = layoutobj
end

function uab.classes.ActionSet.prototype:GetLayoutObj()
    return self.layoutobj
end

