-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 17:50:18 -0400 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
An ActionButton that has a defined behavior of "do nothing".  Normally, this
shows up as a typical cancel button (x), but can show up as a menu selection
with the word "Cancel" associated with it.  Other looks are also possible.

There is one ActionButtonCancel per UnitGroupHeader.
Each ActionButtonCancel instance is associated with a single UnitGroupHeader.
--]]
uab.classes.ActionButtonCancel = uab.mixins.aceOO.Class()

function uab.classes.ActionButtonCancel.ShowTooltip(frame)
    if uab.db.profile.tooltips then
        GameTooltip:SetOwner(frame, "ANCHOR_RIGHT")
        GameTooltip:SetBackdropColor(0.1, 0.1, 0.1, 0.8)
        GameTooltip:SetText("Cancel unit action", nil, nil, nil, nil, true)
    end
end

function uab.classes.ActionButtonCancel.prototype:init(secureheaderobj, framecode)
	uab.classes.ActionButtonCancel.super.prototype.init(self)

    self.pendingattributes = {}	
    self.secureheaderobj = secureheaderobj
    if self.secureheaderobj then
        self.secureheadercode = self.secureheaderobj.secureheadercode
    else
        self.secureheadercode = -1
    end

    self.framecode = framecode
    
    self.posstates = {}
    self.showstates = {}

    self.framename = "UAB_ActionButtonCancel_"..self.framecode
    self.frame = getglobal(self.framename)

    if not self.frame then
    	--[[
    	Create frame
    	--]]
        self.frame = CreateFrame("Button", self.framename, nil, "UAB_StandardCancelButtonTemplate")
    end

    local frame = self.frame
        
    frame.uabobj = self

    if self.secureheaderobj then
        self:SetAttribute(self.secureheaderobj.frame, "addchild", frame)
    end

    uab.SetFrameLevelAndStrata(frame, 1)
    frame:Hide()
    
    self:SetAttribute(frame, "newstate", "*:0")
    
    self:SetAttribute(frame, "useparent-unit", true)
    self:SetAttribute(frame, "useparent-unitsuffix", true)

    frame:SetPoint("CENTER", 0, 0)
    frame:SetScript("OnEnter", function(self, motion) uab.classes.ActionButtonCancel.ShowTooltip(self) end)
    frame:SetScript("OnShow", function(self) self.uabobj:OnShow() end)
    frame:SetScript("OnLeave", function(self, motion) GameTooltip:Hide() end)

    --[[
    Start out with the button always hidden.  When some frame registers for the
    unit group of the activator for this button, the display properties of this
    button will get adjusted then.  We just need to start by indicating that the
    button is always hidden.
    --]]
    self:PrepareForLayouts()
    self:LayoutsDone()
end

function uab.classes.ActionButtonCancel.prototype:Dump(dumper)
    local frame = self.frame
    
    dumper:Dump("Cancel: "..self.framename)
    dumper:IncIndent()
    dumper:Dump("Frame Code      : "..self.framecode)
    dumper:Dump("SecureHeaderCode: "..self.secureheadercode)
    if self.secureheaderobj ~= nil then
        dumper:Dump("SecureHeader    : "..self.secureheaderobj.frame:GetName())
    else
        dumper:Dump("SecureHeader    : nil")
    end
    dumper:DumpFrameAttribute(frame, "newstate")
    dumper:DumpFrameAttribute(frame, "ofspoint")
    dumper:DumpFrameAttribute(frame, "ofsx")
    dumper:DumpFrameAttribute(frame, "ofsy")
    dumper:DumpFrameAttribute(frame, "showstates")
    dumper:DumpFrameAttribute(frame, "hidestates")
    dumper:DecIndent()
end

function uab.classes.ActionButtonCancel.prototype:ApplyPendingAttributes()
	for name, val in pairs(self.pendingattributes) do
		for frame, data in pairs(val) do
    		uab.SetFrameAttribute(frame, name, data.val)
            val[frame] = nil
        end
        self.pendingattributes[name] = nil
	end
end

function uab.classes.ActionButtonCancel.prototype:SetAttribute(frame, attribute, val)
    if uab:IsPendingAttributes() then
        if not self.pendingattributes[attribute] then
            self.pendingattributes[attribute] = {}
        end
        self.pendingattributes[attribute][frame] = { val = val }
    else
        self:ApplyPendingAttributes()
        uab.SetFrameAttribute(frame, attribute, val)
    end
end

function uab.classes.ActionButtonCancel.prototype:SetSecureHeaderFromCode(secureheadercode)
    if secureheadercode ~= -1 then
        if secureheadercode ~= self.secureheadercode then
            self.secureheadercode = secureheadercode
            self.secureheaderobj = uab:GetSecureHeaderObj(secureheadercode)
            self:SetAttribute(self.secureheaderobj.frame, "addchild", self.frame)
        end
    end
end

function uab.classes.ActionButtonCancel.prototype:PrepareForLayouts()
    local info = self.showstates
    for idx, _ in pairs(info) do
        info[idx] = nil
    end

    info = self.posstates
    for x, _ in pairs(info) do
        info[x].pt = nil
        info[x].x = nil
        info[x].y = nil
        info[x] = nil
    end
end

function uab.classes.ActionButtonCancel.prototype:AddShowStates(states)
    self.showstates[states] = true
end

function uab.classes.ActionButtonCancel.prototype:SetPointForStates(states, ofspoint, ofsx, ofsy)
    self.posstates[states] = { pt = ofspoint, x = ofsx, y = ofsy }
end

function uab.classes.ActionButtonCancel.prototype:LayoutsDone()
    local ptattr, xattr, yattr
    local frame = self.frame
    
    for posstates, pos in pairs(self.posstates) do
        if not ptattr then
            ptattr = ""
            xattr = ""
            yattr = ""
        else
            ptattr = ptattr .. ";"
            xattr = xattr .. ";"
            yattr = yattr .. ";"
        end

        ptattr = ptattr .. posstates .. ":" .. pos.pt
        xattr = xattr .. posstates .. ":" .. pos.x
        yattr = yattr .. posstates .. ":" .. pos.y
    end

    self:SetAttribute(frame, "ofspoint", ptattr)
    self:SetAttribute(frame, "ofsx", xattr)
    self:SetAttribute(frame, "ofsy", yattr)

    local showstates

    for states, _ in pairs(self.showstates) do
        if not showstates then
            showstates = ""
        else
            showstates = showstates .. ","
        end

        showstates = showstates .. states
    end

    self:SetAttribute(frame, "showstates", showstates)
    if not showstates then
        self:SetAttribute(frame, "hidestates", "*")
    else
        self:SetAttribute(frame, "hidestates", nil)
    end
end

function uab.classes.ActionButtonCancel.prototype:Frame()
	return self.frame
end

function uab.classes.ActionButtonCancel.prototype:OnShow()
--[[
    -- parent starts as the header
    local parent = self.frame:GetParent()
    -- make parent be the control (parent of the header)
    parent = parent:GetParent()
    -- now, make it be the parent of the control (the unit frame)
    parent = parent:GetParent()
    
    self.frame:SetFrameLevel(parent:GetFrameLevel()+10)
--]]
    -- uab.SetFrameLevelAndStrata(self.frame, 1)
end

