local DOGTAG_MAJOR_VERSION = "LibDogTag-3.0"
local MAJOR_VERSION = "LibDogTag-Items-3.0"
local MINOR_VERSION = tonumber(("$Revision: 5 $"):match("%d+")) or 0

if MINOR_VERSION > _G.DogTag_Items_MINOR_VERSION then
	_G.DogTag_Items_MINOR_VERSION = MINOR_VERSION
end
MINOR_VERSION = _G.DogTag_Items_MINOR_VERSION
_G.DogTag_Items_MINOR_VERSION = nil

local DogTag_Items, oldMinor = LibStub:NewLibrary(MAJOR_VERSION, MINOR_VERSION)
local DogTag_Items_funcs = _G.DogTag_Items_funcs
_G.DogTag_Items_funcs = nil
if not DogTag_Items then
	DogTag_Items_funcs = nil
	collectgarbage('collect')
	return
end

local DogTag = LibStub:GetLibrary(DOGTAG_MAJOR_VERSION)
if not DogTag then
	error(("Cannot load %s without first loading %s"):format(MAJOR_VERSION, DOGTAG_MAJOR_VERSION))
end

if oldMinor then
	DogTag:ClearNamespace("Items")
end

local oldLib
if next(DogTag_Items) ~= nil then
	oldLib = {}
	for k,v in pairs(DogTag_Items) do
		oldLib[k] = v
		DogTag_Items[k] = nil
	end
end
DogTag_Items.oldLib = oldLib

for _,v in ipairs(DogTag_Items_funcs) do
	v(DogTag_Items, DogTag)
end
