local MAJOR_VERSION = "LibDogTag-Items-3.0"
local MINOR_VERSION = tonumber(("$Revision: 5 $"):match("%d+")) or 0

if MINOR_VERSION > _G.DogTag_Items_MINOR_VERSION then
	_G.DogTag_Items_MINOR_VERSION = MINOR_VERSION
end

DogTag_Items_funcs[#DogTag_Items_funcs+1] = function(DogTag_Items, DogTag)

local L = DogTag_Items.L

local function dbg( text )
	DEFAULT_CHAT_FRAME:AddMessage( "LDT-Items-3.0: "..(text or "") )
end

DogTag:AddEventHandler("Items", "BAG_UPDATE", function(event, ...)
	DogTag:FireEvent("UpdateItems")
end)

DogTag:AddTag("Items", "ItemCount", {
	code = function(item)
		return GetItemCount( item )
	end,
	arg = {
		'item', "string;number", '@req',
	},
	ret = "number",
	events = "UpdateItems",
	doc = L["Return count of specified item in your bags"],
	example = '[ItemCount("Soul Shard")] => "19"',
	category = L["Items"],
})

end