local SML = LibStub( "LibSharedMedia-3.0" )
local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )

UnderHood.OptionsHelper = {}
UnderHood.OptionsHelper.__index = UnderHood.OptionsHelper

local Helper = UnderHood.OptionsHelper

function Helper:Initialize()
	LibStub( "AceEvent-3.0" ):Embed( self )
	
	self:RebuildMedia( SML.MediaType.FONT, "Fonts" )
	self:RebuildMedia( SML.MediaType.STATUSBAR, "Statusbars" )
	
	self:RegisterEvent( "SharedMedia_Registered" )
end

function Helper:RebuildMedia( mediatype, list )
	for i, v in ipairs( SML:List( mediatype ) ) do
	    self[list][v] = v
	end
end

function Helper:SharedMedia_Registered( mediatype, name )
	if mediatype == SML.MediaType.FONT then
		self.Fonts[name] = name
	elseif mediatype == SML.MediaType.STATUSBAR then
		self.Statusbars[name] = name
	end
end

Helper.Fonts = {}
Helper.Statusbars = {}

-- Units
Helper.Unit = {
	player = L["Player"],
	target = L["Target"],
	focus = L["Focus"],
	pet = L["Pet"],
	targettarget = L["Target's target"],
	focustarget = L["Focus target"],
	pettarget = L["Pet target"],
	targettargettarget = L["Target of target's target"],
}

for i = 1, 4 do
	Helper.Unit["party"..i] = L["Party"].." "..i
	Helper.Unit["partypet"..i] = L["Party pet"].." "..i
end

-- Frame stratas
Helper.Strata = {
	BACKGROUND = L["Background"],
	LOW = L["Low"],
	MEDIUM = L["Medium"],
	HIGH = L["High"],
	DIALOG = L["Dialog"],
	TOOLTIP = L["Tooltip"],
}

-- Horizontal alignments
Helper.HAlign = {
	LEFT = L["Left"],
	CENTER = L["Center"],
	RIGHT = L["Right"],
}

-- Vertical alignment
Helper.VAlign = {
	TOP = L["Top"],
	MIDDLE = L["Center"],
	BOTTOM = L["Bottom"],
}

-- Tooltip modes
Helper.TooltipVisibility = {
	always = L["Always"],
	ooc = L["Out of Combat"],
	never = L["Never"],
}
