local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )
local UH = UnderHood

local function colorEntry( order, title, group, key )
	local tbl = {}

	tbl.name = title
	tbl.type = "color"
	tbl.order = order
	tbl.get = function() return unpack( UH.db.profile.colors[group][key] ) end
	tbl.set = function( info, r, g, b ) UH.db.profile.colors[group][key] = { r, g, b } end

	return tbl
end

local options = {
	type = "group",
	handler = UnderHood,
	args = {
		general = {
			name = L["General"],
			desc = L["General options."],
			type = "group",
			order = 1,
			args = {
				scale = {
					name = L["Global scale"],
					type = "range",
					min = 0,
					max = 2,
					step = 0.01,
					bigStep = 0.01,
					order = 1,
					get = function( info ) return UH.db.profile.general.scale end,
					set = function( info, value )
					    UH.db.profile.general.scale = value,
					    UH.ParentFrame:SetScale( value )
					end,
				},
				header = {
				    name = L["Miscellaneous features"],
					type = "header",
					order = 9,
				},
				config = {
					name = L["Configuration mode"],
					desc = L["Toggles configuration mode."],
					type = "toggle",
					order = 10,
					get = function( info ) return UH.db.profile.general.config end,
					set = "Options_SetConfigMode",
				},
				debug = {
					name = L["Debug"],
					desc = L["Toggles debug mode."],
					type = "toggle",
					order = 11,
					get = function( info ) return UH.db.profile.general.debug end,
					set = function( info, val ) UH.db.profile.general.debug = val end,
				},
				alpha = {
					name = L["Alpha settings"],
					type = "group",
					order = 30,
					get = function( info ) return UH.db.profile.alpha[info[#info]] end,
					set = function( info, value ) UH.db.profile.alpha[info[#info]] = value; UH:UpdateAlpha() end,
					args = {
						combat = {
							name = L["Combat"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 2,
						},
						ooc = {
							name = L["Out of Combat"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 3,
						},
						regen = {
							name = L["Regenerating"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 4,
						},
						casting = {
							name = L["Casting"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 5,
						},
						target = {
							name = L["Have target"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 6,
						},
						focus = {
							name = L["Have focus"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 7,
						},
						pet = {
							name = L["Have pet"],
							type = "range",
							min = 0,
							max = 1,
							step = 0.01,
							bigStep = 0.01,
							order = 8,
						},
						header = {
						    name = "\n"..L["You can enable or disable some conditions by checking or unchecking boxes below:"].."\n",
							type = "description",
							order = 9,
						},
						enableCasting = {
						    name = L["Enable |cffffff00Casting|r"],
						    type = "toggle",
						    order = 10,
						},
						enableRegen = {
						    name = L["Enable |cffffff00Regenerating|r"],
						    type = "toggle",
						    order = 11,
						},
						enableTarget = {
						    name = L["Enable |cffffff00Have Target|r"],
						    type = "toggle",
						    order = 12,
						},
						enableFocus = {
						    name = L["Enable |cffffff00Have Focus|r"],
						    type = "toggle",
						    order = 13,
						},
						enablePet = {
						    name = L["Enable |cffffff00Have Pet|r"],
						    type = "toggle",
						    order = 14,
						},
					},
				},
				colors = {
					name = L["Colors"],
					type = "group",
					order = 40,
					childGroups = "tab",
					args = {
						unit = {},
						power = {},
						pet = {},
						health = {},
						cast = {},
						threat = {},
					},
				},
				hideBlizzard = {
				    name = L["Hide Blizzard Frames"],
				    type = "group",
				    order = 50,
				    get = function( info ) return UH.db.profile.hideBlizzard[info[#info]] end,
				    set = function( info, value )
				        UH.db.profile.hideBlizzard[info[#info]] = value
				        UH:UpdateBlizzardFrames()
				    end,
				    args = {
						player = {
						    name = L["Player"],
						    type = "toggle",
						    order = 1,
						},
						target = {
						    name = L["Target"],
						    type = "toggle",
						    order = 2,
						},
						party = {
						    name = L["Party"],
						    type = "toggle",
						    order = 3,
						},
						castbar = {
						    name = L["Cast Bar"],
						    type = "toggle",
						    order = 4,
						},
						aura = {
						    name = L["Buffs/Debuffs"],
						    type = "toggle",
						    order = 5,
						},
					},
				},
			},
			plugins = { modules = {}, },
		},
		modules = {
			name = L["Modules"],
			desc = L["Modules configuration."],
			type = "group",
			order = 2,
			args = {
				header = {
					name = L["You can enable or disable some modules by checking or unchecking boxes below:"].."\n",
					type = "description",
					order = 1,
				},
			},
		},
	},
	plugins = {},
}

UnderHood.options = options

function UnderHood:SetupOptions()
	-- Colors
	local tbl = options.args.general.args.colors.args.unit

	tbl.name = L["Units"]
	tbl.type = "group"
	tbl.order = 1
	tbl.args = {}

	tbl.args.unknown = colorEntry( 1, L["Unknown"], "unit", "unknown" )
	tbl.args.hostile = colorEntry( 2, L["Hostile"], "unit", "hostile" )
	tbl.args.neutral = colorEntry( 3, L["Neutral"], "unit", "neutral" )
	tbl.args.friendly = colorEntry( 4, L["Friendly"], "unit", "friendly" )
	tbl.args.civilian = colorEntry( 5, L["Civilian"], "unit", "civilian" )
	tbl.args.tapped = colorEntry( 6, L["Tapped"], "unit", "tapped" )
	tbl.args.dead = colorEntry( 7, L["Dead"], "unit", "dead" )
	tbl.args.disconnected = colorEntry( 8, L["Disconnected"], "unit", "disconnected" )
	tbl.args.inCombat = colorEntry( 9, L["In Combat"], "unit", "inCombat" )

	tbl = options.args.general.args.colors.args.power

	tbl.name = L["Power"]
	tbl.type = "group"
	tbl.order = 2
	tbl.args = {}

	tbl.args.rage = colorEntry( 1, L["Rage"], "power", "rage" )
	tbl.args.energy = colorEntry( 2, L["Energy"], "power", "energy" )
	tbl.args.focus = colorEntry( 3, L["Focus(P)"], "power", "focus" )
	tbl.args.mana = colorEntry( 4, L["Mana"], "power", "mana" )

	tbl = options.args.general.args.colors.args.pet

	tbl.name = L["Pet"]
	tbl.type = "group"
	tbl.order = 3
	tbl.args = {}

	tbl.args.happy = colorEntry( 1, L["Happy"], "pet", "happy" )
	tbl.args.neutral = colorEntry( 2, L["Neutral(P)"], "pet", "neutral" )
	tbl.args.angry = colorEntry( 3, L["Angry"], "pet", "angry" )

	tbl = options.args.general.args.colors.args.health

	tbl.name = L["Health"]
	tbl.type = "group"
	tbl.order = 4
	tbl.args = {}

	tbl.args.min = colorEntry( 1, L["Minimum"], "health", "min" )
	tbl.args.mid = colorEntry( 2, L["Middle"], "health", "mid" )
	tbl.args.max  = colorEntry( 3, L["Maximum"], "health", "max" )

	tbl = options.args.general.args.colors.args.cast

	tbl.name = L["Spellcast"]
	tbl.type = "group"
	tbl.order = 5
	tbl.args = {}

	tbl.args.casting = colorEntry( 1, L["Casting"], "cast", "casting" )
	tbl.args.channeling = colorEntry( 2, L["Channeling"], "cast", "channeling" )
	tbl.args.failed  = colorEntry( 3, L["Cast failed"], "cast", "failed" )
	tbl.args.interrupted = colorEntry( 3, L["Cast interrupted"], "cast", "interrupted" )

	tbl = options.args.general.args.colors.args.threat

	tbl.name = L["Threat"]
	tbl.type = "group"
	tbl.order = 6
	tbl.args = {}

	tbl.args.normal = colorEntry( 1, L["Normal"], "threat", "normal" )
	tbl.args.warning = colorEntry( 2, L["Warning"], "threat", "warning" )
	tbl.args.pull  = colorEntry( 3, L["Pull aggro"], "threat", "pull" )

	-- Modules
	
	local moduleOrder = 2
	
	for k,v in self:IterateModules() do
		local enableOptions = {}
		
		enableOptions.name = v:GetName()
		enableOptions.type = "toggle"
		enableOptions.order = moduleOrder
		enableOptions.get = function() return v:IsEnabled() end
		enableOptions.set = function( info, value )
			if value then
				v:Enable()
				
				if v.GetOptions then
					options.args.modules.args[v.moduleName] = v:GetOptions()
				end
			else
				v:Disable()
				
				options.args.modules.args[v.moduleName] = nil
			end
			
			self.db.profile.modules[v.moduleName] = value
			LibStub( "AceConfigRegistry-3.0" ):NotifyChange( "UnderHood" )
		end

		moduleOrder = moduleOrder + 1
		
		options.args.modules.args[v.moduleName.."State"] = enableOptions
	end
	
	-- Adding profiles
	options.args.profiles = LibStub( "AceDBOptions-3.0" ):GetOptionsTable( self.db )
	options.args.profiles.order = 10

	-- Registering
	LibStub( "AceConfig-3.0" ):RegisterOptionsTable( "UnderHood", options )
	self:RegisterChatCommand( "uh", function() LibStub( "AceConfigDialog-3.0" ):Open( "UnderHood" ) end )
end

function UnderHood:ExtendGeneralSettings( module, moduleOptions )
	options.args.general.plugins.modules[module.moduleName] = moduleOptions
	
	self:NotifyOptionsChanged()
end

function UnderHood:Options_SetConfigMode( info, value )
	self.db.profile.general.config = value
	
	for k, v in self:IterateModules() do
		if type( v.SetConfigMode ) == "function" then
			v:SetConfigMode( value )
		end
	end
	
	self:UpdateAlpha()
	
	if self.db.profile.general.config then
		self:Print( L["Configuration mode on."] )
	else
		self:Print( L["Configuration mode off."] )
	end
end

function UnderHood:NotifyOptionsChanged()
	LibStub( "AceConfigRegistry-3.0" ):NotifyChange( "UnderHood" )
end
