local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )

UnderHood_Texts = UnderHood:NewModule( "Texts", UnderHood.MultiFrameModulePrototype, "AceConsole-3.0", "AceEvent-3.0" );

UnderHood_Texts.configTableName = "texts"
UnderHood_Texts.configEntryPrefix = "text"
UnderHood_Texts.configTemplate = {
	texts = {
		["TargetClass"] = {
			["strata"] = "LOW",
			["fontSize"] = 16,
			["fontName"] = "ABF",
			["scale"] = 1,
			["text"] = "[Classification] [SmartRace:Bracket] [SmartClass:ClassColor] [DruidForm:Paren]",
			["interactive"] = true,
			["width"] = 150,
			["y"] = -187,
			["x"] = 0,
			["name"] = "TargetClass",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["unit"] = "target",
			["hAlign"] = "CENTER",
			["enabled"] = true,
		},
		["TargetGuild"] = {
			["strata"] = "LOW",
			["fontSize"] = 16,
			["fontName"] = "ABF",
			["scale"] = 1,
			["text"] = "[Guild:Angle]",
			["interactive"] = true,
			["width"] = 150,
			["y"] = -204,
			["x"] = 0,
			["name"] = "TargetGuild",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["unit"] = "target",
			["hAlign"] = "CENTER",
			["enabled"] = true,
		},
		["PetName"] = {
			["strata"] = "LOW",
			["interactive"] = true,
			["scale"] = 1,
			["text"] = "[Name]",
			["fontName"] = "ABF",
			["unit"] = "pet",
			["y"] = 12,
			["x"] = -114,
			["name"] = "PetName",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 14,
			["width"] = 150,
			["enabled"] = true,
		},
		["PlayerHealth"] = {
			["strata"] = "LOW",
			["fontSize"] = 14,
			["unit"] = "player",
			["scale"] = 1,
			["text"] = "[FractionalHP:Green] [PercentHP:Percent:Green:Paren]",
			["fontName"] = "ABF",
			["width"] = 150,
			["y"] = -138,
			["x"] = -270,
			["name"] = "PlayerHealth",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontMonochrome"] = false,
			["hAlign"] = "RIGHT",
			["enabled"] = true,
		},
		["PlayerCastName"] = {
			["strata"] = "LOW",
			["unit"] = "player",
			["scale"] = 1,
			["text"] = "[~CastStopDuration ? CastName:Abbreviate:Append( [CastRank:Romanize] )]",
			["fontName"] = "ABF",
			["width"] = 150,
			["y"] = 138,
			["x"] = -266,
			["name"] = "PlayerCastName",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 14,
			["hAlign"] = "RIGHT",
			["enabled"] = true,
		},
		["PlayerCastTime"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["text"] = "[~CastStopDuration ? CastEndDuration:Round(2)]",
			["fontName"] = "ABF",
			["unit"] = "player",
			["y"] = 138,
			["x"] = -116,
			["name"] = "PlayerCastTime",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["width"] = 150,
			["fontSize"] = 14,
			["enabled"] = true,
		},
		["TargetMana"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["text"] = "[HasMP ? FractionalMP:PowerColor] [HasMP ? PercentMP:Percent:PowerColor:Paren]",
			["fontName"] = "ABF",
			["unit"] = "target",
			["y"] = -154,
			["x"] = 285,
			["name"] = "TargetMana",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 14,
			["width"] = 150,
			["enabled"] = true,
		},
		["ToTHealth"] = {
			["strata"] = "MEDIUM",
			["fontSize"] = 12,
			["unit"] = "targettarget",
			["scale"] = 1,
			["text"] = "[FractionalHP:Short] ([PercentHP:Percent])",
			["fontName"] = "ABF",
			["width"] = 130,
			["y"] = -126,
			["x"] = 31,
			["name"] = "ToTHealth",
			["fontOutline"] = false,
			["height"] = 18,
			["level"] = 6,
			["fontMonochrome"] = false,
			["hAlign"] = "RIGHT",
			["enabled"] = true,
		},
		["ToTName"] = {
			["strata"] = "MEDIUM",
			["unit"] = "targettarget",
			["scale"] = 1,
			["text"] = "[Name ? Name] [AFK | DND]",
			["fontName"] = "Porky's",
			["width"] = 100,
			["y"] = -126,
			["x"] = -46,
			["name"] = "ToTName",
			["fontOutline"] = false,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 12,
			["hAlign"] = "LEFT",
			["enabled"] = true,
		},
		["TargetName"] = {
			["strata"] = "LOW",
			["fontSize"] = 16,
			["fontName"] = "ABF",
			["scale"] = 1,
			["text"] = "[Level:DifficultyColor:Bracket] [Name:ClassColor] [AFK | DND]",
			["interactive"] = true,
			["width"] = 200,
			["y"] = -170,
			["x"] = 0,
			["name"] = "TargetName",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["unit"] = "target",
			["hAlign"] = "CENTER",
			["enabled"] = true,
		},
		["FocusName"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["text"] = "[Level:DifficultyColor:Bracket] [Name:ClassColor] [AFK | DND]",
			["fontName"] = "ABF",
			["unit"] = "focus",
			["y"] = 12,
			["x"] = 302,
			["name"] = "FocusName",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["width"] = 150,
			["fontSize"] = 14,
			["enabled"] = true,
		},
		["TargetHealth"] = {
			["strata"] = "LOW",
			["fontSize"] = 14,
			["scale"] = 1,
			["text"] = "[FractionalHP:HostileColor] [PercentHP:Percent:HostileColor:Paren]",
			["fontName"] = "ABF",
			["unit"] = "target",
			["y"] = -154,
			["x"] = -285,
			["name"] = "TargetHealth",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["width"] = 150,
			["hAlign"] = "RIGHT",
			["enabled"] = true,
		},
		["Threat"] = {
			["strata"] = "LOW",
			["width"] = 80,
			["scale"] = 1,
			["text"] = "[HasThreat ? PercentThreat:Percent:Red]",
			["fontName"] = "ABF",
			["unit"] = "player",
			["y"] = 118,
			["x"] = -288,
			["name"] = "Threat",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 14,
			["hAlign"] = "RIGHT",
			["enabled"] = true,
		},
		["PlayerMana"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["text"] = "[HasMP ? FractionalMP:PowerColor] [HasMP ? PercentMP:Percent:PowerColor:Paren]",
			["fontName"] = "ABF",
			["unit"] = "player",
			["y"] = -138,
			["x"] = 270,
			["name"] = "PlayerMana",
			["fontOutline"] = true,
			["height"] = 18,
			["level"] = 6,
			["fontSize"] = 14,
			["width"] = 150,
			["enabled"] = true,
		},
	},
}

function UnderHood_Texts:UpgradeFrameConfig( name, config )
	if type( config.enabled ) ~= "boolean" then
	    config.enabled = true
	end
end

function UnderHood_Texts:OnInitializeFrameConfiguration( config )
	config.unit = "player"
	config.category = "name"
	config.style = L["Long"]
	config.text = "[Level:DifficultyColor:Bracket] [Name:ClassColor] [AFK | DND]"

	config.width = 150
	config.height = 16

	config.fontName = "ABF"
	config.fontSize = 14
	config.fontOutline = true
end
