UnderHood_Icons = UnderHood:NewModule( "Icons", UnderHood.MultiFrameModulePrototype, "AceConsole-3.0", "AceEvent-3.0" )

UnderHood_Icons.configTableName = "icons"
UnderHood_Icons.configEntryPrefix = "icon"
UnderHood_Icons.configTemplate = {
	icons = {
		["Resting"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 60,
			["x"] = -182,
			["name"] = "Resting",
			["width"] = 14,
			["height"] = 14,
			["level"] = 6,
			["icon"] = "resting",
			["visibility"] = "always",
			["enabled"] = true,
		},
		["MasterLooter"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 100,
			["x"] = -182,
			["name"] = "MasterLooter",
			["width"] = 12,
			["height"] = 12,
			["level"] = 6,
			["icon"] = "ml",
			["visibility"] = "ooc",
			["enabled"] = true,
		},
		["TargetIcon"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "target",
			["y"] = -150,
			["x"] = 0,
			["name"] = "TargetIcon",
			["width"] = 20,
			["height"] = 20,
			["level"] = 6,
			["icon"] = "rt",
			["visibility"] = "always",
			["enabled"] = true,
		},
		["FocusIcon"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "focus",
			["y"] = 30,
			["x"] = 238,
			["name"] = "FocusIcon",
			["width"] = 16,
			["height"] = 16,
			["level"] = 6,
			["visibility"] = "always",
			["icon"] = "rt",
			["enabled"] = true,
		},
		["PlayerCombat"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 60,
			["x"] = -182,
			["name"] = "PlayerCombat",
			["width"] = 14,
			["height"] = 14,
			["level"] = 6,
			["icon"] = "combat",
			["visibility"] = "always",
			["enabled"] = true,
		},
		["Leader"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 116,
			["x"] = -182,
			["name"] = "Leader",
			["visibility"] = "ooc",
			["height"] = 12,
			["level"] = 6,
			["icon"] = "leader",
			["width"] = 12,
			["enabled"] = true,
		},
		["PlayerPvP"] = {
			["strata"] = "LOW",
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 81,
			["x"] = -182,
			["name"] = "PlayerPvP",
			["width"] = 16,
			["height"] = 16,
			["level"] = 6,
			["icon"] = "pvp",
			["visibility"] = "ooc",
			["enabled"] = true,
		},
	},
}

function UnderHood_Icons:UpgradeFrameConfig( name, config )
	if type( config.enabled ) ~= "boolean" then
	    config.enabled = true
	end
end

function UnderHood_Icons:OnInitializeFrameConfiguration( config )
	config.icon = "resting"
	config.unit = "player"
	config.visibility = "ooc"

	config.width = 20
	config.height = 20
end
