local UH = UnderHood
local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )

UnderHood_Buffs = UnderHood:NewModule( "Buffs", UnderHood.MultiFrameModulePrototype, "AceConsole-3.0", "AceEvent-3.0" );

UnderHood_Buffs.configTableName = "frames"
UnderHood_Buffs.configEntryPrefix = "frame"
UnderHood_Buffs.configDefaults = {
	profile = {
		colorDebuffBorders = true,
		doubleSelfBuffs = false,
		doubleSelfDebuffs = false,
		doubleWhenSolo = false,
		filter = {
			friendBuffs = {
				["*"] = true,
			},
			friendDebuffs = {
				["*"] = true,
			},
			enemyDebuffs = {
				["*"] = true,
			},
		},
	},
}
UnderHood_Buffs.configTemplate = {
	frames = {
		["ToTDebuffs"] = {
			["strata"] = "LOW",
			["columns"] = 11,
			["maxAuras"] = 22,
			["layout"] = "LTU",
			["scale"] = 1,
			["tooltips"] = "ooc",
			["unit"] = "targettarget",
			["y"] = -98,
			["x"] = 7,
			["name"] = "ToTDebuffs",
			["spacing"] = 1,
			["level"] = 6,
			["type"] = "debuffs",
			["size"] = 16,
			["enabled"] = true,
		},
		["TargetDebuffs"] = {
			["strata"] = "LOW",
			["columns"] = 8,
			["spacing"] = 1,
			["scale"] = 1,
			["maxAuras"] = 16,
			["tooltips"] = "always",
			["unit"] = "target",
			["y"] = -190,
			["x"] = 200,
			["name"] = "TargetDebuffs",
			["type"] = "debuffs",
			["level"] = 6,
			["layout"] = "RTD",
			["size"] = 20,
			["enabled"] = true,
		},
		["TargetBuffs"] = {
			["strata"] = "LOW",
			["columns"] = 8,
			["spacing"] = 1,
			["scale"] = 1,
			["maxAuras"] = 16,
			["tooltips"] = "always",
			["unit"] = "target",
			["y"] = -190,
			["x"] = -200,
			["name"] = "TargetBuffs",
			["type"] = "buffs",
			["level"] = 6,
			["layout"] = "LTD",
			["size"] = 20,
			["enabled"] = true,
		},
	},
}

function UnderHood_Buffs:UpgradeFrameConfig( name, config )
	if not( config.maxAuras ) then
		config.columns = config.columns or 8
		config.maxAuras = (config.rows or 1) * config.columns
		config.rows = nil
		config.spacing = math.min( config.hSpace or 1, config.vSpace or 1 )
		config.hSpace = nil
		config.vSpace = nil
	end

	if type( config.enabled ) ~= "boolean" then
	    config.enabled = true
	end
end

function UnderHood_Buffs:OnInitializeFrameConfiguration( config )
	config.unit = "player"
	config.type = "buffs"
	config.tooltips = "ooc"

	config.x = 0
	config.y = 0

	config.maxAuras = 16
	config.columns = 8
	config.size = 20
	config.spacing = 1

	config.layout = "LTD"
end

function UnderHood_Buffs:UpdateFrames()
	for k, v in pairs( self.Frames ) do
		v:ForceUpdate()
	end
end

function UnderHood_Buffs:Dump()
	UH:Debug( "Dumping Custom Friendly Buffs:" )
	
	for k,v in pairs( self.db.profile.filter.friendBuffs ) do
		UH:Debug( k.." -- "..tostring( v ) )
	end
end

function UnderHood_Buffs:ExtendModuleOptions()
	local friendBuffsValues = {}
	local enemyDebuffsValues = {}
	local friendDebuffsValues = {}
	
	for k in pairs( self.Spells.allFriendlyBuffs ) do
		friendBuffsValues[k] = k
	end

	--[[
	for k in pairs( self.db.profile.filter.friendBuffs ) do
	    if not friendBuffsValues[k] then
			friendBuffsValues[k] = k
		end
	end
	--]]
	for k in pairs( self.Spells.enemyDebuffs ) do
		enemyDebuffsValues[k] = k
	end

	for k in pairs( self.Spells.allFriendlyDebuffs ) do
		friendDebuffsValues[k] = k
	end

	local options = {
		name = L["Aura settings"],
		type = "group",
		get = function( info ) return self.db.profile[info.arg or info[#info]] end,
		set = function( info, value )
			self.db.profile[info.arg or info[#info]] = value
			self:UpdateFrames()
		end,
		args = {
			colorDebuffBorders = {
				name = L["Color borders"],
				desc = L["Color borders using debuff type color"],
				type = "toggle",
				order = 1,
			},
			doubleSelfDebuffs = {
				name = L["Enlarge my debuffs"],
				desc = L["Enlarge debuffs that was applied by you"],
				type = "toggle",
				order = 2,
			},
			doubleSelfBuffs = {
				name = L["Enlarge my buffs"],
				desc = L["Enlarge buffs that was applied by you"],
				type = "toggle",
				order = 3,
			},
			doubleWhenSolo = {
				name = L["Enlarge when solo"],
				desc = L["Enlarge buffs and debuffs when not in group or raid"],
				type = "toggle",
				order = 4,
			},
			filter = {
				name = L["Filter"],
				type = "group",
				order = 2,
				childGroups = "tab",
				args = {
					fb = {
						name = L["Friend buffs"],
						type = "group",
						order = 1,
						args = {
							spells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								values = friendBuffsValues,
								get = function( info, key )
									return self.db.profile.filter.friendBuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.friendBuffs[key] = value
									self:UpdateFrames()
								end,
							},
							extraSpells = {
								name = L["Additional spells"],
								type = "multiselect",
								order = 2,
								hidden = function() return not self.db.profile.filter.extraFriendBuffs end,
								values = function()
								    local result = {}

								    if self.db.profile.filter.extraFriendBuffs then
									    for k in pairs( self.db.profile.filter.extraFriendBuffs ) do
									        result[k] = k
										end
									end

									return result
								end,
								get = function( info, key )
									return self.db.profile.filter.extraFriendBuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.extraFriendBuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
							    name = 	L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 3,
							},
						    add = {
						        name = L["Enter the name of the spell you wish to add:"],
						        type = "input",
						        order = 4,
						        width = "full",
						        get = function( info ) return "" end,
						        set = function( info, value )
									if not self.db.profile.filter.extraFriendBuffs then
									    self.db.profile.filter.extraFriendBuffs = {}
						            end
						            
									if self.db.profile.filter.extraFriendBuffs[value] == nil then
									    self.db.profile.filter.extraFriendBuffs[value] = true
									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						    remove = {
						        name = L["Enter the name of the spell you wish to remove:"],
						        type = "input",
						        order = 5,
						        width = "full",
								hidden = function() return not self.db.profile.filter.extraFriendBuffs end,
						        get = function( info ) return "" end,
						        set = function( info, value )
									if self.db.profile.filter.extraFriendBuffs and self.db.profile.filter.extraFriendBuffs[value] ~= nil then
									    self.db.profile.filter.extraFriendBuffs[value] = nil
									    
									    if not next( self.db.profile.filter.extraFriendBuffs ) then
									    	self.db.profile.filter.extraFriendBuffs = nil
									    end
									    
									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						},
					},
					fd = {
						name = L["Friend debuffs"],
						type = "group",
						order = 2,
						args = {
							spells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								values = friendDebuffsValues,
								get = function( info, key )
									return self.db.profile.filter.friendDebuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.friendDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							extraSpells = {
								name = L["Additional spells"],
								type = "multiselect",
								order = 2,
								hidden = function() return not self.db.profile.filter.extraFriendDebuffs end,
								values = function()
								    local result = {}

								    if self.db.profile.filter.extraFriendDebuffs then
									    for k in pairs( self.db.profile.filter.extraFriendDebuffs ) do
									        result[k] = k
										end
									end

									return result
								end,
								get = function( info, key )
									return self.db.profile.filter.extraFriendDebuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.extraFriendDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
							    name = 	L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 3,
							},
						    add = {
						        name = L["Enter the name of the spell you wish to add:"],
						        type = "input",
						        order = 4,
						        width = "full",
						        get = function( info ) return "" end,
						        set = function( info, value )
									if not self.db.profile.filter.extraFriendDebuffs then
									    self.db.profile.filter.extraFriendDebuffs = {}
						            end

									if self.db.profile.filter.extraFriendDebuffs[value] == nil then
									    self.db.profile.filter.extraFriendDebuffs[value] = true
									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						    remove = {
						        name = L["Enter the name of the spell you wish to remove:"],
						        type = "input",
						        order = 5,
						        width = "full",
								hidden = function() return not self.db.profile.filter.extraFriendDebuffs end,
						        get = function( info ) return "" end,
						        set = function( info, value )
									if self.db.profile.filter.extraFriendDebuffs and self.db.profile.filter.extraFriendDebuffs[value] ~= nil then
									    self.db.profile.filter.extraFriendDebuffs[value] = nil

									    if not next( self.db.profile.filter.extraFriendDebuffs ) then
									    	self.db.profile.filter.extraFriendDebuffs = nil
									    end

									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						},
					},
					ed = {
						name = L["Enemy debuffs"],
						type = "group",
						order = 3,
						args = {
							spells = {
								name = L["Class-specific spells"],
								type = "multiselect",
								order = 1,
								values = enemyDebuffsValues,
								get = function( info, key )
									return self.db.profile.filter.enemyDebuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.enemyDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							extraSpells = {
								name = L["Additional spells"],
								type = "multiselect",
								order = 2,
								hidden = function() return not self.db.profile.filter.extraEnemyDebuffs end,
								values = function()
								    local result = {}

								    if self.db.profile.filter.extraEnemyDebuffs then
									    for k in pairs( self.db.profile.filter.extraEnemyDebuffs ) do
									        result[k] = k
										end
									end

									return result
								end,
								get = function( info, key )
									return self.db.profile.filter.extraEnemyDebuffs[key]
								end,
								set = function( info, key, value )
									self.db.profile.filter.extraEnemyDebuffs[key] = value
									self:UpdateFrames()
								end,
							},
							descr = {
							    name = L["To add or remove additional spell you need to type spell name into respective input box below and press [Enter]."],
								type = "description",
								order = 3,
							},
						    add = {
						        name = L["Enter the name of the spell you wish to add:"],
						        type = "input",
						        order = 4,
						        width = "full",
						        get = function( info ) return "" end,
						        set = function( info, value )
									if not self.db.profile.filter.extraEnemyDebuffs then
									    self.db.profile.filter.extraEnemyDebuffs = {}
						            end

									if self.db.profile.filter.extraEnemyDebuffs[value] == nil then
									    self.db.profile.filter.extraEnemyDebuffs[value] = true
									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						    remove = {
						        name = L["Enter the name of the spell you wish to remove:"],
						        type = "input",
						        order = 5,
						        width = "full",
								hidden = function() return not self.db.profile.filter.extraEnemyDebuffs end,
						        get = function( info ) return "" end,
						        set = function( info, value )
									if self.db.profile.filter.extraEnemyDebuffs and self.db.profile.filter.extraEnemyDebuffs[value] ~= nil then
									    self.db.profile.filter.extraEnemyDebuffs[value] = nil

									    if not next( self.db.profile.filter.extraEnemyDebuffs ) then
									    	self.db.profile.filter.extraEnemyDebuffs = nil
									    end

									    self:UpdateFrames()
									    UH:NotifyOptionsChanged()
									end
						        end,
							},
						},
					},
				},
			},
		},
	}
	
	UH:ExtendGeneralSettings( self, options )
end
