local UH = UnderHood
local UHB = UnderHood_Buffs

local BuffFrame = UHB.FramePrototype
-- [1]: next column settings
-- [2]: next row settings

layouts = {
	RTD = { { "TOPLEFT", "TOPRIGHT", 1, 0 }, { "TOPLEFT", "BOTTOMLEFT", 0, -1 }, },
	RTU = { { "TOPLEFT", "TOPRIGHT", 1, 0 }, { "BOTTOMLEFT", "TOPLEFT", 0, 1 }, },
	LTD = { { "TOPRIGHT", "TOPLEFT", -1, 0 }, { "TOPRIGHT", "BOTTOMRIGHT", 0, -1 }, },
	LTU = { { "TOPRIGHT", "TOPLEFT", -1, 0 }, { "BOTTOMRIGHT", "TOPRIGHT", 0, 1 }, },
	DTL = { { "TOPRIGHT", "BOTTOMRIGHT", 0, -1 }, { "TOPRIGHT", "TOPLEFT", -1, 0 }, },
	DTR = { { "TOPLEFT", "BOTTOMLEFT", 0, -1 }, { "TOPLEFT", "TOPRIGHT", 1, 0 }, },
	UTL = { { "BOTTOMRIGHT", "TOPRIGHT", 0, 1 }, { "BOTTOMRIGHT", "BOTTOMLEFT", -1, 0 }, },
	UTR = { { "BOTTOMLEFT", "TOPLEFT", 0, 1 }, { "BOTTOMLEFT", "BOTTOMRIGHT", 1, 0 }, },
}

--[[
	Smart Layout engine for aura frames.
--]]

function BuffFrame:PerformLayout()
	local buttons = self.buttons
	local totalButtonsCount, largeButtonsCount, smallButtonsCount = 0, 0, 0
	local button, firstSmallButtonIndex
	
	for i = 1, #buttons do
		button = buttons[i]

		if not button.id then break end

		if button.isLarge then
			largeButtonsCount = largeButtonsCount + 1
		else
			if not firstSmallButtonIndex then
				firstSmallButtonIndex = i
			end
			
			smallButtonsCount = smallButtonsCount + 1
		end

		totalButtonsCount = totalButtonsCount + 1
	end

	if totalButtonsCount == 0 then return end
	
	firstSmallButtonIndex = firstSmallButtonIndex or totalButtonsCount + 1
	local config = self.config
	local layout = layouts[config.layout]
	local buttonSize, spacing = config.size, config.spacing
	local largeButtonIndex, smallButtonIndex = 1, firstSmallButtonIndex
	local row, column, lastRowFirstButton, rowSize = 1, 1, nil, config.columns
	local miniRow, miniColumn, miniLastRowFirstButton, miniRowSize
	local point, relPoint, dx, dy
	local anchorFrame, lastButton, lastLargeButton, lastRowFirstButton
	local buttonsLeft = totalButtonsCount
	local smallButtonsLeft = totalButtonsCount - firstSmallButtonIndex + 1
	local largeButtonsLeft = firstSmallButtonIndex - largeButtonIndex
	
	while buttonsLeft > 0 do
		local buttonPlaced = false

		if largeButtonIndex < firstSmallButtonIndex and not miniRowSize then
			-- We have a large button to layout
			if ((column + 2 < rowSize) or smallButtonsLeft == 0 ) then
				-- We have a space in the row to place a button
				button = buttons[largeButtonIndex]

				if column == 1 then
					anchorFrame = lastRowFirstButton or self.frame
					point, relPoint, dx, dy = unpack( layout[2] )
					lastRowFirstButton = button
				else
					anchorFrame = lastLargeButton
					point, relPoint, dx, dy = unpack( layout[1] )
				end

				button:ClearAllPoints()
				button:SetWidth( buttonSize*2 + spacing )
				button:SetHeight( buttonSize*2 + spacing )
				button:SetPoint( point, anchorFrame, relPoint , dx*spacing, dy*spacing )

				lastButton = button
				lastLargeButton = button

				column = column + 2
				largeButtonIndex = largeButtonIndex + 1

				largeButtonsLeft = largeButtonsLeft - 1

				if largeButtonsLeft == 0 and column < rowSize then
					-- There is some space in the row to put small buttons
					miniRow = 1
					miniColumn = 1
					miniRowSize = rowSize - column
					miniLastRowFirstButton = nil
				else
					buttonPlaced = true
				end
			else
				-- We do not have space enough to pace a large button, starting minirow
				miniRow, miniColumn, miniRowSize, miniLastRowFirstButton = 1, 1, rowSize - column, nil
			end
		end
		
		if not buttonPlaced then
			-- No more large buttons or there is a space left in last large row
			button = buttons[smallButtonIndex]
			
			-- Are we in minirow or in the fresh new row?
			if miniRowSize then
				if miniColumn == 1 then
					if miniRow == 1 then
						point, relPoint, dx, dy = unpack( layout[1] )
						anchorFrame = lastLargeButton
						miniLastRowFirstButton = button
					else
						point, relPoint, dx, dy = unpack( layout[2] )
						anchorFrame = miniLastRowFirstButton
					end
				else
					point, relPoint, dx, dy = unpack( layout[1] )
					anchorFrame = lastButton
				end

				miniColumn = miniColumn + 1

				if miniColumn > miniRowSize+1 then
					miniColumn = 1
					miniRow = miniRow + 1

					if miniRow > 2 then
						column = rowSize + 1

						miniRow, miniColumn, miniRowSize, miniLastRowFirstButton = nil, nil, nil, nil
					end
				end
			else
				if column == 1 then
					point, relPoint, dx, dy = unpack( layout[2] )
					anchorFrame = lastRowFirstButton or self.frame
					lastRowFirstButton = button
				else
					point, relPoint, dx, dy = unpack( layout[1] )
					anchorFrame = lastButton
				end
				
				column = column + 1
			end

			button:SetWidth( buttonSize )
			button:SetHeight( buttonSize )
			button:ClearAllPoints()
			button:SetPoint( point, anchorFrame, relPoint, dx*spacing, dy*spacing )
			
			lastButton = button
			
			smallButtonIndex = smallButtonIndex + 1
			smallButtonsLeft = smallButtonsLeft - 1
		end

		if column > rowSize then
			column = 1
			row = row + 1
		end

		buttonsLeft = buttonsLeft - 1
	end
end
