local UH = UnderHood
local UHB = UnderHood_Bars
local SML = LibStub( "LibSharedMedia-3.0" )
local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )

local Factory
local Style
do
	Style = {}
	Style.__index = Style
	Style.name = "Horizontal"
	Style.title = L["Horizontal"]

	function Style:DefaultSettings( config )
	end

	function Style:AdjustStatusBar( p )
		self.bar.frames.sb:SetValue( p )

		if math.floor( p * 100 ) == 0 then
			self.bar.frames.sb:Hide()
		else
			self.bar.frames.sb:Show()
		end
	end

	function Style:Create( bar )
		local self = {}
		setmetatable( self, Style )

		self.bar = bar

		if not bar.frames then bar.frames = {} end
		
		-- Setting frame backdrop
		bar.frame:SetBackdrop( {
			bgFile = "Interface\\Buttons\\WHITE8X8", tile = true, tileSize = 8,
			edgeFile = "Interface\\Buttons\\WHITE8X8", edgeSize = 1,
			insets = { left = 1, right = 1, top = 1, bottom = 1 },
		} )
		bar.frame:SetBackdropColor( 0, 0, 0, 0 )
		bar.frame:SetBackdropBorderColor( 0, 0, 0, 1 )
		
		-- Background
		bar.frames.bg = UH:CreateFrame( "Texture", bar.frame, "BACKGROUND" )
		bar.frames.bg:SetTexture( SML:Fetch( SML.MediaType.STATUSBAR, bar.config.styleSettings.texture ) )

		local r, g, b, a = unpack( bar.config.styleSettings.bgColor )

		bar.frames.bg:SetVertexColor( r, g, b, a )
		bar.frames.bg:SetPoint( "TOPLEFT", bar.frame, "TOPLEFT", 1, -1 )
		bar.frames.bg:SetPoint( "BOTTOMRIGHT", bar.frame, "BOTTOMRIGHT", -1, 1 )

		if bar.config.styleSettings.showBackground then
			bar.frames.bg:Show()
		else
			bar.frames.bg:Hide()
		end

		-- Status Bar
		bar.frames.sb = UH:CreateFrame( "StatusBar", bar.frame )
		bar.frames.sb:SetStatusBarTexture( SML:Fetch( SML.MediaType.STATUSBAR, bar.config.styleSettings.texture ) )
		bar.frames.sb:SetOrientation( "HORIZONTAL" )
		bar.frames.sb:SetMinMaxValues( 0, 1 )
		bar.frames.sb:SetPoint( "TOPLEFT", bar.frame, "TOPLEFT", 1, -1 )
		bar.frames.sb:SetPoint( "BOTTOMRIGHT", bar.frame, "BOTTOMRIGHT", -1, 1 )

		self:AdjustStatusBar( 1 )

		return self
	end

	local zones = { { title = L["Main bar"] } }
	
	function Style:GetZones()
	    return zones
	end
	
	function Style:Destroy( bar )
	    self.bar.frame:SetBackdrop( nil )
	end

	function Style:SetColor( zone, r, g, b, a )
		self.bar.frames.sb:SetStatusBarColor( r, g, b, a )
	end

	function Style:SetValue( zone, value )
		self.value = value

		self:Update()
	end

	function Style:SetCastingColor( r, g, b, a )
	end
	
	function Style:SetCastingValue( value )
	end
	
	function Style:Update()
		local p = 0

		if self.bar:InConfigMode() then
			p = 1
		else
			p = self.value or 0
		end

		if p > 1 then p = 1 end

		self:AdjustStatusBar( p )
	end

	function Style:SetupOptions( options )
	    options.texture = {
	        name = L["Texture"],
	        type = "select",
	        values = UH.OptionsHelper.Statusbars,
	        get = function() return self.bar.config.styleSettings.texture end,
	        set = function( info, value )
	            self.bar.config.styleSettings.texture = value
				self.bar.frames.bg:SetTexture( SML:Fetch( SML.MediaType.STATUSBAR, value ) )
				self.bar.frames.sb:SetStatusBarTexture( SML:Fetch( SML.MediaType.STATUSBAR, value ) )
	        end,
		}
		
		options.showBackground = {
			name = L["Show background"],
			type = "toggle",
			get = function() return self.bar.config.styleSettings.showBackground end,
			set = function( info, value )
				self.bar.config.styleSettings.showBackground = value

				if self.bar.frames and self.bar.frames.bg then
					if value then
						self.bar.frames.bg:Show()
					else
						self.bar.frames.bg:Hide()
					end
				end
			end,
		}
	end

	Factory = {}
	Factory.__index = Factory
	Factory.name = "Horizontal"
	Factory.title = L["Horizontal"]
	
	function Factory:DefaultSettings( config )
		config.width = 100
		config.height = 20

		config.styleSettings = {}
		config.styleSettings.texture = "Armory"
		config.styleSettings.showBackground = true
		config.styleSettings.bgColor = { 0.3, 0.3, 0.3, 0.75 }
	end
	
	function Factory:Create( bar )
	    return Style:Create( bar )
	end
	
	UHB:RegisterStyle( Factory )
end
