local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )
local UH = UnderHood
local UnitMana = UnitMana
local UnitManaMax = UnitManaMax
local UnitPowerType = UnitPowerType
local UnitGUID = UnitGUID

local Provider = {}
Provider.__index = Provider
Provider.name = "Power"
Provider.title = L["Power"]
Provider.supportedUnits = { "player", "target", "focus", "pet", "targettarget" }
	
function Provider:Create( bar, zone, config )
	local self = {}
	
	setmetatable( self, Provider )
	LibStub( "AceEvent-3.0" ):Embed( self )
	
	self.bar = bar
	self.zone = zone
	self.config = config
	
	return self
end
	
function Provider:UnitSupported( unit )
	return true
end
	
function Provider:Connect()
	self.unit = self.bar.config.unit
	local unit = self.unit
	
	self:Update()

	if UH.UnitSendEvents[unit] then
		self:RegisterEvent( "UNIT_MANA" )
		self:RegisterEvent( "UNIT_MAXMANA" )
		self:RegisterEvent( "UNIT_ENERGY", "UNIT_MANA" )
		self:RegisterEvent( "UNIT_MAXENERGY", "UNIT_MAXMANA" )
		self:RegisterEvent( "UNIT_RAGE", "UNIT_MANA" )
		self:RegisterEvent( "UNIT_MAXRAGE", "UNIT_MAXMANA" )
		self:RegisterEvent( "UNIT_DISPLAYPOWER", "UpdateIfUnit" )
	else
		UH:RegisterUpdateTarget( self, "UpdateUneventedUnit" )
	end
	
	if unit == "player" then
		self:RegisterEvent( "PLAYER_ENTERING_WORLD", "Update" )
	elseif unit == "target" then
		self:RegisterEvent( "PLAYER_TARGET_CHANGED", "Update" )
	elseif unit == "focus" then
		self:RegisterEvent( "PLAYER_FOCUS_CHANGED", "Update" )
	elseif unit == "pet" then
	    self:RegisterEvent( "UNIT_PET", "UpdateIfUnit" )
	end
end
	
function Provider:Disconnect()
	self:UnregisterAllEvents()
	UH:UnregisterUpdateTarget( self )
end

function Provider:UpdateUneventedUnit()
	local unit = self.unit
	local totGuid = UnitGUID( unit )

	if self.totGuid ~= totGuid then
	    -- Current ToT unit is not the same as last one = updating
		self.totGuid = totGuid
		self.totPower = nil
		self:Update()
	elseif self.totGuid then
		local current, max = UnitMana( unit ), UnitManaMax( unit )

		current = max > 0 and current / max or 0

		if self.totPower ~= current then
		    self.totPower = current
		    self.bar:SetValue( self.zone, current )
		end
	end
end

function Provider:UNIT_MANA( event, unit )
	if unit == self.unit then
		self:SetValue()
	end
end
	
function Provider:UNIT_MAXMANA( event, unit )
	if unit == self.unit then
		self:SetValue()
	end
end

function Provider:UpdateIfUnit( event, unit )
	if unit == self.unit then
	    self:Update()
	end
end

function Provider:Update()
	local unit = self.unit
	local powerType = UnitExists( unit ) and UnitPowerType( unit ) or -1
	local r,g,b
		
	if powerType == 0 then
		r,g,b = unpack( UH.db.profile.colors.power.mana )
	elseif powerType == 1 then
		r,g,b = unpack( UH.db.profile.colors.power.rage )
	elseif powerType == 2 then
		r,g,b = unpack( UH.db.profile.colors.power.focus )
	elseif powerType == 3 then
		r,g,b = unpack( UH.db.profile.colors.power.energy )
	else
		r,g,b = unpack( UH.db.profile.colors.unit.unknown )
	end
		
	self.bar:SetColor( self.zone, r, g, b, 1 )
	self:SetValue()
end
	
function Provider:SetValue()
	local unit = self.unit
	local current, max = UnitMana( unit ), UnitManaMax( unit )
		
	if max > 0 then
		current = current / max
	else
		current = 0
	end
		
	self.bar:SetValue( self.zone, current )
end
	
UnderHood_Bars:RegisterProvider( Provider )
