local UH = UnderHood
local LibDruidMana = LibStub( "LibDruidMana-1.0", true )
local L = LibStub( "AceLocale-3.0" ):GetLocale( "UnderHood" )

local instances = setmetatable( {}, { __mode='k' } )

local function notifyProviders( current, max )
	for provider, _ in pairs( instances ) do
	    provider:SetValue( current, max )
	end
end

if LibDruidMana then
	LibDruidMana:AddListener( notifyProviders )
end

local Provider = {}
Provider.__index = Provider
Provider.name = "Druid Mana"
Provider.title = L["Druid Mana"]

Provider.supportedUnits = { "player" }
Provider.manageVisibility = true

function Provider:Create( bar, zone, config )
	local self = {}

	setmetatable( self, Provider )
	LibStub( "AceEvent-3.0" ):Embed( self )

	self.bar = bar
	self.zone = zone
	self.config = config

	return self
end

function Provider:UnitSupported( unit )
	return unit == "player"
end

function Provider:IsBarVisible()
	return LibDruidMana and UnitPowerType( "player" ) ~= 0
end

function Provider:Connect()
	self:Update()

	self:RegisterEvent( "UNIT_DISPLAYPOWER", "Update" )
	
	instances[self] = true
end

function Provider:Disconnect()
	self:UnregisterAllEvents()
	
	instances[self] = nil
end

function Provider:Update()
	local r,g,b = unpack( UH.db.profile.colors.power.mana )

	self.bar:SetColor( self.zone, r, g, b, 1 )
	
	if UnitPowerType( "player" ) ~= 0 then
	    self.bar:Show()
	else
	    self.bar:Hide()
	end
	
	self:SetValue()
end

function Provider:SetValue( current, max )
	current = current or (LibDruidMana and LibDruidMana:GetCurrentMana()) or 0
	max = max or (LibDruidMana and LibDruidMana:GetMaximumMana()) or 1

	if max > 0 then
		current = current / max
	else
		current = 0
	end

	self.bar:SetValue( self.zone, current )
end

UnderHood_Bars:RegisterProvider( Provider )
