local stylesRegistry = {}
local stylesNameList = {}
local stylesNameTable = {}

local providersRegistry = {}
local providersNameList = {}
local providersNameTable = {}
local providersNameTableWithNone = {
	[""] = "None",
}

UnderHood_Bars = UnderHood:NewModule( "Bars", UnderHood.MultiFrameModulePrototype, "AceConsole-3.0", "AceEvent-3.0" )

UnderHood_Bars.configTableName = "bars"
UnderHood_Bars.configEntryPrefix = "bar"
UnderHood_Bars.configTemplate = {
	bars = {
		["Threat"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 0,
			["x"] = -236,
			["name"] = "Threat",
			["style"] = "VerticalLarge",
			["height"] = 256,
			["level"] = 6,
			["width"] = 30,
			["zones"] = {
			    {
					["provider"] = "Threat",
					["animate"] = true,
				},
			},
		},
		["PetMana"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 0.51,
			["width"] = 37,
			["unit"] = "pet",
			["y"] = -123,
			["x"] = -342,
			["name"] = "PetMana",
			["style"] = "VerticalLarge",
			["zones"] = {
			    {
					["provider"] = "Power",
				},
			},
			["level"] = 6,
			["height"] = 256,
		},
		["PetHealth"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 0.51,
			["unit"] = "pet",
			["y"] = -123,
			["x"] = -362,
			["name"] = "PetHealth",
			["style"] = "VerticalLarge",
			["zones"] = {
			    {
					["provider"] = "Health",
				},
			},
			["level"] = 6,
			["height"] = 256,
			["width"] = 37,
		},
		["FocusHealth"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 0.51,
			["width"] = 37,
			["unit"] = "focus",
			["y"] = -123,
			["x"] = 456,
			["name"] = "FocusHealth",
			["style"] = "VerticalLarge",
			["zones"] = {
			    {
					["provider"] = "Health",
					["animate"] = true,
					["providerSettings"] = {
						["colorByHostility"] = false,
						["colorByClass"] = false,
					},
				},
				{
					["provider"] = "Casting",
				},
			},
			["level"] = 6,
			["height"] = 256,
		},
		["ToTHealth"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
				["texture"] = "Armory",
			},
			["scale"] = 1,
			["name"] = "ToTHealth",
			["unit"] = "targettarget",
			["y"] = -126,
			["x"] = 0,
			["style"] = "Horizontal",
			["width"] = 200,
			["zones"] = {
			    {
					["provider"] = "Health",
					["animate"] = true,
					["providerSettings"] = {
						["colorByHostility"] = true,
						["colorByClass"] = false,
					},
				},
			},
			["level"] = 6,
			["height"] = 20,
		},
		["FocusMana"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 0.51,
			["unit"] = "focus",
			["y"] = -123,
			["x"] = 478,
			["name"] = "FocusMana",
			["style"] = "VerticalLarge",
			["height"] = 256,
			["level"] = 6,
			["zones"] = {
			    {
			        ["provider"] = "Power",
					["animate"] = true,
				},
				{
				    ["provider"] = "Casting",
				},
			},
			["width"] = 37,
		},
		["PlayerHealth"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 0,
			["x"] = -200,
			["name"] = "PlayerHealth",
			["width"] = 30,
			["height"] = 256,
			["level"] = 6,
			["zones"] = {
			    {
			        ["provider"] = "Health",
					["animate"] = true,
				},
				{
				    ["provider"] = "Casting",
				},
			},
			["style"] = "VerticalLarge",
		},
		["TargetHealth"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 1,
			["style"] = "VerticalLarge",
			["width"] = 30,
			["y"] = 0,
			["x"] = -218,
			["name"] = "TargetHealth",
			["height"] = 256,
			["zones"] = {
			    {
			        ["provider"] = "Health",
					["animate"] = true,
					["providerSettings"] = {
						["colorByHostility"] = true,
						["colorByClass"] = false,
					},
				},
				{
				    ["provider"] = "Casting",
				},
			},
			["level"] = 6,
			["unit"] = "target",
		},
		["TargetMana"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 1,
			["unit"] = "target",
			["y"] = 0,
			["x"] = 218,
			["name"] = "TargetMana",
			["width"] = 30,
			["height"] = 256,
			["level"] = 6,
			["zones"] = {
			    {
			        ["provider"] = "Power",
					["animate"] = true,
				},
			},
			["style"] = "VerticalLarge",
		},
		["DruidMana"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 0.51,
			["width"] = 37,
			["unit"] = "player",
			["y"] = -123,
			["x"] = 364,
			["name"] = "DruidMana",
			["style"] = "VerticalLarge",
			["zones"] = {
			    {
			        ["provider"] = "Druid Mana",
					["animate"] = true,
				},
			},
			["level"] = 6,
			["height"] = 256,
		},
		["PlayerMana"] = {
			["enabled"] = true,
			["strata"] = "LOW",
			["styleSettings"] = {
				["bgColor"] = {
					0.3, -- [1]
					0.3, -- [2]
					0.3, -- [3]
					0.75, -- [4]
				},
				["showBackground"] = true,
			},
			["scale"] = 1,
			["unit"] = "player",
			["y"] = 0,
			["x"] = 200,
			["name"] = "PlayerMana",
			["width"] = 30,
			["height"] = 256,
			["level"] = 6,
			["zones"] = {
			    {
			        ["provider"] = "Power",
					["animate"] = true,
				},
			},
			["style"] = "VerticalLarge",
		},
	},
}

function UnderHood_Bars:UpgradeFrameConfig( name, config )
	if not config.zones then
	    config.zones = {}
	    
	    local zm = {}
	    
	    zm.provider = config.provider
	    zm.providerSettings = config.providerSettings
	    zm.animate = config.animate
	    
	    config.zones[1] = zm
	    
	    config.provider = nil
	    config.providerSettings = nil
	    config.animate = nil
	    
	    if config.castingBar then
	        config.zones[2] = { provider = "Casting" }
	        config.castingBar = nil
	    end
	end
	
	if type( config.enabled ) ~= "boolean" then
	    config.enabled = true
	end
end

function UnderHood_Bars:OnInitializeFrameConfiguration( config )
	config.zones = {
	    {
	        provider = "Health",
		},
	}
	config.unit = "player"

	config.width = 22
	config.height = 256

	config.style = "UnderHood"
	stylesRegistry[config.style]:DefaultSettings( config )
	
	--[[
	for styleName, style in pairs( self:GetStyles() ) do
		config.style = styleName

		if type( style.DefaultSettings ) == "function" then
			style:DefaultSettings( config )
		end

		break
	end
	--]]
end

--[[--------
-- Providers
--]]

function UnderHood_Bars:RegisterProvider( provider )
	providersRegistry[provider.name] = provider
	
	table.insert( providersNameList, provider.name )
	providersNameTable[provider.name] = provider.title
	providersNameTableWithNone[provider.name] = provider.title
end

function UnderHood_Bars:GetProviders()
	return providersRegistry
end

function UnderHood_Bars:GetProvidersNameList()
	return providersNameList
end

function UnderHood_Bars:GetProvidersNameTable()
	return providersNameTable
end

function UnderHood_Bars:GetProvidersNameTableWithNone()
	return providersNameTableWithNone
end

function UnderHood_Bars:GetProvider( name )
	return providersRegistry[name]
end

--[[--------
-- Providers
--]]

function UnderHood_Bars:RegisterStyle( style )
	stylesRegistry[style.name] = style
	
	table.insert( stylesNameList, style.name )
	stylesNameTable[style.name] = style.title
end

function UnderHood_Bars:GetStyles()
	return stylesRegistry
end

function UnderHood_Bars:GetStylesNameList()
	return stylesNameList
end

function UnderHood_Bars:GetStylesNameTable()
	return stylesNameTable
end

function UnderHood_Bars:GetStyle( name )
	return stylesRegistry[name]
end

