--
-- Functionality shamelessly stolen from PitBull's module HideBlizzard.
-- Chknight, thank you once again, I'm in debt :)
--
-- Note: There was a bug with target frame in "original" functionality. Fixed by
--       calling TargetFrame_Update().
--

local playerFrameState = true
local partyFrameState = true
local targetFrameState = true
local castingBarState = true
local auraFrameState = true

local function HideBlizzardPlayerFrame()
	if not playerFrameState then return end
	
	playerFrameState = false
	PlayerFrame:UnregisterAllEvents()
	PlayerFrameHealthBar:UnregisterAllEvents()
	PlayerFrameManaBar:UnregisterAllEvents()
	PlayerFrame:Hide()
end

local function ShowBlizzardPlayerFrame()
	if playerFrameState then return end
	
	playerFrameState = true
	PlayerFrame:RegisterEvent("UNIT_LEVEL")
	PlayerFrame:RegisterEvent("UNIT_COMBAT")
	PlayerFrame:RegisterEvent("UNIT_SPELLMISS")
	PlayerFrame:RegisterEvent("UNIT_PVP_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_MAXMANA")
	PlayerFrame:RegisterEvent("PLAYER_ENTER_COMBAT")
	PlayerFrame:RegisterEvent("PLAYER_LEAVE_COMBAT")
	PlayerFrame:RegisterEvent("PLAYER_UPDATE_RESTING")
	PlayerFrame:RegisterEvent("PARTY_MEMBERS_CHANGED")
	PlayerFrame:RegisterEvent("PARTY_LEADER_CHANGED")
	PlayerFrame:RegisterEvent("PARTY_LOOT_METHOD_CHANGED")
	PlayerFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
	PlayerFrame:RegisterEvent("PLAYER_REGEN_DISABLED")
	PlayerFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
	PlayerFrameHealthBar:RegisterEvent("UNIT_HEALTH")
	PlayerFrameHealthBar:RegisterEvent("UNIT_MAXHEALTH")
	PlayerFrameManaBar:RegisterEvent("UNIT_MANA")
	PlayerFrameManaBar:RegisterEvent("UNIT_RAGE")
	PlayerFrameManaBar:RegisterEvent("UNIT_FOCUS")
	PlayerFrameManaBar:RegisterEvent("UNIT_ENERGY")
	PlayerFrameManaBar:RegisterEvent("UNIT_HAPPINESS")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXMANA")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXRAGE")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXFOCUS")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXENERGY")
	PlayerFrameManaBar:RegisterEvent("UNIT_MAXHAPPINESS")
	PlayerFrameManaBar:RegisterEvent("UNIT_DISPLAYPOWER")
	PlayerFrame:RegisterEvent("UNIT_NAME_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	PlayerFrame:RegisterEvent("UNIT_DISPLAYPOWER")
	PlayerFrame:Show()
end

local function HideBlizzardPartyFrames()
	if not partyFrameState then return end
	
	partyFrameState = false
	for i = 1, 4 do
		local frame = _G["PartyMemberFrame"..i]
		frame:UnregisterAllEvents()
		frame:Hide()
		frame.Show = function() end
	end

	UIParent:UnregisterEvent("RAID_ROSTER_UPDATE")
end

local function ShowBlizzardPartyFrames()
	if partyFrameState then return end
	
	partyFrameState = true
	for i = 1, 4 do
		local frame = _G["PartyMemberFrame"..i]
		frame.Show = nil
		frame:RegisterEvent("PARTY_MEMBERS_CHANGED")
		frame:RegisterEvent("PARTY_LEADER_CHANGED")
		frame:RegisterEvent("PARTY_MEMBER_ENABLE")
		frame:RegisterEvent("PARTY_MEMBER_DISABLE")
		frame:RegisterEvent("PARTY_LOOT_METHOD_CHANGED")
		frame:RegisterEvent("UNIT_PVP_UPDATE")
		frame:RegisterEvent("UNIT_AURA")
		frame:RegisterEvent("UNIT_PET")
		frame:RegisterEvent("VARIABLES_LOADED")
		frame:RegisterEvent("UNIT_NAME_UPDATE")
		frame:RegisterEvent("UNIT_PORTRAIT_UPDATE")
		frame:RegisterEvent("UNIT_DISPLAYPOWER")

		UnitFrame_OnEvent("PARTY_MEMBERS_CHANGED")

		local oldThis = _G.this
		_G.this = frame
		PartyMemberFrame_UpdateMember()
		_G.this = oldThis
	end

	UIParent:RegisterEvent("RAID_ROSTER_UPDATE")
end


local function HideBlizzardTargetFrame()
	if not targetFrameState then return end
	
	targetFrameState = false
	TargetFrame:UnregisterAllEvents()
	TargetFrame:Hide()

	ComboFrame:UnregisterAllEvents()
end

local function ShowBlizzardTargetFrame()
	if targetFrameState then return end
	
	targetFrameState = true
	TargetFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	TargetFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	TargetFrame:RegisterEvent("UNIT_HEALTH")
	TargetFrame:RegisterEvent("UNIT_LEVEL")
	TargetFrame:RegisterEvent("UNIT_FACTION")
	TargetFrame:RegisterEvent("UNIT_CLASSIFICATION_CHANGED")
	TargetFrame:RegisterEvent("UNIT_AURA")
	TargetFrame:RegisterEvent("PLAYER_FLAGS_CHANGED")
	TargetFrame:RegisterEvent("PARTY_MEMBERS_CHANGED")
	
	local oldThis = _G.this
	_G.this = TargetFrame
	TargetFrame_Update()
	_G.this = oldThis

	ComboFrame:RegisterEvent("PLAYER_FOCUS_CHANGED")
	ComboFrame:RegisterEvent("PLAYER_TARGET_CHANGED")
	ComboFrame:RegisterEvent("PLAYER_COMBO_POINTS")
end

local function HideBlizzardCastingBar()
	if not castingBarState then return end
	
	castingBarState = false
	CastingBarFrame:UnregisterAllEvents()
	PetCastingBarFrame:UnregisterAllEvents()
end

local function ShowBlizzardCastingBar()
	if castingBarState then return end
	
	castingBarState = true
	local t = { CastingBarFrame, PetCastingBarFrame }
	
	for i,v in ipairs(t) do
		v:RegisterEvent("UNIT_SPELLCAST_START")
		v:RegisterEvent("UNIT_SPELLCAST_STOP")
		v:RegisterEvent("UNIT_SPELLCAST_FAILED")
		v:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")
		v:RegisterEvent("UNIT_SPELLCAST_DELAYED")
		v:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
		v:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE")
		v:RegisterEvent("PLAYER_ENTERING_WORLD")
	end

	PetCastingBarFrame:RegisterEvent("UNIT_PET")
end

local function HideBlizzardAuraFrame()
	if not auraFrameState then return end
	
	auraFrameState = false
	BuffFrame:Hide()
	TemporaryEnchantFrame:Hide()
	BuffFrame:UnregisterAllEvents()
end

local function ShowBlizzardAuraFrame()
	if auraFrameState then return end
	
	auraFrameState = true
	BuffFrame:Show()
	TemporaryEnchantFrame:Show()
	BuffFrame:RegisterEvent("PLAYER_AURAS_CHANGED")

	BuffFrame_Update()
end

function UnderHood:UpdateBlizzardFrames()
	local hb = self.db.profile.hideBlizzard

	if hb.player then HideBlizzardPlayerFrame() else ShowBlizzardPlayerFrame()end
	if hb.party then HideBlizzardPartyFrames() else ShowBlizzardPartyFrames() end
	if hb.target then HideBlizzardTargetFrame() else ShowBlizzardTargetFrame() end
	if hb.castbar then HideBlizzardCastingBar() else ShowBlizzardCastingBar() end
	if hb.aura then HideBlizzardAuraFrame() else ShowBlizzardAuraFrame() end
end
