local defaults = {
	profile = {
		general = {
			config = false,
			debug = false,
			scale = 1.0,
		},
		alpha = {
		    enablePet = true,
		    enableFocus = true,
		    enableTarget = true,
		    enableCasting = true,
		    enableRegen = true,
			combat = 1,
			ooc = 0,
			regen = 0.75,
			target = 0.75,
			focus = 0.75,
			pet = 0.75,
			casting = 0.75,
		},
		colors = {
			unit = {
				unknown = { 0.8, 0.8, 0.8 },
				hostile = { 226/255, 45/255, 75/255 },
				neutral = { 1, 1, 34/255 },
				friendly = { 0.2, 0.8, 0.15 },
				civilian = { 48/255, 113/255, 191/255 },
				tapped = { 0.5, 0.5, 0.5 },
				dead = { 0.6, 0.6, 0.6 },
				disconnected = { 0.7, 0.7, 0.7 },
				inCombat = { 1, 0, 0 },
			},
			power = {
				rage = { 226/255, 45/255, 75/255 },
				energy = { 1, 220/255, 25/255 },
				focus = { 1, 210/255, 0 },
				mana = { 48/255, 113/255, 191/255 },
			},
			pet = {
				happy = { 0, 1, 0 },
				neutral = { 1, 1, 0 },
				angry = { 1, 0, 0 },
			},
			health = {
				min = { 1, 0, 0 },
				mid = { 1, 1, 0 },
				max = { 0, 1, 0 },
			},
			cast = {
			    casting = { 0, 1, 0 },
			    channeling = { 0, 0, 1 },
			    failed = { 1, 0, 0 },
			    interrupted = { 1, 0, 0 },
			},
			threat = {
			    normal = { 0, 1, 0 },
			    warning = { 1, 1, 0 },
			    pull = { 1, 0, 0 },
			},
		},
		hideBlizzard = {
		    player = true,
		    party = true,
		    target = true,
		    castbar = true,
		    aura = false,
		},
		modules = {
			["*"] = true,
		},
	},
}

function UnderHood:SetupConfig()
	self.db = LibStub( "AceDB-3.0" ):New( "UnderHoodDB", defaults );

	self.db.RegisterCallback( self, "OnNewProfile", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileReset", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileChanged", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileCopied", "HandleProfileChanges" )
end

function UnderHood:HandleProfileChanges()
	self:UpdateModulesForProfile()
	self:UpdateBlizzardFrames()
	self:UpdateAlpha()
	self.ParentFrame:SetScale( self.db.profile.general.scale )
end

function UnderHood:UpdateModulesForProfile()
	self:Debug( "UpdateModulesForProfile()" )
	
	for k,v in self:IterateModules() do
		if v:IsEnabled() ~= self.db.profile.modules[v.moduleName] then
			if self.db.profile.modules[v.moduleName] then
				v:Enable()

				if v.GetOptions then
					self.options.args.modules.args[v.moduleName] = v:GetOptions()
				end
			else
				v:Disable()
				
				self.options.args.modules.args[v.moduleName] = nil
			end
		end
	end
end
