function UMS_OnLoad()
	ums_debugmode=0
	ums_enabled=1
	ums_idlelimit=180

	UMS_OUT_BASIC=0
	UMS_OUT_DEBUG=1
	UMS_OUT_SPAM=2

	ums_outputlevel=UMS_OUT_BASIC

	UMS_Output(UMS_OUT_BASIC,"Un-Motion Sensor v1 loaded.")

	SlashCmdList["UMSHELP"] = UMS_Usage
	SLASH_UMSHELP1 = "/ums";

	SlashCmdList["UMSDEBUG"] = UMS_debug
	SLASH_UMSDEBUG1 = "/umsdebug";

	SlashCmdList["UMSTICK"] = UMS_Tick
	SLASH_UMSTICK1 = "/umstick";

	SlashCmdList["UMSDATA"] = UMS_PrintData
	SLASH_UMSDATA1 = "/umsdata";

	this:RegisterEvent("PLAYER_LOGIN")
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE")
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE")
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL")
	this:RegisterEvent("UPDATE_WORLD_STATES")
	this:RegisterEvent("UPDATE_BATTLEFIELD_STATUS")
	this:RegisterEvent("PARTY_MEMBERS_CHANGED")


	UMS_InitData()

end

function UMS_OnEvent()

	UMS_Output(UMS_OUT_SPAM, "Event: " .. event)

	if (event == "UPDATE_BATTLEFIELD_STATUS") then
		UMS_InitData()
	else
		UMS_Tick()
	end

end

function UMS_debug()

	UMS_Output(UMS_OUT_DEBUG, "UMS_debug")

end

function UMS_InitData()
	local i

	UMS_Output(UMS_OUT_SPAM,"calling initdata")

	ums_data = { }

	for i = 1, 40, 1 do
		ums_data[i] = { }
		ums_data[i].used=0
		ums_data[i].name=""
		ums_data[i].x=0
		ums_data[i].y=0
		ums_data[i].new=0
		ums_data[i].ticks=0
		ums_data[i].last=0
		ums_data[i].flag=0
		ums_data[i].audit=0
	end
end

function UMS_Output(level, msg)
	if (ums_outputlevel) then
		checkagainst=ums_outputlevel
	else
		checkagainst=1
	end
	if level <= checkagainst then
		DEFAULT_CHAT_FRAME:AddMessage("UMS: " .. msg)
	end
end

function UMS_PrintData()
	local i
	local D
	for i = 1, 40, 1 do
		if ( ums_data[i].used == 1 ) then
			D = GetTime() - ums_data[i].last
--			UMS_Output(UMS_OUT_BASIC, "I=" .. i .. " A=" .. ums_data[i].used .. " N=" .. ums_data[i].name .. " D=" .. D .. " X=" .. ums_data[i].x .. " Y=" .. ums_data[i].y )
			UMS_Output(UMS_OUT_BASIC, ums_data[i].name .. " D=" .. D .. " " .. ums_data[i].last .. " X=" .. ums_data[i].x .. " Y=" .. ums_data[i].y )

		end
	end
end

function UMS_Usage()
	SFW_Output(UMS_OUT_BASIC, "Usage:")
end
	
function UMS_Tick()
	local i
	local x,y,n
	local z
	local ok

	ok=0
	z=GetZoneText()
	if (z=="Alterac Valley") then
		ok=1
	end
	if (z=="Arathi Basin") then
		ok=1
	end
	if (z=="Eye of the Storm") then
		ok=1
	end
	if (z=="Warsong Gulch") then
		ok=1
	end

	if (ok==1) then
	
	UMS_StartAudit()

	for i = 0, 40, 1 do
		n = UnitName("raid" .. i)
		if (n) then
			x, y = GetPlayerMapPosition("raid" ..i)
			if (x > 0) then
				if (y > 0) then
					UMS_Output(10, "n=" .. n)
--					if (n == "Charnow") then
						UMS_Update(n,x,y)
--					end
				end
			end
		end
	end


	UMS_FinishAudit()

	UMS_Check()

	end
end

function UMS_myloc()
	local x,y
	x, y = GetPlayerMapPosition("player")
	UMS_Output(UMS_OUT_BASIC, "x=" .. x .. "  y=" .. y)
end

function UMS_Update(n,x,y)
	local i
	local empty
	local ret

--	UMS_Output(5, "Update " .. n .. " " .. x .. " " .. y)
	if (n == "Charnow") then
		UMS_Output(10, "Update " .. n )
	end

	empty=0
	ret=0

	for i = 1, 40, 1 do
		if (ums_data[i].used == 0) then
			empty = i
		end

		if (ums_data[i].name == n) then
			ret = i
		end
	end

--	UMS_Output(UMS_OUT_SPAM,"using slot " .. ret)

	if (ret == 0) then	
		if (empty > 0) then
			UMS_Output(UMS_OUT_SPAM,"initting slot " .. empty .." for " .. n)
			ums_data[empty].used = 1
			ums_data[empty].name=n
			ums_data[empty].x = x
			ums_data[empty].y = y
			ums_data[empty].last = GetTime()
			ret=empty
		else
			UMS_Output(10,"no empty slots")
		end
	end

	if (ret > 0) then

		if (ums_data[ret].x == x) then
			if (ums_data[ret].y == y) then
				ums_data[ret].ticks = ums_data[ret].ticks +1
--				UMS_Output(UMS_OUT_SPAM,"not moved: " .. ums_data[ret].name)
			end
		else
--			UMS_Output(UMS_OUT_SPAM,"moved: " .. ums_data[ret].name)
			ums_data[ret].x = x
			ums_data[ret].y = y
			ums_data[ret].ticks = 0
			ums_data[ret].flag = 0
			ums_data[ret].last = GetTime()
		end

		ums_data[ret].audit = 1

	end
end

function UMS_Check()
	local i
	local d
	local c

	c=0

	for i = 1, 40, 1 do
		if (ums_data[i].used == 1) then
			d=GetTime() - ums_data[i].last
			if (d >= ums_idlelimit) then
				UMS_Output(UMS_OUT_DEBUG, ums_data[i].name .. " idle for " .. d)
				c=c+1

				if (ums_data[i].flag == 0) then
					ums_data[i].flag = 1
					UMS_Report(ums_data[i].name,d)
				end
			end
		end
	end
--	if (c>0) then
--		UMS_Output(UMS_OUT_DEBUG,"counted " .. c)
--	end
end

function UMS_Report(n,x)
	y = round(x,0)
	UMS_Output(UMS_OUT_BASIC, "Report: " .. n .. " idle for " .. y)
	SendChatMessage("Unmotion Sensor: " .. n .. " has not moved for 3 minutes.","BATTLEGROUND")

end

function UMS_StartAudit()
	local i

	for i = 1, 40, 1 do
		ums_data[i].audit=0
	end
end

function UMS_FinishAudit()
	local i

	for i = 1, 40, 1 do
		if (ums_data[i].audit == 0) then
			if (ums_data[i].used == 1) then
				ums_data[i].used=0
				UMS_Output(UMS_OUT_DEBUG,"Removing " .. i .. " " .. ums_data[i].name )
			end
		end
	end
end

    function round(num, idp)
      local mult = 10^(idp or 0)
      return math.floor(num * mult + 0.5) / mult
    end

