-- TunnelVision
-- Coded by Lilcure of Guild Shadowed Soul, Ysera US
-- Inspired by Borbies

-- Begin Date 08/21/2007
		-- A rather simple addon, it does 1 thing
		--	1. Displays warnings based on percent and time til death for selected units
		
		-- TODO
		--	1. Fubar
		--	2. More selectivity in who is and who isn't shown
		--	3. Raid Units
-- 08/28/2007
	-- 0.2
		-- ADDED:
		--	Fubar
		--	Zone Check
		--	Converted to sink from soar and added dogtags
	-- 0.2.1
		-- ADDED:
		--	SharedMedia font support for the warnings
-- 08/30/2007
	-- 0.3
		-- ADDED:
		--	Check box to force it to use Blizzard Error frame rather then a scrolling mod
		--	adjustable warning rate
-- 08/30/2007
	-- 0.4 (preparing for RC1)
		-- Worked on making the script more efficient with redundent operations turned into seperate functions
		-- Combined a few seperate functions into one task
-- Library  declarations
local L = AceLibrary("AceLocale-2.2"):new("TunnelVision")
local waterfall = AceLibrary("Waterfall-1.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local sink = AceLibrary("Sink-1.0")
local sm = AceLibrary("SharedMedia-1.0")
local dt = AceLibrary("DogTag-1.0")
local Tablet = AceLibrary("Tablet-2.0");

-- Global variables to this addon, hate to use them but it's the easiest way to do some things
TunnelVision = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

local health_solo_arr = {
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
					}
						
local health_party_arr = {
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
						{ 0,0,0,0,0,0,0,0,0,0,0, },
					}

local units_solo_arr = {
						"player",
						"pet",
					}
					
local units_party_arr = {
						"party1",
						"party2",
						"party3",
						"party4",
						"partypet1",
						"partypet2",
						"partypet3",
						"partypet4",
					}

local time_death_solo_arr = { 0, 0, }
local time_death_party_arr = { 0,0,0,0,0,0,0,0, }

function TunnelVision:OnInitialize()
	self.opts = { 
	  desc = L["TunnelVision"],
	  type = "group",
	  args = {
	        showsolo = {
	            type = 'toggle',
	            name = L["Solo Warnings"],
	            desc = L["Show warnings for yourself"],
	            get = "IsShowSolo",
	            set = "ToggleShowSolo"
	        },
	        showsolopet = {
	            type = 'toggle',
	            name = L["Solo Pet Warnings"],
	            desc = L["Show warnings for your pet"],
	            get = "IsShowSoloPet",
	            set = "ToggleShowSoloPet"
	        },
	        showparty = {
	            type = 'toggle',
	            name = L["Party Warnings"],
	            desc = L["Show warnings for your party members"],
	            get = "IsShowParty",
	            set = "ToggleShowParty"
	        },
	        showpartypet = {
	            type = 'toggle',
	            name = L["Party Pet Warnings"],
	            desc = L["Show warnings for your party members' pet"],
	            get = "IsShowPartyPet",
	            set = "ToggleShowPartyPet"
	        },
	        zone = {
	            type = 'toggle',
	            name = L["Out of Zone Warnings"],
	            desc = L["Show warnings for units that are not in the same zone as you."],
	            get = "IsZone",
	            set = "ToggleZone"
	        },
	        forceerrorframe = {
	            type = 'toggle',
	            name = L["Force Blizzard Error Frame"],
	            desc = L["Force TunnelVision to use the Blizzard Error frame rather then a Scrolling Combat Mod"],
	            get = "IsErrorFrame",
	            set = "ToggleErrorFrame"
	        },
			warningpercent = {
				type = "range",
				name = L["Warning Percent"],
				desc = L["Change the percent at which you receive a warning message at (0 to disable)"],
				min = 0,
				max = 100,
				step = 1,
				get = function() return self.db.profile.warningpercent end,
				set = function(val)	self.db.profile.warningpercent = val end,
			},
			warningtime = {
				type = "range",
				name = L["Warning Time"],
				desc = L["Change the time, in seconds, at which you receive an estimated death time at (0 to disable)"],
				min = 0,
				max = 20,
				step = 1,
				get = function() return self.db.profile.warningtime end,
				set = function(val)	self.db.profile.warningtime = val end,
			},
			warningrate = {
				type = "range",
				name = L["Warning Rate"],
				desc = L["Change the rate, in seconds, at which you receive warning messages"],
				min = .5,
				max = 5,
				step = .5,
				get = function() return self.db.profile.warningrate end,
				set = function(val)	self.db.profile.warningrate = val end,
			},
			size = {
				type = "range",
				name = L["Font Size"],
				desc = L["Change the font size for the warnings."],
				min = 5,
				max = 30,
				step = .5,
				get = function() return self.db.profile.size end,
				set = function(val)	
					self.db.profile.size = val 
					self:SendMessage("This is a test of the TunnelVision output message!!!")
				end,
			},
			textcolor = {
				name = L["Text Color"],
				desc = L["Set the color font color for the warnings"],
				type = "color",
				get = function()
					return self.db.profile.r, self.db.profile.g, self.db.profile.b
				end,
				set = function(r, g, b)
					self.db.profile.r, self.db.profile.g, self.db.profile.b = r, g, b
					self:SendMessage("This is a test of the TunnelVision output message!!!")
				end,
				hasAlpha = false
			},
			font = {
				name = L["Font"],
				desc = L["Set the font to use for the warnings"],
				type = 'text',
				validate = sm:List('font'),
				get = function()
					return self.db.profile.font
				end,
				set = function(val)
					self.db.profile.font = val
					self:SendMessage("This is a test of the TunnelVision output message!!!")
				end,
			},
			config = {
				name = L["Config"],
				desc = L["Open TunnelVision Configuration Window"],
				type = "execute",
				order = 500,
				func = function()
					waterfall:Open("TunnelVision_Config")
					dewdrop:Close()
				end,
			},
	    },
	}
	waterfall:Register('TunnelVision_Config',
		'aceOptions', self.opts,
		'title', L["TunnelVision Config"]
	)
	self:RegisterChatCommand(L["Slash-Commands"], self.opts)
	self:RegisterDB("TunnelVisionDB", "TunnelVisionDBPC")
	self:RegisterDefaults("profile", {
		showsolo = true,
		showsolopet = true,
		showparty = true,
		showpartypet = true,
		zone = false,
		warningtime = 20,
		warningpercent = 0,
		warningrate = 2,
		size = 12,
		font = "Friz Quadrata TT",
		forceerrorframe = false,
		r = 1,
		g = 1,
		b = 0,
	} )
-- Fubar bits
	TunnelVision.hasIcon = "Interface\\AddOns\\TunnelVision\\icon.tga"
	TunnelVision.defaultPosition = "LEFT"
	TunnelVision.defaultMinimapPosition = 180
	TunnelVision.LastWarning = 0;
end

function TunnelVision:OnEnable()
	self:RegisterEvent("PLAYER_REGEN_DISABLED","StartHeartbeat");
	self:RegisterEvent("PLAYER_REGEN_ENABLED","StopHeartbeat");
-- Fubar bits
    self:SetIcon(true)
	TunnelVision.OnMenuRequest = self.opts
end

function TunnelVision:OnClick(button)
	if button == "LeftButton" then
		waterfall:Open("TunnelVision_Config")
		dewdrop:Close()
	end
end

function TunnelVision:OnTooltipUpdate()
	Tablet:SetHint(L["|c00FFFFFFLeft click|r for Options"])
end

function TunnelVision:StartHeartbeat()
	if not self:IsEventScheduled("Heartbeat") then
		TunnelVision:SetupArrays();
		self:ScheduleRepeatingEvent("Heartbeat", self.Heartbeat, .5, self)
	end
end

function TunnelVision:StopHeartbeat()
	self:CancelScheduledEvent("Heartbeat")
	TunnelVision.LastWarning = 0;
end

function TunnelVision:Heartbeat()
	TunnelVision:ShiftDamageArrs();
	TunnelVision:CurrentHealth();
	if self.db.profile.warningtime > 0 then
		TunnelVision:CalculateDeathTime(units_solo_arr,health_solo_arr,time_death_solo_arr);
		TunnelVision:CalculateDeathTime(units_party_arr,health_party_arr,time_death_party_arr);
	end
	TunnelVision.LastWarning = TunnelVision.LastWarning + .5
	if TunnelVision.LastWarning >= self.db.profile.warningrate then
		TunnelVision.LastWarning = 0;
		TunnelVision:CheckWarnings()
	end
end

function TunnelVision:CheckWarnings()
	if TunnelVision:IsShowSolo() then
		TunnelVision:CheckPercent("player")
		TunnelVision:CheckDeathTime("player",time_death_solo_arr,1)
	end
	if TunnelVision:IsShowSoloPet() then
		TunnelVision:CheckPercent("pet")
		TunnelVision:CheckDeathTime("pet",time_death_solo_arr,2)
	end
	if TunnelVision:IsShowParty() then
		for x=1,4 do
			TunnelVision:CheckPercent(units_party_arr[x])
			TunnelVision:CheckDeathTime(units_party_arr[x],time_death_party_arr,x)
		end
	end
	if TunnelVision:IsShowPartyPet() then
		for x=4,8 do
			TunnelVision:CheckPercent(units_party_arr[x])
			TunnelVision:CheckDeathTime(units_party_arr[x],time_death_party_arr,x)
		end
	end
end
	
function TunnelVision:CheckPercent(unit)
	if self.db.profile.warningpercent == 0 then
		return
	end
	local percent_threshold = self.db.profile.warningpercent / 100
	if UnitExists(unit) then
		local cur_percent_health = UnitHealth(unit) / UnitHealthMax(unit)
		if cur_percent_health <= percent_threshold then
			TunnelVision:CreateWarning(unit,"percent",cur_percent_health)
		end
	end
end

function TunnelVision:CheckDeathTime(unit,arr,idx)
	if self.db.profile.warningtime == 0 then
		return
	end
	if UnitExists(unit) then
		if arr[idx] <= self.db.profile.warningtime and arr[idx] > 0 then
			TunnelVision:CreateWarning(unit,"time",arr[idx])
		end
	end
end

function TunnelVision:CreateWarning(unit,warning_type,amt)
	if dt:Evaluate("player","[zone]") == dt:Evaluate(unit,"[zone]") or TunnelVision:IsZone() then
		if UnitExists(unit) then
			if warning_type == "percent" then
				amt = amt * 100
				amt = string.format("%.f", amt)
				TunnelVision:SendMessage(UnitName(unit).."'s health has fallen to "..amt.."%!!!")
			elseif warning_type == "time" then
				TunnelVision:SendMessage(UnitName(unit).." will die in about "..string.format("%.f",amt).." seconds!!!")
			end
		end
	end
end
	
function TunnelVision:SendMessage(message)
	if TunnelVision:IsErrorFrame() then
		if UIErrorsFrame then
			UIErrorsFrame:AddMessage(message, self.db.profile.r, self.db.profile.g, self.db.profile.b, 1, UIERRORS_HOLD_TIME)
		end
	else
		sink:Pour(message, self.db.profile.r, self.db.profile.g, self.db.profile.b, self.db.profile.font, self.db.profile.size, nil, true)
	end
end
	
function TunnelVision:CalculateDeathTime(units_arr,health_arr,time_death_arr)
	for x=1, table.getn(units_arr) do
		if UnitExists(units_arr[x]) then
			oldest_health, z = TunnelVision:OldestHealth(health_arr,x)
			if oldest_health ~= -99 then
				local max_health = UnitHealthMax(units_arr[x])
				local cur_health = UnitHealth(units_arr[x])
				if max_health == cur_health then
					time_death_arr[x] = -99
				else
					local dropped = oldest_health - health_arr[x][1]
					local time_dropped = (z - 1) / 2
					local per_second = dropped / time_dropped
					time_death_arr[x] = health_arr[x][1] / per_second
				end
			end
		end
	end
end				
			
function TunnelVision:OldestHealth(arr,idx)
	local oldest_found = 1
	for x=table.getn(arr[idx]), 1, -1 do
		if arr[idx][x] ~= -99 then
			oldest_found = x
			break;
		end
	end
    return arr[idx][oldest_found], oldest_found
end

function TunnelVision:CurrentHealth()
	for x=1, table.getn(units_solo_arr) do
		if UnitExists(units_solo_arr[x]) then
			health_solo_arr[x][1] = UnitHealth(units_solo_arr[x]);
		end
	end
	for x=1, table.getn(units_party_arr) do
		if UnitExists(units_party_arr[x]) then
			health_party_arr[x][1] = UnitHealth(units_party_arr[x]);
		end
	end
end
	
function TunnelVision:ShiftDamageArrs()
	for x=1, table.getn(health_solo_arr) do
		for y=table.getn(health_solo_arr[x]) - 1, 1, -1 do
			health_solo_arr[x][y+1] = health_solo_arr[x][y]
		end
	end
	for x=1, table.getn(health_party_arr) do
		for y=table.getn(health_party_arr[x]) - 1, 1 do
			health_party_arr[x][y+1] = health_party_arr[x][y]
		end
	end
end

function TunnelVision:SetupArrays()
	for x=1, table.getn(health_solo_arr) do
		for y=1, table.getn(health_solo_arr[x]) do
			health_solo_arr[x][y] = -99
		end
	end
	for x=1, table.getn(health_party_arr) do
		for y=1, table.getn(health_party_arr[x]) do
			health_party_arr[x][y] = -99
		end
	end
	for x=1, table.getn(time_death_solo_arr) do
		time_death_solo_arr[x] = -99
	end
	for x=1, table.getn(time_death_party_arr) do
		time_death_party_arr[x] = -99
	end
end

function TunnelVision:IsShowSolo()
    return self.db.profile.showsolo
end

function TunnelVision:ToggleShowSolo()
    self.db.profile.showsolo = not self.db.profile.showsolo
end

function TunnelVision:IsShowSoloPet()
    return self.db.profile.showsolopet
end

function TunnelVision:ToggleShowSoloPet()
    self.db.profile.showsolopet = not self.db.profile.showsolopet
end

function TunnelVision:IsShowParty()
    return self.db.profile.showparty
end

function TunnelVision:ToggleShowParty()
    self.db.profile.showparty = not self.db.profile.showparty
end

function TunnelVision:IsShowPartyPet()
    return self.db.profile.showpartypet
end

function TunnelVision:ToggleShowPartyPet()
    self.db.profile.showpartypet = not self.db.profile.showpartypet
end

function TunnelVision:IsZone()
    return self.db.profile.zone
end

function TunnelVision:ToggleZone()
    self.db.profile.zone = not self.db.profile.zone
end

function TunnelVision:IsErrorFrame()
    return self.db.profile.forceerrorframe
end

function TunnelVision:ToggleErrorFrame()
    self.db.profile.forceerrorframe = not self.db.profile.forceerrorframe
end
