﻿TrinityBars2.buttonSkins = {
	["Square (Blizz Default)"] = {
		["NormalTexture"] = "Interface\\Buttons\\UI-Quickslot2",
		["NormalTextureEmpty"] = "Interface\\Buttons\\UI-Quickslot",
		["NormalTextureW"] = 56,
		["NormalTextureH"] = 56,
		["Border"] = "Interface\\Buttons\\UI-ActionButton-Border",
		["BorderW"] = 56,
		["BorderH"] = 56,
		["HighlightTexture"] = "Interface\\Buttons\\ButtonHilight-Square",
		["HighlightTextureW"] = 33,
		["HighlightTextureH"] = 33,
		["CheckedTexture"] = "Interface\\Buttons\\CheckButtonHilight",
		["CheckedTextureW"] = 33,
		["CheckedTextureH"] = 33,
		["PushedTexture"] = "Interface\\Buttons\\UI-Quickslot-Depress",
		["PushedTextureW"] = 33,
		["PushedTextureH"] = 33,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "",
		["SheenTextureW"] = 56,
		["SheenTextureH"] = 56,
		["IconFrameW"]= 31,
		["IconFrameH"]= 31,
		["IconFrameCooldownTL"]= { 0, 0 },
		["IconFrameCooldownBR"]= { 0, 0 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 0, 0 },
		["IconBR"] = { -1, 1 },
		["IconTexCoord"] = { 0, 1, 0, 1 },
		["HotKeyHeight"] = 10,
		["HotKeySetPoint"] = { "TOPLEFT", -3, -4 },
		["CountTextHeight"] = 14,
		["CountTextSetPoint"] = { "BOTTOMRIGHT", -2, 2 },
		["AutoCastType"] = "AutoCast",
		["AutoCastTL"] = { 3, 1 },
		["AutoCastBR"] = { -1, 3 },
		["AutoCastScale"] = 0.9,
	},

	["Square Normal"] = {
		["NormalTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\normalSquare.tga",
		["NormalTextureEmpty"] = "Interface\\Addons\\TrinityBars2\\Images\\normalSquare.tga",
		["NormalTextureW"] = 36,
		["NormalTextureH"] = 36,
		["Border"] = "Interface\\Buttons\\UI-ActionButton-Border",
		["BorderW"] = 55,
		["BorderH"] = 55,
		["HighlightTexture"] = "Interface\\Buttons\\ButtonHilight-Square",
		["HighlightTextureW"] = 31,
		["HighlightTextureH"] = 31,
		["CheckedTexture"] = "Interface\\Buttons\\CheckButtonHilight",
		["CheckedTextureW"] = 31,
		["CheckedTextureH"] = 31,
		["PushedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\normalSquare.tga",
		["PushedTextureW"] = 34,
		["PushedTextureH"] = 34,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "",
		["SheenTextureW"] = 34,
		["SheenTextureH"] = 34,
		["IconFrameW"]= 30	,
		["IconFrameH"]= 30,
		["IconFrameCooldownTL"]= { 0, 0 },
		["IconFrameCooldownBR"]= { 0, 0 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 2.5, -2.5 },
		["IconBR"] = { -2.5, 2.5 },
		["IconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["HotKeyHeight"] = 10,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 14,
		["CountTextSetPoint"] = { "BOTTOMRIGHT", -2, 2 },
		["AutoCastType"] = "AutoCast",
		["AutoCastTL"] = { 3, 0 },
		["AutoCastBR"] = { 0, 3 },
		["AutoCastScale"] = 0.9,
	},

	["Square Thick"] = {
		["NormalTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\thickSquare.tga",
		["NormalTextureEmpty"] = "Interface\\Addons\\TrinityBars2\\Images\\thickSquare.tga",
		["NormalTextureW"] = 43,
		["NormalTextureH"] = 43,
		["Border"] = "Interface\\Buttons\\UI-ActionButton-Border",
		["BorderW"] = 55,
		["BorderH"] = 55,
		["HighlightTexture"] = "Interface\\Buttons\\ButtonHilight-Square",
		["HighlightTextureW"] = 31,
		["HighlightTextureH"] = 31,
		["CheckedTexture"] = "Interface\\Buttons\\CheckButtonHilight",
		["CheckedTextureW"] = 31,
		["CheckedTextureH"] = 31,
		["PushedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\thickSquare.tga",
		["PushedTextureW"] = 41,
		["PushedTextureH"] = 41,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "",
		["SheenTextureW"] = 34,
		["SheenTextureH"] = 34,
		["IconFrameW"]= 30	,
		["IconFrameH"]= 30,
		["IconFrameCooldownTL"]= { 0, 0 },
		["IconFrameCooldownBR"]= { 0, 0 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 1, -1 },
		["IconBR"] = { -1, 1 },
		["IconTexCoord"] = { 0, 1, 0, 1 },
		["HotKeyHeight"] = 10,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 14,
		["CountTextSetPoint"] = { "BOTTOMRIGHT", -2, 2 },
		["AutoCastType"] = "AutoCast",
		["AutoCastTL"] = { 3, 0 },
		["AutoCastBR"] = { 0, 3 },
		["AutoCastScale"] = 0.9,
	},

	["Square Trimmed"] = {
		["NormalTexture"] = "",
		["NormalTextureEmpty"] = "Interface\\Buttons\\UI-Quickslot",
		["NormalTextureW"] = 60,
		["NormalTextureH"] = 60,
		["Border"] = "Interface\\Buttons\\UI-ActionButton-Border",
		["BorderW"] = 65,
		["BorderH"] = 65,
		["HighlightTexture"] = "Interface\\Buttons\\ButtonHilight-Square",
		["HighlightTextureW"] = 40,
		["HighlightTextureH"] = 40,
		["CheckedTexture"] = "Interface\\Buttons\\CheckButtonHilight",
		["CheckedTextureW"] = 40,
		["CheckedTextureH"] = 40,
		["PushedTexture"] = "Interface\\Buttons\\ButtonHilight-Square",
		["PushedTextureW"] = 40,
		["PushedTextureH"] = 40,
		["PushedBlendMode"] = "ADD",
		["SheenTexture"] = "",
		["SheenTextureW"] = 60,
		["SheenTextureH"] = 60,
		["IconFrameW"]= 36,
		["IconFrameH"]= 36,
		["IconFrameCooldownTL"]= { 0, 0 },
		["IconFrameCooldownBR"]= { 0, 0 },
		["IconFrameIconTexCoord"] = { 0.08, 0.92, 0.08, 0.92 },
		["IconTL"] = { 0, 0 },
		["IconBR"] = { 0, 0 },
		["IconTexCoord"] = { 0.08, 0.92, 0.08, 0.92 },
		["HotKeyHeight"] = 10,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 14,
		["CountTextSetPoint"] = { "BOTTOMRIGHT", -2, 2 },
		["AutoCastType"] = "AutoCast",
		["AutoCastTL"] = { 0, 0 },
		["AutoCastBR"] = { 0, 0 },
		["AutoCastScale"] = 1.1,
	},

	["Round"] = {
		["NormalTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButton.tga",
		["NormalTextureEmpty"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButton.tga",
		["NormalTextureW"] = 36,
		["NormalTextureH"] = 36,
		["Border"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButtonBorder.tga",
		["BorderW"] = 36,
		["BorderH"] = 36,
		["HighlightTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButtonHiLight.tga",
		["HighlightTextureW"] = 36,
		["HighlightTextureH"] = 36,
		["CheckedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButtonChecked.tga",
		["CheckedTextureW"] = 34,
		["CheckedTextureH"] = 34,
		["PushedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButton.tga",
		["PushedTextureW"] = 34,
		["PushedTextureH"] = 34,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\RoundButtonSheen2.tga",
		["SheenTextureW"] = 29,
		["SheenTextureH"] = 27,
		["IconFrameW"]= 23,
		["IconFrameH"]= 23,
		["IconFrameCooldownTL"]= { 0, -0 },
		["IconFrameCooldownBR"]= { -0, 0 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 6, -6 },
		["IconBR"] = { -6, 6 },
		["IconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["HotKeyHeight"] = 8,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 10,
		["CountTextSetPoint"] = { "BOTTOM", 0, 0 },
		["AutoCastType"] = "AutoCastSim",
		["AutoCastTL"] = { 4, 4 },
		["AutoCastBR"] = { 4, 4 },
		["AutoCastScale"] = 0.9,

	},

	["Diamond"] = {
		["NormalTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\diamond.tga",
		["NormalTextureEmpty"] = "Interface\\Addons\\TrinityBars2\\Images\\diamond.tga",
		["NormalTextureW"] = 36,
		["NormalTextureH"] = 36,
		["Border"] = "Interface\\Addons\\TrinityBars2\\Images\\diamondBorder.tga",
		["BorderW"] = 36,
		["BorderH"] = 36,
		["HighlightTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\diamondHighlight.tga",
		["HighlightTextureW"] = 36,
		["HighlightTextureH"] = 36,
		["CheckedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\diamondChecked.tga",
		["CheckedTextureW"] = 36,
		["CheckedTextureH"] = 36,
		["PushedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\diamond.tga",
		["PushedTextureW"] = 34,
		["PushedTextureH"] = 34,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\diamondSheen.tga",
		["SheenTextureW"] = 34,
		["SheenTextureH"] = 34,
		["IconFrameW"]= 19,
		["IconFrameH"]= 19,
		["IconFrameCooldownTL"]= { 0, 0 },
		["IconFrameCooldownBR"]= { 0, 0 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 9 -9 },
		["IconBR"] = { -9, 9 },
		["IconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["HotKeyHeight"] = 8,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 10,
		["CountTextSetPoint"] = { "BOTTOM", 0, 0 },
		["AutoCastType"] = "AutoCastSim",
		["AutoCastTL"] = { 4, 4 },
		["AutoCastBR"] = { 4, 4 },
		["AutoCastScale"] = 0.9,
	},

	["Hex 3D"] = {
		["NormalTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\hex.tga",
		["NormalTextureEmpty"] = "Interface\\Addons\\TrinityBars2\\Images\\hex.tga",
		["NormalTextureW"] = 36,
		["NormalTextureH"] = 36,
		["Border"] = "Interface\\Addons\\TrinityBars2\\Images\\hexBorder.tga",
		["BorderW"] = 36,
		["BorderH"] = 36,
		["HighlightTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\hexHighlight.tga",
		["HighlightTextureW"] = 36,
		["HighlightTextureH"] = 36,
		["CheckedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\hexChecked.tga",
		["CheckedTextureW"] = 34,
		["CheckedTextureH"] = 34,
		["PushedTexture"] = "Interface\\Addons\\TrinityBars2\\Images\\hex.tga",
		["PushedTextureW"] = 34,
		["PushedTextureH"] = 34,
		["PushedBlendMode"] = "BLEND",
		["SheenTexture"] = "",
		["SheenTextureW"] = 29,
		["SheenTextureH"] = 27,
		["IconFrameW"]= 21,
		["IconFrameH"]= 21,
		["IconFrameCooldownTL"]= { 2, -2 },
		["IconFrameCooldownBR"]= { -2, 2 },
		["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["IconTL"] = { 7, -7 },
		["IconBR"] = { -7, 7 },
		["IconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 },
		["HotKeyHeight"] = 8,
		["HotKeySetPoint"] = { "TOPLEFT", -1, -4 },
		["CountTextHeight"] = 10,
		["CountTextSetPoint"] = { "BOTTOM", 0, 0 },
		["AutoCastType"] = "AutoCastSim",
		["AutoCastTL"] = { 4, 4 },
		["AutoCastBR"] = { 4, 4 },
		["AutoCastScale"] = 0.9,

	},
}

function TrinityBars2.loadCyCircledSkins()

	local skin

	if (cyCircled) then
		for k,v in pairs (cyCircled.skins) do

			skin = "Cy: "..k

			if (not TrinityBars2.buttonSkins[skin]) then
				TrinityBars2.buttonSkins[skin] = {}
			end

			TrinityBars2.buttonSkins[skin]["NormalTexture"] = cyCircled.skins[k]["overlay"]["tex"]
			TrinityBars2.buttonSkins[skin]["NormalTextureEmpty"]  = cyCircled.skins[k]["overlay"]["tex"]
			TrinityBars2.buttonSkins[skin]["NormalTextureW"] = cyCircled.skins[k]["overlay"]["w"]
			TrinityBars2.buttonSkins[skin]["NormalTextureH"] = cyCircled.skins[k]["overlay"]["h"]
			TrinityBars2.buttonSkins[skin]["Border"] = cyCircled.skins[k]["equip"]["tex"]
			TrinityBars2.buttonSkins[skin]["BorderW"] = cyCircled.skins[k]["equip"]["w"]*0.7
			TrinityBars2.buttonSkins[skin]["BorderH"] = cyCircled.skins[k]["equip"]["h"]*0.7
			TrinityBars2.buttonSkins[skin]["HighlightTexture"] = cyCircled.skins[k]["HighlightTexture"]["tex"]
			if (cyCircled.skins[k]["icon"]["w"] < 30) then
				TrinityBars2.buttonSkins[skin]["HighlightTextureW"] = cyCircled.skins[k]["HighlightTexture"]["w"]*0.8
				TrinityBars2.buttonSkins[skin]["HighlightTextureH"] = cyCircled.skins[k]["HighlightTexture"]["h"]*0.8
			else
				TrinityBars2.buttonSkins[skin]["HighlightTextureW"] = cyCircled.skins[k]["HighlightTexture"]["w"]
				TrinityBars2.buttonSkins[skin]["HighlightTextureH"] = cyCircled.skins[k]["HighlightTexture"]["h"]
			end
			TrinityBars2.buttonSkins[skin]["CheckedTexture"] = cyCircled.skins[k]["CheckedTexture"]["tex"]
			TrinityBars2.buttonSkins[skin]["CheckedTextureW"] = cyCircled.skins[k]["CheckedTexture"]["w"]
			TrinityBars2.buttonSkins[skin]["CheckedTextureH"] = cyCircled.skins[k]["CheckedTexture"]["w"]
			TrinityBars2.buttonSkins[skin]["PushedTexture"] = cyCircled.skins[k]["overlay"]["tex"]
			TrinityBars2.buttonSkins[skin]["PushedTextureW"] = cyCircled.skins[k]["overlay"]["w"]*0.93
			TrinityBars2.buttonSkins[skin]["PushedTextureH"] = cyCircled.skins[k]["overlay"]["w"]*0.93
			TrinityBars2.buttonSkins[skin]["PushedBlendMode"] = "BLEND"
			TrinityBars2.buttonSkins[skin]["SheenTexture"] = ""
			TrinityBars2.buttonSkins[skin]["SheenTextureW"] = 39
			TrinityBars2.buttonSkins[skin]["SheenTextureH"] = 39
			TrinityBars2.buttonSkins[skin]["IconFrameW"] = cyCircled.skins[k]["icon"]["w"]*0.99
			TrinityBars2.buttonSkins[skin]["IconFrameH"] = cyCircled.skins[k]["icon"]["h"]*0.99
			TrinityBars2.buttonSkins[skin]["IconFrameCooldownTL"] = { 1, -1 }
			TrinityBars2.buttonSkins[skin]["IconFrameCooldownBR"] = { -1, 1 }
			TrinityBars2.buttonSkins[skin]["IconFrameIconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 }
			if (cyCircled.skins[k]["icon"]["w"] < 30) then
				TrinityBars2.buttonSkins[skin]["IconTL"] = { 6, -6 }
				TrinityBars2.buttonSkins[skin]["IconBR"] = { -6, 6 }
			else
				TrinityBars2.buttonSkins[skin]["IconTL"] = { 3, -3 }
				TrinityBars2.buttonSkins[skin]["IconBR"] = { -3, 3 }
			end
			TrinityBars2.buttonSkins[skin]["IconTexCoord"] = { 0.05, 0.95, 0.05, 0.95 }
			TrinityBars2.buttonSkins[skin]["HotKeyHeight"] = 10
			TrinityBars2.buttonSkins[skin]["HotKeySetPoint"] = { "CENTER", cyCircled.skins[k]["hotkey"]["x"], cyCircled.skins[k]["hotkey"]["y"] }
			TrinityBars2.buttonSkins[skin]["CountTextHeight"] = 10
			TrinityBars2.buttonSkins[skin]["CountTextSetPoint"] = { "CENTER", cyCircled.skins[k]["count"]["x"], cyCircled.skins[k]["count"]["y"] }
			TrinityBars2.buttonSkins[skin]["AutoCastType"] = "AutoCastSim"
			TrinityBars2.buttonSkins[skin]["AutoCastTL"] = { 4, 4 }
			TrinityBars2.buttonSkins[skin]["AutoCastBR"] = { 4, 4 }
			TrinityBars2.buttonSkins[skin]["AutoCastScale"] = 0.9
		end
	end
end