--Version info: 1.4.4 for WoW version 2.4.0
--See Change Log.txt for detailed information.

local TrashTimer_Data = {}; 	--Boss database (BIG table :P)
local displayWarning = true; 	--flag for displaying 10/30 min warnings
local debugLevel = 0; 			--debugging tools 
									--(level 0 = release/beta, 1 = normal boss alpha w/ debug spam,
									--2 = fake boss alpha w/ debug spam)
local rorjKilled = false; 		--R&J flag for Opera
local rnjTime = 0; 				--Romulo/Julianne death time (to check if it was in time)
local timerMob = "";			--Trash killed temporary storage to be used when combat ends
local timerBoss = 0;				--When combat ends, all three of these are passed to timerUpdate,
local timerZone = "";				--which decides if it needs to start or stop a timer.
TrashTimer_UpdateInterval = 1.0; --for onUpdate calls (to prevent excessive lag)



--Simple output function for testing. Just put "debugger(<string>);" in a part of code you are testing.
local function debugger(variableDump)
	if(debugLevel >= 1) then
		DEFAULT_CHAT_FRAME:AddMessage(variableDump, 0.5, 0.5, 1.0);
	end
end

--Warning output
local function warnOut(msg)
	local info = ChatTypeInfo["RAID_BOSS_EMOTE"];
	RaidNotice_AddMessage(RaidBossEmoteFrame, msg, info);
end

--Displays all active timers (if any) in main chat window or specified channel.
local function displayTimers(chan)
	local timerFlag = false; 								--initialize the flag (false = no timers)
	for zone, bossInfo in pairs(TrashTimer_Data) do			-- |                              |
		for X=1,table.getn(bossInfo) do						--\|/ get data from super-table! \|/
			local bossName, trashTime, timerActive, timerStart = TrashTimer_Data[zone][X][1], TrashTimer_Data[zone][X][2], TrashTimer_Data[zone][X][6], TrashTimer_Data[zone][X][7];
			if(timerActive == true) then
				local hours = 0;
				local mins = 0;
				local secs = 0;
				local respawnTimeLeft = trashTime - (time() - timerStart);
				if(respawnTimeLeft/3600 > 0) then			--convert the seconds to hours, minutes, and seconds.
					hours = math.floor(respawnTimeLeft/3600);
					respawnTimeLeft = respawnTimeLeft - (3600 * hours);
				end
				if(respawnTimeLeft/60 > 0) then
					mins = math.floor(respawnTimeLeft/60);
					respawnTimeLeft = respawnTimeLeft - (60 * mins);
				end
				if(respawnTimeLeft > 0) then
					secs = respawnTimeLeft;
				end
				if(hours == 0 and mins == 0 and secs == 0) then
					warnOut("|cFFFF0000"..bossName.." trash mobs respawned!");
				else
					local message = bossName.." - "..tostring(hours).." hour(s), "..tostring(mins).." minute(s), "..tostring(secs).." second(s)."
					if(chan == "raid") then
						SendChatMessage(message, "RAID");
					else
						DEFAULT_CHAT_FRAME:AddMessage(message);
					end
				end
				timerFlag = true; 							--there was at least one active timer
			end
		end
	end
	if(timerFlag == false) then
		DEFAULT_CHAT_FRAME:AddMessage("No timers active.", 0.0, 1.0, 0.0);
	end
end

--Clears a boss from the table so that it no longer scans for trash there.
local function killBoss(zone, index)
	debugger("Boss kill: "..zone.." - "..TrashTimer_Data[zone][index][1]);
	TrashTimer_Data[zone][index][3] = nil;
	TrashTimer_Data[zone][index][4] = false;
	TrashTimer_Data[zone][index][5] = false;
	TrashTimer_Data[zone][index][6] = false;
	TrashTimer_Data[zone][index][7] = 0;
	timerMob = "";
	timerBoss = 0;
	timerZone = "";
end


--Resets the settings for a boss (due to respawn or manual reset).
local function bossReset(zone, index)
	debugger("Timer reset: "..zone.." - "..TrashTimer_Data[zone][index][1]);
	TrashTimer_Data[zone][index][4] = false;
	TrashTimer_Data[zone][index][5] = false;
	TrashTimer_Data[zone][index][6] = false;
	TrashTimer_Data[zone][index][7] = 0;
end


--Takes in the mob's information and checks to see if timers need started or stopped.
local function timerUpdate(mobName, zone, index)
	debugger("zone:"..zone.." index:"..index.." mob:"..mobName);
	local bossName, timerActive = TrashTimer_Data[zone][index][1], TrashTimer_Data[zone][index][6];
	if(bossName == "Opera") then
		if(timerActive == true) then											--if the timer is on,
			if(mobName == "The Big Bad Wolf" or mobName == "The Crone") then	--and the boss is BBW or Oz,
				killBoss(zone, index);											--kill it.
			elseif(mobName == "Romulo" or mobName == "Julianne") then			--if it's RnJ and one died,
				if(rorjKilled == true and (time() - rnjTime) < 11) then			--see if one died already, and the second one was quick enough.
					killBoss(zone, index);										--then kill them.
				else															--otherwise,
					rorjKilled = true;											--save the time we kill one, and the fact we did.
					rnjTime = time();
				end
			end
		else
			debugger("Starting timer "..zone.." - "..TrashTimer_Data[zone][index][1]);
			TrashTimer_Data[zone][index][6] = true;
			TrashTimer_Data[zone][index][7] = time();
		end
	else
		if(timerActive == true) then
			return;
		else
			debugger("Starting timer "..zone.." - "..TrashTimer_Data[zone][index][1]);
			TrashTimer_Data[zone][index][6] = true;	
			TrashTimer_Data[zone][index][7] = time();
		end
	end
end

--Checks the mob's name vs. the player, trash mobs, and boss names. Then if it matches, passes it to timerUpdate.
local function checkMob(name)
	if(name) then
		if(name == UnitName("player")) then
			displayTimers();
			return;
		end
		local zone = gsub(gsub(GetRealZoneText(), " ", ""), "'", "");
		for n=1, table.getn(TrashTimer_Data[zone]) do			--extract data from the super-table!
			local bossName= TrashTimer_Data[zone][n][1];
			if TrashTimer_Data[zone][n][3] then
				for X=1, table.getn(TrashTimer_Data[zone][n][3]) do
					if(TrashTimer_Data[zone][n][3][X] == name and timerBoss==0) then		--if it's trash that died, and we haven't flagged that trash died,
						timerMob = name;								--set flags that it died. (this makes it pass a trash group as one entity
						timerBoss = n;									--and provide more accurate timer for respawn)
						timerZone = zone;
						debugger(timerMob.." "..timerBoss.." "..timerZone);
						return;
					elseif(bossName == "Opera" and (name == "Romulo" or name == "Julianne" or name == "The Crone" or name == "The Big Bad Wolf")) then
						timerUpdate(name, zone, n);		--Opera boss dead. Check for RnJ, clear timers, etc.
						return;
					elseif(bossName == name) then
						killBoss(zone, n);				--the function name speaks for itself.
						return;
					end
				end
			end
		end
	end
end	


--Initializes the database for all bosses and zones in the format of: 
-- TrashTimer_Data[<zone name in alphanumeric>][<boss number>] = table with...
-- Boss name, time to respawn, trash names (table), first warning flag, second warning flag, timer active flag, and time of first kill.
--To add to the table (for new bosses), put the zone name without spaces or "'" in it like below, and follow the same format.
local function initializeVars()
	if(debugLevel >= 2) then
		TrashTimer_Data = {
			StormwindCity = {
				{"Squirrel King", 60, {"Squirrel"}, false, false, false, 0}
			},
			ElwynnForest = {
				{"Hogger", 1805, {"Riverpaw Outrunner", "Riverpaw Runt"}, false, false, false, 0},
				{"Hogger's Friend", 605, {"Riverpaw Outrunner", "Riverpaw Runt"}, false, false, false, 0}
			}
		};
		message("Debug level is set to 2 for Trash Timer.");
	else
		TrashTimer_Data = {
			TempestKeep = {
				{"Al'ar", 7200, {"Apprentice Star Scryer", "Astromancer", "Star Scryer", "Bloodwarder Vindicator"}, false, false, false, 0},
				{"Void Reaver", 7200, {"Crystalcore Devastator"}, false, false, false, 0},
				{"High Astromancer Solarian", 7200, {"Astromancer Lord", "Novice Astromancer"}, false, false, false, 0},
				{"Kael'thas Sunstrider", 7200, {"Crimson Hand Centurion", "Crimson Hand Blood Knight", "Crimson Battle Mage", "Crimson Hand Inquisitor"}, false, false, false, 0}
			},
			SerpentshrineCavern = {
				{"Hydross the Unstable", 7200, {"Coilfang Beast-Tamer", "Coilfang Hate-Screamer", "Serpentshrine Sporebat"}, false, false, false, 0},
				{"The Lurker Below", 7200, {"Greyheart Technician", "Coilfang Priestess", "Vasj'ir Honor Guard"}, false, false, false, 0},
				{"Morogrim Tidewalker", 7200, {"Tidewalker Depth-Seer", "Tidewalker Harpooner", "Tidewalker Hydromancer", "Tidewalker Shaman", "Tidewalker Lurker", "Tidewalker Warrior"}, false, false, false, 0},
				{"Tidewalker-Leotheras Bridge", 7200, {"Coilfang Serpentguard"}, false, false, false, 0},
				{"Leotheras the Blind", 7200, {"Greyheart Spellbinder", "Greyheart Shield-Bearer", "Serpentshrine Lurker"}, false, false, false, 0}
			},
			GruulsLair = {
				{"High King Maulgar", 3600, {"Gronn-Priest", "Lair Brute"}, false, false, false, 0},
				{"Gruul the Dragonkiller", 3600, {"Gronn-Priest", "Lair Brute"}, false, false, false, 0}
			},
			MagtheridonsLair = {
				{"Magtheridon", 7200, {"Hellfire Warder"}, false, false, false, 0}
			},
			Karazhan = {
				{"Attumen the Huntsman", 1500, {"Spectral Stallion", "Spectral charger"}, false, false, false, 0},
				{"Moroes", 3600, {"Phantom Guest", "Phantom Attendant", "Phantom Valet", "Skeletal Waiter"}, false, false, false, 0},
				{"Maiden of Virtue", 3600, {"Wanton Hostess", "Concubine", "Night Mistress", "Phantom Guardsman", "Spectral Sentry"}, false, false, false, 0},
				{"Opera", 3600, {"Skeletal Usher", "Phantom Stagehand", "Spectral Performer"}, false, false, false, 0},
				{"The Curator", 3600, {"Ghastly Haunt", "Trapped Soul", "Arcane Anomaly", "Syphoner"}, false, false, false, 0},
				{"Shade of Aran", 7200, {"Arcane Protector", "Mana Feeder", "Chaotic Sentience"}, false, false, false, 0},
				{"Terestian Illhoof", 7200, {"Homunculus", "Shadow Pillager"}, false, false, false, 0},
				{"Netherspite", 7200, {"Sorcerous Shade"}, false, false, false, 0},
				{"Prince Malchezaar", 7200, {"Fleshbeast", "Greater Fleshbeast"}, false, false, false, 0}
			},
			BlackTemple = {
				{"High Warlord Naj'entus", 7200, {"Aqueous Lord", "Coilskar General", "Coilskar Harpooner", "Coilskar Sea-Caller", "Coilskar Soothsayer", "Coilskar Wrangler", "Dragon Turtle"}, false, false, false, 0},
				{"Shade of Akama", 7200, {"Illidari Nightlord", "Illidari Boneslicer", "Illidari Heartseeker", "Illidari Defiler"}, false, false, false, 0},
				{"Mother Shahraz", 7200, {"Temple Concubine", "Charming Courtesan", "Spellbound Attendant", "Enslaved Servant", "Sister of Pain", "Sister of Pleasure", "Priestess of Dementia", "Priestess of Delight"}, false, false, false, 0},
				{"Teron Gorefiend", 7200, {"Shadowmoon Champion", "Shadowmoon Houndmaster", "Shadowmoon Riding Hound", "Shadowmoon Grunt", "Shadowmoon War Hound", "Shadowmoon Reaver", "Shadowmoon Blood Mage", "Shadowmoon Deathshaper", "Shadowmoon Soldier", "Shadowmoon Weapon Master", "Shadowmoon Fallen", "Wrathbone Flayer", "Hand of Gorefiend"}, false, false, false, 0},
				{"Gurtogg Bloodboil", 7200, {"Bonechewer Behemoth", "Bonechewer Combatant", "Bonechewer Brawler", "Bonechewer Spectator", "Bonechewer Blood Fury", "Mutant War Hound"}, false, false, false, 0},
				{"Gathios the Shatterer", 7200, {"Promenade Sentinel", "Illidari Blood Lord"}, false, false, false, 0}
			},
			ZulAman = {
				{"Nalorakk", 2700, {"Amani'shi Axe Thrower", "Amani'shi Tribesman"}, false, false, false, 0},
				{"Jan'alai", 7200, {"Amani'shi Scout", "Amani'shi Trainer"}, false, false, false, 0},
				{"Akil'zon", 1800, {"Amani'shi Tempest"}, false, false, false, 0},
				{"Halazzi", 7200, {"Amani Lynx", "Amani Lynx Cub", "Amani Elder Lynx", "Amani'shi Handler", "Amani'shi Beast Tamer"}, false, false, false, 0},
				{"Hex Lord Malacrass", 7200, {"Amani'shi Berserker"}, false, false, false, 0}
			}
		};
	end
end


--Parses slash commands by sending the first word, then the remainder of the string back.
local function getCMD(msg)
	if(msg) then
		local a,b,c = string.find(msg, "(%S+)"); 	--finds the first continuous instance of no spaces (i.e. first word)
		if(a) then
			return c, string.sub(msg, b+2); 		--returns the first word, then the remaining string
		else
			return "";
		end
	end
end


--Spits out the slash commands in pretty colors :)
local function showHelp()
	DEFAULT_CHAT_FRAME:AddMessage("Trash Timer slash commands:");
	DEFAULT_CHAT_FRAME:AddMessage("  |cFF00FFFFhelp|r - displays this message.");
	DEFAULT_CHAT_FRAME:AddMessage("  |cFF00FFFFclear |cFFFFE303boss name|r - clears timer for boss if specified.");
	DEFAULT_CHAT_FRAME:AddMessage("      Otherwise, clears all timers and resets trash. You can");
	DEFAULT_CHAT_FRAME:AddMessage("      use full or partial boss names to reset them.");
	DEFAULT_CHAT_FRAME:AddMessage("  |cFF00FFFFwarn |cFFFFE303on off|r - turns on or off the 30 and 10 minute warning ");
	DEFAULT_CHAT_FRAME:AddMessage("      feature. You will still receive the warning on respawn.");
	DEFAULT_CHAT_FRAME:AddMessage("  |cFF00FFFFreport|r - announces timers to raid.");
	DEFAULT_CHAT_FRAME:AddMessage("Typing only |cFF00FF00/tt|r or |cFF00FF00/trashtimer|r shows the timers.");
end

--Enables or disables the combat log recording (to cut down on lag) depending on if you are in the zone monitored by the addon.
local function checkZone()
	local zone = gsub(gsub(GetRealZoneText(), " ", ""), "'", "");
	if TrashTimer_Data[zone] then
		if(this:IsEventRegistered("COMBAT_LOG_EVENT_UNFILTERED") == nil) then
			this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
			this:RegisterEvent("PLAYER_REGEN_ENABLED");
		end
	elseif(this:IsEventRegistered("COMBAT_LOG_EVENT_UNFILTERED") ~= nil) then
		this:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		this:UnregisterEvent("PLAYER_REGEN_ENABLED");
	end
end

--Slash command handler (uses getCMD to break apart extra bits)
function TrashTimer_Slash(msg)
	if(msg) then
		local cmd, setting = getCMD(msg);
		if(string.lower(cmd) == "help") then
			showHelp();
		elseif(string.lower(cmd) == "warn") then
			if(string.lower(setting) == "on") then
				displayWarning = true;
				DEFAULT_CHAT_FRAME:AddMessage("30 and 10 minute warnings enabled.");
			elseif(string.lower(setting) == "off") then
				displayWarning = false;
				DEFAULT_CHAT_FRAME:AddMessage("30 and 10 minute warnings disabled.");
			else
				if(displayWarning == false) then
					DEFAULT_CHAT_FRAME:AddMessage("30 and 10 minute warnings are disabled.");
				else
					DEFAULT_CHAT_FRAME:AddMessage("30 and 10 minute warnings are enabled.");
				end
			end
		elseif(string.lower(cmd) == "clear") then
			if(string.lower(setting) == "") then
				initializeVars();
				DEFAULT_CHAT_FRAME:AddMessage("All timers and trash reset.");
			else
				for zone, bossInfo in pairs(TrashTimer_Data) do
					for N=1,getn(bossInfo) do
						local bossName = TrashTimer_Data[zone][N][1];
						local a, b = string.find(string.lower(bossName), string.lower(setting)); 
						if(a) then
							bossReset(zone, N);
							DEFAULT_CHAT_FRAME:AddMessage(bossName.." timer cleared.");
						end
					end
				end
			end	
		elseif(string.lower(cmd) == "report") then
			displayTimers("raid");		
		elseif(string.lower(cmd) == "") then
			displayTimers();
		else
			showHelp();
		end
	end
end

--Registers for zone changes (including loading in) and to initialize the database table.
function TrashTimer_OnLoad()
	SLASH_TRASHTIMER1 = "/trashtimer";
	SLASH_TRASHTIMER2 = "/tt";
	SlashCmdList["TRASHTIMER"] = TrashTimer_Slash;
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("ADDON_LOADED");
	debugger("TT loaded");
end


--Checks the registered events, and passes on to appropriate functions.
function TrashTimer_OnEvent()
	if(event=="ADDON_LOADED" and arg1=="TrashTimer") then
		initializeVars();
	elseif(event == "ZONE_CHANGED_NEW_AREA" or event == "PLAYER_ENTERING_WORLD") then	--player changed zones (or started in one).
		checkZone();																	--see if it mattered.
	elseif(event=="COMBAT_LOG_EVENT_UNFILTERED" and arg2 == "UNIT_DIED") then	--something died
		checkMob(arg7);															--see if it's trash or a boss, if anything.
		return;
	elseif(event == "PLAYER_REGEN_ENABLED") then			--after combat,
		if(timerBoss ~= 0) then								--if trash flags are enabled,
			timerUpdate(timerMob, timerZone, timerBoss);	--either update timer or ignore it,
			timerMob = "";									--and reset the flags.
			timerBoss = 0;
			timerZone = "";
		end
	end
end


--Checks every second (close to it) for time to respawn and issues warnings at given intervals.
function TrashTimer_OnUpdate(self, elapsed)
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed;
	
	if(self.TimeSinceLastUpdate > TrashTimer_UpdateInterval) then
		for zone, bossInfo in pairs(TrashTimer_Data) do
			for N=1,table.getn(bossInfo) do
				local bossName, trashTime, trashWarnFirst, trashWarnSecond, timerActive, timerStart = TrashTimer_Data[zone][N][1], TrashTimer_Data[zone][N][2], TrashTimer_Data[zone][N][4], TrashTimer_Data[zone][N][5], TrashTimer_Data[zone][N][6], TrashTimer_Data[zone][N][7];
				if(timerActive == true) then
					local hours = 0;
					local mins = 0;
					local secs = 0;
					local respawnTimeLeft = trashTime - (time() - timerStart);
					--convert the seconds to hours, minutes, and seconds. 
					--If the values go negative, the initial values are used instead.
					if(respawnTimeLeft/3600 > 0) then
						hours = math.floor(respawnTimeLeft/3600);
						respawnTimeLeft = respawnTimeLeft - (3600 * hours);
					end
					if(respawnTimeLeft/60 > 0) then
						mins = math.floor(respawnTimeLeft/60);
						respawnTimeLeft = respawnTimeLeft - (60 * mins);
					end
					if(respawnTimeLeft > 0) then
						secs = respawnTimeLeft;
					end
					--double checks that the respawn time to start with isn't too short 
					--(i.e. warning 30 mins for 25 min trash like attumen)
					if(hours == 0) then
						if(mins < 30 and mins >= 10 and trashWarnFirst == false and trashTime > 1800 and displayWarning == true) then
							warnOut(bossName.." trash mobs respawning in 30 minutes.");
							TrashTimer_Data[zone][N][4] = true;
						elseif(mins < 10 and mins >= 0 and trashWarnSecond == false and trashTime > 600 and displayWarning == true) then
							warnOut(bossName.." trash mobs respawning in 10 minutes.");
							TrashTimer_Data[zone][N][5] = true;
						elseif(mins == 0 and secs == 0) then
							warnOut("|cFFFF0000"..bossName.." trash mobs respawned!");
							bossReset(zone, N);
						end
					end
				end
			end
		end
		self.TimeSinceLastUpdate = 0;			
	end
end