local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("TrainingWheels")
for i,v in pairs(TrainingWheels_Locale) do
	L:AddTranslations(v.locale, function() return v end)
end

TrainingWheels = Rock:NewAddon("TrainingWheels", "LibRockConsole-1.0", "LibRockConfig-1.0", "LibRockDB-1.0", "LibRockTimer-1.0", "LibRockEvent-1.0", "LibRockHook-1.0", "FuBarPlugin-2.0")
--TrainingWheels = Rock:NewAddon("TrainingWheels", "LibRockDB-1.0", "LibRockEvent-1.0", "LibRockTimer-1.0", "LibRockConsole-1.0", "LibRockModuleCore-1.0", "LibRockHook-1.0", "LibRockComm-1.0","LibRockConfig-1.0")

local newList, del, newDict, newSet, unpackDictAndDel, unpackListAndDel = Rock:GetRecyclingFunctions("TrainingWheels", "newList", "del", "newDict", "newSet", "unpackDictAndDel", "unpackListAndDel")

local self = TrainingWheels
local VERSION = tonumber(("$Revision: 52693 $"):match("%d+"))
self.revision = VERSION
self.date = ("$Date: 2007-10-20 14:04:19 -0400 (Sat, 20 Oct 2007) $"):match("%d%d%d%d%-%d%d%-%d%d")
self.svnURL = "$URL: svn://dev.wowace.com/wowace/trunk/TrainingWheels/TrainingWheels.lua $"
self.spellVersion = 1
local _,_,source = self.svnURL:find("^.+/(.+)/TrainingWheels/")
self.source = source:gsub("^trunk$", "stable")
self.version = "1.0r" .. VERSION .. "s"..self.spellVersion .. " (".. self.source ..")"

--Fubar
self.hasIcon = "Interface\\Icons\\INV_Misc_Gear_04"
self.hasNoColor  = true
self.cannotDetachTooltip = true
self.blizzardTooltip = true
self.hideWithoutStandby = true
self.title = "Training Wheels"
self.independentProfile = true
	
--Player Info
self.playerName = UnitName("player")
self.realmName = GetRealmName()
local _, class = UnitClass("player")
self.className = class

self.includedLists = {}
self.playerEquipment = {}
self.snapshots = {}

--Refresh options
self.thisFrameRefreshed = false
self.nextFrameRefresh = false
self.time = GetTime()
self.lastRefresh = 0
self.refreshList = {}

--For dialogs
self.configShow = nil

--Version
Rock("LibRockComm-1.0"):AddAddonVersionReceptor(function (...)
	TrainingWheels:OnVersionReceive(...)
end)

function self:OnVersionReceive(player, addon, version)
	if (addon == "TrainingWheels") then
		if (version == true) then
			version = "Unknown version"
		elseif (version == false) then
			version = "Not loaded"
		end
		self:Print("Version ("..player.."): "..version)
	end
end

function self:QueryVersion(target)
	if (target:upper() == "TARGET") then target = UnitName("target") end
	if (target ~= nil) then
		target = strtrim(target)
		if (target ~= "") then
			local distribution = target:upper()
			if (distribution ~= "GROUP" and distribution ~= "GUILD") then
				distribution = "WHISPER"
			else
				target = nil
			end
			Rock("LibRockComm-1.0"):QueryAddonVersion("TrainingWheels", distribution, target)
		end
	end
end

self.globalStrings = {
	["SPELL_CAST_TIME_SEC"] = gsub(SPELL_CAST_TIME_SEC, "%%%.%d[fg]", "(.+)"),
	["SPELL_CAST_TIME_MIN"] = gsub(SPELL_CAST_TIME_MIN, "%%%.%d[fg]", "(.+)"),
	["SPELL_RECAST_TIME_MIN"] = gsub(SPELL_RECAST_TIME_MIN, "%%%.%d[fg]", "(.+)"),
	["SPELL_RECAST_TIME_SEC"] = gsub(SPELL_RECAST_TIME_SEC, "%%%.%d[fg]", "(.+)"),
}

StaticPopupDialogs["TrainingWheels_ConfirmDeleteSpellList"] = {
	text = "Are you sure you want to delete the Spell List?",
	button1 = YES,
	button2 = NO,
	OnAccept = function(val)
		TrainingWheels:DeleteSpellList(val, true)
	end,
	OnShow = function()
		TrainingWheels.configShow = Rock("LibRockConfig-1.0").base:IsShown()
		if (TrainingWheels.configShow) then
			Rock("LibRockConfig-1.0").base:SetFrameStrata("HIGH")
		end
	end,
	onHide = function()
		if (TrainingWheels.configShow) then
			Rock("LibRockConfig-1.0").base:SetFrameStrata("FULLSCREEN_DIALOG")
		end
	end,
	timeout=0,
	exclusive=1,
	whileDead = 1,
	hideOnEscape = 1,
}
StaticPopupDialogs["TrainingWheels_ConfirmLoadSnapshot"] = {
	text = "Are you sure you want to load the snapshot?",
	button1 = YES,
	button2 = NO,
	OnAccept = function(val)
		TrainingWheels:LoadSnapshot(val, true)
	end,
	OnShow = function()
		TrainingWheels.configShow = Rock("LibRockConfig-1.0").base:IsShown()
		if (TrainingWheels.configShow) then
			Rock("LibRockConfig-1.0").base:SetFrameStrata("HIGH")
		end
	end,
	onHide = function()
		if (TrainingWheels.configShow) then
			Rock("LibRockConfig-1.0").base:SetFrameStrata("FULLSCREEN_DIALOG")
		end
	end,
	timeout=0,
	exclusive=1,
	whileDead = 1,
	hideOnEscape = 1,
};

self.options = {
	type = 'group',
	name = "Training Wheels",
	desc = "Helps you decide which spells to cast next",
	icon = "Interface\\Icons\\INV_Misc_Gear_04",
	handler = TrainingWheels,
	args = {
		{
			type = 'number',
			name = "Leeway",
			desc = "Specify the leeway duration to compensate for your reaction time. Recommended to set this to 0.1.",
			get = function() return self.db.profile.leeway end,
			set = function(v) self.db.profile.leeway = v end,
			min = 0.0,
			max = 1.5,
			step = 0.1,
			order = 1.5,
		},
		{
			type = 'number',
			name = "Latency",
			desc = "Your average latency. Affects decisions for spells with casting time.",
			get = function() return self.db.profile.latency * 1000 end,
			set = function(v) self.db.profile.latency = v / 1000 end,
			min = 0,
			max = 1500,
			step = 100,
			order = 1,
		},
		{
			type = 'number',
			name = "Maximum spells",
			desc = "The maximum number of spells to show at one time.",
			get = function() return self.db.profile.maxSpells end,
			set = function(v) self.db.profile.maxSpells = v end,
			min = 1,
			max = 20,
			step = 1,
			order = 2,
		},
		{
			type = 'boolean',
			name = "Validate spells",
			desc = "Ensure that spells typed in configuration exist.",
			get = function() return self.db.profile.validateSpells, true end,
			set = function(v) self.db.profile.validateSpells = v end,
			order = 2.5,
		},
		{
			type = 'boolean',
			name = "Show labels",
			desc = "Shows the labels of the spells instead of just showing icons.",
			get = function() return self.db.profile.showLabels, true end,
			set = function(v) self.db.profile.showLabels = v end,
			order = 2.75,
		},
		{
			type = 'execute',
			name = "Move spell frame",
			desc = "Enable moving of the Spell Frame.",
			func = function () self.SpellFrame:ToggleMoving() end,
			buttonText = function () if (not self.SpellFrame:IsMoving()) then return "Move spell frame" else return "Lock spell frame" end end,
			order = 3,
		},
		{
			type = 'execute',
			name = "Show version",
			desc = "Show version info for Training Wheels.",
			func = "ShowVersion",
			buttonText = "Show version",
			order = 4,
		},
		{
			type = 'text',
			name = "Query version",
			desc = "Query version from other players.",
			get = false,
			set = "QueryVersion",
			validate = function(val)
				if (val ~= strtrim(val)) then
					return false, "Please type a valid name."
				end
			end,
			usage = "<Name|TARGET|GROUP|GUILD>",
			order = 5,
		},
		{
			type = 'group',
			name = "Spell list",
			desc = "Add and configure spells into the spell list.",
			order = 5,
			args = function()
				--Not sure if recycling like this will do any good.
				--EDIT:Screw Recycling damn confusing crap
				local output = {
					{
						type = 'string',
						name = "Add spell",
						desc = "Add a spell into the list.",
						get = false,
						set = "AddSpell",
						validate = function(value)
							if (value == "" or value ~= strtrim(value)) then
								return false, "Please type a correct name."
							else 
								for i,v in pairs(self.db.char.spellList) do
									if (v.name == value) then
										return false, "Please type a unique name."
										
									end
								end
								return true
							end
						end,
						usage = "<Spell Name (Modifiers)>",
						order = 1,
					},
					{
						type = 'string',
						name = "Save spell list",
						desc = "Save your current spell list into the database, so that you can use it with other characters.",
						get = false,
						set = "SaveSpellList",
						validate = function(value)
							if (value == "" or value ~= strtrim(value)) then
								return false, "Please choose a proper name."
							else 
								for i,v in pairs(self.db.profile.spellLists) do
									if (v.name == value) then
										return false, "Please choose a unique name."
									end
								end
								return true
							end
						end,
						usage = "Please enter a descriptive name. Be careful not to override existing spell lists.",
						order = 2,
					},
					{
						type = 'execute',
						name = "Clear spell list",
						desc = "Clear your current spell list, making it empty.",
						func = "ClearSpellList",
						buttonText = "Clear",
						disabled = function() return #self.db.char.spellList == 0 end,
						confirmText = "Confirm Clear",
						order = 3,
					},
					{
						type = 'choice',
						name = "Load spell list",
						desc = "Load a spell list into your character's configuration.\n\nWill overwrite existing spells with the same name, but will not clear other spells.",
						get = function() return "" end,
						set = "LoadSpellList",
						choices = "GetSpellLists",
						disabled = "~HasSpellLists",
						order = 4,
					},
					{
						type = 'choice',
						name = "Delete spell list",
						desc = "Delete a spell list from the database.",
						get = function() return "" end,
						set = "DeleteSpellList",
						choices = function() return TrainingWheels:GetSpellLists(true) end,
						disabled = function() return not TrainingWheels:HasSpellLists(true) end,
						order = 5,
					},
					{
						type = 'choice',
						name = "Load snapshot",
						desc = "Select a snapshot to load it.\n\nSnapshots of your spell list are taken at each major operation, so that you can revert back safely. Snapshots are not persistent and are not available on next login/reload.",
						get = function() return "" end,
						set = "LoadSnapshot",
						choices = "GetSnapshots",
						choiceType = "dict",
						order = 6,
					},
				}
				
				for i,v in pairs(TrainingWheels.db.char.spellList) do
				--	local cur = {
				--		type = 'group',
				--		name = v.name,
				--		desc = "Modify the settings for "..v.name..".",
				--		child_passValue =  i,
				--		args = function() return
				--			{
				--				{
				--					type = "string",
				--					name = "wtf",
				--					desc = "yeah",
				--					get = function(passValue) return passValue end,
				--					set = function(passvalue, value) TrainingWheels:Print(value) end,
				--					usage = "YOYO",
				--				},
				--			}
				--		end,
				--	}
				--	tinsert(output, cur)
					--This sucks (the Dictionary method that is)
					local curSpell = {
						type = 'group',
						name = v.name,
						desc = "Modify the settings for "..v.name..".",
						child_passValue = i,
						order = 200 - v.priority,
						args = function()
							--Screw garbage handling seriously...
							local curSpellOutput = {
								{
									type = "boolean",
									name = "Enabled",
									desc = "Set whether this spell is enabled or not.",
									get = function(i) return self.db.char.spellList[i].enabled == true end,
									set = function(i,v) self.db.char.spellList[i].enabled = v end,
									order = 2,
								},
								{
									type = "execute",
									name = "Delete spell",
									desc = "Delete the spell from the database.",
									func = "DeleteSpell",
									confirmText = "Confirm Delete",
									buttonText = "Delete spell",
									order = 1,
								},
								{
									type = "string",
									desc = "Change the display name of the spell.",
									name = "Name",
									get = function(i) return self.db.char.spellList[i].name end,
									set = function(i,v) self.db.char.spellList[i].name = v end,
									validate = function(passValue, value)
										if (value == "" or value ~= strtrim(value)) then
											return false, "Please type a correct name."
										else 
											for i,v in pairs(self.db.char.spellList) do
												if (v.name == value and i ~= passValue) then
													return false, "Please type a unique name."
												end
											end
											return true
										end
									end,
									usage = "<Spell Name (Modifiers)>",
									disabled = "~IsSpellEnabled",
									order = 3,
								},
								{
									type = "string",
									desc = "Set the spell to cast. Leave blank to create a dummy action. (Useful for Pots and Stuff)",
									name = "Actual spell name",
									get = function(i) return self.db.char.spellList[i].spellName end,
									set = function (i,v) self.db.char.spellList[i].spellName = v end,
									validate = function (passValue, value)
										if (value ~= "" and self.db.profile.validateSpells == true and self.spellInfo[value] == nil) then
											return false, "Please type a correct spell."
										else
											return true
										end
									end,
									usage = "<Spell Name> or Blank",
									disabled = "~IsSpellEnabled",
									order = 4,
								},
								{
									type = "string",
									desc = "Set the texture to use as icon. Enter either a full texture path, item name, item link or a spell name. If blank, will use the current spell name.",
									name = "Icon",
									get = function(i) return self.db.char.spellList[i].texture end,
									set = function (i,v)
										if (v ~= "") then
											local _,link = GetItemInfo(v)
											if (link ~= nil) then
												v = link
											end
										end
										self.db.char.spellList[i].texture = v
									end,
									usage = "<Texture Path> or <Item name/link> or <Spell Name> or Blank",
									disabled = "~IsSpellEnabled",
									order = 4.5,
								},
								{
									type = "number",
									desc = "Set the priority of this spell.",
									name = "Priority",
									get = function(i) return self.db.char.spellList[i].priority end,
									set = function(i,v) self.db.char.spellList[i].priority = v end,
									min = 0,
									max = 100,
									step = 1,
									bigStep = 5,
									stepBasis = 5,
									disabled = "~IsSpellEnabled",
									order = 5,
								},
								{
									type = "boolean",
									name = "Specify cast time",
									desc = "Specify your own cast time for the spell instead of letting the addon decide for you.\n\nUseful for downranked spells with shorter cast times, or other buffs that make your cast time instant or halved.\n\nYou can also make the cast time longer so that you will cast the spell earlier before it wears off (i.e. Improved Scorch).",
									get = function(i) return self.db.char.spellList[i].ownCastTime end,
									set = function(i,v) self.db.char.spellList[i].ownCastTime = v end,
									disabled = "~IsSpellEnabled",
									order = 6,
								},
								{
									type = "number",
									name = "Spell cast time",
									desc = "Specify the cast time for the spell.",
									get = function(i) return self.db.char.spellList[i].castTime end,
									set = function(i,v) self.db.char.spellList[i].castTime = v end,
									min = 0.0,
									max = 15.0,
									step = 0.1,
									bigStep = 0.5,
									stepBasis = 0.5,
									disabled = function(i) return (not self:IsSpellEnabled(i)) or (self.db.char.spellList[i].ownCastTime == false) end,
									order = 7,
								},
								{
									type = 'choice',
									name = "Target type",
									desc = "The type of your target. Will only show spell when you target a unit of that type. Use Disabled to allow the spell to appear all the time.",
									get = function(i) return self.db.char.spellList[i].targetType end,
									set = function(i,v) self.db.char.spellList[i].targetType = v end,
									choices = {"Enemy", "Ally", "Disabled"},
									disabled = "~IsSpellEnabled",
									order = 3,
								},
								{
									type = 'choice',
									name = "Target source",
									desc = "The identifier of your target.",
									get = function(i) return self.db.char.spellList[i].targetSource end,
									set = function(i,v) self.db.char.spellList[i].targetSource = v end,
									choices = {"Target", "Player", "Pet", "Focus", "Mouseover"},
									disabled = function (i) return (not self:IsSpellEnabled(i)) or (self.db.char.spellList[i].targetType == "Disabled") end,
									order = 3.5,
								},
								{
									type = 'choice',
									name = "Target alive",
									desc = "The status of your target. Will only show spell when you target a unit matching the condition. Use disabled to allow the spell to appear regardless of status.",
									get = function(i) return self.db.char.spellList[i].targetAlive end,
									set = function(i,v) self.db.char.spellList[i].targetAlive = v end,
									choices = {"Alive", "Dead", "Disabled"},
									disabled = function (i) return (not self:IsSpellEnabled(i)) or (self.db.char.spellList[i].targetType == "Disabled") end,
									order = 3.75,
								},
								{
									type = 'boolean',
									name = "Ignore cooldown",
									desc = "Ignore the cooldown of the spell when determining if it is ready. This could be useful if you chain a spell that resets the cooldown (i.e. Presence of Mind).",
									get = function(i) return self.db.char.spellList[i].ignoreCooldown end,
									set = function(i,v) self.db.char.spellList[i].ignoreCooldown = v end,
									disabled = "~IsSpellEnabled",
									order = 7.5,
								},
								{
									type = "execute",
									name = "Add aura check",
									desc = "Add an aura check that determines if the spell should be cast or not.",
									func = "AddAuraCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 8,
								},
								{
									type = "execute",
									name = "Add status check",
									desc = "Add a status (HP/Power) check that determines if the spell should be cast or not.",
									func = "AddStatusCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 9,
								},
								--[[
								{
									type = "execute",
									name = "Add target aura check",
									desc = "Add a target aura check that determines if the spell should be cast or not.",
									func = "AddTargetAuraCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 8,
								},
								{
									type = "execute",
									name = "Add target status check",
									desc = "Add a target status (HP/Power) check that determines if the spell should be cast or not.",
									func = "AddTargetStatusCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 9,
								},
								{
									type = "execute",
									name = "Add player aura check",
									desc = "Add a player aura check that determines if the spell should be cast or not.",
									func = "AddPlayerAuraCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 10,
								},
								{
									type = "execute",
									name = "Add player status check",
									desc = "Add a player status (HP/Power) check that determines if the spell should be cast or not.",
									func = "AddPlayerStatusCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 11,
								},
								]]
								{
									type = "execute",
									name = "Add item ready check",
									desc = "Add an item ready check that determines if the spell should be cast or not.",
									func = "AddItemReadyCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 12,
								},
								{
									type = "execute",
									name = "Add equipment ready check",
									desc = "Add an equipent ready check that determines if the spell should be cast or not.\nGood for trinkets.",
									func = "AddEquipmentReadyCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 13,
								},
								{
									type = "execute",
									name = "Add spell ready check",
									desc = "Add a spell ready check that determines if the spell should be cast or not.\n\nDo not add for casted spell!",
									func = "AddSpellReadyCheck",
									buttonText = "Add",
									disabled = "~IsSpellEnabled",
									order = 14,
								},
							}
							
							for pos,check in pairs(v.conditions) do
								--Surely there must be a better way of doing things T_T
								--Check the type
								if check.type == "aura" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Aura Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Aura" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = 'choice',
												name = "Unit source",
												desc = "The identifier of the unit possessing the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].unitType end,
												set = function(i, pos, v) self.db.char.spellList[i].conditions[pos].unitType = v end,
												choices = {"Target", "Player", "Pet", "Focus", "Mouseover"},
												order = 2.5,
											},
											{
												type = "string",
												name = "Aura name",
												desc = "Set the aura name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												usage = "<Aura Name>",
												order = 3,
											},
											{
												type = "number",
												name = "Minimum stack",
												desc = "Minimum stack of the aura.\nUse 0 to cast when the aura does not exist.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].minStack end,
												set = function(i, pos, value)
													self.db.char.spellList[i].conditions[pos].minStack = value
													if (value > self.db.char.spellList[i].conditions[pos].maxStack) then
														self.db.char.spellList[i].conditions[pos].maxStack = value
													end
												end,
												min = 0,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 5,
											},
											{
												type = "number",
												name = "Maximum stack",
												desc = "Maximum stack of the aura.\nUse 0 to cast when the aura does not exist.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].maxStack end,
												set = function(i, pos, value)
													self.db.char.spellList[i].conditions[pos].maxStack = value
													if (value < self.db.char.spellList[i].conditions[pos].minStack) then
														self.db.char.spellList[i].conditions[pos].minStack = value
													end
												end,
												min = 0,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 6,
											},
											{
												type = "boolean",
												name = "Only player casted",
												desc = "Sets if only auras casted by the player are counted.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].playerCastOnly end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].playerCastOnly = value end,
												order = 7,
											},
											{
												type = "choice",
												name = "Spell affects aura",
												desc = "Sets if the casted spell affects the above aura on the target.\n\nAdd means the spell increases the aura stack by one, while Subtract means the spell decreases the aura stack by one. Disabled means the spell does not modify the aura stack on cast.\n\nGood for spells with casted time and 0 cooldown, as it won't suggest you to cast it again while casting the spell.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
												choices = {"Add", "Subtract", "Disabled"},
												order = 8,
											},
											{
												type = "boolean",
												name = "Refresh aura",
												desc = "Refreshes the aura when it is expiring.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].refreshAura end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].refreshAura = value end,
												order = 9,
											},
											{
												type = "number",
												name = "Refresh leeway",
												desc = "Refreshes the aura when it is expiring. Leave 0 to refresh exactly when aura expires.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].refreshDuration end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].refreshDuration = value end,
												min = 0,
												max = 60,
												bigStep = 1,
												step = 0.1,
												stepBasis = 1,
												order = 10,
											},
										}
									})
								--[[
								if check.type == "targetAura" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Target Aura Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Target Aura" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "string",
												name = "Aura name",
												desc = "Set the aura name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												usage = "<Aura Name>",
												order = 3,
											},
											{
												type = "boolean",
												name = "Cast if exists",
												desc = "Casts spell if the aura exists and is not expiring.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].castWhenExists = value end,
												order = 4,
											},
											{
												type = "number",
												name = "Minimum stack",
												desc = "Minimum stack of the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].minStack end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].minStack = value end,
												min = 1,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 5,
											},
											{
												type = "number",
												name = "Maximum stack",
												desc = "Maximum stack of the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].maxStack end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].maxStack = value end,
												min = 1,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 6,
											},
											{
												type = "boolean",
												name = "Only player casted",
												desc = "Sets if only auras casted by the player are counted.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].playerCastOnly end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].playerCastOnly = value end,
												order = 7,
											},
											{
												type = "boolean",
												name = "Spell applies aura",
												desc = "Sets if the casted spell applies the above aura on the target.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
												order = 8,
											}
										}
									})
								elseif check.type == "playerAura" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Player Aura Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Player Aura" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "string",
												name = "Aura name",
												desc = "Set the aura name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												usage = "<Aura Name>",
												order = 3,
											},
											{
												type = "boolean",
												name = "Cast if exists",
												desc = "Casts spell if the aura exists and is not expiring.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].castWhenExists = value end,
												order = 4,
											},
											{
												type = "number",
												name = "Minimum stack",
												desc = "Minimum stack of the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].minStack end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].minStack = value end,
												min = 1,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 5,
											},
											{
												type = "number",
												name = "Maximum stack",
												desc = "Maximum stack of the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].maxStack end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].maxStack = value end,
												min = 1,
												max = 100,
												step = 1,
												disabled = function(i, pos) return self.db.char.spellList[i].conditions[pos].castWhenExists == false end,
												order = 6,
											},
											{
												type = "boolean",
												name = "Only player casted",
												desc = "Sets if only auras casted by the player are counted.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].playerCastOnly end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].playerCastOnly = value end,
												order = 7,
											},
											{
												type = "boolean",
												name = "Spell applies aura",
												desc = "Sets if the casted spell applies the above aura on the player.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
												order = 8,
											}
										}
									})
								]]
								elseif check.type == "status" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Status Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Status" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = 'choice',
												name = "Unit source",
												desc = "The identifier of the unit possessing the aura.",
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].unitType end,
												set = function(i, pos, v)
													self.db.char.spellList[i].conditions[pos].unitType = v
													self:UpdateStatus(i, pos)
												end,
												choices = {"Target", "Player", "Pet", "Focus", "Mouseover"},
												order = 2.5,
											},
											{
												type = "choice",
												name = "Health",
												desc = "Specify the health condition of the target.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].health end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].health = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 3,
											},
											{
												type = "number",
												name = "Health amount",
												desc = "Specify the health amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].healthAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].healthAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].health == "Disabled" end,
												order = 4,
											},
											{
												type = "choice",
												name = "Power",
												desc = "Specify the power condition of the target.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].power end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].power = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 5,
											},
											{
												type = "number",
												name = "Power amount",
												desc = "Specify the power amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].powerAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].powerAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].power == "Disabled" end,
												order = 6,
											}
										}
									})
								--[[
								elseif check.type == "targetStatus" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Target Status Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Target Status" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "choice",
												name = "Health",
												desc = "Specify the health condition of the target.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].health end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].health = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 3,
											},
											{
												type = "number",
												name = "Health amount",
												desc = "Specify the health amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].healthAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].healthAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].health == "Disabled" end,
												order = 4,
											},
											{
												type = "choice",
												name = "Power",
												desc = "Specify the power condition of the target.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].power end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].power = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 5,
											},
											{
												type = "number",
												name = "Power amount",
												desc = "Specify the power amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].powerAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].powerAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].power == "Disabled" end,
												order = 6,
											}
										}
									})
								elseif check.type == "playerStatus" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Player Status Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Player Status" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "choice",
												name = "Health",
												desc = "Specify the health condition of the player.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].health end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].health = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 3,
											},
											{
												type = "number",
												name = "Health amount",
												desc = "Specify the health amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].healthAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].healthAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].health == "Disabled" end,
												order = 4,
											},
											{
												type = "choice",
												name = "Power",
												desc = "Specify the power condition of the player.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].power end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].power = value
													self:UpdateStatus(i, pos)
												end,
												choices = {"Disabled", "More than", "Less than"},
												order = 5,
											},
											{
												type = "number",
												name = "Power amount",
												desc = "Specify the power amount for the condition.",
												get = function (i, pos) return self.db.char.spellList[i].conditions[pos].powerAmount end,
												set = function (i, pos, value)
													self.db.char.spellList[i].conditions[pos].powerAmount = value
													self:UpdateStatus(i, pos)
												end,
												step = 0.01,
												bigStep = 0.05,
												stepBasis = 0.05,
												isPercent = true,
												disabled = function() return self.db.char.spellList[i].conditions[pos].power == "Disabled" end,
												order = 6,
											}
										}
									})
								]]
								elseif check.type == "itemReady" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Item Ready Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Item Ready" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "string",
												name = "Item name",
												desc = "Set the item name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												usage = "<Item Name>",
												order = 3,
											},
											{
												type = "boolean",
												name = "Cast if ready",
												desc = "Casts spell if the item is ready.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].ready end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].ready = value end,
												order = 4,
											},
											--{
											--	type = "boolean",
											--	name = "Spell uses item",
											--	desc = "Sets if the casted spell uses the above item.",
											--	get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
											--	set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
											--	order = 5,
											--}
										}
									})
								elseif check.type == "equipmentReady" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Equipment Ready Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Equipment Ready" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "string",
												name = "Equipment name",
												desc = "Set the equipment name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												usage = "<Equipment Name> or <Slot1-19> or <TopTrinket> or <BottomTrinket> or <OneTrinket> or <BothTrinkets>",
												order = 3,
											},
											{
												type = "boolean",
												name = "Cast if ready",
												desc = "Casts spell if the item is equipped and ready.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].ready end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].ready = value end,
												order = 4,
											},
											--{
											--	type = "boolean",
											--	name = "Spell uses equipment",
											--	desc = "Sets if the casted spell uses the above equipment.",
											--	get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
											--	set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
											--	order = 5,
											--},
											{
												type = "execute",
												name = "List equipment",
												desc = "List all equipped items and their slots",
												func = "ListEquipmentSlots",
												buttonText = "List",
												order = 6,
											}
										}
									})
								elseif check.type == "spellReady" then
									tinsert(curSpellOutput, {
										type = "group",
										name = check.name,
										desc = "Configure the Spell Ready Check.",
										child_passValue = i,
										child_passValue2 = pos,
										disabled = "~IsSpellEnabled",
										args = {
											{
												--A bit of a hack but what the heck...
												type = "string",
												name = "Check type",
												desc = "The type of condition that is being configured.",
												get = function () return "Spell Ready" end,
												set = function() end,
												usage = "<Check Type>",
												order = 1,
											},
											{
												type = "execute",
												name = "Delete check",
												desc = "Delete the check from the spell.",
												func = "DeleteCheck",
												confirmText = "Confirm Delete",
												buttonText = "Delete Check",
												order = 2,
											},
											{
												type = "string",
												name = "Spell name",
												desc = "Set the spell name.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].name end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].name = value end,
												validate = function (passValue, value)
													if (value ~= "" and self.db.profile.validateSpells == true and self.spellInfo[value] == nil) then
														return false, "Please type a correct spell."
													else
														return true
													end
												end,
												usage = "<Spell Name>",
												order = 3,
											},
											{
												type = "boolean",
												name = "Cast if ready",
												desc = "Casts spell if the above spell is ready.",
												--WTF IS THIS?
												get = function(i, pos) return self.db.char.spellList[i].conditions[pos].ready end,
												set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].ready = value end,
												order = 4,
											},
											--{
											--	type = "boolean",
											--	name = "Spell uses spell",
											--	desc = "Sets if the casted spell uses the above spell.",
											--	get = function(i, pos) return self.db.char.spellList[i].conditions[pos].spellTriggers end,
											--	set = function(i, pos, value) self.db.char.spellList[i].conditions[pos].spellTriggers = value end,
											--	order = 5,
											--}
										}
									})
								end
							end
							
							return curSpellOutput
							
						end,
					}
					tinsert(output, curSpell)
				end
				
				return output
				
			end,
		},
	},
}

self.spellInfo = {}

self.Tooltip = nil

self:SetDatabase("TrainingWheelsDB")
self:SetDefaultProfile("Default")
self:SetDatabaseDefaults("profile", {
	spellFrameX = GetScreenWidth() / 2,
	spellFrameY = GetScreenHeight() / 2,
	leeway = 0.1,
	spellLists = {},
	validateSpells = true,
	showLabels = true,
	maxSpells = 5,
	latency = 0.1,
})
self:SetDatabaseDefaults("char", {
	spellList = {},
})

function self:OnInitialize()
	self:InitSpellFrame()
	self.Tooltip = CreateFrame("GameTooltip", "TrainingWheels_GameTooltip", nil, "GameTooltipTemplate")
	self:SetConfigTable(self.options)
	self:SetConfigSlashCommand("/TrainingWheels", "/TW")
	local migrateResults, migrateMsg = self:MigrateSpellList(self.db.char.spellList)
	if (not migrateResults) then
		message(migrateMsg)
		self.db.char.spellList = {}
	end
	self:SaveSnapshot("Login")
	self:FetchSpellInfo()
	self:FetchEquipmentList()
end

function self:OnEnable()
	self:Monitor()
	self.SpellFrame:Show()
end

function self:OnDisable()
	self.SpellFrame:Hide()
end

function self:Default(tableName, key, defaultValue)
	if (tableName[key] == nil) then
		tableName[key] = defaultValue
	end
	return tableName[key]
end

function self:Monitor()
	self:AddRepeatingTimer(0, "CheckRefresh")
	--self:AddEventListener("UNIT_SPELLCAST_STOP", "ProcessCast")
	self:AddEventListener("UNIT_SPELLCAST_SUCCEEDED", "ProcessCast")
	self:AddEventListener("SPELLS_CHANGED", "FetchSpellInfo")
	self:AddEventListener("TIME_PLAYED_MSG", "FetchSpellInfo")
	--self:AddEventListener("UNIT_SPELLCAST_CHANNEL_STOP", "ProcessCast")
	self:AddEventListener("UNIT_AURA", "ProcessAura")
	self:AddEventListener("PLAYER_TARGET_CHANGED", "ScheduleRefreshSpellFrame")
	self:AddEventListener("UNIT_INVENTORY_CHANGED", "PreFetchEquipmentList")
	self:AddSecureHook("CastSpellByName", "ScheduleRefreshSpellFrame")
	self:AddSecureHook("CastSpell", "ScheduleRefreshSpellFrame")
	self:AddSecureHook("CastShapeshiftForm", "ScheduleRefreshSpellFrame")
	self:AddSecureHook("SpellStopCasting", "ScheduleRefreshSpellFrame")
end

function self:CheckRefresh()
	self.thisFrameRefreshed = false
	self.time = GetTime()
	if (self.nextFrameRefresh == true) then
		self.nextFrameRefresh = false
		self:RefreshSpellFrame()
	elseif (self.time - self.lastRefresh >= 0.1) then
		self:RefreshSpellFrame()
	end
	
end

function self:PreFetchEquipmentList(arg1)
	if (arg1 == "player") then
		self:FetchEquipmentList()
	end
end

function self:FetchEquipmentList()
	for i=0,19 do
		local result = GetInventoryItemLink("player", i)
		if (result ~= nil) then
			self.playerEquipment[i] = GetItemInfo(result)
		else
			self.playerEquipment[i] = nil
		end
	end
end

function self:ProcessCast(arg1)
	if (arg1 == "player" or arg1 == "pet") then
		self:ScheduleRefreshSpellFrame()
	end
end
function self:ProcessAura(arg1)
	if (arg1 == "target" or arg1 == "player" or arg1 == "pet" or arg1 == "mouseover" or arg1 == "focus") then
		self:ScheduleRefreshSpellFrame()
	end
end

function self:FetchSpellInfo()
	local i = 1
	local book = "spell"
	while true do
		local spellName, spellRank = GetSpellName(i, book)
		if not spellName then
			if (book == "spell") then
				i = 1
				book = "pet"
			else
				break
			end
		else
			
			local texture = GetSpellTexture(i, book)
		   
			--Does it already exist?
			local skip = false
			if self.spellInfo[spellName] ~= nil then
				if strlen(self.spellInfo[spellName].rank) >= strlen(spellRank) then
					skip = true
				elseif (strlen(self.spellInfo[spellName].rank) == strlen(spellRank) and self.spellInfo[spellName].rank > spellRank) then
					skip = true
				end
			end
			if not skip then
				--Get the info from tooltip
				--self.Tooltip:ClearLines()
				--self.Tooltip:SetSpell(i, "spell")
				self.Tooltip:SetOwner(UIParent, "ANCHOR_NONE")
				self.Tooltip:SetSpell(i, "spell")
				local castTime = nil
				local cooldown = 0
				for i=1,self.Tooltip:NumLines() do
					--local mytext = getglobal("TrainingWheels_GameTooltipTextLeft"..i)
					local mytext = getglobal("TrainingWheels_GameTooltipTextLeft"..i)
					if mytext ~= nil then
						local text = mytext:GetText()
						if (text ~= nil) then
							local _,_,ct,_ = strfind(text, "^"..self.globalStrings["SPELL_CAST_TIME_SEC"])
							if (ct ~= nil) then
								castTime = tonumber(ct)
								if (castTime ~= nil) then break end
							else
								_,_,ct,_ = strfind(text, "^"..self.globalStrings["SPELL_CAST_TIME_MIN"])
								if (ct ~= nil) then
									castTime = tonumber(ct) * 60
									if (castTime ~= nil) then break end
								end
							end
						end
					else
						break
					end
				end
				local righttext= getglobal("TrainingWheels_GameTooltipTextRight3")
				if righttext ~= nil then
					local text = righttext:GetText()
					if (text ~= nil) then
						local _,_,cd,_ = strfind(text, "^"..self.globalStrings["SPELL_RECAST_TIME_SEC"])
						if (cd ~= nil) then
							cooldown = tonumber(cd)
						else
							_,_,cd,_ = strfind(text, "^"..self.globalStrings["SPELL_RECAST_TIME_MIN"])
							if (cd ~= nil) then
								cooldown = tonumber(cd) * 60
							end
						end
					end
				end
				self.Tooltip:Hide()
				
				local isPetSpell = nil
				if (book == "spell") then
					isPetSpell = false
				else
					isPetSpell = true
				end
				if (castTime == nil) then castTime = 0.0 end
				self.spellInfo[spellName] = {id=i, spellName=spellname, cooldown=cooldown, rank=spellRank, texture=texture, castTime=castTime, isPetSpell = isPetSpell}
			end
			i = i + 1
		end
	end
end

function self:HasSpellLists(noincluded)
	if (#self.db.profile.spellLists > 0) then
		return true
	elseif (noincluded ~= true and #self.includedLists[self.className] > 0) then
		return true
	end
	return false
end

function self:GetSpellLists(noincluded)
	local output = newList("")
	for i,v in pairs(self.db.profile.spellLists) do
		tinsert(output, v.name)
	end
	if (noincluded ~= true and self.includedLists[self.className] ~= nil) then
		for i,v in pairs(self.includedLists[self.className]) do
			--Check if exists in Output already
			local found = false
			for j,v2 in pairs(output) do
				if (v2 == v.name) then
					found = true
					break
				end
			end
			if not found then
				tinsert(output, v.name)
			end
		end
	end
	return "@list", unpackListAndDel(output)
end

function self:SaveSpellList(name)
	local spellList = {
		name= name,
		list= self:CloneTable(self.db.char.spellList),
	}
	tinsert(self.db.profile.spellLists, spellList)

	if (self.includedLists[self.className] ~= nil) then
		for i,v in pairs(self.includedLists[self.className]) do
			if v.name == name then
				self:Print("Overridden included spell list \"".. name.."\". It is now inaccessible until you delete your saved spell list with the same name.")
			end
		end
	end
	
	self:SaveSnapshot("Saved as "..name)
	
	Rock("LibRockConfig-1.0"):RefreshConfigMenu(TrainingWheels)
end

function self:SaveSnapshot(name)
	tinsert(self.snapshots, {name=name, list=self:CloneTable(self.db.char.spellList)})
end

function self:LoadSnapshot(index, confirm)
	if (confirm == nil) then
		local dialog = StaticPopup_Show("TrainingWheels_ConfirmLoadSnapshot")
		if (dialog) then
			dialog.data = index
		end
	else
		if (tonumber(index) <= #self.snapshots) then
			self.db.char.spellList = self:CloneTable(self.snapshots[tonumber(index)].list)
			self:RefreshSpellList()
		end
	end
end

function self:GetSnapshots()
	local output = {}
	local digits = strlen(tostring(#self.snapshots))
	for i,v in pairs (self.snapshots) do
		output[i] = strrep("0", digits - strlen(tostring(i)))..i .. " - "..v.name
	end
	return output
end

function self:LoadSpellList(name, nosave)
	local spellList = nil
	for i,v in pairs(self.db.profile.spellLists) do
		if (v.name == name) then
			spellList = v
			break
		end
	end
	if (spellList == nil and self.includedLists[self.className] ~= nil) then
		for i,v in pairs(self.includedLists[self.className]) do
			if (v.name == name) then
				spellList = v
				break
			end
		end
	end
	if (nosave ~= true) then
		self:SaveSnapshot("Before loading ".. name)
	end
	if (spellList ~= nil) then
		local migrateResults, migrateMsg = self:MigrateSpellList(spellList.list)
		if not migrateResults then
			message(migrateMsg)
			self:LoadSnapshot(#self.snapshots, true)
			return false
		else
			for j,spell in pairs(spellList.list) do
				for k, curSpell in pairs(self.db.char.spellList) do
					if (spell.name == curSpell.name) then
						tremove(self.db.char.spellList, k)
						break
					end
				end
				local result, msg = self:CloneTable(spell)
				if (result == false) then
					--Load back the last spell list if error
					--We don't want our users to end up with corrupted data no matter what
					self:LoadSnapshot(#self.snapshots, true)
					self:Print("Error loading Spell List: "..msg)
					return false, "Error loading Spell List: "..msg
				end
				tinsert(self.db.char.spellList, result)
			end
			self:RefreshSpellFrame()
			Rock("LibRockConfig-1.0"):RefreshConfigMenu(TrainingWheels)
			--No errors, save another snapshot
			if (nosave ~= true) then
				self:SaveSnapshot("After loading ".. name)
			end
			return true
		end
	end
	return false, "Unable to find Spell List ".. name
end

function self:ClearSpellList()
	self:SaveSnapshot("Before clear")
	self.db.char.spellList = {}
	self:SaveSnapshot("After clear")
	self:RefreshSpellFrame()
	Rock("LibRockConfig-1.0"):RefreshConfigMenu(TrainingWheels)
end

function self:DeleteSpellList(name, confirm)
	if (confirm == nil) then
		local dialog = StaticPopup_Show("TrainingWheels_ConfirmDeleteSpellList")
		if (dialog) then
			dialog.data = name
		end
	else
		for i,v in pairs(self.db.profile.spellLists) do
			if (v.name == name) then
				tremove(self.db.profile.spellLists, tonumber(name))
				Rock("LibRockConfig-1.0"):RefreshConfigMenu(TrainingWheels)
				break
			end
		end
	end
end

function self:RefreshSpellList()
	sort(self.db.char.spellList, function (a,b)
		return (a.priority<b.priority or (a.priority == b.priority and a.name < b.name))
	end)
	Rock("LibRockConfig-1.0"):RefreshConfigMenu(TrainingWheels)
	
	self:RefreshSpellFrame()
end

function self:AddSpell(name)
	local spell = {
		version = self.spellVersion,
		name = name,
		spellName = name,
		iconPath = "",
		priority = 50,
		enabled = true,
		ownCastTime = false,
		targetType = "Enemy",
		targetSource = "Target",
		targetAlive = "Alive",
		ignoreCooldown = false,
		castTime = 0.0,
		conditions = {}
	}
	tinsert(self.db.char.spellList, spell)
	self:RefreshSpellList()
end

function self:DeleteSpell(i, confirm)
	tremove(self.db.char.spellList, i)
	self:RefreshSpellList()
end

function self:IsSpellEnabled(i)
	return (self.db.char.spellList[i].enabled == true)
end

function self:AddAuraCheck(i)
	local aura = {
		type = "aura",
		name = "New Aura",
		unitType = "Target",
		minStack = 0,
		maxStack = 0,
		refreshAura = true,
		refreshDuration = 0,
		playerCastOnly = true,
		spellTriggers = "Add",
	}
	tinsert(self.db.char.spellList[i].conditions, aura)
	self:RefreshSpellList()
end

--[[
function self:AddTargetAuraCheck(i)
	local targetAura = {
		type = "targetAura",
		name = "New Target Aura",
		castWhenExists = false,
		playerCastOnly = false,
		minStack = 1,
		maxStack = 100,
		spellTriggers = true,
	}
	tinsert(self.db.char.spellList[i].conditions, targetAura)
	self:RefreshSpellList()
end

function self:AddPlayerAuraCheck(i)
	local playerAura = {
		type = "playerAura",
		name = "New Player Aura",
		castWhenExists = false,
		playerCastOnly = false,
		minStack = 1,
		maxStack = 100,
		spellTriggers = true,
	}
	tinsert(self.db.char.spellList[i].conditions, playerAura)
	self:RefreshSpellList()
end
]]

function self:AddStatusCheck(i)
	local status = {
		type = "status",
		name = "New Status",
		unitType = "Player",
		health = "Disabled",
		healthAmount = 0.75,
		power = "Disabled",
		powerAmount = 0.75,
	}
	tinsert(self.db.char.spellList[i].conditions, status)
	self:RefreshSpellList()
end

--[[
function self:AddPlayerStatusCheck(i)
	local playerStatus = {
		type = "playerStatus",
		name = "New Player Status",
		health = "Disabled",
		healthAmount = 0.75,
		power = "Disabled",
		powerAmount = 0.75,
	}
	tinsert(self.db.char.spellList[i].conditions, playerStatus)
	self:RefreshSpellList()
end

function self:AddTargetStatusCheck(i)
	local targetStatus = {
		type = "targetStatus",
		name = "New Target Status",
		health = "Disabled",
		healthAmount = 0.75,
		power = "Disabled",
		powerAmount = 0.75,
	}
	tinsert(self.db.char.spellList[i].conditions, targetStatus)
	self:RefreshSpellList()
end
]]

function self:AddItemReadyCheck(i)
	local itemReady = {
		type = "itemReady",
		name = "New Item Ready",
		ready = true,
		spellTriggers = true,
	}
	tinsert(self.db.char.spellList[i].conditions, itemReady)
end

function self:AddEquipmentReadyCheck(i)
	local equipmentReady = {
		type = "equipmentReady",
		name = "New Equipment Ready",
		ready = true,
		spellTriggers = true,
	}
	tinsert(self.db.char.spellList[i].conditions, equipmentReady)
end

function self:AddSpellReadyCheck(i)
	local spellReady = {
		type = "spellReady",
		name = "New Spell Ready",
		ready = true,
		spellTriggers = true,
	}
	tinsert(self.db.char.spellList[i].conditions, spellReady)
end

function self:DeleteCheck(i, j)
	tremove(self.db.char.spellList[i].conditions, j)
	self:RefreshSpellList()
end

function self:UpdateStatus(i, pos)
	local healthStr = ""
	local value = self.db.char.spellList[i].conditions[pos].health
	local amount = self.db.char.spellList[i].conditions[pos].healthAmount
	if (value == "More than") then
		healthStr = "H > "..(amount * 100).."%"
	elseif (value == "Less than") then
		healthStr = "H < "..(amount * 100).."%"
	end
	local powerStr = ""
	amount = self.db.char.spellList[i].conditions[pos].powerAmount
	value = self.db.char.spellList[i].conditions[pos].power
	if (value == "More than") then
		powerStr = "P > "..(amount * 100).."%"
	elseif (value == "Less than") then
		powerStr = "P < "..(amount * 100).."%"
	end
	local name = strtrim(healthStr.." "..powerStr)
	if (name ~= "") then
		self.db.char.spellList[i].conditions[pos].name = self.db.char.spellList[i].conditions[pos].unitType.." ("..name..")"
	else
		self.db.char.spellList[i].conditions[pos].name = "Unspecified "..self.db.char.spellList[i].conditions[pos].unitType.." Status"
	end
	self:RefreshSpellList()
end

function self:RefreshSpellFrame()
	if (self.thisFrameRefreshed) then
		return
	end
	self.thisFrameRefreshed = true
	
	self.lastRefresh = self.time
	
	self.SpellFrame:Clear()
	
	--Only if player in combat!
	--if (UnitAffectingCombat("player")) then
	if (true) then
		local playerLeeway, petLeeway = self.db.profile.leeway;
		local currentlyCastingPlayerSpell, _, startTime, endTime = nil
		currentlyCastingPlayerSpell, _, _, icon, startTime, endTime = UnitCastingInfo("player")
		if (currentlyCastingPlayerSpell == nil) then
			currentlyCastingPlayerSpell, _, _, icon, startTime, endTime = UnitChannelInfo("player")
		end
		--OOH we are casting a spell
		if (currentlyCastingPlayerSpell ~= nil) then
			playerLeeway = playerLeeway + (endTime - startTime) / 1000 - self.db.profile.latency
			if (self.spellInfo[currentlyCastingPlayerSpell] ~= nil) then
				self.spellInfo[currentlyCastingPlayerSpell].endCast = endTime / 1000 + self.db.profile.latency
			end
			if (playerLeeway < 0) then playerLeeway = 0 end
		end
		
		local currentlyCastingPetSpell, _, startTime, endTime = nil
		currentlyCastingPetSpell, _, _, icon, startTime, endTime = UnitCastingInfo("pet")
		if (currentlyCastingPetSpell == nil) then
			currentlyCastingPetSpell, _, _, icon, startTime, endTime = UnitChannelInfo("pet")
		end
		--OOH pet is casting a spell
		if (currentlyCastingPetSpell ~= nil) then
			petLeeway = petLeeway + (endTime - startTime) / 1000 - self.db.profile.latency
			if (self.spellInfo[currentlyCastingPetSpell] ~= nil) then
				self.spellInfo[currentlyCastingPetSpell].endCast = endTime / 1000 + self.db.profile.latency
			end
			if (petLeeway < 0) then petLeeway = 0 end
		end		
		
		local auraList = newDict()
		auraList["Player"] = {self:GetAuras("Player")}
		auraList["Target"] = {self:GetAuras("Target")}
		auraList["Focus"] = {self:GetAuras("Focus")}
		auraList["Mouseover"] = {self:GetAuras("Mouseover")}
		auraList["Pet"] = {self:GetAuras("Pet")}
		
		
		--Shit job begins NOW:
		--Obtain the list of shit
		
		
		local count = 0
		for i,v in pairs(self.db.char.spellList) do
			--Check that the spell exists in our db first,
			--and that it is a spell that can be cast on our target

			--Make sure defaults are set properly...
			self:Default(v, "targetSource", "Target")
			self:Default(v, "targetAlive", "Alive")
			self:Default(v, "ignoreCooldown", false)
			if (v.enabled == true and 
				(v.spellName == "" or self.spellInfo[v.spellName] ~= nil) and
					(v.targetType == "Disabled"
					or (UnitExists(v.targetSource) == 1 and 
						(((v.targetType == "Enemy" and UnitIsFriend(v.targetSource, "player") ~= 1)
						or (v.targetType == "Ally" and UnitIsFriend(v.targetSource, "player") == 1))
						) and
							((v.targetAlive == "Disabled") or
							(v.targetAlive == "Alive" and UnitIsDead(v.targetSource) ~= 1) or
							(v.targetAlive == "Dead" and UnitIsDead(v.targetSource) == 1)))))
			then
				count = count + 1
				if (self.refreshList[count] == nil) then
					self.refreshList[count] = {}
				end
		
				--It's clear.. let's get the cast time
				local castTime = v.castTime
				if (v.ownCastTime == false and v.spellName ~= "" and self.spellInfo[v.spellname] ~= nil) then
					castTime = self.spellInfo[v.spellName].castTime
				end
				
				--Let's get if the spell is a pet spell or not (GEEZ)
				local isPetSpell = false
				if (v.spellName ~= "" and self.spellInfo[v.spellname] ~= nil) then
					isPetSpell = self.spellInfo[v.spellName].isPetSpell
				end
				
				local leeway = 0
				
				if (isPetSpell) then
					currentlyCastingSpell = currentlyCastingPetSpell
					leeway = petLeeway
				else
					currentlyCastingSpell = currentlyCastingPlayerSpell
					leeway = playerLeeway
				end
				
				local nextCast = 9999
				local earlyCast = false
				--Cast time complete
				
				--Lets move on to the conditions and see if they are true
				local pass = true;
				for j,check in pairs(v.conditions) do
					if (check.type == "aura") then
						--It is inevitable
						local aura = nil
						if (check.playerCastOnly) then
							aura = auraList[check.unitType][2]
						else
							aura = auraList[check.unitType][1]
						end
						
						--Let's see if we have to refresh it or not
						local refresh = false
						if (check.refreshAura) then
							if (aura[check.name] ~= nil) then
								if (aura[check.name].timeLeft ~= 0 and aura[check.name].timeLeft <= castTime + check.refreshDuration + leeway) then
									refresh = true
								elseif (aura[check.name].timeLeft ~= 0 and aura[check.name].timeLeft < castTime + check.refreshDuration) then
									refresh = true
									earlyCast = true
								end
							end
						end
						
						--If it shouldn't be refreshed, check if it does not fall between the aura stack reqs..
						if (not refresh) then
							local stack = 0
							if (aura[check.name] ~= nil) then
								stack = aura[check.name].count
							end
							
							--See if we are casting the spell, and see if it applies the stack...
							if (check.spellTriggers ~= "Disabled") then
								if (self.spellInfo[v.spellName] ~= nil and self.spellInfo[v.spellName].endCast ~= nil and self.spellInfo[v.spellName].endCast > self.time) then
									if (check.spellTriggers == "Add") then
										stack = stack + 1
									else
										stack = stack - 1
									end
								elseif (currentlyCastingSpell == v.spellName or currentlyCastingPetSpell == v.spellName) then
									if (check.spellTriggers == "Add") then
										stack = stack + 1
									else
										stack = stack - 1
									end
								end
							end
							
							--Lastly see if the spell matches the aura stack reqs
							if (stack < check.minStack or stack > check.maxStack) then
								pass = false
							end
						end
						
					--[[
					if (check.type == "targetAura") then
						local exists = false
						local auraList = nil
						if (check.playerCastOnly) then
							auraList = selfTargetAuras
						else
							auraList = targetAuras
						end
						if (auraList[check.name] ~= nil) then
							if (auraList[check.name].timeLeft ~= 0 and auraList[check.name].timeLeft <= castTime + leeway) then
								exists = false
							else
								exists = true
								if (check.castWhenExists and auraList[check.name].timeLeft > castTime) then
									earlyCast = true
								end
							end
						end
						if (check.castWhenExists ~= exists) then
							pass = false
						elseif (check.castWhenExists == true) then
							local count = auraList[check.name].count
							if (check.spellTriggers and spell == check.name) then
								count = count + 1
							end
							if (check.minStack > count or check.maxStack < count) then
								pass = false
							end
						elseif (pass) then
							if (auraList[check.name] ~= nil and auraList[check.name].timeLeft ~= 0) then
								nextCast = min(nextCast, max(0, auraList[check.name].timeLeft - castTime))
							end
						end
					elseif (check.type == "playerAura") then
						local exists = false
						local auraList = nil
						if (check.playerCastOnly) then
							auraList = selfPlayerAuras
						else
							auraList = playerAuras
						end
						if (auraList[check.name] ~= nil) then
							if (auraList[check.name].timeLeft ~= 0 and auraList[check.name].timeLeft <= castTime + leeway) then
								exists = false
							else
								exists = true
								if (check.castWhenExists and auraList[check.name].timeLeft > castTime) then
									earlyCast = true
								end
							end
						elseif (pass) then
							if (auraList[check.name] ~= nil and auraList[check.name].timeLeft ~= 0) then
								nextCast = min(nextCast, max(0, auraList[check.name].timeLeft - castTime))
							end
						end
						if (check.castWhenExists ~= exists) then
							pass = false
						elseif (check.castWhenExists == true) then
							local count = auraList[check.name].count
							if (check.spellTriggers and spell == check.name) then
								count = count + 1
							end
							if (check.minStack > count or check.maxStack < count) then
								pass = false
							end
						end
					]]
					
					elseif (check.type == "status") then
						if (check.health ~= "Disabled") then
							local percent = UnitHealth(check.unitType) / UnitHealthMax(check.unitType)
							if ((percent < check.healthAmount) ~= (check.health == "Less than")) then
								pass = false
							end
						end
						if (check.power ~= "Disabled") then
							local percent = UnitMana(check.unitType) / UnitManaMax(check.unitType)
							if ((percent < check.powerAmount) ~= (check.power == "Less than")) then
								pass = false
							end
						end
					--[[
					elseif (check.type == "playerStatus") then
						if (check.health ~= "Disabled") then
							local percent = UnitHealth("player") / UnitHealthMax("player")
							if ((percent < check.healthAmount) ~= (check.health == "Less than")) then
								pass = false
							end
						end
						if (check.power ~= "Disabled") then
							local percent = UnitMana("player") / UnitManaMax("player")
							if ((percent < check.powerAmount) ~= (check.power == "Less than")) then
								pass = false
							end
						end
					elseif (check.type == "targetStatus") then
						if (check.health ~= "Disabled") then
							local percent = UnitHealth(v.targetSource) / UnitHealthMax(v.targetSource)
							if ((percent < check.healthAmount) ~= (check.health == "Less than")) then
								pass = false
							end
						end
						if (check.power ~= "Disabled") then
							local percent = UnitMana(v.targetSource) / UnitManaMax(v.targetSource)
							if ((percent < check.powerAmount) ~= (check.power == "Less than")) then
								pass = false
							end
						end
					--]]
					
					elseif (check.type == "itemReady") then
						local start, duration = GetItemCooldown(check.name)
						local localPass = true
						if (start == nil) then
							localPass = false
						elseif (start ~= 0) then 
							local left = start + duration - GetTime()
							if (left > leeway) then
								localPass = false
							elseif (left > 0) then
								earlyCast = true
							end
						end
						if (localPass ~= check.ready) then
							pass = false
						end
					elseif (check.type == "equipmentReady") then
						local itemName = check.name
						local _,_,found = strfind(check.name, "^Slot(%d)+")
						local localPass = true
						if (found ~= nil) then
							itemName = self.playerEquipment[found]
						end
						if (check.name ~= "TopTrinket" and check.name ~= "BottomTrinket" and check.name ~= "OneTrinket" and check.name ~= "BothTrinkets") then
							
							--Check if equipped first
							if (IsEquippedItem(itemName) ~= 1) then
								localPass = false
							else
								local start, duration = GetItemCooldown(itemName)
								if (start == nil) then
									localPass = false
								elseif (start ~= 0) then 
									local left = start + duration - GetTime()
									if (left > leeway) then
										localPass = false
									elseif (left > 0) then
										earlyCast = true
									end
								end
							end
						else
						
							local topTrinket, bottomTrinket = true, true
							local topEarlyCast, bottomEarlyCast = false, false
							if (self.playerEquipment[13] == nil) then
								topTrinket = false;
							else
								local start, duration = GetItemCooldown(self.playerEquipment[13])
								if (start == nil) then
									topTrinket = false;
								elseif (start ~= 0) then
									local left = start + duration - GetTime()
									if (left > leeway) then
										topTrinket = false
									elseif (left > 0) then
										topEarlyCast = true
									end
								end
							end
							if (self.playerEquipment[14] == nil) then
								bottomTrinket = false;
							else
								local start, duration = GetItemCooldown(self.playerEquipment[14])
								if (start == nil) then
									bottomTrinket = false;
								elseif (start ~= 0) then
									local left = start + duration - GetTime()
									if (left > leeway) then
										bottomTrinket = false
									elseif (left > 0) then
										bottomEarlyCast = true
									end
								end
							end
							
							if (check.name == "TopTrinket") then
								localPass = topTrinket
								if (topEarlyCast) then earlyCast = true end
							elseif (check.name == "BottomTrinket") then
								localPass = bottomTrinket
								if (bottomEarlyCast) then earlyCast = true end
							elseif (check.name == "OneTrinket") then
								localPass = topTrinket or bottomTrinket
								if (topEarlyCast and bottomEarlyCast) then earlyCast = true end
							else
								localPass = topTrinket and bottomTrinket
								if (topEarlyCast or bottomEarlyCast) then earlyCast = true end
							end
						end
						if (localPass ~= check.ready) then
							pass = false
						end
					elseif (check.type == "spellReady") then
						if (spell ~= nil and (check.name == currentlyCastingPlayerSpell or check.name == currentlyCastingPetSpell) and self.spellInfo[check.name] ~= nil and self.spellInfo[check.name].cooldown > 0) then
							local localPass = true
							if (localPass ~= check.ready) then
								pass = false
							end
						else
							local start, duration = GetSpellCooldown(check.name, "spell")
							if (start == nil) then
								start, duration = GetSpellCooldown(check.name, "pet")
							end
							local localPass = true
							if (start == nil) then
								localPass = false
							elseif (start ~= 0) then
								local left = start + duration - GetTime()
								if (left > leeway + 1.5) then
									localPass = false
								end
								if (left > 0) then
									earlyCast = true
								end
							end
							if (localPass ~= check.ready) then
								pass = false
							end
						end
					end
					
					if (pass == false) then
						break
					end
				end
				
			
				if (pass and v.spellName ~= "" and self.spellInfo[v.spellName] ~= nil) then
					if ((v.spellName == currentlyCastingPlayerSpell or v.spellName == currentlyCastingPetSpell) and v.ignoreCooldown == false and self.spellInfo[v.spellName].cooldown > 0) then
						pass = false
					else
						--Sorry rogues and catform druids.. GCD is 1.5s bitch
						--TODO Optimisation: CD check first, then condition check DUH
						local start, duration = GetSpellCooldown(v.spellName, "spell")
						if (start == nil) then
							start,duration = GetSpellCooldown(v.spellName, "pet")
						end
						if (start ~= 0) then 
							local left = start + duration - GetTime()
							if (v.ignoreCooldown == false and left > leeway + 1.5) then
								pass = false
							end
							if (v.ignoreCooldown == false and left > 0) then
								--Who the fuck cares
								earlyCast = true
							end
						end
					end
				end

				if (pass) then
					self.refreshList[count].name = v.name
					self.refreshList[count].spellName = v.spellName
					self.refreshList[count].castTime = castTime
					self.refreshList[count].earlyCast = earlyCast
					self.refreshList[count].nextCast = nextCast
					self.refreshList[count].priority = v.priority
					if (v.texture ~= "" and v.texture ~= nil) then
						--An item was suggested? Or maybe a texture path. Let's just test the item texture...
						local _,_,_,_,_,_,_,_,_,texture = GetItemInfo(v.texture)
						if (texture ~= nil) then
							self.refreshList[count].texture = texture
						elseif (self.spellInfo[v.texture] ~= nil) then
							self.refreshList[count].texture = self.spellInfo[v.texture].texture
						else
							self.refreshList[count].texture = v.texture
						end
					else
						if (self.spellInfo[v.spellName] ~= nil) then
							self.refreshList[count].texture = self.spellInfo[v.spellName].texture
						else
							self.refreshList[count].texture = nil
						end
					end
					

					--[[
					if (v.spellName ~= "") then
						if (earlyCast) then
							--Eh it's buggy.. maybe some other time..
							self.SpellFrame:Add(v.name, self.SpellInfo[v.spellName].texture)
						else
							self.SpellFrame:Add(v.name, self.SpellInfo[v.spellName].texture)
						end
					else
						self.SpellFrame:Add(v.name)
					end]]
				else
					count = count - 1
				end
			end
		end
		
		if (count > 0) then
			local iterator = newList()
			for i=1,count do
				tinsert(iterator, {i,self.refreshList[i].priority})
			end
			sort(iterator, function(a,b) return a[2] > b[2] end)
			if (count > 1 and self.loopError == nil) then
				-- I pray for no infinite loops --
				local loopCount = 0
				while (true) do
					loopCount = loopCount + 1
					if (loopCount == 100) then
						self.loopError = true
						message("Training Wheels Loop Error! Refresh List is disabled. Please report this error!")
						break
					end
					local found = false
					local finishTime = max(self.refreshList[iterator[1][1]].castTime, 1.5)
					
					for i=2, count do
						if self.refreshList[iterator[i][1]].nextCast < finishTime then
							--Swap swap swap
							for j=i,2,-1 do
								if self.refreshList[iterator[j][1]].nextCast < self.refreshList[iterator[j-1][1]].nextCast then
									iterator[j], iterator[j - 1] = iterator[j - 1], iterator[j]
									found = true
								else
									break
								end
							end
						end
					end
					
					if found == false then
						break
					end
				end
			end
			
			--Loop through each spell
			for i,stuff in pairs(iterator) do
				v = self.refreshList[stuff[1]]
				if (v.earlyCast) then
					self.SpellFrame:Add(v.name, v.texture, "yellow")
				else
					self.SpellFrame:Add(v.name, v.texture)
				end
			end
			
			del(iterator)
		end
		
		del(auraList)
	end
end

function self:ScheduleRefreshSpellFrame()
	self.nextFrameRefresh = true
end

function self:ListEquipmentSlots()
	local output = "Listing Equipment Slots"
	for i=0,19 do
		local link = GetInventoryItemLink("player", i)
		if link == nil then
			output = output .. "\nSlot "..i..": Empty"
		else
			local itemName = GetItemInfo(link)
			output = output .. "\nSlot "..i..": "..itemName
		end
	end
	self:Print(output)
end

function self:GetAuras(unit)
	local output = {}
	local output2 = {}
	local i = 1
	while true do
		local name,_,_,count,duration,timeLeft = UnitBuff(unit, i)
		local playerBuff = true
		if (name == nil) then break end
		if (duration == nil) then playerBuff = false duration = 99 end
		if (timeLeft == nil) then timeLeft = 99 end
		if (count == 0) then count = 1 end
		local type = "Buff"
		output[name] = newDict("name", name, "count", count, "type", "Buff", "duration", duration, "timeLeft", timeLeft)
		if (output[type] == nil) then
			output[type] = newDict("name", type, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
		else
			output[type].duration = min(output[type].duration, duration)
			output[type].timeLeft = min(output[type].timeLeft, timeLeft)
			output[type].count = output[type].count + count
		end
		
		if (playerBuff) then
			output2[name] = newDict("name", name, "count", count, "type", "Buff", "duration", duration, "timeLeft", timeLeft)
			if (output2[type] == nil) then
				output2[type] = newDict("name", type, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
			else
				output2[type].duration = min(output2[type].duration, duration)
				output2[type].timeLeft = min(output2[type].timeLeft, timeLeft)
				output2[type].count = output2[type].count + count
			end
		end
		
		i = i + 1
	end
	i = 1
	while true do
		local name,_,_,count,type,duration,timeLeft = UnitDebuff(unit, i)
		local playerBuff = true
		if (name == nil) then break end
		if (duration == nil) then playerBuff = false duration = 99 end
		if (timeLeft == nil) then timeLeft = 99 end
		if (count == 0) then count = 1 end
		if (type == "" or type == nil) then type = "No Type" end
		output[name] = newDict("name", name, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
		if (output[type] == nil) then
			output[type] = newDict("name", type, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
		else
			output[type].duration = min(output[type].duration, duration)
			output[type].timeLeft = min(output[type].timeLeft, timeLeft)
			output[type].count = output[type].count + count
		end
		
		if (playerBuff) then
			output2[name] = newDict("name", name, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
			if (output2[type] == nil) then
				output2[type] = newDict("name", type, "count", count, "type", type, "duration", duration, "timeLeft", timeLeft)
			else
				output2[type].duration = min(output2[type].duration, duration)
				output2[type].timeLeft = min(output2[type].timeLeft, timeLeft)
				output2[type].count = output2[type].count + count
			end
		end
		
		i = i + 1
	end
	
	return output, output2
end

function self:OnClick(button)
	if (button == "LeftButton") then
		self:OpenConfigMenu()
	else
		self:OpenMenu()
	end
end

function self:OnTooltipUpdate()
	GameTooltip:AddLine("|cffffff00 Click|r to configure Training Wheels.\n|cffffff00 Right-Click|r to set FuBar options.")
end

function self:ShowVersion()
	message("Training Wheels "..self.version)
end

--Clone a table
function self:CloneTable(value, max, counter)
	if (type(value) ~= "table") then
		return false, "Invalid type."
	end
	if (max ~= nil and type(max) == "number" and max > 0) then
		if (counter == nil) then
			counter = 0
		end
		counter = counter + #value
		if (counter > max) then
			return false, "Too many elements."
		end
	else
		max = nil
	end
	
	local output = {}
	for i,v in pairs(value) do
		if (type(v) ~= "table") then
			--No executable bullshit
			if (type(v) == "function" or type(v) == "thread" or type(v) == "userdata") then
				return false, "Invalid data type "..type(v) .. "."
			end
			output[i] = v
		else
			local result,msg =  self:CloneTable(v, max, counter)
			if (result == false) then
				return false, msg
			else
				output[i] = result
			end
		end
	end
	return output
end