TrainingWheels.SpellFrame = {}
local SpellFrame = TrainingWheels.SpellFrame, TrainingWheels.SpellFrame

SpellFrame.slots = {}
SpellFrame.usedSlots = 0
SpellFrame.curSlot = 0
SpellFrame.moveAllowed = false
	
function TrainingWheels:InitSpellFrame()
	SpellFrame.Frame = CreateFrame("Frame", "TrainingWheels_SpellFrame", UIParent)
	
	local Frame = SpellFrame.Frame
	Frame:SetWidth(200)
	Frame:SetHeight(100)
	Frame:SetFrameStrata("HIGH")
	Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", TrainingWheels.db.profile.spellFrameX, TrainingWheels.db.profile.spellFrameY * -1)
	Frame:SetBackdrop({edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", edgeSize=16})
	Frame:SetScript("OnMouseDown", function(self)
		if (SpellFrame.moveAllowed) then
			self:StartMoving()
		end
	end)
	Frame:SetScript("OnMouseUp", function(self)
		self:StopMovingOrSizing()
		SpellFrame:RememberPosition()
	end)
	Frame:SetClampedToScreen(true)
	SpellFrame:StopMoving()

	--Creating list region
	SpellFrame.List = CreateFrame("Frame", "TrainingWheels_SpellFrame_Region", SpellFrame.Frame)
	local List = SpellFrame.List
	List:SetPoint("TOPLEFT", Frame, "TOPLEFT", 0, 0)
	List:SetPoint("BOTTOMRIGHT", Frame, "BOTTOMRIGHT", 0, 0)

	--Populating list (10 only)
	for i=1,10 do
		SpellFrame:CreateSlot()
	end
	SpellFrame:Clear()
end

function SpellFrame:CreateSlot()
	local i = #(SpellFrame.slots) + 1
	--SpellFrame.slots[i] = CreateFrame("Frame", nil, SpellFrame.List)
	SpellFrame.slots[i] = {}
	local curSlot = SpellFrame.slots[i]
	
	--Create the Texture
	curSlot.Icon = SpellFrame.List:CreateTexture(nil, "OVERLAY")
	local icon = curSlot.Icon
	icon:SetTexture("Interface\\Icons\\Temp")
	icon:SetWidth(32)
	icon:SetHeight(32)
	
	
	--Create the Name
	curSlot.Name = SpellFrame.List:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	local spellName = curSlot.Name
	spellName:SetTextColor(1.0, 1.0, 1.0)
	spellName:SetText("Spell Name")
	spellName:SetJustifyV("MIDDLE")
	spellName:SetJustifyH("LEFT")
	
	--Set the anchor points
	local stepY = -34;
	local stepCount = i - 1;
	icon:SetPoint("TOPLEFT", SpellFrame.List, "TOPLEFT", 0, stepY * stepCount)
	spellName:SetPoint("LEFT", icon, "TOPRIGHT", 2, 0)
	spellName:SetPoint("TOPRIGHT", SpellFrame.List, "TOPRIGHT", 0, stepY * stepCount)
	spellName:SetPoint("BOTTOM", icon, "BOTTOM", 0, 0)
		
	curSlot.SetIcon = function(self, texture)
		self.Icon:SetTexture(texture)
	end
	
	curSlot.GetIcon = function(self)
		return self.Icon:GetTexture()
	end
	
	curSlot.SetName = function(self, name, color)
		if (color == "red") then 
			self.Name:SetTextColor(1.0, 0.0, 0.0)
		elseif (color == "yellow") then
			self.Name:SetTextColor(1.0, 1.0, 0.0)
		elseif (color == "green") then
			self.Name:SetTextColor(0.0, 1.0, 0.0)
		else
			self.Name:SetTextColor(1.0, 1.0, 1.0)
		end
		self.Name:SetText(name)
	end
	
	curSlot.Show = function(self, showIcon)
		if (TrainingWheels.db.profile.showLabels) then
			self.Name:Show()
		end
		if (showIcon) then
			self.Icon:Show()
		end
	end
	
	curSlot.Hide = function(self)
		self.Name:Hide()
		self.Icon:Hide()
	end
end

function SpellFrame:Show()
	self.Frame:Show()
end

function SpellFrame:Hide()
	self.Frame:Hide()
end

function SpellFrame:Add(name, icon, color)
	if (self.usedSlots < TrainingWheels.db.profile.maxSpells) then
		if (self.usedSlots == #(self.slots)) then
			self:CreateSlot()
		end
		self.usedSlots = self.usedSlots + 1
		curSlot = self.slots[self.usedSlots]
		curSlot:SetName(name, color)
		if (icon ~= nil) then
			curSlot:SetIcon("Interface\\Icons\\Temp")
			
			curSlot:SetIcon(icon)
			if (curSlot:GetIcon() == "Interface\\Icons\\Temp") then
				icon = nil
			end
		end
		curSlot:Show(icon ~= nil and icon ~= "")
	end
end

function SpellFrame:Clear()
	self.usedSlots = 0
	for i,v in pairs(self.slots) do
		v:Hide()
	end
end

function SpellFrame:StartMoving()
	self.moveAllowed = true
	self.Frame:SetBackdropBorderColor(1.0,1.0,1.0,1.0)
	self.Frame:SetMovable(true)
	self.Frame:SetResizable(true)
	self.Frame:EnableMouse(true)
end

function SpellFrame:StopMoving()
	self.moveAllowed = false
	self.Frame:StopMovingOrSizing()
	self.Frame:SetBackdropBorderColor(1.0,1.0,1.0,0.0)
	self.Frame:SetMovable(false)
	self.Frame:SetResizable(false)
	self.Frame:EnableMouse(false)
end

function SpellFrame:IsMoving()
	return self.moveAllowed
end

function SpellFrame:ToggleMoving()
	if (self.moveAllowed) then
		self:StopMoving()
	else
		self:StartMoving()
	end
end

function SpellFrame:RememberPosition()
	TrainingWheels.db.profile.spellFrameX = self.Frame:GetLeft()
	TrainingWheels.db.profile.spellFrameY = self.Frame:GetTop()
end