--[[
Migrates spell lists from old versions to new versions
This is accomplished via a version key in each spell that denotes what spell version it's using.
Spell version is different from addon version.
Remember to update this everytime you update the structure of the spell list.
This is not used to validate values, just to migrate old lists to newer versions.
]]
function TrainingWheels:MigrateSpellList(spellList)
	--Unpack our friendly spell list
	for i,spell in pairs(spellList) do
		--We start from the lowest possible version and migrate upwards.
		--DO NOT USE IF ELSE STATEMENTS, we want them to upgrade sequentially, dumbass.
		--ALSO DON'T USE spell.version <= TrainingWheels.spellVersion, you're likely to break things!
		--Migration should never fail, upgrade even if it means changing values...
		
		--Is versioning required?
		if (spell.version ~= TrainingWheels.spellVersion) then
			--Yes it is required...
			
			--Before versioning is used
			--Spell structure is upgraded to provide better aura control
			--Merging of both player and target aura
			--Merging of both player and target status check as well (GODDAMN)
			if (spell.version == nil) then
				if (spell.texture == nil) then
					spell.texture = ""
				end
				for j,cur in pairs (spell.conditions) do
					if (cur.type == "playerAura" or cur.type == "targetAura") then
						if (cur.type == "playerAura") then 
							cur.unitType = "Player"
						else
							cur.unitType = spell.targetSource
							if (cur.unitType == nil) then
								cur.unitType = "Target"
							end
						end
						cur.type = "aura"
						if (cur.castWhenExists == false) then
							cur.minStack = 0
							cur.maxStack = 0
						end
						cur.castWhenExists = nil
						if (cur.spellTriggers) then
							cur.spellTriggers = "Add"
						else
							cur.spellTriggers = "Disabled"
						end
						cur.refreshAura = true
						cur.refreshDuration = 0
					end
					
					if (cur.type == "playerStatus" or cur.type == "targetStatus") then
						if (cur.type == "playerStatus") then
							cur.unitType = "Player"
						else
							cur.unitType = spell.targetSource
							if (cur.unitType == nil) then
								cur.unitType = "Target"
							end
						end
						cur.type = "status"
						local healthStr = ""
						local value = cur.health
						local amount = cur.healthAmount
						if (value == "More than") then
							healthStr = "H > "..(amount * 100).."%"
						elseif (value == "Less than") then
							healthStr = "H < "..(amount * 100).."%"
						end
						local powerStr = ""
						amount = cur.powerAmount
						value = cur.power
						if (value == "More than") then
							powerStr = "P > "..(amount * 100).."%"
						elseif (value == "Less than") then
							powerStr = "P < "..(amount * 100).."%"
						end
						local name = strtrim(healthStr.." "..powerStr)
						if (name ~= "") then
							cur.name = cur.unitType.." ("..name..")"
						else
							cur.name = "Unspecified "..cur.unitType.." Status"
						end
					end
				end
				spell.version = 1
			end
			
			
			--In the end, if the spell version is different, something is really screwed up!
			if (spell.version ~= TrainingWheels.spellVersion) then
				return false, "Unable to migrate spell list."
			end
		end
		--WOOP WOOP SPELL IS CURRENT
	end
	--WOOP WOOP SPELL LIST IS CURRENT
	
	return true
end