﻿--[[
Name: Babble-Tradeskill-2.2
Revision: $Rev: 75273 $
Author(s): ckknight (ckknight@gmail.com), Kemayo
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Tradeskill-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Tradeskill-2.2
Description: A library to provide localizations for tradeskills.
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Tradeskill-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 75273 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleTradeskill = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleTradeskill:EnableDebugging()

BabbleTradeskill:RegisterTranslations("enUS", function()
	return {
-- Gathering skills
		["Disenchant"] = true,
		["Fishing"] = true,
		["Herbalism"] = true,
		["Mining"] = true,
		["Pick Pocket"] = true,
		["Prospecting"] = true,
		["Skinning"] = true,
		["Smelting"] = true,
		["Riding"] = true,

-- Crafting skills
		["Alchemy"] = true,
		["Armorsmith"] = true,
		["Blacksmithing"] = true,
		["Cooking"] = true,
		["Dragonscale Leatherworking"] = true,
		["Elemental Leatherworking"] = true,
		["Elixir Master"] = true,
		["Enchanting"] = true,
		["Engineering"] = true,
		["First Aid"] = true,
		["Gnomish Engineering"] = true,
		["Goblin Engineering"] = true,
		["Gnomish Engineer"] = true,
		["Goblin Engineer"] = true,
		["Jewelcrafting"] = true,
		["Leatherworking"] = true,
		["Master Axesmith"] = true,
		["Master Hammersmith"] = true,
		["Master Swordsmith"] = true,
		["Mooncloth Tailoring"] = true,
		["Poisons"] = true,
		["Potion Master"] = true,
		["Shadoweave Tailoring"] = true,
		["Spellfire Tailoring"] = true,
		["Tailoring"] = true,
		["Transmutation Master"] = true,
		["Tribal Leatherworking"] = true,
		["Weaponsmith"] = true,

-- Alchemy Recipes
		["Adept's Elixir"] = true,
		["Alchemist's Stone"] = true,
		["Arcane Elixir"] = true,
		["Blackmouth Oil"] = true,
		["Catseye Elixir"] = true,
		["Cauldron of Major Arcane Protection"] = true,
		["Cauldron of Major Fire Protection"] = true,
		["Cauldron of Major Frost Protection"] = true,
		["Cauldron of Major Nature Protection"] = true,
		["Cauldron of Major Shadow Protection"] = true,
		["Destruction Potion"] = true,
		["Discolored Healing Potion"] = true,
		["Dreamless Sleep Potion"] = true,
		["Earthen Elixir"] = true,
		["Elixir of Agility"] = true,
		["Elixir of Brute Force"] = true,
		["Elixir of Camouflage"] = true,
		["Elixir of Defense"] = true,
		["Elixir of Demonslaying"] = true,
		["Elixir of Detect Demon"] = true,
		["Elixir of Detect Lesser Invisibility"] = true,
		["Elixir of Detect Undead"] = true,
		["Elixir of Draenic Wisdom"] = true,
		["Elixir of Dream Vision"] = true,
		["Elixir of Empowerment"] = true,
		["Elixir of Firepower"] = true,
		["Elixir of Fortitude"] = true,
		["Elixir of Frost Power"] = true,
		["Elixir of Giant Growth"] = true,
		["Elixir of Giants"] = true,
		["Elixir of Greater Agility"] = true,
		["Elixir of Greater Defense"] = true,
		["Elixir of Greater Firepower"] = true,
		["Elixir of Greater Intellect"] = true,
		["Elixir of Greater Water Breathing"] = true,
		["Elixir of Healing Power"] = true,
		["Elixir of Ironskin"] = true,
		["Elixir of Lesser Agility"] = true,
		["Elixir of Lion's Strength"] = true,
		["Elixir of Major Agility"] = true,
		["Elixir of Major Defense"] = true,
		["Elixir of Major Firepower"] = true,
		["Elixir of Major Fortitude"] = true,
		["Elixir of Major Frost Power"] = true,
		["Elixir of Major Mageblood"] = true,
		["Elixir of Major Shadow Power"] = true,
		["Elixir of Major Strength"] = true,
		["Elixir of Mastery"] = true,
		["Elixir of Minor Agility"] = true,
		["Elixir of Minor Defense"] = true,
		["Elixir of Minor Fortitude"] = true,
		["Elixir of Ogre's Strength"] = true,
		["Elixir of Shadow Power"] = true,
		["Elixir of Superior Defense"] = true,
		["Elixir of the Mongoose"] = true,
		["Elixir of the Sages"] = true,
		["Elixir of the Searching Eye"] = true,
		["Elixir of Water Breathing"] = true,
		["Elixir of Wisdom"] = true,
		["Fel Mana Potion"] = true,
		["Fel Regeneration Potion"] = true,
		["Fel Strength Elixir"] = true,
		["Fire Oil"] = true,
		["Fire Protection Potion"] = true,
		["Flask of Blinding Light"] = true,
		["Flask of Chromatic Resistance"] = true,
		["Flask of Chromatic Wonder"] = true,
		["Flask of Distilled Wisdom"] = true,
		["Flask of Fortification"] = true,
		["Flask of Mighty Restoration"] = true,
		["Flask of Petrification"] = true,
		["Flask of Pure Death"] = true,
		["Flask of Relentless Assault"] = true,
		["Flask of Supreme Power"] = true,
		["Flask of the Titans"] = true,
		["Free Action Potion"] = true,
		["Frost Oil"] = true,
		["Frost Protection Potion"] = true,
		["Ghost Dye"] = true,
		["Gift of Arthas"] = true,
		["Goblin Rocket Fuel"] = true,
		["Great Rage Potion"] = true,
		["Greater Arcane Elixir"] = true,
		["Greater Arcane Protection Potion"] = true,
		["Greater Dreamless Sleep Potion"] = true,
		["Greater Fire Protection Potion"] = true,
		["Greater Frost Protection Potion"] = true,
		["Greater Healing Potion"] = true,
		["Greater Mana Potion"] = true,
		["Greater Nature Protection Potion"] = true,
		["Greater Shadow Protection Potion"] = true,
		["Greater Stoneshield Potion"] = true,
		["Gurubashi Mojo Madness"] = true,
		["Haste Potion"] = true,
		["Healing Potion"] = true,
		["Heroic Potion"] = true,
		["Holy Protection Potion"] = true,
		["Insane Strength Potion"] = true,
		["Invisibility Potion"] = true,
		["Ironshield Potion"] = true,
		["Lesser Healing Potion"] = true,
		["Lesser Invisibility Potion"] = true,
		["Lesser Mana Potion"] = true,
		["Lesser Stoneshield Potion"] = true,
		["Limited Invulnerability Potion"] = true,
		["Living Action Potion"] = true,
		["Mad Alchemist's Potion"] = true,
		["Mageblood Potion"] = true,
		["Magic Resistance Potion"] = true,
		["Major Arcane Protection Potion"] = true,
		["Major Dreamless Sleep Potion"] = true,
		["Major Fire Protection Potion"] = true,
		["Major Frost Protection Potion"] = true,
		["Major Healing Potion"] = true,
		["Major Holy Protection Potion"] = true,
		["Major Mana Potion"] = true,
		["Major Nature Protection Potion"] = true,
		["Major Rejuvenation Potion"] = true,
		["Major Shadow Protection Potion"] = true,
		["Major Troll's Blood Potion"] = true,
		["Mana Potion"] = true,
		["Mercurial Stone"] = true,
		["Mighty Rage Potion"] = true,
		["Mighty Troll's Blood Potion"] = true,
		["Minor Healing Potion"] = true,
		["Minor Magic Resistance Potion"] = true,
		["Minor Mana Potion"] = true,
		["Minor Rejuvenation Potion"] = true,
		["Nature Protection Potion"] = true,
		["Oil of Immolation"] = true,
		["Onslaught Elixir"] = true,
		["Philosopher's Stone"] = true,
		["Potion of Curing"] = true,
		["Purification Potion"] = true,
		["Rage Potion"] = true,
		["Restorative Potion"] = true,
		["Shadow Oil"] = true,
		["Shadow Protection Potion"] = true,
		["Shrouding Potion"] = true,
		["Sneaking Potion"] = true,
		["Stonescale Oil"] = true,
		["Strong Troll's Blood Potion"] = true,
		["Super Healing Potion"] = true,
		["Super Mana Potion"] = true,
		["Super Rejuvenation Potion"] = true,
		["Superior Healing Potion"] = true,
		["Superior Mana Potion"] = true,
		["Swiftness Potion"] = true,
		["Swim Speed Potion"] = true,
		["Transmute: Air to Fire"] = true,
		["Transmute: Arcanite"] = true,
		["Transmute: Earth to Life"] = true,
		["Transmute: Earth to Water"] = true,
		["Transmute: Earthstorm Diamond"] = true,
		["Transmute: Elemental Fire"] = true,
		["Transmute: Fire to Earth"] = true,
		["Transmute: Iron to Gold"] = true,
		["Transmute: Life to Earth"] = true,
		["Transmute: Mithril to Truesilver"] = true,
		["Transmute: Primal Air to Fire"] = true,
		["Transmute: Primal Earth to Life"] = true,
		["Transmute: Primal Earth to Water"] = true,
		["Transmute: Primal Fire to Earth"] = true,
		["Transmute: Primal Fire to Mana"] = true,
		["Transmute: Primal Life to Earth"] = true,
		["Transmute: Primal Mana to Fire"] = true,
		["Transmute: Primal Might"] = true,
		["Transmute: Primal Shadow to Water"] = true,
		["Transmute: Primal Water to Air"] = true,
		["Transmute: Primal Water to Shadow"] = true,
		["Transmute: Skyfire Diamond"] = true,
		["Transmute: Undeath to Water"] = true,
		["Transmute: Water to Air"] = true,
		["Transmute: Water to Undeath"] = true,
		["Unstable Mana Potion"] = true,
		["Volatile Healing Potion"] = true,
		["Weak Troll's Blood Potion"] = true,
		["Wildvine Potion"] = true,
		["Assassin's Alchemist Stone"] = true,
		["Guardian's Alchemist Stone"] = true,
		["Redeemer's Alchemist Stone"] = true,
		["Sorcerer's Alchemist Stone"] = true,

-- Beast Training Skills
		["Arcane Resistance (Rank 1)"] = true,
		["Arcane Resistance (Rank 2)"] = true,
		["Arcane Resistance (Rank 3)"] = true,
		["Arcane Resistance (Rank 4)"] = true,
		["Arcane Resistance (Rank 5)"] = true,
		["Avoidance (Rank 1)"] = true,
		["Avoidance (Rank 2)"] = true,
		["Bite (Rank 1)"] = true,
		["Bite (Rank 2)"] = true,
		["Bite (Rank 3)"] = true,
		["Bite (Rank 4)"] = true,
		["Bite (Rank 5)"] = true,
		["Bite (Rank 6)"] = true,
		["Bite (Rank 7)"] = true,
		["Bite (Rank 8)"] = true,
		["Bite (Rank 9)"] = true,
		["Charge (Rank 1)"] = true,
		["Charge (Rank 2)"] = true,
		["Charge (Rank 3)"] = true,
		--["Charge (Rank 4)"] = true, -- No charge rank 4 in the game
		["Charge (Rank 5)"] = true,
		["Charge (Rank 6)"] = true,
		["Claw (Rank 1)"] = true,
		["Claw (Rank 2)"] = true,
		["Claw (Rank 3)"] = true,
		["Claw (Rank 4)"] = true,
		["Claw (Rank 5)"] = true,
		["Claw (Rank 6)"] = true,
		["Claw (Rank 7)"] = true,
		["Claw (Rank 8)"] = true,
		["Claw (Rank 9)"] = true,
		["Cobra Reflexes ()"] = true,
		["Cower (Rank 1)"] = true,
		["Cower (Rank 2)"] = true,
		["Cower (Rank 3)"] = true,
		["Cower (Rank 4)"] = true,
		["Cower (Rank 5)"] = true,
		["Cower (Rank 6)"] = true,
		["Cower (Rank 7)"] = true,
		["Dash (Rank 1)"] = true,
		["Dash (Rank 2)"] = true,
		["Dash (Rank 3)"] = true,
		["Dive (Rank 1)"] = true,
		["Dive (Rank 2)"] = true,
		["Dive (Rank 3)"] = true,
		["Fire Breath (Rank 1)"] = true,
		["Fire Breath (Rank 2)"] = true,
		["Fire Resistance (Rank 1)"] = true,
		["Fire Resistance (Rank 2)"] = true,
		["Fire Resistance (Rank 3)"] = true,
		["Fire Resistance (Rank 4)"] = true,
		["Fire Resistance (Rank 5)"] = true,
		["Frost Resistance (Rank 1)"] = true,
		["Frost Resistance (Rank 2)"] = true,
		["Frost Resistance (Rank 3)"] = true,
		["Frost Resistance (Rank 4)"] = true,
		["Frost Resistance (Rank 5)"] = true,
		["Furious Howl (Rank 1)"] = true,
		["Furious Howl (Rank 2)"] = true,
		["Furious Howl (Rank 3)"] = true,
		["Furious Howl (Rank 4)"] = true,
		["Gore (Rank 1)"] = true,
		["Gore (Rank 2)"] = true,
		["Gore (Rank 3)"] = true,
		["Gore (Rank 4)"] = true,
		--["Gore (Rank 5)"] = true, -- Not in game
		--["Gore (Rank 6)"] = true, -- Not in game
		["Gore (Rank 7)"] = true,
		["Gore (Rank 8)"] = true,
		["Gore (Rank 9)"] = true,
		["Great Stamina (Rank 1)"] = true,
		["Great Stamina (Rank 10)"] = true,
		["Great Stamina (Rank 11)"] = true,
		["Great Stamina (Rank 2)"] = true,
		["Great Stamina (Rank 3)"] = true,
		["Great Stamina (Rank 4)"] = true,
		["Great Stamina (Rank 5)"] = true,
		["Great Stamina (Rank 6)"] = true,
		["Great Stamina (Rank 7)"] = true,
		["Great Stamina (Rank 8)"] = true,
		["Great Stamina (Rank 9)"] = true,
		["Growl (Rank 1)"] = true,
		["Growl (Rank 2)"] = true,
		["Growl (Rank 3)"] = true,
		["Growl (Rank 4)"] = true,
		["Growl (Rank 5)"] = true,
		["Growl (Rank 6)"] = true,
		["Growl (Rank 7)"] = true,
		["Growl (Rank 8)"] = true,
		["Lightning Breath (Rank 1)"] = true,
		["Lightning Breath (Rank 2)"] = true,
		["Lightning Breath (Rank 3)"] = true,
		["Lightning Breath (Rank 4)"] = true,
		["Lightning Breath (Rank 5)"] = true,
		["Lightning Breath (Rank 6)"] = true,
		["Natural Armor (Rank 1)"] = true,
		["Natural Armor (Rank 10)"] = true,
		["Natural Armor (Rank 11)"] = true,
		["Natural Armor (Rank 2)"] = true,
		["Natural Armor (Rank 3)"] = true,
		["Natural Armor (Rank 4)"] = true,
		["Natural Armor (Rank 5)"] = true,
		["Natural Armor (Rank 6)"] = true,
		["Natural Armor (Rank 7)"] = true,
		["Natural Armor (Rank 8)"] = true,
		["Natural Armor (Rank 9)"] = true,
		["Nature Resistance (Rank 1)"] = true,
		["Nature Resistance (Rank 2)"] = true,
		["Nature Resistance (Rank 3)"] = true,
		["Nature Resistance (Rank 4)"] = true,
		["Nature Resistance (Rank 5)"] = true,
		["Poison Spit (Rank 1)"] = true,
		["Poison Spit (Rank 2)"] = true,
		["Poison Spit (Rank 3)"] = true,
		["Prowl (Rank 1)"] = true,
		["Prowl (Rank 2)"] = true,
		["Prowl (Rank 3)"] = true,
		["Scorpid Poison (Rank 1)"] = true,
		["Scorpid Poison (Rank 2)"] = true,
		["Scorpid Poison (Rank 3)"] = true,
		["Scorpid Poison (Rank 4)"] = true,
		["Scorpid Poison (Rank 5)"] = true,
		["Screech (Rank 1)"] = true,
		["Screech (Rank 2)"] = true,
		["Screech (Rank 3)"] = true,
		["Screech (Rank 4)"] = true,
		["Screech (Rank 5)"] = true,
		["Shadow Resistance (Rank 1)"] = true,
		["Shadow Resistance (Rank 2)"] = true,
		["Shadow Resistance (Rank 3)"] = true,
		["Shadow Resistance (Rank 4)"] = true,
		["Shadow Resistance (Rank 5)"] = true,
		["Shell Shield (Rank 1)"] = true,
		["Thunderstomp (Rank 1)"] = true,
		["Thunderstomp (Rank 2)"] = true,
		["Thunderstomp (Rank 3)"] = true,
		["Warp (Rank 1)"] = true,

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = true,
		["Adamantite Cleaver"] = true,
		["Adamantite Dagger"] = true,
		["Adamantite Maul"] = true,
		["Adamantite Plate Bracers"] = true,
		["Adamantite Plate Gloves"] = true,
		["Adamantite Rapier"] = true,
		["Adamantite Rod"] = true,
		["Adamantite Sharpening Stone"] = true,
		["Adamantite Weapon Chain"] = true,
		["Adamantite Weightstone"] = true,
		["Annihilator"] = true,
		["Arcanite Champion"] = true,
		["Arcanite Reaper"] = true,
		["Arcanite Rod"] = true,
		["Arcanite Skeleton Key"] = true,
		["Barbaric Iron Boots"] = true,
		["Barbaric Iron Breastplate"] = true,
		["Barbaric Iron Gloves"] = true,
		["Barbaric Iron Helm"] = true,
		["Barbaric Iron Shoulders"] = true,
		["Belt of the Guardian"] = true,
		["Big Black Mace"] = true,
		["Big Bronze Knife"] = true,
		["Black Amnesty"] = true,
		["Black Felsteel Bracers"] = true,
		["Black Grasp of the Destroyer"] = true,
		["Black Planar Edge"] = true,
		["Blackfury"] = true,
		["Blackguard"] = true,
		["Blazefury"] = true,
		["Blazeguard"] = true,
		["Blazing Rapier"] = true,
		["Blessed Bracers"] = true,
		["Blight"] = true,
		["Bloodmoon"] = true,
		["Bloodsoul Breastplate"] = true,
		["Bloodsoul Gauntlets"] = true,
		["Bloodsoul Shoulders"] = true,
		["Blue Glittering Axe"] = true,
		["Boots of the Protector"] = true,
		["Bracers of the Green Fortress"] = true,
		["Breastplate of Kings"] = true,
		["Bronze Axe"] = true,
		["Bronze Battle Axe"] = true,
		["Bronze Greatsword"] = true,
		["Bronze Mace"] = true,
		["Bronze Shortsword"] = true,
		["Bronze Warhammer"] = true,
		["Bulwark of Kings"] = true,
		["Bulwark of the Ancient Kings"] = true,
		["Coarse Grinding Stone"] = true,
		["Coarse Sharpening Stone"] = true,
		["Coarse Weightstone"] = true,
		["Copper Axe"] = true,
		["Copper Battle Axe"] = true,
		["Copper Bracers"] = true,
		["Copper Chain Belt"] = true,
		["Copper Chain Boots"] = true,
		["Copper Chain Pants"] = true,
		["Copper Chain Vest"] = true,
		["Copper Claymore"] = true,
		["Copper Dagger"] = true,
		["Copper Mace"] = true,
		["Copper Shortsword"] = true,
		["Corruption"] = true,
		["Dark Iron Boots"] = true,
		["Dark Iron Bracers"] = true,
		["Dark Iron Destroyer"] = true,
		["Dark Iron Gauntlets"] = true,
		["Dark Iron Helm"] = true,
		["Dark Iron Leggings"] = true,
		["Dark Iron Mail"] = true,
		["Dark Iron Plate"] = true,
		["Dark Iron Pulverizer"] = true,
		["Dark Iron Reaver"] = true,
		["Dark Iron Shoulders"] = true,
		["Dark Iron Sunderer"] = true,
		["Darkrune Breastplate"] = true,
		["Darkrune Gauntlets"] = true,
		["Darkrune Helm"] = true,
		["Darksoul Breastplate"] = true,
		["Darksoul Leggings"] = true,
		["Darksoul Shoulders"] = true,
		["Dawnbringer Shoulders"] = true,
		["Dawn's Edge"] = true,
		["Dawnsteel Bracers"] = true,
		["Dawnsteel Shoulders"] = true,
		["Dazzling Mithril Rapier"] = true,
		["Deadly Bronze Poniard"] = true,
		["Deep Thunder"] = true,
		["Demon Forged Breastplate"] = true,
		["Dense Grinding Stone"] = true,
		["Dense Sharpening Stone"] = true,
		["Dense Weightstone"] = true,
		["Dirge"] = true,
		["Dragonmaw"] = true,
		["Dragonstrike"] = true,
		["Drakefist Hammer"] = true,
		["Earthforged Leggings"] = true,
		["Earthpeace Breastplate"] = true,
		["Ebon Hand"] = true,
		["Ebon Shiv"] = true,
		["Edge of Winter"] = true,
		["Elemental Sharpening Stone"] = true,
		["Embrace of the Twisting Nether"] = true,
		["Enchanted Adamantite Belt"] = true,
		["Enchanted Adamantite Boots"] = true,
		["Enchanted Adamantite Breastplate"] = true,
		["Enchanted Adamantite Leggings"] = true,
		["Enchanted Battlehammer"] = true,
		["Enchanted Thorium Blades"] = true,
		["Enchanted Thorium Breastplate"] = true,
		["Enchanted Thorium Helm"] = true,
		["Enchanted Thorium Leggings"] = true,
		["Eternium Rod"] = true,
		["Eternium Runed Blade"] = true,
		["Fel Edged Battleaxe"] = true,
		["Fel Hardened Maul"] = true,
		["Fel Iron Breastplate"] = true,
		["Fel Iron Chain Bracers"] = true,
		["Fel Iron Chain Coif"] = true,
		["Fel Iron Chain Gloves"] = true,
		["Fel Iron Chain Tunic"] = true,
		["Fel Iron Greatsword"] = true,
		["Fel Iron Hammer"] = true,
		["Fel Iron Hatchet"] = true,
		["Fel Iron Plate Belt"] = true,
		["Fel Iron Plate Boots"] = true,
		["Fel Iron Plate Gloves"] = true,
		["Fel Iron Plate Pants"] = true,
		["Fel Iron Rod"] = true,
		["Fel Sharpening Stone"] = true,
		["Fel Weightstone"] = true,
		["Felfury Gauntlets"] = true,
		["Felsteel Gloves"] = true,
		["Felsteel Helm"] = true,
		["Felsteel Leggings"] = true,
		["Felsteel Longblade"] = true,
		["Felsteel Reaper"] = true,
		["Felsteel Shield Spike"] = true,
		["Felsteel Whisper Knives"] = true,
		["Fiery Blaze Enchantment"] = true,
		["Fiery Chain Girdle"] = true,
		["Fiery Chain Shoulders"] = true,
		["Fiery Plate Gauntlets"] = true,
		["Fireguard"] = true,
		["Flamebane Bracers"] = true,
		["Flamebane Breastplate"] = true,
		["Flamebane Gloves"] = true,
		["Flamebane Helm"] = true,
		["Frost Tiger Blade"] = true,
		["Frostguard"] = true,
		["Gauntlets of the Iron Tower"] = true,
		["Gemmed Copper Gauntlets"] = true,
		["Girdle of the Dawn"] = true,
		["Glinting Steel Dagger"] = true,
		["Gloves of the Dawn"] = true,
		["Golden Iron Destroyer"] = true,
		["Golden Rod"] = true,
		["Golden Scale Boots"] = true,
		["Golden Scale Bracers"] = true,
		["Golden Scale Coif"] = true,
		["Golden Scale Cuirass"] = true,
		["Golden Scale Gauntlets"] = true,
		["Golden Scale Leggings"] = true,
		["Golden Scale Shoulders"] = true,
		["Golden Skeleton Key"] = true,
		["Great Earthforged Hammer"] = true,
		["Greater Rune of Warding"] = true,
		["Greater Ward of Shielding"] = true,
		["Green Iron Boots"] = true,
		["Green Iron Bracers"] = true,
		["Green Iron Gauntlets"] = true,
		["Green Iron Hauberk"] = true,
		["Green Iron Helm"] = true,
		["Green Iron Leggings"] = true,
		["Green Iron Shoulders"] = true,
		["Hard Khorium Battlefists"] = true,
		["Hard Khorium Battleplate"] = true,
		["Hammer of Righteous Might"] = true,
		["Hammer of the Titans"] = true,
		["Hand of Eternity"] = true,
		["Hardened Iron Shortsword"] = true,
		["Heartseeker"] = true,
		["Heavy Bronze Mace"] = true,
		["Heavy Copper Broadsword"] = true,
		["Heavy Copper Longsword"] = true,
		["Heavy Copper Maul"] = true,
		["Heavy Earthforged Breastplate"] = true,
		["Heavy Grinding Stone"] = true,
		["Heavy Mithril Axe"] = true,
		["Heavy Mithril Boots"] = true,
		["Heavy Mithril Breastplate"] = true,
		["Heavy Mithril Gauntlet"] = true,
		["Heavy Mithril Helm"] = true,
		["Heavy Mithril Pants"] = true,
		["Heavy Mithril Shoulder"] = true,
		["Heavy Obsidian Belt"] = true,
		["Heavy Sharpening Stone"] = true,
		["Heavy Timbermaw Belt"] = true,
		["Heavy Timbermaw Boots"] = true,
		["Heavy Weightstone"] = true,
		["Helm of the Great Chief"] = true,
		["Helm of the Stalwart Defender"] = true,
		["Huge Thorium Battleaxe"] = true,
		["Icebane Bracers"] = true,
		["Icebane Breastplate"] = true,
		["Icebane Gauntlets"] = true,
		["Iceguard Breastplate"] = true,
		["Iceguard Helm"] = true,
		["Iceguard Leggings"] = true,
		["Imperial Plate Belt"] = true,
		["Imperial Plate Boots"] = true,
		["Imperial Plate Bracers"] = true,
		["Imperial Plate Chest"] = true,
		["Imperial Plate Helm"] = true,
		["Imperial Plate Leggings"] = true,
		["Imperial Plate Shoulders"] = true,
		["Inlaid Mithril Cylinder"] = true,
		["Invulnerable Mail"] = true,
		["Iridescent Hammer"] = true,
		["Iron Buckle"] = true,
		["Iron Counterweight"] = true,
		["Iron Shield Spike"] = true,
		["Ironforge Breastplate"] = true,
		["Ironvine Belt"] = true,
		["Ironvine Breastplate"] = true,
		["Ironvine Gloves"] = true,
		["Jade Serpentblade"] = true,
		["Jagged Obsidian Shield"] = true,
		["Khorium Belt"] = true,
		["Khorium Boots"] = true,
		["Khorium Champion"] = true,
		["Khorium Pants"] = true,
		["Lavaforged Warhammer"] = true,
		["Lesser Rune of Warding"] = true,
		["Lesser Ward of Shielding"] = true,
		["Light Earthforged Blade"] = true,
		["Light Emberforged Hammer"] = true,
		["Light Obsidian Belt"] = true,
		["Light Skyforged Axe"] = true,
		["Lionheart Blade"] = true,
		["Lionheart Champion"] = true,
		["Lionheart Executioner"] = true,
		["Lionheart Helm"] = true,
		["Lunar Crescent"] = true,
		["Massive Iron Axe"] = true,
		["Masterwork Stormhammer"] = true,
		["Mighty Iron Hammer"] = true,
		["Mithril Coif"] = true,
		["Mithril Scale Bracers"] = true,
		["Mithril Scale Gloves"] = true,
		["Mithril Scale Pants"] = true,
		["Mithril Scale Shoulders"] = true,
		["Mithril Shield Spike"] = true,
		["Mithril Spurs"] = true,
		["Mooncleaver"] = true,
		["Moonsteel Broadsword"] = true,
		["Nether Chain Shirt"] = true,
		["Nightfall"] = true,
		["Oathkeeper's Helm"] = true,
		["Obsidian Mail Tunic"] = true,
		["Orcish War Leggings"] = true,
		["Ornate Mithril Boots"] = true,
		["Ornate Mithril Breastplate"] = true,
		["Ornate Mithril Gloves"] = true,
		["Ornate Mithril Helm"] = true,
		["Ornate Mithril Pants"] = true,
		["Ornate Mithril Shoulder"] = true,
		["Ornate Thorium Handaxe"] = true,
		["Patterned Bronze Bracers"] = true,
		["Pearl-handled Dagger"] = true,
		["Persuader"] = true,
		["Phantom Blade"] = true,
		["Polished Steel Boots"] = true,
		["Radiant Belt"] = true,
		["Radiant Boots"] = true,
		["Radiant Breastplate"] = true,
		["Radiant Circlet"] = true,
		["Radiant Gloves"] = true,
		["Radiant Leggings"] = true,
		["Ragesteel Breastplate"] = true,
		["Ragesteel Gloves"] = true,
		["Ragesteel Helm"] = true,
		["Ragesteel Shoulders"] = true,
		["Red Belt of Battle"] = true,
		["Red Havoc Boots"] = true,
		["Rough Bronze Boots"] = true,
		["Rough Bronze Bracers"] = true,
		["Rough Bronze Cuirass"] = true,
		["Rough Bronze Leggings"] = true,
		["Rough Bronze Shoulders"] = true,
		["Rough Copper Vest"] = true,
		["Rough Grinding Stone"] = true,
		["Rough Sharpening Stone"] = true,
		["Rough Weightstone"] = true,
		["Runed Copper Belt"] = true,
		["Runed Copper Bracers"] = true,
		["Runed Copper Breastplate"] = true,
		["Runed Copper Gauntlets"] = true,
		["Runed Copper Pants"] = true,
		["Runed Mithril Hammer"] = true,
		["Runic Breastplate"] = true,
		["Runic Hammer"] = true,
		["Runic Plate Boots"] = true,
		["Runic Plate Helm"] = true,
		["Runic Plate Leggings"] = true,
		["Runic Plate Shoulders"] = true,
		["Sageblade"] = true,
		["Searing Golden Blade"] = true,
		["Serenity"] = true,
		["Shadesteel Bracers"] = true,
		["Shadesteel Girdle"] = true,
		["Shadesteel Greaves"] = true,
		["Shadesteel Sabots"] = true,
		["Shadow Crescent Axe"] = true,
		["Shining Silver Breastplate"] = true,
		["Silver Rod"] = true,
		["Silver Skeleton Key"] = true,
		["Silvered Bronze Boots"] = true,
		["Silvered Bronze Breastplate"] = true,
		["Silvered Bronze Gauntlets"] = true,
		["Silvered Bronze Leggings"] = true,
		["Silvered Bronze Shoulders"] = true,
		["Skyforged Great Axe"] = true,
		["Solid Grinding Stone"] = true,
		["Solid Iron Maul"] = true,
		["Solid Sharpening Stone"] = true,
		["Solid Weightstone"] = true,
		["Steel Breastplate"] = true,
		["Steel Plate Helm"] = true,
		["Steel Weapon Chain"] = true,
		["Steelgrip Gauntlets"] = true,
		["Stoneforged Claymore"] = true,
		["Storm Gauntlets"] = true,
		["Storm Helm"] = true,
		["Stormforged Axe"] = true,
		["Stormforged Hauberk"] = true,
		["Stormherald"] = true,
		["Stronghold Gauntlets"] = true,
		["Sunblessed Breastplate"] = true,
		["Sunblessed Gauntlets"] = true,
		["Sulfuron Hammer"] = true,
		["Swiftsteel Bracers"] = true,
		["Swiftsteel Gloves"] = true,
		["Swiftsteel Shoulders"] = true,
		["The Planar Edge"] = true,
		["The Shatterer"] = true,
		["Thick Bronze Darts"] = true,
		["Thick Obsidian Breastplate"] = true,
		["Thick War Axe"] = true,
		["Thorium Armor"] = true,
		["Thorium Belt"] = true,
		["Thorium Boots"] = true,
		["Thorium Bracers"] = true,
		["Thorium Helm"] = true,
		["Thorium Leggings"] = true,
		["Thorium Shield Spike"] = true,
		["Thunder"] = true,
		["Titanic Leggings"] = true,
		["Truesilver Breastplate"] = true,
		["Truesilver Champion"] = true,
		["Truesilver Gauntlets"] = true,
		["Truesilver Rod"] = true,
		["Truesilver Skeleton Key"] = true,
		["Twisting Nether Chain Shirt"] = true,
		["Volcanic Hammer"] = true,
		["Whirling Steel Axes"] = true,
		["Whitesoul Helm"] = true,
		["Wicked Edge of the Planes"] = true,
		["Wicked Mithril Blade"] = true,
		["Wildguard Breastplate"] = true,
		["Wildguard Helm"] = true,
		["Wildguard Leggings"] = true,
		["Wildthorn Mail"] = true,
		["Windforged Leggings"] = true,
		["Windforged Rapier"] = true,

-- Cooking Recipes
		["Baked Salmon"] = true,
		["Barbecued Buzzard Wing"] = true,
		["Bat Bites"] = true,
		["Beer Basted Boar Ribs"] = true,
		["Big Bear Steak"] = true,
		["Blackened Basilisk"] = true,
		["Blackened Sporefish"] = true,
		["Blackened Trout"] = true,
		["Blood Sausage"] = true,
		["Boiled Clams"] = true,
		["Brilliant Smallfish"] = true,
		["Bristle Whisker Catfish"] = true,
		["Broiled Bloodfin"] = true,
		["Buzzard Bites"] = true,
		["Captain Rumsey's Lager"] = true,
		["Carrion Surprise"] = true,
		["Charred Bear Kabobs"] = true,
		["Charred Wolf Meat"] = true,
		["Clam Bar"] = true,
		["Clam Chowder"] = true,
		["Cooked Crab Claw"] = true,
		["Cooked Glossy Mightfish"] = true,
		["Coyote Steak"] = true,
		["Crab Cake"] = true,
		["Crispy Bat Wing"] = true,
		["Crispy Lizard Tail"] = true,
		["Crocolisk Gumbo"] = true,
		["Crocolisk Steak"] = true,
		["Crunchy Serpent"] = true,
		["Crunchy Spider Surprise"] = true,
		["Curiously Tasty Omelet"] = true,
		["Delicious Chocolate Cake"] = true,
		["Dig Rat Stew"] = true,
		["Dirge's Kickin' Chimaerok Chops"] = true,
		["Dragonbreath Chili"] = true,
		["Dry Pork Ribs"] = true,
		["Egg Nog"] = true,
		["Feltail Delight"] = true,
		["Filet of Redgill"] = true,
		["Fillet of Frenzy"] = true,
		["Fisherman's Feast"] = true,
		["Giant Clam Scorcho"] = true,
		["Gingerbread Cookie"] = true,
		["Goblin Deviled Clams"] = true,
		["Golden Fish Sticks"] = true,
		["Goldthorn Tea"] = true,
		["Gooey Spider Cake"] = true,
		["Goretusk Liver Pie"] = true,
		["Grilled Mudfish"] = true,
		["Grilled Squid"] = true,
		["Heavy Crocolisk Stew"] = true,
		["Heavy Kodo Stew"] = true,
		["Herb Baked Egg"] = true,
		["Hot Apple Cider"] = true,
		["Hot Buttered Trout"] = true,
		["Hot Lion Chops"] = true,
		["Hot Smoked Bass"] = true,
		["Hot Wolf Ribs"] = true,
		["Juicy Bear Burger"] = true,
		["Jungle Stew"] = true,
		["Kaldorei Spider Kabob"] = true,
		["Kibler's Bits"] = true,
		["Lean Venison"] = true,
		["Lean Wolf Steak"] = true,
		["Lobster Stew"] = true,
		["Loch Frenzy Delight"] = true,
		["Longjaw Mud Snapper"] = true,
		["Lynx Steak"] = true,
		["Mightfish Steak"] = true,
		["Mithril Headed Trout"] = true,
		["Mok'Nathal Shortribs"] = true,
		["Monster Omelet"] = true,
		["Murloc Fin Soup"] = true,
		["Mystery Stew"] = true,
		["Nightfin Soup"] = true,
		["Poached Bluefish"] = true,
		["Poached Sunscale Salmon"] = true,
		["Rainbow Fin Albacore"] = true,
		["Ravager Dog"] = true,
		["Redridge Goulash"] = true,
		["Roast Raptor"] = true,
		["Roasted Boar Meat"] = true,
		["Roasted Clefthoof"] = true,
		["Roasted Kodo Meat"] = true,
		["Roasted Moongraze Tenderloin"] = true,
		["Rockscale Cod"] = true,
		["Runn Tum Tuber Surprise"] = true,
		["Sagefish Delight"] = true,
		["Savory Deviate Delight"] = true,
		["Scorpid Surprise"] = true,
		["Seasoned Wolf Kabob"] = true,
		["Skullfish Soup"] = true,
		["Slitherskin Mackerel"] = true,
		["Smoked Bear Meat"] = true,
		["Smoked Desert Dumplings"] = true,
		["Smoked Sagefish"] = true,
		["Soothing Turtle Bisque"] = true,
		["Spice Bread"] = true,
		["Spiced Chili Crab"] = true,
		["Spiced Wolf Meat"] = true,
		["Spicy Crawdad"] = true,
		["Spicy Hot Talbuk"] = true,
		["Spider Sausage"] = true,
		["Sporeling Snack"] = true,
		["Spotted Yellowtail"] = true,
		["Stewed Trout"] = true,
		["Stormchops"] = true,
		["Strider Stew"] = true,
		["Succulent Pork Ribs"] = true,
		["Talbuk Steak"] = true,
		["Tasty Lion Steak"] = true,
		["Tender Wolf Steak"] = true,
		["Thistle Tea"] = true,
		["Undermine Clam Chowder"] = true,
		["Warp Burger"] = true,
		["Westfall Stew"] = true,

-- Enchanting Recipes
		["Brilliant Mana Oil"] = true,
		["Brilliant Wizard Oil"] = true,
		["Enchant 2H Weapon - Agility"] = true,
		["Enchant 2H Weapon - Greater Impact"] = true,
		["Enchant 2H Weapon - Impact"] = true,
		["Enchant 2H Weapon - Lesser Impact"] = true,
		["Enchant 2H Weapon - Lesser Intellect"] = true,
		["Enchant 2H Weapon - Lesser Spirit"] = true,
		["Enchant 2H Weapon - Major Agility"] = true,
		["Enchant 2H Weapon - Major Intellect"] = true,
		["Enchant 2H Weapon - Major Spirit"] = true,
		["Enchant 2H Weapon - Minor Impact"] = true,
		["Enchant 2H Weapon - Savagery"] = true,
		["Enchant 2H Weapon - Superior Impact"] = true,
		["Enchant Boots - Agility"] = true,
		["Enchant Boots - Boar's Speed"] = true,
		["Enchant Boots - Cat's Swiftness"] = true,
		["Enchant Boots - Dexterity"] = true,
		["Enchant Boots - Fortitude"] = true,
		["Enchant Boots - Greater Agility"] = true,
		["Enchant Boots - Greater Stamina"] = true,
		["Enchant Boots - Lesser Agility"] = true,
		["Enchant Boots - Lesser Spirit"] = true,
		["Enchant Boots - Lesser Stamina"] = true,
		["Enchant Boots - Minor Agility"] = true,
		["Enchant Boots - Minor Speed"] = true,
		["Enchant Boots - Minor Stamina"] = true,
		["Enchant Boots - Spirit"] = true,
		["Enchant Boots - Stamina"] = true,
		["Enchant Boots - Surefooted"] = true,
		["Enchant Boots - Vitality"] = true,
		["Enchant Bracer - Assault"] = true,
		["Enchant Bracer - Brawn"] = true,
		["Enchant Bracer - Deflection"] = true,
		["Enchant Bracer - Fortitude"] = true,
		["Enchant Bracer - Greater Intellect"] = true,
		["Enchant Bracer - Greater Spirit"] = true,
		["Enchant Bracer - Greater Stamina"] = true,
		["Enchant Bracer - Greater Strength"] = true,
		["Enchant Bracer - Healing Power"] = true,
		["Enchant Bracer - Intellect"] = true,
		["Enchant Bracer - Lesser Deflection"] = true,
		["Enchant Bracer - Lesser Intellect"] = true,
		["Enchant Bracer - Lesser Spirit"] = true,
		["Enchant Bracer - Lesser Stamina"] = true,
		["Enchant Bracer - Lesser Strength"] = true,
		["Enchant Bracer - Major Defense"] = true,
		["Enchant Bracer - Major Intellect"] = true,
		["Enchant Bracer - Mana Regeneration"] = true,
		["Enchant Bracer - Minor Agility"] = true,
		["Enchant Bracer - Minor Deflection"] = true,
		["Enchant Bracer - Minor Health"] = true,
		["Enchant Bracer - Minor Spirit"] = true,
		["Enchant Bracer - Minor Stamina"] = true,
		["Enchant Bracer - Minor Strength"] = true,
		["Enchant Bracer - Restore Mana Prime"] = true,
		["Enchant Bracer - Spellpower"] = true,
		["Enchant Bracer - Spirit"] = true,
		["Enchant Bracer - Stamina"] = true,
		["Enchant Bracer - Stats"] = true,
		["Enchant Bracer - Strength"] = true,
		["Enchant Bracer - Superior Healing"] = true,
		["Enchant Bracer - Superior Spirit"] = true,
		["Enchant Bracer - Superior Stamina"] = true,
		["Enchant Bracer - Superior Strength"] = true,
		["Enchant Chest - Defense"] = true,
		["Enchant Chest - Exceptional Health"] = true,
		["Enchant Chest - Exceptional Stats"] = true,
		["Enchant Chest - Greater Health"] = true,
		["Enchant Chest - Greater Mana"] = true,
		["Enchant Chest - Greater Stats"] = true,
		["Enchant Chest - Health"] = true,
		["Enchant Chest - Lesser Absorption"] = true,
		["Enchant Chest - Lesser Health"] = true,
		["Enchant Chest - Lesser Mana"] = true,
		["Enchant Chest - Lesser Stats"] = true,
		["Enchant Chest - Major Health"] = true,
		["Enchant Chest - Major Mana"] = true,
		["Enchant Chest - Major Resilience"] = true,
		["Enchant Chest - Major Spirit"] = true,
		["Enchant Chest - Mana"] = true,
		["Enchant Chest - Minor Absorption"] = true,
		["Enchant Chest - Minor Health"] = true,
		["Enchant Chest - Minor Mana"] = true,
		["Enchant Chest - Minor Stats"] = true,
		["Enchant Chest - Restore Mana Prime"] = true,
		["Enchant Chest - Stats"] = true,
		["Enchant Chest - Superior Health"] = true,
		["Enchant Chest - Superior Mana"] = true,
		["Enchant Cloak - Defense"] = true,
		["Enchant Cloak - Dodge"] = true,
		["Enchant Cloak - Fire Resistance"] = true,
		["Enchant Cloak - Greater Agility"] = true,
		["Enchant Cloak - Greater Arcane Resistance"] = true,
		["Enchant Cloak - Greater Defense"] = true,
		["Enchant Cloak - Greater Fire Resistance"] = true,
		["Enchant Cloak - Greater Nature Resistance"] = true,
		["Enchant Cloak - Greater Resistance"] = true,
		["Enchant Cloak - Greater Shadow Resistance"] = true,
		["Enchant Cloak - Lesser Agility"] = true,
		["Enchant Cloak - Lesser Fire Resistance"] = true,
		["Enchant Cloak - Lesser Protection"] = true,
		["Enchant Cloak - Lesser Shadow Resistance"] = true,
		["Enchant Cloak - Major Armor"] = true,
		["Enchant Cloak - Major Resistance"] = true,
		["Enchant Cloak - Minor Agility"] = true,
		["Enchant Cloak - Minor Protection"] = true,
		["Enchant Cloak - Minor Resistance"] = true,
		["Enchant Cloak - Resistance"] = true,
		["Enchant Cloak - Spell Penetration"] = true,
		["Enchant Cloak - Stealth"] = true,
		["Enchant Cloak - Steelweave"] = true,
		["Enchant Cloak - Subtlety"] = true,
		["Enchant Cloak - Superior Defense"] = true,
		["Enchant Gloves - Advanced Herbalism"] = true,
		["Enchant Gloves - Advanced Mining"] = true,
		["Enchant Gloves - Agility"] = true,
		["Enchant Gloves - Assault"] = true,
		["Enchant Gloves - Blasting"] = true,
		["Enchant Gloves - Fire Power"] = true,
		["Enchant Gloves - Fishing"] = true,
		["Enchant Gloves - Frost Power"] = true,
		["Enchant Gloves - Greater Agility"] = true,
		["Enchant Gloves - Greater Strength"] = true,
		["Enchant Gloves - Healing Power"] = true,
		["Enchant Gloves - Herbalism"] = true,
		["Enchant Gloves - Major Healing"] = true,
		["Enchant Gloves - Major Spellpower"] = true,
		["Enchant Gloves - Major Strength"] = true,
		["Enchant Gloves - Mining"] = true,
		["Enchant Gloves - Minor Haste"] = true,
		["Enchant Gloves - Riding Skill"] = true,
		["Enchant Gloves - Shadow Power"] = true,
		["Enchant Gloves - Skinning"] = true,
		["Enchant Gloves - Spell Strike"] = true,
		["Enchant Gloves - Strength"] = true,
		["Enchant Gloves - Superior Agility"] = true,
		["Enchant Gloves - Threat"] = true,
		["Enchant Ring - Healing Power"] = true,
		["Enchant Ring - Spellpower"] = true,
		["Enchant Ring - Stats"] = true,
		["Enchant Ring - Striking"] = true,
		["Enchant Shield - Frost Resistance"] = true,
		["Enchant Shield - Greater Spirit"] = true,
		["Enchant Shield - Greater Stamina"] = true,
		["Enchant Shield - Intellect"] = true,
		["Enchant Shield - Lesser Block"] = true,
		["Enchant Shield - Lesser Protection"] = true,
		["Enchant Shield - Lesser Spirit"] = true,
		["Enchant Shield - Lesser Stamina"] = true,
		["Enchant Shield - Major Stamina"] = true,
		["Enchant Shield - Minor Stamina"] = true,
		["Enchant Shield - Resistance"] = true,
		["Enchant Shield - Shield Block"] = true,
		["Enchant Shield - Spirit"] = true,
		["Enchant Shield - Stamina"] = true,
		["Enchant Shield - Superior Spirit"] = true,
		["Enchant Shield - Resilience"] = true,
		["Enchant Shield - Tough Shield"] = true,
		["Enchant Weapon - Agility"] = true,
		["Enchant Weapon - Battlemaster"] = true,
		["Enchant Weapon - Crusader"] = true,
		["Enchant Weapon - Deathfrost"] = true,
		["Enchant Weapon - Demonslaying"] = true,
		["Enchant Weapon - Executioner"] = true,
		["Enchant Weapon - Fiery Weapon"] = true,
		["Enchant Weapon - Greater Agility"] = true,
		["Enchant Weapon - Greater Striking"] = true,
		["Enchant Weapon - Healing Power"] = true,
		["Enchant Weapon - Icy Chill"] = true,
		["Enchant Weapon - Lesser Beastslayer"] = true,
		["Enchant Weapon - Lesser Elemental Slayer"] = true,
		["Enchant Weapon - Lesser Striking"] = true,
		["Enchant Weapon - Lifestealing"] = true,
		["Enchant Weapon - Major Healing"] = true,
		["Enchant Weapon - Major Intellect"] = true,
		["Enchant Weapon - Major Spellpower"] = true,
		["Enchant Weapon - Major Striking"] = true,
		["Enchant Weapon - Mighty Intellect"] = true,
		["Enchant Weapon - Mighty Spirit"] = true,
		["Enchant Weapon - Minor Beastslayer"] = true,
		["Enchant Weapon - Minor Striking"] = true,
		["Enchant Weapon - Mongoose"] = true,
		["Enchant Weapon - Potency"] = true,
		["Enchant Weapon - Soulfrost"] = true,
		["Enchant Weapon - Spell Power"] = true,
		["Enchant Weapon - Spellsurge"] = true,
		["Enchant Weapon - Strength"] = true,
		["Enchant Weapon - Striking"] = true,
		["Enchant Weapon - Sunfire"] = true,
		["Enchant Weapon - Superior Striking"] = true,
		["Enchant Weapon - Unholy Weapon"] = true,
		["Enchant Weapon - Winter's Might"] = true,
		["Enchanted Leather"] = true,
		["Enchanted Thorium"] = true,
		["Greater Magic Wand"] = true,
		["Greater Mystic Wand"] = true,
		["Large Prismatic Shard"] = true,
		["Lesser Magic Wand"] = true,
		["Lesser Mana Oil"] = true,
		["Lesser Mystic Wand"] = true,
		["Lesser Wizard Oil"] = true,
		["Minor Mana Oil"] = true,
		["Minor Wizard Oil"] = true,
		["Nexus Transformation"] = true,
		["Prismatic Sphere"] = true,
		["Runed Adamantite Rod"] = true,
		["Runed Arcanite Rod"] = true,
		["Runed Copper Rod"] = true,
		["Runed Eternium Rod"] = true,
		["Runed Fel Iron Rod"] = true,
		["Runed Golden Rod"] = true,
		["Runed Silver Rod"] = true,
		["Runed Truesilver Rod"] = true,
		["Small Prismatic Shard"] = true,
		["Smoking Heart of the Mountain"] = true,
		["Superior Mana Oil"] = true,
		["Superior Wizard Oil"] = true,
		["Void Shatter"] = true,
		["Void Sphere"] = true,
		["Wizard Oil"] = true,

-- Engineering Recipes
		["Accurate Scope"] = true,
		["Adamantite Arrow Maker"] = true,
		["Adamantite Frame"] = true,
		["Adamantite Grenade"] = true,
		["Adamantite Rifle"] = true,
		["Adamantite Scope"] = true,
		["Adamantite Shell Machine"] = true,
		["Advanced Target Dummy"] = true,
		["Alarm-O-Bot"] = true,
		["Aquadynamic Fish Attractor"] = true,
		["Arcane Bomb"] = true,
		["Arcanite Dragonling"] = true,
		["Arclight Spanner"] = true,
		["Big Bronze Bomb"] = true,
		["Big Iron Bomb"] = true,
		["Biznicks 247x128 Accurascope"] = true,
		["Bloodvine Goggles"] = true,
		["Bloodvine Lens"] = true,
		["Blue Firework"] = true,
		["Blue Rocket Cluster"] = true,
		["Bright-Eye Goggles"] = true,
		["Bronze Framework"] = true,
		["Bronze Tube"] = true,
		["Catseye Ultra Goggles"] = true,
		["Coarse Blasting Powder"] = true,
		["Coarse Dynamite"] = true,
		["Cogspinner Goggles"] = true,
		["Compact Harvest Reaper Kit"] = true,
		["Copper Modulator"] = true,
		["Copper Tube"] = true,
		["Core Marksman Rifle"] = true,
		["Crafted Heavy Shot"] = true,
		["Crafted Light Shot"] = true,
		["Crafted Solid Shot"] = true,
		["Craftsman's Monocle"] = true,
		["Crashin' Thrashin' Robot"] = true,
		["Crude Scope"] = true,
		["Dark Iron Bomb"] = true,
		["Dark Iron Rifle"] = true,
		["Deadly Blunderbuss"] = true,
		["Deadly Scope"] = true,
		["Deathblow X11 Goggles"] = true,
		["Deepdive Helmet"] = true,
		["Delicate Arcanite Converter"] = true,
		["Dense Blasting Powder"] = true,
		["Dense Dynamite"] = true,
		["Destruction Holo-gogs"] = true,
		["Dimensional Ripper - Area 52"] = true,
		["Dimensional Ripper - Everlook"] = true,
		["Discombobulator Ray"] = true,
		["Elemental Blasting Powder"] = true,
		["Elemental Seaforium Charge"] = true,
		["Explosive Sheep"] = true,
		["EZ-Thro Dynamite II"] = true,
		["EZ-Thro Dynamite"] = true,
		["Fel Iron Bomb"] = true,
		["Fel Iron Casing"] = true,
		["Fel Iron Musket"] = true,
		["Fel Iron Shells"] = true,
		["Fel Iron Toolbox"] = true,
		["Felsteel Boomstick"] = true,
		["Felsteel Stabilizer"] = true,
		["Field Repair Bot 110G"] = true,
		["Field Repair Bot 74A"] = true,
		["Fire Goggles"] = true,
		["Firework Cluster Launcher"] = true,
		["Firework Launcher"] = true,
		["Flame Deflector"] = true,
		["Flash Bomb"] = true,
		["Flawless Arcanite Rifle"] = true,
		["Flying Machine"] = true,
		["Flying Tiger Goggles"] = true,
		["Force Reactive Disk"] = true,
		["Foreman's Enchanted Helmet"] = true,
		["Foreman's Reinforced Helmet"] = true,
		["Frost Grenades"] = true,
		["Furious Gizmatic Goggles"] = true,
		["Fused Wiring"] = true,
		["Gadgetstorm Goggles"] = true,
		["Gnomish Battle Chicken"] = true,
		["Gnomish Battle Goggles"] = true,
		["Gnomish Cloaking Device"] = true,
		["Gnomish Death Ray"] = true,
		["Gnomish Flame Turret"] = true,
		["Gnomish Goggles"] = true,
		["Gnomish Harm Prevention Belt"] = true,
		["Gnomish Mind Control Cap"] = true,
		["Gnomish Net-o-Matic Projector"] = true,
		["Gnomish Poultryizer"] = true,
		["Gnomish Power Goggles"] = true,
		["Gnomish Rocket Boots"] = true,
		["Gnomish Shrink Ray"] = true,
		["Gnomish Universal Remote"] = true,
		["Goblin Bomb Dispenser"] = true,
		["Goblin Construction Helmet"] = true,
		["Goblin Dragon Gun"] = true,
		["Goblin Jumper Cables XL"] = true,
		["Goblin Jumper Cables"] = true,
		["Goblin Land Mine"] = true,
		["Goblin Mining Helmet"] = true,
		["Goblin Mortar"] = true,
		["Goblin Rocket Boots"] = true,
		["Goblin Rocket Fuel Recipe"] = true,
		["Goblin Rocket Helmet"] = true,
		["Goblin Rocket Launcher"] = true,
		["Goblin Sapper Charge"] = true,
		["Gold Power Core"] = true,
		["Green Firework"] = true,
		["Green Lens"] = true,
		["Green Rocket Cluster"] = true,
		["Green Smoke Flare"] = true,
		["Green Tinted Goggles"] = true,
		["Gyro-balanced Khorium Destroyer"] = true,
		["Gyrochronatom"] = true,
		["Gyrofreeze Ice Reflector"] = true,
		["Gyromatic Micro-Adjustor"] = true,
		["Handful of Copper Bolts"] = true,
		["Handful of Fel Iron Bolts"] = true,
		["Hardened Adamantite Tube"] = true,
		["Healing Potion Injector"] = true,
		["Heavy Blasting Powder"] = true,
		["Heavy Dynamite"] = true,
		["Hi-Explosive Bomb"] = true,
		["Hi-Impact Mithril Slugs"] = true,
		["Hyper-Radiant Flame Reflector"] = true,
		["Hyper-Vision Goggles"] = true,
		["Ice Deflector"] = true,
		["Icy Blasting Primers"] = true,
		["Inlaid Mithril Cylinder Plans"] = true,
		["Iron Grenade"] = true,
		["Iron Strut"] = true,
		["Justicebringer 2000 Specs"] = true,
		["Khorium Power Core"] = true,
		["Khorium Scope"] = true,
		["Large Blue Rocket Cluster"] = true,
		["Large Blue Rocket"] = true,
		["Large Copper Bomb"] = true,
		["Large Green Rocket Cluster"] = true,
		["Large Green Rocket"] = true,
		["Large Red Rocket Cluster"] = true,
		["Large Red Rocket"] = true,
		["Large Seaforium Charge"] = true,
		["Lifelike Mechanical Toad"] = true,
		["Lil' Smoky"] = true,
		["Living Replicator Specs"] = true,
		["Lovingly Crafted Boomstick"] = true,
		["Magnified Moon Specs"] = true,
		["Major Recombobulator"] = true,
		["Mana Potion Injector"] = true,
		["Master Engineer's Goggles"] = true,
		["Masterwork Target Dummy"] = true,
		["Mechanical Dragonling"] = true,
		["Mechanical Repair Kit"] = true,
		["Mechanical Squirrel"] = true,
		["Minor Recombobulator"] = true,
		["Mithril Blunderbuss"] = true,
		["Mithril Casing"] = true,
		["Mithril Frag Bomb"] = true,
		["Mithril Gyro-Shot"] = true,
		["Mithril Heavy-bore Rifle"] = true,
		["Mithril Mechanical Dragonling"] = true,
		["Mithril Tube"] = true,
		["Moonsight Rifle"] = true,
		["Nigh-Invulnerability Belt"] = true,
		["Ornate Khorium Rifle"] = true,
		["Ornate Spyglass"] = true,
		["Parachute Cloak"] = true,
		["Pet Bombling"] = true,
		["Portable Bronze Mortar"] = true,
		["Power Amplification Goggles"] = true,
		["Powerful Seaforium Charge"] = true,
		["Powerheal 4000 Lens"] = true,
		["Practice Lock"] = true,
		["Purple Smoke Flare"] = true,
		["Red Firework"] = true,
		["Red Rocket Cluster"] = true,
		["Rocket Boots Xtreme"] = true,
		["Rocket Boots Xtreme Lite"] = true,
		["Rose Colored Goggles"] = true,
		["Rough Blasting Powder"] = true,
		["Rough Boomstick"] = true,
		["Rough Copper Bomb"] = true,
		["Rough Dynamite"] = true,
		["Salt Shaker"] = true,
		["Shadow Goggles"] = true,
		["Silver Contact"] = true,
		["Silver-plated Shotgun"] = true,
		["Small Blue Rocket"] = true,
		["Small Bronze Bomb"] = true,
		["Small Green Rocket"] = true,
		["Small Red Rocket"] = true,
		["Small Seaforium Charge"] = true,
		["Snake Burst Firework"] = true,
		["Sniper Scope"] = true,
		["SnowMaster 9000"] = true,
		["Solid Blasting Powder"] = true,
		["Solid Dynamite"] = true,
		["Spellpower Goggles Xtreme Plus"] = true,
		["Spellpower Goggles Xtreme"] = true,
		["Stabilized Eternium Scope"] = true,
		["Standard Scope"] = true,
		["Steam Tonk Controller"] = true,
		["Super Sapper Charge"] = true,
		["Surestrike Goggles v2.0"] = true,
		["Tankatronic Goggles"] = true,
		["Target Dummy"] = true,
		["The Big One"] = true,
		["The Bigger One"] = true,
		["The Mortar: Reloaded"] = true,
		["Thorium Grenade"] = true,
		["Thorium Rifle"] = true,
		["Thorium Shells"] = true,
		["Thorium Tube"] = true,
		["Thorium Widget"] = true,
		["Tranquil Mechanical Yeti"] = true,
		["Truesilver Transformer"] = true,
		["Turbo-Charged Flying Machine"] = true,
		["Ultra-Flash Shadow Reflector"] = true,
		["Ultrasafe Transporter - Gadgetzan"] = true,
		["Ultrasafe Transporter - Toshley's Station"] = true,
		["Ultra-Spectropic Detection Goggles"] = true,
		["Unstable Trigger"] = true,
		["Voice Amplification Modulator"] = true,
		["Whirring Bronze Gizmo"] = true,
		["White Smoke Flare"] = true,
		["Wonderheal XT40 Shades"] = true,
		["World Enlarger"] = true,
		["Zapthrottle Mote Extractor"] = true,
		["Lightning Etched Specs"] = true,
		["Annihilator Holo-Gogs"] = true,
		["Primal-Attuned Goggles"] = true,
		["Powerheal 9000 Lens"] = true,
		["Justicebringer 3000 Specs"] = true,
		["Surestrike Goggles v3.0"] = true,
		["Hyper-Magnified Moon Specs"] = true,
		["Wonderheal XT68 Shades"] = true,
		["Hard Khorium Goggles"] = true,
		["Quad Deathblow X44 Goggles"] = true,
		["Mayhem Projection Goggles"] = true,

-- First Aid Recipes
		["Anti-Venom"] = true,
		["Heavy Linen Bandage"] = true,
		["Heavy Mageweave Bandage"] = true,
		["Heavy Netherweave Bandage"] = true,
		["Heavy Runecloth Bandage"] = true,
		["Heavy Silk Bandage"] = true,
		["Heavy Wool Bandage"] = true,
		["Linen Bandage"] = true,
		["Mageweave Bandage"] = true,
		["Netherweave Bandage"] = true,
		["Powerful Anti-Venom"] = true,
		["Runecloth Bandage"] = true,
		["Silk Bandage"] = true,
		["Strong Anti-Venom"] = true,
		["Wool Bandage"] = true,

-- Jewelcrafting Recipes
		["Amulet of Flowing Life"] = true,
		["Amulet of the Moon"] = true,
		["Aquamarine Pendant of the Warrior"] = true,
		["Aquamarine Signet"] = true,
		["Arcane Khorium Band"] = true,
		["Azure Moonstone Ring"] = true,
		["Balanced Nightseye"] = true,
		["Balanced Shadowsong Amethyst"] = true,
		["Balanced Shadow Draenite"] = true,
		["Band of Natural Fire"] = true,
		["Barbaric Iron Collar"] = true,
		["Blazing Citrine Ring"] = true,
		["Blazing Eternium Band"] = true,
		["Blood of Amber"] = true,
		["Bold Blood Garnet"] = true,
		["Bold Crimson Spinel"] = true,
		["Bold Living Ruby"] = true,
		["Bracing Earthstorm Diamond"] = true,
		["Braided Copper Ring"] = true,
		["Braided Eternium Chain"] = true,
		["Bright Blood Garnet"] = true,
		["Bright Crimson Spinel"] = true,
		["Bright Living Ruby"] = true,
		["Brilliant Dawnstone"] = true,
		["Brilliant Golden Draenite"] = true,
		["Brilliant Lionseye"] = true,
		["Brilliant Necklace"] = true,
		["Brilliant Pearl Band"] = true,
		["Bronze Band of Force"] = true,
		["Bronze Setting"] = true,
		["Bronze Torc"] = true,
		["Brutal Earthstorm Diamond"] = true,
		["Chain of the Twilight Owl"] = true,
		["Chaotic Skyfire Diamond"] = true,
		["Circlet of Arcane Might"] = true,
		["Citrine Pendant of Golden Healing"] = true,
		["Citrine Ring of Rapid Healing"] = true,
		["Coarse Stone Statue"] = true,
		["Coronet of the Verdant Flame"] = true,
		["Crimson Sun"] = true,
		["Crown of the Sea Witch"] = true,
		["Dazzling Deep Peridot"] = true,
		["Dazzling Seaspray Emerald"] = true,
		["Dazzling Talasite"] = true,
		["Delicate Blood Garnet"] = true,
		["Delicate Copper Wire"] = true,
		["Delicate Crimson Spinel"] = true,
		["Delicate Eternium Ring"] = true,
		["Delicate Living Ruby"] = true,
		["Dense Stone Statue"] = true,
		["Destructive Skyfire Diamond"] = true,
		["Diamond Focus Ring"] = true,
		["Don Julio's Heart"] = true,
		["Elegant Silver Ring"] = true,
		["Ember Skyfire Diamond"] = true,
		["Embrace of the Dawn"] = true,
		["Emerald Crown of Destruction"] = true,
		["Emerald Lion Ring"] = true,
		["Enduring Deep Peridot"] = true,
		["Enduring Seaspray Emerald"] = true,
		["Enduring Talasite"] = true,
		["Engraved Truesilver Ring"] = true,
		["Enigmatic Skyfire Diamond"] = true,
		["Eternal Earthstorm Diamond"] = true,
		["Eye of the Night"] = true,
		["Facet of Eternity"] = true,
		["Falling Star"] = true,
		["Fel Iron Blood Ring"] = true,
		["Figurine - Black Diamond Crab"] = true,
		["Figurine - Black Pearl Panther"] = true,
		["Figurine - Dark Iron Scorpid"] = true,
		["Figurine - Dawnstone Crab"] = true,
		["Figurine - Emerald Owl"] = true,
		["Figurine - Felsteel Boar"] = true,
		["Figurine - Golden Hare"] = true,
		["Figurine - Jade Owl"] = true,
		["Figurine - Living Ruby Serpent"] = true,
		["Figurine - Nightseye Panther"] = true,
		["Figurine - Ruby Serpent"] = true,
		["Figurine - Talasite Owl"] = true,
		["Figurine - Truesilver Boar"] = true,
		["Figurine - Truesilver Crab"] = true,
		["Flashing Crimson Spinel"] = true,
		["Flashing Living Ruby"] = true,
		["Gem Studded Band"] = true,
		["Gleaming Dawnstone"] = true,
		["Gleaming Golden Draenite"] = true,
		["Gleaming Lionseye"] = true,
		["Glinting Flame Spessarite"] = true,
		["Glinting Noble Topaz"] = true,
		["Glinting Pyrestone"] = true,
		["Gloom Band"] = true,
		["Glowing Nightseye"] = true,
		["Glowing Shadow Draenite"] = true,
		["Glowing Shadowsong Amethyst"] = true,
		["Glowing Thorium Band"] = true,
		["Golden Draenite Ring"] = true,
		["Golden Dragon Ring"] = true,
		["Golden Ring of Power"] = true,
		["Great Dawnstone"] = true,
		["Great Golden Draenite"] = true,
		["Great Lionseye"] = true,
		["Hard Khorium Band"] = true,
		["Hard Khorium Choker"] = true,
		["Heavy Adamantite Ring"] = true,
		["Heavy Copper Ring"] = true,
		["Heavy Felsteel Ring"] = true,
		["Heavy Golden Necklace of Battle"] = true,
		["Heavy Iron Knuckles"] = true,
		["Heavy Jade Ring"] = true,
		["Heavy Silver Ring"] = true,
		["Heavy Stone Statue"] = true,
		["Infused Nightseye"] = true,
		["Infused Shadow Draenite"] = true,
		["Infused Shadowsong Amethyst"] = true,
		["Inlaid Malachite Ring"] = true,
		["Inscribed Flame Spessarite"] = true,
		["Inscribed Noble Topaz"] = true,
		["Inscribed Pyrestone"] = true,
		["Insightful Earthstorm Diamond"] = true,
		["Jade Pendant of Blasting"] = true,
		["Jagged Deep Peridot"] = true,
		["Jagged Seaspray Emerald"] = true,
		["Jagged Talasite"] = true,
		["Kailee's Rose"] = true,
		["Khorium Band of Frost"] = true,
		["Khorium Band of Leaves"] = true,
		["Khorium Band of Shadows"] = true,
		["Khorium Inferno Band"] = true,
		["Living Emerald Pendant"] = true,
		["Living Ruby Pendant"] = true,
		["Loop of Forged Power"] = true,
		["Luminous Flame Spessarite"] = true,
		["Luminous Noble Topaz"] = true,
		["Luminous Pyrestone"] = true,
		["Lustrous Azure Moonstone"] = true,
		["Lustrous Empyrean Sapphire"] = true,
		["Lustrous Star of Elune"] = true,
		["Malachite Pendant"] = true,
		["Mercurial Adamantite"] = true,
		["Mithril Filigree"] = true,
		["Moonsoul Crown"] = true,
		["Mystic Dawnstone"] = true,
		["Mystic Lionseye"] = true,
		["Mystical Skyfire Diamond"] = true,
		["Necklace of the Deep"] = true,
		["Necklace of the Diamond Tower"] = true,
		["Onslaught Ring"] = true,
		["Opal Necklace of Impact"] = true,
		["Ornate Tigerseye Necklace"] = true,
		["Pendant of Frozen Flame"] = true,
		["Pendant of Shadow's End"] = true,
		["Pendant of Sunfire"] = true,
		["Pendant of Thawing"] = true,
		["Pendant of the Agate Shield"] = true,
		["Pendant of the Null Rune"] = true,
		["Pendant of Withering"] = true,
		["Potent Flame Spessarite"] = true,
		["Potent Noble Topaz"] = true,
		["Potent Pyrestone"] = true,
		["Powerful Earthstorm Diamond"] = true,
		["Purified Jaggal Pearl"] = true,
		["Purified Shadow Pearl"] = true,
		["Radiant Deep Peridot"] = true,
		["Radiant Seaspray Emerald"] = true,
		["Radiant Talasite"] = true,
		["Red Ring of Destruction"] = true,
		["Relentless Earthstorm Diamond"] = true,
		["Rigid Dawnstone"] = true,
		["Rigid Golden Draenite"] = true,
		["Rigid Lionseye"] = true,
		["Ring of Arcane Shielding"] = true,
		["Ring of Bitter Shadows"] = true,
		["Ring of Flowing Life"] = true,
		["Ring of Silver Might"] = true,
		["Ring of Twilight Shadows"] = true,
		["Rough Stone Statue"] = true,
		["Royal Nightseye"] = true,
		["Royal Shadow Draenite"] = true,
		["Royal Shadowsong Amethyst"] = true,
		["Ruby Crown of Restoration"] = true,
		["Ruby Pendant of Fire"] = true,
		["Runed Blood Garnet"] = true,
		["Runed Crimson Spinel"] = true,
		["Runed Living Ruby"] = true,
		["Sapphire Pendant of Winter Night"] = true,
		["Sapphire Signet"] = true,
		["Shifting Nightseye"] = true,
		["Shifting Shadow Draenite"] = true,
		["Shifting Shadowsong Amethyst"] = true,
		["Simple Opal Ring"] = true,
		["Simple Pearl Ring"] = true,
		["Smooth Dawnstone"] = true,
		["Smooth Golden Draenite"] = true,
		["Smooth Lionseye"] = true,
		["Solid Azure Moonstone"] = true,
		["Solid Bronze Ring"] = true,
		["Solid Empyrean Sapphire"] = true,
		["Solid Star of Elune"] = true,
		["Solid Stone Statue"] = true,
		["Sovereign Nightseye"] = true,
		["Sovereign Shadow Draenite"] = true,
		["Sovereign Shadowsong Amethyst"] = true,
		["Sparkling Azure Moonstone"] = true,
		["Sparkling Empyrean Sapphire"] = true,
		["Sparkling Star of Elune"] = true,
		["Steady Talasite"] = true,
		["Stone of Blades"] = true,
		["Stormy Azure Moonstone"] = true,
		["Stormy Empyrean Sapphire"] = true,
		["Stormy Star of Elune"] = true,
		["Subtle Crimson Spinel"] = true,
		["Subtle Living Ruby"] = true,
		["Swift Skyfire Diamond"] = true,
		["Teardrop Blood Garnet"] = true,
		["Teardrop Crimson Spinel"] = true,
		["Teardrop Living Ruby"] = true,
		["Tenacious Earthstorm Diamond"] = true,
		["The Aquamarine Ward"] = true,
		["The Black Pearl"] = true,
		["The Frozen Eye"] = true,
		["The Jade Eye"] = true,
		["The Natural Ward"] = true,
		["Thick Adamantite Necklace"] = true,
		["Thick Bronze Necklace"] = true,
		["Thick Dawnstone"] = true,
		["Thick Felsteel Necklace"] = true,
		["Thick Golden Draenite"] = true,
		["Thick Lionseye"] = true,
		["Thorium Setting"] = true,
		["Thundering Skyfire Diamond"] = true,
		["Tigerseye Band"] = true,
		["Truesilver Commander's Ring"] = true,
		["Truesilver Healing Ring"] = true,
		["Veiled Flame Spessarite"] = true,
		["Veiled Noble Topaz"] = true,
		["Veiled Pyrestone"] = true,
		["Wicked Flame Spessarite"] = true,
		["Wicked Moonstone Ring"] = true,
		["Wicked Noble Topaz"] = true,
		["Wicked Pyrestone"] = true,
		["Woven Copper Ring"] = true,
		["Quick Dawnstone"] = true,
		["Forceful Talasite"] = true,
		["Reckless Noble Topaz"] = true,
   		["Figurine - Empyrean Tortoise"] = true,
   		["Figurine - Khorium Boar"] = true,
   		["Figurine - Crimson Serpent"] = true,
   		["Figurine - Shadowsong Panther"] = true,
   		["Figurine - Seaspray Albatross"] = true,
   		["Regal Nightseye"] = true,
   		["Reckless Pyrestone"] = true,
   		["Quick Lionseye"] = true,
   		["Steady Seaspray Emerald"] = true,
   		["Forceful Seaspray Emerald"] = true,

-- Leatherworking Recipes
		["Arcane Armor Kit"] = true,
		["Bag of Many Hides"] = true,
		["Barbaric Belt"] = true,
		["Barbaric Bracers"] = true,
		["Barbaric Gloves"] = true,
		["Barbaric Harness"] = true,
		["Barbaric Leggings"] = true,
		["Barbaric Shoulders"] = true,
		["Belt of Deep Shadow"] = true,
		["Belt of Natural Power"] = true,
		["Belt of the Black Eagle"] = true,
		["Big Voodoo Cloak"] = true,
		["Big Voodoo Mask"] = true,
		["Big Voodoo Pants"] = true,
		["Big Voodoo Robe"] = true,
		["Bindings of Lightning Reflexes"] = true,
		["Black Dragonscale Boots"] = true,
		["Black Dragonscale Breastplate"] = true,
		["Black Dragonscale Leggings"] = true,
		["Black Dragonscale Shoulders"] = true,
		["Black Whelp Cloak"] = true,
		["Black Whelp Tunic"] = true,
		["Blackstorm Leggings"] = true,
		["Blastguard Belt"] = true,
		["Blastguard Boots"] = true,
		["Blastguard Pants"] = true,
		["Blood Tiger Breastplate"] = true,
		["Blood Tiger Shoulders"] = true,
		["Blue Dragonscale Breastplate"] = true,
		["Blue Dragonscale Leggings"] = true,
		["Blue Dragonscale Shoulders"] = true,
		["Boots of Natural Grace"] = true,
		["Boots of Shackled Souls"] = true,
		["Boots of the Crimson Hawk"] = true,
		["Boots of Utter Darkness"] = true,
		["Bracers of Renewed Life"] = true,
		["Bracers of Shackled Souls"] = true,
		["Bramblewood Belt"] = true,
		["Bramblewood Boots"] = true,
		["Bramblewood Helm"] = true,
		["Chimeric Boots"] = true,
		["Chimeric Gloves"] = true,
		["Chimeric Leggings"] = true,
		["Chimeric Vest"] = true,
		["Chromatic Cloak"] = true,
		["Chromatic Gauntlets"] = true,
		["Clefthide Leg Armor"] = true,
		["Cloak of Darkness"] = true,
		["Cobrahide Leg Armor"] = true,
		["Cobrascale Gloves"] = true,
		["Cobrascale Hood"] = true,
		["Comfortable Insoles"] = true,
		["Comfortable Leather Hat"] = true,
		["Core Armor Kit"] = true,
		["Corehound Belt"] = true,
		["Corehound Boots"] = true,
		["Cured Heavy Hide"] = true,
		["Cured Light Hide"] = true,
		["Cured Medium Hide"] = true,
		["Cured Rugged Hide"] = true,
		["Cured Thick Hide"] = true,
		["Dark Leather Belt"] = true,
		["Dark Leather Boots"] = true,
		["Dark Leather Cloak"] = true,
		["Dark Leather Gloves"] = true,
		["Dark Leather Pants"] = true,
		["Dark Leather Shoulders"] = true,
		["Dark Leather Tunic"] = true,
		["Dawn Treaders"] = true,
		["Deviate Scale Belt"] = true,
		["Deviate Scale Cloak"] = true,
		["Deviate Scale Gloves"] = true,
		["Devilsaur Gauntlets"] = true,
		["Devilsaur Leggings"] = true,
		["Dragonscale Breastplate"] = true,
		["Dragonscale Gauntlets"] = true,
		["Dragonstrike Leggings"] = true,
		["Dreamscale Breastplate"] = true,
		["Drums of Battle"] = true,
		["Drums of Panic"] = true,
		["Drums of Restoration"] = true,
		["Drums of Speed"] = true,
		["Drums of War"] = true,
		["Dusky Belt"] = true,
		["Dusky Boots"] = true,
		["Dusky Bracers"] = true,
		["Dusky Leather Armor"] = true,
		["Dusky Leather Leggings"] = true,
		["Earthen Leather Shoulders"] = true,
		["Earthen Netherscale Boots"] = true,
		["Ebon Netherscale Belt"] = true,
		["Ebon Netherscale Bracers"] = true,
		["Ebon Netherscale Breastplate"] = true,
		["Embossed Leather Boots"] = true,
		["Embossed Leather Cloak"] = true,
		["Embossed Leather Gloves"] = true,
		["Embossed Leather Pants"] = true,
		["Embossed Leather Vest"] = true,
		["Enchanted Clefthoof Boots"] = true,
		["Enchanted Clefthoof Gloves"] = true,
		["Enchanted Clefthoof Leggings"] = true,
		["Enchanted Felscale Boots"] = true,
		["Enchanted Felscale Gloves"] = true,
		["Enchanted Felscale Leggings"] = true,
		["Feathered Breastplate"] = true,
		["Fel Leather Boots"] = true,
		["Fel Leather Gloves"] = true,
		["Fel Leather Leggings"] = true,
		["Felscale Boots"] = true,
		["Felscale Breastplate"] = true,
		["Felscale Gloves"] = true,
		["Felscale Pants"] = true,
		["Felstalker Belt"] = true,
		["Felstalker Bracer"] = true,
		["Felstalker Breastplate"] = true,
		["Fine Leather Belt"] = true,
		["Fine Leather Boots"] = true,
		["Fine Leather Cloak"] = true,
		["Fine Leather Gloves"] = true,
		["Fine Leather Pants"] = true,
		["Fine Leather Tunic"] = true,
		["Flame Armor Kit"] = true,
		["Flamescale Belt"] = true,
		["Flamescale Boots"] = true,
		["Flamescale Leggings"] = true,
		["Fletcher's Gloves"] = true,
		["Frost Armor Kit"] = true,
		["Frost Leather Cloak"] = true,
		["Frostsaber Boots"] = true,
		["Frostsaber Gloves"] = true,
		["Frostsaber Leggings"] = true,
		["Frostsaber Tunic"] = true,
		["Gauntlets of the Sea"] = true,
		["Gem-studded Leather Belt"] = true,
		["Girdle of Insight"] = true,
		["Glove Reinforcements"] = true,
		["Gloves of the Greatfather"] = true,
		["Gloves of the Living Touch"] = true,
		["Golden Dragonstrike Breastplate"] = true,
		["Golden Mantle of the Dawn"] = true,
		["Greaves of Shackled Souls"] = true,
		["Green Dragonscale Breastplate"] = true,
		["Green Dragonscale Gauntlets"] = true,
		["Green Dragonscale Leggings"] = true,
		["Green Leather Armor"] = true,
		["Green Leather Belt"] = true,
		["Green Leather Bracers"] = true,
		["Green Whelp Armor"] = true,
		["Green Whelp Bracers"] = true,
		["Guardian Armor"] = true,
		["Guardian Belt"] = true,
		["Guardian Cloak"] = true,
		["Guardian Gloves"] = true,
		["Guardian Leather Bracers"] = true,
		["Guardian Pants"] = true,
		["Handstitched Leather Belt"] = true,
		["Handstitched Leather Boots"] = true,
		["Handstitched Leather Bracers"] = true,
		["Handstitched Leather Cloak"] = true,
		["Handstitched Leather Pants"] = true,
		["Handstitched Leather Vest"] = true,
		["Heavy Armor Kit"] = true,
		["Heavy Clefthoof Boots"] = true,
		["Heavy Clefthoof Leggings"] = true,
		["Heavy Clefthoof Vest"] = true,
		["Heavy Earthen Gloves"] = true,
		["Heavy Knothide Armor Kit"] = true,
		["Heavy Knothide Leather"] = true,
		["Heavy Leather Ammo Pouch"] = true,
		["Heavy Leather Ball"] = true,
		["Heavy Leather"] = true,
		["Heavy Quiver"] = true,
		["Heavy Scorpid Belt"] = true,
		["Heavy Scorpid Bracers"] = true,
		["Heavy Scorpid Gauntlets"] = true,
		["Heavy Scorpid Helm"] = true,
		["Heavy Scorpid Leggings"] = true,
		["Heavy Scorpid Shoulders"] = true,
		["Heavy Scorpid Vest"] = true,
		["Helm of Fire"] = true,
		["Herbalist's Gloves"] = true,
		["Hide of the Wild"] = true,
		["Hillman's Belt"] = true,
		["Hillman's Cloak"] = true,
		["Hillman's Leather Gloves"] = true,
		["Hillman's Leather Vest"] = true,
		["Hillman's Shoulders"] = true,
		["Hood of Primal Life"] = true,
		["Hurricane Boots"] = true,
		["Icy Scale Bracers"] = true,
		["Icy Scale Breastplate"] = true,
		["Icy Scale Gauntlets"] = true,
		["Ironfeather Breastplate"] = true,
		["Ironfeather Shoulders"] = true,
		["Knothide Ammo Pouch"] = true,
		["Knothide Armor Kit"] = true,
		["Knothide Leather"] = true,
		["Knothide Quiver"] = true,
		["Kodo Hide Bag"] = true,
		["Lava Belt"] = true,
		["Leatherworker's Satchel"] = true,
		["Light Armor Kit"] = true,
		["Light Leather Bracers"] = true,
		["Light Leather Pants"] = true,
		["Light Leather Quiver"] = true,
		["Light Leather"] = true,
		["Living Breastplate"] = true,
		["Living Crystal Breastplate"] = true,
		["Living Dragonscale Helm"] = true,
		["Living Earth Bindings"] = true,
		["Living Earth Shoulders"] = true,
		["Living Leggings"] = true,
		["Living Shoulders"] = true,
		["Magister's Armor Kit"] = true,
		["Medium Armor Kit"] = true,
		["Medium Leather"] = true,
		["Might of the Timbermaw"] = true,
		["Molten Belt"] = true,
		["Molten Helm"] = true,
		["Mongoose Boots"] = true,
		["Monsoon Belt"] = true,
		["Moonglow Vest"] = true,
		["Murloc Scale Belt"] = true,
		["Murloc Scale Bracers"] = true,
		["Murloc Scale Breastplate"] = true,
		["Nature Armor Kit"] = true,
		["Nethercleft Leg Armor"] = true,
		["Nethercobra Leg Armor"] = true,
		["Netherdrake Gloves"] = true,
		["Netherdrake Helm"] = true,
		["Netherfury Belt"] = true,
		["Netherfury Boots"] = true,
		["Netherfury Leggings"] = true,
		["Netherscale Ammo Pouch"] = true,
		["Netherstrike Belt"] = true,
		["Netherstrike Bracers"] = true,
		["Netherstrike Breastplate"] = true,
		["Nightscape Boots"] = true,
		["Nightscape Headband"] = true,
		["Nightscape Pants"] = true,
		["Nightscape Shoulders"] = true,
		["Nightscape Tunic"] = true,
		["Nimble Leather Gloves"] = true,
		["Onyxia Scale Cloak"] = true,
		["Pilferer's Gloves"] = true,
		["Polar Bracers"] = true,
		["Polar Gloves"] = true,
		["Polar Tunic"] = true,
		["Primal Batskin Bracers"] = true,
		["Primal Batskin Gloves"] = true,
		["Primal Batskin Jerkin"] = true,
		["Primalstorm Breastplate"] = true,
		["Primalstrike Belt"] = true,
		["Primalstrike Bracers"] = true,
		["Primalstrike Vest"] = true,
		["Quickdraw Quiver"] = true,
		["Quiver of a Thousand Feathers"] = true,
		["Raptor Hide Belt"] = true,
		["Raptor Hide Harness"] = true,
		["Red Dragonscale Breastplate"] = true,
		["Red Whelp Gloves"] = true,
		["Redeemed Soul Cinch"] = true,
		["Redeemed Soul Legguards"] = true,
		["Redeemed Soul Moccasins"] = true,
		["Redeemed Soul Wristguards"] = true,
		["Reinforced Mining Bag"] = true,
		["Riding Crop"] = true,
		["Rugged Armor Kit"] = true,
		["Rugged Leather Pants"] = true,
		["Rugged Leather"] = true,
		["Runic Leather Armor"] = true,
		["Runic Leather Belt"] = true,
		["Runic Leather Bracers"] = true,
		["Runic Leather Gauntlets"] = true,
		["Runic Leather Headband"] = true,
		["Runic Leather Pants"] = true,
		["Runic Leather Shoulders"] = true,
		["Sandstalker Bracers"] = true,
		["Sandstalker Breastplate"] = true,
		["Sandstalker Gauntlets"] = true,
		["Scaled Draenic Boots"] = true,
		["Scaled Draenic Gloves"] = true,
		["Scaled Draenic Pants"] = true,
		["Scaled Draenic Vest"] = true,
		["Shadow Armor Kit"] = true,
		["Shadowprowler's Chestguard"] = true,
		["Shadowskin Gloves"] = true,
		["Shifting Cloak"] = true,
		["Shoulderpads of Renewed Life"] = true,
		["Shoulders of Lightning Reflexes"] = true,
		["Small Leather Ammo Pouch"] = true,
		["Spitfire Bracers"] = true,
		["Spitfire Breastplate"] = true,
		["Spitfire Gauntlets"] = true,
		["Stormshroud Armor"] = true,
		["Stormshroud Gloves"] = true,
		["Stormshroud Pants"] = true,
		["Stormshroud Shoulders"] = true,
		["Stylin' Adventure Hat"] = true,
		["Stylin' Crimson Hat"] = true,
		["Stylin' Jungle Hat"] = true,
		["Stylin' Purple Hat"] = true,
		["Swift Boots"] = true,
		["Swift Flight Bracers"] = true,
		["Swiftstrike Bracers"] = true,
		["Swiftstrike Shoulders"] = true,
		["Thick Armor Kit"] = true,
		["Thick Draenic Boots"] = true,
		["Thick Draenic Gloves"] = true,
		["Thick Draenic Pants"] = true,
		["Thick Draenic Vest"] = true,
		["Thick Leather Ammo Pouch"] = true,
		["Thick Leather"] = true,
		["Thick Murloc Armor"] = true,
		["Thick Netherscale Breastplate"] = true,
		["Timbermaw Brawlers"] = true,
		["Tough Scorpid Boots"] = true,
		["Tough Scorpid Bracers"] = true,
		["Tough Scorpid Breastplate"] = true,
		["Tough Scorpid Gloves"] = true,
		["Tough Scorpid Helm"] = true,
		["Tough Scorpid Leggings"] = true,
		["Tough Scorpid Shoulders"] = true,
		["Toughened Leather Armor"] = true,
		["Toughened Leather Gloves"] = true,
		["Turtle Scale Bracers"] = true,
		["Turtle Scale Breastplate"] = true,
		["Turtle Scale Gloves"] = true,
		["Turtle Scale Helm"] = true,
		["Turtle Scale Leggings"] = true,
		["Vindicator's Armor Kit"] = true,
		["Volcanic Breastplate"] = true,
		["Volcanic Leggings"] = true,
		["Volcanic Shoulders"] = true,
		["Waistguard of Shackled Souls"] = true,
		["Warbear Harness"] = true,
		["Warbear Woolies"] = true,
		["White Leather Jerkin"] = true,
		["Wicked Leather Armor"] = true,
		["Wicked Leather Belt"] = true,
		["Wicked Leather Bracers"] = true,
		["Wicked Leather Gauntlets"] = true,
		["Wicked Leather Headband"] = true,
		["Wicked Leather Pants"] = true,
		["Wild Draenish Boots"] = true,
		["Wild Draenish Gloves"] = true,
		["Wild Draenish Leggings"] = true,
		["Wild Draenish Vest"] = true,
		["Wild Leather Boots"] = true,
		["Wild Leather Cloak"] = true,
		["Wild Leather Helmet"] = true,
		["Wild Leather Leggings"] = true,
		["Wild Leather Shoulders"] = true,
		["Wild Leather Vest"] = true,
		["Wildfeather Leggings"] = true,
		["Windhawk Belt"] = true,
		["Windhawk Bracers"] = true,
		["Windhawk Hauberk"] = true,
		["Windscale Hood"] = true,
		["Windslayer Wraps"] = true,
		["Windstrike Gloves"] = true,
		["Winter Boots"] = true,
		["Wolfshead Helm"] = true,
		["Leather Gauntlets of the Sun"] = true,
		["Leather Chestguard of the Sun"] = true,
		["Fletcher's Gloves of the Phoenix"] = true,
		["Embrace of the Phoenix"] = true,
		["Sun-Drenched Scale Gloves"] = true,
		["Sun-Drenched Scale Chestguard"] = true,
		["Carapace of Sun and Shadow"] = true,
		["Gloves of Immortal Dusk"] = true,

-- Smelting Recipes
		["Earth Shatter"] = true,
		["Fire Sunder"] = true,
		["Smelt Adamantite"] = true,
		["Smelt Bronze"] = true,
		["Smelt Copper"] = true,
		["Smelt Dark Iron"] = true,
		["Smelt Elementium"] = true,
		["Smelt Eternium"] = true,
		["Smelt Fel Iron"] = true,
		["Smelt Felsteel"] = true,
		["Smelt Gold"] = true,
		["Smelt Hardened Adamantite"] = true,
		["Smelt Hardened Khorium"] = true,
		["Smelt Iron"] = true,
		["Smelt Khorium"] = true,
		["Smelt Mithril"] = true,
		["Smelt Silver"] = true,
		["Smelt Steel"] = true,
		["Smelt Thorium"] = true,
		["Smelt Tin"] = true,
		["Smelt Truesilver"] = true,

-- Rogue Poison Recipes
		["Anesthetic Poison"] = true,
		["Blinding Powder"] = true,
		["Crippling Poison II"] = true,
		["Crippling Poison"] = true,
		["Deadly Poison II"] = true,
		["Deadly Poison III"] = true,
		["Deadly Poison IV"] = true,
		["Deadly Poison V"] = true,
		["Deadly Poison VI"] = true,
		["Deadly Poison VII"] = true,
		["Deadly Poison"] = true,
		["Instant Poison II"] = true,
		["Instant Poison III"] = true,
		["Instant Poison IV"] = true,
		["Instant Poison V"] = true,
		["Instant Poison VI"] = true,
		["Instant Poison VII"] = true,
		["Instant Poison"] = true,
		["Mind-numbing Poison II"] = true,
		["Mind-numbing Poison III"] = true,
		["Mind-numbing Poison"] = true,
		["Wound Poison II"] = true,
		["Wound Poison III"] = true,
		["Wound Poison IV"] = true,
		["Wound Poison V"] = true,
		["Wound Poison"] = true,

-- Tailoring Recipes
		["Admiral's Hat"] = true,
		["Arcanoweave Boots"] = true,
		["Arcanoweave Bracers"] = true,
		["Arcanoweave Robe"] = true,
		["Argent Boots"] = true,
		["Argent Shoulders"] = true,
		["Azure Shoulders"] = true,
		["Azure Silk Belt"] = true,
		["Azure Silk Cloak"] = true,
		["Azure Silk Gloves"] = true,
		["Azure Silk Hood"] = true,
		["Azure Silk Pants"] = true,
		["Azure Silk Vest"] = true,
		["Bag of Jewels"] = true,
		["Barbaric Linen Vest"] = true,
		["Battlecast Hood"] = true,
		["Battlecast Pants"] = true,
		["Belt of Blasting"] = true,
		["Belt of the Archmage"] = true,
		["Belt of the Long Road"] = true,
		["Big Bag of Enchantment"] = true,
		["Black Belt of Knowledge"] = true,
		["Black Mageweave Boots"] = true,
		["Black Mageweave Gloves"] = true,
		["Black Mageweave Headband"] = true,
		["Black Mageweave Leggings"] = true,
		["Black Mageweave Robe"] = true,
		["Black Mageweave Shoulders"] = true,
		["Black Mageweave Vest"] = true,
		["Black Silk Pack"] = true,
		["Black Swashbuckler's Shirt"] = true,
		["Blackstrike Bracers"] = true,
		["Bloodvine Boots"] = true,
		["Bloodvine Leggings"] = true,
		["Bloodvine Vest"] = true,
		["Blue Linen Robe"] = true,
		["Blue Linen Shirt"] = true,
		["Blue Linen Vest"] = true,
		["Blue Overalls"] = true,
		["Bolt of Imbued Netherweave"] = true,
		["Bolt of Linen Cloth"] = true,
		["Bolt of Mageweave"] = true,
		["Bolt of Netherweave"] = true,
		["Bolt of Runecloth"] = true,
		["Bolt of Silk Cloth"] = true,
		["Bolt of Soulcloth"] = true,
		["Bolt of Woolen Cloth"] = true,
		["Boots of Blasting"] = true,
		["Boots of the Enchanter"] = true,
		["Boots of the Long Road"] = true,
		["Bottomless Bag"] = true,
		["Bracers of Havok"] = true,
		["Bracers of Nimble Thought"] = true,
		["Bright Yellow Shirt"] = true,
		["Brightcloth Cloak"] = true,
		["Brightcloth Gloves"] = true,
		["Brightcloth Pants"] = true,
		["Brightcloth Robe"] = true,
		["Brown Linen Pants"] = true,
		["Brown Linen Robe"] = true,
		["Brown Linen Shirt"] = true,
		["Brown Linen Vest"] = true,
		["Cenarion Herb Bag"] = true,
		["Cindercloth Boots"] = true,
		["Cindercloth Cloak"] = true,
		["Cindercloth Gloves"] = true,
		["Cindercloth Pants"] = true,
		["Cindercloth Robe"] = true,
		["Cindercloth Vest"] = true,
		["Cloak of Arcane Evasion"] = true,
		["Cloak of Eternity"] = true,
		["Cloak of Fire"] = true,
		["Cloak of the Black Void"] = true,
		["Cloak of Warding"] = true,
		["Colorful Kilt"] = true,
		["Core Felcloth Bag"] = true,
		["Crimson Silk Belt"] = true,
		["Crimson Silk Cloak"] = true,
		["Crimson Silk Gloves"] = true,
		["Crimson Silk Pantaloons"] = true,
		["Crimson Silk Robe"] = true,
		["Crimson Silk Shoulders"] = true,
		["Crimson Silk Vest"] = true,
		["Dark Silk Shirt"] = true,
		["Double-stitched Woolen Shoulders"] = true,
		["Dreamweave Circlet"] = true,
		["Dreamweave Gloves"] = true,
		["Dreamweave Vest"] = true,
		["Earthen Silk Belt"] = true,
		["Earthen Vest"] = true,
		["Ebon Shadowbag"] = true,
		["Enchanted Mageweave Pouch"] = true,
		["Enchanted Runecloth Bag"] = true,
		["Enchanter's Cowl"] = true,
		["Felcloth Bag"] = true,
		["Felcloth Boots"] = true,
		["Felcloth Gloves"] = true,
		["Felcloth Hood"] = true,
		["Felcloth Pants"] = true,
		["Felcloth Robe"] = true,
		["Felcloth Shoulders"] = true,
		["Festival Dress"] = true,
		--["Festive Red Dress"] = true, doesn't exist?
		["Festive Red Pant Suit"] = true,
		["Flameheart Bracers"] = true,
		["Flameheart Gloves"] = true,
		["Flameheart Vest"] = true,
		["Flarecore Gloves"] = true,
		["Flarecore Leggings"] = true,
		["Flarecore Mantle"] = true,
		["Flarecore Robe"] = true,
		["Flarecore Wraps"] = true,
		["Formal White Shirt"] = true,
		["Frostweave Gloves"] = true,
		["Frostweave Pants"] = true,
		["Frostweave Robe"] = true,
		["Frostweave Tunic"] = true,
		["Frozen Shadoweave Boots"] = true,
		["Frozen Shadoweave Shoulders"] = true,
		["Frozen Shadoweave Robe"] = true,
		["Gaea's Embrace"] = true,
		["Ghostweave Belt"] = true,
		["Ghostweave Gloves"] = true,
		["Ghostweave Pants"] = true,
		["Ghostweave Vest"] = true,
		["Girdle of Ruination"] = true,
		["Glacial Cloak"] = true,
		["Glacial Gloves"] = true,
		["Glacial Vest"] = true,
		["Glacial Wrists"] = true,
		["Gloves of Meditation"] = true,
		["Gloves of Spell Mastery"] = true,
		["Golden Spellthread"] = true,
		["Gordok Ogre Suit"] = true,
		["Gray Woolen Robe"] = true,
		["Gray Woolen Shirt"] = true,
		["Greater Adept's Robe"] = true,
		["Green Holiday Shirt"] = true,
		["Green Linen Bracers"] = true,
		["Green Linen Shirt"] = true,
		["Green Silk Armor"] = true,
		["Green Silk Pack"] = true,
		["Green Silken Shoulders"] = true,
		["Green Winter Clothes"] = true,
		["Green Woolen Bag"] = true,
		["Green Woolen Vest"] = true,
		["Hands of Darkness"] = true,
		["Handstitched Linen Britches"] = true,
		["Heavy Linen Gloves"] = true,
		--["Heavy Netherweave Net"] = true,
		["Heavy Woolen Cloak"] = true,
		["Heavy Woolen Gloves"] = true,
		["Heavy Woolen Pants"] = true,
		["Icy Cloak"] = true,
		["Imbued Netherweave Bag"] = true,
		["Imbued Netherweave Boots"] = true,
		["Imbued Netherweave Pants"] = true,
		["Imbued Netherweave Robe"] = true,
		["Imbued Netherweave Tunic"] = true,
		["Inferno Gloves"] = true,
		["Lavender Mageweave Shirt"] = true,
		["Lesser Wizard's Robe"] = true,
		["Linen Bag"] = true,
		["Linen Belt"] = true,
		["Linen Boots"] = true,
		["Linen Cloak"] = true,
		["Long Silken Cloak"] = true,
		["Mageweave Bag"] = true,
		["Manaweave Cloak"] = true,
		["Mantle of Nimble Thought"] = true,
		["Mantle of the Timbermaw"] = true,
		["Mooncloth Bag"] = true,
		["Mooncloth Boots"] = true,
		["Mooncloth Circlet"] = true,
		["Mooncloth Gloves"] = true,
		["Mooncloth Leggings"] = true,
		["Mooncloth Robe"] = true,
		["Mooncloth Shoulders"] = true,
		["Mooncloth Vest"] = true,
		["Mooncloth"] = true,
		["Mystic Spellthread"] = true,
		["Netherweave Bag"] = true,
		["Netherweave Belt"] = true,
		["Netherweave Boots"] = true,
		["Netherweave Bracers"] = true,
		["Netherweave Gloves"] = true,
		["Netherweave Net"] = true,
		["Netherweave Pants"] = true,
		["Netherweave Robe"] = true,
		["Netherweave Tunic"] = true,
		["Night's End"] = true,
		["Orange Mageweave Shirt"] = true,
		["Orange Martial Shirt"] = true,
		["Pearl-clasped Cloak"] = true,
		["Phoenix Gloves"] = true,
		["Phoenix Pants"] = true,
		["Pink Mageweave Shirt"] = true,
		["Primal Mooncloth Bag"] = true,
		["Primal Mooncloth Belt"] = true,
		["Primal Mooncloth Robe"] = true,
		["Primal Mooncloth Shoulders"] = true,
		["Primal Mooncloth"] = true,
		["Red Linen Bag"] = true,
		["Red Linen Robe"] = true,
		["Red Linen Shirt"] = true,
		["Red Linen Vest"] = true,
		["Red Mageweave Bag"] = true,
		["Red Mageweave Gloves"] = true,
		["Red Mageweave Headband"] = true,
		["Red Mageweave Pants"] = true,
		["Red Mageweave Shoulders"] = true,
		["Red Mageweave Vest"] = true,
		["Red Swashbuckler's Shirt"] = true,
		["Red Woolen Bag"] = true,
		["Red Woolen Boots"] = true,
		["Reinforced Linen Cape"] = true,
		["Red Winter Clothes"] = true,
		["Reinforced Woolen Shoulders"] = true,
		["Resolute Cape"] = true,
		["Rich Purple Silk Shirt"] = true,
		["Robe of Power"] = true,
		["Robe of the Archmage"] = true,
		["Robe of the Void"] = true,
		["Robe of Winter Night"] = true,
		["Robes of Arcana"] = true,
		["Runecloth Bag"] = true,
		["Runecloth Belt"] = true,
		["Runecloth Boots"] = true,
		["Runecloth Cloak"] = true,
		["Runecloth Gloves"] = true,
		["Runecloth Headband"] = true,
		["Runecloth Pants"] = true,
		["Runecloth Robe"] = true,
		["Runecloth Shoulders"] = true,
		["Runecloth Tunic"] = true,
		["Runed Stygian Belt"] = true,
		["Runed Stygian Boots"] = true,
		["Runed Stygian Leggings"] = true,
		["Runic Spellthread"] = true,
		["Satchel of Cenarius"] = true,
		["Shadow Hood"] = true,
		["Shadowcloth"] = true,
		["Shadoweave Boots"] = true,
		["Shadoweave Gloves"] = true,
		["Shadoweave Mask"] = true,
		["Shadoweave Pants"] = true,
		["Shadoweave Robe"] = true,
		["Shadoweave Shoulders"] = true,
		["Silk Headband"] = true,
		["Silver Spellthread"] = true,
		["Simple Black Dress"] = true,
		["Simple Dress"] = true,
		["Simple Kilt"] = true,
		["Simple Linen Boots"] = true,
		["Simple Linen Pants"] = true,
		["Small Silk Pack"] = true,
		["Soft-soled Linen Boots"] = true,
		["Soul Pouch"] = true,
		["Soulcloth Gloves"] = true,
		["Soulcloth Shoulders"] = true,
		["Soulcloth Vest"] = true,
		["Soulguard Bracers"] = true,
		["Soulguard Girdle"] = true,
		["Soulguard Leggings"] = true,
		["Soulguard Slippers"] = true,
		["Spellcloth"] = true,
		["Spellfire Bag"] = true,
		["Spellfire Belt"] = true,
		["Spellfire Gloves"] = true,
		["Spellfire Robe"] = true,
		["Spellstrike Hood"] = true,
		["Spellstrike Pants"] = true,
		["Spider Belt"] = true,
		["Spider Silk Slippers"] = true,
		["Spidersilk Boots"] = true,
		["Star Belt"] = true,
		["Stylish Blue Shirt"] = true,
		["Stylish Green Shirt"] = true,
		["Stylish Red Shirt"] = true,
		["Swiftheal Mantle"] = true,
		["Swiftheal Wraps"] = true,
		["Sylvan Crown"] = true,
		["Sylvan Shoulders"] = true,
		["Sylvan Vest"] = true,
		["Truefaith Gloves"] = true,
		["Truefaith Vestments"] = true,
		["Tuxedo Jacket"] = true,
		["Tuxedo Pants"] = true,
		["Tuxedo Shirt"] = true,
		["Unyielding Bracers"] = true,
		["Unyielding Girdle"] = true,
		["Vengeance Wrap"] = true,
		["White Bandit Mask"] = true,
		["White Linen Robe"] = true,
		["White Linen Shirt"] = true,
		["White Remedy Cape"] = true,
		["White Swashbuckler's Shirt"] = true,
		["White Wedding Dress"] = true,
		["White Woolen Dress"] = true,
		["Whitemend Hood"] = true,
		["Whitemend Pants"] = true,
		["Wisdom of the Timbermaw"] = true,
		["Wizardweave Leggings"] = true,
		["Wizardweave Robe"] = true,
		["Wizardweave Turban"] = true,
		["Woolen Bag"] = true,
		["Woolen Boots"] = true,
		["Woolen Cape"] = true,
		["Sunfire Robe"] = true,
		["Sunfire Handwraps"] = true,
		["Robe of Eternal Light"] = true,
		["Hands of Eternal Light"] = true,

	}
end)

BabbleTradeskill:RegisterTranslations("deDE", function()
	return {
-- Gathering skills
		["Disenchant"] = "Entzaubern",
		["Fishing"] = "Angeln",
		["Herbalism"] = "Kräuterkunde",
		["Mining"] = "Bergbau",
		["Pick Pocket"] = "Taschendiebstahl",
		["Prospecting"] = "Sondieren",
		["Skinning"] = "Kürschnerei",
		["Smelting"] = "Verhüttung",
		["Riding"] = "Reiten",

-- Crafting skills
		["Alchemy"] = "Alchimie",
		["Armorsmith"] = "Rüstungsschmied",
		["Blacksmithing"] = "Schmiedekunst",
		["Cooking"] = "Kochkunst",
		["Dragonscale Leatherworking"] = "Drachenschuppenlederverarbeitung",
		["Elemental Leatherworking"] = "Elementarlederverarbeitung",
		["Elixir Master"] = "Meister der Elixiere",
		["Enchanting"] = "Verzauberkunst",
		["Engineering"] = "Ingenieurskunst",
		["First Aid"] = "Erste Hilfe",
		["Gnomish Engineering"] = "Gnomeningenieur",
		["Goblin Engineering"] = "Gobliningenieur",
		["Gnomish Engineer"] = "Gnomeningenieur",
		["Goblin Engineer"] = "Gobliningenieur",
		["Jewelcrafting"] = "Juwelenschleifen",
		["Leatherworking"] = "Lederverarbeitung",
		["Master Axesmith"] = "Axtschmied",
		["Master Hammersmith"] = "Hammerschmied",
		["Master Swordsmith"] = "Schwertschmied",
		["Mooncloth Tailoring"] = "Mondstoffschneiderei",
		["Poisons"] = "Gifte",
		["Potion Master"] = "Meister der Tränke",
		["Shadoweave Tailoring"] = "Schattenzwirnschneiderei",
		["Spellfire Tailoring"] = "Zauberfeuerschneiderei",
		["Tailoring"] = "Schneiderei",
		["Transmutation Master"] = "Meister der Transmutation",
		["Tribal Leatherworking"] = "Stammeslederverarbeitung",
		["Weaponsmith"] = "Waffenschmied",

-- Alchemy Recipes
		["Adept's Elixir"] = "Elixier des Adepten",
		["Alchemist's Stone"] = "Alchimistenstein",
		["Arcane Elixir"] = "Arkanes Elixier",
		["Blackmouth Oil"] = "Schwarzmaulöl",
		["Catseye Elixir"] = "Katzenaugenelixier",
		["Cauldron of Major Arcane Protection"] = "Kessel des erheblichen Arkanschutzes",
		["Cauldron of Major Fire Protection"] = "Kessel des erheblichen Feuerschutzes",
		["Cauldron of Major Frost Protection"] = "Kessel des erheblichen Frostschutzes",
		["Cauldron of Major Nature Protection"] = "Kessel des erheblichen Naturschutzes",
		["Cauldron of Major Shadow Protection"] = "Kessel des erheblichen Schattenschutzes",
		["Destruction Potion"] = "Zerstörungstrank",
		["Discolored Healing Potion"] = "Verfärbter Heiltrank",
		["Dreamless Sleep Potion"] = "Trank des traumlosen Schlafs",
		["Earthen Elixir"] = "Erdelixier",
		["Elixir of Agility"] = "Elixier der Beweglichkeit",
		["Elixir of Brute Force"] = "Elixier der rohen Gewalt",
		["Elixir of Camouflage"] = "Elixier der Tarnung",
		["Elixir of Defense"] = "Elixier der Verteidigung",
		["Elixir of Demonslaying"] = "Elixier des Dämonentötens",
		["Elixir of Detect Demon"] = "Elixier der Dämonenentdeckung",
		["Elixir of Detect Lesser Invisibility"] = "Elixier der Entd. geringer Unsichtbarkeit",
		["Elixir of Detect Undead"] = "Elixier der Untotenentdeckung",
		["Elixir of Draenic Wisdom"] = "Elixier der draenischen Weisheit",
		["Elixir of Dream Vision"] = "Elixier der Traumvision",
		["Elixir of Empowerment"] = "Elixier der Schwächung",
		["Elixir of Firepower"] = "Elixier der Feuermacht",
		["Elixir of Fortitude"] = "Elixier der Seelenstärke",
		["Elixir of Frost Power"] = "Elixier der Frostmacht",
		["Elixir of Giant Growth"] = "Elixier des Riesenwuchses",
		["Elixir of Giants"] = "Elixier der Riesen",
		["Elixir of Greater Agility"] = "Elixier der großen Beweglichkeit",
		["Elixir of Greater Defense"] = "Elixier der großen Verteidigung",
		["Elixir of Greater Firepower"] = "Elixier der großen Feuermacht",
		["Elixir of Greater Intellect"] = "Elixier der großen Intelligenz",
		["Elixir of Greater Water Breathing"] = "Elixier der verbesserten Wasseratmung",
		["Elixir of Healing Power"] = "Elixier der Heilkraft",
		["Elixir of Ironskin"] = "Elixier der Eisenhaut",
		["Elixir of Lesser Agility"] = "Elixier der geringen Beweglichkeit",
		["Elixir of Lion's Strength"] = "Elixier der Löwenstärke",
		["Elixir of Major Agility"] = "Elixier der erheblichen Beweglichkeit",
		["Elixir of Major Defense"] = "Elixier der erheblichen Verteidigung",
		["Elixir of Major Firepower"] = "Elixier der erheblichen Feuermacht",
		["Elixir of Major Fortitude"] = "Elixier der erheblichen Seelenstärke",
		["Elixir of Major Frost Power"] = "Elixier der erheblichen Frostmacht",
		["Elixir of Major Mageblood"] = "Elixier des erheblichen Magierbluts",
		["Elixir of Major Shadow Power"] = "Elixier der erheblichen Schattenmacht",
		["Elixir of Major Strength"] = "Elixier der erheblichen Stärke",
		["Elixir of Mastery"] = "Elixier des Meisters",
		["Elixir of Minor Agility"] = "Elixier der schwachen Beweglichkeit",
		["Elixir of Minor Defense"] = "Elixier der schwachen Verteidigung",
		["Elixir of Minor Fortitude"] = "Elixier der schwachen Seelenstärke",
		["Elixir of Ogre's Strength"] = "Elixier der Ogerstärke",
		["Elixir of Shadow Power"] = "Elixier der Schattenmacht",
		["Elixir of Superior Defense"] = "Elixier der überragenden Verteidigung",
		["Elixir of the Mongoose"] = "Elixier des Mungos",
		["Elixir of the Sages"] = "Elixier der Weisen",
		["Elixir of the Searching Eye"] = "Elixier des suchenden Auges",
		["Elixir of Water Breathing"] = "Elixier der Wasseratmung",
		["Elixir of Wisdom"] = "Elixier der Weisheit",
		["Fel Mana Potion"] = "Teufelsmanatrank",
		["Fel Regeneration Potion"] = "Teufelsregenerationstrank",
		["Fel Strength Elixir"] = "Elixier der Teufelsstärke",
		["Fire Oil"] = "Feueröl",
		["Fire Protection Potion"] = "Feuerschutztrank",
		["Flask of Blinding Light"] = "Fläschchen des blendenden Lichts",
		["Flask of Chromatic Resistance"] = "Fläschchen des chromatischen Widerstands",
		["Flask of Chromatic Wonder"] = "Fläschchen des chromatischen Wunders",
		["Flask of Distilled Wisdom"] = "Fläschchen der destillierten Weisheit",
		["Flask of Fortification"] = "Fläschchen der Stärkung",
		["Flask of Mighty Restoration"] = "Fläschchen der mächtigen Wiederherstellung",
		["Flask of Petrification"] = "Fläschchen der Versteinerung",
		["Flask of Pure Death"] = "Fläschchen des reinen Todes",
		["Flask of Relentless Assault"] = "Fläschchen des unerbittlichen Angriffs",
		["Flask of Supreme Power"] = "Fläschchen der obersten Macht",
		["Flask of the Titans"] = "Fläschchen der Titanen",
		["Free Action Potion"] = "Trank der freien Aktion",
		["Frost Oil"] = "Frostöl",
		["Frost Protection Potion"] = "Frostschutztrank",
		["Ghost Dye"] = "Geisterfarbstoff",
		["Gift of Arthas"] = "Arthas' Gabe", -- herb is Arthas’ Tränen (punctuation apostrophe Unicode: U+2019), recipe is Arthas' Gabe
		["Goblin Rocket Fuel"] = "Goblinraketentreibstoff",
		["Great Rage Potion"] = "Großer Wuttrank",
		["Greater Arcane Elixir"] = "Großes Arkanelixier",
		["Greater Arcane Protection Potion"] = "Großer Arkanschutztrank",
		["Greater Dreamless Sleep Potion"] = "Großer Trank des traumlosen Schlafs",
		["Greater Fire Protection Potion"] = "Großer Feuerschutztrank",
		["Greater Frost Protection Potion"] = "Großer Frostschutztrank",
		["Greater Healing Potion"] = "Großer Heiltrank",
		["Greater Mana Potion"] = "Großer Manatrank",
		["Greater Nature Protection Potion"] = "Großer Naturschutztrank",
		["Greater Shadow Protection Potion"] = "Großer Schattenschutztrank",
		["Greater Stoneshield Potion"] = "Großer Steinschildtrank",
		["Gurubashi Mojo Madness"] = "Mojowahnsinn der Gurubashi",
		["Haste Potion"] = "Hasttrank",
		["Healing Potion"] = "Heiltrank",
		["Heroic Potion"] = "Heldentrank",
		["Holy Protection Potion"] = "Heiligschutztrank",
		["Insane Strength Potion"] = "Trank der Wahnsinnsstärke",
		["Invisibility Potion"] = "Unsichtbarkeitstrank",
		["Ironshield Potion"] = "Eisenschildtrank",
		["Lesser Healing Potion"] = "Geringer Heiltrank",
		["Lesser Invisibility Potion"] = "Geringer Unsichtbarkeitstrank",
		["Lesser Mana Potion"] = "Geringer Manatrank",
		["Lesser Stoneshield Potion"] = "Geringer Steinschildtrank",
		["Limited Invulnerability Potion"] = "Begrenzter Unverwundbarkeitstrank",
		["Living Action Potion"] = "Trank der lebhaften Aktion",
		["Mad Alchemist's Potion"] = "Trank des verrückten Alchimisten",
		["Mageblood Potion"] = "Magierbluttrank",
		["Magic Resistance Potion"] = "Magiewiderstandstrank",
		["Major Arcane Protection Potion"] = "Erheblicher Arkanschutztrank",
		["Major Dreamless Sleep Potion"] = "Erheblicher Trank des traumlosen Schlafs",
		["Major Fire Protection Potion"] = "Erheblicher Feuerschutztrank",
		["Major Frost Protection Potion"] = "Erheblicher Frostschutztrank",
		["Major Healing Potion"] = "Erheblicher Heiltrank",
		["Major Holy Protection Potion"] = "Erheblicher Heiligschutztrank",
		["Major Mana Potion"] = "Erheblicher Manatrank",
		["Major Nature Protection Potion"] = "Erheblicher Naturschutztrank",
		["Major Rejuvenation Potion"] = "Erheblicher Verjüngungstrank",
		["Major Shadow Protection Potion"] = "Erheblicher Schattenschutztrank",
		["Major Troll's Blood Potion"] = "Erheblicher Trollbluttrank",
		["Mana Potion"] = "Manatrank",
		["Mercurial Stone"] = "Quecksilberstein",
		["Mighty Rage Potion"] = "Mächtiger Wuttrank",
		["Mighty Troll's Blood Potion"] = "Mächtiger Trollbluttrank",
		["Minor Healing Potion"] = "Schwacher Heiltrank",
		["Minor Magic Resistance Potion"] = "Schwacher Magiewiderstandstrank",
		["Minor Mana Potion"] = "Schwacher Manatrank",
		["Minor Rejuvenation Potion"] = "Schwacher Verjüngungstrank",
		["Nature Protection Potion"] = "Naturschutztrank",
		["Oil of Immolation"] = "Öl des Feuerbrandes",
		["Onslaught Elixir"] = "Elixier des Ansturms",
		["Philosopher's Stone"] = "Stein der Weisen",
		["Potion of Curing"] = "Trank der Genesung",
		["Purification Potion"] = "Läuterungstrank",
		["Rage Potion"] = "Wuttrank",
		["Restorative Potion"] = "Regenerationstrank",
		["Shadow Oil"] = "Schattenöl",
		["Shadow Protection Potion"] = "Schattenschutztrank",
		["Shrouding Potion"] = "Verschleierungstrank",
		["Sneaking Potion"] = "Schleichtrank",
		["Stonescale Oil"] = "Steinschuppenöl",
		["Strong Troll's Blood Potion"] = "Starker Trollbluttrank",
		["Super Healing Potion"] = "Erstklassiger Heiltrank",
		["Super Mana Potion"] = "Erstklassiger Manatrank",
		["Super Rejuvenation Potion"] = "Erstklassiger Verjüngungstrank",
		["Superior Healing Potion"] = "Überragender Heiltrank",
		["Superior Mana Potion"] = "Überragender Manatrank",
		["Swiftness Potion"] = "Hurtigkeitstrank",
		["Swim Speed Potion"] = "Schwimmtempotrank",
		["Transmute: Air to Fire"] = "Transmutieren: Luft zu Feuer",
		["Transmute: Arcanite"] = "Transmutieren: Arkanit",
		["Transmute: Earth to Life"] = "Transmutieren: Erde zu Leben",
		["Transmute: Earth to Water"] = "Transmutieren: Erde zu Wasser",
		["Transmute: Earthstorm Diamond"] = "Transmutieren: Erdsturmdiamant",
		["Transmute: Elemental Fire"] = "Elementarfeuer transmutieren",
		["Transmute: Fire to Earth"] = "Transmutieren: Feuer zu Erde",
		["Transmute: Iron to Gold"] = "Transmutieren: Eisen in Gold",
		["Transmute: Life to Earth"] = "Transmutieren: Leben zu Erde",
		["Transmute: Mithril to Truesilver"] = "Transmutieren: Mithril in Echtsilber",
		["Transmute: Primal Air to Fire"] = "Transmutieren: Urluft zu Feuer",
		["Transmute: Primal Earth to Life"] = "Transmutieren: Urerde zu Leben",
		["Transmute: Primal Earth to Water"] = "Transmutieren: Urerde zu Wasser",
		["Transmute: Primal Fire to Earth"] = "Transmutieren: Urfeuer  zu Erde", -- 2 spaces
		["Transmute: Primal Fire to Mana"] = "Transmutieren: Urfeuer zu Mana",
		["Transmute: Primal Life to Earth"] = "Transmutieren: Urleben zu Erde",
		["Transmute: Primal Mana to Fire"] = "Transmutieren: Urmana zu Feuer",
		["Transmute: Primal Might"] = "Transmutieren: Urmacht",
		["Transmute: Primal Shadow to Water"] = "Transmutieren: Urschatten zu Wasser",
		["Transmute: Primal Water to Air"] = "Transmutieren: Urwasser zu Luft",
		["Transmute: Primal Water to Shadow"] = "Transmutieren: Urwasser zu Schatten",
		["Transmute: Skyfire Diamond"] = "Transmutieren: Himmelsfeuerdiamant",
		["Transmute: Undeath to Water"] = "Transmutieren: Untod zu Wasser",
		["Transmute: Water to Air"] = "Transmutieren: Wasser zu Luft",
		["Transmute: Water to Undeath"] = "Transmutieren: Wasser zu Untod",
		["Unstable Mana Potion"] = "Instabiler Manatrank",
		["Volatile Healing Potion"] = "Flüchtiger Heiltrank",
		["Weak Troll's Blood Potion"] = "Schwacher Trollbluttrank",
		["Wildvine Potion"] = "Wildrankentrank",
		--["Assassin's Alchemist Stone"] = true,
		--["Guardian's Alchemist Stone"] = true,
		--["Redeemer's Alchemist Stone"] = true,
		--["Sorcerer's Alchemist Stone"] = true,

-- Beast Training Skills
		["Arcane Resistance (Rank 1)"] = "Arkanwiderstand (Rang 1)",
		["Arcane Resistance (Rank 2)"] = "Arkanwiderstand (Rang 2)",
		["Arcane Resistance (Rank 3)"] = "Arkanwiderstand (Rang 3)",
		["Arcane Resistance (Rank 4)"] = "Arkanwiderstand (Rang 4)",
		["Arcane Resistance (Rank 5)"] = "Arkanwiderstand (Rang 5)",
		["Avoidance (Rank 1)"] = "Vermeidung (Rang 1)",
		["Avoidance (Rank 2)"] = "Vermeidung (Rang 2)",
		["Bite (Rank 1)"] = "Beißen (Rang 1)",
		["Bite (Rank 2)"] = "Beißen (Rang 2)",
		["Bite (Rank 3)"] = "Beißen (Rang 3)",
		["Bite (Rank 4)"] = "Beißen (Rang 4)",
		["Bite (Rank 5)"] = "Beißen (Rang 5)",
		["Bite (Rank 6)"] = "Beißen (Rang 6)",
		["Bite (Rank 7)"] = "Beißen (Rang 7)",
		["Bite (Rank 8)"] = "Beißen (Rang 8)",
		["Bite (Rank 9)"] = "Beißen (Rang 9)",
		["Charge (Rank 1)"] = "Sturmangriff (Rang 1)",
		["Charge (Rank 2)"] = "Sturmangriff (Rang 2)",
		["Charge (Rank 3)"] = "Sturmangriff (Rang 3)",
		--["Charge (Rank 4)"] = true, -- No charge rank 4 in the game
		["Charge (Rank 5)"] = "Sturmangriff (Rang 5)",
		["Charge (Rank 6)"] = "Sturmangriff (Rang 6)",
		["Claw (Rank 1)"] = "Klaue (Rang 1)",
		["Claw (Rank 2)"] = "Klaue (Rang 2)",
		["Claw (Rank 3)"] = "Klaue (Rang 3)",
		["Claw (Rank 4)"] = "Klaue (Rang 4)",
		["Claw (Rank 5)"] = "Klaue (Rang 5)",
		["Claw (Rank 6)"] = "Klaue (Rang 6)",
		["Claw (Rank 7)"] = "Klaue (Rang 7)",
		["Claw (Rank 8)"] = "Klaue (Rang 8)",
		["Claw (Rank 9)"] = "Klaue (Rang 9)",
		["Cobra Reflexes ()"] = "Kobrareflexe",
		["Cower (Rank 1)"] = "Ducken (Rang 1)",
		["Cower (Rank 2)"] = "Ducken (Rang 2)",
		["Cower (Rank 3)"] = "Ducken (Rang 3)",
		["Cower (Rank 4)"] = "Ducken (Rang 4)",
		["Cower (Rank 5)"] = "Ducken (Rang 5)",
		["Cower (Rank 6)"] = "Ducken (Rang 6)",
		["Cower (Rank 7)"] = "Ducken (Rang 7)",
		["Dash (Rank 1)"] = "Spurt (Rang 1)",
		["Dash (Rank 2)"] = "Spurt (Rang 2)",
		["Dash (Rank 3)"] = "Spurt (Rang 3)",
		["Dive (Rank 1)"] = "Sturzflug (Rang 1)",
		["Dive (Rank 2)"] = "Sturzflug (Rang 2)",
		["Dive (Rank 3)"] = "Sturzflug (Rang 3)",
		["Fire Breath (Rank 1)"] = "Feueratem (Rang 1)",
		["Fire Breath (Rank 2)"] = "Feueratem (Rang 2)",
		["Fire Resistance (Rank 1)"] = "Feuerwiderstand (Rang 1)",
		["Fire Resistance (Rank 2)"] = "Feuerwiderstand (Rang 2)",
		["Fire Resistance (Rank 3)"] = "Feuerwiderstand (Rang 3)",
		["Fire Resistance (Rank 4)"] = "Feuerwiderstand (Rang 4)",
		["Fire Resistance (Rank 5)"] = "Feuerwiderstand (Rang 5)",
		["Frost Resistance (Rank 1)"] = "Frostwiderstand (Rang 1)",
		["Frost Resistance (Rank 2)"] = "Frostwiderstand (Rang 2)",
		["Frost Resistance (Rank 3)"] = "Frostwiderstand (Rang 3)",
		["Frost Resistance (Rank 4)"] = "Frostwiderstand (Rang 4)",
		["Frost Resistance (Rank 5)"] = "Frostwiderstand (Rang 5)",
		["Furious Howl (Rank 1)"] = "Wutgeheul (Rang 1)",
		["Furious Howl (Rank 2)"] = "Wutgeheul (Rang 2)",
		["Furious Howl (Rank 3)"] = "Wutgeheul (Rang 3)",
		["Furious Howl (Rank 4)"] = "Wutgeheul (Rang 4)",
		["Gore (Rank 1)"] = "Aufspießen (Rang 1)",
		["Gore (Rank 2)"] = "Aufspießen (Rang 2)",
		["Gore (Rank 3)"] = "Aufspießen (Rang 3)",
		["Gore (Rank 4)"] = "Aufspießen (Rang 4)",
		--["Gore (Rank 5)"] = true, -- Not in game
		--["Gore (Rank 6)"] = true, -- Not in game
		["Gore (Rank 7)"] = "Aufspießen (Rang 7)",
		["Gore (Rank 8)"] = "Aufspießen (Rang 8)",
		["Gore (Rank 9)"] = "Aufspießen (Rang 9)",
		["Great Stamina (Rank 1)"] = "Große Ausdauer (Rang 1)",
		["Great Stamina (Rank 10)"] = "Große Ausdauer (Rang 10)",
		["Great Stamina (Rank 11)"] = "Große Ausdauer (Rang 11)",
		["Great Stamina (Rank 2)"] = "Große Ausdauer (Rang 2)",
		["Great Stamina (Rank 3)"] = "Große Ausdauer (Rang 3)",
		["Great Stamina (Rank 4)"] = "Große Ausdauer (Rang 4)",
		["Great Stamina (Rank 5)"] = "Große Ausdauer (Rang 5)",
		["Great Stamina (Rank 6)"] = "Große Ausdauer (Rang 6)",
		["Great Stamina (Rank 7)"] = "Große Ausdauer (Rang 7)",
		["Great Stamina (Rank 8)"] = "Große Ausdauer (Rang 8)",
		["Great Stamina (Rank 9)"] = "Große Ausdauer (Rang 9)",
		["Growl (Rank 1)"] = "Knurren (Rang 1)",
		["Growl (Rank 2)"] = "Knurren (Rang 2)",
		["Growl (Rank 3)"] = "Knurren (Rang 3)",
		["Growl (Rank 4)"] = "Knurren (Rang 4)",
		["Growl (Rank 5)"] = "Knurren (Rang 5)",
		["Growl (Rank 6)"] = "Knurren (Rang 6)",
		["Growl (Rank 7)"] = "Knurren (Rang 7)",
		["Growl (Rank 8)"] = "Knurren (Rang 8)",
		["Lightning Breath (Rank 1)"] = "Blitzschlagatem (Rang 1)",
		["Lightning Breath (Rank 2)"] = "Blitzschlagatem (Rang 2)",
		["Lightning Breath (Rank 3)"] = "Blitzschlagatem (Rang 3)",
		["Lightning Breath (Rank 4)"] = "Blitzschlagatem (Rang 4)",
		["Lightning Breath (Rank 5)"] = "Blitzschlagatem (Rang 5)",
		["Lightning Breath (Rank 6)"] = "Blitzschlagatem (Rang 6)",
		["Natural Armor (Rank 1)"] = "Natürliche Rüstung (Rang 1)",
		["Natural Armor (Rank 10)"] = "Natürliche Rüstung (Rang 10)",
		["Natural Armor (Rank 11)"] = "Natürliche Rüstung (Rang 11)",
		["Natural Armor (Rank 2)"] = "Natürliche Rüstung (Rang 2)",
		["Natural Armor (Rank 3)"] = "Natürliche Rüstung (Rang 3)",
		["Natural Armor (Rank 4)"] = "Natürliche Rüstung (Rang 4)",
		["Natural Armor (Rank 5)"] = "Natürliche Rüstung (Rang 5)",
		["Natural Armor (Rank 6)"] = "Natürliche Rüstung (Rang 6)",
		["Natural Armor (Rank 7)"] = "Natürliche Rüstung (Rang 7)",
		["Natural Armor (Rank 8)"] = "Natürliche Rüstung (Rang 8)",
		["Natural Armor (Rank 9)"] = "Natürliche Rüstung (Rang 9)",
		["Nature Resistance (Rank 1)"] = "Naturwiderstand (Rang 1)",
		["Nature Resistance (Rank 2)"] = "Naturwiderstand (Rang 2)",
		["Nature Resistance (Rank 3)"] = "Naturwiderstand (Rang 3)",
		["Nature Resistance (Rank 4)"] = "Naturwiderstand (Rang 4)",
		["Nature Resistance (Rank 5)"] = "Naturwiderstand (Rang 5)",
		["Poison Spit (Rank 1)"] = "Gift spucken (Rang 1)",
		["Poison Spit (Rank 2)"] = "Gift spucken (Rang 2)",
		["Poison Spit (Rank 3)"] = "Gift spucken (Rang 3)",
		["Prowl (Rank 1)"] = "Schleichen (Rang 1)",
		["Prowl (Rank 2)"] = "Schleichen (Rang 2)",
		["Prowl (Rank 3)"] = "Schleichen (Rang 3)",
		["Scorpid Poison (Rank 1)"] = "Skorpidgift (Rang 1)",
		["Scorpid Poison (Rank 2)"] = "Skorpidgift (Rang 2)",
		["Scorpid Poison (Rank 3)"] = "Skorpidgift (Rang 3)",
		["Scorpid Poison (Rank 4)"] = "Skorpidgift (Rang 4)",
		["Scorpid Poison (Rank 5)"] = "Skorpidgift (Rang 5)",
		["Screech (Rank 1)"] = "Schrei (Rang 1)",
		["Screech (Rank 2)"] = "Schrei (Rang 2)",
		["Screech (Rank 3)"] = "Schrei (Rang 3)",
		["Screech (Rank 4)"] = "Schrei (Rang 4)",
		["Screech (Rank 5)"] = "Schrei (Rang 5)",
		["Shadow Resistance (Rank 1)"] = "Schattenwiderstand (Rang 1)",
		["Shadow Resistance (Rank 2)"] = "Schattenwiderstand (Rang 2)",
		["Shadow Resistance (Rank 3)"] = "Schattenwiderstand (Rang 3)",
		["Shadow Resistance (Rank 4)"] = "Schattenwiderstand (Rang 4)",
		["Shadow Resistance (Rank 5)"] = "Schattenwiderstand (Rang 5)",
		["Shell Shield (Rank 1)"] = "Panzerschild (Rang 1)",
		["Thunderstomp (Rank 1)"] = "Donnerstampfer (Rang 1)",
		["Thunderstomp (Rank 2)"] = "Donnerstampfer (Rang 2)",
		["Thunderstomp (Rank 3)"] = "Donnerstampfer (Rang 3)",
		["Warp (Rank 1)"] = "Raumkrümmung (Rang 1)",

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "Adamantitbrustplatte",
		["Adamantite Cleaver"] = "Adamantitbeil",
		["Adamantite Dagger"] = "Adamantitdolch",
		["Adamantite Maul"] = "Adamantitschlägel",
		["Adamantite Plate Bracers"] = "Adamantitarmschienen",
		["Adamantite Plate Gloves"] = "Adamantithandschuhe",
		["Adamantite Rapier"] = "Adamantitrapier",
		["Adamantite Rod"] = "Adamantitrute",
		["Adamantite Sharpening Stone"] = "Adamantitwetzstein",
		["Adamantite Weapon Chain"] = "Adamantitwaffenkette",
		["Adamantite Weightstone"] = "Adamantitgewichtsstein",
		["Annihilator"] = "Vernichter",
		["Arcanite Champion"] = "Arkanitchampion",
		["Arcanite Reaper"] = "Arkanitschnitter",
		["Arcanite Rod"] = "Arkanitrute",
		["Arcanite Skeleton Key"] = "Arkanitdietrich",
		["Barbaric Iron Boots"] = "Barbarische Eisenstiefel",
		["Barbaric Iron Breastplate"] = "Barbarische Eisenbrustplatte",
		["Barbaric Iron Gloves"] = "Barbarische Eisenhandschuhe",
		["Barbaric Iron Helm"] = "Barbarischer Eisenhelm",
		["Barbaric Iron Shoulders"] = "Barbarische Eisenschultern",
		["Belt of the Guardian"] = "Gürtel des Wächters",
		["Big Black Mace"] = "Großer schwarzer Streitkolben",
		["Big Bronze Knife"] = "Großes bronzenes Messer",
		["Black Amnesty"] = "Schwarze Amnestie",
		["Black Felsteel Bracers"] = "Schwarze Teufelsstahlarmschienen",
		["Black Grasp of the Destroyer"] = "Dunkler Griff des Zerstörers",
		["Black Planar Edge"] = "Schwarze Planaraxt",
		["Blackfury"] = "Schattenzorn",
		["Blackguard"] = "Finsterer Streiter",
		["Blazefury"] = "Lodernder Zorn",
		["Blazeguard"] = "Lodernder Wächter",
		["Blazing Rapier"] = "Loderflammenrapier",
		["Blessed Bracers"] = "Gesegnete Armschienen",
		["Blight"] = "Verseuchung",
		["Bloodmoon"] = "Blutmond",
		["Bloodsoul Breastplate"] = "Blutseelenbrustplatte",
		["Bloodsoul Gauntlets"] = "Blutseelenstulpen",
		["Bloodsoul Shoulders"] = "Blutseelenschultern",
		["Blue Glittering Axe"] = "Blaue glitzernde Axt",
		["Boots of the Protector"] = "Stiefel des Beschützers",
		["Bracers of the Green Fortress"] = "Armschienen der grünen Festung",
		["Breastplate of Kings"] = "Brustplatte der Könige",
		["Bronze Axe"] = "Bronzene Axt",
		["Bronze Battle Axe"] = "Bronzene Streitaxt",
		["Bronze Greatsword"] = "Bronzenes Großschwert",
		["Bronze Mace"] = "Bronzener Streitkolben",
		["Bronze Shortsword"] = "Bronzenes Kurzschwert",
		["Bronze Warhammer"] = "Bronzener Kriegshammer",
		["Bulwark of Kings"] = "Bollwerk der Könige",
		["Bulwark of the Ancient Kings"] = "Bollwerk der uralten Könige",
		["Coarse Grinding Stone"] = "Grober Schleifstein",
		["Coarse Sharpening Stone"] = "Grober Wetzstein",
		["Coarse Weightstone"] = "Grober Gewichtsstein",
		["Copper Axe"] = "Kupferaxt",
		["Copper Battle Axe"] = "Kupferstreitaxt",
		["Copper Bracers"] = "Kupferarmschienen",
		["Copper Chain Belt"] = "Kupferner Kettengürtel",
		["Copper Chain Boots"] = "Kupferne Kettenstiefel",
		["Copper Chain Pants"] = "Kupferne Kettenhose",
		["Copper Chain Vest"] = "Kupferne Kettenweste",
		["Copper Claymore"] = "Kupferclaymore",
		["Copper Dagger"] = "Kupferdolch",
		["Copper Mace"] = "Kupferstreitkolben",
		["Copper Shortsword"] = "Kupferkurzschwert",
		["Corruption"] = "Verderbnis",
		["Dark Iron Boots"] = "Dunkeleisenstiefel",
		["Dark Iron Bracers"] = "Dunkeleisenarmschienen",
		["Dark Iron Destroyer"] = "Dunkeleisenzerstörer",
		["Dark Iron Gauntlets"] = "Dunkeleisenstulpen",
		["Dark Iron Helm"] = "Dunkeleisenhelm",
		["Dark Iron Leggings"] = "Dunkeleisengamaschen",
		["Dark Iron Mail"] = "Dunkeleisenpanzer",
		["Dark Iron Plate"] = "Dunkeleisenplatte",
		["Dark Iron Pulverizer"] = "Dunkeleisenpulverisierer",
		["Dark Iron Reaver"] = "Dunkeleisenhäscher",
		["Dark Iron Shoulders"] = "Dunkeleisenschultern",
		["Dark Iron Sunderer"] = "Dunkeleisenzerreißer",
		["Darkrune Breastplate"] = "Dunkelrunenbrustplatte",
		["Darkrune Gauntlets"] = "Dunkelrunenstulpen",
		["Darkrune Helm"] = "Dunkelrunenhelm",
		["Darksoul Breastplate"] = "Dunkelseelenbrustplatte",
		["Darksoul Leggings"] = "Dunkelseelengamaschen",
		["Darksoul Shoulders"] = "Dunkelseelenschultern",
		["Dawnbringer Shoulders"] = "Schultern der Morgenröte",
		["Dawn's Edge"] = "Dämmerungsschneide",
		["Dawnsteel Bracers"] = "Morgenstahlarmschienen",
		["Dawnsteel Shoulders"] = "Morgenstahlschultern",
		["Dazzling Mithril Rapier"] = "Funkelndes Mithrilrapier",
		["Deadly Bronze Poniard"] = "Tödlicher Bronzepoignard",
		["Deep Thunder"] = "Tiefendonner",
		["Demon Forged Breastplate"] = "Dämonengeschmiedete Brustplatte",
		["Dense Grinding Stone"] = "Verdichteter Schleifstein",
		["Dense Sharpening Stone"] = "Verdichteter Wetzstein",
		["Dense Weightstone"] = "Verdichteter Gewichtsstein",
		["Dirge"] = "Todeslied",
		["Dragonmaw"] = "Drachenmal",
		["Dragonstrike"] = "Drachenschlag",
		["Drakefist Hammer"] = "Drachenfaust",
		["Earthforged Leggings"] = "Erdgeschmiedete Gamaschen",
		["Earthpeace Breastplate"] = "Brustplatte des Erdfriedens",
		["Ebon Hand"] = "Ebenholzhand",
		["Ebon Shiv"] = "Ebenholzmesser",
		["Edge of Winter"] = "Schneide des Winters",
		["Elemental Sharpening Stone"] = "Elementarwetzstein",
		["Embrace of the Twisting Nether"] = "Umarmung des wirbelnden Nethers",
		["Enchanted Adamantite Belt"] = "Verzauberter Adamantitgürtel",
		["Enchanted Adamantite Boots"] = "Verzauberte Adamantitstiefel",
		["Enchanted Adamantite Breastplate"] = "Verzauberte Adamantitbrustplatte",
		["Enchanted Adamantite Leggings"] = "Verzauberte Adamantitgamaschen",
		["Enchanted Battlehammer"] = "Verzauberter Kampfhammer",
		["Enchanted Thorium Blades"] = "Verzauberte Thoriumklingen",
		["Enchanted Thorium Breastplate"] = "Verzauberte Thoriumbrustplatte",
		["Enchanted Thorium Helm"] = "Verzauberter Thoriumhelm",
		["Enchanted Thorium Leggings"] = "Verzauberte Thoriumgamaschen",
		["Eternium Rod"] = "Eterniumrute",
		["Eternium Runed Blade"] = "Runenverzierte Eterniumklinge",
		["Fel Edged Battleaxe"] = "Teuflisch scharfe Kampfaxt",
		["Fel Hardened Maul"] = "Teufelsgehärteter Schlägel",
		["Fel Iron Breastplate"] = "Teufelseisenbrustplatte",
		["Fel Iron Chain Bracers"] = "Teufelseisenkettenarmschienen",
		["Fel Iron Chain Coif"] = "Teufelseisenkettenhelmkappe",
		["Fel Iron Chain Gloves"] = "Teufelseisenkettenhandschuhe",
		["Fel Iron Chain Tunic"] = "Teufelseisenkettentunika",
		["Fel Iron Greatsword"] = "Teufelseisengroßschwert",
		["Fel Iron Hammer"] = "Teufelseisenhammer",
		["Fel Iron Hatchet"] = "Teufelseisenkriegsbeil",
		["Fel Iron Plate Belt"] = "Teufelseisenplattengürtel",
		["Fel Iron Plate Boots"] = "Teufelseisenplattenstiefel",
		["Fel Iron Plate Gloves"] = "Teufelseisenplattenhandschuhe",
		["Fel Iron Plate Pants"] = "Teufelseisenplattenhose",
		["Fel Iron Rod"] = "Teufelseisenrute",
		["Fel Sharpening Stone"] = "Teuflischer Wetzstein",
		["Fel Weightstone"] = "Teufelsgewichtsstein",
		["Felfury Gauntlets"] = "Teufelszornstulpen",
		["Felsteel Gloves"] = "Teufelsstahlhandschuhe",
		["Felsteel Helm"] = "Teufelsstahlhelm",
		["Felsteel Leggings"] = "Teufelsstahlgamaschen",
		["Felsteel Longblade"] = "Teufelsstahllangschwert",
		["Felsteel Reaper"] = "Teufelsstahlschneide",
		["Felsteel Shield Spike"] = "Teufelsstahlschildstachel",
		["Felsteel Whisper Knives"] = "Flüsternde Teufelsstahlklingen",
		["Fiery Blaze Enchantment"] = "Feuerverzauberung",
		["Fiery Chain Girdle"] = "Feuriger Kettengurt",
		["Fiery Chain Shoulders"] = "Feurige Kettenschultern",
		["Fiery Plate Gauntlets"] = "Feurige Plattenstulpen",
		["Fireguard"] = "Brandwache",
		["Flamebane Bracers"] = "Flammenbannarmschienen",
		["Flamebane Breastplate"] = "Flammenbannbrustplatte",
		["Flamebane Gloves"] = "Flammenbannhandschuhe",
		["Flamebane Helm"] = "Flammenbannhelm",
		["Frost Tiger Blade"] = "Frosttigerklinge",
		["Frostguard"] = "Frostwache",
		["Gauntlets of the Iron Tower"] = "Stulpen des eisernen Turms",
		["Gemmed Copper Gauntlets"] = "Edelsteinbesetzte Kupferstulpen",
		["Girdle of the Dawn"] = "Gurt der Dämmerung",
		["Glinting Steel Dagger"] = "Glitzernder Stahldolch",
		["Gloves of the Dawn"] = "Handschuhe der Dämmerung",
		["Golden Iron Destroyer"] = "Goldener Eisenzerstörer",
		["Golden Rod"] = "Goldrute",
		["Golden Scale Boots"] = "Goldene Schuppenstiefel",
		["Golden Scale Bracers"] = "Goldene Schuppenarmschienen",
		["Golden Scale Coif"] = "Goldene Schuppenhelmkappe",
		["Golden Scale Cuirass"] = "Goldener Schuppenkürass",
		["Golden Scale Gauntlets"] = "Goldene Schuppenstulpen",
		["Golden Scale Leggings"] = "Goldene Schuppengamaschen",
		["Golden Scale Shoulders"] = "Goldene Schuppenschultern",
		["Golden Skeleton Key"] = "Golddietrich",
		["Great Earthforged Hammer"] = "Großer erdgeschmiedeter Hammer",
		["Greater Rune of Warding"] = "Große Rune des Schutzes",
		["Greater Ward of Shielding"] = "Großer Zauberschutz der Abschirmung",
		["Green Iron Boots"] = "Grüne Eisenstiefel",
		["Green Iron Bracers"] = "Grüne Eisenarmschienen",
		["Green Iron Gauntlets"] = "Grüne Eisenstulpen",
		["Green Iron Hauberk"] = "Grüne Eisenhalsberge",
		["Green Iron Helm"] = "Grüner Eisenhelm",
		["Green Iron Leggings"] = "Grüne Eisengamaschen",
		["Green Iron Shoulders"] = "Grüne Eisenschultern",
		["Hammer of Righteous Might"] = "Hammer der rechtschaffenen Macht",
		["Hammer of the Titans"] = "Hammer der Titanen",
		["Hand of Eternity"] = "Hand der Ewigkeit",
		["Hardened Iron Shortsword"] = "Gehärtetes Eisenkurzschwert",
		["Heartseeker"] = "Herzsucher",
		["Heavy Bronze Mace"] = "Schwerer bronzener Streitkolben",
		["Heavy Copper Broadsword"] = "Schweres Kupferbreitschwert",
		["Heavy Copper Longsword"] = "Schweres Kupferlangschwert",
		["Heavy Copper Maul"] = "Schwerer Kupferschlägel",
		["Heavy Earthforged Breastplate"] = "Schwere erdgeschmiedete Brustplatte",
		["Heavy Grinding Stone"] = "Schwerer Schleifstein",
		["Heavy Mithril Axe"] = "Schwere Mithrilaxt",
		["Heavy Mithril Boots"] = "Schwere Mithrilstiefel",
		["Heavy Mithril Breastplate"] = "Schwere Mithrilbrustplatte",
		["Heavy Mithril Gauntlet"] = "Schwere Mithrilstulpen",
		["Heavy Mithril Helm"] = "Schwerer Mithrilhelm",
		["Heavy Mithril Pants"] = "Schwere Mithrilhose",
		["Heavy Mithril Shoulder"] = "Schwere Mithrilschulter",
		["Heavy Obsidian Belt"] = "Schwerer Obsidiangürtel",
		["Heavy Sharpening Stone"] = "Schwerer Wetzstein",
		["Heavy Timbermaw Belt"] = "Schwerer Gürtel der Holzschlundfeste",
		["Heavy Timbermaw Boots"] = "Schwere Stiefel der Holzschlundfeste",
		["Heavy Weightstone"] = "Schwerer Gewichtsstein",
		["Helm of the Great Chief"] = "Helm des großen Häuptlings",
		["Helm of the Stalwart Defender"] = "Helm des tapferen Verteidigers",
		["Huge Thorium Battleaxe"] = "Gewaltige Thoriumstreitaxt",
		["Icebane Bracers"] = "Eisflucharmschienen",
		["Icebane Breastplate"] = "Eisfluchbrustplatte",
		["Icebane Gauntlets"] = "Eisfluchstulpen",
		["Iceguard Breastplate"] = "Brustplatte der Eiswache",
		["Iceguard Helm"] = "Helm der Eiswache",
		["Iceguard Leggings"] = "Gamaschen der Eiswache",
		["Imperial Plate Belt"] = "Imperialer Plattengürtel",
		["Imperial Plate Boots"] = "Imperiale Plattenstiefel",
		["Imperial Plate Bracers"] = "Imperiale Plattenarmschienen",
		["Imperial Plate Chest"] = "Imperiale Plattenrüstung",
		["Imperial Plate Helm"] = "Imperialer Plattenhelm",
		["Imperial Plate Leggings"] = "Imperiale Plattengamaschen",
		["Imperial Plate Shoulders"] = "Imperiale Plattenschultern",
		["Inlaid Mithril Cylinder"] = "Veredelter Mithrilzylinder",
		["Invulnerable Mail"] = "Unverwundbarer Panzer",
		["Iridescent Hammer"] = "Schillernder Hammer",
		["Iron Buckle"] = "Eiserne Gürtelschnalle",
		["Iron Counterweight"] = "Eisengegengewicht",
		["Iron Shield Spike"] = "Eisenschildstachel",
		["Ironforge Breastplate"] = "Eisenschmiedebrustplatte",
		["Ironvine Belt"] = "Eisenrankengürtel",
		["Ironvine Breastplate"] = "Eisenrankenbrustplatte",
		["Ironvine Gloves"] = "Eisenrankenhandschuhe",
		["Jade Serpentblade"] = "Jadeschlangenklinge",
		["Jagged Obsidian Shield"] = "Gezackter Obsidianschild",
		["Khorium Belt"] = "Khoriumgürtel",
		["Khorium Boots"] = "Khoriumstiefel",
		["Khorium Champion"] = "Khoriumchampion",
		["Khorium Pants"] = "Khoriumhose",
		["Lavaforged Warhammer"] = "Lavageschmiedeter Kriegshammer",
		["Lesser Rune of Warding"] = "Geringe Rune des Schutzes",
		["Lesser Ward of Shielding"] = "Geringer Zauberschutz der Abschirmung",
		["Light Earthforged Blade"] = "Leichte erdgeschmiedete Klinge",
		["Light Emberforged Hammer"] = "Leichter glutgeschmiedeter Hammer",
		["Light Obsidian Belt"] = "Leichter Obsidiangürtel",
		["Light Skyforged Axe"] = "Leichte himmelsgeschmiedete Axt",
		["Lionheart Blade"] = "Löwenherzklinge",
		["Lionheart Champion"] = "Löwenherzchampion",
		["Lionheart Executioner"] = "Löwenherzrichtklinge",
		["Lionheart Helm"] = "Löwenherzhelm",
		["Lunar Crescent"] = "Mondsichel",
		["Massive Iron Axe"] = "Massive Eisenaxt",
		["Masterwork Stormhammer"] = "Meisterlicher Sturmhammer",
		["Mighty Iron Hammer"] = "Mächtiger Eisenhammer",
		["Mithril Coif"] = "Mithrilhelmkappe",
		["Mithril Scale Bracers"] = "Mithrilschuppenarmschienen",
		["Mithril Scale Gloves"] = "Mithrilschuppenhandschuhe",
		["Mithril Scale Pants"] = "Mithrilschuppenhose",
		["Mithril Scale Shoulders"] = "Mithrilschuppenschultern",
		["Mithril Shield Spike"] = "Mithrilschildstachel",
		["Mithril Spurs"] = "Mithrilsporen",
		["Mooncleaver"] = "Mondspaltbeil",
		["Moonsteel Broadsword"] = "Mondstahlbreitschwert",
		["Nether Chain Shirt"] = "Netherkettenhemd",
		["Nightfall"] = "Nachtlauer",
		["Oathkeeper's Helm"] = "Helm der Eidestreue",
		["Obsidian Mail Tunic"] = "Obsidianpanzertunika",
		["Orcish War Leggings"] = "Orcische Kriegsgamaschen",
		["Ornate Mithril Boots"] = "Verschnörkelte Mithrilstiefel",
		["Ornate Mithril Breastplate"] = "Verschnörkelte Mithrilbrustplatte",
		["Ornate Mithril Gloves"] = "Verschnörkelte Mithrilhandschuhe",
		["Ornate Mithril Helm"] = "Verschnörkelter Mithrilhelm",
		["Ornate Mithril Pants"] = "Verschnörkelte Mithrilhose",
		["Ornate Mithril Shoulder"] = "Verschnörkelte Mithrilschulter",
		["Ornate Thorium Handaxe"] = "Verschnörkelte Thoriumhandaxt",
		["Patterned Bronze Bracers"] = "Gemusterte bronzene Armschienen",
		["Pearl-handled Dagger"] = "Perlengriffdolch",
		["Persuader"] = "Willensbrecher",
		["Phantom Blade"] = "Phantomklinge",
		["Polished Steel Boots"] = "Polierte Stahlstiefel",
		["Radiant Belt"] = "Strahlender Gürtel",
		["Radiant Boots"] = "Strahlende Stiefel",
		["Radiant Breastplate"] = "Strahlende Brustplatte",
		["Radiant Circlet"] = "Strahlender Reif",
		["Radiant Gloves"] = "Strahlende Handschuhe",
		["Radiant Leggings"] = "Strahlende Gamaschen",
		["Ragesteel Breastplate"] = "Zornstahlbrustplatte",
		["Ragesteel Gloves"] = "Zornstahlhandschuhe",
		["Ragesteel Helm"] = "Zornstahlhelm",
		["Ragesteel Shoulders"] = "Zornstahlschultern",
		["Red Belt of Battle"] = "Roter Gürtel der Schlacht",
		["Red Havoc Boots"] = "Rote Stiefel der Verwüstung",
		["Rough Bronze Boots"] = "Raue bronzene Stiefel",
		["Rough Bronze Bracers"] = "Raue bronzene Armschienen",
		["Rough Bronze Cuirass"] = "Rauer bronzener Kürass",
		["Rough Bronze Leggings"] = "Raue bronzene Gamaschen",
		["Rough Bronze Shoulders"] = "Raue bronzene Schultern",
		["Rough Copper Vest"] = "Raue Kupferweste",
		["Rough Grinding Stone"] = "Rauer Schleifstein",
		["Rough Sharpening Stone"] = "Rauer Wetzstein",
		["Rough Weightstone"] = "Rauer Gewichtsstein",
		["Runed Copper Belt"] = "Runenverzierter Kupfergürtel",
		["Runed Copper Bracers"] = "Runenverzierte Kupferarmschienen",
		["Runed Copper Breastplate"] = "Runenverzierte Kupferbrustplatte",
		["Runed Copper Gauntlets"] = "Runenverzierte Kupferstulpen",
		["Runed Copper Pants"] = "Runenverzierte Kupferhose",
		["Runed Mithril Hammer"] = "Runenverzierter Mithrilhammer",
		["Runic Breastplate"] = "Runenverzierte Brustplatte",
		["Runic Hammer"] = "Runenverzierter Hammer",
		["Runic Plate Boots"] = "Runenverzierte Plattenstiefel",
		["Runic Plate Helm"] = "Runenverzierter Plattenhelm",
		["Runic Plate Leggings"] = "Runenverzierte Plattengamaschen",
		["Runic Plate Shoulders"] = "Runenverzierte Plattenschultern",
		["Sageblade"] = "Weisenklinge",
		["Searing Golden Blade"] = "Sengende Goldklinge",
		["Serenity"] = "Beschaulichkeit",
		["Shadesteel Bracers"] = "Dämmerstahlarmschienen",
		["Shadesteel Girdle"] = "Dämmerstahlgurt",
		["Shadesteel Greaves"] = "Dämmerstahlbeinschützer",
		["Shadesteel Sabots"] = "Dämmerstahlschuhe",
		["Shadow Crescent Axe"] = "Schattensichelaxt",
		["Shining Silver Breastplate"] = "Leuchtende silberne Brustplatte",
		["Silver Rod"] = "Silberrute",
		["Silver Skeleton Key"] = "Silberdietrich",
		["Silvered Bronze Boots"] = "Bronzene Stiefel mit Versilberung",
		["Silvered Bronze Breastplate"] = "Bronzene Brustplatte mit Versilberung",
		["Silvered Bronze Gauntlets"] = "Bronzene Stulpen mit Versilberung",
		["Silvered Bronze Leggings"] = "Bronzene Gamaschen mit Versilberung",
		["Silvered Bronze Shoulders"] = "Bronzene Schultern mit Versilberung",
		["Skyforged Great Axe"] = "Himmelsgeschmiedete Großaxt",
		["Solid Grinding Stone"] = "Robuster Schleifstein",
		["Solid Iron Maul"] = "Robuster Eisenschlägel",
		["Solid Sharpening Stone"] = "Robuster Wetzstein",
		["Solid Weightstone"] = "Robuster Gewichtsstein",
		["Steel Breastplate"] = "Stahlbrustplatte",
		["Steel Plate Helm"] = "Stahlplattenhelm",
		["Steel Weapon Chain"] = "Stahlwaffenkette",
		["Steelgrip Gauntlets"] = "Stahlgriffstulpen",
		["Stoneforged Claymore"] = "Steingeschmiedetes Claymore",
		["Storm Gauntlets"] = "Sturmstulpen",
		["Storm Helm"] = "Helm des Sturms",
		["Stormforged Axe"] = "Sturmgeschmiedete Axt",
		["Stormforged Hauberk"] = "Sturmgeschmiedete Halsberge",
		["Stormherald"] = "Bote des Sturms",
		["Stronghold Gauntlets"] = "Festungsstulpen",
		["Sulfuron Hammer"] = "Sulfuronhammer",
		["Swiftsteel Bracers"] = "Flinkstahlarmschienen",
		["Swiftsteel Gloves"] = "Flinkstahlhandschuhe",
		["Swiftsteel Shoulders"] = "Flinkstahlschultern",
		["The Planar Edge"] = "Die Planaraxt",
		["The Shatterer"] = "Der Zertrümmerer",
		["Thick Bronze Darts"] = "Schwere bronzene Wurfspeere",
		["Thick Obsidian Breastplate"] = "Dicke Obsidianbrustplatte",
		["Thick War Axe"] = "Dicke Kriegsaxt",
		["Thorium Armor"] = "Thoriumrüstung",
		["Thorium Belt"] = "Thoriumgürtel",
		["Thorium Boots"] = "Thoriumstiefel",
		["Thorium Bracers"] = "Thoriumarmschienen",
		["Thorium Helm"] = "Thoriumhelm",
		["Thorium Leggings"] = "Thoriumgamaschen",
		["Thorium Shield Spike"] = "Thoriumschildstachel",
		["Thunder"] = "Donner",
		["Titanic Leggings"] = "Gamaschen der Titanen",
		["Truesilver Breastplate"] = "Echtsilberbrustplatte",
		["Truesilver Champion"] = "Echtsilberchampion",
		["Truesilver Gauntlets"] = "Echtsilberstulpen",
		["Truesilver Rod"] = "Echtsilberrute",
		["Truesilver Skeleton Key"] = "Echtsilberdietrich",
		["Twisting Nether Chain Shirt"] = "Kettenhemd des wirbelnden Nethers",
		["Volcanic Hammer"] = "Vulkanischer Hammer",
		["Whirling Steel Axes"] = "Wirbelnde Stahläxte",
		["Whitesoul Helm"] = "Helm der weißen Seele",
		["Wicked Edge of the Planes"] = "Tückische Schneide der Ebenen",
		["Wicked Mithril Blade"] = "Tückische Mithrilklinge",
		["Wildguard Breastplate"] = "Brustplatte der Wildwacht",
		["Wildguard Helm"] = "Helm der Wildwacht",
		["Wildguard Leggings"] = "Gamaschen der Wildwacht",
		["Wildthorn Mail"] = "Wilddornpanzerung",
		["Windforged Leggings"] = "Windgeschmiedete Gamaschen",
		["Windforged Rapier"] = "Windgeschmiedetes Rapier",

-- Cooking Recipes
		["Baked Salmon"] = "Gebackener Lachs",
		["Barbecued Buzzard Wing"] = "Gegrillter Bussardflügel",
		["Bat Bites"] = "Fledermausbissen",
		["Beer Basted Boar Ribs"] = "Eberrippchen in Biersauce",
		["Big Bear Steak"] = "Großes Bärensteak",
		["Blackened Basilisk"] = "Schwarzgebratener Basilisk",
		["Blackened Sporefish"] = "Schwarzgebratener Sporenfisch",
		["Blackened Trout"] = "Schwarzgebratene Forelle",
		["Blood Sausage"] = "Blutwurst",
		["Boiled Clams"] = "Gekochte Muscheln",
		["Brilliant Smallfish"] = "Glänzender Kleinfisch",
		["Bristle Whisker Catfish"] = "Stoppelfühlerwels",
		["Broiled Bloodfin"] = "Gebratene Blutflosse",
		["Buzzard Bites"] = "Bussardbissen",
		["Carrion Surprise"] = "Aas Surprise",
		["Charred Wolf Meat"] = "Verkohltes Wolfsfleisch",
		["Clam Bar"] = "Muschelriegel",
		["Clam Chowder"] = "Muschelsuppe",
		["Cooked Crab Claw"] = "Gekochte Krebsschere",
		["Cooked Glossy Mightfish"] = "Gekochter glänzender Machtfisch",
		["Coyote Steak"] = "Kojotensteak",
		["Crab Cake"] = "Krebsküchlein",
		["Crispy Bat Wing"] = "Knuspriger Fledermausflügel",
		["Crispy Lizard Tail"] = "Knuspriger Donnerechsenschwanz",
		["Crocolisk Gumbo"] = "Krokiliskengumbo",
		["Crocolisk Steak"] = "Krokiliskensteak",
		["Crunchy Serpent"] = "Knusperschlange",
		["Crunchy Spider Surprise"] = "Knusperspinne Surprise",
		["Curiously Tasty Omelet"] = "Seltsam schmeckendes Omelett",
		["Delicious Chocolate Cake"] = "Köstlicher Schokoladenkuchen",
		["Dig Rat Stew"] = "Grubenratteneintopf",
		["Dirge's Kickin' Chimaerok Chops"] = "Dirges abgefahrene Chimaerokkoteletts",
		["Dragonbreath Chili"] = "Drachenodemchili",
		["Dry Pork Ribs"] = "Trockene Schweinerippchen",
		["Egg Nog"] = "Eierflip",
		["Feltail Delight"] = "Teufelsfinne Supreme",
		["Filet of Redgill"] = "Rotkiemenfilet",
		["Fillet of Frenzy"] = "Frenzyfilet",
		["Fisherman's Feast"] = "Fischerschmaus",
		["Giant Clam Scorcho"] = "Riesenmuschelrisotto",
		["Gingerbread Cookie"] = "Lebkuchen",
		["Goblin Deviled Clams"] = "Scharfe Muscheln nach Goblinart",
		["Golden Fish Sticks"] = "Goldfischstäbchen",
		["Goldthorn Tea"] = "Golddorntee",
		["Gooey Spider Cake"] = "Klebriger Spinnenkuchen",
		["Goretusk Liver Pie"] = "Pastete aus Geiferzahnleber",
		["Grilled Mudfish"] = "Gegrillter Matschflosser",
		["Grilled Squid"] = "Gegrillter Kalmar",
		["Heavy Crocolisk Stew"] = "Schwerer Krokiliskeneintopf",
		["Heavy Kodo Stew"] = "Schwerer Kodoeintopf",
		["Herb Baked Egg"] = "Kräutergebackenes Ei",
		["Hot Apple Cider"] = "Heißer Apfelwein",
		["Hot Buttered Trout"] = "Heiße Forelle in Butter",
		["Hot Lion Chops"] = "Scharfe Löwenkoteletts",
		["Hot Smoked Bass"] = "Scharfer geräucherter Barsch",
		["Hot Wolf Ribs"] = "Scharfe Wolfrippchen",
		["Jungle Stew"] = "Dschungeleintopf",
		["Kaldorei Spider Kabob"] = "Spinnenkebab der Kaldorei",
		["Kibler's Bits"] = "Kiblers Häppchen",
		["Lean Venison"] = "Mageres Wildbret",
		["Lean Wolf Steak"] = "Mageres Wolfsteak",
		["Lobster Stew"] = "Hummereintopf",
		["Loch Frenzy Delight"] = "Lochfrenzy Supreme",
		["Longjaw Mud Snapper"] = "Langzahniger Matschschnapper",
		["Lynx Steak"] = "Luchssteak",
		["Mightfish Steak"] = "Machtfischsteak",
		["Mithril Headed Trout"] = "Mithrilkopfforelle",
		["Mok'Nathal Shortribs"] = "Rippchen der Mok'Nathal",
		["Monster Omelet"] = "Monsteromelett",
		["Murloc Fin Soup"] = "Murlocflossensuppe",
		["Mystery Stew"] = "Eigenartiger Eintopf",
		["Nightfin Soup"] = "Nachtflossensuppe",
		["Poached Bluefish"] = "Gedünstete Blauflosse",
		["Poached Sunscale Salmon"] = "Gedünsteter Sonnenschuppenlachs",
		["Rainbow Fin Albacore"] = "Regenbogenflossenthunfisch",
		["Ravager Dog"] = "Heißer Hetzer",
		["Redridge Goulash"] = "Rotkammgulasch",
		["Roast Raptor"] = "Gerösteter Raptor",
		["Roasted Boar Meat"] = "Geröstetes Eberfleisch",
		["Roasted Clefthoof"] = "Gerösteter Grollhuf",
		["Roasted Kodo Meat"] = "Geröstetes Kodofleisch",
		["Roasted Moongraze Tenderloin"] = "Geröstete Mondweidenlenden",
		["Rockscale Cod"] = "Steinschuppenkabeljau",
		["Runn Tum Tuber Surprise"] = "Runn Tum Knolle Surprise",
		["Sagefish Delight"] = "Weisenfisch Supreme",
		["Savory Deviate Delight"] = "Pikantes Deviat Supreme",
		["Scorpid Surprise"] = "Skorpid Surprise",
		["Seasoned Wolf Kabob"] = "Gewürzter Wolfskebab",
		["Skullfish Soup"] = "Schädelfischsuppe",
		["Slitherskin Mackerel"] = "Glitschhautmakrele",
		["Smoked Bear Meat"] = "Geräuchertes Bärenfleisch",
		["Smoked Desert Dumplings"] = "Geräucherte Wüstenknödel",
		["Smoked Sagefish"] = "Geräucherter Weisenfisch",
		["Soothing Turtle Bisque"] = "Milde Schildkrötensuppe",
		["Spice Bread"] = "Gewürzbrot",
		["Spiced Chili Crab"] = "Gewürzter Chilikrebs",
		["Spiced Wolf Meat"] = "Gewürztes Wolfsfleisch",
		["Spicy Crawdad"] = "Würziger Flusskrebs",
		["Spicy Hot Talbuk"] = "Feuriger Würztalbuk",
		["Spider Sausage"] = "Spinnenwurst",
		["Sporeling Snack"] = "Sporlingschmaus",
		["Spotted Yellowtail"] = "Tüpfelgelbschwanz",
		["Stewed Trout"] = "Gedämpfte Forelle",
		["Stormchops"] = "Sturmkoteletts",
		["Strider Stew"] = "Schreitereintopf",
		["Succulent Pork Ribs"] = "Saftige Schweinerippchen",
		["Talbuk Steak"] = "Talbuksteak",
		["Tasty Lion Steak"] = "Schmackhaftes Löwensteak",
		["Tender Wolf Steak"] = "Zartes Wolfsteak",
		["Thistle Tea"] = "Disteltee",
		["Undermine Clam Chowder"] = "Undermine-Muschelsuppe",
		["Warp Burger"] = "Doppelwarper",
		["Westfall Stew"] = "Westfalleintopf",

-- Enchanting Recipes
		["Brilliant Mana Oil"] = "Hervorragendes Manaöl",
		["Brilliant Wizard Oil"] = "Hervorragendes Zauberöl",
		["Enchant 2H Weapon - Agility"] = "Zweihandwaffen - Beweglichkeit",
		["Enchant 2H Weapon - Greater Impact"] = "Zweihandwaffe - Großer Einschlag",
		["Enchant 2H Weapon - Impact"] = "Zweihandwaffe - Einschlag",
		["Enchant 2H Weapon - Lesser Impact"] = "Zweihandwaffe - Geringer Einschlag",
		["Enchant 2H Weapon - Lesser Intellect"] = "Zweihandwaffe - Geringe Intelligenz",
		["Enchant 2H Weapon - Lesser Spirit"] = "Zweihandwaffe - Geringe Willenskraft",
		["Enchant 2H Weapon - Major Agility"] = "Zweihandwaffe - Erhebliche Beweglichkeit",
		["Enchant 2H Weapon - Major Intellect"] = "Zweihandwaffen - Erhebliche Intelligenz",
		["Enchant 2H Weapon - Major Spirit"] = "Zweihandwaffe - Erhebliche Willenskraft",
		["Enchant 2H Weapon - Minor Impact"] = "Zweihandwaffe - Schwacher Einschlag",
		["Enchant 2H Weapon - Savagery"] = "Zweihandwaffe - Unbändigkeit",
		["Enchant 2H Weapon - Superior Impact"] = "Zweihandwaffe - Überragender Einschlag",
		["Enchant Boots - Agility"] = "Stiefel - Beweglichkeit",
		["Enchant Boots - Boar's Speed"] = "Stiefel - Flinkheit des Ebers",
		["Enchant Boots - Cat's Swiftness"] = "Stiefel - Schnelligkeit der Katze",
		["Enchant Boots - Dexterity"] = "Stiefel - Gewandtheit",
		["Enchant Boots - Fortitude"] = "Stiefel - Seelenstärke",
		["Enchant Boots - Greater Agility"] = "Stiefel - Große Beweglichkeit",
		["Enchant Boots - Greater Stamina"] = "Stiefel - Große Ausdauer",
		["Enchant Boots - Lesser Agility"] = "Stiefel - Geringe Beweglichkeit",
		["Enchant Boots - Lesser Spirit"] = "Stiefel - Geringe Willenskraft",
		["Enchant Boots - Lesser Stamina"] = "Stiefel - Geringe Ausdauer",
		["Enchant Boots - Minor Agility"] = "Stiefel - Schwache Beweglichkeit",
		["Enchant Boots - Minor Speed"] = "Stiefel - Schwaches Tempo",
		["Enchant Boots - Minor Stamina"] = "Stiefel - Schwache Ausdauer",
		["Enchant Boots - Spirit"] = "Stiefel - Willenskraft",
		["Enchant Boots - Stamina"] = "Stiefel - Ausdauer",
		["Enchant Boots - Surefooted"] = "Stiefel - Sicherer Stand",
		["Enchant Boots - Vitality"] = "Stiefel - Vitalität",
		["Enchant Bracer - Assault"] = "Armschiene - Sturmangriff",
		["Enchant Bracer - Brawn"] = "Armschiene - Muskelkraft",
		["Enchant Bracer - Deflection"] = "Armschiene - Abwehr",
		["Enchant Bracer - Fortitude"] = "Armschiene - Seelenstärke",
		["Enchant Bracer - Greater Intellect"] = "Armschiene - Große Intelligenz",
		["Enchant Bracer - Greater Spirit"] = "Armschiene - Große Willenskraft",
		["Enchant Bracer - Greater Stamina"] = "Armschiene - Große Ausdauer",
		["Enchant Bracer - Greater Strength"] = "Armschiene - Große Stärke",
		["Enchant Bracer - Healing Power"] = "Armschiene - Heilkraft",
		["Enchant Bracer - Intellect"] = "Armschiene - Intelligenz",
		["Enchant Bracer - Lesser Deflection"] = "Armschiene - Geringe Abwehr",
		["Enchant Bracer - Lesser Intellect"] = "Armschiene - Geringe Intelligenz",
		["Enchant Bracer - Lesser Spirit"] = "Armschiene - Geringe Willenskraft",
		["Enchant Bracer - Lesser Stamina"] = "Armschiene - Geringe Ausdauer",
		["Enchant Bracer - Lesser Strength"] = "Armschiene - Geringe Stärke",
		["Enchant Bracer - Major Defense"] = "Armschiene - Erhebliche Verteidigung",
		["Enchant Bracer - Major Intellect"] = "Armschiene - Erhebliche Intelligenz",
		["Enchant Bracer - Mana Regeneration"] = "Armschiene - Manaregeneration",
		["Enchant Bracer - Minor Agility"] = "Armschiene - Schwache Beweglichkeit",
		["Enchant Bracer - Minor Deflection"] = "Armschiene - Schwache Abwehr",
		["Enchant Bracer - Minor Health"] = "Armschiene - Schwache Gesundheit",
		["Enchant Bracer - Minor Spirit"] = "Armschiene - Schwache Willenskraft",
		["Enchant Bracer - Minor Stamina"] = "Armschiene - Schwache Ausdauer",
		["Enchant Bracer - Minor Strength"] = "Armschiene - Schwache Stärke",
		["Enchant Bracer - Restore Mana Prime"] = "Armschiene - Mana wiederherstellen",
		["Enchant Bracer - Spellpower"] = "Armschiene - Zaubermacht",
		["Enchant Bracer - Spirit"] = "Armschiene - Willenskraft",
		["Enchant Bracer - Stamina"] = "Armschiene - Ausdauer",
		["Enchant Bracer - Stats"] = "Armschiene - Werte",
		["Enchant Bracer - Strength"] = "Armschiene - Stärke",
		["Enchant Bracer - Superior Healing"] = "Armschiene - Überragende Heilung",
		["Enchant Bracer - Superior Spirit"] = "Armschiene - Überragende Willenskraft",
		["Enchant Bracer - Superior Stamina"] = "Armschiene - Überragende Ausdauer",
		["Enchant Bracer - Superior Strength"] = "Armschiene - Überragende Stärke",
		["Enchant Chest - Exceptional Health"] = "Brust - Außergewöhnliche Gesundheit",
		["Enchant Chest - Exceptional Stats"] = "Brust - Außergewöhnliche Werte",
		["Enchant Chest - Greater Health"] = "Brust - Große Gesundheit",
		["Enchant Chest - Greater Mana"] = "Brust - Großes Mana",
		["Enchant Chest - Greater Stats"] = "Brust - Große Werte",
		["Enchant Chest - Health"] = "Brust - Gesundheit",
		["Enchant Chest - Lesser Absorption"] = "Brust - Geringe Absorption",
		["Enchant Chest - Lesser Health"] = "Brust - Geringe Gesundheit",
		["Enchant Chest - Lesser Mana"] = "Brust - Geringes Mana",
		["Enchant Chest - Lesser Stats"] = "Brust - Geringe Werte",
		["Enchant Chest - Major Health"] = "Brust - Erhebliche Gesundheit",
		["Enchant Chest - Major Mana"] = "Brust - Erhebliches Mana",
		["Enchant Chest - Major Resilience"] = "Brust - Erhebliche Abhärtung",
		["Enchant Chest - Major Spirit"] = "Brust - Erhebliche Willenskraft",
		["Enchant Chest - Mana"] = "Brust - Mana",
		["Enchant Chest - Minor Absorption"] = "Brust - Schwache Absorption",
		["Enchant Chest - Minor Health"] = "Brust - Schwache Gesundheit",
		["Enchant Chest - Minor Mana"] = "Brust - Schwaches Mana",
		["Enchant Chest - Minor Stats"] = "Brust - Schwache Werte",
		["Enchant Chest - Restore Mana Prime"] = "Brust - Mana wiederherstellen",
		["Enchant Chest - Stats"] = "Brust - Werte",
		["Enchant Chest - Superior Health"] = "Brust - Überragende Gesundheit",
		["Enchant Chest - Superior Mana"] = "Brust - Überragendes Mana",
		["Enchant Cloak - Defense"] = "Umhang - Verteidigung",
		["Enchant Cloak - Dodge"] = "Umhang - Ausweichen",
		["Enchant Cloak - Fire Resistance"] = "Umhang - Feuerwiderstand",
		["Enchant Cloak - Greater Agility"] = "Umhang - Große Beweglichkeit",
		["Enchant Cloak - Greater Arcane Resistance"] = "Umhang - Großer Arkanwiderstand",
		["Enchant Cloak - Greater Defense"] = "Umhang - Große Verteidigung",
		["Enchant Cloak - Greater Fire Resistance"] = "Umhang - Großer Feuerwiderstand",
		["Enchant Cloak - Greater Nature Resistance"] = "Umhang - Großer Naturwiderstand",
		["Enchant Cloak - Greater Resistance"] = "Umhang - Großer Widerstand",
		["Enchant Cloak - Greater Shadow Resistance"] = "Umhang - Großer Schattenwiderstand",
		["Enchant Cloak - Lesser Agility"] = "Umhang - Geringe Beweglichkeit",
		["Enchant Cloak - Lesser Fire Resistance"] = "Umhang - Geringer Feuerwiderstand",
		["Enchant Cloak - Lesser Protection"] = "Umhang - Geringer Schutz",
		["Enchant Cloak - Lesser Shadow Resistance"] = "Umhang - Geringer Schattenwiderstand",
		["Enchant Cloak - Major Armor"] = "Umhang - Erhebliche Rüstung",
		["Enchant Cloak - Major Resistance"] = "Umhang - Erheblicher Widerstand",
		["Enchant Cloak - Minor Agility"] = "Umhang - Schwache Beweglichkeit",
		["Enchant Cloak - Minor Protection"] = "Umhang - Schwacher Schutz",
		["Enchant Cloak - Minor Resistance"] = "Umhang - Schwacher Widerstand",
		["Enchant Cloak - Resistance"] = "Umhang - Widerstand",
		["Enchant Cloak - Spell Penetration"] = "Umhang - Zauberdurchschlagskraft",
		["Enchant Cloak - Stealth"] = "Umhang - Verstohlenheit",
		["Enchant Cloak - Subtlety"] = "Umhang - Feingefühl",
		["Enchant Cloak - Superior Defense"] = "Umhang - Überragende Verteidigung",
		["Enchant Gloves - Advanced Herbalism"] = "Handschuhe - Hochentwickelte Kräuterkunde",
		["Enchant Gloves - Advanced Mining"] = "Handschuhe - Hochentwickelter Bergbau",
		["Enchant Gloves - Agility"] = "Handschuhe - Beweglichkeit",
		["Enchant Gloves - Assault"] = "Handschuhe - Sturmangriff",
		["Enchant Gloves - Blasting"] = "Handschuhe - Sprengkraft",
		["Enchant Gloves - Fire Power"] = "Handschuhe - Feuermacht",
		["Enchant Gloves - Fishing"] = "Handschuhe - Angeln",
		["Enchant Gloves - Frost Power"] = "Handschuhe - Frostmacht",
		["Enchant Gloves - Greater Agility"] = "Handschuhe - Große Beweglichkeit",
		["Enchant Gloves - Greater Strength"] = "Handschuhe - Große Stärke",
		["Enchant Gloves - Healing Power"] = "Handschuhe - Heilkraft",
		["Enchant Gloves - Herbalism"] = "Handschuhe - Kräuterkunde",
		["Enchant Gloves - Major Healing"] = "Handschuhe - Erhebliche Heilung",
		["Enchant Gloves - Major Spellpower"] = "Handschuhe - Erhebliche Zaubermacht",
		["Enchant Gloves - Major Strength"] = "Handschuhe - Erhebliche Stärke",
		["Enchant Gloves - Mining"] = "Handschuhe - Bergbau",
		["Enchant Gloves - Minor Haste"] = "Handschuhe - Schwache Hast",
		["Enchant Gloves - Riding Skill"] = "Handschuhe - Reitfertigkeit",
		["Enchant Gloves - Shadow Power"] = "Handschuhe - Schattenmacht",
		["Enchant Gloves - Skinning"] = "Handschuhe - Kürschnerei",
		["Enchant Gloves - Spell Strike"] = "Handschuhe - Zauberschlag",
		["Enchant Gloves - Strength"] = "Handschuhe - Stärke",
		["Enchant Gloves - Superior Agility"] = "Handschuhe - Überragende Beweglichkeit",
		["Enchant Gloves - Threat"] = "Handschuhe - Bedrohung",
		["Enchant Ring - Healing Power"] = "Ring - Heilkraft",
		["Enchant Ring - Spellpower"] = "Ring - Zaubermacht",
		["Enchant Ring - Stats"] = "Ring - Werte",
		["Enchant Ring - Striking"] = "Ring - Schlagen",
		["Enchant Shield - Frost Resistance"] = "Schild - Frostwiderstand",
		["Enchant Shield - Greater Spirit"] = "Schild - Große Willenskraft",
		["Enchant Shield - Greater Stamina"] = "Schild - Große Ausdauer",
		["Enchant Shield - Intellect"] = "Schild - Intelligenz",
		["Enchant Shield - Lesser Block"] = "Schild - Geringes Blocken",
		["Enchant Shield - Lesser Protection"] = "Schild - Geringer Schutz",
		["Enchant Shield - Lesser Spirit"] = "Schild - Geringe Willenskraft",
		["Enchant Shield - Lesser Stamina"] = "Schild - Geringe Ausdauer",
		["Enchant Shield - Major Stamina"] = "Schild - Erhebliche Ausdauer",
		["Enchant Shield - Minor Stamina"] = "Schild - Schwache Ausdauer",
		["Enchant Shield - Resistance"] = "Schild - Widerstand",
		["Enchant Shield - Shield Block"] = "Schild - Schildblock",
		["Enchant Shield - Spirit"] = "Schild - Willenskraft",
		["Enchant Shield - Stamina"] = "Schild - Ausdauer",
		["Enchant Shield - Superior Spirit"] = "Schild - Erhebliche Willenskraft",
		["Enchant Shield - Resilience"] = "Schild - Abhärtung",
		["Enchant Shield - Tough Shield"] = "Schild - Harter Schild",
		["Enchant Weapon - Agility"] = "Waffe - Beweglichkeit",
		["Enchant Weapon - Battlemaster"] = "Waffe - Meister des Kampfes",
		["Enchant Weapon - Crusader"] = "Waffe - Kreuzfahrer",
		["Enchant Weapon - Demonslaying"] = "Waffe - Dämonentöten",
		["Enchant Weapon - Executioner"] = "Waffe - Scharfrichter",
		["Enchant Weapon - Fiery Weapon"] = "Waffe - Feurige Waffe",
		["Enchant Weapon - Greater Agility"] = "Waffe - Große Beweglichkeit",
		["Enchant Weapon - Greater Striking"] = "Waffe - Großes Schlagen",
		["Enchant Weapon - Healing Power"] = "Waffe - Heilkraft",
		["Enchant Weapon - Icy Chill"] = "Waffe - Eisiger Hauch",
		["Enchant Weapon - Lesser Beastslayer"] = "Waffe - Geringer Wildtiertöter",
		["Enchant Weapon - Lesser Elemental Slayer"] = "Waffe - Geringer Elementartöter",
		["Enchant Weapon - Lesser Striking"] = "Waffe - Geringes Schlagen",
		["Enchant Weapon - Lifestealing"] = "Waffe - Lebensdiebstahl",
		["Enchant Weapon - Major Healing"] = "Waffe - Erhebliche Heilung",
		["Enchant Weapon - Major Intellect"] = "Waffe - Erhebliche Intelligenz",
		["Enchant Weapon - Major Spellpower"] = "Waffe - Erhebliche Zaubermacht",
		["Enchant Weapon - Major Striking"] = "Waffe - Erhebliches Schlagen",
		["Enchant Weapon - Mighty Intellect"] = "Waffe - Mächtige Intelligenz",
		["Enchant Weapon - Mighty Spirit"] = "Waffe - Mächtige Willenskraft",
		["Enchant Weapon - Minor Beastslayer"] = "Waffe - Schwacher Wildtiertöter",
		["Enchant Weapon - Minor Striking"] = "Waffe - Schwaches Schlagen",
		["Enchant Weapon - Mongoose"] = "Waffe - Mungo",
		["Enchant Weapon - Potency"] = "Waffe - Potenz",
		["Enchant Weapon - Soulfrost"] = "Waffe - Seelenfrost",
		["Enchant Weapon - Spell Power"] = "Waffe - Zauberkraft",
		["Enchant Weapon - Spellsurge"] = "Waffe - Zauberflut",
		["Enchant Weapon - Strength"] = "Waffe - Stärke",
		["Enchant Weapon - Striking"] = "Waffe - Schlagen",
		["Enchant Weapon - Sunfire"] = "Waffe - Sonnenfeuer",
		["Enchant Weapon - Superior Striking"] = "Waffe - Überragendes Schlagen",
		["Enchant Weapon - Unholy Weapon"] = "Waffe - Unheilige Waffe",
		["Enchant Weapon - Winter's Might"] = "Waffe - Wintermacht",
		["Enchanted Leather"] = "Verzaubertes Leder",
		["Enchanted Thorium"] = "Verzaubertes Thorium",
		["Greater Magic Wand"] = "Großer Magiezauberstab",
		["Greater Mystic Wand"] = "Großer Mystikerzauberstab",
		["Large Prismatic Shard"] = "Großer Prismasplitter",
		["Lesser Magic Wand"] = "Geringer Magiezauberstab",
		["Lesser Mana Oil"] = "Geringes Manaöl",
		["Lesser Mystic Wand"] = "Geringer Mystikerzauberstab",
		["Lesser Wizard Oil"] = "Geringes Zauberöl",
		["Minor Mana Oil"] = "Schwaches Manaöl",
		["Minor Wizard Oil"] = "Schwaches Zauberöl",
		["Nexus Transformation"] = "Nexusverwandlung",
		["Prismatic Sphere"] = "Prismasphäre",
		["Runed Adamantite Rod"] = "Runenverzierte Adamantitrute",
		["Runed Arcanite Rod"] = "Runenverzierte Arkanitrute",
		["Runed Copper Rod"] = "Runenverzierte Kupferrute",
		["Runed Eternium Rod"] = "Runenverzierte Eterniumrute",
		["Runed Fel Iron Rod"] = "Runenverzierte Teufelseisenrute",
		["Runed Golden Rod"] = "Runenverzierte Goldrute",
		["Runed Silver Rod"] = "Runenverzierte Silberrute",
		["Runed Truesilver Rod"] = "Runenverzierte Echtsilberrute",
		["Small Prismatic Shard"] = "Kleiner Prismasplitter",
		["Smoking Heart of the Mountain"] = "Rauchendes Herz des Berges",
		["Superior Mana Oil"] = "Überragendes Manaöl",
		["Superior Wizard Oil"] = "Überragendes Zauberöl",
		["Void Sphere"] = "Sphäre der Leere",
		["Wizard Oil"] = "Zauberöl",

-- Engineering Recipes
		["Accurate Scope"] = "Genaues Zielfernrohr",
		["Adamantite Arrow Maker"] = "Automat für Adamantitpfeile",
		["Adamantite Frame"] = "Adamantitrahmen",
		["Adamantite Grenade"] = "Adamantitgranate",
		["Adamantite Rifle"] = "Adamantitgewehr",
		["Adamantite Scope"] = "Adamantitzielfernrohr",
		["Adamantite Shell Machine"] = "Maschine für Adamantitpatronen",
		["Advanced Target Dummy"] = "Hochentwickelte Zielattrappe",
		["Alarm-O-Bot"] = "Alarm-O-Bot",
		["Aquadynamic Fish Attractor"] = "Aquadynamischer Fischanlocker",
		["Arcane Bomb"] = "Arkane Bombe",
		["Arcanite Dragonling"] = "Arkanitdrachling",
		["Arclight Spanner"] = "Bogenlichtschraubenschlüssel",
		["Big Bronze Bomb"] = "Große Bronzebombe",
		["Big Iron Bomb"] = "Große Eisenbombe",
		["Biznicks 247x128 Accurascope"] = "Biznicks 247x128 treffsicheres Zielfernrohr",
		["Bloodvine Goggles"] = "Blutrebenschutzbrille",
		["Bloodvine Lens"] = "Blutrebenlinse",
		["Blue Firework"] = "Blaues Feuerwerk",
		["Blue Rocket Cluster"] = "Blaues Raketenbündel",
		["Bright-Eye Goggles"] = "Hellaugenschutzbrille",
		["Bronze Framework"] = "Bronzegerüst",
		["Bronze Tube"] = "Bronzeröhre",
		["Catseye Ultra Goggles"] = "Ultraschutzbrille der Katzensicht",
		["Coarse Blasting Powder"] = "Grobes Sprengpulver",
		["Coarse Dynamite"] = "Grobes Dynamit",
		["Cogspinner Goggles"] = "Zahnradbrille",
		["Compact Harvest Reaper Kit"] = "Kompaktes Ernteschnitterset",
		["Copper Modulator"] = "Kupfermodulator",
		["Copper Tube"] = "Kupferrohr",
		["Core Marksman Rifle"] = "Kernscharfschützengewehr",
		["Crafted Heavy Shot"] = "Gefertigtes schweres Geschoss",
		["Crafted Light Shot"] = "Gefertigtes leichtes Geschoss",
		["Crafted Solid Shot"] = "Gefertigtes robustes Geschoss",
		["Craftsman's Monocle"] = "Handwerkermonokel",
		["Crashin' Thrashin' Robot"] = "Krachbummroboter",
		["Crude Scope"] = "Kunstloses Zielfernrohr",
		["Dark Iron Bomb"] = "Dunkeleisenbombe",
		["Dark Iron Rifle"] = "Dunkeleisengewehr",
		["Deadly Blunderbuss"] = "Tödliche Donnerbüchse",
		["Deadly Scope"] = "Tödliches Zielfernrohr",
		["Deathblow X11 Goggles"] = "Totmacherbrille X11",
		["Deepdive Helmet"] = "Helm des Tiefseetauchers",
		["Delicate Arcanite Converter"] = "Empfindlicher Arkanitwandler",
		["Dense Blasting Powder"] = "Dichtes Sprengpulver",
		["Dense Dynamite"] = "Dichtes Dynamit",
		["Destruction Holo-gogs"] = "Holobrille der Zerstörung",
		["Dimensional Ripper - Area 52"] = "Dimensionszerfetzer: Area 52",
		["Dimensional Ripper - Everlook"] = "Dimensionszerfetzer: Ewige Warte",
		["Discombobulator Ray"] = "Diskombobulatorstrahl",
		["Elemental Blasting Powder"] = "Elementarsprengpulver",
		["Elemental Seaforium Charge"] = "Elementare Zephyriumladung",
		["Explosive Sheep"] = "Explodierendes Schaf",
		["EZ-Thro Dynamite II"] = "EZ-Thro-Dynamit II",
		["EZ-Thro Dynamite"] = "EZ-Thro-Dynamit",
		["Fel Iron Bomb"] = "Teufelseisenbombe",
		["Fel Iron Casing"] = "Teufelseisengehäuse",
		["Fel Iron Musket"] = "Teufelseisenmuskete",
		["Fel Iron Shells"] = "Teufelseisenpatronen",
		["Fel Iron Toolbox"] = "Werkzeugkasten aus Teufelseisen",
		["Felsteel Boomstick"] = "Teufelsstahlschießeisen",
		["Felsteel Stabilizer"] = "Teufelsstahlstabilisator",
		["Field Repair Bot 110G"] = "Feldreparaturbot 110G",
		["Field Repair Bot 74A"] = "Feldreparaturbot 74A",
		["Fire Goggles"] = "Feuerschutzbrille",
		["Firework Cluster Launcher"] = "Zünder für Raketenbündel",
		["Firework Launcher"] = "Zünder für Feuerwerk",
		["Flame Deflector"] = "Flammendeflektor",
		["Flash Bomb"] = "Blitzstrahlbombe",
		["Flawless Arcanite Rifle"] = "Fehlerloses Arkanitgewehr",
		["Flying Machine"] = "Flugmaschine",
		["Flying Tiger Goggles"] = "Fliegerbrille",
		["Force Reactive Disk"] = "Machtreaktive Scheibe",
		["Foreman's Enchanted Helmet"] = "Verzauberter Helm des Vorarbeiters",
		["Foreman's Reinforced Helmet"] = "Verstärkter Helm des Vorarbeiters",
		["Frost Grenades"] = "Frostgranaten",
		["Furious Gizmatic Goggles"] = "Gizmatische Wahnsinnsbrille",
		["Fused Wiring"] = "Verschmorte Verkabelung",
		["Gadgetstorm Goggles"] = "Gadgetsturmbrille",
		["Gnomish Battle Chicken"] = "Gnomenkampfhuhn",
		["Gnomish Battle Goggles"] = "Gnomische Kampfschutzbrille",
		["Gnomish Cloaking Device"] = "Gnomisches Verbergungsgerät",
		["Gnomish Death Ray"] = "Gnomentodesstrahl",
		["Gnomish Flame Turret"] = "Gnomisches Flammengeschütz",
		["Gnomish Goggles"] = "Gnomenschutzbrille",
		["Gnomish Harm Prevention Belt"] = "Gnomenunglücksverhinderungsgürtel",
		["Gnomish Mind Control Cap"] = "Gnomengedankenkontrollkappe",
		["Gnomish Net-o-Matic Projector"] = "Gnomen-Net-o-Matik-Projektor",
		["Gnomish Poultryizer"] = "Gnomischer Geflügelisierer",
		["Gnomish Power Goggles"] = "Gnomische Machtschutzbrille",
		["Gnomish Rocket Boots"] = "Gnomenraketenstiefel",
		["Gnomish Shrink Ray"] = "Gnomenschrumpfstrahl",
		["Gnomish Universal Remote"] = "Gnomenuniversalfernbedienung",
		["Goblin Bomb Dispenser"] = "Goblinbombenspender",
		["Goblin Construction Helmet"] = "Goblinschutzhelm",
		["Goblin Dragon Gun"] = "Goblindrachenwerfer",
		["Goblin Jumper Cables XL"] = "Goblinüberbrückungskabel XL",
		["Goblin Jumper Cables"] = "Goblinüberbrückungskabel",
		["Goblin Land Mine"] = "Goblinlandmine",
		["Goblin Mining Helmet"] = "Goblinbergbauhelm",
		["Goblin Mortar"] = "Goblinmörser",
		["Goblin Rocket Boots"] = "Goblinraketenstiefel",
		["Goblin Rocket Fuel Recipe"] = "Rezept für Goblinraketentreibstoff",
		["Goblin Rocket Helmet"] = "Goblinraketenhelm",
		["Goblin Rocket Launcher"] = "Goblinraketenwerfer",
		["Goblin Sapper Charge"] = "Goblinpioniersprengladung",
		["Gold Power Core"] = "Goldkraftkern",
		["Green Firework"] = "Grünes Feuerwerk",
		["Green Lens"] = "Grüne Linse",
		["Green Rocket Cluster"] = "Grünes Raketenbündel",
		["Green Smoke Flare"] = "Grünes Rauchsignal",
		["Green Tinted Goggles"] = "Schutzbrille mit grünen Gläsern",
		["Gyro-balanced Khorium Destroyer"] = "Gyrobalancierter Khoriumzerstörer",
		["Gyrochronatom"] = "Gyrochronatom",
		["Gyrofreeze Ice Reflector"] = "Gyrofrosteisreflektor",
		["Gyromatic Micro-Adjustor"] = "Gyromatischer Mikroregler",
		["Handful of Copper Bolts"] = "Eine Hand voll Kupferbolzen",
		["Handful of Fel Iron Bolts"] = "Eine Hand voll Teufelseisenbolzen",
		["Hardened Adamantite Tube"] = "Gehärtetes Adamantitrohr",
		["Healing Potion Injector"] = "Heiltrankeinspritzung",
		["Heavy Blasting Powder"] = "Schweres Sprengpulver",
		["Heavy Dynamite"] = "Schweres Dynamit",
		["Hi-Explosive Bomb"] = "Hochexplosive Bombe",
		["Hi-Impact Mithril Slugs"] = "Stark einschlagende Mithrilpatronen",
		["Hyper-Radiant Flame Reflector"] = "Hyperstrahlender Flammenreflektor",
		["Hyper-Vision Goggles"] = "Extremsichtbrille",
		["Ice Deflector"] = "Eisdeflektor",
		["Icy Blasting Primers"] = "Eisiger Sprengzünder",
		["Inlaid Mithril Cylinder Plans"] = "Pläne: Veredelter Mithrilzylinder",
		["Iron Grenade"] = "Eisengranate",
		["Iron Strut"] = "Eisenstrebe",
		["Justicebringer 2000 Specs"] = "Gerechtomatbrille 2000",
		["Khorium Power Core"] = "Khoriumkraftkern",
		["Khorium Scope"] = "Khoriumzielfernrohr",
		["Large Blue Rocket Cluster"] = "Großes blaues Raketenbündel",
		["Large Blue Rocket"] = "Große blaue Rakete",
		["Large Copper Bomb"] = "Große Kupferbombe",
		["Large Green Rocket Cluster"] = "Großes grünes Raketenbündel",
		["Large Green Rocket"] = "Große grüne Rakete",
		["Large Red Rocket Cluster"] = "Großes rotes Raketenbündel",
		["Large Red Rocket"] = "Große rote Rakete",
		["Large Seaforium Charge"] = "Große Zephyriumladung",
		["Lifelike Mechanical Toad"] = "Lebensechte mechanische Kröte",
		["Lil' Smoky"] = "Lil' Smoky",
		["Living Replicator Specs"] = "Lebensreplikatorbrille",
		["Lovingly Crafted Boomstick"] = "Liebevoll hergestelltes Schießeisen",
		["Magnified Moon Specs"] = "Mondlupenbrille",
		["Major Recombobulator"] = "Großer Rekombobulator",
		["Mana Potion Injector"] = "Manatrankeinspritzung",
		["Master Engineer's Goggles"] = "Schutzbrille des Meisteringenieurs",
		["Masterwork Target Dummy"] = "Meisterliche Zielattrappe",
		["Mechanical Dragonling"] = "Mechanischer Drachling",
		["Mechanical Repair Kit"] = "Mechanisches Reparierset",
		["Mechanical Squirrel"] = "Mechanisches Eichhörnchen",
		["Minor Recombobulator"] = "Schwacher Rekombobulator",
		["Mithril Blunderbuss"] = "Mithrildonnerbüchse",
		["Mithril Casing"] = "Mithrilgehäuse",
		["Mithril Frag Bomb"] = "Mithrilschrapnellbombe",
		["Mithril Gyro-Shot"] = "Gyromithrilgeschoss",
		["Mithril Heavy-bore Rifle"] = "Schwerkalibriges Mithrilgewehr",
		["Mithril Mechanical Dragonling"] = "Mechanischer Mithrildrachling",
		["Mithril Tube"] = "Mithrilrohr",
		["Moonsight Rifle"] = "Mondsichtgewehr",
		["Nigh-Invulnerability Belt"] = "Gürtel der fast perfekten Unverwundbarkeit",
		["Ornate Khorium Rifle"] = "Verschnörkeltes Khoriumgewehr",
		["Ornate Spyglass"] = "Verschnörkeltes Handfernrohr",
		["Parachute Cloak"] = "Fallschirmumhang",
		["Pet Bombling"] = "Winzige wandelnde Bombe",
		["Portable Bronze Mortar"] = "Tragbarer bronzener Mörser",
		["Power Amplification Goggles"] = "Energieverstärkungsbrille",
		["Powerful Seaforium Charge"] = "Mächtige Zephyriumladung",
		["Powerheal 4000 Lens"] = "Superheillinse 4000",
		["Practice Lock"] = "Übungsschloss",
		["Purple Smoke Flare"] = "Violettes Rauchsignal",
		["Red Firework"] = "Rotes Feuerwerk",
		["Red Rocket Cluster"] = "Rotes Raketenbündel",
		["Rocket Boots Xtreme"] = "Raketenstiefel Xtrem",
		["Rose Colored Goggles"] = "Rosarote Schutzbrille",
		["Rough Blasting Powder"] = "Raues Sprengpulver",
		["Rough Boomstick"] = "Raues Schießeisen",
		["Rough Copper Bomb"] = "Raue Kupferbombe",
		["Rough Dynamite"] = "Raues Dynamit",
		["Salt Shaker"] = "Salzstreuer",
		["Shadow Goggles"] = "Schattenschutzbrille",
		["Silver Contact"] = "Silberkontakt",
		["Silver-plated Shotgun"] = "Versilberte Schrotflinte",
		["Small Blue Rocket"] = "Kleine blaue Rakete",
		["Small Bronze Bomb"] = "Kleine Bronzebombe",
		["Small Green Rocket"] = "Kleine grüne Rakete",
		["Small Red Rocket"] = "Kleine rote Rakete",
		["Small Seaforium Charge"] = "Kleine Zephyriumladung",
		["Snake Burst Firework"] = "Schlangenexplosionsfeuerwerk",
		["Sniper Scope"] = "Heckenschützenzielfernrohr",
		["SnowMaster 9000"] = "Schneemeister 9000",
		["Solid Blasting Powder"] = "Robustes Sprengpulver",
		["Solid Dynamite"] = "Robustes Dynamit",
		["Spellpower Goggles Xtreme Plus"] = "Zaubermachtschutzbrille Xtrem Plus",
		["Spellpower Goggles Xtreme"] = "Zaubermachtschutzbrille Xtrem",
		["Stabilized Eternium Scope"] = "Geeichtes Eterniumzielfernrohr",
		["Standard Scope"] = "Standardzielfernrohr",
		["Steam Tonk Controller"] = "Dampfpanzersteuerung",
		["Super Sapper Charge"] = "Super Pioniersprengladung",
		["Surestrike Goggles v2.0"] = "Volltrefferbrille v2.0",
		["Tankatronic Goggles"] = "Panzatronikbrille",
		["Target Dummy"] = "Zielattrappe",
		["The Big One"] = "Der Große",
		["The Bigger One"] = "Der Größere",
		["The Mortar: Reloaded"] = "Der Mörser: Wieder aufgeladen",
		["Thorium Grenade"] = "Thoriumgranate",
		["Thorium Rifle"] = "Thoriumgewehr",
		["Thorium Shells"] = "Thoriumpatronen",
		["Thorium Tube"] = "Thoriumröhre",
		["Thorium Widget"] = "Thoriumapparat",
		["Tranquil Mechanical Yeti"] = "Ruhiger mechanischer Yeti",
		["Truesilver Transformer"] = "Echtsilberumwandler",
		["Turbo-Charged Flying Machine"] = "Turbogetriebene Flugmaschine",
		["Ultra-Flash Shadow Reflector"] = "Ultrablendender Schattenreflektor",
		["Ultrasafe Transporter - Gadgetzan"] = "Extrem sicherer Transporter: Gadgetzan",
		["Ultrasafe Transporter - Toshley's Station"] = "Extrem sicherer Transporter: Toshleys Station",
		["Ultra-Spectropic Detection Goggles"] = "Ultraspektropische Enthüllungsbrille",
		["Unstable Trigger"] = "Instabiler Auslöser",
		["Voice Amplification Modulator"] = "Modularer Stimmenverstärker",
		["Whirring Bronze Gizmo"] = "Surrendes bronzenes Dingsda",
		["White Smoke Flare"] = "Weißes Rauchsignal",
		["Wonderheal XT40 Shades"] = "Wunderheilbinokel XT40",
		["World Enlarger"] = "Weltvergrößerer",
		["Zapthrottle Mote Extractor"] = "Schockdrosselnder Partikelextraktor",

-- First Aid Recipes
		["Anti-Venom"] = "Gegengift",
		["Heavy Linen Bandage"] = "Schwerer Leinenverband",
		["Heavy Mageweave Bandage"] = "Schwerer Magiestoffverband",
		["Heavy Netherweave Bandage"] = "Schwerer Netherstoffverband",
		["Heavy Runecloth Bandage"] = "Schwerer Runenstoffverband",
		["Heavy Silk Bandage"] = "Schwerer Seidenverband",
		["Heavy Wool Bandage"] = "Schwerer Wollverband",
		["Linen Bandage"] = "Leinenverband",
		["Mageweave Bandage"] = "Magiestoffverband",
		["Netherweave Bandage"] = "Netherstoffverband",
		["Powerful Anti-Venom"] = "Mächtiges Gegengift",
		["Runecloth Bandage"] = "Runenstoffverband",
		["Silk Bandage"] = "Seidenverband",
		["Strong Anti-Venom"] = "Starkes Gegengift",
		["Wool Bandage"] = "Wollverband",

-- Jewelcrafting Recipes
		["Amulet of the Moon"] = "Amulett des Mondes",
		["Aquamarine Pendant of the Warrior"] = "Aquamarinanhänger des Kriegers",
		["Aquamarine Signet"] = "Aquamarinsiegel",
		["Arcane Khorium Band"] = "Arkanes Khoriumband",
		["Azure Moonstone Ring"] = "Azurmondsteinring",
		["Balanced Nightseye"] = "Ausbalanciertes Nachtauge",
		["Balanced Shadowsong Amethyst"] = "Ausbalancierter Schattensangamethyst",
		["Balanced Shadow Draenite"] = "Ausbalancierter Schattendraenit",
		["Band of Natural Fire"] = "Band des Naturfeuers",
		["Barbaric Iron Collar"] = "Barbarisches Eisenhalsband",
		["Blazing Citrine Ring"] = "Citrinring der Loderflamme",
		["Blazing Eternium Band"] = "Eterniumband der Loderflamme",
		["Blood of Amber"] = "Bernsteinblut",
		["Bold Blood Garnet"] = "Klobiger Blutgranat",
		["Bold Crimson Spinel"] = "Klobiger Purpurspinell",
		["Bold Living Ruby"] = "Klobiger lebendiger Rubin",
		["Bracing Earthstorm Diamond"] = "Starker Erdsturmdiamant",
		["Braided Copper Ring"] = "Umflochtener Kupferring",
		["Braided Eternium Chain"] = "Geflochtene Eterniumkette",
		["Bright Blood Garnet"] = "Heller Blutgranat",
		["Bright Crimson Spinel"] = "Heller Purpurspinell",
		["Bright Living Ruby"] = "Heller lebendiger Rubin",
		["Brilliant Dawnstone"] = "Brillantierter Dämmerstein",
		["Brilliant Golden Draenite"] = "Brillantierter Golddraenit",
		["Brilliant Lionseye"] = "Brillantiertes Löwenauge",
		["Brilliant Necklace"] = "Blitzende Halskette",
		["Brilliant Pearl Band"] = "Blitzendes Perlenband",
		["Bronze Band of Force"] = "Bronzeband der Kraft",
		["Bronze Setting"] = "Bronzefassung",
		["Bronze Torc"] = "Bronzehalsring",
		["Brutal Earthstorm Diamond"] = "Grober Erdsturmdiamant",
		["Chain of the Twilight Owl"] = "Kette der Nebeleule",
		["Chaotic Skyfire Diamond"] = "Wechselhafter Himmelsfeuerdiamant",
		["Circlet of Arcane Might"] = "Reif der arkanen Macht",
		["Citrine Pendant of Golden Healing"] = "Citrinanhänger der goldenen Heilung",
		["Citrine Ring of Rapid Healing"] = "Citrinring der rapiden Heilung",
		["Coarse Stone Statue"] = "Grobe Steinstatue",
		["Coronet of the Verdant Flame"] = "Kronenreif der grünen Flamme",
		["Crimson Sun"] = "Blutrote Sonne",
		["Crown of the Sea Witch"] = "Krone der Meerhexe",
		["Dazzling Deep Peridot"] = "Schillernder Tiefenperidot",
		["Dazzling Seaspray Emerald"] = "Schillernder Gischtsmaragd",
		["Dazzling Talasite"] = "Schillernder Talasit",
		["Delicate Blood Garnet"] = "Feingeschliffener Blutgranat",
		["Delicate Copper Wire"] = "Feiner Kupferdraht",
		["Delicate Crimson Spinel"] = "Feingeschliffener Purpurspinell",
		["Delicate Eternium Ring"] = "Feiner Eterniumring",
		["Delicate Living Ruby"] = "Feingeschliffener lebendiger Rubin",
		["Dense Stone Statue"] = "Verdichtete Steinstatue",
		["Destructive Skyfire Diamond"] = "Zerstörerischer Himmelsfeuerdiamant",
		["Diamond Focus Ring"] = "Diamantener Fokusring",
		["Don Julio's Heart"] = "Don Julios Herz",
		["Elegant Silver Ring"] = "Eleganter Silberring",
		["Embrace of the Dawn"] = "Zärtliche Morgenröte",
		["Emerald Crown of Destruction"] = "Smaragdkrone der Zerstörung",
		["Emerald Lion Ring"] = "Smaragdring des Löwen",
		["Enduring Deep Peridot"] = "Robuster Tiefenperidot",
		["Enduring Seaspray Emerald"] = "Robuster Gischtsmaragd",
		["Enduring Talasite"] = "Robuster Talasit",
		["Engraved Truesilver Ring"] = "Gravierter Echtsilberring",
		["Enigmatic Skyfire Diamond"] = "Rätselhafter Himmelsfeuerdiamant",
		["Eye of the Night"] = "Auge der Nacht",
		["Facet of Eternity"] = "Facette der Ewigkeit",
		["Falling Star"] = "Sternschnuppe",
		["Fel Iron Blood Ring"] = "Teufelseisenblutring",
		["Figurine - Black Diamond Crab"] = "Figur - Schwarzer Diamantkrebs",
		["Figurine - Black Pearl Panther"] = "Figur - Schwarzer Perlenpanther",
		["Figurine - Dark Iron Scorpid"] = "Figur - Dunkeleisenskorpid",
		["Figurine - Dawnstone Crab"] = "Figur - Dämmersteinkrebs",
		["Figurine - Emerald Owl"] = "Figur - Smaragdeule",
		["Figurine - Felsteel Boar"] = "Figur - Teufelsstahleber",
		["Figurine - Golden Hare"] = "Figur - Goldener Hase",
		["Figurine - Jade Owl"] = "Figur - Jadeeule",
		["Figurine - Living Ruby Serpent"] = "Figur - Lebendige Rubinschlange",
		["Figurine - Nightseye Panther"] = "Figur - Nachtaugenpanther",
		["Figurine - Ruby Serpent"] = "Figur - Rubinschlange",
		["Figurine - Talasite Owl"] = "Figur - Talasiteule",
		["Figurine - Truesilver Boar"] = "Figur - Echtsilbereber",
		["Figurine - Truesilver Crab"] = "Figur - Echtsilberkrebs",
		["Flashing Crimson Spinel"] = "Scheinender Purpurspinell",
		["Flashing Living Ruby"] = "Scheinender lebendiger Rubin",
		["Gem Studded Band"] = "Edelsteinbesetztes Band",
		["Gleaming Dawnstone"] = "Schimmernder Dämmerstein",
		["Gleaming Golden Draenite"] = "Schimmernder Golddraenit",
		["Gleaming Lionseye"] = "Schimmerndes Löwenauge",
		["Glinting Flame Spessarite"] = "Glitzernder Flammenspessarit",
		["Glinting Noble Topaz"] = "Glitzernder Edeltopas",
		["Glinting Pyrestone"] = "Glitzernder Pyrostein",
		["Gloom Band"] = "Band der Schwermut",
		["Glowing Nightseye"] = "Leuchtendes Nachtauge",
		["Glowing Shadow Draenite"] = "Leuchtender Schattendraenit",
		["Glowing Shadowsong Amethyst"] = "Leuchtender Schattensangamethyst",
		["Glowing Thorium Band"] = "Leuchtendes Thoriumband",
		["Golden Draenite Ring"] = "Golddraenitring",
		["Golden Dragon Ring"] = "Goldener Drachenring",
		["Golden Ring of Power"] = "Goldring der Macht",
		["Great Dawnstone"] = "Großer Dämmerstein",
		["Great Golden Draenite"] = "Großer Golddraenit",
		["Great Lionseye"] = "Großes Löwenauge",
		["Heavy Adamantite Ring"] = "Schwerer Adamantitring",
		["Heavy Copper Ring"] = "Schwerer Kupferring",
		["Heavy Felsteel Ring"] = "Schwerer Teufelsstahlring",
		["Heavy Golden Necklace of Battle"] = "Schwere goldene Halskette des Kampfes",
		["Heavy Iron Knuckles"] = "Schwerer Eisenschlagring",
		["Heavy Jade Ring"] = "Schwerer Jadering",
		["Heavy Silver Ring"] = "Schwerer silberner Ring",
		["Heavy Stone Statue"] = "Schwere Steinstatue",
		["Infused Nightseye"] = "Energieerfülltes Nachtauge",
		["Infused Shadow Draenite"] = "Energieerfüllter Schattendraenit",
		["Infused Shadowsong Amethyst"] = "Energieerfüllter Schattensangamethyst",
		["Inlaid Malachite Ring"] = "Veredelter Malachitring",
		["Inscribed Flame Spessarite"] = "Gravierter Flammenspessarit",
		["Inscribed Noble Topaz"] = "Gravierter Edeltopas",
		["Inscribed Pyrestone"] = "Gravierter Pyrostein",
		["Insightful Earthstorm Diamond"] = "Bemerkenswerter Erdsturmdiamant",
		["Jade Pendant of Blasting"] = "Jadeanhänger der Zauberwucht",
		["Jagged Deep Peridot"] = "Gezackter Tiefenperidot",
		["Jagged Seaspray Emerald"] = "Gezackter Gischtsmaragd",
		["Jagged Talasite"] = "Gezackter Talasit",
		["Kailee's Rose"] = "Kailees Rose",
		["Khorium Band of Frost"] = "Khoriumband des Frosts",
		["Khorium Band of Leaves"] = "Khoriumband des Laubs",
		["Khorium Band of Shadows"] = "Khoriumband der Schatten",
		["Khorium Inferno Band"] = "Khoriuminfernoband",
		["Living Emerald Pendant"] = "Lebendiger Smaragdanhänger",
		["Living Ruby Pendant"] = "Lebendiger Rubinanhänger",
		["Luminous Flame Spessarite"] = "Glänzender Flammenspessarit",
		["Luminous Noble Topaz"] = "Glänzender Edeltopas",
		["Luminous Pyrestone"] = "Glänzender Pyrostein",
		["Lustrous Azure Moonstone"] = "Irisierender Azurmondstein",
		["Lustrous Empyrean Sapphire"] = "Irisierender Engelssaphir",
		["Lustrous Star of Elune"] = "Irisierender Stern der Elune",
		["Malachite Pendant"] = "Malachitanhänger",
		["Mercurial Adamantite"] = "Quecksilberadamantit",
		["Mithril Filigree"] = "Filigranarbeit aus Mithril",
		["Moonsoul Crown"] = "Krone der Mondseele",
		["Mystic Dawnstone"] = "Mystischer Dämmerstein",
		["Mystic Lionseye"] = "Mystisches Löwenauge",
		["Mystical Skyfire Diamond"] = "Mystischer Himmelsfeuerdiamant",
		["Necklace of the Deep"] = "Halskette der Tiefen",
		["Necklace of the Diamond Tower"] = "Halskette des Diamantturms",
		["Onslaught Ring"] = "Ring des Ansturms",
		["Opal Necklace of Impact"] = "Opalhalskette des Einschlags",
		["Ornate Tigerseye Necklace"] = "Verzierte Tigeraugenhalskette",
		["Pendant of Frozen Flame"] = "Anhänger der Eisflamme",
		["Pendant of Shadow's End"] = "Anhänger der Schattenneige",
		["Pendant of Thawing"] = "Anhänger des Tauens",
		["Pendant of the Agate Shield"] = "Anhänger des Achatschilds",
		["Pendant of the Null Rune"] = "Anhänger der Nullrune",
		["Pendant of Withering"] = "Anhänger des Erlöschens",
		["Potent Flame Spessarite"] = "Mächtiger Flammenspessarit",
		["Potent Noble Topaz"] = "Mächtiger Edeltopas",
		["Potent Pyrestone"] = "Mächtiger Pyrostein",
		["Powerful Earthstorm Diamond"] = "Mächtiger Erdsturmdiamant",
		["Purified Jaggal Pearl"] = "Geläuterte Jaggalperle",
		["Purified Shadow Pearl"] = "Geläuterte Schattenperle",
		["Radiant Deep Peridot"] = "Strahlender Tiefenperidot",
		["Radiant Seaspray Emerald"] = "Strahlender Gischtsmaragd",
		["Radiant Talasite"] = "Strahlender Talasit",
		["Red Ring of Destruction"] = "Roter Ring der Zerstörung",
		["Relentless Earthstorm Diamond"] = "Unerbittlicher Erdsturmdiamant",
		["Rigid Dawnstone"] = "Massiver Dämmerstein",
		["Rigid Golden Draenite"] = "Massiver Golddraenit",
		["Rigid Lionseye"] = "Massives Löwenauge",
		["Ring of Arcane Shielding"] = "Ring des Arkanschutzes",
		["Ring of Bitter Shadows"] = "Ring der qualvollen Schatten",
		["Ring of Silver Might"] = "Ring der Silbermacht",
		["Ring of Twilight Shadows"] = "Ring des Zwielichts",
		["Rough Stone Statue"] = "Raue Steinstatue",
		["Royal Nightseye"] = "Königliches Nachtauge",
		["Royal Shadow Draenite"] = "Königlicher Schattendraenit",
		["Royal Shadowsong Amethyst"] = "Königlicher Schattensangamethyst",
		["Ruby Crown of Restoration"] = "Rubinkrone der Wiederherstellung",
		["Ruby Pendant of Fire"] = "Rubinanhänger des Feuers",
		["Runed Blood Garnet"] = "Runenverzierter Blutgranat",
		["Runed Crimson Spinel"] = "Runenverzierter Purpurspinell",
		["Runed Living Ruby"] = "Runenverzierter lebendiger Rubin",
		["Sapphire Pendant of Winter Night"] = "Saphiranhänger der Winternacht",
		["Sapphire Signet"] = "Saphirsiegel",
		["Shifting Nightseye"] = "Unbeständiges Nachtauge",
		["Shifting Shadow Draenite"] = "Unbeständiger Schattendraenit",
		["Shifting Shadowsong Amethyst"] = "Unbeständiger Schattensangamethyst",
		["Simple Opal Ring"] = "Einfacher Opalring",
		["Simple Pearl Ring"] = "Einfacher Perlenring",
		["Smooth Dawnstone"] = "Glatter Dämmerstein",
		["Smooth Golden Draenite"] = "Glatter Golddraenit",
		["Smooth Lionseye"] = "Glattes Löwenauge",
		["Solid Azure Moonstone"] = "Gediegener Azurmondstein",
		["Solid Bronze Ring"] = "Robuster Bronzering",
		["Solid Empyrean Sapphire"] = "Gediegener Engelssaphir",
		["Solid Star of Elune"] = "Gediegener Stern der Elune",
		["Solid Stone Statue"] = "Robuste Steinstatue",
		["Sovereign Nightseye"] = "Stattliches Nachtauge",
		["Sovereign Shadow Draenite"] = "Stattlicher Schattendraenit",
		["Sovereign Shadowsong Amethyst"] = "Stattlicher Schattensangamethyst",
		["Sparkling Azure Moonstone"] = "Funkelnder Azurmondstein",
		["Sparkling Empyrean Sapphire"] = "Funkelnder Engelssaphir",
		["Sparkling Star of Elune"] = "Funkelnder Stern der Elune",
		["Steady Talasite"] = "Beständiger Talasit",
		["Stone of Blades"] = "Stein der Klingen",
		["Stormy Azure Moonstone"] = "Stürmischer Azurmondstein",
		["Stormy Empyrean Sapphire"] = "Stürmischer Engelssaphir",
		["Stormy Star of Elune"] = "Stürmischer Stern der Elune",
		["Subtle Crimson Spinel"] = "Fragiler Purpurspinell",
		["Subtle Living Ruby"] = "Fragiler lebendiger Rubin",
		["Swift Skyfire Diamond"] = "Flüchtiger Himmelsfeuerdiamant",
		["Teardrop Blood Garnet"] = "Tränenförmiger Blutgranat",
		["Teardrop Crimson Spinel"] = "Tränenförmiger Purpurspinell",
		["Teardrop Living Ruby"] = "Tränenförmiger lebendiger Rubin",
		["Tenacious Earthstorm Diamond"] = "Harter Erdsturmdiamant",
		["The Aquamarine Ward"] = "Der Aquamarinbeschützer",
		["The Black Pearl"] = "Die schwarze Perle",
		["The Frozen Eye"] = "Das gefrorene Auge",
		["The Jade Eye"] = "Das Jadeauge",
		["The Natural Ward"] = "Der Schutz der Natur",
		["Thick Adamantite Necklace"] = "Dicke Adamantithalskette",
		["Thick Bronze Necklace"] = "Dicke Bronzehalskette",
		["Thick Dawnstone"] = "Kompakter Dämmerstein",
		["Thick Felsteel Necklace"] = "Dicke Teufelsstahlhalskette",
		["Thick Golden Draenite"] = "Kompakter Golddraenit",
		["Thick Lionseye"] = "Kompaktes Löwenauge",
		["Thorium Setting"] = "Thoriumfassung",
		["Thundering Skyfire Diamond"] = "Donnernder Himmelsfeuerdiamant",
		["Tigerseye Band"] = "Tigeraugenband",
		["Truesilver Commander's Ring"] = "Echtsilberring des Kommandanten",
		["Truesilver Healing Ring"] = "Echtsilberring der Heilung",
		["Veiled Flame Spessarite"] = "Verschleierter Flammenspessarit",
		["Veiled Noble Topaz"] = "Verschleierter Edeltopas",
		["Veiled Pyrestone"] = "Verschleierter Pyrostein",
		["Wicked Flame Spessarite"] = "Tückischer Flammenspessarit",
		["Wicked Moonstone Ring"] = "Tückischer Mondsteinring",
		["Wicked Noble Topaz"] = "Tückischer Edeltopas",
		["Wicked Pyrestone"] = "Tückischer Pyrostein",
		["Woven Copper Ring"] = "Geflochtener Kupferring",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "Arkanrüstungsset",
		["Bag of Many Hides"] = "Balgtasche",
		["Barbaric Belt"] = "Barbarischer Gürtel",
		["Barbaric Bracers"] = "Barbarische Armschienen",
		["Barbaric Gloves"] = "Barbarische Handschuhe",
		["Barbaric Harness"] = "Barbarischer Harnisch",
		["Barbaric Leggings"] = "Barbarische Gamaschen",
		["Barbaric Shoulders"] = "Barbarische Schultern",
		["Belt of Deep Shadow"] = "Gürtel der tiefen Schatten",
		["Belt of Natural Power"] = "Gürtel der naturgleichen Kraft",
		["Belt of the Black Eagle"] = "Gürtel des schwarzen Adlers",
		["Big Voodoo Cloak"] = "Großer Voodooumhang",
		["Big Voodoo Mask"] = "Große Voodoomaske",
		["Big Voodoo Pants"] = "Große Voodoohose",
		["Big Voodoo Robe"] = "Große Voodoorobe",
		["Bindings of Lightning Reflexes"] = "Bindungen der blitzartigen Reflexe",
		["Black Dragonscale Boots"] = "Schwarze Drachenschuppenstiefel",
		["Black Dragonscale Breastplate"] = "Schwarze Drachenschuppenbrustplatte",
		["Black Dragonscale Leggings"] = "Schwarze Drachenschuppengamaschen",
		["Black Dragonscale Shoulders"] = "Schwarze Drachenschuppenschultern",
		["Black Whelp Cloak"] = "Schwarzwelpenumhang",
		["Black Whelp Tunic"] = "Schwarzwelpentunika",
		["Blackstorm Leggings"] = "Gamaschen des schwarzen Sturms",
		["Blastguard Belt"] = "Lohenschildgürtel",
		["Blastguard Boots"] = "Lohenschildstiefel",
		["Blastguard Pants"] = "Lohenschildhose",
		["Blood Tiger Breastplate"] = "Bluttigerbrustplatte",
		["Blood Tiger Shoulders"] = "Bluttigerschultern",
		["Blue Dragonscale Breastplate"] = "Blaue Drachenschuppenbrustplatte",
		["Blue Dragonscale Leggings"] = "Blaue Drachenschuppengamaschen",
		["Blue Dragonscale Shoulders"] = "Blaue Drachenschuppenschultern",
		["Boots of Natural Grace"] = "Stiefel der naturgleichen Anmut",
		["Boots of Shackled Souls"] = "Stiefel der gefangenen Seelen",
		["Boots of the Crimson Hawk"] = "Stiefel des Purpurfalken",
		["Boots of Utter Darkness"] = "Stiefel der totalen Finsternis",
		["Bracers of Renewed Life"] = "Armschienen des neuen Lebens",
		["Bracers of Shackled Souls"] = "Armschienen der gefangenen Seelen",
		["Bramblewood Belt"] = "Dornenholzgürtel",
		["Bramblewood Boots"] = "Dornenholzstiefel",
		["Bramblewood Helm"] = "Dornenholzhelm",
		["Chimeric Boots"] = "Schimärenstiefel",
		["Chimeric Gloves"] = "Schimärenhandschuhe",
		["Chimeric Leggings"] = "Schimärengamaschen",
		["Chimeric Vest"] = "Schimärenweste",
		["Chromatic Cloak"] = "Chromatischer Umhang",
		["Chromatic Gauntlets"] = "Chromatische Stulpen",
		["Clefthide Leg Armor"] = "Grollbalgbeinrüstung",
		["Cloak of Darkness"] = "Umhang der Dunkelheit",
		["Cobrahide Leg Armor"] = "Kobrahautbeinrüstung",
		["Cobrascale Gloves"] = "Kobraschuppenhandschuhe",
		["Cobrascale Hood"] = "Kobraschuppenkapuze",
		["Comfortable Insoles"] = "Bequeme Einlegesohlen",
		["Comfortable Leather Hat"] = "Bequemer Lederhut",
		["Core Armor Kit"] = "Kernrüstungsset",
		["Corehound Belt"] = "Kernhundgürtel",
		["Corehound Boots"] = "Kernhundstiefel",
		["Cured Heavy Hide"] = "Geschmeidiger schwerer Balg",
		["Cured Light Hide"] = "Geschmeidiger leichter Balg",
		["Cured Medium Hide"] = "Geschmeidiger mittlerer Balg",
		["Cured Rugged Hide"] = "Geschmeidiger unverwüstlicher Balg",
		["Cured Thick Hide"] = "Geschmeidiger dicker Balg",
		["Dark Leather Belt"] = "Dunkler Ledergürtel",
		["Dark Leather Boots"] = "Dunkle Lederstiefel",
		["Dark Leather Cloak"] = "Dunkler Lederumhang",
		["Dark Leather Gloves"] = "Dunkle Lederhandschuhe",
		["Dark Leather Pants"] = "Dunkle Lederhose",
		["Dark Leather Shoulders"] = "Dunkle Lederschultern",
		["Dark Leather Tunic"] = "Dunkle Ledertunika",
		["Dawn Treaders"] = "Stiefel der Dämmerung",
		["Deviate Scale Belt"] = "Deviatschuppengürtel",
		["Deviate Scale Cloak"] = "Deviatschuppenumhang",
		["Deviate Scale Gloves"] = "Deviatschuppenhandschuhe",
		["Devilsaur Gauntlets"] = "Teufelssaurierstulpen",
		["Devilsaur Leggings"] = "Teufelssauriergamaschen",
		["Dragonscale Breastplate"] = "Drachenschuppenbrustplatte",
		["Dragonscale Gauntlets"] = "Drachenschuppenstulpen",
		["Dragonstrike Leggings"] = "Gamaschen des Drachenschlags",
		["Dreamscale Breastplate"] = "Traumschuppenbrustplatte",
		["Drums of Battle"] = "Trommeln der Schlacht",
		["Drums of Panic"] = "Trommeln der Panik",
		["Drums of Restoration"] = "Trommeln der Wiederherstellung",
		["Drums of Speed"] = "Trommeln des Tempos",
		["Drums of War"] = "Trommeln des Krieges",
		["Dusky Belt"] = "Schwärzlicher Gürtel",
		["Dusky Boots"] = "Schwärzliche Stiefel",
		["Dusky Bracers"] = "Schwärzliche Armschienen",
		["Dusky Leather Armor"] = "Schwärzliche Lederrüstung",
		["Dusky Leather Leggings"] = "Schwärzliche Ledergamaschen",
		["Earthen Leather Shoulders"] = "Irdene Lederschultern",
		["Earthen Netherscale Boots"] = "Irdene Netherschuppenstiefel",
		["Ebon Netherscale Belt"] = "Ebenholzfarbener Netherschuppengürtel",
		["Ebon Netherscale Bracers"] = "Ebenholzfarbene Netherschuppenarmschienen",
		["Ebon Netherscale Breastplate"] = "Ebenholzfarbene Netherschuppenbrustplatte",
		["Embossed Leather Boots"] = "Geprägte Lederstiefel",
		["Embossed Leather Cloak"] = "Geprägter Lederumhang",
		["Embossed Leather Gloves"] = "Geprägte Lederhandschuhe",
		["Embossed Leather Pants"] = "Geprägte Lederhose",
		["Embossed Leather Vest"] = "Geprägte Lederweste",
		["Enchanted Clefthoof Boots"] = "Verzauberte Grollhufstiefel",
		["Enchanted Clefthoof Gloves"] = "Verzauberte Grollhufhandschuhe",
		["Enchanted Clefthoof Leggings"] = "Verzauberte Grollhufgamaschen",
		["Enchanted Felscale Boots"] = "Verzauberte Teufelsschuppenstiefel",
		["Enchanted Felscale Gloves"] = "Verzauberte Teufelsschuppenhandschuhe",
		["Enchanted Felscale Leggings"] = "Verzauberte Teufelsschuppengamaschen",
		["Feathered Breastplate"] = "Gefiederte Brustplatte",
		["Fel Leather Boots"] = "Teufelslederstiefel",
		["Fel Leather Gloves"] = "Teufelslederhandschuhe",
		["Fel Leather Leggings"] = "Teufelsledergamaschen",
		["Felscale Boots"] = "Teufelsschuppenstiefel",
		["Felscale Breastplate"] = "Teufelsschuppenbrustplatte",
		["Felscale Gloves"] = "Teufelsschuppenhandschuhe",
		["Felscale Pants"] = "Teufelsschuppenhose",
		["Felstalker Belt"] = "Gürtel des Teufelspirschers",
		["Felstalker Bracer"] = "Armschienen des Teufelspirschers",
		["Felstalker Breastplate"] = "Brustplatte des Teufelspirschers",
		["Fine Leather Belt"] = "Feiner Ledergürtel",
		["Fine Leather Boots"] = "Feine Lederstiefel",
		["Fine Leather Cloak"] = "Feiner Lederumhang",
		["Fine Leather Gloves"] = "Feine Lederhandschuhe",
		["Fine Leather Pants"] = "Feine Lederhose",
		["Fine Leather Tunic"] = "Feine Ledertunika",
		["Flame Armor Kit"] = "Flammenrüstungsset",
		["Flamescale Belt"] = "Flammenschuppengürtel",
		["Flamescale Boots"] = "Flammenschuppenstiefel",
		["Flamescale Leggings"] = "Flammenschuppengamaschen",
		["Fletcher's Gloves"] = "Pfeilmacherhandschuhe",
		["Frost Armor Kit"] = "Frostrüstungsset",
		["Frost Leather Cloak"] = "Frostlederumhang",
		["Frostsaber Boots"] = "Frostsäblerstiefel",
		["Frostsaber Gloves"] = "Frostsäblerhandschuhe",
		["Frostsaber Leggings"] = "Frostsäblergamaschen",
		["Frostsaber Tunic"] = "Frostsäblertunika",
		["Gauntlets of the Sea"] = "Stulpen des Meeres",
		["Gem-studded Leather Belt"] = "Edelsteinbesetzter Ledergürtel",
		["Girdle of Insight"] = "Gurt der Einsicht",
		["Glove Reinforcements"] = "Handschuhverstärkung",
		["Gloves of the Greatfather"] = "Handschuhe des Altvaters",
		["Gloves of the Living Touch"] = "Handschuhe der lebendigen Berührung",
		["Golden Dragonstrike Breastplate"] = "Goldene Brustplatte des Drachenschlags",
		["Golden Mantle of the Dawn"] = "Goldener Mantel der Dämmerung",
		["Greaves of Shackled Souls"] = "Schienbeinschützer der gefangenen Seelen",
		["Green Dragonscale Breastplate"] = "Grüne Drachenschuppenbrustplatte",
		["Green Dragonscale Gauntlets"] = "Grüne Drachenschuppenstulpen",
		["Green Dragonscale Leggings"] = "Grüne Drachenschuppengamaschen",
		["Green Leather Armor"] = "Grüne Lederrüstung",
		["Green Leather Belt"] = "Grüner Ledergürtel",
		["Green Leather Bracers"] = "Grüne Lederarmschienen",
		["Green Whelp Armor"] = "Grünwelpenrüstung",
		["Green Whelp Bracers"] = "Grünwelpenarmschienen",
		["Guardian Armor"] = "Wächterrüstung",
		["Guardian Belt"] = "Wächtergürtel",
		["Guardian Cloak"] = "Wächterumhang",
		["Guardian Gloves"] = "Wächterhandschuhe",
		["Guardian Leather Bracers"] = "Wächterlederarmschienen",
		["Guardian Pants"] = "Wächterhose",
		["Handstitched Leather Belt"] = "Handgenähter Ledergürtel",
		["Handstitched Leather Boots"] = "Handgenähte Lederstiefel",
		["Handstitched Leather Bracers"] = "Handgenähte Armschienen",
		["Handstitched Leather Cloak"] = "Handgenähter Lederumhang",
		["Handstitched Leather Pants"] = "Handgenähte Lederhose",
		["Handstitched Leather Vest"] = "Handgenähte Lederweste",
		["Heavy Armor Kit"] = "Schweres Rüstungsset",
		["Heavy Clefthoof Boots"] = "Schwere Grollhufstiefel",
		["Heavy Clefthoof Leggings"] = "Schwere Grollhufgamaschen",
		["Heavy Clefthoof Vest"] = "Schwere Grollhufweste",
		["Heavy Earthen Gloves"] = "Schwere irdene Handschuhe",
		["Heavy Knothide Armor Kit"] = "Schweres Knotenhautlederset",
		["Heavy Knothide Leather"] = "Schweres Knotenhautleder",
		["Heavy Leather Ammo Pouch"] = "Schwerer Ledermunitionsbeutel",
		["Heavy Leather Ball"] = "Schwerer Lederball",
		["Heavy Leather"] = "Schweres Leder",
		["Heavy Quiver"] = "Schwerer Köcher",
		["Heavy Scorpid Belt"] = "Schwerer Skorpidgürtel",
		["Heavy Scorpid Bracers"] = "Schwere Skorpidarmschienen",
		["Heavy Scorpid Gauntlets"] = "Schwere Skorpidstulpen",
		["Heavy Scorpid Helm"] = "Schwerer Skorpidhelm",
		["Heavy Scorpid Leggings"] = "Schwere Skorpidgamaschen",
		["Heavy Scorpid Shoulders"] = "Schwere Skorpidschultern",
		["Heavy Scorpid Vest"] = "Schwere Skorpidweste",
		["Helm of Fire"] = "Helm des Feuers",
		["Herbalist's Gloves"] = "Kräuterkundigenhandschuhe",
		["Hide of the Wild"] = "Balg der Wildnis",
		["Hillman's Belt"] = "Gürtel des Hügelwächters",
		["Hillman's Cloak"] = "Umhang des Hügelwächters",
		["Hillman's Leather Gloves"] = "Lederhandschuhe des Hügelwächters",
		["Hillman's Leather Vest"] = "Lederweste des Hügelwächters",
		["Hillman's Shoulders"] = "Schultern des Hügelwächters",
		["Hood of Primal Life"] = "Kapuze des Urlebens",
		["Hurricane Boots"] = "Stiefel des Wirbelsturms",
		["Icy Scale Bracers"] = "Eisschuppenarmschienen",
		["Icy Scale Breastplate"] = "Eisschuppenbrustplatte",
		["Icy Scale Gauntlets"] = "Eisschuppenstulpen",
		["Ironfeather Breastplate"] = "Eisenfederbrustplatte",
		["Ironfeather Shoulders"] = "Eisenfederschultern",
		["Knothide Ammo Pouch"] = "Munitionsbeutel aus Knotenhautleder",
		["Knothide Armor Kit"] = "Knotenhautrüstungsset",
		["Knothide Leather"] = "Knotenhautleder",
		["Knothide Quiver"] = "Köcher aus Knotenhautleder",
		["Kodo Hide Bag"] = "Kodobalgtasche",
		["Lava Belt"] = "Lavagürtel",
		["Leatherworker's Satchel"] = "Ranzen des Lederers",
		["Light Armor Kit"] = "Leichtes Rüstungsset",
		["Light Leather Bracers"] = "Leichte Lederarmschienen",
		["Light Leather Pants"] = "Leichte Lederhose",
		["Light Leather Quiver"] = "Leichter Lederköcher",
		["Light Leather"] = "Leichtes Leder",
		["Living Breastplate"] = "Lebendige Brustplatte",
		["Living Crystal Breastplate"] = "Lebendige Kristallbrustplatte",
		["Living Dragonscale Helm"] = "Lebendiger Drachenschuppenhelm",
		["Living Earth Bindings"] = "Lebendige Erdbindungen",
		["Living Earth Shoulders"] = "Lebendige Erdschultern",
		["Living Leggings"] = "Lebendige Gamaschen",
		["Living Shoulders"] = "Lebendige Schultern",
		["Magister's Armor Kit"] = "Rüstungsset des Magisters",
		["Medium Armor Kit"] = "Mittleres Rüstungsset",
		["Medium Leather"] = "Mittleres Leder",
		["Might of the Timbermaw"] = "Macht der Holzschlundfeste",
		["Molten Belt"] = "Geschmolzener Gürtel",
		["Molten Helm"] = "Schmelzhelm",
		["Mongoose Boots"] = "Mungostiefel",
		["Monsoon Belt"] = "Gürtel des Monsuns",
		["Moonglow Vest"] = "Mondscheinweste",
		["Murloc Scale Belt"] = "Murlocschuppengürtel",
		["Murloc Scale Bracers"] = "Murlocschuppenarmschienen",
		["Murloc Scale Breastplate"] = "Murlocschuppenbrustplatte",
		["Nature Armor Kit"] = "Naturrüstungsset",
		["Nethercleft Leg Armor"] = "Netherkluftbeinrüstung",
		["Nethercobra Leg Armor"] = "Netherkobrabeinrüstung",
		["Netherdrake Gloves"] = "Netherdrachenhandschuhe",
		["Netherdrake Helm"] = "Netherdrachenhelm",
		["Netherfury Belt"] = "Netherzorngürtel",
		["Netherfury Boots"] = "Netherzornstiefel",
		["Netherfury Leggings"] = "Netherzorngamaschen",
		["Netherscale Ammo Pouch"] = "Munitionsbeutel aus Netherschuppen",
		["Netherstrike Belt"] = "Netherstoßgürtel",
		["Netherstrike Bracers"] = "Netherstoßarmschienen",
		["Netherstrike Breastplate"] = "Netherstoßbrustplatte",
		["Nightscape Boots"] = "Stiefel des Nachtschleichers",
		["Nightscape Headband"] = "Stirnband des Nachtschleichers",
		["Nightscape Pants"] = "Hose des Nachtschleichers",
		["Nightscape Shoulders"] = "Schultern des Nachtschleichers",
		["Nightscape Tunic"] = "Tunika des Nachtschleichers",
		["Nimble Leather Gloves"] = "Behände Lederhandschuhe",
		["Onyxia Scale Cloak"] = "Onyxiaschuppenumhang",
		["Pilferer's Gloves"] = "Langfingerhandschuhe",
		["Polar Bracers"] = "Polararmschienen",
		["Polar Gloves"] = "Polarhandschuhe",
		["Polar Tunic"] = "Polartunika",
		["Primal Batskin Bracers"] = "Urzeitliche Fledermaushautarmschienen",
		["Primal Batskin Gloves"] = "Urzeitliche Fledermaushauthandschuhe",
		["Primal Batskin Jerkin"] = "Urzeitliches Fledermaushautwams",
		["Primalstorm Breastplate"] = "Brustplatte des Ursturms",
		["Primalstrike Belt"] = "Erstschlaggürtel",
		["Primalstrike Bracers"] = "Erstschlagarmschienen",
		["Primalstrike Vest"] = "Erstschlagweste",
		["Quickdraw Quiver"] = "Schnellziehköcher",
		["Quiver of a Thousand Feathers"] = "Köcher der tausend Federn",
		["Raptor Hide Belt"] = "Raptorbalggürtel",
		["Raptor Hide Harness"] = "Raptorbalgharnisch",
		["Red Dragonscale Breastplate"] = "Rote Drachenschuppenbrustplatte",
		["Red Whelp Gloves"] = "Rotwelpenhandschuhe",
		["Redeemed Soul Cinch"] = "Sattelgurt der erlösten Seele",
		["Redeemed Soul Legguards"] = "Beinschützer der erlösten Seele",
		["Redeemed Soul Moccasins"] = "Mokassins der erlösten Seele",
		["Redeemed Soul Wristguards"] = "Handgelenksschützer der erlösten Seele",
		["Reinforced Mining Bag"] = "Verstärkte Bergbautasche",
		["Riding Crop"] = "Reitgerte",
		["Rugged Armor Kit"] = "Unverwüstliches Rüstungsset",
		["Rugged Leather Pants"] = "Unverwüstliche Lederhose",
		["Rugged Leather"] = "Unverwüstliches Leder",
		["Runic Leather Armor"] = "Runenverzierte Lederrüstung",
		["Runic Leather Belt"] = "Runenverzierter Ledergürtel",
		["Runic Leather Bracers"] = "Runenverzierte Lederarmschienen",
		["Runic Leather Gauntlets"] = "Runenverzierte Lederstulpen",
		["Runic Leather Headband"] = "Runenverziertes Lederstirnband",
		["Runic Leather Pants"] = "Runenverzierte Lederhose",
		["Runic Leather Shoulders"] = "Runenverzierte Lederschultern",
		["Sandstalker Bracers"] = "Sandpirscherarmschienen",
		["Sandstalker Breastplate"] = "Sandpirscherbrustplatte",
		["Sandstalker Gauntlets"] = "Sandpirscherstulpen",
		["Scaled Draenic Boots"] = "Geschuppte draenische Stiefel",
		["Scaled Draenic Gloves"] = "Geschuppte draenische Handschuhe",
		["Scaled Draenic Pants"] = "Geschuppte draenische Hose",
		["Scaled Draenic Vest"] = "Geschuppte draenische Weste",
		["Shadow Armor Kit"] = "Schattenrüstungsset",
		["Shadowprowler's Chestguard"] = "Brustschutz des Schattenschleichers",
		["Shadowskin Gloves"] = "Schattenhauthandschuhe",
		["Shifting Cloak"] = "Veränderlicher Umhang",
		["Shoulderpads of Renewed Life"] = "Schulterpolster des neuen Lebens",
		["Shoulders of Lightning Reflexes"] = "Schultern der blitzartigen Reflexe",
		["Small Leather Ammo Pouch"] = "Kleiner Ledermunitionsbeutel",
		["Spitfire Bracers"] = "Feuerspuckerarmschienen",
		["Spitfire Breastplate"] = "Feuerspuckerbrustplatte",
		["Spitfire Gauntlets"] = "Feuerspuckerstulpen",
		["Stormshroud Armor"] = "Sturmschleierrüstung",
		["Stormshroud Gloves"] = "Sturmschleierhandschuhe",
		["Stormshroud Pants"] = "Sturmschleierhose",
		["Stormshroud Shoulders"] = "Sturmschleierschultern",
		["Stylin' Adventure Hat"] = "Schicker Abenteurerhut",
		["Stylin' Crimson Hat"] = "Schicker purpurfarbener Hut",
		["Stylin' Jungle Hat"] = "Schicker Dschungelhut",
		["Stylin' Purple Hat"] = "Schicker lilafarbener Hut",
		["Swift Boots"] = "Hurtige Stiefel",
		["Swift Flight Bracers"] = "Armschienen der schnellen Flucht",
		["Swiftstrike Bracers"] = "Flinkschlagarmschienen",
		["Swiftstrike Shoulders"] = "Flinkschlagschultern",
		["Thick Armor Kit"] = "Dickes Rüstungsset",
		["Thick Draenic Boots"] = "Dicke draenische Stiefel",
		["Thick Draenic Gloves"] = "Dicke draenische Handschuhe",
		["Thick Draenic Pants"] = "Dicke draenische Hose",
		["Thick Draenic Vest"] = "Dicke draenische Weste",
		["Thick Leather Ammo Pouch"] = "Dicker Ledermunitionsbeutel",
		["Thick Leather"] = "Dickes Leder",
		["Thick Murloc Armor"] = "Dicke Murlocrüstung",
		["Thick Netherscale Breastplate"] = "Dicke Netherschuppenbrustplatte",
		["Timbermaw Brawlers"] = "Kampfhandschuhe der Holzschlundfeste",
		["Tough Scorpid Boots"] = "Feste Skorpidstiefel",
		["Tough Scorpid Bracers"] = "Feste Skorpidarmschienen",
		["Tough Scorpid Breastplate"] = "Feste Skorpidbrustplatte",
		["Tough Scorpid Gloves"] = "Feste Skorpidhandschuhe",
		["Tough Scorpid Helm"] = "Fester Skorpidhelm",
		["Tough Scorpid Leggings"] = "Feste Skorpidgamaschen",
		["Tough Scorpid Shoulders"] = "Feste Skorpidschulterstücke",
		["Toughened Leather Armor"] = "Gekräftigte Lederrüstung",
		["Toughened Leather Gloves"] = "Gekräftigte Lederhandschuhe",
		["Turtle Scale Bracers"] = "Schildkrötenschuppenarmschienen",
		["Turtle Scale Breastplate"] = "Schildkrötenschuppenbrustplatte",
		["Turtle Scale Gloves"] = "Schildkrötenschuppenhandschuhe",
		["Turtle Scale Helm"] = "Schildkrötenschuppenhelm",
		["Turtle Scale Leggings"] = "Schildkrötenschuppengamaschen",
		["Vindicator's Armor Kit"] = "Rüstungsset des Verteidigers",
		["Volcanic Breastplate"] = "Vulkanische Brustplatte",
		["Volcanic Leggings"] = "Vulkanische Gamaschen",
		["Volcanic Shoulders"] = "Vulkanische Schultern",
		["Waistguard of Shackled Souls"] = "Taillenschutz der gefangenen Seelen",
		["Warbear Harness"] = "Kriegsbärenharnisch",
		["Warbear Woolies"] = "Kriegsbärenwollwäsche",
		["White Leather Jerkin"] = "Weißes Lederwams",
		["Wicked Leather Armor"] = "Tückische Lederrüstung",
		["Wicked Leather Belt"] = "Tückischer Ledergürtel",
		["Wicked Leather Bracers"] = "Tückische Lederarmschienen",
		["Wicked Leather Gauntlets"] = "Tückische Lederstulpen",
		["Wicked Leather Headband"] = "Tückisches Lederstirnband",
		["Wicked Leather Pants"] = "Tückische Lederhose",
		["Wild Draenish Boots"] = "Wilde draenische Stiefel",
		["Wild Draenish Gloves"] = "Wilde draenische Handschuhe",
		["Wild Draenish Leggings"] = "Wilde draenische Gamaschen",
		["Wild Draenish Vest"] = "Wilde draenische Weste",
		["Wild Leather Boots"] = "Wildlederstiefel",
		["Wild Leather Cloak"] = "Wildlederumhang",
		["Wild Leather Helmet"] = "Wildlederhelm",
		["Wild Leather Leggings"] = "Wildledergamaschen",
		["Wild Leather Shoulders"] = "Wildlederschultern",
		["Wild Leather Vest"] = "Wildlederweste",
		["Wildfeather Leggings"] = "Wildfedergamaschen",
		["Windhawk Belt"] = "Windfalkengürtel",
		["Windhawk Bracers"] = "Windfalkenarmschienen",
		["Windhawk Hauberk"] = "Windfalkenhalsberge",
		["Windscale Hood"] = "Windschuppenkapuze",
		["Windslayer Wraps"] = "Windtöterwickel",
		["Windstrike Gloves"] = "Windstoßhandschuhe",
		["Winter Boots"] = "Winterstiefel",
		["Wolfshead Helm"] = "Wolfskopfhelm",

-- Smelting Recipes
		["Earth Shatter"] = "Erdspaltung",
		["Fire Sunder"] = "Feuerspaltung",
		["Smelt Adamantite"] = "Adamantit verhütten",
		["Smelt Bronze"] = "Bronze verhütten",
		["Smelt Copper"] = "Kupfer verhütten",
		["Smelt Dark Iron"] = "Dunkeleisen verhütten",
		["Smelt Elementium"] = "Elementium verhütten",
		["Smelt Eternium"] = "Eternium verhütten",
		["Smelt Fel Iron"] = "Teufelseisen verhütten",
		["Smelt Felsteel"] = "Teufelsstahl verhütten",
		["Smelt Gold"] = "Gold verhütten",
		["Smelt Hardened Adamantite"] = "Gehärtetes Adamantit verhütten",
		["Smelt Iron"] = "Eisen verhütten",
		["Smelt Khorium"] = "Khorium verhütten",
		["Smelt Mithril"] = "Mithril verhütten",
		["Smelt Silver"] = "Silber verhütten",
		["Smelt Steel"] = "Stahl verhütten",
		["Smelt Thorium"] = "Thorium verhütten",
		["Smelt Tin"] = "Zinn verhütten",
		["Smelt Truesilver"] = "Echtsilber verhütten",

-- Rogue Poisons Recipes
		["Anesthetic Poison"] = "Beruhigendes Gift",
		["Blinding Powder"] = "Blendungspulver",
		["Crippling Poison II"] = "Verkrüppelndes Gift II",
		["Crippling Poison"] = "Verkrüppelndes Gift",
		["Deadly Poison II"] = "Tödliches Gift II",
		["Deadly Poison III"] = "Tödliches Gift III",
		["Deadly Poison IV"] = "Tödliches Gift IV",
		["Deadly Poison V"] = "Tödliches Gift V",
		["Deadly Poison VI"] = "Tödliches Gift VI",
		["Deadly Poison VII"] = "Tödliches Gift VII",
		["Deadly Poison"] = "Tödliches Gift",
		["Instant Poison II"] = "Sofort wirkendes Gift II",
		["Instant Poison III"] = "Sofort wirkendes Gift III",
		["Instant Poison IV"] = "Sofort wirkendes Gift IV",
		["Instant Poison V"] = "Sofort wirkendes Gift V",
		["Instant Poison VI"] = "Sofort wirkendes Gift VI",
		["Instant Poison VII"] = "Sofort wirkendes Gift VII",
		["Instant Poison"] = "Sofort wirkendes Gift",
		["Mind-numbing Poison II"] = "Gedankenbenebelndes Gift II",
		["Mind-numbing Poison III"] = "Gedankenbenebelndes Gift III",
		["Mind-numbing Poison"] = "Gedankenbenebelndes Gift",
		["Wound Poison II"] = "Wundgift II",
		["Wound Poison III"] = "Wundgift III",
		["Wound Poison IV"] = "Wundgift IV",
		["Wound Poison V"] = "Wundgift V",
		["Wound Poison"] = "Wundgift",

-- Tailoring Recipes
		["Admiral's Hat"] = "Admiralshut",
		["Arcanoweave Boots"] = "Arkanostoffstiefel",
		["Arcanoweave Bracers"] = "Arkanostoffarmschienen",
		["Arcanoweave Robe"] = "Arkanostoffrobe",
		["Argent Boots"] = "Argentumstiefel",
		["Argent Shoulders"] = "Argentumschultern",
		["Azure Shoulders"] = "Azurblaue Schultern",
		["Azure Silk Belt"] = "Azurblauer Seidengürtel",
		["Azure Silk Cloak"] = "Azurblauer Seidenumhang",
		["Azure Silk Gloves"] = "Azurblaue Seidenhandschuhe",
		["Azure Silk Hood"] = "Azurblaue Seidenkapuze",
		["Azure Silk Pants"] = "Azurblaue Seidenhose",
		["Azure Silk Vest"] = "Azurblaue Seidenweste",
		["Bag of Jewels"] = "Juwelenbeutel",
		["Barbaric Linen Vest"] = "Barbarische Leinenweste",
		["Battlecast Hood"] = "Kapuze des Schlachtenzaubers",
		["Battlecast Pants"] = "Hose des Schlachtenzaubers",
		["Belt of Blasting"] = "Gürtel der Zauberwucht",
		["Belt of the Archmage"] = "Gürtel des Erzmagiers",
		["Belt of the Long Road"] = "Gürtel des langen Weges",
		["Big Bag of Enchantment"] = "Große Verzauberertasche",
		["Black Belt of Knowledge"] = "Schwarzer Gürtel des Wissens",
		["Black Mageweave Boots"] = "Schwarze Magiestoffstiefel",
		["Black Mageweave Gloves"] = "Schwarze Magiestoffhandschuhe",
		["Black Mageweave Headband"] = "Schwarzes Magiestoffstirnband",
		["Black Mageweave Leggings"] = "Schwarze Magiestoffgamaschen",
		["Black Mageweave Robe"] = "Schwarze Magiestoffrobe",
		["Black Mageweave Shoulders"] = "Schwarze Magiestoffschultern",
		["Black Mageweave Vest"] = "Schwarze Magiestoffweste",
		["Black Silk Pack"] = "Schwarzes Seidenpack",
		["Black Swashbuckler's Shirt"] = "Schwarzes Schwadroneurshemd",
		["Blackstrike Bracers"] = "Schwarzgestreifte Armschienen",
		["Bloodvine Boots"] = "Blutrebenstiefel",
		["Bloodvine Leggings"] = "Blutrebengamaschen",
		["Bloodvine Vest"] = "Blutrebenweste",
		["Blue Linen Robe"] = "Blaue Leinenrobe",
		["Blue Linen Shirt"] = "Blaues Leinenhemd",
		["Blue Linen Vest"] = "Blaue Leinenweste",
		["Blue Overalls"] = "Blauer Overall",
		["Bolt of Imbued Netherweave"] = "Magieerfüllter Netherstoffballen",
		["Bolt of Linen Cloth"] = "Leinenstoffballen",
		["Bolt of Mageweave"] = "Magiestoffballen",
		["Bolt of Netherweave"] = "Netherstoffballen",
		["Bolt of Runecloth"] = "Runenstoffballen",
		["Bolt of Silk Cloth"] = "Seidenstoffballen",
		["Bolt of Soulcloth"] = "Seelenstoffballen",
		["Bolt of Woolen Cloth"] = "Wollstoffballen",
		["Boots of Blasting"] = "Stiefel der Zauberwucht",
		["Boots of the Enchanter"] = "Stiefel des Verzauberers",
		["Boots of the Long Road"] = "Stiefel des langen Weges",
		["Bottomless Bag"] = "Bodenlose Tasche",
		["Bracers of Havok"] = "Armschienen der Verwüstung",
		["Bracers of Nimble Thought"] = "Armschienen des flinken Gedankens",
		["Bright Yellow Shirt"] = "Hellgelbes Hemd",
		["Brightcloth Cloak"] = "Hellstoffumhang",
		["Brightcloth Gloves"] = "Hellstoffhandschuhe",
		["Brightcloth Pants"] = "Hellstoffhose",
		["Brightcloth Robe"] = "Hellstoffrobe",
		["Brown Linen Pants"] = "Braune Leinenhose",
		["Brown Linen Robe"] = "Braune Leinenrobe",
		["Brown Linen Shirt"] = "Braunes Leinenhemd",
		["Brown Linen Vest"] = "Braune Leinenweste",
		["Cenarion Herb Bag"] = "Cenarische Kräutertasche",
		["Cindercloth Boots"] = "Aschenstoffstiefel",
		["Cindercloth Cloak"] = "Aschenstoffumhang",
		["Cindercloth Gloves"] = "Aschenstoffhandschuhe",
		["Cindercloth Pants"] = "Aschenstoffhose",
		["Cindercloth Robe"] = "Aschenstoffrobe",
		["Cindercloth Vest"] = "Aschenstoffweste",
		["Cloak of Arcane Evasion"] = "Umhang der Arkanflucht",
		["Cloak of Eternity"] = "Umhang der Ewigkeit",
		["Cloak of Fire"] = "Umhang des Feuers",
		["Cloak of the Black Void"] = "Umhang der schwarzen Leere",
		["Cloak of Warding"] = "Schutzumhang der Verteidigung",
		["Colorful Kilt"] = "Bunter Kilt",
		["Core Felcloth Bag"] = "Kernteufelsstofftasche",
		["Crimson Silk Belt"] = "Purpurroter Seidengürtel",
		["Crimson Silk Cloak"] = "Purpurroter Seidenumhang",
		["Crimson Silk Gloves"] = "Purpurrote Seidenhandschuhe",
		["Crimson Silk Pantaloons"] = "Purpurrote Seidenpantalons",
		["Crimson Silk Robe"] = "Purpurrote Seidenrobe",
		["Crimson Silk Shoulders"] = "Purpurrote Seidenschultern",
		["Crimson Silk Vest"] = "Purpurrote Seidenweste",
		["Dark Silk Shirt"] = "Dunkles Seidenhemd",
		["Double-stitched Woolen Shoulders"] = "Doppeltgenähte Wollschultern",
		["Dreamweave Circlet"] = "Traumzwirnreif",
		["Dreamweave Gloves"] = "Traumzwirnhandschuhe",
		["Dreamweave Vest"] = "Traumzwirnweste",
		["Earthen Silk Belt"] = "Irdener Seidengürtel",
		["Earthen Vest"] = "Irdene Weste",
		["Ebon Shadowbag"] = "Schwarzschattentasche",
		["Enchanted Mageweave Pouch"] = "Verzauberter Magiestoffbeutel",
		["Enchanted Runecloth Bag"] = "Verzauberte Runenstofftasche",
		["Enchanter's Cowl"] = "Verzauberergugel",
		["Felcloth Bag"] = "Teufelsstofftasche",
		["Felcloth Boots"] = "Teufelsstoffstiefel",
		["Felcloth Gloves"] = "Teufelsstoffhandschuhe",
		["Felcloth Hood"] = "Teufelsstoffkapuze",
		["Felcloth Pants"] = "Teufelsstoffhose",
		["Felcloth Robe"] = "Teufelsstoffrobe",
		["Felcloth Shoulders"] = "Teufelsstoffschultern",
		["Festival Dress"] = "Festtagskleid",
		--["Festive Red Dress"] = "Festtagskleid", -- doesn't exist!
		["Festive Red Pant Suit"] = "Festlicher roter Hosenanzug",
		["Flameheart Bracers"] = "Flammenherzarmschienen",
		["Flameheart Gloves"] = "Flammenherzhandschuhe",
		["Flameheart Vest"] = "Flammenherzweste",
		["Flarecore Gloves"] = "Flimmerkernhandschuhe",
		["Flarecore Leggings"] = "Flimmerkerngamaschen",
		["Flarecore Mantle"] = "Flimmerkernmantel",
		["Flarecore Robe"] = "Flimmerkernrobe",
		["Flarecore Wraps"] = "Flimmerkernwickeltücher",
		["Formal White Shirt"] = "Formelles weißes Hemd",
		["Frostweave Gloves"] = "Winterzwirnhandschuhe",
		["Frostweave Pants"] = "Winterzwirnhose",
		["Frostweave Robe"] = "Winterzwirnrobe",
		["Frostweave Tunic"] = "Winterzwirntunika",
		["Frozen Shadoweave Boots"] = "Eisschattenzwirnstiefel",
		["Frozen Shadoweave Shoulders"] = "Eisschattenzwirnschultern",
		["Frozen Shadoweave Robe"] = "Eisschattenzwirnrobe",
		["Gaea's Embrace"] = "Gaeas Umarmung",
		["Ghostweave Belt"] = "Geisterzwirngürtel",
		["Ghostweave Gloves"] = "Geisterzwirnhandschuhe",
		["Ghostweave Pants"] = "Geisterzwirnhose",
		["Ghostweave Vest"] = "Geisterzwirnweste",
		["Girdle of Ruination"] = "Gurt der Zerstörung",
		["Glacial Cloak"] = "Gletscherumhang",
		["Glacial Gloves"] = "Gletscherhandschuhe",
		["Glacial Vest"] = "Gletscherweste",
		["Glacial Wrists"] = "Gletscherhandschutz",
		["Gloves of Meditation"] = "Handschuhe der Meditation",
		["Gloves of Spell Mastery"] = "Handschuhe der Zauberbeherrschung",
		["Golden Spellthread"] = "Goldener Zauberfaden",
		["Gordok Ogre Suit"] = "Ogeranzug der Gordok",
		["Gray Woolen Robe"] = "Graue Wollrobe",
		["Gray Woolen Shirt"] = "Graues Wollhemd",
		["Greater Adept's Robe"] = "Große Adeptenrobe",
		["Green Holiday Shirt"] = "Grünes Festtagshemd",
		["Green Linen Bracers"] = "Grüne Leinenarmschienen",
		["Green Linen Shirt"] = "Grünes Leinenhemd",
		["Green Silk Armor"] = "Grüne Seidenrüstung",
		["Green Silk Pack"] = "Grünes Seidenpack",
		["Green Silken Shoulders"] = "Grüne Seidenschultern",
		["Green Winter Clothes"] = "Grüne Winterkleidung",
		["Green Woolen Bag"] = "Grüne Wolltasche",
		["Green Woolen Vest"] = "Grüne Wollweste",
		["Hands of Darkness"] = "Hände der Dunkelheit",
		["Handstitched Linen Britches"] = "Handgenähte Leinenkniehosen",
		["Heavy Linen Gloves"] = "Schwere Leinenhandschuhe",
		["Heavy Woolen Cloak"] = "Schwerer Wollumhang",
		["Heavy Woolen Gloves"] = "Schwere Wollhandschuhe",
		["Heavy Woolen Pants"] = "Schwere Wollhose",
		["Icy Cloak"] = "Eisiger Umhang",
		["Imbued Netherweave Bag"] = "Magieerfüllte Netherstofftasche",
		["Imbued Netherweave Boots"] = "Magieerfüllte Netherstoffstiefel",
		["Imbued Netherweave Pants"] = "Magieerfüllte Netherstoffhose",
		["Imbued Netherweave Robe"] = "Magieerfüllte Netherstoffrobe",
		["Imbued Netherweave Tunic"] = "Magieerfüllte Netherstofftunika",
		["Inferno Gloves"] = "Infernohandschuhe",
		["Lavender Mageweave Shirt"] = "Lavendelfarbenes Magiestoffhemd",
		["Lesser Wizard's Robe"] = "Geringe Hexerrobe",
		["Linen Bag"] = "Leinentasche",
		["Linen Belt"] = "Leinengürtel",
		["Linen Boots"] = "Leinenstiefel",
		["Linen Cloak"] = "Leinenumhang",
		["Long Silken Cloak"] = "Langer Seidenumhang",
		["Mageweave Bag"] = "Magiestofftasche",
		["Manaweave Cloak"] = "Managewirkter Umhang",
		["Mantle of Nimble Thought"] = "Mantelung des flinken Gedankens",
		["Mantle of the Timbermaw"] = "Mantel der Holzschlundfeste",
		["Mooncloth Bag"] = "Mondstofftasche",
		["Mooncloth Boots"] = "Mondstoffstiefel",
		["Mooncloth Circlet"] = "Mondstoffreif",
		["Mooncloth Gloves"] = "Mondstoffhandschuhe",
		["Mooncloth Leggings"] = "Mondstoffgamaschen",
		["Mooncloth Robe"] = "Mondstoffrobe",
		["Mooncloth Shoulders"] = "Mondstoffschultern",
		["Mooncloth Vest"] = "Mondstoffweste",
		["Mooncloth"] = "Mondstoff",
		["Mystic Spellthread"] = "Mystischer Zauberfaden",
		["Netherweave Bag"] = "Netherstofftasche",
		["Netherweave Belt"] = "Netherstoffgürtel",
		["Netherweave Boots"] = "Netherstoffstiefel",
		["Netherweave Bracers"] = "Netherstoffarmschienen",
		["Netherweave Gloves"] = "Netherstoffhandschuhe",
		["Netherweave Net"] = "Netherstoffnetz",
		["Netherweave Pants"] = "Netherstoffhose",
		["Netherweave Robe"] = "Netherstoffrobe",
		["Netherweave Tunic"] = "Netherstofftunika",
		["Night's End"] = "Nachtend",
		["Orange Mageweave Shirt"] = "Orangefarbenes Magiestoffhemd",
		["Orange Martial Shirt"] = "Orangefarbenes Kampfhemd",
		["Pearl-clasped Cloak"] = "Perlenschnallenumhang",
		["Phoenix Gloves"] = "Phönixhandschuhe",
		["Phoenix Pants"] = "Phönixhose",
		["Pink Mageweave Shirt"] = "Rosa Magiestoffhemd",
		["Primal Mooncloth Bag"] = "Urmondstofftasche",
		["Primal Mooncloth Belt"] = "Urmondstoffgürtel",
		["Primal Mooncloth Robe"] = "Urmondstoffrobe",
		["Primal Mooncloth Shoulders"] = "Urmondstoffschultern",
		["Primal Mooncloth"] = "Urmondstoff",
		["Red Linen Bag"] = "Rote Leinentasche",
		["Red Linen Robe"] = "Rote Leinenrobe",
		["Red Linen Shirt"] = "Rotes Leinenhemd",
		["Red Linen Vest"] = "Rote Leinenweste",
		["Red Mageweave Bag"] = "Rote Magiestofftasche",
		["Red Mageweave Gloves"] = "Rote Magiestoffhandschuhe",
		["Red Mageweave Headband"] = "Rotes Magiestoffstirnband",
		["Red Mageweave Pants"] = "Rote Magiestoffhose",
		["Red Mageweave Shoulders"] = "Rote Magiestoffschultern",
		["Red Mageweave Vest"] = "Rote Magiestoffweste",
		["Red Swashbuckler's Shirt"] = "Rotes Schwadroneurshemd",
		["Red Woolen Bag"] = "Rote Wolltasche",
		["Red Woolen Boots"] = "Rote Wollstiefel",
		["Reinforced Linen Cape"] = "Verstärktes Leinencape",
		["Red Winter Clothes"] = "Rote Winterkleidung",
		["Reinforced Woolen Shoulders"] = "Verstärkte Wollschultern",
		["Resolute Cape"] = "Cape der Entschlossenheit",
		["Rich Purple Silk Shirt"] = "Dunkellila Seidenhemd",
		["Robe of Power"] = "Robe der Macht",
		["Robe of the Archmage"] = "Robe des Erzmagiers",
		["Robe of the Void"] = "Robe der Leere",
		["Robe of Winter Night"] = "Robe der Winternacht",
		["Robes of Arcana"] = "Roben von Arcana",
		["Runecloth Bag"] = "Runenstofftasche",
		["Runecloth Belt"] = "Runenstoffgürtel",
		["Runecloth Boots"] = "Runenstoffstiefel",
		["Runecloth Cloak"] = "Runenstoffumhang",
		["Runecloth Gloves"] = "Runenstoffhandschuhe",
		["Runecloth Headband"] = "Runenstoffstirnband",
		["Runecloth Pants"] = "Runenstoffhose",
		["Runecloth Robe"] = "Runenstoffrobe",
		["Runecloth Shoulders"] = "Runenstoffschultern",
		["Runecloth Tunic"] = "Runenstofftunika",
		["Runed Stygian Belt"] = "Runenverzierter stygischer Gürtel",
		["Runed Stygian Boots"] = "Runenverzierte stygische Stiefel",
		["Runed Stygian Leggings"] = "Runenverzierte stygische Gamaschen",
		["Runic Spellthread"] = "Runenverzierter Zauberfaden",
		["Satchel of Cenarius"] = "Cenarischer Ranzen",
		["Shadow Hood"] = "Schattenkapuze",
		["Shadowcloth"] = "Schattenstoff",
		["Shadoweave Boots"] = "Schattenzwirnstiefel",
		["Shadoweave Gloves"] = "Schattenzwirnhandschuhe",
		["Shadoweave Mask"] = "Schattenzwirnmaske",
		["Shadoweave Pants"] = "Schattenzwirnhose",
		["Shadoweave Robe"] = "Schattenzwirnrobe",
		["Shadoweave Shoulders"] = "Schattenzwirnschultern",
		["Silk Headband"] = "Seidenes Stirnband",
		["Silver Spellthread"] = "Silberner Zauberfaden",
		["Simple Black Dress"] = "Einfaches schwarzes Kleid",
		["Simple Dress"] = "Einfaches Kleid",
		["Simple Kilt"] = "Einfacher Kilt",
		["Simple Linen Boots"] = "Einfache Leinenstiefel",
		["Simple Linen Pants"] = "Einfache Leinenhose",
		["Small Silk Pack"] = "Kleines Seidenpack",
		["Soft-soled Linen Boots"] = "Leinenschuhe mit weichen Sohlen",
		["Soul Pouch"] = "Seelenbeutel",
		["Soulcloth Gloves"] = "Seelenstoffhandschuhe",
		["Soulcloth Shoulders"] = "Seelenstoffschultern",
		["Soulcloth Vest"] = "Seelenstoffweste",
		["Soulguard Bracers"] = "Armschienen der Seelenwache",
		["Soulguard Girdle"] = "Gurt der Seelenwache",
		["Soulguard Leggings"] = "Gamaschen der Seelenwache",
		["Soulguard Slippers"] = "Schuhe der Seelenwache",
		["Spellcloth"] = "Zauberstoff",
		["Spellfire Bag"] = "Zauberfeuertasche",
		["Spellfire Belt"] = "Zauberfeuergürtel",
		["Spellfire Gloves"] = "Zauberfeuerhandschuhe",
		["Spellfire Robe"] = "Zauberfeuerrobe",
		["Spellstrike Hood"] = "Kapuze des Zauberschlags",
		["Spellstrike Pants"] = "Hose des Zauberschlags",
		["Spider Belt"] = "Spinnengürtel",
		["Spider Silk Slippers"] = "Spinnenseidenslipper",
		["Spidersilk Boots"] = "Spinnenseidenstiefel",
		["Star Belt"] = "Sternengürtel",
		["Stylish Blue Shirt"] = "Modisches blaues Hemd",
		["Stylish Green Shirt"] = "Modisches grünes Hemd",
		["Stylish Red Shirt"] = "Modisches rotes Hemd",
		["Swiftheal Mantle"] = "Flinkheilmantelung",
		["Swiftheal Wraps"] = "Flinkheiltücher",
		["Sylvan Crown"] = "Sylvankrone",
		["Sylvan Shoulders"] = "Sylvanschultern",
		["Sylvan Vest"] = "Sylvanweste",
		["Truefaith Gloves"] = "Handschuhe des wahren Glaubens",
		["Truefaith Vestments"] = "Trachten des wahren Glaubens",
		["Tuxedo Jacket"] = "Smokingjacke",
		["Tuxedo Pants"] = "Smokinghose",
		["Tuxedo Shirt"] = "Smokinghemd",
		["Unyielding Bracers"] = "Armschienen des Unerschütterlichen",
		["Unyielding Girdle"] = "Gurt des Unerschütterlichen",
		["Vengeance Wrap"] = "Wickeltuch der Vergeltung",
		["White Bandit Mask"] = "Weiße Banditenmaske",
		["White Linen Robe"] = "Weiße Leinenrobe",
		["White Linen Shirt"] = "Weißes Leinenhemd",
		["White Remedy Cape"] = "Weißer Arzneikittel",
		["White Swashbuckler's Shirt"] = "Weißes Schwadroneurshemd",
		["White Wedding Dress"] = "Weißes Hochzeitskleid",
		["White Woolen Dress"] = "Weißes Wollkleid",
		["Whitemend Hood"] = "Kapuze des weißen Heilers",
		["Whitemend Pants"] = "Hose des weißen Heilers",
		["Wisdom of the Timbermaw"] = "Weisheit der Holzschlundfeste",
		["Wizardweave Leggings"] = "Hexerzwirngamaschen",
		["Wizardweave Robe"] = "Hexerzwirnrobe",
		["Wizardweave Turban"] = "Hexerzwirnturban",
		["Woolen Bag"] = "Wolltasche",
		["Woolen Boots"] = "Wollstiefel",
		["Woolen Cape"] = "Wollcape",
	}
end)

BabbleTradeskill:RegisterTranslations("frFR", function()
	return {
-- Gathering skills
		["Disenchant"] = "Désenchanter",
		["Fishing"] = "Pêche",
		["Herbalism"] = "Herboristerie",
		["Mining"] = "Minage",
		["Pick Pocket"] = "Vol à la tire",
		["Prospecting"] = "Prospection",
		["Skinning"] = "Dépecage",
		["Smelting"] = "Fondre",

-- Crafting skills
		["Alchemy"] = "Alchimie",
		["Armorsmith"] = "Fabricant d'armures",
		["Blacksmithing"] = "Forge",
		["Cooking"] = "Cuisine",
		["Dragonscale Leatherworking"] = "Travail du cuir d'écailles de dragon",
		["Elemental Leatherworking"] = "Travail du cuir élémentaire",
		["Elixir Master"] = "Maître des élixirs",
		["Enchanting"] = "Enchantement",
		["Engineering"] = "Ingénierie",
		["First Aid"] = "Premiers soins",
		["Gnomish Engineering"] = "Ingénieur gnome",
		["Goblin Engineering"] = "Ingénieur gobelin",
		["Gnomish Engineer"] = "Ingénieur gnome",
		["Goblin Engineer"] = "Ingénieur gobelin",
		["Jewelcrafting"] = "Joaillerie",
		["Leatherworking"] = "Travail du cuir",
		["Master Axesmith"] = "Fabricant de haches",
		["Master Hammersmith"] = "Fabricant de marteaux",
		["Master Swordsmith"] = "Fabricant d'épées",
		["Mooncloth Tailoring"] = "Couture d'étoffe lunaire",
		["Poisons"] = "Poisons",
		["Potion Master"] = "Maître des potions",
		["Shadoweave Tailoring"] = "Couture de tisse-ombre",
		["Spellfire Tailoring"] = "Couture du feu-sorcier",
		["Tailoring"] = "Couture",
		["Transmutation Master"] = "Maître des transmutations",
		["Tribal Leatherworking"] = "Travail du cuir tribal",
		["Weaponsmith"] = "Fabricant d'armes",

-- Alchemy Recipes
		["Adept's Elixir"] = "Elixir d'adepte",
		["Alchemist's Stone"] = "Pierre d'alchimiste",
		["Arcane Elixir"] = "Elixir des arcanes",
		["Blackmouth Oil"] = "Huile de bouche-noire",
		["Catseye Elixir"] = "Elixir d'oeil de chat",
		["Cauldron of Major Arcane Protection"] = "Chaudron de protection contre les Arcanes majeure",
		["Cauldron of Major Fire Protection"] = "Chaudron de protection contre le Feu majeure",
		["Cauldron of Major Frost Protection"] = "Chaudron de protection contre le Givre majeure",
		["Cauldron of Major Nature Protection"] = "Chaudron de protection contre la Nature majeure",
		["Cauldron of Major Shadow Protection"] = "Chaudron de protection contre l'Ombre majeure",
		["Destruction Potion"] = "Potion de destruction",
		["Discolored Healing Potion"] = "Potion de soins décolorée",
		["Dreamless Sleep Potion"] = "Potion de sommeil sans rêve",
		["Earthen Elixir"] = "Elixir terrestre",
		["Elixir of Agility"] = "Elixir d'agilité",
		["Elixir of Brute Force"] = "Elixir de force de brute",
		["Elixir of Camouflage"] = "Elixir de dissimulation",
		["Elixir of Defense"] = "Elixir de défense",
		["Elixir of Demonslaying"] = "Elixir de tueur de démon",
		["Elixir of Detect Demon"] = "Elixir de détection des démons",
		["Elixir of Detect Lesser Invisibility"] = "Elixir de détection de l'invisibilité inférieure",
		["Elixir of Detect Undead"] = "Elixir de détection des morts-vivants",
		["Elixir of Draenic Wisdom"] = "Elixir de sagesse draenique",
		["Elixir of Dream Vision"] = "Elixir de vision de rêve",
		["Elixir of Empowerment"] = "Elixir de renforcement",
		["Elixir of Firepower"] = "Elixir de maîtrise du Feu",
		["Elixir of Fortitude"] = "Elixir de robustesse",
		["Elixir of Frost Power"] = "Elixir de puissance du Givre",
		["Elixir of Giant Growth"] = "Elixir de taille de géant",
		["Elixir of Giants"] = "Elixir des géants",
		["Elixir of Greater Agility"] = "Elixir d'agilité supérieure",
		["Elixir of Greater Defense"] = "Elixir de défense supérieure",
		["Elixir of Greater Firepower"] = "Elixir de maîtrise du Feu supérieure",
		["Elixir of Greater Intellect"] = "Elixir d'intelligence supérieure",
		["Elixir of Greater Water Breathing"] = "Elixir de respiration aquatique supérieure",
		["Elixir of Healing Power"] = "Elixir de pouvoir de guérison",
		["Elixir of Ironskin"] = "Elixir peau-de-fer",
		["Elixir of Lesser Agility"] = "Elixir d'agilité inférieure",
		["Elixir of Lion's Strength"] = "Elixir de force du lion",
		["Elixir of Major Agility"] = "Elixir d'agilité majeure",
		["Elixir of Major Defense"] = "Elixir de défense majeure",
		["Elixir of Major Firepower"] = "Elixir de maîtrise du Feu majeure",
		["Elixir of Major Fortitude"] = "Elixir de robustesse majeure",
		["Elixir of Major Frost Power"] = "Elixir de puissance du Givre majeure",
		["Elixir of Major Mageblood"] = "Elixir magesang majeur",
		["Elixir of Major Shadow Power"] = "Elixir de puissance de l'Ombre majeure",
		["Elixir of Major Strength"] = "Elixir de force majeure",
		["Elixir of Mastery"] = "Elixir de maîtrise",
		["Elixir of Minor Agility"] = "Elixir d'agilité mineure",
		["Elixir of Minor Defense"] = "Elixir de défense mineure",
		["Elixir of Minor Fortitude"] = "Elixir de robustesse mineure",
		["Elixir of Ogre's Strength"] = "Elixir de force d'ogre",
		["Elixir of Shadow Power"] = "Elixir de puissance de l'Ombre",
		["Elixir of Superior Defense"] = "Elixir de défense excellente",
		["Elixir of the Mongoose"] = "Elixir de la mangouste",
		["Elixir of the Sages"] = "Elixir des sages",
		["Elixir of the Searching Eye"] = "Elixir de l'oeil inquisiteur",
		["Elixir of Water Breathing"] = "Elixir de respiration aquatique",
		["Elixir of Wisdom"] = "Elixir de sagesse",
		["Fel Mana Potion"] = "Potion de mana gangrenée",
		["Fel Regeneration Potion"] = "Potion de régénération gangrenée",
		["Fel Strength Elixir"] = "Elixir de force gangrené",
		["Fire Oil"] = "Huile de feu",
		["Fire Protection Potion"] = "Potion de protection contre le Feu",
		["Flask of Blinding Light"] = "Flacon de lumière aveuglante",
		["Flask of Chromatic Resistance"] = "Flacon de résistance chromatique",
		["Flask of Chromatic Wonder"] = "Flacon de merveille chromatique",
		["Flask of Distilled Wisdom"] = "Flacon de sagesse distillée",
		["Flask of Fortification"] = "Flacon de fortifiant",
		["Flask of Mighty Restoration"] = "Flacon de puissante restauration",
		["Flask of Petrification"] = "Flacon de pétrification",
		["Flask of Pure Death"] = "Flacon de pure mort",
		["Flask of Relentless Assault"] = "Flacon d'attaque implacable",
		["Flask of Supreme Power"] = "Flacon de pouvoir suprême",
		["Flask of the Titans"] = "Flacon des Titans",
		["Free Action Potion"] = "Potion de libre action",
		["Frost Oil"] = "Huile glaciale",
		["Frost Protection Potion"] = "Potion de protection contre le Givre",
		["Ghost Dye"] = "Teinture fantôme",
		["Gift of Arthas"] = "Don d'Arthas",
		["Goblin Rocket Fuel"] = "Carburant de fusée gobelin",
		["Great Rage Potion"] = "Potion de grande rage",
		["Greater Arcane Elixir"] = "Elixir des arcanes supérieur",
		["Greater Arcane Protection Potion"] = "Potion de protection contre les Arcanes supérieure",
		["Greater Dreamless Sleep Potion"] = "Potion de sommeil sans rêve supérieure",
		["Greater Fire Protection Potion"] = "Potion de protection contre le Feu supérieure",
		["Greater Frost Protection Potion"] = "Potion de protection contre le Givre supérieure",
		["Greater Healing Potion"] = "Potion de soins supérieure",
		["Greater Mana Potion"] = "Potion de mana supérieure",
		["Greater Nature Protection Potion"] = "Potion de protection contre la Nature supérieure",
		["Greater Shadow Protection Potion"] = "Potion de protection contre l'Ombre supérieure",
		["Greater Stoneshield Potion"] = "Potion de bouclier de pierre supérieure",
		["Gurubashi Mojo Madness"] = "Folie mojo des Gurubashi",
		["Haste Potion"] = "Potion de hâte",
		["Healing Potion"] = "Potion de soins",
		["Heroic Potion"] = "Potion héroïque",
		["Holy Protection Potion"] = "Potion de protection contre le Sacré",
		["Insane Strength Potion"] = "Potion de Force démente",
		["Invisibility Potion"] = "Potion d'invisibilité",
		["Ironshield Potion"] = "Potion de bouclier de fer",
		["Lesser Healing Potion"] = "Potion de soins inférieure",
		["Lesser Invisibility Potion"] = "Potion d'invisibilité inférieure",
		["Lesser Mana Potion"] = "Potion de mana inférieure",
		["Lesser Stoneshield Potion"] = "Potion de bouclier de pierre inférieure",
		["Limited Invulnerability Potion"] = "Potion d'invulnérabilité limitée",
		["Living Action Potion"] = "Potion de vive action",
		["Mad Alchemist's Potion"] = "Potion de l'alchimiste fou",
		["Mageblood Potion"] = "Potion Magesang",
		["Magic Resistance Potion"] = "Potion de résistance à la magie",
		["Major Arcane Protection Potion"] = "Potion de protection contre les Arcanes majeure",
		["Major Dreamless Sleep Potion"] = "Potion de sommeil sans rêve majeure",
		["Major Fire Protection Potion"] = "Potion de protection contre le Feu majeure",
		["Major Frost Protection Potion"] = "Potion de protection contre le Givre majeure",
		["Major Healing Potion"] = "Potion de soins majeure",
		["Major Holy Protection Potion"] = "Potion de protection contre le Sacré majeure",
		["Major Mana Potion"] = "Potion de mana majeure",
		["Major Nature Protection Potion"] = "Potion de protection contre la Nature majeure",
		["Major Rejuvenation Potion"] = "Potion de régénération majeure",
		["Major Shadow Protection Potion"] = "Potion de protection contre l'Ombre majeure",
		["Major Troll's Blood Potion"] = "Potion de sang de troll majeure",
		["Mana Potion"] = "Potion de mana",
		["Mercurial Stone"] = "Pierre mercurienne",
		["Mighty Rage Potion"] = "Potion de rage puissante",
		["Mighty Troll's Blood Potion"] = "Potion de sang de troll hargneux",
		["Minor Healing Potion"] = "Potion de soins mineure",
		["Minor Magic Resistance Potion"] = "Potion de résistance à la magie mineure",
		["Minor Mana Potion"] = "Potion de mana mineure",
		["Minor Rejuvenation Potion"] = "Potion de régénération mineure",
		["Nature Protection Potion"] = "Potion de protection contre la Nature",
		["Oil of Immolation"] = "Huile d'immolation",
		["Onslaught Elixir"] = "Elixir d'assaut",
		["Philosopher's Stone"] = "Pierre philosophale",
		["Potion of Curing"] = "Potion de guérison",
		["Purification Potion"] = "Potion de purification",
		["Rage Potion"] = "Potion de rage",
		["Restorative Potion"] = "Potion de restauration",
		["Shadow Oil"] = "Huile des ténèbres",
		["Shadow Protection Potion"] = "Potion de protection contre l'Ombre",
		["Shrouding Potion"] = "Potion de voilage",
		["Sneaking Potion"] = "Potion furtive",
		["Stonescale Oil"] = "Huile de pierre-écaille",
		["Strong Troll's Blood Potion"] = "Potion de sang de troll forte",
		["Super Healing Potion"] = "Potion de super-soins",
		["Super Mana Potion"] = "Potion de super-mana",
		["Super Rejuvenation Potion"] = "Potion de super-régénération",
		["Superior Healing Potion"] = "Potion de soins excellente",
		["Superior Mana Potion"] = "Potion de mana excellente",
		["Swiftness Potion"] = "Potion de rapidité",
		["Swim Speed Potion"] = "Potion de nage rapide",
		["Transmute: Air to Fire"] = "Transmutation de l'Air en Feu",
		["Transmute: Arcanite"] = "Transmutation d'arcanite",
		["Transmute: Earth to Life"] = "Transmutation : Terre en Vie",
		["Transmute: Earth to Water"] = "Transmutation : Terre en Eau",
		["Transmute: Earthstorm Diamond"] = "Transmutation : Diamant tonneterre",
		["Transmute: Elemental Fire"] = "Transmutation : Feu élémentaire",
		["Transmute: Fire to Earth"] = "Transmutation : Feu en Terre",
		["Transmute: Iron to Gold"] = "Transmutation : Fer en Or",
		["Transmute: Life to Earth"] = "Transmutation : Vie en Terre",
		["Transmute: Mithril to Truesilver"] = "Transmutation : Mithril en Vrai-argent",
		["Transmute: Primal Air to Fire"] = "Transmutation primordiale : Air en Feu",
		["Transmute: Primal Earth to Life"] = "Transmutation primordiale : Terre en Vie",
		["Transmute: Primal Earth to Water"] = "Transmutation primordiale : Terre en Eau",
		["Transmute: Primal Fire to Earth"] = "Transmutation primordiale : Feu en Terre",
		["Transmute: Primal Fire to Mana"] = "Transmutation primordiale : Feu en Mana",
		["Transmute: Primal Life to Earth"] = "Transmutation primordiale : Vie en Terre",
		["Transmute: Primal Mana to Fire"] = "Transmutation primordiale : Mana en Feu",
		["Transmute: Primal Might"] = "Transmutation primordiale : Pouvoir",
		["Transmute: Primal Shadow to Water"] = "Transmutation primordiale : Ombre en Eau",
		["Transmute: Primal Water to Air"] = "Transmutation primordiale : Eau en Air",
		["Transmute: Primal Water to Shadow"] = "Transmutation primordiale : Eau en Ombre",
		["Transmute: Skyfire Diamond"] = "Transmutation : Diamant brûleciel",
		["Transmute: Undeath to Water"] = "Transmutation : Non-mort en Eau",
		["Transmute: Water to Air"] = "Transmutation : Eau en Air",
		["Transmute: Water to Undeath"] = "Transmutation : Eau en Non-mort",
		["Unstable Mana Potion"] = "Potion de mana instable",
		["Volatile Healing Potion"] = "Potion de soins volatile",
		["Weak Troll's Blood Potion"] = "Potion de sang de troll faible",
		["Wildvine Potion"] = "Potion de sauvageonne",
		["Assassin's Alchemist Stone"] = "Pierre d'alchimiste d'assassin",
		["Guardian's Alchemist Stone"] = "Pierre d'alchimiste de gardien",
		["Redeemer's Alchemist Stone"] = "Pierre d'alchimiste de rédempteur",
		["Sorcerer's Alchemist Stone"] = "Pierre d'alchimiste d'ensorceleur",

-- Beast Training Skills
		["Arcane Resistance (Rank 1)"] = "Résistance aux Arcanes (Rang 1)",
		["Arcane Resistance (Rank 2)"] = "Résistance aux Arcanes (Rang 2)",
		["Arcane Resistance (Rank 3)"] = "Résistance aux Arcanes (Rang 3)",
		["Arcane Resistance (Rank 4)"] = "Résistance aux Arcanes (Rang 4)",
		["Arcane Resistance (Rank 5)"] = "Résistance aux Arcanes (Rang 5)",
		["Avoidance (Rank 1)"] = "Evitement (Rang 1)",
		["Avoidance (Rank 2)"] = "Evitement (Rang 2)",
		["Bite (Rank 1)"] = "Morsure (Rang 1)",
		["Bite (Rank 2)"] = "Morsure (Rang 2)",
		["Bite (Rank 3)"] = "Morsure (Rang 3)",
		["Bite (Rank 4)"] = "Morsure (Rang 4)",
		["Bite (Rank 5)"] = "Morsure (Rang 5)",
		["Bite (Rank 6)"] = "Morsure (Rang 6)",
		["Bite (Rank 7)"] = "Morsure (Rang 7)",
		["Bite (Rank 8)"] = "Morsure (Rang 8)",
		["Bite (Rank 9)"] = "Morsure (Rang 9)",
		["Charge (Rank 1)"] = "Charge (Rang 1)",
		["Charge (Rank 2)"] = "Charge (Rang 2)",
		["Charge (Rank 3)"] = "Charge (Rang 3)",
		--["Charge (Rank 4)"] = "Charge (Rang 4)", -- No charge rank 4 in the game
		["Charge (Rank 5)"] = "Charge (Rang 5)",
		["Charge (Rank 6)"] = "Charge (Rang 6)",
		["Claw (Rank 1)"] = "Griffe (Rang 1)",
		["Claw (Rank 2)"] = "Griffe (Rang 2)",
		["Claw (Rank 3)"] = "Griffe (Rang 3)",
		["Claw (Rank 4)"] = "Griffe (Rang 4)",
		["Claw (Rank 5)"] = "Griffe (Rang 5)",
		["Claw (Rank 6)"] = "Griffe (Rang 6)",
		["Claw (Rank 7)"] = "Griffe (Rang 7)",
		["Claw (Rank 8)"] = "Griffe (Rang 8)",
		["Claw (Rank 9)"] = "Griffe (Rang 9)",
		["Cobra Reflexes ()"] = "Réflexes du cobra ()",
		["Cower (Rank 1)"] = "Dérobade (Rang 1)",
		["Cower (Rank 2)"] = "Dérobade (Rang 2)",
		["Cower (Rank 3)"] = "Dérobade (Rang 3)",
		["Cower (Rank 4)"] = "Dérobade (Rang 4)",
		["Cower (Rank 5)"] = "Dérobade (Rang 5)",
		["Cower (Rank 6)"] = "Dérobade (Rang 6)",
		["Cower (Rank 7)"] = "Dérobade (Rang 7)",
		["Dash (Rank 1)"] = "Célérité (Rang 1)",
		["Dash (Rank 2)"] = "Célérité (Rang 2)",
		["Dash (Rank 3)"] = "Célérité (Rang 3)",
		["Dive (Rank 1)"] = "Plongeon (Rang 1)",
		["Dive (Rank 2)"] = "Plongeon (Rang 2)",
		["Dive (Rank 3)"] = "Plongeon (Rang 3)",
		["Fire Breath (Rank 1)"] = "Souffle de feu (Rang 1)",
		["Fire Breath (Rank 2)"] = "Souffle de feu (Rang 2)",
		["Fire Resistance (Rank 1)"] = "Résistance au Feu (Rang 1)",
		["Fire Resistance (Rank 2)"] = "Résistance au Feu (Rang 2)",
		["Fire Resistance (Rank 3)"] = "Résistance au Feu (Rang 3)",
		["Fire Resistance (Rank 4)"] = "Résistance au Feu (Rang 4)",
		["Fire Resistance (Rank 5)"] = "Résistance au Feu (Rang 5)",
		["Frost Resistance (Rank 1)"] = "Résistance au Givre (Rang 1)",
		["Frost Resistance (Rank 2)"] = "Résistance au Givre (Rang 2)",
		["Frost Resistance (Rank 3)"] = "Résistance au Givre (Rang 3)",
		["Frost Resistance (Rank 4)"] = "Résistance au Givre (Rang 4)",
		["Frost Resistance (Rank 5)"] = "Résistance au Givre (Rang 5)",
		["Furious Howl (Rank 1)"] = "Hurlement furieux (Rang 1)",
		["Furious Howl (Rank 2)"] = "Hurlement furieux (Rang 2)",
		["Furious Howl (Rank 3)"] = "Hurlement furieux (Rang 3)",
		["Furious Howl (Rank 4)"] = "Hurlement furieux (Rang 4)",
		["Gore (Rank 1)"] = "Encorner (Rang 1)",
		["Gore (Rank 2)"] = "Encorner (Rang 2)",
		["Gore (Rank 3)"] = "Encorner (Rang 3)",
		["Gore (Rank 4)"] = "Encorner (Rang 4)",
		--["Gore (Rank 5)"] = "Encorner (Rang 5)", -- Not in game
		--["Gore (Rank 6)"] = "Encorner (Rang 6)", -- Not in game
		["Gore (Rank 7)"] = "Encorner (Rang 7)",
		["Gore (Rank 8)"] = "Encorner (Rang 8)",
		["Gore (Rank 9)"] = "Encorner (Rang 9)",
		["Great Stamina (Rank 1)"] = "Endurance supérieure (Rang 1)",
		["Great Stamina (Rank 10)"] = "Endurance supérieure (Rang 10)",
		["Great Stamina (Rank 11)"] = "Endurance supérieure (Rang 11)",
		["Great Stamina (Rank 2)"] = "Endurance supérieure (Rang 2)",
		["Great Stamina (Rank 3)"] = "Endurance supérieure (Rang 3)",
		["Great Stamina (Rank 4)"] = "Endurance supérieure (Rang 4)",
		["Great Stamina (Rank 5)"] = "Endurance supérieure (Rang 5)",
		["Great Stamina (Rank 6)"] = "Endurance supérieure (Rang 6)",
		["Great Stamina (Rank 7)"] = "Endurance supérieure (Rang 7)",
		["Great Stamina (Rank 8)"] = "Endurance supérieure (Rang 8)",
		["Great Stamina (Rank 9)"] = "Endurance supérieure (Rang 9)",
		["Growl (Rank 1)"] = "Grondement (Rang 1)",
		["Growl (Rank 2)"] = "Grondement (Rang 2)",
		["Growl (Rank 3)"] = "Grondement (Rang 3)",
		["Growl (Rank 4)"] = "Grondement (Rang 4)",
		["Growl (Rank 5)"] = "Grondement (Rang 5)",
		["Growl (Rank 6)"] = "Grondement (Rang 6)",
		["Growl (Rank 7)"] = "Grondement (Rang 7)",
		["Growl (Rank 8)"] = "Grondement (Rang 8)",
		["Lightning Breath (Rank 1)"] = "Souffle de foudre (Rang 1)",
		["Lightning Breath (Rank 2)"] = "Souffle de foudre (Rang 2)",
		["Lightning Breath (Rank 3)"] = "Souffle de foudre (Rang 3)",
		["Lightning Breath (Rank 4)"] = "Souffle de foudre (Rang 4)",
		["Lightning Breath (Rank 5)"] = "Souffle de foudre (Rang 5)",
		["Lightning Breath (Rank 6)"] = "Souffle de foudre (Rang 6)",
		["Natural Armor (Rank 1)"] = "Armure naturelle (Rang 1)",
		["Natural Armor (Rank 10)"] = "Armure naturelle (Rang 10)",
		["Natural Armor (Rank 11)"] = "Armure naturelle (Rang 11)",
		["Natural Armor (Rank 2)"] = "Armure naturelle (Rang 2)",
		["Natural Armor (Rank 3)"] = "Armure naturelle (Rang 3)",
		["Natural Armor (Rank 4)"] = "Armure naturelle (Rang 4)",
		["Natural Armor (Rank 5)"] = "Armure naturelle (Rang 5)",
		["Natural Armor (Rank 6)"] = "Armure naturelle (Rang 6)",
		["Natural Armor (Rank 7)"] = "Armure naturelle (Rang 7)",
		["Natural Armor (Rank 8)"] = "Armure naturelle (Rang 8)",
		["Natural Armor (Rank 9)"] = "Armure naturelle (Rang 9)",
		["Nature Resistance (Rank 1)"] = "Résistance à la Nature (Rang 1)",
		["Nature Resistance (Rank 2)"] = "Résistance à la Nature (Rang 2)",
		["Nature Resistance (Rank 3)"] = "Résistance à la Nature (Rang 3)",
		["Nature Resistance (Rank 4)"] = "Résistance à la Nature (Rang 4)",
		["Nature Resistance (Rank 5)"] = "Résistance à la Nature (Rang 5)",
		["Poison Spit (Rank 1)"] = "Crachat de poison (Rank 1)",
		["Poison Spit (Rank 2)"] = "Crachat de poison (Rank 2)",
		["Poison Spit (Rank 3)"] = "Crachat de poison (Rank 3)",
		["Prowl (Rank 1)"] = "Rôder (Rang 1)",
		["Prowl (Rank 2)"] = "Rôder (Rang 2)",
		["Prowl (Rank 3)"] = "Rôder (Rang 3)",
		["Scorpid Poison (Rank 1)"] = "Poison de scorpide (Rang 1)",
		["Scorpid Poison (Rank 2)"] = "Poison de scorpide (Rang 2)",
		["Scorpid Poison (Rank 3)"] = "Poison de scorpide (Rang 3)",
		["Scorpid Poison (Rank 4)"] = "Poison de scorpide (Rang 4)",
		["Scorpid Poison (Rank 5)"] = "Poison de scorpide (Rang 5)",
		["Screech (Rank 1)"] = "Hurlement (Rang 1)",
		["Screech (Rank 2)"] = "Hurlement (Rang 2)",
		["Screech (Rank 3)"] = "Hurlement (Rang 3)",
		["Screech (Rank 4)"] = "Hurlement (Rang 4)",
		["Screech (Rank 5)"] = "Hurlement (Rang 5)",
		["Shadow Resistance (Rank 1)"] = "Résistance à l'Ombre (Rang 1)",
		["Shadow Resistance (Rank 2)"] = "Résistance à l'Ombre (Rang 2)",
		["Shadow Resistance (Rank 3)"] = "Résistance à l'Ombre (Rang 3)",
		["Shadow Resistance (Rank 4)"] = "Résistance à l'Ombre (Rang 4)",
		["Shadow Resistance (Rank 5)"] = "Résistance à l'Ombre (Rang 5)",
		["Shell Shield (Rank 1)"] = "Carapace bouclier (Rang 1)",
		["Thunderstomp (Rank 1)"] = "Grondeterre (Rang 1)",
		["Thunderstomp (Rank 2)"] = "Grondeterre (Rang 2)",
		["Thunderstomp (Rank 3)"] = "Grondeterre (Rang 3)",
		["Warp (Rank 1)"] = "Distorsion (Rang 1)",

		-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "Cuirasse en adamantite",
		["Adamantite Cleaver"] = "Fendoir en adamantite",
		["Adamantite Dagger"] = "Dague en adamantite",
		["Adamantite Maul"] = "Maillet en adamantite",
		["Adamantite Plate Bracers"] = "Brassards en plaques d'adamantite",
		["Adamantite Plate Gloves"] = "Gants en plaques d'adamantite",
		["Adamantite Rapier"] = "Rapière en adamantite",
		["Adamantite Rod"] = "Bâtonnet en adamantite",
		["Adamantite Sharpening Stone"] = "Pierre à aiguiser adamantine",
		["Adamantite Weapon Chain"] = "Dragonne en adamantite",
		["Adamantite Weightstone"] = "Pierre de lest d'adamantite",
		["Annihilator"] = "Annihilateur",
		["Arcanite Champion"] = "Championne en arcanite",
		["Arcanite Reaper"] = "Faucheuse en arcanite",
		["Arcanite Rod"] = "Bâtonnet en arcanite",
		["Arcanite Skeleton Key"] = "Passe-partout en arcanite",
		["Barbaric Iron Boots"] = "Bottes barbares en fer",
		["Barbaric Iron Breastplate"] = "Cuirasse barbare en fer",
		["Barbaric Iron Gloves"] = "Gants barbares en fer",
		["Barbaric Iron Helm"] = "Casque barbare en fer",
		["Barbaric Iron Shoulders"] = "Epaulières barbares en fer",
		["Belt of the Guardian"] = "Ceinture du gardien",
		["Big Black Mace"] = "Grande masse noire",
		["Big Bronze Knife"] = "Grand couteau en bronze",
		["Black Amnesty"] = "Amnistie noire",
		["Black Felsteel Bracers"] = "Brassards noirs en gangracier",
		["Black Grasp of the Destroyer"] = "Emprise noire du Destructeur",
		["Black Planar Edge"] = "Doloire planaire noire",
		["Blackfury"] = "Fureur noire",
		["Blackguard"] = "Garde noire",
		["Blazefury"] = "Brasefurie",
		["Blazeguard"] = "Brasegarde",
		["Blazing Rapier"] = "Rapière flamboyante",
		["Blessed Bracers"] = "Brassards bénis",
		["Blight"] = "Corruptrice",
		["Bloodmoon"] = "Lune sanguine",
		["Bloodsoul Breastplate"] = "Cuirasse d'âmesang",
		["Bloodsoul Gauntlets"] = "Gantelets d'âmesang",
		["Bloodsoul Shoulders"] = "Epaulières d'âmesang",
		["Blue Glittering Axe"] = "Hache lumineuse bleue",
		["Boots of the Protector"] = "Bottes du protecteur",
		["Bracers of the Green Fortress"] = "Brassards de la forteresse verte",
		["Breastplate of Kings"] = "Cuirasse des rois",
		["Bronze Axe"] = "Hache en bronze",
		["Bronze Battle Axe"] = "Hache d'armes en bronze",
		["Bronze Greatsword"] = "Estramaçon en bronze",
		["Bronze Mace"] = "Masse en bronze",
		["Bronze Shortsword"] = "Epée courte en bronze",
		["Bronze Warhammer"] = "Marteau de guerre en bronze",
		["Bulwark of Kings"] = "Rempart des rois",
		["Bulwark of the Ancient Kings"] = "Rempart des anciens rois",
		["Coarse Grinding Stone"] = "Silex à aiguiser grossier",
		["Coarse Sharpening Stone"] = "Pierre à aiguiser grossière",
		["Coarse Weightstone"] = "Pierre de lest grossière",
		["Copper Axe"] = "Hache en cuivre",
		["Copper Battle Axe"] = "Hache d'armes en cuivre",
		["Copper Bracers"] = "Bracelets en cuivre",
		["Copper Chain Belt"] = "Ceinture en anneaux de cuivre",
		["Copper Chain Boots"] ="Bottes en anneaux de cuivre",
		["Copper Chain Pants"] = "Pantalon en anneaux de cuivre",
		["Copper Chain Vest"] = "Lorica en cuivre",
		["Copper Claymore"] = "Claymore en cuivre",
		["Copper Dagger"] = "Dague en cuivre",
		["Copper Mace"] = "Masse en cuivre",
		["Copper Shortsword"] = "Epée courte en cuivre",
		["Corruption"] = "Corruption",
		["Dark Iron Boots"] = "Bottes en sombrefer",
		["Dark Iron Bracers"] = "Brassards en sombrefer",
		["Dark Iron Destroyer"] = "Déchireuse en sombrefer",
		["Dark Iron Gauntlets"] = "Gantelets en sombrefer",
		["Dark Iron Helm"] = "Heaume en sombrefer",
		["Dark Iron Leggings"] = "Jambières en sombrefer",
		["Dark Iron Mail"] = "Cotte de mailles en sombrefer",
		["Dark Iron Plate"] = "Harnois en sombrefer",
		["Dark Iron Pulverizer"] = "Pulvériseur en sombrefer",
		["Dark Iron Reaver"] = "Déchireuse en sombrefer",
		["Dark Iron Shoulders"] = "Epaulières en sombrefer",
		["Dark Iron Sunderer"] = "Fendeuse en sombrefer",
		["Darkrune Breastplate"] = "Cuirasse de sombrerune",
		["Darkrune Gauntlets"] = "Gantelets de sombrerune",
		["Darkrune Helm"] = "Heaume de sombrerune",
		["Darksoul Breastplate"] = "Cuirasse de ténébrâme",
		["Darksoul Leggings"] = "Jambières de ténébrâme",
		["Darksoul Shoulders"] = "Epaulières de ténébrâme",
		["Dawnbringer Shoulders"] = "Epaulières du point du jour",
		["Dawn's Edge"] = "Courroux de l'aube",
		["Dawnsteel Bracers"] = "Brassards en acier de l'aube",
		["Dawnsteel Shoulders"] = "Epaulières en acier de l'aube",
		["Dazzling Mithril Rapier"] = "Rapière éblouissante en mithril",
		["Deadly Bronze Poniard"] = "Poignard mortel en bronze",
		["Deep Thunder"] = "Tonnerre-profond",
		["Demon Forged Breastplate"] = "Cuirasse démoniaque",
		["Dense Grinding Stone"] = "Silex à aiguiser dense",
		["Dense Sharpening Stone"] = "Pierre à aiguiser dense",
		["Dense Weightstone"] = "Pierre de lest dense",
		["Dirge"] = "Complainte",
		["Dragonmaw"] = "Gueule de dragon",
		["Dragonstrike"] = "Frappe du dragon",
		["Drakefist Hammer"] = "Marteau poing-de-drake",
		["Earthforged Leggings"] = "Jambières de forge-terre",
		["Earthpeace Breastplate"] = "Cuirasse Paix-de-la-terre",
		["Ebon Hand"] = "Main d'ébène",
		["Ebon Shiv"] = "Coutelas d'ébène",
		["Edge of Winter"] = "Tranchante de l'hiver",
		["Elemental Sharpening Stone"] = "Pierre à aiguiser élémentaire",
		["Embrace of the Twisting Nether"] = "Etreinte du Néant distordu",
		["Enchanted Adamantite Belt"] = "Ceinture enchantée en adamantite",
		["Enchanted Adamantite Boots"] = "Bottes enchantées en adamantite",
		["Enchanted Adamantite Breastplate"] = "Cuirasse enchantée en adamantite",
		["Enchanted Adamantite Leggings"] = "Jambières enchantées en adamantite",
		["Enchanted Battlehammer"] = "Marteau d'armes enchanté",
		["Enchanted Thorium Blades"] = "Lames en thorium enchanté",
		["Enchanted Thorium Breastplate"] = "Cuirasse en thorium enchanté",
		["Enchanted Thorium Helm"] = "Heaume en thorium enchanté",
		["Enchanted Thorium Leggings"] = "Jambières en thorium enchanté",
		["Eternium Rod"] = "Bâtonnet en éternium",
		["Eternium Runed Blade"] = "Lame runique en éternium",
		["Fel Edged Battleaxe"] = "Hache de bataille à tranchant gangrené",
		["Fel Hardened Maul"] = "Maillet corrompu durci",
		["Fel Iron Breastplate"] = "Cuirasse en gangrefer",
		["Fel Iron Chain Bracers"] = "Brassards en gangrefer",
		["Fel Iron Chain Coif"] = "Camail en gangrefer",
		["Fel Iron Chain Gloves"] = "Gants en anneaux de gangrefer",
		["Fel Iron Chain Tunic"] = "Tunique en anneaux de gangrefer",
		["Fel Iron Greatsword"] = "Estramaçon en gangrefer",
		["Fel Iron Hammer"] = "Marteau en gangrefer",
		["Fel Iron Hatchet"] = "Hachette en gangrefer",
		["Fel Iron Plate Belt"] = "Ceinture en plaques de gangrefer",
		["Fel Iron Plate Boots"] = "Bottes en plaques de gangrefer",
		["Fel Iron Plate Gloves"] = "Gants en plaques de gangrefer",
		["Fel Iron Plate Pants"] = "Pantalon en plaques de gangrefer",
		["Fel Iron Rod"] = "Bâtonnet en gangrefer",
		["Fel Sharpening Stone"] = "Pierre à aiguiser gangrée",
		["Fel Weightstone"] = "Pierre de lest gangrenée",
		["Felfury Gauntlets"] = "Gantelets gangrefurie",
		["Felsteel Gloves"] = "Gants en gangracier",
		["Felsteel Helm"] = "Casque en gangracier",
		["Felsteel Leggings"] = "Jambières en gangracier",
		["Felsteel Longblade"] = "Lame longue en gangracier",
		["Felsteel Reaper"] = "Faucheuse en gangracier",
		["Felsteel Shield Spike"] = "Pointe de bouclier en gangracier",
		["Felsteel Whisper Knives"] = "Couteaux de murmure en gangracier",
		["Fiery Blaze Enchantment"] = "Enchantement d'éclat flamboyant",
		["Fiery Chain Girdle"] = "Ceinturon en anneaux de feu",
		["Fiery Chain Shoulders"] = "Epaulières en anneaux de feu",
		["Fiery Plate Gauntlets"] = "Gantelets en plaques de feu",
		["Fireguard"] = "Garde du feu",
		["Flamebane Bracers"] = "Brassards plaie-des-flammes",
		["Flamebane Breastplate"] = "Cuirasse plaie-des-flammes",
		["Flamebane Gloves"] = "Gants plaie-des-flammes",
		["Flamebane Helm"] = "Casque plaie-des-flammes",
		["Frost Tiger Blade"] = "Tigresse glaciale",
		["Frostguard"] = "Garde de givre",
		["Gauntlets of the Iron Tower"] = "Gantelets de la tour de fer",
		["Gemmed Copper Gauntlets"] = "Gantelets ornés en cuivre",
		["Girdle of the Dawn"] = "Ceinturon de l'Aube",
		["Glinting Steel Dagger"] = "Dague en acier luisant",
		["Gloves of the Dawn"] = "Gants de l'Aube",
		["Golden Iron Destroyer"] = "Destructeur en fer doré",
		["Golden Rod"] = "Bâtonnet doré",
		["Golden Scale Boots"] = "Bottes en écailles dorées",
		["Golden Scale Bracers"] = "Brassards en écailles dorées",
		["Golden Scale Coif"] = "Camail en écailles dorées",
		["Golden Scale Cuirass"] = "Cuirasse en écailles dorées",
		["Golden Scale Gauntlets"] = "Gantelets en écailles dorées",
		["Golden Scale Leggings"] = "Jambières en écailles dorées",
		["Golden Scale Shoulders"] = "Epaulières en écailles dorées",
		["Golden Skeleton Key"] = "Passe-partout en or",
		["Great Earthforged Hammer"] = "Grand marteau de forge-terre",
		["Greater Rune of Warding"] = "Rune de garde supérieure",
		["Greater Ward of Shielding"] = "Gardien de sauvegarde supérieur",
		["Green Iron Boots"] = "Bottes en fer émeraude",
		["Green Iron Bracers"] = "Brassards en fer émeraude",
		["Green Iron Gauntlets"] = "Gantelets en fer émeraude",
		["Green Iron Hauberk"] = "Haubert en fer émeraude",
		["Green Iron Helm"] = "Heaume en fer émeraude",
		["Green Iron Leggings"] = "Jambières en fer émeraude",
		["Green Iron Shoulders"] = "Epaulières en fer émeraude",
		["Hard Khorium Battlefists"] = "Poings de bataille en khorium durci",
		["Hard Khorium Battleplate"] = "Plaque de bataille en khorium durci",
		["Hammer of Righteous Might"] = "Marteau de la puissance pieuse",
		["Hammer of the Titans"] = "Marteau des Titans",
		["Hand of Eternity"] = "Main de l'éternité",
		["Hardened Iron Shortsword"] = "Epée courte en fer trempé",
		["Heartseeker"] = "Crève-coeur",
		["Heavy Bronze Mace"] = "Masse lourde en bronze",
		["Heavy Copper Broadsword"] = "Lourde épée large en cuivre",
		["Heavy Copper Longsword"] = "Lourde épée longue en cuivre",
		["Heavy Copper Maul"] = "Maillet lourd en cuivre",
		["Heavy Earthforged Breastplate"] = "Cuirasse lourde de forge-terre",
		["Heavy Grinding Stone"] = "Silex à aiguiser lourd",
		["Heavy Mithril Axe"] = "Hache lourde en mithril",
		["Heavy Mithril Boots"] = "Bottes lourdes en mithril",
		["Heavy Mithril Breastplate"] = "Cuirasse lourde en mithril",
		["Heavy Mithril Gauntlet"] = "Gantelets lourds en mithril",
		["Heavy Mithril Helm"] = "Heaume lourd en mithril",
		["Heavy Mithril Pants"] = "Pantalon lourd en mithril",
		["Heavy Mithril Shoulder"] = "Epaulières lourdes en mithril",
		["Heavy Obsidian Belt"] = "Ceinture lourde en obsidienne",
		["Heavy Sharpening Stone"] = "Pierre à aiguiser lourde",
		["Heavy Timbermaw Belt"] = "Ceinture épaisse grumegueule",
		["Heavy Timbermaw Boots"] = "Bottes lourdes grumegueule",
		["Heavy Weightstone"] = "Pierre de lest lourde",
		["Helm of the Great Chief"] = "Heaume du grand chef",
		["Helm of the Stalwart Defender"] = "Casque du fidèle défenseur",
		["Huge Thorium Battleaxe"] = "Hache d'armes énorme en thorium",
		["Icebane Bracers"] = "Brassards plaie-de-glace",
		["Icebane Breastplate"] = "Cuirasse plaie-de-glace",
		["Icebane Gauntlets"] = "Gantelets plaie-de-glace",
		["Iceguard Breastplate"] = "Cuirasse de gardeglace",
		["Iceguard Helm"] = "Heaume de gardeglace",
		["Iceguard Leggings"] = "Jambières de gardeglace",
		["Imperial Plate Belt"] = "Ceinture impériale en plaques",
		["Imperial Plate Boots"] = "Bottes impériales en plaques",
		["Imperial Plate Bracers"] = "Brassards impériaux en plaques",
		["Imperial Plate Chest"] = "Pansière impériale",
		["Imperial Plate Helm"] = "Heaume impérial en plaques",
		["Imperial Plate Leggings"] = "Jambières impériales en plaques",
		["Imperial Plate Shoulders"] = "Epaulières impériales en plaques",
		["Inlaid Mithril Cylinder"] = "Cylindre damasquiné en mithril",
		["Invulnerable Mail"] = "Cotte de mailles invulnérable",
		["Iridescent Hammer"] = "Marteau iridescent",
		["Iron Buckle"] = "Boucle en fer",
		["Iron Counterweight"] = "Contrepoids en fer",
		["Iron Shield Spike"] = "Pointe de bouclier en fer",
		["Ironforge Breastplate"] = "Cuirasse de Forgefer",
		["Ironvine Belt"] = "Ceinture de vignefer",
		["Ironvine Breastplate"] = "Cuirasse de vignefer",
		["Ironvine Gloves"] = "Gants de vignefer",
		["Jade Serpentblade"] = "Serpentine de jade",
		["Jagged Obsidian Shield"] = "Bouclier dentelé en obsidienne",
		["Khorium Belt"] = "Ceinture en khorium",
		["Khorium Boots"] = "Bottes en khorium",
		["Khorium Champion"] = "Champion en khorium",
		["Khorium Pants"] = "Pantalon en khorium",
		["Lavaforged Warhammer"] = "Marteau de guerre de forge-lave",
		["Lesser Rune of Warding"] = "Rune de garde inférieure",
		["Lesser Ward of Shielding"] = "Gardien de sauvegarde inférieur",
		["Light Earthforged Blade"] = "Lame légère de forge-terre",
		["Light Emberforged Hammer"] = "Marteau léger de forge-braise",
		["Light Obsidian Belt"] = "Ceinture légère en obsidienne",
		["Light Skyforged Axe"] = "Hache légère de forge-ciel",
		["Lionheart Blade"] = "Lame Coeur-de-lion",
		["Lionheart Champion"] = "Championne Coeur-de-lion",
		["Lionheart Executioner"] = "Exécutrice Coeur-de-lion",
		["Lionheart Helm"] = "Heaume Coeur-de-lion",
		["Lunar Crescent"] = "Croissant lunaire",
		["Massive Iron Axe"] = "Hache massive en fer",
		["Masterwork Stormhammer"] = "Marteau-tempête ouvragé",
		["Mighty Iron Hammer"] = "Marteau puissant en fer",
		["Mithril Coif"] = "Camail en mithril",
		["Mithril Scale Bracers"] = "Brassards en écailles de mithril",
		["Mithril Scale Gloves"] = "Gants en écailles de mithril", -- à vérifier
		["Mithril Scale Pants"] = "Jambières en écailles de mithril",
		["Mithril Scale Shoulders"] = "Epaulières en écailles de mithril",
		["Mithril Shield Spike"] = "Pointe de bouclier en mithril",
		["Mithril Spurs"] = "Eperons en mithril",
		["Mooncleaver"] = "Tranchelune",
		["Moonsteel Broadsword"] = "Epée large en acier lunaire",
		["Nether Chain Shirt"] = "Cotte d'anneaux du Néant",
		["Nightfall"] = "Crépuscule",
		["Oathkeeper's Helm"] = "Casque de la parole donnée",
		["Obsidian Mail Tunic"] = "Tunique de mailles en obsidienne",
		["Orcish War Leggings"] = "Jambières de guerre orques",
		["Ornate Mithril Boots"] = "Bottes ornées en mithril",
		["Ornate Mithril Breastplate"] = "Cuirasse ornée en mithril",
		["Ornate Mithril Gloves"] = "Gants ornés en mithril",
		["Ornate Mithril Helm"] = "Heaume orné en mithril",
		["Ornate Mithril Pants"] = "Pantalon orné en mithril",
		["Ornate Mithril Shoulder"] = "Epaulières ornées en mithril",
		["Ornate Thorium Handaxe"] = "Hache courte ornée en thorium",
		["Patterned Bronze Bracers"] = "Brassards guillochés en bronze",
		["Pearl-handled Dagger"] = "Dague à manche de perles",
		["Persuader"] = "Eloquente",
		["Phantom Blade"] = "Lame fantôme",
		["Polished Steel Boots"] = "Bottes en acier poli",
		["Radiant Belt"] = "Ceinture radieuse",
		["Radiant Boots"] = "Bottes radieuses",
		["Radiant Breastplate"] = "Cuirasse radieuse",
		["Radiant Circlet"] = "Diadème radieux",
		["Radiant Gloves"] = "Gantelets radieux",
		["Radiant Leggings"] = "Jambières radieuses",
		["Ragesteel Breastplate"] = "Cuirasse Rage-acier",
		["Ragesteel Gloves"] = "Gants Rage-acier",
		["Ragesteel Helm"] = "Casque Rage-acier",
		["Ragesteel Shoulders"] = "Epaulières Rage-acier",
		["Red Belt of Battle"] = "Ceinture de bataille rouge",
		["Red Havoc Boots"] = "Bottes du tumulte rouges",
		["Rough Bronze Boots"] = "Bottes grossières en bronze",
		["Rough Bronze Bracers"] = "Bracelets grossiers en bronze", -- à vérifier
		["Rough Bronze Cuirass"] = "Cuirasse grossière en bronze",
		["Rough Bronze Leggings"] = "Jambières grossières en bronze",
		["Rough Bronze Shoulders"] = "Epaulières grossières en bronze",
		["Rough Copper Vest"] = "Haubergeon grossier en cuivre",
		["Rough Grinding Stone"] = "Silex à aiguiser brut",
		["Rough Sharpening Stone"] = "Pierre à aiguiser brute",
		["Rough Weightstone"] = "Pierre de lest brute",
		["Runed Copper Belt"] = "Ceinture runique en cuivre",
		["Runed Copper Bracers"] = "Brassards runiques en cuivre",
		["Runed Copper Breastplate"] = "Plastron runique en cuivre",
		["Runed Copper Gauntlets"] = "Gantelets runiques en cuivre",
		["Runed Copper Pants"] = "Pantalon runique en cuivre",
		["Runed Mithril Hammer"] = "Marteau runique en mithril",
		["Runic Breastplate"] = "Cuirasse runique",
		["Runic Hammer"] = "Marteau runique",
		["Runic Plate Boots"] = "Bottes runiques en plaques",
		["Runic Plate Helm"] = "Heaume runique en plaques",
		["Runic Plate Leggings"] = "Jambières runiques en plaques",
		["Runic Plate Shoulders"] = "Epaulières runiques en plaques",
		["Sageblade"] = "Lame feuille-de-saule",
		["Searing Golden Blade"] = "Lame dorée incendiaire",
		["Serenity"] = "Sérénité",
		["Shadesteel Bracers"] = "Brassards en ombracier",
		["Shadesteel Girdle"] = "Ceinturon en ombracier",
		["Shadesteel Greaves"] = "Grèves en ombracier",
		["Shadesteel Sabots"] = "Sabots en ombracier",
		["Shadow Crescent Axe"] = "Hache-croissant des ombres",
		["Shining Silver Breastplate"] = "Cuirasse rayonnante en argent",
		["Silver Rod"] = "Bâtonnet en argent",
		["Silver Skeleton Key"] = "Passe-partout en argent",
		["Silvered Bronze Boots"] = "Bottes en bronze argenté",
		["Silvered Bronze Breastplate"] = "Cuirasse en bronze argenté",
		["Silvered Bronze Gauntlets"] = "Gantelets en bronze argenté",
		["Silvered Bronze Leggings"] = "Jambières en bronze argenté",
		["Silvered Bronze Shoulders"] = "Epaulières en bronze argenté",
		["Skyforged Great Axe"] = "Bardiche forge-ciel",
		["Solid Grinding Stone"] = "Silex à aiguiser solide",
		["Solid Iron Maul"] = "Solide maillet en fer",
		["Solid Sharpening Stone"] = "Pierre à aiguiser solide",
		["Solid Weightstone"] = "Pierre de lest solide",
		["Steel Breastplate"] = "Cuirasse en acier",
		["Steel Plate Helm"] = "Heaume en plaques d'acier",
		["Steel Weapon Chain"] = "Dragonne en acier",
		["Steelgrip Gauntlets"] = "Gantelets Poigne-d'acier",
		["Stoneforged Claymore"] = "Claymore de forge-pierre",
		["Storm Gauntlets"] = "Gantelets tempêtes",
		["Storm Helm"] = "Casque tempête",
		["Stormforged Axe"] = "Hache de forge-foudre",
		["Stormforged Hauberk"] = "Haubert de forge-foudre",
		["Stormherald"] = "Héraut de la tempête",
		["Stronghold Gauntlets"] = "Gantelets de la forteresse",
		["Sunblessed Breastplate"] = "Cuirasse bénie par le soleil",
		["Sunblessed Gauntlets"] = "Gantelets bénis par le soleil",
		["Sulfuron Hammer"] = "Marteau en sulfuron",
		["Swiftsteel Bracers"] = "Brassards en vif-acier",
		["Swiftsteel Gloves"] = "Gants en vif-acier",
		["Swiftsteel Shoulders"] = "Epaulières en vif-acier",
		["The Planar Edge"] = "La doloire planaire",
		["The Shatterer"] = "Le Briseur",
		["Thick Bronze Darts"] = "Fléchettes lourdes en bronze",
		["Thick Obsidian Breastplate"] = "Cuirasse épaisse en obsidienne",
		["Thick War Axe"] = "Hache de guerre lourde",
		["Thorium Armor"] = "Armure en thorium",
		["Thorium Belt"] = "Ceinture en thorium",
		["Thorium Boots"] = "Bottes en thorium",
		["Thorium Bracers"] = "Brassards en thorium",
		["Thorium Helm"] = "Heaume en thorium",
		["Thorium Leggings"] = "Jambières en thorium",
		["Thorium Shield Spike"] = "Pointe de bouclier en thorium",
		["Thunder"] = "Tonnerre",
		["Titanic Leggings"] = "Jambières titanesques",
		["Truesilver Breastplate"] = "Cuirasse en vrai-argent",
		["Truesilver Champion"] = "Championne en vrai-argent",
		["Truesilver Gauntlets"] = "Gantelets en vrai-argent",
		["Truesilver Rod"] = "Bâtonnet en vrai-argent",
		["Truesilver Skeleton Key"] = "Passe-partout en vrai-argent",
		["Twisting Nether Chain Shirt"] = "Cotte d'anneaux du Néant distordu",
		["Volcanic Hammer"] = "Marteau volcanique",
		["Whirling Steel Axes"] = "Haches tourbillonnantes en acier",
		["Whitesoul Helm"] = "Heaume d'âme blanche",
		["Wicked Edge of the Planes"] = "Doloire cruelle des plans",
		["Wicked Mithril Blade"] = "Lame pernicieuse en mithril",
		["Wildguard Breastplate"] = "Cuirasse de la garde fauve",
		["Wildguard Helm"] = "Heaume de la garde fauve",
		["Wildguard Leggings"] = "Jambières de la garde fauve",
		["Wildthorn Mail"] = "Cotte de mailles Ronce-sauvage",
		["Windforged Leggings"] = "Jambières de forge-vent",
		["Windforged Rapier"] = "Rapière de forge-vent",

-- Cooking Recipes
		["Baked Salmon"] = "Pain de saumon",
		["Barbecued Buzzard Wing"] = "Aile de busard grillée",
		["Bat Bites"] = "Bouchées à la chauve-souris",
		["Beer Basted Boar Ribs"] = "Côtes de sanglier à la bière",
		["Big Bear Steak"] = "Steak de grand ours",
		["Blackened Basilisk"] = "Basilic noirci",
		["Blackened Sporefish"] = "Poisson-spore noirci",
		["Blackened Trout"] = "Truite noircie",
		["Blood Sausage"] = "Boudin",
		["Boiled Clams"] = "Palourdes bouillies",
		["Brilliant Smallfish"] = "Goujon brillant",
		["Bristle Whisker Catfish"] = "Poisson-chat moustachu",
		["Broiled Bloodfin"] = "Aileron-de-sang grillé",
		["Buzzard Bites"] = "Bouchées de busard",
		["Captain Rumsey's Lager"] = "Brune du capitaine Rumsey",
		["Carrion Surprise"] = "Tourte surprise",
		["Charred Bear Kabobs"] = "Kebab d'ours grillé",
		["Charred Wolf Meat"] = "Viande de loup grillée",
		["Clam Bar"] = "Bâtonnet de palourdes",
		["Clam Chowder"] = "Soupe de palourdes",
		["Cooked Crab Claw"] = "Pince de crabe farcie",
		["Cooked Glossy Mightfish"] = "Barracuda luisant cuit",
		["Coyote Steak"] = "Steak de coyote",
		["Crab Cake"] = "Beignet de crabe",
		["Crispy Bat Wing"] = "Aile de chauve-souris croustillante",
		["Crispy Lizard Tail"] = "Queue de lézard croquante",
		["Crocolisk Gumbo"] = "Gombo de crocilisque",
		["Crocolisk Steak"] = "Steak de crocilisque",
		["Crunchy Serpent"] = "Serpent croustillant",
		["Crunchy Spider Surprise"] = "Surprise d'araignée croustillante",
		["Curiously Tasty Omelet"] = "Omelette au goût étrange",
		["Delicious Chocolate Cake"] = "Gâteau au chocolat délicieux",
		["Dig Rat Stew"] = "Brouet de rat",
		["Dirge's Kickin' Chimaerok Chops"] = "Pyro-côtelettes de chimaerok à la Dirge",
		["Dragonbreath Chili"] = "Chili de souffle de dragon",
		["Dry Pork Ribs"] = "Côtes de porc séchées",
		["Egg Nog"] = "Lait de poule",
		["Feltail Delight"] = "Délice de gangre-queue",
		["Filet of Redgill"] = "Filet de rouget",
		["Fillet of Frenzy"] = "Filet de furie",
		["Fisherman's Feast"] = "Festin du pêcheur",
		["Giant Clam Scorcho"] = "Ardeur de palourde géante",
		["Gingerbread Cookie"] = "Biscuit en pain d'épice",
		["Goblin Deviled Clams"] = "Palourdes gobelines",
		["Golden Fish Sticks"] = "Bâtonnets de poisson doré",
		["Goldthorn Tea"] = "Thé de dorépine",
		["Gooey Spider Cake"] = "Tourte d'araignée fondante",
		["Goretusk Liver Pie"] = "Tourte au foie de broche-tripes",
		["Grilled Mudfish"] = "Eperlan grillé",
		["Grilled Squid"] = "Calmar grillé",
		["Heavy Crocolisk Stew"] = "Ragoût épais de crocilisque",
		["Heavy Kodo Stew"] = "Ragoût épais de kodo",
		["Herb Baked Egg"] = "Oeufs aux herbes",
		["Hot Apple Cider"] = "Cidre chaud",
		["Hot Buttered Trout"] = "Truite au beurre blanc",
		["Hot Lion Chops"] = "Côtelettes de lion épicées",
		["Hot Smoked Bass"] = "Perche fumée",
		["Hot Wolf Ribs"] = "Côtes de loup épicées",
		["Juicy Bear Burger"] = "Steak d'ours juteux",
		["Jungle Stew"] = "Ragoût de la jungle",
		["Kaldorei Spider Kabob"] = "Kébab d'araignée kaldorei",
		["Kibler's Bits"] = "Croquettes de Kibler",
		["Lean Venison"] = "Venaison dégraissée",
		["Lean Wolf Steak"] = "Steak de loup",
		["Lobster Stew"] = "Ragoût de homard",
		["Loch Frenzy Delight"] = "Délice de furie du loch",
		["Longjaw Mud Snapper"] = "Lutjan à longue mâchoire",
		["Lynx Steak"] = "Steak de lynx",
		["Mightfish Steak"] = "Steak de barracuda",
		["Mithril Headed Trout"] = "Truite tête-mithril",
		["Mok'Nathal Shortribs"] = "Côtelettes mok'nathal",
		["Monster Omelet"] = "Omelette monstrueuse",
		["Murloc Fin Soup"] = "Soupe aux ailerons de murloc",
		["Mystery Stew"] = "Ragoût mystère",
		["Nightfin Soup"] = "Soupe de lutjan nagenuit",
		["Poached Bluefish"] = "Tassergal poché",
		["Poached Sunscale Salmon"] = "Saumon solécaille poché",
		["Rainbow Fin Albacore"] = "Thon arc-en-ciel",
		["Ravager Dog"] = "Croque-ravageur",
		["Redridge Goulash"] = "Goulash des Carmines",
		["Roast Raptor"] = "Rôti de raptor",
		["Roasted Boar Meat"] = "Viande de sanglier rôtie",
		["Roasted Clefthoof"] = "Sabot-fourchu rôti",
		["Roasted Kodo Meat"] = "Viande de kodo rôtie",
		["Roasted Moongraze Tenderloin"] = "Filet de frôle-lune rôti",
		["Rockscale Cod"] = "Morue rochécaille",
		["Runn Tum Tuber Surprise"] = "Courante-surprise",
		["Sagefish Delight"] = "Délice de sagerelle",
		["Savory Deviate Delight"] = "Délice de déviant",
		["Scorpid Surprise"] = "Surprise du scorpide",
		["Seasoned Wolf Kabob"] = "Kébab de loup assaisonné",
		["Skullfish Soup"] = "Soupe de poisson-crâne",
		["Slitherskin Mackerel"] = "Maquereau ombré",
		["Smoked Bear Meat"] = "Viande d'ours fumée",
		["Smoked Desert Dumplings"] = "Boulettes fumées du désert",
		["Smoked Sagefish"] = "Sagerelle fumée",
		["Soothing Turtle Bisque"] = "Bisque de tortue apaisante",
		["Spice Bread"] = "Pain épicé",
		["Spiced Chili Crab"] = "Chili de crabe épicé",
		["Spiced Wolf Meat"] = "Viande de loup épicée",
		["Spicy Crawdad"] = "Ecrevisse épicée",
		["Spicy Hot Talbuk"] = "Talbuk extra piquant",
		["Spider Sausage"] = "Saucisse d'araignée",
		["Sporeling Snack"] = "En-cas sporelin",
		["Spotted Yellowtail"] = "Jaune-queue tacheté",
		["Stewed Trout"] = "Fricassée de truite",
		["Stormchops"] = "Côtelettes foudroyantes",
		["Strider Stew"] = "Brouet de trotteur",
		["Succulent Pork Ribs"] = "Côtes de porc aux herbes",
		["Talbuk Steak"] = "Steak de talbuk",
		["Tasty Lion Steak"] = "Délicieux steak de lion",
		["Tender Wolf Steak"] = "Steak de loup tendre",
		["Thistle Tea"] = "Thé de chardon",
		["Undermine Clam Chowder"] = "Soupe de palourdes d'Undermine",
		["Warp Burger"] = "Steak dimensionnel",
		["Westfall Stew"] = "Ragoût de la marche de l'Ouest",

-- Enchanting Recipes
		["Brilliant Mana Oil"] = "Huile de mana brillante",
		["Brilliant Wizard Oil"] = "Huile de sorcier brillante",
		["Enchant 2H Weapon - Agility"] = "Ench. d'arme 2M (Agilité)",
		["Enchant 2H Weapon - Greater Impact"] = "Ench. d'arme 2M (Impact supérieur)",
		["Enchant 2H Weapon - Impact"] = "Ench. d'arme 2M (Impact)",
		["Enchant 2H Weapon - Lesser Impact"] = "Ench. d'arme 2M (Impact inférieur)",
		["Enchant 2H Weapon - Lesser Intellect"] = "Ench. d'arme 2M (Intelligence inférieure)",
		["Enchant 2H Weapon - Lesser Spirit"] = "Ench. d'arme 2M (Esprit inférieur)",
		["Enchant 2H Weapon - Major Agility"] = "Ench. d'arme 2M (Agilité majeure)",
		["Enchant 2H Weapon - Major Intellect"] = "Ench. d'arme 2M (Intelligence majeure)",
		["Enchant 2H Weapon - Major Spirit"] = "Ench. d'arme 2M (Esprit majeur)",
		["Enchant 2H Weapon - Minor Impact"] = "Ench. d'arme 2M (Impact mineur)",
		["Enchant 2H Weapon - Savagery"] = "Ench. d'arme 2M (Sauvagerie)",
		["Enchant 2H Weapon - Superior Impact"] = "Ench. d'arme 2M (Impact excellent)",
		["Enchant Boots - Agility"] = "Ench. de bottes (Agilité)",
		["Enchant Boots - Boar's Speed"] = "Ench. de bottes (Vitesse du sanglier)",
		["Enchant Boots - Cat's Swiftness"] = "Ench. de bottes (Rapidité du félin)",
		["Enchant Boots - Dexterity"] = "Ench. de bottes (Dextérité)",
		["Enchant Boots - Fortitude"] = "Ench. de bottes (Robustesse)",
		["Enchant Boots - Greater Agility"] = "Ench. de bottes (Agilité supérieure)",
		["Enchant Boots - Greater Stamina"] = "Ench. de bottes (Endurance supérieure)",
		["Enchant Boots - Lesser Agility"] = "Ench. de bottes (Agilité inférieure)",
		["Enchant Boots - Lesser Spirit"] = "Ench. de bottes (Esprit inférieur)",
		["Enchant Boots - Lesser Stamina"] = "Ench. de bottes (Endurance inférieure)",
		["Enchant Boots - Minor Agility"] = "Ench. de bottes (Agilité mineure)",
		["Enchant Boots - Minor Speed"] = "Ench. de bottes (Vitesse mineure)",
		["Enchant Boots - Minor Stamina"] = "Ench. de bottes (Endurance mineure)",
		["Enchant Boots - Spirit"] = "Ench. de bottes (Esprit)",
		["Enchant Boots - Stamina"] = "Ench. de bottes (Endurance)",
		["Enchant Boots - Surefooted"] = "Ench. de bottes (Pied sûr)",
		["Enchant Boots - Vitality"] = "Ench. de bottes (Vitalité)",
		["Enchant Bracer - Assault"] = "Ench. de brassards (Assaut)",
		["Enchant Bracer - Brawn"] = "Ench. de brassards (Masse musculaire)",
		["Enchant Bracer - Deflection"] = "Ench. de brassards (Déviation)",
		["Enchant Bracer - Fortitude"] = "Ench. de brassards (Robustesse)",
		["Enchant Bracer - Greater Intellect"] = "Ench. de brassards (Intelligence supérieure)",
		["Enchant Bracer - Greater Spirit"] = "Ench. de brassards (Esprit supérieur)",
		["Enchant Bracer - Greater Stamina"] = "Ench. de brassards (Endurance supérieure)",
		["Enchant Bracer - Greater Strength"] = "Ench. de brassards (Force supérieure)",
		["Enchant Bracer - Healing Power"] = "Ench. de brassards (Pouvoir de guérison)",
		["Enchant Bracer - Intellect"] = "Ench. de brassards (Intelligence)",
		["Enchant Bracer - Lesser Deflection"] = "Ench. de brassards (Déviation inférieure)",
		["Enchant Bracer - Lesser Intellect"] = "Ench. de brassards (Intelligence inférieure)",
		["Enchant Bracer - Lesser Spirit"] = "Ench. de brassards (Esprit inférieur)",
		["Enchant Bracer - Lesser Stamina"] = "Ench. de brassards (Endurance inférieure)",
		["Enchant Bracer - Lesser Strength"] = "Ench. de brassards (Force inférieure)",
		["Enchant Bracer - Major Defense"] = "Ench. de brassards (Défense majeure)",
		["Enchant Bracer - Major Intellect"] = "Ench. de brassards (Intelligence majeure)",
		["Enchant Bracer - Mana Regeneration"] = "Ench. de brassards (Régénération de mana)",
		["Enchant Bracer - Minor Agility"] = "Ench. de brassards (Agilité mineure)",
		["Enchant Bracer - Minor Deflection"] = "Ench. de brassards (Déviation mineure)",
		["Enchant Bracer - Minor Health"] = "Ench. de brassards (Vie mineure)",
		["Enchant Bracer - Minor Spirit"] = "Ench. de brassards (Esprit mineur)",
		["Enchant Bracer - Minor Stamina"] = "Ench. de brassards (Endurance mineure)",
		["Enchant Bracer - Minor Strength"] = "Ench. de brassards (Force mineure)",
		["Enchant Bracer - Restore Mana Prime"] = "Ench. de brassards (Restauration du mana premier)",
		["Enchant Bracer - Spellpower"] = "Ench. de brassards (Puissance des sorts)",
		["Enchant Bracer - Spirit"] = "Ench. de brassards (Esprit)",
		["Enchant Bracer - Stamina"] = "Ench. de brassards (Endurance)",
		["Enchant Bracer - Stats"] = "Ench. de brassards (Caractéristiques)",
		["Enchant Bracer - Strength"] = "Ench. de brassards (Force)",
		["Enchant Bracer - Superior Healing"] = "Ench. de brassards (Soins excellents)",
		["Enchant Bracer - Superior Spirit"] = "Ench. de brassards (Esprit excellent)",
		["Enchant Bracer - Superior Stamina"] = "Ench. de brassards (Endurance excellente)",
		["Enchant Bracer - Superior Strength"] = "Ench. de brassards (Force excellente)",
		["Enchant Chest - Defense"] = "Enchantement de plastron (Défense)",
		["Enchant Chest - Exceptional Health"] = "Ench. de plastron (Pts vie exceptionnels)",
		["Enchant Chest - Exceptional Stats"] = "Ench. de plastron (Carac. exceptionnelles)",
		["Enchant Chest - Greater Health"] = "Ench. de plastron (Vie supérieure)",
		["Enchant Chest - Greater Mana"] = "Ench. de plastron (Mana supérieur)",
		["Enchant Chest - Greater Stats"] = "Ench. de plastron (Caract. supérieures)",
		["Enchant Chest - Health"] = "Ench. de plastron (Vie)",
		["Enchant Chest - Lesser Absorption"] = "Ench. de plastron (Absorption inférieure)",
		["Enchant Chest - Lesser Health"] = "Ench. de plastron (Vie inférieure)",
		["Enchant Chest - Lesser Mana"] = "Ench. de plastron (Mana inférieur)",
		["Enchant Chest - Lesser Stats"] ="Ench. de plastron (Caract. inférieures)",
		["Enchant Chest - Major Health"] = "Ench. de plastron (Vie majeure)",
		["Enchant Chest - Major Mana"] = "Ench. de plastron (Mana majeur)",
		["Enchant Chest - Major Resilience"] = "Ench. de plastron (Résilience majeure)",
		["Enchant Chest - Major Spirit"] = "Ench. de plastron (Esprit majeur)",
		["Enchant Chest - Mana"] = "Ench. de plastron (Mana)",
		["Enchant Chest - Minor Absorption"] = "Ench. de plastron (Absorption mineure)",
		["Enchant Chest - Minor Health"] = "Ench. de plastron (Vie mineure)",
		["Enchant Chest - Minor Mana"] = "Ench. de plastron (Mana mineur)",
		["Enchant Chest - Minor Stats"] = "Ench. de plastron (Caract. mineures)",
		["Enchant Chest - Restore Mana Prime"] = "Ench. de plastron (Rest. du mana premier)",
		["Enchant Chest - Stats"] = "Ench. de plastron (Caractéristiques)",
		["Enchant Chest - Superior Health"] = "Ench. de plastron (Santé excellente)",
		["Enchant Chest - Superior Mana"] = "Ench. de plastron (Mana excellent)",
		["Enchant Cloak - Defense"] = "Ench. de cape (Défense)",
		["Enchant Cloak - Dodge"] = "Ench. de cape (Esquive)",
		["Enchant Cloak - Fire Resistance"] = "Ench. de cape (Résistance au Feu)",
		["Enchant Cloak - Greater Agility"] = "Ench. de cape (Agilité supérieure)",
		["Enchant Cloak - Greater Arcane Resistance"] = "Ench. de cape (Résistance aux arcanes supérieure)",
		["Enchant Cloak - Greater Defense"] = "Ench. de cape (Défense supérieure)",
		["Enchant Cloak - Greater Fire Resistance"] = "Ench. de cape (Résistance au Feu supérieure)",
		["Enchant Cloak - Greater Nature Resistance"] = "Ench. de cape (Résistance à la Nature supérieure)",
		["Enchant Cloak - Greater Resistance"] = "Ench. de cape (Résistance supérieure)",
		["Enchant Cloak - Greater Shadow Resistance"] = "Ench. de cape (Résistance à l'Ombre supérieure)",
		["Enchant Cloak - Lesser Agility"] = "Ench. de cape (Agilité inférieure)",
		["Enchant Cloak - Lesser Fire Resistance"] = "Ench. de cape (Résistance au Feu inf.)",
		["Enchant Cloak - Lesser Protection"] = "Ench. de cape (Protection inférieure)",
		["Enchant Cloak - Lesser Shadow Resistance"] = "Ench. de cape (Résistance à l'Ombre inf.)",
		["Enchant Cloak - Major Armor"] = "Ench. de cape (Armure majeure)",
		["Enchant Cloak - Major Resistance"] = "Ench. de cape (Résistance majeure)",
		["Enchant Cloak - Minor Agility"] = "Ench. de cape (Agilité mineure)",
		["Enchant Cloak - Minor Protection"] = "Ench. de cape (Protection mineure)",
		["Enchant Cloak - Minor Resistance"] = "Ench. de cape (Résistance mineure)",
		["Enchant Cloak - Resistance"] = "Ench. de cape (Résistance)",
		["Enchant Cloak - Spell Penetration"] = "Ench. de cape (Pénétration des sorts)",
		["Enchant Cloak - Stealth"] = "Ench. de cape (Camouflage)",
		["Enchant Cloak - Steelweave"] = "Enchantement de cape (Tisse-acier)",
		["Enchant Cloak - Subtlety"] = "Ench. de cape (Discrétion)",
		["Enchant Cloak - Superior Defense"] = "Ench. de cape (Défense excellente)",
		["Enchant Gloves - Advanced Herbalism"] = "Ench. de gants (Herboristerie avancée)",
		["Enchant Gloves - Advanced Mining"] = "Ench. de gants (Minage avancé)",
		["Enchant Gloves - Agility"] = "Ench. de gants (Agilité)",
		["Enchant Gloves - Assault"] = "Ench. de gants (Assaut)",
		["Enchant Gloves - Blasting"] = "Ench. de gants (Explosion)",
		["Enchant Gloves - Fire Power"] = "Ench. de gants (Puissance du feu)",
		["Enchant Gloves - Fishing"] = "Ench. de gants (Pêche)",
		["Enchant Gloves - Frost Power"] = "Ench. de gants (Puissance du givre)",
		["Enchant Gloves - Greater Agility"] = "Ench. de gants (Agilité supérieure)",
		["Enchant Gloves - Greater Strength"] = "Ench. de gants (Force supérieure)",
		["Enchant Gloves - Healing Power"] = "Ench. de gants (Pouvoir de guérison)",
		["Enchant Gloves - Herbalism"] = "Ench. de gants (Herboristerie)",
		["Enchant Gloves - Major Healing"] = "Ench. de gants (Soins majeurs)",
		["Enchant Gloves - Major Spellpower"] = "Ench. de gants (Puissance des sorts majeure)",
		["Enchant Gloves - Major Strength"] = "Ench. de gants (Force majeure)",
		["Enchant Gloves - Mining"] = "Ench. de gants (Minage)",
		["Enchant Gloves - Minor Haste"] = "Ench. de gants (Hâte mineure)",
		["Enchant Gloves - Riding Skill"] = "Ench. de gants (Equitation)",
		["Enchant Gloves - Shadow Power"] = "Ench. de gants (Puissance de l'ombre)",
		["Enchant Gloves - Skinning"] = "Ench. de gants (Dépeçage)",
		["Enchant Gloves - Spell Strike"] = "Ench. de gants (Frappe-sort)",
		["Enchant Gloves - Strength"] = "Ench. de gants (Force)",
		["Enchant Gloves - Superior Agility"] = "Ench. de gants (Agilité excellente)",
		["Enchant Gloves - Threat"] = "Ench. de gants (Menace)",
		["Enchant Ring - Healing Power"] = "Ench. d'anneau (Pouvoir de guérison)",
		["Enchant Ring - Spellpower"] = "Ench. d'anneau (Puissance des sorts)",
		["Enchant Ring - Stats"] = "Ench. d'anneau (Caractéristiques)",
		["Enchant Ring - Striking"] = "Ench. d'anneau (Frappe)",
		["Enchant Shield - Frost Resistance"] = "Ench. de bouclier (Résistance au Givre)",
		["Enchant Shield - Greater Spirit"] = "Ench. de bouclier (Esprit supérieur)",
		["Enchant Shield - Greater Stamina"] = "Ench. de bouclier (Endurance supérieure)",
		["Enchant Shield - Intellect"] = "Ench. de bouclier (Intelligence)",
		["Enchant Shield - Lesser Block"] = "Ench. de bouclier (Blocage inférieur)",
		["Enchant Shield - Lesser Protection"] = "Ench. de bouclier (Protection inférieure)",
		["Enchant Shield - Lesser Spirit"] = "Ench. de bouclier (Esprit inférieur)",
		["Enchant Shield - Lesser Stamina"] = "Ench. de bouclier (Endurance inférieure)",
		["Enchant Shield - Major Stamina"] = "Ench. de bouclier (Endurance majeure)",
		["Enchant Shield - Minor Stamina"] = "Ench. de bouclier (Endurance mineure)",
		["Enchant Shield - Resistance"] = "Ench. de bouclier (Résistance)",
		["Enchant Shield - Shield Block"] = "Ench. de bouclier (Maîtrise du blocage)",
		["Enchant Shield - Spirit"] = "Ench. de bouclier (Esprit)",
		["Enchant Shield - Stamina"] = "Ench. de bouclier (Endurance)",
		["Enchant Shield - Superior Spirit"] = "Ench. de bouclier (Esprit excellent)",
		["Enchant Shield - Resilience"] = "Ench. de bouclier (Résilience)",
		["Enchant Shield - Tough Shield"] = "Ench. de bouclier (Inébranlable)",
		["Enchant Weapon - Agility"] = "Ench. d'arme (Agilité)",
		["Enchant Weapon - Battlemaster"] = "Ench. d'arme (Maître de guerre)",
		["Enchant Weapon - Crusader"] = "Ench. d'arme (Croisé)",
		["Enchant Weapon - Demonslaying"] = "Ench. d'arme (Tueur de démon)",
		["Enchant Weapon - Executioner"] = "Ench. d'arme (Exécutrice)",
		["Enchant Weapon - Fiery Weapon"] = "Ench. d'arme (Arme flamboyante)",
		["Enchant Weapon - Greater Agility"] = "Ench. d'arme (Agilité supérieure)",
		["Enchant Weapon - Greater Striking"] = "Ench. d'arme (Frappe supérieure)",
		["Enchant Weapon - Healing Power"] = "Ench. d'arme (Pouvoir de guérison)",
		["Enchant Weapon - Icy Chill"] = "Ench. d'arme (Frisson glacial)",
		["Enchant Weapon - Lesser Beastslayer"] = "Ench. d'arme (Tueur de bête inférieur)",
		["Enchant Weapon - Lesser Elemental Slayer"] = "Ench. d'arme (Tueur d'élémentaire inférieur)",
		["Enchant Weapon - Lesser Striking"] = "Ench. d'arme (Frappe inférieure)",
		["Enchant Weapon - Lifestealing"] = "Ench. d'arme (Vol de vie)",
		["Enchant Weapon - Major Healing"] = "Ench. d'arme (Soins majeurs)",
		["Enchant Weapon - Major Intellect"] = "Ench. d'arme (Intelligence majeure)",
		["Enchant Weapon - Major Spellpower"] = "Ench. d'arme (Puissance des sorts majeure)",
		["Enchant Weapon - Major Striking"] = "Ench. d'arme (Frappe majeure)",
		["Enchant Weapon - Mighty Intellect"] = "Ench. d'arme (Intelligence renforcée)",
		["Enchant Weapon - Mighty Spirit"] = "Ench. d'arme (Esprit renforcé)",
		["Enchant Weapon - Minor Beastslayer"] = "Ench. d'arme (Tueur de bête mineur)",
		["Enchant Weapon - Minor Striking"] = "Ench. d'arme (Frappe mineure)",
		["Enchant Weapon - Mongoose"] = "Ench. d'arme (Mangouste)",
		["Enchant Weapon - Potency"] = "Ench. d'arme (Toute-puissance)",
		["Enchant Weapon - Soulfrost"] = "Ench. d'arme (Âme de givre)",
		["Enchant Weapon - Spell Power"] = "Ench. d'arme (Puissance des sorts)",
		["Enchant Weapon - Spellsurge"] = "Ench. d'arme (Eruption de sort)",
		["Enchant Weapon - Strength"] = "Ench. d'arme (Force)",
		["Enchant Weapon - Striking"] = "Ench. d'arme (Frappe)",
		["Enchant Weapon - Sunfire"] = "Ench. d'arme (Feu solaire)",
		["Enchant Weapon - Superior Striking"] = "Ench. d'arme (Frappe excellente)",
		["Enchant Weapon - Unholy Weapon"] = "Ench. d'arme (Arme impie)",
		["Enchant Weapon - Winter's Might"] = "Ench. d'arme (Puissance de l'hiver)",
		["Enchanted Leather"] = "Cuir enchanté",
		["Enchanted Thorium"] = "Thorium enchanté",
		["Greater Magic Wand"] = "Baguette magique supérieure",
		["Greater Mystic Wand"] = "Baguette mystique supérieure",
		["Large Prismatic Shard"] = "Grand éclat prismatique",
		["Lesser Magic Wand"] = "Baguette magique inférieure",
		["Lesser Mana Oil"] = "Huile de mana inférieure",
		["Lesser Mystic Wand"] = "Baguette mystique inférieure",
		["Lesser Wizard Oil"] = "Huile de sorcier inférieure",
		["Minor Mana Oil"] = "Huile de mana mineure",
		["Minor Wizard Oil"] = "Huile de sorcier mineure",
		["Nexus Transformation"] = "Transformation de nexus",
		["Prismatic Sphere"] = "Sphère prismatique",
		["Runed Adamantite Rod"] = "Bâtonnet runique en adamantite",
		["Runed Arcanite Rod"] = "Bâtonnet runique en arcanite",
		["Runed Copper Rod"] = "Bâtonnet runique en cuivre",
		["Runed Eternium Rod"] = "Bâtonnet runique en éternium",
		["Runed Fel Iron Rod"] = "Bâtonnet runique en gangrefer",
		["Runed Golden Rod"] = "Bâtonnet runique en or",
		["Runed Silver Rod"] = "Bâtonnet runique en argent",
		["Runed Truesilver Rod"] = "Bâtonnet runique en vrai-argent",
		["Small Prismatic Shard"] = "Petit éclat prismatique",
		["Smoking Heart of the Mountain"] = "Coeur fumant de la montagne",
		["Superior Mana Oil"] = "Huile de mana excellente",
		["Superior Wizard Oil"] = "Huile de sorcier excellente",
		["Void Shatter"] = "Bris de vide",
		["Void Sphere"] = "Sphère de Vide",
		["Wizard Oil"] = "Huile de sorcier",

-- Engineering Recipes
		["Accurate Scope"] = "Lunette de précision",
		["Adamantite Arrow Maker"] = "Tailleur de flèches en adamantite",
		["Adamantite Frame"] = "Structure en adamantite",
		["Adamantite Grenade"] = "Grenade en adamantite",
		["Adamantite Rifle"] = "Carabine en adamantite",
		["Adamantite Scope"] = "Lunette en adamantite",
		["Adamantite Shell Machine"] = "Presse à obus en adamantite",
		["Advanced Target Dummy"] = "Leurre perfectionné",
		["Alarm-O-Bot"] = "Robot d'alarme",
		["Aquadynamic Fish Attractor"] = "Attracteur de poissons aquadynamique",
		["Arcane Bomb"] = "Bombe des arcanes",
		["Arcanite Dragonling"] = "Petit dragon en arcanite",
		["Arclight Spanner"] = "Clé plate",
		["Big Bronze Bomb"] = "Grande bombe en bronze",
		["Big Iron Bomb"] = "Grande bombe en fer",
		["Biznicks 247x128 Accurascope"] = "Hyperviseur Biznicks 247 x 128",
		["Bloodvine Goggles"] = "Lunettes en vignesang",
		["Bloodvine Lens"] = "Lentille en vignesang",
		["Blue Firework"] = "Fusée bleue",
		["Blue Rocket Cluster"] = "Chapelet de comètes bleues",
		["Bright-Eye Goggles"] = "Lunettes d'oeil brillant",
		["Bronze Framework"] = "Structure en bronze",
		["Bronze Tube"] = "Tube en bronze",
		["Catseye Ultra Goggles"] = "Lunettes d'oeil de chat",
		["Coarse Blasting Powder"] = "Poudre d'explosion grossière",
		["Coarse Dynamite"] = "Dynamite grossière",
		["Cogspinner Goggles"] = "Lunettes de Tournepignon",
		["Compact Harvest Reaper Kit"] = "Kit de moissonneur compact",
		["Copper Modulator"] = "Modulateur en cuivre",
		["Copper Tube"] = "Tube en cuivre",
		["Core Marksman Rifle"] = "Carabine de tireur d'élite endurci",
		["Crafted Heavy Shot"] = "Balle lourde fabriquée",
		["Crafted Light Shot"] = "Balle légère fabriquée",
		["Crafted Solid Shot"] = "Balle dure fabriquée",
		["Craftsman's Monocle"] = "Monocle d'artisan",
		["Crashin' Thrashin' Robot"] = "Robot Cogn'Baff",
		["Crude Scope"] = "Lunette basique",
		["Dark Iron Bomb"] = "Bombe en sombrefer",
		["Dark Iron Rifle"] = "Carabine en sombrefer",
		["Deadly Blunderbuss"] = "Tromblon mortel",
		["Deadly Scope"] = "Lunette mortelle",
		["Deathblow X11 Goggles"] = "Lunettes coup-de-grâce X11",
		["Deepdive Helmet"] = "Casque de scaphandrier",
		["Delicate Arcanite Converter"] = "Convertisseur d'arcanite délicat",
		["Dense Blasting Powder"] = "Poudre d'explosion dense",
		["Dense Dynamite"] = "Dynamite dense",
		["Destruction Holo-gogs"] = "Holo-binocles de destruction",
		["Dimensional Ripper - Area 52"] = "Déchiqueteur dimensionnel - Zone 52",
		["Dimensional Ripper - Everlook"] = "Déchiqueteur dimensionnel - Long-guet",
		["Discombobulator Ray"] = "Rayon discombobulateur",
		["Elemental Blasting Powder"] = "Poudre d'explosion élémentaire",
		["Elemental Seaforium Charge"] = "Charge d'hydroglycérine élémentaire",
		["Explosive Sheep"] = "Mouton explosif",
		["EZ-Thro Dynamite II"] = "Dynamite Ev-Lan II",
		["EZ-Thro Dynamite"] = "Dynamite Ev-Lan",
		["Fel Iron Bomb"] = "Bombe en gangrefer",
		["Fel Iron Casing"] = "Etui en gangrefer",
		["Fel Iron Musket"] = "Mousquet en gangrefer",
		["Fel Iron Shells"] = "Obus en gangrefer",
		["Fel Iron Toolbox"] = "Boîte à outils en gangrefer",
		["Felsteel Boomstick"] = "Espingole en gangracier",
		["Felsteel Stabilizer"] = "Stabilisateur en gangracier",
		["Field Repair Bot 110G"] = "Robot réparateur 110G",
		["Field Repair Bot 74A"] = "Robot réparateur 74A",
		["Fire Goggles"] = "Lunettes de feu",
		["Firework Cluster Launcher"] = "Lanceur de chapelets de fusées",
		["Firework Launcher"] = "Lanceur de fusée",
		["Flame Deflector"] = "Pare-flammes",
		["Flash Bomb"] = "Bombe éclairante",
		["Flawless Arcanite Rifle"] = "Carabine sans défaut en arcanite",
		["Flying Machine"] = "Machine volante",
		["Flying Tiger Goggles"] = "Lunettes de tigre volant",
		["Force Reactive Disk"] = "Disque de force réactif",
		["Foreman's Enchanted Helmet"] = "Casque de contremaître enchanté",
		["Foreman's Reinforced Helmet"] = "Casque de contremaître renforcé",
		["Frost Grenades"] = "Grenades de givre",
		["Furious Gizmatic Goggles"] = "Lunettes bibelomatiques furieuses",
		["Fused Wiring"] = "Câble avec fusible",
		["Gadgetstorm Goggles"] = "Lunettes de gadget-orage",
		["Gnomish Battle Chicken"] = "Coq de combat gnome",
		["Gnomish Battle Goggles"] = "Lunettes de combat gnomes",
		["Gnomish Cloaking Device"] = "Système d'occultation gnome",
		["Gnomish Death Ray"] = "Rayon mortel gnome",
		["Gnomish Flame Turret"] = "Tourelle à feu gnome",
		["Gnomish Goggles"] = "Lunettes gnomes",
		["Gnomish Harm Prevention Belt"] = "Ceinture de prévention gnome",
		["Gnomish Mind Control Cap"] = "Coiffe de contrôle mental gnome",
		["Gnomish Net-o-Matic Projector"] = "Lance-filet automatique gnome",
		["Gnomish Poultryizer"] = "Pouletisateur gnome",
		["Gnomish Power Goggles"] = "Lunettes de puissance gnomes",
		["Gnomish Rocket Boots"] = "Bottes-fusées gnomes",
		["Gnomish Shrink Ray"] = "Rayon réducteur gnome",
		["Gnomish Universal Remote"] = "Télécommande universelle gnome",
		["Goblin Bomb Dispenser"] = "Distributeur de bombes gobelin",
		["Goblin Construction Helmet"] = "Casque de chantier gobelin",
		["Goblin Dragon Gun"] = "Fusil-dragon gobelin",
		["Goblin Jumper Cables XL"] = "Défibrillateur gobelin XL",
		["Goblin Jumper Cables"] = "Défibrillateur gobelin",
		["Goblin Land Mine"] = "Mine gobeline",
		["Goblin Mining Helmet"] = "Casque de mineur gobelin",
		["Goblin Mortar"] = "Mortier gobelin",
		["Goblin Rocket Boots"] = "Bottes-fusées gobelines",
		["Goblin Rocket Fuel Recipe"] = "Recette du carburant de fusée gobelin",
		["Goblin Rocket Helmet"] = "Heaume-fusée gobelin",
		["Goblin Rocket Launcher"] = "Lance-roquettes gobelin",
		["Goblin Sapper Charge"] = "Charge de sapeur gobelin",
		["Gold Power Core"] = "Batterie en or",
		["Green Firework"] = "Fusée verte",
		["Green Lens"] = "Lentille verte",
		["Green Rocket Cluster"] = "Chapelet de comètes vertes",
		["Green Smoke Flare"] = "Fumigène vert",
		["Green Tinted Goggles"] = "Lunettes teintées vertes",
		["Gyro-balanced Khorium Destroyer"] = "Destructeur gyroscopique en khorium",
		["Gyrochronatom"] = "Gyrochronatome",
		["Gyrofreeze Ice Reflector"] = "Réflectoglace gyrogivre",
		["Gyromatic Micro-Adjustor"] = "Micro-ajusteur gyromatique",
		["Handful of Copper Bolts"] = "Poignée de boulons en cuivre",
		["Handful of Fel Iron Bolts"] = "Poignée de boulons en gangrefer",
		["Hardened Adamantite Tube"] = "Tube en adamantite trempé",
		["Healing Potion Injector"] = "Injecteur de potion de soins",
		["Heavy Blasting Powder"] = "Poudre d'explosion majeure",
		["Heavy Dynamite"] = "Dynamite puissante",
		["Hi-Explosive Bomb"] = "Bombe explosive",
		["Hi-Impact Mithril Slugs"] = "Balles perçantes en mithril",
		["Hyper-Radiant Flame Reflector"] = "Réflectoflamme hyper-radiant",
		["Hyper-Vision Goggles"] = "Lunettes d'hyper-vision",
		["Ice Deflector"] = "Pare-glace",
		["Icy Blasting Primers"] = "Amorces d'explosion glaciale",
		["Inlaid Mithril Cylinder Plans"] = "Cylindre damasquiné en mithril",
		["Iron Grenade"] = "Grenade en fer",
		["Iron Strut"] = "Contrefiche en fer",
		["Justicebringer 2000 Specs"] = "Bésicles Porte-justice 2000",
		["Khorium Power Core"] = "Batterie en khorium",
		["Khorium Scope"] = "Lunette en khorium",
		["Large Blue Rocket Cluster"] = "Chapelet de grandes comètes bleues",
		["Large Blue Rocket"] = "Grande comète bleue",
		["Large Copper Bomb"] = "Grande bombe en cuivre",
		["Large Green Rocket Cluster"] = "Chapelet de grandes comètes vertes",
		["Large Green Rocket"] = "Grande comète verte",
		["Large Red Rocket Cluster"] = "Chapelet de grandes comètes rouges",
		["Large Red Rocket"] = "Grande comète rouge",
		["Large Seaforium Charge"] = "Grande charge d'hydroglycérine",
		["Lifelike Mechanical Toad"] = "Crapaud mécanique",
		["Lil' Smoky"] = "Petit fumant",
		["Living Replicator Specs"] = "Bésicles vivantes du réplicateur",
		["Lovingly Crafted Boomstick"] = "Espingole amoureusement construite",
		["Magnified Moon Specs"] = "Bésicles lunaires amplifiées",
		["Major Recombobulator"] = "Recombobulateur majeur",
		["Mana Potion Injector"] = "Injecteur de potion de mana",
		["Master Engineer's Goggles"] = "Lunettes de maître ingénieur",
		["Masterwork Target Dummy"] = "Leurre ouvragé",
		["Mechanical Dragonling"] = "Petit dragon mécanique",
		["Mechanical Repair Kit"] = "Trousse de réparation mécanique",
		["Mechanical Squirrel"] = "Ecureuil mécanique",
		["Minor Recombobulator"] = "Recombobulateur mineur",
		["Mithril Blunderbuss"] = "Tromblon en mithril",
		["Mithril Casing"] = "Armature en mithril",
		["Mithril Frag Bomb"] = "Bombe explosive en mithril",
		["Mithril Gyro-Shot"] = "Balle gyroscopique en mithril",
		["Mithril Heavy-bore Rifle"] = "Carabine de gros calibre en mithril",
		["Mithril Mechanical Dragonling"] = "Petit dragon mécanique en mithril",
		["Mithril Tube"] = "Tube en mithril",
		["Moonsight Rifle"] = "Carabine vise-lune",
		["Nigh-Invulnerability Belt"] = "Ceinture de quasi-invulnérabilité",
		["Ornate Khorium Rifle"] = "Carabine ornée en khorium",
		["Ornate Spyglass"] = "Longue-vue ornée",
		["Parachute Cloak"] = "Cape parachute",
		["Pet Bombling"] = "Bombinette",
		["Portable Bronze Mortar"] = "Mortier portable en bronze",
		["Power Amplification Goggles"] = "Lunettes d'amplification de puissance",
		["Powerful Seaforium Charge"] = "Puissante charge d'hydroglycérine",
		["Powerheal 4000 Lens"] = "Lentille fulgurosoin 4000",
		["Practice Lock"] = "Serrure d'entraînement",
		["Purple Smoke Flare"] = "Fumigène violet",
		["Red Firework"] = "Fusée rouge",
		["Red Rocket Cluster"] = "Chapelet de comètes rouges",
		["Rocket Boots Xtreme"] = "Bottes-fusées extrêmes",
		["Rocket Boots Xtreme Lite"] = "Bottes-fusées extrêmes légères",
		["Rose Colored Goggles"] = "Lunettes roses",
		["Rough Blasting Powder"] = "Poudre d'explosion basique",
		["Rough Boomstick"] = "Espingole grossière",
		["Rough Copper Bomb"] = "Bombe grossière en cuivre",
		["Rough Dynamite"] = "Dynamite basique",
		["Salt Shaker"] = "Tamis à sel",
		["Shadow Goggles"] = "Lunettes des ombres",
		["Silver Contact"] = "Contact en argent",
		["Silver-plated Shotgun"] = "Fusil plaqué argent",
		["Small Blue Rocket"] = "Petite comète bleue",
		["Small Bronze Bomb"] = "Petite bombe en bronze",
		["Small Green Rocket"] = "Petite comète verte",
		["Small Red Rocket"] = "Petite comète rouge",
		["Small Seaforium Charge"] = "Petite charge d'hydroglycérine",
		["Snake Burst Firework"] = "Feu d'artifice \"Explosion serpentine\"",
		["Sniper Scope"] = "Lunette de sniper",
		["SnowMaster 9000"] = "Maître-neige 9000",
		["Solid Blasting Powder"] = "Poudre noire solide",
		["Solid Dynamite"] = "Dynamite solide",
		["Spellpower Goggles Xtreme Plus"] = "Lunettes de concentration extrême",
		["Spellpower Goggles Xtreme"] = "Lunettes de fortification des sorts",
		["Stabilized Eternium Scope"] = "Lunette en éternium stabilisé",
		["Standard Scope"] = "Lunette standard",
		["Steam Tonk Controller"] = "Commande de chariotte à vapeur",
		["Super Sapper Charge"] = "Super-charge de sapeur",
		["Surestrike Goggles v2.0"] = "Lunettes vise-juste v2.0",
		["Tankatronic Goggles"] = "Lunettes tankatroniques",
		["Target Dummy"] = "Leurre",
		["The Big One"] = "Le Mastoc",
		["The Bigger One"] = "L'Encore-Plus-Mastoc",
		["The Mortar: Reloaded"] = "Le mortier : rechargé",
		["Thorium Grenade"] = "Grenade en thorium",
		["Thorium Rifle"] = "Carabine en thorium",
		["Thorium Shells"] = "Obus en thorium",
		["Thorium Tube"] = "Tube en thorium",
		["Thorium Widget"] = "Rouage en thorium",
		["Tranquil Mechanical Yeti"] = "Yéti mécanique paisible",
		["Truesilver Transformer"] = "Altérateur de vrai-argent",
		["Turbo-Charged Flying Machine"] = "Machine volante à turbo-injection",
		["Ultra-Flash Shadow Reflector"] = "Réflectombre ultra-flash",
		["Ultrasafe Transporter - Gadgetzan"] = "Transporteur ultra-sécurisé : Gadgetzan",
		["Ultrasafe Transporter - Toshley's Station"] = "Transporteur ultra-sécurisé : Poste de Toshley",
		["Ultra-Spectropic Detection Goggles"] = "Lunettes de détection ultra-spectroscopiques",
		["Unstable Trigger"] = "Déclencheur instable",
		["Voice Amplification Modulator"] = "Modulateur d'amplification vocale",
		["Whirring Bronze Gizmo"] = "Bidule bourdonnant en bronze",
		["White Smoke Flare"] = "Fumigène blanc",
		["Wonderheal XT40 Shades"] = "Lunettes de soleil fabulosoin XT40",
		["World Enlarger"] = "Agrandisseur de monde",
		["Zapthrottle Mote Extractor"] = "Extracteur de granules Zappeur-Gazier",
		["Lightning Etched Specs"] = "Bésicles gravées aux éclairs",
		["Annihilator Holo-Gogs"] = "Holo-binocles d'anhilation",
		["Primal-Attuned Goggles"] = "Lunettes d'harmonie primale",
		["Powerheal 9000 Lens"] = "Lentille fulgurosoin 9000",
		["Justicebringer 3000 Specs"] = "Bésicles Porte-justice 3000",
		["Surestrike Goggles v3.0"] = "Lunettes vise-juste v3,0",
		["Hyper-Magnified Moon Specs"] = "Bésicles lunaires hyper-amplifiées",
		["Wonderheal XT68 Shades"] = "Lunettes de soleil fabulosoin XT68",
		["Hard Khorium Goggles"] = "Lunettes en Khorium durci",
		["Quad Deathblow X44 Goggles"] = "Quadrilunettes coup-de-grâce X44",
		["Mayhem Projection Goggles"] = "Lunettes de projection de désordre",

-- First Aid Recipes
		["Anti-Venom"] = "Anti-venin",
		["Heavy Linen Bandage"] = "Bandage épais en lin",
		["Heavy Mageweave Bandage"] = "Bandage épais en tisse-mage",
		["Heavy Netherweave Bandage"] = "Bandage épais en tisse-néant",
		["Heavy Runecloth Bandage"] = "Bandage épais en étoffe runique",
		["Heavy Silk Bandage"] = "Bandage épais en soie",
		["Heavy Wool Bandage"] = "Bandage épais en laine",
		["Linen Bandage"] = "Bandage en lin",
		["Mageweave Bandage"] = "Bandage en tisse-mage",
		["Netherweave Bandage"] = "Bandage en tisse-néant",
		["Powerful Anti-Venom"] = "Anti-venin puissant",
		["Runecloth Bandage"] = "Bandage en étoffe runique",
		["Silk Bandage"] = "Bandage en soie",
		["Strong Anti-Venom"] = "Sérum anti-venin supérieur",
		["Wool Bandage"] = "Bandage en laine",

-- Jewelcrafting Recipes
		["Amulet of Flowing Life"] = "Amulette de vague de vie",
		["Amulet of the Moon"] = "Amulette de la lune",
		["Aquamarine Pendant of the Warrior"] = "Pendentif d'aigue-marine du guerrier",
		["Aquamarine Signet"] = "Chevalière d'aigue-marine",
		["Arcane Khorium Band"] = "Bague des arcanes en khorium",
		["Azure Moonstone Ring"] = "Anneau de pierre de lune azur",
		["Balanced Nightseye"] = "Oeil de nuit équilibré",
		["Balanced Shadowsong Amethyst"] = "Améthyste chantelombre équilibrée",
		["Balanced Shadow Draenite"] = "Draénite ombreuse équilibrée",
		["Band of Natural Fire"] = "Bague du feu naturel",
		["Barbaric Iron Collar"] = "Torque barbare en fer",
		["Blazing Citrine Ring"] = "Anneau de citrine flamboyant",
		["Blazing Eternium Band"] = "Bague flamboyante en éternium",
		["Blood of Amber"] = "Sang d'Ambre",
		["Bold Blood Garnet"] = "Grenat sanguin soutenu",
		["Bold Crimson Spinel"] = "Spinelle cramoisi soutenu",
		["Bold Living Ruby"] = "Rubis vivant soutenu",
		["Bracing Earthstorm Diamond"] = "Diamant tonneterre de fringance",
		["Braided Copper Ring"] = "Anneau en cuivre tressé",
		["Braided Eternium Chain"] = "Chaîne en éternium tressé",
		["Bright Blood Garnet"] = "Grenat sanguin éclatant",
		["Bright Crimson Spinel"] = "Spinelle cramoisi éclatant",
		["Bright Living Ruby"] = "Rubis vivant éclatant",
		["Brilliant Dawnstone"] = "Pierre d'aube brillante",
		["Brilliant Golden Draenite"] = "Draénite dorée brillante",
		["Brilliant Lionseye"] = "Oeil de lion brillant",
		["Brilliant Necklace"] = "Collier brillant",
		["Brilliant Pearl Band"] = "Bague en perles brillantes",
		["Bronze Band of Force"] = "Bague de force en bronze",
		["Bronze Setting"] = "Monture en bronze",
		["Bronze Torc"] = "Torque en bronze",
		["Brutal Earthstorm Diamond"] = "Diamant tonneterre de brutalité",
		["Chain of the Twilight Owl"] = "Chaîne de la chouette du crépuscule",
		["Chaotic Skyfire Diamond"] = "Diamant brûleciel chaotique",
		["Circlet of Arcane Might"] = "Diadème de puissance des arcanes",
		["Citrine Pendant of Golden Healing"] = "Pendentif de citrine de soin doré",
		["Citrine Ring of Rapid Healing"] = "Anneau de citrine de soin accéléré",
		["Coarse Stone Statue"] = "Statue en pierre grossière",
		["Coronet of the Verdant Flame"] = "Cerclet de la flamme verdoyante",
		["Crimson Sun"] = "Soleil cramoisi",
		["Crown of the Sea Witch"] = "Couronne de la sorcière des mers",
		["Dazzling Deep Peridot"] = "Olivine éblouissante",
		["Dazzling Seaspray Emerald"] = "Emeraude d'écume éblouissante",
		["Dazzling Talasite"] = "Talasite éblouissante",
		["Delicate Blood Garnet"] = "Grenat sanguin délicat",
		["Delicate Copper Wire"] = "Fil de cuivre délicat",
		["Delicate Eternium Ring"] = "Anneau délicat en éternium",
		["Delicate Crimson Spinel"] = "Spinelle cramoisi délicat",
		["Delicate Living Ruby"] = "Rubis vivant délicat",
		["Dense Stone Statue"] = "Statue en pierre dense",
		["Destructive Skyfire Diamond"] = "Diamant brûleciel de destruction",
		["Diamond Focus Ring"] = "Bague à diamant de focalisation",
		["Don Julio's Heart"] = "Coeur de Don Julio",
		["Elegant Silver Ring"] = "Anneau d'argent élégant",
   		["Ember Skyfire Diamond"] = "Diamant brûleciel brasillé",
		["Embrace of the Dawn"] = "Etreinte de l'aube",
		["Emerald Crown of Destruction"] = "Couronne d'émeraude de destruction",
		["Emerald Lion Ring"] = "Anneau d'émeraude du lion",
		["Enduring Deep Peridot"] = "Olivine durcie",
		["Enduring Seaspray Emerald"] = "Emeraude d'écume durcie",
		["Enduring Talasite"] = "Talasite durcie",
		["Engraved Truesilver Ring"] = "Anneau ciselé en vrai-argent",
		["Enigmatic Skyfire Diamond"] = "Diamant brûleciel de mystère",
		["Eternal Earthstorm Diamond"] = "Diamant tonneterre éternel",
		["Eye of the Night"] = "Oeil de la nuit",
		["Facet of Eternity"] = "Facette d'éternité",
		["Falling Star"] = "Etoile filante",
		["Fel Iron Blood Ring"] = "Anneau de sang en gangrefer",
		["Figurine - Black Diamond Crab"] = "Figurine - Crabe de diamant noir",
		["Figurine - Black Pearl Panther"] = "Figurine - Panthère de perle noire",
		["Figurine - Dark Iron Scorpid"] = "Figurine - Scorpide en sombrefer",
		["Figurine - Dawnstone Crab"] = "Figurine - Crabe de pierre d'aube",
		["Figurine - Emerald Owl"] = "Figurine - Chouette d'émeraude",
		["Figurine - Felsteel Boar"] = "Figurine - Sanglier en gangracier",
		["Figurine - Golden Hare"] = "Figurine - Lièvre doré",
		["Figurine - Jade Owl"] = "Figurine - Chouette de jade",
		["Figurine - Living Ruby Serpent"] = "Figurine - Serpent de rubis vivant",
		["Figurine - Nightseye Panther"] = "Figurine - Panthère d'oeil de nuit",
		["Figurine - Ruby Serpent"] = "Figurine - Serpent de rubis",
		["Figurine - Talasite Owl"] = "Figurine - Chouette de talasite",
		["Figurine - Truesilver Boar"] = "Figurine - Sanglier en vrai-argent",
		["Figurine - Truesilver Crab"] = "Figurine - Crabe en vrai-argent",
		["Flashing Crimson Spinel"] = "Spinelle cramoisi miroitant ",
		["Flashing Living Ruby"] = "Rubis vivant miroitant",
		["Gem Studded Band"] = "Bague émaillée de gemmes",
		["Gleaming Dawnstone"] = "Pierre d'aube resplendissante",
		["Gleaming Golden Draenite"] = "Draénite dorée resplendissante",
		["Gleaming Lionseye"] = "Oeil de lion resplendissant",
		["Glinting Flame Spessarite"] = "Spessarite de flamme luisante",
		["Glinting Noble Topaz"] = "Topaze noble luisante",
		["Glinting Pyrestone"] = "Pyrolithe luisante",
		["Gloom Band"] = "Bague d'obscurité",
		["Glowing Nightseye"] = "Oeil de nuit luminescent",
		["Glowing Shadow Draenite"] = "Draénite ombreuse luminescente",
		["Glowing Shadowsong Amethyst"] = "Améthyste chantelombre luminescente",
		["Glowing Thorium Band"] = "Bague luminescente en thorium",
		["Golden Draenite Ring"] = "Anneau de draénite dorée",
		["Golden Dragon Ring"] = "Anneau doré du dragon",
		["Golden Ring of Power"] = "Anneau doré de puissance",
		["Great Dawnstone"] = "Grande pierre d'aube",
		["Great Golden Draenite"] = "Grande draénite dorée",
		["Great Lionseye"] = "Grand oeil de lion",
		["Hard Khorium Band"] = "Bague en khorium durci",
		["Hard Khorium Choker"] = "Sautoir de khorium durci",
		["Heavy Adamantite Ring"] = "Anneau épais en adamantite",
		["Heavy Copper Ring"] = "Anneau épais en cuivre",
		["Heavy Felsteel Ring"] = "Anneau épais en gangracier",
		["Heavy Golden Necklace of Battle"] = "Collier de bataille épais doré",
		["Heavy Iron Knuckles"] = "Coup de poing lourd en fer",
		["Heavy Jade Ring"] = "Bague de jade lourde",
		["Heavy Silver Ring"] = "Anneau épais d'argent",
		["Heavy Stone Statue"] = "Statue en pierre lourde",
		["Infused Nightseye"] = "Oeil de nuit infusé",
		["Infused Shadow Draenite"] = "Draénite ombreuse infusée",
		["Infused Shadowsong Amethyst"] = "Améthyste chantelombre infusée",
		["Inlaid Malachite Ring"] = "Anneau de malachite damasquiné",
		["Inscribed Flame Spessarite"] = "Spessarite de flamme intaillée",
		["Inscribed Noble Topaz"] = "Topaze noble intaillée",
		["Inscribed Pyrestone"] = "Pyrolithe intaillée",
		["Insightful Earthstorm Diamond"] = "Diamant tonneterre de perspicacité",
		["Jade Pendant of Blasting"] = "Pendentif de jade d'explosion",
		["Jagged Deep Peridot"] = "Olivine dentelée",
		["Jagged Seaspray Emerald"] = "Emeraude d'écume dentelée",
		["Jagged Talasite"] = "Talasite dentelée",
		["Kailee's Rose"] = "Rose de Kailee",
		["Khorium Band of Frost"] = "Bague de givre en khorium",
		["Khorium Band of Leaves"] = "Bague des feuilles en khorium",
		["Khorium Band of Shadows"] = "Bague des ombres en khorium",
		["Khorium Inferno Band"] = "Bague d'Inferno en khorium",
		["Living Emerald Pendant"] = "Pendentif d'émeraude vivante",
		["Living Ruby Pendant"] = "Pendentif de rubis vivant",
		["Loop of Forged Power"] = "Boucle de puissance forgée",
		["Luminous Flame Spessarite"] = "Spessarite de flamme lumineuse",
		["Luminous Noble Topaz"] = "Topaze noble lumineuse",
		["Luminous Pyrestone"] = "Pyrolithe lumineuse",
		["Lustrous Azure Moonstone"] = "Pierre de lune azur satinée",
		["Lustrous Empyrean Sapphire"] = "Saphir empyréen satiné",
		["Lustrous Star of Elune"] = "Etoile d'Elune satinée",
		["Malachite Pendant"] = "Pendentif de malachite",
		["Mercurial Adamantite"] = "Adamantite mercurienne",
		["Mithril Filigree"] = "Filigrane en mithril",
		["Moonsoul Crown"] = "Couronne d'âmelune",
		["Mystic Dawnstone"] = "Pierre d'aube mystique",
		["Mystic Lionseye"] = "Oeil de lion mystique",
		["Mystical Skyfire Diamond"] = "Diamant brûleciel de mysticisme",
		["Necklace of the Deep"] = "Collier des profondeurs",
		["Necklace of the Diamond Tower"] = "Collier de la tour de diamant",
		["Onslaught Ring"] = "Anneau d'assaut",
		["Opal Necklace of Impact"] = "Collier d'opale d'impact",
		["Ornate Tigerseye Necklace"] = "Collier d'oeil de tigre orné",
		["Pendant of Frozen Flame"] = "Pendentif de la flamme gelée",
		["Pendant of Shadow's End"] = "Pendentif de la fin des ombres",
		["Pendant of Sunfire"] = "Pendentif du feu solaire",
		["Pendant of Thawing"] = "Pendentif du dégel",
		["Pendant of the Agate Shield"] = "Pendentif du bouclier d'agate",
		["Pendant of the Null Rune"] = "Pendentif de la rune abolie",
		["Pendant of Withering"] = "Pendentif de flétrissure",
		["Potent Flame Spessarite"] = "Spessarite de flamme toute-puissante",
		["Potent Noble Topaz"] = "Topaze noble toute-puissante",
		["Potent Pyrestone"] = "Pyrolithe toute-puissante",
		["Powerful Earthstorm Diamond"] = "Diamant tonneterre de puissance",
		["Purified Jaggal Pearl"] = "Perle jaggale purifiée",
		["Purified Shadow Pearl"] = "Perle d'ombre purifiée",
		["Radiant Deep Peridot"] = "Olivine radieuse",
		["Radiant Seaspray Emerald"] = "Emeraude d'écume radieuse",
		["Radiant Talasite"] = "Talasite radieuse",
		["Red Ring of Destruction"] = "Bague de destruction rouge",
		["Relentless Earthstorm Diamond"] = "Diamant tonneterre implacable",
		["Rigid Dawnstone"] = "Pierre d'aube rigide",
		["Rigid Golden Draenite"] = "Draénite dorée rigide",
		["Rigid Lionseye"] = "Oeil de lion rigide",
		["Ring of Arcane Shielding"] = "Anneau de protection contre les arcanes",
		["Ring of Bitter Shadows"] = "Anneau des ombres amères",
		["Ring of Flowing Life"] = "Anneau de vague de vie",
		["Ring of Silver Might"] = "Anneau du pouvoir argenté",
		["Ring of Twilight Shadows"] = "Anneau des ombres crépusculaires",
		["Rough Stone Statue"] = "Statue en pierre brute",
		["Royal Nightseye"] = "Oeil de nuit royal",
		["Royal Shadow Draenite"] = "Draénite ombreuse royale",
		["Royal Shadowsong Amethyst"] = "Améthyste chantelombre royale",
		["Ruby Crown of Restoration"] = "Couronne de rubis de restauration",
		["Ruby Pendant of Fire"] = "Pendentif de rubis de feu",
		["Runed Blood Garnet"] = "Grenat sanguin runique",
		["Runed Crimson Spinel"] = "Spinelle cramoisi runique",
		["Runed Living Ruby"] = "Rubis vivant runique",
		["Sapphire Pendant of Winter Night"] = "Pendentif de saphir de la nuit d'hiver",
		["Sapphire Signet"] = "Chevalière de saphir",
		["Shifting Nightseye"] = "Oeil de nuit changeant",
		["Shifting Shadow Draenite"] = "Draénite ombreuse changeante",
		["Shifting Shadowsong Amethyst"] = "Améthyste chantelombre changeante",
		["Simple Opal Ring"] = "Anneau d'opale simple",
		["Simple Pearl Ring"] = "Anneau de perle simple",
		["Smooth Dawnstone"] = "Pierre d'aube lisse",
		["Smooth Golden Draenite"] = "Draénite dorée lisse",
		["Smooth Lionseye"] = "Oeil de lion lisse",
		["Solid Azure Moonstone"] = "Pierre de lune azur solide",
		["Solid Bronze Ring"] = "Anneau solide en bronze",
		["Solid Empyrean Sapphire"] = "Saphir empyréen solide",
		["Solid Star of Elune"] = "Etoile d'Elune solide",
		["Solid Stone Statue"] = "Statue en pierre solide",
		["Sovereign Nightseye"] = "Oeil de nuit souverain",
		["Sovereign Shadow Draenite"] = "Draénite ombreuse souveraine",
		["Sovereign Shadowsong Amethyst"] = "Améthyste chantelombre souveraine",
		["Sparkling Azure Moonstone"] = "Pierre de lune azur étincelante",
		["Sparkling Empyrean Sapphire"] = "Saphir empyréen étincelant",
		["Sparkling Star of Elune"] = "Etoile d'Elune étincelante",
		["Steady Talasite"] = "Talasite stable",
		["Stone of Blades"] = "Pierre des lames",
		["Stormy Azure Moonstone"] = "Pierre de lune azur orageuse",
		["Stormy Empyrean Sapphire"] = "Saphir empyréen orageux",
		["Stormy Star of Elune"] = "Etoile d'Elune orageuse",
		["Subtle Crimson Spinel"] = "Spinelle cramoisi subtil",
		["Subtle Living Ruby"] = "Rubis vivant subtil",
		["Swift Skyfire Diamond"] = "Diamant brûleciel de rapidité",
		["Teardrop Blood Garnet"] = "Larme de grenat sanguin",
		["Teardrop Crimson Spinel"] = "Larme de spinelle cramoisi",
		["Teardrop Living Ruby"] = "Larme de rubis vivant",
		["Tenacious Earthstorm Diamond"] = "Diamant tonneterre de ténacité",
		["The Aquamarine Ward"] = "La garde d'aigue-marine",
		["The Black Pearl"] = "La Perle noire",
		["The Frozen Eye"] = "L'oeil givré",
		["The Jade Eye"] = "L'oeil de jade",
		["The Natural Ward"] = "La garde naturelle",
		["Thick Adamantite Necklace"] = "Collier épais en adamantite",
		["Thick Bronze Necklace"] = "Collier épais en bronze",
		["Thick Dawnstone"] = "Pierre d'aube bombée",
		["Thick Felsteel Necklace"] = "Collier épais en gangracier",
		["Thick Golden Draenite"] = "Draénite dorée bombée",
		["Thick Lionseye"] = "Oeil de lion bombé",
		["Thorium Setting"] = "Monture en thorium",
		["Thundering Skyfire Diamond"] = "Diamant brûleciel foudroyant",
		["Tigerseye Band"] = "Bague d'oeil de tigre",
		["Truesilver Commander's Ring"] = "Anneau de commandant en vrai-argent",
		["Truesilver Healing Ring"] = "Anneau de soin en vrai-argent",
		["Veiled Flame Spessarite"] = "Spessarite de flamme voilée",
		["Veiled Noble Topaz"] = "Topaze noble voilée",
		["Veiled Pyrestone"] = "Pyrolithe voilée",
		["Wicked Flame Spessarite"] = "Spessarite de flamme pernicieuse",
		["Wicked Moonstone Ring"] = "Anneau de pierre de lune pernicieux",
		["Wicked Noble Topaz"] = "Topaze noble pernicieuse",
		["Wicked Pyrestone"] = "Pyrolithe pernicieuse",
		["Woven Copper Ring"] = "Anneau de fils de cuivre",
   		["Figurine - Empyrean Tortoise"] = "Figurine de tortue empyréenne",
   		["Figurine - Khorium Boar"] = "Figurine de sanglier en khorium",
   		["Figurine - Crimson Serpent"] = "Figurine de cobra cramoisi",
   		["Figurine - Shadowsong Panther"] = "Figurine de panthère de chantelombre",
   		["Figurine - Seaspray Albatross"] = "Figurine d'albatros en écume",
   		["Regal Nightseye"] = "Oeil de nuit régalien",
   		["Reckless Pyrestone"] = "Pyrolithe téméraire",
   		["Quick Lionseye"] = "Oeil de lion rapide",
   		["Steady Seaspray Emerald"] = "Emeraude d'écume stable",
   		["Forceful Seaspray Emerald"] = "Emeraude d'écume énergique",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "Renfort d'armure des Arcanes",
		["Bag of Many Hides"] = "Sac des nombreuses peaux",
		["Barbaric Belt"] = "Ceinture barbare",
		["Barbaric Bracers"] = "Brassards barbares",
		["Barbaric Gloves"] = "Gants barbares",
		["Barbaric Harness"] = "Harnais barbare",
		["Barbaric Leggings"] = "Jambières barbares",
		["Barbaric Shoulders"] = "Epaulières barbares",
		["Belt of Deep Shadow"] = "Ceinture des ombres profondes",
		["Belt of Natural Power"] = "Ceinture de puissance naturelle",
		["Belt of the Black Eagle"] = "Ceinture de l'aigle noir",
		["Big Voodoo Cloak"] = "Cape du grand vaudou",
		["Big Voodoo Mask"] = "Masque du grand vaudou",
		["Big Voodoo Pants"] = "Pantalon du grand vaudou",
		["Big Voodoo Robe"] = "Robe du grand vaudou",
		["Bindings of Lightning Reflexes"] = "Manchettes des réflexes éclairs ",
		["Black Dragonscale Boots"] = "Bottes en écailles de dragon noir",
		["Black Dragonscale Breastplate"] = "Cuirasse en écailles de dragon noir",
		["Black Dragonscale Leggings"] = "Jambières en écailles de dragon noir",
		["Black Dragonscale Shoulders"] = "Epaulières en écailles de dragon noir",
		["Black Whelp Cloak"] = "Cape de dragonnet noir",
		["Black Whelp Tunic"] = "Tunique de dragonnet noir",
		["Blackstorm Leggings"] = "Jambières de Noir-orage",
		["Blastguard Belt"] = "Ceinture de déminage",
		["Blastguard Boots"] = "Bottes de déminage",
		["Blastguard Pants"] = "Pantalon de déminage",
		["Blood Tiger Breastplate"] = "Cuirasse du tigre-sang",
		["Blood Tiger Shoulders"] = "Epaulières du tigre-sang",
		["Blue Dragonscale Breastplate"] = "Cuirasse en écailles de dragon bleu",
		["Blue Dragonscale Leggings"] = "Jambières en écailles de dragon bleu",
		["Blue Dragonscale Shoulders"] = "Epaulières en écailles de dragon bleu",
		["Boots of Natural Grace"] = "Bottes de grâce naturelle",
		["Boots of Shackled Souls"] = "Bottes des âmes entravées",
		["Boots of the Crimson Hawk"] = "Bottes du faucon écarlate",
		["Boots of Utter Darkness"] = "Bottes de l'obscurité totale",
		["Bracers of Renewed Life"] = "Brassards du regain de vie",
		["Bracers of Shackled Souls"] = "Brassards des âmes entravées",
		["Bramblewood Belt"] = "Ceinture de la ronceraie",
		["Bramblewood Boots"] = "Bottes de la ronceraie",
		["Bramblewood Helm"] = "Casque de la ronceraie",
		["Chimeric Boots"] = "Bottes chimériques",
		["Chimeric Gloves"] = "Gants chimériques",
		["Chimeric Leggings"] = "Jambières chimériques",
		["Chimeric Vest"] = "Gilet chimérique",
		["Chromatic Cloak"] = "Cape chromatique",
		["Chromatic Gauntlets"] = "Gantelets chromatiques",
		["Clefthide Leg Armor"] = "Armure de jambe en cuir-fourchu",
		["Cloak of Darkness"] = "Cape des ténèbres",
		["Cobrahide Leg Armor"] = "Armure de jambe en peau de cobra",
		["Cobrascale Gloves"] = "Gants en écailles de cobra",
		["Cobrascale Hood"] = "Capuche en écailles de cobra",
		["Comfortable Insoles"] = "Semelles confortables",
		["Comfortable Leather Hat"] = "Chapeau de cuir confortable",
		["Core Armor Kit"] = "Renfort d'armure du Magma",
		["Corehound Belt"] = "Ceinture du Magma",
		["Corehound Boots"] = "Bottes du Magma",
		["Cured Heavy Hide"] = "Peau lourde traitée",
		["Cured Light Hide"] = "Peau légère traitée",
		["Cured Medium Hide"] = "Peau moyenne traitée",
		["Cured Rugged Hide"] = "Peau robuste traitée",
		["Cured Thick Hide"] = "Peau épaisse traitée",
		["Dark Leather Belt"] = "Ceinture noire en cuir",
		["Dark Leather Boots"] = "Bottes noires en cuir",
		["Dark Leather Cloak"] = "Cape noire en cuir",
		["Dark Leather Gloves"] = "Gants noirs en cuir",
		["Dark Leather Pants"] = "Pantalon noir en cuir",
		["Dark Leather Shoulders"] = "Epaulières noires en cuir",
		["Dark Leather Tunic"] = "Tunique noire en cuir",
		["Dawn Treaders"] = "Demi-bottes de l'aube",
		["Deviate Scale Belt"] = "Ceinture en écailles de déviant",
		["Deviate Scale Cloak"] = "Cape en écailles de déviant",
		["Deviate Scale Gloves"] = "Gants en écailles de déviant",
		["Devilsaur Gauntlets"] = "Gantelets diablosaures",
		["Devilsaur Leggings"] = "Jambières diablosaures",
		["Dragonscale Breastplate"] = "Cuirasse en écailles de dragon",
		["Dragonscale Gauntlets"] = "Gantelets en écailles de dragon",
		["Dragonstrike Leggings"] = "Jambières de frappe de dragon",
		["Dreamscale Breastplate"] = "Cuirasse de rêvécaille",
		["Drums of Battle"] = "Tambours de bataille",
		["Drums of Panic"] = "Tambours de panique",
		["Drums of Restoration"] = "Tambours de restauration",
		["Drums of Speed"] = "Tambours de vitesse",
		["Drums of War"] = "Tambours de guerre",
		["Dusky Belt"] = "Ceinture mate",
		["Dusky Boots"] = "Bottes mates",
		["Dusky Bracers"] = "Brassards mats",
		["Dusky Leather Armor"] = "Armure en cuir mat",
		["Dusky Leather Leggings"] = "Jambières en cuir mat",
		["Earthen Leather Shoulders"] = "Epaulières terrestres en cuir",
		["Earthen Netherscale Boots"] = "Bottes terrestres en écailles du Néant",
		["Ebon Netherscale Belt"] = "Ceinture d'ébène en écailles du Néant",
		["Ebon Netherscale Bracers"] = "Brassards d'ébène en écailles du Néant",
		["Ebon Netherscale Breastplate"] = "Cuirasse d'ébène en écailles du Néant",
		["Embossed Leather Boots"] = "Bottes en cuir estampé",
		["Embossed Leather Cloak"] = "Cape en cuir estampé",
		["Embossed Leather Gloves"] = "Gants en cuir estampé",
		["Embossed Leather Pants"] = "Pantalon en cuir estampé",
		["Embossed Leather Vest"] = "Gilet en cuir estampé",
		["Enchanted Clefthoof Boots"] = "Bottes enchantées du sabot-fourchu",
		["Enchanted Clefthoof Gloves"] = "Gants enchantés du sabot-fourchu",
		["Enchanted Clefthoof Leggings"] = "Jambières enchantées du sabot-fourchu",
		["Enchanted Felscale Boots"] = "Bottes enchantées en gangrécailles",
		["Enchanted Felscale Gloves"] = "Gants enchantés en gangrécailles",
		["Enchanted Felscale Leggings"] = "Jambières enchantées en gangrécailles",
		["Feathered Breastplate"] = "Cuirasse ornée de plumes",
		["Fel Leather Boots"] = "Bottes en gangrecuir",
		["Fel Leather Gloves"] = "Gants en gangrecuir",
		["Fel Leather Leggings"] = "Jambières en gangrecuir",
		["Felscale Boots"] = "Bottes en gangrécailles",
		["Felscale Breastplate"] = "Cuirasse en gangrécailles",
		["Felscale Gloves"] = "Gants en gangrécailles",
		["Felscale Pants"] = "Pantalon en gangrécailles",
		["Felstalker Belt"] = "Ceinture de traqueur gangrené",
		["Felstalker Bracer"] = "Brassards de traqueur gangrené",
		["Felstalker Breastplate"] = "Cuirasse de traqueur gangrené",
		["Fine Leather Belt"] = "Ceinture élégante en cuir",
		["Fine Leather Boots"] = "Bottes élégantes en cuir",
		["Fine Leather Cloak"] = "Cape élégante en cuir",
		["Fine Leather Gloves"] = "Gants élégants en cuir",
		["Fine Leather Pants"] = "Pantalon élégant en cuir",
		["Fine Leather Tunic"] = "Tunique élégante en cuir",
		["Flame Armor Kit"] = "Renfort d'armure des Flammes",
		["Flamescale Belt"] = "Ceinture en flamécaille",
		["Flamescale Boots"] = "Bottes en flamécaille",
		["Flamescale Leggings"] = "Jambières en flamécaille",
		["Fletcher's Gloves"] = "Gants de fléchier",
		["Frost Armor Kit"] = "Renfort d'armure de Givre",
		["Frost Leather Cloak"] = "Cape de givre en cuir",
		["Frostsaber Boots"] = "Bottes de sabre-de-givre",
		["Frostsaber Gloves"] = "Gants de sabre-de-givre",
		["Frostsaber Leggings"] = "Jambières de sabre-de-givre",
		["Frostsaber Tunic"] = "Tunique de sabre-de-givre",
		["Gauntlets of the Sea"] = "Gantelets de la mer",
		["Gem-studded Leather Belt"] = "Ceinture en cuir clouté de gemmes",
		["Girdle of Insight"] = "Ceinturon de clairvoyance",
		["Glove Reinforcements"] = "Renforts de gants",
		["Gloves of the Greatfather"] = "Gants du Grandpère",
		["Gloves of the Living Touch"] = "Gants du Grandpère",
		["Golden Dragonstrike Breastplate"] = "Cuirasse dorée de frappe de dragon",
		["Golden Mantle of the Dawn"] = "Mantelet doré de l'Aube",
		["Greaves of Shackled Souls"] = "Grèves des âmes entravées",
		["Green Dragonscale Breastplate"] = "Cuirasse en écailles de dragon vert",
		["Green Dragonscale Gauntlets"] = "Gantelets en écailles de dragon vert",
		["Green Dragonscale Leggings"] = "Jambières en écailles de dragon vert",
		["Green Leather Armor"] = "Armure verte en cuir",
		["Green Leather Belt"] = "Ceinture verte en cuir",
		["Green Leather Bracers"] = "Brassards verts en cuir",
		["Green Whelp Armor"] = "Armure de dragonnet vert",
		["Green Whelp Bracers"] = "Brassards de dragonnet vert",
		["Guardian Armor"] = "Armure de gardien",
		["Guardian Belt"] = "Ceinture de gardien",
		["Guardian Cloak"] = "Cape de gardien",
		["Guardian Gloves"] = "Gants de gardien",
		["Guardian Leather Bracers"] = "Brassards de gardien en cuir",
		["Guardian Pants"] = "Pantalon de gardien",
		["Handstitched Leather Belt"] = "Ceinture en cuir cousu main",
		["Handstitched Leather Boots"] = "Bottes en cuir cousu main",
		["Handstitched Leather Bracers"] = "Brassards en cuir cousu main",
		["Handstitched Leather Cloak"] = "Cape en cuir cousu main",
		["Handstitched Leather Pants"] = "Pantalon en cuir cousu main",
		["Handstitched Leather Vest"] = "Gilet en cuir cousu main",
		["Heavy Armor Kit"] = "Renfort d'armure lourd",
		["Heavy Clefthoof Boots"] = "Bottes du sabot-fourchu épaisses",
		["Heavy Clefthoof Leggings"] = "Jambières du sabot-fourchu épaisses",
		["Heavy Clefthoof Vest"] = "Gilet du sabot-fourchu épais",
		["Heavy Earthen Gloves"] = "Gants terrestres lourds",
		["Heavy Knothide Armor Kit"] = "Renfort d'armure en cuir granuleux lourd",
		["Heavy Knothide Leather"] = "Cuir granuleux lourd",
		["Heavy Leather Ammo Pouch"] = "Giberne en cuir lourd",
		["Heavy Leather Ball"] = "Balle en cuir lourd",
		["Heavy Leather"] = "Cuir lourd",
		["Heavy Quiver"] = "Carquois lourd",
		["Heavy Scorpid Belt"] = "Ceinture en écailles de scorpide épaisses",
		["Heavy Scorpid Bracers"] = "Brassards en écailles de scorpide épaisses",
		["Heavy Scorpid Gauntlets"] = "Gantelets en écailles de scorpide épaisses",
		["Heavy Scorpid Helm"] = "Heaume en écailles de scorpide épaisses",
		["Heavy Scorpid Leggings"] = "Jambières en écailles de scorpide épaisses",
		["Heavy Scorpid Shoulders"] = "Epaulières en écailles de scorpide épaisses",
		["Heavy Scorpid Vest"] = "Broigne en écailles de scorpide épaisses",
		["Helm of Fire"] = "Casque de feu",
		["Herbalist's Gloves"] = "Gants d'herboriste",
		["Hide of the Wild"] = "Peau du Fauve",
		["Hillman's Belt"] = "Ceinture d'homme des collines",
		["Hillman's Cloak"] = "Cape d'homme des collines",
		["Hillman's Leather Gloves"] = "Gants d'homme des collines en cuir",
		["Hillman's Leather Vest"] = "Gilet d'homme des collines en cuir",
		["Hillman's Shoulders"] = "Epaulières d'homme des collines",
		["Hood of Primal Life"] = "Chaperon de vie primordiale",
		["Hurricane Boots"] = "Bottes de l'ouragan",
		["Icy Scale Bracers"] = "Brassards glacécaille",
		["Icy Scale Breastplate"] = "Cuirasse glacécaille",
		["Icy Scale Gauntlets"] = "Gantelets glacécaille",
		["Ironfeather Breastplate"] = "Cuirasse en plumacier",
		["Ironfeather Shoulders"] = "Epaulières en plumacier",
		["Knothide Ammo Pouch"] = "Giberne en cuir granuleux lourd",
		["Knothide Armor Kit"] = "Renfort d'armure granuleux",
		["Knothide Leather"] = "Cuir granuleux",
		["Knothide Quiver"] = "Carquois en cuir granuleux lourd",
		["Kodo Hide Bag"] = "Sac en peau de kodo",
		["Lava Belt"] = "Ceinture de lave",
		["Leatherworker's Satchel"] = "Sacoche d'artisan du cuir",
		["Light Armor Kit"] = "Renfort d'armure léger",
		["Light Leather Bracers"] = "Brassards en cuir léger",
		["Light Leather Pants"] = "Pantalon en cuir léger",
		["Light Leather Quiver"] = "Carquois en cuir léger",
		["Light Leather"] = "Cuir léger",
		["Living Breastplate"] = "Cuirasse vivante",
		["Living Crystal Breastplate"] = "Cuirasse vivante en cristal",
		["Living Dragonscale Helm"] = "Casque vivant en écailles de dragon",
		["Living Earth Bindings"] = "Manchettes de la terre vivante",
		["Living Earth Shoulders"] = "Epaulières de la terre vivante",
		["Living Leggings"] = "Jambières vivantes",
		["Living Shoulders"] = "Epaulières vivantes",
		["Magister's Armor Kit"] = "Renfort d'armure de magistère",
		["Medium Armor Kit"] = "Renfort d'armure moyen",
		["Medium Leather"] = "Cuir moyen",
		["Might of the Timbermaw"] = "Pouvoir des Grumegueules",
		["Molten Belt"] = "Ceinture de la fournaise",
		["Molten Helm"] = "Casque de la fournaise",
		["Mongoose Boots"] = "Bottes de la mangouste",
		["Monsoon Belt"] = "Ceinture de la mousson",
		["Moonglow Vest"] = "Gilet Lueur-de-lune",
		["Murloc Scale Belt"] = "Ceinture en écailles de murloc",
		["Murloc Scale Bracers"] = "Brassards en écailles de murloc",
		["Murloc Scale Breastplate"] = "Cuirasse en écailles de murloc",
		["Nature Armor Kit"] = "Renfort d'armure de la Nature",
		["Nethercleft Leg Armor"] = "Armure de jambe de faille du Néant",
		["Nethercobra Leg Armor"] = "Armure de jambe de cobra du Néant",
		["Netherdrake Gloves"] = "Gants de drake du Néant",
		["Netherdrake Helm"] = "Casque de drake du Néant",
		["Netherfury Belt"] = "Ceinture de la Furie du Néant",
		["Netherfury Boots"] = "Bottes de la Furie du Néant",
		["Netherfury Leggings"] = "Jambières de la Furie du Néant",
		["Netherscale Ammo Pouch"] = "Giberne en écailles du Néant",
		["Netherstrike Belt"] = "Ceinture Coup-de-Néant",
		["Netherstrike Bracers"] = "Brassards Coup-de-Néant",
		["Netherstrike Breastplate"] = "Cuirasse Coup-de-Néant",
		["Nightscape Boots"] = "Bottes de la nuit",
		["Nightscape Headband"] = "Bandeau de la nuit",
		["Nightscape Pants"] = "Pantalon de la nuit",
		["Nightscape Shoulders"] = "Epaulières de la nuit",
		["Nightscape Tunic"] = "Tunique de la nuit",
		["Nimble Leather Gloves"] = "Gants d'agilité en cuir",
		["Onyxia Scale Cloak"] = "Cape en écailles d'Onyxia",
		["Pilferer's Gloves"] = "Gants de chapardeur",
		["Polar Bracers"] = "Brassards polaires",
		["Polar Gloves"] = "Gants polaires",
		["Polar Tunic"] = "Tunique polaire",
		["Primal Batskin Bracers"] = "Brassards en peau de chauve-souris primordiale",
		["Primal Batskin Gloves"] = "Gants en peau de chauve-souris primordiale",
		["Primal Batskin Jerkin"] = "Pourpoint en peau de chauve-souris primordiale",
		["Primalstorm Breastplate"] = "Cuirasse de tempête primordiale",
		["Primalstrike Belt"] = "Ceinture de frappe primordiale",
		["Primalstrike Bracers"] = "Brassards de frappe primordiale",
		["Primalstrike Vest"] = "Gilet de frappe primordiale",
		["Quickdraw Quiver"] = "Carquois de tir rapide",
		["Quiver of a Thousand Feathers"] = "Carquois des mille plumes",
		["Raptor Hide Belt"] = "Ceinture en peau de raptor",
		["Raptor Hide Harness"] = "Harnais en peau de raptor",
		["Red Dragonscale Breastplate"] = "Cuirasse en écailles de dragon rouge",
		["Red Whelp Gloves"] = "Gants en cuir de dragonnet rouge",
		["Redeemed Soul Cinch"] = "Cordelière d'âme rachetée",
		["Redeemed Soul Legguards"] = "Garde-jambes d'âme rachetée",
		["Redeemed Soul Moccasins"] = "Mocassins d'âme rachetée",
		["Redeemed Soul Wristguards"] = "Garde-poignets d'âme rachetée",
		["Reinforced Mining Bag"] = "Sac de mineur renforcé",
		["Riding Crop"] = "Cravache d'équitation",
		["Rugged Armor Kit"] = "Renfort d'armure robuste",
		["Rugged Leather Pants"] = "Pantalon en cuir robuste",
		["Rugged Leather"] = "Cuir robuste",
		["Runic Leather Armor"] = "Armure runique en cuir",
		["Runic Leather Belt"] = "Ceinture runique en cuir",
		["Runic Leather Bracers"] = "Brassards runiques en cuir",
		["Runic Leather Gauntlets"] = "Gantelets runique en cuir",
		["Runic Leather Headband"] = "Bandeau runique en cuir",
		["Runic Leather Pants"] = "Pantalon runique en cuir",
		["Runic Leather Shoulders"] = "Epaulières runiques en cuir",
		["Sandstalker Bracers"] = "Brassards de traqueuse des sables",
		["Sandstalker Breastplate"] = "Cuirasse de traqueuse des sables",
		["Sandstalker Gauntlets"] = "Gantelets de traqueuse des sables",
		["Scaled Draenic Boots"] = "Bottes draeniques en écailles",
		["Scaled Draenic Gloves"] = "Gants draeniques en écailles",
		["Scaled Draenic Pants"] = "Pantalon draenique en écailles",
		["Scaled Draenic Vest"] = "Broigne draenique",
		["Shadow Armor Kit"] = "Renfort d'armure de l'Ombre",
		["Shadowprowler's Chestguard"] = "Corselet de rôdeur des ombres",
		["Shadowskin Gloves"] = "Gants en peau d'ombre",
		["Shifting Cloak"] = "Cape changeante",
		["Shoulderpads of Renewed Life"] = "Protège-épaules du regain de vie",
		["Shoulders of Lightning Reflexes"] = "Epaulières des réflexes éclairs",
		["Small Leather Ammo Pouch"] = "Petite giberne en cuir",
		["Spitfire Bracers"] = "Brassards de crache-feu",
		["Spitfire Breastplate"] = "Cuirasse de crache-feu",
		["Spitfire Gauntlets"] = "Gantelets de crache-feu",
		["Stormshroud Armor"] = "Armure tempétueuse",
		["Stormshroud Gloves"] = "Gants tempétueux",
		["Stormshroud Pants"] = "Pantalon tempétueux",
		["Stormshroud Shoulders"] = "Epaulières tempétueuses",
		["Stylin' Adventure Hat"] = "Chapeau d'aventurier stylé",
		["Stylin' Crimson Hat"] = "Chapeau cramoisi stylé",
		["Stylin' Jungle Hat"] = "Chapeau de jungle stylé",
		["Stylin' Purple Hat"] = "Chapeau violet stylé",
		["Swift Boots"] = "Bottes de rapidité",
		["Swift Flight Bracers"] = "Brassards de vol rapide",
		["Swiftstrike Bracers"] = "Brassards de frappe rapide",
		["Swiftstrike Shoulders"] = "Epaulières de frappe rapide",
		["Thick Armor Kit"] = "Renfort d'armure épais",
		["Thick Draenic Boots"] = "Bottes draeniques épaisses",
		["Thick Draenic Gloves"] = "Gants draeniques épais",
		["Thick Draenic Pants"] = "Pantalon draenique épais",
		["Thick Draenic Vest"] = "Gilet draenique épais",
		["Thick Leather Ammo Pouch"] = "Giberne en cuir épais",
		["Thick Leather"] = "Cuir épais",
		["Thick Murloc Armor"] = "Armure épaisse de murloc",
		["Thick Netherscale Breastplate"] = "Cuirasse épaisse en écailles du Néant",
		["Timbermaw Brawlers"] = "Batailleurs grumegueules",
		["Tough Scorpid Boots"] = "Bottes armées du scorpide",
		["Tough Scorpid Bracers"] = "Brassards armés du scorpide",
		["Tough Scorpid Breastplate"] = "Cuirasse armée du scorpide",
		["Tough Scorpid Gloves"] = "Gants armés du scorpide",
		["Tough Scorpid Helm"] = "Casque armé du scorpide",
		["Tough Scorpid Leggings"] = "Jambières armées du scorpide",
		["Tough Scorpid Shoulders"] = "Epaulières armées du scorpide",
		["Toughened Leather Armor"] = "Armure en cuir raffermi",
		["Toughened Leather Gloves"] = "Gants en cuir raffermi",
		["Turtle Scale Bracers"] = "Brassards en écailles de tortue",
		["Turtle Scale Breastplate"] = "Cuirasse en écailles de tortue",
		["Turtle Scale Gloves"] = "Gants en écailles de tortue",
		["Turtle Scale Helm"] = "Casque en écailles de tortue",
		["Turtle Scale Leggings"] = "Jambières en écailles de tortue",
		["Vindicator's Armor Kit"] = "Renfort d'armure de redresseur de torts",
		["Volcanic Breastplate"] = "Cuirasse volcanique",
		["Volcanic Leggings"] = "Jambières volcaniques",
		["Volcanic Shoulders"] = "Epaulières volcaniques",
		["Waistguard of Shackled Souls"] = "Sangle des âmes entravées",
		["Warbear Harness"] = "Harnais de l'ours de guerre",
		["Warbear Woolies"] = "Haut-de-chausses de l'ours de guerre",
		["White Leather Jerkin"] = "Pourpoint blanc en cuir",
		["Wicked Leather Armor"] = "Armure corrompue en cuir",
		["Wicked Leather Belt"] = "Ceinture corrompue en cuir",
		["Wicked Leather Bracers"] = "Brassards corrompus en cuir",
		["Wicked Leather Gauntlets"] = "Gantelets corrompus en cuir",
		["Wicked Leather Headband"] = "Bandeau corrompu en cuir",
		["Wicked Leather Pants"] = "Pantalon corrompu en cuir",
		["Wild Draenish Boots"] = "Bottes draeniques sauvages",
		["Wild Draenish Gloves"] = "Gants draeniques sauvages",
		["Wild Draenish Leggings"] = "Jambières draeniques sauvages",
		["Wild Draenish Vest"] = "Gilet draenique sauvage",
		["Wild Leather Boots"] = "Bottes en cuir fauve",
		["Wild Leather Cloak"] = "Cape en cuir fauve",
		["Wild Leather Helmet"] = "Casque en cuir fauve",
		["Wild Leather Leggings"] = "Jambières en cuir fauve",
		["Wild Leather Shoulders"] = "Epaulières en cuir fauve",
		["Wild Leather Vest"] = "Gilet en cuir fauve",
		["Wildfeather Leggings"] = "Jambières de plumes sauvages",
		["Windhawk Belt"] = "Ceinture Faucon-du-vent",
		["Windhawk Bracers"] = "Brassards Faucon-du-vent",
		["Windhawk Hauberk"] = "Haubert Faucon-du-vent",
		["Windscale Hood"] = "Capuche en écailles du vent",
		["Windslayer Wraps"] = "Protège-mains de tueur du vent",
		["Windstrike Gloves"] = "Gants du Frappevent",
		["Wolfshead Helm"] = "Casque tête-de-loup",
		["Leather Gauntlets of the Sun"] = "Gantelets du soleil en cuir",
		["Leather Chestguard of the Sun"] = "Corselet du soleil en cuir",
		["Fletcher's Gloves of the Phoenix"] = "Gants de fléchier du phénix",
		["Embrace of the Phoenix"] = "Etreinte du phénix",
		["Sun-Drenched Scale Gloves"] = "Gants en écailles gorgés de soleil",
		["Sun-Drenched Scale Chestguard"] = "Corselet en écailles gorgé de soleil",
		["Carapace of Sun and Shadow"] = "Carapace de soleil et d'ombre",
		["Gloves of Immortal Dusk"] = "Gants de crépuscule immortel",

-- Smelting Recipes
		["Earth Shatter"] = "Brise-terre",
		["Fire Sunder"] = "Scission du feu",
		["Smelt Adamantite"] = "Fonte de l'adamantite",
		["Smelt Bronze"] = "Fonte du bronze",
		["Smelt Copper"] = "Fonte du cuivre",
		["Smelt Dark Iron"] = "Fonte du sombrefer",
		["Smelt Elementium"] = "Fonte de l'élémentium",
		["Smelt Eternium"] = "Fonte de l'éternium",
		["Smelt Fel Iron"] = "Fonte de gangrefer",
		["Smelt Felsteel"] = "Fonte de gangracier",
		["Smelt Gold"] = "Fonte de l'or",
		["Smelt Hardened Adamantite"] = "Fonte de l'adamantite trempé",
		["Smelt Hardened Khorium"] = "Fonte du khorium durci",
		["Smelt Iron"] = "Fonte du fer",
		["Smelt Khorium"] = "Fonte du khorium",
		["Smelt Mithril"] = "Fonte du mithril",
		["Smelt Silver"] = "Fonte de l'argent",
		["Smelt Steel"] = "Fonte de l'acier",
		["Smelt Thorium"] = "Fonte du thorium",
		["Smelt Tin"] = "Fonte de l'étain",
		["Smelt Truesilver"] = "Fonte du vrai-argent",

-- Rogue Poison Recipes
		["Anesthetic Poison"] = "Poison anesthésiant",
		["Blinding Powder"] = "Poudre aveuglante",
		["Crippling Poison II"] = "Poison affaiblissant II",
		["Crippling Poison"] = "Poison affaiblissant",
		["Deadly Poison II"] = "Poison mortel II",
		["Deadly Poison III"] = "Poison mortel III",
		["Deadly Poison IV"] = "Poison mortel IV",
		["Deadly Poison V"] = "Poison mortel V",
		["Deadly Poison VI"] = "Poison mortel VI",
		["Deadly Poison VII"] = "Poison mortel VII",
		["Deadly Poison"] = "Poison mortel",
		["Instant Poison II"] = "Poison instantané II",
		["Instant Poison III"] = "Poison instantané III",
		["Instant Poison IV"] = "Poison instantané IV",
		["Instant Poison V"] = "Poison instantané V",
		["Instant Poison VI"] = "Poison instantané VI",
		["Instant Poison VII"] = "Poison instantané V",
		["Instant Poison"] = "Poison instantané",
		["Mind-numbing Poison II"] = "Poison de distraction mentale II",
		["Mind-numbing Poison III"] = "Poison de distraction mentale III",
		["Mind-numbing Poison"] = "Poison de distraction mentale",
		["Wound Poison II"] = "Poison douloureux II",
		["Wound Poison III"] = "Poison douloureux III",
		["Wound Poison IV"] = "Poison douloureux IV",
		["Wound Poison V"] = "Poison douloureux V",
		["Wound Poison"] = "Poison douloureux",

-- Tailoring Recipes
		["Admiral's Hat"] = "Bicorne d'amiral",
		["Arcanoweave Boots"] = "Bottes en tisse-arcane",
		["Arcanoweave Bracers"] = "Brassards en tisse-arcane",
		["Arcanoweave Robe"] = "Robe en tisse-arcane",
		["Argent Boots"] = "Bottes de l'Aube d'argent",
		["Argent Shoulders"] = "Epaulières de l'Aube d'argent",
		["Azure Shoulders"] = "Epaulières d'azur",
		["Azure Silk Belt"] = "Ceinture azur en soie",
		["Azure Silk Cloak"] = "Cape azur en soie",
		["Azure Silk Gloves"] = "Gants azur en soie",
		["Azure Silk Hood"] = "Chaperon azur en soie",
		["Azure Silk Pants"] = "Pantalon azur en soie",
		["Azure Silk Vest"] = "Gilet azur en soie",
		["Bag of Jewels"] = "Sac de joyaux",
		["Barbaric Linen Vest"] = "Gilet barbare en lin",
		["Battlecast Hood"] = "Chaperon d'escarmouche",
		["Battlecast Pants"] = "Pantalon d'escarmouche",
		["Belt of Blasting"] = "Ceinture d'explosion",
		["Belt of the Archmage"] = "Ceinture de l'archimage",
		["Belt of the Long Road"] = "Ceinture du long chemin",
		["Big Bag of Enchantment"] = "Grand sac d'enchantement",
		["Black Belt of Knowledge"] = "Ceinture noire de connaissance",
		["Black Mageweave Boots"] = "Bottes noires en tisse-mage",
		["Black Mageweave Gloves"] = "Gants noirs en tisse-mage",
		["Black Mageweave Headband"] = "Bandeau noir en tisse-mage",
		["Black Mageweave Leggings"] = "Jambières noires en tisse-mage",
		["Black Mageweave Robe"] = "Robe noire en tisse-mage",
		["Black Mageweave Shoulders"] = "Epaulières noires en tisse-mage",
		["Black Mageweave Vest"] = "Gilet noir en tisse-mage",
		["Black Silk Pack"] = "Sac noir en soie",
		["Black Swashbuckler's Shirt"] = "Chemise noire de bretteur",
		["Blackstrike Bracers"] = "Brassards de noire frappe",
		["Bloodvine Boots"] = "Bottes en vignesang",
		["Bloodvine Leggings"] = "Jambières en vignesang",
		["Bloodvine Vest"] = "Gilet en vignesang",
		["Blue Linen Robe"] = "Robe bleue en lin",
		["Blue Linen Shirt"] = "Chemise bleue en lin",
		["Blue Linen Vest"] = "Gilet bleu en lin",
		["Blue Overalls"] = "Salopette bleue",
		["Bolt of Imbued Netherweave"] = "Rouleau de tisse-néant imprégné",
		["Bolt of Linen Cloth"] = "Rouleau d'étoffe de lin",
		["Bolt of Mageweave"] = "Rouleau de tisse-mage",
		["Bolt of Netherweave"] = "Rouleau de tisse-néant",
		["Bolt of Runecloth"] = "Rouleau d'étoffe runique",
		["Bolt of Silk Cloth"] = "Rouleau d'étoffe de soie",
		["Bolt of Soulcloth"] = "Rouleau d'âmétoffe",
		["Bolt of Woolen Cloth"] = "Rouleau d'étoffe de laine",
		["Boots of Blasting"] = "Bottes d'explosion",
		["Boots of the Enchanter"] = "Bottes de l'enchanteur",
		["Boots of the Long Road"] = "Bottes du long chemin",
		["Bottomless Bag"] = "Sac sans fond",
		["Bracers of Havok"] = "Brassards de Sans-quartier",
		["Bracers of Nimble Thought"] = "Brassards de la pensée agile",
		["Bright Yellow Shirt"] = "Chemise jaune vif",
		["Brightcloth Cloak"] = "Cape en étoffe lumineuse",
		["Brightcloth Gloves"] = "Gants en étoffe lumineuse",
		["Brightcloth Pants"] = "Pantalon en étoffe lumineuse",
		["Brightcloth Robe"] = "Robe en étoffe lumineuse",
		["Brown Linen Pants"] = "Pantalon marron en lin",
		["Brown Linen Robe"] = "Robe marron en lin",
		["Brown Linen Shirt"] = "Chemise marron en lin",
		["Brown Linen Vest"] = "Gilet marron en lin",
		["Cenarion Herb Bag"] = "Sac d'herbes cénarien",
		["Cindercloth Boots"] = "Bottes en étoffe cendrée",
		["Cindercloth Cloak"] = "Cape en étoffe cendrée",
		["Cindercloth Gloves"] = "Gants en étoffe cendrée",
		["Cindercloth Pants"] = "Pantalon en étoffe cendrée",
		["Cindercloth Robe"] = "Robe en étoffe cendrée",
		["Cindercloth Vest"] = "Gilet en étoffe cendrée",
		["Cloak of Arcane Evasion"] = "Cape d'évasion arcanique",
		["Cloak of Eternity"] = "Cape d'éternité",
		["Cloak of Fire"] = "Cape de feu",
		["Cloak of the Black Void"] = "Cape du vide noir",
		["Cloak of Warding"] = "Cape de sauvegarde",
		["Colorful Kilt"] = "Kilt coloré",
		["Core Felcloth Bag"] = "Sac en gangrétoffe du Magma",
		["Crimson Silk Belt"] = "Ceinture cramoisie en soie",
		["Crimson Silk Cloak"] = "Cape cramoisie en soie",
		["Crimson Silk Gloves"] = "Gants cramoisis en soie",
		["Crimson Silk Pantaloons"] = "Culotte cramoisie en soie",
		["Crimson Silk Robe"] = "Robe cramoisie en soie",
		["Crimson Silk Shoulders"] = "Epaulières cramoisies en soie",
		["Crimson Silk Vest"] = "Gilet cramoisi en soie",
		["Dark Silk Shirt"] = "Chemise noire en soie",
		["Double-stitched Woolen Shoulders"] = "Epaulières à double couture en laine",
		["Dreamweave Circlet"] = "Diadème en tisse-rêve",
		["Dreamweave Gloves"] = "Gants en tisse-rêve",
		["Dreamweave Vest"] = "Gilet en tisse-rêve",
		["Earthen Silk Belt"] = "Ceinture terrestre en soie",
		["Earthen Vest"] = "Gilet terrestre",
		["Ebon Shadowbag"] = "Ombresac d'ébène",
		["Enchanted Mageweave Pouch"] = "Bourse enchantée en tisse-mage",
		["Enchanted Runecloth Bag"] = "Sac enchanté en étoffe runique",
		["Enchanter's Cowl"] = "Capuche d'enchanteur",
		["Felcloth Bag"] = "Sac en gangrétoffe",
		["Felcloth Boots"] = "Bottes en gangrétoffe",
		["Felcloth Gloves"] = "Gants en gangrétoffe",
		["Felcloth Hood"] = "Chaperon en gangrétoffe",
		["Felcloth Pants"] = "Pantalon en gangrétoffe",
		["Felcloth Robe"] = "Robe en gangrétoffe",
		["Felcloth Shoulders"] = "Epaulières en gangrétoffe",
		["Festival Dress"] = "Robe de fête",
		--["Festive Red Dress"] = "Robe de fête rouge", -- doesn't exist!
		["Festive Red Pant Suit"] = "Habit de fête rouge",
		["Flameheart Bracers"] = "Brassards coeur-de-flammes",
		["Flameheart Gloves"] = "Gants coeur-de-flammes",
		["Flameheart Vest"] = "Gilet coeur-de-flammes",
		["Flarecore Gloves"] = "Gants Coeur-de-braise",
		["Flarecore Leggings"] = "Jambières Coeur-de-braise",
		["Flarecore Mantle"] = "Mantelet Coeur-de-braise",
		["Flarecore Robe"] = "Robe Coeur-de-braise",
		["Flarecore Wraps"] = "Couvre-bras Coeur-de-braise",
		["Formal White Shirt"] = "Chemise blanche habillée",
		["Frostweave Gloves"] = "Gants tisse-givre",
		["Frostweave Pants"] = "Pantalon tisse-givre",
		["Frostweave Robe"] = "Robe tisse-givre",
		["Frostweave Tunic"] = "Tunique tisse-givre",
		["Frozen Shadoweave Boots"] = "Bottes en tisse-ombre gelé",
		["Frozen Shadoweave Shoulders"] = "Epaulières en tisse-ombre gelé",
		["Frozen Shadoweave Robe"] = "Robe en tisse-ombre gelé",
		["Gaea's Embrace"] = "Etreinte de Gaïa",
		["Ghostweave Belt"] = "Ceinture en tisse-fantôme",
		["Ghostweave Gloves"] = "Gants en tisse-fantôme",
		["Ghostweave Pants"] = "Pantalon en tisse-fantôme",
		["Ghostweave Vest"] = "Gilet en tisse-fantôme",
		["Girdle of Ruination"] = "Ceinturon de saccage",
		["Glacial Cloak"] = "Cape glaciaire",
		["Glacial Gloves"] = "Gants glaciaires",
		["Glacial Vest"] = "Gilet glaciaire",
		["Glacial Wrists"] = "Poignets glaciaires",
		["Gloves of Meditation"] = "Gants de méditation",
		["Gloves of Spell Mastery"] = "Gants de maîtrise magique",
		["Golden Spellthread"] = "Fil ensorcelé doré",
		["Gordok Ogre Suit"] = "Tenue d'ogre gordok",
		["Gray Woolen Robe"] = "Robe grise en laine",
		["Gray Woolen Shirt"] = "Chemise grise en laine",
		["Greater Adept's Robe"] = "Robe d'adepte supérieur",
		["Green Holiday Shirt"] = "Chemise verte de fête",
		["Green Linen Bracers"] = "Brassards verts en lin",
		["Green Linen Shirt"] = "Chemise verte en lin",
		["Green Silk Armor"] = "Armure verte en soie",
		["Green Silk Pack"] = "Sac vert en soie",
		["Green Silken Shoulders"] = "Epaulières vertes en soie",
		["Green Winter Clothes"] = "Vêtements d'hiver verts",
		["Green Woolen Bag"] = "Sac vert en laine",
		["Green Woolen Vest"] = "Gilet vert en laine",
		["Hands of Darkness"] = "Mains des ténèbres",
		["Handstitched Linen Britches"] = "Braies en lin cousu main",
		["Heavy Linen Gloves"] = "Gants en lin épais",
		--["Heavy Netherweave Net"] = "Filet épais en tisse-néant",
		["Heavy Woolen Cloak"] = "Cape en laine épaisse",
		["Heavy Woolen Gloves"] = "Gants en laine épaisse",
		["Heavy Woolen Pants"] = "Pantalon en laine épaisse",
		["Icy Cloak"] = "Cape glaciale",
		["Imbued Netherweave Bag"] = "Sac en tisse-néant imprégné",
		["Imbued Netherweave Boots"] = "Bottes en tisse-néant imprégné",
		["Imbued Netherweave Pants"] = "Pantalon en tisse-néant imprégné",
		["Imbued Netherweave Robe"] = "Robe en tisse-néant imprégné",
		["Imbued Netherweave Tunic"] = "Tunique en tisse-néant imprégné",
		["Inferno Gloves"] = "Gants d'Inferno",
		["Lavender Mageweave Shirt"] = "Chemise lavande en tisse-mage",
		["Lesser Wizard's Robe"] = "Robe de sorcier inférieur",
		["Linen Bag"] = "Sac en lin",
		["Linen Belt"] = "Ceinture en lin",
		["Linen Boots"] = "Bottes en lin",
		["Linen Cloak"] = "Cape en lin",
		["Long Silken Cloak"] = "Longue cape en soie",
		["Mageweave Bag"] = "Sac en tisse-mage",
		["Manaweave Cloak"] = "Cape en tisse-mana",
		["Mantle of Nimble Thought"] = "Mantelet de la pensée agile",
		["Mantle of the Timbermaw"] = "Mantelet des Grumegueules",
		["Mooncloth Bag"] = "Sac en étoffe lunaire",
		["Mooncloth Boots"] = "Bottes en étoffe lunaire",
		["Mooncloth Circlet"] = "Diadème en étoffe lunaire",
		["Mooncloth Gloves"] = "Gants en étoffe lunaire",
		["Mooncloth Leggings"] = "Jambières en étoffe lunaire",
		["Mooncloth Robe"] = "Robe en étoffe lunaire",
		["Mooncloth Shoulders"] = "Epaulières en étoffe lunaire",
		["Mooncloth Vest"] = "Gilet en étoffe lunaire",
		["Mooncloth"] = "Etoffe lunaire",
		["Mystic Spellthread"] = "Fil ensorcelé mystique",
		["Netherweave Bag"] = "Sac en tisse-néant",
		["Netherweave Belt"] = "Ceinture en tisse-néant",
		["Netherweave Boots"] = "Bottes en tisse-néant",
		["Netherweave Bracers"] = "Brassards en tisse-néant",
		["Netherweave Gloves"] = "Gants en tisse-néant",
		["Netherweave Net"] = "Filet en tisse-néant",
		["Netherweave Pants"] = "Pantalon en tisse-néant",
		["Netherweave Robe"] = "Robe en tisse-néant",
		["Netherweave Tunic"] = "Tunique en tisse-néant",
		["Night's End"] = "Au bout de la nuit",
		["Orange Mageweave Shirt"] = "Chemise orange en tisse-mage",
		["Orange Martial Shirt"] = "Chemise orange martiale",
		["Pearl-clasped Cloak"] = "Cape brodée de perles",
		["Phoenix Gloves"] = "Gants du phénix",
		["Phoenix Pants"] = "Pantalon du phénix",
		["Pink Mageweave Shirt"] = "Chemise rose en tisse-mage",
		["Primal Mooncloth Bag"] = "Sac d'étoffe lunaire primordiale",
		["Primal Mooncloth Belt"] = "Ceinture d'étoffe lunaire primordiale",
		["Primal Mooncloth Robe"] = "Robe d'étoffe lunaire primordiale",
		["Primal Mooncloth Shoulders"] = "Epaulières d'étoffe lunaire primordiale",
		["Primal Mooncloth"] = "Etoffe lunaire primordiale",
		["Red Linen Bag"] = "Sac rouge en lin",
		["Red Linen Robe"] = "Robe rouge en lin",
		["Red Linen Shirt"] = "Chemise rouge en lin",
		["Red Linen Vest"] = "Gilet rouge en lin",
		["Red Mageweave Bag"] = "Sac rouge en tisse-mage",
		["Red Mageweave Gloves"] = "Gants rouges en tisse-mage",
		["Red Mageweave Headband"] = "Bandeau rouge en tisse-mage",
		["Red Mageweave Pants"] = "Pantalon rouge en tisse-mage",
		["Red Mageweave Shoulders"] = "Epaulières rouges en tisse-mage",
		["Red Mageweave Vest"] = "Gilet rouge en tisse-mage",
		["Red Swashbuckler's Shirt"] = "Chemise rouge de bretteur",
		["Red Woolen Bag"] = "Sac rouge en laine",
		["Red Woolen Boots"] = "Bottes rouges en laine",
		["Reinforced Linen Cape"] = "Cape en lin renforcé",
		["Red Winter Clothes"] = "Vêtements d'hiver rouges",
		["Reinforced Woolen Shoulders"] = "Epaulières renforcées en laine",
		["Resolute Cape"] = "Cape résolue",
		["Rich Purple Silk Shirt"] = "Riche chemise violette en soie",
		["Robe of Power"] = "Robe de puissance",
		["Robe of the Archmage"] = "Robe de l'archimage",
		["Robe of the Void"] = "Robe du Vide",
		["Robe of Winter Night"] = "Robe de la nuit hivernale",
		["Robes of Arcana"] = "Robe d'Arcana",
		["Runecloth Bag"] = "Sac en étoffe runique",
		["Runecloth Belt"] = "Ceinture en étoffe runique",
		["Runecloth Boots"] = "Bottes en étoffe runique",
		["Runecloth Cloak"] = "Cape en étoffe runique",
		["Runecloth Gloves"] = "Gants en étoffe runique",
		["Runecloth Headband"] = "Bandeau en étoffe runique",
		["Runecloth Pants"] = "Pantalon en étoffe runique",
		["Runecloth Robe"] = "Robe en étoffe runique",
		["Runecloth Shoulders"] = "Epaulières en étoffe runique",
		["Runecloth Tunic"] = "Tunique en étoffe runique",
		["Runed Stygian Belt"] = "Ceinture runique ténébreuse",
		["Runed Stygian Boots"] = "Bottes runiques ténébreuses",
		["Runed Stygian Leggings"] = "Jambières runiques ténébreuses",
		["Runic Spellthread"] = "Fil ensorcelé runique",
		["Satchel of Cenarius"] = "Sacoche de Cénarius",
		["Shadow Hood"] = "Chaperon des ombres",
		["Shadowcloth"] = "Etoffe d'ombre",
		["Shadoweave Boots"] = "Bottes en tisse-ombre",
		["Shadoweave Gloves"] = "Gants en tisse-ombre",
		["Shadoweave Mask"] = "Masque en tisse-ombre",
		["Shadoweave Pants"] = "Pantalon en tisse-ombre",
		["Shadoweave Robe"] = "Robe en tisse-ombre",
		["Shadoweave Shoulders"] = "Epaulières en tisse-ombre",
		["Silk Headband"] = "Bandeau en soie",
		["Silver Spellthread"] = "Fil ensorcelé argenté",
		["Simple Black Dress"] = "Robe noire simple",
		["Simple Dress"] = "Jupe simple",
		["Simple Kilt"] = "Kilt simple",
		["Simple Linen Boots"] = "Bottes en lin écru",
		["Simple Linen Pants"] = "Pantalon en lin écru",
		["Small Silk Pack"] = "Petit sac en soie",
		["Soft-soled Linen Boots"] = "Bottes en lin à semelle souple",
		["Soul Pouch"] = "Bourse d'âme",
		["Soulcloth Gloves"] = "Gants d'âmétoffe",
		["Soulcloth Shoulders"] = "Epaulières d'âmétoffe",
		["Soulcloth Vest"] = "Gilet d'âmétoffe",
		["Soulguard Bracers"] = "Poignets garde-âme",
		["Soulguard Girdle"] = "Cilice garde-âme",
		["Soulguard Leggings"] = "Jambières garde-âme",
		["Soulguard Slippers"] = "Mules garde-âme",
		["Spellcloth"] = "Etoffe ensorcelée",
		["Spellfire Bag"] = "Sac du feu-sorcier",
		["Spellfire Belt"] = "Ceinture du feu-sorcier",
		["Spellfire Gloves"] = "Gants du feu-sorcier",
		["Spellfire Robe"] = "Robe du feu-sorcier",
		["Spellstrike Hood"] = "Chaperon frappe-sort",
		["Spellstrike Pants"] = "Pantalon frappe-sort",
		["Spider Belt"] = "Ceinture de l'araignée",
		["Spider Silk Slippers"] = "Mules en soie d'araignée",
		["Spidersilk Boots"] = "Bottes en soie d'araignée",
		["Star Belt"] = "Ceinture de l'étoile",
		["Stylish Blue Shirt"] = "Chemise bleue d'apparat",
		["Stylish Green Shirt"] = "Chemise verte d'apparat",
		["Stylish Red Shirt"] = "Chemise rouge d'apparat",
		["Swiftheal Mantle"] = "Mantelet des soins vifs",
		["Swiftheal Wraps"] = "Couvre-bras des soins vifs",
		["Sylvan Crown"] = "Couronne sylvestre",
		["Sylvan Shoulders"] = "Epaulières sylvestres",
		["Sylvan Vest"] = "Gilet sylvestre",
		["Truefaith Gloves"] = "Gants de vraie foi",
		["Truefaith Vestments"] = "Habit de vraie foi",
		["Tuxedo Jacket"] = "Veste de smoking",
		["Tuxedo Pants"] = "Pantalon de smoking",
		["Tuxedo Shirt"] = "Chemise de smoking",
		["Unyielding Bracers"] = "Brassards inflexibles",
		["Unyielding Girdle"] = "Ceinturon inflexible",
		["Vengeance Wrap"] = "Houppelande vengeresse",
		["White Bandit Mask"] = "Masque blanc de bandit",
		["White Linen Robe"] = "Robe blanche en lin",
		["White Linen Shirt"] = "Chemise blanche en lin",
		["White Remedy Cape"] = "Cape du remède blanc",
		["White Swashbuckler's Shirt"] = "Chemise blanche de bretteur",
		["White Wedding Dress"] = "Robe blanche de mariée",
		["White Woolen Dress"] = "Robe blanche en laine",
		["Whitemend Hood"] = "Chaperon de la blanche guérison",
		["Whitemend Pants"] = "Pantalon de la blanche guérison",
		["Winter Boots"] = "Bottes d'hiver",
		["Wisdom of the Timbermaw"] = "Sagesse des Grumegueules",
		["Wizardweave Leggings"] = "Jambières en tisse-sorcier",
		["Wizardweave Robe"] = "Robe en tisse-sorcier",
		["Wizardweave Turban"] = "Turban en tisse-sorcier",
		["Woolen Bag"] = "Sac en laine",
		["Woolen Boots"] = "Bottes en laine",
		["Woolen Cape"] = "Cape en laine",
		["Sunfire Robe"] = "Robe du feu solaire",
		["Sunfire Handwraps"] = "Protège-mains du feu solaire",
		["Robe of Eternal Light"] = "Robe de la lumière éternelle",
		["Hands of Eternal Light"] = "Mains de lumière éternelle",
	}
end)

BabbleTradeskill:RegisterTranslations("zhCN", function()
	return {
--Gathering skills 综合
		["Disenchant"] = "附魔分解",
		["Fishing"] = "钓鱼",
		["Herbalism"] = "采药",
		["Mining"] = "采矿",
		["Pick Pocket"] = "搜索",
		["Prospecting"] = "选矿",
		["Skinning"] = "剥皮",
		["Smelting"] = "熔炼",
		["Riding"] = "骑乘",

--Crafting skills 详细专业技能分类
		["Alchemy"] = "炼金术",
		["Armorsmith"] = "护甲锻造师",
		["Blacksmithing"] = "锻造",
		["Cooking"] = "烹饪",
		["Dragonscale Leatherworking"] = "龙鳞制皮",
		["Elemental Leatherworking"] = "元素制皮",
		["Elixir Master"] = "药剂大师",
		["Enchanting"] = "附魔",
		["Engineering"] = "工程学",
		["First Aid"] = "急救",
		["Gnomish Engineering"] = "侏儒工程师",
		["Goblin Engineering"] = "地精工程师",
		["Gnomish Engineer"] = "侏儒工程学",
		["Goblin Engineer"] = "地精工程师",
		["Jewelcrafting"] = "珠宝加工",	--TBC check
		["Leatherworking"] = "制皮",
		["Master Axesmith"] = "铸斧大师",
		["Master Hammersmith"] = "铸锤大师",
		["Master Swordsmith"] = "铸剑大师",
		["Mooncloth Tailoring"] = "月布裁缝", -- need fix
		["Poisons"] = "毒药",
		["Potion Master"] = "药水大师",
		["Shadoweave Tailoring"] = "暗纹裁缝", -- need fix
		["Spellfire Tailoring"] = "魔焰裁缝", -- need fix
		["Tailoring"] = "裁缝",
		["Transmutation Master"] = "转化大师",
		["Tribal Leatherworking"] = "部族制皮",
		["Weaponsmith"] = "武器锻造师",

-- Alchemy Recipes 炼金术
		["Adept's Elixir"] = "法能药剂",
		["Alchemist's Stone"] = "炼金石",
		["Arcane Elixir"] = "奥法药剂",
		["Blackmouth Oil"] = "黑口鱼油",
		["Catseye Elixir"] = "猫眼药剂",
		["Cauldron of Major Arcane Protection"] = "特效奥术防护药锅",
		["Cauldron of Major Fire Protection"] = "特效火焰防护药锅",
		["Cauldron of Major Frost Protection"] = "特效冰霜防护药锅",
		["Cauldron of Major Nature Protection"] = "特效自然防护药锅",
		["Cauldron of Major Shadow Protection"] = "特效暗影防护药锅",
		["Destruction Potion"] = "毁灭药水",
		["Discolored Healing Potion"] = "褪色的治疗药水",
		["Dreamless Sleep Potion"] = "昏睡药水",
		["Earthen Elixir"] = "土灵药剂",
		["Elixir of Agility"] = "敏捷药剂",
		["Elixir of Brute Force"] = "蛮力药剂",
		["Elixir of Camouflage"] = "伪装药剂",
		["Elixir of Defense"] = "防御药剂",
		["Elixir of Demonslaying"] = "屠魔药剂",
		["Elixir of Detect Demon"] = "侦测恶魔药剂",
		["Elixir of Detect Lesser Invisibility"] = "侦测次级隐形药剂",
		["Elixir of Detect Undead"] = "侦测亡灵药剂",
		["Elixir of Draenic Wisdom"] = "德莱尼智慧药剂",
		["Elixir of Dream Vision"] = "梦境药剂",
		["Elixir of Empowerment"] = "强化药剂",
		["Elixir of Firepower"] = "火力药剂",
		["Elixir of Fortitude"] = "坚韧药剂",
		["Elixir of Frost Power"] = "冰霜之力药剂",
		["Elixir of Giant Growth"] = "增长药剂",
		["Elixir of Giants"] = "巨人药剂",
		["Elixir of Greater Agility"] = "强效敏捷药剂",
		["Elixir of Greater Defense"] = "强效防御药剂",
		["Elixir of Greater Firepower"] = "强效火力药剂",
		["Elixir of Greater Intellect"] = "强效聪颖药剂",
		["Elixir of Greater Water Breathing"] = "强效水下呼吸药剂",
		["Elixir of Healing Power"] = "治疗能量药剂",
		["Elixir of Ironskin"] = "铁皮药剂",
		["Elixir of Lesser Agility"] = "次级敏捷药剂",
		["Elixir of Lion's Strength"] = "狮王之力药剂",
		["Elixir of Major Agility"] = "特效敏捷药剂",
		["Elixir of Major Defense"] = "特效防御药剂",
		["Elixir of Major Firepower"] = "特效火力药剂",
		["Elixir of Major Fortitude"] = "特效坚韧药剂",
		["Elixir of Major Frost Power"] = "特效冰霜能量药剂",
		["Elixir of Major Mageblood"] = "特效魔血药剂",
		["Elixir of Major Shadow Power"] = "特效暗影能量药剂",
		["Elixir of Major Strength"] = "特效力量药剂",
		["Elixir of Mastery"] = "掌控药剂",
		["Elixir of Minor Agility"] = "初级敏捷药剂",
		["Elixir of Minor Defense"] = "初级防御药剂",
		["Elixir of Minor Fortitude"] = "初级坚韧药剂",
		["Elixir of Ogre's Strength"] = "食人魔力量药剂",
		["Elixir of Shadow Power"] = "暗影之力药剂",
		["Elixir of Superior Defense"] = "超强防御药剂",
		["Elixir of the Mongoose"] = "猫鼬药剂",
		["Elixir of the Sages"] = "先知药剂",
		["Elixir of the Searching Eye"] = "搜寻之眼药剂",
		["Elixir of Water Breathing"] = "水下呼吸药剂",
		["Elixir of Wisdom"] = "智慧药剂",
		["Fel Mana Potion"] = "魔能法力药水",
		["Fel Regeneration Potion"] = "魔能回复药水",
		["Fel Strength Elixir"] = "魔能力量药剂",
		["Fire Oil"] = "火焰之油",
		["Fire Protection Potion"] = "火焰防护药水",
		["Flask of Blinding Light"] = "盲目光芒合剂",
		["Flask of Chromatic Resistance"] = "多重抗性合剂",
		["Flask of Chromatic Wonder"] = "多彩奇迹合剂",
		["Flask of Distilled Wisdom"] = "精炼智慧合剂",
		["Flask of Fortification"] = "强固合剂",
		["Flask of Mighty Restoration"] = "强效回复合剂",
		["Flask of Petrification"] = "化石合剂",
		["Flask of Pure Death"] = "纯粹死亡合剂",
		["Flask of Relentless Assault"] = "无情突袭合剂",
		["Flask of Supreme Power"] = "超级能量合剂",
		["Flask of the Titans"] = "泰坦合剂",
		["Free Action Potion"] = "自由行动药剂",
		["Frost Oil"] = "冰霜之油",
		["Frost Protection Potion"] = "冰霜防护药水",
		["Ghost Dye"] = "幻象染料",
		["Gift of Arthas"] = "阿尔萨斯的礼物",
		["Goblin Rocket Fuel"] = "地精火箭燃油",
		["Great Rage Potion"] = "暴怒药水",
		["Greater Arcane Elixir"] = "强效奥法药剂",
		["Greater Arcane Protection Potion"] = "强效奥术防护药水",
		["Greater Dreamless Sleep Potion"] = "强效昏睡药水",
		["Greater Fire Protection Potion"] = "强效火焰防护药水",
		["Greater Frost Protection Potion"] = "强效冰霜防护药水",
		["Greater Healing Potion"] = "强效治疗药水",
		["Greater Mana Potion"] = "强效法力药水",
		["Greater Nature Protection Potion"] = "强效自然防护药水",
		["Greater Shadow Protection Potion"] = "强效暗影防护药水",
		["Greater Stoneshield Potion"] = "强效石盾药水",
		["Gurubashi Mojo Madness"] = "古拉巴什魔精",
		["Haste Potion"] = "加速药水",
		["Healing Potion"] = "治疗药水",
		["Heroic Potion"] = "英雄药水",
		["Holy Protection Potion"] = "神圣防护药水",
		["Insane Strength Potion"] = "疯狂力量药水",
		["Invisibility Potion"] = "隐形药水",
		["Ironshield Potion"] = "铁盾药水",
		["Lesser Healing Potion"] = "次级治疗药水",
		["Lesser Invisibility Potion"] = "次级隐形药水",
		["Lesser Mana Potion"] = "次级法力药水",
		["Lesser Stoneshield Potion"] = "次级石盾药水",
		["Limited Invulnerability Potion"] = "有限无敌药水",
		["Living Action Potion"] = "活力行动药水",
		["Mad Alchemist's Potion"] = "疯狂炼金师药水",
		["Mageblood Potion"] = "魔血药水",
		["Magic Resistance Potion"] = "抗魔药水",
		["Major Arcane Protection Potion"] = "特效奥术防护药水",
		["Major Dreamless Sleep Potion"] = "特效无梦睡眠药水",
		["Major Fire Protection Potion"] = "特效火焰防护药水",
		["Major Frost Protection Potion"] = "特效冰霜防护药水",
		["Major Healing Potion"] = "特效治疗药水",
		["Major Holy Protection Potion"] = "特效神圣防护药水",
		["Major Mana Potion"] = "特效法力药水",
		["Major Nature Protection Potion"] = "特效自然防护药水",
		["Major Rejuvenation Potion"] = "特效活力药水",
		["Major Shadow Protection Potion"] = "特效暗影防护药水",
		["Major Troll's Blood Potion"] = "特效巨魔之血药水",
		["Mana Potion"] = "法力药水",
		["Mercurial Stone"] = "水银石",
		["Mighty Rage Potion"] = "强效怒气药水",
		["Mighty Troll's Blood Potion"] = "超强巨魔之血药水",
		["Minor Healing Potion"] = "初级治疗药水",
		["Minor Magic Resistance Potion"] = "初级抗魔药水",
		["Minor Mana Potion"] = "初级法力药水",
		["Minor Rejuvenation Potion"] = "初级活力药水",
		["Nature Protection Potion"] = "自然防护药水",
		["Oil of Immolation"] = "献祭之油",
		["Onslaught Elixir"] = "强攻药剂",
		["Philosopher's Stone"] = "点金石",
		["Potion of Curing"] = "治愈药水",
		["Purification Potion"] = "净化药水",
		["Rage Potion"] = "怒气药水",
		["Restorative Potion"] = "滋补药剂",
		["Shadow Oil"] = "暗影之油",
		["Shadow Protection Potion"] = "暗影防护药水",
		["Shrouding Potion"] = "遮罩药水",
		["Sneaking Potion"] = "潜行药水",
		["Stonescale Oil"] = "石鳞鱼油",
		["Strong Troll's Blood Potion"] = "强力巨魔之血药水",
		["Super Healing Potion"] = "超级治疗药水",
		["Super Mana Potion"] = "超级法力药水",
		["Super Rejuvenation Potion"] = "超级活力药水",
		["Superior Healing Potion"] = "优质治疗药水",
		["Superior Mana Potion"] = "优质法力药水",
		["Swiftness Potion"] = "迅捷药水",
		["Swim Speed Potion"] = "速游药水",
		["Transmute: Air to Fire"] = "转化：点气成火",
		["Transmute: Arcanite"] = "转化：奥金",
		["Transmute: Earth to Life"] = "转化：土转生命",
		["Transmute: Earth to Water"] = "转化：转土成水",
		["Transmute: Earthstorm Diamond"] = "转化：大地风暴钻石",
		["Transmute: Elemental Fire"] = "转化：元素火焰",
		["Transmute: Fire to Earth"] = "转化：点火成土",
		["Transmute: Iron to Gold"] = "点铁成金",
		["Transmute: Life to Earth"] = "转化：生命归土",
		["Transmute: Mithril to Truesilver"] = "转化秘银",
		["Transmute: Primal Air to Fire"] = "转化：源生空气至源生火焰",
		["Transmute: Primal Earth to Life"] = "转化：源生之土至源生生命",
		["Transmute: Primal Earth to Water"] = "转化：源生之土至源生之水",
		["Transmute: Primal Fire to Earth"] = "转化：源生火焰至源生之土",
		["Transmute: Primal Fire to Mana"] = "转化：源生火焰至源生法力",
		["Transmute: Primal Life to Earth"] = "转化：源生生命至源生之土",
		["Transmute: Primal Mana to Fire"] = "转化：源生法力至源生火焰",
		["Transmute: Primal Might"] = "转化：源生之能",
		["Transmute: Primal Shadow to Water"] = "转化：源生暗影至源生之水",
		["Transmute: Primal Water to Air"] = "转化：源生之水至源生空气",
		["Transmute: Primal Water to Shadow"] = "转化：源生之水至源生暗影",
		["Transmute: Skyfire Diamond"] = "转化：天火钻石",
		["Transmute: Undeath to Water"] = "转化：死灵化水",
		["Transmute: Water to Air"] = "转化：点水成气",
		["Transmute: Water to Undeath"] = "转化：水转死灵",
		["Unstable Mana Potion"] = "不稳定的法力药水",
		["Volatile Healing Potion"] = "不稳定的治疗药水",
		["Weak Troll's Blood Potion"] = "弱效巨魔之血药水",
		["Wildvine Potion"] = "野葡萄药水",


-- Beast Training Skills 宠物技能
		["Arcane Resistance (Rank 1)"] = "奥术抗性 (等级 1)",
		["Arcane Resistance (Rank 2)"] = "奥术抗性 (等级 2)",
		["Arcane Resistance (Rank 3)"] = "奥术抗性 (等级 3)",
		["Arcane Resistance (Rank 4)"] = "奥术抗性 (等级 4)",
		["Arcane Resistance (Rank 5)"] = "奥术抗性 (等级 5)",
		["Avoidance (Rank 1)"] = "躲闪 (等级 1)",
		["Avoidance (Rank 2)"] = "躲闪 (等级 2)",
		["Bite (Rank 1)"] = "撕咬 (等级 1)",
		["Bite (Rank 2)"] = "撕咬 (等级 2)",
		["Bite (Rank 3)"] = "撕咬 (等级 3)",
		["Bite (Rank 4)"] = "撕咬 (等级 4)",
		["Bite (Rank 5)"] = "撕咬 (等级 5)",
		["Bite (Rank 6)"] = "撕咬 (等级 6)",
		["Bite (Rank 7)"] = "撕咬 (等级 7)",
		["Bite (Rank 8)"] = "撕咬 (等级 8)",
		["Bite (Rank 9)"] = "撕咬 (等级 9)",
		["Charge (Rank 1)"] = "冲锋 (等级 1)",
		["Charge (Rank 2)"] = "冲锋 (等级 2)",
		["Charge (Rank 3)"] = "冲锋 (等级 3)",
--		["Charge (Rank 4)"] = "冲锋 (等级 4)",
		["Charge (Rank 5)"] = "冲锋 (等级 5)",
		["Charge (Rank 6)"] = "冲锋 (等级 6)",
		["Claw (Rank 1)"] = "爪击 (等级 1)",
		["Claw (Rank 2)"] = "爪击 (等级 2)",
		["Claw (Rank 3)"] = "爪击 (等级 3)",
		["Claw (Rank 4)"] = "爪击 (等级 4)",
		["Claw (Rank 5)"] = "爪击 (等级 5)",
		["Claw (Rank 6)"] = "爪击 (等级 6)",
		["Claw (Rank 7)"] = "爪击 (等级 7)",
		["Claw (Rank 8)"] = "爪击 (等级 8)",
		["Claw (Rank 9)"] = "爪击 (等级 9)",
		["Cobra Reflexes ()"] = "毒蛇反射 ()",
		["Cower (Rank 1)"] = "畏缩 (等级 1)",
		["Cower (Rank 2)"] = "畏缩 (等级 2)",
		["Cower (Rank 3)"] = "畏缩 (等级 3)",
		["Cower (Rank 4)"] = "畏缩 (等级 4)",
		["Cower (Rank 5)"] = "畏缩 (等级 5)",
		["Cower (Rank 6)"] = "畏缩 (等级 6)",
		["Cower (Rank 7)"] = "畏缩 (等级 7)",
		["Dash (Rank 1)"] = "突进 (等级 1)",
		["Dash (Rank 2)"] = "突进 (等级 2)",
		["Dash (Rank 3)"] = "突进 (等级 3)",
		["Dive (Rank 1)"] = "俯冲 (等级 1)",
		["Dive (Rank 2)"] = "俯冲 (等级 2)",
		["Dive (Rank 3)"] = "俯冲 (等级 3)",
		["Fire Breath (Rank 1)"] = "火焰吐息 (等级 1)",
		["Fire Breath (Rank 2)"] = "火焰吐息 (等级 2)",
		["Fire Resistance (Rank 1)"] = "火焰抗性 (等级 1)",
		["Fire Resistance (Rank 2)"] = "火焰抗性 (等级 2)",
		["Fire Resistance (Rank 3)"] = "火焰抗性 (等级 3)",
		["Fire Resistance (Rank 4)"] = "火焰抗性 (等级 4)",
		["Fire Resistance (Rank 5)"] = "火焰抗性 (等级 5)",
		["Frost Resistance (Rank 1)"] = "冰霜抗性 (等级 1)",
		["Frost Resistance (Rank 2)"] = "冰霜抗性 (等级 2)",
		["Frost Resistance (Rank 3)"] = "冰霜抗性 (等级 3)",
		["Frost Resistance (Rank 4)"] = "冰霜抗性 (等级 4)",
		["Frost Resistance (Rank 5)"] = "冰霜抗性 (等级 5)",
		["Furious Howl (Rank 1)"] = "狂怒之嚎 (等级 1)",
		["Furious Howl (Rank 2)"] = "狂怒之嚎 (等级 2)",
		["Furious Howl (Rank 3)"] = "狂怒之嚎 (等级 3)",
		["Furious Howl (Rank 4)"] = "狂怒之嚎 (等级 4)",
		["Gore (Rank 1)"] = "角刺 (等级 1)",
		["Gore (Rank 2)"] = "角刺 (等级 2)",
		["Gore (Rank 3)"] = "角刺 (等级 3)",
		["Gore (Rank 4)"] = "角刺 (等级 4)",
--		["Gore (Rank 5)"] = "角刺 (等级 5)",
--		["Gore (Rank 6)"] = "角刺 (等级 6)",
		["Gore (Rank 7)"] = "角刺 (等级 7)",
		["Gore (Rank 8)"] = "角刺 (等级 8)",
		["Gore (Rank 9)"] = "角刺 (等级 9)",
		["Great Stamina (Rank 1)"] = "持久耐力 (等级 1)",
		["Great Stamina (Rank 10)"] = "持久耐力 (等级 10)",
		["Great Stamina (Rank 11)"] = "持久耐力 (等级 11)",
		["Great Stamina (Rank 2)"] = "持久耐力 (等级 2)",
		["Great Stamina (Rank 3)"] = "持久耐力 (等级 3)",
		["Great Stamina (Rank 4)"] = "持久耐力 (等级 4)",
		["Great Stamina (Rank 5)"] = "持久耐力 (等级 5)",
		["Great Stamina (Rank 6)"] = "持久耐力 (等级 6)",
		["Great Stamina (Rank 7)"] = "持久耐力 (等级 7)",
		["Great Stamina (Rank 8)"] = "持久耐力 (等级 8)",
		["Great Stamina (Rank 9)"] = "持久耐力 (等级 9)",
		["Growl (Rank 1)"] = "低吼 (等级 1)",
		["Growl (Rank 2)"] = "低吼 (等级 2)",
		["Growl (Rank 3)"] = "低吼 (等级 3)",
		["Growl (Rank 4)"] = "低吼 (等级 4)",
		["Growl (Rank 5)"] = "低吼 (等级 5)",
		["Growl (Rank 6)"] = "低吼 (等级 6)",
		["Growl (Rank 7)"] = "低吼 (等级 7)",
		["Growl (Rank 8)"] = "低吼 (等级 8)",
		["Lightning Breath (Rank 1)"] = "闪电吐息 (等级 1)",
		["Lightning Breath (Rank 2)"] = "闪电吐息 (等级 2)",
		["Lightning Breath (Rank 3)"] = "闪电吐息 (等级 3)",
		["Lightning Breath (Rank 4)"] = "闪电吐息 (等级 4)",
		["Lightning Breath (Rank 5)"] = "闪电吐息 (等级 5)",
		["Lightning Breath (Rank 6)"] = "闪电吐息 (等级 6)",
		["Natural Armor (Rank 1)"] = "自然护甲 (等级 1)",
		["Natural Armor (Rank 10)"] = "自然护甲 (等级 10)",
		["Natural Armor (Rank 11)"] = "自然护甲 (等级 11)",
		["Natural Armor (Rank 2)"] = "自然护甲 (等级 2)",
		["Natural Armor (Rank 3)"] = "自然护甲 (等级 3)",
		["Natural Armor (Rank 4)"] = "自然护甲 (等级 4)",
		["Natural Armor (Rank 5)"] = "自然护甲 (等级 5)",
		["Natural Armor (Rank 6)"] = "自然护甲 (等级 6)",
		["Natural Armor (Rank 7)"] = "自然护甲 (等级 7)",
		["Natural Armor (Rank 8)"] = "自然护甲 (等级 8)",
		["Natural Armor (Rank 9)"] = "自然护甲 (等级 9)",
		["Nature Resistance (Rank 1)"] = "自然抗性 (等级 1)",
		["Nature Resistance (Rank 2)"] = "自然抗性 (等级 2)",
		["Nature Resistance (Rank 3)"] = "自然抗性 (等级 3)",
		["Nature Resistance (Rank 4)"] = "自然抗性 (等级 4)",
		["Nature Resistance (Rank 5)"] = "自然抗性 (等级 5)",
		["Poison Spit (Rank 1)"] = "毒液喷吐 (等级 1)",
		["Poison Spit (Rank 2)"] = "毒液喷吐 (等级 2)",
		["Poison Spit (Rank 3)"] = "毒液喷吐 (等级 3)",
		["Prowl (Rank 1)"] = "潜伏 (等级 1)",
		["Prowl (Rank 2)"] = "潜伏 (等级 2)",
		["Prowl (Rank 3)"] = "潜伏 (等级 3)",
		["Scorpid Poison (Rank 1)"] = "蝎毒 (等级 1)",
		["Scorpid Poison (Rank 2)"] = "蝎毒 (等级 2)",
		["Scorpid Poison (Rank 3)"] = "蝎毒 (等级 3)",
		["Scorpid Poison (Rank 4)"] = "蝎毒 (等级 4)",
		["Scorpid Poison (Rank 5)"] = "蝎毒 (等级 5)",
		["Screech (Rank 1)"] = "尖啸 (等级 1)",
		["Screech (Rank 2)"] = "尖啸 (等级 2)",
		["Screech (Rank 3)"] = "尖啸 (等级 3)",
		["Screech (Rank 4)"] = "尖啸 (等级 4)",
		["Screech (Rank 5)"] = "尖啸 (等级 5)",
		["Shadow Resistance (Rank 1)"] = "暗影抗性 (等级 1)",
		["Shadow Resistance (Rank 2)"] = "暗影抗性 (等级 2)",
		["Shadow Resistance (Rank 3)"] = "暗影抗性 (等级 3)",
		["Shadow Resistance (Rank 4)"] = "暗影抗性 (等级 4)",
		["Shadow Resistance (Rank 5)"] = "暗影抗性 (等级 5)",
		["Shell Shield (Rank 1)"] = "甲壳护盾 (等级 1)",
		["Thunderstomp (Rank 1)"] = "雷霆践踏 (等级 1)",
		["Thunderstomp (Rank 2)"] = "雷霆践踏 (等级 2)",
		["Thunderstomp (Rank 3)"] = "雷霆践踏 (等级 3)",
		["Warp (Rank 1)"] = "迁跃 (等级 1)",

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "精金胸甲",
		["Adamantite Cleaver"] = "精金利斧",
		["Adamantite Dagger"] = "精金匕首",
		["Adamantite Maul"] = "精金重槌",
		["Adamantite Plate Bracers"] = "精金板甲护腕",
		["Adamantite Plate Gloves"] = "精金板甲手套",
		["Adamantite Rapier"] = "精金轻剑",
		["Adamantite Rod"] = "精金棒",
		["Adamantite Sharpening Stone"] = "精金磨刀石",
		["Adamantite Weapon Chain"] = "精金武器链",
		["Adamantite Weightstone"] = "精金平衡石",
		["Annihilator"] = "歼灭者",
		["Arcanite Champion"] = "奥金勇士剑",
		["Arcanite Reaper"] = "奥金斧",
		["Arcanite Rod"] = "奥金棒",
		["Arcanite Skeleton Key"] = "奥金万能钥匙",
		["Barbaric Iron Boots"] = "野人铁靴",
		["Barbaric Iron Breastplate"] = "野人铁质胸甲",
		["Barbaric Iron Gloves"] = "野人铁手套",
		["Barbaric Iron Helm"] = "野人铁盔",
		["Barbaric Iron Shoulders"] = "野人铁护肩",
		["Belt of the Guardian"] = "守护者腰带",
		["Big Black Mace"] = "巨型黑色锤",
		["Big Bronze Knife"] = "青铜匕首",
		["Black Amnesty"] = "野蛮狂怒",
		["Black Felsteel Bracers"] = "黑色魔钢护腕",
		["Black Grasp of the Destroyer"] = "毁灭者的黑暗之握",
		["Black Planar Edge"] = "黑色位面战斧",
		["Blackfury"] = "黑色怒火",
		["Blackguard"] = "黑色卫士",
		["Blazefury"] = "光芒之怒",
		["Blazeguard"] = "光芒卫士",
		["Blazing Rapier"] = "闪耀轻剑",
		["Blessed Bracers"] = "神宠护腕",
		["Blight"] = "荒芜",
		["Bloodmoon"] = "血月",
		["Bloodsoul Breastplate"] = "血魂胸甲",
		["Bloodsoul Gauntlets"] = "血魂护手",
		["Bloodsoul Shoulders"] = "血魂护肩",
		["Blue Glittering Axe"] = "蓝光斧",
		["Boots of the Protector"] = "保卫者战靴",
		["Bracers of the Green Fortress"] = "绿色要塞护腕",
		["Breastplate of Kings"] = "王者胸甲",
		["Bronze Axe"] = "青铜斧",
		["Bronze Battle Axe"] = "青铜战斧",
		["Bronze Greatsword"] = "青铜巨剑",
		["Bronze Mace"] = "青铜钉锤",
		["Bronze Shortsword"] = "青铜短剑",
		["Bronze Warhammer"] = "青铜战锤",
		["Bulwark of Kings"] = "王者壁垒",
		["Bulwark of the Ancient Kings"] = "列王壁垒",
		["Coarse Grinding Stone"] = "粗制砂轮",
		["Coarse Sharpening Stone"] = "粗制磨刀石",
		["Coarse Weightstone"] = "粗制平衡石",
		["Copper Axe"] = "铜斧",
		["Copper Battle Axe"] = "铜质战斧",
		["Copper Bracers"] = "铜质护腕",
		["Copper Chain Belt"] = "铜质链甲腰带",
		["Copper Chain Boots"] = "铜质链甲战靴",
		["Copper Chain Pants"] = "铜质链甲短裤",
		["Copper Chain Vest"] = "铜质链甲外衣",
		["Copper Claymore"] = "铜质双刃刀",
		["Copper Dagger"] = "铜质匕首",
		["Copper Mace"] = "铜质钉锤",
		["Copper Shortsword"] = "铜质短剑",
		["Corruption"] = "腐蚀术",
		["Dark Iron Boots"] = "黑铁长靴",
		["Dark Iron Bracers"] = "黑铁护腕",
		["Dark Iron Destroyer"] = "黑铁战斧",
		["Dark Iron Gauntlets"] = "黑铁护手",
		["Dark Iron Helm"] = "黑铁头盔",
		["Dark Iron Leggings"] = "黑铁护腿",
		["Dark Iron Mail"] = "黑铁锁甲",
		["Dark Iron Plate"] = "黑铁板甲",
		["Dark Iron Pulverizer"] = "黑铁粉碎者",
		["Dark Iron Reaver"] = "黑铁利剑",
		["Dark Iron Shoulders"] = "黑铁护肩",
		["Dark Iron Sunderer"] = "黑铁斩碎者",
		["Darkrune Breastplate"] = "黑暗符文胸甲",
		["Darkrune Gauntlets"] = "黑暗符文护手",
		["Darkrune Helm"] = "黑暗符文头盔",
		["Darksoul Breastplate"] = "黑暗之魂胸甲",
		["Darksoul Leggings"] = "黑暗之魂护腿",
		["Darksoul Shoulders"] = "黑暗之魂护肩",
		["Dawnbringer Shoulders"] = "黎明使者护肩",
		["Dawn's Edge"] = "黎明之刃",
		["Dawnsteel Bracers"] = "晨光护腕",
		["Dawnsteel Shoulders"] = "晨钢护肩",
		["Dazzling Mithril Rapier"] = "秘银细剑",
		["Deadly Bronze Poniard"] = "致命的青铜短剑",
		["Deep Thunder"] = "惊雷",
		["Demon Forged Breastplate"] = "魔铸胸甲",
		["Dense Grinding Stone"] = "致密砂轮",
		["Dense Sharpening Stone"] = "致密磨刀石",
		["Dense Weightstone"] = "致密平衡石",
		["Dirge"] = "挽歌",
		["Dragonmaw"] = "巨龙之喉",
		["Dragonstrike"] = "巨龙之击",
		["Drakefist Hammer"] = "龙拳之锤",
		["Earthforged Leggings"] = "地铸护腿",
		["Earthpeace Breastplate"] = "和谐胸甲",
		["Ebon Hand"] = "黑手",
		["Ebon Shiv"] = "乌木刀",
		["Edge of Winter"] = "寒冬之刃",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Embrace of the Twisting Nether"] = "扭曲虚空的拥抱",
		["Enchanted Adamantite Belt"] = "魔化精金腰带",
		["Enchanted Adamantite Boots"] = "魔化精金长靴",
		["Enchanted Adamantite Breastplate"] = "魔化精金胸甲",
		["Enchanted Adamantite Leggings"] = "魔化精金护腿",
		["Enchanted Battlehammer"] = "魔化战锤",
		["Enchanted Thorium Blades"] = "魔化瑟银飞刀",
		["Enchanted Thorium Breastplate"] = "魔法瑟银胸甲",
		["Enchanted Thorium Helm"] = "魔法瑟银头盔",
		["Enchanted Thorium Leggings"] = "魔法瑟银护腿",
		["Eternium Rod"] = "恒金棒",
		["Eternium Runed Blade"] = "恒金符文之刃",
		["Fel Edged Battleaxe"] = "魔能利斧",
		["Fel Hardened Maul"] = "魔能强化战槌",
		["Fel Iron Breastplate"] = "魔铁胸甲",
		["Fel Iron Chain Bracers"] = "魔铁链甲护腕",
		["Fel Iron Chain Coif"] = "魔铁链甲罩帽",
		["Fel Iron Chain Gloves"] = "魔铁链甲手套",
		["Fel Iron Chain Tunic"] = "魔铁链甲外套",
		["Fel Iron Greatsword"] = "魔铁巨剑",
		["Fel Iron Hammer"] = "魔铁战锤",
		["Fel Iron Hatchet"] = "魔铁短斧",
		["Fel Iron Plate Belt"] = "魔铁板甲腰带",
		["Fel Iron Plate Boots"] = "魔铁板甲战靴",
		["Fel Iron Plate Gloves"] = "魔铁板甲手套",
		["Fel Iron Plate Pants"] = "魔铁板甲短裤",
		["Fel Iron Rod"] = "魔铁棒",
		["Fel Sharpening Stone"] = "魔能磨刀石",
		["Fel Weightstone"] = "魔能平衡石",
		["Felfury Gauntlets"] = "魔怒护手",
		["Felsteel Gloves"] = "魔钢手套",
		["Felsteel Helm"] = "魔钢头盔",
		["Felsteel Leggings"] = "魔钢护腿",
		["Felsteel Longblade"] = "魔钢长剑",
		["Felsteel Reaper"] = "魔钢斧",
		["Felsteel Shield Spike"] = "魔钢盾刺",
		["Felsteel Whisper Knives"] = "魔钢密语匕首",
--		["Fiery Blaze Enchantment"] = true,
		["Fiery Chain Girdle"] = "炽热链甲束带",
		["Fiery Chain Shoulders"] = "炽热链甲护肩",
		["Fiery Plate Gauntlets"] = "炽热板甲护手",
		["Fireguard"] = "火焰卫士",
		["Flamebane Bracers"] = "灭焰护腕",
		["Flamebane Breastplate"] = "灭焰胸甲",
		["Flamebane Gloves"] = "灭焰手套",
		["Flamebane Helm"] = "灭焰头盔",
		["Frost Tiger Blade"] = "霜虎之刃",
		["Frostguard"] = "寒冰护卫者",
		["Gauntlets of the Iron Tower"] = "铁塔护手",
		["Gemmed Copper Gauntlets"] = "铜质宝石手套",
		["Girdle of the Dawn"] = "黎明束腰",
		["Glinting Steel Dagger"] = "亮闪闪的钢匕首",
		["Gloves of the Dawn"] = "黎明手套",
		["Golden Iron Destroyer"] = "碎铁金锤",
		["Golden Rod"] = "金棒",
		["Golden Scale Boots"] = "金鳞战靴",
		["Golden Scale Bracers"] = "金鳞护腕",
		["Golden Scale Coif"] = "金鳞罩盔",
		["Golden Scale Cuirass"] = "金鳞胸甲",
		["Golden Scale Gauntlets"] = "金鳞护手",
		["Golden Scale Leggings"] = "金鳞护腿",
		["Golden Scale Shoulders"] = "金鳞护肩",
		["Golden Skeleton Key"] = "黄金万能钥匙",
		["Great Earthforged Hammer"] = "巨型地铸战锤",
		["Greater Rune of Warding"] = "强效结界符文",
		["Greater Ward of Shielding"] = "强效护盾结界",
		["Green Iron Boots"] = "绿铁战靴",
		["Green Iron Bracers"] = "绿铁护腕",
		["Green Iron Gauntlets"] = "绿铁护手",
		["Green Iron Hauberk"] = "绿铁锁甲",
		["Green Iron Helm"] = "绿铁头盔",
		["Green Iron Leggings"] = "绿铁护腿",
		["Green Iron Shoulders"] = "绿铁护肩",
		["Hammer of Righteous Might"] = "正义力量之锤",
		["Hammer of the Titans"] = "泰坦之锤",
		["Hand of Eternity"] = "永恒之手",
		["Hardened Iron Shortsword"] = "硬铁短剑",
		["Heartseeker"] = "觅心者",
		["Heavy Bronze Mace"] = "青铜重锤",
		["Heavy Copper Broadsword"] = "铜质重剑",
		["Heavy Copper Longsword"] = "铜制重剑",
		["Heavy Copper Maul"] = "铜质大锤",
		["Heavy Earthforged Breastplate"] = "重型地铸胸甲",
		["Heavy Grinding Stone"] = "重砂轮",
		["Heavy Mithril Axe"] = "秘银重斧",
		["Heavy Mithril Boots"] = "秘银重靴",
		["Heavy Mithril Breastplate"] = "重型秘银胸甲",
		["Heavy Mithril Gauntlet"] = "重型秘银手套",
		["Heavy Mithril Helm"] = "重型秘银头盔",
		["Heavy Mithril Pants"] = "秘银短裤",
		["Heavy Mithril Shoulder"] = "重型秘银护肩",
		["Heavy Obsidian Belt"] = "重型黑曜石腰带",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Heavy Timbermaw Belt"] = "重型木喉腰带",
		["Heavy Timbermaw Boots"] = "重型木喉长靴",
		["Heavy Weightstone"] = "重平衡石",
		["Helm of the Great Chief"] = "大酋长头盔",
		["Helm of the Stalwart Defender"] = "坚定防御者头盔",
		["Huge Thorium Battleaxe"] = "巨型瑟银战斧",
		["Icebane Bracers"] = "破冰护腕",
		["Icebane Breastplate"] = "破冰胸甲",
		["Icebane Gauntlets"] = "破冰护手",
		["Iceguard Breastplate"] = "寒冰卫士胸甲",
		["Iceguard Helm"] = "寒冰卫士头盔",
		["Iceguard Leggings"] = "寒冰卫士护腿",
		["Imperial Plate Belt"] = "君王板甲腰带",
		["Imperial Plate Boots"] = "君王板甲战靴",
		["Imperial Plate Bracers"] = "君王板甲护腕",
		["Imperial Plate Chest"] = "君王板甲护胸",
		["Imperial Plate Helm"] = "君王板甲头盔",
		["Imperial Plate Leggings"] = "君王板甲护腿",
		["Imperial Plate Shoulders"] = "君王板甲护肩",
		["Inlaid Mithril Cylinder"] = "秘银杆",
		["Invulnerable Mail"] = "免伤锁甲",
		["Iridescent Hammer"] = "彩虹之锤",
		["Iron Buckle"] = "铁扣环",
		["Iron Counterweight"] = "铁质平衡锤",
		["Iron Shield Spike"] = "铁质盾刺",
		["Ironforge Breastplate"] = "铁炉堡胸甲",
		["Ironvine Belt"] = "铁藤腰带",
		["Ironvine Breastplate"] = "铁藤胸甲",
		["Ironvine Gloves"] = "铁藤手套",
		["Jade Serpentblade"] = "玉蛇刀",
		["Jagged Obsidian Shield"] = "碎裂黑曜石盾牌",
		["Khorium Belt"] = "氪金腰带",
		["Khorium Boots"] = "氪金战靴",
		["Khorium Champion"] = "氪金圣剑",
		["Khorium Pants"] = "氪金短裤",
		["Lavaforged Warhammer"] = "熔铸战锤",
		["Lesser Rune of Warding"] = "次级结界符文",
		["Lesser Ward of Shielding"] = "次级护盾结界",
		["Light Earthforged Blade"] = "轻型地铸利刃",
		["Light Emberforged Hammer"] = "轻型灰烬铸锤",
		["Light Obsidian Belt"] = "轻型黑曜石腰带",
		["Light Skyforged Axe"] = "轻型天铸战斧",
		["Lionheart Blade"] = "狮心之刃",
		["Lionheart Champion"] = "狮心圣剑",
		["Lionheart Executioner"] = "狮心斩杀者",
		["Lionheart Helm"] = "狮心头盔",
		["Lunar Crescent"] = "新月",
		["Massive Iron Axe"] = "巨型铁斧",
		["Masterwork Stormhammer"] = "精工风暴战锤",
		["Mighty Iron Hammer"] = "巨型铁锤",
		["Mithril Coif"] = "秘银罩帽",
		["Mithril Scale Bracers"] = "秘银鳞片护腕",
		["Mithril Scale Gloves"] = "秘银鳞片手套",
		["Mithril Scale Pants"] = "秘银鳞片短裤",
		["Mithril Scale Shoulders"] = "秘银鳞片护肩",
		["Mithril Shield Spike"] = "秘银盾刺",
		["Mithril Spurs"] = "秘银马刺",
		["Mooncleaver"] = "月牙屠斧",
		["Moonsteel Broadsword"] = "月钢宽剑",
		["Nether Chain Shirt"] = "虚空链衫",
		["Nightfall"] = "夜幕",
		["Oathkeeper's Helm"] = "誓言守护者头盔",
		["Obsidian Mail Tunic"] = "黑曜石锁甲",
		["Orcish War Leggings"] = "兽人护腿",
		["Ornate Mithril Boots"] = "精制秘银战靴",
		["Ornate Mithril Breastplate"] = "精制秘银胸甲",
		["Ornate Mithril Gloves"] = "精制秘银手套",
		["Ornate Mithril Helm"] = "精制秘银头盔",
		["Ornate Mithril Pants"] = "精制秘银短裤",
		["Ornate Mithril Shoulder"] = "精制秘银护肩",
		["Ornate Thorium Handaxe"] = "华丽瑟银手斧",
		["Patterned Bronze Bracers"] = "青铜花纹护腕",
		["Pearl-handled Dagger"] = "珍珠匕首",
		["Persuader"] = "说服者",
		["Phantom Blade"] = "幻影之刃",
		["Polished Steel Boots"] = "精钢战靴",
		["Radiant Belt"] = "辐光腰带",
		["Radiant Boots"] = "辐光长靴",
		["Radiant Breastplate"] = "辐光胸甲",
		["Radiant Circlet"] = "辐光头饰",
		["Radiant Gloves"] = "辐光手套",
		["Radiant Leggings"] = "辐光护腿",
		["Ragesteel Breastplate"] = "怒钢胸甲",
		["Ragesteel Gloves"] = "怒钢手套",
		["Ragesteel Helm"] = "怒钢头盔",
		["Ragesteel Shoulders"] = "怒钢护肩",
		["Red Belt of Battle"] = "红色战斗腰带",
		["Red Havoc Boots"] = "红色浩劫长靴",
		["Rough Bronze Boots"] = "劣质青铜战靴",
		["Rough Bronze Bracers"] = "劣质青铜护腕",
		["Rough Bronze Cuirass"] = "劣质青铜胸甲",
		["Rough Bronze Leggings"] = "劣质青铜护腿",
		["Rough Bronze Shoulders"] = "劣质青铜护肩",
		["Rough Copper Vest"] = "劣质铜外衣",
		["Rough Grinding Stone"] = "劣质砂轮",
		["Rough Sharpening Stone"] = "劣质磨刀石",
		["Rough Weightstone"] = "劣质平衡石",
		["Runed Copper Belt"] = "铜质符文腰带",
		["Runed Copper Bracers"] = "铜质符文护腕",
		["Runed Copper Breastplate"] = "铜质符文胸甲",
		["Runed Copper Gauntlets"] = "铜质符文护手",
		["Runed Copper Pants"] = "铜质符文短裤",
		["Runed Mithril Hammer"] = "秘银符文战锤",
		["Runic Breastplate"] = "符文板甲",
		["Runic Hammer"] = "符印战锤",
		["Runic Plate Boots"] = "符文板甲战靴",
		["Runic Plate Helm"] = "符文板甲头盔",
		["Runic Plate Leggings"] = "符文板甲护腿",
		["Runic Plate Shoulders"] = "符文板甲护肩",
		["Sageblade"] = "先知之刃",
		["Searing Golden Blade"] = "灼热金剑",
		["Serenity"] = "平静",
		["Shadesteel Bracers"] = "影钢护腕",
		["Shadesteel Girdle"] = "影钢束带",
		["Shadesteel Greaves"] = "影钢腿甲",
		["Shadesteel Sabots"] = "影钢战靴",
		["Shadow Crescent Axe"] = "月牙斧",
		["Shining Silver Breastplate"] = "银鳞胸甲",
		["Silver Rod"] = "银棒",
		["Silver Skeleton Key"] = "白银万能钥匙",
		["Silvered Bronze Boots"] = "镀银青铜战靴",
		["Silvered Bronze Breastplate"] = "镀银青铜胸甲",
		["Silvered Bronze Gauntlets"] = "镀银青铜护手",
		["Silvered Bronze Leggings"] = "镀银青铜护腿",
		["Silvered Bronze Shoulders"] = "镀银青铜护肩",
		["Skyforged Great Axe"] = "天铸巨斧",
		["Solid Grinding Stone"] = "坚固的砂轮",
		["Solid Iron Maul"] = "结实的铁锤",
		["Solid Sharpening Stone"] = "坚固的磨刀石",
		["Solid Weightstone"] = "坚固的平衡石",
		["Steel Breastplate"] = "钢质胸甲",
		["Steel Plate Helm"] = "钢质头盔",
		["Steel Weapon Chain"] = "钢质武器链",
		["Steelgrip Gauntlets"] = "钢钳护手",
		["Stoneforged Claymore"] = "石铸巨剑",
		["Storm Gauntlets"] = "风暴护手",
		["Storm Helm"] = "风暴头盔",
		["Stormforged Axe"] = "雷铸战斧",
		["Stormforged Hauberk"] = "雷铸战甲",
		["Stormherald"] = "风暴使者",
		["Stronghold Gauntlets"] = "要塞护手",
		["Sulfuron Hammer"] = "萨弗隆战锤",
		["Swiftsteel Bracers"] = "迅钢护腕",
		["Swiftsteel Gloves"] = "迅钢手套",
		["Swiftsteel Shoulders"] = "迅钢护肩",
		["The Planar Edge"] = "位面战斧",
		["The Shatterer"] = "粉碎者",
		["Thick Bronze Darts"] = "厚重青铜飞镖",
		["Thick Obsidian Breastplate"] = "厚重黑曜石胸甲",
		["Thick War Axe"] = "厚重战斧",
		["Thorium Armor"] = "瑟银护甲",
		["Thorium Belt"] = "瑟银腰带",
		["Thorium Boots"] = "瑟银长靴",
		["Thorium Bracers"] = "瑟银护腕",
		["Thorium Helm"] = "瑟银头盔",
		["Thorium Leggings"] = "瑟银护腿",
		["Thorium Shield Spike"] = "瑟银盾刺",
		["Thunder"] = "雷霆",
		["Titanic Leggings"] = "泰坦护腿",
		["Truesilver Breastplate"] = "真银胸甲",
		["Truesilver Champion"] = "真银圣剑",
		["Truesilver Gauntlets"] = "真银护手",
		["Truesilver Rod"] = "真银棒",
		["Truesilver Skeleton Key"] = "真银万能钥匙",
		["Twisting Nether Chain Shirt"] = "扭曲虚空链衫",
		["Volcanic Hammer"] = "火山战锤",
		["Whirling Steel Axes"] = "旋风钢斧",
		["Whitesoul Helm"] = "白魂头盔",
		["Wicked Edge of the Planes"] = "邪恶位面战斧",
		["Wicked Mithril Blade"] = "秘银魔剑",
		["Wildguard Breastplate"] = "野性卫士胸甲",
		["Wildguard Helm"] = "野性卫士头盔",
		["Wildguard Leggings"] = "野性卫士护腿",
		["Wildthorn Mail"] = "野刺锁甲",
		["Windforged Leggings"] = "风铸护腿",
		["Windforged Rapier"] = "风铸轻剑",


-- Cooking Recipes
		["Baked Salmon"] = "烤鲑鱼",
		["Barbecued Buzzard Wing"] = "烧烤秃鹰翅膀",
		["Bat Bites"] = "美味蝙蝠",
		["Beer Basted Boar Ribs"] = "啤酒烤猪排",
		["Big Bear Steak"] = "大块的熊排",
		["Blackened Basilisk"] = "烟熏蜥蜴",
		["Blackened Sporefish"] = "烟熏孢子鱼",
		["Blackened Trout"] = "烟熏鲑鱼",
		["Blood Sausage"] = "血肠",
		["Boiled Clams"] = "水煮蚌肉",
		["Brilliant Smallfish"] = "美味小鱼",
		["Bristle Whisker Catfish"] = "刺须鲶鱼",
		["Broiled Bloodfin"] = "烤血鳞鱼",
		["Buzzard Bites"] = "美味秃鹫",
		["Carrion Surprise"] = "腐肉大餐",
		["Charred Wolf Meat"] = "烧烤狼肉",
		["Clam Bar"] = "蚌柳",
		["Clam Chowder"] = "杂烩蚌肉",
		["Cooked Crab Claw"] = "煮蟹爪",
		["Cooked Glossy Mightfish"] = "煮熟的光滑大鱼",
		["Coyote Steak"] = "山狗肉排",
		["Crab Cake"] = "蟹肉蛋糕",
		["Crispy Bat Wing"] = "香脆蝙蝠翅",
		["Crispy Lizard Tail"] = "脆炸蜥蜴尾",
		["Crocolisk Gumbo"] = "鳄鱼浓汤",
		["Crocolisk Steak"] = "鳄鱼肉排",
		["Crunchy Serpent"] = "香脆蛇",
		["Crunchy Spider Surprise"] = "松脆蜘蛛",
		["Curiously Tasty Omelet"] = "美味煎蛋卷",
		["Delicious Chocolate Cake"] = "美味巧克力蛋糕",
		["Dig Rat Stew"] = "掘地鼠炖肉",
		["Dirge's Kickin' Chimaerok Chops"] = "迪尔格的超美味奇美拉肉片",
		["Dragonbreath Chili"] = "龙息红椒",
		["Dry Pork Ribs"] = "猪肉干",
		["Egg Nog"] = "蛋奶酒",
		["Feltail Delight"] = "美味魔尾鱼",
		["Filet of Redgill"] = "油炸红腮鱼",
		["Fillet of Frenzy"] = "狂鱼肉片",
		["Fisherman's Feast"] = "渔夫的美味",
		["Giant Clam Scorcho"] = "烧烤巨蚌",
		["Gingerbread Cookie"] = "姜饼",
		["Goblin Deviled Clams"] = "地精芥末蘸蚌肉",
		["Golden Fish Sticks"] = "金色鱼柳",
		["Goldthorn Tea"] = "金棘茶",
		["Gooey Spider Cake"] = "蜘蛛蛋糕",
		["Goretusk Liver Pie"] = "猪肝馅饼",
		["Grilled Mudfish"] = "烤泥鱼",
		["Grilled Squid"] = "烤鱿鱼",
		["Heavy Crocolisk Stew"] = "鳄鱼炖肉",
		["Heavy Kodo Stew"] = "科多肉杂烩",
		["Herb Baked Egg"] = "草药烘蛋",
		["Hot Apple Cider"] = "苹果热酒",
		["Hot Buttered Trout"] = "黄油鲑鱼",
		["Hot Lion Chops"] = "烤狮排",
		["Hot Smoked Bass"] = "烟熏鲈鱼",
		["Hot Wolf Ribs"] = "辣味狼排",
		["Jungle Stew"] = "丛林大杂烩",
		["Kaldorei Spider Kabob"] = "卡多雷蜘蛛烤肉",
		["Kibler's Bits"] = "金布勒宠物食品",
		["Lean Venison"] = "瘦鹿肉",
		["Lean Wolf Steak"] = "瘦狼排",
		["Lobster Stew"] = "炖龙虾",
		["Loch Frenzy Delight"] = "洛克湖狂鱼",
		["Longjaw Mud Snapper"] = "长嘴泥鳅",
		["Lynx Steak"] = "山猫肉排",
		["Mightfish Steak"] = "大鱼片",
		["Mithril Headed Trout"] = "银头鲑鱼",
		["Mok'Nathal Shortribs"] = "莫克纳萨肋排",
		["Monster Omelet"] = "超级煎蛋卷",
		["Murloc Fin Soup"] = "鱼人鳍汤",
		["Mystery Stew"] = "神秘杂烩",
		["Nightfin Soup"] = "夜鳞鱼汤",
		["Poached Bluefish"] = "水煮蓝鱼",
		["Poached Sunscale Salmon"] = "水煮阳鳞鲑鱼",
		["Rainbow Fin Albacore"] = "彩鳍鱼",
		["Ravager Dog"] = "掠食者热狗",
		["Redridge Goulash"] = "赤脊山炖肉",
		["Roast Raptor"] = "烤迅猛龙肉",
		["Roasted Boar Meat"] = "烤野猪肉",
		["Roasted Clefthoof"] = "烧烤裂蹄牛",
		["Roasted Kodo Meat"] = "烤科多肉",
		["Roasted Moongraze Tenderloin"] = "月痕鹿腰肉",
		["Rockscale Cod"] = "石鳞鳕鱼",
		["Runn Tum Tuber Surprise"] = "洛恩塔姆薯块",
		["Sagefish Delight"] = "美味鼠尾鱼",
		["Savory Deviate Delight"] = "美味风蛇",
		["Scorpid Surprise"] = "蝎肉大餐",
		["Seasoned Wolf Kabob"] = "干烤狼肉串",
		["Skullfish Soup"] = "骨鱼汤",
		["Slitherskin Mackerel"] = "滑皮鲭鱼",
		["Smoked Bear Meat"] = "熏熊肉",
		["Smoked Desert Dumplings"] = "沙漠肉丸子",
		["Smoked Sagefish"] = "烤鼠尾鱼",
		["Soothing Turtle Bisque"] = "海龟汤",
		["Spice Bread"] = "香料面包",
		["Spiced Chili Crab"] = "辣椒蟹肉",
		["Spiced Wolf Meat"] = "香辣狼肉",
		["Spicy Crawdad"] = "香辣小龙虾",
		["Spicy Hot Talbuk"] = "热辣塔布羊排",
		["Spider Sausage"] = "蜘蛛肉肠",
		["Sporeling Snack"] = "孢子小吃",
		["Spotted Yellowtail"] = "斑点黄尾鱼",
		["Stewed Trout"] = "炖鲑鱼",
		["Stormchops"] = "风暴牛排",
		["Strider Stew"] = "炖陆行鸟",
		["Succulent Pork Ribs"] = "多汁猪排",
		["Talbuk Steak"] = "塔布肉排",
		["Tasty Lion Steak"] = "香烤狮肉",
		["Tender Wolf Steak"] = "嫩狼肉排",
		["Thistle Tea"] = "菊花茶",
		["Undermine Clam Chowder"] = "安德麦蚌肉杂烩",
		["Warp Burger"] = "迁跃兽汉堡",
		["Westfall Stew"] = "杂味炖肉",


-- Enchanting Recipes
		["Brilliant Mana Oil"] = "卓越法力之油",
		["Brilliant Wizard Oil"] = "卓越巫师之油",
		["Enchant 2H Weapon - Agility"] = "附魔双手武器 - 敏捷",
		["Enchant 2H Weapon - Greater Impact"] = "附魔双手武器 - 强效冲击",
		["Enchant 2H Weapon - Impact"] = "附魔双手武器 - 冲击",
		["Enchant 2H Weapon - Lesser Impact"] = "附魔双手武器 - 次级冲击",
		["Enchant 2H Weapon - Lesser Intellect"] = "附魔双手武器 - 次级智力",
		["Enchant 2H Weapon - Lesser Spirit"] = "附魔双手武器 - 次级精神",
		["Enchant 2H Weapon - Major Agility"] = "附魔双手武器 - 特效敏捷",
		["Enchant 2H Weapon - Major Intellect"] = "附魔双手武器 - 特效智力",
		["Enchant 2H Weapon - Major Spirit"] = "附魔双手武器 - 特效精神",
		["Enchant 2H Weapon - Minor Impact"] = "附魔双手武器 - 初级冲击",
		["Enchant 2H Weapon - Savagery"] = "附魔双手武器 - 野蛮",
		["Enchant 2H Weapon - Superior Impact"] = "附魔双手武器 - 超强冲击",
		["Enchant Boots - Agility"] = "附魔靴子 - 敏捷",
		["Enchant Boots - Boar's Speed"] = "附魔长靴 - 野猪之速",
		["Enchant Boots - Cat's Swiftness"] = "附魔长靴 - 豹之迅捷",
		["Enchant Boots - Dexterity"] = "附魔长靴 - 灵巧",
		["Enchant Boots - Fortitude"] = "附魔长靴 - 坚韧",
		["Enchant Boots - Greater Agility"] = "附魔靴子 - 强效敏捷",
		["Enchant Boots - Greater Stamina"] = "附魔靴子 - 强效耐力",
		["Enchant Boots - Lesser Agility"] = "附魔靴子 - 次级敏捷",
		["Enchant Boots - Lesser Spirit"] = "附魔靴子 - 次级精神",
		["Enchant Boots - Lesser Stamina"] = "附魔靴子 - 次级耐力",
		["Enchant Boots - Minor Agility"] = "附魔靴子 - 初级敏捷",
		["Enchant Boots - Minor Speed"] = "附魔靴子 - 初级速度",
		["Enchant Boots - Minor Stamina"] = "附魔靴子 - 初级耐力",
		["Enchant Boots - Spirit"] = "附魔靴子 - 精神",
		["Enchant Boots - Stamina"] = "附魔靴子 - 耐力",
		["Enchant Boots - Surefooted"] = "附魔长靴 - 稳固",
		["Enchant Boots - Vitality"] = "附魔长靴 - 活力",
		["Enchant Bracer - Assault"] = "附魔护腕 - 突袭",
		["Enchant Bracer - Brawn"] = "附魔护腕 - 强壮",
		["Enchant Bracer - Deflection"] = "附魔护腕 - 偏斜",
		["Enchant Bracer - Fortitude"] = "附魔护腕 - 坚韧",
		["Enchant Bracer - Greater Intellect"] = "附魔护腕 - 强效智力",
		["Enchant Bracer - Greater Spirit"] = "附魔护腕 - 强效精神",
		["Enchant Bracer - Greater Stamina"] = "附魔护腕 - 强效耐力",
		["Enchant Bracer - Greater Strength"] = "附魔护腕 - 强效力量",
		["Enchant Bracer - Healing Power"] = "附魔护腕 - 治疗能力",
		["Enchant Bracer - Intellect"] = "附魔护腕 - 智力",
		["Enchant Bracer - Lesser Deflection"] = "附魔护腕 - 次级偏斜",
		["Enchant Bracer - Lesser Intellect"] = "附魔护腕 - 次级智力",
		["Enchant Bracer - Lesser Spirit"] = "附魔护腕 - 次级精神",
		["Enchant Bracer - Lesser Stamina"] = "附魔护腕 - 次级耐力",
		["Enchant Bracer - Lesser Strength"] = "附魔护腕 - 次级力量",
		["Enchant Bracer - Major Defense"] = "附魔护腕 - 特效防御",
		["Enchant Bracer - Major Intellect"] = "附魔护腕 - 特效智力",
		["Enchant Bracer - Mana Regeneration"] = "附魔护腕 - 法力回复",
		["Enchant Bracer - Minor Agility"] = "附魔护腕 - 初级敏捷",
		["Enchant Bracer - Minor Deflection"] = "附魔护腕 - 初级偏斜",
		["Enchant Bracer - Minor Health"] = "附魔护腕 - 初级生命",
		["Enchant Bracer - Minor Spirit"] = "附魔护腕 - 初级精神",
		["Enchant Bracer - Minor Stamina"] = "附魔护腕 - 初级耐力",
		["Enchant Bracer - Minor Strength"] = "附魔护腕 - 初级力量",
		["Enchant Bracer - Restore Mana Prime"] = "附魔护腕 - 优秀法力回复",
		["Enchant Bracer - Spellpower"] = "附魔护腕 - 法术能量",
		["Enchant Bracer - Spirit"] = "附魔护腕 - 精神",
		["Enchant Bracer - Stamina"] = "附魔护腕 - 耐力",
		["Enchant Bracer - Stats"] = "附魔护腕 - 属性",
		["Enchant Bracer - Strength"] = "附魔护腕 - 力量",
		["Enchant Bracer - Superior Healing"] = "附魔护腕 - 超强治疗",
		["Enchant Bracer - Superior Spirit"] = "附魔护腕 - 超强精神",
		["Enchant Bracer - Superior Stamina"] = "附魔护腕 - 超强耐力",
		["Enchant Bracer - Superior Strength"] = "附魔护腕 - 超强力量",
		["Enchant Chest - Exceptional Health"] = "附魔胸甲 - 杰出生命",
		["Enchant Chest - Exceptional Stats"] = "附魔胸甲 - 杰出属性",
		["Enchant Chest - Greater Health"] = "附魔胸甲 - 强效生命",
		["Enchant Chest - Greater Mana"] = "附魔胸甲 - 强效法力",
		["Enchant Chest - Greater Stats"] = "附魔胸甲 - 强效属性",
		["Enchant Chest - Health"] = "附魔胸甲 - 生命",
		["Enchant Chest - Lesser Absorption"] = "附魔胸甲 - 次级吸收",
		["Enchant Chest - Lesser Health"] = "附魔胸甲 - 次级生命",
		["Enchant Chest - Lesser Mana"] = "附魔胸甲 - 次级法力",
		["Enchant Chest - Lesser Stats"] = "附魔胸甲 - 次级状态",
		["Enchant Chest - Major Health"] = "附魔胸甲 - 特效生命",
		["Enchant Chest - Major Mana"] = "附魔胸甲 - 特效法力",
		["Enchant Chest - Major Resilience"] = "附魔胸甲 - 特效韧性",
		["Enchant Chest - Major Spirit"] = "附魔胸甲 - 特效精神",
		["Enchant Chest - Mana"] = "附魔胸甲 - 法力",
		["Enchant Chest - Minor Absorption"] = "附魔胸甲 - 初级吸收",
		["Enchant Chest - Minor Health"] = "附魔胸甲 - 初级生命",
		["Enchant Chest - Minor Mana"] = "附魔胸甲 - 初级法力",
		["Enchant Chest - Minor Stats"] = "附魔胸甲 - 初级属性",
		["Enchant Chest - Restore Mana Prime"] = "附魔胸甲 - 优秀法力回复",
		["Enchant Chest - Stats"] = "附魔胸甲 - 状态",
		["Enchant Chest - Superior Health"] = "附魔胸甲 - 超强生命",
		["Enchant Chest - Superior Mana"] = "附魔胸甲 - 超强法力",
		["Enchant Cloak - Defense"] = "附魔披风 - 防御",
		["Enchant Cloak - Dodge"] = "附魔披风 - 躲闪",
		["Enchant Cloak - Fire Resistance"] = "附魔披风 - 火焰抗性",
		["Enchant Cloak - Greater Agility"] = "附魔披风 - 强效敏捷",
		["Enchant Cloak - Greater Arcane Resistance"] = "附魔披风 - 强效奥术抗性",
		["Enchant Cloak - Greater Defense"] = "附魔披风 - 强效防御",
		["Enchant Cloak - Greater Fire Resistance"] = "附魔披风 - 强效火焰抗性",
		["Enchant Cloak - Greater Nature Resistance"] = "附魔披风 - 强效自然抗性",
		["Enchant Cloak - Greater Resistance"] = "附魔披风 - 强效抗性",
		["Enchant Cloak - Greater Shadow Resistance"] = "附魔披风 - 强效暗影抗性",
		["Enchant Cloak - Lesser Agility"] = "附魔披风 - 次级敏捷",
		["Enchant Cloak - Lesser Fire Resistance"] = "附魔披风 - 次级火焰抗性",
		["Enchant Cloak - Lesser Protection"] = "附魔披风 - 次级防护",
		["Enchant Cloak - Lesser Shadow Resistance"] = "附魔披风 - 次级暗影抵抗",
		["Enchant Cloak - Major Armor"] = "附魔披风 - 特效护甲",
		["Enchant Cloak - Major Resistance"] = "附魔披风 - 特效抗性",
		["Enchant Cloak - Minor Agility"] = "附魔披风 - 初级敏捷",
		["Enchant Cloak - Minor Protection"] = "附魔披风 - 初级防护",
		["Enchant Cloak - Minor Resistance"] = "附魔披风 - 初级抗性",
		["Enchant Cloak - Resistance"] = "附魔披风 - 抗性",
		["Enchant Cloak - Spell Penetration"] = "附魔披风 - 法术穿透",
		["Enchant Cloak - Stealth"] = "附魔披风 - 潜行",
		["Enchant Cloak - Subtlety"] = "附魔披风 - 狡诈",
		["Enchant Cloak - Superior Defense"] = "附魔披风 - 超强防御",
		["Enchant Gloves - Advanced Herbalism"] = "附魔手套 - 高级草药学",
		["Enchant Gloves - Advanced Mining"] = "附魔手套 - 高级采矿",
		["Enchant Gloves - Agility"] = "附魔手套 - 敏捷",
		["Enchant Gloves - Assault"] = "附魔手套 - 突袭",
		["Enchant Gloves - Blasting"] = "附魔手套 - 冲击",
		["Enchant Gloves - Fire Power"] = "附魔手套 - 火焰能量",
		["Enchant Gloves - Fishing"] = "附魔手套 - 钓鱼",
		["Enchant Gloves - Frost Power"] = "附魔手套 - 冰霜能量",
		["Enchant Gloves - Greater Agility"] = "附魔手套 - 强效敏捷",
		["Enchant Gloves - Greater Strength"] = "附魔手套 - 强效力量",
		["Enchant Gloves - Healing Power"] = "附魔手套 - 治疗能量",
		["Enchant Gloves - Herbalism"] = "附魔手套 - 草药学",
		["Enchant Gloves - Major Healing"] = "附魔手套 - 特效治疗",
		["Enchant Gloves - Major Spellpower"] = "附魔手套 - 特效法术能量",
		["Enchant Gloves - Major Strength"] = "附魔手套 - 特效力量",
		["Enchant Gloves - Mining"] = "附魔手套 - 采矿",
		["Enchant Gloves - Minor Haste"] = "附魔手套 - 初级加速",
		["Enchant Gloves - Riding Skill"] = "附魔手套 - 骑乘",
		["Enchant Gloves - Shadow Power"] = "附魔手套 - 暗影能量",
		["Enchant Gloves - Skinning"] = "附魔手套 - 剥皮",
		["Enchant Gloves - Spell Strike"] = "附魔手套 - 法术打击",
		["Enchant Gloves - Strength"] = "附魔手套 - 力量",
		["Enchant Gloves - Superior Agility"] = "附魔手套 - 超强敏捷",
		["Enchant Gloves - Threat"] = "附魔手套 - 威胁",
		["Enchant Ring - Healing Power"] = "附魔戒指 - 治疗能量",
		["Enchant Ring - Spellpower"] = "附魔戒指 - 法术能量",
		["Enchant Ring - Stats"] = "附魔戒指 - 属性",
		["Enchant Ring - Striking"] = "附魔戒指 - 打击",
		["Enchant Shield - Frost Resistance"] = "附魔盾牌 - 冰霜抗性",
		["Enchant Shield - Greater Spirit"] = "附魔盾牌 - 强效精神",
		["Enchant Shield - Greater Stamina"] = "附魔盾牌 - 强效耐力",
		["Enchant Shield - Intellect"] = "附魔盾牌 - 智力",
		["Enchant Shield - Lesser Block"] = "附魔盾牌 - 次级格挡",
		["Enchant Shield - Lesser Protection"] = "附魔盾牌 - 次级防护",
		["Enchant Shield - Lesser Spirit"] = "附魔盾牌 - 次级精神",
		["Enchant Shield - Lesser Stamina"] = "附魔盾牌 - 次级耐力",
		["Enchant Shield - Major Stamina"] = "附魔盾牌 - 特效耐力",
		["Enchant Shield - Minor Stamina"] = "附魔盾牌 - 初级耐力",
		["Enchant Shield - Resistance"] = "附魔盾牌 - 抗性",
		["Enchant Shield - Shield Block"] = "附魔盾牌 - 盾牌格挡",
		["Enchant Shield - Spirit"] = "附魔盾牌 - 精神",
		["Enchant Shield - Stamina"] = "附魔盾牌 - 耐力",
		["Enchant Shield - Superior Spirit"] = "附魔盾牌 - 超强精神",
		["Enchant Shield - Resilience"] = "附魔盾牌 - 韧性",
		["Enchant Shield - Tough Shield"] = "附魔盾牌 - 坚韧盾牌",
		["Enchant Weapon - Agility"] = "附魔武器 - 敏捷",
		["Enchant Weapon - Battlemaster"] = "附魔武器 - 作战专家",
		["Enchant Weapon - Crusader"] = "附魔武器 - 十字军",
		["Enchant Weapon - Demonslaying"] = "附魔武器 - 屠魔",
		["Enchant Weapon - Executioner"] = "附魔武器 - 斩杀",
		["Enchant Weapon - Fiery Weapon"] = "附魔武器 - 烈焰",
		["Enchant Weapon - Greater Agility"] = "附魔武器 - 强效敏捷",
		["Enchant Weapon - Greater Striking"] = "附魔武器 - 强效攻击",
		["Enchant Weapon - Healing Power"] = "附魔武器 - 治疗能量",
		["Enchant Weapon - Icy Chill"] = "附魔武器 - 冰寒",
		["Enchant Weapon - Lesser Beastslayer"] = "附魔武器 - 次级屠兽",
		["Enchant Weapon - Lesser Elemental Slayer"] = "附魔武器 - 次级元素杀手",
		["Enchant Weapon - Lesser Striking"] = "附魔武器 - 次级攻击",
		["Enchant Weapon - Lifestealing"] = "附魔武器 - 生命偷取",
		["Enchant Weapon - Major Healing"] = "附魔武器 - 特效治疗",
		["Enchant Weapon - Major Intellect"] = "附魔武器 - 特效智力",
		["Enchant Weapon - Major Spellpower"] = "附魔武器 - 特效法术能量",
		["Enchant Weapon - Major Striking"] = "附魔武器 - 特效打击",
		["Enchant Weapon - Mighty Intellect"] = "附魔武器 - 强效智力",
		["Enchant Weapon - Mighty Spirit"] = "附魔武器 - 强效精神",
		["Enchant Weapon - Minor Beastslayer"] = "附魔武器 - 初级屠兽",
		["Enchant Weapon - Minor Striking"] = "附魔武器 - 初级攻击",
		["Enchant Weapon - Mongoose"] = "附魔武器 - 猫鼬",
		["Enchant Weapon - Potency"] = "附魔武器 - 力量",
		["Enchant Weapon - Soulfrost"] = "附魔武器 - 魂霜",
		["Enchant Weapon - Spell Power"] = "附魔武器 - 法术能量",
		["Enchant Weapon - Spellsurge"] = "附魔武器 - 魔法激荡",
		["Enchant Weapon - Strength"] = "附魔武器 - 力量",
		["Enchant Weapon - Striking"] = "附魔武器 - 攻击",
		["Enchant Weapon - Sunfire"] = "附魔武器 - 阳炎",
		["Enchant Weapon - Superior Striking"] = "附魔武器 - 超强打击",
		["Enchant Weapon - Unholy Weapon"] = "附魔武器 - 邪恶武器",
		["Enchant Weapon - Winter's Might"] = "附魔武器 - 寒冬之力",
		["Enchanted Leather"] = "魔化皮",
		["Enchanted Thorium"] = "魔化瑟银",
		["Greater Magic Wand"] = "强效魔法杖",
		["Greater Mystic Wand"] = "强效秘法杖",
		["Large Prismatic Shard"] = "大块棱光碎片",
		["Lesser Magic Wand"] = "次级魔法杖",
		["Lesser Mana Oil"] = "次级法力之油",
		["Lesser Mystic Wand"] = "次级秘法魔杖",
		["Lesser Wizard Oil"] = "次级巫师之油",
		["Minor Mana Oil"] = "初级法力之油",
		["Minor Wizard Oil"] = "初级巫师之油",
		["Nexus Transformation"] = "转化连结水晶",
		["Prismatic Sphere"] = "棱光之球",
		["Runed Adamantite Rod"] = "符文精金棒",
		["Runed Arcanite Rod"] = "符文奥金棒",
		["Runed Copper Rod"] = "符文铜棒",
		["Runed Eternium Rod"] = "符文恒金棒",
		["Runed Fel Iron Rod"] = "符文魔铁棒",
		["Runed Golden Rod"] = "符文金棒",
		["Runed Silver Rod"] = "符文银棒",
		["Runed Truesilver Rod"] = "符文真银棒",
		["Small Prismatic Shard"] = "小块棱光碎片",
		["Smoking Heart of the Mountain"] = "浓烟山脉之心",
		["Superior Mana Oil"] = "超级法力之油",
		["Superior Wizard Oil"] = "超级巫师之油",
		["Void Sphere"] = "虚空之球",
		["Wizard Oil"] = "巫师之油",

-- Engineering Recipes
		["Accurate Scope"] = "精确瞄准镜",
		["Adamantite Arrow Maker"] = "精金制箭器",
		["Adamantite Frame"] = "精金框架",
		["Adamantite Grenade"] = "精金手雷",
		["Adamantite Rifle"] = "精金步枪",
		["Adamantite Scope"] = "精金瞄准镜",
		["Adamantite Shell Machine"] = "精金制弹机",
		["Advanced Target Dummy"] = "高级假人",
		["Alarm-O-Bot"] = "报警机器人",
		["Aquadynamic Fish Attractor"] = "水下诱鱼器",
		["Arcane Bomb"] = "奥术炸弹",
		["Arcanite Dragonling"] = "奥金机械幼龙",
		["Arclight Spanner"] = "扳手",
		["Big Bronze Bomb"] = "重磅青铜炸弹",
		["Big Iron Bomb"] = "重磅铁制炸弹",
		["Biznicks 247x128 Accurascope"] = "比兹尼克247x128精确瞄准镜",
		["Bloodvine Goggles"] = "血藤护目镜",
		["Bloodvine Lens"] = "血藤透镜",
		["Blue Firework"] = "蓝色焰火",
		["Blue Rocket Cluster"] = "蓝色烟花束",
		["Bright-Eye Goggles"] = "增亮护目镜",
		["Bronze Framework"] = "青铜框架",
		["Bronze Tube"] = "青铜管",
		["Catseye Ultra Goggles"] = "猫眼超级护目镜",
		["Coarse Blasting Powder"] = "粗制火药粉",
		["Coarse Dynamite"] = "劣质炸药",
		["Cogspinner Goggles"] = "旋轮护目镜",
		["Compact Harvest Reaper Kit"] = "联合收割机组件",
		["Copper Modulator"] = "铜质调节器",
		["Copper Tube"] = "铜管",
		["Core Marksman Rifle"] = "火核狙击步枪",
		["Crafted Heavy Shot"] = "精制重弹丸",
		["Crafted Light Shot"] = "精制轻弹丸",
		["Crafted Solid Shot"] = "精制实心弹丸",
		["Craftsman's Monocle"] = "工匠眼镜",
		["Crashin' Thrashin' Robot"] = "打架机器人",
		["Crude Scope"] = "粗制瞄准镜",
		["Dark Iron Bomb"] = "黑铁炸弹",
		["Dark Iron Rifle"] = "黑铁步枪",
		["Deadly Blunderbuss"] = "致命的短枪",
		["Deadly Scope"] = "致命瞄准镜",
		["Deathblow X11 Goggles"] = "死亡一击护目镜X11型",
		["Deepdive Helmet"] = "潜水头盔",
		["Delicate Arcanite Converter"] = "精密奥金转换器",
		["Dense Blasting Powder"] = "致密炸药粉",
		["Dense Dynamite"] = "致密炸弹",
		["Destruction Holo-gogs"] = "毁灭全视护目镜",
		["Dimensional Ripper - Area 52"] = "空间撕裂器 - 52区",
		["Dimensional Ripper - Everlook"] = "空间撕裂器 - 永望镇",
		["Discombobulator Ray"] = "退化射线",
		["Elemental Blasting Powder"] = "元素炸药粉",
		["Elemental Seaforium Charge"] = "元素爆盐炸弹",
		["Explosive Sheep"] = "自爆绵羊",
		["EZ-Thro Dynamite II"] = "简易投掷炸弹II",
		["EZ-Thro Dynamite"] = "简易投掷炸弹",
		["Fel Iron Bomb"] = "魔铁炸弹",
		["Fel Iron Casing"] = "魔铁外壳",
		["Fel Iron Musket"] = "魔铁步枪",
		["Fel Iron Shells"] = "魔铁弹丸",
		["Fel Iron Toolbox"] = "魔铁工具箱",
		["Felsteel Boomstick"] = "魔钢火枪",
		["Felsteel Stabilizer"] = "魔钢稳定器",
		["Field Repair Bot 110G"] = "战地修理机器人 110G",
		["Field Repair Bot 74A"] = "修理机器人74A型",
		["Fire Goggles"] = "火焰护目镜",
		["Firework Cluster Launcher"] = "烟花束发射器",
		["Firework Launcher"] = "烟花发射器",
		["Flame Deflector"] = "火焰偏斜器",
		["Flash Bomb"] = "闪光雷",
		["Flawless Arcanite Rifle"] = "完美的奥金步枪",
		["Flying Machine"] = "飞行器",
		["Flying Tiger Goggles"] = "飞虎护目镜",
		["Force Reactive Disk"] = "力反馈盾牌",
		["Foreman's Enchanted Helmet"] = "工头的附魔头盔",
		["Foreman's Reinforced Helmet"] = "工头的加固头盔",
		["Frost Grenades"] = "冰霜手雷",
		["Furious Gizmatic Goggles"] = "狂野机械护目镜",
		["Fused Wiring"] = "保险丝",
		["Gadgetstorm Goggles"] = "齿轮风暴护目镜",
		["Gnomish Battle Chicken"] = "侏儒作战小鸡",
		["Gnomish Battle Goggles"] = "侏儒作战护目镜",
		["Gnomish Cloaking Device"] = "侏儒隐形装置",
		["Gnomish Death Ray"] = "侏儒死亡射线",
		["Gnomish Flame Turret"] = "侏儒喷火炮台",
		["Gnomish Goggles"] = "侏儒护目镜",
		["Gnomish Harm Prevention Belt"] = "侏儒防护腰带",
		["Gnomish Mind Control Cap"] = "侏儒洗脑帽",
		["Gnomish Net-o-Matic Projector"] = "侏儒撒网器",
		["Gnomish Poultryizer"] = "侏儒变鸡器",
		["Gnomish Power Goggles"] = "侏儒能量护目镜",
		["Gnomish Rocket Boots"] = "侏儒火箭靴",
		["Gnomish Shrink Ray"] = "侏儒缩小射线",
		["Gnomish Universal Remote"] = "侏儒通用遥控器",
		["Goblin Bomb Dispenser"] = "地精炸弹箱",
		["Goblin Construction Helmet"] = "地精施工头盔",
		["Goblin Dragon Gun"] = "地精龙枪",
		["Goblin Jumper Cables XL"] = "地精起搏器XL型",
		["Goblin Jumper Cables"] = "地精起搏器",
		["Goblin Land Mine"] = "地精暗雷",
		["Goblin Mining Helmet"] = "地精采矿头盔",
		["Goblin Mortar"] = "地精迫击炮",
		["Goblin Rocket Boots"] = "地精火箭靴",
		["Goblin Rocket Fuel Recipe"] = "地精火箭燃油配方",
		["Goblin Rocket Helmet"] = "地精火箭头盔",
		["Goblin Rocket Launcher"] = "地精火箭发射器",
		["Goblin Sapper Charge"] = "地精工兵炸药",
		["Gold Power Core"] = "黄金能量核心",
		["Green Firework"] = "绿色焰火",
		["Green Lens"] = "绿色透镜",
		["Green Rocket Cluster"] = "绿色烟花束",
		["Green Smoke Flare"] = "绿色烟幕弹",
		["Green Tinted Goggles"] = "绿色护目镜",
		["Gyro-balanced Khorium Destroyer"] = "陀螺平衡氪金重枪",
		["Gyrochronatom"] = "发条式同步协调陀螺仪",
		["Gyrofreeze Ice Reflector"] = "寒冰偏斜器",
		["Gyromatic Micro-Adjustor"] = "侏儒微调器",
		["Handful of Copper Bolts"] = "一把螺栓",
		["Handful of Fel Iron Bolts"] = "魔铁螺丝",
		["Hardened Adamantite Tube"] = "硬化精金管",
		["Healing Potion Injector"] = "治疗药水注射器",
		["Heavy Blasting Powder"] = "烈性火药",
		["Heavy Dynamite"] = "烈性炸药",
		["Hi-Explosive Bomb"] = "高爆炸弹",
		["Hi-Impact Mithril Slugs"] = "高速秘银弹头",
		["Hyper-Radiant Flame Reflector"] = "高辐射烈焰反射器",
		["Hyper-Vision Goggles"] = "超视距护目镜",
		["Ice Deflector"] = "寒冰偏斜器",
		["Icy Blasting Primers"] = "冰霜冲击雷管",
		["Inlaid Mithril Cylinder Plans"] = "秘银杆设计图",
		["Iron Grenade"] = "铁皮手雷",
		["Iron Strut"] = "铁棒",
		["Justicebringer 2000 Specs"] = "审判者护目镜2000型",
		["Khorium Power Core"] = "氪金能量核心",
		["Khorium Scope"] = "氪金瞄准镜",
		["Large Blue Rocket Cluster"] = "大型蓝色烟花束",
		["Large Blue Rocket"] = "大型蓝色烟花",
		["Large Copper Bomb"] = "大型铜壳炸弹",
		["Large Green Rocket Cluster"] = "大型绿色烟花束",
		["Large Green Rocket"] = "大型绿色烟花",
		["Large Red Rocket Cluster"] = "大型红色烟花束",
		["Large Red Rocket"] = "大型红色烟花",
		["Large Seaforium Charge"] = "大型爆盐炸弹",
		["Lifelike Mechanical Toad"] = "仿真机械蛙",
		["Lil' Smoky"] = "发条娃娃",
		["Living Replicator Specs"] = "活力复制器",
		["Lovingly Crafted Boomstick"] = "精致手工火枪",
		["Magnified Moon Specs"] = "月光放大护目镜",
		["Major Recombobulator"] = "强力净化器",
		["Mana Potion Injector"] = "法力药水注射器",
		["Master Engineer's Goggles"] = "高级技师护目镜",
		["Masterwork Target Dummy"] = "高级活动假人",
		["Mechanical Dragonling"] = "机械幼龙",
		["Mechanical Repair Kit"] = "机械修理包",
		["Mechanical Squirrel"] = "机械松鼠",
		["Minor Recombobulator"] = "自动净化装置",
		["Mithril Blunderbuss"] = "秘银火枪",
		["Mithril Casing"] = "秘银外壳",
		["Mithril Frag Bomb"] = "秘银破片炸弹",
		["Mithril Gyro-Shot"] = "秘银螺旋弹",
		["Mithril Heavy-bore Rifle"] = "大口径秘银步枪",
		["Mithril Mechanical Dragonling"] = "秘银机械幼龙",
		["Mithril Tube"] = "秘银管",
		["Moonsight Rifle"] = "夜视步枪",
		["Nigh-Invulnerability Belt"] = "近似无敌腰带",
		["Ornate Khorium Rifle"] = "精制氪金步枪",
		["Ornate Spyglass"] = "精制望远镜",
		["Parachute Cloak"] = "降落伞披风",
		["Pet Bombling"] = "炸弹宠物",
		["Portable Bronze Mortar"] = "便携式青铜迫击炮",
		["Power Amplification Goggles"] = "能量放大护目镜",
		["Powerful Seaforium Charge"] = "强力爆盐炸弹",
		["Powerheal 4000 Lens"] = "超级治疗射线4000型",
		["Practice Lock"] = "练习锁",
		["Purple Smoke Flare"] = "紫色烟幕弹",
		["Red Firework"] = "红色焰火",
		["Red Rocket Cluster"] = "红色烟花束",
		["Rocket Boots Xtreme"] = "超级火箭靴",
		["Rose Colored Goggles"] = "玫瑰色护目镜",
		["Rough Blasting Powder"] = "劣质火药",
		["Rough Boomstick"] = "劣质火枪",
		["Rough Copper Bomb"] = "劣质铜壳炸弹",
		["Rough Dynamite"] = "劣质炸药",
		["Salt Shaker"] = "筛盐器",
		["Shadow Goggles"] = "暗影护目镜",
		["Silver Contact"] = "银触媒",
		["Silver-plated Shotgun"] = "镀银猎枪",
		["Small Blue Rocket"] = "小型蓝色烟花",
		["Small Bronze Bomb"] = "小型青铜炸弹",
		["Small Green Rocket"] = "小型绿色烟花",
		["Small Red Rocket"] = "小型红色烟花",
		["Small Seaforium Charge"] = "小型爆盐炸弹",
		["Snake Burst Firework"] = "长蛇焰火",
		["Sniper Scope"] = "狙击瞄准镜",
		["SnowMaster 9000"] = "雪王9000型",
		["Solid Blasting Powder"] = "实心炸药",
		["Solid Dynamite"] = "实心炸弹",
		["Spellpower Goggles Xtreme Plus"] = "法术能量护目镜超级改良版",
		["Spellpower Goggles Xtreme"] = "法术能量护目镜超级版",
		["Stabilized Eternium Scope"] = "稳定恒金瞄准镜",
		["Standard Scope"] = "普通瞄准镜",
		["Steam Tonk Controller"] = "蒸汽车控制器",
		["Super Sapper Charge"] = "超级神风炸药",
		["Surestrike Goggles v2.0"] = "必中护目镜V2.0",
		["Tankatronic Goggles"] = "坦克眼镜",
		["Target Dummy"] = "活动假人",
		["The Big One"] = "大炸弹",
		["The Bigger One"] = "更大的炸弹",
		["The Mortar: Reloaded"] = "迫击炮：重载",
		["Thorium Grenade"] = "瑟银手榴弹",
		["Thorium Rifle"] = "瑟银火枪",
		["Thorium Shells"] = "瑟银弹",
		["Thorium Tube"] = "瑟银管",
		["Thorium Widget"] = "瑟银零件",
		["Tranquil Mechanical Yeti"] = "安静的机械雪人",
		["Truesilver Transformer"] = "真银变压器",
		["Turbo-Charged Flying Machine"] = "涡轮加速飞机",
		["Ultra-Flash Shadow Reflector"] = "快速暗影反射器",
		["Ultrasafe Transporter - Gadgetzan"] = "安全传送器 - 加基森",
		["Ultrasafe Transporter - Toshley's Station"] = "超级安全传送器：托什雷的基地",
		["Ultra-Spectropic Detection Goggles"] = "超光谱侦测护目镜",
		["Unstable Trigger"] = "不牢固的扳机",
		["Voice Amplification Modulator"] = "语音增强模组",
		["Whirring Bronze Gizmo"] = "高速青铜齿轮",
		["White Smoke Flare"] = "白色烟幕弹",
		["Wonderheal XT40 Shades"] = "奇迹治疗罩XT40型",
		["World Enlarger"] = "世界放大器",
		["Zapthrottle Mote Extractor"] = "气阀微粒提取器",


-- First Aid Recipes
		["Anti-Venom"] = "抗毒药剂",
		["Heavy Linen Bandage"] = "厚亚麻绷带",
		["Heavy Mageweave Bandage"] = "厚魔纹绷带",
		["Heavy Netherweave Bandage"] = "厚灵纹布绷带",
		["Heavy Runecloth Bandage"] = "厚符文布绷带",
		["Heavy Silk Bandage"] = "厚丝质绷带",
		["Heavy Wool Bandage"] = "厚绒线绷带",
		["Linen Bandage"] = "亚麻绷带",
		["Mageweave Bandage"] = "魔纹绷带",
		["Netherweave Bandage"] = "灵纹布绷带",
		["Powerful Anti-Venom"] = "特效抗毒药剂",
		["Runecloth Bandage"] = "符文布绷带",
		["Silk Bandage"] = "丝质绷带",
		["Strong Anti-Venom"] = "强力抗毒药剂",
		["Wool Bandage"] = "绒线绷带",

-- Jewelcrafting Recipes
		["Amulet of the Moon"] = "月之护符",
		["Aquamarine Pendant of the Warrior"] = "战士之绿玉坠饰",
		["Aquamarine Signet"] = "青绿石徽记",
		["Arcane Khorium Band"] = "奥法氪金指环",
		["Azure Moonstone Ring"] = "碧月石指环",
		["Balanced Nightseye"] = "平衡夜目石",
		["Balanced Shadowsong Amethyst"] = "平衡影歌紫玉",
		["Balanced Shadow Draenite"] = "平衡德拉诺影钻",
		["Band of Natural Fire"] = "自然火焰指环",
		["Barbaric Iron Collar"] = "野蛮铁项圈",
		["Blazing Citrine Ring"] = "闪耀黄水晶之戒",
		["Blazing Eternium Band"] = "闪耀恒金指环",
		["Blood of Amber"] = "琥珀之血",
		["Bold Blood Garnet"] = "朴素血榴石",
		["Bold Crimson Spinel"] = "朴素赤尖石",
		["Bold Living Ruby"] = "朴素红曜石",
		["Bracing Earthstorm Diamond"] = "鼓舞之大地风暴钻石",
		["Braided Copper Ring"] = "铜丝戒指",
		["Braided Eternium Chain"] = "恒金饰链",
		["Bright Blood Garnet"] = "明亮血榴石",
		["Bright Crimson Spinel"] = "明亮赤尖石",
		["Bright Living Ruby"] = "明亮红曜石",
		["Brilliant Dawnstone"] = "闪耀黎明石",
		["Brilliant Golden Draenite"] = "闪耀德拉诺金钻",
		["Brilliant Lionseye"] = "闪耀狮眼石",
		["Brilliant Necklace"] = "魔光项链",
		["Brilliant Pearl Band"] = "耀眼的珍珠戒指",
		["Bronze Band of Force"] = "力量之青铜指环",
		["Bronze Setting"] = "青铜底座",
		["Bronze Torc"] = "青铜饰环",
		["Brutal Earthstorm Diamond"] = "蛮力之大地风暴钻石",
		["Chain of the Twilight Owl"] = "夜枭之链",
		["Chaotic Skyfire Diamond"] = "混乱之天火钻石",
		["Circlet of Arcane Might"] = "奥法能量头饰",
		["Citrine Pendant of Golden Healing"] = "金色治疗之黄水晶坠饰",
		["Citrine Ring of Rapid Healing"] = "迅疾治疗之黄水晶戒指",
		["Coarse Stone Statue"] = "粗糙石像",
		["Coronet of the Verdant Flame"] = "翠绿火焰宝冠",
		["Crimson Sun"] = "血色残阳",
		["Crown of the Sea Witch"] = "海巫之冠",
		["Dazzling Deep Peridot"] = "眩光翠榄石",
		["Dazzling Seaspray Emerald"] = "眩光海浪翡翠",
		["Dazzling Talasite"] = "眩光水玉",
		["Delicate Blood Garnet"] = "精致血榴石",
		["Delicate Copper Wire"] = "精巧的铜线",
		["Delicate Crimson Spinel"] = "精致赤尖石",
		["Delicate Eternium Ring"] = "精致恒金戒指",
		["Delicate Living Ruby"] = "精致红曜石",
		["Dense Stone Statue"] = "厚重石像",
		["Destructive Skyfire Diamond"] = "毁灭之天火钻石",
		["Diamond Focus Ring"] = "钻石专注戒指",
		["Don Julio's Heart"] = "胡里奥之心",
		["Elegant Silver Ring"] = "优雅的银戒指",
		["Embrace of the Dawn"] = "黎明的拥抱",
		["Emerald Crown of Destruction"] = "毁灭之翡翠王冠",
		["Emerald Lion Ring"] = "翡翠狮王戒指",
		["Enduring Deep Peridot"] = "坚硬翠榄石",
		["Enduring Seaspray Emerald"] = "坚硬海浪翡翠",
		["Enduring Talasite"] = "坚硬水玉",
		["Engraved Truesilver Ring"] = "蚀刻真银戒指",
		["Enigmatic Skyfire Diamond"] = "神秘之天火钻石",
		["Eye of the Night"] = "夜晚之眼",
		["Facet of Eternity"] = "永恒之钻",
		["Falling Star"] = "坠星石",
		["Fel Iron Blood Ring"] = "魔铁血戒",
		["Figurine - Black Diamond Crab"] = "雕像 - 黑钻石螃蟹",
		["Figurine - Black Pearl Panther"] = "雕像 - 黑珍珠猎豹",
		["Figurine - Dark Iron Scorpid"] = "雕像 - 黑铁蝎",
		["Figurine - Dawnstone Crab"] = "雕像 - 黎明石螃蟹",
		["Figurine - Emerald Owl"] = "雕像 - 翡翠猫头鹰",
		["Figurine - Felsteel Boar"] = "雕像 - 魔钢野猪",
		["Figurine - Golden Hare"] = "雕像 - 金兔",
		["Figurine - Jade Owl"] = "雕像 - 碧玉猫头鹰",
		["Figurine - Living Ruby Serpent"] = "雕像 - 红曜石毒蛇",
		["Figurine - Nightseye Panther"] = "雕像 - 夜目石猎豹",
		["Figurine - Ruby Serpent"] = "雕像 - 红宝石蛇",
		["Figurine - Talasite Owl"] = "雕像 - 水玉猫头鹰",
		["Figurine - Truesilver Boar"] = "雕像 - 真银野猪",
		["Figurine - Truesilver Crab"] = "雕像 - 真银螃蟹",
		["Flashing Crimson Spinel"] = "闪光赤尖石",
		["Flashing Living Ruby"] = "闪光红曜石",
		["Gem Studded Band"] = "宝石镶嵌指环",
		["Gleaming Dawnstone"] = "柔光黎明石",
		["Gleaming Golden Draenite"] = "柔光德拉诺金钻",
		["Gleaming Lionseye"] = "柔光狮眼石",
		["Glinting Flame Spessarite"] = "反光火榴石",
		["Glinting Noble Topaz"] = "反光黄晶玉",
		["Glinting Pyrestone"] = "反光焚石",
		["Gloom Band"] = "阴沉之戒",
		["Glowing Nightseye"] = "炽热夜目石",
		["Glowing Shadow Draenite"] = "炽热德拉诺影钻",
		["Glowing Shadowsong Amethyst"] = "炽热影歌紫玉",
		["Glowing Thorium Band"] = "光芒瑟银指环",
		["Golden Draenite Ring"] = "德拉诺金钻指环",
		["Golden Dragon Ring"] = "金色巨龙戒指",
		["Golden Ring of Power"] = "能量之黄金戒指",
		["Great Dawnstone"] = "巨型黎明石",
		["Great Golden Draenite"] = "巨型德拉诺金钻",
		["Great Lionseye"] = "巨型狮眼石",
		["Heavy Adamantite Ring"] = "重型精金戒指",
		["Heavy Copper Ring"] = "重型铜戒指",
		["Heavy Felsteel Ring"] = "重魔钢戒指",
		["Heavy Golden Necklace of Battle"] = "重型作战金项链",
		["Heavy Iron Knuckles"] = "重型铁拳套",
		["Heavy Jade Ring"] = "重型翡翠戒指",
		["Heavy Silver Ring"] = "重型银戒指",
		["Heavy Stone Statue"] = "沉重石像",
		["Infused Nightseye"] = "充能夜目石",
		["Infused Shadow Draenite"] = "充能德拉诺影钻",
		["Infused Shadowsong Amethyst"] = "充能影歌紫玉",
		["Inlaid Malachite Ring"] = "孔雀石镶饰戒指",
		["Inscribed Flame Spessarite"] = "铭文火榴石",
		["Inscribed Noble Topaz"] = "铭文黄晶玉",
		["Inscribed Pyrestone"] = "铭文焚石",
		["Insightful Earthstorm Diamond"] = "洞察之大地风暴钻石",
		["Jade Pendant of Blasting"] = "冲击之碧玉坠饰",
		["Jagged Deep Peridot"] = "裂纹翠榄石",
		["Jagged Seaspray Emerald"] = "裂纹海浪翡翠",
		["Jagged Talasite"] = "裂纹水玉",
		["Kailee's Rose"] = "凯蕾的玫瑰",
		["Khorium Band of Frost"] = "冰霜氪金指环",
		["Khorium Band of Leaves"] = "绿叶氪金指环",
		["Khorium Band of Shadows"] = "暗影氪金指环",
		["Khorium Inferno Band"] = "炼狱氪金指环",
		["Living Emerald Pendant"] = "绿曜石坠饰",
		["Living Ruby Pendant"] = "红曜石坠饰",
		["Luminous Flame Spessarite"] = "辉光火榴石",
		["Luminous Noble Topaz"] = "辉光黄晶玉",
		["Luminous Pyrestone"] = "辉光焚石",
		["Lustrous Azure Moonstone"] = "异彩碧月石",
		["Lustrous Empyrean Sapphire"] = "异彩天蓝宝石",
		["Lustrous Star of Elune"] = "异彩艾露恩之星",
		["Malachite Pendant"] = "孔雀石坠饰",
		["Mercurial Adamantite"] = "水银精金",
		["Mithril Filigree"] = "秘银丝",
		["Moonsoul Crown"] = "月魂王冠",
		["Mystic Dawnstone"] = "秘法黎明石",
		["Mystic Lionseye"] = "秘法狮眼石",
		["Mystical Skyfire Diamond"] = "秘法之天火钻石",
		["Necklace of the Deep"] = "深海项链",
		["Necklace of the Diamond Tower"] = "钻石之塔项链",
		["Onslaught Ring"] = "猛攻指环",
		["Opal Necklace of Impact"] = "冲击之猫眼石项链",
		["Ornate Tigerseye Necklace"] = "精制虎眼石项链",
		["Pendant of Frozen Flame"] = "冰冷烈焰坠饰",
		["Pendant of Shadow's End"] = "暗影终结坠饰",
		["Pendant of Thawing"] = "融雪坠饰",
		["Pendant of the Agate Shield"] = "玛瑙护盾坠饰",
		["Pendant of the Null Rune"] = "空洞符文坠饰",
		["Pendant of Withering"] = "凋零坠饰",
		["Potent Flame Spessarite"] = "高能火榴石",
		["Potent Noble Topaz"] = "高能黄晶玉",
		["Potent Pyrestone"] = "高能焚石",
		["Powerful Earthstorm Diamond"] = "强能之大地风暴钻石",
		["Purified Jaggal Pearl"] = "纯净裂纹珍珠",
		["Purified Shadow Pearl"] = "纯净暗影珍珠",
		["Radiant Deep Peridot"] = "辐光翠榄石",
		["Radiant Seaspray Emerald"] = "辐光海浪翡翠",
		["Radiant Talasite"] = "辐光水玉",
		["Red Ring of Destruction"] = "红色毁灭指环",
		["Relentless Earthstorm Diamond"] = "残酷之大地风暴钻石",
		["Rigid Dawnstone"] = "刚硬黎明石",
		["Rigid Golden Draenite"] = "刚硬德拉诺金钻",
		["Rigid Lionseye"] = "刚硬狮眼石",
		["Ring of Arcane Shielding"] = "奥术护盾指环",
		["Ring of Bitter Shadows"] = "苦痛暗影之戒",
		["Ring of Silver Might"] = "银色力量之戒",
		["Ring of Twilight Shadows"] = "暮色暗影之戒",
		["Rough Stone Statue"] = "劣质石像",
		["Royal Nightseye"] = "皇家夜目石",
		["Royal Shadow Draenite"] = "皇家德拉诺影钻",
		["Royal Shadowsong Amethyst"] = "皇家影歌紫玉",
		["Ruby Crown of Restoration"] = "恢复之红宝石王冠",
		["Ruby Pendant of Fire"] = "火焰之红宝石坠饰",
		["Runed Blood Garnet"] = "符文血榴石",
		["Runed Crimson Spinel"] = "符文赤尖石",
		["Runed Living Ruby"] = "符文红曜石",
		["Sapphire Pendant of Winter Night"] = "寒冬之蓝宝石坠饰",
		["Sapphire Signet"] = "蓝宝石徽记",
		["Shifting Nightseye"] = "狡诈夜目石",
		["Shifting Shadow Draenite"] = "狡诈德拉诺影钻",
		["Shifting Shadowsong Amethyst"] = "狡诈影歌紫玉",
		["Simple Opal Ring"] = "朴素的猫眼石戒指",
		["Simple Pearl Ring"] = "朴素的珍珠戒指",
		["Smooth Dawnstone"] = "圆润黎明石",
		["Smooth Golden Draenite"] = "圆润德拉诺金钻",
		["Smooth Lionseye"] = "圆润狮眼石",
		["Solid Azure Moonstone"] = "致密碧月石",
		["Solid Bronze Ring"] = "结实的青铜戒指",
		["Solid Empyrean Sapphire"] = "致密天蓝宝石",
		["Solid Star of Elune"] = "致密艾露恩之星",
		["Solid Stone Statue"] = "坚固石像",
		["Sovereign Nightseye"] = "统御夜目石",
		["Sovereign Shadow Draenite"] = "统御德拉诺影钻",
		["Sovereign Shadowsong Amethyst"] = "统御影歌紫玉",
		["Sparkling Azure Moonstone"] = "火花碧月石",
		["Sparkling Empyrean Sapphire"] = "火花天蓝宝石",
		["Sparkling Star of Elune"] = "火花艾露恩之星",
		["Steady Talasite"] = "稳固水玉",
		["Stone of Blades"] = "刀锋之石",
		["Stormy Azure Moonstone"] = "风暴碧月石",
		["Stormy Empyrean Sapphire"] = "风暴天蓝宝石",
		["Stormy Star of Elune"] = "风暴艾露恩之星",
		["Subtle Crimson Spinel"] = "诡秘赤尖石",
		["Subtle Living Ruby"] = "诡秘红曜石",
		["Swift Skyfire Diamond"] = "迅捷之天火钻石",
		["Teardrop Blood Garnet"] = "泪珠血榴石",
		["Teardrop Crimson Spinel"] = "泪珠赤尖石",
		["Teardrop Living Ruby"] = "泪珠红曜石",
		["Tenacious Earthstorm Diamond"] = "坚韧之大地风暴钻石",
		["The Aquamarine Ward"] = "青绿石屏障",
		["The Black Pearl"] = "黑色明珠",
		["The Frozen Eye"] = "冰霜之眼",
		["The Jade Eye"] = "翡翠之眼",
		["The Natural Ward"] = "自然屏障",
		["Thick Adamantite Necklace"] = "厚重精金项链",
		["Thick Bronze Necklace"] = "粗制青铜项链",
		["Thick Dawnstone"] = "厚重黎明石",
		["Thick Felsteel Necklace"] = "厚重魔钢项链",
		["Thick Golden Draenite"] = "厚重德拉诺金钻",
		["Thick Lionseye"] = "厚重狮眼石",
		["Thorium Setting"] = "瑟银底座",
		["Thundering Skyfire Diamond"] = "雷鸣之天火钻石",
		["Tigerseye Band"] = "虎眼指环",
		["Truesilver Commander's Ring"] = "真银指挥官之戒",
		["Truesilver Healing Ring"] = "真银治疗戒指",
		["Veiled Flame Spessarite"] = "隐秘火榴石",
		["Veiled Noble Topaz"] = "隐秘黄晶玉",
		["Veiled Pyrestone"] = "隐秘焚石",
		["Wicked Flame Spessarite"] = "邪恶火榴石",
		["Wicked Moonstone Ring"] = "邪恶月亮石戒指",
		["Wicked Noble Topaz"] = "邪恶黄晶玉",
		["Wicked Pyrestone"] = "邪恶焚石",
		["Woven Copper Ring"] = "铜纹戒指",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "奥术护甲片",
		["Bag of Many Hides"] = "大皮带",
		["Barbaric Belt"] = "野人腰带",
		["Barbaric Bracers"] = "野人护腕",
		["Barbaric Gloves"] = "野人手套",
		["Barbaric Harness"] = "野人背心",
		["Barbaric Leggings"] = "野人护腿",
		["Barbaric Shoulders"] = "野人护肩",
		["Belt of Deep Shadow"] = "深邃暗影腰带",
		["Belt of Natural Power"] = "自然力量腰带",
		["Belt of the Black Eagle"] = "黑鹰腰带",
		["Big Voodoo Cloak"] = "巫毒披风",
		["Big Voodoo Mask"] = "巫毒面具",
		["Big Voodoo Pants"] = "巫毒短裤",
		["Big Voodoo Robe"] = "巫毒长袍",
		["Bindings of Lightning Reflexes"] = "闪电反射护腕",
		["Black Dragonscale Boots"] = "黑色龙鳞战靴",
		["Black Dragonscale Breastplate"] = "黑色龙鳞胸甲",
		["Black Dragonscale Leggings"] = "黑色龙鳞护腿",
		["Black Dragonscale Shoulders"] = "黑色龙鳞护肩",
		["Black Whelp Cloak"] = "黑色雏龙披风",
		["Black Whelp Tunic"] = "黑色雏龙外衣",
		["Blackstorm Leggings"] = "黑色风暴护腿",
		["Blastguard Belt"] = "爆炸防护腰带",
		["Blastguard Boots"] = "爆炸防护长靴",
		["Blastguard Pants"] = "爆炸防护短裤",
		["Blood Tiger Breastplate"] = "血虎胸甲",
		["Blood Tiger Shoulders"] = "血虎护肩",
		["Blue Dragonscale Breastplate"] = "蓝龙鳞片胸甲",
		["Blue Dragonscale Leggings"] = "蓝龙鳞片护腿",
		["Blue Dragonscale Shoulders"] = "蓝龙鳞片护肩",
		["Boots of Natural Grace"] = "自然优雅之靴",
		["Boots of Shackled Souls"] = "束缚灵魂长靴",
		["Boots of the Crimson Hawk"] = "赤鹰之靴",
		["Boots of Utter Darkness"] = "绝对黑暗之靴",
		["Bracers of Renewed Life"] = "新生护腕",
		["Bracers of Shackled Souls"] = "束缚灵魂护腕",
		["Bramblewood Belt"] = "荆木腰带",
		["Bramblewood Boots"] = "荆木长靴",
		["Bramblewood Helm"] = "荆木头盔",
		["Chimeric Boots"] = "奇美拉长靴",
		["Chimeric Gloves"] = "奇美拉手套",
		["Chimeric Leggings"] = "奇美拉护腿",
		["Chimeric Vest"] = "奇美拉外衣",
		["Chromatic Cloak"] = "多彩披风",
		["Chromatic Gauntlets"] = "多彩护手",
		["Clefthide Leg Armor"] = "裂蹄腿甲片",
		["Cloak of Darkness"] = "黑暗披风",
		["Cobrahide Leg Armor"] = "眼镜蛇皮腿甲片",
		["Cobrascale Gloves"] = "眼镜蛇鳞片手套",
		["Cobrascale Hood"] = "眼镜蛇鳞片兜帽",
		["Comfortable Insoles"] = "鞋垫",
		["Comfortable Leather Hat"] = "舒适的皮帽",
		["Core Armor Kit"] = "熔火护甲片",
		["Corehound Belt"] = "熔火犬皮腰带",
		["Corehound Boots"] = "熔岩犬皮靴",
		["Cured Heavy Hide"] = "熟化重毛皮",
		["Cured Light Hide"] = "熟化轻毛皮",
		["Cured Medium Hide"] = "熟化中毛皮",
		["Cured Rugged Hide"] = "熟化毛皮",
		["Cured Thick Hide"] = "熟化厚毛皮",
		["Dark Leather Belt"] = "黑皮腰带",
		["Dark Leather Boots"] = "黑皮战靴",
		["Dark Leather Cloak"] = "黑皮披风",
		["Dark Leather Gloves"] = "黑皮手套",
		["Dark Leather Pants"] = "黑皮短裤",
		["Dark Leather Shoulders"] = "黑皮护肩",
		["Dark Leather Tunic"] = "黑皮外套",
		["Dawn Treaders"] = "黎明皮靴",
		["Deviate Scale Belt"] = "蛇鳞腰带",
		["Deviate Scale Cloak"] = "蛇鳞披风",
		["Deviate Scale Gloves"] = "蛇鳞手套",
		["Devilsaur Gauntlets"] = "魔暴龙皮手套",
		["Devilsaur Leggings"] = "魔暴龙皮护腿",
		["Dragonscale Breastplate"] = "龙鳞胸甲",
		["Dragonscale Gauntlets"] = "龙鳞护手",
		["Dragonstrike Leggings"] = "龙击护腿",
		["Dreamscale Breastplate"] = "梦幻龙鳞胸甲",
		["Drums of Battle"] = "战斗之鼓",
		["Drums of Panic"] = "恐慌之鼓",
		["Drums of Restoration"] = "恢复之鼓",
		["Drums of Speed"] = "速度之鼓",
		["Drums of War"] = "战争之鼓",
		["Dusky Belt"] = "暗色皮带",
		["Dusky Boots"] = "暗色长靴",
		["Dusky Bracers"] = "暗色护腕",
		["Dusky Leather Armor"] = "暗色皮甲",
		["Dusky Leather Leggings"] = "暗色皮护腿",
		["Earthen Leather Shoulders"] = "土灵皮护肩",
		["Earthen Netherscale Boots"] = "土灵虚鳞长靴",
		["Ebon Netherscale Belt"] = "黑色虚鳞腰带",
		["Ebon Netherscale Bracers"] = "黑色虚鳞护腕",
		["Ebon Netherscale Breastplate"] = "黑色虚鳞胸甲",
		["Embossed Leather Boots"] = "雕花皮靴",
		["Embossed Leather Cloak"] = "雕花皮质披风",
		["Embossed Leather Gloves"] = "雕花皮手套",
		["Embossed Leather Pants"] = "雕花皮短裤",
		["Embossed Leather Vest"] = "雕花皮外衣",
		["Enchanted Clefthoof Boots"] = "魔化裂蹄长靴",
		["Enchanted Clefthoof Gloves"] = "魔化裂蹄手套",
		["Enchanted Clefthoof Leggings"] = "魔化裂蹄护腿",
		["Enchanted Felscale Boots"] = "魔化邪鳞长靴",
		["Enchanted Felscale Gloves"] = "魔化邪鳞手套",
		["Enchanted Felscale Leggings"] = "魔化邪鳞护腿",
		["Feathered Breastplate"] = "羽饰胸甲",
		["Fel Leather Boots"] = "魔能皮甲长靴",
		["Fel Leather Gloves"] = "魔能皮甲手套",
		["Fel Leather Leggings"] = "魔能皮甲护腿",
		["Felscale Boots"] = "魔鳞长靴",
		["Felscale Breastplate"] = "魔鳞胸甲",
		["Felscale Gloves"] = "魔鳞手套",
		["Felscale Pants"] = "魔鳞短裤",
		["Felstalker Belt"] = "魔能猎手腰带",
		["Felstalker Bracer"] = "魔能猎手护腕",
		["Felstalker Breastplate"] = "魔能猎手胸甲",
		["Fine Leather Belt"] = "优质皮带",
		["Fine Leather Boots"] = "优质皮靴",
		["Fine Leather Cloak"] = "优质皮披风",
		["Fine Leather Gloves"] = "优质皮手套",
		["Fine Leather Pants"] = "优质皮裤",
		["Fine Leather Tunic"] = "优质皮外套",
		["Flame Armor Kit"] = "烈焰护甲片",
		["Flamescale Belt"] = "焰鳞腰带",
		["Flamescale Boots"] = "焰鳞长靴",
		["Flamescale Leggings"] = "焰鳞护腿",
		["Fletcher's Gloves"] = "造弓师手套",
		["Frost Armor Kit"] = "冰霜护甲片",
		["Frost Leather Cloak"] = "冰霜皮质披风",
		["Frostsaber Boots"] = "霜刃长靴",
		["Frostsaber Gloves"] = "霜刃手套",
		["Frostsaber Leggings"] = "霜刃护腿",
		["Frostsaber Tunic"] = "霜刃外套",
		["Gauntlets of the Sea"] = "深海护手",
		["Gem-studded Leather Belt"] = "宝石皮带",
		["Girdle of Insight"] = "洞察束带",
		["Glove Reinforcements"] = "手套强固",
		["Gloves of the Greatfather"] = "冬天爷爷的手套",
		["Gloves of the Living Touch"] = "生命之触手套",
		["Golden Dragonstrike Breastplate"] = "金色龙击胸甲",
		["Golden Mantle of the Dawn"] = "金色黎明衬肩",
		["Greaves of Shackled Souls"] = "束缚灵魂护腿",
		["Green Dragonscale Breastplate"] = "绿龙鳞片胸甲",
		["Green Dragonscale Gauntlets"] = "绿色龙鳞护手",
		["Green Dragonscale Leggings"] = "绿龙鳞片护腿",
		["Green Leather Armor"] = "绿色皮甲",
		["Green Leather Belt"] = "绿色皮带",
		["Green Leather Bracers"] = "绿色皮护腕",
		["Green Whelp Armor"] = "绿色幼龙护甲",
		["Green Whelp Bracers"] = "绿色幼龙护腕",
		["Guardian Armor"] = "守护之甲",
		["Guardian Belt"] = "守护腰带",
		["Guardian Cloak"] = "守护披风",
		["Guardian Gloves"] = "守护手套",
		["Guardian Leather Bracers"] = "守护腕甲",
		["Guardian Pants"] = "守护短裤",
		["Handstitched Leather Belt"] = "手工皮带",
		["Handstitched Leather Boots"] = "手工皮靴",
		["Handstitched Leather Bracers"] = "手工皮护腕",
		["Handstitched Leather Cloak"] = "手工皮披风",
		["Handstitched Leather Pants"] = "手工皮短裤",
		["Handstitched Leather Vest"] = "手工皮外衣",
		["Heavy Armor Kit"] = "重型护甲片",
		["Heavy Clefthoof Boots"] = "厚重裂蹄长靴",
		["Heavy Clefthoof Leggings"] = "厚重裂蹄护腿",
		["Heavy Clefthoof Vest"] = "厚重裂蹄外套",
		["Heavy Earthen Gloves"] = "重型土灵手套",
		["Heavy Knothide Armor Kit"] = "厚重裂蹄护甲片",
		["Heavy Knothide Leather"] = "重结缔皮",
		["Heavy Leather Ammo Pouch"] = "重皮弹药包",
		["Heavy Leather Ball"] = "重皮球",
		["Heavy Leather"] = "重皮",
		["Heavy Quiver"] = "重型箭袋",
		["Heavy Scorpid Belt"] = "重型蝎壳腰带",
		["Heavy Scorpid Bracers"] = "重型蝎壳护腕",
		["Heavy Scorpid Gauntlets"] = "重型蝎壳护手",
		["Heavy Scorpid Helm"] = "重型蝎壳头盔",
		["Heavy Scorpid Leggings"] = "重型蝎壳护腿",
		["Heavy Scorpid Shoulders"] = "重型蝎壳护肩",
		["Heavy Scorpid Vest"] = "重型蝎壳外衣",
		["Helm of Fire"] = "火焰头盔",
		["Herbalist's Gloves"] = "采药人手套",
		["Hide of the Wild"] = "野性之皮",
		["Hillman's Belt"] = "山地腰带",
		["Hillman's Cloak"] = "山地披风",
		["Hillman's Leather Gloves"] = "山地皮手套",
		["Hillman's Leather Vest"] = "山地皮外衣",
		["Hillman's Shoulders"] = "山地护肩",
		["Hood of Primal Life"] = "源生生命罩帽",
		["Hurricane Boots"] = "飓风长靴",
		["Icy Scale Bracers"] = "寒鳞护腕",
		["Icy Scale Breastplate"] = "寒鳞胸甲",
		["Icy Scale Gauntlets"] = "寒鳞护手",
		["Ironfeather Breastplate"] = "铁羽胸甲",
		["Ironfeather Shoulders"] = "铁羽护肩",
		["Knothide Ammo Pouch"] = "结蹄皮弹药包",
		["Knothide Armor Kit"] = "结缔皮护甲片",
		["Knothide Leather"] = "结缔皮",
		["Knothide Quiver"] = "结蒂皮箭袋",
		["Kodo Hide Bag"] = "科多兽皮包",
		["Lava Belt"] = "熔岩腰带",
		["Leatherworker's Satchel"] = "制皮匠的背包",
		["Light Armor Kit"] = "轻型护甲片",
		["Light Leather Bracers"] = "轻皮护腕",
		["Light Leather Pants"] = "轻皮短裤",
		["Light Leather Quiver"] = "轻皮箭袋",
		["Light Leather"] = "轻皮",
		["Living Breastplate"] = "生命胸甲",
		["Living Crystal Breastplate"] = "生命水晶胸甲",
		["Living Dragonscale Helm"] = "生命龙鳞头盔",
		["Living Earth Bindings"] = "生命之地护腕",
		["Living Earth Shoulders"] = "生命之地护肩",
		["Living Leggings"] = "生命护腿",
		["Living Shoulders"] = "生命护肩",
		["Magister's Armor Kit"] = "魔导师的护甲片",
		["Medium Armor Kit"] = "中型护甲片",
		["Medium Leather"] = "中皮",
		["Might of the Timbermaw"] = "木喉之力",
		["Molten Belt"] = "熔火腰带",
		["Molten Helm"] = "熔铸头盔",
		["Mongoose Boots"] = "猫鼬长靴",
		["Monsoon Belt"] = "季风腰带",
		["Moonglow Vest"] = "月光外衣",
		["Murloc Scale Belt"] = "鱼人鳞片腰带",
		["Murloc Scale Bracers"] = "鱼人鳞片护腕",
		["Murloc Scale Breastplate"] = "鱼人鳞片胸甲",
		["Nature Armor Kit"] = "自然护甲片",
		["Nethercleft Leg Armor"] = "虚空裂蹄腿甲片",
		["Nethercobra Leg Armor"] = "虚空毒蛇腿甲片",
		["Netherdrake Gloves"] = "虚空幼龙手套",
		["Netherdrake Helm"] = "虚空幼龙头盔",
		["Netherfury Belt"] = "虚空之怒腰带",
		["Netherfury Boots"] = "虚空之怒长靴",
		["Netherfury Leggings"] = "虚空之怒护腿",
		["Netherscale Ammo Pouch"] = "虚空鳞片弹药包",
		["Netherstrike Belt"] = "虚空打击腰带",
		["Netherstrike Bracers"] = "虚空打击护腕",
		["Netherstrike Breastplate"] = "虚空打击胸甲",
		["Nightscape Boots"] = "夜色长靴",
		["Nightscape Headband"] = "夜色头带",
		["Nightscape Pants"] = "夜色短裤",
		["Nightscape Shoulders"] = "夜色护肩",
		["Nightscape Tunic"] = "夜色外套",
		["Nimble Leather Gloves"] = "轻巧的皮手套",
		["Onyxia Scale Cloak"] = "奥妮克希亚鳞片披风",
		["Pilferer's Gloves"] = "窃贼手套",
		["Polar Bracers"] = "北极护腕",
		["Polar Gloves"] = "北极手套",
		["Polar Tunic"] = "北极外套",
		["Primal Batskin Bracers"] = "原始蝙蝠皮护腕",
		["Primal Batskin Gloves"] = "原始蝙蝠皮手套",
		["Primal Batskin Jerkin"] = "原始蝙蝠皮外套",
		["Primalstorm Breastplate"] = "原始风暴胸甲",
		["Primalstrike Belt"] = "原始打击腰带",
		["Primalstrike Bracers"] = "原始打击护腕",
		["Primalstrike Vest"] = "原始打击外衣",
		["Quickdraw Quiver"] = "快捷箭袋",
		["Quiver of a Thousand Feathers"] = "千羽箭袋",
		["Raptor Hide Belt"] = "迅猛龙皮腰带",
		["Raptor Hide Harness"] = "迅猛龙皮背心",
		["Red Dragonscale Breastplate"] = "红龙鳞片胸甲",
		["Red Whelp Gloves"] = "红色雏龙手套",
		["Redeemed Soul Cinch"] = "救赎灵魂束带",
		["Redeemed Soul Legguards"] = "救赎灵魂腿甲",
		["Redeemed Soul Moccasins"] = "救赎灵魂长靴",
		["Redeemed Soul Wristguards"] = "救赎灵魂腕甲",
		["Reinforced Mining Bag"] = "加固矿工袋",
		["Riding Crop"] = "马鞭",
		["Rugged Armor Kit"] = "毛皮护甲片",
		["Rugged Leather Pants"] = "皱褶皮短裤",
		["Rugged Leather"] = "硬甲皮",
		["Runic Leather Armor"] = "符文皮甲",
		["Runic Leather Belt"] = "符文皮甲腰带",
		["Runic Leather Bracers"] = "符文皮甲护腕",
		["Runic Leather Gauntlets"] = "符文皮甲护手",
		["Runic Leather Headband"] = "符文皮甲头环",
		["Runic Leather Pants"] = "符文皮甲短裤",
		["Runic Leather Shoulders"] = "符文皮甲护肩",
		["Sandstalker Bracers"] = "沙行者护腕",
		["Sandstalker Breastplate"] = "沙行者胸甲",
		["Sandstalker Gauntlets"] = "沙行者护手",
		["Scaled Draenic Boots"] = "缀鳞德拉诺长靴",
		["Scaled Draenic Gloves"] = "缀鳞德拉诺手套",
		["Scaled Draenic Pants"] = "缀鳞德拉诺短裤",
		["Scaled Draenic Vest"] = "缀鳞德拉诺外套",
		["Shadow Armor Kit"] = "暗影护甲片",
		["Shadowprowler's Chestguard"] = "阴影徘徊者胸甲",
		["Shadowskin Gloves"] = "影皮手套",
		["Shifting Cloak"] = "移形披风",
		["Shoulderpads of Renewed Life"] = "新生护肩",
		["Shoulders of Lightning Reflexes"] = "闪电反射护肩",
		["Small Leather Ammo Pouch"] = "皮质小弹药包",
		["Spitfire Bracers"] = "飞火护腕",
		["Spitfire Breastplate"] = "飞火胸甲",
		["Spitfire Gauntlets"] = "飞火护手",
		["Stormshroud Armor"] = "雷暴",
		["Stormshroud Gloves"] = "雷暴手套",
		["Stormshroud Pants"] = "雷暴短裤",
		["Stormshroud Shoulders"] = "雷暴护肩",
		["Stylin' Adventure Hat"] = "斯蒂林的冒险帽",
		["Stylin' Crimson Hat"] = "斯蒂林的赤链帽",
		["Stylin' Jungle Hat"] = "斯蒂林的丛林帽",
		["Stylin' Purple Hat"] = "斯蒂林的紫皮帽",
		["Swift Boots"] = "迅捷之靴",
		["Swift Flight Bracers"] = "迅行护腕",
		["Swiftstrike Bracers"] = "迅捷打击护腕",
		["Swiftstrike Shoulders"] = "迅捷打击护肩",
		["Thick Armor Kit"] = "厚重护甲片",
		["Thick Draenic Boots"] = "厚重德莱尼长靴",
		["Thick Draenic Gloves"] = "厚重德莱尼手套",
		["Thick Draenic Pants"] = "厚重德莱尼短裤",
		["Thick Draenic Vest"] = "厚重德莱尼外套",
		["Thick Leather Ammo Pouch"] = "厚皮弹药包",
		["Thick Leather"] = "厚皮",
		["Thick Murloc Armor"] = "厚鱼人皮甲",
		["Thick Netherscale Breastplate"] = "厚重虚空鳞片胸甲",
		["Timbermaw Brawlers"] = "木喉作战手套",
		["Tough Scorpid Boots"] = "硬化蝎壳战靴",
		["Tough Scorpid Bracers"] = "硬化蝎壳护腕",
		["Tough Scorpid Breastplate"] = "硬化蝎壳胸甲",
		["Tough Scorpid Gloves"] = "硬化蝎壳手套",
		["Tough Scorpid Helm"] = "硬化蝎壳头盔",
		["Tough Scorpid Leggings"] = "硬化蝎壳护腿",
		["Tough Scorpid Shoulders"] = "硬化蝎壳护肩",
		["Toughened Leather Armor"] = "韧化皮甲",
		["Toughened Leather Gloves"] = "韧化皮手套",
		["Turtle Scale Bracers"] = "龟壳护腕",
		["Turtle Scale Breastplate"] = "龟壳胸甲",
		["Turtle Scale Gloves"] = "龟壳手套",
		["Turtle Scale Helm"] = "龟壳头盔",
		["Turtle Scale Leggings"] = "龟壳护腿",
		["Vindicator's Armor Kit"] = "守备官的护甲片",
		["Volcanic Breastplate"] = "火山胸甲",
		["Volcanic Leggings"] = "火山护腿",
		["Volcanic Shoulders"] = "火山护肩",
		["Waistguard of Shackled Souls"] = "束缚灵魂腰带",
		["Warbear Harness"] = "战熊背心",
		["Warbear Woolies"] = "战熊热裤",
		["White Leather Jerkin"] = "白色皮夹克",
		["Wicked Leather Armor"] = "邪恶皮甲",
		["Wicked Leather Belt"] = "邪恶皮甲腰带",
		["Wicked Leather Bracers"] = "邪恶皮甲护腕",
		["Wicked Leather Gauntlets"] = "邪恶皮甲护手",
		["Wicked Leather Headband"] = "邪恶皮甲头环",
		["Wicked Leather Pants"] = "邪恶皮甲短裤",
		["Wild Draenish Boots"] = "野性德莱尼长靴",
		["Wild Draenish Gloves"] = "野性德莱尼手套",
		["Wild Draenish Leggings"] = "野性德莱尼护腿",
		["Wild Draenish Vest"] = "野性德莱尼外套",
		["Wild Leather Boots"] = "蛮皮战靴",
		["Wild Leather Cloak"] = "蛮皮披风",
		["Wild Leather Helmet"] = "蛮皮头盔",
		["Wild Leather Leggings"] = "蛮皮护腿",
		["Wild Leather Shoulders"] = "蛮皮护肩",
		["Wild Leather Vest"] = "蛮皮外衣",
		["Wildfeather Leggings"] = "野羽护腿",
		["Windhawk Belt"] = "风鹰腰带",
		["Windhawk Bracers"] = "风鹰护腕",
		["Windhawk Hauberk"] = "风鹰胸甲",
		["Windscale Hood"] = "风鳞兜帽",
		["Windslayer Wraps"] = "风斩裹手",
		["Windstrike Gloves"] = "风击手套",
		["Winter Boots"] = "寒冬长靴",
		["Wolfshead Helm"] = "狼头之盔",


-- Smelting Recipes
		["Earth Shatter"] = "敲碎源生之土",
		["Fire Sunder"] = "火焰碎裂",
		["Smelt Adamantite"] = "熔炼精金",
		["Smelt Bronze"] = "熔炼青铜",
		["Smelt Copper"] = "熔炼铜锭",
		["Smelt Dark Iron"] = "熔炼黑铁",
		["Smelt Elementium"] = "熔炼源质",
		["Smelt Eternium"] = "熔炼恒金",
		["Smelt Fel Iron"] = "熔炼魔铁",
		["Smelt Felsteel"] = "熔炼魔钢",
		["Smelt Gold"] = "熔炼金锭",
		["Smelt Hardened Adamantite"] = "熔炼硬化精金",
		["Smelt Iron"] = "熔炼铁锭",
		["Smelt Khorium"] = "熔炼氪金",
		["Smelt Mithril"] = "熔炼秘银",
		["Smelt Silver"] = "熔炼银锭",
		["Smelt Steel"] = "熔炼钢锭",
		["Smelt Thorium"] = "熔炼瑟银",
		["Smelt Tin"] = "熔炼锡锭",
		["Smelt Truesilver"] = "熔炼真银",

-- Rogue Poison Recipes
		["Anesthetic Poison"] = "麻醉药膏",
		["Blinding Powder"] = "致盲粉",
		["Crippling Poison II"] = "减速药膏 II",
		["Crippling Poison"] = "减速药膏",
		["Deadly Poison II"] = "致命药膏 II",
		["Deadly Poison III"] = "致命药膏 III",
		["Deadly Poison IV"] = "致命药膏 IV",
		["Deadly Poison V"] = "致命药膏 V",
		["Deadly Poison VI"] = "致命药膏 VI",
		["Deadly Poison VII"] = "致命药膏 VII",
		["Deadly Poison"] = "致命药膏",
		["Instant Poison II"] = "速效药膏 II",
		["Instant Poison III"] = "速效药膏 III",
		["Instant Poison IV"] = "速效药膏 IV",
		["Instant Poison V"] = "速效药膏 V",
		["Instant Poison VI"] = "速效药膏 VI",
		["Instant Poison VII"] = "速效药膏 VII",
		["Instant Poison"] = "速效药膏",
		["Mind-numbing Poison II"] = "麻痹药膏 II",
		["Mind-numbing Poison III"] = "麻痹药膏 III",
		["Mind-numbing Poison"] = "麻痹药膏",
		["Wound Poison II"] = "致伤药膏 II",
		["Wound Poison III"] = "致伤药膏 III",
		["Wound Poison IV"] = "致伤药膏 IV",
		["Wound Poison V"] = "致伤药膏 V",
		["Wound Poison"] = "致伤药膏",

-- Tailoring Recipes
		["Admiral's Hat"] = "将军之帽",
		["Arcanoweave Boots"] = "奥法交织长靴",
		["Arcanoweave Bracers"] = "奥法交织护腕",
		["Arcanoweave Robe"] = "奥法交织长袍",
		["Argent Boots"] = "银色长靴",
		["Argent Shoulders"] = "银色护肩",
		["Azure Shoulders"] = "碧蓝护肩",
		["Azure Silk Belt"] = "碧蓝丝质腰带",
		["Azure Silk Cloak"] = "碧蓝丝质披风",
		["Azure Silk Gloves"] = "碧蓝丝质手套",
		["Azure Silk Hood"] = "碧蓝丝质头巾",
		["Azure Silk Pants"] = "碧蓝丝质短裤",
		["Azure Silk Vest"] = "碧蓝丝质外衣",
		["Bag of Jewels"] = "珠宝袋",
		["Barbaric Linen Vest"] = "野人亚麻外衣",
		["Battlecast Hood"] = "战斗施法罩帽",
		["Battlecast Pants"] = "战斗施法短裤",
		["Belt of Blasting"] = "冲击腰带",
		["Belt of the Archmage"] = "大法师腰带",
		["Belt of the Long Road"] = "长路腰带",
		["Big Bag of Enchantment"] = "大附魔袋",
		["Black Belt of Knowledge"] = "黑色知识腰带",
		["Black Mageweave Boots"] = "黑色魔纹之靴",
		["Black Mageweave Gloves"] = "黑色魔纹手套",
		["Black Mageweave Headband"] = "黑色魔纹头带",
		["Black Mageweave Leggings"] = "黑色魔纹短裤",
		["Black Mageweave Robe"] = "黑色魔纹长袍",
		["Black Mageweave Shoulders"] = "黑色魔纹护肩",
		["Black Mageweave Vest"] = "黑色魔纹外衣",
		["Black Silk Pack"] = "黑色丝质背包",
		["Black Swashbuckler's Shirt"] = "黑色冒险者衬衣",
		["Blackstrike Bracers"] = "黑色侵袭护腕",
		["Bloodvine Boots"] = "血藤长靴",
		["Bloodvine Leggings"] = "血藤护腿",
		["Bloodvine Vest"] = "血藤外套",
		["Blue Linen Robe"] = "蓝色亚麻长袍",
		["Blue Linen Shirt"] = "蓝色亚麻衬衣",
		["Blue Linen Vest"] = "蓝色亚麻外衣",
		["Blue Overalls"] = "蓝色罩衫",
		["Bolt of Imbued Netherweave"] = "魔化灵纹布卷",
		["Bolt of Linen Cloth"] = "亚麻布卷",
		["Bolt of Mageweave"] = "魔纹布卷",
		["Bolt of Netherweave"] = "灵纹布卷",
		["Bolt of Runecloth"] = "符文布卷",
		["Bolt of Silk Cloth"] = "丝绸卷",
		["Bolt of Soulcloth"] = "灵魂布卷",
		["Bolt of Woolen Cloth"] = "毛布卷",
		["Boots of Blasting"] = "冲击长靴",
		["Boots of the Enchanter"] = "附魔师长靴",
		["Boots of the Long Road"] = "长路之靴",
		["Bottomless Bag"] = "无底包",
		["Bracers of Havok"] = "浩劫护腕",
		["Bracers of Nimble Thought"] = "敏锐思维护腕",
		["Bright Yellow Shirt"] = "淡黄色衬衣",
		["Brightcloth Cloak"] = "亮布披风",
		["Brightcloth Gloves"] = "亮布手套",
		["Brightcloth Pants"] = "亮布短裤",
		["Brightcloth Robe"] = "亮布长袍",
		["Brown Linen Pants"] = "棕色亚麻短裤",
		["Brown Linen Robe"] = "棕色亚麻长袍",
		["Brown Linen Shirt"] = "棕色亚麻衬衣",
		["Brown Linen Vest"] = "棕色亚麻外衣",
		["Cenarion Herb Bag"] = "塞纳里奥草药包",
		["Cindercloth Boots"] = "灰布长靴",
		["Cindercloth Cloak"] = "灰布披风",
		["Cindercloth Gloves"] = "灰布手套",
		["Cindercloth Pants"] = "灰布短裤",
		["Cindercloth Robe"] = "灰布长袍",
		["Cindercloth Vest"] = "灰布外衣",
		["Cloak of Arcane Evasion"] = "奥术闪避披风",
		["Cloak of Eternity"] = "永恒披风",
		["Cloak of Fire"] = "火焰披风",
		["Cloak of the Black Void"] = "黑色虚空披风",
		["Cloak of Warding"] = "护卫披风",
		["Colorful Kilt"] = "多彩褶裙",
		["Core Felcloth Bag"] = "熔火恶魔布包",
		["Crimson Silk Belt"] = "深红丝质腰带",
		["Crimson Silk Cloak"] = "深红丝质披风",
		["Crimson Silk Gloves"] = "深红丝质手套",
		["Crimson Silk Pantaloons"] = "深红丝质马裤",
		["Crimson Silk Robe"] = "深红丝质长袍",
		["Crimson Silk Shoulders"] = "深红丝质护肩",
		["Crimson Silk Vest"] = "深红丝质外衣",
		["Dark Silk Shirt"] = "黑丝衬衣",
		["Double-stitched Woolen Shoulders"] = "双线毛纺护肩",
		["Dreamweave Circlet"] = "梦纹头饰",
		["Dreamweave Gloves"] = "梦纹手套",
		["Dreamweave Vest"] = "梦纹外衣",
		["Earthen Silk Belt"] = "土灵丝质腰带",
		["Earthen Vest"] = "土灵外衣",
		["Ebon Shadowbag"] = "黑色暗影背包",
		["Enchanted Mageweave Pouch"] = "魔化魔纹布包",
		["Enchanted Runecloth Bag"] = "魔化符文布包",
		["Enchanter's Cowl"] = "巫术师兜帽",
		["Felcloth Bag"] = "恶魔布包",
		["Felcloth Boots"] = "恶魔布靴",
		["Felcloth Gloves"] = "恶魔布手套",
		["Felcloth Hood"] = "恶魔布帽",
		["Felcloth Pants"] = "恶魔布短裤",
		["Felcloth Robe"] = "恶魔布袍",
		["Felcloth Shoulders"] = "恶魔布护肩",
		["Festival Dress"] = "节庆长裙",
		--["Festive Red Dress"] = "红色节庆长裙",doesn't exist?
		["Festive Red Pant Suit"] = "红色节庆裤装",
		["Flameheart Bracers"] = "烈焰之心护腕",
		["Flameheart Gloves"] = "烈焰之心手套",
		["Flameheart Vest"] = "烈焰之心外衣",
		["Flarecore Gloves"] = "光芒手套",
		["Flarecore Leggings"] = "光芒护腿",
		["Flarecore Mantle"] = "光芒衬肩",
		["Flarecore Robe"] = "光芒长袍",
		["Flarecore Wraps"] = "光芒护腕",
		["Formal White Shirt"] = "体面的白衬衣",
		["Frostweave Gloves"] = "霜纹手套",
		["Frostweave Pants"] = "霜纹短裤",
		["Frostweave Robe"] = "霜纹长袍",
		["Frostweave Tunic"] = "霜纹外套",
		["Frozen Shadoweave Boots"] = "冰霜暗纹长靴",
		["Frozen Shadoweave Shoulders"] = "冰霜暗纹护肩",
		["Frozen Shadoweave Robe"] = "冰霜暗纹外衣",
		["Gaea's Embrace"] = "盖亚的拥抱",
		["Ghostweave Belt"] = "鬼纹腰带",
		["Ghostweave Gloves"] = "鬼纹手套",
		["Ghostweave Pants"] = "鬼纹短裤",
		["Ghostweave Vest"] = "鬼纹外衣",
		["Girdle of Ruination"] = "毁灭束带",
		["Glacial Cloak"] = "冰川披风",
		["Glacial Gloves"] = "冰川手套",
		["Glacial Vest"] = "冰川外衣",
		["Glacial Wrists"] = "冰川护腕",
		["Gloves of Meditation"] = "冥想手套",
		["Gloves of Spell Mastery"] = "法术掌握手套",
		["Golden Spellthread"] = "金色魔线",
		["Gordok Ogre Suit"] = "戈多克食人魔装",
		["Gray Woolen Robe"] = "灰色毛纺长袍",
		["Gray Woolen Shirt"] = "灰色毛纺衬衣",
		["Greater Adept's Robe"] = "大师长袍",
		["Green Holiday Shirt"] = "绿色节日衬衣",
		["Green Linen Bracers"] = "绿色亚麻护腕",
		["Green Linen Shirt"] = "绿色亚麻衬衣",
		["Green Silk Armor"] = "绿色丝甲",
		["Green Silk Pack"] = "绿色丝质包",
		["Green Silken Shoulders"] = "绿色丝质护肩",
		["Green Winter Clothes"] = "绿色冬衣",
		["Green Woolen Bag"] = "绿色毛纺包",
		["Green Woolen Vest"] = "绿色毛纺外衣",
		["Hands of Darkness"] = "黑暗之手",
		["Handstitched Linen Britches"] = "手工亚麻裤",
		["Heavy Linen Gloves"] = "高级亚麻手套",
		["Heavy Woolen Cloak"] = "高级毛纺披风",
		["Heavy Woolen Gloves"] = "高级毛纺手套",
		["Heavy Woolen Pants"] = "高级毛纺短裤",
		["Icy Cloak"] = "冰覆披风",
		["Imbued Netherweave Bag"] = "魔化灵纹布包",
		["Imbued Netherweave Boots"] = "魔化灵纹长靴",
		["Imbued Netherweave Pants"] = "魔化灵纹短裤",
		["Imbued Netherweave Robe"] = "魔化灵纹长袍",
		["Imbued Netherweave Tunic"] = "魔化灵纹外套",
		["Inferno Gloves"] = "地狱火手套",
		["Lavender Mageweave Shirt"] = "紫色魔纹衬衣",
		["Lesser Wizard's Robe"] = "次级巫师袍",
		["Linen Bag"] = "亚麻包",
		["Linen Belt"] = "亚麻腰带",
		["Linen Boots"] = "亚麻靴",
		["Linen Cloak"] = "亚麻披风",
		["Long Silken Cloak"] = "丝质长披风",
		["Mageweave Bag"] = "魔纹包",
		["Manaweave Cloak"] = "法力编织披风",
		["Mantle of Nimble Thought"] = "敏锐思维衬肩",
		["Mantle of the Timbermaw"] = "木喉衬肩",
		["Mooncloth Bag"] = "月布包",
		["Mooncloth Boots"] = "月布长靴",
		["Mooncloth Circlet"] = "月布头饰",
		["Mooncloth Gloves"] = "月布手套",
		["Mooncloth Leggings"] = "月布护腿",
		["Mooncloth Robe"] = "月布长袍",
		["Mooncloth Shoulders"] = "月布护肩",
		["Mooncloth Vest"] = "月布外衣",
		["Mooncloth"] = "月布",
		["Mystic Spellthread"] = "秘法魔线",
		["Netherweave Bag"] = "灵纹布包",
		["Netherweave Belt"] = "灵纹腰带",
		["Netherweave Boots"] = "灵纹长靴",
		["Netherweave Bracers"] = "灵纹护腕",
		["Netherweave Gloves"] = "灵纹手套",
		["Netherweave Net"] = "灵纹投网",
		["Netherweave Pants"] = "灵纹短裤",
		["Netherweave Robe"] = "灵纹长袍",
		["Netherweave Tunic"] = "灵纹外套",
		["Night's End"] = "夜色之末",
		["Orange Mageweave Shirt"] = "橙色魔纹衬衣",
		["Orange Martial Shirt"] = "橙色军用衬衣",
		["Pearl-clasped Cloak"] = "珍珠披风",
		["Phoenix Gloves"] = "凤凰手套",
		["Phoenix Pants"] = "凤凰短裤",
		["Pink Mageweave Shirt"] = "粉色魔纹衬衣",
		["Primal Mooncloth Bag"] = "原始月布包",
		["Primal Mooncloth Belt"] = "原始月布腰带",
		["Primal Mooncloth Robe"] = "原始月布长袍",
		["Primal Mooncloth Shoulders"] = "原始月布护肩",
		["Primal Mooncloth"] = "原始月布",
		["Red Linen Bag"] = "红色亚麻包",
		["Red Linen Robe"] = "红色亚麻长袍",
		["Red Linen Shirt"] = "红色亚麻衬衣",
		["Red Linen Vest"] = "红色亚麻外衣",
		["Red Mageweave Bag"] = "红色魔纹包",
		["Red Mageweave Gloves"] = "红色魔纹手套",
		["Red Mageweave Headband"] = "红色魔纹头带",
		["Red Mageweave Pants"] = "红色魔纹短裤",
		["Red Mageweave Shoulders"] = "红色魔纹护肩",
		["Red Mageweave Vest"] = "红色魔纹外衣",
		["Red Swashbuckler's Shirt"] = "红色冒险者衬衣",
		["Red Woolen Bag"] = "红色毛纺包",
		["Red Woolen Boots"] = "红色毛纺靴",
		["Reinforced Linen Cape"] = "强化亚麻斗篷",
		["Red Winter Clothes"] = "红色冬衣",
		["Reinforced Woolen Shoulders"] = "强化毛纺护肩",
		["Resolute Cape"] = "坚毅披风",
		["Rich Purple Silk Shirt"] = "紫色丝质衬衣",
		["Robe of Power"] = "力量法袍",
		["Robe of the Archmage"] = "大法师之袍",
		["Robe of the Void"] = "虚空法袍",
		["Robe of Winter Night"] = "冬夜法袍",
		["Robes of Arcana"] = "奥法之袍",
		["Runecloth Bag"] = "符文布背包",
		["Runecloth Belt"] = "符文布腰带",
		["Runecloth Boots"] = "符文布靴",
		["Runecloth Cloak"] = "符文布披风",
		["Runecloth Gloves"] = "符文布手套",
		["Runecloth Headband"] = "符文布头带",
		["Runecloth Pants"] = "符文布短裤",
		["Runecloth Robe"] = "符文布袍",
		["Runecloth Shoulders"] = "符文布护肩",
		["Runecloth Tunic"] = "符文布外套",
		["Runed Stygian Belt"] = "符文冥河腰带",
		["Runed Stygian Boots"] = "符文冥河长靴",
		["Runed Stygian Leggings"] = "符文冥河护腿",
		["Runic Spellthread"] = "符文魔线",
		["Satchel of Cenarius"] = "塞纳留斯之袋",
		["Shadow Hood"] = "暗影头巾",
		["Shadowcloth"] = "暗影布",
		["Shadoweave Boots"] = "暗纹之靴",
		["Shadoweave Gloves"] = "暗纹手套",
		["Shadoweave Mask"] = "暗纹面罩",
		["Shadoweave Pants"] = "暗纹短裤",
		["Shadoweave Robe"] = "暗纹长袍",
		["Shadoweave Shoulders"] = "暗纹护肩",
		["Silk Headband"] = "丝质头带",
		["Silver Spellthread"] = "银色魔线",
		["Simple Black Dress"] = "简易的黑裙子",
		["Simple Dress"] = "简易的裙子",
		["Simple Kilt"] = "简易的褶裙",
		["Simple Linen Boots"] = "简易的亚麻靴",
		["Simple Linen Pants"] = "简易亚麻短裤",
		["Small Silk Pack"] = "丝绸小包",
		["Soft-soled Linen Boots"] = "软底亚麻靴",
		["Soul Pouch"] = "灵魂袋",
		["Soulcloth Gloves"] = "灵魂布手套",
		["Soulcloth Shoulders"] = "灵魂布护肩",
		["Soulcloth Vest"] = "灵魂布外衣",
		["Soulguard Bracers"] = "灵魂卫士护腕",
		["Soulguard Girdle"] = "灵魂卫士束带",
		["Soulguard Leggings"] = "灵魂卫士护腿",
		["Soulguard Slippers"] = "灵魂卫士便鞋",
		["Spellcloth"] = "魔法布",
		["Spellfire Bag"] = "魔焰背包",
		["Spellfire Belt"] = "魔焰腰带",
		["Spellfire Gloves"] = "魔焰手套",
		["Spellfire Robe"] = "魔焰长袍",
		["Spellstrike Hood"] = "法术打击兜帽",
		["Spellstrike Pants"] = "法术打击短裤",
		["Spider Belt"] = "蜘蛛腰带",
		["Spider Silk Slippers"] = "蛛丝便鞋",
		["Spidersilk Boots"] = "蛛丝之靴",
		["Star Belt"] = "星辰腰带",
		["Stylish Blue Shirt"] = "漂亮的蓝衬衣",
		["Stylish Green Shirt"] = "漂亮的绿衬衣",
		["Stylish Red Shirt"] = "漂亮的红衬衣",
		["Swiftheal Mantle"] = "迅捷治疗衬肩",
		["Swiftheal Wraps"] = "迅捷治疗护腕",
		["Sylvan Crown"] = "林栖者头冠",
		["Sylvan Shoulders"] = "林栖者护肩",
		["Sylvan Vest"] = "林栖者外衣",
		["Truefaith Gloves"] = "信念手套",
		["Truefaith Vestments"] = "信念外衣",
		["Tuxedo Jacket"] = "礼服夹克",
		["Tuxedo Pants"] = "礼服短裤",
		["Tuxedo Shirt"] = "礼服衬衣",
		["Unyielding Bracers"] = "不屈护腕",
		["Unyielding Girdle"] = "不屈束带",
		["Vengeance Wrap"] = "复仇披风",
		["White Bandit Mask"] = "白色强盗面罩",
		["White Linen Robe"] = "白色亚麻长袍",
		["White Linen Shirt"] = "白色亚麻衬衣",
		["White Remedy Cape"] = "白色治愈斗篷",
		["White Swashbuckler's Shirt"] = "白色冒险者衬衣",
		["White Wedding Dress"] = "白色婚纱",
		["White Woolen Dress"] = "白色毛绒裙",
		["Whitemend Hood"] = "白色治愈兜帽",
		["Whitemend Pants"] = "白色治愈短裤",
		["Wisdom of the Timbermaw"] = "木喉之智",
		["Wizardweave Leggings"] = "巫纹护腿",
		["Wizardweave Robe"] = "巫纹长袍",
		["Wizardweave Turban"] = "巫纹头巾",
		["Woolen Bag"] = "毛纺包",
		["Woolen Boots"] = "毛纺靴",
		["Woolen Cape"] = "毛纺斗篷",
	}
end)

BabbleTradeskill:RegisterTranslations("zhTW", function()
	return {
-- Gathering skills
		["Disenchant"] = "分解",
		["Fishing"] = "釣魚",
		["Herbalism"] = "草藥學",
		["Mining"] = "採礦",
		["Pick Pocket"] = "偷竊",
		["Prospecting"] = "勘探",
		["Skinning"] = "剝皮",
		["Smelting"] = "熔煉",
		["Riding"] = "騎乘",


-- Crafting skills
		["Alchemy"] = "鍊金術",
		["Armorsmith"] = "護甲鍛造師",
		["Blacksmithing"] = "鍛造",
		["Cooking"] = "烹飪",
		["Dragonscale Leatherworking"] = "龍鱗製皮",
		["Elemental Leatherworking"] = "元素製皮",
		["Elixir Master"] = "藥劑專精",
		["Enchanting"] = "附魔",
		["Engineering"] = "工程學",
		["First Aid"] = "急救",
		["Gnomish Engineering"] = "地精工程學",
		["Goblin Engineering"] = "哥布林工程學",
		["Gnomish Engineer"] = "地精工程學",
		["Goblin Engineer"] = "哥布林工程師",
		["Jewelcrafting"] = "珠寶設計",
		["Leatherworking"] = "製皮",
		["Master Axesmith"] = "鑄斧大師",
		["Master Hammersmith"] = "鑄錘大師",
		["Master Swordsmith"] = "鑄劍大師",
		["Mooncloth Tailoring"] = "月布裁縫",
		["Poisons"] = "毒藥",
		["Potion Master"] = "藥水專精",
		["Shadoweave Tailoring"] = "影紋裁縫",
		["Spellfire Tailoring"] = "魔焰裁縫",
		["Tailoring"] = "裁縫",
		["Transmutation Master"] = "轉化專精",
		["Tribal Leatherworking"] = "部族製皮",
		["Weaponsmith"] = "武器鑄造",

-- Alchemy Recipes
		["Adept's Elixir"] = "內行藥劑",
		["Alchemist's Stone"] = "鍊金石",
		["Arcane Elixir"] = "秘法藥劑",
		["Blackmouth Oil"] = "黑口魚油",
		["Catseye Elixir"] = "貓眼藥劑",
		["Cauldron of Major Arcane Protection"] = "極效秘法防護大鍋",
		["Cauldron of Major Fire Protection"] = "極效火焰防護大鍋",
		["Cauldron of Major Frost Protection"] = "極效冰霜防護大鍋",
		["Cauldron of Major Nature Protection"] = "極效自然防護大鍋",
		["Cauldron of Major Shadow Protection"] = "極效暗影防護大鍋",
		["Destruction Potion"] = "毀滅藥水",
		["Discolored Healing Potion"] = "透明治療藥水",
		["Dreamless Sleep Potion"] = "昏睡藥水",
		["Earthen Elixir"] = "地化藥劑",
		["Elixir of Agility"] = "敏捷藥劑",
		["Elixir of Brute Force"] = "蠻力藥劑",
		["Elixir of Camouflage"] = "隱身藥劑",
		["Elixir of Defense"] = "防禦藥劑",
		["Elixir of Demonslaying"] = "屠魔藥劑",
		["Elixir of Detect Demon"] = "偵測惡魔藥劑",
		["Elixir of Detect Lesser Invisibility"] = "偵測次級隱形藥劑",
		["Elixir of Detect Undead"] = "偵測不死生物藥劑",
		["Elixir of Draenic Wisdom"] = "德萊尼智慧藥劑",
		["Elixir of Dream Vision"] = "夢境幻象藥劑",
		["Elixir of Empowerment"] = "活效藥劑",
		["Elixir of Firepower"] = "火力藥劑",
		["Elixir of Fortitude"] = "堅韌藥劑",
		["Elixir of Frost Power"] = "冰霜之力藥劑",
		["Elixir of Giant Growth"] = "增長藥劑",
		["Elixir of Giants"] = "巨人藥劑",
		["Elixir of Greater Agility"] = "強效敏捷藥劑",
		["Elixir of Greater Defense"] = "強效防禦藥劑",
		["Elixir of Greater Firepower"] = "強效火力藥劑",
		["Elixir of Greater Intellect"] = "強效聰穎藥劑",
		["Elixir of Greater Water Breathing"] = "強效水下呼吸藥劑",
		["Elixir of Healing Power"] = "治療能量藥劑",
		["Elixir of Ironskin"] = "鐵膚藥劑",
		["Elixir of Lesser Agility"] = "次級敏捷藥劑",
		["Elixir of Lion's Strength"] = "獅王之力藥劑",
		["Elixir of Major Agility"] = "極效敏捷藥劑",
		["Elixir of Major Defense"] = "極效防禦藥劑",
		["Elixir of Major Firepower"] = "極效火焰之力藥劑",
		["Elixir of Major Fortitude"] = "極效堅韌藥劑",
		["Elixir of Major Frost Power"] = "極效冰霜之力藥劑",
		["Elixir of Major Mageblood"] = "極效魔血藥劑",
		["Elixir of Major Shadow Power"] = "極效暗影之力藥劑",
		["Elixir of Major Strength"] = "極效力量藥劑",
		["Elixir of Mastery"] = "精通藥劑",
		["Elixir of Minor Agility"] = "初級敏捷藥劑",
		["Elixir of Minor Defense"] = "初級防禦藥劑",
		["Elixir of Minor Fortitude"] = "初級堅韌藥劑",
		["Elixir of Ogre's Strength"] = "巨魔力量藥劑",
		["Elixir of Shadow Power"] = "暗影之力藥劑",
		["Elixir of Superior Defense"] = "超強防禦藥劑",
		["Elixir of the Mongoose"] = "貓鼬藥劑",
		["Elixir of the Sages"] = "先知藥劑",
		["Elixir of the Searching Eye"] = "搜尋之眼藥劑",
		["Elixir of Water Breathing"] = "水下呼吸藥劑",
		["Elixir of Wisdom"] = "智慧藥劑",
		["Fel Mana Potion"] = "魔化法力藥水",
		["Fel Regeneration Potion"] = "魔化再生藥水",
		["Fel Strength Elixir"] = "魔化力量藥劑",
		["Fire Oil"] = "火焰之油",
		["Fire Protection Potion"] = "火焰防護藥水",
		["Flask of Blinding Light"] = "盲目之光精煉藥劑",
		["Flask of Chromatic Resistance"] = "多重抗性精煉藥劑",
		["Flask of Chromatic Wonder"] = "炫彩驚奇精煉藥劑",
		["Flask of Distilled Wisdom"] = "智慧精煉藥劑",
		["Flask of Fortification"] = "防禦精煉藥劑",
		["Flask of Mighty Restoration"] = "法力恢復精煉藥劑",
		["Flask of Petrification"] = "化石精煉藥劑",
		["Flask of Pure Death"] = "純淨死亡精煉藥劑",
		["Flask of Relentless Assault"] = "強襲精煉藥劑",
		["Flask of Supreme Power"] = "超級能量精煉藥劑",
		["Flask of the Titans"] = "泰坦精煉藥劑",
		["Free Action Potion"] = "自由行動藥水",
		["Frost Oil"] = "冰霜之油",
		["Frost Protection Potion"] = "冰霜防護藥水",
		["Ghost Dye"] = "鬼魂染料",
		["Gift of Arthas"] = "阿薩斯的禮物",
		["Goblin Rocket Fuel"] = "哥布林火箭燃油",
		["Great Rage Potion"] = "暴怒藥水",
		["Greater Arcane Elixir"] = "強效秘法藥劑",
		["Greater Arcane Protection Potion"] = "強效秘法防護藥水",
		["Greater Dreamless Sleep Potion"] = "強效昏睡藥水",
		["Greater Fire Protection Potion"] = "強效火焰防護藥水",
		["Greater Frost Protection Potion"] = "強效冰霜防護藥水",
		["Greater Healing Potion"] = "強效治療藥水",
		["Greater Mana Potion"] = "強效法力藥水",
		["Greater Nature Protection Potion"] = "強效自然防護藥水",
		["Greater Shadow Protection Potion"] = "強效暗影防護藥水",
		["Greater Stoneshield Potion"] = "強效石盾藥水",
		["Gurubashi Mojo Madness"] = "古拉巴什瘋狂魔精",
		["Haste Potion"] = "急速藥水",
		["Healing Potion"] = "治療藥水",
		["Heroic Potion"] = "英勇藥水",
		["Holy Protection Potion"] = "神聖防護藥水",
		["Insane Strength Potion"] = "瘋狂力量藥水",
		["Invisibility Potion"] = "隱形藥水",
		["Ironshield Potion"] = "鐵盾藥水",
		["Lesser Healing Potion"] = "次級治療藥水",
		["Lesser Invisibility Potion"] = "次級隱形藥水",
		["Lesser Mana Potion"] = "次級法力藥水",
		["Lesser Stoneshield Potion"] = "次級石盾藥水",
		["Limited Invulnerability Potion"] = "有限無敵藥水",
		["Living Action Potion"] = "活力行動藥水",
		["Mad Alchemist's Potion"] = "瘋狂鍊金師藥水",
		["Mageblood Potion"] = "魔血藥水",
		["Magic Resistance Potion"] = "抗魔藥水",
		["Major Arcane Protection Potion"] = "極效秘法防護藥水",
		["Major Dreamless Sleep Potion"] = "極效昏睡藥水",
		["Major Fire Protection Potion"] = "極效火焰防護藥水",
		["Major Frost Protection Potion"] = "極效冰霜防護藥水",
		["Major Healing Potion"] = "極效治療藥水",
		["Major Holy Protection Potion"] = "極效神聖防護藥水",
		["Major Mana Potion"] = "極效法力藥水",
		["Major Nature Protection Potion"] = "極效自然防護藥水",
		["Major Rejuvenation Potion"] = "極效活力藥水",
		["Major Shadow Protection Potion"] = "極效暗影防護藥水",
		["Major Troll's Blood Potion"] = "極效食人妖之血藥水",
		["Mana Potion"] = "法力藥水",
		["Mercurial Stone"] = "水銀石",
		["Mighty Rage Potion"] = "強效怒氣藥水",
		["Mighty Troll's Blood Potion"] = "強大食人妖之血藥水",
		["Minor Healing Potion"] = "初級治療藥水",
		["Minor Magic Resistance Potion"] = "初級抗魔藥水",
		["Minor Mana Potion"] = "初級法力藥水",
		["Minor Rejuvenation Potion"] = "初級活力藥水",
		["Nature Protection Potion"] = "自然防護藥水",
		["Oil of Immolation"] = "獻祭之油",
		["Onslaught Elixir"] = "猛擊藥劑",
		["Philosopher's Stone"] = "點金石",
		["Potion of Curing"] = "治癒藥水",
		["Purification Potion"] = "淨化藥水",
		["Rage Potion"] = "怒氣藥水",
		["Restorative Potion"] = "滋補藥水",
		["Shadow Oil"] = "暗影之油",
		["Shadow Protection Potion"] = "暗影防護藥水",
		["Shrouding Potion"] = "漸隱藥水",
		["Sneaking Potion"] = "潛行藥水",
		["Stonescale Oil"] = "石鱗魚油",
		["Strong Troll's Blood Potion"] = "強力食人妖之血藥水",
		["Super Healing Potion"] = "超強效治療藥水",
		["Super Mana Potion"] = "超強效法力藥水",
		["Super Rejuvenation Potion"] = "超強效活力藥水",
		["Superior Healing Potion"] = "超強治療藥水",
		["Superior Mana Potion"] = "超強法力藥水",
		["Swiftness Potion"] = "迅捷藥水",
		["Swim Speed Potion"] = "速游藥水",
		["Transmute: Air to Fire"] = "轉化:轉氣成火",
		["Transmute: Arcanite"] = "轉化:奧金",
		["Transmute: Earth to Life"] = "轉化:土轉生命",
		["Transmute: Earth to Water"] = "轉化:轉土成水",
		["Transmute: Earthstorm Diamond"] = "轉化:大地風暴鑽石",
		["Transmute: Elemental Fire"] = "轉化:元素火焰",
		["Transmute: Fire to Earth"] = "轉化:轉火成土",
		["Transmute: Iron to Gold"] = "轉化:轉鐵成金",
		["Transmute: Life to Earth"] = "轉化:生命歸土",
		["Transmute: Mithril to Truesilver"] = "轉化真銀",
		["Transmute: Primal Air to Fire"] = "轉化:原始空氣轉原始之火",
		["Transmute: Primal Earth to Life"] = "轉化:原始大地轉原始生命",
		["Transmute: Primal Earth to Water"] = "轉化:原始大地轉原始之水",
		["Transmute: Primal Fire to Earth"] = "轉化:原始之火轉原始大地",
		["Transmute: Primal Fire to Mana"] = "轉化:原始之火轉原始法力",
		["Transmute: Primal Life to Earth"] = "轉化:原始生命轉原始大地",
		["Transmute: Primal Mana to Fire"] = "轉化:原始法力轉原始之火",
		["Transmute: Primal Might"] = "轉化:原始力量",
		["Transmute: Primal Shadow to Water"] = "轉化:原始暗影轉原始之水",
		["Transmute: Primal Water to Air"] = "轉化:原始之水轉原始空氣",
		["Transmute: Primal Water to Shadow"] = "轉化:原始之水轉原始暗影",
		["Transmute: Skyfire Diamond"] = "轉化:天火鑽石",
		["Transmute: Undeath to Water"] = "轉化:死靈化水",
		["Transmute: Water to Air"] = "轉化:轉水成氣",
		["Transmute: Water to Undeath"] = "轉化:水轉死靈",
		["Unstable Mana Potion"] = "不穩定法力藥水",
		["Volatile Healing Potion"] = "強烈治療藥水",
		["Weak Troll's Blood Potion"] = "弱效食人妖之血藥水",
		["Wildvine Potion"] = "野葡萄藥水",

-- Beast Training Skills
		["Arcane Resistance (Rank 1)"] = "秘法抗性 (等級 1)",
		["Arcane Resistance (Rank 2)"] = "秘法抗性 (等級 2)",
		["Arcane Resistance (Rank 3)"] = "秘法抗性 (等級 3)",
		["Arcane Resistance (Rank 4)"] = "秘法抗性 (等級 4)",
		["Arcane Resistance (Rank 5)"] = "秘法抗性 (等級 5)",
		["Avoidance (Rank 1)"] = "躲避 (等級 1)",
		["Avoidance (Rank 2)"] = "躲避 (等級 2)",
		["Bite (Rank 1)"] = "撕咬 (等級 1)",
		["Bite (Rank 2)"] = "撕咬 (等級 2)",
		["Bite (Rank 3)"] = "撕咬 (等級 3)",
		["Bite (Rank 4)"] = "撕咬 (等級 4)",
		["Bite (Rank 5)"] = "撕咬 (等級 5)",
		["Bite (Rank 6)"] = "撕咬 (等級 6)",
		["Bite (Rank 7)"] = "撕咬 (等級 7)",
		["Bite (Rank 8)"] = "撕咬 (等級 8)",
		["Bite (Rank 9)"] = "撕咬 (等級 9)",
		["Charge (Rank 1)"] = "衝鋒 (等級 1)",
		["Charge (Rank 2)"] = "衝鋒 (等級 2)",
		["Charge (Rank 3)"] = "衝鋒 (等級 3)",
		--["Charge (Rank 4)"] = "衝鋒 (等級 4)", -- No charge rank 4 in the game
		["Charge (Rank 5)"] = "衝鋒 (等級 5)",
		["Charge (Rank 6)"] = "衝鋒 (等級 6)",
		["Claw (Rank 1)"] = "爪擊 (等級 1)",
		["Claw (Rank 2)"] = "爪擊 (等級 2)",
		["Claw (Rank 3)"] = "爪擊 (等級 3)",
		["Claw (Rank 4)"] = "爪擊 (等級 4)",
		["Claw (Rank 5)"] = "爪擊 (等級 5)",
		["Claw (Rank 6)"] = "爪擊 (等級 6)",
		["Claw (Rank 7)"] = "爪擊 (等級 7)",
		["Claw (Rank 8)"] = "爪擊 (等級 8)",
		["Claw (Rank 9)"] = "爪擊 (等級 9)",
		["Cobra Reflexes ()"] = "毒蛇反射 ()",
		["Cower (Rank 1)"] = "畏縮 (等級 1)",
		["Cower (Rank 2)"] = "畏縮 (等級 2)",
		["Cower (Rank 3)"] = "畏縮 (等級 3)",
		["Cower (Rank 4)"] = "畏縮 (等級 4)",
		["Cower (Rank 5)"] = "畏縮 (等級 5)",
		["Cower (Rank 6)"] = "畏縮 (等級 6)",
		["Cower (Rank 7)"] = "畏縮 (等級 7)",
		["Dash (Rank 1)"] = "突進 (等級 1)",
		["Dash (Rank 2)"] = "突進 (等級 2)",
		["Dash (Rank 3)"] = "突進 (等級 3)",
		["Dive (Rank 1)"] = "俯衝 (等級 1)",
		["Dive (Rank 2)"] = "俯衝 (等級 2)",
		["Dive (Rank 3)"] = "俯衝 (等級 3)",
		["Fire Breath (Rank 1)"] = "火焰之息 (等級 1)",
		["Fire Breath (Rank 2)"] = "火焰之息 (等級 2)",
		["Fire Resistance (Rank 1)"] = "火焰抗性 (等級 1)",
		["Fire Resistance (Rank 2)"] = "火焰抗性 (等級 2)",
		["Fire Resistance (Rank 3)"] = "火焰抗性 (等級 3)",
		["Fire Resistance (Rank 4)"] = "火焰抗性 (等級 4)",
		["Fire Resistance (Rank 5)"] = "火焰抗性 (等級 5)",
		["Frost Resistance (Rank 1)"] = "冰霜抗性 (等級 1)",
		["Frost Resistance (Rank 2)"] = "冰霜抗性 (等級 2)",
		["Frost Resistance (Rank 3)"] = "冰霜抗性 (等級 3)",
		["Frost Resistance (Rank 4)"] = "冰霜抗性 (等級 4)",
		["Frost Resistance (Rank 5)"] = "冰霜抗性 (等級 5)",
		["Furious Howl (Rank 1)"] = "狂怒之嚎 (等級 1)",
		["Furious Howl (Rank 2)"] = "狂怒之嚎 (等級 2)",
		["Furious Howl (Rank 3)"] = "狂怒之嚎 (等級 3)",
		["Furious Howl (Rank 4)"] = "狂怒之嚎 (等級 4)",
		["Gore (Rank 1)"] = "獠牙穿刺 (等級 1)",
		["Gore (Rank 2)"] = "獠牙穿刺 (等級 2)",
		["Gore (Rank 3)"] = "獠牙穿刺 (等級 3)",
		["Gore (Rank 4)"] = "獠牙穿刺 (等級 4)",
		--["Gore (Rank 5)"] = "獠牙穿刺 (等級 5)", -- Not in game
		--["Gore (Rank 6)"] = "獠牙穿刺 (等級 6)", -- Not in game
		["Gore (Rank 7)"] = "獠牙穿刺 (等級 7)",
		["Gore (Rank 8)"] = "獠牙穿刺 (等級 8)",
		["Gore (Rank 9)"] = "獠牙穿刺 (等級 9)",
		["Great Stamina (Rank 1)"] = "強效耐力 (等級 1)",
		["Great Stamina (Rank 10)"] = "強效耐力 (等級 10)",
		["Great Stamina (Rank 11)"] = "強效耐力 (等級 11)",
		["Great Stamina (Rank 2)"] = "強效耐力 (等級 2)",
		["Great Stamina (Rank 3)"] = "強效耐力 (等級 3)",
		["Great Stamina (Rank 4)"] = "強效耐力 (等級 4)",
		["Great Stamina (Rank 5)"] = "強效耐力 (等級 5)",
		["Great Stamina (Rank 6)"] = "強效耐力 (等級 6)",
		["Great Stamina (Rank 7)"] = "強效耐力 (等級 7)",
		["Great Stamina (Rank 8)"] = "強效耐力 (等級 8)",
		["Great Stamina (Rank 9)"] = "強效耐力 (等級 9)",
		["Growl (Rank 1)"] = "低吼 (等級 1)",
		["Growl (Rank 2)"] = "低吼 (等級 2)",
		["Growl (Rank 3)"] = "低吼 (等級 3)",
		["Growl (Rank 4)"] = "低吼 (等級 4)",
		["Growl (Rank 5)"] = "低吼 (等級 5)",
		["Growl (Rank 6)"] = "低吼 (等級 6)",
		["Growl (Rank 7)"] = "低吼 (等級 7)",
		["Growl (Rank 8)"] = "低吼 (等級 8)",
		["Lightning Breath (Rank 1)"] = "閃電吐息 (等級 1)",
		["Lightning Breath (Rank 2)"] = "閃電吐息 (等級 2)",
		["Lightning Breath (Rank 3)"] = "閃電吐息 (等級 3)",
		["Lightning Breath (Rank 4)"] = "閃電吐息 (等級 4)",
		["Lightning Breath (Rank 5)"] = "閃電吐息 (等級 5)",
		["Lightning Breath (Rank 6)"] = "閃電吐息 (等級 6)",
		["Natural Armor (Rank 1)"] = "自然護甲 (等級 1)",
		["Natural Armor (Rank 10)"] = "自然護甲 (等級 10)",
		["Natural Armor (Rank 11)"] = "自然護甲 (等級 11)",
		["Natural Armor (Rank 2)"] = "自然護甲 (等級 2)",
		["Natural Armor (Rank 3)"] = "自然護甲 (等級 3)",
		["Natural Armor (Rank 4)"] = "自然護甲 (等級 4)",
		["Natural Armor (Rank 5)"] = "自然護甲 (等級 5)",
		["Natural Armor (Rank 6)"] = "自然護甲 (等級 6)",
		["Natural Armor (Rank 7)"] = "自然護甲 (等級 7)",
		["Natural Armor (Rank 8)"] = "自然護甲 (等級 8)",
		["Natural Armor (Rank 9)"] = "自然護甲 (等級 9)",
		["Nature Resistance (Rank 1)"] = "自然抗性 (等級 1)",
		["Nature Resistance (Rank 2)"] = "自然抗性 (等級 2)",
		["Nature Resistance (Rank 3)"] = "自然抗性 (等級 3)",
		["Nature Resistance (Rank 4)"] = "自然抗性 (等級 4)",
		["Nature Resistance (Rank 5)"] = "自然抗性 (等級 5)",
		["Poison Spit (Rank 1)"] = "毒液噴射 (等級 1)",
		["Poison Spit (Rank 2)"] = "毒液噴射 (等級 2)",
		["Poison Spit (Rank 3)"] = "毒液噴射 (等級 3)",
		["Prowl (Rank 1)"] = "潛行 (等級 1)",
		["Prowl (Rank 2)"] = "潛行 (等級 2)",
		["Prowl (Rank 3)"] = "潛行 (等級 3)",
		["Scorpid Poison (Rank 1)"] = "蠍毒 (等級 1)",
		["Scorpid Poison (Rank 2)"] = "蠍毒 (等級 2)",
		["Scorpid Poison (Rank 3)"] = "蠍毒 (等級 3)",
		["Scorpid Poison (Rank 4)"] = "蠍毒 (等級 4)",
		["Scorpid Poison (Rank 5)"] = "蠍毒 (等級 5)",
		["Screech (Rank 1)"] = "尖嘯 (等級 1)",
		["Screech (Rank 2)"] = "尖嘯 (等級 2)",
		["Screech (Rank 3)"] = "尖嘯 (等級 3)",
		["Screech (Rank 4)"] = "尖嘯 (等級 4)",
		["Screech (Rank 5)"] = "尖嘯 (等級 5)",
		["Shadow Resistance (Rank 1)"] = "暗影抗性 (等級 1)",
		["Shadow Resistance (Rank 2)"] = "暗影抗性 (等級 2)",
		["Shadow Resistance (Rank 3)"] = "暗影抗性 (等級 3)",
		["Shadow Resistance (Rank 4)"] = "暗影抗性 (等級 4)",
		["Shadow Resistance (Rank 5)"] = "暗影抗性 (等級 5)",
		["Shell Shield (Rank 1)"] = "甲殼護盾 (等級 1)",
		["Thunderstomp (Rank 1)"] = "雷霆踐踏 (等級 1)",
		["Thunderstomp (Rank 2)"] = "雷霆踐踏 (等級 2)",
		["Thunderstomp (Rank 3)"] = "雷霆踐踏 (等級 3)",
		["Warp (Rank 1)"] = "扭曲傳送 (等級 1)",

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "堅鋼胸甲",
		["Adamantite Cleaver"] = "堅鋼斬斧",
		["Adamantite Dagger"] = "堅鋼匕首",
		["Adamantite Maul"] = "堅鋼大槌",
		["Adamantite Plate Bracers"] = "堅鋼鎧甲護腕",
		["Adamantite Plate Gloves"] = "堅鋼鎧甲手套",
		["Adamantite Rapier"] = "堅鋼細劍",
		["Adamantite Rod"] = "堅鋼魔棒",
		["Adamantite Sharpening Stone"] = "堅鋼磨刀石",
		["Adamantite Weapon Chain"] = "堅鋼武器鍊",
		["Adamantite Weightstone"] = "堅鋼平衡石",
		["Annihilator"] = "殲滅者",
		["Arcanite Champion"] = "奧金勇士劍",
		["Arcanite Reaper"] = "奧金斧",
		["Arcanite Rod"] = "奧金棒",
		["Arcanite Skeleton Key"] = "奧金骷髏鑰匙",
		["Barbaric Iron Boots"] = "野人鐵靴",
		["Barbaric Iron Breastplate"] = "野人鐵胸甲",
		["Barbaric Iron Gloves"] = "野人鐵手套",
		["Barbaric Iron Helm"] = "野人鐵頭盔",
		["Barbaric Iron Shoulders"] = "野人鐵護肩",
		["Belt of the Guardian"] = "守衛者腰帶",
		["Big Black Mace"] = "巨型黑錘",
		["Big Bronze Knife"] = "青銅匕首",
		["Black Amnesty"] = "黑色赦免者",
		["Black Felsteel Bracers"] = "黑魔鋼護腕",
		["Black Grasp of the Destroyer"] = "黑色毀滅者手套",
		["Black Planar Edge"] = "黑色異界之鋒",
		["Blackfury"] = "黑色怒火",
		["Blackguard"] = "黑色衛士",
		["Blazefury"] = "燃燒之怒",
		["Blazeguard"] = "燃燒守護者",
		["Blazing Rapier"] = "閃耀輕劍",
		["Blessed Bracers"] = "受祝福的護腕",
		["Blight"] = "荒蕪",
		["Bloodmoon"] = "血月",
		["Bloodsoul Breastplate"] = "血魂胸甲",
		["Bloodsoul Gauntlets"] = "血魂護手",
		["Bloodsoul Shoulders"] = "血魂護肩",
		["Blue Glittering Axe"] = "藍光斧",
		["Boots of the Protector"] = "保衛者之靴",
		["Bracers of the Green Fortress"] = "綠色堡壘護腕",
		["Breastplate of Kings"] = "王者胸甲",
		["Bronze Axe"] = "青銅斧",
		["Bronze Battle Axe"] = "青銅戰斧",
		["Bronze Greatsword"] = "青銅巨劍",
		["Bronze Mace"] = "青銅釘錘",
		["Bronze Shortsword"] = "青銅短劍",
		["Bronze Warhammer"] = "青銅戰錘",
		["Bulwark of Kings"] = "諸王壁壘",
		["Bulwark of the Ancient Kings"] = "遠古諸王壁壘",
		["Coarse Grinding Stone"] = "粗製砂輪",
		["Coarse Sharpening Stone"] = "粗製磨刀石",
		["Coarse Weightstone"] = "粗製平衡石",
		["Copper Axe"] = "銅斧",
		["Copper Battle Axe"] = "銅質戰斧",
		["Copper Bracers"] = "銅質護腕",
		["Copper Chain Belt"] = "銅質鍊甲腰帶",
		["Copper Chain Boots"] = "銅質鍊甲戰靴",
		["Copper Chain Pants"] = "銅質鍊甲便褲",
		["Copper Chain Vest"] = "銅質鍊甲外衣",
		["Copper Claymore"] = "銅質巨刃劍",
		["Copper Dagger"] = "銅質匕首",
		["Copper Mace"] = "銅質釘錘",
		["Copper Shortsword"] = "銅質短劍",
		["Corruption"] = "腐蝕",
		["Dark Iron Boots"] = "黑鐵戰靴",
		["Dark Iron Bracers"] = "黑鐵護腕",
		["Dark Iron Destroyer"] = "黑鐵戰斧",
		["Dark Iron Gauntlets"] = "黑鐵護手",
		["Dark Iron Helm"] = "黑鐵頭盔",
		["Dark Iron Leggings"] = "黑鐵護腿",
		["Dark Iron Mail"] = "黑鐵鎖甲",
		["Dark Iron Plate"] = "黑鐵鎧甲",
		["Dark Iron Pulverizer"] = "黑鐵粉碎者",
		["Dark Iron Reaver"] = "黑鐵掠刃",
		["Dark Iron Shoulders"] = "黑鐵護肩",
		["Dark Iron Sunderer"] = "黑鐵斬碎者",
		["Darkrune Breastplate"] = "暗色符文胸甲",
		["Darkrune Gauntlets"] = "暗色符文護手",
		["Darkrune Helm"] = "暗色符文頭盔",
		["Darksoul Breastplate"] = "黑暗之魂胸甲",
		["Darksoul Leggings"] = "黑暗之魂護腿",
		["Darksoul Shoulders"] = "黑暗之魂護肩",
		["Dawnbringer Shoulders"] = "黎明使者護肩",
		["Dawn's Edge"] = "黎明之鋒",
		["Dawnsteel Bracers"] = "黎明鋼鐵護腕",
		["Dawnsteel Shoulders"] = "黎明鋼鐵護肩",
		["Dazzling Mithril Rapier"] = "秘銀細劍",
		["Deadly Bronze Poniard"] = "致命的青銅短劍",
		["Deep Thunder"] = "深雷",
		["Demon Forged Breastplate"] = "魔鑄胸甲",
		["Dense Grinding Stone"] = "緻密砂輪",
		["Dense Sharpening Stone"] = "緻密磨刀石",
		["Dense Weightstone"] = "緻密平衡石",
		["Dirge"] = "輓歌之刃",
		["Dragonmaw"] = "龍喉",
		["Dragonstrike"] = "龍擊",
		["Drakefist Hammer"] = "龍拳之錘",
		["Earthforged Leggings"] = "地鑄護腿",
		["Earthpeace Breastplate"] = "大地和平胸甲",
		["Ebon Hand"] = "黑檀之手",
		["Ebon Shiv"] = "黑檀剃刃",
		["Edge of Winter"] = "寒冬之鋒",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Embrace of the Twisting Nether"] = "扭曲虛空之擁",
		["Enchanted Adamantite Belt"] = "附魔堅鋼腰帶",
		["Enchanted Adamantite Boots"] = "附魔堅鋼長靴",
		["Enchanted Adamantite Breastplate"] = "附魔堅鋼胸甲",
		["Enchanted Adamantite Leggings"] = "附魔堅鋼護腿",
		["Enchanted Battlehammer"] = "附魔戰錘",
		["Enchanted Thorium Blades"] = "附魔瑟銀刃",
		["Enchanted Thorium Breastplate"] = "附魔瑟銀胸甲",
		["Enchanted Thorium Helm"] = "附魔瑟銀頭盔",
		["Enchanted Thorium Leggings"] = "附魔瑟銀護腿",
		["Eternium Rod"] = "恆金棒",
		["Eternium Runed Blade"] = "恆金符文刃",
		["Fel Edged Battleaxe"] = "魔鋒戰斧",
		["Fel Hardened Maul"] = "魔鐵強化槌",
		["Fel Iron Breastplate"] = "魔鐵胸甲",
		["Fel Iron Chain Bracers"] = "魔鐵鍊甲護腕",
		["Fel Iron Chain Coif"] = "魔鐵鍊甲頭盔",
		["Fel Iron Chain Gloves"] = "魔鐵鍊甲手套",
		["Fel Iron Chain Tunic"] = "魔鐵鍊甲外套",
		["Fel Iron Greatsword"] = "魔鐵巨劍",
		["Fel Iron Hammer"] = "魔鐵錘",
		["Fel Iron Hatchet"] = "魔鐵短斧",
		["Fel Iron Plate Belt"] = "魔鐵鎧甲腰帶",
		["Fel Iron Plate Boots"] = "魔鐵鎧甲長靴",
		["Fel Iron Plate Gloves"] = "魔鐵鎧甲手套",
		["Fel Iron Plate Pants"] = "魔鐵鎧甲便褲",
		["Fel Iron Rod"] = "魔鐵棒",
		["Fel Sharpening Stone"] = "惡魔磨刀石",
		["Fel Weightstone"] = "惡魔平衡石",
		["Felfury Gauntlets"] = "魔怒護手",
		["Felsteel Gloves"] = "魔鋼手套",
		["Felsteel Helm"] = "魔鋼頭盔",
		["Felsteel Leggings"] = "魔鋼護腿",
		["Felsteel Longblade"] = "魔鋼長刃",
		["Felsteel Reaper"] = "魔鋼斧",
		["Felsteel Shield Spike"] = "魔鋼盾刺",
		["Felsteel Whisper Knives"] = "魔鋼耳語小刀",
		["Fiery Blaze Enchantment"] = "熾熱魔符",
		["Fiery Chain Girdle"] = "熾熱鍊甲束腰",
		["Fiery Chain Shoulders"] = "熾熱鍊甲護肩",
		["Fiery Plate Gauntlets"] = "熾熱鎧甲護手",
		["Fireguard"] = "火焰衛士",
		["Flamebane Bracers"] = "烈焰毀滅護腕",
		["Flamebane Breastplate"] = "烈焰毀滅胸甲",
		["Flamebane Gloves"] = "烈焰毀滅手套",
		["Flamebane Helm"] = "烈焰毀滅頭盔",
		["Frost Tiger Blade"] = "霜虎之刃",
		["Frostguard"] = "寒冰護衛者",
		["Gauntlets of the Iron Tower"] = "鐵塔護手",
		["Gemmed Copper Gauntlets"] = "銅質寶石護手",
		["Girdle of the Dawn"] = "黎明束腰",
		["Glinting Steel Dagger"] = "亮閃閃的鋼匕首",
		["Gloves of the Dawn"] = "黎明手套",
		["Golden Iron Destroyer"] = "碎鐵金錘",
		["Golden Rod"] = "金棒",
		["Golden Scale Boots"] = "金鱗戰靴",
		["Golden Scale Bracers"] = "金鱗護腕",
		["Golden Scale Coif"] = "金鱗罩盔",
		["Golden Scale Cuirass"] = "金鱗胸衣",
		["Golden Scale Gauntlets"] = "金鱗護手",
		["Golden Scale Leggings"] = "金鱗護腿",
		["Golden Scale Shoulders"] = "金鱗護肩",
		["Golden Skeleton Key"] = "金骷髏鑰匙",
		["Great Earthforged Hammer"] = "大型地鑄戰錘",
		["Greater Rune of Warding"] = "強效結界符文",
		["Greater Ward of Shielding"] = "強效護盾護咒",
		["Green Iron Boots"] = "綠鐵戰靴",
		["Green Iron Bracers"] = "綠鐵護腕",
		["Green Iron Gauntlets"] = "綠鐵護手",
		["Green Iron Hauberk"] = "綠鐵鍊衫",
		["Green Iron Helm"] = "綠鐵頭盔",
		["Green Iron Leggings"] = "綠鐵護腿",
		["Green Iron Shoulders"] = "綠鐵護肩",
		["Hard Khorium Battlefists"] = "特硬克銀戰拳",
		["Hard Khorium Battleplate"] = "特硬克銀戰甲",
		["Hammer of Righteous Might"] = "公正力量之錘",
		["Hammer of the Titans"] = "泰坦之錘",
		["Hand of Eternity"] = "永恆之手",
		["Hardened Iron Shortsword"] = "硬鐵短劍",
		["Heartseeker"] = "尋心者",
		["Heavy Bronze Mace"] = "青銅重錘",
		["Heavy Copper Broadsword"] = "重銅寬劍",
		["Heavy Copper Longsword"] = "重銅長劍",
		["Heavy Copper Maul"] = "重銅大槌",
		["Heavy Earthforged Breastplate"] = "重型地鑄胸甲",
		["Heavy Grinding Stone"] = "重砂輪",
		["Heavy Mithril Axe"] = "秘銀重斧",
		["Heavy Mithril Boots"] = "秘銀重靴",
		["Heavy Mithril Breastplate"] = "重型秘銀胸甲",
		["Heavy Mithril Gauntlet"] = "重型秘銀護手",
		["Heavy Mithril Helm"] = "重型秘銀頭盔",
		["Heavy Mithril Pants"] = "秘銀便褲",
		["Heavy Mithril Shoulder"] = "重型秘銀護肩",
		["Heavy Obsidian Belt"] = "厚重黑曜石腰帶",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Heavy Timbermaw Belt"] = "重型木喉腰帶",
		["Heavy Timbermaw Boots"] = "重型木喉長靴",
		["Heavy Weightstone"] = "重平衡石",
		["Helm of the Great Chief"] = "大酋長頭盔",
		["Helm of the Stalwart Defender"] = "堅實防衛者頭盔",
		["Huge Thorium Battleaxe"] = "巨型瑟銀戰斧",
		["Icebane Bracers"] = "冰剋護腕",
		["Icebane Breastplate"] = "冰剋胸甲",
		["Icebane Gauntlets"] = "冰剋護手",
		["Iceguard Breastplate"] = "冰霜守衛胸甲",
		["Iceguard Helm"] = "冰霜守衛頭盔",
		["Iceguard Leggings"] = "冰霜守衛護腿",
		["Imperial Plate Belt"] = "君王鎧甲腰帶",
		["Imperial Plate Boots"] = "君王鎧甲靴",
		["Imperial Plate Bracers"] = "君王鎧甲護腕",
		["Imperial Plate Chest"] = "君王鎧甲護胸",
		["Imperial Plate Helm"] = "君王鎧甲頭盔",
		["Imperial Plate Leggings"] = "君王鎧甲護腿",
		["Imperial Plate Shoulders"] = "君王鎧甲護肩",
		["Inlaid Mithril Cylinder"] = "秘銀杆",
		["Invulnerable Mail"] = "免傷鎖甲",
		["Iridescent Hammer"] = "彩虹之錘",
		["Iron Buckle"] = "鐵扣環",
		["Iron Counterweight"] = "鐵質平衡錘",
		["Iron Shield Spike"] = "鐵質盾刺",
		["Ironforge Breastplate"] = "鐵爐堡胸甲",
		["Ironvine Belt"] = "鐵藤腰帶",
		["Ironvine Breastplate"] = "鐵藤胸甲",
		["Ironvine Gloves"] = "鐵藤手套",
		["Jade Serpentblade"] = "玉蛇刃",
		["Jagged Obsidian Shield"] = "鋸齒黑曜石之盾",
		["Khorium Belt"] = "克銀腰帶",
		["Khorium Boots"] = "克銀長靴",
		["Khorium Champion"] = "克銀勇士",
		["Khorium Pants"] = "克銀便褲",
		["Lavaforged Warhammer"] = "熔鑄戰錘",
		["Lesser Rune of Warding"] = "次級結界符文",
		["Lesser Ward of Shielding"] = "次級護盾護咒",
		["Light Earthforged Blade"] = "輕地鑄之刃",
		["Light Emberforged Hammer"] = "輕煤鑄之錘",
		["Light Obsidian Belt"] = "輕巧黑曜石腰帶",
		["Light Skyforged Axe"] = "空鑄輕斧",
		["Lionheart Blade"] = "獅心之刃",
		["Lionheart Champion"] = "獅心勇士劍",
		["Lionheart Executioner"] = "獅心斬首者",
		["Lionheart Helm"] = "獅心頭盔",
		["Lunar Crescent"] = "新月斧",
		["Massive Iron Axe"] = "巨型鐵斧",
		["Masterwork Stormhammer"] = "精工風暴戰錘",
		["Mighty Iron Hammer"] = "巨型鐵錘",
		["Mithril Coif"] = "秘銀頭巾",
		["Mithril Scale Bracers"] = "秘銀鱗片護腕",
		["Mithril Scale Gloves"] = "秘銀鱗片手套",
		["Mithril Scale Pants"] = "秘銀鱗片便褲",
		["Mithril Scale Shoulders"] = "秘銀鱗片護肩",
		["Mithril Shield Spike"] = "秘銀盾刺",
		["Mithril Spurs"] = "秘銀馬刺",
		["Mooncleaver"] = "月光斬斧",
		["Moonsteel Broadsword"] = "月鋼寬劍",
		["Nether Chain Shirt"] = "虛空鍊衫",
		["Nightfall"] = "夜幕",
		["Oathkeeper's Helm"] = "誓言守護者頭盔",
		["Obsidian Mail Tunic"] = "黑曜石鎖甲外套",
		["Orcish War Leggings"] = "獸人護腿",
		["Ornate Mithril Boots"] = "華麗秘銀戰靴",
		["Ornate Mithril Breastplate"] = "華麗秘銀胸甲",
		["Ornate Mithril Gloves"] = "華麗秘銀手套",
		["Ornate Mithril Helm"] = "華麗秘銀頭盔",
		["Ornate Mithril Pants"] = "華麗秘銀便褲",
		["Ornate Mithril Shoulder"] = "華麗秘銀護肩",
		["Ornate Thorium Handaxe"] = "華麗瑟銀手斧",
		["Patterned Bronze Bracers"] = "青銅花紋護腕",
		["Pearl-handled Dagger"] = "珍珠匕首",
		["Persuader"] = "刺錘",
		["Phantom Blade"] = "魅影之刃",
		["Polished Steel Boots"] = "拋光鋼鐵戰靴",
		["Radiant Belt"] = "輻光腰帶",
		["Radiant Boots"] = "輻光長靴",
		["Radiant Breastplate"] = "輻光胸甲",
		["Radiant Circlet"] = "輻光頭環",
		["Radiant Gloves"] = "輻光手套",
		["Radiant Leggings"] = "輻光護腿",
		["Ragesteel Breastplate"] = "怒鋼胸甲",
		["Ragesteel Gloves"] = "怒鋼手套",
		["Ragesteel Helm"] = "怒鋼頭盔",
		["Ragesteel Shoulders"] = "怒鋼護肩",
		["Red Belt of Battle"] = "紅色戰鬥腰帶",
		["Red Havoc Boots"] = "紅色浩劫戰靴",
		["Rough Bronze Boots"] = "劣質青銅戰靴",
		["Rough Bronze Bracers"] = "劣質青銅護腕",
		["Rough Bronze Cuirass"] = "劣質青銅胸衣",
		["Rough Bronze Leggings"] = "劣質青銅護腿",
		["Rough Bronze Shoulders"] = "劣質青銅護肩",
		["Rough Copper Vest"] = "劣質銅外衣",
		["Rough Grinding Stone"] = "劣質砂輪",
		["Rough Sharpening Stone"] = "劣質磨刀石",
		["Rough Weightstone"] = "劣質平衡石",
		["Runed Copper Belt"] = "銅質符文腰帶",
		["Runed Copper Bracers"] = "銅質符文護腕",
		["Runed Copper Breastplate"] = "銅質符文胸甲",
		["Runed Copper Gauntlets"] = "銅質符文護手",
		["Runed Copper Pants"] = "銅質符文便褲",
		["Runed Mithril Hammer"] = "秘銀符文戰錘",
		["Runic Breastplate"] = "符文胸甲",
		["Runic Hammer"] = "符文錘",
		["Runic Plate Boots"] = "符文鎧甲靴",
		["Runic Plate Helm"] = "符文鎧甲頭盔",
		["Runic Plate Leggings"] = "符文鎧甲護腿",
		["Runic Plate Shoulders"] = "符文鎧甲護肩",
		["Sageblade"] = "賢者之刃",
		["Searing Golden Blade"] = "灼熱金刃",
		["Serenity"] = "平靜",
		["Shadesteel Bracers"] = "影堅護腕",
		["Shadesteel Girdle"] = "影堅束腰",
		["Shadesteel Greaves"] = "影堅護脛",
		["Shadesteel Sabots"] = "影堅戰靴",
		["Shadow Crescent Axe"] = "暗影月牙斧",
		["Shining Silver Breastplate"] = "銀鱗胸甲",
		["Silver Rod"] = "銀棒",
		["Silver Skeleton Key"] = "銀骷髏鑰匙",
		["Silvered Bronze Boots"] = "鍍銀青銅戰靴",
		["Silvered Bronze Breastplate"] = "鍍銀青銅胸甲",
		["Silvered Bronze Gauntlets"] = "鍍銀青銅護手",
		["Silvered Bronze Leggings"] = "鍍銀青銅護腿",
		["Silvered Bronze Shoulders"] = "鍍銀青銅護肩",
		["Skyforged Great Axe"] = "空鑄巨斧",
		["Solid Grinding Stone"] = "堅固的砂輪",
		["Solid Iron Maul"] = "堅固的鐵槌",
		["Solid Sharpening Stone"] = "堅固的磨刀石",
		["Solid Weightstone"] = "堅固的平衡石",
		["Steel Breastplate"] = "鋼質胸甲",
		["Steel Plate Helm"] = "鋼質頭盔",
		["Steel Weapon Chain"] = "鋼質武器鍊",
		["Steelgrip Gauntlets"] = "鋼握護手",
		["Stoneforged Claymore"] = "石鑄巨刃劍",
		["Storm Gauntlets"] = "風暴護手",
		["Storm Helm"] = "風暴頭盔",
		["Stormforged Axe"] = "暴風冶煉之斧",
		["Stormforged Hauberk"] = "暴風冶煉鍊衫",
		["Stormherald"] = "風暴信使",
		["Stronghold Gauntlets"] = "要塞護手",
		["Sunblessed Breastplate"] = "太陽祝福胸甲",
		["Sunblessed Gauntlets"] = "太陽祝福護手",
		["Sulfuron Hammer"] = "薩弗隆戰錘",
		["Swiftsteel Bracers"] = "迅鋼護腕",
		["Swiftsteel Gloves"] = "迅鋼手套",
		["Swiftsteel Shoulders"] = "迅鋼護肩",
		["The Planar Edge"] = "異界之鋒",
		["The Shatterer"] = "粉碎者",
		["Thick Bronze Darts"] = "厚青銅飛鏢",
		["Thick Obsidian Breastplate"] = "厚黑曜石胸甲",
		["Thick War Axe"] = "厚重的戰斧",
		["Thorium Armor"] = "瑟銀護甲",
		["Thorium Belt"] = "瑟銀腰帶",
		["Thorium Boots"] = "瑟銀長靴",
		["Thorium Bracers"] = "瑟銀護腕",
		["Thorium Helm"] = "瑟銀頭盔",
		["Thorium Leggings"] = "瑟銀護腿",
		["Thorium Shield Spike"] = "瑟銀盾刺",
		["Thunder"] = "雷",
		["Titanic Leggings"] = "泰坦護腿",
		["Truesilver Breastplate"] = "真銀胸甲",
		["Truesilver Champion"] = "真銀勇士劍",
		["Truesilver Gauntlets"] = "真銀護手",
		["Truesilver Rod"] = "真銀棒",
		["Truesilver Skeleton Key"] = "真銀骷髏鑰匙",
		["Twisting Nether Chain Shirt"] = "扭曲虛空鍊衫",
		["Volcanic Hammer"] = "火山戰錘",
		["Whirling Steel Axes"] = "旋風鐵斧",
		["Whitesoul Helm"] = "白魂頭盔",
		["Wicked Edge of the Planes"] = "諸界邪鋒",
		["Wicked Mithril Blade"] = "秘銀魔刃",
		["Wildguard Breastplate"] = "野性看守者胸甲",
		["Wildguard Helm"] = "野性看守者頭盔",
		["Wildguard Leggings"] = "野性看守者護腿",
		["Wildthorn Mail"] = "野刺鎖甲",
		["Windforged Leggings"] = "風冶護腿",
		["Windforged Rapier"] = "風冶細劍",

-- Cooking Recipes
		["Baked Salmon"] = "烤鮭魚",
		["Barbecued Buzzard Wing"] = "燒烤禿鷲翅膀",
		["Bat Bites"] = "蝙蝠餐點",
		["Beer Basted Boar Ribs"] = "啤酒烤豬排",
		["Big Bear Steak"] = "大塊的熊排",
		["Blackened Basilisk"] = "焦黑的蜥蜴肉串",
		["Blackened Sporefish"] = "焦黑的孢子魚",
		["Blackened Trout"] = "焦黑的鱒魚",
		["Blood Sausage"] = "血腸",
		["Boiled Clams"] = "水煮蚌肉",
		["Brilliant Smallfish"] = "美味小魚",
		["Bristle Whisker Catfish"] = "刺鬚鯰魚",
		["Broiled Bloodfin"] = "烤血鰭",
		["Buzzard Bites"] = "禿鷲便餐",
		["Carrion Surprise"] = "腐肉大餐",
		["Charred Bear Kabobs"] = "燒烤熊肉串",
		["Charred Wolf Meat"] = "燒烤狼肉",
		["Clam Bar"] = "蛤蜊條",
		["Clam Chowder"] = "蚌肉雜燴",
		["Cooked Crab Claw"] = "煮蟹爪",
		["Cooked Glossy Mightfish"] = "煮熟的光滑大魚",
		["Coyote Steak"] = "山狗肉排",
		["Crab Cake"] = "蟹肉蛋糕",
		["Crispy Bat Wing"] = "香脆蝙蝠翅",
		["Crispy Lizard Tail"] = "脆炸蜥蜴尾",
		["Crocolisk Gumbo"] = "鱷魚燴肉",
		["Crocolisk Steak"] = "鱷魚肉排",
		["Crunchy Serpent"] = "香脆巨蛇肉",
		["Crunchy Spider Surprise"] = "香脆蜘蛛大餐",
		["Curiously Tasty Omelet"] = "美味煎蛋捲",
		["Delicious Chocolate Cake"] = "美味巧克力蛋糕",
		["Dig Rat Stew"] = "掘地鼠燉肉",
		["Dirge's Kickin' Chimaerok Chops"] = "戴格的超美味奇美拉肉片",
		["Dragonbreath Chili"] = "龍息紅椒",
		["Dry Pork Ribs"] = "豬肉乾",
		["Egg Nog"] = "蛋奶酒",
		["Feltail Delight"] = "魔尾點心",
		["Filet of Redgill"] = "油炸紅腮魚",
		["Fillet of Frenzy"] = "狂魚肉片",
		["Fisherman's Feast"] = "漁夫大餐",
		["Giant Clam Scorcho"] = "燒烤巨蚌",
		["Gingerbread Cookie"] = "薑餅",
		["Goblin Deviled Clams"] = "哥布林芥末蘸蚌肉",
		["Golden Fish Sticks"] = "金魚肉串",
		["Goldthorn Tea"] = "金棘茶",
		["Gooey Spider Cake"] = "蜘蛛蛋糕",
		["Goretusk Liver Pie"] = "豬肝餡餅",
		["Grilled Mudfish"] = "烤泥鰍",
		["Grilled Squid"] = "烤魷魚",
		["Heavy Crocolisk Stew"] = "鱷魚燉肉",
		["Heavy Kodo Stew"] = "大型科多獸燉肉",
		["Herb Baked Egg"] = "香料烘蛋",
		["Hot Apple Cider"] = "熱蘋果酒",
		["Hot Buttered Trout"] = "熱奶油鱒魚",
		["Hot Lion Chops"] = "烤獅排",
		["Hot Smoked Bass"] = "煙燻鱸魚",
		["Hot Wolf Ribs"] = "辣狼排",
		["Juicy Bear Burger"] = "多汁熊排堡",
		["Jungle Stew"] = "叢林燉肉",
		["Kaldorei Spider Kabob"] = "卡多雷蜘蛛烤肉",
		["Kibler's Bits"] = "基布雷爾的零嘴",
		["Lean Venison"] = "瘦鹿肉",
		["Lean Wolf Steak"] = "瘦狼排",
		["Lobster Stew"] = "龍蝦燉肉",
		["Loch Frenzy Delight"] = "洛克湖狂魚湯",
		["Longjaw Mud Snapper"] = "長嘴泥鰍",
		["Lynx Steak"] = "山貓肉排",
		["Mightfish Steak"] = "大魚片",
		["Mithril Headed Trout"] = "銀頭鱒魚",
		["Mok'Nathal Shortribs"] = "摩克納薩爾小肋排",
		["Monster Omelet"] = "超級煎蛋捲",
		["Murloc Fin Soup"] = "魚人鰭湯",
		["Mystery Stew"] = "神秘燉肉",
		["Nightfin Soup"] = "夜鱗魚湯",
		["Poached Bluefish"] = "水煮藍魚",
		["Poached Sunscale Salmon"] = "水煮陽鱗鮭魚",
		["Rainbow Fin Albacore"] = "彩鰭魚",
		["Ravager Dog"] = "劫毀熱狗",
		["Redridge Goulash"] = "赤脊山燉肉",
		["Roast Raptor"] = "烤迅猛龍肉",
		["Roasted Boar Meat"] = "烤野豬肉",
		["Roasted Clefthoof"] = "燒烤裂蹄肉",
		["Roasted Kodo Meat"] = "烤科多肉",
		["Roasted Moongraze Tenderloin"] = "燒烤牧月鹿腰肉",
		["Rockscale Cod"] = "石鱗鱈魚",
		["Runn Tum Tuber Surprise"] = "洛恩塔姆薯塊",
		["Sagefish Delight"] = "美味鼠尾魚",
		["Savory Deviate Delight"] = "美味變異點心",
		["Scorpid Surprise"] = "蠍肉大餐",
		["Seasoned Wolf Kabob"] = "乾烤狼肉串",
		["Skullfish Soup"] = "鯨肉湯",
		["Slitherskin Mackerel"] = "滑皮鯖魚",
		["Smoked Bear Meat"] = "燻熊肉",
		["Smoked Desert Dumplings"] = "沙漠肉丸子",
		["Smoked Sagefish"] = "烤鼠尾魚",
		["Soothing Turtle Bisque"] = "海龜湯",
		["Spice Bread"] = "香料麵包",
		["Spiced Chili Crab"] = "辣椒蟹肉",
		["Spiced Wolf Meat"] = "香辣狼肉",
		["Spicy Crawdad"] = "香辣喇蛄",
		["Spicy Hot Talbuk"] = "辣炒塔巴克",
		["Spider Sausage"] = "蜘蛛肉腸",
		["Sporeling Snack"] = "小孢子點心",
		["Spotted Yellowtail"] = "斑點黃尾魚",
		["Stewed Trout"] = "鱒魚燉肉",
		["Stormchops"] = "風暴肉排",
		["Strider Stew"] = "陸行鳥燉肉",
		["Succulent Pork Ribs"] = "多汁豬排",
		["Talbuk Steak"] = "塔巴克肉排",
		["Tasty Lion Steak"] = "香烤獅肉",
		["Tender Wolf Steak"] = "嫩狼肉排",
		["Thistle Tea"] = "菊花茶",
		["Undermine Clam Chowder"] = "安德麥蚌肉雜燴",
		["Warp Burger"] = "扭曲漢堡",
		["Westfall Stew"] = "西部荒野燉肉",

-- Enchanting Recipes
		["Brilliant Mana Oil"] = "卓越法力之油",
		["Brilliant Wizard Oil"] = "卓越巫師之油",
		["Enchant 2H Weapon - Agility"] = "附魔雙手武器 - 敏捷",
		["Enchant 2H Weapon - Greater Impact"] = "附魔雙手武器 - 強效衝擊",
		["Enchant 2H Weapon - Impact"] = "附魔雙手武器 - 衝擊",
		["Enchant 2H Weapon - Lesser Impact"] = "附魔雙手武器 - 次級衝擊",
		["Enchant 2H Weapon - Lesser Intellect"] = "附魔雙手武器 - 次級智力",
		["Enchant 2H Weapon - Lesser Spirit"] = "附魔雙手武器 - 次級精神",
		["Enchant 2H Weapon - Major Agility"] = "附魔雙手武器 - 極效敏捷",
		["Enchant 2H Weapon - Major Intellect"] = "附魔雙手武器 - 極效智力",
		["Enchant 2H Weapon - Major Spirit"] = "附魔雙手武器 - 極效精神",
		["Enchant 2H Weapon - Minor Impact"] = "附魔雙手武器 - 初級衝擊",
		["Enchant 2H Weapon - Savagery"] = "附魔雙手武器 - 兇蠻",
		["Enchant 2H Weapon - Superior Impact"] = "附魔雙手武器 - 超強衝擊",
		["Enchant Boots - Agility"] = "附魔靴子 - 敏捷",
		["Enchant Boots - Boar's Speed"] = "附魔靴子 - 野豬之速",
		["Enchant Boots - Cat's Swiftness"] = "附魔靴子 - 貓之迅捷",
		["Enchant Boots - Dexterity"] = "附魔靴子 - 靈巧",
		["Enchant Boots - Fortitude"] = "附魔靴子 - 堅韌",
		["Enchant Boots - Greater Agility"] = "附魔靴子 - 強效敏捷",
		["Enchant Boots - Greater Stamina"] = "附魔靴子 - 強效耐力",
		["Enchant Boots - Lesser Agility"] = "附魔靴子 - 次級敏捷",
		["Enchant Boots - Lesser Spirit"] = "附魔靴子 - 次級精神",
		["Enchant Boots - Lesser Stamina"] = "附魔靴子 - 次級耐力",
		["Enchant Boots - Minor Agility"] = "附魔靴子 - 初級敏捷",
		["Enchant Boots - Minor Speed"] = "附魔靴子 - 初級速度",
		["Enchant Boots - Minor Stamina"] = "附魔靴子 - 初級耐力",
		["Enchant Boots - Spirit"] = "附魔靴子 - 精神",
		["Enchant Boots - Stamina"] = "附魔靴子 - 耐力",
		["Enchant Boots - Surefooted"] = "附魔靴子 - 穩固",
		["Enchant Boots - Vitality"] = "附魔靴子 - 活力",
		["Enchant Bracer - Assault"] = "附魔護腕 - 攻擊",
		["Enchant Bracer - Brawn"] = "附魔護腕 - 健壯",
		["Enchant Bracer - Deflection"] = "附魔護腕 - 偏斜",
		["Enchant Bracer - Fortitude"] = "附魔護腕 - 堅韌",
		["Enchant Bracer - Greater Intellect"] = "附魔護腕 - 強效智力",
		["Enchant Bracer - Greater Spirit"] = "附魔護腕 - 強效精神",
		["Enchant Bracer - Greater Stamina"] = "附魔護腕 - 強效耐力",
		["Enchant Bracer - Greater Strength"] = "附魔護腕 - 強效力量",
		["Enchant Bracer - Healing Power"] = "附魔護腕 - 治療能量",
		["Enchant Bracer - Intellect"] = "附魔護腕 - 智力",
		["Enchant Bracer - Lesser Deflection"] = "附魔護腕 - 次級偏斜",
		["Enchant Bracer - Lesser Intellect"] = "附魔護腕 - 次級智力",
		["Enchant Bracer - Lesser Spirit"] = "附魔護腕 - 次級精神",
		["Enchant Bracer - Lesser Stamina"] = "附魔護腕 - 次級耐力",
		["Enchant Bracer - Lesser Strength"] = "附魔護腕 - 次級力量",
		["Enchant Bracer - Major Defense"] = "附魔護腕 - 極效防禦",
		["Enchant Bracer - Major Intellect"] = "附魔護腕 - 極效智力",
		["Enchant Bracer - Mana Regeneration"] = "附魔護腕 - 法力恢復",
		["Enchant Bracer - Minor Agility"] = "附魔護腕 - 初級敏捷",
		["Enchant Bracer - Minor Deflection"] = "附魔護腕 - 初級偏斜",
		["Enchant Bracer - Minor Health"] = "附魔護腕 - 初級生命",
		["Enchant Bracer - Minor Spirit"] = "附魔護腕 - 初級精神",
		["Enchant Bracer - Minor Stamina"] = "附魔護腕 - 初級耐力",
		["Enchant Bracer - Minor Strength"] = "附魔護腕 - 初級力量",
		["Enchant Bracer - Restore Mana Prime"] = "附魔護腕 - 基礎法力恢復",
		["Enchant Bracer - Spellpower"] = "附魔護腕 - 法術能量",
		["Enchant Bracer - Spirit"] = "附魔護腕 - 精神",
		["Enchant Bracer - Stamina"] = "附魔護腕 - 耐力",
		["Enchant Bracer - Stats"] = "附魔護腕 - 屬性",
		["Enchant Bracer - Strength"] = "附魔護腕 - 力量",
		["Enchant Bracer - Superior Healing"] = "附魔護腕 - 超強治療",
		["Enchant Bracer - Superior Spirit"] = "附魔護腕 - 超強精神",
		["Enchant Bracer - Superior Stamina"] = "附魔護腕 - 超強耐力",
		["Enchant Bracer - Superior Strength"] = "附魔護腕 - 超強力量",
		["Enchant Chest - Defense"] = "附魔胸甲 - 防禦",
		["Enchant Chest - Exceptional Health"] = "附魔胸甲 - 特殊生命",
		["Enchant Chest - Exceptional Stats"] = "附魔胸甲 - 特殊屬性",
		["Enchant Chest - Greater Health"] = "附魔胸甲 - 強效生命",
		["Enchant Chest - Greater Mana"] = "附魔胸甲 - 強效法力",
		["Enchant Chest - Greater Stats"] = "附魔胸甲 - 強效屬性",
		["Enchant Chest - Health"] = "附魔胸甲 - 生命",
		["Enchant Chest - Lesser Absorption"] = "附魔胸甲 - 次級吸收",
		["Enchant Chest - Lesser Health"] = "附魔胸甲 - 次級生命",
		["Enchant Chest - Lesser Mana"] = "附魔胸甲 - 次級法力",
		["Enchant Chest - Lesser Stats"] = "附魔胸甲 - 次級屬性",
		["Enchant Chest - Major Health"] = "附魔胸甲 - 極效生命",
		["Enchant Chest - Major Mana"] = "附魔胸甲 - 極效法力",
		["Enchant Chest - Major Resilience"] = "附魔胸甲 - 極效韌性",
		["Enchant Chest - Major Spirit"] = "附魔胸甲 - 極效精神",
		["Enchant Chest - Mana"] = "附魔胸甲 - 法力",
		["Enchant Chest - Minor Absorption"] = "附魔胸甲 - 初級吸收",
		["Enchant Chest - Minor Health"] = "附魔胸甲 - 初級生命",
		["Enchant Chest - Minor Mana"] = "附魔胸甲 - 初級法力",
		["Enchant Chest - Minor Stats"] = "附魔胸甲 - 初級屬性",
		["Enchant Chest - Restore Mana Prime"] = "附魔胸甲 - 基礎法力恢復",
		["Enchant Chest - Stats"] = "附魔胸甲 - 屬性",
		["Enchant Chest - Superior Health"] = "附魔胸甲 - 超強生命",
		["Enchant Chest - Superior Mana"] = "附魔胸甲 - 超強法力",
		["Enchant Cloak - Defense"] = "附魔披風 - 防禦",
		["Enchant Cloak - Dodge"] = "附魔披風 - 閃躲",
		["Enchant Cloak - Fire Resistance"] = "附魔披風 - 火焰抗性",
		["Enchant Cloak - Greater Agility"] = "附魔披風 - 強效敏捷",
		["Enchant Cloak - Greater Arcane Resistance"] = "附魔披風 - 強效秘法抗性",
		["Enchant Cloak - Greater Defense"] = "附魔披風 - 強效防禦",
		["Enchant Cloak - Greater Fire Resistance"] = "附魔披風 - 強效火焰抗性",
		["Enchant Cloak - Greater Nature Resistance"] = "附魔披風 - 強效自然抗性",
		["Enchant Cloak - Greater Resistance"] = "附魔披風 - 強效抗性",
		["Enchant Cloak - Greater Shadow Resistance"] = "附魔披風 - 強效暗影抗性",
		["Enchant Cloak - Lesser Agility"] = "附魔披風 - 次級敏捷",
		["Enchant Cloak - Lesser Fire Resistance"] = "附魔披風 - 次級火焰抗性",
		["Enchant Cloak - Lesser Protection"] = "附魔披風 - 次級防護",
		["Enchant Cloak - Lesser Shadow Resistance"] = "附魔披風 - 次級暗影抗性",
		["Enchant Cloak - Major Armor"] = "附魔披風 - 極效護甲",
		["Enchant Cloak - Major Resistance"] = "附魔披風 - 極效抗性",
		["Enchant Cloak - Minor Agility"] = "附魔披風 - 初級敏捷",
		["Enchant Cloak - Minor Protection"] = "附魔披風 - 初級防護",
		["Enchant Cloak - Minor Resistance"] = "附魔披風 - 初級抗性",
		["Enchant Cloak - Resistance"] = "附魔披風 - 抗性",
		["Enchant Cloak - Spell Penetration"] = "附魔披風 - 法術穿透",
		["Enchant Cloak - Stealth"] = "附魔披風 - 潛行",
		["Enchant Cloak - Subtlety"] = "附魔披風 - 狡詐",
		["Enchant Cloak - Superior Defense"] = "附魔披風 - 超強防禦",
		["Enchant Gloves - Advanced Herbalism"] = "附魔手套 - 高級草藥學",
		["Enchant Gloves - Advanced Mining"] = "附魔手套 - 高級採礦",
		["Enchant Gloves - Agility"] = "附魔手套 - 敏捷",
		["Enchant Gloves - Assault"] = "附魔手套 - 攻擊",
		["Enchant Gloves - Blasting"] = "附魔手套 - 衝擊",
		["Enchant Gloves - Fire Power"] = "附魔手套 - 火焰能量",
		["Enchant Gloves - Fishing"] = "附魔手套 - 釣魚",
		["Enchant Gloves - Frost Power"] = "附魔手套 - 冰霜能量",
		["Enchant Gloves - Greater Agility"] = "附魔手套 - 強效敏捷",
		["Enchant Gloves - Greater Strength"] = "附魔手套 - 強效力量",
		["Enchant Gloves - Healing Power"] = "附魔手套 - 治療能量",
		["Enchant Gloves - Herbalism"] = "附魔手套 - 草藥學",
		["Enchant Gloves - Major Healing"] = "附魔手套 - 極效治療",
		["Enchant Gloves - Major Spellpower"] = "附魔手套 - 極效法術能量",
		["Enchant Gloves - Major Strength"] = "附魔手套 - 極效力量",
		["Enchant Gloves - Mining"] = "附魔手套 - 採礦",
		["Enchant Gloves - Minor Haste"] = "附魔手套 - 初級加速",
		["Enchant Gloves - Riding Skill"] = "附魔手套 - 騎術",
		["Enchant Gloves - Shadow Power"] = "附魔手套 - 暗影能量",
		["Enchant Gloves - Skinning"] = "附魔手套 - 剝皮",
		["Enchant Gloves - Spell Strike"] = "附魔手套 - 法術打擊",
		["Enchant Gloves - Strength"] = "附魔手套 - 力量",
		["Enchant Gloves - Superior Agility"] = "附魔手套 - 超強敏捷",
		["Enchant Gloves - Threat"] = "附魔手套 - 威脅",
		["Enchant Ring - Healing Power"] = "附魔戒指 - 治療能量",
		["Enchant Ring - Spellpower"] = "附魔戒指 - 法術能量",
		["Enchant Ring - Stats"] = "附魔戒指 - 屬性",
		["Enchant Ring - Striking"] = "附魔戒指 - 打擊",
		["Enchant Shield - Frost Resistance"] = "附魔盾牌 - 冰霜抗性",
		["Enchant Shield - Greater Spirit"] = "附魔盾牌 - 強效精神",
		["Enchant Shield - Greater Stamina"] = "附魔盾牌 - 強效耐力",
		["Enchant Shield - Intellect"] = "附魔盾牌 - 智力",
		["Enchant Shield - Lesser Block"] = "附魔盾牌 - 次級格擋",
		["Enchant Shield - Lesser Protection"] = "附魔盾牌 - 次級防護",
		["Enchant Shield - Lesser Spirit"] = "附魔盾牌 - 次級精神",
		["Enchant Shield - Lesser Stamina"] = "附魔盾牌 - 次級耐力",
		["Enchant Shield - Major Stamina"] = "附魔盾牌 - 極效耐力",
		["Enchant Shield - Minor Stamina"] = "附魔盾牌 - 初級耐力",
		["Enchant Shield - Resistance"] = "附魔盾牌 - 抗性",
		["Enchant Shield - Shield Block"] = "附魔盾牌 - 盾牌格擋",
		["Enchant Shield - Spirit"] = "附魔盾牌 - 精神",
		["Enchant Shield - Stamina"] = "附魔盾牌 - 耐力",
		["Enchant Shield - Superior Spirit"] = "附魔盾牌 - 超強精神",
		["Enchant Shield - Resilience"] = "附魔盾牌 - 韌性",
		["Enchant Shield - Tough Shield"] = "附魔盾牌 - 堅硬盾牌",
		["Enchant Weapon - Agility"] = "附魔武器 - 敏捷",
		["Enchant Weapon - Battlemaster"] = "附魔武器 - 戰鬥大師",
		["Enchant Weapon - Crusader"] = "附魔武器 - 十字軍",
		["Enchant Weapon - Deathfrost"] = "附魔武器 - 死亡冰霜",
		["Enchant Weapon - Demonslaying"] = "附魔武器 - 屠魔",
		["Enchant Weapon - Executioner"] = "附魔武器 - 處決者",
		["Enchant Weapon - Fiery Weapon"] = "附魔武器 - 灼熱武器",
		["Enchant Weapon - Greater Agility"] = "附魔武器 - 強效敏捷",
		["Enchant Weapon - Greater Striking"] = "附魔武器 - 強效打擊",
		["Enchant Weapon - Healing Power"] = "附魔武器 - 治療能量",
		["Enchant Weapon - Icy Chill"] = "附魔武器 - 冰寒",
		["Enchant Weapon - Lesser Beastslayer"] = "附魔武器 - 次級屠獸",
		["Enchant Weapon - Lesser Elemental Slayer"] = "附魔武器 - 次級元素殺手",
		["Enchant Weapon - Lesser Striking"] = "附魔武器 - 次級打擊",
		["Enchant Weapon - Lifestealing"] = "附魔武器 - 生命偷取",
		["Enchant Weapon - Major Healing"] = "附魔武器 - 極效治療",
		["Enchant Weapon - Major Intellect"] = "附魔武器 - 極效智力",
		["Enchant Weapon - Major Spellpower"] = "附魔武器 - 極效法術能量",
		["Enchant Weapon - Major Striking"] = "附魔武器 - 極效打擊",
		["Enchant Weapon - Mighty Intellect"] = "附魔武器 - 強力智力",
		["Enchant Weapon - Mighty Spirit"] = "附魔武器 - 強力精神",
		["Enchant Weapon - Minor Beastslayer"] = "附魔武器 - 初級屠獸",
		["Enchant Weapon - Minor Striking"] = "附魔武器 - 初級打擊",
		["Enchant Weapon - Mongoose"] = "附魔武器 - 貓鼬",
		["Enchant Weapon - Potency"] = "附魔武器 - 潛能",
		["Enchant Weapon - Soulfrost"] = "附魔武器 - 靈魂冰霜",
		["Enchant Weapon - Spell Power"] = "附魔武器 - 法術能量",
		["Enchant Weapon - Spellsurge"] = "附魔武器 - 法力回流",
		["Enchant Weapon - Strength"] = "附魔武器 - 力量",
		["Enchant Weapon - Striking"] = "附魔武器 - 打擊",
		["Enchant Weapon - Sunfire"] = "附魔武器 - 烈日火焰",
		["Enchant Weapon - Superior Striking"] = "附魔武器 - 超強打擊",
		["Enchant Weapon - Unholy Weapon"] = "附魔武器 - 邪能",
		["Enchant Weapon - Winter's Might"] = "附魔武器 - 寒冬之力",
		["Enchanted Leather"] = "附魔皮",
		["Enchanted Thorium"] = "附魔瑟銀",
		["Greater Magic Wand"] = "強效魔法杖",
		["Greater Mystic Wand"] = "強效秘法杖",
		["Large Prismatic Shard"] = "大塊稜石裂片",
		["Lesser Magic Wand"] = "次級魔法杖",
		["Lesser Mana Oil"] = "次級法力之油",
		["Lesser Mystic Wand"] = "次級秘法魔杖",
		["Lesser Wizard Oil"] = "次級巫師之油",
		["Minor Mana Oil"] = "初級法力之油",
		["Minor Wizard Oil"] = "初級巫師之油",
		["Nexus Transformation"] = "轉換聯結水晶",
		["Prismatic Sphere"] = "稜石之球",
		["Runed Adamantite Rod"] = "符文堅鋼魔棒",
		["Runed Arcanite Rod"] = "符文奧金棒",
		["Runed Copper Rod"] = "符文銅棒",
		["Runed Eternium Rod"] = "符文恆金棒",
		["Runed Fel Iron Rod"] = "符文魔鐵棒",
		["Runed Golden Rod"] = "符文金棒",
		["Runed Silver Rod"] = "符文銀棒",
		["Runed Truesilver Rod"] = "符文真銀棒",
		["Small Prismatic Shard"] = "小塊稜石裂片",
		["Smoking Heart of the Mountain"] = "濃煙山脈之心",
		["Superior Mana Oil"] = "超強法力之油",
		["Superior Wizard Oil"] = "超強巫師之油",
		["Void Shatter"] = "粉碎虛無",
		["Void Sphere"] = "虛無之球",
		["Wizard Oil"] = "巫師之油",

-- Engineering Recipes
		["Accurate Scope"] = "精確瞄準鏡",
		["Adamantite Arrow Maker"] = "堅鋼之箭製造器",
		["Adamantite Frame"] = "堅鋼骨架",
		["Adamantite Grenade"] = "堅鋼手榴彈",
		["Adamantite Rifle"] = "堅鋼步槍",
		["Adamantite Scope"] = "堅鋼瞄準鏡",
		["Adamantite Shell Machine"] = "堅鋼彈藥製造器",
		["Advanced Target Dummy"] = "高級活動假人",
		["Alarm-O-Bot"] = "警報機器人",
		["Aquadynamic Fish Attractor"] = "水下誘魚器",
		["Arcane Bomb"] = "秘法炸彈",
		["Arcanite Dragonling"] = "奧金幼龍",
		["Arclight Spanner"] = "扳手",
		["Big Bronze Bomb"] = "重磅青銅炸彈",
		["Big Iron Bomb"] = "重磅鐵製炸彈",
		["Biznicks 247x128 Accurascope"] = "比茲尼克247x128精確瞄準鏡",
		["Bloodvine Goggles"] = "血藤護目鏡",
		["Bloodvine Lens"] = "血藤透鏡",
		["Blue Firework"] = "藍色煙火",
		["Blue Rocket Cluster"] = "藍色煙花束",
		["Bright-Eye Goggles"] = "增亮護目鏡",
		["Bronze Framework"] = "青銅框架",
		["Bronze Tube"] = "青銅管",
		["Catseye Ultra Goggles"] = "貓眼超級護目鏡",
		["Coarse Blasting Powder"] = "粗製火藥粉",
		["Coarse Dynamite"] = "粗製火藥",
		["Cogspinner Goggles"] = "考格斯賓護目鏡",
		["Compact Harvest Reaper Kit"] = "微型收割機組件",
		["Copper Modulator"] = "銅質調節器",
		["Copper Tube"] = "銅管",
		["Core Marksman Rifle"] = "熔核狙擊步槍",
		["Crafted Heavy Shot"] = "精製重彈丸",
		["Crafted Light Shot"] = "精製輕彈丸",
		["Crafted Solid Shot"] = "精製實心彈丸",
		["Craftsman's Monocle"] = "工匠眼鏡",
		["Crashin' Thrashin' Robot"] = "暴力粉碎機器人",
		["Crude Scope"] = "粗製瞄準鏡",
		["Dark Iron Bomb"] = "黑鐵炸彈",
		["Dark Iron Rifle"] = "黑鐵步槍",
		["Deadly Blunderbuss"] = "致命的短槍",
		["Deadly Scope"] = "致命瞄準鏡",
		["Deathblow X11 Goggles"] = "死亡打擊X11護目鏡",
		["Deepdive Helmet"] = "潛水盔帽",
		["Delicate Arcanite Converter"] = "精密奧金轉換器",
		["Dense Blasting Powder"] = "緻密火藥粉",
		["Dense Dynamite"] = "緻密火藥",
		["Destruction Holo-gogs"] = "毀滅護目鏡",
		["Dimensional Ripper - Area 52"] = "空間撕裂器 - 52區",
		["Dimensional Ripper - Everlook"] = "空間撕裂器 - 永望鎮",
		["Discombobulator Ray"] = "退化射線",
		["Elemental Blasting Powder"] = "元素火藥粉",
		["Elemental Seaforium Charge"] = "元素爆鹽炸藥",
		["Explosive Sheep"] = "自爆綿羊",
		["EZ-Thro Dynamite II"] = "簡易投擲火藥 II",
		["EZ-Thro Dynamite"] = "簡易投擲火藥",
		["Fel Iron Bomb"] = "魔鐵炸彈",
		["Fel Iron Casing"] = "魔鐵外殼",
		["Fel Iron Musket"] = "魔鐵槍",
		["Fel Iron Shells"] = "魔鐵彈藥",
		["Fel Iron Toolbox"] = "魔鐵工具箱",
		["Felsteel Boomstick"] = "魔鋼火槍",
		["Felsteel Stabilizer"] = "魔鋼安置器",
		["Field Repair Bot 110G"] = "修理機器人110G型",
		["Field Repair Bot 74A"] = "修理機器人74A型",
		["Fire Goggles"] = "火焰護目鏡",
		["Firework Cluster Launcher"] = "煙花束發射器",
		["Firework Launcher"] = "煙火發射器",
		["Flame Deflector"] = "火焰偏折器",
		["Flash Bomb"] = "閃光雷",
		["Flawless Arcanite Rifle"] = "完美的奧金步槍",
		["Flying Machine"] = "飛行器",
		["Flying Tiger Goggles"] = "飛虎護目鏡",
		["Force Reactive Disk"] = "力回饋盾牌",
		["Foreman's Enchanted Helmet"] = "工頭的附魔盔帽",
		["Foreman's Reinforced Helmet"] = "工頭強化盔帽",
		["Frost Grenades"] = "冰霜手榴彈",
		["Furious Gizmatic Goggles"] = "狂怒電磁護目鏡",
		["Fused Wiring"] = "保險絲",
		["Gadgetstorm Goggles"] = "機件護目鏡",
		["Gnomish Battle Chicken"] = "地精作戰小雞",
		["Gnomish Battle Goggles"] = "地精作戰護目鏡",
		["Gnomish Cloaking Device"] = "地精隱形裝置",
		["Gnomish Death Ray"] = "地精死亡射線",
		["Gnomish Flame Turret"] = "地精烈焰砲塔",
		["Gnomish Goggles"] = "地精護目鏡",
		["Gnomish Harm Prevention Belt"] = "地精防護腰帶",
		["Gnomish Mind Control Cap"] = "地精洗腦帽",
		["Gnomish Net-o-Matic Projector"] = "地精撒網器",
		["Gnomish Poultryizer"] = "地精變形器",
		["Gnomish Power Goggles"] = "地精能量護目鏡",
		["Gnomish Rocket Boots"] = "地精火箭靴",
		["Gnomish Shrink Ray"] = "地精縮小射線",
		["Gnomish Universal Remote"] = "地精通用遙控器",
		["Goblin Bomb Dispenser"] = "哥布林炸彈箱",
		["Goblin Construction Helmet"] = "哥布林施工盔帽",
		["Goblin Dragon Gun"] = "哥布林龍槍",
		["Goblin Jumper Cables XL"] = "哥布林起搏器XL型",
		["Goblin Jumper Cables"] = "哥布林起搏器",
		["Goblin Land Mine"] = "哥布林地雷",
		["Goblin Mining Helmet"] = "哥布林採礦盔帽",
		["Goblin Mortar"] = "哥布林迫擊砲",
		["Goblin Rocket Boots"] = "哥布林火箭靴",
		["Goblin Rocket Fuel Recipe"] = "哥布林火箭燃油配方",
		["Goblin Rocket Helmet"] = "哥布林火箭盔帽",
		["Goblin Rocket Launcher"] = "哥布林火箭發射器",
		["Goblin Sapper Charge"] = "哥布林工事炸藥",
		["Gold Power Core"] = "黃金能量核心",
		["Green Firework"] = "綠色煙火",
		["Green Lens"] = "綠色透鏡",
		["Green Rocket Cluster"] = "綠色煙花束",
		["Green Smoke Flare"] = "綠色煙霧照明彈",
		["Green Tinted Goggles"] = "綠色護目鏡",
		["Gyro-balanced Khorium Destroyer"] = "迴轉平衡克銀毀滅火槍",
		["Gyrochronatom"] = "發條式同步協調陀螺儀",
		["Gyrofreeze Ice Reflector"] = "超低溫寒冰反射器",
		["Gyromatic Micro-Adjustor"] = "地精微調器",
		["Handful of Copper Bolts"] = "一把螺栓",
		["Handful of Fel Iron Bolts"] = "一把魔鐵螺栓",
		["Hardened Adamantite Tube"] = "特堅鋼管",
		["Healing Potion Injector"] = "治療藥水注射器",
		["Heavy Blasting Powder"] = "烈性火藥粉",
		["Heavy Dynamite"] = "烈性火藥",
		["Hi-Explosive Bomb"] = "高爆爆裂物",
		["Hi-Impact Mithril Slugs"] = "高速秘銀彈頭",
		["Hyper-Radiant Flame Reflector"] = "高輻射烈焰反射器",
		["Hyper-Vision Goggles"] = "超視覺護目鏡",
		["Ice Deflector"] = "冰霜偏折器",
		["Icy Blasting Primers"] = "冰爆雷管",
		["Inlaid Mithril Cylinder Plans"] = "秘銀杆設計圖",
		["Iron Grenade"] = "鐵皮手雷",
		["Iron Strut"] = "鐵棒",
		["Justicebringer 2000 Specs"] = "正義化身2000護目鏡",
		["Khorium Power Core"] = "克銀能量核心",
		["Khorium Scope"] = "克銀瞄準鏡",
		["Large Blue Rocket Cluster"] = "大型藍色煙花束",
		["Large Blue Rocket"] = "大型藍色煙花",
		["Large Copper Bomb"] = "大型銅殼炸彈",
		["Large Green Rocket Cluster"] = "大型綠色煙花束",
		["Large Green Rocket"] = "大型綠色煙花",
		["Large Red Rocket Cluster"] = "大型紅色煙花束",
		["Large Red Rocket"] = "大型紅色煙花",
		["Large Seaforium Charge"] = "大型爆鹽炸藥",
		["Lifelike Mechanical Toad"] = "仿真機械蛙",
		["Lil' Smoky"] = "發條娃娃",
		["Living Replicator Specs"] = "生命複製護目鏡",
		["Lovingly Crafted Boomstick"] = "精緻手工火槍",
		["Magnified Moon Specs"] = "放大月光護目鏡",
		["Major Recombobulator"] = "極效淨化器",
		["Mana Potion Injector"] = "法力藥水注射器",
		["Master Engineer's Goggles"] = "工程大師護目鏡",
		["Masterwork Target Dummy"] = "精工活動假人",
		["Mechanical Dragonling"] = "機械幼龍",
		["Mechanical Repair Kit"] = "機械修理包",
		["Mechanical Squirrel"] = "機械松鼠",
		["Minor Recombobulator"] = "初級淨化器",
		["Mithril Blunderbuss"] = "秘銀火槍",
		["Mithril Casing"] = "秘銀外殼",
		["Mithril Frag Bomb"] = "秘銀破片炸彈",
		["Mithril Gyro-Shot"] = "秘銀螺旋彈",
		["Mithril Heavy-bore Rifle"] = "大口徑秘銀步槍",
		["Mithril Mechanical Dragonling"] = "秘銀機械幼龍",
		["Mithril Tube"] = "秘銀管",
		["Moonsight Rifle"] = "夜視步槍",
		["Nigh-Invulnerability Belt"] = "有限無敵腰帶",
		["Ornate Khorium Rifle"] = "華麗克銀步槍",
		["Ornate Spyglass"] = "華麗望遠鏡",
		["Parachute Cloak"] = "降落傘披風",
		["Pet Bombling"] = "炸彈寵物",
		["Portable Bronze Mortar"] = "可攜式青銅迫擊砲",
		["Power Amplification Goggles"] = "能量增強護目鏡",
		["Powerful Seaforium Charge"] = "強力爆鹽炸藥",
		["Powerheal 4000 Lens"] = "能量4000護目鏡",
		["Practice Lock"] = "練習鎖",
		["Purple Smoke Flare"] = "紫色煙霧照明彈",
		["Red Firework"] = "紅色煙火",
		["Red Rocket Cluster"] = "紅色煙花束",
		["Rocket Boots Xtreme"] = "火箭靴極限版",
		["Rose Colored Goggles"] = "玫瑰色護目鏡",
		["Rough Blasting Powder"] = "劣質火藥粉",
		["Rough Boomstick"] = "劣質火槍",
		["Rough Copper Bomb"] = "劣質銅殼炸彈",
		["Rough Dynamite"] = "劣質火藥",
		["Salt Shaker"] = "篩鹽器",
		["Shadow Goggles"] = "暗影護目鏡",
		["Silver Contact"] = "銀觸媒",
		["Silver-plated Shotgun"] = "鍍銀獵槍",
		["Small Blue Rocket"] = "小型藍色煙花",
		["Small Bronze Bomb"] = "小型青銅炸彈",
		["Small Green Rocket"] = "小型綠色煙花",
		["Small Red Rocket"] = "小型紅色煙花",
		["Small Seaforium Charge"] = "小型爆鹽炸藥",
		["Snake Burst Firework"] = "長蛇煙火",
		["Sniper Scope"] = "狙擊瞄準鏡",
		["SnowMaster 9000"] = "雪王9000型",
		["Solid Blasting Powder"] = "實心火藥粉",
		["Solid Dynamite"] = "實心火藥",
		["Spellpower Goggles Xtreme Plus"] = "法術能量護目鏡極限改良版",
		["Spellpower Goggles Xtreme"] = "法術能量護目鏡極限版",
		["Stabilized Eternium Scope"] = "穩固恆金瞄準鏡",
		["Standard Scope"] = "普通瞄準鏡",
		["Steam Tonk Controller"] = "蒸汽坦克遙控器",
		["Super Sapper Charge"] = "強力工事炸藥",
		["Surestrike Goggles v2.0"] = "絕對打擊護目鏡v2.0",
		["Tankatronic Goggles"] = "坦克電子護目鏡",
		["Target Dummy"] = "活動假人",
		["The Big One"] = "大炸彈",
		["The Bigger One"] = "特大炸彈",
		["The Mortar: Reloaded"] = "迫擊砲:重載",
		["Thorium Grenade"] = "瑟銀手榴彈",
		["Thorium Rifle"] = "瑟銀火槍",
		["Thorium Shells"] = "瑟銀彈",
		["Thorium Tube"] = "瑟銀管",
		["Thorium Widget"] = "瑟銀零件",
		["Tranquil Mechanical Yeti"] = "安靜的機械雪人",
		["Truesilver Transformer"] = "真銀變壓器",
		["Turbo-Charged Flying Machine"] = "渦輪飛行器",
		["Ultra-Flash Shadow Reflector"] = "超快速暗影反射器",
		["Ultrasafe Transporter - Gadgetzan"] = "安全傳送器:加基森",
		["Ultrasafe Transporter - Toshley's Station"] = "安全傳送器:托斯利基地",
		["Ultra-Spectropic Detection Goggles"] = "超光學偵測護目鏡",
		["Unstable Trigger"] = "不牢固的扳機",
		["Voice Amplification Modulator"] = "語音增強模組",
		["Whirring Bronze Gizmo"] = "高速青銅齒輪",
		["White Smoke Flare"] = "白色煙霧照明彈",
		["Wonderheal XT40 Shades"] = "驚奇XT40護目鏡",
		["World Enlarger"] = "世界放大器",
		["Zapthrottle Mote Extractor"] = "快速節流微粒吸取器",
		["Lightning Etched Specs"] = "閃電蝕刻眼鏡",
		["Annihilator Holo-Gogs"] = "殲滅者環視鏡",
		["Primal-Attuned Goggles"] = "原始調和護目鏡",
		["Powerheal 9000 Lens"] = "能量治癒9000鏡片",
		["Justicebringer 3000 Specs"] = "正義使者3000眼鏡",
		["Surestrike Goggles v3.0"] = "絕對打擊護目鏡v3.0",
		["Hyper-Magnified Moon Specs"] = "超放大月光眼鏡",
		["Wonderheal XT68 Shades"] = "奇跡治癒XT68遮光鏡",
		["Hard Khorium Goggles"] = "特硬克銀護目鏡",
		["Quad Deathblow X44 Goggles"] = "四倍死亡打擊X44護目鏡",
		["Mayhem Projection Goggles"] = "暴行投影護目鏡",

-- First Aid Recipes
		["Anti-Venom"] = "抗毒藥劑",
		["Heavy Linen Bandage"] = "厚亞麻繃帶",
		["Heavy Mageweave Bandage"] = "厚魔紋繃帶",
		["Heavy Netherweave Bandage"] = "厚幽紋繃帶",
		["Heavy Runecloth Bandage"] = "厚符文布繃帶",
		["Heavy Silk Bandage"] = "厚絲質繃帶",
		["Heavy Wool Bandage"] = "厚絨線繃帶",
		["Linen Bandage"] = "亞麻繃帶",
		["Mageweave Bandage"] = "魔紋繃帶",
		["Netherweave Bandage"] = "幽紋繃帶",
		["Powerful Anti-Venom"] = "特強抗毒藥劑",
		["Runecloth Bandage"] = "符文布繃帶",
		["Silk Bandage"] = "絲質繃帶",
		["Strong Anti-Venom"] = "強力抗毒藥劑",
		["Wool Bandage"] = "絨線繃帶",

-- Jewelcrafting Recipes
		["Amulet of Flowing Life"] = "流動生命護符",
		["Amulet of the Moon"] = "月之頭飾",
		["Aquamarine Pendant of the Warrior"] = "戰士青綠石墜飾",
		["Aquamarine Signet"] = "青綠石徽記",
		["Arcane Khorium Band"] = "秘法克銀指環",
		["Azure Moonstone Ring"] = "藍月石之戒",
		["Balanced Nightseye"] = "平衡的夜眼石",
		["Balanced Shadowsong Amethyst"] = "平衡影歌紫水晶",
		["Balanced Shadow Draenite"] = "平衡的暗影卓奈石",
		["Band of Natural Fire"] = "天火指環",
		["Barbaric Iron Collar"] = "野人鐵項圈",
		["Blazing Citrine Ring"] = "光輝之黃水晶戒",
		["Blazing Eternium Band"] = "閃耀的恆金指環",
		["Blood of Amber"] = "琥珀之血",
		["Bold Blood Garnet"] = "清晰的血石榴石",
		["Bold Crimson Spinel"] = "清晰的赤紅尖晶石",
		["Bold Living Ruby"] = "清晰的生命紅寶石",
		["Bracing Earthstorm Diamond"] = "振奮的大地風暴鑽石",
		["Braided Copper Ring"] = "鑲邊的銅戒",
		["Braided Eternium Chain"] = "鑲綴的恆金頸鍊",
		["Bright Blood Garnet"] = "明亮的血石榴石",
		["Bright Crimson Spinel"] = "明亮的赤紅尖晶石",
		["Bright Living Ruby"] = "光亮的生命紅寶石",
		["Brilliant Dawnstone"] = "明亮的黎明石",
		["Brilliant Golden Draenite"] = "明亮的黃金卓奈石",
		["Brilliant Lionseye"] = "明亮的獅眼石",
		["Brilliant Necklace"] = "卓越項鍊",
		["Brilliant Pearl Band"] = "明亮珍珠指環",
		["Bronze Band of Force"] = "青銅力量指環",
		["Bronze Setting"] = "青銅底座",
		["Bronze Torc"] = "青銅飾環",
		["Brutal Earthstorm Diamond"] = "粗暴的大地風暴鑽石",
		["Chain of the Twilight Owl"] = "暮光貓頭鷹項鍊",
		["Chaotic Skyfire Diamond"] = "混沌的天火鑽石",
		["Circlet of Arcane Might"] = "秘法之力頭環",
		["Citrine Pendant of Golden Healing"] = "治療之黃水晶墜飾",
		["Citrine Ring of Rapid Healing"] = "快速治療之黃水晶吊飾",
		["Coarse Stone Statue"] = "粗製的雕像",
		["Coronet of the Verdant Flame"] = "翠綠之火頭冠",
		["Crimson Sun"] = "赤紅之日",
		["Crown of the Sea Witch"] = "海巫之冠",
		["Dazzling Deep Peridot"] = "燦爛的翠綠橄欖石",
		["Dazzling Seaspray Emerald"] = "燦爛的海泉綠寶石",
		["Dazzling Talasite"] = "燦爛的泰拉寶石",
		["Delicate Blood Garnet"] = "精緻的血石榴石",
		["Delicate Copper Wire"] = "精緻的銅絲",
		["Delicate Crimson Spinel"] = "精緻的赤紅尖晶石",
		["Delicate Eternium Ring"] = "精緻的恆金戒指",
		["Delicate Living Ruby"] = "精緻的生命紅寶石",
		["Dense Stone Statue"] = "緻密的雕像",
		["Destructive Skyfire Diamond"] = "毀滅的天火鑽石",
		["Diamond Focus Ring"] = "鑽石專注戒指",
		["Don Julio's Heart"] = "胡力歐之心",
		["Elegant Silver Ring"] = "高貴的銀戒指",
		["Ember Skyfire Diamond"] = "餘燼的天火鑽石",
		["Embrace of the Dawn"] = "黎明之擁",
		["Emerald Crown of Destruction"] = "毀滅之綠寶石冠",
		["Emerald Lion Ring"] = "綠寶石獅子戒指",
		["Enduring Deep Peridot"] = "耐久的翠綠橄欖石",
		["Enduring Seaspray Emerald"] = "耐久的海泉綠寶石",
		["Enduring Talasite"] = "耐久的泰拉寶石",
		["Engraved Truesilver Ring"] = "雕刻過的真銀戒",
		["Enigmatic Skyfire Diamond"] = "謎般的天火鑽石",
		["Eternal Earthstorm Diamond"] = "永恆的大地風暴鑽石",
		["Eye of the Night"] = "夜之眼",
		["Facet of Eternity"] = "永恆切面",
		["Falling Star"] = "殞落之星",
		["Fel Iron Blood Ring"] = "魔鐵血指環",
		["Figurine - Black Diamond Crab"] = "刻像 - 黑鑽石蟹",
		["Figurine - Black Pearl Panther"] = "刻像 - 黑珍珠獵豹",
		["Figurine - Dark Iron Scorpid"] = "刻像 - 黑鐵蠍",
		["Figurine - Dawnstone Crab"] = "刻像 - 黎明石蟹",
		["Figurine - Emerald Owl"] = "刻像 - 綠寶石貓頭鷹",
		["Figurine - Felsteel Boar"] = "刻像 - 魔鋼野豬",
		["Figurine - Golden Hare"] = "刻像 - 黃金野兔",
		["Figurine - Jade Owl"] = "刻像 - 翡翠貓頭鷹",
		["Figurine - Living Ruby Serpent"] = "刻像 - 生命紅寶石巨蛇",
		["Figurine - Nightseye Panther"] = "刻像 - 夜眼石獵豹",
		["Figurine - Ruby Serpent"] = "刻像 - 紅寶石巨蛇",
		["Figurine - Talasite Owl"] = "刻像 - 泰拉寶石貓頭鷹",
		["Figurine - Truesilver Boar"] = "刻像 - 真銀野豬",
		["Figurine - Truesilver Crab"] = "刻像 - 真銀蟹",
		["Flashing Crimson Spinel"] = "閃亮的赤紅尖晶石",
		["Flashing Living Ruby"] = "閃爍的生命紅寶石",
		["Gem Studded Band"] = "寶石指環",
		["Gleaming Dawnstone"] = "微光的黎明石",
		["Gleaming Golden Draenite"] = "微光的黃金卓奈石",
		["Gleaming Lionseye"] = "閃爍的獅眼石",
		["Glinting Flame Spessarite"] = "閃爍的火石榴石",
		["Glinting Noble Topaz"] = "閃爍的皇家黃寶石",
		["Glinting Pyrestone"] = "閃爍焚石",
		["Gloom Band"] = "昏暗指環",
		["Glowing Nightseye"] = "發光的夜眼石",
		["Glowing Shadow Draenite"] = "發光的暗影卓奈石",
		["Glowing Shadowsong Amethyst"] = "鮮艷影歌紫水晶",
		["Glowing Thorium Band"] = "發光的瑟銀指環",
		["Golden Draenite Ring"] = "黃金卓奈石戒指",
		["Golden Dragon Ring"] = "黃金龍戒",
		["Golden Ring of Power"] = "力量黃金戒",
		["Great Dawnstone"] = "絕佳的黎明石",
		["Great Golden Draenite"] = "絕佳的黃金卓奈石",
		["Great Lionseye"] = "極佳的獅眼石",
		["Hard Khorium Band"] = "特硬克銀指環",
		["Hard Khorium Choker"] = "特硬克銀頸飾",
		["Heavy Adamantite Ring"] = "沉重的堅鋼戒指",
		["Heavy Copper Ring"] = "重銅戒指",
		["Heavy Felsteel Ring"] = "厚重的魔鋼戒指",
		["Heavy Golden Necklace of Battle"] = "戰爭之黃金項鍊",
		["Heavy Iron Knuckles"] = "重鐵指環",
		["Heavy Jade Ring"] = "厚重的玉戒指",
		["Heavy Silver Ring"] = "重銀戒指",
		["Heavy Stone Statue"] = "沉重的雕像",
		["Infused Nightseye"] = "注入力量的夜眼石",
		["Infused Shadow Draenite"] = "注入力量的暗影卓奈石",
		["Infused Shadowsong Amethyst"] = "能量影歌紫水晶",
		["Inlaid Malachite Ring"] = "孔雀石戒指",
		["Inscribed Flame Spessarite"] = "雕刻過的火石榴石",
		["Inscribed Noble Topaz"] = "雕刻的皇家黃寶石",
		["Inscribed Pyrestone"] = "雕刻焚石",
		["Insightful Earthstorm Diamond"] = "洞察的大地風暴鑽石",
		["Jade Pendant of Blasting"] = "衝擊之翡翠墜飾",
		["Jagged Deep Peridot"] = "鋸齒狀的翠綠橄欖石",
		["Jagged Seaspray Emerald"] = "尖突的海泉綠寶石",
		["Jagged Talasite"] = "齒狀的泰拉寶石",
		["Kailee's Rose"] = "凱麗之薔",
		["Khorium Band of Frost"] = "冰霜克銀指環",
		["Khorium Band of Leaves"] = "自然克銀指環",
		["Khorium Band of Shadows"] = "暗影克銀指環",
		["Khorium Inferno Band"] = "克銀地獄火指環",
		["Living Emerald Pendant"] = "生命綠寶石墜飾",
		["Living Ruby Pendant"] = "生命紅寶石墜飾",
		["Loop of Forged Power"] = "鍛能戒環",
		["Luminous Flame Spessarite"] = "夜光的火石榴石",
		["Luminous Noble Topaz"] = "夜光的皇家黃寶石",
		["Luminous Pyrestone"] = "光輝焚石",
		["Lustrous Azure Moonstone"] = "光亮的藍月石",
		["Lustrous Empyrean Sapphire"] = "光亮的蒼穹藍寶石",
		["Lustrous Star of Elune"] = "光輝的伊露恩之星",
		["Malachite Pendant"] = "孔雀石墜飾",
		["Mercurial Adamantite"] = "水銀堅鋼石",
		["Mithril Filigree"] = "秘銀絲邊",
		["Moonsoul Crown"] = "月魂之冠",
		["Mystic Dawnstone"] = "神秘的黎明石",
		["Mystic Lionseye"] = "神秘的獅眼石",
		["Mystical Skyfire Diamond"] = "神秘的天火鑽石",
		["Necklace of the Deep"] = "深淵項鍊",
		["Necklace of the Diamond Tower"] = "鑽石塔項鍊",
		["Onslaught Ring"] = "突襲之戒",
		["Opal Necklace of Impact"] = "衝擊之蛋白石項鍊",
		["Ornate Tigerseye Necklace"] = "華麗虎眼石項鍊",
		["Pendant of Frozen Flame"] = "霜炎墜飾",
		["Pendant of Shadow's End"] = "絕影墜飾",
		["Pendant of Sunfire"] = "日炎墜飾",
		["Pendant of Thawing"] = "融解墜飾",
		["Pendant of the Agate Shield"] = "瑪瑙之盾墜飾",
		["Pendant of the Null Rune"] = "零符墜飾",
		["Pendant of Withering"] = "枯萎墜飾",
		["Potent Flame Spessarite"] = "高效的火石榴石",
		["Potent Noble Topaz"] = "高效的皇家黃寶石",
		["Potent Pyrestone"] = "高效焚石",
		["Powerful Earthstorm Diamond"] = "強力的大地風暴鑽石",
		["Purified Jaggal Pearl"] = "純淨的鋸齒珍珠",
		["Purified Shadow Pearl"] = "純淨的暗影珍珠",
		["Radiant Deep Peridot"] = "發光的翠綠橄欖石",
		["Radiant Seaspray Emerald"] = "發光的海泉綠寶石",
		["Radiant Talasite"] = "明亮的泰拉寶石",
		["Red Ring of Destruction"] = "紅色毀滅之戒",
		["Relentless Earthstorm Diamond"] = "不懈的大地風暴鑽石",
		["Rigid Dawnstone"] = "堅硬的黎明石",
		["Rigid Golden Draenite"] = "堅硬的黃金卓奈石",
		["Rigid Lionseye"] = "堅硬的獅眼石",
		["Ring of Arcane Shielding"] = "秘法護盾戒指",
		["Ring of Bitter Shadows"] = "痛苦暗影之戒",
		["Ring of Flowing Life"] = "流動生命戒指",
		["Ring of Silver Might"] = "銀白力量之戒",
		["Ring of Twilight Shadows"] = "黃金暗影戒指",
		["Rough Stone Statue"] = "劣質的雕像",
		["Royal Nightseye"] = "高貴的夜眼石",
		["Royal Shadow Draenite"] = "高貴的暗影卓奈石",
		["Royal Shadowsong Amethyst"] = "皇家影歌紫水晶",
		["Ruby Crown of Restoration"] = "治療之紅寶石冠",
		["Ruby Pendant of Fire"] = "火焰紅寶石墜飾",
		["Runed Blood Garnet"] = "符文血石榴石",
		["Runed Crimson Spinel"] = "符文赤紅尖晶石",
		["Runed Living Ruby"] = "符文生命紅寶石",
		["Sapphire Pendant of Winter Night"] = "冬夜藍寶石墜飾",
		["Sapphire Signet"] = "藍寶石徽記",
		["Shifting Nightseye"] = "移形的夜眼石",
		["Shifting Shadow Draenite"] = "移形的暗影卓奈石",
		["Shifting Shadowsong Amethyst"] = "移形影歌紫水晶",
		["Simple Opal Ring"] = "簡單的蛋白石戒指",
		["Simple Pearl Ring"] = "簡單的珍珠戒指",
		["Smooth Dawnstone"] = "平滑的黎明石",
		["Smooth Golden Draenite"] = "光滑的黃金卓奈石",
		["Smooth Lionseye"] = "光滑的獅眼石",
		["Solid Azure Moonstone"] = "堅固的藍月石",
		["Solid Bronze Ring"] = "厚實的青銅戒",
		["Solid Empyrean Sapphire"] = "堅固的蒼穹藍寶石",
		["Solid Star of Elune"] = "堅固的伊露恩之星",
		["Solid Stone Statue"] = "堅固的雕像",
		["Sovereign Nightseye"] = "尊貴的夜眼石",
		["Sovereign Shadow Draenite"] = "高級的暗影卓奈石",
		["Sovereign Shadowsong Amethyst"] = "至尊影歌紫水晶",
		["Sparkling Azure Moonstone"] = "閃亮的藍月石",
		["Sparkling Empyrean Sapphire"] = "發光的蒼穹藍寶石",
		["Sparkling Star of Elune"] = "閃亮的伊露恩之星",
		["Steady Talasite"] = "穩固的泰拉寶石",
		["Stone of Blades"] = "眾刃之石",
		["Stormy Azure Moonstone"] = "激烈的藍月石",
		["Stormy Empyrean Sapphire"] = "狂暴的蒼穹藍寶石",
		["Stormy Star of Elune"] = "風暴的伊露恩之星",
		["Subtle Crimson Spinel"] = "精巧的赤紅尖晶石",
		["Subtle Living Ruby"] = "精良的生命紅寶石",
		["Swift Skyfire Diamond"] = "迅捷的天火鑽石",
		["Teardrop Blood Garnet"] = "淚滴血石榴石",
		["Teardrop Crimson Spinel"] = "淚珠赤紅尖晶石",
		["Teardrop Living Ruby"] = "淚滴生命紅寶石",
		["Tenacious Earthstorm Diamond"] = "堅韌的大地風暴鑽石",
		["The Aquamarine Ward"] = "青綠石護符",
		["The Black Pearl"] = "黑貝珠",
		["The Frozen Eye"] = "冰凍之眼",
		["The Jade Eye"] = "翡翠之眼",
		["The Natural Ward"] = "自然守衛",
		["Thick Adamantite Necklace"] = "厚堅鋼項鍊",
		["Thick Bronze Necklace"] = "厚青銅項鍊",
		["Thick Dawnstone"] = "厚重的黎明石",
		["Thick Felsteel Necklace"] = "厚魔鋼項鍊",
		["Thick Golden Draenite"] = "厚重的黃金卓奈石",
		["Thick Lionseye"] = "厚重的獅眼石",
		["Thorium Setting"] = "瑟銀底座",
		["Thundering Skyfire Diamond"] = "驚人的天火鑽石",
		["Tigerseye Band"] = "虎眼指環",
		["Truesilver Commander's Ring"] = "真銀指揮官之戒",
		["Truesilver Healing Ring"] = "真銀治療戒指",
		["Veiled Flame Spessarite"] = "矇矓的火石榴石",
		["Veiled Noble Topaz"] = "矇矓的皇家黃寶石",
		["Veiled Pyrestone"] = "矇矓焚石",
		["Wicked Flame Spessarite"] = "邪惡的火石榴石",
		["Wicked Moonstone Ring"] = "邪惡月亮石戒指",
		["Wicked Noble Topaz"] = "邪惡的皇家黃寶石",
		["Wicked Pyrestone"] = "邪惡焚石",
		["Woven Copper Ring"] = "銅紋戒",
		["Quick Dawnstone"] = "迅速的黎明石",
		["Forceful Talasite"] = "堅強的泰拉寶石",
		["Reckless Noble Topaz"] = "魯莽的皇家黃寶石",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "秘法護甲片",
		["Bag of Many Hides"] = "拼接皮包",
		["Barbaric Belt"] = "野人腰帶",
		["Barbaric Bracers"] = "野人護腕",
		["Barbaric Gloves"] = "野人手套",
		["Barbaric Harness"] = "野人背心",
		["Barbaric Leggings"] = "野人護腿",
		["Barbaric Shoulders"] = "野人護肩",
		["Belt of Deep Shadow"] = "暗影深淵腰帶",
		["Belt of Natural Power"] = "自然之力腰帶",
		["Belt of the Black Eagle"] = "黑鷹腰帶",
		["Big Voodoo Cloak"] = "巫毒披風",
		["Big Voodoo Mask"] = "巫毒面具",
		["Big Voodoo Pants"] = "巫毒便褲",
		["Big Voodoo Robe"] = "巫毒長袍",
		["Bindings of Lightning Reflexes"] = "電光反射束腕",
		["Black Dragonscale Boots"] = "黑色龍鱗戰靴",
		["Black Dragonscale Breastplate"] = "黑色龍鱗胸甲",
		["Black Dragonscale Leggings"] = "黑色龍鱗護腿",
		["Black Dragonscale Shoulders"] = "黑色龍鱗護肩",
		["Black Whelp Cloak"] = "黑色幼龍披風",
		["Black Whelp Tunic"] = "黑色幼龍外套",
		["Blackstorm Leggings"] = "黑色風暴護腿",
		["Blastguard Belt"] = "爆烈守衛腰帶",
		["Blastguard Boots"] = "爆烈守衛長靴",
		["Blastguard Pants"] = "爆烈守衛便褲",
		["Blood Tiger Breastplate"] = "血虎胸甲",
		["Blood Tiger Shoulders"] = "血虎護肩",
		["Blue Dragonscale Breastplate"] = "藍龍鱗片胸甲",
		["Blue Dragonscale Leggings"] = "藍龍鱗片護腿",
		["Blue Dragonscale Shoulders"] = "藍龍鱗片護肩",
		["Boots of Natural Grace"] = "自然之擁長靴",
		["Boots of Shackled Souls"] = "束縛之魂長靴",
		["Boots of the Crimson Hawk"] = "紅鷹之靴",
		["Boots of Utter Darkness"] = "絕對黑暗之靴",
		["Bracers of Renewed Life"] = "生命再生護腕",
		["Bracers of Shackled Souls"] = "束縛之魂護腕",
		["Bramblewood Belt"] = "木藤腰帶",
		["Bramblewood Boots"] = "木藤靴子",
		["Bramblewood Helm"] = "木藤頭盔",
		["Chimeric Boots"] = "奇美拉長靴",
		["Chimeric Gloves"] = "奇美拉手套",
		["Chimeric Leggings"] = "奇美拉護腿",
		["Chimeric Vest"] = "奇美拉外衣",
		["Chromatic Cloak"] = "炫彩披風",
		["Chromatic Gauntlets"] = "炫彩護手",
		["Clefthide Leg Armor"] = "裂蹄皮護腿片",
		["Cloak of Darkness"] = "黑暗披風",
		["Cobrahide Leg Armor"] = "眼鏡蛇皮護腿片",
		["Cobrascale Gloves"] = "眼鏡蛇鱗手套",
		["Cobrascale Hood"] = "眼鏡蛇鱗頭套",
		["Comfortable Insoles"] = "舒適的鞋墊",
		["Comfortable Leather Hat"] = "舒適的皮帽",
		["Core Armor Kit"] = "熔核護甲片",
		["Corehound Belt"] = "熔核犬皮腰帶",
		["Corehound Boots"] = "熔核犬皮靴",
		["Cured Heavy Hide"] = "熟化重毛皮",
		["Cured Light Hide"] = "熟化輕毛皮",
		["Cured Medium Hide"] = "熟化中毛皮",
		["Cured Rugged Hide"] = "熟化毛皮",
		["Cured Thick Hide"] = "熟化厚毛皮",
		["Dark Leather Belt"] = "黑皮腰帶",
		["Dark Leather Boots"] = "黑皮戰靴",
		["Dark Leather Cloak"] = "黑皮披風",
		["Dark Leather Gloves"] = "黑皮手套",
		["Dark Leather Pants"] = "黑皮便褲",
		["Dark Leather Shoulders"] = "黑皮護肩",
		["Dark Leather Tunic"] = "黑皮外套",
		["Dawn Treaders"] = "黎明皮靴",
		["Deviate Scale Belt"] = "蛇鱗腰帶",
		["Deviate Scale Cloak"] = "蛇鱗披風",
		["Deviate Scale Gloves"] = "蛇鱗手套",
		["Devilsaur Gauntlets"] = "魔暴龍護手",
		["Devilsaur Leggings"] = "魔暴龍皮護腿",
		["Dragonscale Breastplate"] = "龍鱗胸甲",
		["Dragonscale Gauntlets"] = "龍鱗護手",
		["Dragonstrike Leggings"] = "龍擊護腿",
		["Dreamscale Breastplate"] = "夢幻龍鱗胸甲",
		["Drums of Battle"] = "戰鬥之鼓",
		["Drums of Panic"] = "驚慌之鼓",
		["Drums of Restoration"] = "恢復之鼓",
		["Drums of Speed"] = "速度之鼓",
		["Drums of War"] = "戰爭之鼓",
		["Dusky Belt"] = "暗色皮帶",
		["Dusky Boots"] = "暗色長靴",
		["Dusky Bracers"] = "暗色護腕",
		["Dusky Leather Armor"] = "暗色皮甲",
		["Dusky Leather Leggings"] = "暗色皮護腿",
		["Earthen Leather Shoulders"] = "土靈皮護肩",
		["Earthen Netherscale Boots"] = "土靈虛空鱗長靴",
		["Ebon Netherscale Belt"] = "黑虛空鱗腰帶",
		["Ebon Netherscale Bracers"] = "黑虛空鱗護腕",
		["Ebon Netherscale Breastplate"] = "黑虛空鱗胸甲",
		["Embossed Leather Boots"] = "雕花皮靴",
		["Embossed Leather Cloak"] = "雕花皮質披風",
		["Embossed Leather Gloves"] = "雕花皮手套",
		["Embossed Leather Pants"] = "雕花皮便褲",
		["Embossed Leather Vest"] = "雕花皮外衣",
		["Enchanted Clefthoof Boots"] = "附魔裂蹄長靴",
		["Enchanted Clefthoof Gloves"] = "附魔裂蹄手套",
		["Enchanted Clefthoof Leggings"] = "附魔裂蹄護腿",
		["Enchanted Felscale Boots"] = "附魔魔鱗長靴",
		["Enchanted Felscale Gloves"] = "附魔魔鱗手套",
		["Enchanted Felscale Leggings"] = "附魔魔鱗護腿",
		["Feathered Breastplate"] = "羽飾胸甲",
		["Fel Leather Boots"] = "惡魔皮靴",
		["Fel Leather Gloves"] = "惡魔皮手套",
		["Fel Leather Leggings"] = "惡魔皮護腿",
		["Felscale Boots"] = "魔鱗長靴",
		["Felscale Breastplate"] = "魔鱗胸甲",
		["Felscale Gloves"] = "魔鱗手套",
		["Felscale Pants"] = "魔鱗便褲",
		["Felstalker Belt"] = "惡魔捕獵者腰帶",
		["Felstalker Bracer"] = "惡魔捕獵者護腕",
		["Felstalker Breastplate"] = "惡魔捕獵者胸甲",
		["Fine Leather Belt"] = "優質皮帶",
		["Fine Leather Boots"] = "優質皮靴",
		["Fine Leather Cloak"] = "優質皮披風",
		["Fine Leather Gloves"] = "優質皮手套",
		["Fine Leather Pants"] = "優質皮褲",
		["Fine Leather Tunic"] = "優質皮外套",
		["Flame Armor Kit"] = "烈焰護甲片",
		["Flamescale Belt"] = "火鱗腰帶",
		["Flamescale Boots"] = "火鱗長靴",
		["Flamescale Leggings"] = "火鱗護腿",
		["Fletcher's Gloves"] = "造弓師手套",
		["Frost Armor Kit"] = "寒冰護甲片",
		["Frost Leather Cloak"] = "冰霜皮質披風",
		["Frostsaber Boots"] = "霜刃長靴",
		["Frostsaber Gloves"] = "霜刃手套",
		["Frostsaber Leggings"] = "霜刃護腿",
		["Frostsaber Tunic"] = "霜刃外套",
		["Gauntlets of the Sea"] = "深海護手",
		["Gem-studded Leather Belt"] = "寶石皮帶",
		["Girdle of Insight"] = "洞察束腰",
		["Glove Reinforcements"] = "手套強化片",
		["Gloves of the Greatfather"] = "冬天爺爺的手套",
		["Gloves of the Living Touch"] = "生命之觸手套",
		["Golden Dragonstrike Breastplate"] = "黃金龍擊胸甲",
		["Golden Mantle of the Dawn"] = "金色黎明披肩",
		["Greaves of Shackled Souls"] = "束縛之魂護脛",
		["Green Dragonscale Breastplate"] = "綠龍鱗片胸甲",
		["Green Dragonscale Gauntlets"] = "綠色龍鱗護手",
		["Green Dragonscale Leggings"] = "綠龍鱗片護腿",
		["Green Leather Armor"] = "綠色皮甲",
		["Green Leather Belt"] = "綠色皮帶",
		["Green Leather Bracers"] = "綠色皮護腕",
		["Green Whelp Armor"] = "綠色幼龍護甲",
		["Green Whelp Bracers"] = "綠色幼龍護腕",
		["Guardian Armor"] = "守護之甲",
		["Guardian Belt"] = "守護腰帶",
		["Guardian Cloak"] = "守護披風",
		["Guardian Gloves"] = "守衛手套",
		["Guardian Leather Bracers"] = "守護皮甲護腕",
		["Guardian Pants"] = "守護便褲",
		["Handstitched Leather Belt"] = "手工皮帶",
		["Handstitched Leather Boots"] = "手工皮靴",
		["Handstitched Leather Bracers"] = "手工皮護腕",
		["Handstitched Leather Cloak"] = "手工皮披風",
		["Handstitched Leather Pants"] = "手工皮便褲",
		["Handstitched Leather Vest"] = "手工皮外衣",
		["Heavy Armor Kit"] = "重型護甲片",
		["Heavy Clefthoof Boots"] = "重型裂蹄長靴",
		["Heavy Clefthoof Leggings"] = "重型裂蹄護腿",
		["Heavy Clefthoof Vest"] = "重型裂蹄外衣",
		["Heavy Earthen Gloves"] = "重型土靈手套",
		["Heavy Knothide Armor Kit"] = "厚重境外皮護甲片",
		["Heavy Knothide Leather"] = "厚重境外皮革",
		["Heavy Leather Ammo Pouch"] = "重皮彈藥包",
		["Heavy Leather Ball"] = "重皮球",
		["Heavy Leather"] = "重皮",
		["Heavy Quiver"] = "重型箭袋",
		["Heavy Scorpid Belt"] = "重型蠍殼腰帶",
		["Heavy Scorpid Bracers"] = "重型蠍殼護腕",
		["Heavy Scorpid Gauntlets"] = "重型蠍殼護手",
		["Heavy Scorpid Helm"] = "重型蠍殼頭盔",
		["Heavy Scorpid Leggings"] = "重型蠍殼護腿",
		["Heavy Scorpid Shoulders"] = "重型蠍殼護肩",
		["Heavy Scorpid Vest"] = "重型蠍殼外衣",
		["Helm of Fire"] = "火焰頭盔",
		["Herbalist's Gloves"] = "採藥師手套",
		["Hide of the Wild"] = "野性之皮",
		["Hillman's Belt"] = "山地腰帶",
		["Hillman's Cloak"] = "山地披風",
		["Hillman's Leather Gloves"] = "山地皮手套",
		["Hillman's Leather Vest"] = "山地皮外衣",
		["Hillman's Shoulders"] = "山地護肩",
		["Hood of Primal Life"] = "原始生命兜帽",
		["Hurricane Boots"] = "颶風長靴",
		["Icy Scale Bracers"] = "冰鱗護腕",
		["Icy Scale Breastplate"] = "冰鱗胸甲",
		["Icy Scale Gauntlets"] = "冰鱗護手",
		["Ironfeather Breastplate"] = "鐵羽胸甲",
		["Ironfeather Shoulders"] = "鐵羽護肩",
		["Knothide Ammo Pouch"] = "境外皮彈藥包",
		["Knothide Armor Kit"] = "境外護甲片",
		["Knothide Leather"] = "境外皮革",
		["Knothide Quiver"] = "境外皮箭袋",
		["Kodo Hide Bag"] = "科多獸皮包",
		["Lava Belt"] = "熔岩腰帶",
		["Leatherworker's Satchel"] = "製皮師的背包",
		["Light Armor Kit"] = "輕型護甲片",
		["Light Leather Bracers"] = "輕皮護腕",
		["Light Leather Pants"] = "輕皮便褲",
		["Light Leather Quiver"] = "輕皮箭袋",
		["Light Leather"] = "輕皮",
		["Living Breastplate"] = "生命胸甲",
		["Living Crystal Breastplate"] = "生命水晶胸甲",
		["Living Dragonscale Helm"] = "生命龍鱗頭盔",
		["Living Earth Bindings"] = "大地生命束腕",
		["Living Earth Shoulders"] = "大地生命護肩",
		["Living Leggings"] = "生命護腿",
		["Living Shoulders"] = "生命護肩",
		["Magister's Armor Kit"] = "博學者護甲片",
		["Medium Armor Kit"] = "中型護甲片",
		["Medium Leather"] = "中皮",
		["Might of the Timbermaw"] = "木喉之力",
		["Molten Belt"] = "熔火腰帶",
		["Molten Helm"] = "熔鑄頭盔",
		["Mongoose Boots"] = "貓鼬長靴",
		["Monsoon Belt"] = "季風腰帶",
		["Moonglow Vest"] = "月光外衣",
		["Murloc Scale Belt"] = "魚人鱗片腰帶",
		["Murloc Scale Bracers"] = "魚人鱗片護腕",
		["Murloc Scale Breastplate"] = "魚人鱗片胸甲",
		["Nature Armor Kit"] = "自然護甲片",
		["Nethercleft Leg Armor"] = "虛空裂蹄護腿片",
		["Nethercobra Leg Armor"] = "虛空眼鏡蛇護腿片",
		["Netherdrake Gloves"] = "虛空龍手套",
		["Netherdrake Helm"] = "虛空龍頭盔",
		["Netherfury Belt"] = "虛空之怒腰帶",
		["Netherfury Boots"] = "虛空之怒長靴",
		["Netherfury Leggings"] = "虛空之怒護腿",
		["Netherscale Ammo Pouch"] = "虛空鱗彈藥袋",
		["Netherstrike Belt"] = "地擊腰帶",
		["Netherstrike Bracers"] = "地擊護腕",
		["Netherstrike Breastplate"] = "地擊胸甲",
		["Nightscape Boots"] = "夜景長靴",
		["Nightscape Headband"] = "夜景頭帶",
		["Nightscape Pants"] = "夜景便褲",
		["Nightscape Shoulders"] = "夜景護肩",
		["Nightscape Tunic"] = "夜景外套",
		["Nimble Leather Gloves"] = "輕巧的皮手套",
		["Onyxia Scale Cloak"] = "奧妮克希亞鱗片披風",
		["Pilferer's Gloves"] = "竊賊手套",
		["Polar Bracers"] = "極地護腕",
		["Polar Gloves"] = "極地手套",
		["Polar Tunic"] = "極地外套",
		["Primal Batskin Bracers"] = "原始蝙蝠皮護腕",
		["Primal Batskin Gloves"] = "原始蝙蝠皮手套",
		["Primal Batskin Jerkin"] = "原始蝙蝠皮上衣",
		["Primalstorm Breastplate"] = "原始風暴胸甲",
		["Primalstrike Belt"] = "原始之擊腰帶",
		["Primalstrike Bracers"] = "原始之擊護腕",
		["Primalstrike Vest"] = "原始之擊外衣",
		["Quickdraw Quiver"] = "快捷箭袋",
		["Quiver of a Thousand Feathers"] = "千羽箭袋",
		["Raptor Hide Belt"] = "迅猛龍皮腰帶",
		["Raptor Hide Harness"] = "迅猛龍皮背心",
		["Red Dragonscale Breastplate"] = "紅龍鱗片胸甲",
		["Red Whelp Gloves"] = "紅色幼龍手套",
		["Redeemed Soul Cinch"] = "救贖之魂繫腰",
		["Redeemed Soul Legguards"] = "救贖之魂腿甲",
		["Redeemed Soul Moccasins"] = "救贖之魂底鞋",
		["Redeemed Soul Wristguards"] = "救贖之魂腕甲",
		["Reinforced Mining Bag"] = "強化礦石包",
		["Riding Crop"] = "騎乘馬鞭",
		["Rugged Armor Kit"] = "毛皮護甲片",
		["Rugged Leather Pants"] = "粗厚皮便褲",
		["Rugged Leather"] = "硬甲皮",
		["Runic Leather Armor"] = "符文皮甲",
		["Runic Leather Belt"] = "符文皮甲腰帶",
		["Runic Leather Bracers"] = "符文皮甲護腕",
		["Runic Leather Gauntlets"] = "符文皮甲護手",
		["Runic Leather Headband"] = "符文皮甲頭帶",
		["Runic Leather Pants"] = "符文皮甲便褲",
		["Runic Leather Shoulders"] = "符文皮甲護肩",
		["Sandstalker Bracers"] = "沙行者護腕",
		["Sandstalker Breastplate"] = "沙行者胸甲",
		["Sandstalker Gauntlets"] = "沙行者護手",
		["Scaled Draenic Boots"] = "德萊尼綴鱗長靴",
		["Scaled Draenic Gloves"] = "德萊尼綴鱗手套",
		["Scaled Draenic Pants"] = "德萊尼綴鱗便褲",
		["Scaled Draenic Vest"] = "德萊尼綴鱗外衣",
		["Shadow Armor Kit"] = "暗影護甲片",
		["Shadowprowler's Chestguard"] = "暗影徘徊者護胸",
		["Shadowskin Gloves"] = "影皮手套",
		["Shifting Cloak"] = "移形披風",
		["Shoulderpads of Renewed Life"] = "生命再生肩墊",
		["Shoulders of Lightning Reflexes"] = "電光反射護肩",
		["Small Leather Ammo Pouch"] = "皮質小彈藥包",
		["Spitfire Bracers"] = "飛火護腕",
		["Spitfire Breastplate"] = "飛火胸甲",
		["Spitfire Gauntlets"] = "飛火護手",
		["Stormshroud Armor"] = "雷暴護甲",
		["Stormshroud Gloves"] = "雷暴手套",
		["Stormshroud Pants"] = "雷暴便褲",
		["Stormshroud Shoulders"] = "雷暴護肩",
		["Stylin' Adventure Hat"] = "造型冒險帽",
		["Stylin' Crimson Hat"] = "造型紅色帽",
		["Stylin' Jungle Hat"] = "造型叢林帽",
		["Stylin' Purple Hat"] = "造型紫色帽",
		["Swift Boots"] = "迅捷之靴",
		["Swift Flight Bracers"] = "迅行護腕",
		["Swiftstrike Bracers"] = "迅擊護腕",
		["Swiftstrike Shoulders"] = "迅擊護肩",
		["Thick Armor Kit"] = "厚重護甲片",
		["Thick Draenic Boots"] = "厚德萊尼長靴",
		["Thick Draenic Gloves"] = "厚德萊尼手套",
		["Thick Draenic Pants"] = "厚德萊尼便褲",
		["Thick Draenic Vest"] = "厚德萊尼外衣",
		["Thick Leather Ammo Pouch"] = "厚皮彈藥包",
		["Thick Leather"] = "厚皮",
		["Thick Murloc Armor"] = "厚魚人皮甲",
		["Thick Netherscale Breastplate"] = "厚虛空鱗胸甲",
		["Timbermaw Brawlers"] = "木喉作戰手套",
		["Tough Scorpid Boots"] = "硬化蠍殼戰靴",
		["Tough Scorpid Bracers"] = "硬化蠍殼護腕",
		["Tough Scorpid Breastplate"] = "硬化蠍殼胸甲",
		["Tough Scorpid Gloves"] = "硬化蠍殼手套",
		["Tough Scorpid Helm"] = "硬化蠍殼頭盔",
		["Tough Scorpid Leggings"] = "硬化蠍殼護腿",
		["Tough Scorpid Shoulders"] = "硬化蠍殼護肩",
		["Toughened Leather Armor"] = "韌化皮甲",
		["Toughened Leather Gloves"] = "韌化皮手套",
		["Turtle Scale Bracers"] = "龜殼護腕",
		["Turtle Scale Breastplate"] = "龜殼胸甲",
		["Turtle Scale Gloves"] = "龜殼手套",
		["Turtle Scale Helm"] = "龜殼頭盔",
		["Turtle Scale Leggings"] = "龜殼護腿",
		["Vindicator's Armor Kit"] = "復仇者護甲片",
		["Volcanic Breastplate"] = "火山胸甲",
		["Volcanic Leggings"] = "火山護腿",
		["Volcanic Shoulders"] = "火山護肩",
		["Waistguard of Shackled Souls"] = "束縛之魂護腰",
		["Warbear Harness"] = "戰熊背心",
		["Warbear Woolies"] = "戰熊毛褲",
		["White Leather Jerkin"] = "白色皮上衣",
		["Wicked Leather Armor"] = "邪惡皮甲",
		["Wicked Leather Belt"] = "邪惡皮甲腰帶",
		["Wicked Leather Bracers"] = "邪惡皮甲護腕",
		["Wicked Leather Gauntlets"] = "邪惡皮甲護手",
		["Wicked Leather Headband"] = "邪惡皮甲頭帶",
		["Wicked Leather Pants"] = "邪惡皮甲便褲",
		["Wild Draenish Boots"] = "狂野德萊尼長靴",
		["Wild Draenish Gloves"] = "狂野德萊尼手套",
		["Wild Draenish Leggings"] = "狂野德萊尼護腿",
		["Wild Draenish Vest"] = "狂野德萊尼外衣",
		["Wild Leather Boots"] = "蠻皮戰靴",
		["Wild Leather Cloak"] = "蠻皮披風",
		["Wild Leather Helmet"] = "蠻皮盔帽",
		["Wild Leather Leggings"] = "蠻皮護腿",
		["Wild Leather Shoulders"] = "蠻皮護肩",
		["Wild Leather Vest"] = "蠻皮外衣",
		["Wildfeather Leggings"] = "野性之皮護腿",
		["Windhawk Belt"] = "風之隼腰帶",
		["Windhawk Bracers"] = "風之隼護腕",
		["Windhawk Hauberk"] = "風之隼鍊衫",
		["Windscale Hood"] = "風鱗兜帽",
		["Windslayer Wraps"] = "屠風者裹帶",
		["Windstrike Gloves"] = "風擊手套",
		["Winter Boots"] = "冬靴",
		["Wolfshead Helm"] = "狼首頭盔",
		["Leather Gauntlets of the Sun"] = "太陽皮甲護手",
		["Leather Chestguard of the Sun"] = "太陽皮甲護胸",
		["Fletcher's Gloves of the Phoenix"] = "鳳凰弓匠手套",
		["Embrace of the Phoenix"] = "鳳凰之擁",
		["Sun-Drenched Scale Gloves"] = "沁日鱗甲手套",
		["Sun-Drenched Scale Chestguard"] = "沁日鱗甲護胸",
		["Carapace of Sun and Shadow"] = "日與影之殼",
		["Gloves of Immortal Dusk"] = "不朽之暮手套",

-- Smelting Recipes
		["Earth Shatter"] = "大地破碎",
		["Fire Sunder"] = "火焰分離",
		["Smelt Adamantite"] = "熔煉堅鋼錠",
		["Smelt Bronze"] = "熔煉青銅",
		["Smelt Copper"] = "熔煉銅錠",
		["Smelt Dark Iron"] = "熔煉黑鐵",
		["Smelt Elementium"] = "熔煉源質",
		["Smelt Eternium"] = "熔煉恆金錠",
		["Smelt Fel Iron"] = "熔煉魔鐵錠",
		["Smelt Felsteel"] = "熔煉魔鋼錠",
		["Smelt Gold"] = "熔煉金錠",
		["Smelt Hardened Adamantite"] = "熔煉特堅鋼錠",
		["Smelt Hardened Khorium"] = "熔煉硬化克銀",
		["Smelt Iron"] = "熔煉鐵錠",
		["Smelt Khorium"] = "熔煉克銀錠",
		["Smelt Mithril"] = "熔煉秘銀",
		["Smelt Silver"] = "熔煉銀錠",
		["Smelt Steel"] = "熔煉鋼錠",
		["Smelt Thorium"] = "熔煉瑟銀",
		["Smelt Tin"] = "熔煉錫錠",
		["Smelt Truesilver"] = "熔煉真銀",

-- Rogue Poison Recipes
		["Anesthetic Poison"] = "麻醉毒藥",
		["Blinding Powder"] = "致盲粉",
		["Crippling Poison II"] = "致殘毒藥 II",
		["Crippling Poison"] = "致殘毒藥",
		["Deadly Poison II"] = "致命毒藥 II",
		["Deadly Poison III"] = "致命毒藥 III",
		["Deadly Poison IV"] = "致命毒藥 IV",
		["Deadly Poison V"] = "致命毒藥 V",
		["Deadly Poison VI"] = "致命毒藥 VI",
		["Deadly Poison VII"] = "致命毒藥 VII",
		["Deadly Poison"] = "致命毒藥",
		["Instant Poison II"] = "速效毒藥 II",
		["Instant Poison III"] = "速效毒藥 III",
		["Instant Poison IV"] = "速效毒藥 IV",
		["Instant Poison V"] = "速效毒藥 V",
		["Instant Poison VI"] = "速效毒藥 VI",
		["Instant Poison VII"] = "速效毒藥 VII",
		["Instant Poison"] = "速效毒藥",
		["Mind-numbing Poison II"] = "麻痹毒藥 II",
		["Mind-numbing Poison III"] = "麻痹毒藥 III",
		["Mind-numbing Poison"] = "麻痹毒藥",
		["Wound Poison II"] = "致傷毒藥 II",
		["Wound Poison III"] = "致傷毒藥 III",
		["Wound Poison IV"] = "致傷毒藥 IV",
		["Wound Poison V"] = "致傷毒藥 V",
		["Wound Poison"] = "致傷毒藥",

-- Tailoring Recipes
		["Admiral's Hat"] = "將軍之帽",
		["Arcanoweave Boots"] = "奧紋長靴",
		["Arcanoweave Bracers"] = "奧紋護腕",
		["Arcanoweave Robe"] = "奧紋長袍",
		["Argent Boots"] = "銀色長靴",
		["Argent Shoulders"] = "銀色護肩",
		["Azure Shoulders"] = "碧藍護肩",
		["Azure Silk Belt"] = "碧藍絲質腰帶",
		["Azure Silk Cloak"] = "碧藍絲質披風",
		["Azure Silk Gloves"] = "碧藍絲質手套",
		["Azure Silk Hood"] = "碧藍絲質兜帽",
		["Azure Silk Pants"] = "碧藍絲質便褲",
		["Azure Silk Vest"] = "碧藍絲質外衣",
		["Bag of Jewels"] = "寶石包",
		["Barbaric Linen Vest"] = "野人亞麻外衣",
		["Battlecast Hood"] = "戰放兜帽",
		["Battlecast Pants"] = "戰放便褲",
		["Belt of Blasting"] = "衝擊腰帶",
		["Belt of the Archmage"] = "大法師腰帶",
		["Belt of the Long Road"] = "長路腰帶",
		["Big Bag of Enchantment"] = "附魔大背包",
		["Black Belt of Knowledge"] = "黑色學識腰帶",
		["Black Mageweave Boots"] = "黑色魔紋之靴",
		["Black Mageweave Gloves"] = "黑色魔紋手套",
		["Black Mageweave Headband"] = "黑色魔紋頭帶",
		["Black Mageweave Leggings"] = "黑色魔紋護腿",
		["Black Mageweave Robe"] = "黑色魔紋長袍",
		["Black Mageweave Shoulders"] = "黑色魔紋護肩",
		["Black Mageweave Vest"] = "黑色魔紋外衣",
		["Black Silk Pack"] = "黑色絲質背包",
		["Black Swashbuckler's Shirt"] = "黑色劍客襯衣",
		["Blackstrike Bracers"] = "黑擊護腕",
		["Bloodvine Boots"] = "血藤長靴",
		["Bloodvine Leggings"] = "血藤護腿",
		["Bloodvine Vest"] = "血藤外衣",
		["Blue Linen Robe"] = "藍色亞麻長袍",
		["Blue Linen Shirt"] = "藍色亞麻襯衣",
		["Blue Linen Vest"] = "藍色亞麻外衣",
		["Blue Overalls"] = "藍色罩衫",
		["Bolt of Imbued Netherweave"] = "魔染幽紋布卷",
		["Bolt of Linen Cloth"] = "亞麻布卷",
		["Bolt of Mageweave"] = "魔紋布卷",
		["Bolt of Netherweave"] = "幽紋布卷",
		["Bolt of Runecloth"] = "符文布卷",
		["Bolt of Silk Cloth"] = "絲綢卷",
		["Bolt of Soulcloth"] = "靈魂布卷",
		["Bolt of Woolen Cloth"] = "毛布卷",
		["Boots of Blasting"] = "衝擊之靴",
		["Boots of the Enchanter"] = "附魔師之靴",
		["Boots of the Long Road"] = "長路之靴",
		["Bottomless Bag"] = "無底之包",
		["Bracers of Havok"] = "哈伏克護腕",
		["Bracers of Nimble Thought"] = "靈機護腕",
		["Bright Yellow Shirt"] = "淡黃色襯衣",
		["Brightcloth Cloak"] = "亮布披風",
		["Brightcloth Gloves"] = "亮布手套",
		["Brightcloth Pants"] = "亮布便褲",
		["Brightcloth Robe"] = "亮布長袍",
		["Brown Linen Pants"] = "棕色亞麻便褲",
		["Brown Linen Robe"] = "棕色亞麻長袍",
		["Brown Linen Shirt"] = "棕色亞麻襯衣",
		["Brown Linen Vest"] = "棕色亞麻外衣",
		["Cenarion Herb Bag"] = "塞納里奧草藥包",
		["Cindercloth Boots"] = "灰布長靴",
		["Cindercloth Cloak"] = "灰布披風",
		["Cindercloth Gloves"] = "灰布手套",
		["Cindercloth Pants"] = "灰布便褲",
		["Cindercloth Robe"] = "灰布長袍",
		["Cindercloth Vest"] = "灰布外衣",
		["Cloak of Arcane Evasion"] = "秘法迴避披風",
		["Cloak of Eternity"] = "永恆披風",
		["Cloak of Fire"] = "火焰披風",
		["Cloak of the Black Void"] = "黑色虛無披風",
		["Cloak of Warding"] = "防護披風",
		["Colorful Kilt"] = "多彩褶裙",
		["Core Felcloth Bag"] = "熔核惡魔布包",
		["Crimson Silk Belt"] = "赤紅絲質腰帶",
		["Crimson Silk Cloak"] = "赤紅絲質披風",
		["Crimson Silk Gloves"] = "赤紅絲質手套",
		["Crimson Silk Pantaloons"] = "赤紅絲質窄褲",
		["Crimson Silk Robe"] = "赤紅絲質長袍",
		["Crimson Silk Shoulders"] = "赤紅絲質護肩",
		["Crimson Silk Vest"] = "赤紅絲質外衣",
		["Dark Silk Shirt"] = "黑絲襯衣",
		["Double-stitched Woolen Shoulders"] = "雙線毛紡護肩",
		["Dreamweave Circlet"] = "織夢頭環",
		["Dreamweave Gloves"] = "織夢手套",
		["Dreamweave Vest"] = "織夢外衣",
		["Earthen Silk Belt"] = "土靈絲質腰帶",
		["Earthen Vest"] = "土靈外衣",
		["Ebon Shadowbag"] = "黑檀暗影包",
		["Enchanted Mageweave Pouch"] = "附魔魔紋包",
		["Enchanted Runecloth Bag"] = "附魔符文布背包",
		["Enchanter's Cowl"] = "附魔師風帽",
		["Felcloth Bag"] = "惡魔布包",
		["Felcloth Boots"] = "惡魔布靴",
		["Felcloth Gloves"] = "惡魔布手套",
		["Felcloth Hood"] = "惡魔布兜帽",
		["Felcloth Pants"] = "惡魔布便褲",
		["Felcloth Robe"] = "惡魔布袍",
		["Felcloth Shoulders"] = "惡魔布護肩",
		["Festival Dress"] = "節慶長裙",
		--["Festive Red Dress"] = "Festive Red Dress", doesn't exist?
		["Festive Red Pant Suit"] = "紅色節慶褲子",
		["Flameheart Bracers"] = "烈焰之心護腕",
		["Flameheart Gloves"] = "烈焰之心手套",
		["Flameheart Vest"] = "烈焰之心外衣",
		["Flarecore Gloves"] = "光核手套",
		["Flarecore Leggings"] = "光核護腿",
		["Flarecore Mantle"] = "光核披肩",
		["Flarecore Robe"] = "光核長袍",
		["Flarecore Wraps"] = "光核裹帶",
		["Formal White Shirt"] = "體面的白襯衣",
		["Frostweave Gloves"] = "霜紋手套",
		["Frostweave Pants"] = "霜紋便褲",
		["Frostweave Robe"] = "霜紋長袍",
		["Frostweave Tunic"] = "霜紋外套",
		["Frozen Shadoweave Boots"] = "冰霜影紋之靴",
		["Frozen Shadoweave Shoulders"] = "冰霜影紋護肩",
		["Frozen Shadoweave Robe"] = "冰霜影紋長袍",
		["Gaea's Embrace"] = "蓋亞之擁",
		["Ghostweave Belt"] = "鬼紋腰帶",
		["Ghostweave Gloves"] = "鬼紋手套",
		["Ghostweave Pants"] = "鬼紋便褲",
		["Ghostweave Vest"] = "鬼紋外衣",
		["Girdle of Ruination"] = "禍根束腰",
		["Glacial Cloak"] = "冰川披風",
		["Glacial Gloves"] = "冰川手套",
		["Glacial Vest"] = "冰川外衣",
		["Glacial Wrists"] = "冰川腕帶",
		["Gloves of Meditation"] = "冥想手套",
		["Gloves of Spell Mastery"] = "精通法術手套",
		["Golden Spellthread"] = "金色法術絲線",
		["Gordok Ogre Suit"] = "戈多克巨魔裝",
		["Gray Woolen Robe"] = "灰色毛紡長袍",
		["Gray Woolen Shirt"] = "灰色毛紡襯衣",
		["Greater Adept's Robe"] = "大師長袍",
		["Green Holiday Shirt"] = "綠色節日襯衣",
		["Green Linen Bracers"] = "綠色亞麻護腕",
		["Green Linen Shirt"] = "綠色亞麻襯衣",
		["Green Silk Armor"] = "綠色絲甲",
		["Green Silk Pack"] = "綠色絲質包",
		["Green Silken Shoulders"] = "綠色絲質護肩",
		["Green Winter Clothes"] = "綠色冬裝",
		["Green Woolen Bag"] = "綠色毛紡包",
		["Green Woolen Vest"] = "綠色毛紡外衣",
		["Hands of Darkness"] = "黑暗之手",
		["Handstitched Linen Britches"] = "手工亞麻褲",
		["Heavy Linen Gloves"] = "高級亞麻手套",
		["Heavy Woolen Cloak"] = "重型毛紡披風",
		["Heavy Woolen Gloves"] = "高級毛紡手套",
		["Heavy Woolen Pants"] = "高級毛紡便褲",
		["Icy Cloak"] = "冰覆披風",
		["Imbued Netherweave Bag"] = "魔染幽紋布包",
		["Imbued Netherweave Boots"] = "魔染幽紋長靴",
		["Imbued Netherweave Pants"] = "魔染幽紋便褲",
		["Imbued Netherweave Robe"] = "魔染幽紋長袍",
		["Imbued Netherweave Tunic"] = "魔染幽紋外套",
		["Inferno Gloves"] = "地獄火手套",
		["Lavender Mageweave Shirt"] = "紫色魔紋襯衣",
		["Lesser Wizard's Robe"] = "次級巫師袍",
		["Linen Bag"] = "亞麻包",
		["Linen Belt"] = "亞麻腰帶",
		["Linen Boots"] = "亞麻靴",
		["Linen Cloak"] = "亞麻披風",
		["Long Silken Cloak"] = "絲質長披風",
		["Mageweave Bag"] = "魔紋包",
		["Manaweave Cloak"] = "法力之紋披風",
		["Mantle of Nimble Thought"] = "靈機披肩",
		["Mantle of the Timbermaw"] = "木喉披肩",
		["Mooncloth Bag"] = "月布包",
		["Mooncloth Boots"] = "月布長靴",
		["Mooncloth Circlet"] = "月布頭環",
		["Mooncloth Gloves"] = "月布手套",
		["Mooncloth Leggings"] = "月布護腿",
		["Mooncloth Robe"] = "月布長袍",
		["Mooncloth Shoulders"] = "月布護肩",
		["Mooncloth Vest"] = "月布外衣",
		["Mooncloth"] = "月布",
		["Mystic Spellthread"] = "神秘法術絲線",
		["Netherweave Bag"] = "幽紋布包",
		["Netherweave Belt"] = "幽紋腰帶",
		["Netherweave Boots"] = "幽紋長靴",
		["Netherweave Bracers"] = "幽紋護腕",
		["Netherweave Gloves"] = "幽紋手套",
		["Netherweave Net"] = "幽紋之網",
		["Netherweave Pants"] = "幽紋便褲",
		["Netherweave Robe"] = "幽紋長袍",
		["Netherweave Tunic"] = "幽紋外套",
		["Night's End"] = "夜幕之終",
		["Orange Mageweave Shirt"] = "橙色魔紋襯衣",
		["Orange Martial Shirt"] = "橙色軍用襯衣",
		["Pearl-clasped Cloak"] = "珍珠披風",
		["Phoenix Gloves"] = "鳳凰手套",
		["Phoenix Pants"] = "鳳凰便褲",
		["Pink Mageweave Shirt"] = "粉紅魔紋襯衣",
		["Primal Mooncloth Bag"] = "原始月布包",
		["Primal Mooncloth Belt"] = "原始月布腰帶",
		["Primal Mooncloth Robe"] = "原始月布長袍",
		["Primal Mooncloth Shoulders"] = "原始月布護肩",
		["Primal Mooncloth"] = "原始月布",
		["Red Linen Bag"] = "紅色亞麻包",
		["Red Linen Robe"] = "紅色亞麻長袍",
		["Red Linen Shirt"] = "紅色亞麻襯衣",
		["Red Linen Vest"] = "紅色亞麻外衣",
		["Red Mageweave Bag"] = "紅色魔紋包",
		["Red Mageweave Gloves"] = "紅色魔紋手套",
		["Red Mageweave Headband"] = "紅色魔紋頭帶",
		["Red Mageweave Pants"] = "紅色魔紋便褲",
		["Red Mageweave Shoulders"] = "紅色魔紋護肩",
		["Red Mageweave Vest"] = "紅色魔紋外衣",
		["Red Swashbuckler's Shirt"] = "紅色劍客襯衣",
		["Red Woolen Bag"] = "紅色毛紡包",
		["Red Woolen Boots"] = "紅色毛紡靴",
		["Reinforced Linen Cape"] = "強化亞麻斗篷",
		["Red Winter Clothes"] = "紅色冬裝",
		["Reinforced Woolen Shoulders"] = "強化毛紡護肩",
		["Resolute Cape"] = "堅決斗篷",
		["Rich Purple Silk Shirt"] = "紫色絲質襯衣",
		["Robe of Power"] = "力量長袍",
		["Robe of the Archmage"] = "大法師之袍",
		["Robe of the Void"] = "虛無長袍",
		["Robe of Winter Night"] = "冬夜長袍",
		["Robes of Arcana"] = "神秘的長袍",
		["Runecloth Bag"] = "符文布背包",
		["Runecloth Belt"] = "符文布腰帶",
		["Runecloth Boots"] = "符文布靴",
		["Runecloth Cloak"] = "符文布披風",
		["Runecloth Gloves"] = "符文布手套",
		["Runecloth Headband"] = "符文布頭帶",
		["Runecloth Pants"] = "符文布便褲",
		["Runecloth Robe"] = "符文布袍",
		["Runecloth Shoulders"] = "符文布護肩",
		["Runecloth Tunic"] = "符文布外套",
		["Runed Stygian Belt"] = "符文冥河腰帶",
		["Runed Stygian Boots"] = "符文冥河長靴",
		["Runed Stygian Leggings"] = "符文冥河護腿",
		["Runic Spellthread"] = "符文法術絲線",
		["Satchel of Cenarius"] = "塞納留斯的背包",
		["Shadow Hood"] = "暗影兜帽",
		["Shadowcloth"] = "暗影布",
		["Shadoweave Boots"] = "影紋之靴",
		["Shadoweave Gloves"] = "影紋手套",
		["Shadoweave Mask"] = "影紋面罩",
		["Shadoweave Pants"] = "影紋便褲",
		["Shadoweave Robe"] = "影紋長袍",
		["Shadoweave Shoulders"] = "影紋護肩",
		["Silk Headband"] = "絲質頭帶",
		["Silver Spellthread"] = "銀色法術絲線",
		["Simple Black Dress"] = "簡單的黑裙子",
		["Simple Dress"] = "簡單的裙子",
		["Simple Kilt"] = "簡單的褶裙",
		["Simple Linen Boots"] = "簡單的亞麻靴",
		["Simple Linen Pants"] = "簡單的亞麻便褲",
		["Small Silk Pack"] = "絲綢小包",
		["Soft-soled Linen Boots"] = "軟底亞麻靴",
		["Soul Pouch"] = "靈魂袋",
		["Soulcloth Gloves"] = "靈魂布手套",
		["Soulcloth Shoulders"] = "靈魂布護肩",
		["Soulcloth Vest"] = "靈魂布外衣",
		["Soulguard Bracers"] = "靈魂守護護腕",
		["Soulguard Girdle"] = "靈魂守護束腰",
		["Soulguard Leggings"] = "靈魂守護護腿",
		["Soulguard Slippers"] = "靈魂守護軟靴",
		["Spellcloth"] = "魔法布",
		["Spellfire Bag"] = "魔焰包",
		["Spellfire Belt"] = "魔焰腰帶",
		["Spellfire Gloves"] = "魔焰手套",
		["Spellfire Robe"] = "魔焰長袍",
		["Spellstrike Hood"] = "法擊兜帽",
		["Spellstrike Pants"] = "法擊便褲",
		["Spider Belt"] = "蜘蛛腰帶",
		["Spider Silk Slippers"] = "蛛絲軟靴",
		["Spidersilk Boots"] = "蛛絲之靴",
		["Star Belt"] = "星辰腰帶",
		["Stylish Blue Shirt"] = "時髦藍襯衣",
		["Stylish Green Shirt"] = "時髦綠襯衣",
		["Stylish Red Shirt"] = "時髦紅襯衣",
		["Swiftheal Mantle"] = "速癒披肩",
		["Swiftheal Wraps"] = "速癒裹帶",
		["Sylvan Crown"] = "森林之冠",
		["Sylvan Shoulders"] = "森林護肩",
		["Sylvan Vest"] = "森林外衣",
		["Truefaith Gloves"] = "真誠手套",
		["Truefaith Vestments"] = "真誠外衣",
		["Tuxedo Jacket"] = "禮服夾克",
		["Tuxedo Pants"] = "禮服便褲",
		["Tuxedo Shirt"] = "禮服襯衣",
		["Unyielding Bracers"] = "不屈護腕",
		["Unyielding Girdle"] = "不屈束腰",
		["Vengeance Wrap"] = "復仇披風",
		["White Bandit Mask"] = "白色強盜面罩",
		["White Linen Robe"] = "白色亞麻長袍",
		["White Linen Shirt"] = "白色亞麻襯衣",
		["White Remedy Cape"] = "白色治療斗篷",
		["White Swashbuckler's Shirt"] = "白色劍客襯衣",
		["White Wedding Dress"] = "白色婚紗",
		["White Woolen Dress"] = "白色毛絨裙",
		["Whitemend Hood"] = "白癒兜帽",
		["Whitemend Pants"] = "白癒便褲",
		["Wisdom of the Timbermaw"] = "木喉之智",
		["Wizardweave Leggings"] = "巫紋護腿",
		["Wizardweave Robe"] = "巫紋長袍",
		["Wizardweave Turban"] = "巫紋頭巾",
		["Woolen Bag"] = "毛紡包",
		["Woolen Boots"] = "毛紡靴",
		["Woolen Cape"] = "毛紡斗篷",
		["Sunfire Robe"] = "日炎長袍",
		["Sunfire Handwraps"] = "日炎裹手",
		["Robe of Eternal Light"] = "永恆之光長袍",
		["Hands of Eternal Light"] = "永恆之光手套",

	}
end)

BabbleTradeskill:RegisterTranslations("koKR", function()
	return {
-- Gathering skills
		["Disenchant"] = "마력 추출",
		["Fishing"] = "낚시",
		["Herbalism"] = "약초 채집",
		["Mining"] = "채광",
		["Pick Pocket"] = "훔치기",
		["Prospecting"] = "보석 추출",
		["Skinning"] = "무두질",
		["Smelting"] = "제련술",

-- Crafting skills
		["Alchemy"] = "연금술",
		["Armorsmith"] = "방어구제작",
		["Blacksmithing"] = "대장기술",
		["Cooking"] = "요리",
		["Dragonscale Leatherworking"] = "용비늘 가죽세공",
		["Elemental Leatherworking"] = "원소 가죽세공",
		["Elixir Master"] = "비약의 대가",
		["Enchanting"] = "마법부여",
		["Engineering"] = "기계공학",
		["First Aid"] = "응급치료",
		["Gnomish Engineering"] = "노움 기계공학",
		["Goblin Engineering"] = "고블린 기계공학",
		["Gnomish Engineer"] = "노움 기계공학",
		["Goblin Engineer"] = "고블린 기계공학",
		["Jewelcrafting"] = "보석세공",
		["Leatherworking"] = "가죽세공",
		["Master Axesmith"] = "도끼 제작의 대가",
		["Master Hammersmith"] = "망치 제작의 대가",
		["Master Swordsmith"] = "검 제작의 대가",
		["Mooncloth Tailoring"] = "달빛매듭 재봉술",
		["Poisons"] = "독 조제",
		["Potion Master"] = "물약의 대가",
		["Shadoweave Tailoring"] = "그림자매듭 재봉술",
		["Spellfire Tailoring"] = "마법불꽃 재봉술",
		["Tailoring"] = "재봉술",
		["Transmutation Master"] = "변환의 대가",
		["Tribal Leatherworking"] = "전통 가죽세공",
		["Weaponsmith"] = "무기제작",

-- Alchemy Recipes
		["Adept's Elixir"] = "숙련의 비약",
		["Alchemist's Stone"] = "연금술사의 돌",
		["Arcane Elixir"] = "신비의 비약",
		["Blackmouth Oil"] = "아귀 오일",
		["Catseye Elixir"] = "고양이눈 비약",
		["Cauldron of Major Arcane Protection"] = "최상급 비전 보호의 가마솥",
		["Cauldron of Major Fire Protection"] = "최상급 화염 보호의 가마솥",
		["Cauldron of Major Frost Protection"] = "최상급 냉기 보호의 가마솥",
		["Cauldron of Major Nature Protection"] = "최상급 자연 보호의 가마솥",
		["Cauldron of Major Shadow Protection"] = "최상급 암흑 보호의 가마솥",
		["Destruction Potion"] = "파괴의 물약",
		["Discolored Healing Potion"] = "빛바랜 치유 물약",
		["Dreamless Sleep Potion"] = "숙면의 물약",
		["Earthen Elixir"] = "대지의 비약",
		["Elixir of Agility"] = "민첩의 비약",
		["Elixir of Brute Force"] = "야수 힘의 비약",
		["Elixir of Camouflage"] = "위장의 비약",
		["Elixir of Defense"] = "방어의 비약",
		["Elixir of Demonslaying"] = "악마 사냥 전문화의 비약",
		["Elixir of Detect Demon"] = "악마 감지의 비약",
		["Elixir of Detect Lesser Invisibility"] = "하급 투명체 감지의 비약",
		["Elixir of Detect Undead"] = "언데드 감지의 비약",
		["Elixir of Draenic Wisdom"] = "드레나이 지혜의 비약",
		["Elixir of Dream Vision"] = "몽상의 비약",
		["Elixir of Empowerment"] = "권능의 비약",
		["Elixir of Firepower"] = "화염 강화의 비약",
		["Elixir of Fortitude"] = "인내의 비약",
		["Elixir of Frost Power"] = "냉기 강화의 비약",
		["Elixir of Giant Growth"] = "성장의 비약",
		["Elixir of Giants"] = "거인의 비약",
		["Elixir of Greater Agility"] = "상급 민첩의 비약",
		["Elixir of Greater Defense"] = "상급 방어의 비약",
		["Elixir of Greater Firepower"] = "상급 화염 강화의 비약",
		["Elixir of Greater Intellect"] = "상급 지능의 비약",
		["Elixir of Greater Water Breathing"] = "상급 수중 호흡의 비약",
		["Elixir of Healing Power"] = "치유력 강화의 비약",
		["Elixir of Ironskin"] = "무쇠가죽 비약",
		["Elixir of Lesser Agility"] = "하급 민첩의 비약",
		["Elixir of Lion's Strength"] = "사자의 힘 비약",
		["Elixir of Major Agility"] = "최상급 민첩의 비약",
		["Elixir of Major Defense"] = "일급 방어의 비약",
		["Elixir of Major Firepower"] = "최상급 화염 강화의 비약",
		["Elixir of Major Fortitude"] = "최상급 인내의 비약",
		["Elixir of Major Frost Power"] = "최상급 냉기 강화의 비약",
		["Elixir of Major Mageblood"] = "최상급 마력의 비약",
		["Elixir of Major Shadow Power"] = "최상급 암흑 강화의 비약",
		["Elixir of Major Strength"] = "최상급 힘의 비약",
		["Elixir of Mastery"] = "정통의 비약",
		["Elixir of Minor Agility"] = "최하급 민첩의 비약",
		["Elixir of Minor Defense"] = "최하급 방어의 비약",
		["Elixir of Minor Fortitude"] = "최하급 인내의 비약",
		["Elixir of Ogre's Strength"] = "오우거의 힘 비약",
		["Elixir of Shadow Power"] = "암흑 강화의 비약",
		["Elixir of Superior Defense"] = "최상급 방어의 비약",
		["Elixir of the Mongoose"] = "살쾡이의 비약",
		["Elixir of the Sages"] = "현인의 비약",
		["Elixir of the Searching Eye"] = "탐색의 비약",
		["Elixir of Water Breathing"] = "수중 호흡의 비약",
		["Elixir of Wisdom"] = "지혜의 비약",
		["Fel Mana Potion"] = "타락의 마나 물약",
		["Fel Regeneration Potion"] = "타락의 회복 물약",
		["Fel Strength Elixir"] = "타락한 힘의 비약",
		["Fire Oil"] = "화염 오일",
		["Fire Protection Potion"] = "화염 보호 물약",
		["Flask of Blinding Light"] = "눈부신 빛의 영약",
		["Flask of Chromatic Resistance"] = "마력 저항의 영약",
		["Flask of Chromatic Wonder"] = "오색 신비의 영약",
		["Flask of Distilled Wisdom"] = "순수한 지혜의 영약",
		["Flask of Fortification"] = "증강의 영약",
		["Flask of Mighty Restoration"] = "강력한 마나 회복의 영약",
		["Flask of Petrification"] = "석화의 영약",
		["Flask of Pure Death"] = "순수한 죽음의 영약",
		["Flask of Relentless Assault"] = "가혹한 공격의 영약",
		["Flask of Supreme Power"] = "강력한 마력의 영약",
		["Flask of the Titans"] = "티탄의 영약",
		["Free Action Potion"] = "자유 의지의 물약",
		["Frost Oil"] = "냉기 오일",
		["Frost Protection Potion"] = "냉기 보호 물약",
		["Ghost Dye"] = "유령 염료",
		["Gift of Arthas"] = "아서스의 선물",
		["Goblin Rocket Fuel"] = "고블린 로켓 연료",
		["Great Rage Potion"] = "상급 분노의 물약",
		["Greater Arcane Elixir"] = "상급 신비의 비약",
		["Greater Arcane Protection Potion"] = "상급 비전 보호 물약",
		["Greater Dreamless Sleep Potion"] = "상급 숙면의 물약",
		["Greater Fire Protection Potion"] = "상급 화염 보호 물약",
		["Greater Frost Protection Potion"] = "상급 냉기 보호 물약",
		["Greater Healing Potion"] = "상급 치유 물약",
		["Greater Mana Potion"] = "상급 마나 물약",
		["Greater Nature Protection Potion"] = "상급 자연 보호 물약",
		["Greater Shadow Protection Potion"] = "상급 암흑 보호 물약",
		["Greater Stoneshield Potion"] = "상급 돌방패 물약",
		["Gurubashi Mojo Madness"] = "광기의 구루바시 모조",
		["Haste Potion"] = "가속의 물약",
		["Healing Potion"] = "치유 물약",
		["Heroic Potion"] = "영웅의 물약",
		["Holy Protection Potion"] = "신성 보호 물약",
		["Insane Strength Potion"] = "광기어린 힘의 물약",
		["Invisibility Potion"] = "투명 물약",
		["Ironshield Potion"] = "무쇠방패 물약",
		["Lesser Healing Potion"] = "하급 치유 물약",
		["Lesser Invisibility Potion"] = "하급 투명 물약",
		["Lesser Mana Potion"] = "하급 마나 물약",
		["Lesser Stoneshield Potion"] = "하급 돌방패 물약",
		["Limited Invulnerability Potion"] = "제한된 무적 물약",
		["Living Action Potion"] = "자유 행동의 물약",
		["Mad Alchemist's Potion"] = "미치광이 연금술사의 물약",
		["Mageblood Potion"] = "마력의 물약",
		["Magic Resistance Potion"] = "마법 저항 물약",
		["Major Arcane Protection Potion"] = "최상급 비전 보호 물약",
		["Major Dreamless Sleep Potion"] = "최상급 숙면의 물약",
		["Major Fire Protection Potion"] = "최상급 화염 보호 물약",
		["Major Frost Protection Potion"] = "최상급 냉기 보호 물약",
		["Major Healing Potion"] = "일급 치유 물약",
		["Major Holy Protection Potion"] = "최상급 신성 보호 물약",
		["Major Mana Potion"] = "일급 마나 물약",
		["Major Nature Protection Potion"] = "최상급 자연 보호 물약",
		["Major Rejuvenation Potion"] = "일급 회복 물약",
		["Major Shadow Protection Potion"] = "최상급 암흑 보호 물약",
		["Major Troll's Blood Potion"] = "일급 재생의 물약",
		["Mana Potion"] = "마나 물약",
		["Mercurial Stone"] = "수은석",
		["Mighty Rage Potion"] = "강력한 분노의 물약",
		["Mighty Troll's Blood Potion"] = "강력한 재생의 물약",
		["Minor Healing Potion"] = "최하급 치유 물약",
		["Minor Magic Resistance Potion"] = "최하급 마법 저항 물약",
		["Minor Mana Potion"] = "최하급 마나 물약",
		["Minor Rejuvenation Potion"] = "최하급 회복 물약",
		["Nature Protection Potion"] = "자연 보호 물약",
		["Oil of Immolation"] = "제물의 오일",
		["Onslaught Elixir"] = "맹공의 비약",
		["Philosopher's Stone"] = "현자의 돌",
		["Potion of Curing"] = "독 치료의 물약",
		["Purification Potion"] = "정화 물약",
		["Rage Potion"] = "분노 물약",
		["Restorative Potion"] = "복원의 물약",
		["Shadow Oil"] = "암흑 오일",
		["Shadow Protection Potion"] = "암흑 보호 물약",
		["Shrouding Potion"] = "장막의 물약",
		["Sneaking Potion"] = "은신의 물약",
		["Stonescale Oil"] = "돌비늘 오일",
		["Strong Troll's Blood Potion"] = "강한 재생의 물약",
		["Super Healing Potion"] = "특급 치유 물약",
		["Super Mana Potion"] = "특급 마나 물약",
		["Super Rejuvenation Potion"] = "특급 회복 물약",
		["Superior Healing Potion"] = "최상급 치유 물약",
		["Superior Mana Potion"] = "최상급 마나 물약",
		["Swiftness Potion"] = "신속의 물약",
		["Swim Speed Potion"] = "신속한 수영 물약",
		["Transmute: Air to Fire"] = "변환식: 바람을 불로",
		["Transmute: Arcanite"] = "변환식: 아케이나이트",
		["Transmute: Earth to Life"] = "변환식: 대지를 생명으로",
		["Transmute: Earth to Water"] = "변환식: 대지를 물로",
		["Transmute: Earthstorm Diamond"] = "변환식: 대지폭풍 다이아몬드",
		["Transmute: Elemental Fire"] = "변환식: 자연의 불꽃",
		["Transmute: Fire to Earth"] = "변환식: 불을 대지로",
		["Transmute: Iron to Gold"] = "변환식: 철을 금으로",
		["Transmute: Life to Earth"] = "변환식: 생명을 대지로",
		["Transmute: Mithril to Truesilver"] = "변환식: 미스릴을 진은으로",
		["Transmute: Primal Air to Fire"] = "변환식: 바람의 근원을 불로",
		["Transmute: Primal Earth to Life"] = "변환식: 대지의 근원을 생명으로",
		["Transmute: Primal Earth to Water"] = "변환식: 대지의 근원을 물로",
		["Transmute: Primal Fire to Earth"] = "변환식: 불의 근원을 대지로",
		["Transmute: Primal Fire to Mana"] = "변환식: 불의 근원을 마나로",
		["Transmute: Primal Life to Earth"] = "변환식: 생명의 근원을 대지로",
		["Transmute: Primal Mana to Fire"] = "변환식: 마나의 근원을 불로",
		["Transmute: Primal Might"] = "변환식: 힘의 근원",
		["Transmute: Primal Shadow to Water"] = "변환식: 어둠의 근원을 물로",
		["Transmute: Primal Water to Air"] = "변환식: 물의 근원을 바람으로",
		["Transmute: Primal Water to Shadow"] = "변환식: 물의 근원을 어둠으로",
		["Transmute: Skyfire Diamond"] = "변환식: 하늘불꽃 다이아몬드",
		["Transmute: Undeath to Water"] = "변환식: 불사를 물로",
		["Transmute: Water to Air"] = "변환식: 물을 바람으로",
		["Transmute: Water to Undeath"] = "변환식: 물을 불사로",
		["Unstable Mana Potion"] = "불안정한 마나 물약",
		["Volatile Healing Potion"] = "신속 치유 물약",
		["Weak Troll's Blood Potion"] = "약한 재생의 물약",
		["Wildvine Potion"] = "야생덩굴 물약",

-- Beast Training Skills
		["Arcane Resistance (Rank 1)"] = "비전 마법 저항 (1 레벨)",
		["Arcane Resistance (Rank 2)"] = "비전 마법 저항 (2 레벨)",
		["Arcane Resistance (Rank 3)"] = "비전 마법 저항 (3 레벨)",
		["Arcane Resistance (Rank 4)"] = "비전 마법 저항 (4 레벨)",
		["Arcane Resistance (Rank 5)"] = "비전 마법 저항 (5 레벨)",
		["Avoidance (Rank 1)"] = "마력 회피 (1 레벨)",
		["Avoidance (Rank 2)"] = "마력 회피 (2 레벨)",
		["Bite (Rank 1)"] = "물기 (1 레벨)",
		["Bite (Rank 2)"] = "물기 (2 레벨)",
		["Bite (Rank 3)"] = "물기 (3 레벨)",
		["Bite (Rank 4)"] = "물기 (4 레벨)",
		["Bite (Rank 5)"] = "물기 (5 레벨)",
		["Bite (Rank 6)"] = "물기 (6 레벨)",
		["Bite (Rank 7)"] = "물기 (7 레벨)",
		["Bite (Rank 8)"] = "물기 (8 레벨)",
		["Bite (Rank 9)"] = "물기 (9 레벨)",
		["Charge (Rank 1)"] = "돌진 (1 레벨)",
		["Charge (Rank 2)"] = "돌진 (2 레벨)",
		["Charge (Rank 3)"] = "돌진 (3 레벨)",
		--["Charge (Rank 4)"] = true, -- No charge rank 4 in the game
		["Charge (Rank 5)"] = "돌진 (5 레벨)",
		["Charge (Rank 6)"] = "돌진 (6 레벨)",
		["Claw (Rank 1)"] = "할퀴기 (1 레벨)",
		["Claw (Rank 2)"] = "할퀴기 (2 레벨)",
		["Claw (Rank 3)"] = "할퀴기 (3 레벨)",
		["Claw (Rank 4)"] = "할퀴기 (4 레벨)",
		["Claw (Rank 5)"] = "할퀴기 (5 레벨)",
		["Claw (Rank 6)"] = "할퀴기 (6 레벨)",
		["Claw (Rank 7)"] = "할퀴기 (7 레벨)",
		["Claw (Rank 8)"] = "할퀴기 (8 레벨)",
		["Claw (Rank 9)"] = "할퀴기 (9 레벨)",
		["Cobra Reflexes ()"] = "코브라의 반사신경",
		["Cower (Rank 1)"] = "웅크리기 (1 레벨)",
		["Cower (Rank 2)"] = "웅크리기 (2 레벨)",
		["Cower (Rank 3)"] = "웅크리기 (3 레벨)",
		["Cower (Rank 4)"] = "웅크리기 (4 레벨)",
		["Cower (Rank 5)"] = "웅크리기 (5 레벨)",
		["Cower (Rank 6)"] = "웅크리기 (6 레벨)",
		["Cower (Rank 7)"] = "웅크리기 (7 레벨)",
		["Dash (Rank 1)"] = "질주 (1 레벨)",
		["Dash (Rank 2)"] = "질주 (2 레벨)",
		["Dash (Rank 3)"] = "질주 (3 레벨)",
		["Dive (Rank 1)"] = "급강하 (1 레벨)",
		["Dive (Rank 2)"] = "급강하 (2 레벨)",
		["Dive (Rank 3)"] = "급강하 (3 레벨)",
		["Fire Breath (Rank 1)"] = "불의 숨결 (1 레벨)",
		["Fire Breath (Rank 2)"] = "불의 숨결 (2 레벨)",
		["Fire Resistance (Rank 1)"] = "화염 마법 저항 (1 레벨)",
		["Fire Resistance (Rank 2)"] = "화염 마법 저항 (2 레벨)",
		["Fire Resistance (Rank 3)"] = "화염 마법 저항 (3 레벨)",
		["Fire Resistance (Rank 4)"] = "화염 마법 저항 (4 레벨)",
		["Fire Resistance (Rank 5)"] = "화염 마법 저항 (5 레벨)",
		["Frost Resistance (Rank 1)"] = "냉기 마법 저항 (1 레벨)",
		["Frost Resistance (Rank 2)"] = "냉기 마법 저항 (2 레벨)",
		["Frost Resistance (Rank 3)"] = "냉기 마법 저항 (3 레벨)",
		["Frost Resistance (Rank 4)"] = "냉기 마법 저항 (4 레벨)",
		["Frost Resistance (Rank 5)"] = "냉기 마법 저항 (5 레벨)",
		["Furious Howl (Rank 1)"] = "사나운 울음소리 (1 레벨)",
		["Furious Howl (Rank 2)"] = "사나운 울음소리 (2 레벨)",
		["Furious Howl (Rank 3)"] = "사나운 울음소리 (3 레벨)",
		["Furious Howl (Rank 4)"] = "사나운 울음소리 (4 레벨)",
		["Gore (Rank 1)"] = "들이받기 (1 레벨)",
		["Gore (Rank 2)"] = "들이받기 (2 레벨)",
		["Gore (Rank 3)"] = "들이받기 (3 레벨)",
		["Gore (Rank 4)"] = "들이받기 (4 레벨)",
		--["Gore (Rank 5)"] = true, -- Not in game
		--["Gore (Rank 6)"] = true, -- Not in game
		["Gore (Rank 7)"] = "들이받기 (7 레벨)",
		["Gore (Rank 8)"] = "들이받기 (8 레벨)",
		["Gore (Rank 9)"] = "들이받기 (9 레벨)",
		["Great Stamina (Rank 1)"] = "강인한 체력 (1 레벨)",
		["Great Stamina (Rank 10)"] = "강인한 체력 (10 레벨)",
		["Great Stamina (Rank 11)"] = "강인한 체력 (11 레벨)",
		["Great Stamina (Rank 2)"] = "강인한 체력 (2 레벨)",
		["Great Stamina (Rank 3)"] = "강인한 체력 (3 레벨)",
		["Great Stamina (Rank 4)"] = "강인한 체력 (4 레벨)",
		["Great Stamina (Rank 5)"] = "강인한 체력 (5 레벨)",
		["Great Stamina (Rank 6)"] = "강인한 체력 (6 레벨)",
		["Great Stamina (Rank 7)"] = "강인한 체력 (7 레벨)",
		["Great Stamina (Rank 8)"] = "강인한 체력 (8 레벨)",
		["Great Stamina (Rank 9)"] = "강인한 체력 (9 레벨)",
		["Growl (Rank 1)"] = "포효 (1 레벨)",
		["Growl (Rank 2)"] = "포효 (2 레벨)",
		["Growl (Rank 3)"] = "포효 (3 레벨)",
		["Growl (Rank 4)"] = "포효 (4 레벨)",
		["Growl (Rank 5)"] = "포효 (5 레벨)",
		["Growl (Rank 6)"] = "포효 (6 레벨)",
		["Growl (Rank 7)"] = "포효 (7 레벨)",
		["Growl (Rank 8)"] = "포효 (8 레벨)",
		["Lightning Breath (Rank 1)"] = "번개 숨결 (1 레벨)",
		["Lightning Breath (Rank 2)"] = "번개 숨결 (2 레벨)",
		["Lightning Breath (Rank 3)"] = "번개 숨결 (3 레벨)",
		["Lightning Breath (Rank 4)"] = "번개 숨결 (4 레벨)",
		["Lightning Breath (Rank 5)"] = "번개 숨결 (5 레벨)",
		["Lightning Breath (Rank 6)"] = "번개 숨결 (6 레벨)",
		["Natural Armor (Rank 1)"] = "무쇠 가죽 (1 레벨)",
		["Natural Armor (Rank 10)"] = "무쇠 가죽 (10 레벨)",
		["Natural Armor (Rank 11)"] = "무쇠 가죽 (11 레벨)",
		["Natural Armor (Rank 2)"] = "무쇠 가죽 (2 레벨)",
		["Natural Armor (Rank 3)"] = "무쇠 가죽 (3 레벨)",
		["Natural Armor (Rank 4)"] = "무쇠 가죽 (4 레벨)",
		["Natural Armor (Rank 5)"] = "무쇠 가죽 (5 레벨)",
		["Natural Armor (Rank 6)"] = "무쇠 가죽 (6 레벨)",
		["Natural Armor (Rank 7)"] = "무쇠 가죽 (7 레벨)",
		["Natural Armor (Rank 8)"] = "무쇠 가죽 (8 레벨)",
		["Natural Armor (Rank 9)"] = "무쇠 가죽 (9 레벨)",
		["Nature Resistance (Rank 1)"] = "자연 마법 저항 (1 레벨)",
		["Nature Resistance (Rank 2)"] = "자연 마법 저항 (2 레벨)",
		["Nature Resistance (Rank 3)"] = "자연 마법 저항 (3 레벨)",
		["Nature Resistance (Rank 4)"] = "자연 마법 저항 (4 레벨)",
		["Nature Resistance (Rank 5)"] = "자연 마법 저항 (5 레벨)",
		["Poison Spit (Rank 1)"] = "독액 (1 레벨)",
		["Poison Spit (Rank 2)"] = "독액 (2 레벨)",
		["Poison Spit (Rank 3)"] = "독액 (3 레벨)",
		["Prowl (Rank 1)"] = "숨기 (1 레벨)",
		["Prowl (Rank 2)"] = "숨기 (2 레벨)",
		["Prowl (Rank 3)"] = "숨기 (3 레벨)",
		["Scorpid Poison (Rank 1)"] = "전갈독 (1 레벨)",
		["Scorpid Poison (Rank 2)"] = "전갈독 (2 레벨)",
		["Scorpid Poison (Rank 3)"] = "전갈독 (3 레벨)",
		["Scorpid Poison (Rank 4)"] = "전갈독 (4 레벨)",
		["Scorpid Poison (Rank 5)"] = "전갈독 (5 레벨)",
		["Screech (Rank 1)"] = "날카로운 울음소리 (1 레벨)",
		["Screech (Rank 2)"] = "날카로운 울음소리 (2 레벨)",
		["Screech (Rank 3)"] = "날카로운 울음소리 (3 레벨)",
		["Screech (Rank 4)"] = "날카로운 울음소리 (4 레벨)",
		["Screech (Rank 5)"] = "날카로운 울음소리 (5 레벨)",
		["Shadow Resistance (Rank 1)"] = "암흑 마법 저항 (1 레벨)",
		["Shadow Resistance (Rank 2)"] = "암흑 마법 저항 (2 레벨)",
		["Shadow Resistance (Rank 3)"] = "암흑 마법 저항 (3 레벨)",
		["Shadow Resistance (Rank 4)"] = "암흑 마법 저항 (4 레벨)",
		["Shadow Resistance (Rank 5)"] = "암흑 마법 저항 (5 레벨)",
		["Shell Shield (Rank 1)"] = "껍질 방패",
		["Thunderstomp (Rank 1)"] = "천둥 발구르기 (1 레벨)",
		["Thunderstomp (Rank 2)"] = "천둥 발구르기 (2 레벨)",
		["Thunderstomp (Rank 3)"] = "천둥 발구르기 (3 레벨)",
		["Warp (Rank 1)"] = "공간이동 (1 레벨)",

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "아다만타이트 흉갑",
		["Adamantite Cleaver"] = "아다만타이트 클레버",
		["Adamantite Dagger"] = "아다만타이트 단검",
		["Adamantite Maul"] = "아다만타이트 마울",
		["Adamantite Plate Bracers"] = "아다만타이트 판금 팔보호구",
		["Adamantite Plate Gloves"] = "아다만타이트 판금 장갑",
		["Adamantite Rapier"] = "아다만타이트 레이피어",
		["Adamantite Rod"] = "아다만타이트 마법막대",
		["Adamantite Sharpening Stone"] = "아다만타이트 숫돌",
		["Adamantite Weapon Chain"] = "아다만타이트 무기 사슬",
		["Adamantite Weightstone"] = "아다만타이트 무게추",
		["Annihilator"] = "파괴의 도끼",
		["Arcanite Champion"] = "용사의 아케이나이트검",
		["Arcanite Reaper"] = "아케이나이트 도끼",
		["Arcanite Rod"] = "아케이나이트 마법막대",
		["Arcanite Skeleton Key"] = "아케이나이트 해골 열쇠",
		["Barbaric Iron Boots"] = "야만전사의 철제 장화",
		["Barbaric Iron Breastplate"] = "야만전사의 철제 흉갑",
		["Barbaric Iron Gloves"] = "야만전사의 철제 장갑",
		["Barbaric Iron Helm"] = "야만전사의 철제 투구",
		["Barbaric Iron Shoulders"] = "야만전사의 철제 어깨보호구",
		["Belt of the Guardian"] = "수호병의 허리띠",
		["Big Black Mace"] = "검은 대형 철퇴",
		["Big Bronze Knife"] = "큰 청동 나이프",
		["Black Amnesty"] = "어둠의 사절",
		["Black Felsteel Bracers"] = "검은 지옥강철 팔보호구",
		["Black Grasp of the Destroyer"] = "파괴자의 검은 손아귀",
		["Black Planar Edge"] = "검은 차원의 도끼",
		["Blackfury"] = "검은분노",
		["Blackguard"] = "검은 수호자",
		["Blazefury"] = "타오르는 격노",
		["Blazeguard"] = "타오르는 수호검",
		["Blazing Rapier"] = "불타는 레이피어",
		["Blessed Bracers"] = "축복받은 팔보호구",
		["Blight"] = "황폐의 그림자",
		["Bloodmoon"] = "피의 달",
		["Bloodsoul Breastplate"] = "붉은영혼의 흉갑",
		["Bloodsoul Gauntlets"] = "붉은영혼의 건틀릿",
		["Bloodsoul Shoulders"] = "붉은영혼의 어깨보호구",
		["Blue Glittering Axe"] = "화려한 푸른 도끼",
		["Boots of the Protector"] = "파수병의 장화",
		["Bracers of the Green Fortress"] = "푸른 요새의 팔보호구",
		["Breastplate of Kings"] = "왕의 흉갑",
		["Bronze Axe"] = "청동 도끼",
		["Bronze Battle Axe"] = "청동 전투도끼",
		["Bronze Greatsword"] = "청동 대검",
		["Bronze Mace"] = "청동 철퇴",
		["Bronze Shortsword"] = "청동 쇼트소드",
		["Bronze Warhammer"] = "청동 전투해머",
		["Bulwark of Kings"] = "왕의 보루흉갑",
		["Bulwark of the Ancient Kings"] = "고대 왕의 보루흉갑",
		["Coarse Grinding Stone"] = "일반 연마석",
		["Coarse Sharpening Stone"] = "일반 숫돌",
		["Coarse Weightstone"] = "일반 무게추",
		["Copper Axe"] = "구리 도끼",
		["Copper Battle Axe"] = "구리 배틀액스",
		["Copper Bracers"] = "구리 팔보호구",
		["Copper Chain Belt"] = "구리 사슬 허리띠",
		["Copper Chain Boots"] = "구리 사슬 장화",
		["Copper Chain Pants"] = "구리 사슬 바지",
		["Copper Chain Vest"] = "구리 사슬 조끼",
		["Copper Claymore"] = "구리 클레이모어",
		["Copper Dagger"] = "구리 단검",
		["Copper Mace"] = "구리 철퇴",
		["Copper Shortsword"] = "구리 쇼트소드",
		["Corruption"] = "부패의 검",
		["Dark Iron Boots"] = "검은무쇠 장화",
		["Dark Iron Bracers"] = "검은무쇠 팔보호구",
		["Dark Iron Destroyer"] = "검은무쇠 파괴자",
		["Dark Iron Gauntlets"] = "검은무쇠 건틀릿",
		["Dark Iron Helm"] = "검은무쇠 투구",
		["Dark Iron Leggings"] = "검은무쇠 다리보호구",
		["Dark Iron Mail"] = "검은무쇠 사슬 갑옷",
		["Dark Iron Plate"] = "검은무쇠 판금 갑옷",
		["Dark Iron Pulverizer"] = "검은무쇠 분쇄기",
		["Dark Iron Reaver"] = "검은무쇠 학살자",
		["Dark Iron Shoulders"] = "검은무쇠 어깨보호구",
		["Dark Iron Sunderer"] = "검은무쇠 전투도끼",
		["Darkrune Breastplate"] = "암흑룬 흉갑",
		["Darkrune Gauntlets"] = "암흑룬 건틀릿",
		["Darkrune Helm"] = "암흑룬 투구",
		["Darksoul Breastplate"] = "검은영혼의 흉갑",
		["Darksoul Leggings"] = "검은영혼의 다리보호구",
		["Darksoul Shoulders"] = "검은영혼의 어깨보호구",
		["Dawnbringer Shoulders"] = "새벽지기의 어깨보호구",
		["Dawn's Edge"] = "여명의 도끼",
		["Dawnsteel Bracers"] = "여명의 강철 팔보호구",
		["Dawnsteel Shoulders"] = "여명의 강철 어깨보호구",
		["Dazzling Mithril Rapier"] = "눈부신 미스릴 레이피어",
		["Deadly Bronze Poniard"] = "예리한 청동 단검",
		["Deep Thunder"] = "천둥번개 망치",
		["Demon Forged Breastplate"] = "악마의 룬 흉갑",
		["Dense Grinding Stone"] = "강도 높은 연마석",
		["Dense Sharpening Stone"] = "강도 높은 숫돌",
		["Dense Weightstone"] = "강도 높은 무게추",
		["Dirge"] = "진혼곡",
		["Dragonmaw"] = "용아귀",
		["Dragonstrike"] = "용의 일격",
		["Drakefist Hammer"] = "비룡갈퀴 망치",
		["Earthforged Leggings"] = "대지로 벼려낸 다리보호구",
		["Earthpeace Breastplate"] = "평온한 대지의 흉갑",
		["Ebon Hand"] = "칠흑의 손",
		["Ebon Shiv"] = "흑단 비수",
		["Edge of Winter"] = "겨울날 도끼",
		["Elemental Sharpening Stone"] = "원소 숫돌",
		["Embrace of the Twisting Nether"] = "뒤틀린 황천의 선물",
		["Enchanted Adamantite Belt"] = "마력 깃든 아다만타이트 허리띠",
		["Enchanted Adamantite Boots"] = "마력 깃든 아다만타이트 장화",
		["Enchanted Adamantite Breastplate"] = "마력 깃든 아다만타이트 흉갑",
		["Enchanted Adamantite Leggings"] = "마력 깃든 아다만타이트 다리보호구",
		["Enchanted Battlehammer"] = "마력 깃든 전투망치",
		["Enchanted Thorium Blades"] = "마력 깃든 토륨 나이프",
		["Enchanted Thorium Breastplate"] = "마력 깃든 토륨 흉갑",
		["Enchanted Thorium Helm"] = "마력 깃든 토륨 투구",
		["Enchanted Thorium Leggings"] = "마력 깃든 토륨 다리보호구",
		["Eternium Rod"] = "이터늄 마법막대",
		["Eternium Runed Blade"] = "이터늄 룬검",
		["Fel Edged Battleaxe"] = "지옥날 전투도끼",
		["Fel Hardened Maul"] = "지옥 경화 마울",
		["Fel Iron Breastplate"] = "지옥무쇠 흉갑",
		["Fel Iron Chain Bracers"] = "지옥무쇠 사슬 팔보호구",
		["Fel Iron Chain Coif"] = "지옥무쇠 사슬 코이프",
		["Fel Iron Chain Gloves"] = "지옥무쇠 사슬 장갑",
		["Fel Iron Chain Tunic"] = "지옥무쇠 사슬 조끼",
		["Fel Iron Greatsword"] = "지옥무쇠 대검",
		["Fel Iron Hammer"] = "지옥무쇠 망치",
		["Fel Iron Hatchet"] = "지옥무쇠 도끼",
		["Fel Iron Plate Belt"] = "지옥무쇠 허리띠",
		["Fel Iron Plate Boots"] = "지옥무쇠 장화",
		["Fel Iron Plate Gloves"] = "지옥무쇠 장갑",
		["Fel Iron Plate Pants"] = "지옥무쇠 바지",
		["Fel Iron Rod"] = "지옥무쇠 마법막대",
		["Fel Sharpening Stone"] = "지옥의 숫돌",
		["Fel Weightstone"] = "지옥 무게추",
		["Felfury Gauntlets"] = "격노의 지옥 건틀릿",
		["Felsteel Gloves"] = "지옥강철 장갑",
		["Felsteel Helm"] = "지옥강철 투구",
		["Felsteel Leggings"] = "지옥강철 다리보호구",
		["Felsteel Longblade"] = "지옥강철 장검",
		["Felsteel Reaper"] = "지옥강철 도끼",
		["Felsteel Shield Spike"] = "지옥강철 방패 스파이크",
		["Felsteel Whisper Knives"] = "속삭이는 지옥강철 나이프",
		["Fiery Blaze Enchantment"] = "이글거리는 불꽃의 부적",
		["Fiery Chain Girdle"] = "불타는 사슬 벨트",
		["Fiery Chain Shoulders"] = "불타는 사슬 어깨보호구",
		["Fiery Plate Gauntlets"] = "불꽃의 판금 건틀릿",
		["Fireguard"] = "불꽃의 수호검",
		["Flamebane Bracers"] = "화염파멸 팔보호구",
		["Flamebane Breastplate"] = "화염파멸 흉갑",
		["Flamebane Gloves"] = "화염파멸 장갑",
		["Flamebane Helm"] = "화염파멸 투구",
		["Frost Tiger Blade"] = "빙호검",
		["Frostguard"] = "서리수호검",
		["Gauntlets of the Iron Tower"] = "철탑의 건틀릿",
		["Gemmed Copper Gauntlets"] = "보석박힌 구리 건틀릿",
		["Girdle of the Dawn"] = "여명의 벨트",
		["Glinting Steel Dagger"] = "반짝이는 강철 단검",
		["Gloves of the Dawn"] = "여명의 장갑",
		["Golden Iron Destroyer"] = "황금 철제 해머",
		["Golden Rod"] = "금마법막대",
		["Golden Scale Boots"] = "황금 미늘 장화",
		["Golden Scale Bracers"] = "황금 미늘 팔보호구",
		["Golden Scale Coif"] = "황금 미늘 코이프",
		["Golden Scale Cuirass"] = "황금 미늘 흉갑",
		["Golden Scale Gauntlets"] = "황금 미늘 건틀릿",
		["Golden Scale Leggings"] = "황금 미늘 다리보호구",
		["Golden Scale Shoulders"] = "황금 미늘 어깨보호구",
		["Golden Skeleton Key"] = "황금 해골 열쇠",
		["Great Earthforged Hammer"] = "대지로 벼려낸 거대한 망치",
		["Greater Rune of Warding"] = "상급 수호의 룬",
		["Greater Ward of Shielding"] = "상급 보호의 룬",
		["Green Iron Boots"] = "녹색 철제 장화",
		["Green Iron Bracers"] = "녹색 철제 팔보호구",
		["Green Iron Gauntlets"] = "녹색 철제 건틀릿",
		["Green Iron Hauberk"] = "녹색 철제 갑옷",
		["Green Iron Helm"] = "녹색 철제 투구",
		["Green Iron Leggings"] = "녹색 철제 다리보호구",
		["Green Iron Shoulders"] = "녹색 철제 어깨보호구",
		["Hard Khorium Battlefists"] = "단단한 코륨 전투판금 건틀릿",
		["Hard Khorium Battleplate"] = "단단한 코륨 전투판금 흉갑",
		["Hammer of Righteous Might"] = "정의로운 힘의 망치",
		["Hammer of the Titans"] = "티탄의 망치",
		["Hand of Eternity"] = "영원의 손길",
		["Hardened Iron Shortsword"] = "단단한 철제 쇼트소드",
		["Heartseeker"] = "심장적출 단검",
		["Heavy Bronze Mace"] = "무거운 청동 철퇴",
		["Heavy Copper Broadsword"] = "단단한 구리 브로드소드",
		["Heavy Copper Longsword"] = "단단한 구리 장검",
		["Heavy Copper Maul"] = "무거운 구리 마울",
		["Heavy Earthforged Breastplate"] = "대지로 벼려낸 강화 흉갑",
		["Heavy Grinding Stone"] = "단단한 연마석",
		["Heavy Mithril Axe"] = "견고한 미스릴 도끼",
		["Heavy Mithril Boots"] = "견고한 미스릴 장화",
		["Heavy Mithril Breastplate"] = "견고한 미스릴 흉갑",
		["Heavy Mithril Gauntlet"] = "견고한 미스릴 건틀릿",
		["Heavy Mithril Helm"] = "견고한 미스릴 투구",
		["Heavy Mithril Pants"] = "견고한 미스릴 바지",
		["Heavy Mithril Shoulder"] = "견고한 미스릴 어깨보호구",
		["Heavy Obsidian Belt"] = "견고한 흑요석 허리띠",
		["Heavy Sharpening Stone"] = "단단한 숫돌",
		["Heavy Timbermaw Belt"] = "튼튼한 나무구렁 허리띠",
		["Heavy Timbermaw Boots"] = "튼튼한 나무구렁 장화",
		["Heavy Weightstone"] = "무거운 무게추",
		["Helm of the Great Chief"] = "대족장의 투구",
		["Helm of the Stalwart Defender"] = "강인한 수호자의 투구",
		["Huge Thorium Battleaxe"] = "거대한 토륨 전투도끼",
		["Icebane Bracers"] = "얼음막이 팔보호구",
		["Icebane Breastplate"] = "얼음막이 흉갑",
		["Icebane Gauntlets"] = "얼음막이 건틀릿",
		["Iceguard Breastplate"] = "얼음수호 흉갑",
		["Iceguard Helm"] = "얼음수호 투구",
		["Iceguard Leggings"] = "얼음수호 다리보호구",
		["Imperial Plate Belt"] = "황제의 판금 허리띠",
		["Imperial Plate Boots"] = "황제의 판금 장화",
		["Imperial Plate Bracers"] = "황제의 판금 팔보호구",
		["Imperial Plate Chest"] = "황제의 판금 흉갑",
		["Imperial Plate Helm"] = "황제의 판금 투구",
		["Imperial Plate Leggings"] = "황제의 판금 다리보호구",
		["Imperial Plate Shoulders"] = "황제의 판금 어깨보호구",
		["Inlaid Mithril Cylinder"] = "세공된 미스릴 실린더",
		["Invulnerable Mail"] = "무적의 사슬갑옷",
		["Iridescent Hammer"] = "오색 망치",
		["Iron Buckle"] = "철제 죔쇠",
		["Iron Counterweight"] = "철제 평형추",
		["Iron Shield Spike"] = "철제 방패 스파이크",
		["Ironforge Breastplate"] = "아이언포지 흉갑",
		["Ironvine Belt"] = "무쇠덩굴 허리띠",
		["Ironvine Breastplate"] = "무쇠덩굴 흉갑",
		["Ironvine Gloves"] = "무쇠덩굴 장갑",
		["Jade Serpentblade"] = "비취 비늘검",
		["Jagged Obsidian Shield"] = "뾰족한 흑요석 방패",
		["Khorium Belt"] = "코륨 허리띠",
		["Khorium Boots"] = "코륨 장화",
		["Khorium Champion"] = "용사의 코륨검",
		["Khorium Pants"] = "코륨 바지",
		["Lavaforged Warhammer"] = "용암으로 벼려낸 전투망치",
		["Lesser Rune of Warding"] = "하급 수호의 룬",
		["Lesser Ward of Shielding"] = "하급 수호의 보호막",
		["Light Earthforged Blade"] = "대지로 벼려낸 검",
		["Light Emberforged Hammer"] = "불꽃으로 벼려낸 망치",
		["Light Obsidian Belt"] = "가벼운 흑요석 허리띠",
		["Light Skyforged Axe"] = "하늘로 벼려낸 도끼",
		["Lionheart Blade"] = "사자심장 검",
		["Lionheart Champion"] = "용사의 사자심장 검",
		["Lionheart Executioner"] = "집행의 사자심장 검",
		["Lionheart Helm"] = "사자심장 투구",
		["Lunar Crescent"] = "초승달 도끼",
		["Massive Iron Axe"] = "큰 철제 도끼",
		["Masterwork Stormhammer"] = "명인의 폭풍망치",
		["Mighty Iron Hammer"] = "거대한 철제 해머",
		["Mithril Coif"] = "미스릴 코이프",
		["Mithril Scale Bracers"] = "미스릴 미늘 팔보호구",
		["Mithril Scale Gloves"] = "미스릴 미늘 장갑",
		["Mithril Scale Pants"] = "미스릴 미늘 바지",
		["Mithril Scale Shoulders"] = "미스릴 미늘 어깨보호구",
		["Mithril Shield Spike"] = "미스릴 방패 스파이크",
		["Mithril Spurs"] = "미스릴 박차",
		["Mooncleaver"] = "달빛 클레버",
		["Moonsteel Broadsword"] = "달의 강철 브로드소드",
		["Nether Chain Shirt"] = "황천의 사슬 조끼",
		["Nightfall"] = "일몰",
		["Oathkeeper's Helm"] = "굳은 신념의 투구",
		["Obsidian Mail Tunic"] = "흑요석 사슬 튜닉",
		["Orcish War Leggings"] = "오크족 전투 다리보호구",
		["Ornate Mithril Boots"] = "화려한 미스릴 장화",
		["Ornate Mithril Breastplate"] = "화려한 미스릴 흉갑",
		["Ornate Mithril Gloves"] = "화려한 미스릴 장갑",
		["Ornate Mithril Helm"] = "화려한 미스릴 투구",
		["Ornate Mithril Pants"] = "화려한 미스릴 바지",
		["Ornate Mithril Shoulder"] = "화려한 미스릴 어깨보호구",
		["Ornate Thorium Handaxe"] = "화려한 토륨 손도끼",
		["Patterned Bronze Bracers"] = "청동 무늬 팔보호구",
		["Pearl-handled Dagger"] = "진주장식 단검",
		["Persuader"] = "강권의 망치",
		["Phantom Blade"] = "환영검",
		["Polished Steel Boots"] = "빛나는 강철 장화",
		["Radiant Belt"] = "찬란하게 빛나는 허리띠",
		["Radiant Boots"] = "찬란하게 빛나는 장화",
		["Radiant Breastplate"] = "찬란하게 빛나는 흉갑",
		["Radiant Circlet"] = "찬란하게 빛나는 머리장식",
		["Radiant Gloves"] = "찬란하게 빛나는 장갑",
		["Radiant Leggings"] = "찬란하게 빛나는 다리보호구",
		["Ragesteel Breastplate"] = "분노의 강철 흉갑",
		["Ragesteel Gloves"] = "분노의 강철 장갑",
		["Ragesteel Helm"] = "분노의 강철 투구",
		["Ragesteel Shoulders"] = "분노의 강철 어깨보호구",
		["Red Belt of Battle"] = "전투의 붉은 허리띠",
		["Red Havoc Boots"] = "붉은 파괴의 장화",
		["Rough Bronze Boots"] = "청동 장화",
		["Rough Bronze Bracers"] = "청동 팔보호구",
		["Rough Bronze Cuirass"] = "청동 흉갑",
		["Rough Bronze Leggings"] = "청동 다리보호구",
		["Rough Bronze Shoulders"] = "청동 어깨보호구",
		["Rough Copper Vest"] = "조잡한 구리 조끼",
		["Rough Grinding Stone"] = "조잡한 연마석",
		["Rough Sharpening Stone"] = "조잡한 숫돌",
		["Rough Weightstone"] = "가벼운 무게추",
		["Runed Copper Belt"] = "구리 룬문자 허리띠",
		["Runed Copper Bracers"] = "구리 룬문자 팔보호구",
		["Runed Copper Breastplate"] = "구리 룬문자 흉갑",
		["Runed Copper Gauntlets"] = "구리 룬문자 건틀릿",
		["Runed Copper Pants"] = "구리 룬문자 바지",
		["Runed Mithril Hammer"] = "룬문자 미스릴 해머",
		["Runic Breastplate"] = "룬문자 흉갑",
		["Runic Hammer"] = "룬문자 망치",
		["Runic Plate Boots"] = "룬문자 판금 장화",
		["Runic Plate Helm"] = "룬문자 판금 투구",
		["Runic Plate Leggings"] = "룬문자 판금 다리보호구",
		["Runic Plate Shoulders"] = "룬문자 판금 어깨보호구",
		["Sageblade"] = "현자의 검",
		["Searing Golden Blade"] = "이글거리는 황금 단도",
		["Serenity"] = "평온의 곤봉",
		["Shadesteel Bracers"] = "어둠강철 팔보호구",
		["Shadesteel Girdle"] = "어둠강철 벨트",
		["Shadesteel Greaves"] = "어둠강철 경갑",
		["Shadesteel Sabots"] = "어둠강철 장화",
		["Shadow Crescent Axe"] = "암흑 초승달 도끼",
		["Shining Silver Breastplate"] = "빛나는 은미늘 흉갑",
		["Silver Rod"] = "은마법막대",
		["Silver Skeleton Key"] = "은 해골 열쇠",
		["Silvered Bronze Boots"] = "은도금한 청동 장화",
		["Silvered Bronze Breastplate"] = "은도금한 청동 흉갑",
		["Silvered Bronze Gauntlets"] = "은도금한 청동 건틀릿",
		["Silvered Bronze Leggings"] = "은도금한 청동 다리보호구",
		["Silvered Bronze Shoulders"] = "은도금한 청동 어깨보호구",
		["Skyforged Great Axe"] = "하늘로 벼려낸 거대한 도끼",
		["Solid Grinding Stone"] = "견고한 연마석",
		["Solid Iron Maul"] = "튼튼한 철제 마울",
		["Solid Sharpening Stone"] = "견고한 숫돌",
		["Solid Weightstone"] = "견고한 무게추",
		["Steel Breastplate"] = "강철 흉갑",
		["Steel Plate Helm"] = "강철 판금 투구",
		["Steel Weapon Chain"] = "강철 무기 사슬",
		["Steelgrip Gauntlets"] = "강철죔쇠 건틀릿",
		["Stoneforged Claymore"] = "돌로 벼려낸 클레이모어",
		["Storm Gauntlets"] = "폭풍 건틀릿",
		["Storm Helm"] = "폭풍 투구",
		["Stormforged Axe"] = "폭풍으로 벼려낸 도끼",
		["Stormforged Hauberk"] = "폭풍으로 벼려낸 다리보호구",
		["Stormherald"] = "폭풍의 전령",
		["Stronghold Gauntlets"] = "아성의 건틀릿",
		["Sunblessed Breastplate"] = "태양의 축복 흉갑",
		["Sunblessed Gauntlets"] = "태양의 축복 건틀릿",
		["Sulfuron Hammer"] = "설퍼론 망치",
		["Swiftsteel Bracers"] = "신속의 강철 팔보호구",
		["Swiftsteel Gloves"] = "신속의 강철 장갑",
		["Swiftsteel Shoulders"] = "신속의 강철 어깨보호구",
		["The Planar Edge"] = "차원의 도끼",
		["The Shatterer"] = "산산조각 망치",
		["Thick Bronze Darts"] = "두꺼운 청동 창",
		["Thick Obsidian Breastplate"] = "견고한 흑요석 흉갑",
		["Thick War Axe"] = "두꺼운날 워액스",
		["Thorium Armor"] = "토륨 갑옷",
		["Thorium Belt"] = "토륨 허리띠",
		["Thorium Boots"] = "토륨 장화",
		["Thorium Bracers"] = "토륨 팔보호구",
		["Thorium Helm"] = "토륨 투구",
		["Thorium Leggings"] = "토륨 다리보호구",
		["Thorium Shield Spike"] = "토륨 방패 스파이크",
		["Thunder"] = "천둥 망치",
		["Titanic Leggings"] = "티탄의 다리보호구",
		["Truesilver Breastplate"] = "진은 흉갑",
		["Truesilver Champion"] = "용사의 진은검",
		["Truesilver Gauntlets"] = "진은 건틀릿",
		["Truesilver Rod"] = "진은마법막대",
		["Truesilver Skeleton Key"] = "진은 해골 열쇠",
		["Twisting Nether Chain Shirt"] = "뒤틀린 황천의 사슬 조끼",
		["Volcanic Hammer"] = "화산 망치",
		["Whirling Steel Axes"] = "소용돌이치는 강철 도끼",
		["Whitesoul Helm"] = "순백의 투구",
		["Wicked Edge of the Planes"] = "사악한 차원의 도끼",
		["Wicked Mithril Blade"] = "날카로운 미스릴 검",
		["Wildguard Breastplate"] = "야생수호 흉갑",
		["Wildguard Helm"] = "야생수호 투구",
		["Wildguard Leggings"] = "야생수호 다리보호구",
		["Wildthorn Mail"] = "찔레가시 사슬갑옷",
		["Windforged Leggings"] = "바람으로 벼려낸 다리보호구",
		["Windforged Rapier"] = "바람으로 벼려낸 레이피어",

-- Cooking Recipes
		["Baked Salmon"] = "훈제 연어",
		["Barbecued Buzzard Wing"] = "대머리수리 날개 구이",
		["Bat Bites"] = "박쥐 꼬치",
		["Beer Basted Boar Ribs"] = "맥주로 양념한 멧돼지 갈비",
		["Big Bear Steak"] = "큰 곰 스테이크",
		["Blackened Basilisk"] = "바실리스크 장작구이",
		["Blackened Sporefish"] = "포자물고기 장작구이",
		["Blackened Trout"] = "송어 장작구이",
		["Blood Sausage"] = "선지 소시지",
		["Boiled Clams"] = "삶은 조개",
		["Brilliant Smallfish"] = "비단잉어 구이",
		["Bristle Whisker Catfish"] = "표범메기 구이",
		["Broiled Bloodfin"] = "피지느러미 구이",
		["Buzzard Bites"] = "독수리 꼬치",
		["Carrion Surprise"] = "고기말이 별미",
		["Charred Bear Kabobs"] = "곰 케밥 숯불구이",
		["Charred Wolf Meat"] = "늑대 숯불구이",
		["Clam Bar"] = "조개맛살",
		["Clam Chowder"] = "조개 수프",
		["Cooked Crab Claw"] = "집게발 요리",
		["Cooked Glossy Mightfish"] = "빛깔좋은 망둥어 요리",
		["Coyote Steak"] = "코요테 스테이크",
		["Crab Cake"] = "게살 케이크",
		["Crispy Bat Wing"] = "바삭바삭한 박쥐 날개",
		["Crispy Lizard Tail"] = "바삭바삭한 도마뱀 꼬리",
		["Crocolisk Gumbo"] = "악어 검보 스튜",
		["Crocolisk Steak"] = "악어 스테이크",
		["Crunchy Serpent"] = "바삭바삭 천둥매 튀김",
		["Crunchy Spider Surprise"] = "바삭바삭한 거미 튀김",
		["Curiously Tasty Omelet"] = "진기한 맛의 오믈렛",
		["Delicious Chocolate Cake"] = "맛좋은 초콜릿 케이크",
		["Dig Rat Stew"] = "들쥐 스튜",
		["Dirge's Kickin' Chimaerok Chops"] = "더지의 기똥찬 키메로크 찹스테이크",
		["Dragonbreath Chili"] = "용숨결 칠리",
		["Dry Pork Ribs"] = "말린 돼지 갈비",
		["Egg Nog"] = "에그노그",
		["Feltail Delight"] = "지옥꼬리퉁돔 별미",
		["Filet of Redgill"] = "붉은퉁돔 통구이",
		["Fillet of Frenzy"] = "프렌지살 요리",
		["Fisherman's Feast"] = "낚시꾼의 별미",
		["Giant Clam Scorcho"] = "대합 구이",
		["Gingerbread Cookie"] = "생강 과자빵",
		["Goblin Deviled Clams"] = "고블린식 매운 조개 요리",
		["Golden Fish Sticks"] = "황금 어묵",
		["Goldthorn Tea"] = "황금가시 차",
		["Gooey Spider Cake"] = "쫄깃쫄깃한 거미 케이크",
		["Goretusk Liver Pie"] = "뿔엄니멧돼지 간 파이",
		["Grilled Mudfish"] = "미꾸라지 구이",
		["Grilled Squid"] = "오징어 구이",
		["Heavy Crocolisk Stew"] = "푸짐한 악어 스튜",
		["Heavy Kodo Stew"] = "코도 고기 스튜",
		["Herb Baked Egg"] = "알 약초구이",
		["Hot Apple Cider"] = "따뜻한 사과맛 탄산수",
		["Hot Buttered Trout"] = "송어 버터 구이",
		["Hot Lion Chops"] = "매운 사자 고기",
		["Hot Smoked Bass"] = "농어 훈제",
		["Hot Wolf Ribs"] = "늑대 양념 갈비",
		["Juicy Bear Burger"] = "즙이 많은 곰 버거",
		["Jungle Stew"] = "밀림 스튜",
		["Kaldorei Spider Kabob"] = "나이트 엘프 거미 케밥",
		["Kibler's Bits"] = "키블러의 간식",
		["Lean Venison"] = "사슴 살코기 구이",
		["Lean Wolf Steak"] = "늑대 살코기 스테이크",
		["Lobster Stew"] = "바닷가재 스튜",
		["Loch Frenzy Delight"] = "호수프렌지 별미",
		["Longjaw Mud Snapper"] = "긴주둥이진흙퉁돔 구이",
		["Lynx Steak"] = "스라소니 스테이크",
		["Mightfish Steak"] = "망둥어 스테이크",
		["Mithril Headed Trout"] = "미스릴송어 구이",
		["Mok'Nathal Shortribs"] = "모크나탈 갈비",
		["Monster Omelet"] = "괴물 오믈렛",
		["Murloc Fin Soup"] = "멀록 지느러미 수프",
		["Mystery Stew"] = "신비의 스튜",
		["Nightfin Soup"] = "밤비늘퉁돔 수프",
		["Poached Bluefish"] = "삶은 게르치",
		["Poached Sunscale Salmon"] = "삶은 해비늘연어",
		["Rainbow Fin Albacore"] = "무지개날개다랑어 구이",
		["Ravager Dog"] = "칼날발톱 핫도그",
		["Redridge Goulash"] = "붉은마루산 굴라시 스튜",
		["Roast Raptor"] = "랩터 숯불구이",
		["Roasted Boar Meat"] = "멧돼지 숯불구이",
		["Roasted Clefthoof"] = "갈래발굽 숯불구이",
		["Roasted Kodo Meat"] = "코도 숯불구이",
		["Roasted Moongraze Tenderloin"] = "달새김 안심 스테이크",
		["Rockscale Cod"] = "돌비늘대구 구이",
		["Runn Tum Tuber Surprise"] = "룬툼 줄기 별미",
		["Sagefish Delight"] = "총명어 별미",
		["Savory Deviate Delight"] = "돌연변이 물고기 별미",
		["Scorpid Surprise"] = "전갈 별미",
		["Seasoned Wolf Kabob"] = "양념 늑대 케밥",
		["Skullfish Soup"] = "해골물고기 수프",
		["Slitherskin Mackerel"] = "줄무늬고등어 구이",
		["Smoked Bear Meat"] = "곰고기 숯불구이",
		["Smoked Desert Dumplings"] = "훈제 사막 경단",
		["Smoked Sagefish"] = "훈제 총명어",
		["Soothing Turtle Bisque"] = "독특한 거북이 비스크",
		["Spice Bread"] = "매콤한 빵",
		["Spiced Chili Crab"] = "매콤한 칠리 게요리",
		["Spiced Wolf Meat"] = "늑대 양념 구이",
		["Spicy Crawdad"] = "매운 가재",
		["Spicy Hot Talbuk"] = "매콤한 양념 탈부크 구이",
		["Spider Sausage"] = "거미 소시지",
		["Sporeling Snack"] = "스포어링 과자",
		["Spotted Yellowtail"] = "점박이놀래기 구이",
		["Stewed Trout"] = "송어 매운탕",
		["Stormchops"] = "번개구이",
		["Strider Stew"] = "타조 스튜",
		["Succulent Pork Ribs"] = "육즙이 많은 돼지 갈비",
		["Talbuk Steak"] = "탈부크 스테이크",
		["Tasty Lion Steak"] = "맛있는 사자 스테이크",
		["Tender Wolf Steak"] = "연한 늑대 스테이크",
		["Thistle Tea"] = "엉겅퀴 차",
		["Undermine Clam Chowder"] = "언더마인 조개 수프",
		["Warp Burger"] = "차원의 버거",
		["Westfall Stew"] = "서부정통 스튜",

-- Enchanting Recipes
		["Brilliant Mana Oil"] = "반짝이는 마나 오일",
		["Brilliant Wizard Oil"] = "반짝이는 마술사 오일",
		["Enchant 2H Weapon - Agility"] = "양손 무기 마법부여 - 민첩성",
		["Enchant 2H Weapon - Greater Impact"] = "양손 무기 마법부여 - 상급 충격",
		["Enchant 2H Weapon - Impact"] = "양손 무기 마법부여 - 충격",
		["Enchant 2H Weapon - Lesser Impact"] = "양손 무기 마법부여 - 하급 충격",
		["Enchant 2H Weapon - Lesser Intellect"] = "양손 무기 마법부여 - 하급 지능",
		["Enchant 2H Weapon - Lesser Spirit"] = "양손 무기 마법부여 - 하급 정신력",
		["Enchant 2H Weapon - Major Agility"] = "양손 무기 마법부여 - 일급 민첩성",
		["Enchant 2H Weapon - Major Intellect"] = "양손 무기 마법부여 - 일급 지능",
		["Enchant 2H Weapon - Major Spirit"] = "양손 무기 마법부여 - 일급 정신력",
		["Enchant 2H Weapon - Minor Impact"] = "양손 무기 마법부여 - 최하급 충격",
		["Enchant 2H Weapon - Savagery"] = "양손 무기 마법부여 - 전투력",
		["Enchant 2H Weapon - Superior Impact"] = "양손 무기 마법부여 - 최상급 충격",
		["Enchant Boots - Agility"] = "장화 마법부여 - 민첩성",
		["Enchant Boots - Boar's Speed"] = "장화 마법부여 - 멧돼지의 속도",
		["Enchant Boots - Cat's Swiftness"] = "장화 마법부여 - 살쾡이의 날렵함",
		["Enchant Boots - Dexterity"] = "장화 마법부여 - 기민함",
		["Enchant Boots - Fortitude"] = "장화 마법부여 - 인내",
		["Enchant Boots - Greater Agility"] = "장화 마법부여 - 상급 민첩",
		["Enchant Boots - Greater Stamina"] = "장화 마법부여 - 상급 체력",
		["Enchant Boots - Lesser Agility"] = "장화 마법부여 - 하급 민첩성",
		["Enchant Boots - Lesser Spirit"] = "장화 마법부여 - 하급 정신력",
		["Enchant Boots - Lesser Stamina"] = "장화 마법부여 - 하급 체력",
		["Enchant Boots - Minor Agility"] = "장화 마법부여 - 최하급 민첩성",
		["Enchant Boots - Minor Speed"] = "장화 마법부여 - 최하급 속도",
		["Enchant Boots - Minor Stamina"] = "장화 마법부여 - 최하급 체력",
		["Enchant Boots - Spirit"] = "장화 마법부여 - 정신력",
		["Enchant Boots - Stamina"] = "장화 마법부여 - 체력",
		["Enchant Boots - Surefooted"] = "장화 마법부여 - 침착함",
		["Enchant Boots - Vitality"] = "장화 마법부여 - 활력",
		["Enchant Bracer - Assault"] = "손목보호구 마법부여 - 맹공",
		["Enchant Bracer - Brawn"] = "손목보호구 마법부여 - 완력",
		["Enchant Bracer - Deflection"] = "손목보호구 마법부여 - 회피",
		["Enchant Bracer - Fortitude"] = "손목보호구 마법부여 - 인내",
		["Enchant Bracer - Greater Intellect"] = "손목보호구 마법부여 - 상급 지능",
		["Enchant Bracer - Greater Spirit"] = "손목보호구 마법부여 - 상급 정신력",
		["Enchant Bracer - Greater Stamina"] = "손목보호구 마법부여 - 상급 체력",
		["Enchant Bracer - Greater Strength"] = "손목보호구 마법부여 - 상급 힘",
		["Enchant Bracer - Healing Power"] = "손목보호구 마법부여 - 치유 강화",
		["Enchant Bracer - Intellect"] = "손목보호구 마법부여 - 지능",
		["Enchant Bracer - Lesser Deflection"] = "손목보호구 마법부여 - 하급 회피",
		["Enchant Bracer - Lesser Intellect"] = "손목보호구 마법부여 - 하급 지능",
		["Enchant Bracer - Lesser Spirit"] = "손목보호구 마법부여 - 하급 정신력",
		["Enchant Bracer - Lesser Stamina"] = "손목보호구 마법부여 - 하급 체력",
		["Enchant Bracer - Lesser Strength"] = "손목보호구 마법부여 - 하급 힘",
		["Enchant Bracer - Major Defense"] = "손목보호구 마법부여 - 상급 방어 숙련",
		["Enchant Bracer - Major Intellect"] = "손목보호구 마법부여 - 일급 지능",
		["Enchant Bracer - Mana Regeneration"] = "손목보호구 마법부여 - 마나 재생",
		["Enchant Bracer - Minor Agility"] = "손목보호구 마법부여 - 최하급 민첩성",
		["Enchant Bracer - Minor Deflection"] = "손목보호구 마법부여 - 최하급 회피",
		["Enchant Bracer - Minor Health"] = "손목보호구 마법부여 - 최하급 생명력",
		["Enchant Bracer - Minor Spirit"] = "손목보호구 마법부여 - 최하급 정신력",
		["Enchant Bracer - Minor Stamina"] = "손목보호구 마법부여 - 최하급 체력",
		["Enchant Bracer - Minor Strength"] = "손목보호구 마법부여 - 최하급 힘",
		["Enchant Bracer - Restore Mana Prime"] = "손목보호구 마법부여 - 상급 마나 회복",
		["Enchant Bracer - Spellpower"] = "손목보호구 마법부여 - 주문 강화",
		["Enchant Bracer - Spirit"] = "손목보호구 마법부여 - 정신력",
		["Enchant Bracer - Stamina"] = "손목보호구 마법부여 - 체력",
		["Enchant Bracer - Stats"] = "손목보호구 마법부여 - 능력치",
		["Enchant Bracer - Strength"] = "손목보호구 마법부여 - 힘",
		["Enchant Bracer - Superior Healing"] = "손목보호구 마법부여 - 상급 치유 마법 강화",
		["Enchant Bracer - Superior Spirit"] = "손목보호구 마법부여 - 최상급 정신력",
		["Enchant Bracer - Superior Stamina"] = "손목보호구 마법부여 - 최상급 체력",
		["Enchant Bracer - Superior Strength"] = "손목보호구 마법부여 - 최상급 힘",
		["Enchant Chest - Defense"] = "가슴보호구 마법부여 - 방어 숙련",
		["Enchant Chest - Exceptional Health"] = "가슴보호구 마법부여 - 특급 생명력",
		["Enchant Chest - Exceptional Stats"] = "가슴보호구 마법부여 - 특급 능력치",
		["Enchant Chest - Greater Health"] = "가슴보호구 마법부여 - 상급 생명력",
		["Enchant Chest - Greater Mana"] = "가슴보호구 마법부여 - 상급 마나",
		["Enchant Chest - Greater Stats"] = "가슴보호구 마법부여 - 상급 능력치",
		["Enchant Chest - Health"] = "가슴보호구 마법부여 - 생명력",
		["Enchant Chest - Lesser Absorption"] = "가슴보호구 마법부여 - 하급 흡수",
		["Enchant Chest - Lesser Health"] = "가슴보호구 마법부여 - 하급 생명력",
		["Enchant Chest - Lesser Mana"] = "가슴보호구 마법부여 - 하급 마나",
		["Enchant Chest - Lesser Stats"] = "가슴보호구 마법부여 - 하급 능력치",
		["Enchant Chest - Major Health"] = "가슴보호구 마법부여 - 일급 생명력",
		["Enchant Chest - Major Mana"] = "가슴보호구 마법부여 - 일급 마나",
		["Enchant Chest - Major Resilience"] = "가슴보호구 마법부여 - 일급 탄력성",
		["Enchant Chest - Major Spirit"] = "가슴보호구 마법부여 - 일급 정신력",
		["Enchant Chest - Mana"] = "가슴보호구 마법부여 - 마나",
		["Enchant Chest - Minor Absorption"] = "가슴보호구 마법부여 - 최하급 흡수",
		["Enchant Chest - Minor Health"] = "가슴보호구 마법부여 - 최하급 생명력",
		["Enchant Chest - Minor Mana"] = "가슴보호구 마법부여 - 최하급 마나",
		["Enchant Chest - Minor Stats"] = "가슴보호구 마법부여 - 최하급 능력치",
		["Enchant Chest - Restore Mana Prime"] = "가슴보호구 마법부여 - 상급 마나 회복",
		["Enchant Chest - Stats"] = "가슴보호구 마법부여 - 능력치",
		["Enchant Chest - Superior Health"] = "가슴보호구 마법부여 - 최상급 생명력",
		["Enchant Chest - Superior Mana"] = "가슴보호구 마법부여 - 최상급 마나",
		["Enchant Cloak - Defense"] = "망토 마법부여 - 보호",
		["Enchant Cloak - Dodge"] = "망토 마법부여 - 회피",
		["Enchant Cloak - Fire Resistance"] = "망토 마법부여 - 화염 저항력",
		["Enchant Cloak - Greater Agility"] = "망토 마법부여 - 상급 민첩성",
		["Enchant Cloak - Greater Arcane Resistance"] = "망토 마법부여 - 상급 비전 저항력",
		["Enchant Cloak - Greater Defense"] = "망토 마법부여 - 상급 보호",
		["Enchant Cloak - Greater Fire Resistance"] = "망토 마법부여 - 상급 화염 저항력",
		["Enchant Cloak - Greater Nature Resistance"] = "망토 마법부여 - 상급 자연 저항력",
		["Enchant Cloak - Greater Resistance"] = "망토 마법부여 - 상급 저항",
		["Enchant Cloak - Greater Shadow Resistance"] = "망토 마법부여 - 상급 암흑 저항력",
		["Enchant Cloak - Lesser Agility"] = "망토 마법부여 - 하급 민첩성",
		["Enchant Cloak - Lesser Fire Resistance"] = "망토 마법부여 - 하급 화염 저항력",
		["Enchant Cloak - Lesser Protection"] = "망토 마법부여 - 하급 보호",
		["Enchant Cloak - Lesser Shadow Resistance"] = "망토 마법부여 - 하급 암흑 저항력",
		["Enchant Cloak - Major Armor"] = "망토 마법부여 - 일급 방어도",
		["Enchant Cloak - Major Resistance"] = "망토 마법부여 - 상급 저항력",
		["Enchant Cloak - Minor Agility"] = "망토 마법부여 - 최하급 민첩성",
		["Enchant Cloak - Minor Protection"] = "망토 마법부여 - 최하급 보호",
		["Enchant Cloak - Minor Resistance"] = "망토 마법부여 - 최하급 저항력",
		["Enchant Cloak - Resistance"] = "망토 마법부여 - 저항력",
		["Enchant Cloak - Spell Penetration"] = "망토 마법부여 - 주문 관통력",
		["Enchant Cloak - Stealth"] = "망토 마법부여 - 은신",
		["Enchant Cloak - Subtlety"] = "망토 마법부여 - 미묘함",
		["Enchant Cloak - Superior Defense"] = "망토 마법부여 - 최상급 보호",
		["Enchant Gloves - Advanced Herbalism"] = "장갑 마법부여 - 약초 채집 숙련",
		["Enchant Gloves - Advanced Mining"] = "장갑 마법부여 - 채광 숙련",
		["Enchant Gloves - Agility"] = "장갑 마법부여 - 민첩성",
		["Enchant Gloves - Assault"] = "장갑 마법부여 - 맹공",
		["Enchant Gloves - Blasting"] = "장갑 마법부여 - 폭파",
		["Enchant Gloves - Fire Power"] = "장갑 마법부여 - 화염 마법 강화",
		["Enchant Gloves - Fishing"] = "장갑 마법부여 - 낚시",
		["Enchant Gloves - Frost Power"] = "장갑 마법부여 - 냉기 마법 강화",
		["Enchant Gloves - Greater Agility"] = "장갑 마법부여 - 상급 민첩",
		["Enchant Gloves - Greater Strength"] = "장갑 마법부여 - 상급 힘",
		["Enchant Gloves - Healing Power"] = "장갑 마법부여 - 치유 마법 강화",
		["Enchant Gloves - Herbalism"] = "장갑 마법부여 - 약초 채집",
		["Enchant Gloves - Major Healing"] = "장갑 마법부여 - 일급 치유 마법 강화",
		["Enchant Gloves - Major Spellpower"] = "장갑 마법부여 - 일급 주문 강화",
		["Enchant Gloves - Major Strength"] = "장갑 마법부여 - 일급 힘",
		["Enchant Gloves - Mining"] = "장갑 마법부여 - 채광",
		["Enchant Gloves - Minor Haste"] = "장갑 마법부여 - 최하급 신속",
		["Enchant Gloves - Riding Skill"] = "장갑 마법부여 - 숙련된 조련술",
		["Enchant Gloves - Shadow Power"] = "장갑 마법부여 - 암흑 마법 강화",
		["Enchant Gloves - Skinning"] = "장갑 마법부여 - 무두질",
		["Enchant Gloves - Spell Strike"] = "장갑 마법부여 - 주문 적중",
		["Enchant Gloves - Strength"] = "장갑 마법부여 - 힘",
		["Enchant Gloves - Superior Agility"] = "장갑 마법부여 - 최상급 민첩",
		["Enchant Gloves - Threat"] = "장갑 마법부여 - 위협",
		["Enchant Ring - Healing Power"] = "반지 마법부여 - 치유 마법 강화",
		["Enchant Ring - Spellpower"] = "반지 마법부여 - 주문 강화",
		["Enchant Ring - Stats"] = "반지 마법부여 - 능력치",
		["Enchant Ring - Striking"] = "반지 마법부여 - 공격력",
		["Enchant Shield - Frost Resistance"] = "방패 마법부여 - 냉기 저항",
		["Enchant Shield - Greater Spirit"] = "방패 마법부여 - 상급 정신력",
		["Enchant Shield - Greater Stamina"] = "방패 마법부여 - 상급 체력",
		["Enchant Shield - Intellect"] = "방패 마법부여 - 지능",
		["Enchant Shield - Lesser Block"] = "방패 마법부여 - 하급 방어",
		["Enchant Shield - Lesser Protection"] = "방패 마법부여 - 하급 보호",
		["Enchant Shield - Lesser Spirit"] = "방패 마법부여 - 하급 정신력",
		["Enchant Shield - Lesser Stamina"] = "방패 마법부여 - 하급 체력",
		["Enchant Shield - Major Stamina"] = "방패 마법부여 - 일급 체력",
		["Enchant Shield - Minor Stamina"] = "방패 마법부여 - 최하급 체력",
		["Enchant Shield - Resistance"] = "방패 마법부여 - 저항력",
		["Enchant Shield - Shield Block"] = "방패 마법부여 - 방패 막기 향상",
		["Enchant Shield - Spirit"] = "방패 마법부여 - 정신력",
		["Enchant Shield - Stamina"] = "방패 마법부여 - 체력",
		["Enchant Shield - Superior Spirit"] = "방패 마법부여 - 최상급 정신력",
		["Enchant Shield - Resilience"] = "방패 마법부여 - 탄력",
		["Enchant Shield - Tough Shield"] = "방패 마법부여 - 견고한 방패",
		["Enchant Weapon - Agility"] = "무기 마법부여 - 민첩성",
		["Enchant Weapon - Battlemaster"] = "무기 마법부여 - 전투의 대가",
		["Enchant Weapon - Crusader"] = "무기 마법부여 - 성전사",
		["Enchant Weapon - Deathfrost"] = "무기 마법부여 - 혹한",
		["Enchant Weapon - Demonslaying"] = "무기 마법부여 - 악마 사냥 전문화",
		["Enchant Weapon - Executioner"] = "무기 마법부여 - 집행자",
		["Enchant Weapon - Fiery Weapon"] = "무기 마법부여 - 불타는 무기",
		["Enchant Weapon - Greater Agility"] = "무기 마법부여 - 상급 민첩",
		["Enchant Weapon - Greater Striking"] = "무기 마법부여 - 상급 공격력",
		["Enchant Weapon - Healing Power"] = "무기 마법부여 - 치유 강화",
		["Enchant Weapon - Icy Chill"] = "무기 마법부여 - 빙결",
		["Enchant Weapon - Lesser Beastslayer"] = "무기 마법부여 - 하급 야수 사냥 전문화",
		["Enchant Weapon - Lesser Elemental Slayer"] = "무기 마법부여 - 하급 정령 사냥 전문화",
		["Enchant Weapon - Lesser Striking"] = "무기 마법부여 - 하급 공격력",
		["Enchant Weapon - Lifestealing"] = "무기 마법부여 - 생명력 흡수",
		["Enchant Weapon - Major Healing"] = "무기 마법부여 - 일급 치유 마법 강화",
		["Enchant Weapon - Major Intellect"] = "무기 마법부여 - 일급 지능",
		["Enchant Weapon - Major Spellpower"] = "무기 마법부여 - 상급 주문 강화",
		["Enchant Weapon - Major Striking"] = "무기 마법부여 - 일급 공격력",
		["Enchant Weapon - Mighty Intellect"] = "무기 마법부여 - 뛰어난 지능",
		["Enchant Weapon - Mighty Spirit"] = "무기 마법부여 - 강한 정신력",
		["Enchant Weapon - Minor Beastslayer"] = "무기 마법부여 - 최하급 야수 사냥 전문화",
		["Enchant Weapon - Minor Striking"] = "무기 마법부여 - 최하급 공격력",
		["Enchant Weapon - Mongoose"] = "무기 마법부여 - 살쾡이",
		["Enchant Weapon - Potency"] = "무기 마법부여 - 근력",
		["Enchant Weapon - Soulfrost"] = "무기 마법부여 - 냉기의 영혼",
		["Enchant Weapon - Spell Power"] = "무기 마법부여 - 주문 강화",
		["Enchant Weapon - Spellsurge"] = "무기 마법부여 - 마력의 폭풍",
		["Enchant Weapon - Strength"] = "무기 마법부여 - 힘",
		["Enchant Weapon - Striking"] = "무기 마법부여 - 공격력",
		["Enchant Weapon - Sunfire"] = "무기 마법부여 - 태양의 불꽃",
		["Enchant Weapon - Superior Striking"] = "무기 마법부여 - 최상급 공격력",
		["Enchant Weapon - Unholy Weapon"] = "무기 마법부여 - 부정의 무기",
		["Enchant Weapon - Winter's Might"] = "무기 마법부여 - 한겨울 추위",
		["Enchanted Leather"] = "마력 깃든 가죽",
		["Enchanted Thorium"] = "마력 깃든 토륨",
		["Greater Magic Wand"] = "상급 마술봉",
		["Greater Mystic Wand"] = "신비한 상급 마술봉",
		["Large Prismatic Shard"] = "무지갯빛 큰 결정",
		["Lesser Magic Wand"] = "하급 마술봉",
		["Lesser Mana Oil"] = "하급 마나 오일",
		["Lesser Mystic Wand"] = "신비한 하급 마술봉",
		["Lesser Wizard Oil"] = "하급 마술사 오일",
		["Minor Mana Oil"] = "최하급 마나 오일",
		["Minor Wizard Oil"] = "최하급 마술사 오일",
		["Nexus Transformation"] = "마력 변환",
		["Prismatic Sphere"] = "무지갯빛 구슬",
		["Runed Adamantite Rod"] = "룬문자 아다만타이트 마법막대",
		["Runed Arcanite Rod"] = "룬문자 아케이나이트 마법막대",
		["Runed Copper Rod"] = "룬문자 구리마법막대",
		["Runed Eternium Rod"] = "룬문자 이터늄 마법막대",
		["Runed Fel Iron Rod"] = "룬문자 지옥무쇠 마법막대",
		["Runed Golden Rod"] = "룬문자 금마법막대",
		["Runed Silver Rod"] = "룬문자 은마법막대",
		["Runed Truesilver Rod"] = "룬문자 진은마법막대",
		["Small Prismatic Shard"] = "무지갯빛 작은 결정",
		["Smoking Heart of the Mountain"] = "연기나는 산의 정수",
		["Superior Mana Oil"] = "최고급 마나 오일",
		["Superior Wizard Oil"] = "최고급 마술사 오일",
		["Void Shatter"] = "공허의 조각",
		["Void Sphere"] = "공허의 구슬",
		["Wizard Oil"] = "마술사 오일",

-- Engineering Recipes
		["Accurate Scope"] = "정밀한 조준경",
		["Adamantite Arrow Maker"] = "아다만타이트 화살 제조기",
		["Adamantite Frame"] = "아다만타이트 형틀",
		["Adamantite Grenade"] = "아다만타이트 수류탄",
		["Adamantite Rifle"] = "아다만타이트 소총",
		["Adamantite Scope"] = "아다만타이트 조준경",
		["Adamantite Shell Machine"] = "아다만타이트 탄환 제조기",
		["Advanced Target Dummy"] = "고급 표적 허수아비",
		["Alarm-O-Bot"] = "노움 자동경보기",
		["Aquadynamic Fish Attractor"] = "액체역학 물고기 유인기",
		["Arcane Bomb"] = "신비의 폭탄",
		["Arcanite Dragonling"] = "아케이나이트 기계용",
		["Arclight Spanner"] = "만능 스패너",
		["Big Bronze Bomb"] = "대형 청동 폭탄",
		["Big Iron Bomb"] = "대형 철제 폭탄",
		["Biznicks 247x128 Accurascope"] = "비즈닉스 247x128 조준경",
		["Bloodvine Goggles"] = "붉은덩굴 고글",
		["Bloodvine Lens"] = "붉은덩굴 렌즈",
		["Blue Firework"] = "푸른 폭죽",
		["Blue Rocket Cluster"] = "파란색 연발탄",
		["Bright-Eye Goggles"] = "초롱초롱 고글",
		["Bronze Framework"] = "청동 골격",
		["Bronze Tube"] = "청동관",
		["Catseye Ultra Goggles"] = "고양이눈 고글",
		["Coarse Blasting Powder"] = "굵은 화약",
		["Coarse Dynamite"] = "일반 다이너마이트",
		["Cogspinner Goggles"] = "톱니바퀴 고글",
		["Compact Harvest Reaper Kit"] = "소형 허수아비골렘 키트",
		["Copper Modulator"] = "구리 변조기",
		["Copper Tube"] = "구리관",
		["Core Marksman Rifle"] = "명사수의 라이플",
		["Crafted Heavy Shot"] = "수제 중형 탄환",
		["Crafted Light Shot"] = "수제 소형 탄환",
		["Crafted Solid Shot"] = "수제 합금 탄환",
		["Craftsman's Monocle"] = "장인의 단안경",
		["Crashin' Thrashin' Robot"] = "우당탕 쿠당탕 전투로봇",
		["Crude Scope"] = "조잡한 조준경",
		["Dark Iron Bomb"] = "검은무쇠 폭탄",
		["Dark Iron Rifle"] = "검은무쇠 소총",
		["Deadly Blunderbuss"] = "정교한 나팔총",
		["Deadly Scope"] = "초정밀 조준경",
		["Deathblow X11 Goggles"] = "죽음의 고글 X11",
		["Deepdive Helmet"] = "잠수용 헬멧",
		["Delicate Arcanite Converter"] = "정교한 아케이나이트 변환기",
		["Dense Blasting Powder"] = "강도 높은 화약",
		["Dense Dynamite"] = "강도 높은 다이너마이트",
		["Destruction Holo-gogs"] = "파괴의 홀로그램 고글",
		["Dimensional Ripper - Area 52"] = "차원 분할기 : 52번 구역",
		["Dimensional Ripper - Everlook"] = "차원 분할기 : 눈망루 마을",
		["Discombobulator Ray"] = "유전자 역결합 광선",
		["Elemental Blasting Powder"] = "원소 화약",
		["Elemental Seaforium Charge"] = "원소 시포리움 폭약",
		["Explosive Sheep"] = "양 폭탄",
		["EZ-Thro Dynamite II"] = "초보자용 다이너마이트 II",
		["EZ-Thro Dynamite"] = "초보자용 다이너마이트",
		["Fel Iron Bomb"] = "지옥무쇠 폭탄",
		["Fel Iron Casing"] = "지옥무쇠 형틀",
		["Fel Iron Musket"] = "지옥무쇠 머스킷총",
		["Fel Iron Shells"] = "지옥무쇠 탄환",
		["Fel Iron Toolbox"] = "지옥무쇠 연장통",
		["Felsteel Boomstick"] = "지옥강철 붐스틱",
		["Felsteel Stabilizer"] = "지옥강철 안정장치",
		["Field Repair Bot 110G"] = "야전수리로봇 110G",
		["Field Repair Bot 74A"] = "야전수리로봇 74A",
		["Fire Goggles"] = "화염 고글",
		["Firework Cluster Launcher"] = "연발탄 발사대",
		["Firework Launcher"] = "폭죽 발사대",
		["Flame Deflector"] = "화염 반사장치",
		["Flash Bomb"] = "섬광탄",
		["Flawless Arcanite Rifle"] = "정교한 아케이나이트 소총",
		["Flying Machine"] = "비행기",
		["Flying Tiger Goggles"] = "비호 고글",
		["Force Reactive Disk"] = "마력장 원반",
		["Foreman's Enchanted Helmet"] = "현장감독의 마법 안전모",
		["Foreman's Reinforced Helmet"] = "현장감독의 강화 안전모",
		["Frost Grenades"] = "냉기 수류탄",
		["Furious Gizmatic Goggles"] = "맹렬한 기계장치 고글",
		["Fused Wiring"] = "신관 배선",
		["Gadgetstorm Goggles"] = "폭풍기계장치 고글",
		["Gnomish Battle Chicken"] = "노움 쌈닭",
		["Gnomish Battle Goggles"] = "노움 전투 고글",
		["Gnomish Cloaking Device"] = "노움 은폐 장치",
		["Gnomish Death Ray"] = "노움 즉사 광선",
		["Gnomish Flame Turret"] = "노움 화염 포탑",
		["Gnomish Goggles"] = "노움 고글",
		["Gnomish Harm Prevention Belt"] = "노움 전투 방어 허리띠",
		["Gnomish Mind Control Cap"] = "노움 정신 지배 모자",
		["Gnomish Net-o-Matic Projector"] = "노움 자동그물발사기",
		["Gnomish Poultryizer"] = "노움 꼬꼬댁 변신장치",
		["Gnomish Power Goggles"] = "노움 주문증폭 고글",
		["Gnomish Rocket Boots"] = "노움 로켓 장화",
		["Gnomish Shrink Ray"] = "노움 난쟁이 광선",
		["Gnomish Universal Remote"] = "노움의 만능 원격조종기",
		["Goblin Bomb Dispenser"] = "고블린 폭탄 자판기",
		["Goblin Construction Helmet"] = "고블린 안전모",
		["Goblin Dragon Gun"] = "고블린 용기총",
		["Goblin Jumper Cables XL"] = "고블린 점퍼 케이블 XL",
		["Goblin Jumper Cables"] = "고블린 점퍼 케이블",
		["Goblin Land Mine"] = "고블린 지뢰",
		["Goblin Mining Helmet"] = "고블린 채광용 헬멧",
		["Goblin Mortar"] = "고블린 박격포",
		["Goblin Rocket Boots"] = "고블린 로켓 장화",
		["Goblin Rocket Fuel Recipe"] = "조제법: 고블린 로켓 연료",
		["Goblin Rocket Helmet"] = "고블린 로켓 헬멧",
		["Goblin Rocket Launcher"] = "고블린 로켓 발사기",
		["Goblin Sapper Charge"] = "고블린 공병 폭탄",
		["Gold Power Core"] = "황금 동력핵",
		["Green Firework"] = "녹색 폭죽",
		["Green Lens"] = "녹색 렌즈",
		["Green Rocket Cluster"] = "녹색 연발탄",
		["Green Smoke Flare"] = "녹색 조명탄",
		["Green Tinted Goggles"] = "녹빛 고글",
		["Gyro-balanced Khorium Destroyer"] = "균형 잡힌 회전식 코륨 파괴자",
		["Gyrochronatom"] = "태엽장치",
		["Gyrofreeze Ice Reflector"] = "회전냉각식 냉기 반사기",
		["Gyromatic Micro-Adjustor"] = "자동회전 초정밀조율기",
		["Handful of Copper Bolts"] = "구리 나사 한 줌",
		["Handful of Fel Iron Bolts"] = "지옥무쇠 나사 한 줌",
		["Hardened Adamantite Tube"] = "강화된 아다만타이트관",
		["Healing Potion Injector"] = "치유 물약 주사기",
		["Heavy Blasting Powder"] = "강한 화약",
		["Heavy Dynamite"] = "강한 다이너마이트",
		["Hi-Explosive Bomb"] = "고폭탄",
		["Hi-Impact Mithril Slugs"] = "고강도 미스릴 산탄",
		["Hyper-Radiant Flame Reflector"] = "극고온 화염 반사기",
		["Hyper-Vision Goggles"] = "고감도 고글",
		["Ice Deflector"] = "냉기 반사장치",
		["Icy Blasting Primers"] = "얼음 뇌관",
		["Inlaid Mithril Cylinder Plans"] = "세공된 미스릴 실린더 도면",
		["Iron Grenade"] = "철제 수류탄",
		["Iron Strut"] = "철제 버팀대",
		["Justicebringer 2000 Specs"] = "정의의 수호 반사경 2000",
		["Khorium Power Core"] = "코륨 동력핵",
		["Khorium Scope"] = "코륨 조준경",
		["Large Blue Rocket Cluster"] = "큰 파란색 연발탄",
		["Large Blue Rocket"] = "큰 파란색 폭죽",
		["Large Copper Bomb"] = "대형 구리 폭탄",
		["Large Green Rocket Cluster"] = "큰 녹색 연발탄",
		["Large Green Rocket"] = "큰 녹색 폭죽",
		["Large Red Rocket Cluster"] = "큰 빨간색 연발탄",
		["Large Red Rocket"] = "큰 빨간색 폭죽",
		["Large Seaforium Charge"] = "대형 시포리움 폭약",
		["Lifelike Mechanical Toad"] = "감쪽같은 기계개구리",
		["Lil' Smoky"] = "릴 스모키",
		["Living Replicator Specs"] = "생명의 순환 반사경",
		["Lovingly Crafted Boomstick"] = "정성이 가득 담긴 붐스틱",
		["Magnified Moon Specs"] = "증폭된 달빛 반사경",
		["Major Recombobulator"] = "상급 유전자 역결합기",
		["Mana Potion Injector"] = "마나 물약 주사기",
		["Master Engineer's Goggles"] = "전문 기술자의 고글",
		["Masterwork Target Dummy"] = "일급 표적 허수아비",
		["Mechanical Dragonling"] = "소형 기계용",
		["Mechanical Repair Kit"] = "기계 수리 장비",
		["Mechanical Squirrel"] = "기계 다람쥐",
		["Minor Recombobulator"] = "하급 유전자 역결합기",
		["Mithril Blunderbuss"] = "미스릴 나팔총",
		["Mithril Casing"] = "미스릴 형틀",
		["Mithril Frag Bomb"] = "미스릴 파편 폭탄",
		["Mithril Gyro-Shot"] = "미스릴 회전탄",
		["Mithril Heavy-bore Rifle"] = "미스릴 중구경 라이플",
		["Mithril Mechanical Dragonling"] = "소형 미스릴 기계용",
		["Mithril Tube"] = "미스릴관",
		["Moonsight Rifle"] = "달빛 라이플",
		["Nigh-Invulnerability Belt"] = "거의 무적 허리띠",
		["Ornate Khorium Rifle"] = "화려한 코륨 소총",
		["Ornate Spyglass"] = "화려한 망원경",
		["Parachute Cloak"] = "낙하산 망토",
		["Pet Bombling"] = "작은 꼬마 폭탄",
		["Portable Bronze Mortar"] = "휴대용 청동 박격포",
		["Power Amplification Goggles"] = "마력 증폭 고글",
		["Powerful Seaforium Charge"] = "강력한 시포리움 폭약",
		["Powerheal 4000 Lens"] = "강력한 치유 랜즈 4000",
		["Practice Lock"] = "연습용 자물쇠",
		["Purple Smoke Flare"] = "보라색 조명탄",
		["Red Firework"] = "붉은 폭죽",
		["Red Rocket Cluster"] = "빨간색 연발탄",
		["Rocket Boots Xtreme"] = "극한의 로켓 장화",
		["Rose Colored Goggles"] = "장밋빛 고글",
		["Rough Blasting Powder"] = "천연 화약",
		["Rough Boomstick"] = "조잡한 붐스틱",
		["Rough Copper Bomb"] = "천연 구리 폭탄",
		["Rough Dynamite"] = "천연 다이너마이트",
		["Salt Shaker"] = "소금 정제기",
		["Shadow Goggles"] = "그림자 고글",
		["Silver Contact"] = "은 접지",
		["Silver-plated Shotgun"] = "은도금 산탄총",
		["Small Blue Rocket"] = "작은 파란색 폭죽",
		["Small Bronze Bomb"] = "소형 청동 폭탄",
		["Small Green Rocket"] = "작은 녹색 폭죽",
		["Small Red Rocket"] = "작은 빨간색 폭죽",
		["Small Seaforium Charge"] = "소형 시포리움 폭약",
		["Snake Burst Firework"] = "뱀꼬리 폭죽",
		["Sniper Scope"] = "저격용 조준경",
		["SnowMaster 9000"] = "눈뭉치제조기 9000",
		["Solid Blasting Powder"] = "조밀한 화약",
		["Solid Dynamite"] = "조밀한 다이너마이트",
		["Spellpower Goggles Xtreme Plus"] = "최신형 주문증폭 고글",
		["Spellpower Goggles Xtreme"] = "초강력 화력 고글",
		["Stabilized Eternium Scope"] = "안정된 이터늄 조준경",
		["Standard Scope"] = "일반 조준경",
		["Steam Tonk Controller"] = "통통 전차 조종기",
		["Super Sapper Charge"] = "초강력 공병 폭탄",
		["Surestrike Goggles v2.0"] = "일격보증 고글 v2.0",
		["Tankatronic Goggles"] = "전자방어 고글",
		["Target Dummy"] = "표적 허수아비",
		["The Big One"] = "왕폭탄",
		["The Bigger One"] = "대왕폭탄",
		["The Mortar: Reloaded"] = "박격포 재장전",
		["Thorium Grenade"] = "토륨 수류탄",
		["Thorium Rifle"] = "토륨 소총",
		["Thorium Shells"] = "토륨 탄환",
		["Thorium Tube"] = "토륨관",
		["Thorium Widget"] = "토륨 부품",
		["Tranquil Mechanical Yeti"] = "온순한 기계설인",
		["Truesilver Transformer"] = "진은 변환기",
		["Turbo-Charged Flying Machine"] = "터보 충전 비행기",
		["Ultra-Flash Shadow Reflector"] = "초광자 암흑 반사기",
		["Ultrasafe Transporter - Gadgetzan"] = "안전보증 순간이동기: 가젯잔",
		["Ultrasafe Transporter - Toshley's Station"] = "안전보증 순간이동기: 토쉴리의 연구기지",
		["Ultra-Spectropic Detection Goggles"] = "초분광 감지 고글",
		["Unstable Trigger"] = "유동성 제동장치",
		["Voice Amplification Modulator"] = "주문 확성 변조기",
		["Whirring Bronze Gizmo"] = "청동 회전 장치",
		["White Smoke Flare"] = "백색 조명탄",
		["Wonderheal XT40 Shades"] = "기적의 치유 색안경 XT40",
		["World Enlarger"] = "아제로스 확대기",
		["Zapthrottle Mote Extractor"] = "기압조절 가스 추출기",
		["Lightning Etched Specs"] = "번개 깃든 반사경",
		["Annihilator Holo-Gogs"] = "파멸의 홀로그램 고글",
		["Primal-Attuned Goggles"] = "원소 조화의 고글",
		["Powerheal 9000 Lens"] = "강력한 치유 렌즈 9000",
		["Justicebringer 3000 Specs"] = "정의의 수호 반사경 3000",
		["Surestrike Goggles v3.0"] = "일격보증 고글 v3.0",
		["Hyper-Magnified Moon Specs"] = "고도로 증폭된 달빛 반사경",
		["Wonderheal XT68 Shades"] = "기적의 치유 색안경 XT68",
		["Hard Khorium Goggles"] = "단단한 코륨 고글",
		["Quad Deathblow X44 Goggles"] = "사중 죽음의 고글 X44",
		["Mayhem Projection Goggles"] = "파괴력 투영 고글",

-- First Aid Recipes
		["Anti-Venom"] = "해독제",
		["Heavy Linen Bandage"] = "두꺼운 리넨 붕대",
		["Heavy Mageweave Bandage"] = "두꺼운 마법 붕대",
		["Heavy Netherweave Bandage"] = "두꺼운 황천매듭 붕대",
		["Heavy Runecloth Bandage"] = "두꺼운 룬매듭 붕대",
		["Heavy Silk Bandage"] = "두꺼운 비단 붕대",
		["Heavy Wool Bandage"] = "두꺼운 양모 붕대",
		["Linen Bandage"] = "리넨 붕대",
		["Mageweave Bandage"] = "마법 붕대",
		["Netherweave Bandage"] = "황천매듭 붕대",
		["Powerful Anti-Venom"] = "강력한 해독제",
		["Runecloth Bandage"] = "룬매듭 붕대",
		["Silk Bandage"] = "비단 붕대",
		["Strong Anti-Venom"] = "강한 해독제",
		["Wool Bandage"] = "양모 붕대",

-- Jewelcrafting Recipes
		["Amulet of Flowing Life"] = "샘솟는 생명의 아뮬렛",
		["Amulet of the Moon"] = "달의 아뮬렛",
		["Aquamarine Pendant of the Warrior"] = "전사의 남옥 펜던트",
		["Aquamarine Signet"] = "남옥 인장 반지",
		["Arcane Khorium Band"] = "비전의 코륨 고리",
		["Azure Moonstone Ring"] = "하늘월장석 반지",
		["Balanced Nightseye"] = "균형 잡힌 야안석",
		["Balanced Shadowsong Amethyst"] = "균형 잡힌 어둠노래 자수정",
		["Balanced Shadow Draenite"] = "균형 잡힌 암흑 드레나이트",
		["Band of Natural Fire"] = "자연의 불꽃 고리",
		["Barbaric Iron Collar"] = "야만전사의 철제 목줄",
		["Blazing Citrine Ring"] = "타오르는 황수정 반지",
		["Blazing Eternium Band"] = "타오르는 이터늄 반지",
		["Blood of Amber"] = "호박석 조각",
		["Bold Blood Garnet"] = "굵은 혈류석",
		["Bold Crimson Spinel"] = "굵은 붉은 첨정석",
		["Bold Living Ruby"] = "굵은 여명의 루비",
		["Bracing Earthstorm Diamond"] = "원기 회복의 대지폭풍 다이아몬드",
		["Braided Copper Ring"] = "갈래매듭 구리 반지",
		["Braided Eternium Chain"] = "이터늄 고리 목걸이",
		["Bright Blood Garnet"] = "광채나는 혈류석",
		["Bright Crimson Spinel"] = "광채나는 붉은 첨정석",
		["Bright Living Ruby"] = "광채나는 여명의 루비",
		["Brilliant Dawnstone"] = "찬란한 여명석",
		["Brilliant Golden Draenite"] = "찬란한 황금 드레나이트",
		["Brilliant Lionseye"] = "찬란한 사안석",
		["Brilliant Necklace"] = "찬란한 목걸이",
		["Brilliant Pearl Band"] = "찬란한 진주 고리",
		["Bronze Band of Force"] = "마력의 청동 고리",
		["Bronze Setting"] = "청동 장식",
		["Bronze Torc"] = "청동 목걸이",
		["Brutal Earthstorm Diamond"] = "무자비의 대지폭풍 다이아몬드",
		["Chain of the Twilight Owl"] = "황혼의 올빼미 사슬 목걸이",
		["Chaotic Skyfire Diamond"] = "혼돈의 하늘불꽃 다이아몬드",
		["Circlet of Arcane Might"] = "신비한 힘의 화관",
		["Citrine Pendant of Golden Healing"] = "황금빛 치유의 황수정 펜던트",
		["Citrine Ring of Rapid Healing"] = "신속한 치유의 황수정 반지",
		["Coarse Stone Statue"] = "일반 돌 조각상",
		["Coronet of the Verdant Flame"] = "푸른 불길의 화관",
		["Crimson Sun"] = "진홍빛 태양",
		["Crown of the Sea Witch"] = "바다마녀의 관",
		["Dazzling Deep Peridot"] = "휘황찬란한 심연의 감람석",
		["Dazzling Seaspray Emerald"] = "휘황찬란한 바다안개 에메랄드",
		["Dazzling Talasite"] = "휘황찬란한 탈라사이트",
		["Delicate Blood Garnet"] = "섬세하게 연마된 혈류석",
		["Delicate Copper Wire"] = "가느다란 구리 철사",
		["Delicate Crimson Spinel"] = "섬세하게 연마된 붉은 첨정석",
		["Delicate Eternium Ring"] = "섬세한 이터늄 반지",
		["Delicate Living Ruby"] = "섬세하게 연마된 생명의 루비",
		["Dense Stone Statue"] = "강도 높은 돌 조각상",
		["Destructive Skyfire Diamond"] = "파괴의 하늘불꽃 다이아몬드",
		["Diamond Focus Ring"] = "다이아몬드 정신집중 반지",
		["Don Julio's Heart"] = "돈 훌리오의 심장",
		["Elegant Silver Ring"] = "세련된 은 반지",
		["Ember Skyfire Diamond"] = "이글거리는 하늘불꽃 다이아몬드",
		["Embrace of the Dawn"] = "여명의 선물",
		["Emerald Crown of Destruction"] = "파괴의 에메랄드 왕관",
		["Emerald Lion Ring"] = "에메랄드 사자 반지",
		["Enduring Deep Peridot"] = "견고한 심연의 감람석",
		["Enduring Seaspray Emerald"] = "견고한 바다안개 에메랄드",
		["Enduring Talasite"] = "견고한 탈라사이트",
		["Engraved Truesilver Ring"] = "글자가 새겨진 진은 반지",
		["Enigmatic Skyfire Diamond"] = "불가사의의 하늘불꽃 다이아몬드",
		["Eye of the Night"] = "밤의 눈",
		["Facet of Eternity"] = "영원의 상",
		["Falling Star"] = "별똥별",
		["Fel Iron Blood Ring"] = "피의 지옥무쇠 반지",
		["Figurine - Black Diamond Crab"] = "조각상 - 검은 다이아몬드 게",
		["Figurine - Black Pearl Panther"] = "조각상 - 검은 진주 표범",
		["Figurine - Dark Iron Scorpid"] = "조각상 - 검은무쇠 전갈",
		["Figurine - Dawnstone Crab"] = "조각상 - 여명석 게",
		["Figurine - Emerald Owl"] = "조각상 - 에메랄드 올빼미",
		["Figurine - Felsteel Boar"] = "조각상 - 지옥강철 멧돼지",
		["Figurine - Golden Hare"] = "조각상 - 황금 토끼",
		["Figurine - Jade Owl"] = "조각상 - 비취 올빼미",
		["Figurine - Living Ruby Serpent"] = "조각상 - 생명의 루비 뱀",
		["Figurine - Nightseye Panther"] = "조각상 - 야안석 표범",
		["Figurine - Ruby Serpent"] = "조각상 - 루비 뱀",
		["Figurine - Talasite Owl"] = "조각상 - 탈라사이트 올빼미",
		["Figurine - Truesilver Boar"] = "조각상 - 진은 멧돼지",
		["Figurine - Truesilver Crab"] = "조각상 - 진은 게",
		["Flashing Crimson Spinel"] = "번쩍이는 붉은 첨정석",
		["Flashing Living Ruby"] = "번쩍이는 생명의 루비",
		["Gem Studded Band"] = "보석 박힌 고리",
		["Gleaming Dawnstone"] = "번뜩이는 여명석",
		["Gleaming Golden Draenite"] = "번뜩이는 황금 드레나이트",
		["Gleaming Lionseye"] = "번뜩이는 사안석",
		["Glinting Flame Spessarite"] = "예리하게 빛나는 불꽃석류석",
		["Glinting Noble Topaz"] = "예리하게 빛나는 귀황옥",
		["Glinting Pyrestone"] = "예리하게 빛나는 열화석",
		["Gloom Band"] = "어둠의 고리",
		["Glowing Nightseye"] = "작열하는 야안석",
		["Glowing Shadow Draenite"] = "작열하는 암흑 드레나이트",
		["Glowing Shadowsong Amethyst"] = "작열하는 어둠노래 자수정",
		["Glowing Thorium Band"] = "작열하는 토륨 반지",
		["Golden Draenite Ring"] = "황금 드레나이트 반지",
		["Golden Dragon Ring"] = "황금 용 반지",
		["Golden Ring of Power"] = "마력의 금반지",
		["Great Dawnstone"] = "커다란 여명석",
		["Great Golden Draenite"] = "커다란 황금 드레나이트",
		["Great Lionseye"] = "커다란 사안석",
		["Hard Khorium Band"] = "단단한 코륨 반지",
		["Hard Khorium Choker"] = "단단한 코륨 목걸이",
		["Heavy Adamantite Ring"] = "무거운 아다만타이트 반지",
		["Heavy Copper Ring"] = "묵직한 구리 반지",
		["Heavy Felsteel Ring"] = "무거운 지옥강철 반지",
		["Heavy Golden Necklace of Battle"] = "전투의 묵직한 황금 목걸이",
		["Heavy Iron Knuckles"] = "묵직한 철제 너클",
		["Heavy Jade Ring"] = "무거운 비취 반지",
		["Heavy Silver Ring"] = "무거운 은 반지",
		["Heavy Stone Statue"] = "단단한 돌 조각상",
		["Infused Nightseye"] = "마력 깃든 야안석",
		["Infused Shadow Draenite"] = "마력 깃든 암흑 드레나이트",
		["Infused Shadowsong Amethyst"] = "마력 깃든 어둠노래 자수정",
		["Inlaid Malachite Ring"] = "세공된 공작석 반지",
		["Inscribed Flame Spessarite"] = "문자가 새겨진 불꽃석류석",
		["Inscribed Noble Topaz"] = "문자가 새겨진 귀황옥",
		["Inscribed Pyrestone"] = "문자가 새겨진 열화석",
		["Insightful Earthstorm Diamond"] = "통찰의 대지폭풍 다이아몬드",
		["Jade Pendant of Blasting"] = "작렬하는 비취 펜던트",
		["Jagged Deep Peridot"] = "톱니모양 심연의 감람석",
		["Jagged Seaspray Emerald"] = "톱니모양 바다안개 에메랄드",
		["Jagged Talasite"] = "톱니모양 탈라사이트",
		["Kailee's Rose"] = "카일리의 장미",
		["Khorium Band of Frost"] = "냉기의 코륨 고리",
		["Khorium Band of Leaves"] = "나뭇잎의 코륨 고리",
		["Khorium Band of Shadows"] = "암흑의 코륨 고리",
		["Khorium Inferno Band"] = "불지옥의 코륨 고리",
		["Living Emerald Pendant"] = "생명의 에메랄드 펜던트",
		["Living Ruby Pendant"] = "생명의 루비 펜던트",
		["Loop of Forged Power"] = "두려운 힘의 고리",
		["Luminous Flame Spessarite"] = "영롱한 불꽃석류석",
		["Luminous Noble Topaz"] = "영롱한 귀황옥",
		["Luminous Pyrestone"] = "영롱한 열화석",
		["Lustrous Azure Moonstone"] = "빛나는 하늘월장석",
		["Lustrous Empyrean Sapphire"] = "빛나는 창공의 사파이어",
		["Lustrous Star of Elune"] = "빛나는 엘룬의 별",
		["Malachite Pendant"] = "공작석 펜던트",
		["Mercurial Adamantite"] = "수은 아다만타이트",
		["Mithril Filigree"] = "미스릴 장식",
		["Moonsoul Crown"] = "달의 영혼 관",
		["Mystic Dawnstone"] = "신비로운 여명석",
		["Mystic Lionseye"] = "신비로운 사안석",
		["Mystical Skyfire Diamond"] = "신비의 하늘불꽃 다이아몬드",
		["Necklace of the Deep"] = "심연의 목걸이",
		["Necklace of the Diamond Tower"] = "다이아몬드 탑 목걸이",
		["Onslaught Ring"] = "맹공격의 반지",
		["Opal Necklace of Impact"] = "충돌의 오팔 목걸이",
		["Ornate Tigerseye Necklace"] = "화려한 호안석 목걸이",
		["Pendant of Frozen Flame"] = "얼어붙은 불길의 펜던트",
		["Pendant of Shadow's End"] = "암흑 종말의 펜던트",
		["Pendant of Sunfire"] = "태양불꽃 펜던트",
		["Pendant of Thawing"] = "해빙의 펜던트",
		["Pendant of the Agate Shield"] = "보호의 태마노 펜던트",
		["Pendant of the Null Rune"] = "무의미한 룬의 펜던트",
		["Pendant of Withering"] = "가뭄의 펜던트",
		["Potent Flame Spessarite"] = "마력이 담긴 불꽃석류석",
		["Potent Noble Topaz"] = "마력이 담긴 귀황옥",
		["Potent Pyrestone"] = "마력이 담긴 열화석",
		["Powerful Earthstorm Diamond"] = "강력한 대지폭풍 다이아몬드",
		["Purified Jaggal Pearl"] = "정화된 톱니조개 진주",
		["Purified Shadow Pearl"] = "정화된 암흑 진주",
		["Radiant Deep Peridot"] = "눈부신 심연의 감람석",
		["Radiant Seaspray Emerald"] = "눈부신 바다안개 에메랄드",
		["Radiant Talasite"] = "눈부신 탈라사이트",
		["Red Ring of Destruction"] = "파괴의 붉은 반지",
		["Relentless Earthstorm Diamond"] = "냉혹의 대지폭풍 다이아몬드",
		["Rigid Dawnstone"] = "강도 높은 여명석",
		["Rigid Golden Draenite"] = "강도 높은 황금 드레나이트",
		["Rigid Lionseye"] = "강도 높은 사안석",
		["Ring of Arcane Shielding"] = "비전 보호의 반지",
		["Ring of Bitter Shadows"] = "가혹한 어둠의 반지",
		["Ring of Flowing Life"] = "샘솟는 생명의 반지",
		["Ring of Silver Might"] = "힘의 은 반지",
		["Ring of Twilight Shadows"] = "황혼의 그림자 반지",
		["Rough Stone Statue"] = "조잡한 돌 조각상",
		["Royal Nightseye"] = "호화로운 야안석",
		["Royal Shadow Draenite"] = "호화로운 암흑 드레나이트",
		["Royal Shadowsong Amethyst"] = "호화로운 어둠노래 자수정",
		["Ruby Crown of Restoration"] = "회복의 루비 왕관",
		["Ruby Pendant of Fire"] = "불의 루비 펜던트",
		["Runed Blood Garnet"] = "룬이 새겨진 혈류석",
		["Runed Crimson Spinel"] = "룬이 새겨진 붉은 첨정석",
		["Runed Living Ruby"] = "룬이 새겨진 생명의 루비",
		["Sapphire Pendant of Winter Night"] = "겨울밤의 사파이어 펜던트",
		["Sapphire Signet"] = "사파이어 인장 반지",
		["Shifting Nightseye"] = "아른거리는 야안석",
		["Shifting Shadow Draenite"] = "아른거리는 암흑 드레나이트",
		["Shifting Shadowsong Amethyst"] = "아른거리는 어둠노래 자수정",
		["Simple Opal Ring"] = "간결한 오팔 반지",
		["Simple Pearl Ring"] = "간결한 진주 반지",
		["Smooth Dawnstone"] = "매끄러운 여명석",
		["Smooth Golden Draenite"] = "매끄러운 황금 드레나이트",
		["Smooth Lionseye"] = "매끄러운 사안석",
		["Solid Azure Moonstone"] = "단단한 하늘월장석",
		["Solid Bronze Ring"] = "순 청동 반지",
		["Solid Empyrean Sapphire"] = "단단한 창공의 사파이어",
		["Solid Star of Elune"] = "단단한 엘룬의 별",
		["Solid Stone Statue"] = "견고한 돌 조각상",
		["Sovereign Nightseye"] = "최상급 야안석",
		["Sovereign Shadow Draenite"] = "최상급 암흑 드레나이트",
		["Sovereign Shadowsong Amethyst"] = "최상급 어둠노래 자수정",
		["Sparkling Azure Moonstone"] = "반짝거리는 하늘월장석",
		["Sparkling Empyrean Sapphire"] = "반짝거리는 창공의 사파이어",
		["Sparkling Star of Elune"] = "반짝거리는 엘룬의 별",
		["Steady Talasite"] = "한결같은 탈라사이트",
		["Stone of Blades"] = "검단석",
		["Stormy Azure Moonstone"] = "휘몰아치는 하늘월장석",
		["Stormy Empyrean Sapphire"] = "휘몰아치는 창공의 사파이어",
		["Stormy Star of Elune"] = "휘몰아치는 엘룬의 별",
		["Subtle Crimson Spinel"] = "정교하게 연마된 붉은 첨정석",
		["Subtle Living Ruby"] = "정교하게 연마된 생명의 루비",
		["Swift Skyfire Diamond"] = "신속의 하늘불꽃 다이아몬드",
		["Teardrop Blood Garnet"] = "눈물모양 혈류석",
		["Teardrop Crimson Spinel"] = "눈물모양 붉은 첨정석",
		["Teardrop Living Ruby"] = "눈물모양 생명의 루비",
		["Tenacious Earthstorm Diamond"] = "불굴의 대지폭풍 다이아몬드",
		["The Aquamarine Ward"] = "남옥 수호 반지",
		["The Black Pearl"] = "흑진주 고리",
		["The Frozen Eye"] = "얼어붙은 눈",
		["The Jade Eye"] = "비취의 눈",
		["The Natural Ward"] = "자연의 수호",
		["Thick Adamantite Necklace"] = "두꺼운 아다만타이트 목걸이",
		["Thick Bronze Necklace"] = "두꺼운 청동 목걸이",
		["Thick Dawnstone"] = "두꺼운 여명석",
		["Thick Felsteel Necklace"] = "두꺼운 지옥강철 목걸이",
		["Thick Golden Draenite"] = "두꺼운 황금 드레나이트",
		["Thick Lionseye"] = "두꺼운 사안석",
		["Thorium Setting"] = "토륨 장식",
		["Thundering Skyfire Diamond"] = "천둥치는 하늘불꽃 다이아몬드",
		["Tigerseye Band"] = "호안석 고리",
		["Truesilver Commander's Ring"] = "지휘관의 진은 반지",
		["Truesilver Healing Ring"] = "치유의 진은 반지",
		["Veiled Flame Spessarite"] = "가리어진 불꽃석류석",
		["Veiled Noble Topaz"] = "가리어진 귀황옥",
		["Veiled Pyrestone"] = "가리어진 열화석",
		["Wicked Flame Spessarite"] = "악의의 불꽃석류석",
		["Wicked Moonstone Ring"] = "부정한 월장석 반지",
		["Wicked Noble Topaz"] = "악의의 귀황옥",
		["Wicked Pyrestone"] = "악의의 열화석",
		["Woven Copper Ring"] = "띠매듭 구리 반지",
		["Quick Dawnstone"] = "쾌속의 여명석",
		["Forceful Talasite"] = "강인한 탈라사이트",
		["Reckless Noble Topaz"] = "무모의 귀황옥",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "비전 방어구 키트",
		["Bag of Many Hides"] = "가죽 덧댄 가방",
		["Barbaric Belt"] = "야만전사의 허리띠",
		["Barbaric Bracers"] = "야만전사의 팔보호구",
		["Barbaric Gloves"] = "야만전사의 장갑",
		["Barbaric Harness"] = "야만전사의 멜빵",
		["Barbaric Leggings"] = "야만전사의 다리보호구",
		["Barbaric Shoulders"] = "야만전사의 어깨보호구",
		["Belt of Deep Shadow"] = "깊은 어둠의 허리띠",
		["Belt of Natural Power"] = "자연이 품은 힘의 허리띠",
		["Belt of the Black Eagle"] = "검은 독수리 허리띠",
		["Big Voodoo Cloak"] = "부두교 망토",
		["Big Voodoo Mask"] = "부두교 가면",
		["Big Voodoo Pants"] = "부두교 바지",
		["Big Voodoo Robe"] = "부두교 로브",
		["Bindings of Lightning Reflexes"] = "번개같은 반사 신경의 손목띠",
		["Black Dragonscale Boots"] = "검은용비늘 장화",
		["Black Dragonscale Breastplate"] = "검은용비늘 흉갑",
		["Black Dragonscale Leggings"] = "검은용비늘 다리보호구",
		["Black Dragonscale Shoulders"] = "검은용비늘 어깨보호구",
		["Black Whelp Cloak"] = "새끼 검은용 망토",
		["Black Whelp Tunic"] = "새끼 검은용 튜닉",
		["Blackstorm Leggings"] = "검은폭풍 다리보호구",
		["Blastguard Belt"] = "폭풍막이 허리띠",
		["Blastguard Boots"] = "폭풍막이 장화",
		["Blastguard Pants"] = "폭풍막이 바지",
		["Blood Tiger Breastplate"] = "붉은호랑이 흉갑",
		["Blood Tiger Shoulders"] = "붉은호랑이 어깨보호구",
		["Blue Dragonscale Breastplate"] = "푸른용비늘 흉갑",
		["Blue Dragonscale Leggings"] = "푸른용비늘 다리보호구",
		["Blue Dragonscale Shoulders"] = "푸른용비늘 어깨보호구",
		["Boots of Natural Grace"] = "자연이 내린 은총의 장화",
		["Boots of Shackled Souls"] = "구속된 영혼의 장화",
		["Boots of the Crimson Hawk"] = "붉은매 장화",
		["Boots of Utter Darkness"] = "철저한 암흑의 장화",
		["Bracers of Renewed Life"] = "새로운 삶의 팔보호구",
		["Bracers of Shackled Souls"] = "구속된 영혼의 팔보호구",
		["Bramblewood Belt"] = "가시나무 허리띠",
		["Bramblewood Boots"] = "가시나무 장화",
		["Bramblewood Helm"] = "가시나무 투구",
		["Chimeric Boots"] = "키메라 장화",
		["Chimeric Gloves"] = "키메라 장갑",
		["Chimeric Leggings"] = "키메라 다리보호구",
		["Chimeric Vest"] = "키메라 조끼",
		["Chromatic Cloak"] = "오색 망토",
		["Chromatic Gauntlets"] = "오색 건틀릿",
		["Clefthide Leg Armor"] = "갈래가죽 다리 방어구 강화 키트",
		["Cloak of Darkness"] = "암흑의 망토",
		["Cobrahide Leg Armor"] = "코브라가죽 다리 방어구 강화 키트",
		["Cobrascale Gloves"] = "코브라 비늘 장갑",
		["Cobrascale Hood"] = "코브라 비늘 두건",
		["Comfortable Insoles"] = "편안한 깔창",
		["Comfortable Leather Hat"] = "편한 가죽 모자",
		["Core Armor Kit"] = "화산 방어구 키트",
		["Corehound Belt"] = "화산사냥개 허리띠",
		["Corehound Boots"] = "화산사냥개 장화",
		["Cured Heavy Hide"] = "질긴 경화 가죽",
		["Cured Light Hide"] = "얇은 경화 가죽",
		["Cured Medium Hide"] = "일반 경화 가죽",
		["Cured Rugged Hide"] = "거친 경화 가죽",
		["Cured Thick Hide"] = "두꺼운 경화 가죽",
		["Dark Leather Belt"] = "암색 가죽 허리띠",
		["Dark Leather Boots"] = "암색 가죽 장화",
		["Dark Leather Cloak"] = "암색 가죽 망토",
		["Dark Leather Gloves"] = "암색 가죽 장갑",
		["Dark Leather Pants"] = "암색 가죽 바지",
		["Dark Leather Shoulders"] = "암색 가죽 어깨보호구",
		["Dark Leather Tunic"] = "암색 가죽 튜닉",
		["Dawn Treaders"] = "여명의 가죽장화",
		["Deviate Scale Belt"] = "돌연변이 비늘 허리띠",
		["Deviate Scale Cloak"] = "돌연변이 비늘 망토",
		["Deviate Scale Gloves"] = "돌연변이 비늘 장갑",
		["Devilsaur Gauntlets"] = "데빌사우루스 건틀릿",
		["Devilsaur Leggings"] = "데빌사우루스 다리보호구",
		["Dragonscale Breastplate"] = "용비늘 흉갑",
		["Dragonscale Gauntlets"] = "용비늘 건틀릿",
		["Dragonstrike Leggings"] = "용쐐기 다리보호구",
		["Dreamscale Breastplate"] = "꿈비늘 흉갑",
		["Drums of Battle"] = "전투의 북소리",
		["Drums of Panic"] = "공황의 북소리",
		["Drums of Restoration"] = "회복의 북소리",
		["Drums of Speed"] = "신속의 북소리",
		["Drums of War"] = "전쟁의 북소리",
		["Dusky Belt"] = "거무스름한 허리띠",
		["Dusky Boots"] = "거무스름한 장화",
		["Dusky Bracers"] = "거무스름한 팔보호구",
		["Dusky Leather Armor"] = "거무스름한 가죽 갑옷",
		["Dusky Leather Leggings"] = "거무스름한 가죽 다리보호구",
		["Earthen Leather Shoulders"] = "대지의 가죽 어깨보호구",
		["Earthen Netherscale Boots"] = "대지의 황천비늘 장화",
		["Ebon Netherscale Belt"] = "칠흑의 황천비늘 허리띠",
		["Ebon Netherscale Bracers"] = "칠흑의 황천비늘 팔보호구",
		["Ebon Netherscale Breastplate"] = "칠흑의 황천비늘 흉갑",
		["Embossed Leather Boots"] = "새김무늬 가죽 장화",
		["Embossed Leather Cloak"] = "새김무늬 가죽 망토",
		["Embossed Leather Gloves"] = "새김무늬 가죽 장갑",
		["Embossed Leather Pants"] = "새김무늬 가죽 바지",
		["Embossed Leather Vest"] = "새김무늬 가죽 조끼",
		["Enchanted Clefthoof Boots"] = "마력 깃든 갈래발굽 장화",
		["Enchanted Clefthoof Gloves"] = "마력 깃든 갈래발굽 장갑",
		["Enchanted Clefthoof Leggings"] = "마력 깃든 갈래발굽 다리보호구",
		["Enchanted Felscale Boots"] = "마력 깃든 지옥껍질 장화",
		["Enchanted Felscale Gloves"] = "마력 깃든 지옥껍질 장갑",
		["Enchanted Felscale Leggings"] = "마력 깃든 지옥껍질 다리보호구",
		["Feathered Breastplate"] = "깃털장식 흉갑",
		["Fel Leather Boots"] = "지옥 가죽 장화",
		["Fel Leather Gloves"] = "지옥 가죽 장갑",
		["Fel Leather Leggings"] = "지옥 가죽 다리보호구",
		["Felscale Boots"] = "지옥껍질 장화",
		["Felscale Breastplate"] = "지옥껍질 흉갑",
		["Felscale Gloves"] = "지옥껍질 장갑",
		["Felscale Pants"] = "지옥껍질 바지",
		["Felstalker Belt"] = "지옥추적자 허리띠",
		["Felstalker Bracer"] = "지옥추적자 팔보호구",
		["Felstalker Breastplate"] = "지옥추적자 흉갑",
		["Fine Leather Belt"] = "고급 가죽 허리띠",
		["Fine Leather Boots"] = "고급 가죽 장화",
		["Fine Leather Cloak"] = "고급 가죽 망토",
		["Fine Leather Gloves"] = "고급 가죽 장갑",
		["Fine Leather Pants"] = "고급 가죽 바지",
		["Fine Leather Tunic"] = "고급 가죽 튜닉",
		["Flame Armor Kit"] = "화염 방어구 키트",
		["Flamescale Belt"] = "화염비늘 허리띠",
		["Flamescale Boots"] = "화염비늘 장화",
		["Flamescale Leggings"] = "화염비늘 다리보호구",
		["Fletcher's Gloves"] = "활장이 장갑",
		["Frost Armor Kit"] = "냉기 방어구 키트",
		["Frost Leather Cloak"] = "서리 가죽 망토",
		["Frostsaber Boots"] = "눈호랑이 장화",
		["Frostsaber Gloves"] = "눈호랑이 장갑",
		["Frostsaber Leggings"] = "눈호랑이 다리보호구",
		["Frostsaber Tunic"] = "눈호랑이 튜닉",
		["Gauntlets of the Sea"] = "바다의 건틀릿",
		["Gem-studded Leather Belt"] = "보석박힌 가죽 허리띠",
		["Girdle of Insight"] = "통찰의 벨트",
		["Glove Reinforcements"] = "장갑 강화도구",
		["Gloves of the Greatfather"] = "겨울 할아버지 장갑",
		["Gloves of the Living Touch"] = "생명이 넘치는 손길의 장갑",
		["Golden Dragonstrike Breastplate"] = "황금 용쐐기 흉갑",
		["Golden Mantle of the Dawn"] = "여명의 황금 어깨보호대",
		["Greaves of Shackled Souls"] = "구속된 영혼의 경갑",
		["Green Dragonscale Breastplate"] = "녹색용비늘 흉갑",
		["Green Dragonscale Gauntlets"] = "녹색용비늘 건틀릿",
		["Green Dragonscale Leggings"] = "녹색용비늘 다리보호구",
		["Green Leather Armor"] = "녹색 가죽 갑옷",
		["Green Leather Belt"] = "녹색 가죽 허리띠",
		["Green Leather Bracers"] = "녹색 가죽 팔보호구",
		["Green Whelp Armor"] = "새끼 녹색용 갑옷",
		["Green Whelp Bracers"] = "새끼 녹색용 팔보호구",
		["Guardian Armor"] = "수호 갑옷",
		["Guardian Belt"] = "수호 허리띠",
		["Guardian Cloak"] = "수호 망토",
		["Guardian Gloves"] = "수호 장갑",
		["Guardian Leather Bracers"] = "수호 가죽 팔보호구",
		["Guardian Pants"] = "수호 바지",
		["Handstitched Leather Belt"] = "손바느질한 가죽 허리띠",
		["Handstitched Leather Boots"] = "손바느질한 가죽 장화",
		["Handstitched Leather Bracers"] = "손바느질한 가죽 팔보호구",
		["Handstitched Leather Cloak"] = "손바느질한 가죽 망토",
		["Handstitched Leather Pants"] = "손바느질한 가죽 바지",
		["Handstitched Leather Vest"] = "손바느질한 가죽 조끼",
		["Heavy Armor Kit"] = "고급 방어구 키트",
		["Heavy Clefthoof Boots"] = "질긴 갈래발굽 장화",
		["Heavy Clefthoof Leggings"] = "질긴 갈래발굽 다리보호구",
		["Heavy Clefthoof Vest"] = "질긴 갈래발굽 조끼",
		["Heavy Earthen Gloves"] = "두꺼운 대지의 장갑",
		["Heavy Knothide Armor Kit"] = "질긴 톱니매듭 가죽 방어구 키트",
		["Heavy Knothide Leather"] = "질긴 톱니매듭 가죽",
		["Heavy Leather Ammo Pouch"] = "질긴 가죽 탄약주머니",
		["Heavy Leather Ball"] = "무거운 가죽 공",
		["Heavy Leather"] = "질긴 가죽",
		["Heavy Quiver"] = "두꺼운 가죽 화살통",
		["Heavy Scorpid Belt"] = "두꺼운 전갈 허리띠",
		["Heavy Scorpid Bracers"] = "두꺼운 전갈 팔보호구",
		["Heavy Scorpid Gauntlets"] = "두꺼운 전갈 건틀릿",
		["Heavy Scorpid Helm"] = "두꺼운 전갈 투구",
		["Heavy Scorpid Leggings"] = "두꺼운 전갈 다리보호구",
		["Heavy Scorpid Shoulders"] = "두꺼운 전갈 어깨보호구",
		["Heavy Scorpid Vest"] = "두꺼운 전갈 조끼",
		["Helm of Fire"] = "불꽃의 투구",
		["Herbalist's Gloves"] = "약초채집가 장갑",
		["Hide of the Wild"] = "야생의 장막",
		["Hillman's Belt"] = "산악인의 허리띠",
		["Hillman's Cloak"] = "산악인의 망토",
		["Hillman's Leather Gloves"] = "산악인의 가죽 장갑",
		["Hillman's Leather Vest"] = "산악인의 가죽 조끼",
		["Hillman's Shoulders"] = "산악인의 어깨보호구",
		["Hood of Primal Life"] = "근원 생명의 두건",
		["Hurricane Boots"] = "폭풍우 장화",
		["Icy Scale Bracers"] = "얼어붙은 미늘 팔보호구",
		["Icy Scale Breastplate"] = "얼어붙은 미늘 흉갑",
		["Icy Scale Gauntlets"] = "얼어붙은 미늘 건틀릿",
		["Ironfeather Breastplate"] = "무쇠깃털 흉갑",
		["Ironfeather Shoulders"] = "무쇠깃털 어깨보호구",
		["Knothide Ammo Pouch"] = "코도가죽 탄약주머니",
		["Knothide Armor Kit"] = "톱니매듭 방어구 키트",
		["Knothide Leather"] = "톱니매듭 가죽",
		["Knothide Quiver"] = "코도가죽 화살통",
		["Kodo Hide Bag"] = "코도 가죽 자루",
		["Lava Belt"] = "용암 허리띠",
		["Leatherworker's Satchel"] = "가죽세공인의 가방",
		["Light Armor Kit"] = "작은 방어구 키트",
		["Light Leather Bracers"] = "얇은 가죽 팔보호구",
		["Light Leather Pants"] = "얇은 가죽 바지",
		["Light Leather Quiver"] = "얇은 가죽 화살통",
		["Light Leather"] = "얇은 가죽",
		["Living Breastplate"] = "살아있는 흉갑",
		["Living Crystal Breastplate"] = "생명의 수정 흉갑",
		["Living Dragonscale Helm"] = "생명의 용비늘 투구",
		["Living Earth Bindings"] = "살아있는 대지의 손목띠",
		["Living Earth Shoulders"] = "살아있는 대지의 어깨보호구",
		["Living Leggings"] = "살아있는 다리보호구",
		["Living Shoulders"] = "살아있는 어깨보호구",
		["Magister's Armor Kit"] = "마법학자의 방어구 키트",
		["Medium Armor Kit"] = "일반 방어구 키트",
		["Medium Leather"] = "일반 가죽",
		["Might of the Timbermaw"] = "나무구렁일족의 힘",
		["Molten Belt"] = "작열의 허리띠",
		["Molten Helm"] = "화산 투구",
		["Mongoose Boots"] = "살쾡이 장화",
		["Monsoon Belt"] = "계절풍 허리띠",
		["Moonglow Vest"] = "달빛 조끼",
		["Murloc Scale Belt"] = "멀록 비늘 허리띠",
		["Murloc Scale Bracers"] = "멀록 비늘 팔보호구",
		["Murloc Scale Breastplate"] = "멀록 비늘 흉갑",
		["Nature Armor Kit"] = "자연 방어구 키트",
		["Nethercleft Leg Armor"] = "황천의 갈래 다리 방어구 강화 키트",
		["Nethercobra Leg Armor"] = "황천의 코브라 다리 방어구 강화 키트",
		["Netherdrake Gloves"] = "황천의 비룡 장갑",
		["Netherdrake Helm"] = "황천의 비룡 투구",
		["Netherfury Belt"] = "황천의 격노 허리띠",
		["Netherfury Boots"] = "황천의 격노 장화",
		["Netherfury Leggings"] = "황천의 격노 다리보호구",
		["Netherscale Ammo Pouch"] = "황천비늘 탄약주머니",
		["Netherstrike Belt"] = "황천쐐기 허리띠",
		["Netherstrike Bracers"] = "황천쐐기 팔보호구",
		["Netherstrike Breastplate"] = "황천쐐기 흉갑",
		["Nightscape Boots"] = "밤하늘 장화",
		["Nightscape Headband"] = "밤하늘 머리띠",
		["Nightscape Pants"] = "밤하늘 바지",
		["Nightscape Shoulders"] = "밤하늘 어깨보호구",
		["Nightscape Tunic"] = "밤하늘 튜닉",
		["Nimble Leather Gloves"] = "민첩의 가죽 장갑",
		["Onyxia Scale Cloak"] = "오닉시아 비늘 망토",
		["Pilferer's Gloves"] = "좀도둑 장갑",
		["Polar Bracers"] = "북극의 팔보호구",
		["Polar Gloves"] = "북극의 장갑",
		["Polar Tunic"] = "북극의 튜닉",
		["Primal Batskin Bracers"] = "원시 박쥐가죽 팔보호구",
		["Primal Batskin Gloves"] = "원시 박쥐가죽 장갑",
		["Primal Batskin Jerkin"] = "원시 박쥐가죽 웃옷",
		["Primalstorm Breastplate"] = "원소폭풍 흉갑",
		["Primalstrike Belt"] = "원소쐐기 허리띠",
		["Primalstrike Bracers"] = "원소쐐기 팔보호구",
		["Primalstrike Vest"] = "원소쐐기 조끼",
		["Quickdraw Quiver"] = "속사 화살통",
		["Quiver of a Thousand Feathers"] = "천 개의 깃털 화살통",
		["Raptor Hide Belt"] = "랩터 가죽 허리띠",
		["Raptor Hide Harness"] = "랩터 가죽 멜빵",
		["Red Dragonscale Breastplate"] = "붉은용비늘 흉갑",
		["Red Whelp Gloves"] = "새끼 붉은용 장갑",
		["Redeemed Soul Cinch"] = "구원된 영혼의 허리띠",
		["Redeemed Soul Legguards"] = "구원된 영혼의 다리보호대",
		["Redeemed Soul Moccasins"] = "구원된 영혼의 장화",
		["Redeemed Soul Wristguards"] = "구원된 영혼의 손목보호구",
		["Reinforced Mining Bag"] = "강화된 채광용 자루",
		["Riding Crop"] = "말채찍",
		["Rugged Armor Kit"] = "튼튼한 방어구 키트",
		["Rugged Leather Pants"] = "튼튼한 가죽 바지",
		["Rugged Leather"] = "튼튼한 가죽",
		["Runic Leather Armor"] = "룬문자 가죽 갑옷",
		["Runic Leather Belt"] = "룬문자 가죽 허리띠",
		["Runic Leather Bracers"] = "룬문자 가죽 팔보호구",
		["Runic Leather Gauntlets"] = "룬문자 가죽 건틀릿",
		["Runic Leather Headband"] = "룬문자 가죽 머리띠",
		["Runic Leather Pants"] = "룬문자 가죽 바지",
		["Runic Leather Shoulders"] = "룬문자 가죽 어깨보호구",
		["Sandstalker Bracers"] = "모래추적자 팔보호구",
		["Sandstalker Breastplate"] = "모래추적자 흉갑",
		["Sandstalker Gauntlets"] = "모래추적자 건틀릿",
		["Scaled Draenic Boots"] = "드레나이 미늘 장화",
		["Scaled Draenic Gloves"] = "드레나이 미늘 장갑",
		["Scaled Draenic Pants"] = "드레나이 미늘 바지",
		["Scaled Draenic Vest"] = "드레나이 미늘 조끼",
		["Shadow Armor Kit"] = "암흑 방어구 키트",
		["Shadowprowler's Chestguard"] = "그림자늑대의 가슴보호구",
		["Shadowskin Gloves"] = "암흑가죽 장갑",
		["Shifting Cloak"] = "변화의 망토",
		["Shoulderpads of Renewed Life"] = "새로운 삶의 어깨보호구",
		["Shoulders of Lightning Reflexes"] = "번개같은 반사 신경의 어깨보호구",
		["Small Leather Ammo Pouch"] = "작은 가죽 탄약주머니",
		["Spitfire Bracers"] = "독송곳니 팔보호구",
		["Spitfire Breastplate"] = "독송곳니 흉갑",
		["Spitfire Gauntlets"] = "독송곳니 건틀릿",
		["Stormshroud Armor"] = "폭풍안개 갑옷",
		["Stormshroud Gloves"] = "폭풍안개 장갑",
		["Stormshroud Pants"] = "폭풍안개 바지",
		["Stormshroud Shoulders"] = "폭풍안개 어깨보호구",
		["Stylin' Adventure Hat"] = "근사한 모험가 모자",
		["Stylin' Crimson Hat"] = "근사한 진홍색 모자",
		["Stylin' Jungle Hat"] = "근사한 밀림 모자",
		["Stylin' Purple Hat"] = "근사한 보라색 모자",
		["Swift Boots"] = "신속의 장화",
		["Swift Flight Bracers"] = "날쌘비행 팔보호구",
		["Swiftstrike Bracers"] = "재빠른 일격의 팔보호구",
		["Swiftstrike Shoulders"] = "재빠른 일격의 어깨보호구",
		["Thick Armor Kit"] = "두꺼운 방어구 키트",
		["Thick Draenic Boots"] = "두꺼운 드레나이 장화",
		["Thick Draenic Gloves"] = "두꺼운 드레나이 장갑",
		["Thick Draenic Pants"] = "두꺼운 드레나이 바지",
		["Thick Draenic Vest"] = "두꺼운 드레나이 조끼",
		["Thick Leather Ammo Pouch"] = "두꺼운 가죽 탄약주머니",
		["Thick Leather"] = "두꺼운 가죽",
		["Thick Murloc Armor"] = "두꺼운 멀록비늘 갑옷",
		["Thick Netherscale Breastplate"] = "두꺼운 황천비늘 흉갑",
		["Timbermaw Brawlers"] = "나무구렁일족 장갑",
		["Tough Scorpid Boots"] = "단단한 전갈 장화",
		["Tough Scorpid Bracers"] = "단단한 전갈 팔보호구",
		["Tough Scorpid Breastplate"] = "단단한 전갈 흉갑",
		["Tough Scorpid Gloves"] = "단단한 전갈 장갑",
		["Tough Scorpid Helm"] = "단단한 전갈 투구",
		["Tough Scorpid Leggings"] = "단단한 전갈 다리보호구",
		["Tough Scorpid Shoulders"] = "단단한 전갈 어깨보호구",
		["Toughened Leather Armor"] = "경화 가죽 갑옷",
		["Toughened Leather Gloves"] = "경화 가죽 장갑",
		["Turtle Scale Bracers"] = "거북 껍질 팔보호구",
		["Turtle Scale Breastplate"] = "거북 껍질 흉갑",
		["Turtle Scale Gloves"] = "거북 껍질 장갑",
		["Turtle Scale Helm"] = "거북 껍질 투구",
		["Turtle Scale Leggings"] = "거북 껍질 다리보호구",
		["Vindicator's Armor Kit"] = "구원자의 방어구 키트",
		["Volcanic Breastplate"] = "화산 흉갑",
		["Volcanic Leggings"] = "화산 다리보호구",
		["Volcanic Shoulders"] = "화산 어깨보호구",
		["Waistguard of Shackled Souls"] = "구속된 영혼의 허리보호대",
		["Warbear Harness"] = "전투곰 멜빵",
		["Warbear Woolies"] = "전투곰 다리보호구",
		["White Leather Jerkin"] = "흰색 가죽 웃옷",
		["Wicked Leather Armor"] = "악의의 가죽 갑옷",
		["Wicked Leather Belt"] = "악의의 가죽 허리띠",
		["Wicked Leather Bracers"] = "악의의 가죽 팔보호구",
		["Wicked Leather Gauntlets"] = "악의의 가죽 건틀릿",
		["Wicked Leather Headband"] = "악의의 가죽 머리띠",
		["Wicked Leather Pants"] = "악의의 가죽 바지",
		["Wild Draenish Boots"] = "야생의 드레나이 장화",
		["Wild Draenish Gloves"] = "야생의 드레나이 장갑",
		["Wild Draenish Leggings"] = "야생의 드레나이 다리보호구",
		["Wild Draenish Vest"] = "야생의 드레나이 조끼",
		["Wild Leather Boots"] = "야생 가죽 장화",
		["Wild Leather Cloak"] = "야생 가죽 망토",
		["Wild Leather Helmet"] = "야생 가죽 투구",
		["Wild Leather Leggings"] = "야생 가죽 다리보호구",
		["Wild Leather Shoulders"] = "야생 가죽 어깨보호구",
		["Wild Leather Vest"] = "야생 가죽 조끼",
		["Wildfeather Leggings"] = "바람깃털 다리보호구",
		["Windhawk Belt"] = "바람매 허리띠",
		["Windhawk Bracers"] = "바람매 팔보호구",
		["Windhawk Hauberk"] = "바람매 갑옷",
		["Windscale Hood"] = "바람비늘 두건",
		["Windslayer Wraps"] = "바람의 학살자 장갑",
		["Windstrike Gloves"] = "바람쐐기 장갑",
		["Winter Boots"] = "겨울 장화",
		["Wolfshead Helm"] = "늑대머리 투구",
		["Leather Gauntlets of the Sun"] = "태양의 가죽 건틀릿",
		["Leather Chestguard of the Sun"] = "태양의 가죽 흉갑",
		["Fletcher's Gloves of the Phoenix"] = "불사조의 활장이 장갑",
		["Embrace of the Phoenix"] = "불사조의 은총",
		["Sun-Drenched Scale Gloves"] = "태양빛에 물든 미늘 장갑",
		["Sun-Drenched Scale Chestguard"] = "태양빛에 물든 흉갑",
		["Carapace of Sun and Shadow"] = "해그림자 갑옷",
		["Gloves of Immortal Dusk"] = "불멸의 그늘 장갑",

-- Smelting Recipes
		["Earth Shatter"] = "대지의 근원을 티끌로",
		["Fire Sunder"] = "불의 근원을 티끌로",
		["Smelt Adamantite"] = "아다만타이트 제련",
		["Smelt Bronze"] = "청동 제련",
		["Smelt Copper"] = "구리 제련",
		["Smelt Dark Iron"] = "검은무쇠 제련",
		["Smelt Elementium"] = "엘레멘티움 제련",
		["Smelt Eternium"] = "이터늄 제련",
		["Smelt Fel Iron"] = "지옥무쇠 제련",
		["Smelt Felsteel"] = "지옥강철 제련",
		["Smelt Gold"] = "금 제련",
		["Smelt Hardened Adamantite"] = "강화된 아다만타이트 제련",
		["Smelt Hardened Khorium"] = "강화된 코륨 제련",
		["Smelt Iron"] = "철 제련",
		["Smelt Khorium"] = "코륨 제련",
		["Smelt Mithril"] = "미스릴 제련",
		["Smelt Silver"] = "은 제련",
		["Smelt Steel"] = "강철 제련",
		["Smelt Thorium"] = "토륨 제련",
		["Smelt Tin"] = "주석 제련",
		["Smelt Truesilver"] = "진은 제련",

-- Rogue Poison Recipes
		["Anesthetic Poison"] = "정신 마취 독",
		["Blinding Powder"] = "실명 가루",
		["Crippling Poison II"] = "신경 마비 독 II",
		["Crippling Poison"] = "신경 마비 독",
		["Deadly Poison II"] = "맹독 II",
		["Deadly Poison III"] = "맹독 III",
		["Deadly Poison IV"] = "맹독 IV",
		["Deadly Poison V"] = "맹독 V",
		["Deadly Poison VI"] = "맹독 VI",
		["Deadly Poison VII"] = "맹독 VII",
		["Deadly Poison"] = "맹독",
		["Instant Poison II"] = "순간 효과 독 II",
		["Instant Poison III"] = "순간 효과 독 III",
		["Instant Poison IV"] = "순간 효과 독 IV",
		["Instant Poison V"] = "순간 효과 독 V",
		["Instant Poison VI"] = "순간 효과 독 VI",
		["Instant Poison VII"] = "순간 효과 독 VII",
		["Instant Poison"] = "순간 효과 독",
		["Mind-numbing Poison II"] = "정신 마비 독 II",
		["Mind-numbing Poison III"] = "정신 마비 독 III",
		["Mind-numbing Poison"] = "정신 마비 독",
		["Wound Poison II"] = "상처 감염 독 II",
		["Wound Poison III"] = "상처 감염 독 III",
		["Wound Poison IV"] = "상처 감염 독 IV",
		["Wound Poison V"] = "상처 감염 독 V",
		["Wound Poison"] = "상처 감염 독",

-- Tailoring Recipes
		["Admiral's Hat"] = "함대사령관 모자",
		["Arcanoweave Boots"] = "비전매듭 장화",
		["Arcanoweave Bracers"] = "비전매듭 팔보호구",
		["Arcanoweave Robe"] = "비전매듭 로브",
		["Argent Boots"] = "은빛 여명회 장화",
		["Argent Shoulders"] = "은빛 여명회 어깨보호구",
		["Azure Shoulders"] = "감청색 어깨보호구",
		["Azure Silk Belt"] = "감청색 비단 허리띠",
		["Azure Silk Cloak"] = "감청색 비단 망토",
		["Azure Silk Gloves"] = "감청색 비단 장갑",
		["Azure Silk Hood"] = "감청색 비단 두건",
		["Azure Silk Pants"] = "감청색 비단 바지",
		["Azure Silk Vest"] = "감청색 비단 조끼",
		["Bag of Jewels"] = "보석 자루",
		["Barbaric Linen Vest"] = "야만전사의 리넨 조끼",
		["Battlecast Hood"] = "전투시전술 두건",
		["Battlecast Pants"] = "전투시전술 바지",
		["Belt of Blasting"] = "발파의 허리띠",
		["Belt of the Archmage"] = "대마법사의 허리띠",
		["Belt of the Long Road"] = "긴 여정의 허리띠",
		["Big Bag of Enchantment"] = "큰 마법용품 가방",
		["Black Belt of Knowledge"] = "지식의 검은 허리띠",
		["Black Mageweave Boots"] = "검은 마법매듭 장화",
		["Black Mageweave Gloves"] = "검은 마법매듭 장갑",
		["Black Mageweave Headband"] = "검은 마법매듭 머리띠",
		["Black Mageweave Leggings"] = "검은 마법매듭 다리보호구",
		["Black Mageweave Robe"] = "검은 마법매듭 로브",
		["Black Mageweave Shoulders"] = "검은 마법매듭 어깨보호구",
		["Black Mageweave Vest"] = "검은 마법매듭 조끼",
		["Black Silk Pack"] = "검은색 비단 배낭",
		["Black Swashbuckler's Shirt"] = "검은색 모험가 셔츠",
		["Blackstrike Bracers"] = "검은 강타의 팔보호구",
		["Bloodvine Boots"] = "붉은덩굴 장화",
		["Bloodvine Leggings"] = "붉은덩굴 다리보호구",
		["Bloodvine Vest"] = "붉은덩굴 조끼",
		["Blue Linen Robe"] = "파란색 리넨 로브",
		["Blue Linen Shirt"] = "파란색 리넨 셔츠",
		["Blue Linen Vest"] = "파란색 리넨 조끼",
		["Blue Overalls"] = "파란색 작업복",
		["Bolt of Imbued Netherweave"] = "마력 깃든 황천매듭 두루마리",
		["Bolt of Linen Cloth"] = "리넨 두루마리",
		["Bolt of Mageweave"] = "마법 두루마리",
		["Bolt of Netherweave"] = "황천매듭 두루마리",
		["Bolt of Runecloth"] = "룬무늬 두루마리",
		["Bolt of Silk Cloth"] = "비단 두루마리",
		["Bolt of Soulcloth"] = "영혼매듭 두루마리",
		["Bolt of Woolen Cloth"] = "양모 두루마리",
		["Boots of Blasting"] = "발파의 장화",
		["Boots of the Enchanter"] = "마술사의 장화",
		["Boots of the Long Road"] = "긴 여정의 장화",
		["Bottomless Bag"] = "무한의 가방",
		["Bracers of Havok"] = "대혼란의 팔보호구",
		["Bracers of Nimble Thought"] = "기민한 사고의 팔보호구",
		["Bright Yellow Shirt"] = "밝은 노란색 셔츠",
		["Brightcloth Cloak"] = "빛매듭 망토",
		["Brightcloth Gloves"] = "빛매듭 장갑",
		["Brightcloth Pants"] = "빛매듭 바지",
		["Brightcloth Robe"] = "빛매듭 로브",
		["Brown Linen Pants"] = "갈색 리넨 바지",
		["Brown Linen Robe"] = "갈색 리넨 로브",
		["Brown Linen Shirt"] = "갈색 리넨 셔츠",
		["Brown Linen Vest"] = "갈색 리넨 조끼",
		["Cenarion Herb Bag"] = "세나리온 약초 가방",
		["Cindercloth Boots"] = "불매듭 장화",
		["Cindercloth Cloak"] = "불매듭 망토",
		["Cindercloth Gloves"] = "불매듭 장갑",
		["Cindercloth Pants"] = "불매듭 바지",
		["Cindercloth Robe"] = "불매듭 로브",
		["Cindercloth Vest"] = "불매듭 조끼",
		["Cloak of Arcane Evasion"] = "비전 회피의 망토",
		["Cloak of Eternity"] = "영원의 망토",
		["Cloak of Fire"] = "불의 망토",
		["Cloak of the Black Void"] = "검은 공허의 망토",
		["Cloak of Warding"] = "수호의 망토",
		["Colorful Kilt"] = "붉은색 킬트",
		["Core Felcloth Bag"] = "화산핵 지옥매듭 가방",
		["Crimson Silk Belt"] = "심홍색 비단 허리띠",
		["Crimson Silk Cloak"] = "심홍색 비단 망토",
		["Crimson Silk Gloves"] = "심홍색 비단 장갑",
		["Crimson Silk Pantaloons"] = "심홍색 비단 바지",
		["Crimson Silk Robe"] = "심홍색 비단 로브",
		["Crimson Silk Shoulders"] = "심홍색 비단 어깨보호구",
		["Crimson Silk Vest"] = "심홍색 비단 조끼",
		["Dark Silk Shirt"] = "암색 비단 셔츠",
		["Double-stitched Woolen Shoulders"] = "이중 양모 어깨보호구",
		["Dreamweave Circlet"] = "꿈매듭 머리장식",
		["Dreamweave Gloves"] = "꿈매듭 장갑",
		["Dreamweave Vest"] = "꿈매듭 조끼",
		["Earthen Silk Belt"] = "대지의 비단 허리띠",
		["Earthen Vest"] = "대지의 조끼",
		["Ebon Shadowbag"] = "칠흑의 암흑 가방",
		["Enchanted Mageweave Pouch"] = "마력 깃든 마법매듭 가방",
		["Enchanted Runecloth Bag"] = "마력 깃든 룬매듭 가방",
		["Enchanter's Cowl"] = "마술사의 두건",
		["Felcloth Bag"] = "지옥매듭 가방",
		["Felcloth Boots"] = "지옥매듭 장화",
		["Felcloth Gloves"] = "지옥매듭 장갑",
		["Felcloth Hood"] = "지옥매듭 두건",
		["Felcloth Pants"] = "지옥매듭 바지",
		["Felcloth Robe"] = "지옥매듭 로브",
		["Felcloth Shoulders"] = "지옥매듭 어깨보호구",
		["Festival Dress"] = "축제 드레스",
		--["Festive Red Dress"] = "Festive Red Dress", doesn't exist?
		["Festive Red Pant Suit"] = "빨간색 축제 의상",
		["Flameheart Bracers"] = "화염심장 팔보호구",
		["Flameheart Gloves"] = "화염심장 장갑",
		["Flameheart Vest"] = "화염심장 조끼",
		["Flarecore Gloves"] = "화염핵 장갑",
		["Flarecore Leggings"] = "화염핵 다리보호구",
		["Flarecore Mantle"] = "화염핵 어깨보호대",
		["Flarecore Robe"] = "화염핵 로브",
		["Flarecore Wraps"] = "화염핵 손목띠",
		["Formal White Shirt"] = "흰색 정장 셔츠",
		["Frostweave Gloves"] = "서리매듭 장갑",
		["Frostweave Pants"] = "서리매듭 바지",
		["Frostweave Robe"] = "서리매듭 로브",
		["Frostweave Tunic"] = "서리매듭 튜닉",
		["Frozen Shadoweave Boots"] = "얼어붙은 그림자매듭 장화",
		["Frozen Shadoweave Shoulders"] = "얼어붙은 그림자매듭 어깨보호구",
		["Frozen Shadoweave Robe"] = "얼어붙은 그림자매듭 로브",
		["Gaea's Embrace"] = "가이아의 은총",
		["Ghostweave Belt"] = "유령매듭 허리띠",
		["Ghostweave Gloves"] = "유령매듭 장갑",
		["Ghostweave Pants"] = "유령매듭 바지",
		["Ghostweave Vest"] = "유령매듭 조끼",
		["Girdle of Ruination"] = "몰락의 벨트",
		["Glacial Cloak"] = "빙하의 망토",
		["Glacial Gloves"] = "빙하의 장갑",
		["Glacial Vest"] = "빙하의 조끼",
		["Glacial Wrists"] = "빙하의 손목보호대",
		["Gloves of Meditation"] = "명상의 장갑",
		["Gloves of Spell Mastery"] = "주문 전문화 장갑",
		["Golden Spellthread"] = "마력의 황금 실타래",
		["Gordok Ogre Suit"] = "고르독 오우거 위장복",
		["Gray Woolen Robe"] = "회색 양모 로브",
		["Gray Woolen Shirt"] = "회색 양모 셔츠",
		["Greater Adept's Robe"] = "상급사제용 로브",
		["Green Holiday Shirt"] = "녹색 축제일 셔츠",
		["Green Linen Bracers"] = "녹색 리넨 팔보호구",
		["Green Linen Shirt"] = "녹색 리넨 셔츠",
		["Green Silk Armor"] = "녹색 비단 갑옷",
		["Green Silk Pack"] = "녹색 비단 배낭",
		["Green Silken Shoulders"] = "녹색 비단 어깨보호구",
		["Green Winter Clothes"] = "초록색 겨울 의복",
		["Green Woolen Bag"] = "녹색 양모 자루",
		["Green Woolen Vest"] = "녹색 양모 조끼",
		["Hands of Darkness"] = "암흑의 장갑",
		["Handstitched Linen Britches"] = "손바느질한 리넨 바지",
		["Heavy Linen Gloves"] = "질긴 리넨 장갑",
		["Heavy Woolen Cloak"] = "두꺼운 양모 망토",
		["Heavy Woolen Gloves"] = "두꺼운 양모 장갑",
		["Heavy Woolen Pants"] = "질긴 양모 바지",
		["Icy Cloak"] = "얼음 망토",
		["Imbued Netherweave Bag"] = "마력 깃든 황천매듭 가방",
		["Imbued Netherweave Boots"] = "마력 깃든 황천매듭 장화",
		["Imbued Netherweave Pants"] = "마력 깃든 황천매듭 바지",
		["Imbued Netherweave Robe"] = "마력 깃든 황천매듭 로브",
		["Imbued Netherweave Tunic"] = "마력 깃든 황천매듭 튜닉",
		["Inferno Gloves"] = "지옥불 장갑",
		["Lavender Mageweave Shirt"] = "연보라색 마법매듭 셔츠",
		["Lesser Wizard's Robe"] = "견습마술사 로브",
		["Linen Bag"] = "리넨 가방",
		["Linen Belt"] = "리넨 허리띠",
		["Linen Boots"] = "리넨 장화",
		["Linen Cloak"] = "리넨 망토",
		["Long Silken Cloak"] = "긴 비단 망토",
		["Mageweave Bag"] = "마법매듭 가방",
		["Manaweave Cloak"] = "마나매듭 망토",
		["Mantle of Nimble Thought"] = "기민한 사고의 어깨보호대",
		["Mantle of the Timbermaw"] = "나무구렁일족 어깨보호대",
		["Mooncloth Bag"] = "달빛매듭 가방",
		["Mooncloth Boots"] = "달빛매듭 장화",
		["Mooncloth Circlet"] = "달빛매듭 머리장식",
		["Mooncloth Gloves"] = "달빛매듭 장갑",
		["Mooncloth Leggings"] = "달빛매듭 다리보호구",
		["Mooncloth Robe"] = "달빛매듭 로브",
		["Mooncloth Shoulders"] = "달빛매듭 어깨보호구",
		["Mooncloth Vest"] = "달빛매듭 조끼",
		["Mooncloth"] = "달빛 옷감",
		["Mystic Spellthread"] = "신비한 마력의 실타래",
		["Netherweave Bag"] = "황천매듭 가방",
		["Netherweave Belt"] = "황천매듭 허리띠",
		["Netherweave Boots"] = "황천매듭 장화",
		["Netherweave Bracers"] = "황천매듭 팔보호구",
		["Netherweave Gloves"] = "황천매듭 장갑",
		["Netherweave Net"] = "황천매듭 그물",
		["Netherweave Pants"] = "황천매듭 바지",
		["Netherweave Robe"] = "황천매듭 로브",
		["Netherweave Tunic"] = "황천매듭 튜닉",
		["Night's End"] = "밤의 끝자락",
		["Orange Mageweave Shirt"] = "주황색 마법매듭 셔츠",
		["Orange Martial Shirt"] = "주황색 무도복",
		["Pearl-clasped Cloak"] = "진주장식 망토",
		["Phoenix Gloves"] = "불사조 장갑",
		["Phoenix Pants"] = "불사조 바지",
		["Pink Mageweave Shirt"] = "분홍색 마법매듭 셔츠",
		["Primal Mooncloth Bag"] = "태초의 달빛매듭 가방",
		["Primal Mooncloth Belt"] = "태초의 달빛매듭 허리띠",
		["Primal Mooncloth Robe"] = "태초의 달빛매듭 로브",
		["Primal Mooncloth Shoulders"] = "태초의 달빛매듭 어깨보호대",
		["Primal Mooncloth"] = "태초의 달빛 옷감",
		["Red Linen Bag"] = "빨간 리넨 가방",
		["Red Linen Robe"] = "붉은색 리넨 로브",
		["Red Linen Shirt"] = "붉은색 리넨 셔츠",
		["Red Linen Vest"] = "붉은색 리넨 조끼",
		["Red Mageweave Bag"] = "빨간색 마법매듭 가방",
		["Red Mageweave Gloves"] = "붉은 마법매듭 장갑",
		["Red Mageweave Headband"] = "붉은 마법매듭 머리띠",
		["Red Mageweave Pants"] = "붉은 마법매듭 바지",
		["Red Mageweave Shoulders"] = "붉은 마법매듭 어깨보호구",
		["Red Mageweave Vest"] = "붉은 마법매듭 조끼",
		["Red Swashbuckler's Shirt"] = "붉은색 모험가 셔츠",
		["Red Woolen Bag"] = "붉은색 양모 자루",
		["Red Woolen Boots"] = "붉은색 양모 장화",
		["Reinforced Linen Cape"] = "질긴 리넨 단망토",
		["Red Winter Clothes"] = "붉은색 겨울 의복",
		["Reinforced Woolen Shoulders"] = "질긴 양모 어깨보호구",
		["Resolute Cape"] = "결의의 외투",
		["Rich Purple Silk Shirt"] = "진보라색 비단 셔츠",
		["Robe of Power"] = "마력의 로브",
		["Robe of the Archmage"] = "대마법사의 로브",
		["Robe of the Void"] = "공허의 로브",
		["Robe of Winter Night"] = "겨울밤의 로브",
		["Robes of Arcana"] = "아카나의 로브",
		["Runecloth Bag"] = "룬매듭 가방",
		["Runecloth Belt"] = "룬매듭 허리띠",
		["Runecloth Boots"] = "룬매듭 장화",
		["Runecloth Cloak"] = "룬매듭 망토",
		["Runecloth Gloves"] = "룬매듭 장갑",
		["Runecloth Headband"] = "룬매듭 머리띠",
		["Runecloth Pants"] = "룬매듭 바지",
		["Runecloth Robe"] = "룬매듭 로브",
		["Runecloth Shoulders"] = "룬매듭 어깨보호구",
		["Runecloth Tunic"] = "룬매듭 튜닉",
		["Runed Stygian Belt"] = "저승의 룬매듭 허리띠",
		["Runed Stygian Boots"] = "저승의 룬매듭 장화",
		["Runed Stygian Leggings"] = "저승의 룬매듭 다리보호구",
		["Runic Spellthread"] = "마력의 룬문자 실타래",
		["Satchel of Cenarius"] = "세나리우스의 주머니",
		["Shadow Hood"] = "그림자 두건",
		["Shadowcloth"] = "어둠 깃든 옷감",
		["Shadoweave Boots"] = "그림자매듭 장화",
		["Shadoweave Gloves"] = "그림자매듭 장갑",
		["Shadoweave Mask"] = "그림자매듭 복면",
		["Shadoweave Pants"] = "그림자매듭 바지",
		["Shadoweave Robe"] = "그림자매듭 로브",
		["Shadoweave Shoulders"] = "그림자매듭 어깨보호구",
		["Silk Headband"] = "비단 머리띠",
		["Silver Spellthread"] = "마력의 은 실타래",
		["Simple Black Dress"] = "수수한 검은색 드레스",
		["Simple Dress"] = "수수한 드레스",
		["Simple Kilt"] = "수수한 킬트",
		["Simple Linen Boots"] = "수수한 리넨 장화",
		["Simple Linen Pants"] = "수수한 리넨 바지",
		["Small Silk Pack"] = "작은 비단 배낭",
		["Soft-soled Linen Boots"] = "부드러운 리넨 장화",
		["Soul Pouch"] = "영혼의 주머니",
		["Soulcloth Gloves"] = "영혼매듭 장갑",
		["Soulcloth Shoulders"] = "영혼매듭 어깨보호구",
		["Soulcloth Vest"] = "영혼매듭 조끼",
		["Soulguard Bracers"] = "영혼의 수호자 팔보호구",
		["Soulguard Girdle"] = "영혼의 수호자 벨트",
		["Soulguard Leggings"] = "영혼의 수호자 다리보호구",
		["Soulguard Slippers"] = "영혼의 수호자 덧신",
		["Spellcloth"] = "마력 깃든 옷감",
		["Spellfire Bag"] = "마법불꽃 가방",
		["Spellfire Belt"] = "마법불꽃 허리띠",
		["Spellfire Gloves"] = "마법불꽃 장갑",
		["Spellfire Robe"] = "마법불꽃 로브",
		["Spellstrike Hood"] = "마법 강타의 두건",
		["Spellstrike Pants"] = "마법 강타의 바지",
		["Spider Belt"] = "거미줄 허리띠",
		["Spider Silk Slippers"] = "거미줄 슬리퍼",
		["Spidersilk Boots"] = "거미줄 장화",
		["Star Belt"] = "별장식 허리띠",
		["Stylish Blue Shirt"] = "세련된 파란색 셔츠",
		["Stylish Green Shirt"] = "세련된 녹색 셔츠",
		["Stylish Red Shirt"] = "세련된 붉은색 셔츠",
		["Swiftheal Mantle"] = "신속한 치유의 어깨보호대",
		["Swiftheal Wraps"] = "신속한 치유의 손목끈",
		["Sylvan Crown"] = "숲의 관",
		["Sylvan Shoulders"] = "숲의 어깨보호구",
		["Sylvan Vest"] = "숲의 조끼",
		["Truefaith Gloves"] = "신앙의 장갑",
		["Truefaith Vestments"] = "신앙의 예복",
		["Tuxedo Jacket"] = "턱시도 재킷",
		["Tuxedo Pants"] = "턱시도 바지",
		["Tuxedo Shirt"] = "턱시도 셔츠",
		["Unyielding Bracers"] = "불굴의 팔보호구",
		["Unyielding Girdle"] = "불굴의 벨트",
		["Vengeance Wrap"] = "복수의 외투",
		["White Bandit Mask"] = "하얀 산적 복면",
		["White Linen Robe"] = "흰색 리넨 로브",
		["White Linen Shirt"] = "흰색 리넨 셔츠",
		["White Remedy Cape"] = "백색 치유의 외투",
		["White Swashbuckler's Shirt"] = "흰색 모험가 셔츠",
		["White Wedding Dress"] = "하얀 웨딩드레스",
		["White Woolen Dress"] = "흰색 양모 드레스",
		["Whitemend Hood"] = "백마법 두건",
		["Whitemend Pants"] = "백마법 바지",
		["Wisdom of the Timbermaw"] = "나무구렁일족의 지혜",
		["Wizardweave Leggings"] = "마술매듭 다리보호구",
		["Wizardweave Robe"] = "마술매듭 로브",
		["Wizardweave Turban"] = "마술매듭 터번",
		["Woolen Bag"] = "양모 자루",
		["Woolen Boots"] = "양모 장화",
		["Woolen Cape"] = "양모 단망토",
		["Sunfire Robe"] = "태양불꽃 로브",
		["Sunfire Handwraps"] = "태양불꽃 장갑",
		["Robe of Eternal Light"] = "영원한 빛의 로브",
		["Hands of Eternal Light"] = "영원한 빛의 장갑",
	}
end)

BabbleTradeskill:RegisterTranslations("esES", function()
	return {
-- Gathering skills
		["Disenchant"] = "Desencantar",
		["Fishing"] = "Pesca",
		["Herbalism"] = "Herboristería",
		["Mining"] = "Minería",
		["Pick Pocket"] = "Robar",
		["Prospecting"] = "Prospección",
		["Skinning"] = "Desuello",
		["Smelting"] = "Fundición",
		["Riding"] = "Equitación",

-- Crafting skills
		["Alchemy"] = "Alquimia",
		["Armorsmith"] = "Forjador de armaduras", -- check
		["Blacksmithing"] = "Herrería",
		["Cooking"] = "Cocina",
		["Dragonscale Leatherworking"] = "Peletería dragontina", -- check
		["Elemental Leatherworking"] = "Peletería elemental", -- check
		["Elixir Master"] = "Maestro de elixires", -- check
		["Enchanting"] = "Encantamiento",
		["Engineering"] = "Ingeniería",
		["First Aid"] = "Primeros auxilios",
		["Gnomish Engineering"] = "Ingeniería gnomica",
		["Goblin Engineering"] = "Ingeniería goblin",
		["Gnomish Engineer"] = "Ingeniería gnomica",
		["Goblin Engineer"] = "Ingeniería goblin",
		["Jewelcrafting"] = "Joyería",
		["Leatherworking"] = "Peletería",
		["Master Axesmith"] = "Forjador de hachas",
		["Master Hammersmith"] = "Forjador de martillos", -- check
		["Master Swordsmith"] = "Forjador de espadas", -- check
		["Mooncloth Tailoring"] = "Sastrería con tela lunar",
		["Poisons"] = "Venenos",
		["Potion Master"] = "Maestro de pociones", -- check
		["Shadoweave Tailoring"] = "Sastrería con tejido de Sombras",
		["Spellfire Tailoring"] = "Sastrería con fuego de hechizo",
		["Tailoring"] = "Sastrería",
		["Transmutation Master"] = "Maestro de transmutación", -- check
		["Tribal Leatherworking"] = "Peletería tribal", -- check
		["Weaponsmith"] = "Forjador de armas", -- check

-- Alchemy Recipes
		["Adept's Elixir"] = "Elixir de adepto",
		["Alchemist's Stone"] = "Piedra de alquimista",
		["Arcane Elixir"] = "Elixir Arcano",
		["Blackmouth Oil"] = "Aceite bocanegra",
		["Catseye Elixir"] = "Elixir de ojo de gato",
		["Cauldron of Major Arcane Protection"] = "Caldera de protección contra lo Arcano sublime",
		["Cauldron of Major Fire Protection"] = "Caldera de protección contra el Fuego sublime",
		["Cauldron of Major Frost Protection"] = "Caldera de protección contra la Escarcha sublime",
		["Cauldron of Major Nature Protection"] = "Caldera de protección contra la Naturaleza sublime",
		["Cauldron of Major Shadow Protection"] = "Caldera de protección contra las Sombras sublime",
		["Destruction Potion"] = "Poción de destrucción",
		["Discolored Healing Potion"] = "Poción de sanación descolorida",
		["Dreamless Sleep Potion"] = "Poción de letargo sin sueños",
		["Earthen Elixir"] = "Elixir terráneo",
		["Elixir of Agility"] = "Elixir de agilidad",
		["Elixir of Brute Force"] = "Elixir de fuerza bruta",
		["Elixir of Camouflage"] = "Elixir de camuflaje",
		["Elixir of Defense"] = "Elixir de defensa",
		["Elixir of Demonslaying"] = "Elixir de matanza de demonios",
		["Elixir of Detect Demon"] = "Elixir de detección de demonios",
		["Elixir of Detect Lesser Invisibility"] = "Elixir de detección de invisibilidad inferior",
		["Elixir of Detect Undead"] = "Elixir de detección de no-muertos",
		["Elixir of Draenic Wisdom"] = "Elixir de sabiduría draénica",
		["Elixir of Dream Vision"] = "Elixir de Visión onírica",
		["Elixir of Empowerment"] = "Elixir de empoderación",
		["Elixir of Firepower"] = "Elixir de poder de Fuego",
		["Elixir of Fortitude"] = "Elixir de entereza",
		["Elixir of Frost Power"] = "Elixir de poder de Escarcha",
		["Elixir of Giant Growth"] = "Elixir de crecimiento gigante",
		["Elixir of Giants"] = "Elixir de gigantes",
		["Elixir of Greater Agility"] = "Elixir de agilidad superior",
		["Elixir of Greater Defense"] = "Elixir de defensa superior",
		["Elixir of Greater Firepower"] = "Elixir de poder de Fuego superior",
		["Elixir of Greater Intellect"] = "Elixir de intelecto superior",
		["Elixir of Greater Water Breathing"] = "Elixir de respiración acuática superior",
		["Elixir of Healing Power"] = "Elixir de poder de sanación",
		["Elixir of Ironskin"] = "Elixir de piel de hierro",
		["Elixir of Lesser Agility"] = "Elixir de agilidad inferior",
		["Elixir of Lion's Strength"] = "Elixir de fuerza de león",
		["Elixir of Major Agility"] = "Elixir de agilidad sublime",
		["Elixir of Major Defense"] = "Elixir de defensa sublime",
		["Elixir of Major Firepower"] = "Elixir de poder de Fuego sublime",
		["Elixir of Major Fortitude"] = "Elixir de entereza sublime",
		["Elixir of Major Frost Power"] = "Elixir de poder de Escarcha sublime",
		["Elixir of Major Mageblood"] = "Elixir de sangre de mago sublime",
		["Elixir of Major Shadow Power"] = "Elixir de poder de las Sombras sublime",
		["Elixir of Major Strength"] = "Elixir de fuerza sublime",
		["Elixir of Mastery"] = "Elixir de maestría",
		["Elixir of Minor Agility"] = "Elixir de agilidad menor",
		["Elixir of Minor Defense"] = "Elixir de defensa menor",
		["Elixir of Minor Fortitude"] = "Elixir de entereza menor",
		["Elixir of Ogre's Strength"] = "Elixir de fuerza de ogro",
		["Elixir of Shadow Power"] = "Elixir de poder de las Sombras",
		["Elixir of Superior Defense"] = "Elixir de defensa excelente",
		["Elixir of the Mongoose"] = "Elixir de la mangosta",
		["Elixir of the Sages"] = "Elixir de los sabios",
		["Elixir of the Searching Eye"] = "Elixir del ojo escrutador",
		["Elixir of Water Breathing"] = "Elixir de respiración acuática",
		["Elixir of Wisdom"] = "Elixir de sabiduría",
		["Fel Mana Potion"] = "Poción de maná vil",
		["Fel Regeneration Potion"] = "Poción de regeneración vil",
		["Fel Strength Elixir"] = "Elixir de fuerza vil",
		["Fire Oil"] = "Aceite de Fuego",
		["Fire Protection Potion"] = "Poción de Protección contra el Fuego",
		["Flask of Blinding Light"] = "Frasco de Luz cegadora",
		["Flask of Chromatic Resistance"] = "Frasco de resistencia cromática",
		["Flask of Chromatic Wonder"] = "Frasco de Maravilla cromática",
		["Flask of Distilled Wisdom"] = "Frasco de sabiduría destilada",
		["Flask of Fortification"] = "Frasco de fortificación",
		["Flask of Mighty Restoration"] = "Frasco de restauración poderosa",
		["Flask of Petrification"] = "Frasco de petrificación",
		["Flask of Pure Death"] = "Frasco de muerte pura",
		["Flask of Relentless Assault"] = "Frasco de asalto incansable",
		["Flask of Supreme Power"] = "Frasco de poder supremo",
		["Flask of the Titans"] = "Frasco de los Titanes",
		["Free Action Potion"] = "Poción de acción libre",
		["Frost Oil"] = "Aceite de Escarcha",
		["Frost Protection Potion"] = "Poción de Protección contra la Escarcha",
		["Ghost Dye"] = "Tinte fantasmal",
		["Gift of Arthas"] = "Ofrenda de Arthas",
		["Goblin Rocket Fuel"] = "Combustible de cohete goblin",
		["Great Rage Potion"] = "Poción de gran ira",
		["Greater Arcane Elixir"] = "Elixir Arcano superior",
		["Greater Arcane Protection Potion"] = "Poción de protección contra lo Arcano sublime",
		["Greater Dreamless Sleep Potion"] = "Poción de letargo sin sueños sublime",
		["Greater Fire Protection Potion"] = "Poción de protección contra el Fuego sublime",
		["Greater Frost Protection Potion"] = "Poción de protección contra la Escarcha sublime",
		["Greater Healing Potion"] = "Poción de sanación sublime",
		["Greater Mana Potion"] = "Poción de maná sublime",
		["Greater Nature Protection Potion"] = "Poción de protección contra la Naturaleza sublime",
		["Greater Shadow Protection Potion"] = "Poción de protección contra las Sombras sublime",
		["Greater Stoneshield Potion"] = "Poción de escudo de piedra superior",
		["Gurubashi Mojo Madness"] = "Locura de mojo Gurubashi",
		["Haste Potion"] = "Poción de presteza",
		["Healing Potion"] = "Poción de sanación",
		["Heroic Potion"] = "Poción de heroicidad",
		["Holy Protection Potion"] = "Poción de Protección contra lo Sagrado",
		["Insane Strength Potion"] = "Poción de fuerza demente",
		["Invisibility Potion"] = "Poción de invisibilidad",
		["Ironshield Potion"] = "Poción de escudo de hierro",
		["Lesser Healing Potion"] = "Poción de sanación inferior",
		["Lesser Invisibility Potion"] = "Poción de invisibilidad inferior",
		["Lesser Mana Potion"] = "Poción de maná inferior",
		["Lesser Stoneshield Potion"] = "Poción de escudo de piedra inferior",
		["Limited Invulnerability Potion"] = "Poción de invulnerabilidad limitada",
		["Living Action Potion"] = "Poción de acción viva",
		["Mad Alchemist's Potion"] = "Poción de alquimista loco",
		["Mageblood Potion"] = "Poción de sangre de mago",
		["Magic Resistance Potion"] = "Poción de resistencia a la magia",
		["Major Arcane Protection Potion"] = "Poción de protección contra lo Arcano superior",
		["Major Dreamless Sleep Potion"] = "Poción de letargo sin sueños superior",
		["Major Fire Protection Potion"] = "Poción de protección contra el Fuego superior",
		["Major Frost Protection Potion"] = "Poción de Protección contra la Escarcha superior",
		["Major Healing Potion"] = "Poción de sanación superior",
		["Major Holy Protection Potion"] = "Poción de Protección contra lo Sagrado sublime",
		["Major Mana Potion"] = "Poción de maná superior",
		["Major Nature Protection Potion"] = "Poción de protección contra la Naturaleza superior",
		["Major Rejuvenation Potion"] = "Poción de rejuvenecimiento sublime",
		["Major Shadow Protection Potion"] = "Poción de protección contra las Sombras superior",
		["Major Troll's Blood Potion"] = "Poción de sangre de trol sublime",
		["Mana Potion"] = "Poción de maná",
		["Mercurial Stone"] = "Piedra mercúrica",
		["Mighty Rage Potion"] = "Poción de ira poderosa",
		["Mighty Troll's Blood Potion"] = "Poción de sangre de trol poderosa",
		["Minor Healing Potion"] = "Poción de sanación menor",
		["Minor Magic Resistance Potion"] = "Poción de resistencia a la magia menor",
		["Minor Mana Potion"] = "Poción de maná menor",
		["Minor Rejuvenation Potion"] = "Poción de Rejuvenecimiento menor",
		["Nature Protection Potion"] = "Poción de Protección contra la Naturaleza",
		["Oil of Immolation"] = "Aceite de inmolación",
		["Onslaught Elixir"] = "Elixir de acometida",
		["Philosopher's Stone"] = "Piedra filosofal",
		["Potion of Curing"] = "Poción de curación",
		["Purification Potion"] = "Poción de purificación",
		["Rage Potion"] = "Poción de ira",
		["Restorative Potion"] = "Poción restauradora",
		["Shadow Oil"] = "Aceite de las Sombras",
		["Shadow Protection Potion"] = "Poción de Protección contra las Sombras",
		["Shrouding Potion"] = "Poción de velo",
		["Sneaking Potion"] = "Poción de Escabullida",
		["Stonescale Oil"] = "Aceite de escama pétrea",
		["Strong Troll's Blood Potion"] = "Poción de sangre de trol fuerte",
		["Super Healing Potion"] = "Superpoción de sanación",
		["Super Mana Potion"] = "Superpoción de maná",
		["Super Rejuvenation Potion"] = "Superpoción de rejuvenecimiento",
		["Superior Healing Potion"] = "Poción de sanación excelente",
		["Superior Mana Potion"] = "Poción de maná excelente",
		["Swiftness Potion"] = "Poción de Escabullida",
		["Swim Speed Potion"] = "Poción de velocidad de nado",
		["Transmute: Air to Fire"] = "Transmutar: aire en fuego",
		["Transmute: Arcanite"] = "Transmutar: arcanita",
		["Transmute: Earth to Life"] = "Transmutar: tierra en vida",
		["Transmute: Earth to Water"] = "Transmutar: tierra en agua",
		["Transmute: Earthstorm Diamond"] = "Transmutar: diamante de tormenta de tierra",
		["Transmute: Elemental Fire"] = "Transmutar: fuego elemental",
		["Transmute: Fire to Earth"] = "Transmutar: fuego en tierra",
		["Transmute: Iron to Gold"] = "Transmutar: hierro a oro",
		["Transmute: Life to Earth"] = "Transmutar: vida en tierra",
		["Transmute: Mithril to Truesilver"] = "Transmutar: mitril a veraplata",
		["Transmute: Primal Air to Fire"] = "Transmutar: aire primigenio a fuego primigenio",
		["Transmute: Primal Earth to Life"] = "Transmutar: tierra primigenia a vida primigenia",
		["Transmute: Primal Earth to Water"] = "Transmutar: tierra primigenia a agua primigenia",
		["Transmute: Primal Fire to Earth"] = "Transmutar: fuego primigenio a tierra primigenia",
		["Transmute: Primal Fire to Mana"] = "Transmutar: fuego primigenio a maná primigenio",
		["Transmute: Primal Life to Earth"] = "Transmutar: vida primigenia a tierra primigenia",
		["Transmute: Primal Mana to Fire"] = "Transmutar: maná primigenio a fuego primigenio",
		["Transmute: Primal Might"] = "Transmutar: poderío primigenio",
		["Transmute: Primal Shadow to Water"] = "Transmutar: sombra primigenia a agua primigenia",
		["Transmute: Primal Water to Air"] = "Transmutar: agua primigenia a aire primigenio",
		["Transmute: Primal Water to Shadow"] = "Transmutar: agua primigenia a sombra primigenia",
		["Transmute: Skyfire Diamond"] = "Transmutar: diamante de fuego celeste",
		["Transmute: Undeath to Water"] = "Transmutar: no-muerto a agua",
		["Transmute: Water to Air"] = "Transmutar: agua a aire",
		["Transmute: Water to Undeath"] = "Transmutar: agua a no-muerto",
		["Unstable Mana Potion"] = "Poción de maná inestable",
		["Volatile Healing Potion"] = "Poción de sanación volátil",
		["Weak Troll's Blood Potion"] = "Poción de sangre de trol débil",
		["Wildvine Potion"] = "Poción de atriplex salvaje",

-- Beast Training Skills

-- Blacksmithing Recipes
		["Adamantite Breastplate"] = "Coraza de adamantita",
		["Adamantite Cleaver"] = "Cuchilla de adamantita",
		["Adamantite Dagger"] = "Daga de adamantita",
		["Adamantite Maul"] = "Gran maza de adamantita",
		["Adamantite Plate Bracers"] = "Brazales de placas de adamantita",
		["Adamantite Plate Gloves"] = "Guantes de placas de adamantita",
		["Adamantite Rapier"] = "Estoque de adamantita",
		["Adamantite Rod"] = "Vara de adamantita",
		["Adamantite Sharpening Stone"] = "Piedra de afilar de adamantita",
		["Adamantite Weapon Chain"] = "Cadena de adamantita",
		["Adamantite Weightstone"] = "Contrapeso de adamantita",
		["Annihilator"] = "Aniquiladora",
		["Arcanite Champion"] = "Campeona de arcanita",
		["Arcanite Reaper"] = "Segadora de arcanita",
		["Arcanite Rod"] = "Vara de arcanita",
		["Arcanite Skeleton Key"] = "Llave esqueleto de arcanita",
		["Barbaric Iron Boots"] = "Botas barbáricas de hierro",
		["Barbaric Iron Breastplate"] = "Coraza barbárica de hierro",
		["Barbaric Iron Gloves"] = "Guantes barbáricos de hierro",
		["Barbaric Iron Helm"] = "Yelmo barbárico de hierro",
		["Barbaric Iron Shoulders"] = "Sobrehombros barbáricos de hierro",
		["Belt of the Guardian"] = "Cinturón del guardián",
		["Big Black Mace"] = "Maza negra grande",
		["Big Bronze Knife"] = "Cuchillo de bronce grande",
		["Black Amnesty"] = "Amnistía negra",
		["Black Felsteel Bracers"] = "Brazales de acero vil negros",
		["Black Grasp of the Destroyer"] = "Garra negra del Destructor",
		["Black Planar Edge"] = "Filo bidimensional negro",
		["Blackfury"] = "Furianegra",
		["Blackguard"] = "Guardanegra",
		["Blazefury"] = "Furia abrasadora",
		["Blazeguard"] = "Guardia abrasadora",
		["Blazing Rapier"] = "Estoque llameante",
		["Blessed Bracers"] = "Brazales benditos",
		["Blight"] = "Toxicidad",
		["Bloodmoon"] = "Luna de sangre",
		["Bloodsoul Breastplate"] = "Coraza alma de sangre",
		["Bloodsoul Gauntlets"] = "Guanteletes alma de sangre",
		["Bloodsoul Shoulders"] = "Sobrehombros alma de sangre",
		["Blue Glittering Axe"] = "Hacha azul relumbrante",
		["Boots of the Protector"] = "Botas del protector",
		["Bracers of the Green Fortress"] = "Brazales de la Fortaleza Verde",
		["Breastplate of Kings"] = "Coraza de reyes",
		["Bronze Axe"] = "Hacha de bronce",
		["Bronze Battle Axe"] = "Hacha de batalla de bronce",
		["Bronze Greatsword"] = "Espada magna de bronce",
		["Bronze Mace"] = "Maza de bronce",
		["Bronze Shortsword"] = "Espada corta de bronce",
		["Bronze Warhammer"] = "Martillo de guerra de bronce",
		["Bulwark of Kings"] = "Baluarte de reyes",
		["Bulwark of the Ancient Kings"] = "Baluarte de los antiguos reyes",
		["Coarse Grinding Stone"] = "Piedra de pulir burda",
		["Coarse Sharpening Stone"] = "Piedra de afilar burda",
		["Coarse Weightstone"] = "Contrapeso burdo",
		["Copper Axe"] = "Hacha de cobre",
		["Copper Battle Axe"] = "Hacha de batalla de cobre",
		["Copper Bracers"] = "Brazales de cobre",
		["Copper Chain Belt"] = "Cinturón de anillas de cobre",
		["Copper Chain Boots"] = "Botas de anillas de cobre",
		["Copper Chain Pants"] = "Pantalones de anillas de cobre",
		["Copper Chain Vest"] = "Jubón de anillas de cobre",
		["Copper Claymore"] = "Espada claymore de cobre",
		["Copper Dagger"] = "Daga de cobre",
		["Copper Mace"] = "Maza de cobre",
		["Copper Shortsword"] = "Espada corta de cobre",
		["Corruption"] = "Corrupción",
		["Dark Iron Boots"] = "Botas Hierro Negro",
		["Dark Iron Bracers"] = "Brazales Hierro Negro",
		["Dark Iron Destroyer"] = "Destructor Hierro Negro",
		["Dark Iron Gauntlets"] = "Guanteletes Hierro Negro",
		["Dark Iron Helm"] = "Yelmo Hierro Negro",
		["Dark Iron Leggings"] = "Leotardos Hierro Negro",
		["Dark Iron Mail"] = "Malla Hierro Negro",
		["Dark Iron Plate"] = "Placa Hierro Negro",
		["Dark Iron Pulverizer"] = "Pulverizador Hierro Negro",
		["Dark Iron Reaver"] = "Espetadora Hierro Negro",
		["Dark Iron Shoulders"] = "Sobrehombros Hierro Negro",
		["Dark Iron Sunderer"] = "Taladora Hierro Negro",
		["Darkrune Breastplate"] = "Coraza runa oscura",
		["Darkrune Gauntlets"] = "Guanteletes runa oscura",
		["Darkrune Helm"] = "Yelmo runa oscura",
		["Darksoul Breastplate"] = "Coraza almanegra",
		["Darksoul Leggings"] = "Leotardos almanegra",
		["Darksoul Shoulders"] = "Sobrehombros almanegra",
		["Dawnbringer Shoulders"] = "Sobrehombros Albar",
		["Dawn's Edge"] = "Filo del Alba",
		["Dawnsteel Bracers"] = "Brazales albacero",
		["Dawnsteel Shoulders"] = "Sobrehombros albacero",
		["Dazzling Mithril Rapier"] = "Estoque de mitril deslumbrante",
		["Deadly Bronze Poniard"] = "Puñal de bronce mortal",
		["Deep Thunder"] = "Trueno profundo",
		["Demon Forged Breastplate"] = "Coraza de demonio forjada",
		["Dense Grinding Stone"] = "Piedra de pulir densa",
		["Dense Sharpening Stone"] = "Piedra de afilar densa",
		["Dense Weightstone"] = "Contrapeso denso",
		["Dirge"] = "Réquiem",
		["Dragonmaw"] = "Faucedraco",
		["Dragonstrike"] = "Golpe de dragón",
		["Drakefist Hammer"] = "Martillo de puñodraco",
		["Earthforged Leggings"] = "Leotardos terraforjados",
		["Earthpeace Breastplate"] = "Coraza de paz terrenal",
		["Ebon Hand"] = "Mano de ébano",
		["Ebon Shiv"] = "Chafarote de ébano",
		["Edge of Winter"] = "Filo del invierno",
		["Elemental Sharpening Stone"] = "Piedra de afilar elemental",
		["Embrace of the Twisting Nether"] = "Abrazo de El Vacío Abisal",
		["Enchanted Adamantite Belt"] = "Cinturón de adamantita encantado",
		["Enchanted Adamantite Boots"] = "Botas de adamantita encantada",
		["Enchanted Adamantite Breastplate"] = "Coraza de adamantita encantada",
		["Enchanted Adamantite Leggings"] = "Leotardos de adamantita encantados",
		["Enchanted Battlehammer"] = "Martillo de batalla encantado",
		["Enchanted Thorium Blades"] = "Hojas de torio encantado",
		["Enchanted Thorium Breastplate"] = "Coraza de torio encantado",
		["Enchanted Thorium Helm"] = "Yelmo de torio encantado",
		["Enchanted Thorium Leggings"] = "Leotardos de torio encantado",
		["Eternium Rod"] = "Vara de eternio",
		["Eternium Runed Blade"] = "Hoja rúnica de eternio",
		["Fel Edged Battleaxe"] = "Hacha de batalla vil afilada",
		["Fel Hardened Maul"] = "Gran maza vil endurecida",
		["Fel Iron Breastplate"] = "Coraza de hierro vil",
		["Fel Iron Chain Bracers"] = "Brazales de anillas de hierro vil",
		["Fel Iron Chain Coif"] = "Almófar de anillas de hierro vil",
		["Fel Iron Chain Gloves"] = "Guantes de anillas de hierro vil",
		["Fel Iron Chain Tunic"] = "Túnica de anillas de hierro vil",
		["Fel Iron Greatsword"] = "Espada magna de hierro vil",
		["Fel Iron Hammer"] = "Martillo de hierro vil",
		["Fel Iron Hatchet"] = "Hachuela de hierro vil",
		["Fel Iron Plate Belt"] = "Cinturón de placas de hierro vil",
		["Fel Iron Plate Boots"] = "Botas de placas de hierro vil",
		["Fel Iron Plate Gloves"] = "Guantes de placas de hierro vil",
		["Fel Iron Plate Pants"] = "Pantalones de placas de hierro vil",
		["Fel Iron Rod"] = "Vara de hierro vil",
		["Fel Sharpening Stone"] = "Piedra de afilar vil",
		["Fel Weightstone"] = "Contrapeso vil",
		["Felfury Gauntlets"] = "Guanteletes de furia vil",
		["Felsteel Gloves"] = "Guantes de acero vil",
		["Felsteel Helm"] = "Yelmo de acero vil",
		["Felsteel Leggings"] = "Leotardos de acero vil",
		["Felsteel Longblade"] = "Hoja larga de acero vil",
		["Felsteel Reaper"] = "Segadora de acero vil",
		["Felsteel Shield Spike"] = "Punta de escudo de acero vil",
		["Felsteel Whisper Knives"] = "Cuchillos susurrantes de acero vil",
		["Fiery Blaze Enchantment"] = "Encanto de hojas ígneas",
		["Fiery Chain Girdle"] = "Faja de anillas ígneas",
		["Fiery Chain Shoulders"] = "Sobrehombros de anillas ígneas",
		["Fiery Plate Gauntlets"] = "Guanteletes de placas ígneas",
		["Fireguard"] = "Guardia de fuego",
		["Flamebane Bracers"] = "Brazales aterrallamas",
		["Flamebane Breastplate"] = "Coraza aterrallamas",
		["Flamebane Gloves"] = "Guantes aterrallamas",
		["Flamebane Helm"] = "Yelmo aterrallamas",
		["Frost Tiger Blade"] = "Hoja tigre de Escarcha",
		["Frostguard"] = "Guardia de Escarcha",
		["Gauntlets of the Iron Tower"] = "Guanteletes de la Torre de Hierro",
		["Gemmed Copper Gauntlets"] = "Guanteletes de cobre con gemas",
		["Girdle of the Dawn"] = "Faja del Alba",
		["Glinting Steel Dagger"] = "Daga de acero destellante",
		["Gloves of the Dawn"] = "Guantes del Alba",
		["Golden Iron Destroyer"] = "Destructora de hierro dorado",
		["Golden Rod"] = "Vara dorada",
		["Golden Scale Boots"] = "Botas de escamas doradas",
		["Golden Scale Bracers"] = "Brazales de escamas doradas",
		["Golden Scale Coif"] = "Almófar de escamas doradas",
		["Golden Scale Cuirass"] = "Coraza de escamas doradas",
		["Golden Scale Gauntlets"] = "Guanteletes de escamas doradas",
		["Golden Scale Leggings"] = "Leotardos de escamas doradas",
		["Golden Scale Shoulders"] = "Sobrehombros de escamas doradas",
		["Golden Skeleton Key"] = "Llave esqueleto dorada",
		["Great Earthforged Hammer"] = "Gran martillo terraforjado",
		["Greater Rune of Warding"] = "Runa de amparo superior",
		["Greater Ward of Shielding"] = "Resguardo de escudo superior",
		["Green Iron Boots"] = "Botas de hierro verdes",
		["Green Iron Bracers"] = "Brazales de hierro verdes",
		["Green Iron Gauntlets"] = "Guanteletes de hierro verdes",
		["Green Iron Hauberk"] = "Camisote de hierro verde",
		["Green Iron Helm"] = "Yelmo de hierro verde",
		["Green Iron Leggings"] = "Leotardos de hierro verdes",
		["Green Iron Shoulders"] = "Sobrehombros de hierro verdes",
		--["Hard Khorium Battlefists"] = true,
		--["Hard Khorium Battleplate"] = true,
		["Hammer of Righteous Might"] = "Martillo de poderío recto",
		["Hammer of the Titans"] = "Martillo de los Titanes",
		["Hand of Eternity"] = "Mano de la eternidad",
		["Hardened Iron Shortsword"] = "Espada corta de hierro endurecido",
		["Heartseeker"] = "Buscacorazones",
		["Heavy Bronze Mace"] = "Maza de bronce pesada",
		["Heavy Copper Broadsword"] = "Espada ancha de cobre pesada",
		["Heavy Copper Longsword"] = "Tizona de cobre pesada",
		["Heavy Copper Maul"] = "Gran maza de cobre pesada",
		["Heavy Earthforged Breastplate"] = "Coraza terraforjada pesada",
		["Heavy Grinding Stone"] = "Piedra de pulir pesada",
		["Heavy Mithril Axe"] = "Hacha de mitril pesada",
		["Heavy Mithril Boots"] = "Botas de mitril pesadas",
		["Heavy Mithril Breastplate"] = "Coraza de mitril pesada",
		["Heavy Mithril Gauntlet"] = "Guanteletes de mitril pesados",
		["Heavy Mithril Helm"] = "Yelmo de mitril pesado",
		["Heavy Mithril Pants"] = "Pantalones de mitril pesados",
		["Heavy Mithril Shoulder"] = "Sobrehombros de mitril pesados",
		["Heavy Obsidian Belt"] = "Cinturón obsidiano pesado",
		["Heavy Sharpening Stone"] = "Piedra de afilar pesada",
		["Heavy Timbermaw Belt"] = "Cinturón Fauces de Madera pesado",
		["Heavy Timbermaw Boots"] = "Botas Fauces de Madera pesadas",
		["Heavy Weightstone"] = "Contrapeso pesado",
		["Helm of the Great Chief"] = "Yelmo del gran jefe",
		["Helm of the Stalwart Defender"] = "Yelmo de adepto defensor",
		["Huge Thorium Battleaxe"] = "Hacha de batalla de torio enorme",
		["Icebane Bracers"] = "Brazales Deliriohelado",
		["Icebane Breastplate"] = "Coraza Deliriohelado",
		["Icebane Gauntlets"] = "Icebane Gauntlets",
		["Iceguard Breastplate"] = "Coraza de guardia de hielo",
		["Iceguard Helm"] = "Yelmo de guardia de hielo",
		["Iceguard Leggings"] = "Leotardos de guardia de hielo",
		["Imperial Plate Belt"] = "Cinturón de placas imperiales",
		["Imperial Plate Boots"] = "Botas de placas imperiales",
		["Imperial Plate Bracers"] = "Brazales de placas imperiales",
		["Imperial Plate Chest"] = "Peto de placas imperiales",
		["Imperial Plate Helm"] = "Yelmo de placas imperiales",
		["Imperial Plate Leggings"] = "Leotardos de placas imperiales",
		["Imperial Plate Shoulders"] = "Sobrehombros de placas imperiales",
		["Inlaid Mithril Cylinder"] = "Cilindro de mitril taraceado",
		["Invulnerable Mail"] = "Malla invulnerable",
		["Iridescent Hammer"] = "Martillo iridiscente",
		["Iron Buckle"] = "Hebilla de hierro",
		["Iron Counterweight"] = "Contrapeso de hierro",
		["Iron Shield Spike"] = "Escudo con punta de hierro",
		["Ironforge Breastplate"] = "Coraza de Forjaz",
		["Ironvine Belt"] = "Cinturón Parraférrea",
		["Ironvine Breastplate"] = "Coraza Parraférrea",
		["Ironvine Gloves"] = "Guantes Parraférrea",
		["Jade Serpentblade"] = "Hoja serpentina de jade",
		["Jagged Obsidian Shield"] = "Escudo dentado obsidiano",
		["Khorium Belt"] = "Cinturón de korio",
		["Khorium Boots"] = "Botas de korio",
		["Khorium Champion"] = "Campeón de korio",
		["Khorium Pants"] = "Pantalones de korio",
		["Lavaforged Warhammer"] = "Martillo de guerra lavaforjado",
		["Lesser Rune of Warding"] = "Runa de amparo inferior",
		["Lesser Ward of Shielding"] = "Resguardo de escudo inferior",
		["Light Earthforged Blade"] = "Hoja terraforjada ligera",
		["Light Emberforged Hammer"] = "Martillo ascuaforjado ligero",
		["Light Obsidian Belt"] = "Cinturón obsidiano ligero",
		["Light Skyforged Axe"] = "Hacha cieloforjada ligera",
		["Lionheart Blade"] = "Hoja de corazón de león",
		["Lionheart Champion"] = "Campeón corazón de león",
		["Lionheart Executioner"] = "Verdugo corazón de león",
		["Lionheart Helm"] = "Yelmo corazón de león",
		["Lunar Crescent"] = "Luna creciente",
		["Massive Iron Axe"] = "Hacha de hierro macizo",
		["Masterwork Stormhammer"] = "Martillo de tormenta magistral",
		["Mighty Iron Hammer"] = "Martillo de hierro poderoso",
		["Mithril Coif"] = "Almófar de mitril",
		["Mithril Scale Bracers"] = "Brazales de escamas de mitril",
		--["Mithril Scale Gloves"] = true,
		["Mithril Scale Pants"] = "Pantalones de escamas de mitril",
		["Mithril Scale Shoulders"] = "Sobrehombros de escamas de mitril",
		["Mithril Shield Spike"] = "Punta de escudo de mitril",
		["Mithril Spurs"] = "Espuelas de mitril",
		["Mooncleaver"] = "Cortaluna",
		["Moonsteel Broadsword"] = "Espada ancha de acero lunar",
		["Nether Chain Shirt"] = "Camisa de anillas abisales",
		["Nightfall"] = "Ocaso",
		["Oathkeeper's Helm"] = "Yelmo de El Guardián del Juramento",
		["Obsidian Mail Tunic"] = "Túnica de malla obsidiana",
		["Orcish War Leggings"] = "Leotardos de guerra orcos",
		["Ornate Mithril Boots"] = "Botas de mitril ornamentadas",
		["Ornate Mithril Breastplate"] = "Coraza de mitril ornamentado",
		["Ornate Mithril Gloves"] = "Guantes de mitril ornamentados",
		["Ornate Mithril Helm"] = "Yelmo de mitril ornamentado",
		["Ornate Mithril Pants"] = "Pantalones de mitril ornamentado",
		["Ornate Mithril Shoulder"] = "Sobrehombros de mitril ornamentado",
		["Ornate Thorium Handaxe"] = "Hacha de mano de torio ornamentada",
		["Patterned Bronze Bracers"] = "Brazales de bronce estampados",
		["Pearl-handled Dagger"] = "Daga con empuñadura de perla",
		["Persuader"] = "Persuasor",
		["Phantom Blade"] = "Hoja fantasma",
		["Polished Steel Boots"] = "Botas de acero pulido",
		["Radiant Belt"] = "Cinturón radiante",
		["Radiant Boots"] = "Botas radiantes",
		["Radiant Breastplate"] = "Coraza radiante",
		["Radiant Circlet"] = "Aro radiante",
		["Radiant Gloves"] = "Guantes radiantes",
		["Radiant Leggings"] = "Leotardos radiantes",
		["Ragesteel Breastplate"] = "Coraza de acerira",
		["Ragesteel Gloves"] = "Guantes de acerira",
		["Ragesteel Helm"] = "Yelmo de acerira",
		["Ragesteel Shoulders"] = "Sobrehombros de acerira",
		["Red Belt of Battle"] = "Cinturón rojo de batalla",
		["Red Havoc Boots"] = "Botas de caos rojas",
		["Rough Bronze Boots"] = "Botas de bronce férreas",
		--["Rough Bronze Bracers"] = true,
		["Rough Bronze Cuirass"] = "Coraza de bronce férrea",
		["Rough Bronze Leggings"] = "Leotardos de bronce férreos",
		["Rough Bronze Shoulders"] = "Sobrehombros de bronce férreos",
		["Rough Copper Vest"] = "Jubón de cobre férreo",
		["Rough Grinding Stone"] = "Piedra de pulir férrea",
		["Rough Sharpening Stone"] = "Piedra de afilar férrea",
		["Rough Weightstone"] = "Contrapeso férreo",
		["Runed Copper Belt"] = "Cinturón rúnico de cobre",
		["Runed Copper Bracers"] = "Brazales rúnicos de cobre",
		["Runed Copper Breastplate"] = "Coraza rúnica de cobre",
		["Runed Copper Gauntlets"] = "Guanteletes rúnicos de cobre",
		["Runed Copper Pants"] = "Pantalones rúnicos de cobre",
		["Runed Mithril Hammer"] = "Martillo rúnico de mitril",
		["Runic Breastplate"] = "Coraza de placas rúnicas",
		["Runic Hammer"] = "Martillo rúnico",
		["Runic Plate Boots"] = "Botas de placas rúnicas",
		["Runic Plate Helm"] = "Yelmo de placas rúnicas",
		["Runic Plate Leggings"] = "Leotardos de placas rúnicas",
		["Runic Plate Shoulders"] = "Sobrehombros de placas rúnicas",
		["Sageblade"] = "Hoja sabia",
		["Searing Golden Blade"] = "Hoja dorada abrasadora",
		["Serenity"] = "Serenidad",
		["Shadesteel Bracers"] = "Brazales de acero de Sombras",
		["Shadesteel Girdle"] = "Faja de acero de Sombras",
		["Shadesteel Greaves"] = "Grebas de acero de Sombras",
		["Shadesteel Sabots"] = "Zuecos de acero de Sombras",
		["Shadow Crescent Axe"] = "Hacha creciente de las Sombras",
		["Shining Silver Breastplate"] = "Coraza de plata resplandeciente",
		["Silver Rod"] = "Vara de plata",
		["Silver Skeleton Key"] = "Llave esqueleto de plata",
		["Silvered Bronze Boots"] = "Botas de bronce bañadas en plata",
		["Silvered Bronze Breastplate"] = "Coraza de bronce bañada en plata",
		["Silvered Bronze Gauntlets"] = "Guanteletes de bronce bañados en plata",
		["Silvered Bronze Leggings"] = "Leotardos de bronce bañados en plata",
		["Silvered Bronze Shoulders"] = "Sobrehombros de bronce bañados en plata",
		["Skyforged Great Axe"] = "Gran hacha cieloforjada",
		["Solid Grinding Stone"] = "Piedra de pulir sólida",
		["Solid Iron Maul"] = "Gran maza de hierro sólido",
		["Solid Sharpening Stone"] = "Piedra de afilar sólida",
		["Solid Weightstone"] = "Contrapeso sólido",
		["Steel Breastplate"] = "Coraza de acero",
		["Steel Plate Helm"] = "Yelmo de placas de acero",
		["Steel Weapon Chain"] = "Cadena de acero",
		["Steelgrip Gauntlets"] = "Guanteletes de presacero",
		["Stoneforged Claymore"] = "Espada claymore de forja de piedra",
		["Storm Gauntlets"] = "Guanteletes de tormenta",
		["Storm Helm"] = "Yelmo de tormenta",
		["Stormforged Axe"] = "Hacha tronaforjada",
		["Stormforged Hauberk"] = "Camisote tronaforjado",
		["Stormherald"] = "Heraldo de la tormenta",
		["Stronghold Gauntlets"] = "Guanteletes bastión",
		--["Sunblessed Breastplate"] = true,
		--["Sunblessed Gauntlets"] = true,
		["Sulfuron Hammer"] = "Martillo de Sulfuron",
		["Swiftsteel Bracers"] = "Brazales de acero presto",
		["Swiftsteel Gloves"] = "Guantes de acero presto",
		["Swiftsteel Shoulders"] = "Sobrehombros de acero presto",
		["The Planar Edge"] = "El filo bidimensional",
		["The Shatterer"] = "El despedazador",
		["Thick Bronze Darts"] = "Dardos de bronce gruesos",
		["Thick Obsidian Breastplate"] = "Coraza obsidiana gruesa",
		["Thick War Axe"] = "Gran hacha de guerra",
		["Thorium Armor"] = "Armadura de torio",
		["Thorium Belt"] = "Cinturón de torio",
		["Thorium Boots"] = "Botas de torio",
		["Thorium Bracers"] = "Brazales de torio",
		["Thorium Helm"] = "Yelmo de torio",
		["Thorium Leggings"] = "Leotardos de torio",
		["Thorium Shield Spike"] = "Punta de escudo de torio",
		["Thunder"] = "Trueno",
		["Titanic Leggings"] = "Leotardos titánicos",
		["Truesilver Breastplate"] = "Coraza de veraplata",
		["Truesilver Champion"] = "Campeón de veraplata",
		["Truesilver Gauntlets"] = "Guanteletes de veraplata",
		["Truesilver Rod"] = "Vara de veraplata",
		["Truesilver Skeleton Key"] = "Llave esqueleto de veraplata",
		["Twisting Nether Chain Shirt"] = "Camisa de anillas de El Vacío Abisal",
		["Volcanic Hammer"] = "Martillo volcánico",
		["Whirling Steel Axes"] = "Hachas giratorias de acero",
		["Whitesoul Helm"] = "Yelmo Almablanca",
		["Wicked Edge of the Planes"] = "Filo despiadado de los planos",
		["Wicked Mithril Blade"] = "Espada de mitril maligna",
		["Wildguard Breastplate"] = "Coraza de guardia salvaje",
		["Wildguard Helm"] = "Yelmo de guardia salvaje",
		["Wildguard Leggings"] = "Leotardos de guardia salvaje",
		["Wildthorn Mail"] = "Malla espina salvaje",
		["Windforged Leggings"] = "Leotardos ventoforjado",
		["Windforged Rapier"] = "Estoque ventoforjado",

-- Cooking Recipes
		["Baked Salmon"] = "Salmón al horno",
		["Barbecued Buzzard Wing"] = "Ala de águila ratonera a la parrilla",
		["Bat Bites"] = "Pinchitos de murciélago",
		["Beer Basted Boar Ribs"] = "Costillas de jabalí a la cerveza",
		["Big Bear Steak"] = "Chuleta de oso grande",
		["Blackened Basilisk"] = "Basilisco ennegrecido",
		["Blackened Sporefish"] = "Pescado con esporas ennegrecido",
		["Blackened Trout"] = "Trucha ennegrecida",
		["Blood Sausage"] = "Morcilla",
		["Boiled Clams"] = "Almejas hervidas",
		["Brilliant Smallfish"] = "Pececito luminoso",
		["Bristle Whisker Catfish"] = "Siluro mostacherizo",
		["Broiled Bloodfin"] = "Sangraleta a la parrilla",
		["Buzzard Bites"] = "Pinchito de águila ratonera",
		["Carrion Surprise"] = "Sorpresa de carroña",
		["Charred Wolf Meat"] = "Carne de lobo carbonizada",
		["Clam Bar"] = "Barrita de almeja",
		["Clam Chowder"] = "Sopa de almejas",
		["Cooked Crab Claw"] = "Pinza de cangrejo cocida",
		["Cooked Glossy Mightfish"] = "Vigorpez lustroso cocido",
		["Coyote Steak"] = "Filete de coyote",
		["Crab Cake"] = "Pastel de cangrejo",
		["Crispy Bat Wing"] = "Ala de murciélago crujiente",
		["Crispy Lizard Tail"] = "Cola de lagarto crujiente",
		["Crocolisk Gumbo"] = "Potaje de crocolisco",
		["Crocolisk Steak"] = "Filete de crocolisco",
		["Crunchy Serpent"] = "Serpiente crujiente",
		["Crunchy Spider Surprise"] = "Sorpresa de araña crujiente",
		["Curiously Tasty Omelet"] = "Tortilla con un sabor curioso",
		["Delicious Chocolate Cake"] = "Pastel de chocolate delicioso",
		["Dig Rat Stew"] = "Estofado de ratas de madriguera",
		["Dirge's Kickin' Chimaerok Chops"] = "Fabulosas chuletillas de quimerok de Dirge",
		["Dragonbreath Chili"] = "Ají aliento de dragón",
		["Dry Pork Ribs"] = "Costillas de cerdo secas",
		["Egg Nog"] = "Ponche de huevo",
		["Feltail Delight"] = "Delicias de colavil",
		["Filet of Redgill"] = "Filete de branquirrojo",
		["Fillet of Frenzy"] = "Filete de pez furia",
		["Fisherman's Feast"] = "Festín de pescador",
		["Giant Clam Scorcho"] = "Almeja gigante a la brasa",
		["Gingerbread Cookie"] = "Galleta de jengibre",
		["Goblin Deviled Clams"] = "Almejas picantes a la goblin",
		["Golden Fish Sticks"] = "Palitos de pez dorado",
		["Goldthorn Tea"] = "Té de espina de oro",
		["Gooey Spider Cake"] = "Pastel de araña pegajosa",
		["Goretusk Liver Pie"] = "Pastel de hígado de Dentosangre",
		["Grilled Mudfish"] = "Pezfango a la parrilla",
		["Grilled Squid"] = "Calamar a la parrilla",
		["Heavy Crocolisk Stew"] = "Estofado de crocolisco pesado",
		["Heavy Kodo Stew"] = "Estofado de kodo pesado",
		["Herb Baked Egg"] = "Huevo a las finas hierbas",
		["Hot Apple Cider"] = "Sidra de manzana caliente",
		["Hot Buttered Trout"] = "Trucha con mantequilla caliente",
		["Hot Lion Chops"] = "Chuletillas de león picantes",
		["Hot Smoked Bass"] = "Lubina ahumada picante",
		["Hot Wolf Ribs"] = "Costillas de lobo picantes",
		["Jungle Stew"] = "Estofado de la selva",
		["Kaldorei Spider Kabob"] = "Kebab de araña Kaldorei",
		["Kibler's Bits"] = "Tapitas de Kibler",
		["Lean Venison"] = "Venado magro",
		["Lean Wolf Steak"] = "Filete de lobo magro",
		["Lobster Stew"] = "Estofado de langosta",
		["Loch Frenzy Delight"] = "Delicia de furia de Loch Modan",
		["Longjaw Mud Snapper"] = "Pargo de lodo boquilargo",
		["Lynx Steak"] = "Chuleta de lince",
		["Mightfish Steak"] = "Filete de vigorpez",
		["Mithril Headed Trout"] = "Trucha cabeza de mitril",
		["Mok'Nathal Shortribs"] = "Costillitas de Mok'Nathal",
		["Monster Omelet"] = "Tortilla gigante",
		["Murloc Fin Soup"] = "Sopa de aleta de múrloc",
		["Mystery Stew"] = "Estofado misterioso",
		["Nightfin Soup"] = "Sopa de aletoche",
		["Poached Bluefish"] = "Pezazul pochado",
		["Poached Sunscale Salmon"] = "Salmón solescamas pochado",
		["Rainbow Fin Albacore"] = "Atún blanco arco iris",
		["Ravager Dog"] = "Perro devastador",
		["Redridge Goulash"] = "Estofado Crestagrana",
		["Roast Raptor"] = "Raptor asado",
		["Roasted Boar Meat"] = "Carne de jabalí asada",
		["Roasted Clefthoof"] = "Uñagrieta asado",
		["Roasted Kodo Meat"] = "Carne de kodo asada",
		["Roasted Moongraze Tenderloin"] = "Solomillo de venado lunar asado",
		["Rockscale Cod"] = "Bacalao Piedrescama",
		["Runn Tum Tuber Surprise"] = "Sorpresa de tubérculo Runn Tum",
		["Sagefish Delight"] = "Delicia de sabiola",
		["Savory Deviate Delight"] = "Delicia de pez descarriado sabrosa",
		["Scorpid Surprise"] = "Sorpresa de escórpido",
		["Seasoned Wolf Kabob"] = "Kebab de lobo sazonado",
		["Skullfish Soup"] = "Sopa de pez calavera",
		["Slitherskin Mackerel"] = "Caballa de piel escurridiza",
		["Smoked Bear Meat"] = "Carne de oso ahumada",
		["Smoked Desert Dumplings"] = "Albóndigas del desierto ahumadas",
		["Smoked Sagefish"] = "Sabiola ahumada",
		["Soothing Turtle Bisque"] = "Sopa de tortuga reconfortante",
		["Spice Bread"] = "Pan con especias",
		["Spiced Chili Crab"] = "Chili de cangrejo especiado",
		["Spiced Wolf Meat"] = "Carne de lobo especiada",
		["Spicy Crawdad"] = "Cigala picante",
		["Spicy Hot Talbuk"] = "Talbuk con guindillas",
		["Spider Sausage"] = "Salchicha de araña",
		["Sporeling Snack"] = "Tentempié de esporino",
		["Spotted Yellowtail"] = "Serviola moteada",
		["Stewed Trout"] = "Estofado de trucha",
		["Stormchops"] = "Costillas de truenos",
		["Strider Stew"] = "Estofado de zancudo",
		["Succulent Pork Ribs"] = "Costillas de cerdo suculentas",
		["Talbuk Steak"] = "Chuleta de talbuk",
		["Tasty Lion Steak"] = "Filete de león sabroso",
		["Tender Wolf Steak"] = "Chuleta de lobo tierno",
		["Thistle Tea"] = "Té de cardo",
		["Undermine Clam Chowder"] = "Sopa de almejas de Minahonda",
		["Warp Burger"] = "Hamburguesa de distorsión",
		["Westfall Stew"] = "Estofado de los Páramos de Poniente",

-- Enchanting Recipes
		["Brilliant Mana Oil"] = "Aceite de maná luminoso",
		["Brilliant Wizard Oil"] = "Aceite de zahorí luminoso",
		["Enchant 2H Weapon - Agility"] = "Encantar arma 2M: agilidad",
		["Enchant 2H Weapon - Greater Impact"] = "Encantar arma 2M: impacto superior",
		["Enchant 2H Weapon - Impact"] = "Encantar arma 2M: impacto",
		["Enchant 2H Weapon - Lesser Impact"] = "Encantar arma 2M: impacto inferior",
		["Enchant 2H Weapon - Lesser Intellect"] = "Encantar arma 2M: intelecto inferior",
		["Enchant 2H Weapon - Lesser Spirit"] = "Encantar arma 2M: espíritu inferior",
		["Enchant 2H Weapon - Major Agility"] = "Encantar arma 2M: agilidad sublime",
		["Enchant 2H Weapon - Major Intellect"] = "Encantar arma 2M: intelecto sublime",
		["Enchant 2H Weapon - Major Spirit"] = "Encantar arma 2M: espíritu sublime",
		["Enchant 2H Weapon - Minor Impact"] = "Encantar arma 2M: impacto menor",
		["Enchant 2H Weapon - Savagery"] = "Encantar arma 2M: salvajismo",
		["Enchant 2H Weapon - Superior Impact"] = "Encantar arma 2M: impacto excelente",
		["Enchant Boots - Agility"] = "Encantar botas: agilidad",
		["Enchant Boots - Boar's Speed"] = "Encantar botas: velocidad del jabalí",
		["Enchant Boots - Cat's Swiftness"] = "Encantar botas: presteza felina",
		["Enchant Boots - Dexterity"] = "Encantar botas: maña",
		["Enchant Boots - Fortitude"] = "Encantar botas: entereza",
		["Enchant Boots - Greater Agility"] = "Encantar botas: agilidad superior",
		["Enchant Boots - Greater Stamina"] = "Encantar botas: aguante superior",
		["Enchant Boots - Lesser Agility"] = "Encantar botas: agilidad inferior",
		["Enchant Boots - Lesser Spirit"] = "Encantar botas: espíritu inferior",
		["Enchant Boots - Lesser Stamina"] = "Encantar botas: aguante inferior",
		["Enchant Boots - Minor Agility"] = "Encantar botas: agilidad menor",
		["Enchant Boots - Minor Speed"] = "Encantar botas: velocidad menor",
		["Enchant Boots - Minor Stamina"] = "Encantar botas: aguante menor",
		["Enchant Boots - Spirit"] = "Encantar botas: espíritu",
		["Enchant Boots - Stamina"] = "Encantar botas: aguante",
		["Enchant Boots - Surefooted"] = "Encantar botas: pies de plomo",
		["Enchant Boots - Vitality"] = "Encantar botas: vitalidad",
		["Enchant Bracer - Assault"] = "Encantar brazal: asalto",
		["Enchant Bracer - Brawn"] = "Encantar brazal: lozanía",
		["Enchant Bracer - Deflection"] = "Encantar brazal: desvío",
		["Enchant Bracer - Fortitude"] = "Encantar brazal: entereza",
		["Enchant Bracer - Greater Intellect"] = "Encantar brazal: Intelecto superior",
		["Enchant Bracer - Greater Spirit"] = "Encantar brazal: espíritu superior",
		["Enchant Bracer - Greater Stamina"] = "Encantar brazal: aguante superior",
		["Enchant Bracer - Greater Strength"] = "Encantar brazal: fuerza superior",
		["Enchant Bracer - Healing Power"] = "Encantar brazal: poder de sanación",
		["Enchant Bracer - Intellect"] = "Encantar brazal: intelecto",
		["Enchant Bracer - Lesser Deflection"] = "Encantar brazal: desvío inferior",
		["Enchant Bracer - Lesser Intellect"] = "Encantar brazal: intelecto inferior",
		["Enchant Bracer - Lesser Spirit"] = "Encantar brazal: espíritu inferior",
		["Enchant Bracer - Lesser Stamina"] = "Encantar brazal: aguante inferior",
		["Enchant Bracer - Lesser Strength"] = "Encantar brazal: fuerza inferior",
		["Enchant Bracer - Major Defense"] = "Encantar brazal: defensa sublime",
		["Enchant Bracer - Major Intellect"] = "Encantar brazal: intelecto sublime",
		["Enchant Bracer - Mana Regeneration"] = "Encantar brazal: regeneración de maná",
		["Enchant Bracer - Minor Agility"] = "Encantar brazal: agilidad menor",
		["Enchant Bracer - Minor Deflection"] = "Encantar brazal: desvío menor",
		["Enchant Bracer - Minor Health"] = "Encantar brazal: salud menor",
		["Enchant Bracer - Minor Spirit"] = "Encantar brazal: espíritu menor",
		["Enchant Bracer - Minor Stamina"] = "Encantar brazal: aguante menor",
		["Enchant Bracer - Minor Strength"] = "Encantar brazal: fuerza menor",
		["Enchant Bracer - Restore Mana Prime"] = "Encantar brazal: restaurar maná de primera",
		["Enchant Bracer - Spellpower"] = "Encantar brazal: poder de hechizos",
		["Enchant Bracer - Spirit"] = "Encantar brazal: espíritu",
		["Enchant Bracer - Stamina"] = "Encantar brazal: aguante",
		["Enchant Bracer - Stats"] = "Encantar brazal: estadísticas",
		["Enchant Bracer - Strength"] = "Encantar brazal: fuerza",
		["Enchant Bracer - Superior Healing"] = "Encantar brazal: sanación excelente",
		["Enchant Bracer - Superior Spirit"] = "Encantar brazal: espíritu excelente",
		["Enchant Bracer - Superior Stamina"] = "Encantar brazal: aguante excelente",
		["Enchant Bracer - Superior Strength"] = "Encantar brazal: fuerza excelente",
		["Enchant Chest - Defense"] = "Encantar pechera: defensa",
		["Enchant Chest - Exceptional Health"] = "Encantar pechera: salud excepcional",
		["Enchant Chest - Exceptional Stats"] = "Encantar pechera: estadísticas excepcionales",
		["Enchant Chest - Greater Health"] = "Encantar pechera: salud superior",
		["Enchant Chest - Greater Mana"] = "Encantar pechera: maná superior",
		["Enchant Chest - Greater Stats"] = "Encantar pechera: estadísticas superiores",
		["Enchant Chest - Health"] = "Encantar pechera: salud",
		["Enchant Chest - Lesser Absorption"] = "Encantar pechera: amortiguación inferior",
		["Enchant Chest - Lesser Health"] = "Encantar pechera: salud inferior",
		["Enchant Chest - Lesser Mana"] = "Encantar pechera: maná inferior",
		["Enchant Chest - Lesser Stats"] = "Encantar pechera: estadísticas inferiores",
		["Enchant Chest - Major Health"] = "Encantar pechera: salud sublime",
		["Enchant Chest - Major Mana"] = "Encantar pechera: maná sublime",
		["Enchant Chest - Major Resilience"] = "Encantar pechera: temple sublime",
		["Enchant Chest - Major Spirit"] = "Encantar pechera: espíritu sublime",
		["Enchant Chest - Mana"] = "Encantar pechera: maná",
		["Enchant Chest - Minor Absorption"] = "Encantar pechera: amortiguación menor",
		["Enchant Chest - Minor Health"] = "Encantar pechera: salud menor",
		["Enchant Chest - Minor Mana"] = "Encantar pechera: maná menor",
		["Enchant Chest - Minor Stats"] = "Encantar pechera: estadísticas menores",
		["Enchant Chest - Restore Mana Prime"] = "Encantar pechera: restaurar maná de primera",
		["Enchant Chest - Stats"] = "Encantar pechera: estadísticas",
		["Enchant Chest - Superior Health"] = "Encantar pechera: salud excelente",
		["Enchant Chest - Superior Mana"] = "Encantar pechera: maná excelente",
		["Enchant Cloak - Defense"] = "Encantar capa: defensa",
		["Enchant Cloak - Dodge"] = "Encantar capa: esquivar",
		["Enchant Cloak - Fire Resistance"] = "Encantar capa: Resistencia al Fuego",
		["Enchant Cloak - Greater Agility"] = "Encantar capa: agilidad superior",
		["Enchant Cloak - Greater Arcane Resistance"] = "Encantar capa: resistencia a lo Arcano superior",
		["Enchant Cloak - Greater Defense"] = "Encantar capa: defensa superior",
		["Enchant Cloak - Greater Fire Resistance"] = "Encantar capa: resistencia al Fuego superior",
		["Enchant Cloak - Greater Nature Resistance"] = "Encantar capa: resistencia a la Naturaleza superior",
		["Enchant Cloak - Greater Resistance"] = "Encantar capa: resistencia superior",
		["Enchant Cloak - Greater Shadow Resistance"] = "Encantar capa: resistencia a las Sombras superior",
		["Enchant Cloak - Lesser Agility"] = "Encantar capa: agilidad inferior",
		["Enchant Cloak - Lesser Fire Resistance"] = "Encantar capa: resistencia al Fuego inferior",
		["Enchant Cloak - Lesser Protection"] = "Encantar capa: protección inferior",
		["Enchant Cloak - Lesser Shadow Resistance"] = "Encantar capa: resistencia a las Sombras inferior",
		["Enchant Cloak - Major Armor"] = "Encantar capa: armadura sublime",
		["Enchant Cloak - Major Resistance"] = "Encantar capa: resistencia sublime",
		["Enchant Cloak - Minor Agility"] = "Encantar capa: agilidad menor",
		["Enchant Cloak - Minor Protection"] = "Encantar capa: protección menor",
		["Enchant Cloak - Minor Resistance"] = "Encantar capa: resistencia menor",
		["Enchant Cloak - Resistance"] = "Encantar capa: resistencia",
		["Enchant Cloak - Spell Penetration"] = "Encantar capa: penetración de hechizos",
		["Enchant Cloak - Stealth"] = "Encantar capa: sigilo",
		["Enchant Cloak - Subtlety"] = "Encantar capa: sutileza",
		["Enchant Cloak - Superior Defense"] = "Encantar capa: defensa excelente",
		["Enchant Gloves - Advanced Herbalism"] = "Encantar guantes: herboristería avanzada",
		["Enchant Gloves - Advanced Mining"] = "Encantar guantes: minería avanzada",
		["Enchant Gloves - Agility"] = "Encantar guantes: agilidad",
		["Enchant Gloves - Assault"] = "Encantar guantes: asalto",
		["Enchant Gloves - Blasting"] = "Encantar guantes: detonación",
		["Enchant Gloves - Fire Power"] = "Encantar guantes: poder de Fuego",
		["Enchant Gloves - Fishing"] = "Encantar guantes: pesca",
		["Enchant Gloves - Frost Power"] = "Encantar guantes: poder de Escarcha",
		["Enchant Gloves - Greater Agility"] = "Encantar guantes: agilidad superior",
		["Enchant Gloves - Greater Strength"] = "Encantar guantes: fuerza superior",
		["Enchant Gloves - Healing Power"] = "Encantar guantes: sanación",
		["Enchant Gloves - Herbalism"] = "Encantar guantes: herboristería",
		["Enchant Gloves - Major Healing"] = "Encantar guantes: sanación sublime",
		["Enchant Gloves - Major Spellpower"] = "Encantar guantes: poder de hechizo sublime",
		["Enchant Gloves - Major Strength"] = "Encantar guantes: fuerza sublime",
		["Enchant Gloves - Mining"] = "Encantar guantes: minería",
		["Enchant Gloves - Minor Haste"] = "Encantar guantes: celeridad menor",
		["Enchant Gloves - Riding Skill"] = "Encantar guantes: equitación",
		["Enchant Gloves - Shadow Power"] = "Encantar guantes: Poder de las Sombras",
		["Enchant Gloves - Skinning"] = "Encantar guantes: desuello",
		["Enchant Gloves - Spell Strike"] = "Encantar guantes: golpe con hechizos",
		["Enchant Gloves - Strength"] = "Encantar guantes: fuerza",
		["Enchant Gloves - Superior Agility"] = "Encantar guantes: agilidad excelente",
		["Enchant Gloves - Threat"] = "Encantar guantes: amenaza",
		["Enchant Ring - Healing Power"] = "Encantar anillo: poder de sanación",
		["Enchant Ring - Spellpower"] = "Encantar anillo: poder de hechizos",
		["Enchant Ring - Stats"] = "Encantar anillo: estadísticas",
		["Enchant Ring - Striking"] = "Encantar anillo: golpear",
		["Enchant Shield - Frost Resistance"] = "Encantar escudo: resistencia a la Escarcha",
		["Enchant Shield - Greater Spirit"] = "Encantar escudo: espíritu superior",
		["Enchant Shield - Greater Stamina"] = "Encantar escudo: aguante superior",
		["Enchant Shield - Intellect"] = "Encantar escudo: intelecto",
		["Enchant Shield - Lesser Block"] = "Encantar escudo: bloqueo inferior",
		["Enchant Shield - Lesser Protection"] = "Encantar escudo: protección inferior",
		["Enchant Shield - Lesser Spirit"] = "Encantar escudo: espíritu inferior",
		["Enchant Shield - Lesser Stamina"] = "Encantar escudo: aguante inferior",
		["Enchant Shield - Major Stamina"] = "Encantar escudo: aguante sublime",
		["Enchant Shield - Minor Stamina"] = "Encantar escudo: aguante menor",
		["Enchant Shield - Resistance"] = "Encantar escudo: resistencia",
		["Enchant Shield - Shield Block"] = "Encantar escudo: bloquear con escudo",
		["Enchant Shield - Spirit"] = "Encantar escudo: espíritu",
		["Enchant Shield - Stamina"] = "Encantar escudo: aguante",
		["Enchant Shield - Superior Spirit"] = "Encantar escudo: espíritu excelente",
		["Enchant Shield - Resilience"] = "Encantar escudo: temple",
		["Enchant Shield - Tough Shield"] = "Encantar escudo: escudo consistente",
		["Enchant Weapon - Agility"] = "Encantar arma: agilidad",
		["Enchant Weapon - Battlemaster"] = "Encantar arma: maestro de batalla",
		["Enchant Weapon - Crusader"] = "Encantar arma: cruzado",
		["Enchant Weapon - Demonslaying"] = "Encantar arma: matanza de demonios",
		["Enchant Weapon - Executioner"] = "Encantar arma: verdugo",
		["Enchant Weapon - Fiery Weapon"] = "Encantar arma: arma ígnea",
		["Enchant Weapon - Greater Agility"] = "Encantar arma: agilidad superior",
		["Enchant Weapon - Greater Striking"] = "Encantar arma: golpear superior",
		["Enchant Weapon - Healing Power"] = "Encantar arma: poder de sanación",
		["Enchant Weapon - Icy Chill"] = "Encantar arma: escalofrío gélido",
		["Enchant Weapon - Lesser Beastslayer"] = "Encantar arma: Destripadora de bestias inferior",
		["Enchant Weapon - Lesser Elemental Slayer"] = "Encantar arma: mataelementales inferior",
		["Enchant Weapon - Lesser Striking"] = "Encantar arma: golpear inferior",
		["Enchant Weapon - Lifestealing"] = "Encantar arma: robo de vida",
		["Enchant Weapon - Major Healing"] = "Encantar arma: sanación sublime",
		["Enchant Weapon - Major Intellect"] = "Encantar arma: intelecto sublime",
		["Enchant Weapon - Major Spellpower"] = "Encantar arma: poder de hechizo sublime",
		["Enchant Weapon - Major Striking"] = "Encantar arma: golpear sublime",
		["Enchant Weapon - Mighty Intellect"] = "Encantar arma: intelecto poderoso",
		["Enchant Weapon - Mighty Spirit"] = "Encantar arma: espíritu poderoso",
		["Enchant Weapon - Minor Beastslayer"] = "Encantar arma: Destripadora de bestias menor",
		["Enchant Weapon - Minor Striking"] = "Encantar arma: golpear menor",
		["Enchant Weapon - Mongoose"] = "Encantar arma: mangosta",
		["Enchant Weapon - Potency"] = "Encantar arma: potencia",
		["Enchant Weapon - Soulfrost"] = "Encantar arma: escarcha de alma",
		["Enchant Weapon - Spell Power"] = "Encantar arma: poder de hechizo",
		["Enchant Weapon - Spellsurge"] = "Encantar arma: oleada de hechizos",
		["Enchant Weapon - Strength"] = "Encantar arma: fortaleza",
		["Enchant Weapon - Striking"] = "Encantar arma: golpear",
		["Enchant Weapon - Sunfire"] = "Encantar arma: fuego solar",
		["Enchant Weapon - Superior Striking"] = "Encantar arma: golpes excelentes",
		["Enchant Weapon - Unholy Weapon"] = "Encantar arma: arma profana",
		["Enchant Weapon - Winter's Might"] = "Encantar arma: poderío del invierno",
		["Enchanted Leather"] = "Cuero encantado",
		["Enchanted Thorium"] = "Torio encantado",
		["Greater Magic Wand"] = "Varita mágica superior",
		["Greater Mystic Wand"] = "Varita mística superior",
		["Large Prismatic Shard"] = "Fragmento centelleante grande",
		["Lesser Magic Wand"] = "Varita mágica inferior",
		["Lesser Mana Oil"] = "Aceite de maná inferior",
		["Lesser Mystic Wand"] = "Varita mística inferior",
		["Lesser Wizard Oil"] = "Aceite de zahorí inferior",
		["Minor Mana Oil"] = "Aceite de maná menor",
		["Minor Wizard Oil"] = "Aceite de zahorí menor",
		["Nexus Transformation"] = "Transformación de Nexus",
		["Prismatic Sphere"] = "Esfera centelleante",
		["Runed Adamantite Rod"] = "Vara rúnica de adamantita",
		["Runed Arcanite Rod"] = "Vara rúnica de arcanita",
		["Runed Copper Rod"] = "Vara rúnica de cobre",
		["Runed Eternium Rod"] = "Vara rúnica de eternio",
		["Runed Fel Iron Rod"] = "Vara rúnica de hierro vil",
		["Runed Golden Rod"] = "Vara rúnica dorada",
		["Runed Silver Rod"] = "Vara rúnica de plata",
		["Runed Truesilver Rod"] = "Vara rúnica de veraplata",
		["Small Prismatic Shard"] = "Fragmento centelleante pequeño",
		["Smoking Heart of the Mountain"] = "Corazón humeante de la montaña",
		["Superior Mana Oil"] = "Aceite de maná excelente",
		["Superior Wizard Oil"] = "Aceite de zahorí excelente",
		["Void Sphere"] = "Esfera de vacío",
		["Wizard Oil"] = "Aceite de zahorí",

-- Engineering Recipes
		["Accurate Scope"] = "Mira de precisión",
		["Adamantite Arrow Maker"] = "Generador de flechas de adamantita",
		["Adamantite Frame"] = "Marco de adamantita",
		["Adamantite Grenade"] = "Granada de adamantita",
		["Adamantite Rifle"] = "Rifle de adamantita",
		["Adamantite Scope"] = "Mira de adamantita",
		["Adamantite Shell Machine"] = "Máquina de balas de adamantita",
		["Advanced Target Dummy"] = "Muñeco-diana avanzado",
		["Alarm-O-Bot"] = "Roboalarma gnómica",
		["Aquadynamic Fish Attractor"] = "Atraepeces acuadinámico",
		["Arcane Bomb"] = "Bomba Arcana",
		["Arcanite Dragonling"] = "Dragonizo de arcanita",
		["Arclight Spanner"] = "Llave inglesa arcoluz",
		["Big Bronze Bomb"] = "Bomba de bronce grande",
		["Big Iron Bomb"] = "Bomba de hierro grande",
		["Biznicks 247x128 Accurascope"] = "Acurascopio 247x128 de Biznicks",
		["Bloodvine Goggles"] = "Gafas vid de sangre",
		["Bloodvine Lens"] = "Lente vid de sangre",
		["Blue Firework"] = "Fuego de artificio azul",
		["Blue Rocket Cluster"] = "Traca de cohetes azules",
		["Bright-Eye Goggles"] = "Gafas ojo brillante",
		["Bronze Framework"] = "Marco de bronce",
		["Bronze Tube"] = "Tubo de bronce",
		["Catseye Ultra Goggles"] = "Ultragafas ojo de gato",
		["Coarse Blasting Powder"] = "Pólvora burda",
		["Coarse Dynamite"] = "Dinamita burda",
		["Cogspinner Goggles"] = "Gafas Volopiñón",
		["Compact Harvest Reaper Kit"] = "Juego de segador de la cosecha compacto",
		["Copper Modulator"] = "Modulador de cobre",
		["Copper Tube"] = "Tubo de cobre",
		["Core Marksman Rifle"] = "Rifle de tirador del Núcleo",
		["Crafted Heavy Shot"] = "Proyectil artesanal pesado",
		["Crafted Light Shot"] = "Proyectil artesanal ligero",
		["Crafted Solid Shot"] = "Proyectil artesanal sólido",
		["Craftsman's Monocle"] = "Monóculo de artesano",
		["Crashin' Thrashin' Robot"] = "Robot triturador",
		["Crude Scope"] = "Mira rudimentaria",
		["Dark Iron Bomb"] = "Bomba Hierro Negro",
		["Dark Iron Rifle"] = "Rifle Hierro Negro",
		["Deadly Blunderbuss"] = "Trabuco mortal",
		["Deadly Scope"] = "Mira mortal",
		["Deathblow X11 Goggles"] = "Gafas X11 Arremetida mortal",
		["Deepdive Helmet"] = "Casco de inmersión",
		["Delicate Arcanite Converter"] = "Conversor de arcanita delicado",
		["Dense Blasting Powder"] = "Pólvora densa",
		["Dense Dynamite"] = "Dinamita densa",
		["Destruction Holo-gogs"] = "Gafas holográficas de destrucción",
		["Dimensional Ripper - Area 52"] = "Desgarrador dimensional: Área 52",
		["Dimensional Ripper - Everlook"] = "Desgarrador dimensional: Vista Eterna",
		["Discombobulator Ray"] = "Rayo descombobulador",
		["Elemental Blasting Powder"] = "Pólvora elemental",
		["Elemental Seaforium Charge"] = "Carga de seforio elemental",
		["Explosive Sheep"] = "Oveja explosiva",
		["EZ-Thro Dynamite II"] = "Dinamita para tontos II",
		["EZ-Thro Dynamite"] = "Dinamita para tontos",
		["Fel Iron Bomb"] = "Bomba de hierro vil",
		["Fel Iron Casing"] = "Envoltura de hierro vil",
		["Fel Iron Musket"] = "Mosquete de hierro vil",
		["Fel Iron Shells"] = "Balas de hierro vil",
		["Fel Iron Toolbox"] = "Caja de herramientas de hierro vil",
		["Felsteel Boomstick"] = "Bocarda de acero vil",
		["Felsteel Stabilizer"] = "Estabilizador de acero vil",
		["Field Repair Bot 110G"] = "Robot de reparación de campo 110G",
		["Field Repair Bot 74A"] = "Robot de reparación de campo 74A",
		["Fire Goggles"] = "Gafas de Fuego",
		["Firework Cluster Launcher"] = "Lanzafuegos de tracas de cohetes",
		["Firework Launcher"] = "Lanzafuegos de artificio",
		["Flame Deflector"] = "Deflector de llamas",
		["Flash Bomb"] = "Bomba cegadora",
		["Flawless Arcanite Rifle"] = "Rifle de arcanita impecable",
		["Flying Machine"] = "Máquina voladora",
		["Flying Tiger Goggles"] = "Gafas de tigre volador",
		["Force Reactive Disk"] = "Disco reactivo a la fuerza",
		["Foreman's Enchanted Helmet"] = "Casco encantado de supervisor",
		["Foreman's Reinforced Helmet"] = "Casco reforzado de supervisor",
		["Frost Grenades"] = "Granadas de Escarcha",
		["Furious Gizmatic Goggles"] = "Gafas cacharráticas frenéticas",
		["Fused Wiring"] = "Cableado de fusibles",
		["Gadgetstorm Goggles"] = "Gafas trastotormenta",
		["Gnomish Battle Chicken"] = "Gallo de batalla gnómico",
		["Gnomish Battle Goggles"] = "Gafas gnomas de batalla",
		["Gnomish Cloaking Device"] = "Aparato de invisibilidad gnómico",
		["Gnomish Death Ray"] = "Rayo mortal gnómico",
		["Gnomish Flame Turret"] = "Torreta de llamas gnoma",
		["Gnomish Goggles"] = "Gafas gnómicas",
		["Gnomish Harm Prevention Belt"] = "Cinturón de prevención de daño gnómico",
		["Gnomish Mind Control Cap"] = "Gorro de control mental gnómico",
		["Gnomish Net-o-Matic Projector"] = "Proyector redomático gnómico",
		["Gnomish Poultryizer"] = "Pollotizador gnómico",
		["Gnomish Power Goggles"] = "Gafas gnómicas de poder",
		["Gnomish Rocket Boots"] = "Botas cohete gnómicas",
		["Gnomish Shrink Ray"] = "Rayo reductor gnómico",
		["Gnomish Universal Remote"] = "Mando universal gnómico",
		["Goblin Bomb Dispenser"] = "Dispensador de bombas goblin",
		["Goblin Construction Helmet"] = "Casco de albañil goblin",
		["Goblin Dragon Gun"] = "Escopeta dragón goblin",
		["Goblin Jumper Cables XL"] = "Desfibriladores goblin XL",
		["Goblin Jumper Cables"] = "Desfibriladores goblin",
		["Goblin Land Mine"] = "Mina terrestre goblin",
		["Goblin Mining Helmet"] = "Casco de minero goblin",
		["Goblin Mortar"] = "Mortero goblin",
		["Goblin Rocket Boots"] = "Botas cohete goblin",
		["Goblin Rocket Fuel Recipe"] = "Receta de combustible de cohete goblin",
		["Goblin Rocket Helmet"] = "Casco de cohete goblin",
		["Goblin Rocket Launcher"] = "Lanzacohetes goblin",
		["Goblin Sapper Charge"] = "Carga de zapador goblin",
		["Gold Power Core"] = "Núcleo de poder de oro",
		["Green Firework"] = "Fuego de artificio verde",
		["Green Lens"] = "Lente verde",
		["Green Rocket Cluster"] = "Traca de cohetes verdes",
		["Green Smoke Flare"] = "Bengala de humo verde",
		["Green Tinted Goggles"] = "Gafas tintadas de verde",
		["Gyro-balanced Khorium Destroyer"] = "Destructor de korio giroequilibrado",
		["Gyrochronatom"] = "Girocronátomo",
		["Gyrofreeze Ice Reflector"] = "Reflector de hielo girohielo",
		["Gyromatic Micro-Adjustor"] = "Microajustador giromático",
		["Handful of Copper Bolts"] = "Puñado de tornillos de cobre",
		["Handful of Fel Iron Bolts"] = "Puñado de tornillos de hierro vil",
		["Hardened Adamantite Tube"] = "Tubo de adamantita endurecida",
		["Healing Potion Injector"] = "Inyector de poción de sanación",
		["Heavy Blasting Powder"] = "Pólvora potente",
		["Heavy Dynamite"] = "Dinamita potente",
		["Hi-Explosive Bomb"] = "Bomba altamente explosiva",
		["Hi-Impact Mithril Slugs"] = "Balas de mitril de gran impacto",
		["Hyper-Radiant Flame Reflector"] = "Reflector de llamas hiperradiante",
		["Hyper-Vision Goggles"] = "Gafas de hipervisión",
		["Ice Deflector"] = "Deflector de hielo",
		["Icy Blasting Primers"] = "Cebos explosivos helados",
		["Inlaid Mithril Cylinder Plans"] = "Diseño de cilindro de mitril taraceado",
		["Iron Grenade"] = "Granada de hierro",
		["Iron Strut"] = "Tornapunta de hierro",
		["Justicebringer 2000 Specs"] = "Características de la Justiciera 2000",
		["Khorium Power Core"] = "Núcleo de poder de korio",
		["Khorium Scope"] = "Mira de korio",
		["Large Blue Rocket Cluster"] = "Traca de cohetes azules grandes",
		["Large Blue Rocket"] = "Cohete azul grande",
		["Large Copper Bomb"] = "Bomba grande de cobre",
		["Large Green Rocket Cluster"] = "Traca de cohetes verdes grandes",
		["Large Green Rocket"] = "Cohete verde grande",
		["Large Red Rocket Cluster"] = "Traca de cohetes rojos grandes",
		["Large Red Rocket"] = "Cohete rojo grande",
		["Large Seaforium Charge"] = "Carga de seforio grande",
		["Lifelike Mechanical Toad"] = "Sapo mecánico casi vivo",
		["Lil' Smoky"] = "Lil' Smoky",
		["Living Replicator Specs"] = "Características del Replicador viviente",
		["Lovingly Crafted Boomstick"] = "Bocarda fabricada con amor",
		["Magnified Moon Specs"] = "Características de la luna ampliada",
		["Major Recombobulator"] = "Recombobulador sublime",
		["Mana Potion Injector"] = "Inyector de poción de maná",
		["Master Engineer's Goggles"] = "Gafas de maestro ingeniero",
		["Masterwork Target Dummy"] = "Muñeco-diana magistral",
		["Mechanical Dragonling"] = "Dragonizo mecánico",
		["Mechanical Repair Kit"] = "Equipo de reparación mecánica",
		["Mechanical Squirrel"] = "Ardilla mecánica",
		["Minor Recombobulator"] = "Recombobulador menor",
		["Mithril Blunderbuss"] = "Trabuco de mitril",
		["Mithril Casing"] = "Envoltura de mitril",
		["Mithril Frag Bomb"] = "Bomba de fragmentación de mitril",
		["Mithril Gyro-Shot"] = "Girotiro de mitril",
		["Mithril Heavy-bore Rifle"] = "Rifle de gran calibre de mitril",
		["Mithril Mechanical Dragonling"] = "Dragonizo mecánico de mitril",
		["Mithril Tube"] = "Tubo de mitril",
		["Moonsight Rifle"] = "Rifle de vista lunar",
		["Nigh-Invulnerability Belt"] = "Cinturón de quasi-invulnerabilidad",
		["Ornate Khorium Rifle"] = "Rifle de korio ornamentado",
		["Ornate Spyglass"] = "Catalejo ornamentado",
		["Parachute Cloak"] = "Capa paracaídas",
		["Pet Bombling"] = "Bomba mascota",
		["Portable Bronze Mortar"] = "Mortero de bronce portátil",
		["Power Amplification Goggles"] = "Gafas de amplificación de poder",
		["Powerful Seaforium Charge"] = "Carga de seforio potente",
		["Powerheal 4000 Lens"] = "Lente de supersanación 4000",
		["Practice Lock"] = "Cerradura de prácticas",
		["Purple Smoke Flare"] = "Bengala de humo morado",
		["Red Firework"] = "Fuego de artificio rojo",
		["Red Rocket Cluster"] = "Traca de cohetes rojos",
		["Rocket Boots Xtreme"] = "Botas cohete Xtremo",
		["Rose Colored Goggles"] = "Gafas tintadas de rosa",
		["Rough Blasting Powder"] = "Pólvora férrea",
		["Rough Boomstick"] = "Bocarda férrea",
		["Rough Copper Bomb"] = "Bomba de cobre férrea",
		["Rough Dynamite"] = "Dinamita férrea",
		["Salt Shaker"] = "Salero",
		["Shadow Goggles"] = "Gafas de las Sombras",
		["Silver Contact"] = "Contacto de plata",
		["Silver-plated Shotgun"] = "Escopeta de chapa de plata",
		["Small Blue Rocket"] = "Cohete azul pequeño",
		["Small Bronze Bomb"] = "Bomba de bronce pequeña",
		["Small Green Rocket"] = "Cohete verde pequeño",
		["Small Red Rocket"] = "Cohete rojo pequeño",
		["Small Seaforium Charge"] = "Carga de seforio pequeña",
		["Snake Burst Firework"] = "Fuego de artificio con forma de culebra",
		["Sniper Scope"] = "Mira de francotirador",
		["SnowMaster 9000"] = "Señor de las nieves 9000",
		["Solid Blasting Powder"] = "Pólvora sólida",
		["Solid Dynamite"] = "Dinamita sólida",
		["Spellpower Goggles Xtreme Plus"] = "Gafas de poder de hechizo Xtremo Plus",
		["Spellpower Goggles Xtreme"] = "Gafas de poder de hechizo Xtremo",
		["Stabilized Eternium Scope"] = "Mira de eternium estabilizada",
		["Standard Scope"] = "Mira estándar",
		["Steam Tonk Controller"] = "Mando de tonque de vapor",
		["Super Sapper Charge"] = "Supercarga de zapador",
		["Surestrike Goggles v2.0"] = "Gafas de golpe seguro v2,0",
		["Tankatronic Goggles"] = "Gafas tanquetrónicas",
		["Target Dummy"] = "Muñeco-diana",
		["The Big One"] = "La grande",
		["The Bigger One"] = "La más grande",
		["The Mortar: Reloaded"] = "El mortero: recargado",
		["Thorium Grenade"] = "Granada de torio",
		["Thorium Rifle"] = "Rifle de torio",
		["Thorium Shells"] = "Proyectiles de torio",
		["Thorium Tube"] = "Tubo de torio",
		["Thorium Widget"] = "Trasto de torio",
		["Tranquil Mechanical Yeti"] = "Yeti mecánico tranquilo",
		["Truesilver Transformer"] = "Transformador de veraplata",
		["Turbo-Charged Flying Machine"] = "Mando de máquina voladora turboalimentada",
		["Ultra-Flash Shadow Reflector"] = "Reflector de las Sombras ultradeslumbrante",
		["Ultrasafe Transporter - Gadgetzan"] = "Transportador ultraseguro: Gadgetzan",
		["Ultrasafe Transporter - Toshley's Station"] = "Transportador ultraseguro: Estación de Toshley",
		["Ultra-Spectropic Detection Goggles"] = "Gafas de detección ultraespectrópicas",
		["Unstable Trigger"] = "Activador inestable",
		["Voice Amplification Modulator"] = "Modulador de amplificación de voz",
		["Whirring Bronze Gizmo"] = "Cacharros zumbones de bronce",
		["White Smoke Flare"] = "Bengala de humo blanco",
		["Wonderheal XT40 Shades"] = "Gafas de sol curamaravilla XT40",
		["World Enlarger"] = "Amplificador de mundo",
		["Zapthrottle Mote Extractor"] = "Extractor de motas de zapacelerador",

-- First Aid Recipes
		["Anti-Venom"] = "Contraveneno",
		["Heavy Linen Bandage"] = "Venda de lino gruesa",
		["Heavy Mageweave Bandage"] = "Venda de tejido mágico grueso",
		["Heavy Netherweave Bandage"] = "Venda de tejido abisal grueso",
		["Heavy Runecloth Bandage"] = "Venda de paño rúnico grueso",
		["Heavy Silk Bandage"] = "Venda de seda gruesa",
		["Heavy Wool Bandage"] = "Venda de lana gruesa",
		["Linen Bandage"] = "Venda de lino",
		["Mageweave Bandage"] = "Venda de tejido mágico",
		["Netherweave Bandage"] = "Venda de tejido abisal",
		["Powerful Anti-Venom"] = "Contraveneno potente",
		["Runecloth Bandage"] = "Venda de paño rúnico",
		["Silk Bandage"] = "Venda de seda",
		["Strong Anti-Venom"] = "Contraveneno fuerte",
		["Wool Bandage"] = "Venda de lana",

-- Jewelcrafting Recipes
		["Amulet of the Moon"] = "Amuleto de la Luna",
		["Aquamarine Pendant of the Warrior"] = "Colgante del Guerrero de aguamarina",
		["Aquamarine Signet"] = "Sello de aguamarina",
		["Arcane Khorium Band"] = "Sortija de korio Arcana",
		["Azure Moonstone Ring"] = "Anillo de piedra lunar azur",
		["Balanced Nightseye"] = "Ojo de noche equilibrado",
		["Balanced Shadowsong Amethyst"] = "Amatista Cantosombrío equilibrada",
		["Balanced Shadow Draenite"] = "Draenita de Sombras equilibrada",
		["Band of Natural Fire"] = "Sortija de fuego natural",
		["Barbaric Iron Collar"] = "Collera barbárica de hierro",
		["Blazing Citrine Ring"] = "Anillo de citrino llameante",
		["Blazing Eternium Band"] = "Sortija de eternio llameante",
		["Blood of Amber"] = "Sangre de ámbar",
		["Bold Blood Garnet"] = "Granate de sangre llamativo",
		["Bold Crimson Spinel"] = "Espinela carmesí llamativa",
		["Bold Living Ruby"] = "Rubí vivo llamativo",
		["Bracing Earthstorm Diamond"] = "Diamante de tormenta de tierra vigorizante",
		["Braided Copper Ring"] = "Anillo de cobre trenzado",
		["Braided Eternium Chain"] = "Cadena de eternio trenzada",
		["Bright Blood Garnet"] = "Granate de sangre brillante",
		["Bright Crimson Spinel"] = "Espinela carmesí brillante",
		["Bright Living Ruby"] = "Rubí vivo brillante",
		["Brilliant Dawnstone"] = "Piedra del alba luminosa",
		["Brilliant Golden Draenite"] = "Draenita dorada luminosa",
		["Brilliant Lionseye"] = "Ojo de león luminoso",
		["Brilliant Necklace"] = "Collar luminoso",
		["Brilliant Pearl Band"] = "Sortija de perla luminosa",
		["Bronze Band of Force"] = "Sortija de fuerza de bronce",
		["Bronze Setting"] = "Engarce de bronce",
		["Bronze Torc"] = "Torques de bronce",
		["Brutal Earthstorm Diamond"] = "Diamante de tormenta de tierra brutal",
		["Chain of the Twilight Owl"] = "Cadena del búho crepuscular",
		["Chaotic Skyfire Diamond"] = "Diamante de fuego celeste caótico",
		["Circlet of Arcane Might"] = "Aro de poderío Arcano",
		["Citrine Pendant of Golden Healing"] = "Colgante de citrino de sanación dorada",
		["Citrine Ring of Rapid Healing"] = "Anillo de citrino de sanación rápida",
		["Coarse Stone Statue"] = "Estatua de piedra burda",
		["Coronet of the Verdant Flame"] = "Nimbo de la llama verdeante",
		["Crimson Sun"] = "Sol carmesí",
		["Crown of the Sea Witch"] = "Corona de la Bruja del Mar",
		["Dazzling Deep Peridot"] = "Peridoto intenso deslumbrante",
		["Dazzling Seaspray Emerald"] = "Esmeralda de espuma de mar deslumbrante",
		["Dazzling Talasite"] = "Talasita deslumbrante",
		["Delicate Blood Garnet"] = "Granate de sangre delicado",
		["Delicate Copper Wire"] = "Hilo de cobre delicado",
		["Delicate Crimson Spinel"] = "Espinela carmesí delicada",
		["Delicate Eternium Ring"] = "Anillo de eternio delicado",
		["Delicate Living Ruby"] = "Rubí vivo delicado",
		["Dense Stone Statue"] = "Estatua de piedra densa",
		["Destructive Skyfire Diamond"] = "Diamante de fuego celeste destructor",
		["Diamond Focus Ring"] = "Anillo de diamante de enfoque",
		["Don Julio's Heart"] = "Corazón de Don Julio",
		["Elegant Silver Ring"] = "Anillo de plata elegante",
		["Embrace of the Dawn"] = "Abrazo del alba",
		["Emerald Crown of Destruction"] = "Corona de esmeralda de destrucción",
		["Emerald Lion Ring"] = "Anillo de león de esmeralda",
		["Enduring Deep Peridot"] = "Peridoto intenso duradero",
		["Enduring Seaspray Emerald"] = "Esmeralda de espuma de mar duradera",
		["Enduring Talasite"] = "Talasita firme",
		["Engraved Truesilver Ring"] = "Anillo de veraplata grabado",
		["Enigmatic Skyfire Diamond"] = "Diamante de fuego celeste enigmático",
		["Eye of the Night"] = "Ojo de la noche",
		["Facet of Eternity"] = "Faceta de eternidad",
		["Falling Star"] = "Estrella fugaz",
		["Fel Iron Blood Ring"] = "Anillo de sangre de hierro vil",
		["Figurine - Black Diamond Crab"] = "Figurilla: cangrejo de diamante negro",
		["Figurine - Black Pearl Panther"] = "Figurilla: pantera de perla negra",
		["Figurine - Dark Iron Scorpid"] = "Figurilla: escórpido de hierro negro",
		["Figurine - Dawnstone Crab"] = "Figurilla: cangrejo de piedra del alba",
		["Figurine - Emerald Owl"] = "Figurilla: búho de esmeralda",
		["Figurine - Felsteel Boar"] = "Figurilla: jabalí de acero vil",
		["Figurine - Golden Hare"] = "Figurilla: liebre dorada",
		["Figurine - Jade Owl"] = "Figurilla: búho de jade",
		["Figurine - Living Ruby Serpent"] = "Figurilla: serpiente de rubí vivo",
		["Figurine - Nightseye Panther"] = "Figurilla: pantera de ojo de noche",
		["Figurine - Ruby Serpent"] = "Figurilla: serpiente de rubí",
		["Figurine - Talasite Owl"] = "Figurilla: búho de talasita",
		["Figurine - Truesilver Boar"] = "Figurilla: jabalí de veraplata",
		["Figurine - Truesilver Crab"] = "Figurilla: cangrejo de veraplata",
		["Flashing Crimson Spinel"] = "Espinela carmesí ostentosa",
		["Flashing Living Ruby"] = "Rubí vivo ostentoso",
		["Gem Studded Band"] = "Sortija con incrustaciones de gemas",
		["Gleaming Dawnstone"] = "Piedra del alba reluciente",
		["Gleaming Golden Draenite"] = "Draenita dorada reluciente",
		["Gleaming Lionseye"] = "Ojo de león reluciente",
		["Glinting Flame Spessarite"] = "Espesartita de llamas destellante",
		["Glinting Noble Topaz"] = "Topacio noble destellante",
		["Glinting Pyrestone"] = "Piropiedra destelleante",
		["Gloom Band"] = "Sortija luminiscente",
		["Glowing Nightseye"] = "Ojo de noche resplandeciente",
		["Glowing Shadow Draenite"] = "Draenita de Sombras resplandeciente",
		["Glowing Shadowsong Amethyst"] = "Amatista Cantosombrío resplandeciente",
		["Glowing Thorium Band"] = "Sortija de torio resplandeciente",
		["Golden Draenite Ring"] = "Anillo de draenita dorado",
		["Golden Dragon Ring"] = "Anillo de dragón dorado",
		["Golden Ring of Power"] = "Anillo de oro de poder",
		["Great Dawnstone"] = "Gran piedra del alba",
		["Great Golden Draenite"] = "Gran draenita dorada",
		["Great Lionseye"] = "Gran Ojo de león",
		["Heavy Adamantite Ring"] = "Anillo de adamantita pesado",
		["Heavy Copper Ring"] = "Anillo de cobre pesado",
		["Heavy Felsteel Ring"] = "Anillo de jade pesado",
		["Heavy Golden Necklace of Battle"] = "Collar de batalla dorado pesado",
		["Heavy Iron Knuckles"] = "Nudillos de hierro pesados",
		["Heavy Jade Ring"] = "Anillo de jade pesado",
		["Heavy Silver Ring"] = "Anillo de plata pesado",
		["Heavy Stone Statue"] = "Estatua de piedra pesada",
		["Infused Nightseye"] = "Ojo de noche imbuido",
		["Infused Shadow Draenite"] = "Draenita de Sombras imbuida",
		["Infused Shadowsong Amethyst"] = "Amatista Cantosombrío imbuida",
		["Inlaid Malachite Ring"] = "Anillo de malaquita taraceado",
		["Inscribed Flame Spessarite"] = "Espesartita de llamas con inscripciones",
		["Inscribed Noble Topaz"] = "Topacio noble con inscripciones",
		["Inscribed Pyrestone"] = "Piropiedra con inscripciones",
		["Insightful Earthstorm Diamond"] = "Diamante de tormenta de tierra perspicaz",
		["Jade Pendant of Blasting"] = "Colgante de jade de Detonación",
		["Jagged Deep Peridot"] = "Peridoto intenso irregular",
		["Jagged Seaspray Emerald"] = "Esmeralda de espuma de mar irregular",
		["Jagged Talasite"] = "Talasita irregular",
		["Kailee's Rose"] = "Rosa de Kailee",
		["Khorium Band of Frost"] = "Sortija de korio de Escarcha",
		["Khorium Band of Leaves"] = "Sortija de korio de hojas",
		["Khorium Band of Shadows"] = "Sortija de korio de las Sombras",
		["Khorium Inferno Band"] = "Sortija de korio del infierno",
		["Living Emerald Pendant"] = "Colgante de esmeralda viva",
		["Living Ruby Pendant"] = "Colgante de rubí vivo",
		["Luminous Flame Spessarite"] = "Espesartita de llamas luminosa",
		["Luminous Noble Topaz"] = "Topacio noble luminoso",
		["Luminous Pyrestone"] = "Piropiedra luminosa",
		["Lustrous Azure Moonstone"] = "Piedra lunar azur luciente",
		["Lustrous Empyrean Sapphire"] = "Zafiro empíreo luciente",
		["Lustrous Star of Elune"] = "Estrella de Elune luciente",
		["Malachite Pendant"] = "Colgante de malaquita",
		["Mercurial Adamantite"] = "Adamantita mercúrica",
		["Mithril Filigree"] = "Filigrana de mitril",
		["Moonsoul Crown"] = "Corona alma lunar",
		["Mystic Dawnstone"] = "Piedra del alba mística",
		["Mystic Lionseye"] = "Ojo de león místico",
		["Mystical Skyfire Diamond"] = "Diamante de fuego celeste místico",
		["Necklace of the Deep"] = "Collar de las profundidades",
		["Necklace of the Diamond Tower"] = "Collar de la torre de diamantes",
		["Onslaught Ring"] = "Anillo de acometida",
		["Opal Necklace of Impact"] = "Collar de ópalo de impacto",
		["Ornate Tigerseye Necklace"] = "Collar de ojo de tigre ornamentado",
		["Pendant of Frozen Flame"] = "Colgante de la llama helada",
		["Pendant of Shadow's End"] = "Colgante del final de las Sombras",
		["Pendant of Thawing"] = "Colgante de deshielo",
		["Pendant of the Agate Shield"] = "Colgante del escudo de ágata",
		["Pendant of the Null Rune"] = "Colgante de la runa anodina",
		["Pendant of Withering"] = "Colgante de fulminación",
		["Potent Flame Spessarite"] = "Espesartita de llamas pujante",
		["Potent Noble Topaz"] = "Topacio noble pujante",
		["Potent Pyrestone"] = "Piropiedra pujante",
		["Powerful Earthstorm Diamond"] = "Diamante de tormenta de tierra potente",
		["Purified Jaggal Pearl"] = "Perla jaggal purificada",
		["Purified Shadow Pearl"] = "Perla de las Sombras purificada",
		["Radiant Deep Peridot"] = "Peridoto intenso radiante",
		["Radiant Seaspray Emerald"] = "Esmeralda de espuma de mar radiante",
		["Radiant Talasite"] = "Talasita radiante",
		["Red Ring of Destruction"] = "Anillo rojo de destrucción",
		["Relentless Earthstorm Diamond"] = "Diamante de tormenta de tierra incansable",
		["Rigid Dawnstone"] = "Piedra del alba rígida",
		["Rigid Golden Draenite"] = "Draenita dorada rígida",
		["Rigid Lionseye"] = "Ojo de león rígido",
		["Ring of Arcane Shielding"] = "Anillo de protección Arcana",
		["Ring of Bitter Shadows"] = "Anillo de sombras amargas",
		["Ring of Silver Might"] = "Anillo del poderío de la plata",
		["Ring of Twilight Shadows"] = "Anillo de sombras crepusculares",
		["Rough Stone Statue"] = "Estatua de piedra férrea",
		["Royal Nightseye"] = "Ojo de noche real",
		["Royal Shadow Draenite"] = "Draenita de Sombras real",
		["Royal Shadowsong Amethyst"] = "Amatista Cantosombrío real",
		["Ruby Crown of Restoration"] = "Corona de rubí de restauración",
		["Ruby Pendant of Fire"] = "Colgante de rubí de fuego",
		["Runed Blood Garnet"] = "Granate de sangre rúnico",
		["Runed Crimson Spinel"] = "Espinela carmesí rúnica",
		["Runed Living Ruby"] = "Rubí vivo rúnico",
		["Sapphire Pendant of Winter Night"] = "Colgante de zafiro de noche invernal",
		["Sapphire Signet"] = "Sello de zafiro",
		["Shifting Nightseye"] = "Ojo de noche cambiante",
		["Shifting Shadow Draenite"] = "Draenita de Sombras cambiante",
		["Shifting Shadowsong Amethyst"] = "Amatista Cantosombrío cambiante",
		["Simple Opal Ring"] = "Anillo de ópalo sencillo",
		["Simple Pearl Ring"] = "Anillo con perla sencillo",
		["Smooth Dawnstone"] = "Piedra del alba lisa",
		["Smooth Golden Draenite"] = "Draenita dorada lisa",
		["Smooth Lionseye"] = "Ojo de león liso",
		["Solid Azure Moonstone"] = "Piedra lunar azur maciza",
		["Solid Bronze Ring"] = "Anillo de bronce sólido",
		["Solid Empyrean Sapphire"] = "Zafiro empíreo sólido",
		["Solid Star of Elune"] = "Estrella de Elune sólida",
		["Solid Stone Statue"] = "Estatua de piedra sólida",
		["Sovereign Nightseye"] = "Ojo de noche soberano",
		["Sovereign Shadow Draenite"] = "Draenita de Sombras soberana",
		["Sovereign Shadowsong Amethyst"] = "Amatista Cantosombrío soberana",
		["Sparkling Azure Moonstone"] = "Piedra lunar azur chispeante",
		["Sparkling Empyrean Sapphire"] = "Zafiro empíreo chispeante",
		["Sparkling Star of Elune"] = "Estrella de Elune chispeante",
		["Steady Talasite"] = "Talasita firme",
		["Stone of Blades"] = "Piedra tajadera",
		["Stormy Azure Moonstone"] = "Piedra lunar azur tormentosa",
		["Stormy Empyrean Sapphire"] = "Zafiro empíreo tormentoso",
		["Stormy Star of Elune"] = "Estrella de Elune tormentosa",
		["Subtle Crimson Spinel"] = "Espinela carmesí sutil",
		["Subtle Living Ruby"] = "Rubí vivo sutil",
		["Swift Skyfire Diamond"] = "Diamante de fuego celeste veloz",
		["Teardrop Blood Garnet"] = "Lágrima de granate de sangre",
		["Teardrop Crimson Spinel"] = "Lágrima de espinela carmesí",
		["Teardrop Living Ruby"] = "Lágrima de rubí vivo",
		["Tenacious Earthstorm Diamond"] = "Diamante de tormenta de tierra tenaz",
		["The Aquamarine Ward"] = "La protección aguamarina",
		["The Black Pearl"] = "La perla negra",
		["The Frozen Eye"] = "El ojo helado",
		["The Jade Eye"] = "El ojo de jade",
		["The Natural Ward"] = "El resguardo natural",
		["Thick Adamantite Necklace"] = "Collar de adamantita grueso",
		["Thick Bronze Necklace"] = "Collar de bronce grueso",
		["Thick Dawnstone"] = "Piedra del alba gruesa",
		["Thick Felsteel Necklace"] = "Collar de acero vil grueso",
		["Thick Golden Draenite"] = "Draenita dorada gruesa",
		["Thick Lionseye"] = "Ojo de león grueso",
		["Thorium Setting"] = "Engarce de torio",
		["Thundering Skyfire Diamond"] = "Diamante de fuego celeste del trueno",
		["Tigerseye Band"] = "Sortija de ojo de tigre",
		["Truesilver Commander's Ring"] = "Anillo de veraplata de Comandante",
		["Truesilver Healing Ring"] = "Anillo de veraplata de sanación",
		["Veiled Flame Spessarite"] = "Espesartita de llamas velada",
		["Veiled Noble Topaz"] = "Topacio noble velado",
		["Veiled Pyrestone"] = "Piropiedra velada",
		["Wicked Flame Spessarite"] = "Espesartita de llamas maligna",
		["Wicked Moonstone Ring"] = "Anillo de piedra lunar maligno",
		["Wicked Noble Topaz"] = "Topacio noble maligno",
		["Wicked Pyrestone"] = "Piropiedra maligna",
		["Woven Copper Ring"] = "Anillo de cobre tejido",

-- Leatherworking Recipes
		["Arcane Armor Kit"] = "Refuerzo para armadura Arcano",
		["Bag of Many Hides"] = "Bolsa de muchos pellejos",
		["Barbaric Belt"] = "Cinturón barbárico",
		["Barbaric Bracers"] = "Brazales barbáricos",
		["Barbaric Gloves"] = "Guantes barbáricos",
		["Barbaric Harness"] = "Arnés barbárico",
		["Barbaric Leggings"] = "Leotardos barbáricos",
		["Barbaric Shoulders"] = "Sobrehombros barbáricos",
		["Belt of Deep Shadow"] = "Cinturón de sombra profunda",
		["Belt of Natural Power"] = "Cinturón de poder natural",
		["Belt of the Black Eagle"] = "Cinturón del águila negra",
		["Big Voodoo Cloak"] = "Capa de gran vudú",
		["Big Voodoo Mask"] = "Máscara de gran vudú",
		["Big Voodoo Pants"] = "Pantalones de gran vudú",
		["Big Voodoo Robe"] = "Toga de gran vudú",
		["Bindings of Lightning Reflexes"] = "Ataduras de reflejos de relámpago",
		["Black Dragonscale Boots"] = "Botas de escamas de dragón negras",
		["Black Dragonscale Breastplate"] = "Coraza de escamas de dragón negro",
		["Black Dragonscale Leggings"] = "Leotardos de escamas de dragón negro",
		["Black Dragonscale Shoulders"] = "Sobrehombros de escamas de dragón negro",
		["Black Whelp Cloak"] = "Capa de cría negra",
		["Black Whelp Tunic"] = "Túnica de cría negra",
		["Blackstorm Leggings"] = "Leotardos de tormenta negra",
		["Blastguard Belt"] = "Cinturón antiexplosión",
		["Blastguard Boots"] = "Botas antiexplosión",
		["Blastguard Pants"] = "Pantalones antiexplosión",
		["Blood Tiger Breastplate"] = "Coraza de tigre de sangre",
		["Blood Tiger Shoulders"] = "Sobrehombros de tigre de sangre",
		["Blue Dragonscale Breastplate"] = "Coraza de escamas de dragón azul",
		["Blue Dragonscale Leggings"] = "Leotardos de escamas de dragón azul",
		["Blue Dragonscale Shoulders"] = "Sobrehombros de escamas de dragón azul",
		["Boots of Natural Grace"] = "Botas de gracia natural",
		["Boots of Shackled Souls"] = "Botas de almas encadenadas",
		["Boots of the Crimson Hawk"] = "Botas del halcón carmesí",
		["Boots of Utter Darkness"] = "Botas de oscuridad absoluta",
		["Bracers of Renewed Life"] = "Brazales de vida renovada",
		["Bracers of Shackled Souls"] = "Brazales de almas encadenadas",
		["Bramblewood Belt"] = "Cinturón zarzal",
		["Bramblewood Boots"] = "Botas zarzal",
		["Bramblewood Helm"] = "Yelmo zarzal",
		["Chimeric Boots"] = "Botas quiméricas",
		["Chimeric Gloves"] = "Guantes quiméricos",
		["Chimeric Leggings"] = "Leotardos quiméricos",
		["Chimeric Vest"] = "Jubón quimérico",
		["Chromatic Cloak"] = "Capa cromática",
		["Chromatic Gauntlets"] = "Guanteletes cromáticos",
		["Clefthide Leg Armor"] = "Armadura para pierna de pellejo grieta",
		["Cloak of Darkness"] = "Capa de oscuridad",
		["Cobrahide Leg Armor"] = "Armadura para pierna de pellejo de cobra",
		["Cobrascale Gloves"] = "Guantes de escamas de cobra",
		["Cobrascale Hood"] = "Caperuza de escamas de cobra",
		["Comfortable Insoles"] = "Plantillas cómodas",
		["Comfortable Leather Hat"] = "Sombrero de cuero cómodo",
		["Core Armor Kit"] = "Refuerzo para armadura del Núcleo",
		["Corehound Belt"] = "Cinturón de can del Núcleo",
		["Corehound Boots"] = "Botas de can del Núcleo",
		["Cured Heavy Hide"] = "Pellejo pesado curado",
		["Cured Light Hide"] = "Pellejo ligero curado",
		["Cured Medium Hide"] = "Pellejo medio curado",
		["Cured Rugged Hide"] = "Pellejo basto curado",
		["Cured Thick Hide"] = "Pellejo grueso curado",
		["Dark Leather Belt"] = "Cinturón de cuero oscuro",
		["Dark Leather Boots"] = "Botas de cuero oscuro",
		["Dark Leather Cloak"] = "Capa de cuero oscuro",
		["Dark Leather Gloves"] = "Guantes de cuero oscuro",
		["Dark Leather Pants"] = "Pantalones de cuero oscuro",
		["Dark Leather Shoulders"] = "Sobrehombros de cuero oscuro",
		["Dark Leather Tunic"] = "Túnica de cuero oscuro",
		["Dawn Treaders"] = "Botines del Alba",
		["Deviate Scale Belt"] = "Cinturón de escamas descarriadas",
		["Deviate Scale Cloak"] = "Capa de escamas descarriadas",
		["Deviate Scale Gloves"] = "Guantes de escamas descarriadas",
		["Devilsaur Gauntlets"] = "Guanteletes de demosaurio",
		["Devilsaur Leggings"] = "Leotardos de demosaurio",
		["Dragonscale Breastplate"] = "Coraza de escamas de dragón",
		["Dragonscale Gauntlets"] = "Guanteletes de escamas de dragón",
		["Dragonstrike Leggings"] = "Leotardos de golpe de dragón",
		["Dreamscale Breastplate"] = "Coraza de escamas oníricas",
		["Drums of Battle"] = "Tambores de batalla",
		["Drums of Panic"] = "Tambores de pánico",
		["Drums of Restoration"] = "Tambores de restauración",
		["Drums of Speed"] = "Tambores de velocidad",
		["Drums of War"] = "Tambores de guerra",
		["Dusky Belt"] = "Cinturón oscurecido",
		["Dusky Boots"] = "Botas oscurecidas",
		["Dusky Bracers"] = "Brazales oscurecidos",
		["Dusky Leather Armor"] = "Armadura de cuero oscurecido",
		["Dusky Leather Leggings"] = "Leotardos de cuero oscurecido",
		["Earthen Leather Shoulders"] = "Sobrehombros de cuero terráneo",
		["Earthen Netherscale Boots"] = "Botas de escamas abisales terráneas",
		["Ebon Netherscale Belt"] = "Cinturón de escamas abisales de ébano",
		["Ebon Netherscale Bracers"] = "Brazales de escamas abisales de ébano",
		["Ebon Netherscale Breastplate"] = "Coraza de escamas abisales de ébano",
		["Embossed Leather Boots"] = "Botas de cuero estampado",
		["Embossed Leather Cloak"] = "Capa de cuero estampado",
		["Embossed Leather Gloves"] = "Guantes de cuero estampado",
		["Embossed Leather Pants"] = "Pantalones de cuero estampado",
		["Embossed Leather Vest"] = "Jubón de cuero estampado",
		["Enchanted Clefthoof Boots"] = "Botas uñagrieta encantadas",
		["Enchanted Clefthoof Gloves"] = "Guantes uñagrieta encantados",
		["Enchanted Clefthoof Leggings"] = "Leotardos uñagrieta encantados",
		["Enchanted Felscale Boots"] = "Botas de escamas viles encantadas",
		["Enchanted Felscale Gloves"] = "Guantes de escamas viles encantados",
		["Enchanted Felscale Leggings"] = "Leotardos de escamas viles encantados",
		["Feathered Breastplate"] = "Coraza de plumas",
		["Fel Leather Boots"] = "Botas de cuero vil",
		["Fel Leather Gloves"] = "Guantes de cuero vil",
		["Fel Leather Leggings"] = "Leotardos de cuero vil",
		["Felscale Boots"] = "Botas de escamas viles",
		["Felscale Breastplate"] = "Coraza de escamas viles",
		["Felscale Gloves"] = "Guantes de escamas viles",
		["Felscale Pants"] = "Pantalones de escamas viles",
		["Felstalker Belt"] = "Cinturón de acechador vil",
		["Felstalker Bracer"] = "Brazal de acechador vil",
		["Felstalker Breastplate"] = "Coraza de acechador vil",
		["Fine Leather Belt"] = "Cinturón de cuero refinado",
		["Fine Leather Boots"] = "Botas de cuero refinado",
		["Fine Leather Cloak"] = "Capa de cuero refinado",
		["Fine Leather Gloves"] = "Guantes de cuero refinado",
		["Fine Leather Pants"] = "Pantalones de cuero refinado",
		["Fine Leather Tunic"] = "Túnica de cuero refinado",
		["Flame Armor Kit"] = "Refuerzo para armadura contra el Fuego",
		["Flamescale Belt"] = "Cinturón de flamaescama",
		["Flamescale Boots"] = "Botas de flamaescama",
		["Flamescale Leggings"] = "Leotardos de flamaescama",
		["Fletcher's Gloves"] = "Guantes de flechero",
		["Frost Armor Kit"] = "Refuerzo para armadura contra Escarcha",
		["Frost Leather Cloak"] = "Capa de cuero de Escarcha",
		["Frostsaber Boots"] = "Botas sable de hielo",
		["Frostsaber Gloves"] = "Guantes sable de hielo",
		["Frostsaber Leggings"] = "Leotardos sable de hielo",
		["Frostsaber Tunic"] = "Túnica sable de hielo",
		["Gauntlets of the Sea"] = "Guanteletes del Mar",
		["Gem-studded Leather Belt"] = "Cinturón de cuero con gemas incrustadas",
		["Girdle of Insight"] = "Faja de perspicacia",
		["Glove Reinforcements"] = "Refuerzos de guantes",
		["Gloves of the Greatfather"] = "Guantes del Padre Invierno",
		["Gloves of the Living Touch"] = "Guantes del toque viviente",
		["Golden Dragonstrike Breastplate"] = "Coraza de golpe de dragón dorada",
		["Golden Mantle of the Dawn"] = "Manto del Alba dorado",
		["Greaves of Shackled Souls"] = "Grebas de almas encadenadas",
		["Green Dragonscale Breastplate"] = "Coraza de escamas de dragón verde",
		["Green Dragonscale Gauntlets"] = "Guanteletes de escamas de dragón verde",
		["Green Dragonscale Leggings"] = "Leotardos de escamas de dragón verde",
		["Green Leather Armor"] = "Armadura de cuero verde",
		["Green Leather Belt"] = "Cinturón de cuero verde",
		["Green Leather Bracers"] = "Brazales de cuero verdes",
		["Green Whelp Armor"] = "Armadura de cría verde",
		["Green Whelp Bracers"] = "Brazales de cría verde",
		["Guardian Armor"] = "Armadura de guardián",
		["Guardian Belt"] = "Cinturón de guardián",
		["Guardian Cloak"] = "Capa de guardián",
		["Guardian Gloves"] = "Guantes de guardián",
		["Guardian Leather Bracers"] = "Brazales de cuero de guardián",
		["Guardian Pants"] = "Pantalones de guardián",
		["Handstitched Leather Belt"] = "Cinturón de cuero cosido a mano",
		["Handstitched Leather Boots"] = "Botas de cuero cosidas a mano",
		["Handstitched Leather Bracers"] = "Brazales de cuero cosidos a mano",
		["Handstitched Leather Cloak"] = "Capa de cuero cosida a mano",
		["Handstitched Leather Pants"] = "Pantalones de cuero cosidos a mano",
		["Handstitched Leather Vest"] = "Jubón de cuero cosido a mano",
		["Heavy Armor Kit"] = "Refuerzo para armadura pesado",
		["Heavy Clefthoof Boots"] = "Botas uñagrieta pesadas",
		["Heavy Clefthoof Leggings"] = "Leotardos uñagrieta pesados",
		["Heavy Clefthoof Vest"] = "Jubón uñagrieta pesado",
		["Heavy Earthen Gloves"] = "Guantes terráneos gruesos",
		["Heavy Knothide Armor Kit"] = "Refuerzo para armadura de pellejo nudoso grueso",
		["Heavy Knothide Leather"] = "Cuero de pellejo nudoso grueso",
		["Heavy Leather Ammo Pouch"] = "Faltriquera para munición de cuero pesado",
		["Heavy Leather Ball"] = "Bola de cuero pesado",
		["Heavy Leather"] = "Cuero pesado",
		["Heavy Quiver"] = "Carcaj pesado",
		["Heavy Scorpid Belt"] = "Cinturón de escórpido pesado",
		["Heavy Scorpid Bracers"] = "Brazales de escórpido pesados",
		["Heavy Scorpid Gauntlets"] = "Guanteletes de escórpido pesados",
		["Heavy Scorpid Helm"] = "Yelmo de escórpido pesado",
		["Heavy Scorpid Leggings"] = "Leotardos de escórpido pesados",
		["Heavy Scorpid Shoulders"] = "Sobrehombros de escórpido gruesos",
		["Heavy Scorpid Vest"] = "Jubón de escórpido pesado",
		["Helm of Fire"] = "Yelmo de fuego",
		["Herbalist's Gloves"] = "Guantes de herborista",
		["Hide of the Wild"] = "Capa de fiera",
		["Hillman's Belt"] = "Cinturón de montañero",
		["Hillman's Cloak"] = "Capa de montañero",
		["Hillman's Leather Gloves"] = "Guantes de cuero de montañero",
		["Hillman's Leather Vest"] = "Jubón de cuero de montañero",
		["Hillman's Shoulders"] = "Sobrehombros de montañero",
		["Hood of Primal Life"] = "Caperuza de vida primigenia",
		["Hurricane Boots"] = "Botas de huracán",
		["Icy Scale Bracers"] = "Brazales de escamas heladas",
		["Icy Scale Breastplate"] = "Coraza de escamas heladas",
		["Icy Scale Gauntlets"] = "Guanteletes de escamas heladas",
		["Ironfeather Breastplate"] = "Coraza plumahierro",
		["Ironfeather Shoulders"] = "Sobrehombros plumahierro",
		["Knothide Ammo Pouch"] = "Faltriquera para munición de pellejo nudoso",
		["Knothide Armor Kit"] = "Refuerzo para armadura de pellejo nudoso",
		["Knothide Leather"] = "Cuero de pellejo nudoso",
		["Knothide Quiver"] = "Carcaj de pellejo nudoso",
		["Kodo Hide Bag"] = "Bolsa de pellejo de kodo",
		["Lava Belt"] = "Cinturón de lava",
		["Leatherworker's Satchel"] = "Cartera de peletero",
		["Light Armor Kit"] = "Refuerzo para armadura ligero",
		["Light Leather Bracers"] = "Brazales de cuero ligero",
		["Light Leather Pants"] = "Pantalones de cuero ligero",
		["Light Leather Quiver"] = "Carcaj de cuero ligero",
		["Light Leather"] = "Cuero ligero",
		["Living Breastplate"] = "Coraza viva",
		["Living Crystal Breastplate"] = "Coraza de cristal viviente",
		["Living Dragonscale Helm"] = "Yelmo de escamas de dragón viviente",
		["Living Earth Bindings"] = "Ataduras Tierra Viva",
		["Living Earth Shoulders"] = "Sobrehombros Tierra Viva",
		["Living Leggings"] = "Leotardos vivos",
		["Living Shoulders"] = "Sobrehombros vivos",
		["Magister's Armor Kit"] = "Refuerzo para armadura de magister",
		["Medium Armor Kit"] = "Refuerzo para armadura medio",
		["Medium Leather"] = "Cuero medio",
		["Might of the Timbermaw"] = "Poderío de los Fauces de Madera",
		["Molten Belt"] = "Cinturón de arrabio",
		["Molten Helm"] = "Yelmo de arrabio",
		["Mongoose Boots"] = "Botas de mangosta",
		["Monsoon Belt"] = "Cinturón de monzón",
		["Moonglow Vest"] = "Jubón resplandor lunar",
		["Murloc Scale Belt"] = "Cinturón de escamas de múrloc",
		["Murloc Scale Bracers"] = "Brazales de escamas de múrloc",
		["Murloc Scale Breastplate"] = "Coraza de escamas de múrloc",
		["Nature Armor Kit"] = "Refuerzo para armadura contra la Naturaleza",
		["Nethercleft Leg Armor"] = "Armadura para pierna grieta abisal",
		["Nethercobra Leg Armor"] = "Armadura para pierna cobra abisal",
		["Netherdrake Gloves"] = "Guantes de draco abisal",
		["Netherdrake Helm"] = "Yelmo de draco abisal",
		["Netherfury Belt"] = "Cinturón de furia abisal",
		["Netherfury Boots"] = "Botas de furia abisal",
		["Netherfury Leggings"] = "Leotardos de furia abisal",
		["Netherscale Ammo Pouch"] = "Faltriquera de munición de escamas abisales",
		["Netherstrike Belt"] = "Cinturón de golpe abisal",
		["Netherstrike Bracers"] = "Brazales de golpe abisal",
		["Netherstrike Breastplate"] = "Coraza de golpe abisal",
		["Nightscape Boots"] = "Botas Nochefugaz",
		["Nightscape Headband"] = "Cinta Nochefugaz",
		["Nightscape Pants"] = "Pantalones Nochefugaz",
		["Nightscape Shoulders"] = "Sobrehombros Nochefugaz",
		["Nightscape Tunic"] = "Túnica Nochefugaz",
		["Nimble Leather Gloves"] = "Guantes de cuero livianos",
		["Onyxia Scale Cloak"] = "Capa de escamas de Onyxia",
		["Pilferer's Gloves"] = "Guantes de ratero",
		["Polar Bracers"] = "Brazales polares",
		["Polar Gloves"] = "Guantes polares",
		["Polar Tunic"] = "Túnica polar",
		["Primal Batskin Bracers"] = "Brazales de piel de murciélago primigenio",
		["Primal Batskin Gloves"] = "Guantes de piel de murciélago primigenio",
		["Primal Batskin Jerkin"] = "Chaleco de piel de murciélago primigenio",
		["Primalstorm Breastplate"] = "Coraza de tormenta primigenia",
		["Primalstrike Belt"] = "Cinturón de golpe primigenio",
		["Primalstrike Bracers"] = "Brazales de golpe primigenio",
		["Primalstrike Vest"] = "Jubón de golpe primigenio",
		["Quickdraw Quiver"] = "Carcaj rápido",
		["Quiver of a Thousand Feathers"] = "Carcaj de mil plumas",
		["Raptor Hide Belt"] = "Cinturón de pellejo de raptor",
		["Raptor Hide Harness"] = "Arnés de pellejo de raptor",
		["Red Dragonscale Breastplate"] = "Coraza de escamas de dragón rojas",
		["Red Whelp Gloves"] = "Guantes de cría roja",
		["Redeemed Soul Cinch"] = "Cincho de alma redimida",
		["Redeemed Soul Legguards"] = "Musleras de alma redimida",
		["Redeemed Soul Moccasins"] = "Mocasines de alma redimida",
		["Redeemed Soul Wristguards"] = "Guardamuñecas de alma redimida",
		["Reinforced Mining Bag"] = "Bolsa de minero reforzada",
		["Riding Crop"] = "Fusta",
		["Rugged Armor Kit"] = "Refuerzo para armadura basto",
		["Rugged Leather Pants"] = "Pantalones de cuero basto",
		["Rugged Leather"] = "Cuero basto",
		["Runic Leather Armor"] = "Armadura de cuero rúnico",
		["Runic Leather Belt"] = "Cinturón de cuero rúnico",
		["Runic Leather Bracers"] = "Brazales de cuero rúnico",
		["Runic Leather Gauntlets"] = "Guanteletes de cuero rúnico",
		["Runic Leather Headband"] = "Cinta de cuero rúnico",
		["Runic Leather Pants"] = "Pantalones de cuero rúnico",
		["Runic Leather Shoulders"] = "Sobrehombros de cuero rúnico",
		["Sandstalker Bracers"] = "Brazales acecharenas",
		["Sandstalker Breastplate"] = "Coraza acecharenas",
		["Sandstalker Gauntlets"] = "Guanteletes acecharenas",
		["Scaled Draenic Boots"] = "Botas draénicas escamadas",
		["Scaled Draenic Gloves"] = "Guantes draénicos escamados",
		["Scaled Draenic Pants"] = "Pantalones draénicos escamados",
		["Scaled Draenic Vest"] = "Jubón draénico escamado",
		["Shadow Armor Kit"] = "Refuerzo para armadura de las Sombras",
		["Shadowprowler's Chestguard"] = "Coselete de merodeador de las Sombras",
		["Shadowskin Gloves"] = "Guantes sombradermos",
		["Shifting Cloak"] = "Capa ondeante",
		["Shoulderpads of Renewed Life"] = "Hombreras de vida renovada",
		["Shoulders of Lightning Reflexes"] = "Sobrehombros de reflejos de relámpago",
		["Small Leather Ammo Pouch"] = "Faltriquera de munición de cuero pequeña",
		["Spitfire Bracers"] = "Brazales escupefuego",
		["Spitfire Breastplate"] = "Coraza Escupefuego",
		["Spitfire Gauntlets"] = "Guanteletes escupefuego",
		["Stormshroud Armor"] = "Armadura de sudario de tormenta",
		["Stormshroud Gloves"] = "Guantes de sudario de tormenta",
		["Stormshroud Pants"] = "Pantalones de sudario de tormenta",
		["Stormshroud Shoulders"] = "Sobrehombros de sudario de tormenta",
		["Stylin' Adventure Hat"] = "Sombrero de aventurero a la moda",
		["Stylin' Crimson Hat"] = "Sombrero carmesí a la moda",
		["Stylin' Jungle Hat"] = "Sombrero de la jungla a la moda",
		["Stylin' Purple Hat"] = "Sombrero morado a la moda",
		["Swift Boots"] = "Botas prestas",
		["Swift Flight Bracers"] = "Brazales de Vuelo veloz",
		["Swiftstrike Bracers"] = "Brazales Golpeveloz",
		["Swiftstrike Shoulders"] = "Sobrehombros Golpeveloz",
		["Thick Armor Kit"] = "Refuerzo para armadura grueso",
		["Thick Draenic Boots"] = "Botas draénicas gruesas",
		["Thick Draenic Gloves"] = "Guantes draénicos gruesos",
		["Thick Draenic Pants"] = "Pantalones draénicos gruesos",
		["Thick Draenic Vest"] = "Jubón draénico grueso",
		["Thick Leather Ammo Pouch"] = "Faltriquera de munición de cuero grueso",
		["Thick Leather"] = "Cuero grueso",
		["Thick Murloc Armor"] = "Armadura múrloc gruesa",
		["Thick Netherscale Breastplate"] = "Coraza de escamas abisales gruesa",
		["Timbermaw Brawlers"] = "Guantes de cuero Fauces de Madera",
		["Tough Scorpid Boots"] = "Botas de escórpido resistentes",
		["Tough Scorpid Bracers"] = "Brazales de escórpido resistentes",
		["Tough Scorpid Breastplate"] = "Coraza de escórpido resistente",
		["Tough Scorpid Gloves"] = "Guantes de escórpido resistentes",
		["Tough Scorpid Helm"] = "Yelmo de escórpido resistente",
		["Tough Scorpid Leggings"] = "Leotardos de escórpido resistentes",
		["Tough Scorpid Shoulders"] = "Sobrehombros de escórpido resistentes",
		["Toughened Leather Armor"] = "Armadura de cuero fortalecido",
		["Toughened Leather Gloves"] = "Guantes de cuero fortalecido",
		["Turtle Scale Bracers"] = "Brazales de escamas de tortuga",
		["Turtle Scale Breastplate"] = "Coraza de escamas de tortuga",
		["Turtle Scale Gloves"] = "Guantes de escamas de tortuga",
		["Turtle Scale Helm"] = "Yelmo de escamas de tortuga",
		["Turtle Scale Leggings"] = "Leotardos de escamas de tortuga",
		["Vindicator's Armor Kit"] = "Refuerzo para armadura de vindicador",
		["Volcanic Breastplate"] = "Coraza volcánica",
		["Volcanic Leggings"] = "Leotardos volcánicos",
		["Volcanic Shoulders"] = "Sobrehombros volcánicos",
		["Waistguard of Shackled Souls"] = "Guardarrenes de almas encadenadas",
		["Warbear Harness"] = "Arnés de oso de guerra",
		["Warbear Woolies"] = "Prendas de lana de oso de guerra",
		["White Leather Jerkin"] = "Chaleco de cuero blanco",
		["Wicked Leather Armor"] = "Armadura de cuero maligno",
		["Wicked Leather Belt"] = "Cinturón de cuero maligno",
		["Wicked Leather Bracers"] = "Brazales de cuero maligno",
		["Wicked Leather Gauntlets"] = "Guanteletes de cuero maligno",
		["Wicked Leather Headband"] = "Cinta de cuero maligno",
		["Wicked Leather Pants"] = "Pantalones de cuero maligno",
		["Wild Draenish Boots"] = "Botas draenianas salvajes",
		["Wild Draenish Gloves"] = "Guantes draenianos salvajes",
		["Wild Draenish Leggings"] = "Leotardos draenianos salvajes",
		["Wild Draenish Vest"] = "Jubón draeniano salvaje",
		["Wild Leather Boots"] = "Botas de cuero salvaje",
		["Wild Leather Cloak"] = "Capa de cuero salvaje",
		["Wild Leather Helmet"] = "Casco de cuero salvaje",
		["Wild Leather Leggings"] = "Leotardos de cuero salvaje",
		["Wild Leather Shoulders"] = "Sobrehombros de cuero salvaje",
		["Wild Leather Vest"] = "Jubón de cuero salvaje",
		["Wildfeather Leggings"] = "Leotardos plumasalvaje",
		["Windhawk Belt"] = "Cinturón de halcón del viento",
		["Windhawk Bracers"] = "Brazales de halcón del viento",
		["Windhawk Hauberk"] = "Camisote de halcón del viento",
		["Windscale Hood"] = "Caperuza de escamas de viento",
		["Windslayer Wraps"] = "Guantes destripaviento",
		["Windstrike Gloves"] = "Guantes de golpe de viento",
		["Winter Boots"] = "Botas de invierno",
		["Wolfshead Helm"] = "Yelmo cabeza de lobo",
		--["Leather Gauntlets of the Sun"] = true,
		--["Leather Chestguard of the Sun"] = true,
		--["Fletcher's Gloves of the Phoenix"] = true,
		--["Embrace of the Phoenix"] = true,
		--["Sun-Drenched Scale Gloves"] = true,
		--["Sun-Drenched Scale Chestguard"] = true,
		--["Carapace of Sun and Shadow"] = true,
		--["Gloves of Immortal Dusk"] = true,

-- Smelting Recipes
		["Earth Shatter"] = "Desmenuzar tierra",
		["Fire Sunder"] = "Hender Fuego",
		["Smelt Adamantite"] = "Fundir adamantita",
		["Smelt Bronze"] = "Fundir bronce",
		["Smelt Copper"] = "Fundir cobre",
		["Smelt Dark Iron"] = "Fundir hierro negro",
		["Smelt Elementium"] = "Fundir elementium",
		["Smelt Eternium"] = "Fundir eternio",
		["Smelt Fel Iron"] = "Fundir hierro vil",
		["Smelt Felsteel"] = "Fundir acero vil",
		["Smelt Gold"] = "Fundir oro",
		["Smelt Hardened Adamantite"] = "Fundir adamantita endurecida",
		["Smelt Iron"] = "Fundir hierro",
		["Smelt Khorium"] = "Fundir korio",
		["Smelt Mithril"] = "Fundir mitril",
		["Smelt Silver"] = "Fundir plata",
		["Smelt Steel"] = "Fundir acero",
		["Smelt Thorium"] = "Fundir torio",
		["Smelt Tin"] = "Fundir estaño",
		["Smelt Truesilver"] = "Fundir veraplata",

-- Rogue Poison Recipes

-- Tailoring Recipes
		["Admiral's Hat"] = "Sombrero de almirante",
		["Arcanoweave Boots"] = "Botas de tejido Arcano",
		["Arcanoweave Bracers"] = "Brazales de tejido Arcano",
		["Arcanoweave Robe"] = "Toga de tejido Arcano",
		["Argent Boots"] = "Botas Argenta",
		["Argent Shoulders"] = "Sobrehombros Argenta",
		["Azure Shoulders"] = "Sobrehombros azur",
		["Azure Silk Belt"] = "Cinturón de seda azur",
		["Azure Silk Cloak"] = "Capa de seda azur",
		["Azure Silk Gloves"] = "Guantes de seda azur",
		["Azure Silk Hood"] = "Caperuza de seda azur",
		["Azure Silk Pants"] = "Pantalones de seda azur",
		["Azure Silk Vest"] = "Jubón de seda azur",
		["Bag of Jewels"] = "Bolsa de joyas",
		["Barbaric Linen Vest"] = "Jubón de lino barbárico",
		["Battlecast Hood"] = "Caperuza de conjuro de batalla",
		["Battlecast Pants"] = "Pantalones de conjuro de batalla",
		["Belt of Blasting"] = "Cinturón de detonación",
		["Belt of the Archmage"] = "Cinturón del archimago",
		["Belt of the Long Road"] = "Cinturón del largo camino",
		["Big Bag of Enchantment"] = "Bolsa de encantamiento grande",
		["Black Belt of Knowledge"] = "Cinturón negro de sabiduría",
		["Black Mageweave Boots"] = "Botas de tejido mágico negras",
		["Black Mageweave Gloves"] = "Guantes de tejido mágico negros",
		["Black Mageweave Headband"] = "Cinta de tejido mágico negra",
		["Black Mageweave Leggings"] = "Leotardos de tejido mágico negros",
		["Black Mageweave Robe"] = "Toga de tejido mágico negra",
		["Black Mageweave Shoulders"] = "Sobrehombros de tejido mágico negros",
		["Black Mageweave Vest"] = "Jubón de tejido mágico negro",
		["Black Silk Pack"] = "Talega de seda negra",
		["Black Swashbuckler's Shirt"] = "Camisa de espadachín negra",
		["Blackstrike Bracers"] = "Brazales golpenegro",
		["Bloodvine Boots"] = "Botas vid de sangre",
		["Bloodvine Leggings"] = "Leotardos vid de sangre",
		["Bloodvine Vest"] = "Jubón vid de sangre",
		["Blue Linen Robe"] = "Toga de lino azul",
		["Blue Linen Shirt"] = "Camisa de lino azul",
		["Blue Linen Vest"] = "Jubón de lino azul",
		["Blue Overalls"] = "Mono azul",
		["Bolt of Imbued Netherweave"] = "Madeja de tejido abisal imbuido",
		["Bolt of Linen Cloth"] = "Madeja de paño de lino",
		["Bolt of Mageweave"] = "Madeja de tejido mágico",
		["Bolt of Netherweave"] = "Madeja de tejido abisal",
		["Bolt of Runecloth"] = "Madeja de paño rúnico",
		["Bolt of Silk Cloth"] = "Madeja de paño de seda",
		["Bolt of Soulcloth"] = "Madeja de paño de alma",
		["Bolt of Woolen Cloth"] = "Madeja de paño de lana",
		["Boots of Blasting"] = "Botas de detonación",
		["Boots of the Enchanter"] = "Botas del encantador",
		["Boots of the Long Road"] = "Botas del largo camino",
		["Bottomless Bag"] = "Bolsa sin fondo",
		["Bracers of Havok"] = "Brazales del caos",
		["Bracers of Nimble Thought"] = "Brazales de pensamiento ágil",
		["Bright Yellow Shirt"] = "Camisa amarillo brillante",
		["Brightcloth Cloak"] = "Capa de paño brillante",
		["Brightcloth Gloves"] = "Guantes de paño brillante",
		["Brightcloth Pants"] = "Pantalones de paño brillante",
		["Brightcloth Robe"] = "Toga de paño brillante",
		["Brown Linen Pants"] = "Pantalones de lino marrones",
		["Brown Linen Robe"] = "Toga de lino marrón",
		["Brown Linen Shirt"] = "Camisa de lino marrón",
		["Brown Linen Vest"] = "Jubón de lino marrón",
		["Cenarion Herb Bag"] = "Bolsa de hierbas Cenarion",
		["Cindercloth Boots"] = "Botas de paño cenizo",
		["Cindercloth Cloak"] = "Capa de paño cenizo",
		["Cindercloth Gloves"] = "Guantes de paño cenizo",
		["Cindercloth Pants"] = "Pantalones de paño cenizo",
		["Cindercloth Robe"] = "Toga de paño cenizo",
		["Cindercloth Vest"] = "Jubón de paño cenizo",
		["Cloak of Arcane Evasion"] = "Capa de evasión Arcana",
		["Cloak of Eternity"] = "Capa de eternidad",
		["Cloak of Fire"] = "Capa de Fuego",
		["Cloak of the Black Void"] = "Capa del vacío negro",
		["Cloak of Warding"] = "Capa de amparo",
		["Colorful Kilt"] = "Falda de colores",
		["Core Felcloth Bag"] = "Bolsa de tela vil del Núcleo",
		["Crimson Silk Belt"] = "Cinturón de seda carmesí",
		["Crimson Silk Cloak"] = "Capa de seda carmesí",
		["Crimson Silk Gloves"] = "Guantes de seda carmesíes",
		["Crimson Silk Pantaloons"] = "Bombachos de seda carmesíes",
		["Crimson Silk Robe"] = "Toga de seda carmesí",
		["Crimson Silk Shoulders"] = "Sobrehombros de seda carmesíes",
		["Crimson Silk Vest"] = "Jubón de seda carmesí",
		["Dark Silk Shirt"] = "Camisa de seda oscura",
		["Double-stitched Woolen Shoulders"] = "Sobrehombros de lana con doble pespunte",
		["Dreamweave Circlet"] = "Aro de tejido onírico",
		["Dreamweave Gloves"] = "Guantes de tejido onírico",
		["Dreamweave Vest"] = "Jubón de tejido onírico",
		["Earthen Silk Belt"] = "Cinturón de seda terránea",
		["Earthen Vest"] = "Jubón terráneo",
		["Ebon Shadowbag"] = "Bolsa de las Sombras de ébano",
		["Enchanted Mageweave Pouch"] = "Faltriquera de tejido mágico encantada",
		["Enchanted Runecloth Bag"] = "Bolsa de paño rúnico encantada",
		["Enchanter's Cowl"] = "Capucha de encantador",
		["Felcloth Bag"] = "Bolsa de tela vil",
		["Felcloth Boots"] = "Botas de tela vil",
		["Felcloth Gloves"] = "Guantes de tela vil",
		["Felcloth Hood"] = "Caperuza de tela vil",
		["Felcloth Pants"] = "Pantalones de tela vil",
		["Felcloth Robe"] = "Toga de tela vil",
		["Felcloth Shoulders"] = "Sobrehombros de tela vil",
		["Festival Dress"] = "Vestido de fiesta",
		--["Festive Red Dress"] = "Festive Red Dress", doesn't exist?
		["Festive Red Pant Suit"] = "Traje de pantalón de fiesta rojo",
		["Flameheart Bracers"] = "Brazales de corazón de llamas",
		["Flameheart Gloves"] = "Guantes de corazón de llamas",
		["Flameheart Vest"] = "Jubón de corazón de llamas",
		["Flarecore Gloves"] = "Guantes Bengala del Núcleo",
		["Flarecore Leggings"] = "Leotardos Bengala del Núcleo",
		["Flarecore Mantle"] = "Manto Bengala del Núcleo",
		["Flarecore Robe"] = "Toga Bengala del Núcleo",
		["Flarecore Wraps"] = "Brazaletes Bengala del Núcleo",
		["Formal White Shirt"] = "Camisa blanca formal",
		["Frostweave Gloves"] = "Guantes de tejido de Escarcha",
		["Frostweave Pants"] = "Pantalones de tejido de Escarcha",
		["Frostweave Robe"] = "Toga de tejido de Escarcha",
		["Frostweave Tunic"] = "Túnica de tejido de Escarcha",
		["Frozen Shadoweave Boots"] = "Botas de tejido de sombra congelado",
		["Frozen Shadoweave Shoulders"] = "Sobrehombros de tejido de sombra congelado",
		["Frozen Shadoweave Robe"] = "Túnica de tejido de sombra congelado",
		["Gaea's Embrace"] = "Abrazo de Gaia",
		["Ghostweave Belt"] = "Cinturón de tejido fantasmal",
		["Ghostweave Gloves"] = "Guantes de tejido fantasmal",
		["Ghostweave Pants"] = "Pantalones de tejido fantasmal",
		["Ghostweave Vest"] = "Jubón de tejido fantasmal",
		["Girdle of Ruination"] = "Faja de ruina",
		["Glacial Cloak"] = "Capa glacial",
		["Glacial Gloves"] = "Guantes glaciales",
		["Glacial Vest"] = "Jubón glacial",
		["Glacial Wrists"] = "Muñequeras glaciales",
		["Gloves of Meditation"] = "Guantes de meditación",
		["Gloves of Spell Mastery"] = "Guantes de maestría en hechizos",
		["Golden Spellthread"] = "Hilo de hechizo de oro",
		["Gordok Ogre Suit"] = "Disfraz de ogro Gordok",
		["Gray Woolen Robe"] = "Toga de lana gris",
		["Gray Woolen Shirt"] = "Camisa de lana gris",
		["Greater Adept's Robe"] = "Toga de adepto superior",
		["Green Holiday Shirt"] = "Camisa de vacaciones verde",
		["Green Linen Bracers"] = "Brazales de lino verdes",
		["Green Linen Shirt"] = "Camisa de lino verde",
		["Green Silk Armor"] = "Armadura de seda verde",
		["Green Silk Pack"] = "Talega de seda verde",
		["Green Silken Shoulders"] = "Sobrehombros de seda verdes",
		["Green Winter Clothes"] = "Ropa de invierno verde",
		["Green Woolen Bag"] = "Bolsa de lana verde",
		["Green Woolen Vest"] = "Jubón de lana verde",
		["Hands of Darkness"] = "Manos de oscuridad",
		["Handstitched Linen Britches"] = "Calzones de lino cosidos a mano",
		["Heavy Linen Gloves"] = "Guantes de lino gruesos",
		["Heavy Woolen Cloak"] = "Capa de lana gruesa",
		["Heavy Woolen Gloves"] = "Guantes de lana gruesos",
		["Heavy Woolen Pants"] = "Pantalones de lana gruesos",
		["Icy Cloak"] = "Capa helada",
		["Imbued Netherweave Bag"] = "Bolsa de tejido abisal imbuido",
		["Imbued Netherweave Boots"] = "Botas de tejido abisal imbuido",
		["Imbued Netherweave Pants"] = "Pantalones de tejido abisal imbuido",
		["Imbued Netherweave Robe"] = "Toga de tejido abisal imbuido",
		["Imbued Netherweave Tunic"] = "Túnica de tejido abisal imbuido",
		["Inferno Gloves"] = "Guantes inferno",
		["Lavender Mageweave Shirt"] = "Camisa de tejido mágico lavanda",
		["Lesser Wizard's Robe"] = "Toga de zahorí inferior",
		["Linen Bag"] = "Bolsa de lino",
		["Linen Belt"] = "Cinturón de lino",
		["Linen Boots"] = "Botas de lino",
		["Linen Cloak"] = "Capa de lino",
		["Long Silken Cloak"] = "Capa larga de seda",
		["Mageweave Bag"] = "Bolsa de tejido mágico",
		["Manaweave Cloak"] = "Capa de tejido de maná",
		["Mantle of Nimble Thought"] = "Manto de pensamiento ágil",
		["Mantle of the Timbermaw"] = "Manto de los Fauces de Madera",
		["Mooncloth Bag"] = "Bolsa de tela lunar",
		["Mooncloth Boots"] = "Botas de tela lunar",
		["Mooncloth Circlet"] = "Aro de tela lunar",
		["Mooncloth Gloves"] = "Guantes de tela lunar",
		["Mooncloth Leggings"] = "Leotardos de tela lunar",
		["Mooncloth Robe"] = "Toga de tela lunar",
		["Mooncloth Shoulders"] = "Sobrehombros de tela lunar",
		["Mooncloth Vest"] = "Jubón de tela lunar",
		["Mooncloth"] = "Tela lunar",
		["Mystic Spellthread"] = "Hilo de hechizo místico",
		["Netherweave Bag"] = "Bolsa de tejido abisal",
		["Netherweave Belt"] = "Cinturón de tejido abisal",
		["Netherweave Boots"] = "Botas de tejido abisal",
		["Netherweave Bracers"] = "Brazales de tejido abisal",
		["Netherweave Gloves"] = "Guantes de tejido abisal",
		["Netherweave Net"] = "Red de tejido abisal",
		["Netherweave Pants"] = "Pantalones de tejido abisal",
		["Netherweave Robe"] = "Toga de tejido abisal",
		["Netherweave Tunic"] = "Túnica de tejido abisal",
		["Night's End"] = "Fin de la Noche",
		["Orange Mageweave Shirt"] = "Camisa de tejido mágico naranja",
		["Orange Martial Shirt"] = "Camisa marcial naranja",
		["Pearl-clasped Cloak"] = "Capa con broche de perlas",
		["Phoenix Gloves"] = "Guantes Fénix",
		["Phoenix Pants"] = "Pantalones Fénix",
		["Pink Mageweave Shirt"] = "Camisa de tejido mágico rosa",
		["Primal Mooncloth Bag"] = "Bolsa de tela lunar primigenia",
		["Primal Mooncloth Belt"] = "Cinturón de tela lunar primigenia",
		["Primal Mooncloth Robe"] = "Toga de tela lunar primigenia",
		["Primal Mooncloth Shoulders"] = "Sobrehombros de tela lunar primigenia",
		["Primal Mooncloth"] = "Tela lunar primigenia",
		["Red Linen Bag"] = "Bolsa de lino roja",
		["Red Linen Robe"] = "Toga de lino roja",
		["Red Linen Shirt"] = "Camisa de lino roja",
		["Red Linen Vest"] = "Jubón de lino rojo",
		["Red Mageweave Bag"] = "Bolsa de tejido mágico roja",
		["Red Mageweave Gloves"] = "Guantes de tejido mágico rojos",
		["Red Mageweave Headband"] = "Cinta de tejido mágico roja",
		["Red Mageweave Pants"] = "Pantalones de tejido mágico rojos",
		["Red Mageweave Shoulders"] = "Sobrehombros de tejido mágico rojos",
		["Red Mageweave Vest"] = "Jubón de tejido mágico rojo",
		["Red Swashbuckler's Shirt"] = "Camisa de espadachín roja",
		["Red Woolen Bag"] = "Bolsa de lana roja",
		["Red Woolen Boots"] = "Botas de lana roja",
		["Reinforced Linen Cape"] = "Manteo de lino reforzado",
		["Red Winter Clothes"] = "Ropa de invierno roja",
		["Reinforced Woolen Shoulders"] = "Sobrehombros de lana reforzada",
		["Resolute Cape"] = "Manteo resuelto",
		["Rich Purple Silk Shirt"] = "Camisa de seda morada viva",
		["Robe of Power"] = "Toga de poder",
		["Robe of the Archmage"] = "Toga del archimago",
		["Robe of the Void"] = "Toga del Vacío",
		["Robe of Winter Night"] = "Toga de Noche invernal",
		["Robes of Arcana"] = "Togas de Arcana",
		["Runecloth Bag"] = "Bolsa de paño rúnico",
		["Runecloth Belt"] = "Cinturón de paño rúnico",
		["Runecloth Boots"] = "Botas de paño rúnico",
		["Runecloth Cloak"] = "Capa de paño rúnico",
		["Runecloth Gloves"] = "Guantes de paño rúnico",
		["Runecloth Headband"] = "Cinta de paño rúnico",
		["Runecloth Pants"] = "Pantalones de paño rúnico",
		["Runecloth Robe"] = "Toga de paño rúnico",
		["Runecloth Shoulders"] = "Sobrehombros de paño rúnico",
		["Runecloth Tunic"] = "Túnica de paño rúnico",
		["Runed Stygian Belt"] = "Cinturón rúnico estigio",
		["Runed Stygian Boots"] = "Botas rúnicas estigias",
		["Runed Stygian Leggings"] = "Leotardos rúnicos estigios",
		["Runic Spellthread"] = "Hilo de hechizo rúnico",
		["Satchel of Cenarius"] = "Cartera de Cenarius",
		["Shadow Hood"] = "Caperuza de las Sombras",
		["Shadowcloth"] = "Paño de las Sombras",
		["Shadoweave Boots"] = "Botas tejido de sombra",
		["Shadoweave Gloves"] = "Guantes tejido de sombra",
		["Shadoweave Mask"] = "Máscara de tejido de sombra",
		["Shadoweave Pants"] = "Pantalones de tejido de sombra",
		["Shadoweave Robe"] = "Toga de tejido de sombra",
		["Shadoweave Shoulders"] = "Sobrehombros de tejido de sombra",
		["Silk Headband"] = "Cinta de seda",
		["Silver Spellthread"] = "Hilo de hechizo de plata",
		["Simple Black Dress"] = "Vestido negro sencillo",
		["Simple Dress"] = "Vestido sencillo",
		["Simple Kilt"] = "Falda sencilla",
		["Simple Linen Boots"] = "Botas de lino sencillas",
		["Simple Linen Pants"] = "Pantalones de lino sencillos",
		["Small Silk Pack"] = "Talega de seda pequeña",
		["Soft-soled Linen Boots"] = "Botas de lino de suela suave",
		["Soul Pouch"] = "Faltriquera de almas",
		["Soulcloth Gloves"] = "Guantes de paño de alma",
		["Soulcloth Shoulders"] = "Sobrehombros de paño de alma",
		["Soulcloth Vest"] = "Jubón de paño de alma",
		["Soulguard Bracers"] = "Brazales de guarda de almas",
		["Soulguard Girdle"] = "Faja de guarda de almas",
		["Soulguard Leggings"] = "Leotardos de guarda de almas",
		["Soulguard Slippers"] = "Zapatillas de guarda de almas",
		["Spellcloth"] = "Paño de hechizos",
		["Spellfire Bag"] = "Bolsa fuego de hechizo",
		["Spellfire Belt"] = "Cinturón fuego de hechizo",
		["Spellfire Gloves"] = "Guantes fuego de hechizo",
		["Spellfire Robe"] = "Toga fuego de hechizo",
		["Spellstrike Hood"] = "Caperuza de golpe de hechizo",
		["Spellstrike Pants"] = "Pantalones de golpe de hechizo",
		["Spider Belt"] = "Cinturón de araña",
		["Spider Silk Slippers"] = "Zapatillas de seda de araña",
		["Spidersilk Boots"] = "Botas de seda de araña",
		["Star Belt"] = "Cinturón de estrella",
		["Stylish Blue Shirt"] = "Camisa azul con estilo",
		["Stylish Green Shirt"] = "Camisa verde con estilo",
		["Stylish Red Shirt"] = "Camisa roja con estilo",
		["Swiftheal Mantle"] = "Manto Sanaveloz",
		["Swiftheal Wraps"] = "Brazaletes Sanaveloz",
		["Sylvan Crown"] = "Corona nemorosa",
		["Sylvan Shoulders"] = "Sobrehombros nemorosos",
		["Sylvan Vest"] = "Jubón nemoroso",
		["Truefaith Gloves"] = "Guantes de fe verdadera",
		["Truefaith Vestments"] = "Vestimentas de fe verdadera",
		["Tuxedo Jacket"] = "Chaqueta de esmoquin",
		["Tuxedo Pants"] = "Pantalones de esmoquin",
		["Tuxedo Shirt"] = "Camisa de esmoquin",
		["Unyielding Bracers"] = "Brazales implacables",
		["Unyielding Girdle"] = "Faja implacable",
		["Vengeance Wrap"] = "Brazalete de venganza",
		["White Bandit Mask"] = "Máscara de bandido blanca",
		["White Linen Robe"] = "Toga de lino blanca",
		["White Linen Shirt"] = "Camisa de lino blanca",
		["White Remedy Cape"] = "Capa blanca de enmienda",
		["White Swashbuckler's Shirt"] = "Camisa de espadachín blanca",
		["White Wedding Dress"] = "Vestido de boda blanco",
		["White Woolen Dress"] = "Vestido de lana blanco",
		["Whitemend Hood"] = "Caperuza con remiendos blancos",
		["Whitemend Pants"] = "Pantalones con remiendos blancos",
		["Wisdom of the Timbermaw"] = "Sabiduría de los Fauces de Madera",
		["Wizardweave Leggings"] = "Leotardos de tejido zahorí",
		["Wizardweave Robe"] = "Toga de tejido zahorí",
		["Wizardweave Turban"] = "Turbante de tejido zahorí",
		["Woolen Bag"] = "Bolsa de lana",
		["Woolen Boots"] = "Botas de lana",
		["Woolen Cape"] = "Manteo de lana",
	}
end)

local skillIcons = {
	["Alchemy"] = "Trade_Alchemy",
	--["Armorsmith"] = "",
	["Blacksmithing"] = "Trade_BlackSmithing",
	["Cooking"] = "INV_Misc_Food_15",
	["Disenchant"] = "Spell_Holy_RemoveCurse",
	["Dragonscale Leatherworking"] = "INV_Misc_MonsterScales_03",
	--["Elemental Leatherworking"] = "",
	["Enchanting"] = "Trade_Engraving",
	["Engineering"] = "Trade_Engineering",
	["First Aid"] = "Spell_Holy_SealOfSacrifice",
	["Fishing"] = "Trade_Fishing",
	--["Gnomish Engineering"] = "",
	--["Goblin Engineering"] = "",
	["Herbalism"] = "Spell_Nature_NatureTouchGrow",
	["Jewelcrafting"] = "INV_Misc_Gem_02",
	["Leatherworking"] = "INV_Misc_ArmorKit_17",
	--["Master Axesmith"] = "",
	--["Master Hammersmith"] = "",
	--["Master Swordsmith"] = "",
	["Mining"] = "Spell_Fire_FlameBlades",
	--["Mooncloth Tailoring"] = "",
	--["Shadoweave Tailoring"] = "",
	--["Spellfire Tailoring"] = "",
	["Pick Pocket"] = "INV_Misc_Bag_11",
	["Prospecting"] = "INV_Misc_Gem_Bloodstone_01",
	["Skinning"] = "INV_Misc_Pelt_Wolf_01",
	["Smelting"] = "Spell_Fire_FlameBlades",
	["Tailoring"] = "Trade_Tailoring",
	--["Tribal Leatherworking"] = "",
	--["Weaponsmith"] = "",
}

BabbleTradeskill:Debug()
BabbleTradeskill:SetStrictness(true)

function BabbleTradeskill:GetSkillIcon(skill)
	self:argCheck(skill, 2, "string")
	local icon = skillIcons[skill] or skillIcons[self:HasReverseTranslation(skill) and self:GetReverseTranslation(skill) or false]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function BabbleTradeskill:GetShortSkillIcon(skill)
	self:argCheck(skill, 2, "string")
	return skillIcons[skill] or skillIcons[self:HasReverseTranslation(skill) and self:GetReverseTranslation(skill) or false]
end

AceLibrary:Register(BabbleTradeskill, MAJOR_VERSION, MINOR_VERSION)
BabbleTradeskill = nil
