-- $Revision: 75619 $
--[[
TODO: (Updated 10/25/2007

*Add Drum recipes to vendors
*Fix remaining Enchanting Oils to actually work
:ODOT

Specialcases = When there are several combines that yield the same itemid
[index or itemid]itemid|name

Combines
[index]skill|components|recipe|yield|itemid
index = itemid or -enchantid or specialcase
skill =
	A = Alchemy
	B = Blacksmithing
	Ba = Armorsmith
	Bw = Weaponsmith
	Bws = Master Swordsmith
	Bwh = Master Hammersmith
	Bwx = Master Axesmith
	N = Enchanting
	E = Engineering
	Eg = Gnomish Engineer
	Eb = Goblin Engineer
	J = Jewelcrafting
	L = Leatherworking
	Ld = Dragonscale Leatherworking
	Le = Elemental Leatherworking
	Lt = Tribal Leatherworking
	T = Tailoting
	C = Cooking
	F = First Aid
	P = Poisons 
	M = Mining
	# = level
components =
  itemid[:num] ...
recipe = recipeid (Optional)
yield = how many the combine makes (Optional)
itemid = itemid crafted if it differs from index (Optional)
	
Components
[itemid]name/cost/source
Name
Cost (sell value for all except vendor, where it is buy value) per item
Source
	V = Vendor (Only items with unlimited supply)
	D = Dropped
	C = Crafted
	M = Mined
	H = Herbalism
	S = Skinned
	F = Fished
	E = Disenchanted
	G = Gathered (No skill required)
	P = Pickpocketed

Enchants
[-enchantid]name/description

Zones
[index]name

Vendors
[index]name|zone|faction|location|comment

Recipes
[recipeid]#|source|price|level
# = combine id	
source
	D = Drop
	V = Vendor
	Q = Quest
	# index to table vendors
Price = Vendor sell price (Optional)
Level = faction rank needed (Optional)

]]

if GetLocale() ~= 'zhCN' then return end;

if not TradeskillInfo or not TradeskillInfo.vars then return end
if not TradeskillInfo_Translations then
	TradeskillInfo_Translations = {}
end

-- Local translation function
local function TT(text)
	if TradeskillInfo_Translations[text] and TradeskillInfo_Translations[text] ~= "" then
		return TradeskillInfo_Translations[text]
	end
	return text
end
	
	
TradeskillInfo.vars.tradeskills = {
	['A'] = TT("炼金术"),
	['B'] = TT("锻造"),
	['D'] = TT("附魔"),
	['E'] = TT("工程学"),
	['J'] = TT("珠宝加工"),
	['L'] = TT("制皮"),
	['T'] = TT("裁缝"),
	['W'] = TT("烹饪"),
	['X'] = TT("急救"),
	['Y'] = TT("采矿"),
	['Z'] = TT("毒药"),
}

TradeskillInfo.vars.skillnames = {
	[TradeskillInfo.vars.tradeskills['A']] = 'A',
	[TradeskillInfo.vars.tradeskills['B']] = 'B',
	[TradeskillInfo.vars.tradeskills['D']] = 'D',
	[TradeskillInfo.vars.tradeskills['E']] = 'E',
	[TradeskillInfo.vars.tradeskills['J']] = 'J',
	[TradeskillInfo.vars.tradeskills['L']] = 'L',
	[TradeskillInfo.vars.tradeskills['T']] = 'T',
	[TradeskillInfo.vars.tradeskills['W']] = 'W',
	[TradeskillInfo.vars.tradeskills['X']] = 'X',
	[TradeskillInfo.vars.tradeskills['Y']] = 'Y',
	[TradeskillInfo.vars.tradeskills['Z']] = 'Z',
}

TradeskillInfo.vars.specializations = {
	['a'] = "护甲锻造师",
	['w'] = "武器锻造",
	['ws'] = "铸剑大师",
	['wh'] = "铸锤大师",
	['wx'] = "铸斧大师",
	['d'] = "龙鳞制皮",
	['e'] = "元素制皮",
	['t'] = "部落制皮",
	['g'] = "侏儒工程学",
	['b'] = "地精工程学",
	['p'] = "魔焰裁缝",
	['s'] = "暗纹裁缝",
	['m'] = "月布裁缝",
}
TradeskillInfo.vars.specializationnames = {
	[TradeskillInfo.vars.specializations['a']] = "a",
	[TradeskillInfo.vars.specializations['w']] = "w",
	[TradeskillInfo.vars.specializations['ws']] = "ws",
	[TradeskillInfo.vars.specializations['wh']] = "wh",
	[TradeskillInfo.vars.specializations['wx']] = "wx",
	[TradeskillInfo.vars.specializations['d']] = "d",
	[TradeskillInfo.vars.specializations['e']] = "e",
	[TradeskillInfo.vars.specializations['t']] = "t",
	[TradeskillInfo.vars.specializations['g']] = "g",
	[TradeskillInfo.vars.specializations['b']] = "b",
	[TradeskillInfo.vars.specializations['p']] = "p",
	[TradeskillInfo.vars.specializations['s']] = "s",
	[TradeskillInfo.vars.specializations['m']] = "m",
}
TradeskillInfo.vars.sources = {
	['V'] = "|cff7fff7f商人|r",
	['Va'] = "联盟商人",
	['Vh'] = "部落商人",
	['D'] = "|cff700f7f掉落|r",
	['C'] = "制造",
	['Ca'] = "炼金术",
	['Cb'] = "锻造",
	['Cn'] = "附魔",
	['Ce'] = "工程学",
	['Cj'] = "珠宝加工",
	['Cl'] = "制皮",
	['Ct'] = "裁缝",
	['Cc'] = "烹饪",
	['Cf'] = "急救",
	['Cp'] = "毒药",
	['Cs'] = "熔炼",
	['M'] = "采矿",
	['Ma'] = "铜矿",
	['Mb'] = "锡矿",
	['Mc'] = "银矿",
	['Md'] = "金矿",
	['Me'] = "铁矿",
	['Mf'] = "秘银矿",
	['Mg'] = "真银矿",
	['Mh'] = "黑铁矿",
	['Mi'] = "哈卡莱瑟银矿",
	['Mj'] = "瑟银矿",
	['Mk'] = "富瑟银矿",
	['Ml'] = "魔铁矿脉",
    ['Mm'] = "精金矿脉",
    ['Mn'] = "氪金矿脉", 
	['H'] = "草药",
	['S'] = "剥皮",
	['Sa'] = "野兽(等级1-10)",
	['Sb'] = "野兽(等级1-20)",
	['Sc'] = "野兽(等级20-30)",
	['Sd'] = "野兽(等级30-40)",
	['Se'] = "野兽(等级40-50)",
	['Sf'] = "野兽(等级50-60)",
	['Sg'] = "深喉猎豹(荆棘谷,悲伤沼泽)", -- 7428
	['Sh'] = "乌龟(等级40-60)", -- 8167
	['Si'] = "蝎子(等级40-50)", -- 8154
	['Sj'] = "蝎子(等级50-60)", -- 15408
	['Sk'] = "龙人(等级40-60+)", -- 8165
	['Sl'] = "精英龙人(等级50-60+)", -- 15412, 15414, 15415, 15416, 
	['Sm'] = "霜刃守护者(冬泉谷)", -- 15422
	['Sn'] = "魔暴龙(安戈洛环形山)", -- 15417
	['So'] = "奇美拉(艾萨拉,冬泉谷,厄运之槌)", -- 15423
	['Sp'] = "狼(等级40-60)", -- 8368
	['Sq'] = "熊(等级50-60)", -- 15419
	['Sr'] = "蝙蝠(祖尔格拉布)", -- 19767
	['Ss'] = "老虎(祖尔格拉布)", -- 19768
	['St'] = "上古熔火恶犬,玛格曼达(熔火之心)", -- 17012
	['Su'] = "异种蝎(希利苏斯)", -- 20501,20498
	['Sv'] = "梦魇巨龙", -- 20381
	['Sw'] = "奥妮克希亚", -- 20381
	['Sy'] = "野兽(哀嚎洞穴)",
	['Sz'] = "龙类(湿地)",
	['Saa'] = "龙类(赤脊山)",
	['Sab'] = "龙类悲伤沼泽)",
	['Sac'] = "迅猛龙(等级30-40)",
	['F'] = "钓鱼",
	['E'] = "分解",
	['Ea'] = "分解物品(等级1-20)",
	['Eb'] = "分解物品(等级1-10)",
	['Ec'] = "分解物品(等级11-15)",
	['Ed'] = "分解物品(等级16-20)",
	['Ee'] = "分解物品(等级21-30)",
	['Ef'] = "分解物品(等级21-25)",
	['Eg'] = "分解物品(等级26-30)",
	['Eh'] = "分解物品(等级31-40)",
	['Ei'] = "分解物品(等级31-35)",
	['Ej'] = "分解物品(等级36-40)",
	['Ek'] = "分解物品(等级41-50)",
	['El'] = "分解物品(等级41-45)",
	['Em'] = "分解物品(等级46-50)",
	['En'] = "分解物品(等级51-60)",
	['Eo'] = "分解史诗物品(等级51-60)",
	['Ep'] = "分解物品(等级57-63)",
	['Eq'] = "分解物品(等级64+)",
	['Er'] = "分解物品(等级57+)",
	['Es'] = "分解史诗物品(等级57+)",
	['G'] = "采集",
	['P'] = "偷窃",
	['Q'] = "任务",
	['Qa'] = "联盟任务",
	['Qh'] = "部落任务",
	['T'] = "训练师",
	['Ts'] = "专业训练师",
	['X'] = "目前无法获得",
	['R'] = "采矿",
	['U'] = "未知",
}

TradeskillInfo.vars.difficulty = {
	['trivial'] = 1,	
	['easy'] = 2,	
	['medium'] = 3,	
	['optimal'] = 4,	
}

TradeskillInfo.vars.diffcolors = {
	[1] = '|cff777777',
	[2] = '|cff33bb33',
	[3] = '|cffffff00',
	[4] = '|cffff7733',
	[5] = '|cffffffff',
}

TradeskillInfo.vars.specialcases = {
	[3386] = "",
	[1] = "3386|抗毒药剂",
	[3577] = "",
	[2] = "3577|点铁成金",
	[6037] = "",
	[3] = "6037|点化秘银",
	[7078] = "",
	[4] = "7078|点气成火",
	[12360] = "",
	[5] = "12360|合成奥金",
	[12803] = "",
	[6] = "12803|土转生命",
	[7080] = "",
	[7] = "7080|转土成水",
	[7076] = "",
	[8] = "7076|点火成土",
	[9] = "7076|生命归土",
	[10] = "7080|死灵化水",
	[7082] = "",
	[11] = "7082|水转空气",
	[12808] = "",
	[12] = "12808|水转死灵",
	[7068] = "",
	[13] = "7068|转化：元素火焰",
	[25867] = "",
	[14] = "25867|转化：大地风暴钻石",
	[23571] = "",
	[15] = "23571|转化：源生之能",
	[25868] = "",
	[16] = "25868|转化：天火钻石",
	[21884] = "",
	[17] = "21884|转化：源生空气转源生火焰",
	[21885] = "",
	[18] = "21885|转化：源生之土转源生之水",
	[22452] = "",
	[19] = "22452|转化：源生火焰转源生之土",
	[22451] = "",
	[20] = "22451|转化：源生之水转源生空气",
	[22861] = "",
	[21] = "22861|盲目光芒合剂",
	[22866] = "",
	[22] = "22866|纯粹死亡合剂",
	[21886] = "",
	[23] = "21886|转化:源生之土转源生生命",
	[22457] = "",
	[24] = "22457|转化：源生火焰转源生法力",
	[25] = "22452|转化：源生生命转源生之土",
	[26] = "21884|转化：源生法力转源生火焰",
	[27] = "21885|转化：源生暗影转源生之水",
	[22456] = "",
	[28] = "22456|转化：源生之水转源生暗影",
--	[23575] = "",
--	[29] = "23575|Lesser Ward of Shielding",
--	[23576] = "",
--	[30] = "23576|强效护盾符文",
--	[8364] = "",
--	[31] = "8364|Mithril Headed Trout",
	--[12655] = "",
	--[32] = "12655|Enchanted Thorium",
--	[4401] = "",
--	[33] = "4401|Mechanical Squirrel",
	[21570] = "",
	[34] = "21570|烟花束发射器",
	[32413] = "",
	[35] = "32413|冰霜手榴弹",
	[10713] = "",
	[36] = "10713|设计图：秘银杆",
	[18986] = "",
	[37] = "18986|安全传送器：加基森",
	[18645] = "",
	[38] = "18645|侏儒警报机器人",
	[23825] = "",
	[39] = "23825|近似无敌腰带",
	[30544] = "",
	[40] = "30544|安全传送器：托斯利基地",
	[10644] = "",
	[41] = "10644|地精火箭燃油配方",
	[10577] = "",
	[42] = "10577|地精迫击炮",
	[43] = "10577|迫击炮:重载",
	[24122] = "",
	[44] = "24122|翠绿之火王冠",
	[15078] = "",
	[45] = "15078|重型蝎壳护手",
	[25697] = "",
	[46] = "25697|魔能猎手护腕",
	[2840] = "",
	[47] = "2840|熔炼铜锭",
	[2841] = "",
	[48] = "2841|熔炼青铜",
	[3576] = "",
	[49] = "3576|熔炼锡锭",
	[2842] = "",
	[50] = "2842|熔炼银锭",
	[3575] = "",
	[51] = "3575|熔炼铁锭",
	[52] = "3577|熔炼金锭",
	[3859] = "",
	[53] = "3859|熔炼钢锭",
	[3860] = "",
	[54] = "3860|熔炼秘银",
	[55] = "6037|熔炼真银",
	[11371] = "",
	[56] = "11371|熔炼黑铁",
	[12359] = "",
	[57] = "12359|熔炼瑟银",
	[17771] = "",
	[58] = "17771|熔炼源质",
	[22573] = "",
	[59] = "22573|敲碎源生之土",
	[22574] = "",
	[60] = "22574|火焰碎裂",
	[23445] = "",
	[61] = "23445|熔炼魔铁",
	[23446] = "",
	[62] = "23446|熔炼精金",
	[23447] = "",
	[63] = "23447|熔炼恒金",
	[23448] = "",
	[64] = "23448|熔炼魔铁",
	[23449] = "",
	[65] = "23449|熔炼氪金",
	[23573] = "",
	[66] = "23573|熔炼硬化精金",
	[21542] = "",
	[67] = "21542|红色节庆裤子",
	[18258] = "",
	[68] = "18258|戈多克巨魔裝",
	[69] = "18258|戈多克巨魔裝",
--    [22448] = "",
--    [70] = "22448|Nexus Transformation",
    }

TradeskillInfo.vars.enchantItems = {
	[-7421] = "6218",
	[-14293] = "11287",
	[-25124] = "20744",
	[-14807] = "11288",
	[-7795] = "6339",
	[-25125] = "20745",
	[-13628] = "11130",
	[-14809] = "11289",
	[-14810] = "11290",
	[-25126] = "20746",
	[-13702] = "11145",
	[-17181] = "12810",
	[-17180] = "12655",
	[-25127] = "20747",
	[-15596] = "11811",
	[-25128] = "20750",
	[-20051] = "16207",
	[-25130] = "20748",
	[-25129] = "20749",
	[-32664] = "22461",
	[-28016] = "22521",
	[-28027] = "22460",
	[-28022] = "22449",
	[-28019] = "22522",
	[-28028] = "22459",
	[-32665] = "22462",
	[-32667] = "22463",
    [-42613] = "22448",
}

TradeskillInfo.vars.combines = {
--[[ Alchemy --]]
	[2454] = "2329|A1|2449 765 3371",	-- Elixir of Lion's Strength
	[5997] = "7183|A1|765:2 3371",	-- Elixir of Minor Defense
	[118] = "2330|A1|2447 765 3371",	-- Minor Healing Potion
	[3382] = "3170|A15|2447 2449:2 3371",	-- Weak Troll's Blood Potion
	[2455] = "2331|A25|785 765 3371",	-- Minor Mana Potion
	[2456] = "2332|A40|785:2 2447 3371",	-- Minor Rejuvenation Potion
	[4596] = "4508|A50|3164 2447 3371|4597",	-- Discolored Healing Potion
	[2457] = "3230|A50|2452 765 3371|2553",	-- Elixir of Minor Agility
	[2458] = "2334|A50|2449:2 2447 3371",	-- Elixir of Minor Fortitude
	[858] = "2337|A55|118 2450",	-- Lesser Healing Potion
	[5631] = "6617|A60|5635 2450 3371|5640",	-- Rage Potion
	[2459] = "2335|A60|2452 2450 3371|2555",	-- Swiftness Potion
	[6370] = "7836|A80|6358:2 3371",	-- Blackmouth Oil
	[6662] = "8240|A90|6522 2449 3371|6663",	-- Elixir of Giant Growth
	[5996] = "7179|A90|3820 6370:2 3371",	-- Elixir of Water Breathing
	[3383] = "3171|A90|785 2450:2 3371",	-- Elixir of Wisdom
	[6051] = "7255|A100|2453 2452 3371|6053",	-- Holy Protection Potion
	[6372] = "7841|A100|2452 6370 3371",	-- Swim Speed Potion
	[929] = "3447|A110|2453 2450 3372",	-- Healing Potion
	[3384] = "3172|A110|785:3 3355 3371|3393",	-- Minor Magic Resistance Potion
	[3385] = "3173|A120|785 3820 3371",	-- Lesser Mana Potion
	[1] = "3174|A120|1288 2453 3372|3394||3386",	-- Potion of Curing
	[3388] = "3176|A125|2453:2 2450:2 3372",	-- Strong Troll's Blood Potion
	[3389] = "3177|A130|3355 3820 3372",	-- Elixir of Defense
	[6371] = "7837|A130|6359:2 3371",	-- Fire Oil
	[6048] = "7256|A135|3369 3356 3372|6054",	-- Shadow Protection Potion
	[6373] = "7845|A140|6371:2 3356 3372",	-- Elixir of Firepower
	[3390] = "2333|A140|3355 2452 3372|3396",	-- Elixir of Lesser Agility
	[3391] = "3188|A150|2449 3356 3372|6211",	-- Elixir of Ogre's Strength
	[5634] = "6624|A150|6370:2 3820 3372|5642",	-- Free Action Potion
	[1710] = "7181|A155|3357 3356 3372",	-- Greater Healing Potion
	[3827] = "3452|A160|3820 3356 3372",	-- Mana Potion
	[3824] = "3449|A160|3818:4 3369:4 3372|6068",	-- Shadow Oil
	[6049] = "7257|A165|4402 6371 3372|6055",	-- Fire Protection Potion
	[3823] = "3448|A165|3818 3355 3372",	-- Lesser Invisibility Potion
	[3826] = "3451|A170|3357 2453 3372|3831",	-- Mighty Troll's Blood Potion
	[3825] = "3450|A175|3355 3821 3372|3830",	-- Elixir of Fortitude
	[5633] = "6618|A175|5637 3356 3372|5643",	-- Great Rage Potion
	[8949] = "11449|A185|3820 3821 3372",	-- Elixir of Agility
	[17708] = "21923|A190|3819:2 3358 3372|17709",	-- Elixir of Frost Power
	[3829] = "3454|A190|3358:4 3819:2 3372|14634",	-- Frost Oil
	[6050] = "7258|A190|3819 3821 3372|6056",	-- Frost Protection Potion
	[6052] = "7259|A190|3357 3820 3372|6057",	-- Nature Protection Potion
	[3828] = "3453|A195|3358 3818 3372|3832",	-- Elixir of Detect Lesser Invisibility
	[8951] = "11450|A195|3355 3821 3372",	-- Elixir of Greater Defense
	[9061] = "11456|A195|4625 9260 3372|10644",	-- Goblin Rocket Fuel
	[10592] = "12609|A200|3821 3818 3372",	-- Catseye Elixir
	[6149] = "11448|A205|3358 3821 3372",	-- Greater Mana Potion
	[8956] = "11451|A205|4625 3821 8925",	-- Oil of Immolation
	[2] = "11479|A210|3575|9304||3577",	-- Transmute: Iron to Gold
	[3] = "11480|A210|3860|9305||6037",	-- Transmute: Mithril to Truesilver
	[9036] = "11453|A210|3358 8831 8925|9293",	-- Magic Resistance Potion
	[9149] = "11459|A210|3575:4 9262 8831:4 4625:4|9303",	-- Philosopher's Stone
	[18294] = "22808|A215|7972 8831:2 8925",	-- Elixir of Greater Water Breathing
	[4623] = "4942|A215|3858 3821 3372|4624",	-- Lesser Stoneshield Potion
	[3928] = "11457|A215|8838 3358 8925",	-- Superior Healing Potion
	[9144] = "11458|A225|8153 8831 8925|9294",	-- Wildvine Potion
    [9030] = "11522|A285|7067 3821 8925", -- Restorative Potion, added 8/7/2007
	[12190] = "15833|A230|8831:3 8925",	-- Dreamless Sleep Potion
	[9154] = "11460|A230|8836 8925",	-- Elixir of Detect Undead
	[9210] = "11473|A230|8845:2 4342 8925|9302",	-- Ghost Dye
	[9155] = "11461|A235|8839 3821 8925",	-- Arcane Elixir
	[9179] = "11465|A235|8839 3358 8925",	-- Elixir of Greater Intellect
	[9264] = "11476|A235|8845:3 8925|9301",	-- Elixir of Shadow Power
	[9172] = "11464|A235|8845 8838 8925|9295",	-- Invisibility Potion
	[9197] = "11468|A240|8831:3 8925|9297",	-- Elixir of Dream Vision
	[9187] = "11467|A240|8838 3821 8925",	-- Elixir of Greater Agility
	[9088] = "11466|A240|8836 8839 8925|9296",	-- Gift of Arthas
	[9206] = "11472|A245|8838 8846 8925|9298",	-- Elixir of Giants
	[9224] = "11477|A250|8846 8845 8925|9300",	-- Elixir of Demonslaying
	[9233] = "11478|A250|8846:2 8925",	-- Elixir of Detect Demon
	[21546] = "26277|A250|6371:3 4625:3 8925|21547",	-- Elixir of Greater Firepower
	[3387] = "3175|A250|8839:2 8845 8925|3395",	-- Limited Invulnerability Potion
	[13423] = "17551|A250|13422 3372",	-- Stonescale Oil
	[13442] = "17552|A255|8846:3 8925|13476",	-- Mighty Rage Potion
	[13443] = "17553|A260|8838:2 8839:2 8925|13477",	-- Superior Mana Potion
	[13445] = "17554|A265|13423:2 8838 8925|13478",	-- Elixir of Superior Defense
	[13447] = "17555|A270|13463 13466:2 8925|13479",	-- Elixir of the Sages
	[4] = "17559|A275|7082|13482||7078",	-- Transmute: Air to Fire
	[5] = "17187|A275|12359 12363|12958||12360",	-- Transmute: Arcanite
	[6] = "17566|A275|7076|13489||12803",	-- Transmute: Earth to Life
	[7] = "17561|A275|7076|13484||7080",	-- Transmute: Earth to Water
	[8] = "17560|A275|7078|13483||7076",	-- Transmute: Fire to Earth
	[9] = "17565|A275|12803|13488||7076",	-- Transmute: Life to Earth
	[10] = "17563|A275|12808|13486||7080",	-- Transmute: Undeath to Water
	[11] = "17562|A275|7080|13485||7082",	-- Transmute: Water to Air
	[12] = "17564|A275|7080|13487||12808",	-- Transmute: Water to Undeath
	[13453] = "17557|A275|8846:2 13466:2 8925|13481",	-- Elixir of Brute Force
	[20002] = "24366|A275|13463:2 13464 8925|20012",	-- Greater Dreamless Sleep Potion
	[20007] = "24365|A275|13463 13466:2 8925|20011",	-- Mageblood Potion
	[13446] = "17556|A275|13464:2 13465 8925|13480",	-- Major Healing Potion
	[13452] = "17571|A280|13465:2 13466:2 8925|13491",	-- Elixir of the Mongoose
	[13455] = "17570|A280|13423:2 10620 8925|13490",	-- Greater Stoneshield Potion
	[13454] = "17573|A285|13463:3 13465 8925|13493",	-- Greater Arcane Elixir
	[20008] = "24367|A285|13467:2 13465:2 10286:2 8925|20013",	-- Living Action Potion
	[13462] = "17572|A285|13467:2 13466:2 8925|13492",	-- Purification Potion
	[9030] = "11452|A285|7067 3821 8925",	-- Restorative Potion
	[13461] = "17577|A290|11176 13463 8925|13497",	-- Greater Arcane Protection Potion
	[13457] = "17574|A290|7068 13463 8925|13494",	-- Greater Fire Protection Potion
	[13456] = "17575|A290|7070 13463 8925|13495",	-- Greater Frost Protection Potion
	[13458] = "17576|A290|7067 13463 8925|13496",	-- Greater Nature Protection Potion
	[13459] = "17578|A290|3824 13463 8925|13499",	-- Greater Shadow Protection Potion
	[20004] = "24368|A290|8846 13466:2 8925|20014",	-- Major Troll's Blood Potion
	[13444] = "17580|A295|13463:3 13467:2 8925|13501",	-- Major Mana Potion
	[19931] = "24266|A300|12938 19943 12804:6 13468||3",	-- Gurubashi Mojo Madness
	[28103] = "33740|A300|13463 22785 18256",	-- Adept's Elixir
	[13513] = "17638|A300|13467:7 13465:3 13468 8925|13522",	-- Flask of Chromatic Resistance
	[13511] = "17636|A300|13463:7 13467:3 13468 8925|13520",	-- Flask of Distilled Wisdom
	[13506] = "17634|A300|13423:7 13465:3 13468 8925|13518",	-- Flask of Petrification
	[13512] = "17637|A300|13463:7 13465:3 13468 8925|13521",	-- Flask of Supreme Power
	[13510] = "17635|A300|8846:7 13423:3 13468 8925|13519",	-- Flask of the Titans
	[18253] = "22732|A300|10286 13464:4 13463:4 18256|18257",	-- Major Rejuvenation Potion
	[28102] = "33738|A300|13465 22785 18256",	-- Onslaught Elixir
	[13] = "25146|A300|7077|20761|3|7068",	-- Transmute: Elemental Fire
	[28100] = "33732|A300|13464 22785 18256",	-- Volatile Healing Potion
	[22823] = "28543|A305|22787 22785 18256|22900",	-- Elixir of Camouflage
	[22824] = "28544|A305|13465 22785 18256",	-- Elixir of Major Strength
	[22825] = "28545|A310|13464 22786 18256",	-- Elixir of Healing Power
	[32062] = "39636|A310|22787:2 22785 18256",	-- Elixir of Major Fortitude
	[28101] = "33733|A310|22787:2 22785 18256",	-- Unstable Mana Potion
	[28104] = "33741|A315|22789:3 22785 18256",	-- Elixir of Mastery
	[22826] = "28546|A315|22787:2 22785 18256|22901",	-- Sneaking Potion
    [34440] = "45061|A315|22787:2 8925", -- Mad Alchemist's Potion
	[32063] = "39637|A320|22786 22787:2 18256|32070",	-- Earthen Elixir
	[32067] = "39638|A320|22785 22789 18256",	-- Elixir of Draenic Wisdom
	[22827] = "28549|A320|22578:2 22790 18256|22902",	-- Elixir of Major Frost Power
	[22828] = "28550|A320|22789:3 18256|22903",	-- Insane Strength Potion
	[31080] = "38070|A325|22452 21886 22457",	-- Mercurial Stone
	[22830] = "28552|A325|22787:2 22789 18256|22904",	-- Elixir of the Searching Eye
	[22829] = "28551|A325|22791:2 22785 18256",	-- Super Healing Potion
	[32068] = "39639|A330|22790 22787 18256|32071",	-- Elixir of Ironskin
	[22831] = "28553|A330|22789 22785:2 18256|22905",	-- Elixir of Major Agility
	[31679] = "38960|A335|22789 22792:2 18256|31680",	-- Fel Strength Elixir
	[22871] = "28554|A335|22787:3 22791 18256|22906",	-- Shrouding Potion
	[22832] = "28555|A340|22786:2 22785 18256|22907",	-- Super Mana Potion
	[22834] = "28557|A345|22790:3 22789 18256|22909",	-- Elixir of Major Defense
	[22833] = "28556|A345|22574:2 22790 18256|22908",	-- Elixir of Major Firepower
	[31676] = "38962|A345|22785:2 22792:3 18256|31681",	-- Fel Regeneration Potion
	[13503] = "17632|A350|9149 25867 25868 22794:2 23571:5|13517",	-- Alchemist's Stone
	[14] = "32765|A350|23079:3 23107:3 23112:3 22452:2 21885:2|25869||25867",	-- Transmute: Earthstorm Diamond
	[15] = "29688|A350|22452 21885 22451 21884 22457|23574||23571",	-- Transmute: Primal Might
	[16] = "32766|A350|23077:3 21929:3 23117:3 21884:2 22451:2|29232||25868",	-- Transmute: Skyfire Diamond
	[17] = "28566|A350|22451|22915||21884",	-- Transmute: Primal Air to Fire
	[18] = "28567|A350|22452|22916||21885",	-- Transmute: Primal Earth to Water
	[19] = "28568|A350|21884|30443||22452",	-- Transmute: Primal Fire to Earth
	[20] = "28569|A350|21885|22918||22451",	-- Transmute: Primal Water to Air
	[22839] = "28565|A350|22792:2 22791 18256|22914",	-- Destruction Potion
	[22835] = "28558|A350|22790 22792 18256|22910",	-- Elixir of Major Shadow Power
	[22838] = "28564|A350|22789:2 22791 18256|22913",	-- Haste Potion -- also 35295
	[22837] = "28563|A350|22789:2 22790 18256|22912",	-- Heroic Potion
	[22836] = "28562|A350|22786 22792 18256|22911",	-- Major Dreamless Sleep Potion
	[22840] = "28570|A355|22790 22791 18256|22919",	-- Elixir of Major Mageblood
	[31677] = "38961|A360|22793 22792:2 18256|31682",	-- Fel Mana Potion
	[21] = "28590|A360|22794 22793:3 22791:7 18256|||22861",	-- Flask of Blinding Light
	[22851] = "28587|A360|22794 22793:3 22790:7 18256",	-- Flask of Fortification
	[22853] = "28588|A360|22794 22793:3 22786:7 18256",	-- Flask of Mighty Restoration
	[22] = "28591|A360|22794 22793:3 22792:7 18256|||22866",	-- Flask of Pure Death
	[22854] = "28589|A360|22794 22793:3 22789:7 18256",	-- Flask of Relentless Assault
	[22845] = "28575|A360|22457 22793:3 18256:5|22923|5",	-- Major Arcane Protection Potion
	[22841] = "28571|A360|21884 22793:3 18256:5|22920|5",	-- Major Fire Protection Potion
	[22842] = "28572|A360|21885 22793:3 18256:5|22921|5",	-- Major Frost Protection Potion
	[22847] = "28577|A360|21886 22793:3 18256:5|22925|5",	-- Major Holy Protection Potion
	[22844] = "28573|A360|21886 22793:3 18256:5|22922|5",	-- Major Nature Protection Potion
	[22846] = "28576|A360|22456 22793:3 18256:5|22924|5",	-- Major Shadow Protection Potion
	[22850] = "28586|A360|22793:2 22786 22791 18256",	-- Super Rejuvenation Potion
	[22848] = "28578|A365|22791 22793 18256|22926",	-- Elixir of Empowerment -- also 35294
	[22849] = "28579|A365|22790:2 22573:3 18256|22927",	-- Ironshield Potion
	[23] = "28585|A375|22452|||21886",	-- Transmute: Primal Earth to Life
	[24] = "28583|A375|21884|||22457",	-- Transmute: Primal Fire to Mana
	[25] = "28584|A375|21886|||22452",	-- Transmute: Primal Life to Earth
	[26] = "28582|A375|22457|||21884",	-- Transmute: Primal Mana to Fire
	[27] = "28580|A375|22456|||21885",	-- Transmute: Primal Shadow to Water
	[28] = "28581|A375|21885|||22456",	-- Transmute: Primal Water to Shadow
	[32839] = "41458|A375|22457:2 22793:7 23782",	-- Cauldron of Major Arcane Protection
	[32849] = "41500|A375|21884:2 22793:7 23782",	-- Cauldron of Major Fire Protection
	[32850] = "41501|A375|21885:2 22793:7 23782",	-- Cauldron of Major Frost Protection
	[32851] = "41502|A375|21886:2 22793:7 23782",	-- Cauldron of Major Nature Protection
	[32852] = "41503|A375|22456:2 22793:7 23782",	-- Cauldron of Major Shadow Protection
    [33208] = "42736|A375|22786:7 22791:3 22794:1 18256:1|33209", --Flask of Chromatic Wonder
--[[ Blacksmithing --]]
	[2853] = "2663|B1|2840:2",	-- Copper Bracers
	[2852] = "2662|B1|2840:4",	-- Copper Chain Pants
	[10421] = "12260|B1|2840:4",	-- Rough Copper Vest
	[2862] = "2660|B1|2835",	-- Rough Sharpening Stone
	[3239] = "3115|B1|2835 2589",	-- Rough Weightstone
	[2844] = "2737|B15|2840:6 2880 2589:2",	-- Copper Mace
	[2845] = "2738|B20|2840:6 2880 2589:2",	-- Copper Axe
	[3469] = "3319|B20|2840:8",	-- Copper Chain Boots
	[2847] = "2739|B25|2840:6 2880 2589:2",	-- Copper Shortsword
	[3470] = "3320|B25|2835:2",	-- Rough Grinding Stone
	[7955] = "9983|B30|2840:10 2880:2 3470 2318",	-- Copper Claymore
	[7166] = "8880|B30|2840:6 2880 3470 2318",	-- Copper Dagger
    [33791] = "43549|B35|2840:10 818:1 3470:2|33792", -- Heavy Copper Longsword
	[3488] = "3293|B35|2840:12 2880:2 774:2 3470:2 2318:2",	-- Copper Battle Axe
	[3471] = "3321|B35|2840:8 3470:2|3609",	-- Copper Chain Vest
	[2851] = "2661|B35|2840:6",	-- Copper Chain Belt
	[3472] = "3323|B40|2840:8 3470:2",	-- Runed Copper Gauntlets
	[3473] = "3324|B45|2840:8 2321:2 3470:3",	-- Runed Copper Pants
	[3474] = "3325|B60|2840:8 818 774|3610",	-- Gemmed Copper Gauntlets
	[2863] = "2665|B65|2836",	-- Coarse Sharpening Stone
	[3240] = "3116|B65|2836 2592",	-- Coarse Weightstone
	[6214] = "7408|B65|2840:12 2880:2 2318:2",	-- Heavy Copper Maul
	[3489] = "3294|B70|2840:10 2880:2 2842:2 3470:2 2318:2",	-- Thick War Axe
	[2857] = "2666|B70|2840:10",	-- Runed Copper Belt
	[3478] = "3326|B75|2836:2",	-- Coarse Grinding Stone
	[2864] = "2667|B80|2840:12 1210 3470:2|2881",	-- Runed Copper Breastplate
	[2854] = "2664|B90|2840:10 3470:3",	-- Runed Copper Bracers
	[3487] = "3292|B95|2840:14 2880:2 818:2 2319:2",	-- Heavy Copper Broadsword
	[6350] = "7817|B95|2841:6 3470:6",	-- Rough Bronze Boots
	[6731] = "8367|B100|2840:16 818:2 3470:3|6735",	-- Ironforge Breastplate
	[15869] = "19666|B100|2842 3470||2",	-- Silver Skeleton Key
	[29201] = "34979|B100|2841:6 3470:2 2319",	-- Thick Bronze Darts
	[6338] = "7818|B100|2842 3470:2",	-- Silver Rod
	[3848] = "3491|B105|2841:6 2880:4 3470:2 818 2319",	-- Big Bronze Knife
	[2865] = "2668|B105|2841:6",	-- Rough Bronze Leggings
	[2866] = "2670|B105|2841:7",	-- Rough Bronze Cuirass
	[2848] = "2740|B110|2841:6 2880:4 2319",	-- Bronze Mace
	[3480] = "3328|B110|2841:5 3478",	-- Rough Bronze Shoulders
	[5540] = "6517|B115|2841:6 3466 5498:2 3478:2",	-- Pearl-handled Dagger
	[2849] = "2741|B115|2841:7 2880:4 2319",	-- Bronze Axe
	[2868] = "2672|B120|2841:5 3478:2",	-- Patterned Bronze Bracers
	[2850] = "2742|B120|2841:5 2880:4 2319:2",	-- Bronze Shortsword
	[3490] = "3295|B125|2841:4 3466 2459 1210:2 3478:2 2319:2|2883",	-- Deadly Bronze Poniard
	[3481] = "3330|B125|2841:8 2842:2 3478:2|2882",	-- Silvered Bronze Shoulders
	[7956] = "9985|B125|2841:8 3466 2319",	-- Bronze Warhammer
	[3486] = "3337|B125|2838:3",	-- Heavy Grinding Stone
	[2871] = "2674|B125|2838",	-- Heavy Sharpening Stone
	[3241] = "3117|B125|2838 2592",	-- Heavy Weightstone
	[3491] = "3296|B130|2841:8 3466 1206 1210 3478:2 2319:2",	-- Heavy Bronze Mace
	[3482] = "3331|B130|2841:6 2842 3478:2",	-- Silvered Bronze Boots
	[2869] = "2673|B130|2841:10 2842:2 3478:2|5578",	-- Silvered Bronze Breastplate
	[7957] = "9986|B130|2841:12 3466:2 2319:2",	-- Bronze Greatsword
	[3483] = "3333|B135|2841:8 2842 3478:2",	-- Silvered Bronze Gauntlets
	[7958] = "9987|B135|2841:14 3466 2319:2",	-- Bronze Battle Axe
	[5541] = "6518|B140|2841:10 3466 5500 3478:2 2319:2|5543",	-- Iridescent Hammer
	[2870] = "2675|B145|2841:20 1206:2 1705:2 5500:2 2842:4",	-- Shining Silver Breastplate
	[3484] = "3334|B145|3575:6 3478:2 2605|3611",	-- Green Iron Boots
	[3492] = "3297|B145|3575:6 3466:2 3391 1705:2 3478:2 2319:2|3608",	-- Mighty Iron Hammer
	[15870] = "19667|B150|3577 3486||2",	-- Golden Skeleton Key
	[3485] = "3336|B150|3575:4 5498:2 3478:2 2605|3612",	-- Green Iron Gauntlets
	[3851] = "3494|B150|3575:8 3466:2 3486 2842:4 4234:2|10858",	-- Solid Iron Maul
	[11128] = "14379|B150|3577 3478:2",	-- Golden Rod
	[7071] = "8768|B150|3575||2",	-- Iron Buckle
	[6042] = "7221|B150|3575:6 3478:4|6044",	-- Iron Shield Spike
	[7914] = "9813|B155|3575:20 3486:4|7979",	-- Barbaric Iron Breastplate
	[3842] = "3506|B155|3575:8 3486 2605",	-- Green Iron Leggings
	[3849] = "3492|B155|3575:6 3466:2 3486 1705:2 4234:3|12162",	-- Hardened Iron Shortsword
	[10423] = "12259|B155|2841:12 2842:4 3478:2|10424",	-- Silvered Bronze Leggings
	[7913] = "9811|B160|3575:8 5635:4 3486:2|7978",	-- Barbaric Iron Shoulders
	[3840] = "3504|B160|3575:7 3486 2605|3870",	-- Green Iron Shoulders
	[3835] = "3501|B165|3575:6 2605",	-- Green Iron Bracers
	[6043] = "7222|B165|3575:4 3478:2 1705|6045",	-- Iron Counterweight
	[3852] = "3495|B170|3575:10 3577:4 1705:2 3466:2 4234:2 3486:2|3867",	-- Golden Iron Destroyer
	[3843] = "3507|B170|3575:10 3577:2 3486|3872",	-- Golden Scale Leggings
	[3836] = "3502|B170|3575:12 3864 2605",	-- Green Iron Helm
	[7915] = "9814|B175|3575:10 5637:2 5635:2|7980",	-- Barbaric Iron Helm
	[3841] = "3505|B175|3859:6 3577:2 3486|3871",	-- Golden Scale Shoulders
	[3850] = "3493|B175|3575:8 3466:2 3486:2 1529:2 4234:3|3866",	-- Jade Serpentblade
	[3853] = "3496|B175|3859:8 3466:2 3486:2 1705:3 4234:3|12163",	-- Moonsteel Broadsword
	[3844] = "3508|B180|3575:20 3486:4 1529:2 1206:2 4255",	-- Green Iron Hauberk
	[7916] = "9818|B180|3575:12 5637:4 3486:2|7981",	-- Barbaric Iron Boots
	[12259] = "15972|B180|3859:10 3466:2 1206 7067 4234",	-- Glinting Steel Dagger
	[3855] = "3498|B180|3575:14 3466:2 3486:2 3577:4 4234:2|12164",	-- Massive Iron Axe
	[7917] = "9820|B185|3575:14 3486:3 5637:2|7982",	-- Barbaric Iron Gloves
	[3846] = "3513|B185|3859:8 3864 1705 3486:2|3874",	-- Polished Steel Boots
	[6040] = "7223|B185|3859:5 3486:2",	-- Golden Scale Bracers
	[17704] = "21913|B190|3859:10 3829 7070:2 7069:2 4234:2|17706",	-- Edge of Winter
	[3837] = "3503|B190|3859:8 3577:2 3486:2|6047",	-- Golden Scale Coif
	[12260] = "15973|B190|3859:10 3577:4 7068:2 4234:2|12261",	-- Searing Golden Blade
	[6041] = "7224|B190|3859:8 3486:2 4234:4|6046",	-- Steel Weapon Chain
	[3845] = "3511|B195|3859:12 3577:2 3486:4|3873",	-- Golden Scale Cuirass
	[3854] = "3497|B200|3859:8 3466:2 3486:2 1529:2 3829 4234:4|3868",	-- Frost Tiger Blade
	[3847] = "3515|B200|3859:10 3577:4 3486:4|3875",	-- Golden Scale Boots
	[3856] = "3500|B200|3859:10 3466:2 3486:3 3864:2 3824 4234:3|3869",	-- Shadow Crescent Axe
	[7963] = "9916|B200|3859:16 3486:3",	-- Steel Breastplate
	[15871] = "19668|B200|6037 7966||2",	-- Truesilver Skeleton Key
	[29202] = "34981|B200|3859:5 7069:2 3486:2 4234",	-- Whirling Steel Axes
	[9060] = "11454|B200|3860:5 3577 6037|10713",	-- Inlaid Mithril Cylinder
	[7966] = "9920|B200|7912:4",	-- Solid Grinding Stone
	[7964] = "9918|B200|7912",	-- Solid Sharpening Stone
	[7965] = "9921|B200|7912 4306",	-- Solid Weightstone
	[11144] = "14380|B200|6037 3486",	-- Truesilver Rod
	[9366] = "11643|B205|3859:10 3577:4 3486:4|9367",	-- Golden Scale Gauntlets
	[7919] = "9928|B205|3860:6 4338:4",	-- Heavy Mithril Gauntlet
	[7918] = "9926|B205|3860:8 4234:6",	-- Heavy Mithril Shoulder
	[7941] = "9993|B210|3860:12 3864:2 7966 4234:4",	-- Heavy Mithril Axe
	[7921] = "9933|B210|3860:10|7975",	-- Heavy Mithril Pants
	[7920] = "9931|B210|3860:12",	-- Mithril Scale Pants
	[7924] = "9937|B215|3860:8|7995",	-- Mithril Scale Bracers
	[7967] = "9939|B215|3860:4 6037:2 7966:4|7976",	-- Mithril Shield Spike
	[7922] = "9935|B215|3859:14 7966",	-- Steel Plate Helm
	[7942] = "9995|B220|3860:16 7909:2 7966 4304:4|7992",	-- Blue Glittering Axe
	[7927] = "9950|B220|3860:10 4338:6 6037 7966|7984",	-- Ornate Mithril Gloves
	[7926] = "9945|B220|3860:12 6037 7966|7983",	-- Ornate Mithril Pants
	[7936] = "9979|B220|3860:14 6037:2 4304:4 7966 7909",	-- Ornate Mithril Boots
	[7935] = "9972|B220|3860:16 6037:6 7077 7966",	-- Ornate Mithril Breastplate
	[7937] = "9980|B220|3860:16 6037:2 7966",	-- Ornate Mithril Helm
	[7938] = "9954|B225|3860:10 6037:8 7909:3 3864:3 5966 7966:2",	-- Truesilver Gauntlets, removed armorsmith requirement
	[7928] = "9952|B225|3860:12 6037 4304:6|7985",	-- Ornate Mithril Shoulder
	[7943] = "9997|B225|3860:14 6037:4 7966 4304:2|8029",	-- Wicked Mithril Blade
	[7945] = "10001|B230|3860:16 7971 1210:4 7966 4304:2",	-- Big Black Mace
	[7930] = "9959|B230|3860:16",	-- Heavy Mithril Breastplate
	[7931] = "9961|B230|3860:10 4338:6",	-- Mithril Coif
	[7933] = "9968|B235|3860:14 4304:4",	-- Heavy Mithril Boots
	[7932] = "9966|B235|3860:14 4304:4|7991",	-- Mithril Scale Shoulders
	[7954] = "10003|B235|3860:24 7075:4 6037:6 3864:5 1529:5 7966:4 4304:4",	-- The Shatterer, removed weaponsmith requirement
	[7969] = "9964|B235|3860:4 7966:3|7989",	-- Mithril Spurs
	[7944] = "10005|B240|3860:14 7909 1705:2 1206:2 7966 4338:2|7993",	-- Dazzling Mithril Rapier
	[7934] = "9970|B245|3860:14 7909|7990",	-- Heavy Mithril Helm
	[7946] = "10009|B245|3860:18 7075:2 7966 4304:4|8028",	-- Runed Mithril Hammer
	[7939] = "9974|B245|3860:12 6037:12 7910:2 7971:2 7966:2",	-- Truesilver Breastplate, removed armorsmith requirement
	[7961] = "10007|B245|3860:28 7081:6 6037:8 3823:2 7909:6 7966:4 4304:2",	-- Phantom Blade, removed weaponsmith requirement
	[7959] = "10011|B250|3860:28 7972:10 6037:10 7966:6 4304:6",	-- Blight, removed weaponsmith requirement
	[12405] = "16642|B250|12359:16 12361 11188:4|12682",	-- Thorium Armor
	[12406] = "16643|B250|12359:12 11186:4|12683",	-- Thorium Belt
	[12644] = "16639|B250|12365:4",	-- Dense Grinding Stone
	[12404] = "16641|B250|12365",	-- Dense Sharpening Stone
	[12643] = "16640|B250|12365 14047",	-- Dense Weightstone
	[7947] = "10013|B255|3860:12 6037:6 7910:2 7966 4304:2|8030",	-- Ebon Shiv
	[12408] = "16644|B255|12359:12 11184:4|12684",	-- Thorium Bracers
	[11606] = "15293|B260|11371:10 7077:2|11614",	-- Dark Iron Mail
	[7960] = "10015|B260|3860:30 6037:16 7910:6 7081:4 7966:8 4304:6",	-- Truesilver Champion, removed armorsmith requirement
	[12416] = "16645|B260|12359:10 7077:2|12685",	-- Radiant Belt
	[11608] = "15292|B265|11371:18 7077:4|11610",	-- Dark Iron Pulverizer
	[12424] = "16647|B265|12359:10 8170:6|12688",	-- Imperial Plate Belt
	[12428] = "16646|B265|12359:12 8170:6|12687",	-- Imperial Plate Shoulders
	[12624] = "16650|B270|12359:40 12655:2 12803:4 8153:4 12364|12691",	-- Wildthorn Mail
	[11605] = "15295|B270|11371:6 7077|11615",	-- Dark Iron Shoulders
	[12425] = "16649|B270|12359:12|12690",	-- Imperial Plate Bracers
	[12415] = "16648|B270|12359:18 7077:2 7910|12689",	-- Radiant Breastplate
	[11607] = "15294|B275|11371:26 7077:4|11611",	-- Dark Iron Sunderer
	[12774] = "16970|B275|12359:30 12655:4 7910:4 12361:4 12644:2 8170:4|12821",	-- Dawn's Edge
	[15872] = "19669|B275|12360 12644||2",	-- Arcanite Skeleton Key
	[12773] = "16969|B275|12359:20 12799:2 12644:2 8170:4|12819",	-- Ornate Thorium Handaxe
	[12645] = "16651|B275|12359:4 12644:4 7076:2|12692",	-- Thorium Shield Spike
	[16206] = "20201|B275|12360:3 12644",	-- Arcanite Rod
	[12777] = "16978|B280|12655:10 7078:4 7077:4 12800:2 12644:2|12825",	-- Blazing Rapier
	[12776] = "16973|B280|12359:20 12655:6 12364:2 12804:4 8170:4|12824",	-- Enchanted Battlehammer
	[12775] = "16971|B280|12359:40 12644:6 8170:6|12823",	-- Huge Thorium Battleaxe
	[12409] = "16652|B280|12359:20 8170:8 11185:4|12693",	-- Thorium Boots
	[12410] = "16653|B280|12359:24 7910 11188:4|12694",	-- Thorium Helm
	[11604] = "15296|B285|11371:20 7077:8|11612",	-- Dark Iron Plate
	[12628] = "16667|B285|12359:40 12662:10 12361:4 7910:4|12696",	-- Demon Forged Breastplate
	[12781] = "16983|B285|12655:6 12360:2 12804:4 12799:2 12361:2 12364|12827",	-- Serenity
	[12418] = "16654|B285|12359:18 7077:4|12695",	-- Radiant Gloves
	[12782] = "16985|B290|12359:40 12360:2 12662:16 12808:8 12361:2 12644:2 8170:4|12830",	-- Corruption
	[12631] = "16655|B290|12359:20 12655:6 7078:2 7910:4|12699",	-- Fiery Plate Gauntlets
	[19051] = "23632|B290|12359:8 6037:6 12811|19203",	-- Girdle of the Dawn
	[19043] = "23628|B290|12359:12 7076:3 12803:3|19202",	-- Heavy Timbermaw Belt
	[12419] = "16656|B290|12359:14 7077:4|12697",	-- Radiant Boots
	[12792] = "16984|B290|12359:30 7077:4 7910:4 8170:4|12828",	-- Volcanic Hammer
	[17014] = "20874|B295|11371:4 17010:2 17011:2|17051",	-- Dark Iron Bracers
	[16989] = "20872|B295|11371:6 17010:3 17011:3|17049",	-- Fiery Chain Girdle
	[17193] = "21161|B295|17203:8 11371:20 12360:50 7078:25 11382:10 17011:10 17010:10|18592",	-- Sulfuron Hammer
	[12632] = "16661|B295|12359:20 12655:4 7080:4 12361:4|12703",	-- Storm Gauntlets
	[12426] = "16657|B295|12359:18|12700",	-- Imperial Plate Boots
	[12427] = "16658|B295|12359:18 7910|12701",	-- Imperial Plate Helm
	[12417] = "16659|B295|12359:18 7077:4|12702",	-- Radiant Circlet
	[19166] = "23638|B300|17011:3 17010:6 12360:12 11382 11371:4|19208",	-- Black Amnesty
	[22194] = "27589|B300|22203:8 22202:24 12810:8 13512|22220",	-- Black Grasp of the Destroyer
	[19167] = "23639|B300|17011:5 17010:2 12360:16 11371:6|19209",	-- Blackfury
	[19168] = "23652|B300|17011:6 17010:6 12360:10 11371:6 12809:12|19211",	-- Blackguard
	[20039] = "24399|B300|17011:3 17010:3 17012:4 11371:6|20040",	-- Dark Iron Boots
	[19164] = "23637|B300|17011:3 17010:5 17012:4 11371:4 11382:2|19207",	-- Dark Iron Gauntlets
	[19148] = "23636|B300|17011:4 17010:2 11371:4|19206",	-- Dark Iron Helm
	[17013] = "20876|B300|11371:16 17010:4 17011:6|17052",	-- Dark Iron Leggings
	[19170] = "23650|B300|17011:4 17010:7 12360:12 11371:8 12800:4|19210",	-- Ebon Hand
	[16988] = "20873|B300|11371:16 17010:4 17011:5|17053",	-- Fiery Chain Shoulders
	[22671] = "28244|B300|22682:4 12359:12 12360:2 7080:2",	-- Icebane Bracers
	[22669] = "28242|B300|22682:7 12359:16 12360:2 7080:4",	-- Icebane Breastplate
	[22670] = "28243|B300|22682:5 12359:12 12360:2 7080:2",	-- Icebane Gauntlets
	[12641] = "16746|B300|12360:30 12655:30 12364:6 12800:6|12728",	-- Invulnerable Mail
	[22198] = "27586|B300|22203:8 22202:24 12655:8 7076:4|22219",	-- Jagged Obsidian Shield
	[12640] = "16729|B300|12359:80 12360:12 8146:40 12361:10 12800:4|12717",	-- Lionheart Helm
	[19169] = "23653|B300|17011:8 17010:5 12360:10 11371:12 12364:4|19212",	-- Nightfall
	[22191] = "27590|B300|22203:15 22202:36 12810:12 12809:10 12800:4|22221",	-- Obsidian Mail Tunic
	[22384] = "27830|B300|12360:15 11371:10 12808:20 20520:20 15417:10 12753:2|22390",	-- Persuader
	[22383] = "27832|B300|12360:12 20725:2 13512:2 12810:4|22389",	-- Sageblade
	[12639] = "16741|B300|12360:15 12655:20 7076:10 12361:4 12799:4|12720",	-- Stronghold Gauntlets
	[22196] = "27587|B300|22203:18 22202:40 12655:12 7076:10 12364:4|22222",	-- Thick Obsidian Breastplate
	[22385] = "27829|B300|12360:12 12655:20 7076:10 13510:2|22388",	-- Titanic Leggings
	[12798] = "16991|B300|12359:40 12360:12 12808:10 12364:8 12644:2 12810:4|12835",	-- Annihilator
	[12790] = "16990|B300|12360:15 12800:8 12811 12799:4 12810:8 12644:2|12834",	-- Arcanite Champion
	[12784] = "16994|B300|12360:20 12810:6 12644:2|12838",	-- Arcanite Reaper
	[19690] = "24136|B300|12359:20 19774:10 19726:2 7910:2|19776",	-- Bloodsoul Breastplate
	[19692] = "24138|B300|12359:12 19774:6 19726:2 12810:4|19778",	-- Bloodsoul Gauntlets
	[19691] = "24137|B300|12359:16 19774:8 19726:2 7910|19777",	-- Bloodsoul Shoulders
	[17016] = "20897|B300|11371:18 17011:12 11382:2 12810:2|17060",	-- Dark Iron Destroyer
	[17015] = "20890|B300|11371:16 17010:12 11382:2 12810:2|17059",	-- Dark Iron Reaver
	[20550] = "24914|B300|12359:20 20520:10 6037:10|20554",	-- Darkrune Breastplate
	[20549] = "24912|B300|12359:12 20520:6 6037:6 12810:2|20553",	-- Darkrune Gauntlets
	[20551] = "24913|B300|12359:16 20520:8 6037:8 11754|20555",	-- Darkrune Helm
	[19693] = "24139|B300|12359:20 19774:14 12799:2|19779",	-- Darksoul Breastplate
	[19694] = "24140|B300|12359:18 19774:12 12799:2|19780",	-- Darksoul Leggings
	[19695] = "24141|B300|12359:16 19774:10 12799|19781",	-- Darksoul Shoulders
	[12618] = "16745|B300|12360:8 12655:24 7076:4 7080:4 12364:2 12800:2|12727",	-- Enchanted Thorium Breastplate
	[12620] = "16742|B300|12360:6 12655:16 7076:6 12799:2 12800|12725",	-- Enchanted Thorium Helm
	[12619] = "16744|B300|12360:10 12655:20 7080:6 12361:2 12364|12726",	-- Enchanted Thorium Leggings
	[12797] = "16992|B300|12360:18 12361:8 12800:8 7080:4 12644:2 12810:4|12836",	-- Frostguard
	[19057] = "23633|B300|12360:2 6037:10 12811|19205",	-- Gloves of the Dawn
	[12796] = "16988|B300|12359:50 12360:15 12809:4 12810:6 7076:10|12833",	-- Hammer of the Titans
	[12783] = "16995|B300|12360:10 12655:10 12810:2 7910:6 12800:6 12799:6 12644:4|12839",	-- Heartseeker
	[22197] = "27585|B300|22202:14 12655:4 7076:2|22209",	-- Heavy Obsidian Belt
	[19048] = "23629|B300|12360:4 7076:6 12803:6|19204",	-- Heavy Timbermaw Boots
	[12636] = "16728|B300|12359:40 12655:4 8168:60 12799:6 12364:2|12716",	-- Helm of the Great Chief
	[22764] = "28463|B300|12655:6 12803:2|22768",	-- Ironvine Belt
	[22762] = "28461|B300|12655:12 19726:2 12360:2 12803:2|22766",	-- Ironvine Breastplate
	[22763] = "28462|B300|12655:8 19726 12803:2|22767",	-- Ironvine Gloves
	[22195] = "27588|B300|22202:14 12810:4|22214",	-- Light Obsidian Belt
	[12794] = "16993|B300|12655:20 12364:8 12799:8 7076:6 12810:4|12837",	-- Masterwork Stormhammer
	[12633] = "16724|B300|12359:20 12655:4 6037:6 3577:6 12800:2|12711",	-- Whitesoul Helm
	[18262] = "22757|B300|7067:2 12365:3|18264",	-- Elemental Sharpening Stone
	[29203] = "34982|B300|12655:2 12359:6 8170",	-- Enchanted Thorium Blades
	[23493] = "29551|B300|23445:4",	-- Fel Iron Chain Coif
	[23482] = "29545|B300|23445:4",	-- Fel Iron Plate Gloves
	[12422] = "16663|B300|12359:20|12705",	-- Imperial Plate Chest
	[12429] = "16730|B300|12359:24|12715",	-- Imperial Plate Leggings
	[12420] = "16725|B300|12359:20 7077:4|12713",	-- Radiant Leggings
	[12613] = "16731|B300|12359:40 12360:2 7910|12718",	-- Runic Breastplate
	[12611] = "16665|B300|12359:20 12360:2 2842:10|12707",	-- Runic Plate Boots
	[12612] = "16726|B300|12359:30 12360:2 6037:2 12364|12714",	-- Runic Plate Helm
	[12614] = "16732|B300|12359:40 12360:2 7910|12719",	-- Runic Plate Leggings
	[12610] = "16664|B300|12359:20 12360:2 3577:6|12706",	-- Runic Plate Shoulders
	[12414] = "16662|B300|12359:26 11186:4|12704",	-- Thorium Leggings
	[25843] = "32655|B300|23445:6",	-- Fel Iron Rod
	[23528] = "29654|B300|23445 22573",	-- Fel Sharpening Stone
	[28420] = "34607|B300|23445 21877",	-- Fel Weightstone
	[23484] = "29547|B305|23445:4",	-- Fel Iron Plate Belt
	[23491] = "29552|B310|23445:5",	-- Fel Iron Chain Gloves
	[23497] = "29557|B310|23445:9",	-- Fel Iron Hatchet
	[23494] = "29553|B315|23445:6",	-- Fel Iron Chain Bracers
	[23498] = "29558|B315|23445:10",	-- Fel Iron Hammer
	[23487] = "29548|B315|23445:6",	-- Fel Iron Plate Boots
	[23488] = "29549|B315|23445:8",	-- Fel Iron Plate Pants
	[23490] = "29556|B320|23445:9",	-- Fel Iron Chain Tunic
	[23499] = "29565|B320|23445:12",	-- Fel Iron Greatsword
	[23502] = "29566|B325|23446:8|23590",	-- Adamantite Maul
	[23489] = "29550|B325|23445:10",	-- Fel Iron Breastplate
	[23559] = "32284|B325|23446",	-- Lesser Rune of Warding
	[23503] = "29568|B330|23446:8|23591",	-- Adamantite Cleaver
	[23504] = "29569|B330|23446:7 21887:2|23592",	-- Adamantite Dagger
    [33185] = "42688|B335|23573:2 23449|33186", -- Adamantite Weapon Chain -- also 35296
	[23506] = "29603|B335|23446:6 22452:2 21884:2|23594",	-- Adamantite Plate Bracers
	[23508] = "29605|B335|23446:8 21887:2 22452:3 21884:2|23595",	-- Adamantite Plate Gloves
	[23505] = "29571|B335|23446:12|23593",	-- Adamantite Rapier
	[23507] = "29606|B340|23446:12 22452:4 21884:2|23596",	-- Adamantite Breastplate
	[23575] = "29728|B340|23446|23638||23575",	-- Lesser Ward of Shielding
	[29204] = "34983|B350|23448:6 22451:2 21884:2 23793",	-- Felsteel Whisper Knives
	[23515] = "29614|B350|23445:6 21885:3 21884:2|23601",	-- Flamebane Bracers
	[23529] = "29656|B350|23446 22573:2|23618",	-- Adamantite Sharpening Stone
	[28421] = "34608|B350|23446 21877:2|28632",	-- Adamantite Weightstone
	[25844] = "32656|B350|23446:10|25846",	-- Adamantite Rod
	[25521] = "32285|B350|23449|25526",	-- Greater Rune of Warding
	[23510] = "29608|B355|23573:2 22445:8 22449:2|23597",	-- Enchanted Adamantite Belt
	[23511] = "29611|B355|23573:3 22445:12 22449:2|23598",	-- Enchanted Adamantite Boots
	[23516] = "29615|B355|23445:12 21885:5 21884:3|23602",	-- Flamebane Helm
	[23509] = "29610|B360|23573:4 22445:20 22449:4|23599",	-- Enchanted Adamantite Breastplate
	[23517] = "29619|B360|23448:6|23605",	-- Felsteel Gloves
	[23518] = "29620|B360|23448:8|23606",	-- Felsteel Leggings
	[23514] = "29616|B360|23445:8 21885:4 21884:4|23603",	-- Flamebane Gloves
	[23524] = "29628|B360|23449:3 21885:2 22457:2|23608",	-- Khorium Belt
	[23523] = "29629|B360|23449:6 21885:4 22457:4|23609",	-- Khorium Pants
	[23530] = "29657|B360|23448:4 21884:4 22452:4|24002",	-- Felsteel Shield Spike
	[23537] = "29669|B365|23448:6 22456:15 23572|23626",	-- Black Felsteel Bracers
	[23539] = "29672|B365|23573:6 23571:2 21885:15 23572|23628",	-- Blessed Bracers
	[23538] = "29671|B365|23573:6 21886:20 23572|23627",	-- Bracers of the Green Fortress
	[23555] = "29699|B365|23449:10 23448:10 23571:8 23572:2|23636",	-- Dirge
	[23554] = "29698|B365|23449:10 23573:4 23447:10 23571:8 23572:2|23635",	-- Eternium Runed Blade
	[23542] = "29694|B365|23449:10 23448:10 23571:8 23572:2|23631",	-- Fel Edged Battleaxe
	[23546] = "29697|B365|23449:10 23448:10 23571:8 23572:2|23634",	-- Fel Hardened Maul
	[23531] = "29658|B365|23448:10 23571:3 23572|23620",	-- Felfury Gauntlets
	[23540] = "29692|B365|23449:10 23448:10 23571:6 23572:2|23629",	-- Felsteel Longblade
	[23543] = "29695|B365|23449:10 23448:10 23571:8 23572:2|23632",	-- Felsteel Reaper
	[23532] = "29622|B365|23573:10 23571:2 22452:15 23572|23621",	-- Gauntlets of the Iron Tower
	[23556] = "29700|B365|23449:10 23573:4 23447:10 23571:8 23572:4|23637",	-- Hand of Eternity
	[23535] = "29664|B365|23573:8 22452:22 22457:12 23572|23624",	-- Helm of the Stalwart Defender
	[23541] = "29693|B365|23449:20 23573:2 23571:6 23572:2|23630",	-- Khorium Champion
	[23536] = "29668|B365|23573:8 23571:3 21886:18 23572|23625",	-- Oathkeeper's Helm
	[23544] = "29696|B365|23449:10 23448:10 23571:8 23572:2|23633",	-- Runic Hammer
	[23533] = "29662|B365|23448:10 23571:5 23572|23622",	-- Steelgrip Gauntlets
	[23534] = "29663|B365|23573:8 22451:16 21885:16 23572|23623",	-- Storm Helm
	[23512] = "29613|B365|23573:4 22445:24 22449:4|23600",	-- Enchanted Adamantite Leggings
	[23519] = "29621|B365|23448:8|23607",	-- Felsteel Helm
	[23513] = "29617|B365|23445:16 21885:6 21884:4|23604",	-- Flamebane Breastplate
	[23525] = "29630|B365|23449:4 21885:3 22457:3|23610",	-- Khorium Boots
	[23520] = "29642|B365|23445:8 21884:6 23449:3 22824:2|23611",	-- Ragesteel Gloves
	[23521] = "29643|B365|23445:10 21884:10 23449:4 22824:4|23612",	-- Ragesteel Helm
    [33173] = '42662|B365|23445:12 21884:2 23449:8 27503:2|33174||33173', --Ragesteel Shoulders
    [32854] = "43846|B365|23449:16 23448:12 23571:6 23572:2|33954", -- Hammer of Righteous Might
	[23527] = "29649|B370|23573:4 21886:6 22452:4|23617",	-- Earthpeace Breastplate
	[23522] = "29645|B370|23445:12 21884:10 23449:6 22824:4|23613",	-- Ragesteel Breastplate
	[31369] = "38477|B375|23449:8 21885:12 21884:12 23572|31393",	-- Iceguard Breastplate
	[31371] = "38479|B375|23449:8 21885:12 21884:12 23572|31395",	-- Iceguard Helm
	[31370] = "38478|B375|23449:8 21885:12 21884:12 23572|31394",	-- Iceguard Leggings
	[31364] = "38473|B375|23448:8 21886:12 22456:12 23572|31390",	-- Wildguard Breastplate
	[31368] = "38476|B375|23448:8 21886:12 22456:12 23572|31392",	-- Wildguard Helm
	[31367] = "38475|B375|23448:8 21886:12 22456:12 23572|31391",	-- Wildguard Leggings
	[25845] = "32657|B375|23447:4|25847",	-- Eternium Rod
	[23576] = "29729|B375|23447|23639||23576",	-- Greater Ward of Shielding
    [30034] = '36389|B375|30183:2 23573:5 21885:10 22452:5|30321', --Belt of the Guardian
    [30033] = '36391|B375|23572:2 23573:12 21885:5|30323', -- Boots of the Protector
    [30032] = '36390|B375|30183:2 23573:5 21884:10|30322', -- Red Belt of Battle
    [30031] = '36392|B375|23572:2 23573:4 21884:12|30324', -- Red Havok Boots
    [32573] = '41135|B375|23449:18 23573:2 21884:8 32428:2|32739', --Dawnsteel Shoulders -- also 35530
    [32568] = '41132|B375|23448:14 23573:2 22451:6 32428:2|32736', --Swiftsteel Bracers -- also 35531
    [32571] = '41134|B375|23449:14 23573:2 21884:2 32428:2|32738', --Dawnsteel Bracers -- also 35529
    [32570] = '41133|B375|23448:18 23573:2 22451:8 32428:2|32737', --Swiftsteel Shoulders -- also 35532
    [32403] = '40034|B375|32428:1 22450:1 21886:2 22456:2 23446:4|32442', --Shadesteel Bracers
    [32401] = '40036|B375|32428:2 22450:1 21886:3 22456:4 23446:6|32444', --Shadesteel Girdle
    [32404] = '40035|B375|32428:3 22450:1 21886:4 22456:6 23446:12|32443', --Shadesteel Greaves
    [32402] = '40033|B375|32428:2 22450:1 21886:2 22456:4 23446:4|32442', --Shadesteel Sabots
--[[ blacksmithing specialty --]]
	[30069] = "36122|Ba260|3860:16 7075:2",	-- Earthforged Leggings
	[30070] = "36124|Ba260|3860:16 7081:2",	-- Windforged Leggings
	[30074] = "36129|Ba330|23446:8 22452:4",	-- Heavy Earthforged Breastplate
	[30076] = "36130|Ba330|23446:8 21885:2 22451:2",	-- Stormforged Hauberk
	[28483] = "34533|Ba350|23571:8 23573:6 23447:6 23449:8",	-- Breastplate of Kings
	[23563] = "34529|Ba350|22456:20 22451:20 23573:6 23448:4 23449:8",	-- Nether Chain Shirt
	[28484] = "34534|Ba375|28483 23572:10 22457:10",	-- Bulwark of Kings
	[28485] = "36257|Ba375|28484 30183:2",	-- Bulwark of the Ancient Kings
	[23565] = "36256|Ba375|23564 30183:2",	-- Embrace of the Twisting Nether
	[23564] = "34530|Ba375|23563 23572:10 22457:10",	-- Twisting Nether Chain Shirt
	[30071] = "36125|Bw260|3860:12 7075:4",	-- Light Earthforged Blade
	[30073] = "36128|Bw260|3860:12 7077:4",	-- Light Emberforged Hammer
	[30072] = "36126|Bw260|3860:12 7081:4",	-- Light Skyforged Axe
	[30088] = "36135|Bwx330|23446:10 22451:6",	-- Skyforged Great Axe
	[30087] = "36134|Bwx330|23446:8 21885:3 22451:3",	-- Stormforged Axe
	[28434] = "34543|Bwx350|22451:12 22452:12 23571:4 23447:22",	-- Lunar Crescent
	[28431] = "34541|Bwx350|23571:5 22456:20 23573:2 23448:12",	-- The Planar Edge
	[28432] = "34542|Bwx375|28431 23572:8 23448:6",	-- Black Planar Edge
	[28436] = "36261|Bwx375|28435 30183:5",	-- Bloodmoon
	[28435] = "34544|Bwx375|28434 23572:8 22457:10",	-- Mooncleaver
	[28433] = "36260|Bwx375|28432 30183:5",	-- Wicked Edge of the Planes
	[30093] = "36137|Bwh330|23446:12 22452:6",	-- Great Earthforged Hammer
	[30089] = "36136|Bwh330|23446:8 21884:6",	-- Lavaforged Warhammer
	[28437] = "34545|Bwh350|21884:20 22452:20 23447:12 23449:8",	-- Drakefist Hammer
	[28440] = "34547|Bwh350|22451:20 21885:20 23573:6 23449:12",	-- Thunder
	[28441] = "34548|Bwh375|28440 23572:8 22457:10",	-- Deep Thunder
	[28438] = "34546|Bwh375|28437 23572:8 23571:2",	-- Dragonmaw
	[28439] = "36262|Bwh375|28438 30183:5",	-- Dragonstrike
	[28442] = "36263|Bwh375|28441 30183:5",	-- Stormherald
	[30086] = "36133|Bws330|23446:10 22452:6",	-- Stoneforged Claymore
	[30077] = "36131|Bws330|23446:6 22451:6",	-- Windforged Rapier
	[28425] = "34535|Bws350|22456:20 22457:20 23448:14",	-- Fireguard
	[28428] = "34538|Bws350|23571:10 23449:14 23573:6",	-- Lionheart Blade
	[28427] = "36258|Bws375|28426 30183:5",	-- Blazefury
	[28426] = "34537|Bws375|28425 23572:8 22451:10",	-- Blazeguard
	[28429] = "34540|Bws375|28428 23572:8 23571:2",	-- Lionheart Champion
	[28430] = "36259|Bws375|28429 30183:5",	-- Lionheart Executioner
--[[ Horde only blacksmithing, needs fixed --]]
	[7929] = "9957|B220|3860:12 7067|99999",	-- Orcish War Leggings
--[[ Cooking --]]
    [33924] = "43779|W1|30817:8 1179:4 2678:4 6889:8 2593:1 785:3|33925", -- Delicious Chocolate Cake
	[6290] = "7751|W1|6291|6325",	-- Brilliant Smallfish
	[2679] = "2538|W1|2672",	-- Charred Wolf Meat
	[12224] = "15935|W1|12223 2678|12226",	-- Crispy Bat Wing
	[17197] = "21143|W1|6889 17194|17200",	-- Gingerbread Cookie
	[6888] = "8604|W1|6889 2678",	-- Herb Baked Egg
	[27635] = "33276|W1|27668|27685",	-- Lynx Steak
	[2681] = "2540|W1|769",	-- Roasted Boar Meat
	[24105] = "33277|W1|23676|27686",	-- Roasted Moongraze Tenderloin
	[787] = "7752|W1|6303|6326",	-- Slitherskin Mackerel
	[30816] = "37836|W1|30817 2678",	-- Spice Bread
	[2888] = "2795|W10|2886 2894|2889",	-- Beer Basted Boar Ribs
	[5472] = "6412|W10|5465|5482",	-- Kaldorei Spider Kabob
	[2680] = "2539|W10|2672 2678",	-- Spiced Wolf Meat
	[5473] = "6413|W20|5466|5483",	-- Scorpid Surprise
	[17198] = "21144|W35|6889 1179 17196 17194|17201",	-- Egg Nog
	[5474] = "6414|W35|5467 2678|5484|2",	-- Roasted Kodo Meat
	[6890] = "8607|W40|3173|6892",	-- Smoked Bear Meat
	[27636] = "33278|W50|27669|27687",	-- Bat Bites
	[5525] = "6499|W50|5503 159",	-- Boiled Clams
	[2684] = "2541|W50|2673",	-- Coyote Steak
	[5476] = "6415|W50|5468 2678|5485|2",	-- Fillet of Frenzy
	[724] = "2542|W50|723 2678|2697",	-- Goretusk Liver Pie
	[6316] = "7754|W50|6317 2678|6329",	-- Loch Frenzy Delight
	[4592] = "7753|W50|6289|6328",	-- Longjaw Mud Snapper
	[5095] = "7827|W50|6361|6368",	-- Rainbow Fin Albacore
	[5477] = "6416|W50|5469 4536|5486|2",	-- Strider Stew
	[3220] = "3371|W60|3173 3172 3174|3679|2",	-- Blood Sausage
	[22645] = "28267|W60|22644|22647",	-- Crunchy Spider Surprise
	[7676] = "9513|W60|2452 159|18160",	-- Thistle Tea
	[2683] = "2544|W75|2674 2678",	-- Crab Cake
	[733] = "2543|W75|729 730 731|728",	-- Westfall Stew
	[3662] = "3370|W80|2924 2678|3678",	-- Crocolisk Steak
	[2687] = "2546|W80|2677 2678",	-- Dry Pork Ribs
	[21072] = "25704|W80|21071 2678|21099",	-- Smoked Sagefish
	[2682] = "2545|W85|2675 2678|2698",	-- Cooked Crab Claw
	[6657] = "8238|W85|6522 2678|6661",	-- Savory Deviate Delight
	[5526] = "6501|W90|5503 1179 2678|5528",	-- Clam Chowder
	[5478] = "6417|W90|5051|5487|2",	-- Dig Rat Stew
	[3663] = "3372|W90|1468:2 2692|3680",	-- Murloc Fin Soup
	[4593] = "7755|W100|6308|6330",	-- Bristle Whisker Catfish
	[5479] = "6418|W100|5470 2692|5488|2",	-- Crispy Lizard Tail
	[1082] = "2547|W100|1081 1080|2699",	-- Redridge Goulash
	[1017] = "2549|W100|1015:2 2665|2701|3",	-- Seasoned Wolf Kabob
	[3726] = "3397|W110|3730 2692|3734",	-- Big Bear Steak
	[3666] = "3377|W110|2251:2 2692|3683",	-- Gooey Spider Cake
	[5480] = "6419|W110|5471 2678:4|5489|2",	-- Lean Venison
	[2685] = "2548|W110|2677:2 2692|2700",	-- Succulent Pork Ribs
	[3664] = "3373|W120|3667 2692|3681",	-- Crocolisk Gumbo
	[5527] = "6500|W125|5504 2692",	-- Goblin Deviled Clams
	[3727] = "3398|W125|3731 2692|3735",	-- Hot Lion Chops
	[12209] = "15853|W125|1015 2678|12227",	-- Lean Wolf Steak
	[3665] = "3376|W130|3685 2692|3682",	-- Curiously Tasty Omelet
	[20074] = "24418|W150|3667:2 3713|20075",	-- Heavy Crocolisk Stew
	[3728] = "3399|W150|3731:2 3713|3736",	-- Tasty Lion Steak
	[4457] = "4094|W175|3404 2692|4609",	-- Barbecued Buzzard Wing
	[12213] = "15863|W175|12037 2692|12232",	-- Carrion Surprise
	[6038] = "7213|W175|4655 2692|6039",	-- Giant Clam Scorcho
	[10841] = "13028|W175|3821 159||4",	-- Goldthorn Tea
	[13851] = "15856|W175|12203 2692|12229",	-- Hot Wolf Ribs
	[12212] = "15861|W175|12202 159 4536:2|12231|2",	-- Jungle Stew
	[8364] = "20916|W175|8365|17062",	-- Mithril Headed Trout
	[12214] = "15865|W175|12037 2596|12233",	-- Mystery Stew
	[12210] = "15855|W175|12184 2692|12228",	-- Roast Raptor
	[4594] = "7828|W175|6362|6369",	-- Rockscale Cod
	[21217] = "25954|W175|21153 2692|21219",	-- Sagefish Delight
	[3729] = "3400|W175|3712 3713|3737",	-- Soothing Turtle Bisque
	[12217] = "15906|W200|12037 4402 2692|12239",	-- Dragonbreath Chili
	[12215] = "15910|W200|12204:2 3713 159|12240|2",	-- Heavy Kodo Stew
	[17222] = "21175|W200|12205:2",	-- Spider Sausage
	[13927] = "18239|W225|13754 3713|13940",	-- Cooked Glossy Mightfish
	[13930] = "18241|W225|13758|13941",	-- Filet of Redgill
	[12218] = "15933|W225|12207 3713:2|16110",	-- Monster Omelet
	[12216] = "15915|W225|12206 2692:2|16111",	-- Spiced Chili Crab
	[6887] = "18238|W225|4603|13939",	-- Spotted Yellowtail
	[18045] = "22480|W225|12208 3713|18046",	-- Tender Wolf Steak
	[16766] = "20626|W225|7974:2 2692 1179|16767|2",	-- Undermine Clam Chowder
	[13928] = "18240|W240|13755 3713|13942",	-- Grilled Squid
	[13929] = "18242|W240|13756 2692:2|13943",	-- Hot Smoked Bass
	[13931] = "18243|W250|13759 159|13945",	-- Nightfin Soup
	[13932] = "18244|W250|13760|13946",	-- Poached Sunscale Salmon
	[13935] = "18247|W275|13889 3713|13949",	-- Baked Salmon
	[13933] = "18245|W275|13888 159|13947",	-- Lobster Stew
	[13934] = "18246|W275|13893 2692 3713|13948",	-- Mightfish Steak
	[18254] = "22761|W275|18255 3713|18267",	-- Runn Tum Tuber Surprise
	[20452] = "24801|W285|20424 3713",	-- Smoked Desert Dumplings
	[27661] = "33290|W300|27422|27694",	-- Blackened Trout
	[27651] = "33279|W300|27671|27684",	-- Buzzard Bites
	[30155] = "36210|W300|24477:2 3713|30156",	-- Clam Bar
	[21023] = "25659|W300|2692 9061 8150 21024|21025|5",	-- Dirge's Kickin' Chimaerok Chops
	[27662] = "33291|W300|27425|27695",	-- Feltail Delight
	[27655] = "33284|W300|27674|27688",	-- Ravager Dog
    [33867] = "43761|W300|33823:1|33869", -- Broiled Bloodfin
    [33874] = "43772|W300|27671|33875", -- Kibler's Bits
    [33866] = "43758|W300|27678 13757|33871", -- Stormchops
	[27663] = "33292|W310|27429|27696",	-- Blackened Sporefish
	[27656] = "33285|W310|27676|27689",	-- Sporeling Snack
	[27657] = "33286|W315|27677|27690",	-- Blackened Basilisk
	[27664] = "33293|W320|27435|27697",	-- Grilled Mudfish
	[27665] = "33294|W320|27437|27698",	-- Poached Bluefish
	[27666] = "33295|W325|27438|27699",	-- Golden Fish Sticks
	[27658] = "33287|W325|27678|27691",	-- Roasted Clefthoof
	[27660] = "33289|W325|27682|27693",	-- Talbuk Steak
	[27659] = "33288|W325|27681|27692",	-- Warp Burger
    [34411] = "45022|W325|34412 17196 17194|34413|2", --Hot Apple Cider
    [33825] = "43707|W325|33824|33870", -- Skullfish Soup
    [33872] = "43765|W325|27682 2692|33873", -- Spicy Hot Talbuk
	[31673] = "38868|W335|31671|31674",	-- Crunchy Serpent
	[31672] = "38867|W335|31670|31675",	-- Mok'Nathal Shortribs
	[27667] = "33296|W350|27439|27700",	-- Spicy Crawdad
	[33048] = "42296|W325|27422 2593 3713",	-- Stewed Trout
	[33052] = "42302|W350|27515 4539:5 3713:5||6",	-- Fisherman's Feast
	[33053] = "42305|W350|27516 3713:2||2",	-- Hot Buttered Trout
--[[ Enchanting --]]
	[6218] = "7421|D1|6217 10940 10938",	-- Runed Copper Rod
	[-7428] = "D1|10938 10940",	-- Enchant Bracer - Minor Deflection
	[-7418] = "D1|10940",	-- Enchant Bracer - Minor Health
	[11287] = "14293|D10|4470 10938",	-- Lesser Magic Wand
	[-7420] = "D15|10940",	-- Enchant Chest - Minor Health
	[-7443] = "D20|10938|6342",	-- Enchant Chest - Minor Mana
	[-7426] = "D40|10940:2 10938",	-- Enchant Chest - Minor Absorption
	[20744] = "25124|D45|10940:2 17034 3371",	-- Minor Wizard Oil
	[-7454] = "D45|10940 10938:2",	-- Enchant Cloak - Minor Resistance
	[-7457] = "D50|10940:3",	-- Enchant Bracer - Minor Stamina
	[-7766] = "D60|10938:2|6344",	-- Enchant Bracer - Minor Spirit
	[-7748] = "D60|10940:2 10938:2",	-- Enchant Chest - Lesser Health
	[11288] = "14807|D70|4470 10939",	-- Greater Magic Wand
	[-7771] = "D70|10940:3 10939",	-- Enchant Cloak - Minor Protection
	[-7779] = "D80|10940:2 10939",	-- Enchant Bracer - Minor Agility
	[-7782] = "D80|10940:5|6347",	-- Enchant Bracer - Minor Strength
	[-7776] = "D80|10939 10938|6346",	-- Enchant Chest - Lesser Mana
	[-7786] = "D90|10940:4 10939:2|6348",	-- Enchant Weapon - Minor Beastslayer
	[-7788] = "D90|10940:2 10939 10978",	-- Enchant Weapon - Minor Striking
	[6339] = "7795|D100|6338 10940:6 10939:3 6218",	-- Runed Silver Rod
	[-7793] = "D100|10939:3|6349",	-- Enchant 2H Weapon - Lesser Intellect
	[-7745] = "D100|10940:4 10978",	-- Enchant 2H Weapon - Minor Impact
	[-13378] = "D105|10998 10940:2",	-- Enchant Shield - Minor Stamina
	[-13380] = "D110|10998 10940:6|11038",	-- Enchant 2H Weapon - Lesser Spirit
	[-13419] = "D110|10998|11039",	-- Enchant Cloak - Minor Agility
	[-13421] = "D115|10940:6 10978",	-- Enchant Cloak - Lesser Protection
	[-13464] = "D115|10998 10940 10978|11081",	-- Enchant Shield - Lesser Protection
	[-7859] = "D120|10998:2|6375",	-- Enchant Bracer - Lesser Spirit
	[-7857] = "D120|10940:4 10998",	-- Enchant Chest - Health
	[-7867] = "D125|10940:6 10998:2|6377",	-- Enchant Boots - Minor Agility
	[-7863] = "D125|10940:8",	-- Enchant Boots - Minor Stamina
	[-7861] = "D125|6371 10998",	-- Enchant Cloak - Lesser Fire Resistance
	[-13501] = "D130|11083:2",	-- Enchant Bracer - Lesser Stamina
	[-13485] = "D130|10998:2 10940:4",	-- Enchant Shield - Lesser Spirit
	[-13522] = "D135|11082 6048|11098",	-- Enchant Cloak - Lesser Shadow Resistance
	[-13536] = "D140|11083:2|11101",	-- Enchant Bracer - Lesser Strength
	[-13538] = "D140|10940:2 11082 11084",	-- Enchant Chest - Lesser Absorption
	[-13503] = "D140|11083:2 11084",	-- Enchant Weapon - Lesser Striking
	[-13529] = "D145|11083:3 11084",	-- Enchant 2H Weapon - Lesser Impact
	[-13607] = "D145|11082 10998:2",	-- Enchant Chest - Mana
	[-13620] = "D145|11083 6370:3|11152",	-- Enchant Gloves - Fishing
	[-13617] = "D145|11083 3356:3|11151",	-- Enchant Gloves - Herbalism
	[-13612] = "D145|11083 2772:3|11150",	-- Enchant Gloves - Mining
	[20745] = "25125|D150|11083:3 17034:2 3372|20752",	-- Minor Mana Oil
	[11130] = "13628|D150|11128 5500 11082:2 11083:2 6339",	-- Runed Golden Rod
	[-13622] = "D150|11082:2",	-- Enchant Bracer - Lesser Intellect
	[-13626] = "D150|11082 11083 11084",	-- Enchant Chest - Minor Stats
	[11289] = "14809|D155|11291 11134 11083",	-- Lesser Mystic Wand
	[-13635] = "D155|11138 11083:3",	-- Enchant Cloak - Defense
	[-13631] = "D155|11134 11083",	-- Enchant Shield - Lesser Stamina
	[-13637] = "D160|11083 11134",	-- Enchant Boots - Lesser Agility
	[-13640] = "D160|11083:3",	-- Enchant Chest - Greater Health
	[-13642] = "D165|11134",	-- Enchant Bracer - Spirit
	[-13644] = "D170|11083:4",	-- Enchant Boots - Lesser Stamina
	[-13646] = "D170|11134 11083:2|11163",	-- Enchant Bracer - Lesser Deflection
	[-13648] = "D170|11083:6",	-- Enchant Bracer - Stamina
	[11290] = "14810|D175|11291 11135 11137",	-- Greater Mystic Wand
	[-13657] = "D175|11134 7068",	-- Enchant Cloak - Fire Resistance
	[-13653] = "D175|11134 5637:2 11138|11164",	-- Enchant Weapon - Lesser Beastslayer
	[-13655] = "D175|11134 7067 11138|11165",	-- Enchant Weapon - Lesser Elemental Slayer
	[-13661] = "D180|11137",	-- Enchant Bracer - Strength
	[-13659] = "D180|11135 11137",	-- Enchant Shield - Spirit
	[-13663] = "D185|11135",	-- Enchant Chest - Greater Mana
	[-13687] = "D190|11135 11134:2|11167",	-- Enchant Boots - Lesser Spirit
	[-21931] = "D190|11135:3 11137:3 11139 3819:2|17725",	-- Enchant Weapon - Winter's Might
	[-13689] = "D195|11135:2 11137:2 11139|11168",	-- Enchant Shield - Lesser Block
	[-13693] = "D195|11135:2 11139",	-- Enchant Weapon - Striking
	[20746] = "25126|D200|11137:3 17035:2 3372",	-- Lesser Wizard Oil
	[11145] = "13702|D200|11144 7971 11135:2 11137:2 11130",	-- Runed Truesilver Rod
	[-13695] = "D200|11137:4 11139",	-- Enchant 2H Weapon - Impact
	[-13700] = "D200|11135:2 11137:2 11139",	-- Enchant Chest - Lesser Stats
	[-13698] = "D200|11137 7392:3|11166",	-- Enchant Gloves - Skinning
	[-13746] = "D205|11137:3",	-- Enchant Cloak - Greater Defense
	[-13794] = "D205|11174",	-- Enchant Cloak - Resistance
	[-13822] = "D210|11174:2",	-- Enchant Bracer - Intellect
	[-13815] = "D210|11174 11137",	-- Enchant Gloves - Agility
	[-13817] = "D210|11137:5|11202",	-- Enchant Shield - Stamina
	[-13836] = "D215|11137:5",	-- Enchant Boots - Stamina
	[-13841] = "D215|11137:3 6037:3|11203",	-- Enchant Gloves - Advanced Mining
	[-13846] = "D220|11174:3 11137|11204",	-- Enchant Bracer - Greater Spirit
	[-13858] = "D220|11137:6",	-- Enchant Chest - Superior Health
	[-13890] = "D225|11177 7909 11174",	-- Enchant Boots - Minor Speed
	[-13882] = "D225|11174:2|11206",	-- Enchant Cloak - Lesser Agility
	[-13868] = "D225|11137:3 8838:3|11205",	-- Enchant Gloves - Advanced Herbalism
	[-13887] = "D225|11174:2 11137:3",	-- Enchant Gloves - Strength
	[-13917] = "D230|11175 11174:2",	-- Enchant Chest - Superior Mana
	[-13905] = "D230|11175 11176:2",	-- Enchant Shield - Greater Spirit
	[-13915] = "D230|11177 11176:2 9224|11208",	-- Enchant Weapon - Demonslaying
	[-13935] = "D235|11175:2",	-- Enchant Boots - Agility
	[-13931] = "D235|11175 11176:2|11223",	-- Enchant Bracer - Deflection
	[-13933] = "D235|11178 3829|11224",	-- Enchant Shield - Frost Resistance
	[-13937] = "D240|11178:2 11176:2",	-- Enchant 2H Weapon - Greater Impact
	[-13939] = "D240|11176:2 11175",	-- Enchant Bracer - Greater Strength
	[-13945] = "D245|11176:5|11225",	-- Enchant Bracer - Greater Stamina
	[-13941] = "D245|11178 11176:3 11175:2",	-- Enchant Chest - Stats
	[-13943] = "D245|11178:2 11175:2",	-- Enchant Weapon - Greater Striking
	[12810] = "17181|D250|8170 16202",	-- Enchanted Leather
	[12655] = "17180|D250|12359 11176:3",	-- Enchanted Thorium
	[20747] = "25127|D250|11176:3 8831:2 8925|20754||20747",	-- Lesser Mana Oil
	[-13948] = "D250|11178:2 8153:2",	-- Enchant Gloves - Minor Haste
	[-13947] = "D250|11178:2 11176:3|11226",	-- Enchant Gloves - Riding Skill
	[-20008] = "D255|16202:3|16214",	-- Enchant Bracer - Greater Intellect
	[-20020] = "D260|11176:10|16215",	-- Enchant Boots - Greater Stamina
	[11811] = "15596|D265|11382 7078 14343:3|11813",	-- Smoking Heart of the Mountain
	[-20014] = "D265|16202:2 7077 7075 7079 7081 7972|16216",	-- Enchant Cloak - Greater Resistance
	[-20017] = "D265|11176:10|16217",	-- Enchant Shield - Greater Stamina
	[-13898] = "D265|11177:4 7078|11207",	-- Enchant Weapon - Fiery Weapon
	[-20009] = "D270|16202:3 11176:10|16218",	-- Enchant Bracer - Superior Spirit
	[-20012] = "D270|16202:3 16204:3|16219",	-- Enchant Gloves - Greater Agility
	[20750] = "25128|D275|16204:3 4625:2 8925|20755||20750",	-- Wizard Oil
	[-20024] = "D275|16203:2 16202|16220",	-- Enchant Boots - Spirit
	[-20026] = "D275|16204:6 14343|16221",	-- Enchant Chest - Major Health
	[-20016] = "D280|16203:2 16204:4|16222",	-- Enchant Shield - Superior Spirit
	[-20015] = "D285|16204:8|16224",	-- Enchant Cloak - Superior Defense
	[-20029] = "D285|14343:4 7080 7082 13467|16223",	-- Enchant Weapon - Icy Chill
	[16207] = "20051|D290|16206 13926 16204:10 16203:4 11145 14344:2|16243",	-- Runed Arcanite Rod
	[-27837] = "D290|14344:10 16203:6 16204:14 7082:4|22392",	-- Enchant 2H Weapon - Agility
	[-23801] = "D290|16204:16 16203:4 7080:2|19446",	-- Enchant Bracer - Mana Regeneration
	[-20028] = "D290|16203:3 14343|16242",	-- Enchant Chest - Major Mana
	[-23800] = "D290|14344:6 16203:6 16204:4 7082:2|19445",	-- Enchant Weapon - Agility
	[-23799] = "D290|14344:6 16203:6 16204:4 7076:2|19444",	-- Enchant Weapon - Strength
	[-20030] = "D295|14344:4 16204:10|16247",	-- Enchant 2H Weapon - Superior Impact
	[-20023] = "D295|16203:8|16245",	-- Enchant Boots - Greater Agility
	[-20010] = "D295|16204:6 16203:6|16246",	-- Enchant Bracer - Superior Strength
	[-20013] = "D295|16203:4 16204:4|16244",	-- Enchant Gloves - Greater Strength
	[-20033] = "D295|14344:4 12808:4|16248",	-- Enchant Weapon - Unholy Weapon
	[20748] = "25130|D300|14344:2 8831:3 18256|20757",	-- Brilliant Mana Oil
	[20749] = "25129|D300|14344:2 4625:3 18256|20756",	-- Brilliant Wizard Oil
	[22461] = "32664|D300|25843 16203:4 14344:6 16207",	-- Runed Fel Iron Rod
    [-42613] = "D300|20725|||22448", --Nexus Transformation 
	[-20036] = "D300|16203:12 14344:2|16249",	-- Enchant 2H Weapon - Major Intellect
	[-20035] = "D300|16203:12 14344:2|16255",	-- Enchant 2H Weapon - Major Spirit
	[-34002] = "D300|22445:6",	-- Enchant Bracer - Assault
	[-23802] = "D300|14344:2 16204:20 16203:4 12803:6|19447",	-- Enchant Bracer - Healing Power
	[-20011] = "D300|16204:15|16251",	-- Enchant Bracer - Superior Stamina
	[-20025] = "D300|14344:4 16204:15 16203:10|16253",	-- Enchant Chest - Greater Stats
	[-33991] = "D300|22447:2 22445:2",	-- Enchant Chest - Restore Mana Prime
	[-25086] = "D300|22448:3 22446:3 22452:8|20736",	-- Enchant Cloak - Dodge
	[-25081] = "D300|22448:3 22446:3 7078:4|20732",	-- Enchant Cloak - Greater Fire Resistance
	[-25082] = "D300|22448:2 22446:3 12803:4|20733",	-- Enchant Cloak - Greater Nature Resistance
	[-25083] = "D300|22448:3 22446:3 22794:2|20734",	-- Enchant Cloak - Stealth
	[-25084] = "D300|22448:4 22446:2 22456:8|20735",	-- Enchant Cloak - Subtlety
	[-25078] = "D300|20725:2 14344:10 7078:4|20729",	-- Enchant Gloves - Fire Power
	[-25074] = "D300|20725:3 14344:10 7080:4|20728",	-- Enchant Gloves - Frost Power
	[-25079] = "D300|20725:3 14344:8 12811|20730",	-- Enchant Gloves - Healing Power
	[-25073] = "D300|20725:3 14344:10 12808:6|20727",	-- Enchant Gloves - Shadow Power
	[-25080] = "D300|22448:3 22446:3 22451:2|20731",	-- Enchant Gloves - Superior Agility
	[-25072] = "D300|22448:4 22446:2 21886:8|20726",	-- Enchant Gloves - Threat
	[-20034] = "D300|14344:4 12811:2|16252",	-- Enchant Weapon - Crusader
	[-22750] = "D300|14344:4 16203:8 12803:6 7080:6 12811|18260",	-- Enchant Weapon - Healing Power
	[-20032] = "D300|14344:6 12808:6 12803:6|16254",	-- Enchant Weapon - Lifestealing
	[-23804] = "D300|14344:15 16203:12 16204:20|19449",	-- Enchant Weapon - Mighty Intellect
	[-23803] = "D300|14344:10 16203:8 16204:15|19448",	-- Enchant Weapon - Mighty Spirit
	[-22749] = "D300|14344:4 16203:12 7078:4 7080:4 7082:4 13926:2|18259",	-- Enchant Weapon - Spell Power
	[-20031] = "D300|14344:2 16203:10|16250",	-- Enchant Weapon - Superior Striking
	[-27948] = "D305|22445:6 13446:4 13444:4|22542",	-- Enchant Boots - Vitality
	[-27899] = "D305|22445:6",	-- Enchant Bracer - Brawn
	[-34001] = "D305|22447:3",	-- Enchant Bracer - Major Intellect
	[-33993] = "D305|22447 22445:4",	-- Enchant Gloves - Blasting
	[22521] = "28016|D310|22445:3 22791 18256|22562||22521",	-- Superior Mana Oil
	[-34004] = "D310|22446 22445:4 22451",	-- Enchant Cloak - Greater Agility
	[-27961] = "D310|22445:8",	-- Enchant Cloak - Major Armor
	[-33996] = "D310|22445:8",	-- Enchant Gloves - Assault
	[-27944] = "D310|22445:6 22452:10",	-- Enchant Shield - Tough Shield
	[-27905] = "D315|22445:6 22447:6",	-- Enchant Bracer - Stats
	[-27957] = "D315|22445:8 13446:4 14344:2",	-- Enchant Chest - Exceptional Health
	[-27950] = "D320|22445:12|22543",	-- Enchant Boots - Fortitude
	[-27906] = "D320|22448:2 22445:10|22530",	-- Enchant Bracer - Major Defense
	[-33990] = "D320|22446:2",	-- Enchant Chest - Major Spirit
	[22460] = "28027|D325|22449:4",	-- Prismatic Sphere
	[-27911] = "D325|22446:4 21886:4|24000",	-- Enchant Bracer - Superior Healing
	[-34003] = "D325|22446:2 22445:6 22457:2|28274",	-- Enchant Cloak - Spell Penetration
	[-27945] = "D325|22446:4|22539",	-- Enchant Shield - Intellect
	[-34009] = "D325|22445:15|28282",	-- Enchant Shield - Major Stamina
	[-27962] = "D330|22446:4 21884:4 22451:4 22452:4 21885:4|22548",	-- Enchant Cloak - Major Resistance
    [-44383] = "D330|22449 22447:4", --Enchant Shield Resilience
	[22449] = "28022|D335|22448:3|22565",	-- Large Prismatic Shard
	[-27913] = "D335|22446:8|22532",	-- Enchant Bracer - Restore Mana Prime
    [22448] = "42615|D335|22449|42615|3|22448", --Small Prismatic Shard
	[22522] = "28019|D340|22445:3 22792 18256|22563||22522",	-- Superior Wizard Oil
	[-27951] = "D340|22446:8 22445:8|22544",	-- Enchant Boots - Dexterity
	[-33995] = "D340|22445:12 22446",	-- Enchant Gloves - Major Strength
	[-27946] = "D340|22445:12 22446:4 22452:10|22540",	-- Enchant Shield - Shield Block
	[-27968] = "D340|22449:2 22446:10|22551",	-- Enchant Weapon - Major Intellect
	[-27967] = "D340|22449:2 22446:6 22445:6|22552",	-- Enchant Weapon - Major Striking
	[-27960] = "D345|22449:4 22445:4 22446:4|24003",	-- Enchant Chest - Exceptional Stats
	[-33992] = "D345|22446:4 22445:10|28270",	-- Enchant Chest - Major Resilience
	[22459] = "28028|D350|22450:2",	-- Void Sphere
	[22462] = "32665|D350|25844 22446:8 22449:8 23571 22461|25848",	-- Runed Adamantite Rod
	[-27971] = "D350|22449:4 22445:40|22554",	-- Enchant 2H Weapon - Savagery
	[-27914] = "D350|22449 22446:10 22445:20|22533",	-- Enchant Bracer - Fortitude
	[-34005] = "D350|22449:4 22457:8|28276",	-- Enchant Cloak - Greater Arcane Resistance
	[-34006] = "D350|22449:4 22456:8|28277",	-- Enchant Cloak - Greater Shadow Resistance
	[-33999] = "D350|22446:6 22449:6 21886:6|28273",	-- Enchant Gloves - Major Healing
	[-34010] = "D350|22449:8 21885:8 21886:8|28281",	-- Enchant Weapon - Major Healing
	[-27975] = "D350|22449:8 22446:8|22555",	-- Enchant Weapon - Major Spellpower
	[-27972] = "D350|22449:4 22446:5 22445:20|22553",	-- Enchant Weapon - Potency
   	[-42620] = "D350|22445:8 22446:4 22449:8 22451:2|33165",	-- Enchant Weapon - Greater Agility
	[-27977] = "D360|22449:8 22446:6 22445:20|22556",	-- Enchant 2H Weapon - Major Agility
	[-34008] = "D360|22449:8 22452:8|28280",	-- Enchant Boots - Boar's Speed
	[-34007] = "D360|22449:8 22451:8|28279",	-- Enchant Boots - Cat's Swiftness
	[-27917] = "D360|22449:6 21884:6 21885:6|22534",	-- Enchant Bracer - Spellpower
	[-33997] = "D360|22446:6 22449:6 22457:6|28272",	-- Enchant Gloves - Major Spellpower
	[-33994] = "D360|22446:8 22445:2 22449:2|28271",	-- Enchant Gloves - Spell Strike
	[-27924] = "D360|22449:2 22446:2|22536",	-- Enchant Ring - Spellpower
	[-27920] = "D360|22449:2 22445:6|22535",	-- Enchant Ring - Striking
	[-27947] = "D360|22449:6 22452:3 21884:3 22451:3 21885:3|22541",	-- Enchant Shield - Resistance
	[-28004] = "D360|22450:8 22449:8 21885:2|22557",	-- Enchant Weapon - Battlemaster
	[-28003] = "D360|22449:12 22446:10 22445:20|22558",	-- Enchant Weapon - Spellsurge
	[-27954] = "D370|22450:2 22449:4 23572|22545",	-- Enchant Boots - Surefooted
	[-27926] = "D370|22449:2 22446:3 22445:5|22537",	-- Enchant Ring - Healing Power
	[22463] = "32667|D375|25845 22446:12 22450:2 23571:4 22462|25849",	-- Runed Eternium Rod
	[-27927] = "D375|22450:2 22449:2|22538",	-- Enchant Ring - Stats
	[-27984] = "D375|22450:6 22449:10 22446:8 22445:40|22559",	-- Enchant Weapon - Mongoose
	[-27982] = "D375|22450:12 22449:10 22446:8 21885:6 22456:6|22561",	-- Enchant Weapon - Soulfrost
	[-27981] = "D375|22450:12 22449:10 22446:8 21884:6 23571:1|22560",	-- Enchant Weapon - Sunfire
    [-42974] = "D375|22450:6 22449:10 22446:6 22445:30 22824:3|33307", --Enchant Weapon: Executioner
--	[-27958] = "D375|22449 13444:4 22446:3",	-- Enchant Chest - Exceptional Mana
--[[ Engineering --]]
	[8067] = "3920|E1|4357 2840||200",	-- Crafted Light Shot
	[4357] = "3918|E1|2835",	-- Rough Blasting Powder
	[4358] = "3919|E1|4357:2 2589||2",	-- Rough Dynamite
	[4359] = "3922|E30|2840",	-- Handful of Copper Bolts
	[4360] = "3923|E30|2840 4359 4357:2 2589||2",	-- Rough Copper Bomb
	[4362] = "3925|E50|4361 4359 4399",	-- Rough Boomstick
	[6219] = "7430|E50|2840:6",	-- Arclight Spanner
	[4361] = "3924|E50|2840:2 2880",	-- Copper Tube
	[4405] = "3977|E60|4361 774 4359",	-- Crude Scope
	[4363] = "3926|E65|4359:2 2840 2589:2",	-- Copper Modulator
	[4364] = "3929|E75|2836",	-- Coarse Blasting Powder
	[4365] = "3931|E75|4364:3 2589||2",	-- Coarse Dynamite
	[8068] = "3930|E75|4364 2840||200",	-- Crafted Heavy Shot
	[4401] = "3928|E75|4363 4359 2840 774:2|4408||4401",	-- Mechanical Squirrel
	[4366] = "3932|E85|4363 4359:2 2841 2592",	-- Target Dummy
	[4404] = "3973|E90|2842||5",	-- Silver Contact
	[4368] = "3934|E100|2318:6 818:2",	-- Flying Tiger Goggles
	[6714] = "8339|E100|4364:4 2592|6716|2",	-- EZ-Thro Dynamite
	[6712] = "8334|E100|2841 4359:2 2880",	-- Practice Lock
	[4367] = "3933|E100|4364:2 4363 2318 159|4409",	-- Small Seaforium Charge
	[4369] = "3936|E105|4361:2 4359:4 4399 2319:2",	-- Deadly Blunderbuss
	[4371] = "3938|E105|2841:2 2880",	-- Bronze Tube
	[4370] = "3937|E105|2840:3 4364:4 4404||3",	-- Large Copper Bomb
	[4406] = "3978|E110|4371 1206",	-- Standard Scope
	[4372] = "3939|E115|4371:2 4359:2 4400 1206:3|13309",	-- Lovingly Crafted Boomstick
	[4373] = "3940|E120|2319:4 1210:2|4410",	-- Shadow Goggles
	[4374] = "3941|E120|4364:4 2841:2 4404 2592||2",	-- Small Bronze Bomb
	[7506] = "9269|E125|2841:6 4375 814:2 818 774|7560",	-- Gnomish Universal Remote
	[8069] = "3947|E125|4377 2841||200",	-- Crafted Solid Shot
	[4376] = "3944|E125|4375 4402|4411",	-- Flame Deflector
	[4377] = "3945|E125|2838",	-- Heavy Blasting Powder
	[4378] = "3946|E125|4377:2 2592||3",	-- Heavy Dynamite
	[21558] = "26416|E125|4364 2319|21724|3",	-- Small Blue Rocket
	[21559] = "26417|E125|4364 2319|21725|3",	-- Small Green Rocket
	[21557] = "26418|E125|4364 2319|21726|3",	-- Small Red Rocket
	[4375] = "3942|E125|2841:2 2592",	-- Whirring Bronze Gizmo
	[4379] = "3949|E130|4371:2 4375:2 4400 2842:3",	-- Silver-plated Shotgun
	[4381] = "3952|E135|4371 4375:2 2319:2 1206|14639",	-- Minor Recombobulator
	[5507] = "6458|E135|4371:2 4375:2 4363 1206",	-- Ornate Spyglass
	[4380] = "3950|E140|4377:2 2841:3 4404||3",	-- Big Bronze Bomb
	[4383] = "3954|E145|4371:3 4375:3 4400 1705:2|4412",	-- Moonsight Rifle
	[4382] = "3953|E145|2841:2 2319 2592",	-- Bronze Framework
	[4386] = "3957|E145|4375 3829|13308",	-- Ice Deflector
	[4385] = "3956|E150|2319:4 1206:2 4368",	-- Green Tinted Goggles
	[6533] = "9271|E150|2841:2 6530 4364||3",	-- Aquadynamic Fish Attractor
	[9312] = "23067|E150|4377 4234|18649|3",	-- Blue Firework
	[4388] = "3959|E150|4375:3 4306:2 1529 4371|4413",	-- Discombobulator Ray
	[4384] = "3955|E150|4382 4375 4377:2 2592:2",	-- Explosive Sheep
	[10558] = "12584|E150|3577||3",	-- Gold Power Core
	[9313] = "23068|E150|4377 4234|18648|3",	-- Green Firework
	[9318] = "23066|E150|4377 4234|18647|3",	-- Red Firework
	[4387] = "3958|E160|3575:2",	-- Iron Strut
	[7148] = "9273|E165|3575:6 4375:2 814:2 4306:2 1210:2 7191|7561",	-- Goblin Jumper Cables
	[4403] = "3960|E165|4371:4 4387 4377:4 2319:4|4414",	-- Portable Bronze Mortar
	[4407] = "3979|E170|4371 1529 3864|13310",	-- Accurate Scope
	[4389] = "3961|E170|3575 10558",	-- Gyrochronatom
	[10499] = "12587|E175|4234:6 3864:2|10601",	-- Bright-Eye Goggles
	[4391] = "3963|E175|4387:2 4382 4389:2 4234:4",	-- Compact Harvest Reaper Kit
	[10498] = "12590|E175|3859:4",	-- Gyromatic Micro-Adjustor
	[4390] = "3962|E175|3575 4377 4306||3",	-- Iron Grenade
	[21589] = "26420|E175|4377 4234|21727|3",	-- Large Blue Rocket
	[21590] = "26421|E175|4377 4234|21728|3",	-- Large Green Rocket
	[21592] = "26422|E175|4377 4234|21729|3",	-- Large Red Rocket
	[10505] = "12585|E175|7912:2",	-- Solid Blasting Powder
	[10507] = "12586|E175|10505 4306||2",	-- Solid Dynamite
	[4393] = "3966|E185|4234:6 3864:2|4415",	-- Craftsman's Monocle
	[4392] = "3965|E185|4387 4382 4389 4234:4",	-- Advanced Target Dummy
	[4852] = "8243|E185|4611 4377 4306|6672",	-- Flash Bomb
	[4394] = "3967|E190|3575:3 4377:3 4404||2",	-- Big Iron Bomb
	[4397] = "3971|E190|4389:4 1529:2 1705:2 3864:2 7191|7742",	-- Gnomish Cloaking Device
	[4396] = "3969|E190|4382 4387:4 4389:4 3864:2 7191|13311",	-- Mechanical Dragonling
	[17716] = "21940|E190|3860:8 4389:4 17202:4 3829|17720",	-- SnowMaster 9000
	[4395] = "3968|E195|4377:3 3575:2 4389|4416",	-- Goblin Land Mine
	[10559] = "12589|E195|3860:3",	-- Mithril Tube
	[18588] = "23069|E200|10505 4338:2|18650",	-- EZ-Thro Dynamite II
	[4398] = "3972|E200|10505:2 4234:2 159|4417",	-- Large Seaforium Charge
	[11590] = "15255|E200|3860 4338 10505",	-- Mechanical Repair Kit
	[10560] = "12591|E200|3860 4338 10505",	-- Unstable Trigger
	[10500] = "12594|E205|4385 3864:2 7068:2 4234:4",	-- Fire Goggles
	[10508] = "12595|E205|10559 10560 4400 3860:4 7068:2",	-- Mithril Blunderbuss
	[10512] = "12596|E210|3860 10505||200",	-- Hi-Impact Mithril Slugs
	[10546] = "12597|E210|10559 7909:2 4304:2|10602",	-- Deadly Scope
	[10721] = "12903|Eg215|7387 3860:4 6037:2 10560 7909:2",	-- Gnomish Harm Prevention Belt
	[10561] = "12599|E215|3860:3",	-- Mithril Casing
	[10514] = "12603|E215|10561 10560 10505||3",	-- Mithril Frag Bomb
	[10501] = "12607|E220|4304:4 7909:2 10592|10603",	-- Catseye Ultra Goggles
	[10510] = "12614|E220|10559:2 10560 4400 3860:6 3864:2|10604",	-- Mithril Heavy-bore Rifle
	[10518] = "12616|E225|4339:4 10285:2 10560 10505:4|10606",	-- Parachute Cloak
	[10502] = "12615|E225|4304:4 7910:2|10605",	-- Spellpower Goggles Xtreme
	[21571] = "26423|E225|10505 4304|21730|3",	-- Blue Rocket Cluster
	[21569] = "26442|E225|9060 9061 10560 10561|21738",	-- Firework Launcher
	[21574] = "26424|E225|10505 4304|21731|3",	-- Green Rocket Cluster
	[21576] = "26425|E225|10505 4304|21732|3",	-- Red Rocket Cluster
	[10506] = "12617|E230|3860:8 10561 6037 818:4 774:4|10607",	-- Deepdive Helmet
	[10503] = "12618|E230|4304:6 7910:2",	-- Rose Colored Goggles
	[10562] = "12619|E235|10561:2 10560 10505:2||4",	-- Hi-Explosive Bomb
	[10548] = "12620|E240|10559 7910 6037:2|10608",	-- Sniper Scope
	[10504] = "12622|E245|4304:8 1529:3 7909:3 10286:2 8153:2",	-- Green Lens
	[10513] = "12621|E245|3860:2 10505:2||200",	-- Mithril Gyro-Shot
	[15992] = "19788|E250|12365:2",	-- Dense Blasting Powder
	[18641] = "23070|E250|15992:2 14047:3||2",	-- Dense Dynamite
	[10576] = "12624|E250|3860:14 7077:4 6037:4 9060:2 9061:2 7910:2|10609",	-- Mithril Mechanical Dragonling
	[15846] = "19567|E250|10561 12359:6 10558 10560:4",	-- Salt Shaker
	[19026] = "23507|E250|15992:2 14047:2 8150|19027|4",	-- Snake Burst Firework
	[21277] = "26011|E250|15407 15994:4 7079:2 18631:2 10558",	-- Tranquil Mechanical Yeti
	[18634] = "23077|E260|15994:6 18631:2 12361:2 7078:4 3829:2 13467:4|18652",	-- Gyrofreeze Ice Reflector
	[15995] = "19792|E260|10559:2 10561:2 15994:2 12359:4 10546|16043",	-- Thorium Rifle
	[15993] = "19790|E260|15994 12359:3 15992:3 14047:3|16041|3",	-- Thorium Grenade
	[15994] = "19791|E260|12359:3 14047|16042",	-- Thorium Widget
	[18631] = "23071|E260|6037:2 7067:2 7069|18651",	-- Truesilver Transformer
	[15996] = "19793|E265|12803 15994:4 10558 8170|16044",	-- Lifelike Mechanical Toad
	[15999] = "19794|E270|10502 7910:4 12810:2 14047:8|16045",	-- Spellpower Goggles Xtreme Plus
	[16004] = "19796|E275|16000:2 11371:6 10546:2 12361:2 12799:2 8170:4|16048",	-- Dark Iron Rifle
	[18637] = "23079|E275|16000:2 18631 14047:2|18655",	-- Major Recombobulator
	[34] = "26443|E275|9060:4 9061:4 18631:2 10561|21737||21570",	-- Firework Cluster Launcher
	[7191] = "39895|E275|20816:3 7078:2|32381||7191",	-- Fused Wiring
	[21714] = "26426|E275|15992 8170|21733|3",	-- Large Blue Rocket Cluster
	[21716] = "26427|E275|15992 8170|21734|3",	-- Large Green Rocket Cluster
	[21718] = "26428|E275|15992 8170|21735|3",	-- Large Red Rocket Cluster
	[16023] = "19814|E275|10561 16000 15994:2 6037 8170:2 14047:4|16046",	-- Masterwork Target Dummy
	[18594] = "23080|E275|15994:2 15992:3 8170:2 159|18656",	-- Powerful Seaforium Charge
	[16000] = "19795|E275|12359:6|16047",	-- Thorium Tube
	[15997] = "19800|E285|12359:2 15992|16051|200",	-- Thorium Shells
	[16005] = "19799|E285|15994:2 11371 15992:3 14047:3|16049|3",	-- Dark Iron Bomb
	[16006] = "19815|E285|12360 14227|16050",	-- Delicate Arcanite Converter
	[18638] = "23081|E290|11371:4 18631:3 7080:6 7910:4 12800:2|18657",	-- Hyper-Radiant Flame Reflector
	[16008] = "19825|E290|10500 12364:2 12810:4|16053",	-- Master Engineer's Goggles
	[16009] = "19819|E290|16006:2 10558 15994 12799|16052",	-- Voice Amplification Modulator
	[18282] = "22795|E300|17010:4 17011:2 12360:6 16006:2 16000:2|18292",	-- Core Marksman Rifle
	[18168] = "22797|E300|12360:6 16006:2 7082:8 12803:12 7076:8|18291",	-- Force Reactive Disk
	[16022] = "19830|E300|10576 16006:8 12655:10 15994:6 10558:4 12810:6|16054",	-- Arcanite Dragonling
	[18283] = "22793|E300|17011:2 7076:2 16006:4 11371:6 16000|18290",	-- Biznicks 247x128 Accurascope
	[19999] = "24356|E300|19726:4 19774:5 16006:2 12804:8 12810:4|20000",	-- Bloodvine Goggles
	[19998] = "24357|E300|19726:5 19774:5 16006 12804:8 12810:4|20001",	-- Bloodvine Lens
	[16007] = "19833|E300|12360:10 16000:2 7078:2 7076:2 12800:2 12810:2|16056",	-- Flawless Arcanite Rifle
	[18639] = "23082|E300|11371:8 18631:4 12803:6 12808:4 12800:2 12799:2|18658",	-- Ultra-Flash Shadow Reflector
	[16040] = "19831|E300|16006 12359:3 14047|16055|3",	-- Arcane Bomb
	[23781] = "30303|E300|22574 22573:2||4",	-- Elemental Blasting Powder
	[23736] = "30310|E300|23782 23783:2 23781||4",	-- Fel Iron Bomb
	[23782] = "30304|E300|23445:3",	-- Fel Iron Casing
	[18232] = "22704|E300|12359:12 7191:2",	-- Field Repair Bot 74A (New Mats in 2.3)
	[23783] = "30305|E300|23445",	-- Handful of Fel Iron Bolts
	[23821] = "30548|E305|23782:2 23783:2 21886:4 16006|23888",	-- Zapthrottle Mote Extractor
	[23772] = "30346|E310|23445:2 23781||200",	-- Fel Iron Shells
	[23742] = "30312|E320|4400 23782:3 23783:8",	-- Fel Iron Musket
	[23774] = "30348|E325|23782 23445:5 23783:2|23816",	-- Fel Iron Toolbox
	[23784] = "30306|E325|23446:4 22452",	-- Adamantite Frame
	[23737] = "30311|E325|23446:4 23783:2 23781||3",	-- Adamantite Grenade
	[23767] = "30337|E325|23784 23782:2 10558 23783:2|23810",	-- Crashin' Thrashin' Robot
    [33092] = "30551|E330|23782 23783 21887:2 22829:20|23883", -- Healing Potion Injector, added after r45586 -- also 35310
    [33093] = "30552|E330|23782 23783 21887:2 22832:20|23884", -- Mana Potion Injector, added after r45586 -- also 35311
	[34504] = "30347|E335|23446 23781:2 4470:4|23815",	-- Adamantite Shell Machine (Changed in 2.3)
	[23764] = "30329|E335|23446:8 23112:2|23807",	-- Adamantite Scope
	[23771] = "30344|E335|23781 21877 2605|23814|3",	-- Green Smoke Flare
	[32423] = "39971|E335|21885 23781:2 21877:2||10",	-- Icy Blasting Primers
	[25886] = "32814|E335|23781 21877 4342|25887|3",	-- Purple Smoke Flare
	[23768] = "30341|E335|23781 21877|23811|3",	-- White Smoke Flare
    [20475] = "43676|E335|23446 4470 23783|33804", -- Adamantite Arrow Maker
	[23758] = "30316|E340|23793:4 23077:2 22445:8|23803",	-- Cogspinner Goggles
	[23761] = "30317|E340|23793:4 21929:2 22445:8|23804",	-- Power Amplification Goggles
	[32478] = "41317|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Deathblow X11 Goggles
	[32494] = "41320|E350|23793:6 23786 23785:2 23787:4 23572 23438:2",	-- Destruction Holo-gogs
	[32461] = "40274|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Furious Gizmatic Goggles
	[32476] = "41315|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Gadgetstorm Goggles
	[32472] = "41311|E350|23793:6 23786 23785:2 23787:4 23572 23440:2",	-- Justicebringer 2000 Specs
	[32475] = "41316|E350|23793:6 23786 23785:2 23787:4 23572 23439:2",	-- Living Replicator Specs
	[32480] = "41319|E350|23793:6 23786 23785:2 23787:4 23572 23437:2",	-- Magnified Moon Specs
	[32495] = "41321|E350|23793:6 23786 23785:2 23787:4 23572 23439:2",	-- Powerheal 4000 Lens
	[32474] = "41314|E350|23793:6 23786 23785:2 23787:4 23572 23441:2",	-- Surestrike Goggles v2.0
	[32473] = "41312|E350|23793:6 23786 23785:2 23787:4 23572 23437:2",	-- Tankatronic Goggles
	[32479] = "41318|E350|23793:6 23786 23785:2 23787:4 23572 23440:2",	-- Wonderheal XT40 Shades
	[23762] = "30318|E350|23793:4 23449:2 23079:2 22448:2|23805",	-- Ultra-Spectropic Detection Goggles
	[23746] = "30313|E350|16000:2 23784:2 23783:4|23799",	-- Adamantite Rifle
	[23819] = "30547|E350|23781:2 23782 23783|23874|2",	-- Elemental Seaforium Charge
	[23787] = "30309|E350|23448:2",	-- Felsteel Stabilizer
	[23785] = "30307|E350|23573:3",	-- Hardened Adamantite Tube
	[23786] = "30308|E350|23449:3 21884",	-- Khorium Power Core
    [34060] = "44155|E350|23784:2 23445:30 23783:8 11291:8 23446:5 23819:4", -- Flying Machine Control
	[23824] = "30556|E355|23793:8 23786:2 23785:2 23787:4|23887",	-- Rocket Boots Xtreme
	[23747] = "30314|E360|23785 23787:4 23783:4|23800",	-- Felsteel Boomstick
	[23763] = "30325|E360|23793:4 23449:2 23441:2 22449:2|23806",	-- Hyper-Vision Goggles
	[23765] = "30332|E360|23785 23449:4 23440:2|23808",	-- Khorium Scope
    [34113] = "44391|E360|23446:8 23783:8 23786|34114|5", -- Field Repair Bot110g
	[32756] = "41307|E375|23785 23449:20 23787:4 21884:12 22451:12 23572",	-- Gyro-balanced Khorium Destroyer
	[23748] = "30315|E375|23785:2 23449:12 23783:4 23439:2|23802",	-- Ornate Khorium Rifle
	[23766] = "30334|E375|23785:2 23787:6 23438:2|23809",	-- Stabilized Eternium Scope
	--[23820] = "30549|E375|23784 23783:2 10558",	-- Critter Enlarger [currently not in game since TBC beta] 2.1.2
	[35] = "39973|E375|32423 23782 23783||5|32413",	-- Frost Grenades
	--[23769] = "30342|E375|23781 21877 2604||3",	-- Red Smoke Flare [currently only available at vendor] 2.1.2
--[[ Gnomish Engineering --]]
	[10716] = "12899|Eg205|10559 10560 3860:4 8151:4 1529:2",	-- Gnomish Shrink Ray
	[36] = "12895|Eg205|10648 10647|||10713",	-- Inlaid Mithril Cylinder Plans
	[11826] = "15633|Eg205|7075 4389:2 7191 3860:2 6037|11827",	-- Lil' Smoky
	[10545] = "12897|Eg210|10500 10559 10558:2 8151:2 4234:2",	-- Gnomish Goggles
	[10720] = "12902|Eg210|10559 10285:2 4337:4 10505:2 3860:4",	-- Gnomish Net-o-Matic Projector
	[10724] = "12905|Eg225|10026 10559:2 4234:4 10505:8 4389:4",	-- Gnomish Rocket Boots
	[10725] = "12906|Eg230|10561 6037:6 3860:6 9060:2 10558 1529:2",	-- Gnomish Battle Chicken
	[10726] = "12907|Eg235|3860:10 6037:4 10558 7910:2 4338:4",	-- Gnomish Mind Control Cap
	[10645] = "12759|Eg240|10559:2 10560 12808 7972:4 9060",	-- Gnomish Death Ray
	[37] = "23489|Eg260|3860:12 18631:2 7075:4 7079:2 7909:4 9060|||18986",	-- Ultrasafe Transporter - Gadgetzan
	[18660] = "23129|Eg260|10561 15994:2 10558 10560 3864|18661",	-- World Enlarger
	[38] = "23096|Eg265|12359:4 15994:2 8170:4 7910 7191|18654||18645",	-- Alarm-O-Bot
	[23841] = "30568|Eg325|23784 23783:2 21884 23782||3",	-- Gnomish Flame Turret
	[23835] = "30569|Eg340|23785:2 23786:2 22445:10 22449:2",	-- Gnomish Poultryizer
	[39] = "30570|Eg350|23793:8 23786:4 21886:10 22456:10 16006:2|||23825",	-- Nigh-Invulnerability Belt
	[40] = "36955|Eg350|23784 22451:2 23787:2 23783:4 23786|||30544",	-- Ultrasafe Transporter - Toshley's Station
	[23829] = "30575|Eg375|23793:8 22456:12 22452:12 21884:12 23436:2",	-- Gnomish Battle Goggles
	[23828] = "30574|Eg375|24271:4 21884:8 22451:8 22452:8 21885:8 23437:2",	-- Gnomish Power Goggles
--[[ Goblin Engineering --]]
	[10543] = "12718|Eb205|3860:8 3864 7068:4",	-- Goblin Construction Helmet
	[10542] = "12717|Eb205|3860:8 3864 7067:4",	-- Goblin Mining Helmet
	[41] = "12715|Eb205|10648 10647|||10644",	-- Goblin Rocket Fuel Recipe
	[10646] = "12760|Eb205|4338 10505:3 10560",	-- Goblin Sapper Charge
	[11825] = "15628|Eb205|4394 7077 7191 3860:6|11828",	-- Pet Bombling
	[42] = "12716|Eb205|10559:2 3860:4 10505:5 10558 7068|||10577",	-- Goblin Mortar
	[43] = "13240|Eb205|10577 3860 10505:3|||10577",	-- The Mortar: Reloaded
	[7189] = "8895|Eb225|10026 10559:2 4234:4 9061:2 10560",	-- Goblin Rocket Boots
	[10587] = "12755|Eb230|10561:2 10505:4 6037:6 10560 4407:2",	-- Goblin Bomb Dispenser
	[10586] = "12754|Eb235|10561 9061 10507:6 10560||2",	-- The Big One
	[10727] = "12908|Eb240|10559:2 9061:4 3860:6 6037:6 10560",	-- Goblin Dragon Gun
	[10588] = "12758|Eb245|10543 9061:4 3860:4 10560",	-- Goblin Rocket Helmet
	[18984] = "23486|Eb260|3860:10 18631 7077:4 7910:2 10586",	-- Dimensional Ripper - Everlook
	[18587] = "23078|Eb265|15994:2 18631:2 7191:2 14227:2 7910:2|18653",	-- Goblin Jumper Cables XL
	[23826] = "30558|Eb325|23782:3 23781:6 17020:3 23783:2||3",	-- The Bigger One
	[23827] = "30560|Eb340|21877:4 23781:4 22457||2",	-- Super Sapper Charge
	[23836] = "30563|Eb350|23785:2 23786 23787:2 21884:6 22452:6 16006:2",	-- Goblin Rocket Launcher
	[30542] = "36954|Eb350|23784 21884:2 23826:2 23783:4 23786",	-- Dimensional Ripper - Area 52
	[23838] = "30565|Eb375|24272:4 22457:12 22451:12",	-- Foreman's Enchanted Helmet
	[23839] = "30566|Eb375|23573:8 22452:12 21884:12",	-- Foreman's Reinforced Helmet
--[[ First Aid --]]
	[1251] = "3275|X1|2589",	-- Linen Bandage
	[2581] = "3276|X40|2589:2",	-- Heavy Linen Bandage
	[6452] = "7934|X80|1475||3",	-- Anti-Venom
	[3530] = "3277|X80|2592",	-- Wool Bandage
	[3531] = "3278|X115|2592:2",	-- Heavy Wool Bandage
	[6453] = "7935|X130|1288|6454|3",	-- Strong Anti-Venom
	[6450] = "7928|X150|4306",	-- Silk Bandage
	[6451] = "7929|X180|4306:2|16112",	-- Heavy Silk Bandage
	[8544] = "10840|X210|4338|16113",	-- Mageweave Bandage
	[8545] = "10841|X240|4338:2",	-- Heavy Mageweave Bandage
	[14529] = "18629|X260|14047",	-- Runecloth Bandage
	[14530] = "18630|X290|14047:2",	-- Heavy Runecloth Bandage
	[19440] = "23787|X300|19441|19442",	-- Powerful Anti-Venom
	[21990] = "27032|X330|21877|21992",	-- Netherweave Bandage
	[21991] = "27033|X360|21877:2|21993",	-- Heavy Netherweave Bandage
--[[ Jewelcrafting --]]
	[20906] = "25493|J1|20816:2",	-- Braided Copper Ring
	[21931] = "26925|J1|20816:2 2840",	-- Woven Copper Ring
	[20816] = "25255|J1|2840:2",	-- Delicate Copper Wire
	[25498] = "32259|J1|2835:8",	-- Rough Stone Statue
	[21932] = "26926|J5|2840:4 20816:2",	-- Heavy Copper Ring
	[25438] = "32178|J20|774 20816",	-- Malachite Pendant
	[25439] = "32179|J20|818 20816",	-- Tigerseye Band
	[20821] = "25283|J30|774:2 2840:2",	-- Inlaid Malachite Ring
	[21934] = "26928|J30|818:2 2840:2 20816",	-- Ornate Tigerseye Necklace
	[20818] = "25280|J50|2842",	-- Elegant Silver Ring
	[20907] = "25490|J50|2841:4",	-- Solid Bronze Ring
	[21933] = "26927|J50|2841:2 1210 20816",	-- Thick Bronze Necklace
	[20817] = "25278|J50|2841:2",	-- Bronze Setting
	[25880] = "32801|J50|2836:8",	-- Coarse Stone Statue
	[20820] = "25284|J60|5498 20817 2840:2",	-- Simple Pearl Ring
	[30804] = "37818|J65|2841:2 20817 774:3 818:3 1210:2",	-- Bronze Band of Force
	[20823] = "25287|J70|1210:2 20817 20816:2",	-- Gloom Band
	[30419] = "36523|J75|2841:4 20817 1206",	-- Brilliant Necklace
	[31154] = "38175|J80|2841:6 20817 1705",	-- Bronze Torc
	[20827] = "25317|J80|2842:2",	-- Ring of Silver Might
	[20826] = "25305|J90|2842:2 20817 1206 1705",	-- Heavy Silver Ring
	[20828] = "25318|J100|1210:2 2841:2",	-- Ring of Twilight Shadows
	[30420] = "36524|J105|1529 20817 3575:2",	-- Heavy Jade Ring
	[20830] = "25339|J110|1705:2 20817|20854",	-- Amulet of the Moon
	[20909] = "25498|J110|3575:8 5637:2 20817:2",	-- Barbaric Iron Collar
	[25881] = "32807|J110|2838:8",	-- Heavy Stone Statue
	[20832] = "25321|J120|1705:3 5498:3 11083:4 2842:4 3827:2",	-- Moonsoul Crown
	[20950] = "25610|J120|1206 20817|20970",	-- Pendant of the Agate Shield
	[20954] = "25612|J125|3575:8 3391:2|20971",	-- Heavy Iron Knuckles
	[20833] = "25323|J125|1705 3824 3575:4|20855",	-- Wicked Moonstone Ring
	[20955] = "25613|J135|1529 3577:2 20816:2",	-- Golden Dragon Ring
	[20958] = "25617|J150|3864 20963|20973",	-- Blazing Citrine Ring
	[20831] = "25320|J150|3577 1206:2 3391|20856",	-- Heavy Golden Necklace of Battle
	[20963] = "25615|J150|3860:2",	-- Mithril Filigree
	[20966] = "25618|J160|1529 20963:2|20974",	-- Jade Pendant of Blasting
	[20960] = "25620|J170|6037 20963:2",	-- Engraved Truesilver Ring
	[20959] = "25619|J170|1529 7067:2|20975",	-- The Jade Eye
	[25882] = "32808|J175|7912:10",	-- Solid Stone Statue
	[29157] = "34955|J180|3577:4 1705 1529 3864",	-- Golden Ring of Power
	[20961] = "25621|J180|3864 7070:2 3860:2",	-- Citrine Ring of Rapid Healing
	[20967] = "25622|J190|3864 7070:2 3577:2 20817|20976",	-- Citrine Pendant of Golden Healing
	[29158] = "34959|J200|6037:3 7910:2 3864:2",	-- Truesilver Commander's Ring
	[21756] = "26873|J200|3577:6 3864:2|21940",	-- Figurine - Golden Hare
	[21748] = "26872|J200|1529:4 6037:2 11137:4 20963:4",	-- Figurine - Jade Owl
	[20964] = "26874|J210|7909:3 8151:4",	-- Aquamarine Signet
	[21758] = "26875|J215|7971:4 8151:4|21941",	-- Figurine - Black Pearl Panther
	[21755] = "26876|J220|7909 20963:3",	-- Aquamarine Pendant of the Warrior
	[20969] = "26878|J225|7910:2 7971:2 6037:4 21752:4 6149:4|21942",	-- Ruby Crown of Restoration
	[21760] = "26881|J225|7909:2 6037:4 7075:2 7079:2 8151:4|21943",	-- Figurine - Truesilver Crab
	[25883] = "32809|J225|12365:10",	-- Dense Stone Statue
	[21752] = "26880|J225|12359",	-- Thorium Setting
	[30421] = "36525|J230|7910 21752",	-- Red Ring of Destruction
	[21763] = "26882|J235|7910:2 6037:4 7077:2 7081:2 8151:4|21944",	-- Figurine - Truesilver Boar
	[21764] = "26883|J235|7910 21752",	-- Ruby Pendant of Fire
	[21765] = "26885|J240|6037:2 10286:2",	-- Truesilver Healing Ring
	[21754] = "26887|J245|7909 21752|21945",	-- The Aquamarine Ward
	[21753] = "26896|J250|7909:2 3864:2 21752:4 6037:2|21947",	-- Gem Studded Band
	[21766] = "26897|J250|12799:2 21752:2 6037:4 11178:2 20963:2|21948",	-- Opal Necklace of Impact
	[21769] = "26900|J260|7910:2 7078:2 8152:4 6037:2|21949",	-- Figurine - Ruby Serpent
	[21767] = "26902|J260|12799 21752",	-- Simple Opal Ring
	[30422] = "36526|J265|12800 21752",	-- Diamond Focus Ring
	[21774] = "26906|J275|12364:2 12799:2 12361:2 12360:2 12359:2|21952",	-- Emerald Crown of Destruction
	[21768] = "26903|J275|12361:4 6037:2 21752",	-- Sapphire Signet
	[29159] = "34960|J280|12800:2 21752",	-- Glowing Thorium Band
	[21775] = "26907|J280|21752 12804 7076",	-- Onslaught Ring
	[21790] = "26908|J280|12361 12808 21752",	-- Sapphire Pendant of Winter Night
	[21777] = "26909|J285|12364:2 12360:2 12359:2 12804:4|21953",	-- Figurine - Emerald Owl
	[21778] = "26910|J285|12363 12808:2 12662|21954",	-- Ring of Bitter Shadows
	[21791] = "26911|J290|12364:2 12803:4 12804:4",	-- Living Emerald Pendant
	[29160] = "34961|J290|12364:2 21752",	-- Emerald Lion Ring
	[21784] = "26912|J300|18335:4 11754:4 12800:2 12360:2 12359:4|21955",	-- Figurine - Black Diamond Crab
	[21789] = "26914|J300|11371:4 12360:2 7910:2|21956",	-- Figurine - Dark Iron Scorpid
	[23113] = "28938|J300|23112|23148",	-- Brilliant Golden Draenite
	[23108] = "28925|J300|23107|23144",	-- Glowing Shadow Draenite
	[23098] = "28910|J300|21929|23135",	-- Inscribed Flame Spessarite
	[23103] = "28916|J300|23079|23140",	-- Radiant Deep Peridot
	[23118] = "28950|J300|23117|23152",	-- Solid Azure Moonstone
	[23094] = "28903|J300|23077|23130",	-- Teardrop Blood Garnet
	[21792] = "26915|J305|12800:2 21752:2 12360:2|21957",	-- Necklace of the Diamond Tower
	[23095] = "28905|J305|23077|23131",	-- Bold Blood Garnet
	[28595] = "34590|J305|23077|28596",	-- Bright Blood Garnet
	[23114] = "28944|J305|23112|23149",	-- Gleaming Golden Draenite
	[23104] = "28917|J305|23079|23141",	-- Jagged Deep Peridot
	[23099] = "28912|J305|21929|23136",	-- Luminous Flame Spessarite
	[23109] = "28927|J305|23107|23145",	-- Royal Shadow Draenite
	[23119] = "28953|J305|23117|23153",	-- Sparkling Azure Moonstone
	[21779] = "26916|J310|21929 7078:4 12803:4",	-- Band of Natural Fire
	[24074] = "31048|J310|23445 23077:2",	-- Fel Iron Blood Ring
	[24075] = "31049|J310|23445 23112:2",	-- Golden Draenite Ring
	[23105] = "28918|J315|23079|23142",	-- Enduring Deep Peridot
	[23100] = "28914|J315|21929|23137",	-- Glinting Flame Spessarite
	[23096] = "28906|J315|23077|23133",	-- Runed Blood Garnet
	[23110] = "28933|J315|23107|23146",	-- Shifting Shadow Draenite
	[23120] = "28955|J315|23117|23154",	-- Stormy Azure Moonstone
	[23115] = "28947|J315|23112|23150",	-- Thick Golden Draenite
	[24076] = "31050|J320|23445 23117:2 23079",	-- Azure Moonstone Ring
	[32772] = "41414|J325|24478:8 23447:2",	-- Brilliant Pearl Band
	[31079] = "38068|J325|24243:4 22452",	-- Mercurial Adamantite
	[23106] = "28924|J325|23079|23143",	-- Dazzling Deep Peridot
	[23097] = "28907|J325|23077|23134",	-- Delicate Blood Garnet
	[23121] = "28957|J325|23117|23155",	-- Lustrous Azure Moonstone
	[23101] = "28915|J325|21929|23138",	-- Potent Flame Spessarite
	[32833] = "41420|J325|24478 27860",	-- Purified Jaggal Pearl
	[23116] = "28948|J325|23112|23151",	-- Rigid Golden Draenite
	[28290] = "34069|J325|23112|28291",	-- Smooth Golden Draenite
	[23111] = "28936|J325|23107|23147",	-- Sovereign Shadow Draenite
	[32774] = "41415|J330|24479 31079:4",	-- The Black Pearl
	[24078] = "31052|J335|23446 31079",	-- Heavy Adamantite Ring
	[24077] = "31051|J335|23446:2 31079",	-- Thick Adamantite Necklace
	[32508] = "40514|J340|22578:3 24478:10 24479",	-- Necklace of the Deep
	[24087] = "31058|J345|23448:2 31079:4|24163",	-- Heavy Felsteel Ring
	[31863] = "39463|J350|23441|31876",	-- Balanced Nightseye, pattern added
	[24027] = "31084|J350|23436|24193",	-- Bold Living Ruby, pattern added
	[24031] = "31089|J350|23436|24192",	-- Bright Living Ruby, pattern added --also 35306
	[24047] = "31096|J350|23440|24203",	-- Brilliant Dawnstone, pattern in
	[24065] = "31112|J350|23437|24219",	-- Dazzling Talasite, pattern in
	[24028] = "31085|J350|23436|24194",	-- Delicate Living Ruby, pattern in
	[24062] = "31110|J350|23437|24217",	-- Enduring Talasite, pattern in
	[24036] = "31091|J350|23436|24198",	-- Flashing Living Ruby, pattern in
	[24050] = "31099|J350|23440|24206",	-- Gleaming Dawnstone, pattern in
	[24061] = "31109|J350|23439|24216",	-- Glinting Noble Topaz, pattern in
	[24056] = "31104|J350|23441|24211",	-- Glowing Nightseye, pattern in
	[31861] = "39452|J350|23440|31875",	-- Great Dawnstone, pattern added
	[31865] = "39462|J350|23441|31877",	-- Infused Nightseye
	[24058] = "31106|J350|23439|24213",	-- Inscribed Noble Topaz, pattern in
	[24067] = "31113|J350|23437|24220",	-- Jagged Talasite, pattern in
	[24079] = "31053|J350|23449:2 31079:3 22456:3|24158",	-- Khorium Band of Shadows, pattern in
	[24060] = "31108|J350|23439|24215",	-- Luminous Noble Topaz, pattern in
	[24037] = "31094|J350|23438|24201",	-- Lustrous Star of Elune, pattern in
	[24053] = "31101|J350|23440|24208",	-- Mystic Dawnstone
	[24059] = "31107|J350|23439|24214",	-- Potent Noble Topaz, pattern in 
	[32836] = "41429|J350|24479 27860",	-- Purified Shadow Pearl
	[24066] = "31111|J350|23437|24218",	-- Radiant Talasite, pattern in 
	[24051] = "31098|J350|23440|24205",	-- Rigid Dawnstone, pattern in -- also 35307
	[24057] = "31105|J350|23441|24212",	-- Royal Nightseye, pattern in 
	[24030] = "31088|J350|23436|24196",	-- Runed Living Ruby, pattern in  --also 35305
	[24055] = "31103|J350|23441|24210",	-- Shifting Nightseye, pattern in 
	[24048] = "31097|J350|23440|24204",	-- Smooth Dawnstone, pattern in
	[24033] = "31092|J350|23438|24199",	-- Solid Star of Elune, pattern in -- also 35304
	[24054] = "31102|J350|23441|24209",	-- Sovereign Nightseye, pattern in
	[24035] = "31149|J350|23438|24200",	-- Sparkling Star of Elune, pattern in
	[24039] = "31095|J350|23438|24202",	-- Stormy Star of Elune, pattern in
	[24032] = "31090|J350|23436|24197",	-- Subtle Living Ruby, pattern in
	[24029] = "31087|J350|23436|24195",	-- Teardrop Living Ruby, pattern in
	[24052] = "31100|J350|23440|24207",	-- Thick Dawnstone, pattern in
	[31867] = "39470|J350|23439|31878",	-- Veiled Noble Topaz
	[31868] = "39471|J350|23439|31879",	-- Wicked Noble Topaz
    [33782] = '43493|J350|23437|33783|1|33782', --Steady Talasite
	[24088] = "31060|J355|23447 31079:5|24164",	-- Delicate Eternium Ring
	[24080] = "31054|J355|23449:2 31079:4 21885:3|24159",	-- Khorium Band of Frost
	[24082] = "31055|J355|23449:2 31079:4 21884:3|24160",	-- Khorium Inferno Band
	[24110] = "31068|J355|23449:4 31079 23436|24167",	-- Living Ruby Pendant
	[24106] = "31067|J355|23448:2 31079:3|24166",	-- Thick Felsteel Necklace
	[24114] = "31070|J360|23447:2 31079:3|24168",	-- Braided Eternium Chain
	[24116] = "31071|J360|23573:2 31079:2 23441|24169",	-- Eye of the Night
	[24085] = "31056|J360|23449:2 31079:4 21886:3|24161",	-- Khorium Band of Leaves
	[24092] = "31062|J360|23448:2 21885:6 21884:4 31079|24174",	-- Pendant of Frozen Flame
	[24097] = "31065|J360|23448:2 21886:6 22456:4 31079|24177",	-- Pendant of Shadow's End
	[24093] = "31063|J360|23448:2 21884:6 21885:4 31079|24175",	-- Pendant of Thawing
	[24098] = "31066|J360|23448:2 22457:8 31079|24178",	-- Pendant of the Null Rune
	[24095] = "31064|J360|23448:2 22456:6 21886:4 31079|24176",	-- Pendant of Withering
	[30825] = "37855|J360|23447:2 22457:8|30826",	-- Ring of Arcane Shielding
	[24086] = "31057|J365|23449:2 31079:4 22457:3|24162",	-- Arcane Khorium Band
	[24089] = "31061|J365|23447:2 31079:4 21884:4|24165",	-- Blazing Eternium Band
	[25897] = "32867|J365|25867|25903",	-- Bracing Earthstorm Diamond
	[25899] = "32869|J365|25867|25906",	-- Brutal Earthstorm Diamond
	[24121] = "31076|J365|23449:2 31079:4 23117:2|24171",	-- Chain of the Twilight Owl
	[32776] = "41418|J365|23449:12 31079:4 24478:20 24479:3",	-- Crown of the Sea Witch
	[25890] = "32871|J365|25868|25907",	-- Destructive Skyfire Diamond
	[24117] = "31072|J365|23447:2 31079:4 23112:2|24170",	-- Embrace of the Dawn
	[25895] = "32874|J365|25868|25910",	-- Enigmatic Skyfire Diamond
	[25901] = "32870|J365|25867|25904",	-- Insightful Earthstorm Diamond
	[25893] = "32872|J365|25868|25909",	-- Mystical Skyfire Diamond
	[25896] = "32866|J365|25867|25902",	-- Powerful Earthstorm Diamond
	[32409] = "39961|J365|25867|32412",	-- Relentless Earthstorm Diamond
	[25894] = "32873|J365|25868|25908",	-- Swift Skyfire Diamond
	[25898] = "32868|J365|25867|25905",	-- Tenacious Earthstorm Diamond
	[32410] = "39963|J365|25868|32411",	-- Thundering Skyfire Diamond
    [33140] = '42592|J365|23440|33159|1|33140', -- Blood of Amber
    [33131] = '42589|J365|23436|33156|1|33131', -- Crimson Sun
    [33133] = '42558|J365|23436|33305|1|33133', -- Don Julio's Heart
    [33144] = '42593|J365|23440|33160|1|33144', --Facet of Eternity
    [33135] = '42590|J365|23438|33157|1|33135', --Falling Star
    [33134] = '42588|J365|23436|33155|1|33134', --Kailee's Rose
    [33143] = '42591|J365|23440|33158|1|33143', --Stone of Blades
    [34220] = "44794|J365|25868|34221", --Chaotic Skyfire Diamond
	[24123] = "31078|J370|23448:20 22457:20 23438:2 31079:5|24173",	-- Circlet of Arcane Might
	[44] = "31077|J370|23449:20 21886:20 23437:2 31079:5|24172||24122",	-- Coronet of the Verdant Flame
	[24125] = "31080|J370|23449:4 23440:2 23112:4|24180",	-- Figurine - Dawnstone Crab
	[24124] = "31079|J370|23448:8 23077:2 22452:4|24179",	-- Figurine - Felsteel Boar
	[24126] = "31081|J370|23448:2 23436:2 21884:4|24181",	-- Figurine - Living Ruby Serpent
	[24128] = "31083|J370|23573:6 23441:2 22456:2|24183",	-- Figurine - Nightseye Panther
	[24127] = "31082|J370|23447:2 23437:2 22457:4|24182",	-- Figurine - Talasite Owl
	[32213] = "39729|J375|32230|32299",	-- Balanced Shadowsong Amethyst
	[32193] = "39705|J375|32227|32274",	-- Bold Crimson Spinel
	[32197] = "39712|J375|32227|32283",	-- Bright Crimson Spinel
	[32204] = "39719|J375|32229|32290",	-- Brilliant Lionseye
	[32225] = "39741|J375|32249|32311",	-- Dazzling Seaspray Emerald
	[32194] = "39706|J375|32227|32277",	-- Delicate Crimson Spinel
	[32223] = "39739|J375|32249|32309",	-- Enduring Seaspray Emerald
	[32199] = "39714|J375|32227|32285",	-- Flashing Crimson Spinel
	[32207] = "39722|J375|32229|32293",	-- Gleaming Lionseye
	[32220] = "39736|J375|32231|32306",	-- Glinting Pyrestone
	[32215] = "39731|J375|32230|32301",	-- Glowing Shadowsong Amethyst
	[32210] = "39725|J375|32229|32296",	-- Great Lionseye
	[32214] = "39730|J375|32230|32300",	-- Infused Shadowsong Amethyst
	[32217] = "39733|J375|32231|32303",	-- Inscribed Pyrestone
	[32226] = "39742|J375|32249|32312",	-- Jagged Seaspray Emerald
	[32219] = "39735|J375|32231|32305",	-- Luminous Pyrestone
	[32202] = "39717|J375|32228|32288",	-- Lustrous Empyrean Sapphire
	[32209] = "39724|J375|32229|32295",	-- Mystic Lionseye
	[32218] = "39734|J375|32231|32304",	-- Potent Pyrestone
	[32224] = "39740|J375|32249|32310",	-- Radiant Seaspray Emerald
    [32206] = '39721|J375|32229|32292', --Rigid Lionseye
	[32216] = "39732|J375|32230|32302",	-- Royal Shadowsong Amethyst
	[32196] = "39711|J375|32227|32282",	-- Runed Crimson Spinel
	[32212] = "39728|J375|32230|32298",	-- Shifting Shadowsong Amethyst
	[32205] = "39720|J375|32229|32291",	-- Smooth Lionseye
	[32200] = "39715|J375|32228|32286",	-- Solid Empyrean Sapphire
	[32211] = "39727|J375|32230|32297",	-- Sovereign Shadowsong Amethyst
	[32201] = "39716|J375|32228|32287",	-- Sparkling Empyrean Sapphire
	[32203] = "39718|J375|32228|32289",	-- Stormy Empyrean Sapphire
	[32198] = "39713|J375|32227|32284",	-- Subtle Crimson Spinel
	[32195] = "39710|J375|32227|32281",	-- Teardrop Crimson Spinel
	[31398] = "38503|J375|31079:4 23449:2 21885:6 21884:6|31401",	-- The Frozen Eye
	[31399] = "38504|J375|31079:4 23448:2 21886:6 22456:6|31402",	-- The Natural Ward
	[32208] = "39723|J375|32229|32294",	-- Thick Lionseye
	[32221] = "39737|J375|32231|32307",	-- Veiled Pyrestone
	[32222] = "39738|J375|32231|32308",	-- Wicked Pyrestone
	[32206] = "39721|J375|32229",	-- Rigid Lionseye
	[31862] = "39455|J325|23107|31871",	-- Balanced Shadow Draenite
	[31860] = "39451|J325|23112|31870",	-- Great Golden Draenite
	[31864] = "39458|J325|23107|31872",	-- Infused Shadow Draenite
	[31866] = "39466|J325|21929|31873",	-- Veiled Flame Spessarite
	[31869] = "39467|J325|21929|31874",	-- Wicked Flame Spessarite
--[[ Leatherworking --]]
	[2302] = "2149|L1|2318:2 2320",	-- Handstitched Leather Boots
	[7277] = "9059|L1|2318:2 2320:3",	-- Handstitched Leather Bracers
	[7276] = "9058|L1|2318:2 2320",	-- Handstitched Leather Cloak
	[5957] = "7126|L1|2318:3 2320",	-- Handstitched Leather Vest
	[2304] = "2152|L1|2318",	-- Light Armor Kit
	[2318] = "2881|L1|2934:3",	-- Light Leather
	[2303] = "2153|L15|2318:4 2320",	-- Handstitched Leather Pants
	[4237] = "3753|L25|2318:6 2320",	-- Handstitched Leather Belt
	[7278] = "9060|L30|2318:4 2320:2",	-- Light Leather Quiver
	[7279] = "9062|L30|2318:3 2320:4",	-- Small Leather Ammo Pouch
	[7280] = "9064|L35|2318:5 2320:5|7288",	-- Rugged Leather Pants
	[4231] = "3816|L35|783 4289",	-- Cured Light Hide
	[2300] = "2160|L40|2318:8 2320:4",	-- Embossed Leather Vest
	[5081] = "5244|L40|5082:3 2318:4 2320|5083",	-- Kodo Hide Bag
	[2309] = "2161|L55|2318:8 2320:5",	-- Embossed Leather Boots
	[4239] = "3756|L55|2318:3 2320:2",	-- Embossed Leather Gloves
	[2310] = "2162|L60|2318:5 2320:2",	-- Embossed Leather Cloak
	[2311] = "2163|L60|2318:8 2320:2 2324|2407",	-- White Leather Jerkin
	[7281] = "9065|L70|2318:6 2320:4",	-- Light Leather Bracers
	[4242] = "3759|L75|4231 2318:6 2320:2",	-- Embossed Leather Pants
	[2312] = "2164|L75|4231 2318:4 2320:2|2408",	-- Fine Leather Gloves
	[4246] = "3763|L80|2318:6 2320:2",	-- Fine Leather Belt
	[2308] = "2159|L85|2318:10 2321:2",	-- Fine Leather Cloak
	[4243] = "3761|L85|4231:3 2318:6 2320:4",	-- Fine Leather Tunic
	[6466] = "7953|L90|6470:4 4231 2321|6474",	-- Deviate Scale Cloak
	[6709] = "8322|L90|2318:6 4231 2320:4 5498|6710",	-- Moonglow Vest
	[5780] = "6702|L90|5784:8 2318:6 2321|5786",	-- Murloc Scale Belt
	[2307] = "2158|L90|2318:7 2320:2|2406",	-- Fine Leather Boots
	[7282] = "9068|L95|2318:10 4231 2321",	-- Light Leather Pants
	[5781] = "6703|L95|5784:12 4231 2318:8 2321|5787",	-- Murloc Scale Breastplate
	[7283] = "9070|L100|7286:12 2319:4 2321|7289",	-- Black Whelp Cloak
	[20575] = "24940|L100|2319:8 7286:8 4231 2321:2|20576",	-- Black Whelp Tunic
	[2317] = "2169|L100|2319:6 2321 4340|2409",	-- Dark Leather Tunic
	[4244] = "3762|L100|4243 4231:2 2320:2|4293",	-- Hillman's Leather Vest
	[4233] = "3817|L100|4232 4289",	-- Cured Medium Hide
	[2315] = "2167|L100|2319:4 2321:2 4340",	-- Dark Leather Boots
	[2313] = "2165|L100|2319:4 2320",	-- Medium Armor Kit
	[2319] = "20648|L100|2318:4",	-- Medium Leather
	[6467] = "7954|L105|6470:5 2321:2|6475",	-- Deviate Scale Gloves
	[5958] = "7133|L105|2319:8 2997 2321|5972",	-- Fine Leather Pants
	[2316] = "2168|L110|2319:8 2321 4340",	-- Dark Leather Cloak
	[6468] = "7955|L115|6471:6 6470:4 2321:2|6476",	-- Deviate Scale Belt
	[5961] = "7135|L115|2319:12 4340 2321",	-- Dark Leather Pants
	[4248] = "3765|L120|2312 4233 2321 4340|7360",	-- Dark Leather Gloves
	[4250] = "3767|L120|2319:8 3383 2321:2|4294",	-- Hillman's Belt
	[7285] = "9074|L120|2457 2319:6 2321",	-- Nimble Leather Gloves
	[7284] = "9072|L120|7287:6 2319:4 2321|7290",	-- Red Whelp Gloves
	[2314] = "2166|L120|2319:10 4231:2 2321:2",	-- Toughened Leather Armor
	[4249] = "3766|L125|4246 4233 2321:2 4340",	-- Dark Leather Belt
	[7348] = "9145|L125|2319:8 5116:4 2321:2",	-- Fletcher's Gloves
	[4251] = "3768|L130|4233 2319:4 2321",	-- Hillman's Shoulders
	[4253] = "3770|L135|2319:4 4233:2 3389:2 3182:2 2321:2",	-- Toughened Leather Gloves
	[7352] = "9147|L135|2319:6 7067 2321:2|7362",	-- Earthen Leather Shoulders
	[7349] = "9146|L135|2319:8 3356:4 2321:2|7361",	-- Herbalist's Gloves
	[4252] = "3769|L140|2319:12 3390 4340 2321:2|4296",	-- Dark Leather Shoulders
	[7358] = "9148|L140|2319:10 5373:2 2321:2|7363",	-- Pilferer's Gloves
	[4255] = "3772|L145|4234:9 2605:2 2321:4|7613",	-- Green Leather Armor
	[7359] = "9149|L145|2319:12 7067:2 2997:2 2321:2|7364",	-- Heavy Earthen Gloves
	[4247] = "3764|L145|2319:14 2321:4",	-- Hillman's Leather Gloves
	[4254] = "3771|L150|4234:6 5637:2 2321|4297",	-- Barbaric Gloves
	[7372] = "9194|L150|4234:8 2321:2",	-- Heavy Leather Ammo Pouch
	[7371] = "9193|L150|4234:8 2321:2",	-- Heavy Quiver
	[4236] = "3818|L150|4235 4289:3",	-- Cured Heavy Hide
	[4265] = "3780|L150|4234:5 2321",	-- Heavy Armor Kit
	[4234] = "20649|L150|2319:5",	-- Heavy Leather
	[18662] = "23190|L150|4234:2 2321|18731",	-- Heavy Leather Ball
	[3719] = "3760|L150|4234:5 2321:2",	-- Hillman's Cloak
	[18948] = "23399|L155|4234:8 4236:2 5498:4 4461 5637:4|18949",	-- Barbaric Bracers
	[4456] = "4097|L155|4461:4 4234:4 2321:2|13288",	-- Raptor Hide Belt
	[4455] = "4096|L155|4461:6 4234:4 2321:2|13287",	-- Raptor Hide Harness
	[4257] = "3774|L160|4236 4234:5 2321 2605 7071",	-- Green Leather Belt
	[5962] = "7147|L160|4234:12 4305:2 2321:2",	-- Guardian Pants
	[7373] = "9195|L165|4234:10 2325 2321:2|7449",	-- Dusky Leather Leggings
	[5963] = "7149|L170|4234:10 2321:2 1206|5973",	-- Barbaric Leggings
	[4258] = "3775|L170|4236:2 4234:4 2321 7071|4298",	-- Guardian Belt
	[5782] = "6704|L170|5785:12 4236 4234:10 2321:3|5788",	-- Thick Murloc Armor
	[4262] = "3778|L175|4236:4 5500:2 1529:2 3864 2321|14635",	-- Gem-studded Leather Belt
	[5964] = "7151|L175|4234:8 4236 2321:2",	-- Barbaric Shoulders
	[7374] = "9196|L175|4234:10 3824 2321:2",	-- Dusky Leather Armor
	[7375] = "9197|L175|7392:4 4234:10 2321:2|7450",	-- Green Whelp Armor
	[4256] = "3773|L175|4236:2 4234:12 3824 2321:2|4299",	-- Guardian Armor
	[7377] = "9198|L180|4234:6 7067:2 7070:2 2321:2",	-- Frost Leather Cloak
	[4259] = "3776|L180|4236:2 4234:6 2605 2321",	-- Green Leather Bracers
	[7378] = "9201|L185|4234:16 2325 4291:2",	-- Dusky Bracers
	[5965] = "7153|L185|4234:14 4305:2 4291:2|5974",	-- Guardian Cloak
	[17721] = "21943|L190|4234:8 7067:4 4291|17722",	-- Gloves of the Greatfather
	[7386] = "9202|L190|7392:6 4234:8 4291:2|7451",	-- Green Whelp Bracers
	[5783] = "6705|L190|5785:16 4236 4234:14 4291|5789",	-- Murloc Scale Bracers
	[5739] = "6661|L190|4234:14 2321:2 7071",	-- Barbaric Harness
	[5966] = "7156|L190|4234:4 4236 4291",	-- Guardian Gloves
	[7387] = "9206|L195|4234:10 4305:2 2325:2 7071",	-- Dusky Belt
	[4260] = "3777|L195|4234:6 4236:2 4291|4300",	-- Guardian Leather Bracers
	[18238] = "22711|L200|4304:6 7428:8 7971:2 4236:2 1210:4 8343|18239",	-- Shadowskin Gloves
	[4264] = "3779|L200|4234:6 4236:2 4096:2 5633 4291 7071|4301",	-- Barbaric Belt
	[8174] = "10490|L200|4234:12 4236:2 4291:2|8384",	-- Comfortable Leather Hat
	[7390] = "9207|L200|4234:8 7428:2 3824 4291:2|7452",	-- Dusky Boots
	[7391] = "9208|L200|4234:10 2459:2 4337:2 4291|7453",	-- Swift Boots
	[8172] = "10482|L200|8169 8150",	-- Cured Thick Hide
	[8173] = "10487|L200|4304:5 4291",	-- Thick Armor Kit
	[4304] = "20650|L200|4234:6",	-- Thick Leather
	[8176] = "10507|L205|4304:5 4291:2",	-- Nightscape Headband
	[8175] = "10499|L205|4304:7 4291:2",	-- Nightscape Tunic
	[8187] = "10509|L205|4304:6 8167:8 8343|8385",	-- Turtle Scale Gloves
	[8192] = "10516|L210|4304:8 4338:6 4291:3|8409",	-- Nightscape Shoulders
	[8198] = "10518|L210|4304:8 8167:12 8343",	-- Turtle Scale Bracers
	[8189] = "10511|L210|4304:6 8167:12 8343",	-- Turtle Scale Breastplate
	[8210] = "10529|L210|4304:10 8153 8172|8403",	-- Wild Leather Shoulders
	[8200] = "10520|L215|4304:10 8151:4 8343|8386",	-- Big Voodoo Robe
	[8214] = "10546|L215|4304:10 8153:2 8172|8405",	-- Wild Leather Helmet
	[8211] = "10544|L215|4304:12 8153:2 8172|8404",	-- Wild Leather Vest
	[8201] = "10531|L220|4304:8 8151:6 8343|8387",	-- Big Voodoo Mask
	[8205] = "10533|L220|4304:10 8154:4 4291:2|8397",	-- Tough Scorpid Bracers
	[8203] = "10525|L220|4304:12 8154:12 4291:4|8395",	-- Tough Scorpid Breastplate
	[8217] = "14930|L225|4304:12 8172 8949 4291:4",	-- Quickdraw Quiver
	[8218] = "14932|L225|4304:10 8172 8951 4291:6",	-- Thick Leather Ammo Pouch
	[8204] = "10542|L225|4304:6 8154:8 4291:2|8398",	-- Tough Scorpid Gloves
	[8347] = "10619|L225|4304:24 8165:12 8343:4 8172:2",	-- Dragonscale Gauntlets
	[8367] = "10650|L255|4304:40 8165:30 8343:4 8172:4",	-- Dragonscale Breastplate
	[8345] = "10621|L225|4304:18 8368:2 8146:8 8343:4 8172:2",	-- Wolfshead Helm
	[8193] = "10548|L230|4304:14 4291:4",	-- Nightscape Pants
	[8191] = "10552|L230|4304:14 8167:24 8343",	-- Turtle Scale Helm
	[8346] = "10630|L230|4304:20 7079:8 7075:2 8172 8343:4",	-- Gauntlets of the Sea
	[8197] = "10558|L235|4304:16 8343:2",	-- Nightscape Boots
	[8209] = "10554|L235|4304:12 8154:12 4291:6|8399",	-- Tough Scorpid Boots
	[8185] = "10556|L235|4304:14 8167:28 8343",	-- Turtle Scale Leggings
	[8213] = "10566|L235|4304:14 8153:4 8172:2|8406",	-- Wild Leather Boots
	[8216] = "10562|L240|4304:14 8152:4 8343:2|8390",	-- Big Voodoo Cloak
	[8202] = "10560|L240|4304:10 8152:6 8343:2|8389",	-- Big Voodoo Pants
	[8207] = "10564|L240|4304:12 8154:16 8343:2|8400",	-- Tough Scorpid Shoulders
	[8215] = "10574|L240|4304:16 8153:6 8172:2|8408",	-- Wild Leather Cloak
	[8212] = "10572|L240|4304:16 8153:6 8172:2|8407",	-- Wild Leather Leggings
	[8206] = "10568|L245|4304:14 8154:8 8343:2|8401",	-- Tough Scorpid Leggings
	[8208] = "10570|L250|4304:10 8154:20 8343:2|8402",	-- Tough Scorpid Helm
	[8348] = "10632|L250|4304:40 7077:8 7075:4 8172:2 8343:4",	-- Helm of Fire
	[8349] = "10647|L250|4304:40 8168:40 7971:2 8172:4 8343:4",	-- Feathered Breastplate
	[15407] = "19047|L250|8171 15409",	-- Cured Rugged Hide
	[15564] = "19058|L250|8170:5",	-- Rugged Armor Kit
	[8170] = "22331|L250|4304:6",	-- Rugged Leather
	[15077] = "19048|L255|8170:4 15408:4 14341|15724",	-- Heavy Scorpid Bracers
	[15045] = "19050|L260|8170:20 15412:25 14341:2|15726",	-- Green Dragonscale Breastplate
	[15083] = "19049|L260|8170:8 2325 14341|15725",	-- Wicked Leather Gauntlets
	[15074] = "19053|L265|8170:6 15423:6 14341|15729",	-- Chimeric Gloves
	[15076] = "19051|L265|8170:6 15408:6 14341|15727",	-- Heavy Scorpid Vest
	[15084] = "19052|L265|8170:8 2325 14341|15728",	-- Wicked Leather Bracers
	[15046] = "19060|L270|8170:20 15412:25 14341|15733",	-- Green Dragonscale Leggings
	[15067] = "19062|L270|8170:24 15420:80 1529:2 14341|15735",	-- Ironfeather Shoulders
	[15061] = "19061|L270|8170:12 12803:4 14341|15734",	-- Living Shoulders
	[15091] = "19055|L270|8170:10 14047:6 14341|15731",	-- Runic Leather Gauntlets
	[15054] = "19059|L270|8170:6 7078 7075 14341|15732",	-- Volcanic Leggings
	[15057] = "19067|L275|8170:16 7080:2 7082:2 14341|15741",	-- Stormshroud Pants
	[15064] = "19068|L275|8170:28 15419:12 14341|15742",	-- Warbear Harness
	[15073] = "19063|L275|8170:4 15423:8 14341|15737",	-- Chimeric Boots
	[15071] = "19066|L275|8170:4 15422:6 14341|15740",	-- Frostsaber Boots
	[45] = "19064|L275|8170:6 15408:8 14341|15738||15078",	-- Heavy Scorpid Gauntlets
	[15092] = "19065|L275|8170:6 7971 14047:6 14341|15739",	-- Runic Leather Bracers
	[15072] = "19073|L280|8170:8 15423:8 14341|15746",	-- Chimeric Leggings
	[15082] = "19070|L280|8170:6 15408:8 14341|15743",	-- Heavy Scorpid Belt
	[15093] = "19072|L280|8170:12 14047:10 14341|15745",	-- Runic Leather Belt
	[15086] = "19071|L280|8170:12 2325 14341|15744",	-- Wicked Leather Headband
	[20296] = "24655|L280|8170:20 15412:30 15407 14341:2",	-- Green Dragonscale Gauntlets
	[15048] = "19077|L285|8170:28 15415:30 15407 14341|15751",	-- Blue Dragonscale Breastplate
	[15060] = "19078|L285|8170:16 12803:6 15407 14341|15752",	-- Living Leggings
	[15056] = "19079|L285|8170:16 7080:3 7082:3 15407 14341|15753",	-- Stormshroud Armor
	[15065] = "19080|L285|8170:24 15419:14 14341|20254",	-- Warbear Woolies
	[15069] = "19074|L285|8170:6 15422:8 14341|15747",	-- Frostsaber Leggings
	[15079] = "19075|L285|8170:8 15408:12 14341|15748",	-- Heavy Scorpid Leggings
    [34086] = "44953|L285|2840 2997 8170:4 14341|34262", -- Winter Boots
	[15053] = "19076|L285|8170:8 7078 7076 14341|15749",	-- Volcanic Breastplate
	[15050] = "19085|L290|8170:40 15416:60 15407 14341:2|15759",	-- Black Dragonscale Breastplate
	[19052] = "23705|L290|8170:30 12809:2 7080:4 15407:2 14341:2|19328",	-- Dawn Treaders
	[15063] = "19084|L290|8170:30 15417:8 14341|15758",	-- Devilsaur Gauntlets
	[15066] = "19086|L290|8170:40 15420:120 1529 15407 14341|15760",	-- Ironfeather Breastplate
	[19044] = "23703|L290|8170:30 12804:2 12803:4 15407:2 14341:2|19326",	-- Might of the Timbermaw
	[15075] = "19081|L290|8170:10 15423:10 14341|15755",	-- Chimeric Vest
	[15094] = "19082|L290|8170:14 14047:10 14341|15756",	-- Runic Leather Headband
	[15087] = "19083|L290|8170:16 15407 2325:3 14341|15757",	-- Wicked Leather Pants
	[16982] = "20853|L295|17012:20 17010:6 17011:2 14341:2|17022",	-- Corehound Boots
	[15049] = "19089|L295|8170:28 15415:30 12810:2 15407 14341|15763",	-- Blue Dragonscale Shoulders
	[15058] = "19090|L295|8170:12 7080:3 7082:3 12810:2 14341|15764",	-- Stormshroud Shoulders
	[15070] = "19087|L295|8170:6 15422:10 14341|15761",	-- Frostsaber Gloves
	[15080] = "19088|L295|8170:8 15408:12 15407 14341|15762",	-- Heavy Scorpid Helm
	[16984] = "20855|L300|12810:6 15416:30 17010:4 17011:3 14341:2|17025",	-- Black Dragonscale Boots
	[18509] = "22926|L300|8170:30 12607:12 15416:30 15414:30 15407:5 14341:8|18517",	-- Chromatic Cloak
	[19157] = "23708|L300|17010:5 17011:2 17012:4 12607:4 15407:4 14227:4|19331",	-- Chromatic Gauntlets
	[19162] = "23709|L300|17010:8 17012:12 12810:10 15407:4 14227:4|19332",	-- Corehound Belt
	[20380] = "24703|L300|12810:12 20381:6 12803:4 15407:4 14227:6|20382",	-- Dreamscale Breastplate
	[18510] = "22927|L300|8170:30 12803:12 7080:10 18512:8 15407:3 14341:8|18518",	-- Hide of the Wild
	[22665] = "28224|L300|22682:4 15408:16 7080:2 15407:2 14227:4",	-- Icy Scale Bracers
	[22664] = "28222|L300|22682:7 15408:24 7080:2 15407:4 14227:4",	-- Icy Scale Breastplate
	[22666] = "28223|L300|22682:5 15408:16 7080:2 15407:3 14227:4",	-- Icy Scale Gauntlets
	[19149] = "23707|L300|17011:5 15407:4 14227:4|19330",	-- Lava Belt
	[19163] = "23710|L300|17010:2 17011:7 7076:6 15407:4 14227:4|19333",	-- Molten Belt
	[16983] = "20854|L300|17012:15 17010:3 17011:6 14341:2|17023",	-- Molten Helm
	[22663] = "28221|L300|22682:4 12810:12 7080:2 15407:2 14227:4",	-- Polar Bracers
	[22662] = "28220|L300|22682:5 12810:12 7080:2 15407:3 14227:4",	-- Polar Gloves
	[22661] = "28219|L300|22682:7 12810:16 7080:2 15407:4 14227:4",	-- Polar Tunic
	[18511] = "22928|L300|8170:30 7082:12 12753:4 12809:8 15407:4 14341:8|18519",	-- Shifting Cloak
	[15052] = "19107|L300|8170:40 15416:60 12810:4 15407 14341:2|15781",	-- Black Dragonscale Leggings
	[15051] = "19094|L300|8170:44 15416:45 12810:2 15407 14341|15770",	-- Black Dragonscale Shoulders
	[19688] = "24124|L300|19768:35 19726:2 15407:3 14341:3|19772",	-- Blood Tiger Breastplate
	[19689] = "24125|L300|19768:25 19726:2 15407:3 14341:3|19773",	-- Blood Tiger Shoulders
	[22761] = "28474|L300|12810:4 12803:2 15407|22769",	-- Bramblewood Belt
	[22760] = "28473|L300|12810:6 18512:2 12803:2 15407:2|22770",	-- Bramblewood Boots
	[22759] = "28472|L300|12810:12 19726:2 12803:2 15407:2|22771",	-- Bramblewood Helm
	[18251] = "22727|L300|17012:3 14341:2|18252",	-- Core Armor Kit
	[15062] = "19097|L300|8170:30 15417:14 15407 14341|15772",	-- Devilsaur Leggings
	[18504] = "22921|L300|8170:12 12804:12 15407:2 14341:4|18514",	-- Girdle of Insight
	[19058] = "23706|L300|12810:8 12803:4 12809:4 15407:2 14341:2|19329",	-- Golden Mantle of the Dawn
	[15059] = "19095|L300|8170:16 12803:8 14342:2 15407 14341:2|15771",	-- Living Breastplate
	[18506] = "22922|L300|8170:12 7082:6 11754:4 15407:2 14341:4|18515",	-- Mongoose Boots
	[15138] = "19093|L300|15410 14044 14341",	-- Onyxia Scale Cloak
	[19687] = "24123|L300|19767:8 15407:3 12803:4 14341:3|19771",	-- Primal Batskin Bracers
	[19686] = "24122|L300|19767:10 15407:4 12803:4 14341:3|19770",	-- Primal Batskin Gloves
	[19685] = "24121|L300|19767:14 15407:5 12803:4 14341:4|19769",	-- Primal Batskin Jerkin
	[15047] = "19054|L300|8170:40 15414:30 14341|15730",	-- Red Dragonscale Breastplate
	[20476] = "24849|L300|20501 20498:20 18512:2|20509",	-- Sandstalker Bracers
	[20478] = "24851|L300|20501:3 20498:40 18512:2 15407:2|20511",	-- Sandstalker Breastplate
	[20477] = "24850|L300|20501:2 20498:30 18512:2 15407|20510",	-- Sandstalker Gauntlets
	[20481] = "24846|L300|20500 20498:20 7078:2|20506",	-- Spitfire Bracers
	[20479] = "24848|L300|20500:3 20498:40 7078:2 15407:2|20508",	-- Spitfire Breastplate
	[20480] = "24847|L300|20500:2 20498:30 7078:2 15407|20507",	-- Spitfire Gauntlets
	[21278] = "26279|L300|12810:6 7080:4 7082:4 15407:2 14227:2|21548",	-- Stormshroud Gloves
	[18508] = "22923|L300|8170:12 18512:8 15420:60 15407:4 14341:4|18516",	-- Swift Flight Bracers
	[19049] = "23704|L300|12810:8 12804:6 12803:6 15407:2 14227:2|19327",	-- Timbermaw Brawlers
	[25654] = "32462|L300|21887:5 25700 14341:2",	-- Felscale Gloves
	[15068] = "19104|L300|8170:12 15422:12 15407 14341:2|15779",	-- Frostsaber Tunic
	[15081] = "19100|L300|8170:14 15408:14 15407 14341:2|15774",	-- Heavy Scorpid Shoulders
	[15090] = "19102|L300|8170:22 12810:4 14047:16 15407 14341:2|15776",	-- Runic Leather Armor
	[15095] = "19091|L300|8170:18 14047:12 12810:2 14341|15765",	-- Runic Leather Pants
	[15096] = "19103|L300|8170:16 12810:4 14047:18 15407 14341:2|15777",	-- Runic Leather Shoulders
	[25662] = "32466|L300|21887:6 25700:3 14341:2",	-- Scaled Draenic Pants
	[25669] = "32470|L300|21887:6 14341:2",	-- Thick Draenic Gloves
	[15055] = "19101|L300|8170:10 7078 7076 14341:2|15775",	-- Volcanic Shoulders
	[15085] = "19098|L300|8170:20 15407:2 14256:2 2325:4 14341:2|15773",	-- Wicked Leather Armor
	[15088] = "19092|L300|8170:14 2325:2 14341:2|15768",	-- Wicked Leather Belt
	[25673] = "32478|L300|21887:6 14341:3",	-- Wild Draenish Boots
	[25679] = "32482|L300|21887:2|25726",	-- Comfortable Insoles
	[25650] = "32456|L300|21887:4",	-- Knothide Armor Kit
	[21887] = "32454|L300|25649:5",	-- Knothide Leather
	[20295] = "24654|L300|8170:28 15415:36 15407:2 14341:2",	-- Blue Dragonscale Leggings
    [34482] = "45100|L300|21887:20 25700:4 25707:3 14341:3", -- Leatherworker's Satchel
	[25655] = "32463|L310|21887:8 25700 14341:2",	-- Felscale Boots
	[25661] = "32467|L310|21887:8 25700 14341:2",	-- Scaled Draenic Gloves
	[25674] = "32479|L310|21887:9 14341:3",	-- Wild Draenish Gloves
	[25670] = "32471|L315|21887:10 14341:2",	-- Thick Draenic Pants
    [34099] = "44343|L315|21887:24 14341:4 22451:1", -- Knothide Ammo Pouch
    [34100] = "44344|L315|21887:20 25719:30 14341:2", -- Knothide Quiver
	[25656] = "32464|L320|21887:10 25700:3 14341:3",	-- Felscale Pants
	[25668] = "32472|L320|21887:10 14341:3",	-- Thick Draenic Boots
	[25675] = "32480|L320|21887:13 14341:3",	-- Wild Draenish Leggings
	[29540] = "35530|L325|23793:6 22452:4|29664",	-- Reinforced Mining Bag
	[25660] = "32468|L325|21887:12 25700:3 14341:3",	-- Scaled Draenic Vest
	[23793] = "32455|L325|21887:5|25720",	-- Heavy Knothide Leather
	[25652] = "32458|L325|23793:3 22457|25722",	-- Magister's Armor Kit
	[25651] = "32457|L325|23793:3 22452|25721",	-- Vindicator's Armor Kit
	[25671] = "32473|L330|21887:14 14341:3",	-- Thick Draenic Vest
	[25676] = "32481|L330|21887:15 14341:3",	-- Wild Draenish Vest
	[29534] = "35555|L335|23793:4 25708:8 22452:4|29720",	-- Clefthide Leg Armor
	[29533] = "35549|L335|23793:4 29539:2 22451:4|29719",	-- Cobrahide Leg Armor
	[25657] = "32465|L335|21887:14 25700:3 14341:3",	-- Felscale Breastplate
	[25659] = "32469|L335|21887:12 25700:2 14341:3",	-- Scaled Draenic Boots
	[25685] = "32490|L340|23793:6 25707:6 22456:6 14341:3|25732",	-- Fel Leather Gloves
	[25694] = "32501|L340|23793:4 25699:8 21885:3 22457:3 14341:2|25741",	-- Netherfury Belt
	[25692] = "32502|L340|23793:8 25699:12 21885:5 22457:5 14341:2|25742",	-- Netherfury Leggings
	[29488] = "35524|L340|23793:4 22457:4|29675",	-- Arcane Armor Kit
	[29528] = "35540|L340|23793:2 25700:3",	-- Drums of War (Trainer)
	[29485] = "35521|L340|23793:4 21885:4|29672",	-- Flame Armor Kit
	[29486] = "35522|L340|23793:4 21884:4|29673",	-- Frost Armor Kit
	[29487] = "35523|L340|23793:4 22456:4|29674",	-- Nature Armor Kit
	[29483] = "35520|L340|23793:4 21886:4|29669",	-- Shadow Armor Kit
	[29530] = "35544|L345|23793:6 29547:4|34172",	-- Drums of Speed ****Kurenai
	[29500] = "35537|L350|23793:4 25707:6 21884:3 21885:3|29704",	-- Blastguard Belt
	[29499] = "35536|L350|23793:4 25707:8 21884:3 21885:3|29703",	-- Blastguard Boots
	[29498] = "35535|L350|23793:6 25707:10 21884:4 21885:4|29702",	-- Blastguard Pants
	[29497] = "35534|L350|23793:4 25708:16 22457:6|29701",	-- Enchanted Clefthoof Boots
	[29496] = "35533|L350|23793:4 25708:16 22457:6|29700",	-- Enchanted Clefthoof Gloves
	[29495] = "35532|L350|23793:6 25708:24 22457:8|29698",	-- Enchanted Clefthoof Leggings
	[29491] = "35527|L350|23793:4 25700:10 22457:6|29684",	-- Enchanted Felscale Boots
	[29490] = "35526|L350|23793:4 25700:10 22457:6|29682",	-- Enchanted Felscale Gloves
	[29489] = "35525|L350|23793:6 25700:12 22457:8|29677",	-- Enchanted Felscale Leggings
	[25686] = "32493|L350|23793:10 25707:8 22456:8 14341:3|25733",	-- Fel Leather Boots
	[25687] = "32494|L350|23793:10 25707:10 22456:10 14341:3|25734",	-- Fel Leather Leggings
	[25695] = "32498|L350|23793:6 25707:4 25699:8 22451:6 14341:2|25738",	-- Felstalker Belt
	[29494] = "35531|L350|23793:4 25699:8 21884:3 21885:3|29693",	-- Flamescale Belt
	[29493] = "35528|L350|23793:4 25699:8 21884:3 21885:3|29691",	-- Flamescale Boots
	[29492] = "35529|L350|23793:6 25699:12 21884:4 21885:4|29689",	-- Flamescale Leggings
	[25693] = "32503|L350|23793:6 25699:10 21885:4 22457:4 14341:2|25743",	-- Netherfury Boots
    [34207] = "44770|L350|23793:18 22452:12 14341:1", -- Glove Reinforcements
	[25653] = "32461|L350|23793:4 23571 22445:6 22448|25725",	-- Riding Crop
	[25681] = "32487|L350|23793:6 29539:2 21886:8 2325:4 14341:3|25729",	-- Stylin' Adventure Hat
	[25683] = "32488|L350|23793:6 29539:2 21884:8 2604:4 14341:3|25731",	-- Stylin' Crimson Hat
	[25682] = "32489|L350|23793:6 29539:2 22452:8 14341:3|25730",	-- Stylin' Jungle Hat
	[25680] = "32485|L350|23793:6 29539:2 22456:8 4342:4 14341:3|25728",	-- Stylin' Purple Hat
	[29531] = "35539|L350|23793:6 29548:4|34174",	-- Drums of Restoration ---Kurenai
    [34105] = "44359|L350|23793:8 17056:9 22451:2 23572|34200", -- Quiver of a Thousand Feathers
    [34330] = "44970|L350|23793:3", -- Heavy Knothide Armor Kit
    [34106] = "44768|L350|23793:12 29548:12 22452:4 23572|34201", -- Netherscale Ammo Pouch
	[25691] = "32497|L355|23793:4 25708:20 22452:4 14341:2|25737",	-- Heavy Clefthoof Boots
	[25690] = "32496|L355|23793:6 25708:34 22452:4 14341:2|25736",	-- Heavy Clefthoof Leggings
	[46] = "32499|L360|23793:6 25707:6 25699:6 22451:4 14341:2|25739||25697",	-- Felstalker Bracer
	[25696] = "32500|L360|23793:10 25707:4 25699:8 22451:8 14341:2|25740",	-- Felstalker Breastplate
	[25689] = "32495|L360|23793:6 25708:40 22452:4 14341:2|25735",	-- Heavy Clefthoof Vest
    [33122] = "42546|L360|23793:8 21844:12 22456:12 23572:4|33124", -- Cloak of Darkness
    [34490] = "45117|L360|23793:15 29547:5 25707:5 29548:5 25708:5 14341:3|34491", -- Bag of Many Hides
	[29503] = "35559|L365|23793:4 29539:8 22451:12 22456:12 23572|29724",	-- Cobrascale Gloves -- also rid 35302******
	[29502] = "35558|L365|23793:6 29539:10 22451:15 22456:15 23572|29723",	-- Cobrascale Hood
	[29512] = "35567|L365|23793:4 29548:24 22452:22 22457:4 23572|29730",	-- Earthen Netherscale Boots
	[29506] = "35562|L365|23793:4 21886:16 22452:12 23572|29727",	-- Gloves of the Living Touch -- also rid 35303******
	[29505] = "35561|L365|23793:6 21886:20 21885:8 23572|29726",	-- Hood of Primal Life
	[29508] = "35564|L365|23793:6 29548:28 21886:12 22457:12 23572|29729",	-- Living Dragonscale Helm
	[29511] = "35573|L365|23793:4 29548:24 21884:14 22457:10 23572|29733",	-- Netherdrake Gloves -- also 35301
	[29510] = "35572|L365|23793:6 29548:28 21884:18 22457:12 23572|29732",	-- Netherdrake Helm
	[29514] = "35574|L365|23793:8 29548:32 22452:20 22451:8 23572|29734",	-- Thick Netherscale Breastplate
	[29504] = "35560|L365|23793:6 29547:20 22451:18 22457:10 23572|29725",	-- Windscale Hood
	[29507] = "35563|L365|23793:4 29547:12 22452:18 22451:8 23572|29728",	-- Windslayer Wraps
	[29509] = "35568|L365|23793:4 29547:14 22451:14 21884:10 23572|29731",	-- Windstrike Gloves -- also 35300
	[29529] = "35543|L365|23793:6 25708:4|29717",	-- Drums of Battle
	[29536] = "35557|L365|23793:4 25708:16 22452:8 23572|29721",	-- Nethercleft Leg Armor
	[29535] = "35554|L365|23793:4 29539:4 22451:8 23572|29722",	-- Nethercobra Leg Armor
	[29532] = "35538|L370|23793:6 25707:4|29713",	-- Drums of Panic
    [30040] = '36351|L375|30183:2 23793:4 22456:10 22451:10 14341:2|30302', --Belt of Deep Shadow
    [30042] = '36339|L375|30183:2 23793:4 21886:10 14341:2 22451:10|30301', --Belt of Natural Power
    [30046] = '36352|L375|30183:2 23793:4 22451:10 29457:10 14341:2|30303', --Belt of the Black Eagle
    [30041] = '36355|L375|23572:2 23793:3 21886:12 14341:2|30305', --Boots of Natural Grace
    [30045] = '36358|L375|23572:2 23793:4 22451:10 29547:6 14341:2|30307', --Boots of the Crimson Hawk
    [30043] = '36359|L375|23572:2 23793:4 21885:10 29547:6 14341:2|30308', --Hurricane Boots
    [30044] = '36353|L375|30183:2 23793:4 21885:10 29547:6 14341:2|30304', --Monsoon Belt
    [32574] = '41161|L375|23793:4 22451:4 21885:4 29547:12 32428:4|32748', -- Bindings of Lightning Reflexes - also rid 35517*****
    [32579] = '41164|L375|23793:6 22451:6 22452:6 29547:16 32428:2|32751', -- Living Earth Shoulders -- also 35521****
    [32583] = '41157|L375|23793:6 22451:8 21886:8 32428:2|32745', --Shoulderpads of Renewed Life -- also 35523
    [32580] = '41158|L375|23793:4 22451:10 32428:3|32746', --Swiftstrike Bracers
    [32582] = '41156|L375|23793:4 22451:6 21886:6 32428:4|32744', -- Bracers of Renewed Life - also rid 35519*****
    [32577] = '41163|L375|23793:3 22451:4 22452:4 29547:12 32428:4|32750', -- Living Earth Bindings - also rid 35520
    [32583] = '41157|L375|23793:4 22451:8 21886:8 32428:2|32745', -- Shoulders of Renewed Life
    [32575] = '41162|L375|23793:6 22451:6 21885:6 29547:16 32428:2|32749', -- Shoulders of Lightning Reflexes -- also 35524
    [32581] = '41160|L375|23793:6 22451:12 32428:2|32747', --Swiftstrike Shoulders -- also 35528
    [30039] = '36357|L375|23572:2 23793:4 22456:12 14341:2|30306', --Boots of Utter Darkness
    [32398] = '39997|L375|32428:2 22450:1 21886:2 22456:4 25700:4|32429', --Boots of Shackeled Souls
    [32399] = '40000|L375|32428:2 22450:1 21886:2 22456:2 25700:2|32430', --Bracers of Shackeled Souls
    [32400] = '40001|L375|32428:3 22450:1 21886:4 22456:6 25700:3|32431', --Greaves of Shackeled Souls
    [32397] = '40002|L375|32428:2 22450:1 21886:3 22456:4 25700:2|32429', --Waistguard of Shackeled Souls
    [32393] = '40006|L375|32428:2 22450:1 21886:3 22456:4 25707:2|32436', --Redeemed Cinch
    [32396] = '40005|L375|32428:3 22450:1 21886:4 22456:6 25707:3|32429', --Redeemed Legguards
    [32394] = '40003|L375|32428:2 22450:1 21886:4 22456:6 25707:4|32433', --Redeemed Moccassins
    [32395] = '40004|L375|32428:2 22450:1 21886:2 22456:2 25707:4|32434', --Redeemed Wristguards
    [33204] = "42731|L375|23793:10 21844:16 22452:12 22456:12 23572:2|33205", --Shadowprowler's Chestguard
--[[ Specialty Leatherworking --]]
	[29971] = "36076|Ld260|8170:10 8165:10 7077:2 8172:2 14341",	-- Dragonstrike Leggings
	[29975] = "36079|Ld330|21887:20 15416:8 21884:3 14341:2",	-- Golden Dragonstrike Breastplate
	[29516] = "35576|Ld375|23793:6 29548:24 21884:12 22456:12 23572",	-- Ebon Netherscale Belt
	[29517] = "35577|Ld375|23793:4 29548:18 21884:8 22456:8",	-- Ebon Netherscale Bracers
	[29515] = "35575|Ld375|23793:8 29548:30 21884:16 22456:16 23572:2",	-- Ebon Netherscale Breastplate
	[29520] = "35582|Ld375|23793:6 29548:24 22457:12 22451:12 23572",	-- Netherstrike Belt
	[29521] = "35584|Ld375|23793:4 29548:18 22457:8 22451:8",	-- Netherstrike Bracers
	[29519] = "35580|Ld375|23793:8 29548:30 22457:16 22451:16 23572:2",	-- Netherstrike Breastplate
	[29964] = "36074|Le260|8170:10 7081:8 8172:2 14341",	-- Blackstorm Leggings
	[29973] = "36077|Le330|21887:20 22451:2 22452:2 14341:2",	-- Primalstorm Breastplate
	[29526] = "35590|Le375|23793:6 23571:5 23572",	-- Primalstrike Belt
	[29527] = "35591|Le375|23793:4 23571:3",	-- Primalstrike Bracers
	[29525] = "35589|Le375|23793:8 23571:6 23572:2",	-- Primalstrike Vest
	[29970] = "36075|Lt260|8170:10 8168:40 8153:4 8172:2 14341",	-- Wildfeather Leggings
	[29974] = "36078|Lt330|21887:20 25699:12 21886:3 14341:2",	-- Living Crystal Breastplate
	[29524] = "35587|Lt375|23793:6 29547:16 22451:12 23571:2 23572",	-- Windhawk Belt
	[29523] = "35588|Lt375|23793:4 29547:12 22451:8 23571",	-- Windhawk Bracers
	[29522] = "35585|Lt375|23793:8 29547:20 22451:16 23571:3 23572:2",	-- Windhawk Hauberk
--[[ Smelting --]]
	[47] = "2657|Y1|2770|||2840",	-- Smelt Copper
	[48] = "2659|Y65|2840 3576||2|2841",	-- Smelt Bronze
	[49] = "3304|Y65|2771|||3576",	-- Smelt Tin
	[50] = "2658|Y75|2775|||2842",	-- Smelt Silver
	[51] = "3307|Y125|2772|||3575",	-- Smelt Iron
	[52] = "3308|Y155|2776|||3577",	-- Smelt Gold
	[53] = "3569|Y165|3575 3857|||3859",	-- Smelt Steel
	[54] = "10097|Y175|3858|||3860",	-- Smelt Mithril
	[55] = "10098|Y230|7911|||6037",	-- Smelt Truesilver
	[56] = "14891|Y230|11370:8|||11371",	-- Smelt Dark Iron
	[57] = "16153|Y250|10620|||12359",	-- Smelt Thorium
	[58] = "22967|Y300|18562 12360:10 17010 18567:3|||17771",	-- Smelt Elementium
	[59] = "35750|Y300|22452||10|22573",	-- Earth Shatter
	[60] = "35751|Y300|21884||10|22574",	-- Fire Sunder
	[61] = "29356|Y300|23424:2|||23445",	-- Smelt Fel Iron
	[62] = "29358|Y325|23425:2|||23446",	-- Smelt Adamantite
	[63] = "29359|Y350|23427:2|||23447",	-- Smelt Eternium
	[64] = "29360|Y350|23445:3 23447:2|||23448",	-- Smelt Felsteel
	[65] = "29361|Y375|23426:2|||23449",	-- Smelt Khorium
	[66] = "29686|Y375|23446:10|||23573",	-- Smelt Hardened Adamantite
--[[ Tailoring --]]
	[2996] = "2963|T1|2589:2",	-- Bolt of Linen Cloth
	[4344] = "3915|T1|2996 2320",	-- Brown Linen Shirt
	[2570] = "2387|T1|2996 2320",	-- Linen Cloak
	[10045] = "12044|T1|2996 2320",	-- Simple Linen Pants
	[2576] = "2393|T1|2996 2320 2324",	-- White Linen Shirt
	[2568] = "2385|T10|2996 2320",	-- Brown Linen Vest
	[7026] = "8776|T15|2996 2320",	-- Linen Belt
	[10046] = "12045|T20|2996:2 2318 2320",	-- Simple Linen Boots
	[6238] = "7623|T30|2996:3 2320",	-- Brown Linen Robe
	[6241] = "7624|T30|2996:3 2320 2324",	-- White Linen Robe
	[4343] = "3914|T30|2996:2 2320",	-- Brown Linen Pants
	[4307] = "3840|T35|2996:2 2320",	-- Heavy Linen Gloves
	[2572] = "2389|T40|2996:3 2320:2 2604:2|2598",	-- Red Linen Robe
	[2577] = "2394|T40|2996:2 2320 6260",	-- Blue Linen Shirt
	[2575] = "2392|T40|2996:2 2320 2604",	-- Red Linen Shirt
	[6786] = "8465|T40|2996:2 2320 6260 2324",	-- Simple Dress
	[4238] = "3755|T45|2996:3 2320:3",	-- Linen Bag
	[6240] = "7630|T55|2996:3 2320 6260|6270",	-- Blue Linen Vest
	[6239] = "7629|T55|2996:3 2320 2604|6271",	-- Red Linen Vest
	[4308] = "3841|T60|2996:3 2320:2 2605",	-- Green Linen Bracers
	[2580] = "2397|T60|2996:2 2320:3",	-- Reinforced Linen Cape
	[2569] = "2386|T65|2996:3 2320 2318",	-- Linen Boots
	[2578] = "2395|T70|2996:4 2318 2321",	-- Barbaric Linen Vest
	[6242] = "7633|T70|2996:4 2320:2 6260:2|6272",	-- Blue Linen Robe
	[4309] = "3842|T70|2996:4 2321:2",	-- Handstitched Linen Britches
	[2579] = "2396|T70|2996:3 2321 2605",	-- Green Linen Shirt
	[5762] = "6686|T70|2996:4 2321 2604|5771",	-- Red Linen Bag
	[2997] = "2964|T75|2592:3",	-- Bolt of Woolen Cloth
	[10047] = "12046|T75|2996:4 2321",	-- Simple Kilt
	[2584] = "2402|T75|2997 2321",	-- Woolen Cape
	[4312] = "3845|T80|2996:5 2318:2 2321",	-- Soft-soled Linen Boots
	[4240] = "3757|T80|2997:3 2321",	-- Woolen Bag
	[4310] = "3843|T85|2997:3 2321",	-- Heavy Woolen Gloves
	[2582] = "2399|T85|2997:2 2321:2 2605",	-- Green Woolen Vest
	[5542] = "6521|T90|2997:3 2321:2 5498",	-- Pearl-clasped Cloak
	[4313] = "3847|T95|2997:4 2318:2 2321 2604:2|4345",	-- Red Woolen Boots
	[2583] = "2401|T95|2997:4 2321:2 2318:2",	-- Woolen Boots
	[4241] = "3758|T95|2997:4 2605 2321|4292",	-- Green Woolen Bag
	[6263] = "7639|T100|2997:4 2321:2 6260:2|6274",	-- Blue Overalls
	[4311] = "3844|T100|2997:3 2321:2 5498:2|4346",	-- Heavy Woolen Cloak
	[2587] = "2406|T100|2997:2 2321 4340",	-- Gray Woolen Shirt
	[2585] = "2403|T105|2997:4 2321:3 4340|2601",	-- Gray Woolen Robe
	[4316] = "3850|T110|2997:5 2321:4",	-- Heavy Woolen Pants
	[4314] = "3848|T110|2997:3 2321:2",	-- Double-stitched Woolen Shoulders
	[4330] = "3866|T110|2997:3 2604:2 2321",	-- Stylish Red Shirt
	[6787] = "8467|T110|2997:3 2324:4 2321",	-- White Woolen Dress
	[6264] = "7643|T115|2997:5 2321:3 2604:3|6275",	-- Greater Adept's Robe
	[4332] = "3869|T115|4305 4341 2321|14627",	-- Bright Yellow Shirt
	[5763] = "6688|T115|2997:4 2604 2321|5772",	-- Red Woolen Bag
	[10048] = "12047|T120|2997:5 2604:3 2321|10316",	-- Colorful Kilt
	[4315] = "3849|T120|2997:6 2319:2 2321:2|4347",	-- Reinforced Woolen Shoulders
	[6384] = "7892|T120|2997:4 6260:2 4340 2321|6390",	-- Stylish Blue Shirt
	[6385] = "7893|T120|2997:4 2605:2 4340 2321|6391",	-- Stylish Green Shirt
	[4320] = "3855|T125|4305:2 2319:4 3182:4 5500:2",	-- Spidersilk Boots
	[4331] = "3868|T125|2997:4 5500 2321:4 2324:2|4348",	-- Phoenix Gloves
	[4317] = "3851|T125|2997:6 5500 2321:3|4349",	-- Phoenix Pants
	[4305] = "3839|T125|4306:4",	-- Bolt of Silk Cloth
	[4318] = "3852|T130|2997:4 2321:3 3383",	-- Gloves of Meditation
	[4319] = "3854|T135|4305:3 4234:2 6260:2 2321:2|7114",	-- Azure Silk Gloves
	[5766] = "6690|T135|4305:2 2321:2 3182:2",	-- Lesser Wizard's Robe
	[7046] = "8758|T140|4305:4 6260:2 2321:3",	-- Azure Silk Pants
	[4321] = "3856|T140|4305:3 3182 2321:2|4350",	-- Spider Silk Slippers
	[7047] = "8780|T145|4305:3 4234:2 6048:2 2321:2|7092",	-- Hands of Darkness
	[7048] = "8760|T145|4305:2 6260:2 2321",	-- Azure Silk Hood
	[4324] = "3859|T150|4305:5 6260:4",	-- Azure Silk Vest
	[5770] = "6692|T150|4305:4 2321:2 3182:2|5773",	-- Robes of Arcana
	[7049] = "8782|T150|4305:3 4234:2 929:4 2321|7091",	-- Truefaith Gloves
	[4245] = "3813|T150|4305:3 4234:2 2321:3",	-- Small Silk Pack
	[4322] = "3857|T155|4305:3 2321:2 4337:2|14630",	-- Enchanter's Cowl
	[4333] = "3870|T155|4305:2 4340:2 2321|6401",	-- Dark Silk Shirt
	[7050] = "8762|T160|4305:3 2321:2",	-- Silk Headband
	[6795] = "8483|T160|4305:3 2324:2 4291",	-- White Swashbuckler's Shirt
	[7065] = "8784|T165|4305:5 2605:2 4291|7090",	-- Green Silk Armor
	[7051] = "8764|T170|4305:3 7067 2321:2",	-- Earthen Vest
	[4323] = "3858|T170|4305:4 4291 3824|4351",	-- Shadow Hood
	[4334] = "3871|T170|4305:3 2324:2 2321",	-- Formal White Shirt
	[7052] = "8766|T175|4305:4 7070 6260:2 2321:2 7071",	-- Azure Silk Belt
	[7053] = "8786|T175|4305:3 6260:2 2321:2|7089",	-- Azure Silk Cloak
	[4325] = "3860|T175|4305:4 4291 4337:2|4352",	-- Boots of the Enchanter
	[7055] = "8772|T175|4305:4 7071 2604:2 4291",	-- Crimson Silk Belt
	[4339] = "3865|T175|4338:5",	-- Bolt of Mageweave
	[5764] = "6693|T175|4305:4 4234:3 2321:3 2605|5774",	-- Green Silk Pack
	[6796] = "8489|T175|4305:3 2604:2 4291",	-- Red Swashbuckler's Shirt
	[7056] = "8789|T180|4305:5 2604:2 6371:2 4291|7087",	-- Crimson Silk Cloak
	[7057] = "8774|T180|4305:5 4291:2",	-- Green Silken Shoulders
	[4328] = "3863|T180|4305:4 4337:2 7071|4353",	-- Spider Belt
	[4336] = "3873|T180|4305:5 2325 4291|10728",	-- Black Swashbuckler's Shirt
	[4326] = "3861|T185|4305:4 3827 4291",	-- Long Silken Cloak
	[5765] = "6695|T185|4305:5 2325 2321:4|5775",	-- Black Silk Pack
	[7058] = "8791|T185|4305:4 2604:2 2321:2",	-- Crimson Silk Vest
	[4335] = "3872|T185|4305:4 4342 4291|4354",	-- Rich Purple Silk Shirt
	[7054] = "8770|T190|4339:2 7067:2 7070:2 7068:2 7069:2 4291:2",	-- Robe of Power
	[7060] = "8795|T190|4305:6 7072:2 6260:2 4291:2|7085",	-- Azure Shoulders
	[7059] = "8793|T190|4305:5 6371:2 2604:2 4291:2|7084",	-- Crimson Silk Shoulders
	[17723] = "21945|T190|4305:5 2605:4 4291|17724",	-- Green Holiday Shirt
	[7061] = "8797|T195|4305:5 7067:4 4234:4 7071 4291:2|7086",	-- Earthen Silk Belt
	[7062] = "8799|T195|4305:4 2604:2 4291:2",	-- Crimson Silk Pantaloons
	[10052] = "12064|T195|4339:2 6261:2 8343|10311",	-- Orange Martial Shirt
	[4327] = "3862|T200|4339:3 4291:2 3829 4337:2|4355",	-- Icy Cloak
	[4329] = "3864|T200|4339:4 4234:4 3864 7071 4291|4356",	-- Star Belt
	[9999] = "12049|T205|4339:2 4291:3",	-- Black Mageweave Leggings
	[9998] = "12048|T205|4339:2 4291:3",	-- Black Mageweave Vest
	[7063] = "8802|T205|4305:8 7068:4 3827:2 2604:4 4291|7088",	-- Crimson Silk Robe
	[10054] = "12075|T235|4339:2 4342:2 8343:2|10314",	-- Lavender Mageweave Shirt
	[10001] = "12050|T210|4339:3 8343",	-- Black Mageweave Robe
	[7064] = "8804|T210|4305:6 7068:2 6371:2 4304:2 2604:4 4291:2",	-- Crimson Silk Gloves
	[10002] = "12052|T210|4339:3 10285:2 8343",	-- Shadoweave Pants
	[10055] = "12080|T235|4339:3 10290 8343|10317",	-- Pink Mageweave Shirt
	[10003] = "12053|T215|4339:2 8343:2",	-- Black Mageweave Gloves
	[10009] = "12060|T215|4339:3 2604:2 8343|10302",	-- Red Mageweave Pants
	[10007] = "12056|T215|4339:3 2604:2 8343|10300",	-- Red Mageweave Vest
	[10004] = "12055|T215|4339:3 10285:2 8343",	-- Shadoweave Robe
	[10008] = "12059|T215|4339 2324 8343|10301",	-- White Bandit Mask
	[10056] = "12061|T215|4339 6261 8343",	-- Orange Mageweave Shirt
	[10034] = "12085|T240|4339:4 8343:2|10321",	-- Tuxedo Shirt
	[10035] = "12089|T245|4339:4 8343:3|10323",	-- Tuxedo Pants
	[10019] = "12067|T225|4339:4 8153:4 10286:2 8343:2",	-- Dreamweave Gloves
	[10021] = "12070|T225|4339:6 8153:6 10286:2 8343:2",	-- Dreamweave Vest
	[10030] = "12081|T225|4339:3 4589:6 8343:2|10318",	-- Admiral's Hat
	[10042] = "12069|T225|4339:5 7077:2 8343:2",	-- Cindercloth Robe
	[22246] = "27658|T225|4339:4 11137:4 8343:2|22307",	-- Enchanted Mageweave Pouch
	[10018] = "12066|T225|4339:3 2604:2 8343:2|10312",	-- Red Mageweave Gloves
	[10023] = "12071|T225|4339:5 10285:5 8343:2",	-- Shadoweave Gloves
	[10050] = "12065|T225|4339:4 4291:2",	-- Mageweave Bag
	[10040] = "12091|T250|4339:5 8343:3 2324|10325",	-- White Wedding Dress
	[10026] = "12073|T230|4339:3 8343:2 4304:2",	-- Black Mageweave Boots
	[10024] = "12072|T230|4339:3 8343:2",	-- Black Mageweave Headband
	[10027] = "12074|T230|4339:3 8343:2",	-- Black Mageweave Shoulders
	[10025] = "12086|T230|4339:2 10285:8 8343:2|10463",	-- Shadoweave Mask
	[10029] = "12078|T235|4339:4 2604:2 8343:3|10315",	-- Red Mageweave Shoulders
	[10028] = "12076|T235|4339:5 10285:4 8343:2",	-- Shadoweave Shoulders
	[10051] = "12079|T235|4339:4 2604:2 8343:2",	-- Red Mageweave Bag
	[10053] = "12077|T235|4339:3 2325 8343 2324",	-- Simple Black Dress
	[10036] = "12093|T250|4339:5 8343:3|10326",	-- Tuxedo Jacket
	[13868] = "18404|T240|14048:5 7079:2 14341|14467",	-- Frostweave Robe
	[10033] = "12084|T240|4339:4 2604:2 8343:2|10320",	-- Red Mageweave Headband
	[10031] = "12082|T240|4339:6 10285:6 8343:3 4304:2",	-- Shadoweave Boots
	[10044] = "12088|T245|4339:5 7077 8343:3 4304:2",	-- Cindercloth Boots
	[10041] = "12092|T250|4339:8 8153:4 10286:2 8343:3 6037 1529",	-- Dreamweave Circlet
	[14048] = "18401|T250|14047:5",	-- Bolt of Runecloth
	[21154] = "26403|T250|14048:4 4625:2 2604:2 14341|21722",	-- Festival Dress
	[67] = "26407|T250|14048:4 4625:2 2604:2 14341|21723||21542",	-- Festive Red Pant Suit
	[14342] = "18560|T250|14256:2|14526",	-- Mooncloth
	[13869] = "18403|T255|14048:5 7079:2 14341|14466",	-- Frostweave Tunic
	[13856] = "18402|T255|14048:3 14341",	-- Runecloth Belt
	[14042] = "18408|T260|14048:5 7077:2 14341|14471",	-- Cindercloth Vest
	[13858] = "18406|T260|14048:5 14227 14341|14469",	-- Runecloth Robe
	[13857] = "18407|T260|14048:5 14227 14341|14470",	-- Runecloth Tunic
	[21340] = "26085|T260|14048:6 8170:4 7972:2 14341|21358",	-- Soul Pouch
	[14046] = "18405|T260|14048:5 8170:2 14341|14468",	-- Runecloth Bag
	[13870] = "18411|T265|14048:3 7080 14341|14474",	-- Frostweave Gloves
	[14143] = "18410|T265|14048:3 9210:2 14227 14341|14473",	-- Ghostweave Belt
	[13860] = "18409|T265|14048:4 14227 14341|14472",	-- Runecloth Cloak
	[14101] = "18415|T270|14048:4 3577:2 14341|14479",	-- Brightcloth Gloves
	[14100] = "18414|T270|14048:5 3577:2 14341|14478",	-- Brightcloth Robe
	[14043] = "18412|T270|14048:4 7077:2 14341|14476",	-- Cindercloth Gloves
	[14142] = "18413|T270|14048:4 9210:2 14227 14341|14477",	-- Ghostweave Gloves
	[14134] = "18422|T275|14048:6 7078:4 7077:4 7068:4 14341|14486",	-- Cloak of Fire
	[14103] = "18420|T275|14048:4 3577:2 14341|14484",	-- Brightcloth Cloak
	[22251] = "27724|T275|14048:5 8831:10 11040:8 14341:2|22310",	-- Cenarion Herb Bag
	[14044] = "18418|T275|14048:5 7078 14341|14482",	-- Cindercloth Cloak
	[22248] = "27659|T275|14048:5 16203:2 14341:2|22308",	-- Enchanted Runecloth Bag
	[14107] = "18419|T275|14048:5 14256:2 14341|14483",	-- Felcloth Pants
	[14141] = "18416|T275|14048:6 9210:4 14227 14341|14480",	-- Ghostweave Vest
	[13863] = "18417|T275|14048:4 8170:4 14341|14481",	-- Runecloth Gloves
	[14132] = "18421|T275|14048:6 11176 14341|14485",	-- Wizardweave Leggings
	[21341] = "26086|T280|14256:12 12810:6 20520:2 14227:4",	-- Felcloth Bag
	[14045] = "18434|T280|14048:6 7078 14341|14490",	-- Cindercloth Pants
	[13871] = "18424|T280|14048:6 7080 14341|14489",	-- Frostweave Pants
	[13864] = "18423|T280|14048:4 14227:2 8170:4 14341|14488",	-- Runecloth Boots
	[14140] = "18452|T285|14048:4 14342:6 12800 12810:2 14341:2|14509",	-- Mooncloth Circlet
	[18486] = "22902|T285|14048:6 14342:4 13926:2 14341:2|18487",	-- Mooncloth Robe
	[14139] = "18448|T285|14048:5 14342:5 14341|14507",	-- Mooncloth Shoulders
	[14138] = "18447|T285|14048:6 14342:4 14341|14501",	-- Mooncloth Vest
	[14136] = "18436|T285|14048:10 14256:12 12808:4 7080:4 14341|14493",	-- Robe of Winter Night
	[14108] = "18437|T285|14048:6 14256:2 8170:4 14341|14492",	-- Felcloth Boots
	[13865] = "18438|T285|14048:6 14227:2 14341|14491",	-- Runecloth Pants
	[19056] = "23664|T290|14048:6 12810:4 13926:2 12809:2 14227:2|19216",	-- Argent Boots
	[15802] = "19435|T290|14048:6 14342:4 7971:2 14341",	-- Mooncloth Boots
	[14137] = "18440|T290|14048:6 14342:4 14341|14497",	-- Mooncloth Leggings
	[19047] = "23662|T290|14048:8 7076:3 12803:3 14227:2|19215",	-- Wisdom of the Timbermaw
	[14104] = "18439|T290|14048:6 3577:4 14227 14341|14494",	-- Brightcloth Pants
	[14111] = "18442|T290|14048:5 14256:2 14341|14496",	-- Felcloth Hood
	[14144] = "18441|T290|14048:6 9210:4 14341|14495",	-- Ghostweave Pants
	[13866] = "18444|T295|14048:4 14227:2 14341|14498",	-- Runecloth Headband
	[18405] = "22866|T300|14048:16 9210:10 14342:10 7080:12 7078:12 14344:6 14341:6|18414",	-- Belt of the Archmage
	[21342] = "26087|T300|14256:20 17012:16 19726:8 7078:4 14227:4|21371",	-- Core Felcloth Bag
	[16979] = "20849|T300|14048:8 17010:6 7078:4 12810:2 14341:2|17018",	-- Flarecore Gloves
	[19165] = "23667|T300|14342:8 17010:5 17011:3 7078:10 14227:4|19220",	-- Flarecore Leggings
	[16980] = "20848|T300|14048:12 17010:4 17011:4 12810:6 14341:2|17017",	-- Flarecore Mantle
	[19156] = "23666|T300|14342:10 17010:2 17011:3 7078:6 14227:4|19219",	-- Flarecore Robe
	[18263] = "22759|T300|14342:6 17010:8 7078:2 12810:6 14341:4|18265",	-- Flarecore Wraps
	[22658] = "28208|T300|22682:5 14048:4 7080:2 14227:4",	-- Glacial Cloak
	[22654] = "28205|T300|22682:5 14048:4 7080:4 14227:4",	-- Glacial Gloves
	[22652] = "28207|T300|22682:7 14048:8 7080:6 14227:8",	-- Glacial Vest
	[22655] = "28209|T300|22682:4 14048:2 7080:2 14227:4",	-- Glacial Wrists
	[14146] = "18454|T300|14048:10 14342:10 9210:10 13926:6 12364:6 12810:8 14341:2|14511",	-- Gloves of Spell Mastery
	[14152] = "18457|T300|14048:12 7078:10 7082:10 7076:10 7080:10 14341:2|14513",	-- Robe of the Archmage
	[14153] = "18458|T300|14048:12 12662:20 14256:40 7078:12 12808:12 14341:2|14514",	-- Robe of the Void
	[14154] = "18456|T300|14048:12 14342:10 12811:4 13926:4 9210:10 14341:2|14512",	-- Truefaith Vestments
	[19059] = "23665|T300|14342:5 12809:2 14227:2|19217",	-- Argent Shoulders
	[19684] = "24093|T300|14342:3 19726:3 12810:4 14048:4 14227:4|19766",	-- Bloodvine Boots
	[19683] = "24092|T300|14342:4 19726:4 12804:4 14048:4 14227:2|19765",	-- Bloodvine Leggings
	[19682] = "24091|T300|14342:3 19726:5 12804:4 14048:4 14227:2|19764",	-- Bloodvine Vest
	[14156] = "18455|T300|14048:8 14342:12 14344:2 17012:2 14341:2|14510",	-- Bottomless Bag
	[18413] = "22870|T300|14048:12 12809:4 12360 14341:2|18418",	-- Cloak of Warding
	[18407] = "22867|T300|14048:12 14256:20 12662:6 12808:8 14341:2|18415",	-- Felcloth Gloves
	[22660] = "28210|T300|19726 14342:2 12803:4 14227:4|22683",	-- Gaea's Embrace
	[18408] = "22868|T300|14048:12 7078:10 7910:2 14341:2|18416",	-- Inferno Gloves
	[19050] = "23663|T300|14342:5 7076:5 12803:5 14227:2|19218",	-- Mantle of the Timbermaw
	[18409] = "22869|T300|14048:12 14342:6 13926:2 14341:2|18417",	-- Mooncloth Gloves
	[20539] = "24902|T300|14048:2 20520:6 14256:2 12810:2 14227:2|20548",	-- Runed Stygian Belt
	[20537] = "24903|T300|14048:4 20520:6 14256:4 12810:2 14227:2|20547",	-- Runed Stygian Boots
	[20538] = "24901|T300|14048:6 20520:8 14256:6 14227:2|20546",	-- Runed Stygian Leggings
	[22757] = "28481|T300|14048:4 14342:2 12803:2 14227:2|22773",	-- Sylvan Crown
	[22758] = "28482|T300|14048:2 12803:4 14227:2|22772",	-- Sylvan Shoulders
	[22756] = "28480|T300|14048:4 19726:2 12803:2 14227:2|22774",	-- Sylvan Vest
	[22249] = "27660|T300|14048:6 14344:4 12810:4 14227:4|22309",	-- Big Bag of Enchantment
	[14106] = "18451|T300|14048:8 14256:3 12662:2 14341:2|14506",	-- Felcloth Robe
	[14112] = "18453|T300|14048:7 14256:3 12662:2 8170:4 14341:2|14508",	-- Felcloth Shoulders
	[68] = "22815|L300|8170:4 14048:2 18240 14341|||18258",	-- Gordok Ogre Suit
	[69] = "22813|T300|14048:2 8170:4 18240 14341|||18258",	-- Gordok Ogre Suit
	[14155] = "18445|T300|14048:4 14342 14341|14499",	-- Mooncloth Bag
	[13867] = "18449|T300|14048:7 14227:2 8170:4 14341|14504",	-- Runecloth Shoulders
	[22252] = "27725|T300|14048:6 14342:2 13468 14227:4|22312",	-- Satchel of Cenarius
	[14128] = "18446|T300|14048:8 11176:2 14341|14500",	-- Wizardweave Robe
	[14130] = "18450|T300|14048:6 11176:4 7910 14341|14505",	-- Wizardweave Turban
	[21840] = "26745|T300|21877:6",	-- Bolt of Netherweave
	[24268] = "31460|T300|21877:3||2",	-- Netherweave Net
	[21850] = "26765|T310|21840:3 14341",	-- Netherweave Belt
	[21849] = "26764|T310|21840:3 14341",	-- Netherweave Bracers
	[21841] = "26746|T315|21840:4 14341",	-- Netherweave Bag
	[21851] = "26770|T320|21840:4 21887:2 14341",	-- Netherweave Gloves
	[21842] = "26747|T325|21840:3 22445:2|21892",	-- Bolt of Imbued Netherweave
	[21852] = "26771|T325|21840:6 14341",	-- Netherweave Pants
--	[24269] = "31461|T325|21877:6|24315|2",	-- Heavy Netherweave Net; Removed during TBC beta
	[24273] = "31430|T335|14341 22457:5|24292",	-- Mystic Spellthread
	[24275] = "31431|T335|14341 21886:5|24293",	-- Silver Spellthread
	[21853] = "26772|T335|21840:6 21887:2 14341",	-- Netherweave Boots
	[21859] = "26775|T340|21842:5 21881:2 14341|21898",	-- Imbued Netherweave Pants
	[24270] = "31459|T340|21842:6 21887:4|24314",	-- Bag of Jewels
	[21843] = "26749|T340|21842:4 21881:2 22446|21893",	-- Imbued Netherweave Bag
	[21854] = "26773|T340|21840:8 14341:2|21896",	-- Netherweave Robe
	[21855] = "26774|T345|21840:8 14341:2|21897",	-- Netherweave Tunic
	[21844] = "26750|T345|21840 21882:8|21894",	-- Bolt of Soulcloth
	[21866] = "26782|T350|21840:6 22445:12 14341:2|21905",	-- Arcanoweave Bracers
	[24251] = "31437|T350|21842:4 21884:8|24298",	-- Blackstrike Bracers
	[24250] = "31435|T350|21842:4 22452:4 22456:4|24297",	-- Bracers of Havok
	[30831] = "37873|T350|21842:4 22457:3 21886:3 21881:2|30833",	-- Cloak of Arcane Evasion
	[24253] = "31440|T350|21842:6 22452:6|24300",	-- Cloak of Eternity
	[24252] = "31438|T350|21842:6 22457:3 22456:3|24299",	-- Cloak of the Black Void
	[30837] = "37882|T350|21840:5 21884:5 14341:2|30842",	-- Flameheart Bracers
	[21860] = "26776|T350|21842:4 21887:6 21881:2 14341|21899",	-- Imbued Netherweave Boots
	[21845] = "26751|T350|21842 21886 21885|21895",	-- Primal Mooncloth
	[24272] = "36686|T350|21842 22456 21884|30483",	-- Shadowcloth
	[24271] = "31373|T350|21842 22457 21884|24316",	-- Spellcloth
	[24249] = "31434|T350|21842:4 22452:8|24296",	-- Unyielding Bracers -- also 35308
	[24254] = "31441|T350|21842:6 21886:6|24301",	-- White Remedy Cape
	[21863] = "26779|T355|21844:5 21887:6 14341:4|21902",	-- Soulcloth Gloves
	[21867] = "26783|T360|21840:8 22445:16 14341:2|21906",	-- Arcanoweave Boots
	[30838] = "37883|T360|21840:7 21884:7 14341:2|30843",	-- Flameheart Gloves
	[21861] = "26777|T360|21842:6 21881:2 14341|21900",	-- Imbued Netherweave Robe
	[21862] = "26778|T360|21842:6 21881:2 14341|21901",	-- Imbued Netherweave Tunic
	[24257] = "31444|T365|21842:6 22457:14 23572|24304",	-- Black Belt of Knowledge
	[24256] = "31443|T365|24272:10 21884:16 23572|24303",	-- Girdle of Ruination
	[24260] = "31450|T365|24271:10 22457:12 23572|24307",	-- Manaweave Cloak
	[24258] = "31448|T365|21845:10 22452:12 23572|24305",	-- Resolute Cape
	[21864] = "26780|T365|21844:6 14341:4|21903",	-- Soulcloth Shoulders
	[24255] = "31442|T365|21845:8 22452:16 23572|24302",	-- Unyielding Girdle -- also 35309
	[24259] = "31449|T365|24272:10 22451:14 23572|24306",	-- Vengeance Wrap
	[21868] = "26784|T370|21840:12 22445:20 14341:2|21907",	-- Arcanoweave Robe
	[30839] = "37884|T370|21840:9 21884:9 14341:2|30844",	-- Flameheart Vest
	[24267] = "31456|T375|21842:12 23571:8 23572|24313",	-- Battlecast Hood
	[24263] = "31453|T375|21842:12 23571:8 23572|24310",	-- Battlecast Pants
	[24276] = "31433|T375|14341 21886:10 23572|24295",	-- Golden Spellthread
	[24274] = "31432|T375|14341 22457:10 23572|24294",	-- Runic Spellthread
	[21865] = "26781|T375|21844:8 14341:4|21904",	-- Soulcloth Vest
	[24266] = "31455|T375|24271:10 23571:5 23572|24312",	-- Spellstrike Hood
	[24262] = "31452|T375|24271:10 23571:5 23572|24309",	-- Spellstrike Pants
	[32585] = "41208|T375|21842:4 21845:2 21886:6 32428:2|32753",	-- Swiftheal Mantle -- also 35525
	[32584] = "41207|T375|21842:3 21845:4 21886:8 32428:4|32752",	-- Swiftheal Wraps -- also 35526
	[24264] = "31454|T375|21845:10 23571:5 23572|24311",	-- Whitemend Hood
	[24261] = "31451|T375|21845:10 23571:5 23572|24308",	-- Whitemend Pants
	[21872] = "26759|T375|24272:6 21881:4|21915",	-- Ebon Shadowbag
	[21876] = "26763|T375|21845:8 21881:4|21919",	-- Primal Mooncloth Bag
	[21858] = "26755|T375|24271:6 22446:4 21881:4|21911",	-- Spellfire Bag
	[30463] = "36670|T375|21840:6 21887:4 21885:3 21886:3 21881:2",	-- Lifeblood Belt
	[30464] = "36672|T375|21840:4 21887:4 21885:2 21886:2 21881:2",	-- Lifeblood Bracers
	[30465] = "36669|T375|21840:10 21885:5 21886:5 21881:2",	-- Lifeblood Leggings
	[30460] = "36667|T375|21840:6 21887:4 21884:3 22456:4 21881:2",	-- Netherflame Belt
	[30461] = "36668|T375|21840:6 21887:4 21884:2 22456:6 21881:2",	-- Netherflame Boots
	[30459] = "36665|T375|21840:10 21884:5 22456:6 21881:2",	-- Netherflame Robe
	[21873] = "26760|Tm355|21845:4 21881:2 21886:8|21916",	-- Primal Mooncloth Belt
	[21874] = "26761|Tm365|21845:8 21881:2 21886:8|21918",	-- Primal Mooncloth Shoulders
	[21875] = "26762|Tm375|21845:14 22457:12 21881:4|21917",	-- Primal Mooncloth Robe
	[21869] = "26756|Ts355|24272:4 21885:10 21881:2|21912",	-- Frozen Shadoweave Shoulders
	[21870] = "26757|Ts365|24272:8 21885:12 21881:2|21914",	-- Frozen Shadoweave Boots
	[21871] = "26758|Ts375|24272:14 21885:16 21881:4|21913",	-- Frozen Shadoweave Robe
	[21846] = "26752|Tp355|24271:4 21884:10 21881:2|21908",	-- Spellfire Belt
	[21847] = "26753|Tp365|24271:8 21884:12 21881:4|21909",	-- Spellfire Gloves
	[21848] = "26754|Tp375|24271:14 21884:16 21881:4|21910",	-- Spellfire Robe
    [30038] = '36315|T375|30183:2 21842:4 21884:15 14341:2|30280', --Belt of Blasting
    [30036] = '36316|T375|30183:2 21842:4 21886:10 14341:2 21885:10|30281', --Belt of the Long Road
    [30037] = '36317|T375|23572:2 24272:4 24271:4 14341:2|30282', --Boots of Blasting
    [30035] = '36318|T375|23572:2 21845:2 24271:4 14341:2|30283', -- Boots of the Long Road
    [32587] = '41206|T375|21842:4 24271:2 22457:6 32428:2|32755', -- Mantle of Nimble Thought -- also rid 35522****
    [32586] = '41205|T375|21842:3 24271:4 22457:8 32428:4|32754', --Bracers of Nimble Thought - also rid35518*******
    [32420] = '40060|T375|32428:1 22450:1 21886:2 22456:2 21842:1|32447', --Night's End
    [32392] = '40021|T375|32428:1 22450:1 21886:2 22456:2 21842:1|32438', --Soulguard Bracers
    [32390] = '40024|T375|32428:2 22450:1 21886:3 22456:4 21842:1|32440', --Soulguard Girdle
    [32389] = '40023|T375|32428:3 22450:1 21886:4 22456:6 21842:2|32439', --Soulguard Leggings
    [32391] = '40020|T375|32428:2 22450:1 21886:2 22456:4 21842:1|32437', --Soulguard Slippers
    [34087] = "44950|T250|14048:8 2997 2605:2 14341|34261", -- Green Winter Clothes
    [34085] = "44958|T250|14048:8 2997 2604:2 14341|34319", -- Red Winter Clothes
--[[ poisons --]]
	[6947] = '8681|Z1|2928 3371',	-- Instant Poison
	[3775] = '3420|Z1|2930 3371',	-- Crippling Poison
	[5237] = '5763|Z100|2928 2930 3371',	-- Mind-numbing Poison
	[6949] = '8687|Z120|2928:3 3372',	-- Instant Poison II
	[2892] = '2835|Z130|5173 3372',	-- Deadly Poison
	[10918] = '13220|Z140|2930 5173 3372',	-- Wound Poison
--	[5530] = '6510|Z150|3818||3',	-- Blinding Powder
	[6950] = '8691|Z160|8924 3372',	-- Instant Poison III
	[2893] = '2837|Z170|5173:2 3372',	-- Deadly Poison II
	[6951] = '8694|Z170|2928:4 2930:4 3372',	-- Mind-numbing Poison II
	[10920] = '13228|Z180|2930 5173:2 3372',	-- Wound Poison II
	[8926] = '11341|Z200|8924:2 8925',	-- Instant Poison IV
	[8984] = '11357|Z210|5173:3 8925',	-- Deadly Poison III
	[10921] = '13229|Z220|8923 5173:2 8925',	-- Wound Poison III
	[3776] = '3421|Z230|8923:3 8925',	-- Crippling Poison II
	[8927] = '11342|Z240|8924:3 8925',	-- Instant Poison V
	[9186] = '11400|Z240|8924:2 8923:2 8925',	-- Mind-numbing Poison III
	[8985] = '11358|Z250|5173:5 8925',	-- Deadly Poison IV
	[10922] = '13230|Z260|8923:2 5173:2 8925',	-- Wound Poison IV
	[8928] = '11343|Z280|8924:4 8925',	-- Instant Poison VI
	[20844] = '25347|Z300|5173:7 8925|21302',	-- Deadly Poison V
	[21835] = '26786|Z340|3777:4 5173 8925',	-- Anesthetic Poison
	[21927] = '26892|Z340|2931 8924 8925',	-- Instant Poison VII
	[22053] = '26969|Z310|2931 8925',	-- Deadly Poison VI
	[22054] = '27282|Z350|2931 5173 8925',	-- Deadly Poison VII
	[22055] = '27283|Z320|8923:3 5173:3 8925',	-- Wound Poison V
--~ --[[ New in 2.4 --]]
    [34360] = '46126|J365|23449:4 32228:2 31079:4|35205', -- Amulet of Flowing Life - also recipe 35533
    [34361] = "46124|J365|35128:2 31079:4 34464:5|35200", -- Hard Khorium Band
    [34358] = "46127|J365|35128:2 23572:2 31079:4|35203", -- Hard Khorium Choker - also 35535
    [34359] = "46125|J365|23449:4 32227:2 31079:4|35201", -- Pendant of Sunfire - also 35537
    [34362] = "46122|J365|23449:4 23571 31079:4 34664:5|35198", -- Loop of Forged Power
    [34363] = "46123|J365|23449:4 23447:4 31079:4 34664:5|35199", -- Ring of Flowing Life - also 35538
    [34369] = "46138|L365|23793:8 22456:6 23572:3 14341:4|35218", -- Carapace of Sun and Shadow - also 35539
    [34373] = "46137|L365|23793:8 21884:6 23572:3 14341:4|35217", -- Embrace of the Phoenix
    [34374] = "46133|L365|23793:6 21884:4 34664:6 14341:2|35213", -- Fletcher's Gloves of the Phoenix - also 35541
    [34370] = "46134|L365|23793:6 22456:4 34664:6 14341:2|35214", -- Gloves of Immortal Dusk
    [34367] = "46129|T365|21845:6 34664:6 14341:6|35205", -- Hands of Eternal Light -- also 35544
    [34371] = "46136|L365|23793:8 21884:6 23572:3 14341:4|35216", -- Leather Chestguard of the Sun -- also 35545
    [34372] = "46132|L365|23793:6 21884:4 34664:6 14341:2|35212", -- Leather Gauntlets of the Sun -- also 35546
    [34365] = "46131|T365|21845:12 21886:4 21885:4 14341:4|35207", -- Robe of Eternal Light -- also 35548
    [34375] = "46139|L365|29547:15 22451:6 23572:3 14341:4|35219", -- Sun-Drenched Scale Chestguard
    [34376] = "46135|L365|29547:8 22451:4 34664:6 14341:2|35215", -- Sun-Drenched Scale Gloves -- also 35550
    [34366] = "46128|T365|24271:6 34664:6 14341:6|35204", -- Sunfire Handwraps -- also 35551
    [34364] = "46130|T365|24271:12 21884:4 22456:4 14341:4|35206", -- Sunfire Robe
    [34378] = "46141|B365|35128:2 34664:6|35209", -- Hard Khorium Battlefists --also 35553
    [34377] = "46144|B365|35128:6 23572:4|35211", -- Hard Khorium Battleplate
    [34379] = "46142|B365|23573:4 21886:10 23572:4|35210", -- Sunblessed Breastplate
    [34380] = "46140|B365|23573:2 21886:6 34664:6|35208", -- Sunblessed Gauntlets
    [34847] = "46111|E375|32494 22456:4 23572:4|35186", -- Annihilator Holo-Gogs (Requires Mage, Priest, Warlock)
    [34357] = "46115|E375|32473 35128:2 23572:4|35196", -- Hard Khorium Goggles (Requires Paladin, Warrior)
    [35182] = "46109|E375|32480 21885:4 23572:4|35190", -- Hyper-Magnified Moon Specs (Requires Druid)
    [35185] = "46107|E375|32472 35128:2 23572:4|35187", -- Justicebringer 3000 Specs (Requires Paladin)
    [34355] = "46112|E375|32476 22457:4 23572:4|35193", -- Lightning Etched Specs (Requires Shaman)
    [34354] = "46114|E375|32461 22451:4 23572:4|35195", -- Mayhem Projection Goggles (Requires Warrior, Paladin)
    [35181] = "46108|E375|32495 21885:4 23572:4|35189", -- Powerheal 9000 Lens (Requires Priest)
    [35184] = "46110|E375|32475 22457:4 23572:4|35192", -- Primal-Attuned Goggles (Requires Shaman)
    [34353] = "46116|E375|32478 22456:4 23572:4|35197", -- Quad Deathblow X44 Goggles (Requires Rogue, Druid)
    [34356] = "46113|E375|32474 22451:4 23572:4|35194", -- Surestrike Goggles v3.0 (Requires Hunter, Shaman)
    [35183] = "46106|E375|32479 21885:4 23572:4|35191", -- Wonderheal XT68 Shades (Requires Druid)
    [34832] = "45695|W100|2596 2594|34834|5", -- Captain Rumsey's Lager
    [35503] = "46601|J370|25868|35505", -- Ember Skyfire Diamond, requires Shattered Sun Offensive Revered
    [35501] = "46597|J370|25867|35502", -- Eternal Earthstorm Diamond, Requires Shattered Sun Offesnive Revered
    [-45765] = "D360|22450|34872|2|22449", -- Void Shatter, Requires Shattered Sun Offensive Honored
    [35563] = "46684|W250|35562|35564", -- Charred Bear Kabobs
    [35565] = "46688|W250|35562|35566", -- Juicy Bear Burger
   	[35128] = "46353|Y375|23449:3 23573|35273",	-- Smelt Hardened Khorium
    [35759] = "47053|J375|32249|35769", --Forceful Seaspray Emerald
    [35761] = "47056|J375|32229|35768", -- Quick Lionseye
    [35760] = "47055|J375|32231|35767", -- Reckless Pyrestone
    [35758] = "47054|J375|32249|35766", -- Steady Seaspray Emerald
    [35581] = "46697|E355|21840:8 23786:2 23785:2 23787:4|35582", -- Rocket Boots Xtreme Lite
    [35700] = "46777|J375|23447:8 32227:2 21884:8|35697", -- Figurine - Crimson Serpent
    [35693] = "46775|J375|23449:8 32228:2 23440:6|35696", -- Figurine - Empyrean Tortoise
    [35694] = "46776|J375|23449:8 32231:2 22452:8|35696", -- Figurine - Khorium Boar
    [35703] = "46779|J375|23447:8 32249:2 22457:8|35699", -- Figurine - Seaspray Albatross
    [35702] = "46778|J375|23573:4 32230:2 22456:8|35698", -- Figurine - Shadowsong Panther
    [35707] = "46803|J375|23441|35708", -- Regal Nightseye
    [-46594] = "D360|22446:4 22445:8 23427:4|35500", -- Enchant Chest - Defense
    [35751] = "47050|A375|13503 22456:6 30183:2|35755", -- Assassin's Alchemist Stone
    [35748] = "47046|A375|13503 22451:6 30183:2|35752", -- Guardian's Alchemist Stone
    [35750] = "47049|A375|13503 21886:6 30183:2|35754", -- Redeemer's Alchemist Stone
    [35749] = "47048|A375|13503 21884:6 30183:2|35753", -- Sorcerer's Alchemist Stone
    [-47051] = "D375|22446:8 22452:8|35756", -- Enchant Cloak - Steelweave
    [35319] = "46405|J350|23437|35325", --Forceful Talasite
    [35315] = "46403|J350|23440|35322", --Quick Dawnstone
    [35316] = "46404|J350|23439|35323", --Reckless Noble Topaz
    }

TradeskillInfo.vars.components = {
	[2454] = "狮王之力药剂/20/Ca",
	[5997] = "初级防御药剂/5/Ca",
	[118] = "初级治疗药水/5/Ca",
	[3382] = "弱效巨魔之血药水/10/Ca",
	[2455] = "初级法力药水/10/Ca",
	[2456] = "初级活力药水/15/Ca",
	[4596] = "褪色治疗药水/25/Ca",
	[2457] = "初级敏捷药剂/15/Ca",
	[2458] = "初级坚韧药剂/15/Ca",
	[858] = "次级治疗药水/25/Ca",
	[5631] = "怒气药水/30/Ca",
	[2459] = "迅捷药水/25/Ca",
	[6370] = "黑口鱼油/10/Ca",
	[6662] = "增长药剂/95/Ca",
	[5996] = "水下呼吸药剂/95/Ca",
	[3383] = "智慧药剂/100/Ca",
	[6051] = "神圣防护药水/62/Ca",
	[6372] = "速游药水/35/Ca",
	[929] = "治疗药水/75/Ca",
	[3384] = "初级抗魔药水/20/Ca",
	[3385] = "次级法力药水/30/Ca",
	[1] = "抗毒药剂/0/Ca",
	[3386] = "抗毒药剂/35/Ca",
	[3388] = "强力巨魔之血药水/40/Ca",
	[3389] = "防御药剂/40/Ca",
	[6371] = "火焰之油/12/Ca",
	[6048] = "暗影防护药水/100/Ca",
	[6373] = "火力药剂/35/Ca",
	[3390] = "次级敏捷药剂/35/Ca",
	[3391] = "食人魔力量药剂/20/Ca",
	[5634] = "自由行动药剂/75/Ca",
	[1710] = "强效治疗药水/125/Ca",
	[3827] = "法力药水/120/Ca",
	[3824] = "暗影之油/150/Ca",
	[6049] = "火焰防护药水/170/Ca",
	[3823] = "次级隐形药水/100/Ca",
	[3826] = "超强巨魔之血药水/105/Ca",
	[3825] = "坚韧药剂/110/Ca",
	[5633] = "暴怒药水/150/Ca",
	[8949] = "敏捷药剂/200/Ca",
	[17708] = "冰霜之力药剂/35/Ca",
	[3829] = "冰霜之油/150/Ca",
	[6050] = "冰霜防护药水/300/Ca",
	[6052] = "自然防护药水/300/Ca",
	[3828] = "侦测次级隐形药剂/150/Ca",
	[8951] = "强效防御药剂/200/Ca",
	[9061] = "地精火箭燃油/250/Ca",
	[10592] = "猫眼药剂/150/Ca",
	[6149] = "强效法力药水/120/Ca",
	[8956] = "献祭之油/200/Ca",
	[2] = "转化：转铁成金/0/Ca",
	[3577] = "金锭/600/Cs",
	[3] = "转化秘银/0/Ca",
	[6037] = "真银锭/1250/Cs",
	[9036] = "抗魔药水/20/Ca",
	[9149] = "点金石/250/Ca",
	[18294] = "强力水下呼吸药剂/250/Ca",
	[4623] = "次级石盾药水/375/Ca",
	[3928] = "优质治疗药水/250/Ca",
	[9144] = "野葡萄药水/250/Ca",
	[9030] = "滋补药剂/250/Ca", -- Restorative Potion, added 8/7/2007
	[12190] = "昏睡药水/250/Ca",
	[9154] = "侦测亡灵药剂/300/Ca",
	[9210] = "幻象染料/750/Ca",
	[9155] = "奥法药剂/400/Ca",
	[9179] = "强效聪颖药剂/1000/Ca",
	[9264] = "暗影之力药剂/35/Ca",
	[9172] = "隐形药水/500/Ca",
	[9197] = "梦境药剂/600/Ca",
	[9187] = "强效敏捷药剂/600/Ca",
	[9088] = "阿尔萨斯的礼物/250/Ca",
	[9206] = "巨人药剂/700/Ca",
	[9224] = "屠魔药剂/700/Ca",
	[9233] = "侦测恶魔药剂/500/Ca",
	[21546] = "强效火力药剂/35/Ca",
	[3387] = "有限无敌药水/30/Ca",
	[13423] = "石鳞鱼油/125/Ca",
	[13442] = "强效怒气药水/500/Ca",
	[13443] = "优质法力药水/400/Ca",
	[13445] = "超强防御药剂/500/Ca",
	[13447] = "先知药剂/1250/Ca",
	[4] = "转化：点气成火/0/Ca",
	[7078] = "火焰精华/400/D",
	[5] = "转化：奥金/0/Ca",
	[12360] = "奥金锭/5000/Ca",
	[6] = "转化：土转生命/0/Ca",
	[12803] = "生命精华/500/D",
	[7] = "转化：转土成水/0/Ca",
	[7080] = "水之精华/400/D",
	[8] = "转化：点火成土/0/Ca",
	[7076] = "大地精华/400/D",
	[9] = "转化：生命归土/0/Ca",
	[10] = "转化：死灵化水/0/Ca",
	[11] = "转化：点水成气/0/Ca",
	[7082] = "空气精华/400/D",
	[12] = "转化：水转死灵/0/Ca",
	[12808] = "死灵精华/1000/D",
	[13453] = "蛮力药剂/1250/Ca",
	[20002] = "强效昏睡药水/1000/Ca",
	[20007] = "魔血药水/1000/Ca",
	[13446] = "特效治疗药水/1000/Ca",
	[13452] = "猫鼬药剂/1250/Ca",
	[13455] = "强效石盾药水/750/Ca",
	[13454] = "强效奥法药剂/750/Ca",
	[20008] = "活力行动药水/600/Ca",
	[13462] = "净化药水/750/Ca",
	[9030] = "滋补药剂/200/Ca",
	[13461] = "强效奥术防护药水/750/Ca",
	[13457] = "强效火焰防护药水/750/Ca",
	[13456] = "强效冰霜防护药水/750/Ca",
	[13458] = "强效自然防护药水/750/Ca",
	[13459] = "强效暗影防护药水/100/Ca",
	[20004] = "特效巨魔之血药水/1000/Ca",
	[13444] = "特效法力药水/1500/Ca",
	[19931] = "古拉巴什疯狂魔精/0/Ca",
	[28103] = "法能药剂/2500/Ca",
	[13513] = "多重抗性合剂/5000/Ca",
	[13511] = "精炼智慧合剂/5000/Ca",
	[13506] = "石化合剂/5000/Ca",
	[13512] = "超级能量合剂/5000/Ca",
	[13510] = "泰坦合剂/5000/Ca",
	[18253] = "特效活力药水/15/Ca",
	[28102] = "强攻药剂/2500/Ca",
	[13] = "转化：元素火焰/0/Ca",
	[7068] = "元素火焰/400/D",
	[28100] = "强烈治疗药水/1000/Ca",
	[22823] = "伪装药剂/2500/Ca",
	[22824] = "特效力量药剂/2500/Ca",
	[22825] = "治疗能量药剂/2500/Ca",
	[32062] = "特效坚韧药剂/0/Ca",
	[28101] = "不稳定的法力药剂/1500/Ca",
	[28104] = "掌控药剂/2500/Ca",
	[22826] = "潜行药水/2500/Ca",
	[32063] = "土灵药剂/0/Ca",
	[32067] = "德莱尼智慧药剂/0/Ca",
	[22827] = "特效冰霜能量药剂/2500/Ca",
	[22828] = "疯狂力量药水/2500/Ca",
	[31080] = "水银石/4000/Ca",
	[22830] = "搜寻之眼药剂/4000/Ca",
	[22829] = "超级治疗药水/5000/Ca",
	[32068] = "铁皮药剂/0/Ca",
	[22831] = "特效敏捷药剂/4000/Ca",
	[31679] = "魔能力量药剂/3000/Ca",
	[22871] = "遮罩药水/5000/Ca",
	[22832] = "超级法力药水/5000/Ca",
	[22834] = "特效防御药剂/4000/Ca",
	[22833] = "特效火力药剂/2500/Ca",
	[31676] = "魔能回复药水/5000/Ca",
	[13503] = "炼金石/25000/Ca",
	[14] = "转化：大地风暴钻石/0/Ca",
	[25867] = "大地风暴钻石/30000/Ca",
	[15] = "转化：源生之能/0/Ca",
	[23571] = "源生之能/16000/Ca",
	[16] = "转化：天火钻石/0/Ca",
	[25868] = "天火钻石/30000/Ca",
	[17] = "转化：源生空气至源生火焰/0/Ca",
	[21884] = "源生火焰/4000/C",
	[18] = "转化：源生之土至源生之水/0/Ca",
	[21885] = "源生之水/4000/C",
	[19] = "转化：源生火焰至源生之土/0/Ca",
	[22452] = "源生之土/4000/C",
	[20] = "转化：源生之水至源生空气/0/Ca",
	[22451] = "源生空气/4000/C",
	[22839] = "毁灭药水/5000/Ca",
	[22835] = "特效暗影能量药剂/6000/Ca",
	[22838] = "加速药水/5000/Ca",
	[22837] = "英雄药水/5000/Ca",
	[22836] = "特效无梦睡眠药水/5000/Ca",
	[22840] = "特效魔血药剂/6000/Ca",
	[31677] = "魔能法力药水/5000/Ca",
	[21] = "盲目光芒合剂/0/Ca",
	[22861] = "盲目光芒合剂/20000/Ca",
	[22851] = "强固合剂/20000/Ca",
	[22853] = "强效回复合剂/20000/Ca",
	[22] = "纯粹死亡合剂/0/Ca",
	[22866] = "纯粹死亡合剂/20000/Ca",
	[22854] = "无情突袭合剂/20000/Ca",
	[22845] = "特效奥术防护药水/6000/Ca",
	[22841] = "特效火焰防护药水/6000/Ca",
	[22842] = "特效冰霜防护药水/6000/Ca",
	[22847] = "特效神圣防护药水/6000/Ca",
	[22844] = "特效自然防护药水/6000/Ca",
	[22846] = "特效暗影防护药水/6000/Ca",
	[22850] = "超级活力药水/7000/Ca",
	[22848] = "强化药剂/7000/Ca",
	[22849] = "铁盾药水/7000/Ca",
	[23] = "转化：源生之土至源生生命/0/Ca",
	[21886] = "源生生命/4000/C",
	[24] = "转化：源生火焰至源生法力/0/Ca",
	[22457] = "源生法力/4000/C",
	[25] = "转化：源生生命至源生之土/0/Ca",
	[26] = "转化：源生法力至源生火焰/0/Ca",
	[27] = "转化：源生暗影至源生之水/0/Ca",
	[28] = "转化：源生之水至源生暗影/0/Ca",
	[22456] = "源生暗影/4000/C",
	[32839] = "特效奥术防护药锅/0/Ca",
	[32849] = "特效火焰防护药锅/0/Ca",
	[32850] = "特效冰霜防护药锅/0/Ca",
	[32851] = "特效自然防护药锅/0/Ca",
	[32852] = "特效暗影防护药锅/0/Ca",
	[2853] = "铜质护腕/17/Cb",
	[2852] = "铜质链甲短裤/67/Cb",
	[10421] = "劣质铜外衣/32/Cb",
	[2862] = "劣质磨刀石/3/Cb",
	[3239] = "劣质平衡石/3/Cb",
	[2844] = "铜质钉锤/106/Cb",
	[2845] = "铜斧/109/Cb",
	[3469] = "铜质链甲战靴/49/Cb",
	[2847] = "铜质短剑/110/Cb",
	[3470] = "劣质砂轮/5/Cb",
	[7955] = "铜质双刃刀/241/Cb",
	[7166] = "铜质匕首/194/Cb",
	[3488] = "铜质战斧/613/Cb",
	[3471] = "铜质链甲外衣/142/Cb",
	[2851] = "铜质链甲腰带/56/Cb",
	[3472] = "铜质符文护手/71/Cb",
	[3473] = "铜质符文短裤/299/Cb",
	[3474] = "铜质宝石手套/216/Cb",
	[2863] = "粗制磨刀石/10/Cb",
	[3240] = "粗制平衡石/10/Cb",
	[6214] = "铜质大锤/595/Cb",
	[3489] = "厚重的战斧/937/Cb",
	[2857] = "铜质符文腰带/198/Cb",
	[3478] = "粗制砂轮/10/Cb",
	[2864] = "铜质符文胸甲/630/Cb",
	[2854] = "铜质符文护腕/225/Cb",
	[3487] = "铜质重剑/1498/Cb",
	[6350] = "劣质青铜战靴/295/Cb",
	[6731] = "铁炉堡胸甲/871/Cb",
	[15869] = "白银万能钥匙/50/Cb",
	[29201] = "厚重青铜飞镖/150/Cb",
	[6338] = "银棒/125/Cb",
	[3848] = "青铜匕首/1426/Cb",
	[2865] = "劣质青铜护腿/962/Cb",
	[2866] = "劣质青铜胸甲/752/Cb",
	[2848] = "青铜钉锤/1119/Cb",
	[3480] = "劣质青铜护肩/532/Cb",
	[5540] = "珍珠匕首/2107/Cb",
	[2849] = "青铜斧/1269/Cb",
	[2868] = "青铜花纹护腕/807/Cb",
	[2850] = "青铜短剑/1439/Cb",
	[3490] = "致命的青铜短剑/2731/Cb",
	[3481] = "镀银青铜护肩/1284/Cb",
	[7956] = "青铜战锤/1944/Cb",
	[3486] = "重砂轮/100/Cb",
	[2871] = "重磨刀石/40/Cb",
	[3241] = "重平衡石/40/Cb",
	[3491] = "青铜重锤/2741/Cb",
	[3482] = "镀银青铜战靴/1317/Cb",
	[2869] = "镀银青铜胸甲/1831/Cb",
	[7957] = "青铜巨剑/2205/Cb",
	[3483] = "镀银青铜护手/965/Cb",
	[7958] = "青铜战斧/2435/Cb",
	[5541] = "彩虹之锤/3693/Cb",
	[2870] = "银鳞胸甲/2935/Cb",
	[3484] = "绿铁战靴/1767/Cb",
	[3492] = "巨型铁锤/4552/Cb",
	[15870] = "黄金万能钥匙/300/Cb",
	[3485] = "绿铁护手/1295/Cb",
	[3851] = "结实的铁锤/6258/Cb",
	[11128] = "金棒/500/Cb",
	[7071] = "铁扣环/100/Cb",
	[6042] = "铁质盾刺/250/Cb",
	[7914] = "野人铁质胸甲/3330/Cb",
	[3842] = "绿铁护腿/2906/Cb",
	[3849] = "硬铁短剑/5468/Cb",
	[10423] = "镀银青铜护腿/2842/Cb",
	[7913] = "野人铁护肩/2500/Cb",
	[3840] = "绿铁护肩/2571/Cb",
	[3835] = "绿铁护腕/1106/Cb",
	[6043] = "铁质平衡锤/500/Cb",
	[3852] = "碎铁金锤/8360/Cb",
	[3843] = "金鳞护腿/3882/Cb",
	[3836] = "绿铁头盔/3053/Cb",
	[7915] = "野人铁盔/3337/Cb",
	[3841] = "金鳞护肩/3106/Cb",
	[3850] = "玉蛇刀/7304/Cb",
	[3853] = "月钢宽剑/10153/Cb",
	[3844] = "绿铁锁甲/5658/Cb",
	[7916] = "野人铁靴/3700/Cb",
	[12259] = "亮闪闪的钢匕首/8072/Cb",
	[3855] = "巨型铁斧/11248/Cb",
	[7917] = "野人铁手套/2711/Cb",
	[3846] = "精钢战靴/3937/Cb",
	[6040] = "金鳞护腕/1649/Cb",
	[17704] = "寒冬之刃/9178/Cb",
	[3837] = "金鳞罩盔/4405/Cb",
	[12260] = "灼热金剑/10395/Cb",
	[6041] = "钢质武器链/1500/Cb",
	[3845] = "金鳞胸甲/6558/Cb",
	[3854] = "霜虎之刃/14120/Cb",
	[3847] = "金鳞战靴/4977/Cb",
	[3856] = "月牙斧/14221/Cb",
	[7963] = "钢质胸甲/6488/Cb",
	[15871] = "真银万能钥匙/625/Cb",
	[29202] = "旋风钢斧/600/Cb",
	[9060] = "秘银杆/1000/Cb",
	[7966] = "坚固的砂轮/200/Cb",
	[7964] = "坚固的磨刀石/40/Cb",
	[7965] = "坚固的平衡石/40/Cb",
	[11144] = "真银棒/1000/Cb",
	[9366] = "金鳞护手/3689/Cb",
	[7919] = "重型秘银手套/2476/Cb",
	[7918] = "重型秘银护肩/3701/Cb",
	[7941] = "秘银重斧/12520/Cb",
	[7921] = "秘银短裤/5387/Cb",
	[7920] = "秘银鳞片短裤/8053/Cb",
	[7924] = "秘银鳞片护腕/4103/Cb",
	[7967] = "秘银盾刺/250/Cb",
	[7922] = "钢质头盔/2377/Cb",
	[7942] = "蓝光斧/14659/Cb",
	[7927] = "精制秘银手套/2987/Cb",
	[7926] = "精制秘银短裤/5952/Cb",
	[7928] = "精制秘银护肩/4857/Cb",
	[7943] = "秘银魔剑/15891/Cb",
	[7945] = "巨型黑色锤/17291/Cb",
	[7930] = "重型秘银胸甲/7045/Cb",
	[7931] = "秘银罩帽/7955/Cb",
	[7933] = "秘银重靴/5769/Cb",
	[7932] = "秘银鳞片护肩/8661/Cb",
	[7969] = "秘银马刺/250/Cb",
	[7944] = "秘银细剑/20092/Cb",
	[7934] = "重型秘银头盔/5790/Cb",
	[7946] = "秘银符文战锤/21660/Cb",
	[12405] = "瑟银护甲/9239/Cb",
	[12406] = "瑟银腰带/4636/Cb",
	[12644] = "致密砂轮/200/Cb",
	[12404] = "致密磨刀石/75/Cb",
	[12643] = "致密平衡石/75/Cb",
	[7947] = "乌木刀/24892/Cb",
	[12408] = "瑟银护腕/4998/Cb",
	[11606] = "黑铁锁甲/19255/Cb",
	[12416] = "辐光腰带/7595/Cb",
	[11608] = "黑铁粉碎者/45760/Cb",
	[12424] = "君王板甲腰带/5533/Cb",
	[12428] = "君王板甲护肩/8646/Cb",
	[12624] = "野刺锁甲/20642/Cb",
	[11605] = "黑铁护肩/10776/Cb",
	[12425] = "君王板甲护腕/6044/Cb",
	[12415] = "辐光胸甲/17003/Cb",
	[11607] = "黑铁斩碎者/51225/Cb",
	[12774] = "黎明之刃/36044/Cb",
	[15872] = "奥金万能钥匙/625/Cb",
	[12773] = "华丽瑟银手斧/33079/Cb",
	[12645] = "瑟银盾刺/500/Cb",
	[16206] = "奥金棒/1000/Cb",
	[12777] = "闪耀轻剑/38648/Cb",
	[12776] = "魔化战锤/48124/Cb",
	[12775] = "巨型瑟银战斧/39949/Cb",
	[12409] = "瑟银长靴/10336/Cb",
	[12410] = "瑟银头盔/10372/Cb",
	[11604] = "黑铁板甲/19428/Cb",
	[12628] = "魔铸胸甲/16640/Cb",
	[12781] = "平静/42721/Cb",
	[12418] = "辐光手套/10242/Cb",
	[12782] = "腐蚀/56808/Cb",
	[12631] = "炽热板甲护手/8919/Cb",
	[19051] = "黎明束带/9365/Cb",
	[19043] = "重型木喉腰带/13291/Cb",
	[12419] = "辐光长靴/16421/Cb",
	[12792] = "火山战锤/39255/Cb",
	[17014] = "黑铁护腕/12637/Cb",
	[16989] = "炽热链甲腰带/18610/Cb",
	[17193] = "萨弗隆战锤/122310/Cb",
	[12632] = "风暴护手/14099/Cb",
	[12426] = "君王板甲战靴/12062/Cb",
	[12427] = "君王板甲头盔/12106/Cb",
	[12417] = "辐光头饰/17034/Cb",
	[19166] = "黑色赦免者/46447/Cb",
	[22194] = "黑色摧毁者手套/33521/Cb",
	[19167] = "黑色怒火/116531/Cb",
	[19168] = "黑色卫士/102890/Cb",
	[20039] = "黑铁长靴/31709/Cb",
	[19164] = "黑铁护手/22425/Cb",
	[19148] = "黑铁头盔/25399/Cb",
	[17013] = "黑铁护腿/26441/Cb",
	[19170] = "黑手/103689/Cb",
	[16988] = "炽热链甲护肩/31460/Cb",
	[22671] = "破冰护腕/60635/Cb",
	[22669] = "破冰胸甲/119683/Cb",
	[22670] = "破冰护手/60406/Cb",
	[12641] = "免伤锁甲/43836/Cb",
	[22198] = "碎裂黑曜石盾牌/67440/Cb",
	[12640] = "狮心头盔/21894/Cb",
	[19169] = "夜幕/129112/Cb",
	[22191] = "黑曜石锁甲外套/73128/Cb",
	[22384] = "说服者/80554/Cb",
	[22383] = "先知之刃/80019/Cb",
	[12639] = "要塞护手/15271/Cb",
	[22196] = "厚重黑曜石胸甲/48043/Cb",
	[22385] = "泰坦护腿/25276/Cb",
	[12798] = "歼灭者/57150/Cb",
	[12790] = "奥金勇士剑/74619/Cb",
	[12784] = "奥金斧/73036/Cb",
	[19690] = "血魂胸甲/39683/Cb",
	[19692] = "血魂护手/19980/Cb",
	[19691] = "血魂护肩/29675/Cb",
	[17016] = "黑铁战斧/63973/Cb",
	[17015] = "黑铁利剑/63738/Cb",
	[20550] = "黑暗符文胸甲/23051/Cb",
	[20549] = "黑暗符文护手/11484/Cb",
	[20551] = "黑暗符文头盔/17352/Cb",
	[19693] = "黑暗之魂胸甲/24192/Cb",
	[19694] = "黑暗之魂护腿/23555/Cb",
	[19695] = "黑暗之魂护肩/18285/Cb",
	[12618] = "魔法瑟银胸甲/23972/Cb",
	[12620] = "魔法瑟银头盔/17245/Cb",
	[12619] = "魔法瑟银护腿/24058/Cb",
	[12797] = "寒冰护卫者/56943/Cb",
	[19057] = "黎明手套/11606/Cb",
	[12796] = "泰坦之锤/70912/Cb",
	[12783] = "寻心者/58215/Cb",
	[22197] = "重型黑曜石腰带/14282/Cb",
	[19048] = "木喉重靴/28061/Cb",
	[12636] = "大酋长头盔/24285/Cb",
	[22764] = "铁藤腰带/15864/Cb",
	[22762] = "铁藤胸甲/31492/Cb",
	[22763] = "铁藤护手/15806/Cb",
	[22195] = "轻巧黑曜石腰带/22752/Cb",
	[12794] = "精工风暴战锤/56304/Cb",
	[12633] = "白魂头盔/14859/Cb",
	[18262] = "元素磨刀石/1250/Cb",
	[29203] = "魔化瑟银飞刀/10000/Cb",
	[23493] = "魔铁链甲头盔/27683/Cb",
	[23482] = "魔铁板甲手套/20269/Cb",
	[12422] = "君王板甲护胸/16204/Cb",
	[12429] = "君王板甲护腿/17923/Cb",
	[12420] = "辐光护腿/25330/Cb",
	[12613] = "符文胸甲/18205/Cb",
	[12611] = "符文板甲战靴/12293/Cb",
	[12612] = "符文板甲头盔/12956/Cb",
	[12614] = "符文板甲护腿/18272/Cb",
	[12610] = "符文板甲护肩/12247/Cb",
	[12414] = "瑟银护腿/17376/Cb",
	[25843] = "魔铁棒/8000/Cb",
	[23528] = "魔能磨刀石/750/Cb",
	[28420] = "魔能平衡石/750/Cb",
	[23484] = "魔铁板甲腰带/20969/Cb",
	[23491] = "魔铁链甲手套/18866/Cb",
	[23497] = "魔铁短斧/58164/Cb",
	[23494] = "魔铁链甲护腕/19615/Cb",
	[23498] = "魔铁战锤/8813/Cb",
	[23487] = "魔铁板甲战靴/33419/Cb",
	[23488] = "魔铁板甲短裤/44805/Cb",
	[23490] = "魔铁链甲外套/39760/Cb",
	[23499] = "魔铁巨剑/795830/Cb",
	[23502] = "精金重槌/82647/Cb",
	[23489] = "魔铁胸甲/47475/Cb",
	[23559] = "次级结界符文/750/Cb",  --fly?
	[23503] = "精金利斧/85143/Cb",
	[23504] = "精金匕首/68364/Cb",
	[23506] = "精金板甲护腕/28586/Cb",
	[23508] = "精金板甲手套/28793/Cb",
	[23505] = "精金轻剑/70380/Cb",
	[23507] = "精金胸甲/58548/Cb",
	--[29] = "Lesser Rune of Warding/0/Cb",
	[23575] = "次级护盾符文/1500/Cb",
	[29204] = "魔钢密语匕首/1223/Cb",
	[23515] = "灭焰护腕/29607/Cb",
	[23529] = "精金磨刀石/1000/Cb",
	[28421] = "精金平衡石/1000/Cb",
	[25844] = "精金棒/32000/Cb",
	[23576] = "强效护盾符文/1500/Cb",
	[23510] = "魔化精金腰带/31529/Cb",
	[23511] = "魔化精金长靴/47104/Cb",
	[23516] = "灭焰头盔/44599/Cb",
	[23509] = "魔化精金胸甲/62984/Cb",
	[23517] = "魔钢手套/30311/Cb",
	[23518] = "魔钢护腿/60504/Cb",
	[23514] = "灭焰手套/32234/Cb",
	[23524] = "氪金腰带/31103/Cb",
	[23523] = "氪金短裤/61628/Cb",
	[23530] = "魔钢盾刺/12000/Cb",
	[23537] = "黑色魔钢护腕/35904/Cb",
	[23539] = "神宠护腕/36174/Cb",
	[23538] = "绿色要塞护腕/5282/Cb",
	[23555] = "挽歌/13877/Cb",
	[23554] = "恒金符文之刃/91813/Cb",
	[23542] = "魔能利斧/103904/Cb",
	[23546] = "魔能强化战槌/5395/Cb",
	[23531] = "魔怒护手/29918/Cb",
	[23540] = "魔钢长剑/103139/Cb",
	[23543] = "魔钢斧/130359/Cb",
	[23532] = "铁塔护手/35238/Cb",
	[23556] = "永恒之手/101609/Cb",
	[23535] = "坚定防御者头盔/53053/Cb",
	[23541] = "氪金圣剑/129402/Cb",
	[23536] = "誓言守护者头盔/53248/Cb",
	[23544] = "符印战锤/104659/Cb",
	[23533] = "钢钳护手/35369/Cb",
	[23534] = "风暴头盔/45389/Cb",
	[23512] = "魔化精金护腿/64163/Cb",
	[23519] = "魔钢头盔/45822/Cb",
	[23513] = "灭焰胸甲/64391/Cb",
	[23525] = "氪金战靴/46837/Cb",
	[23520] = "怒钢手套/30896/Cb",
	[23521] = "怒钢头盔/46159/Cb",
	[23527] = "和谐胸甲/54020/Cb",
	[23522] = "怒钢胸甲/61891/Cb",
	[31369] = "寒冰卫士胸甲/73884/Cb",
	[31371] = "寒冰卫士头盔/55708/Cb",
	[31370] = "寒冰卫士护腿/74152/Cb",
	[31364] = "野性卫士胸甲/72552/Cb",
	[31368] = "野性卫士头盔/55107/Cb",
	[31367] = "野性卫士护腿/73355/Cb",
	[25845] = "恒金棒/40000/Cb",
	[25521] = "强效结界符文/1250/Cb",
	[7929] = "兽人护腿/7739/Cb",
	[7936] = "精制秘银战靴/6739/Cb",
	[7935] = "精制秘银胸甲/8368/Cb",
	[7937] = "精制秘银头盔/6763/Cb",
	[7938] = "真银护手/4028/Cb",
	[7939] = "真银胸甲/10899/Cb",
	[30069] = "地铸护腿/22391/Cb",
	[30070] = "风铸护腿/19263/Cb",
	[30074] = "重型地铸胸甲/51597/Cb",
	[30076] = "雷铸战甲/44570/Cb",
	[28483] = "王者胸甲/71734/Cb",
	[23563] = "虚空链衫/67081/Cb",
	[28484] = "王者壁垒/84902/Cb",
	[28485] = "列王壁垒/98174/Cb",
	[23565] = "扭曲虚空的拥抱/87849/Cb",
	[23564] = "扭曲虚空链衫/75985/Cb",
	[7954] = "粉碎者/23159/Cb",
	[7961] = "幻影之刃/25508/Cb",
	[7959] = "荒芜/33857/Cb",
	[30071] = "轻型地铸利刃/32222/Cb",
	[30073] = "轻型灰烬铸锤/33297/Cb",
	[30072] = "轻型天铸战斧/32340/Cb",
	[7960] = "真银圣剑/38548/Cb",
	[30088] = "天铸巨斧/97120/Cb",
	[30087] = "雷铸战斧/77416/Cb",
	[28434] = "新月/133370/Cb",
	[28431] = "位面战斧/102808/Cb",
	[28432] = "黑色位面战斧/117066/Cb",
	[28436] = "血月/170435/Cb",
	[28435] = "月牙屠斧/151832/Cb",
	[28433] = "邪恶位面战斧/134904/Cb",
	[30093] = "巨型地铸战锤/101472/Cb",
	[30089] = "熔铸战锤/80037/Cb",
	[28437] = "龙拳之锤/107834/Cb",
	[28440] = "雷霆/123276/Cb",
	[28441] = "惊雷/140395/Cb",
	[28438] = "巨龙之喉/122767/Cb",
	[28439] = "巨龙之击/124657/Cb",
	[28442] = "风暴使者/157642/Cb",
	[30086] = "石铸巨剑/96412/Cb",
	[30077] = "风铸轻剑/74563/Cb",
	[28425] = "火焰卫士/100534/Cb",
	[28428] = "狮心之刃/127089/Cb",
	[28427] = "光芒之怒/128528/Cb",
	[28426] = "光芒卫士/114486/Cb",
	[28429] = "狮心圣剑/144720/Cb",
	[28430] = "狮心斩杀者/162480/Cb",
	[6290] = "美味小鱼/1/Cc",
	[2679] = "烧烤狼肉/5/Cc",
	[12224] = "香脆蝙蝠翅/10/Cc",
	[17197] = "姜饼/10/Cc",
	[6888] = "草药烘蛋/10/Cc",
	[27635] = "山猫肉排/6/Cc",
	[2681] = "烤野猪肉/6/Cc",
	[24105] = "烧烤牧月鹿腰肉/6/Cc",
	[787] = "滑皮鲭鱼/1/Cc",
	[30816] = "莫高雷香料面包/5/Cc",
	[2888] = "啤酒烤猪排/10/Cc",
	[5472] = "卡多雷蜘蛛烤肉/10/Cc",
	[2680] = "香辣狼肉/10/Cc",
	[5473] = "蝎肉大餐/10/Cc",
	[17198] = "蛋奶酒/9/Cc",
	[5474] = "烤科多肉/9/Cc",
	[6890] = "熏熊肉/6/Cc",
	[27636] = "蝙蝠餐点/25/Cc",
	[5525] = "水煮蚌肉/20/Cc",
	[2684] = "山狗肉排/20/Cc",
	[5476] = "狂鱼肉片/3/Cc",
	[724] = "猪肝馅饼/25/Cc",
	[6316] = "洛克湖狂鱼/3/Cc",
	[4592] = "长嘴泥鳅/1/Cc",
	[5095] = "彩鳍鱼/3/Cc",
	[5477] = "炖陆行鸟/18/Cc",
	[3220] = "血肠/40/Cc",
	[22645] = "松脆蜘蛛/25/Cc",
	[7676] = "菊花茶/30/Cc",
	[2683] = "蟹肉蛋糕/25/Cc",
	[733] = "杂味炖肉/100/Cc",
	[3662] = "鳄鱼肉排/25/Cc",
	[2687] = "猪肉干/25/Cc",
	[21072] = "烤鼠尾鱼/40/Cc",
	[2682] = "煮蟹爪/25/Cc",
	[6657] = "美味风蛇/5/Cc",
	[5526] = "杂烩蚌肉/75/Cc",
	[5478] = "掘地鼠炖肉/70/Cc",
	[3663] = "鱼人鳍汤/125/Cc",
	[4593] = "刺须鲶鱼/4/Cc",
	[5479] = "脆炸蜥蜴尾/125/Cc",
	[1082] = "赤脊山炖肉/150/Cc",
	[1017] = "干烤狼肉串/100/Cc",
	[3726] = "大块的熊排/125/Cc",
	[3666] = "蜘蛛蛋糕/100/Cc",
	[5480] = "瘦鹿肉/95/Cc",
	[2685] = "多汁猪排/75/Cc",
	[3664] = "鳄鱼浓汤/100/Cc",
	[5527] = "地精芥末蘸蚌肉/95/Cc",
	[3727] = "烤狮排/125/Cc",
	[12209] = "瘦狼排/95/Cc",
	[3665] = "美味煎蛋卷/150/Cc",
	[20074] = "鳄鱼炖肉/300/Cc",
	[3728] = "香烤狮肉/300/Cc",
	[4457] = "烧烤秃鹰翅膀/300/Cc",
	[12213] = "腐肉大餐/300/Cc",
	[6038] = "烧烤巨蚌/312/Cc",
	[10841] = "金棘茶/85/Cc",
	[13851] = "热狼排/312/Cc",
	[12212] = "丛林大杂烩/300/Cc",
	[31] = "银头鳟鱼/0/Cc",
	[8364] = "银头鲑鱼/6/Cc",
	[12214] = "神秘杂烩/300/Cc",
	[12210] = "烤迅猛龙肉/300/Cc",
	[4594] = "石鳞鳕鱼/6/Cc",
	[21217] = "美味鼠尾鱼/125/Cc",
	[3729] = "海龟汤/300/Cc",
	[12217] = "龙息红椒/300/Cc",
	[12215] = "科多肉杂烩/300/Cc",
	[17222] = "蜘蛛肉肠/300/Cc",
	[13927] = "煮熟的光滑大鱼/8/Cc",
	[13930] = "油炸红腮鱼/5/Cc",
	[12218] = "超级煎蛋卷/300/Cc",
	[12216] = "辣椒蟹肉/300/Cc",
	[6887] = "斑点黄尾鱼/5/Cc",
	[18045] = "嫩狼肉排/300/Cc",
	[16766] = "安德麦蚌肉杂烩/100/Cc",
	[13928] = "烤鱿鱼/8/Cc",
	[13929] = "烟熏鲈鱼/10/Cc",
	[13931] = "夜鳞鱼汤/12/Cc",
	[13932] = "水煮阳鳞鲑鱼/12/Cc",
	[13935] = "烤鲑鱼/10/Cc",
	[13933] = "炖龙虾/14/Cc",
	[13934] = "大鱼片/18/Cc",
	[18254] = "洛恩塔姆薯块/18/Cc",
	[20452] = "沙漠肉丸子/250/Cc",
	[27661] = "烟熏鳟鱼/150/Cc",
	[27651] = "美味秃鹰/150/Cc",
	[30155] = "蚌柳/150/Cc",
	[21023] = "迪尔格的超美味奇美拉肉片/250/Cc",
	[27662] = "美味魔尾鱼/150/Cc",
	[27655] = "掠食者热狗/150/Cc",
	[27663] = "烟熏孢子鱼/150/Cc",
	[27656] = "孢子小吃/150/Cc",
	[27657] = "烟熏蜥蜴/150/Cc",
	[27664] = "烤泥鱼/150/Cc",
	[27665] = "水煮蓝鱼/150/Cc",
	[27666] = "金色鱼柳/150/Cc",
	[27658] = "烧烤裂蹄牛/150/Cc",
	[27660] = "塔布肉排/150/Cc",
	[27659] = "迁跃兽汉堡/150/Cc",
	[31673] = "香脆蛇/150/Cc",
	[31672] = "莫克纳萨肋排/150/Cc",
	[27667] = "香辣小龙虾/150/Cc",
	[33052] = "渔夫的美味/0/Cc",
	[33053] = "黄油鲑鱼/0/Cc",
	[33048] = "炖鲑鱼/0/Cc",
	[6218] = "符文铜棒/24/Cn",
	[11287] = "次级魔法杖/104/Cn",
	[20744] = "初级巫师之油/100/Cn",
	[11288] = "强效魔法杖/466/Cn",
	[6339] = "符文银棒/24/Cn",
	[20745] = "初级法力之油/1000/Cn",
	[11130] = "符文金棒/500/Cn",
	[11289] = "次级秘法魔杖/2148/Cn",
	[11290] = "强效秘法杖/3157/Cn",
	[20746] = "次级巫师之油/1000/Cn",
	[11145] = "符文真银棒/1250/Cn",
	[12810] = "魔化皮/500/Cn",
	[12655] = "附魔瑟银锭/500/Cn",
	[20747] = "次级法力之油/1000/Cn",
	[11811] = "浓烟山脉之心/1500/Cn",
	[20750] = "巫师之油/1000/Cn",
	[16207] = "符文奥金棒/1250/Cn",
	[20748] = "卓越法力之油/800/Cn",
	[20749] = "卓越巫师之油/600/Cn",
	[22461] = "符文魔铁棒/1250/Cn",
	[22521] = "超级法力之油/1500/Cn",
	[22460] = "棱光之球/0/Cn",
	[22449] = "大块棱光碎片/0/Eq",
	[22522] = "超级巫师之油/1500/Cn",
	[22459] = "虚空之球/0/Cn",
	[22462] = "符文精金棒/32000/Cn",
	[22463] = "符文恒金棒/40000/Cn",
	[8067] = "精制轻弹丸/0/Ce",
	[4357] = "劣质火药/4/Ce",
	[4358] = "劣质炸药/30/Ce",
	[4359] = "一把螺栓/12/Ce",
	[4360] = "劣质铜壳炸弹/60/Ce",
	[4362] = "劣质火枪/187/Ce",
	[6219] = "扳手/144/Ce",
	[4361] = "铜管/120/Ce",
	[4405] = "粗制瞄准镜/125/Ce",
	[4363] = "铜质调节器/50/Ce",
	[4364] = "粗制火药粉/12/Ce",
	[4365] = "劣质炸药/75/Ce",
	[8068] = "精制重弹丸/0/Ce",
	[33] = "机械松鼠/0/Ce",
	[4401] = "机械松鼠笼/100/Ce",
	[4366] = "活动假人/75/Ce",
	[4404] = "银触媒/25/Ce",
	[4368] = "飞虎护目镜/408/Ce",
	[6714] = "简易投掷炸弹/75/Ce",
	[6712] = "练习锁/12/Ce",
	[4367] = "小型爆盐炸弹/150/Ce",
	[4369] = "致命的短枪/1179/Ce",
	[4371] = "青铜管/200/Ce",
	[4370] = "大型铜壳炸弹/175/Ce",
	[4406] = "普通瞄准镜/600/Ce",
	[4372] = "精致手工火枪/1800/Ce",
	[4373] = "暗影护目镜/722/Ce",
	[4374] = "小型青铜炸弹/200/Ce",
	[7506] = "侏儒通用遥控器/500/Ce",
	[8069] = "精制实心弹丸/0/Ce",
	[4376] = "火焰偏斜器/200/Ce",
	[4377] = "烈性火药/150/Ce",
	[4378] = "烈性炸药/350/Ce",
	[21558] = "小型蓝色烟花/6/Ce",
	[21559] = "小型绿色烟花/6/Ce",
	[21557] = "小型红色烟花/6/Ce",
	[4375] = "高速青铜齿轮/115/Ce",
	[4379] = "镀银猎枪/2357/Ce",
	[4381] = "自动净化装置/600/Ce",
	[5507] = "精制望远镜/600/Ce",
	[4380] = "重磅青铜炸弹/500/Ce",
	[4383] = "夜视步枪/3183/Ce",
	[4382] = "青铜框架/600/Ce",
	[4386] = "寒冰偏斜器/175/Ce",
	[4385] = "绿色护目镜/1410/Ce",
	[6533] = "水下诱鱼器/62/Ce",
	[9312] = "蓝色焰火/12/Ce",
	[4388] = "退化射线/1000/Ce",
	[4384] = "自爆绵羊/1000/Ce",
	[10558] = "黄金能量核心/250/Ce",
	[9313] = "绿色焰火/12/Ce",
	[9318] = "红色焰火/12/Ce",
	[4387] = "铁棒/400/Ce",
	[7148] = "地精起搏器/21/Ce",
	[4403] = "便携式青铜迫击炮/2000/Ce",
	[4407] = "精确瞄准镜/1200/Ce",
	[4389] = "发条式同步协调陀螺仪/750/Ce",
	[10499] = "增亮护目镜/2105/Ce",
	[4391] = "联合收割机组件/4000/Ce",
	[10498] = "地精微调器/16/Ce",
	[4390] = "铁皮手雷/500/Ce",
	[21589] = "大型蓝色烟花束/12/Ce",
	[21590] = "大型绿色烟花/12/Ce",
	[21592] = "大型红色烟花束/12/Ce",
	[10505] = "实心炸药/250/Ce",
	[10507] = "实心炸弹/350/Ce",
	[4393] = "工匠眼镜/2632/Ce",
	[4392] = "高级假人/2500/Ce",
	[4852] = "闪光雷/300/Ce",
	[4394] = "重磅铁制炸弹/750/Ce",
	[4397] = "地精隐形装置/5000/Ce",
	[4396] = "机械幼龙/6000/Ce",
	[17716] = "雪王9000型/7500/Ce",
	[4395] = "地精暗雷/1600/Ce",
	[10559] = "秘银管/750/Ce",
	[18588] = "简易投掷炸弹 II/200/Ce",
	[4398] = "大型爆盐炸弹/900/Ce",
	[11590] = "机械修理包/250/Ce",
	[10560] = "不牢固的扳机/1000/Ce",
	[10500] = "火焰护目镜/3478/Ce",
	[10508] = "秘银火枪/8958/Ce",
	[10512] = "高速秘银弹头/2/Ce",
	[10546] = "致命瞄准镜/1500/Ce",
	[10721] = "地精防护腰带/3317/Ce",
	[10561] = "秘银外壳/1000/Ce",
	[10514] = "秘银破片炸弹/750/Ce",
	[10501] = "猫眼超级护目镜/4398/Ce",
	[10510] = "大口径秘银步枪/11369/Ce",
	[10518] = "降落伞披风/4696/Ce",
	[10502] = "法术能量护目镜超级版/4088/Ce",
	[21571] = "蓝色烟花束/25/Ce",
	[21569] = "烟花发射器/0/Ce",
	[21574] = "绿色烟花束/25/Ce",
	[21576] = "红色烟花束/25/Ce",
	[10506] = "潜水头盔/5227/Ce",
	[10503] = "玫瑰色护目镜/5169/Ce",
	[10562] = "高爆炸弹/750/Ce",
	[10548] = "狙击瞄准镜/2500/Ce",
	[10504] = "绿色透镜/7770/Ce",
	[10513] = "秘银螺旋弹/5/Ce",
	[15992] = "致密炸药粉/250/Ce",
	[18641] = "致密炸弹/500/Ce",
	[10576] = "秘银机械幼龙/6000/Ce",
	[15846] = "筛盐器/7500/Ce",
	[19026] = "长蛇烟火/250/Ce",
	[21277] = "安静的机械雪人/1250/Ce",
	[18634] = "超低温寒冰偏斜器/12500/Ce",
	[15995] = "瑟银火枪/19739/Ce",
	[15993] = "瑟银手榴弹/1500/Ce",
	[15994] = "瑟银零件/2500/Ce",
	[18631] = "真银变压器/3000/Ce",
	[15996] = "仿真机械蛙/2500/Ce",
	[15999] = "法术能量护目镜超级改良版/9002/Ce",
	[16004] = "黑铁步枪/29152/Ce",
	[18637] = "强力净化器/600/Ce",
	[34] = "烟花束发射器/0/Ce",
	[21570] = "烟花束发射器/0/Ce",
	[7191] = "保险丝/0/Ce",
	[21714] = "大型蓝色烟花束/50/Ce",
	[21716] = "大型绿色烟花束/50/Ce",
	[21718] = "大型红色烟花束/50/Ce",
	[16023] = "高级活动假人/10000/Ce",
	[18594] = "强力爆盐炸弹/3000/Ce",
	[16000] = "瑟银管/3750/Ce",
	[15997] = "瑟银弹/10/Ce",
	[16005] = "黑铁炸弹/1250/Ce",
	[16006] = "精密奥金转换器/10000/Ce",
	[18638] = "高辐射烈焰反射器/12500/Ce",
	[16008] = "高级技师护目镜/11739/Ce",
	[16009] = "语音增强模组/5930/Ce",
	[18282] = "火核狙击步枪/66347/Ce",
	[18168] = "力反馈盾牌/56416/Ce",
	[16022] = "奥金机械幼龙/40000/Ce",
	[18283] = "比兹尼克247x128精确瞄准镜/25000/Ce",
	[19999] = "血藤护目镜/18639/Ce",
	[19998] = "血藤透镜/23211/Ce",
	[16007] = "完美的奥金步枪/40625/Ce",
	[18639] = "快速暗影反射器/12500/Ce",
	[16040] = "奥术炸弹/4000/Ce",
	[23781] = "元素炸药粉/500/Ce",
	[23736] = "魔铁炸弹/2500/Ce",
	[23782] = "魔铁外壳/8000/Ce",
	[18232] = "修理机器人74A型/10000/Ce",
	[23783] = "魔铁螺丝/1500/Ce",
	[23821] = "气阀微粒提取器/15000/Ce",
	[23772] = "魔铁弹丸/20/Ce",
	[23742] = "魔铁步枪/5538/Ce",
	[23774] = "魔铁工具箱/30000/Ce",
	[23784] = "精金框架/10000/Ce",
	[23737] = "精金手雷/2500/Ce",
	[23767] = "打架机器人/16179/Ce",
    [33092] = "治疗药水注射器/0/Ce",
    [33093] = "法力药水注射器/0/Ce",
	[34504] = "精金制弹机/25/Ce",
	[23764] = "精金瞄准镜/2500/Ce",
	[23771] = "绿色烟幕弹/80/Ce",
	[32423] = "冰霜冲击雷管/0/Ce",
	[25886] = "紫色烟幕弹/0/Ce",
	[23768] = "白色烟幕弹/19489/Ce",
	[23758] = "旋轮护目镜/29667/Ce",
	[23761] = "能量放大护目镜/20534/Ce",
	[32478] = "死亡一击护目镜X11型/0/Ce",
	[32494] = "毁灭全视护目镜/0/Ce",
	[32461] = "狂野机械护目镜/0/Ce",
	[32476] = "齿轮风暴护目镜/0/Ce",
	[32472] = "审判者护目镜2000型/0/Ce",
	[32475] = "活力复制器/0/Ce",
	[32480] = "月光放大护目镜/0/Ce",
	[32495] = "超级治疗射线4000型/0/Ce",
	[32474] = "必中护目镜V2.0/0/Ce",
	[32473] = "坦克眼镜/0/Ce",
	[32479] = "奇迹治疗罩XT40型/0/Ce",
	[23762] = "超光谱侦测护目镜/25324/Ce",
	[23746] = "精金步枪/55725/Ce",
	[23819] = "元素爆盐炸弹/0/Ce",
	[23787] = "魔钢稳定器/12000/Ce",
	[23785] = "硬化精金管/30000/Ce",
	[23786] = "氪金能量核心/12000/Ce",
	[23824] = "超级火箭靴/32734/Ce",
	[23747] = "魔钢火枪/62413/Ce",
	[23763] = "超视距护目镜/31774/Ce",
	[23765] = "氪金瞄准镜/2500/Ce",
	[32756] = "陀螺平衡氪金重枪/0/Ce",
	[23748] = "精制氪金步枪/66312/Ce",
	[23766] = "稳定恒金瞄准镜/20000/Ce",
	[23820] = "生物放大器/0/Ce",
	[35] = "冰霜手雷/0/Ce",
	[32413] = "冰霜手雷/0/Ce",
	[23769] = "红色烟幕弹/0/Ce",
	[10716] = "侏儒缩小射线/750/Ce",
	[36] = "秘银杆设计图/0/Ce",
	[10713] = "设计图：秘银杆/500/Ce",
	[11826] = "发条娃娃/2500/Ce",
	[10545] = "侏儒护目镜/3929/Ce",
	[10720] = "侏儒撒网器/750/Ce",
	[10724] = "侏儒火箭靴/4696/Ce",
	[10725] = "侏儒作战小鸡/1500/Ce",
	[10726] = "侏儒洗脑帽/5520/Ce",
	[10645] = "侏儒死亡射线/750/Ce",
	[37] = "安全传送器：加基森/0/Ce",
	[18986] = "安全传送器：加基森/5000/Ce",
	[18660] = "世界放大器/7500/Ce",
	[38] = "报警机器人/0/Ce",
	[18645] = "地精警报机器人/1500/Ce",
	[23841] = "侏儒喷火炮台/3000/Ce",
	[23835] = "侏儒变鸡器/22500/Ce",
	[39] = "近似无敌腰带/0/Ce",
	[23825] = "近似无敌腰带/11565/Ce",
	[40] = "超级安全传送器：托什雷的基地/0/Ce",
	[30544] = "超级安全传送器：托什雷的基地/5000/Ce",
	[23829] = "侏儒作战护目镜/38321/Ce",
	[23828] = "侏儒能量护目镜/30547/Ce",
	[10543] = "地精施工头盔/3517/Ce",
	[10542] = "地精采矿头盔/5255/Ce",
	[41] = "地精火箭燃油配方/0/Ce",
	[10644] = "配方：地精火箭燃油/500/Ce",
	[10646] = "地精工兵炸药/500/Ce",
	[11825] = "炸弹宠物/2500/Ce",
	[42] = "地精迫击炮/0/Ce",
	[43] = "迫击炮:重载/0/Ce",
	[7189] = "地精火箭靴/4712/Ce",
	[10587] = "地精炸弹箱/1500/Ce",
	[10586] = "大炸弹/750/Ce",
	[10727] = "地精龙枪/2000/Ce",
	[10588] = "地精火箭头盔/5834/Ce",
	[18984] = "空间撕裂器 - 永望镇/5000/Ce",
	[18587] = "地精起搏器XL型/2000/Ce",
	[23826] = "更大的炸弹/3000/Ce",
	[23827] = "超级神风炸药/4000/Ce",
	[23836] = "地精火箭发射器/4000/Ce",
	[30542] = "空间撕裂器 - 52区/5000/Ce",
	[23838] = "工头的附魔头盔/29454/Ce",
	[23839] = "工头的加固头盔/44345/Ce",
	[1251] = "亚麻绷带/10/Cf",
	[2581] = "厚亚麻绷带/20/Cf",
	[6452] = "抗毒药剂/28/Cf",
	[3530] = "绒线绷带/28/Cf",
	[3531] = "厚绒线绷带/57/Cf",
	[6453] = "强力抗毒药剂/62/Cf",
	[6450] = "丝质绷带/200/Cf",
	[6451] = "厚丝质绷带/400/Cf",
	[8544] = "魔纹绷带/400/Cf",
	[8545] = "厚魔纹绷带/600/Cf",
	[14529] = "符文布绷带/500/Cf",
	[14530] = "厚符文布绷带/1000/Cf",
	[19440] = "强效抗毒药剂/500/Cf",
	[21990] = "灵纹布绷带/1500/Cf",
	[21991] = "厚灵纹布绷带/2250/Cf",
	[20906] = "铜丝戒指/250/Cj",
	[21931] = "铜纹戒指/250/Cj",
	[20816] = "精巧的铜线/20/Cj",
	[25498] = "劣质石像/25/Cj",
	[21932] = "重型铜戒指/250/Cj",
	[25438] = "孔雀石坠饰/750/Cj",
	[25439] = "虎眼指环 /250/Cj",
	[20821] = "孔雀石镶饰戒指/1064/Cj",
	[21934] = "精制虎眼石项链/1500/Cj",
	[20818] = "优雅的银戒指/625/Cj",
	[20907] = "结实的青铜戒指/300/Cj",
	[21933] = "粗制青铜项链/750/Cj",
	[20817] = "青铜底座/100/Cj",
	[25880] = "粗糙石像/150/Cj",
	[20820] = "朴素的珍珠戒指/1064/Cj",
	[30804] = "力量之青铜指环/1064/Cj",
	[20823] = "阴沉之戒/837/Cj",
	[30419] = "魔光项链 /750/Cj",
	[31154] = "青铜饰环/750/Cj",
	[20827] = "银色力量之戒/875/Cj",
	[20826] = "重型银戒指/2207/Cj",
	[20828] = "暮色暗影之戒/677/Cj",
	[30420] = "重型翡翠戒指/677/Cj",
	[20830] = "月之护符/1535/Cj",
	[20909] = "野蛮铁项圈/1010/Cj",
	[25881] = "沉重石像/25/Cj",
	[20832] = "月魂王冠/1800/Cj",
	[20950] = "玛瑙护盾坠饰/1535/Cj",
	[20954] = "重型铁拳套/5681/Cj",
	[20833] = "邪恶月亮石戒指/54/Cj",
	[20955] = "金色巨龙戒指/665/Cj",
	[20958] = "闪耀黄水晶之戒/1130/Cj",
	[20831] = "重型作战金项链/1535/Cj",
	[20963] = "秘银丝/900/Cj",
	[20966] = "冲击之碧玉坠饰/3482/Cj",
	[20960] = "蚀刻真银戒指/1720/Cj",
	[20959] = "翡翠之眼/1720/Cj",
	[25882] = "坚固石像/1000/Cj",
	[29157] = "能量之黄金戒指/1500/Cj",
	[20961] = "快速治疗之黄水晶吊饰/21633/Cj",
	[20967] = "金色治疗之黄水晶坠饰/3482/Cj",
	[29158] = "真银指挥官之戒/1750/Cj",
	[21756] = "雕像 - 金兔/1500/Cj",
	[21748] = "雕像 - 碧玉猫头鹰/1500/Cj",
	[20964] = "青绿石徽记/6646/Cj",
	[21758] = "雕像 - 黑珍珠猎豹/1500/Cj",
	[21755] = "战士之绿玉坠饰/1230/Cj",
	[20969] = "恢复之红宝石王冠 /5989/Cj",
	[21760] = "雕像 - 真银螃蟹/1500/Cj",
	[25883] = "致密石像/14087/Cj",
	[21752] = "瑟银底座/1250/Cj",
	[30421] = "红色毁灭指环/2542/Cj",
	[21763] = "雕像 - 真银野猪/1500/Cj",
	[21764] = "火焰之红宝石坠饰/6420/Cj",
	[21765] = "真银治疗戒指/2542/Cj",
	[21754] = "青绿石屏障/4307/Cj",
	[21753] = "宝石镶嵌指环/5000/Cj",
	[21766] = "冲击之猫眼石项链/830/Cj",
	[21769] = "雕像 - 红宝石蛇/1500/Cj",
	[21767] = "朴素的猫眼石戒指/8375/Cj",
	[30422] = "钻石专注戒指/8375/Cj",
	[21774] = "毁灭之翡翠王冠/1/Cj",
	[21768] = "蓝宝石徽记/12500/Cj",
	[29159] = "光芒瑟银指环/8375/Cj",
	[21775] = "猛攻指环/8375/Cj",
	[21790] = "寒冬之蓝宝石坠饰/7767/Cj",
	[21777] = "雕像 - 翡翠猫头鹰/3750/Cj",
	[21778] = "痛苦暗影之戒/18662/Cj",
	[21791] = "生命绿宝石坠饰/14059/Cj",
	[29160] = "翡翠狮王戒指/9125/Cj",
	[21784] = "雕像 - 黑钻石蟹/15000/Cj",
	[21789] = "雕像 - 黑铁蝎/15000/Cj",
	[23113] = "闪耀德拉诺金钻/10000/Cj",
	[23108] = "炽热德拉诺影钻/10000/Cj",
	[23098] = "铭文火榴石/10000/Cj",
	[23103] = "辐光翠榄石/10000/Cj",
	[23118] = "致密碧月石/10000/Cj",
	[23094] = "泪珠血榴石/10000/Cj",
	[21792] = "钻石之塔项链/25218/Cj",
	[23095] = "朴素血榴石/10000/Cj",
	[28595] = "明亮血榴石/10000/Cj",
	[23114] = "柔光德拉诺金钻/10000/Cj",
	[23104] = "裂纹翠榄石/10000/Cj",
	[23099] = "辉光火榴石/10000/Cj",
	[23109] = "皇家德拉诺影钻/10000/Cj",
	[23119] = "火花碧月石/10000/Cj",
	[21779] = "天火指环/21305/Cj",
	[24074] = "魔铁血戒/24491/Cj",
	[24075] = "黄金卓奈石戒指/24491/Cj",
	[23105] = "坚硬翠榄石/10000/Cj",
	[23100] = "反光火榴石/10000/Cj",
	[23096] = "符文血榴石/10000/Cj",
	[23110] = "狡诈德拉诺影钻/10000/Cj",
	[23120] = "风暴碧月石/10000/Cj",
	[23115] = "厚重德拉诺金钻/10000/Cj",
	[24076] = "蓝月石之戒/3769/Cj",
	[32772] = "耀眼的珍珠戒指/0/Cj",
	[31079] = "水银精金/10000/Cj",
	[23106] = "眩光翠榄石/20000/Cj",
	[23097] = "精致血榴石/10000/Cj",
	[23121] = "异彩碧月石/10000/Cj",
	[23101] = "高能火榴石/10000/Cj",
	[32833] = "纯净裂纹珍珠/0/Cj",
	[23116] = "刚硬德拉诺金钻/10000/Cj",
	[28290] = "圆润德拉诺金钻/10000/Cj",
	[23111] = "统御德拉诺影钻/10000/Cj",
	[32774] = "黑色明珠/0/Cj",
	[24078] = "重型精金戒指/16134/Cj",
	[24077] = "厚重精金项链/10715/Cj",
	[32508] = "深海项链/0/Cj",
	[24087] = "重魔钢戒指/37037/Cj",
	[31863] = "平衡夜目石/0/Cj",
	[24027] = "朴素红曜石/30000/Cj",
	[24031] = "明亮红曜石/30000/Cj",
	[24047] = "闪耀黎明石/30000/Cj",
	[24065] = "眩光水玉/30000/Cj",
	[24028] = "精致红曜石/30000/Cj",
	[24062] = "坚硬水玉/30000/Cj",
	[24036] = "闪光红曜石/30000/Cj",
	[24050] = "柔光黎明石/30000/Cj",
	[24061] = "反光黄晶玉/30000/Cj",
	[24056] = "炽热夜目石/30000/Cj",
	[31861] = "巨型黎明石/0/Cj",
	[31865] = "充能夜目石/0/Cj",
	[24058] = "铭文黄晶玉/30000/Cj",
	[24067] = "裂纹水玉/30000/Cj",
	[24079] = "暗影氪金指环 /38775/Cj",
	[24060] = "辉光黄晶玉/30000/Cj",
	[24037] = "异彩艾露恩之星/30000/Cj",
	[24053] = "秘法黎明石/0/Cj",
	[24059] = "高能黄晶玉/4815/Cj",
	[32836] = "纯净暗影珍珠/0/Cj",
	[24066] = "辐光水玉/1767/Cj",
	[24051] = "刚硬黎明石/500/Cj",
	[24057] = "皇家夜目石/3183/Cj",
	[24030] = "符文红曜石/30000/Cj",
	[24055] = "狡诈夜目石/30000/Cj",
	[24048] = "圆润黎明石/1433/Cj",
	[24033] = "致密艾露恩之星/30000/Cj",
	[24054] = "统御夜目石/30000/Cj",
	[24035] = "火花艾露恩之星/30000/Cj",
	[24039] = "风暴艾露恩之星/30000/Cj",
	[24032] = "诡秘红曜石/30000/Cj",
	[24029] = "泪珠红曜石/30000/Cj",
	[24052] = "厚重黎明石/30000/Cj",
	[31867] = "隐秘黄晶玉/0/Cj",
	[31868] = "邪恶黄晶玉/0/Cj",
	[24088] = "精致恒金戒指/39122/Cj",
	[24080] = "冰霜氪金指环/39122/Cj",
	[24082] = "炼狱氪金指环/39122/Cj",
	[24110] = "红曜石坠饰/39122/Cj",
	[24106] = "厚重魔钢项链/39122/Cj",
	[24114] = "恒金饰链/39470/Cj",
	[24116] = "夜晚之眼/39470/Cj",
	[24085] = "绿叶氪金指环/39470/Cj",
	[24092] = "冰冷烈焰坠饰/39470/Cj",
	[24097] = "暗影终结坠饰/39470/Cj",
	[24093] = "融雪坠饰/39470/Cj",
	[24098] = "空洞符文坠饰/39470/Cj",
	[24095] = "凋零坠饰/39470/Cj",
	[30825] = "奥术护盾指环/37037/Cj",
	[24086] = "奥术氪金指环/39818/Cj",
	[24089] = "闪耀恒金指环/39818/Cj",
	[25897] = "鼓舞之大地风暴钻石/30000/Cj",
	[25899] = "蛮力之大地风暴钻石/30000/Cj",
	[24121] = "夜枭之链/39818/Cj",
	[32776] = "海巫之冠/0/Cj",
	[25890] = "毁灭之天火钻石/30000/Cj",
	[24117] = "黎明的拥抱/39818/Cj",
	[25895] = "神秘之天火钻石/4522/Cj",
	[25901] = "洞察之大地风暴钻石/30000/Cj",
	[25893] = "秘法之天火钻石/30000/Cj",
	[25896] = "强能之大地风暴钻石/30000/Cj",
	[32409] = "残酷之大地风暴钻石/0/Cj",
	[25894] = "迅捷之天火钻石/30000/Cj",
	[25898] = "坚韧之大地风暴钻石/8226/Cj",
	[32410] = "雷鸣之天火钻石/0/Cj",
	[24123] = "奥法能量头饰/30712/Cj",
	[44] = "翠焰宝冠/0/Cj",
	[24122] = "翠焰宝冠/30597/Cj",
	[24125] = "雕像 - 黎明石螃蟹/15000/Cj",
	[24124] = "雕像 - 魔钢野猪/12000/Cj",
	[24126] = "雕像 - 红曜石毒蛇/2/Cj",
	[24128] = "雕像 - 夜目石猎豹/15000/Cj",
	[24127] = "雕像 - 水玉猫头鹰/15000/Cj",
	[32213] = "平衡影歌紫玉/0/Cj",
	[32193] = "朴素赤尖石/0/Cj",
	[32197] = "明亮赤尖石/0/Cj",
	[32204] = "闪耀狮眼石/0/Cj",
	[32225] = "眩光海浪翡翠/0/Cj",
	[32194] = "精致赤尖石/0/Cj",
	[32223] = "坚硬海浪翡翠/0/Cj",
	[32199] = "闪光赤尖石/0/Cj",
	[32207] = "柔光狮眼石/0/Cj",
	[32220] = "反光焚石/0/Cj",
	[32215] = "炽热影歌紫玉/0/Cj",
	[32210] = "巨型狮眼石/0/Cj",
	[32214] = "充能影歌紫玉/0/Cj",
	[32217] = "铭文焚石/0/Cj",
	[32226] = "裂纹海浪翡翠/0/Cj",
	[32219] = "辉光焚石/0/Cj",
	[32202] = "异彩天蓝宝石/0/Cj",
	[32209] = "秘法狮眼石/0/Cj",
	[32218] = "高能焚石/0/Cj",
	[32224] = "辐光海浪翡翠/0/Cj",
	[32216] = "皇家影歌紫玉/0/Cj",
	[32196] = "符文赤尖石/0/Cj",
	[32212] = "狡诈影歌紫玉/0/Cj",
	[32205] = "圆润狮眼石/0/Cj",
	[32200] = "致密天蓝宝石/0/Cj",
	[32211] = "统御影歌紫玉/0/Cj",
	[32201] = "火花天蓝宝石/0/Cj",
	[32203] = "风暴天蓝宝石/0/Cj",
	[32198] = "诡秘赤尖石/0/Cj",
	[32195] = "泪珠赤尖石/0/Cj",
	[31398] = "冰霜之眼/60256/Cj",
	[31399] = "自然屏障/60256/Cj",
	[32208] = "厚重狮眼石/0/Cj",
	[32221] = "隐秘焚石/0/Cj",
	[32222] = "邪恶焚石/0/Cj",
	[32206] = "刚硬狮眼石/0/Cj",
	[31862] = "平衡德拉诺影钻/0/Cj",
	[31860] = "巨型德拉诺金钻/0/Cj",
	[31864] = "充能德拉诺影钻/0/Cj",
	[31866] = "隐秘火榴石/0/Cj",
	[31869] = "邪恶火榴石/0/Cj",
	[2302] = "手工皮靴/29/Cl",
	[7277] = "手工皮护腕/28/Cl",
	[7276] = "手工皮披风/34/Cl",
	[5957] = "手工皮外衣/40/Cl",
	[2304] = "轻型护甲片/15/Cl",
	[2318] = "轻皮/15/SbCl",
	[2303] = "手工皮短裤/71/Cl",
	[4237] = "手工皮带/34/Cl",
	[7278] = "轻皮箭袋/25/Cl",
	[7279] = "皮质小弹药包/25/Cl",
	[7280] = "皱褶皮短裤/162/Cl",
	[4231] = "熟化轻毛皮/110/Cl",
	[2300] = "雕花皮外衣/192/Cl",
	[5081] = "科多兽皮包/250/Cl",
	[2309] = "雕花皮靴/268/Cl",
	[4239] = "雕花皮手套/71/Cl",
	[2310] = "雕花皮质披风/112/Cl",
	[2311] = "白色皮夹克/150/Cl",
	[7281] = "轻皮护腕/84/Cl",
	[4242] = "雕花皮短裤/347/Cl",
	[2312] = "优质皮手套/181/Cl",
	[4246] = "优质皮带/125/Cl",
	[2308] = "优质皮披风/267/Cl",
	[4243] = "优质皮外套/461/Cl",
	[6466] = "蛇鳞披风/413/Cl",
	[6709] = "月光外衣/545/Cl",
	[5780] = "鱼人鳞片腰带/156/Cl",
	[2307] = "优质皮靴/243/Cl",
	[7282] = "轻皮短裤/599/Cl",
	[5781] = "鱼人鳞片胸甲/601/Cl",
	[7283] = "黑色幼龙披风/519/Cl",
	[20575] = "黑色幼龙外套/743/Cl",
	[2317] = "黑皮外套/689/Cl",
	[4244] = "山地皮外衣/723/Cl",
	[4233] = "熟化中毛皮/200/Cl",
	[2315] = "黑皮战靴/307/Cl",
	[2313] = "中型护甲片/200/Cl",
	[2319] = "中皮/50/Sc",
	[6467] = "蛇鳞手套/420/Cl",
	[5958] = "优质皮裤/829/Cl",
	[2316] = "黑皮披风/408/Cl",
	[6468] = "蛇鳞腰带/658/Cl",
	[5961] = "黑皮短裤/1089/Cl",
	[4248] = "黑皮手套/791/Cl",
	[4250] = "山地腰带/705/Cl",
	[7285] = "轻巧的皮手套/588/Cl",
	[7284] = "红色幼龙手套/586/Cl",
	[2314] = "韧化皮甲/743/Cl",
	[4249] = "黑皮腰带/703/Cl",
	[7348] = "造弓师手套/690/Cl",
	[4251] = "山地护肩/1199/Cl",
	[4253] = "韧化皮手套/962/Cl",
	[7352] = "土灵皮护肩/1306/Cl",
	[7349] = "采药师手套/861/Cl",
	[4252] = "黑皮护肩/1457/Cl",
	[7358] = "窃贼手套/885/Cl",
	[4255] = "绿色皮甲/2366/Cl",
	[7359] = "重型土灵手套/978/Cl",
	[4247] = "山地皮手套/1049/Cl",
	[4254] = "野人手套/1071/Cl",
	[7372] = "重皮弹药包/500/Cl",
	[7371] = "重型箭袋/500/Cl",
	[4236] = "熟化重毛皮/225/Cl",
	[4265] = "重型护甲片/650/Cl",
	[4234] = "重皮/150/Sd",
	[18662] = "重皮球/5/Cl",
	[3719] = "山地披风/1027/Cl",
	[18948] = "野人护腕/1589/Cl",
	[4456] = "迅猛龙皮腰带/1553/Cl",
	[4455] = "迅猛龙皮背心/3096/Cl",
	[4257] = "绿色皮带/1311/Cl",
	[5962] = "守护短裤/2794/Cl",
	[7373] = "暗色皮护腿/3097/Cl",
	[5963] = "野人护腿/3151/Cl",
	[4258] = "守护腰带/1592/Cl",
	[5782] = "厚鱼人皮甲/3211/Cl",
	[4262] = "宝石皮带/2652/Cl",
	[5964] = "野人护肩/2609/Cl",
	[7374] = "暗色皮甲/3760/Cl",
	[7375] = "绿色幼龙护甲/3773/Cl",
	[4256] = "守护之甲/3477/Cl",
	[7377] = "冰霜皮质披风/2269/Cl",
	[4259] = "绿色皮护腕/1934/Cl",
	[7378] = "暗色护腕/2146/Cl",
	[5965] = "守护披风/2536/Cl",
	[17721] = "冬天爷爷的手套/2268/Cl",
	[7386] = "绿色幼龙护腕/2387/Cl",
	[5783] = "鱼人鳞片护腕/2316/Cl",
	[5739] = "野人背心/2738/Cl",
	[5966] = "守护手套/1374/Cl",
	[7387] = "暗色皮带/2587/Cl",
	[4260] = "守护腕甲/2559/Cl",
	[18238] = "影皮手套/3321/Cl",
	[4264] = "野人腰带/2804/Cl",
	[8174] = "舒适的皮帽/4131/Cl",
	[7390] = "暗色长靴/4237/Cl",
	[7391] = "迅捷之靴/4253/Cl",
	[8172] = "熟化厚毛皮/500/Cl",
	[8173] = "厚重护甲片/1000/Cl",
	[4304] = "厚皮/300/Se",
	[8176] = "夜色头带/4495/Cl",
	[8175] = "夜色外套/5971/Cl",
	[8187] = "龟壳手套/3477/Cl",
	[8192] = "夜色护肩/4782/Cl",
	[8198] = "龟壳护腕/4013/Cl",
	[8189] = "龟壳胸甲/7567/Cl",
	[8210] = "蛮皮护肩/5537/Cl",
	[8200] = "巫毒长袍/7275/Cl",
	[8214] = "蛮皮头盔 /6230/Cl",
	[8211] = "蛮皮外衣/8002/Cl",
	[8201] = "巫毒面具/5350/Cl",
	[8205] = "硬化蝎壳护腕/4346/Cl",
	[8203] = "硬化蝎壳胸甲/8628/Cl",
	[8217] = "快捷箭袋/1000/Cl",
	[8218] = "厚皮弹药包/1000/Cl",
	[8204] = "硬化蝎壳手套/4676/Cl",
	[8193] = "夜色短裤/8708/Cl",
	[8191] = "龟壳头盔/7780/Cl",
	[8197] = "夜色长靴/7158/Cl",
	[8209] = "硬化蝎壳战靴/8375/Cl",
	[8185] = "龟壳护腿/10952/Cl",
	[8213] = "蛮皮战靴/8150/Cl",
	[8216] = "巫毒披风/6323/Cl",
	[8202] = "巫毒短裤/9022/Cl",
	[8207] = "硬化蝎壳护肩/8978/Cl",
	[8215] = "蛮皮披风/9017/Cl",
	[8212] = "蛮皮护腿/11585/Cl",
	[8206] = "硬化蝎壳护腿/12704/Cl",
	[8208] = "硬化蝎壳头盔/10272/Cl",
	[15407] = "熟化毛皮/500/Cl",
	[15564] = "毛皮护甲片/1000/Cl",
	[8170] = "硬甲皮/500/Sf",
	[15077] = "重型蝎壳护腕/7615/Cl",
	[15045] = "绿龙鳞片胸甲/19938/Cl",
	[15083] = "邪恶皮甲护手/6872/Cl",
	[15074] = "奇美拉手套/6867/Cl",
	[15076] = "重型蝎壳外衣/16604/Cl",
	[15084] = "邪恶皮甲护腕/7311/Cl",
	[15046] = "绿龙鳞片护腿/22482/Cl",
	[15067] = "铁羽护肩/12758/Cl",
	[15061] = "生命护肩/13803/Cl",
	[15091] = "符文皮甲护手/7195/Cl",
	[15054] = "火山护腿/14559/Cl",
	[15057] = "雷暴短裤/18728/Cl",
	[15064] = "战熊背心/19717/Cl",
	[15073] = "奇美拉长靴/11530/Cl",
	[15071] = "霜刃长靴/11443/Cl",
	[45] = "重型蝎壳护手/0/Cl",
	[15078] = "重型蝎壳护手/9649/Cl",
	[15092] = "符文皮甲护腕/7656/Cl",
	[15072] = "奇美拉护腿/16233/Cl",
	[15082] = "重型蝎壳腰带/10375/Cl",
	[15093] = "符文皮甲腰带/8368/Cl",
	[15086] = "邪恶皮甲头环/13154/Cl",
	[15048] = "蓝龙鳞片胸甲/24409/Cl",
	[15060] = "生命护腿/21277/Cl",
	[15056] = "雷暴护甲/20966/Cl",
	[15065] = "战熊热裤/22233/Cl",
	[15069] = "霜刃护腿/17012/Cl",
	[15079] = "重型蝎壳护腿/21760/Cl",
	[15053] = "火山胸甲/17275/Cl",
	[15050] = "黑色龙鳞胸甲/26071/Cl",
	[19052] = "黎明皮靴/17621/Cl",
	[15063] = "魔暴龙手套/11701/Cl",
	[15066] = "铁羽胸甲/23650/Cl",
	[19044] = "木喉之力/11116/Cl",
	[15075] = "奇美拉外衣/18449/Cl",
	[15094] = "符文皮甲头环/14155/Cl",
	[15087] = "邪恶皮甲短裤/17892/Cl",
	[16982] = "熔岩犬皮靴/24397/Cl",
	[15049] = "蓝龙鳞片护肩/20543/Cl",
	[15058] = "雷暴护肩/14692/Cl",
	[15070] = "霜刃手套/9504/Cl",
	[15080] = "重型蝎壳头盔/18230/Cl",
	[16984] = "黑色龙鳞战靴/32653/Cl",
	[18509] = "多彩披风/23006/Cl",
	[19157] = "多彩护手/31943/Cl",
	[19162] = "熔火犬皮腰带/27831/Cl",
	[20380] = "梦幻龙鳞胸甲/52455/Cl",
	[18510] = "野性之皮/20889/Cl",
	[22665] = "寒鳞护腕/50516/Cl",
	[22664] = "寒鳞胸甲/100642/Cl",
	[22666] = "寒鳞护手/50712/Cl",
	[19149] = "熔岩腰带/21248/Cl",
	[19163] = "熔火腰带/27931/Cl",
	[16983] = "熔铸头盔/25709/Cl",
	[22663] = "北极护腕/46175/Cl",
	[22662] = "北极手套/44851/Cl",
	[22661] = "北极外套/89377/Cl",
	[18511] = "移形披风/20971/Cl",
	[15052] = "黑色龙鳞护腿/31933/Cl",
	[15051] = "黑色龙鳞护肩/21736/Cl",
	[19688] = "血虎胸甲/31546/Cl",
	[19689] = "血虎护肩/24082/Cl",
	[22761] = "荆木腰带/19607/Cl",
	[22760] = "荆木靴子/29302/Cl",
	[22759] = "荆木头盔/29190/Cl",
	[18251] = "熔核护甲片/5000/Cl",
	[15062] = "魔暴龙皮护腿/25709/Cl",
	[18504] = "洞察束带/14126/Cl",
	[19058] = "金色黎明衬肩/21845/Cl",
	[15059] = "生命胸甲/24776/Cl",
	[18506] = "猫鼬长靴/21340/Cl",
	[15138] = "奥妮克希亚鳞片披风/15198/Cl",
	[19687] = "原始蝙蝠皮护腕/15939/Cl",
	[19686] = "原始蝙蝠皮手套/15270/Cl",
	[19685] = "原始蝙蝠皮外套/29288/Cl",
	[15047] = "红龙鳞片胸甲/29836/Cl",
	[20476] = "沙行者护腕/16401/Cl",
	[20478] = "沙行者胸甲/33917/Cl",
	[20477] = "沙行者护手/16898/Cl",
	[20481] = "飞火护腕/17139/Cl",
	[20479] = "飞火胸甲/34036/Cl",
	[20480] = "飞火护手/17078/Cl",
	[21278] = "雷暴手套/13212/Cl",
	[18508] = "迅行护腕/17194/Cl",
	[19049] = "木喉作战手套/15576/Cl",
	[25654] = "魔鳞手套/17436/Cl",
	[15068] = "霜刃外套/21835/Cl",
	[15081] = "重型蝎壳护肩/20261/Cl",
	[15090] = "符文皮甲/22002/Cl",
	[15095] = "符文皮甲短裤/20885/Cl",
	[15096] = "符文皮甲护肩/17332/Cl",
	[25662] = "缀鳞德拉诺短裤/32525/Cl",
	[25669] = "厚重德莱尼手套/14274/Cl",
	[15055] = "火山护肩/16019/Cl",
	[15085] = "邪恶皮甲/22732/Cl",
	[15088] = "邪恶皮甲腰带/9901/Cl",
	[25673] = "野性德莱尼长靴/21717/Cl",
	[25679] = "鞋垫/466/Cl",
	[25650] = "结缔皮护甲片/7500/Cl",
	[21887] = "结缔皮/1250/Cl",
	[25655] = "魔鳞长靴/26106/Cl",
	[25661] = "缀鳞德拉诺手套/29461/Cl",
	[25674] = "野性德莱尼手套/15897/Cl",
	[25670] = "厚重德莱尼短裤/32249/Cl",
	[25656] = "魔鳞短裤/36782/Cl",
	[25668] = "厚重德莱尼长靴/24047/Cl",
	[25675] = "野性德莱尼护腿/30530/Cl",
	[29540] = "加固矿工袋/30000/Cl",
	[25660] = "缀鳞德拉诺外套/38316/Cl",
	[23793] = "重结缔皮/6250/SCl",
	[25652] = "魔导师的护甲片/22500/Cl",
	[25651] = "守备官的护甲片/22500/Cl",
	[25671] = "厚重德莱尼外套/35070/Cl",
	[25676] = "野性德莱尼外套/32311/Cl",
	[29534] = "裂蹄腿甲片/20000/Cl",
	[29533] = "眼镜蛇皮腿甲片/20000/Cl",
	[25657] = "魔鳞胸甲/39930/Cl",
	[25659] = "缀鳞德拉诺长靴/62470/Cl",
	[25685] = "魔能皮甲手套/20771/Cl",
	[25694] = "虚空之怒腰带/25734/Cl",
	[25692] = "虚空之怒护腿/51110/Cl",
	[29488] = "奥术护甲片/15000/Cl",
	[29528] = "战争之鼓/5000/Cl",
	[29485] = "烈焰护甲片/15000/Cl",
	[29486] = "冰霜护甲片/15000/Cl",
	[29487] = "自然护甲片/15000/Cl",
	[29483] = "暗影护甲片/15000/Cl",
	[29530] = "速度之鼓/5000/Cl",
	[29500] = "爆炸防护腰带/21281/Cl",
	[29499] = "爆炸防护长靴/31803/Cl",
	[29498] = "爆炸防护短裤/42245/Cl",
	[29497] = "魔化裂蹄长靴/31564/Cl",
	[29496] = "魔化裂蹄手套/20965/Cl",
	[29495] = "魔化裂蹄护腿/41772/Cl",
	[29491] = "魔化邪鳞长靴/40049/Cl",
	[29490] = "魔化邪鳞手套/26486/Cl",
	[29489] = "魔化邪鳞护腿/52781/Cl",
	[25686] = "魔能皮甲长靴/32862/Cl",
	[25687] = "魔能皮甲护腿/43976/Cl",
	[25695] = "魔能猎手腰带/24563/Cl",
	[29494] = "焰鳞腰带/24968/Cl",
	[29493] = "焰鳞长靴/40332/Cl",
	[29492] = "焰鳞护腿/53353/Cl",
	[25693] = "虚空之怒长靴/36667/Cl",
	[25653] = "马鞭/17500/Cl",
	[25681] = "斯蒂林的冒险帽/66290/Cl",
	[25683] = "斯蒂林的赤链帽/37986/Cl",
	[25682] = "斯蒂林的丛林帽/31539/Cl",
	[25680] = "斯蒂林的紫皮帽/31300/Cl",
	[29531] = "恢复之鼓/5000/Cl",
	[25691] = "厚重裂蹄长靴/33726/Cl",
	[25690] = "厚重裂蹄护腿/44808/Cl",
	[46] = "魔能猎手护腕/0/Cl",
	[25697] = "魔能猎手护腕/25155/Cl",
	[25696] = "魔能猎手胸甲/50116/Cl",
	[25689] = "厚重裂蹄外套/45010/Cl",
	[29503] = "眼镜蛇鳞片手套/24742/Cl",
	[29502] = "眼镜蛇鳞片兜帽/533/Cl",
	[29512] = "土灵虚鳞长靴/42922/Cl",
	[29506] = "生命之触手套/25014/Cl",
	[29505] = "源生生命罩帽/37384/Cl",
	[29508] = "生命龙鳞头盔/45350/Cl",
	[29511] = "虚空幼龙手套/28381/Cl",
	[29510] = "虚空幼龙头盔/42408/Cl",
	[29514] = "厚重虚空鳞片胸甲/57415/Cl",
	[29504] = "风鳞兜帽/37247/Cl",
	[29507] = "风斩裹手/34308/Cl",
	[29509] = "风击手套/30343/Cl",
	[29529] = "战斗之鼓/5000/Cl",
	[29536] = "虚空裂蹄腿甲片/40000/Cl",
	[29535] = "虚空毒蛇腿甲片/40000/Cl",
	[29532] = "恐慌之鼓/5000/Cl",
	[8347] = "龙鳞护手/5979/Cl",
	[8367] = "龙鳞胸甲/18455/Cl",
	[29971] = "龙击护腿/9022/Cl",
	[20296] = "绿色龙鳞护手/12590/Cl",
	[20295] = "蓝龙鳞片护腿/31083/Cl",
	[29975] = "金色龙击胸甲/79950/Cl",
	[29516] = "黑色虚鳞腰带/31638/Cl",
	[29517] = "黑色虚鳞护腕/31758/Cl",
	[29515] = "黑色虚鳞胸甲/63043/Cl",
	[29520] = "虚空打击腰带/32114/Cl",
	[29521] = "虚空打击护腕/19896/Cl",
	[29519] = "虚空打击胸甲/34629/Cl",
	[8346] = "深海护手/5363/Cl",
	[8348] = "火焰头盔/10819/Cl",
	[29964] = "黑色风暴护腿/15290/Cl",
	[29973] = "原始风暴胸甲/38564/Cl",
	[29526] = "原始打击腰带/28074/Cl",
	[29527] = "原始打击护腕/28172/Cl",
	[29525] = "原始打击外衣/54518/Cl",
	[8345] = "狼头之盔/7421/Cl",
	[8349] = "羽饰胸甲/14478/Cl",
	[29970] = "野羽护腿/1361/Cl",
	[29974] = "生命水晶胸甲/474/Cl",
	[29524] = "风鹰腰带/27169/Cl",
	[29523] = "风鹰护腕/19065/Cl",
	[29522] = "风鹰胸甲/53924/Cl",
	[47] = "熔炼铜锭/0/Cs",
	[2840] = "铜锭/10/Cs",
	[48] = "熔炼青铜/0/Cs",
	[2841] = "青铜锭/50/Cs",
	[49] = "熔炼锡锭/0/Cs",
	[3576] = "锡锭/35/Cs",
	[50] = "熔炼银锭/0/Cs",
	[2842] = "银锭/100/Cs",
	[51] = "熔炼铁锭/0/Cs",
	[3575] = "铁锭/200/Cs",
	[52] = "熔炼金锭/0/Cs",
	[53] = "熔炼钢锭/0/Cs",
	[3859] = "钢锭/60/Cs",
	[54] = "熔炼秘银/0/Cs",
	[3860] = "秘银锭/400/Cs",
	[55] = "熔炼真银/0/Cs",
	[56] = "熔炼黑铁/0/Cs",
	[11371] = "黑铁锭/600/Cs",
	[57] = "熔炼瑟银/0/Cs",
	[12359] = "瑟银锭/600/Cs",
	[58] = "熔炼源质/0/Cs",
	[17771] = "源质锭/0/Cs",
	[59] = "敲碎源生之土/0/Cs",
	[22573] = "土之微粒/400/MlMmMnD",
	[60] = "火焰碎裂/0/Cs",
	[22574] = "火焰微粒/400/DMl",
	[61] = "熔炼魔铁/0/Cs",
	[23445] = "魔铁锭/2000/Cs",
	[62] = "熔炼精金/0/Cs",
	[23446] = "精金锭/3000/Cs",
	[63] = "熔炼恒金/0/Cs",
	[23447] = "恒金锭/2500/Cs",
	[64] = "熔炼魔钢/0/Cs",
	[23448] = "魔钢锭/22500/Cs",
	[65] = "熔炼氪金/0/Cs",
	[23449] = "氪金锭/12500/Cs",
	[66] = "熔炼硬化精金/0/Cs",
	[23573] = "硬化精金锭/30000/Cs",
	[2996] = "亚麻布卷/40/Ct",
	[4344] = "棕色亚麻衬衣/11/Ct",
	[2570] = "亚麻披风/11/Ct",
	[10045] = "简易亚麻短裤/23/Ct",
	[2576] = "白色亚麻衬衣/75/Ct",
	[2568] = "棕色亚麻外衣/31/Ct",
	[7026] = "亚麻腰带/22/Ct",
	[10046] = "简易的亚麻靴/32/Ct",
	[6238] = "棕色亚麻长袍/98/Ct",
	[6241] = "白色亚麻长袍/99/Ct",
	[4343] = "棕色亚麻短裤/60/Ct",
	[4307] = "高级亚麻手套/29/Ct",
	[2572] = "红色亚麻长袍/99/Ct",
	[2577] = "蓝色亚麻衬衣/75/Ct",
	[2575] = "红色亚麻衬衣/25/Ct",
	[6786] = "简易的裙子/59/Ct",
	[4238] = "亚麻包/200/Ct",
	[6240] = "蓝色亚麻外衣/161/Ct",
	[6239] = "红色亚麻外衣/160/Ct",
	[4308] = "绿色亚麻护腕/45/Ct",
	[2580] = "强化亚麻斗篷/67/Ct",
	[2569] = "亚麻靴/87/Ct",
	[2578] = "野人亚麻外衣/224/Ct",
	[6242] = "蓝色亚麻长袍/243/Ct",
	[4309] = "手工亚麻裤/226/Ct",
	[2579] = "绿色亚麻衬衣/37/Ct",
	[5762] = "红色亚麻包/250/Ct",
	[2997] = "毛布卷/100/Ct",
	[10047] = "简易的褶裙/164/Ct",
	[2584] = "毛纺斗篷/142/Ct",
	[4312] = "软底亚麻靴/237/Ct",
	[4240] = "毛纺包/300/Ct",
	[4310] = "高级毛纺手套/180/Ct",
	[2582] = "绿色毛纺外衣/216/Ct",
	[5542] = "珍珠披风/370/Ct",
	[4313] = "红色毛纺靴/416/Ct",
	[2583] = "毛纺靴/359/Ct",
	[4241] = "绿色毛纺包/450/Ct",
	[6263] = "蓝色罩衫/589/Ct",
	[4311] = "重型毛纺披风/475/Ct",
	[2587] = "灰色毛纺衬衣/200/Ct",
	[2585] = "灰色毛纺长袍/638/Ct",
	[4316] = "高级毛纺短裤/743/Ct",
	[4314] = "双线毛纺护肩/331/Ct",
	[4330] = "漂亮的红衬衣/250/Ct",
	[6787] = "白色毛绒裙/466/Ct",
	[6264] = "大师长袍/884/Ct",
	[4332] = "淡黄色衬衣/500/Ct",
	[5763] = "红色毛纺包/700/Ct",
	[10048] = "多彩褶裙/935/Ct",
	[4315] = "强化毛纺护肩/425/Ct",
	[6384] = "漂亮的蓝衬衣/250/Ct",
	[6385] = "漂亮的绿衬衣/250/Ct",
	[4320] = "蛛丝之靴/979/Ct",
	[4331] = "凤凰手套/526/Ct",
	[4317] = "凤凰短裤/1076/Ct",
	[4305] = "丝绸卷/600/Ct",
	[4318] = "冥想手套/610/Ct",
	[4319] = "碧蓝丝质手套/815/Ct",
	[5766] = "次级巫师袍/1338/Ct",
	[4333] = "黑丝衬衣/1200/Ct",
	[7046] = "碧蓝丝质短裤/1494/Ct",
	[4321] = "蛛丝便鞋/1120/Ct",
	[7047] = "黑暗之手/824/Ct",
	[7048] = "碧蓝丝质头巾/745/Ct",
	[4324] = "碧蓝丝质外衣/1874/Ct",
	[5770] = "奥法之袍/1807/Ct",
	[7049] = "信念手套/914/Ct",
	[4245] = "丝绸小包/2000/Ct",
	[4322] = "巫术师兜帽/1810/Ct",
	[7050] = "丝质头带/999/Ct",
	[6795] = "白色冒险者衬衣/500/Ct",
	[7065] = "绿色丝甲/2398/Ct",
	[7051] = "土灵外衣/2696/Ct",
	[4323] = "暗影头巾/1999/Ct",
	[4334] = "体面的白衬衣/550/Ct",
	[7052] = "碧蓝丝质腰带/1488/Ct",
	[7053] = "碧蓝丝质披风/2240/Ct",
	[4325] = "附魔师长靴/2272/Ct",
	[7055] = "深红丝质腰带/1503/Ct",
	[4339] = "魔纹布卷/1250/Ct",
	[5764] = "绿色丝质包/3000/Ct",
	[6796] = "红色冒险者衬衣/750/Ct",
	[7056] = "深红丝质披风/2314/Ct",
	[7057] = "绿色丝质护肩/2323/Ct",
	[4328] = "蜘蛛腰带/1524/Ct",
	[4336] = "黑色冒险者衬衣/1500/Ct",
	[4326] = "丝质长披风/2496/Ct",
	[5765] = "黑色丝质背包/4000/Ct",
	[7058] = "深红丝质外衣/2052/Ct",
	[4335] = "紫色丝质衬衣/1500/Ct",
	[7054] = "力量法袍/4700/Ct",
	[7060] = "碧蓝护肩/2791/Ct",
	[7059] = "深红丝质护肩/2781/Ct",
	[17723] = "绿色节日衬衣/750/Ct",
	[7061] = "土灵丝质腰带/2017/Ct",
	[7062] = "深红丝质马裤/2430/Ct",
	[10052] = "橙色军用衬衣/1500/Ct",
	[4327] = "冰覆披风/3788/Ct",
	[4329] = "星辰腰带/2120/Ct",
	[9999] = "黑色魔纹短裤/4832/Ct",
	[9998] = "黑色魔纹外衣/4815/Ct",
	[7063] = "深红丝质长袍/4741/Ct",
	[10054] = "紫色魔纹衬衣/3000/Ct",
	[10001] = "黑色魔纹长袍/5257/Ct",
	[7064] = "深红丝质手套/2569/Ct",
	[10002] = "影纹短裤/5276/Ct",
	[10055] = "粉红魔纹衬衣/3000/Ct",
	[10003] = "黑色魔纹手套/2859/Ct",
	[10009] = "红色魔纹短裤/5284/Ct",
	[10007] = "红色魔纹外衣/5799/Ct",
	[10004] = "影纹长袍/5738/Ct",
	[10008] = "白色强盗面罩/4365/Ct",
	[10056] = "橙色魔纹衬衣/1500/Ct",
	[10034] = "礼服衬衣/2000/Ct",
	[10035] = "礼服长裤/1735/Ct",
	[10019] = "梦纹手套/3944/Ct",
	[10021] = "梦纹外衣/7946/Ct",
	[10030] = "将军之帽/6007/Ct",
	[10042] = "灰布长袍/6644/Ct",
	[22246] = "魔化魔纹布包/2500/Ct",
	[10018] = "红色魔纹手套/3275/Ct",
	[10023] = "影纹手套/3334/Ct",
	[10050] = "魔纹包/2500/Ct",
	[10040] = "白色婚纱/1767/Ct",
	[10026] = "黑色魔纹之靴/5459/Ct",
	[10024] = "黑色魔纹头带/5421/Ct",
	[10027] = "黑色魔纹护肩/5479/Ct",
	[10025] = "影纹面罩/6790/Ct",
	[10029] = "红色魔纹护肩/5391/Ct",
	[10028] = "影纹护肩/5938/Ct",
	[10051] = "红色魔纹包/2500/Ct",
	[10053] = "简易的黑裙子/4499/Ct",
	[10036] = "礼服夹克/1741/Ct",
	[13868] = "霜纹长袍/9665/Ct",
	[10033] = "红色魔纹头带/6075/Ct",
	[10031] = "影纹之靴/6030/Ct",
	[10044] = "灰布长靴/6765/Ct",
	[10041] = "梦纹头饰/7161/Ct",
	[14048] = "符文布卷/2000/Ct",
	[21154] = "节庆长裙/1/Ct",
	[67] = "红色节庆裤子/0/Ct",
	[21542] = "节庆服装/1/Ct",
	[14342] = "月布/4000/Ct",
	[13869] = "霜纹外套/9702/Ct",
	[13856] = "符文布腰带/5112/Ct",
	[14042] = "灰布外衣/10561/Ct",
	[13858] = "符文布袍/10917/Ct",
	[13857] = "符文布外套/10878/Ct",
	[21340] = "灵魂袋/5000/Ct",
	[14046] = "符文布背包/5000/Ct",
	[13870] = "霜纹手套/5471/Ct",
	[14143] = "鬼纹腰带/5763/Ct",
	[13860] = "符文布披风/8741/Ct",
	[14101] = "亮布手套/6066/Ct",
	[14100] = "亮布长袍/12089/Ct",
	[14043] = "灰布手套/5955/Ct",
	[14142] = "鬼纹手套/6087/Ct",
	[14134] = "火焰披风/11280/Ct",
	[14103] = "亮布披风/9716/Ct",
	[22251] = "塞纳里奥草药包/10000/Ct",
	[14044] = "灰布披风/9503/Ct",
	[22248] = "魔化符文布包/10000/Ct",
	[14107] = "恶魔布短裤/13140/Ct",
	[14141] = "鬼纹外衣/12859/Ct",
	[13863] = "符文布手套/6617/Ct",
	[14132] = "巫纹护腿/12441/Ct",
	[21341] = "恶魔布包/20000/Ct",
	[14045] = "灰布短裤/13480/Ct",
	[13871] = "霜纹短裤/13436/Ct",
	[13864] = "符文布靴/9553/Ct",
	[14140] = "月布头饰/16693/Ct",
	[18486] = "月布长袍/21683/Ct",
	[14139] = "月布护肩/15840/Ct",
	[14138] = "月布外衣/20042/Ct",
	[14136] = "冬夜法袍/17025/Ct",
	[14108] = "恶魔布靴/11112/Ct",
	[13865] = "符文布短裤/13555/Ct",
	[19056] = "银色长靴/12941/Ct",
	[15802] = "月布长靴/11648/Ct",
	[14137] = "月布护腿/18113/Ct",
	[19047] = "木喉之智/9232/Ct",
	[14104] = "亮布短裤/15484/Ct",
	[14111] = "恶魔布帽/10775/Ct",
	[14144] = "鬼纹短裤/14374/Ct",
	[13866] = "符文布头带/11358/Ct",
	[18405] = "大法师腰带/14744/Ct",
	[21342] = "熔火恶魔布包/80000/Ct",
	[16979] = "光芒手套/14901/Ct",
	[19165] = "光芒护腿/45006/Ct",
	[16980] = "光芒衬肩/21365/Ct",
	[19156] = "光芒长袍/34911/Ct",
	[18263] = "光芒护腕/16911/Ct",
	[22658] = "冰川披风/53045/Ct",
	[22654] = "冰川护手/34846/Ct",
	[22652] = "冰川外衣/69171/Ct",
	[22655] = "冰川护腕/34973/Ct",
	[14146] = "法术掌握手套/14084/Ct",
	[14152] = "大法师之袍/28815/Ct",
	[14153] = "虚空法袍/28920/Ct",
	[14154] = "信念外衣/29028/Ct",
	[19059] = "银色护肩/17541/Ct",
	[19684] = "血藤长靴/18915/Ct",
	[19683] = "血藤护腿/25129/Ct",
	[19682] = "血藤外衣/24872/Ct",
	[14156] = "无底包/40000/Ct",
	[18413] = "监护披风/17070/Ct",
	[18407] = "恶魔布手套/11139/Ct",
	[22660] = "盖亚的拥抱/24601/Ct",
	[18408] = "地狱火手套/11178/Ct",
	[19050] = "木喉衬肩/18758/Ct",
	[18409] = "月布手套/11219/Ct",
	[20539] = "符文冥河腰带/11908/Ct",
	[20537] = "符文冥河长靴/17736/Ct",
	[20538] = "符文冥河护腿/22703/Ct",
	[22757] = "林栖者头冠/24961/Ct",
	[22758] = "林栖者护肩/25051/Ct",
	[22756] = "林栖者外套/33164/Ct",
	[22249] = "大附魔袋/30000/Ct",
	[14106] = "恶魔布袍/18053/Ct",
	[14112] = "恶魔布护肩/13509/Ct",
	[68] = "戈多克巨魔装/0/Cl",
	[69] = "戈多克巨魔装/0/Ct",
	[14155] = "月布包/20000/Ct",
	[13867] = "符文布护肩/12570/Ct",
	[22252] = "塞纳留斯之袋/30000/Ct",
	[14128] = "巫纹长袍/16093/Ct",
	[14130] = "巫纹头巾/12768/Ct",
	[21840] = "灵纹布卷/4000/Ct",
	[24268] = "灵纹投网/100/Ct",
	[21850] = "灵纹腰带/12306/Ct",
	[21849] = "灵纹护腕/12261/Ct",
	[21841] = "灵纹布包/10000/Ct",
	[21851] = "灵纹手套/13059/Ct",
	[21842] = "魔化灵纹布卷/8000/Ct",
	[21852] = "灵纹短裤/26926/Ct",
	[24269] = "重型地纹之网/100/Ct",
	[24273] = "秘法魔线/20000/Ct",
	[24275] = "银色魔线/20000/Ct",
	[21853] = "灵纹长靴/21336/Ct",
	[21859] = "魔化灵纹短裤/31883/Ct",
	[24270] = "珠宝袋/30000/Ct",
	[21843] = "魔化灵纹布包/10000/Ct",
	[21854] = "灵纹长袍/29267/Ct",
	[21855] = "灵纹外套/30091/Ct",
	[21844] = "灵魂布卷/8000/Ct",
	[21866] = "奥法交织护腕/17197/Ct",
	[24251] = "黑色侵袭护腕/16690/Ct",
	[24250] = "浩劫护腕/16626/Ct",
	[30831] = "奥术闪避披风/25066/Ct",
	[24253] = "永恒披风/25223/Ct",
	[24252] = "黑色虚空披风/25128/Ct",
	[30837] = "烈焰之心护腕/17088/Ct",
	[21860] = "魔化灵纹长靴/24616/Ct",
	[21845] = "原始月布/4000/Ct",
	[24272] = "暗影布/4000/Ct",
	[24271] = "魔法布/4000/Ct",
	[24249] = "不屈护腕/16563/Ct",
	[24254] = "白色治愈斗篷/26001/Ct",
	[21863] = "灵魂布手套/20474/Ct",
	[21867] = "奥法交织长靴/26309/Ct",
	[30838] = "烈焰之心手套/17430/Ct",
	[21861] = "魔化灵纹长袍/34308/Ct",
	[21862] = "魔化灵纹外套/34437/Ct",
	[24257] = "黑色知识腰带/21095/Ct",
	[24256] = "毁灭束带/21018/Ct",
	[24260] = "法力编织披风/31984/Ct",
	[24258] = "坚毅披风/31757/Ct",
	[21864] = "灵魂布护肩/30824/Ct",
	[24255] = "不屈束带/20942/Ct",
	[24259] = "复仇披风/31869/Ct",
	[21868] = "奥法交织长袍/35486/Ct",
	[30839] = "烈焰之心外衣/35267/Ct",
	[24267] = "战斗施法罩帽/29676/Ct",
	[24263] = "战斗施法短裤/43100/Ct",
	[24276] = "金色魔线/50000/Ct",
	[24274] = "符文魔线/50000/Ct",
	[21865] = "灵魂布外衣/41251/Ct",
	[24266] = "法术打击兜帽/30889/Ct",
	[24262] = "法术打击短裤/42951/Ct",
	[32585] = "迅捷治疗衬肩/0/Ct",
	[32584] = "迅捷治疗护腕/0/Ct",
	[24264] = "白色治愈兜帽/32440/Ct",
	[24261] = "白色治愈短裤/42798/Ct",
	[21872] = "黑色暗影背包/40000/Ct",
	[21876] = "原始月布包/50000/Ct",
	[21858] = "魔焰背包/20000/Ct",
	[30463] = "生命之血腰带/0/Ct",
	[30464] = "生命之血护腕/0/Ct",
	[30465] = "生命之血护腿/0/Ct",
	[30460] = "虚空烈焰腰带/0/Ct",
	[30461] = "虚空烈焰长靴/0/Ct",
	[30459] = "虚空烈焰之袍/0/Ct",
	[21873] = "原始月布腰带/22185/Ct",
	[21874] = "原始月布护肩/33398/Ct",
	[21875] = "原始月布长袍/41510/Ct",
	[21869] = "冰霜暗纹护肩/32801/Ct",
	[21870] = "冰霜暗纹长靴/32921/Ct",
	[21871] = "冰霜暗纹外衣/44055/Ct",
	[21846] = "魔焰腰带/21632/Ct",
	[21847] = "魔焰手套/21712/Ct",
	[21848] = "魔焰长袍/43584/Ct",
	[2449] = "地根草/20/H",
	[765] = "银叶草/10/H",
	[3371] = "空瓶/4/V",
	[2447] = "宁神花/10/H",
	[785] = "魔皇草/20/H",
	[3164] = "变色的狼心/33/D",
	[2452] = "雨燕草/15/H",
	[2450] = "石南草/25/H",
	[5635] = "锋利的爪子/45/D",
	[6358] = "黑口鱼/4/F",
	[6522] = "变异鱼/4/F",
	[3820] = "荆棘藻/100/H",
	[2453] = "跌打草/25/H",
	[3372] = "铅瓶/40/V",
	[3355] = "野钢花/50/H",
	[1288] = "大毒囊/185/D",
	[6359] = "火鳞鳝鱼/5/F",
	[3369] = "墓地苔/25/H",
	[3356] = "皇血草/30/H",
	[3357] = "活根草/75/H",
	[3818] = "枯叶草/125/H",
	[4402] = "火囊/250/D",
	[3821] = "金棘草/150/H",
	[5637] = "大牙齿/75/D",
	[3819] = "冬刺草/100/H",
	[3358] = "卡德加的胡须/175/H",
	[4625] = "火焰花/250/H",
	[9260] = "烈性朗姆酒/400/D",
	[8925] = "水晶瓶/500/V",
	[8831] = "紫莲花/300/H",
	[9262] = "黑色硫酸盐/1000/MfMhMjR",
	[7972] = "亡灵腐液/400/D",
	[3858] = "秘银矿石/250/Mf175",
	[8838] = "太阳草/60/H",
	[8153] = "野葡萄藤/5/H",
	[8836] = "阿尔萨斯之泪/95/H",
	[8845] = "幽灵菇/375/H",
	[4342] = "紫色染料/2500/V",
	[8839] = "盲目草/375/H",
	[8846] = "格罗姆之血/250/H",
	[13422] = "石鳞鳗/10/F",
	[13463] = "梦叶草/100/H",
	[13466] = "瘟疫花/250/H",
	[12363] = "奥术水晶/2000/MiMjMn",
	[13464] = "黄金参/100/H",
	[13465] = "山鼠草/150/H",
	[10620] = "瑟银矿石/250/Mj250",
	[13467] = "冰盖草/250/H",
	[10286] = "野性之心/400/D",
	[7067] = "元素之土/400/D",
	[11176] = "梦境之尘/0/Ek",
	[7070] = "元素之水/400/D",
	[12938] = "英雄之血/0/D",
	[19943] = "极效魔精/2000/D",
	[12804] = "强力魔精/2000/D",
	[13468] = "黑莲花/1000/H",
	[22785] = "魔草/500/H",
	[18256] = "灌魔之瓶/6000/V",
	[7077] = "火焰之心/400/D",
	[22787] = "邪雾草/600/H",
	[22786] = "梦露花/500/H",
	[22789] = "泰罗果/500/H",
	[22578] = "水之微粒/400/DF",
	[22790] = "远古苔/750/H",
	[22791] = "虚空花/1000/H",
	[22792] = "噩梦藤/1250/H",
	[22794] = "魔莲花/10000/H",
	[23079] = "翠榄石/10000/DMlMmMnR",
	[23107] = "德拉诺影钻/10000/DMlMmMnR",
	[23112] = "德拉诺金钻/10000/DMlMmMnR",
	[23077] = "血榴石/10000/DMlMmMnR",
	[21929] = "火榴石/10000/DMlMmMnR",
	[23117] = "碧月石/10000/DMlMmMnR",
	[22793] = "法力蓟/2500/H",
	[2835] = "劣质的石头/2/Ma1",
	[2589] = "亚麻布/13/D",
	[2880] = "弱效助熔剂/100/V",
	[774] = "孔雀石/15/DMaR",
	[2321] = "细线/100/V",
	[818] = "虎眼石/100/DMaR",
	[2836] = "粗糙的石头/15/Mb65",
	[2592] = "毛料/33/D",
	[1210] = "暗影石/250/DMaMbMcR",
	[3466] = "强效助熔剂/2000/V",
	[5498] = "有光泽的小珍珠/200/DG",
	[2838] = "沉重的石头/60/Me125",
	[1206] = "绿玛瑙/400/DMbMcR",
	[5500] = "彩色珍珠/750/DG",
	[1705] = "次级月亮石/600/DMbMcMdMeR",
	[2605] = "绿色染料/100/V",
	[3864] = "黄水晶/800/DMdMeMfMgR",
	[1529] = "翡翠/700/DMbMdMeR",
	[7069] = "元素空气/400/D",
	[7912] = "坚固的石头/100/Mf175",
	[4306] = "丝绸/150/D",
	[4338] = "魔纹布/250/D",
	[7909] = "青绿石/1000/DMeMfMgR",
	[7971] = "黑珍珠/1000/DG",
	[7075] = "大地之核/400/D",
	[12361] = "蓝宝石/7000/DMjR",
	[11188] = "黄色能量水晶/0/G",
	[11186] = "红色能量水晶/0/G",
	[12365] = "致密的石头/250/Mj250",
	[14047] = "符文布/400/D",
	[7910] = "红宝石/5000/DMfMgMjR",
	[11184] = "蓝色能量水晶/0/G",
	[12364] = "巨型绿宝石/10000/DMjR",
	[12799] = "大猫眼石/7000/DMjR",
	[12800] = "艾泽拉斯钻石/10000/DMjR",
	[11185] = "绿色能量水晶/0/G",
	[12662] = "恶魔符文/600/D",
	[12811] = "正义宝珠/20000/D",
	[17010] = "炽热之核/2000/D",
	[17011] = "熔岩之核/2000/D",
	[17203] = "萨弗隆铁锭/100000/D",
	[11382] = "山脉之血/750/DMhR",
	[22203] = "大块黑曜石碎片/5000/DM",
	[22202] = "小块黑曜石碎片/2500/DM",
	[12809] = "守护之石/10000/D",
	[17012] = "熔火犬皮/1000/St315",
	[22682] = "冰冻符文/20000/D",
	[8146] = "邪恶之爪/500/D",
	[20520] = "黑暗符文/2000/D",
	[15417] = "魔暴龙皮/500/Sn",
	[12753] = "暗影之皮/0/D",
	[20725] = "连结水晶/0/Eo",
	[19774] = "灵魂宝钻/5000/DMiR",
	[19726] = "血藤/500/H",
	[11754] = "黑钻石/0/DMhR",
	[8168] = "乌黑的羽毛/100/D",
	[21877] = "灵纹布/800/D",
	[22445] = "奥法之尘/0/Er",
	[23572] = "源生虚空/16000/D",
	[30183] = "虚空漩涡/20000/D",
	[32428] = "黑暗之心/0/D",
	[22450] = "虚空水晶/0/Es",
	[7081] = "风之气息/400/D",
	[4470] = "普通木柴/34/V",
	[6291] = "新鲜的美味小鱼/1/F",
	[2672] = "多汁狼肉/4/D",
	[12223] = "蝙蝠肉翅/4/D",
	[2678] = "甜香料/2/V",
	[6889] = "小蛋/4/D",
	[17194] = "节日香料/10/V",
	[27668] = "山猫肉/5/D",
	[769] = "大块野猪肉/3/D",
	[23676] = "牧月成鹿嫩腰肉/5/D",
	[6303] = "新鲜的滑皮鲭鱼/1/F",
	[30817] = "面粉/1/V",
	[2886] = "峭壁野猪肋排/5/D",
	[2894] = "狂想麦酒/12/V",
	[5465] = "小蜘蛛腿/3/D",
	[5466] = "蝎刺/8/D",
	[1179] = "冰镇牛奶/6/VD",
	[17196] = "节日美酒/12/V",
	[5467] = "科多兽肉/7/D",
	[3173] = "熊肉/15/D",
	[27669] = "蝙蝠的肉/5/D",
	[5503] = "蚌肉/16/DG",
	[159] = "清凉的泉水/5/V",
	[2673] = "山狗肉/10/D",
	[5468] = "柔软的狂鱼肉/12/D",
	[723] = "血牙野猪的肝/15/D",
	[6317] = "新鲜的洛克湖狂鱼/2/F",
	[6289] = "新鲜的长嘴泥鳅/1/F",
	[6361] = "新鲜的彩鳍鱼/2/F",
	[5469] = "陆行鸟肉/9/D",
	[4536] = "新鲜的红苹果/5/V",
	[3172] = "猪大肠/18/D",
	[3174] = "蜘蛛的毒液/16/D",
	[22644] = "香脆蜘蛛腿/12/D",
	[2674] = "蟹肉/12/D",
	[729] = "秃鹫肉条/17/D",
	[730] = "鱼人的眼球/16/D",
	[731] = "血牙野猪的头/27/D",
	[2924] = "鳄鱼肉/16/D",
	[2677] = "猪排/15/D",
	[21071] = "新鲜的鼠尾鱼/25/F",
	[2675] = "蟹爪/11/D",
	[5051] = "掘地鼠/1/D",
	[1468] = "鱼人的鳍/28/D",
	[2692] = "辣椒/40/V",
	[6308] = "新鲜的刺须鲶鱼/2/F",
	[5470] = "雷霆蜥蜴的尾巴/28/D",
	[1081] = "香脆蜘蛛肉/50/D",
	[1080] = "硬秃鹫肉/78/D",
	[1015] = "狼肋排/24/D",
	[2665] = "暴风城特产调料/20/V",
	[3730] = "大块的熊肉/45/D",
	[2251] = "粘糊的蜘蛛腿 /12/D",
	[5471] = "鹿肉/30/D",
	[3667] = "嫩鳄鱼肉/25/D",
	[5504] = "有腥味的蚌肉/22/DG",
	[3731] = "狮肉/55/D",
	[3685] = "迅猛龙蛋/71/D",
	[3713] = "舒心草/160/V",
	[3404] = "秃鹫的翅膀/181/D",
	[12037] = "神秘的肉/87/D",
	[4655] = "大块蚌肉/71/DG",
	[12203] = "红狼肉/87/D",
	[12202] = "虎肉/87/D",
	[8365] = "新鲜的银头鳟鱼/4/D",
	[2596] = "矮人烈酒/120/V",
	[12184] = "迅猛龙肉/87/D",
	[6362] = "新鲜的石鳞鳕鱼/4/F",
	[21153] = "新鲜的大鼠尾鱼/125/D",
	[3712] = "海龟肉/87/D",
	[12204] = "科多兽肉/112/D",
	[12205] = "白蜘蛛肉/112/D",
	[13754] = "新鲜的光滑大鱼/6/F",
	[13758] = "新鲜的红腮鱼/4/F",
	[12207] = "巨蛋/150/D",
	[12206] = "嫩螃蟹肉/112/D",
	[4603] = "新鲜的斑点黄尾鱼/4/F",
	[12208] = "嫩狼肉/150/D",
	[7974] = "美味的蚌肉/50/DG",
	[13755] = "冬鱿鱼/7/F",
	[13756] = "新鲜的夏日鲈鱼/9/F",
	[13759] = "新鲜的夜鳞鲷鱼/10/F",
	[13760] = "新鲜的阳鳞鲑鱼/10/F",
	[13889] = "新鲜的白鳞鲑鱼/5/F",
	[13888] = "黑爪龙虾/12/F",
	[13893] = "新鲜的大鱼/15/F",
	[18255] = "洛恩塔姆地薯/15/G",
	[20424] = "沙虫的肉/175/D",
	[27422] = "刺鳃鲑鱼/8/D",
	[27671] = "秃鹰肉/200/D",
	[24477] = "裂开的蚌肉/100/D",
	[8150] = "石中盐/250/D",
	[21024] = "奇美洛克的腰肋肉/0/D",
	[27425] = "斑点魔尾鱼/8/D",
	[27674] = "掠食者的肉/200/D",
	[27429] = "赞加孢子鱼/914/D",
	[27676] = "奇怪的孢子/200/D",
	[27677] = "蜥蜴肉块/200/D",
	[27435] = "菲格鲁泥鱼/8/D",
	[27437] = "冰鳞蓝鱼/8/D",
	[27438] = "金镖鱼/8/D",
	[27678] = "裂蹄牛肉/200/D",
	[27682] = "塔布羊肉/200/D",
	[27681] = "迁跃兽肉/200/D",
	[31671] = "蛇肉/200/D",
	[31670] = "迅猛龙肋排/200/D",
	[27439] = "狂暴龙虾/8/D",
	[27515] = "粗斑魔尾鱼/0/D",
	[4539] = "金皮苹果/0/D",
	[27516] = "巨刺鲑鱼/0/D",
	[2593] = "波尔多酒/0/D",
	[6217] = "铜棒/124/V",
	[10940] = "奇异之尘/0/Ea",
	[10938] = "次级魔法精华/0/Eb",
	[17034] = "枫树种子/200/V",
	[10939] = "强效魔法精华/0/Ec",
	[10978] = "小块微光碎片/0/Ea",
	[10998] = "次级星界精华/0/Ed",
	[11083] = "灵魂之尘/0/Ee",
	[11082] = "强效星界精华/0/Ef",
	[11084] = "大块微光碎片/0/Ef",
	[2772] = "铁矿石/150/Me125",
	[11291] = "星木/4050/V",
	[11134] = "次级秘法精华/0/Eg",
	[11138] = "小块闪光碎片/0/Eg",
	[11135] = "强效秘法精华/0/Ei",
	[11137] = "幻象之尘/0/Eh",
	[11139] = "大块闪光碎片/0/Ei",
	[17035] = "荆棘种子/400/V",
	[7392] = "绿色幼龙鳞片/200/Sab",
	[11174] = "次级虚空精华/0/Ej",
	[11177] = "小块强光碎片/0/Ej",
	[11175] = "强效虚空精华/0/El",
	[11178] = "大块强光碎片/0/El",
	[16202] = "次级不灭精华/0/Em",
	[14343] = "小块魔光碎片/0/Em",
	[7079] = "纯水之球/400/D",
	[16204] = "幻影之尘/0/En",
	[16203] = "强效不灭精华/0/En",
	[13926] = "金珍珠/10000/DG",
	[14344] = "大块魔光碎片/0/En",
	[22447] = "次级位面精华/0/Ep",
	[22448] = "小块棱光碎片/0/Ep",
	[22446] = "强效位面精华/0/Eq",
	[4399] = "木柴/200/V",
	[4400] = "沉重的树干/2000/V",
	[814] = "灯油/25/D",
	[6530] = "夜色虫/100/VD",
	[4611] = "蓝珍珠/50/G",
	[17202] = "雪球/0/DC",
	[10285] = "暗影蛛丝/1000/D",
	[14227] = "铁网蛛丝/2500/D",
	[23436] = "红曜石/30000/MlMmMnRD",
	[23438] = "艾露恩之星/30000/MlMmMnRD",
	[23440] = "黎明石/30000/MlMmMnRD",
	[23439] = "黄晶玉/30000/MlMmMnRD",
	[23437] = "水玉/30000/MlMmRD",
	[23441] = "夜目石/30000/MlMmMnRD",
	[2604] = "红色染料/50/V",
	[6260] = "蓝色染料/50/V",
	[8151] = "魔精/250/D",
	[10648] = "空白的羊皮纸/500/V",
	[10647] = "墨水/2000/V",
	[4337] = "粗蜘蛛丝/750/D",
	[10577] = "地精迫击炮/2000/Ce",
	[17020] = "魔粉/250/V",
	[1475] = "小毒囊/82/D",
	[19441] = "巨型毒囊/1500/D",
	[8152] = "大魔精/500/D",
	[18335] = "原始黑钻石/2520/D",
	[24478] = "裂纹的珍珠/0/D",
	[24243] = "精金粉/2250/RD",
	[27860] = "清洁的德拉诺之水/0/D",
	[24479] = "暗影珍珠/0/D",
	[32230] = "影歌紫玉/0/D",
	[32227] = "赤尖石/0/D",
	[32229] = "狮眼石/0/D",
	[32249] = "海浪翡翠/0/D",
	[32231] = "焚石/0/D",
	[32228] = "天蓝宝石/0/D",
	[2320] = "粗线/10/V",
	[2934] = "破烂的皮革/7/Sa",
	[783] = "轻毛皮/50/Sb",
	[4289] = "盐/50/V",
	[5082] = "薄科多兽皮/25/D",
	[2324] = "漂白液/25/V",
	[6470] = "飞蛇鳞片/20/DSy",
	[5784] = "粘糊糊的鱼人鳞片/75/D",
	[7286] = "黑色幼龙鳞片/25/Saa",
	[4340] = "灰色染料/350/V",
	[4232] = "中毛皮/125/Sc",
	[6471] = "完美的飞蛇鳞片/500/DSy",
	[7287] = "红色雏龙鳞片/100/Sz",
	[5116] = "细长的尾羽/303/D",
	[3182] = "蜘蛛丝/387/D",
	[5373] = "好运符/72/P",
	[4235] = "重毛皮/200/Sd",
	[4461] = "迅猛龙的外皮/208/Sac",
	[2325] = "黑色染料/1000/V",
	[5785] = "厚鱼人鳞片/500/D",
	[4291] = "丝线/500/V",
	[7428] = "暗影猎豹毛皮/250/Sg",
	[8343] = "粗丝线/2000/V",
	[4096] = "粗糙的猩猩毛发/608/D",
	[8169] = "厚毛皮/500/Se",
	[8167] = "龟壳/100/Sh",
	[8154] = "蝎壳/250/Si",
	[8171] = "硬甲毛皮/500/Sf",
	[15409] = "精炼石中盐/1000/Cl",
	[15408] = "厚蝎鳞/500/Sj",
	[14341] = "符文线/4500/V",
	[15412] = "绿龙鳞片/500/Sl",
	[15423] = "奇美拉皮革/500/So",
	[15420] = "铁羽毛/100/D",
	[15419] = "战熊皮/600/Sq",
	[15422] = "霜刃豹皮革/500/Sm",
	[15415] = "蓝龙鳞片/500/Sl",
	[15416] = "黑龙鳞片/1000/Sl",
	[12607] = "闪亮的彩色龙鳞/8048/D",
	[15414] = "红龙鳞片/1500/Sl",
	[20381] = "梦幻龙鳞/5000/Sv315",
	[18512] = "幼虫酸液/4000/D",
	[19768] = "原始虎皮/2000/Ss",
	[15410] = "奥妮克希亚鳞片/5000/Sw315",
	[19767] = "原始蝙蝠皮/2000/Sr",
	[20501] = "重型异种蝎甲壳/2000/S",
	[20498] = "异种虫甲壳质/1000/D",
	[20500] = "轻型异种虫壳/2000/S",
	[25700] = "魔鳞/1250/S",
	[18240] = "食人魔鞣酸/0/S",
	[14256] = "恶魔布/2000/D",
	[25649] = "结缔皮碎片/250/S",
	[25708] = "厚裂蹄牛皮/750/S",
	[29539] = "眼镜蛇鳞片/1250/S",
	[25707] = "魔皮/6250/S",
	[25699] = "水晶能量皮革/1250/S",
	[25703] = "斑马皮/100/S",
	[29548] = "虚空龙鳞/2000/S",
	[29547] = "风鳞/1250/S",
	[8165] = "破碎的龙鳞/500/Sk",
	[8368] = "厚狼皮/1000/Sp",
	[2770] = "铜矿石/5/Ma1",
	[2771] = "锡矿石/25/Mb65",
	[2775] = "银矿石/75/Mc75",
	[2776] = "金矿石/500/Md155",
	[3857] = "煤块/500/VD",
	[7911] = "真银矿石/500/Mg230",
	[11370] = "黑铁矿石/500/Mh275",
	[18562] = "源质矿石/0/D",
	[18567] = "元素助熔剂/0/D",
	[23424] = "魔铁矿石/1000/Ml",
	[23425] = "精金矿石/1500/Mm",
	[23427] = "恒金矿石/1250/MnMmMl",
	[23426] = "氪金矿石/2500/Mn",
	[4341] = "黄色染料/500/V",
	[7072] = "纳迦鳞片/150/D",
	[6261] = "橙色染料/1000/V",
	[10290] = "粉红染料/2500/V",
	[4589] = "细长的狮鹫兽羽毛/530/D",
	[11040] = "晨光麦/1/DMH",
	[21881] = "灵网蜘蛛丝/5000/D",
	[21882] = "灵魂精华/2500/D",
	[21927] = "速效药膏 VII/125/Cp",
	[3776] = "致残药膏 II/175/Cp",
	[22053] = "致命药膏 VI/150/Cp",
	[12625] = "黎明使者护肩/22847/Cb",
	[8927] = "速效药膏 V/100/Cp",
--	[5530] = "Blinding Powder/125/Cp",
	[10918] = "致伤药膏/42/Cp",
	[12772] = "镶饰瑟银战锤/38871/Cb",
	[5173] = "丧命草/100/V",
	[6949] = "速效药膏 II/20/Cp",
	[2928] = "蚀骨灰/20/V",
	[8928] = "速效药膏 VI/125/Cp",
	[6947] = "速效药膏/5/Cp",
	[21835] = "麻醉药膏/125/Cp",
	[22055] = "致伤药膏 V/175/Cp",
	[22728] = "蒸汽坦克遥控器/1879/Ce",
	[5237] = "麻痹药膏/18/Cp",
	[2931] = "魔女的痛苦/250/V",
	[10922] = "致伤药膏 IV/175/Cp",
	[3777] = "死草根/40/V",
	[8985] = "致命药膏 IV/150/Cp",
	[10921] = "致伤药膏 III/125/Cp",
	[20844] = "致命药膏 V/150/Cp",
	[8984] = "致命药膏 III/100/Cp",
	[6950] = "速效药膏 III/30/Cp",
	[3775] = "致残药膏/13/Cp",
	[18258] = "戈多克食人魔装/0/Cl",
	[8923] = "苦楚精华/180/V",
	[22054] = "致命药膏 VII/150/Cp",
	[2930] = "痛苦精华/50/V",
	[6951] = "麻痹药膏 II/75/Cp",
	[2893] = "致命药膏 II/55/Cp",
	[9186] = "麻痹药膏 III/175/Cp",
	[2892] = "致命药膏/30/Cp",
	[8924] = "堕落之尘/100/V",
	[10920] = "致伤药膏 II/67/Cp",
	[8926] = "速效药膏 IV/75/Cp",
--new
    [30038] = "冲击腰带/0/Ct",
    [30040] = "深邃暗影腰带/0/Cl",
    [30042] = "自然力量腰带/0/Cl",
    [30046] = "黑鹰腰带/0/Cl",
    [30036] = "长路腰带/0/Ct",
    [30037] = "冲击长靴/0/Ct",
    [30041] = "自然优雅之靴/0/Cl",
    [30045] = "赤鹰之靴/0/Cl",
    [30035] = "长路之靴/0/Ct",
    [30043] = "飓风长靴/0/Cl",
    [30044] = "季风腰带/0/Cl",
    [30034] = "守护者腰带/0/Cb",
    [30033] = "保卫者战靴/0/Cb",
    [30032] = "红色战斗腰带/0/Cb",
    [30031] = "红色浩劫长靴/0/Cb",
    [32199] = "闪光赤尖石/0/Cj",
    [32210] = "巨型狮眼石/0/Cj",
    [32217] = "铭文焚石/0/Cj",
    [32209] = "秘法狮眼石/0/Cj",
    [32212] = "狡诈影歌紫玉/0/Cj",
    [32211] = "统御影歌紫玉/0/Cj",
    [32203] = "风暴天蓝宝石/0/Cj",
    [32221] = "隐秘焚石/0/Cj",
    [32574] = "闪电反射护腕/0/Cl",
    [32579] = "生命之地护肩/0/Cl",
    [32587] = "敏锐思维衬肩/0/Ct",
    [32583] = "新生护肩/0/Cl",  --?
    [32580] = "迅捷打击护腕/0/Cl",
    [32573] = "晨钢护肩/0/Cb",    --?
    [32568] = "迅钢护腕/0/Cb",
    [32586] = "敏锐思维护腕/0/Ct",
    [32582] = "新生护腕/0/Cl",
    [32577] = "生命之地护腕/0/Cl",
    [32583] = "新生护肩/0/Cl",
    [32575] = "闪电反射护肩/0/Cl",
    [32581] = "迅捷打击护肩/0/Cl",
    [32571] = "晨光护腕/0/Cb",  --?
    [32570] = "迅钢护肩/0/Cb",
    [30039] = "绝对黑暗之靴/0/Cl",
    [32398] = "束缚灵魂长靴/0/Cl",
    [32399] = "束缚灵魂护腕/0/Cl",
    [32400] = "束缚灵魂护腿/0/Cl",
    [32397] = "束缚灵魂腰带/0/Cl",
    [32393] = "救赎灵魂束带/0/Cl",
    [32396] = "救赎灵魂腿甲/0/Cl",
    [32394] = "救赎灵魂长靴/0/Cl",
    [32395] = "救赎灵魂腕甲/0/Cl",
    [32420] = "夜色之末/0/Ct",
    [32392] = "灵魂卫士护腕/0/Ct",
    [32390] = "灵魂卫士腰带/0/Ct",
    [32389] = "灵魂卫士护腿/0/Ct",
    [32391] = "灵魂卫士便鞋/0/Ct",
    [32403] = "影钢护腕/0/Cb",
    [32401] = "影钢束带/0/Cb",
    [32404] = "影钢腿甲/0/Cb",
    [32402] = "影钢战靴/0/Cb",
    [33173] = "怒钢护肩/0/Cb",
    [32213] = "平衡影歌紫玉/0/Cj",
    [32193] = "朴素赤尖石/0/Cj",
    [32197] = "明亮赤尖石/0/Cj",
    [32204] = "闪耀狮眼石/0/Cj",
    [32225] = "眩光海浪翡翠/0/Cj",
    [32194] = "精致赤尖石/0/Cj",
    [32223] = "坚硬海浪翡翠/0/Cj",
    [32207] = "柔光狮眼石/0/Cj",
    [32220] = "反光焚石/0/Cj",
    [32215] = "炽热影歌紫玉/0/Cj",
    [32214] = "充能影歌紫玉/0/Cj",
    [32226] = "裂纹海浪翡翠/0/Cj",
    [32219] = "辉光焚石/0/Cj",
    [32202] = "异彩天蓝宝石/0/Cj",
    [32218] = "高能焚石/0/Cj",
    [32224] = "辐光海浪翡翠/0/Cj",
    [32206] = "刚硬狮眼石/0/Cj",
    [32216] = "皇家影歌紫玉/0/Cj",
    [32196] = "符文赤尖石/0/Cj",
    [32205] = "圆润狮眼石/0/Cj",
    [32200] = "致密天蓝宝石/0/Cj",
    [32201] = "火花天蓝宝石/0/Cj",
    [32198] = "诡秘赤尖石/0/Cj",
    [32195] = "泪珠赤尖石/0/Cj",
    [32208] = "厚重狮眼石/0/Cj",
    [32222] = "邪恶焚石/0/Cj",
    [33140] = "琥珀之血/0/Cj",
    [33131] = "血色残阳/0/Cj",
    [33133] = "胡里奥之心/0/Cj",
    [33144] = "永恒之钻/0/Cj",
    [33135] = "坠星石/0/Cj",
    [33134] = "凯蕾的玫瑰/0/Cj",
    [33143] = "刀锋之石/0/Cj",
   	[-42620] = "附魔武器 - 强效敏捷/0/Cn",
    [-42613] = "转化连结水晶/0/Cn",
    [22448] = "小块棱光碎片/0/Cn",
    [33204] = "阴影徘徊者胸甲/0/Cl",
    [33122] = "黑暗披风/0/Cl",
    [33208] = "多彩奇迹合剂/0/Ca",
    [7191] = "保险丝/0/CeD",
    [33782] = "稳固水玉/0/Cj",
    [17056] = "轻羽毛/0/D",
    [25719] = "鸦人的羽毛/0/D",
    [34249] = "草裙舞娃娃/0/D",
    [27503] = "力量卷轴 V/0/DV",    
    [34220] = "混乱之天火钻石/0/Cj",
    [33867] = "烤血鳞鱼/0/Cc",
    [33924] = "美味巧克力蛋糕/0/Cc",
    [34411] = "热苹果酒/0/Cc",
    [33874] = "金布勒宠物食品/0/Cc",
    [33825] = "骨鱼汤/0/Cc",
    [33872] = "热辣塔布羊排/0/Cc",
    [33866] = "风暴牛排/0/Cc",
    [34060] = "飞行器控制台/0/Ce",
    [34061] = "涡轮加速飞行器控制台/0/Ce",
    [34113] = "战地修理机器人110G/0/Ce",
    [20475] = "精金制箭器/0/Ce",
    [34440] = "疯狂炼金师药水/0/Ca",
    [-42974] = "附魔武器 - 斩杀/0/Cn",
    [-44383] = "附魔盾牌 - 韧性/0/Cn",
    [32854] = "正义力量之锤/0/Cb",
    [33185] = "精金武器链/0/Cb",
    [33791] = "钢制重剑/0/Cb",
    [34207] = "手套强化护甲片/0/Cb",
    [34099] = "科多皮弹药包/0/Cl",
    [34100] = "科多皮箭袋/0/Cl",
    [34105] = "千羽箭袋/0/Cl",
    [34106] = "虚空鳞片弹药包/0/Cl",
    [34490] = "大皮袋/0/Cl",
    [34482] = "制皮匠的背包/0/Cl",
    [34086] = "寒冬长靴/0/Cl",
    [34807] = "绿色冬衣/0/Ct",
    [34805] = "红色冬衣/0/Ct",
    [34330] = "厚重结缔皮护甲片/0/Cl",
    [33823] = "血鳞鲶鱼/0/F",
    [34412] = "气泡苹果酒/0/Q",
    [33824] = "弯尾骨鱼/0/F",
    [13757] = "电鳗/0/F",
    [34360] = "涌动生命护符/0/Cj",
    [34361] = "硬化氪金指环/0/Cj",
    [34358] = "硬化氪金项链/0/Cj",
    [34359] = "阳炎坠饰/0/Cj",
    [34362] = "熔铸能量指环/0/Cj",
    [34363] = "涌动生命指环/0/Cj",
    [34369] = "烈日暗影甲胄/0/Cl",
    [34373] = "凤凰的拥抱/0/Cl",
    [34374] = "凤凰飞羽手套/0/Cl",
    [34370] = "永生幽暗手套/0/Ct",
    [34367] = "永恒光芒之手/0/Ct",
    [34371] = "骄阳之皮革胸甲/0/Cl",
    [34372] = "骄阳之皮革护手/0/Cl",
    [34365] = "永恒光芒长袍/0/Ct",
    [34375] = "炙日鳞片胸甲/0/Cl",
    [34376] = "炙日鳞片手套/0/Cl",
    [34366] = "阳炎护手/0/Ct",
    [34364] = "阳炎之袍/0/Ct",
    [34378] = "硬化氪金拳甲/0/Cb",
    [34377] = "硬化氪金战甲/0/Cb",
    [34379] = "圣日胸甲/0/Cb",
    [34380] = "圣日护手/0/Cb",
    [34847] = "湮灭全视护目镜/0/Ce",
    [34357] = "硬化氪金护目镜/0/Ce",
    [35182] = "超级月光放大护目镜/0/Ce",
    [35185] = "审判者护目镜3000型/0/Ce",
    [34355] = "闪电蚀刻护目镜/0/Ce",
    [34354] = "伤害投射护目镜/0/Ce",
    [35181] = "超级治疗射线9000型/0/Ce",
    [35184] = "源生同频护目镜/0/Ce",
    [34353] = "四核死亡一击护目镜X44型/0/Ce",
    [34356] = "必中护目镜V3.0/0/Ce",
    [35183] = "奇迹治疗罩XT68型/0/Ce",
    [34832] = "拉姆瑟船长的特酿啤酒/0/Cc",
    [35503] = "灰烬之天火钻石/0/Cj",
    [35501] = "永恒之大地风暴钻石/0/Cj",
    [35563] = "熊肉串烧/0/Cc",
    [35565] = "多汁熊肉汉堡/0/Cc",
   	[35128] = "熔炼硬化氪金/0/Cs",
    [35759] = "坚强海浪翡翠/0/Cj",
    [35761] = "迅捷狮眼石/0/Cj",
    [35760] = "鲁莽焚石/0/Cj",
    [35758] = "稳固海浪翡翠/0/Cj",
    [35581] = "轻便型超级火箭靴/0/Cj",
    [35700] = "雕像 - 赤尖蛇/0/Cj",
    [35693] = "雕像 - 天蓝宝石海龟/0/Cj",
    [35694] = "雕像 - 氪金野猪/0/Cj",
    [35703] = "雕像 - 海浪信天翁/0/Cj",
    [35702] = "雕像 - 影歌猎豹/0/Cj",
    [35707] = "华丽夜目石/0/Cj",
    [35751] = "刺客的炼金石/0/Cj",
    [35748] = "守护者的炼金石/0/Cj",
    [35750] = "救赎者的炼金石/0/Cj",
    [35749] = "巫师的炼金石/0/Cj",
    [34664] = "太阳之尘/0/D",
    [35562] = "熊腰肉/0/D",
    [46405] = "坚强水玉/0/Cj",
    [46403] = "迅捷黎明石/0/Cj",
    [46404] = "鲁莽黄晶玉/0/Cj",

}

TradeskillInfo.vars.enchants = {
	[-7428] = "附魔护腕 - 初级偏斜/永久性地为一双护腕附魔，使它们获得防御等级提高2的效果。",
	[-7418] = "附魔护腕 - 初级生命/永久性地为一双护腕附魔，使它们获得生命值+5的效果。",
	[-7420] = "附魔胸甲 - 初级生命/永久性地为一件胸甲附魔，使它获得生命值+5的效果。",
	[-7443] = "附魔胸甲 - 初级法力/永久性地为一件胸甲附魔，使它获得法力值+5的效果。",
	[-7426] = "附魔胸甲 - 初级吸收/为一件胸甲附魔，使它每次被击中时都有2%的机会吸收10点伤害。",
	[-7454] = "附魔披风 - 初级抗性/永久性地为一件披风附魔，使它获得所有魔法抗性+1的效果。",
	[-7457] = "附魔护腕 - 初级耐力/永久性地为一只护腕附魔，使它获得耐力+1的效果。",
	[-7766] = "附魔护腕 - 初级精神/永久性地为一只护腕附魔，使它获得精神+1的效果。",
	[-7748] = "附魔胸甲 - 次级生命/永久性地为一件胸甲附魔，使它获得生命值+15的效果。",
	[-7771] = "附魔披风 - 初级防护/为一件披风附魔，使它获得护甲+10的效果。",
	[-7779] = "附魔护腕 - 初级敏捷/永久性地为一只护腕附魔，使它获得敏捷+1的效果。",
	[-7782] = "附魔护腕 - 初级力量/永久性地为一只护腕附魔，使它获得力量+1的效果。",
	[-7776] = "附魔胸甲 - 次级法力/永久性地为一件胸甲附魔，使它获得法力值+20的效果。",
	[-7786] = "附魔武器 - 初级屠兽/永久性地为一把近战武器附魔，使它获得对野兽伤害+2的效果。",
	[-7788] = "附魔武器 - 初级攻击/永久性地为一把近战武器附魔，使它获得伤害+1的效果。",
	[-7793] = "附魔双手武器 - 次级智力/永久性地为一把双手近战武器附魔，使它获得智力+3的效果。",
	[-7745] = "附魔双手武器 - 初级冲击/永久性地为一把双手近战武器附魔，使它获得伤害+2的效果。",
	[-13378] = "附魔盾牌 - 初级耐力/永久性地为一面盾牌附魔，使它获得耐力+1的效果。",
	[-13380] = "附魔双手武器 - 次级精神/永久性地为一把双手近战武器附魔，使它获得精神+3的效果。",
	[-13419] = "附魔披风 - 初级敏捷/永久性地为一件披风附魔，使它获得敏捷+1的效果。",
	[-13421] = "附魔披风 - 次级防护/永久性地为一件披风附魔，使它获得护甲+20的效果。",
	[-13464] = "附魔盾牌 - 次级防护/永久性地为一面盾牌附魔，使它获得护甲+30的效果。",
	[-7859] = "附魔护腕 - 次级精神/永久性地为一只护腕附魔，使它获得精神+3的效果。",
	[-7857] = "附魔胸甲 - 生命/永久性地为一件胸甲附魔，使它获得生命值+25的效果。",
	[-7867] = "附魔靴子 - 初级敏捷/永久性地为一双靴子附魔，使它们获得敏捷+1的效果。",
	[-7863] = "附魔靴子 - 初级耐力/永久性地为一双靴子附魔，使它们获得耐力+1的效果。",
	[-7861] = "附魔披风 - 次级火焰抗性/永久性地为一件披风附魔，使它获得火焰抗性+5的效果。",
	[-13501] = "附魔护腕 - 次级耐力/永久性地为一只护腕附魔，使它获得耐力+3的效果。",
	[-13485] = "附魔盾牌 - 次级精神/永久性地为一面盾牌附魔，使它获得精神+3的效果。",
	[-13522] = "附魔披风 - 次级暗影抵抗/永久性地为一件披风附魔，使它获得暗影抗性+10的效果。",
	[-13536] = "附魔护腕 - 次级力量/永久性地为一只护腕附魔，使它获得力量+3的效果。",
	[-13538] = "附魔胸甲 - 次级吸收/为一件胸甲附魔，使它每次被击中时都有5%的机会吸收25点伤害。",
	[-13503] = "附魔武器 - 次级攻击/永久性地为一把近战武器附魔，使它获得伤害+2的效果。",
	[-13529] = "附魔双手武器 - 次级冲击/永久性地为一把双手近战武器附魔，使它获得伤害+3的效果。",
	[-13607] = "附魔胸甲 - 法力/永久性地为一件胸甲附魔，使它获得法力值+30的效果。",
	[-13620] = "附魔手套 - 钓鱼/永久性地为一双手套附魔， 使它们获得钓鱼技能+2的效果。",
	[-13617] = "附魔手套 - 草药学/永久性地为一双手套附魔， 使它们获得草药学技能+2的效果。",
	[-13612] = "附魔手套 - 采矿/永久性地为一双手套附魔， 使它们获得采矿技能+2的效果。",
	[-13622] = "附魔护腕 - 次级智力/永久性地为一只护腕附魔，使它获得智力+3的效果。",
	[-13626] = "附魔胸甲 - 初级属性/永久性地为一件胸甲附魔，使它获得所有属性+1的效果。",
	[-13635] = "附魔披风 - 防御/永久性地为一件披风附魔，使它获得护甲+30的效果。",
	[-13631] = "附魔盾牌 - 次级耐力/永久性地为一面盾牌附魔，使它获得耐力+3的效果。",
	[-13637] = "附魔靴子 - 次级敏捷/永久性地为一双靴子附魔，使它们获得敏捷+3的效果。",
	[-13640] = "附魔胸甲 - 强效生命/永久性地为一件胸甲附魔，使它获得生命值+35的效果。",
	[-13642] = "附魔护腕 - 精神/永久性地为一副护腕附魔，使它们获得精神+5的效果。",
	[-13644] = "附魔靴子 - 次级耐力/永久性地为一双靴子附魔，使它们获得耐力+3的效果。",
	[-13646] = "附魔护腕 - 次级偏斜/永久性地为一副护腕附魔，使它们获得+3防御等级的效果。",
	[-13648] = "附魔护腕 - 耐力/永久性地为一副护腕附魔，使它们获得耐力+5的效果。",
	[-13657] = "附魔披风 - 火焰抗性/永久性地为一件披风附魔，使它获得火焰抗性+7的效果。",
	[-13653] = "附魔武器 - 次级屠兽/永久性地为一把近战武器附魔，使它获得对野兽伤害+6的效果。",
	[-13655] = "附魔武器 - 次级元素杀手/永久性地为一把近战武器附魔，使它获得对元素生物伤害+6的效果。",
	[-13661] = "附魔护腕 - 力量/永久性地为一副护腕附魔，使它们获得力量+5的效果。",
	[-13659] = "附魔盾牌 - 精神/永久性地为一面盾牌附魔，使它获得精神+5的效果。",
	[-13663] = "附魔胸甲 - 强效法力/永久性地为一件胸甲附魔，使它获得法力值+50的效果。",
	[-13687] = "附魔靴子 - 次级精神/永久性地为一双靴子附魔，使它们获得精神+3的效果。",
	[-21931] = "附魔武器 - 寒冬之力/永久性地为一把武器附魔，使它获得令冰霜法术造成的伤害+7的效果。",
	[-13689] = "附魔盾牌 - 次级格挡/永久性地为一面盾牌附魔，使它获得格挡等级+10的效果。",
	[-13693] = "附魔武器 - 攻击/永久性地为一把近战武器附魔，使它获得伤害+3的效果。",
	[-13695] = "附魔双手武器 - 冲击/永久性地为一把双手近战武器附魔，使它获得伤害+5的效果。",
	[-13700] = "附魔胸甲 - 次级状态/永久性地为一件胸甲附魔，使它获得所有属性+2的效果。",
	[-13698] = "附魔手套 - 剥皮/永久性地为一双手套附魔， 使它们获得剥皮技能+5的效果。",
	[-13746] = "附魔披风 - 强效防御/永久性地为一件披风附魔，使它获得护甲+50的效果。",
	[-13794] = "附魔披风 - 抗性/永久性地为一件披风附魔，使它获得所有魔法抗性+3的效果。",
	[-13822] = "附魔护腕 - 智力/永久性地为一副护腕附魔，使它们获得智力+5的效果。",
	[-13815] = "附魔手套 - 敏捷/永久性地为一双手套附魔， 使它们获得敏捷+5的效果。",
	[-13817] = "附魔盾牌 - 耐力/永久性地为一面盾牌附魔，使它获得耐力+5的效果。",
	[-13836] = "附魔靴子 - 耐力/永久性地为一双靴子附魔，使它们获得耐力+5的效果。",
	[-13841] = "附魔手套 - 高级采矿/永久性地为一双手套附魔， 使它们获得采矿技能+5的效果。",
	[-13846] = "附魔护腕 - 强效精神/永久性地为一副护腕附魔，使它们获得精神+7的效果。",
	[-13858] = "附魔胸甲 - 超强生命/永久性地为一件胸甲附魔，使它获得生命值+50的效果。",
	[-13890] = "附魔靴子 - 初级速度/永久性地为一双靴子附魔，使它们获得略微提升移动速度的效果。",
	[-13882] = "附魔披风 - 次级敏捷/永久性地为一件披风附魔，使它获得敏捷+3的效果。",
	[-13868] = "附魔手套 - 高级草药学/永久性地为一双手套附魔， 使它们获得草药学技能+5的效果。",
	[-13887] = "附魔手套 - 力量/永久性地为一双手套附魔， 使它们获得力量+5的效果。",
	[-13917] = "附魔胸甲 - 超强法力/永久性地为一件胸甲附魔，使它获得法力值+65的效果。",
	[-13905] = "附魔盾牌 - 强效精神/永久性地为一面盾牌附魔，使它获得精神+7的效果。",
	[-13915] = "附魔武器 - 屠魔/永久性地为一把近战武器附魔，使它获得有一定几率击晕恶魔并对其造成大量伤害的效果。",
	[-13935] = "附魔靴子 - 敏捷/永久性地为一双靴子附魔，使它们获得敏捷+5的效果。",
	[-13931] = "附魔护腕 - 偏斜/永久性地为一副护腕附魔，使它们获得+5防御等级的效果。",
	[-13933] = "附魔盾牌 - 冰霜抗性/永久性地为一面盾牌附魔，使它获得+8冰霜抗性的效果。",
	[-13937] = "附魔双手武器 - 强效冲击/永久性地为一把双手近战武器附魔，使它获得伤害+7的效果。",
	[-13939] = "附魔护腕 - 强效力量/永久性地为一副护腕附魔，使它们获得力量+7的效果。",
	[-13945] = "附魔护腕 - 强效耐力/永久性地为一副护腕附魔，使它们获得耐力+7的效果。",
	[-13941] = "附魔胸甲 - 状态/永久性地为一件胸甲附魔，使它获得所有属性+3的效果。",
	[-13943] = "附魔武器 - 强效攻击/永久性地为一把近战武器附魔，使它获得伤害+4的效果。",
	[-13948] = "附魔手套 - 初级加速/永久性地为一双手套附魔，使它们获得近战和远程加速等级提高10的效果。",
	[-13947] = "附魔手套 - 骑乘/永久性地为一双手套附魔， 使它们获得略微提升坐骑移动速度的效果。",
	[-20008] = "附魔护腕 - 强效智力/永久性地为一副护腕附魔，使它们获得智力+7的效果。",
	[-20020] = "附魔靴子 - 强效耐力/永久性地为一双靴子附魔，使它们获得耐力+7的效果。",
	[-20014] = "附魔披风 - 强效抗性/永久性地为一件披风附魔，使它获得所有魔法抗性+5的效果。",
	[-20017] = "附魔盾牌 - 强效耐力/永久性地为一面盾牌附魔，使它获得耐力+7的效果。",
	[-13898] = "附魔武器 - 烈焰/永久性地为一把近战武器附魔，使它获得附加40点火焰伤害的效果。",
	[-20009] = "附魔护腕 - 超强精神/永久性地为一副护腕附魔，使它们获得精神+9的效果。",
	[-20012] = "附魔手套 - 强效敏捷/永久性地为一双手套附魔， 使它们获得敏捷+7的效果。",
	[-20024] = "附魔靴子 - 精神/永久性地为一双靴子附魔，使它们获得精神+5的效果。",
	[-20026] = "附魔胸甲 - 特效生命/永久性地为一件胸甲附魔，使它获得生命值+100的效果。",
	[-20016] = "附魔盾牌 - 超强精神/永久性地为一面盾牌附魔，使它获得精神+9的效果。",
	[-20015] = "附魔披风 - 超强防御/永久性地为一件披风附魔，使它获得护甲+70的效果。",
	[-20029] = "附魔武器 - 冰寒/永久性地为一把近战武器附魔，使它能释放冰寒，使目标的移动和攻击速度减慢。对60级以上玩家的效果降低。",
	[-27837] = "附魔双手武器 - 敏捷/永久性地为一件双手近战武器附魔，使其获得敏捷+25的效果。",
	[-23801] = "附魔护腕 - 法力回复/永久性地为一副护腕附魔，使其获得每5秒回复4点法力值的效果。",
	[-20028] = "附魔胸甲 - 特效法力/永久性地为一件胸甲附魔，使它获得法力值+100的效果。",
	[-23800] = "附魔武器 - 敏捷/永久性地为一件近战武器附魔，使其获得+15敏捷的效果。",
	[-23799] = "附魔武器 - 力量/永久性地为一件近战武器附魔，使其获得+15力量的效果。",
	[-20030] = "附魔双手武器 - 超强冲击/永久性地为一把双手近战武器附魔，使它获得伤害+9的效果。",
	[-20023] = "附魔靴子 - 强效敏捷/永久性地为一双靴子附魔，使它们获得敏捷+7的效果。",
	[-20010] = "附魔护腕 - 超强力量/永久性地为一副护腕附魔，使它们获得力量+9的效果。",
	[-20013] = "附魔手套 - 强效力量/永久性地为一双手套附魔， 使它们获得力量+7的效果。",
	[-20033] = "附魔武器 - 邪恶武器/永久性地为一把近战武器附魔，使它可诅咒目标，减少目标的近战伤害。",
	[-20036] = "附魔双手武器 - 特效智力/永久性地为一把双手近战武器附魔，使它获得智力+9的效果。",
	[-20035] = "附魔双手武器 - 特效精神/永久性地为一把双手近战武器附魔，使它获得精神+9的效果。",
	[-34002] = "附魔护腕 - 突袭/永久性地为一副护腕附魔，使它们获得攻击强度提高24点的效果。该装备等级不得低于35级。",
	[-23802] = "附魔护腕 - 治疗能力/永久性地为一副护腕附魔，使它获得法术治疗效果提高最多24点、法术伤害提高最多8点的效果。",
	[-20011] = "附魔护腕 - 超强耐力/永久性地为一副护腕附魔，使它们获得耐力+9的效果。",
	[-20025] = "附魔胸甲 - 强效属性/永久性地为一件胸甲附魔，使它获得所有属性+4的效果。",
	[-33991] = "附魔胸甲 - 优秀法力回复/永久性地为一件胸甲附魔，使它获得每5秒回复6点法力值的效果。该装备等级不得低于35级。",
	[-25086] = "附魔披风 - 躲闪/给一条披风永久性地附魔，使装备它的人物获得躲闪等级+12的效果。",
	[-25081] = "附魔披风 - 强效火焰抗性/给一条披风永久性地附魔，使装备它的人物获得火焰抗性提高15点的效果。",
	[-25082] = "附魔披风 - 强效自然抗性/给一条披风永久性地附魔，使装备它的人物获得自然抗性提高15点的效果。",
	[-25083] = "附魔披风 - 潜行/给一条披风永久性地附魔，使装备它的角色人物获得潜行能力提高的效果。",
	[-25084] = "附魔披风 - 狡诈/给一条披风永久性地附魔，使装备它的人物获得对怪物所造成的威胁值降低2%的效果。",
	[-25078] = "附魔手套 - 火焰能量/永久性地为一双手套附魔，使装备它的人物获得火焰法术和技能所造成的伤害提高最多20点的效果。",
	[-25074] = "附魔手套 - 冰霜能量/永久性地为一双手套附魔，使装备它的人物获得冰霜法术和技能所造成的伤害提高最多20点的效果。",
	[-25079] = "附魔手套 - 治疗能量/永久性地为一双手套附魔，使它获得法术治疗效果提高最多30点、法术伤害提高最多10点的效果。",
	[-25073] = "附魔手套 - 暗影能量/永久性地为一双手套附魔，使装备它的人物获得暗影法术和技能所造成的伤害提高最多20点的效果。",
	[-25080] = "附魔手套 - 超强敏捷/永久性地为一双手套附魔，使装备它的人物获得敏捷提高15点的效果。",
	[-25072] = "附魔手套 - 威胁/永久性地为一双手套附魔，使装备它的人物获得对怪物所造成的威胁值提高2%的效果。",
	[-20034] = "附魔武器 - 十字军/永久性地为一把近战武器附魔，使它获得在攻击时经常性地为你回复75-125点生命值，并使你的力量提高100点，持续15秒。对60级以上玩家的效果降低。",
	[-22750] = "附魔武器 - 治疗能量/永久性地为一把近战武器附魔，使它获得法术治疗效果提高最多55点、法术伤害提高最多19点的效果。",
	[-20032] = "附魔武器 - 生命偷取/永久性地为一把近战武器附魔，使它可从敌人那儿偷取生命值。对60级以上玩家的效果降低。",
	[-23804] = "附魔武器 - 强效智力/永久性地为一件近战武器附魔，使其获得+22智力的效果。",
	[-23803] = "附魔武器 - 强效精神/永久性地为一件近战武器附魔，使其获得+20精神的效果。",
	[-22749] = "附魔武器 - 法术能量/永久性地为一把近战武器附魔，使它获得所有法术伤害和治疗提高最多30点的效果。",
	[-20031] = "附魔武器 - 超强打击/永久性地为一把近战武器附魔，使它获得伤害+5的效果。",
	[-27948] = "附魔长靴 - 活力/永久性地为一双靴子附魔，使它们获得每5秒回复4点生命值和法力值的效果。该装备等级不得低于35级。",
	[-27899] = "附魔护腕 - 强壮/永久性地为一副护腕附魔，使它们获得力量提高12点的效果。该装备等级不得低于35级。",
	[-34001] = "附魔护腕 - 特效智力/永久性地为一副护腕附魔，使它们获得智力提高12点的效果。该装备等级不得低于35级。",
	[-33993] = "附魔手套 - 冲击/永久性地为一双手套附魔，使它们获得法术爆击等级提高10的效果。该装备等级不得低于35级。",
	[-34004] = "附魔披风 - 强效敏捷/永久性地为一件披风附魔，使它获得敏捷提高12点的效果。该装备等级不得低于35级。",
	[-27961] = "附魔披风 - 特效护甲/永久性地为一件披风附魔，使它获得护甲值提高120点的效果。该装备等级不得低于35级。",
	[-33996] = "附魔手套 - 突袭/永久性地为一双手套附魔，使它们获得攻击强度提高26点的效果。该装备等级不得低于35级。",
	[-27944] = "附魔盾牌 - 坚韧盾牌/永久性地为一面盾牌附魔，使它获得格挡值提高18点的效果。该装备等级不得低于35级。",
	[-27905] = "附魔护腕 - 属性/永久性地为一副护腕附魔，使它们获得所有属性提高4点的效果。该装备等级不得低于35级。",
	[-27957] = "附魔胸甲 - 杰出生命/永久性地为一件胸甲附魔，使它获得生命值提高150点的效果。该装备等级不得低于35级。",
	[-27950] = "附魔长靴 - 坚韧/永久性地为一双靴子附魔，使它们获得耐力提高12点的效果。该装备等级不得低于35级。",
	[-27906] = "附魔护腕 - 特效防御/永久性地为一副护腕附魔，使它们获得防御等级提高12的效果。该装备等级不得低于35级。",
	[-33990] = "附魔胸甲 - 特效精神/永久性地为一件胸甲附魔，使它获得精神提高15点的效果。该装备等级不得低于35级。",
	[-27911] = "附魔护腕 - 超强治疗/永久性地为一副护腕附魔，使它获得法术治疗效果提高最多30点、法术伤害提高最多10点的效果。该物品等级不得低于35级。",
	[-34003] = "附魔披风 - 法术穿透/永久性地为一件披风附魔，使它获得法术穿透提高20的效果。该装备等级不得低于35级。",
	[-27945] = "附魔盾牌 - 智力/永久性地为一面盾牌附魔，使它获得智力提高12点的效果。该装备等级不得低于35级。",
	[-34009] = "附魔盾牌 - 特效耐力/永久性地为一面盾牌附魔，使它获得耐力提高18点的效果。该装备等级不得低于35级。",
	[-27962] = "附魔披风 - 特效抗性/永久性地为一件披风附魔，使它获得所有抗性提高7点的效果。该装备等级不得低于35级。",
	[-27913] = "附魔护腕 - 优秀法力回复/永久性地为一副护腕附魔，使它们获得每5秒回复6点法力值的效果。该装备等级不得低于35级。",
	[-27951] = "附魔长靴 - 灵巧/永久性地为一双靴子附魔，使它们获得敏捷提高12点的效果。该装备等级不得低于35级。",
	[-33995] = "附魔手套 - 特效力量/永久性地为一双手套附魔，使它们获得力量提高15点的效果。该装备等级不得低于35级。",
	[-27946] = "附魔盾牌 - 盾牌格挡/永久性地为一面盾牌附魔，使它获得格挡等级提高15的效果。该装备等级不得低于35级。",
	[-27968] = "附魔武器 - 特效智力/永久性地为一把近战武器附魔，使它获得智力提高30点的效果。该装备等级不得低于35级。",
	[-27967] = "附魔武器 - 特效打击/永久性地为一把近战武器附魔，使它获得伤害提高7点的效果。该装备等级不得低于35级。",
	[-27960] = "附魔胸甲 - 杰出属性/永久性地为一件胸甲附魔，使它获得所有属性提高6点的效果。该装备等级不得低于35级。",
	[-33992] = "附魔胸甲 - 特效韧性/永久性地为一件胸甲附魔，使它获得韧性等级提高15的效果。该装备等级不得低于35级。",
	[-27971] = "附魔双手武器 - 野蛮/永久性地为一把双手近战武器附魔，使它获得攻击强度提高70点的效果。该装备等级不得低于35级。",
	[-27914] = "附魔护腕 - 坚韧/永久性地为一副护腕附魔，使它们获得耐力提高12点的效果。该装备等级不得低于35级。",
	[-34005] = "附魔披风 - 强效奥术抗性/永久性地为一件披风附魔，使它获得奥术抗性提高15点的效果。该装备等级不得低于35级。",
	[-34006] = "附魔披风 - 强效暗影抗性/永久性地为一件披风附魔，使它获得暗影抗性提高15点的效果。该装备等级不得低于35级。",
	[-33999] = "附魔手套 - 特效治疗/永久性地为一双手套附魔，使它获得法术治疗效果提高最多35点、法术伤害提高最多12点的效果。该物品等级不得低于35级。",
	[-34010] = "附魔武器 - 特效治疗/永久性地为一把近战武器附魔，使它获得法术治疗效果提高最多81点、法术伤害提高最多27点的效果。该装备等级不得低于35级。",
	[-27975] = "附魔武器 - 特效法术能量/永久性地为一把近战武器附魔，使它获得法术伤害和治疗提高最多40点的效果。该装备等级不得低于35级。",
	[-27972] = "附魔武器 - 力量/永久性地为一把近战武器附魔，使它获得力量提高20点的效果。该装备等级不得低于35级。",
	[-27977] = "附魔双手武器 - 特效敏捷/永久性地为一把双手近战武器附魔，使它获得敏捷提高35点的效果。该装备等级不得低于35级。",
	[-34008] = "附魔长靴 - 野猪之速/永久性地为一双靴子附魔，使它们获得移动速度略微提升以及耐力提高9点的效果。该装备等级不得低于35级。",
	[-34007] = "附魔长靴 - 豹之迅捷/永久性地为一双靴子附魔，使它们获得移动速度略微提升以及敏捷提高6点的效果。该装备等级不得低于35级。",
	[-27917] = "附魔护腕 - 法术能量/永久性地为一副护腕附魔，使它们获得法术伤害提高最多15点的效果。该装备等级不得低于35级。",
	[-33997] = "附魔手套 - 特效法术能量/永久性地为一双手套附魔，使它获得法术伤害和治疗提高最多20点的效果。该装备等级不得低于35级。",
	[-33994] = "附魔手套 - 法术打击/永久性地为一双手套附魔，使它们获得法术命中等级提高15的效果。该装备等级不得低于35级。",
	[-27924] = "附魔戒指 - 法术能量/永久性地为一只戒指附魔，使它获得法术伤害和治疗提高最多12点的效果。只有附魔师自己的戒指才能附魔，且对戒指附魔会使它变为灵魂绑定物品。该装备等级不得低于35级。",
	[-27920] = "附魔戒指 - 打击/永久性地为一只戒指附魔，使它获得物理伤害提高2点的效果。只有附魔师自己的戒指才能附魔，且对戒指附魔会使它变为灵魂绑定物品。该装备等级不得低于35级。",
	[-27947] = "附魔盾牌 - 抗性/永久性地为一面盾牌附魔，使它获得对所有魔法的抗性提高5点的效果。该装备等级不得低于35级。",
	[-28004] = "附魔武器 - 作战专家/永久性地为一把近战武器附魔，使它有一定几率在命中目标后为附近的小队成员恢复180到300点生命值。该装备等级不得低于35级。",
	[-28003] = "附魔武器 - 魔法激荡/永久性地为一把近战武器附魔，使其获得在施法时有3%的几率在10秒内为所有小队成员恢复100点法力值的效果。该装备等级不得低于35级。",
	[-27954] = "附魔长靴 - 稳固/永久性地为一双靴子附魔，使它们获得对诱捕和定身效果的抵抗几率提高5%、以及命中等级提高10的效果。该装备等级不得低于35级。",
	[-27926] = "附魔戒指 - 治疗能量/永久性地为一只戒指附魔，使它获得法术治疗效果提高最多20点、法术伤害提高最多7点的效果。只有附魔师自己的戒指才能附魔，且对戒指附魔会使它变为灵魂绑定物品。该装备等级不得低于35级。",
	[-27927] = "附魔戒指 - 属性/永久性地为一只戒指附魔，使它获得所有属性提高4点的效果。只有附魔师自己的戒指才能附魔，且对戒指附魔会使它变为灵魂绑定物品。该装备等级不得低于35级。",
	[-27984] = "附魔武器 - 猫鼬/永久性地为一把近战武器附魔，使它有一定几率令你的敏捷提高120点，攻击速度略微提升。该装备等级不得低于35级。",
	[-27982] = "附魔武器 - 魂霜/永久性地为一把近战武器附魔，使其获得最多54点冰霜和暗影伤害加成的效果。该装备等级不得低于35级。",
	[-27981] = "附魔武器 - 阳炎/永久性地为一把近战武器附魔，使其获得最多50点火焰和奥术伤害加成的效果。该装备等级不得低于35级。",
	[-27958] = "附魔胸甲 - 杰出法力/永久性地为一件胸甲附魔，使它获得法力值提高150点的效果。该装备等级不得低于35级。",
    [-42620] = "附魔武器 - 强效敏捷/永久性地为一把武器附魔，使其获得敏捷+20的效果。该装备等级不得低于35级",
    [-42613] = "转化连结水晶 - 将一颗连结水晶转化为一份小块棱光碎片。",
    [-42974] = "附魔武器 - 斩杀/永久性地为一把近战武器附魔，使它获得无视目标的840点护甲值的效果。该物品等级不得低于60级。",
    [-44383] = "附魔盾牌 - 韧性/永久性地为一面盾牌附魔，使它获得韧性等级提高12的效果。该物品等级不得低于35级。",
    [-45765] = "虚空碎裂/将一块虚空水晶拆分成为两块棱光碎片。",
    [-46594] = "附魔胸甲 - 防御/永久性地为一件胸甲附魔，使它获得防御等级+15的效果。该物品等级不得低于35级。",
    [-47051] = "附魔披风 - 钢纹/永久性地为一件披风附魔，使它获得防御等级+12的效果。该物品等级不得低于35级。",
    }

TradeskillInfo.vars.zones = {
	[1] = "奥特兰克山脉",
	[2] = "阿拉希高地",
	[3] = "灰谷",
	[4] = "艾萨拉",
	[5] = "荒芜之地",
	[6] = "黑石深渊",
	[7] = "诅咒之地",
	[8] = "燃烧平原",
	[9] = "黑海岸",
	[10] = "达纳苏斯",
	[11] = "凄凉之地",
	[12] = "厄运之槌",
	[13] = "丹莫洛",
	[14] = "杜洛塔",
	[15] = "暮色森林",
	[16] = "尘泥沼泽",
	[17] = "东瘟疫之地",
	[18] = "艾尔文森林",
	[19] = "费伍德森林",
	[20] = "菲拉斯",
	[21] = "莫诺瑞根",
	[22] = "希尔斯布莱德丘陵",
	[23] = "铁炉堡",
	[24] = "洛克莫丹",
	[25] = "月光林地",
	[26] = "莫高雷",
	[27] = "纳克萨玛斯",
	[28] = "奥格瑞玛",
	[29] = "赤脊山",
	[30] = "安其拉废墟",
	[31] = "希利苏斯",
	[32] = "银松森林",
	[33] = "石爪山脉",
	[34] = "暴风城",
	[35] = "荆棘谷",
	[36] = "悲伤沼泽",
	[37] = "塔纳利斯",
	[38] = "泰达希尔",
	[39] = "贫瘠之地",
	[40] = "辛特兰",
	[41] = "千针石林",
	[42] = "雷霆崖",
	[43] = "提瑞斯法林地",
	[44] = "安戈洛环形山",
	[45] = "幽暗城",
	[46] = "哀嚎洞穴",
	[47] = "西瘟疫之地",
	[48] = "西部荒野",
	[49] = "湿地",
	[50] = "冬泉谷",
	[51] = "斯坦索姆",
	[52] = "通灵学院",
-- Burning Crusade	
	[53] = "地狱火半岛",
	[54] = "永歌森林",
	[55] = "银月城",
	[56] = "卡拉赞",
	[57] = "秘蓝岛",
	[58] = "埃索达",
	[59] = "刀锋山",
	[60] = "沙塔斯城",
	[61] = "虚空风暴",
	[62] = "幽魂之地",
	[63] = "旧希尔斯布莱德丘陵",
	[64] = "秘血岛",
	[65] = "影月谷",
	[66] = "泰罗卡森林",
	[67] = "赞加沼泽",
	[68] = "逆风小径",
	[69] = "纳格兰",
    [70] = "黑暗神庙",
    [71] = "海加尔山",     
    [72] = "奎尔丹纳斯岛",
}
TradeskillInfo.vars.factions = {
	[1] = FACTION_ALLIANCE,
	[2] = FACTION_HORDE,
	[3] = "",
	[4] = "银色黎明",
	[5] = "塞纳里奥议会",
	[6] = "瑟银兄弟会",
	[7] = "木喉要塞",
	[8] = "赞达拉部族",
-- Burning Crusade
	[9] = "时光守护者",
	[10] = "流沙之鳞",
	[11] = "紫罗兰之眼",
	[12] = "塞纳里奥远征队",
	[13] = "孢子村",
	[14] = "萨尔玛",
	[15] = "荣耀堡",
	[16] = "玛格汉",
	[17] = "库雷尼",
	[18] = "星界财团",
	[19] = "占星者",
	[20] = "奥尔多",
	[21] = "沙塔尔",
	[22] = "贫民窟",
    [23] = "灰舌死誓者",
    [24] = "破碎残阳",
}
-- Kurenai / The Mag'har
-- Honor Hold / Thrallmar
-- The Scryers / The Aldor

TradeskillInfo.vars.vendors = {
--      "name|zone|faction|location|comment"
	[1] = "阿比盖尔·沙伊尔|43|2|61,52",
	[2] = "安迪尔·风矛|31|5|63,50",
	[3] = "炼金师匹斯特苏格|37|3|51,27",
	[4] = "亚历山德拉·波利罗|34|1|43,74",
	[5] = "奥格诺恩|45|2|52,74",
	[6] = "艾米·达文波特|29|1|29,47",
	[7] = "安德鲁·希尔伯特|32|2|43,40",
	[8] = "安多德·法德兰|2|1|45,47",
	[9] = "银色黎明军需官哈萨娜|43|4|83,68",
	[10] = "银色黎明军需官莱斯巴克|47|4|43,84",
	[11] = "巴莱·洛克维|16|2|36,31",
	[12] = "拜尔|19|2|35,53",
	[13] = "巴纳拉什|36|2|45,57",
	[14] = "布里莫|4|3|46,90",
	[15] = "布里克雷兹·古斯提|35|3|28,77",
	[16] = "布雷兹里克·巴克舒特|37|3|52,28",
	[17] = "布里兹提克|15|3|18,54",
	[18] = "伯布斯·钢轴|23|1|40,34",
	[19] = "博亚|28|2|63,51",
	[20] = "布琳娜·星光|20|1|89,46",
	[21] = "布洛金|1|3|38,39",
	[22] = "布隆克|20|2|76,43",
	[23] = "凯瑟琳·利兰|34|1|46,59",
	[24] = "克里斯托弗·杰弗寇特|22|2|63,19",
	[25] = "克莱德·兰萨尔|29|1|89,70",
	[26] = "康斯坦茨·布里斯博埃斯|43|2|52,55",
	[27] = "布鲁斯下士|35|1|38,3",
	[28] = "怯懦的克罗斯比|35|3|27,83",
	[29] = "克拉赛·斯巴克斯|35|3|28,77",
	[30] = "达利亚|3|1|36,52",
	[31] = "丹尼尔·巴特莱特|45|2|64,38",
	[32] = "丹尼勒·希普斯迪|15|1|76,46",
	[33] = "达利安·辛格|34|1|30,68",
	[34] = "旅店老板达纳尔|25|3|52,33",
	[35] = "迪菲亚奸商|48|1|44,68",
	[36] = "德尼布·沃克|2|1|27,59",
	[37] = "德拉克·奈特弗|22|2|62,20",
	[38] = "迪尔格·奎克里弗|37|3|53,28",
	[39] = "德拉克·卷刃|24|1|36,49",
	[40] = "德拉克·林格雷|18|1|83,67",
	[41] = "德鲁纳·烈酒|2|1|46,47",
	[42] = "艾琳娜|10|1|64,22",
	[43] = "埃姆鲁尔·里克努斯|23|1|60,38",
	[44] = "艾瑞卡·塔特|34|1|76,37",
	[45] = "埃文·维布鲁|50|3|61,38",
	[46] = "弗拉德|49|1|26,26",
	[47] = "菲尔丹|10|1|48,21",
	[48] = "加格斯普吉特|39|3|63,36",
	[49] = "考格斯宾|23|1|68,43",
	[50] = "乔治·坎达特|22|2|91,39",
	[51] = "卡尔拉什|36|2|46,52",
	[52] = "格鲁克卡恩|16|2|36,31",
	[53] = "吉盖特·火油|40|3|35,39",
	[54] = "吉科希斯|37|3|67,22",
	[55] = "吉娜·马克葛瑞格|48|1|57,54",
	[56] = "格劳瑞亚·菲米尔|29|1|27,44",
	[57] = "格里克斯·布鲁维特|35|3|28,77",
	[58] = "格纳兹·枪焰|35|3|51,35",
	[59] = "格雷塔·甘特|13|1|31,44",
	[60] = "格瑞姆塔克|14|2|51,42",
	[61] = "哈格鲁斯|28|2|46,46",
	[62] = "哈蒙·卡文|2|1|47,48",
	[63] = "哈尔甘|40|1|14,45",
	[64] = "哈克兰·月林|3|1|51,67",
	[65] = "哈鲁恩·暗纹|3|1|18,59",
	[66] = "哈恩·长线|26|2|48,55",
	[67] = "海尔丹·风歌|9|1|37,56",
	[68] = "海伦妮亚·奥德恩|16|1|66,52",
	[69] = "西米克|50|3|61,39",
	[70] = "哈拉玛|39|2|52,30",
	[71] = "加贝|37|3|67,22",
	[72] = "詹迪亚|41|2|46,51",
	[73] = "詹奈特·霍莫斯|11|1|66,7",
	[74] = "杉多尔·迅蹄|20|2|74,43",
	[75] = "加诺斯·铁心|2|1|46,48",
	[76] = "加奎琳娜·德拉米特|35|3|36,11",
	[77] = "贾斯·法拉恩|17|3|81,58",
	[78] = "加兹里克|5|3|42,53",
	[79] = "基达|33|2|47,62",
	[80] = "吉娜比克·铁线|49|1|8,56",
	[81] = "杰萨拉·考迪尔|34|1|44,64",
	[82] = "金克·铁钩|41|3|77,76",
	[83] = "约瑟夫·摩尔|45|2|71,59",
	[84] = "朱比|4|3|45,91",
	[85] = "祖恩哈|2|2|73,36",
	[86] = "祖塔克|35|3|27,77",
	[87] = "凯塔·深炉|34|1|56,17",
	[88] = "卡尔丹·暗月|46|3|",
	[89] = "卡妮亚|31|5|52,40",
	[90] = "基纳|2|2|74,33",
	[91] = "凯尔希·杨斯|35|3|28,74",
	[92] = "肯多尔·卡邦卡|34|1|75,37",
	[93] = "卡拉·深水|24|1|40,39",
	[94] = "霍勒|34|1|56,60|Seasonal",
	[95] = "吉克尼库|39|3|42,38",
	[96] = "基利恩·萨纳森|32|2|33,18",
	[97] = "基尔克斯|39|3|63,38",
	[98] = "基瑞娜|11|2|51,54",
	[99] = "基萨斯|28|2|53,37",
	[100] = "克纳兹·枪焰|35|3|51,35",
	[101] = "考吉尔德|28|2|56,34",
	[102] = "克雷贡·塔尔松|48|1|37,89",
	[103] = "克林科·古德斯迪尔|37|3|52,29",
	[104] = "库尔维亚|33|2|46,60",
	[105] = "卡兹克斯|15|3|81,21",
	[106] = "莱尔德|9|1|37,44",
	[107] = "拉尔丹|3|1|34,49",
	[108] = "雷欧·萨恩|32|2|54,82",
	[109] = "莱纳德·波特|47|1|43,84",
	[110] = "安多洛夫中将|30|5|",
	[111] = "莉蕾|32|2|43,50",
	[112] = "林迪·拉波尼|22|1|51,61",
	[113] = "莉兹白·克伦威尔|45|2|81,31",
	[114] = "洛加纳斯|20|1|33,44",
	[115] = "罗克图斯·暗契|6|6|",
	[116] = "罗莱尔·冬歌|25|3|48,40",
	[117] = "玛格努斯·霜鸣|47|3|68,77|Quest",
	[118] = "曼胡|42|2|44,45",
	[119] = "玛林·斯万|22|2|62,21",
	[120] = "玛里甘|19|1|62,26",
	[121] = "玛丽亚·卢米尔|34|1|46,78",
	[122] = "马丁·塔布雷|43|2|66,59",
	[123] = "马萨特·坦德|36|3|25,31",
	[124] = "大工匠奥玛里恩|27|3|",
	[125] = "马弗拉林|9|1|37,41",
	[126] = "玛兹克·斯奈普沙特|35|3|28,75",
	[127] = "梅罗什|19|7|66,3",
	[128] = "米莎·杨斯|22|1|49,55",
	[129] = "米利尔·格里高利|45|2|71,30",
	[130] = "米什塔|31|5|50,36",
	[131] = "莫塔尔|41|2|45,50",
	[132] = "穆尔兰|11|2|56,56",
	[133] = "迈斯林迪尔|10|1|61,18",
	[134] = "纳尔·迷雾行者|42|2|52,52",
	[135] = "纳姆杜|21|1|",
	[136] = "南达·布拉森|22|1|50,57",
	[137] = "纳斯塔姆·卡布彬|45|2|69,40|Seasonal",
	[138] = "纳尔基·长刀|2|1|46,48",
	[139] = "纳尔克|35|3|28,74",
	[140] = "纳塔·黎明行者|42|2|45,40",
	[141] = "奈尔加|44|3|43,8",
	[142] = "耐里斯特|35|2|32,29",
	[143] = "尼莎·影歌|38|1|56,92",
	[144] = "妮娜·莱特布鲁|7|1|67,18",
	[145] = "尼奥玛|40|1|13,43",
	[146] = "奈欧玛|38|1|57,60",
	[147] = "奥克玛尔|16|2|36,31",
	[148] = "老人海明威|35|3|27,77",
	[149] = "奥索·莫吉克|40|2|80,80",
	[150] = "埃瑞克|23|1|43,29",
	[151] = "本尼·考伯宾奇|28|2|53,67|Seasonal",
	[152] = "普拉格|6|3|",
	[153] = "普拉特·马克格鲁比|20|1|30,42",
	[154] = "琦亚|50|3|61,37",
	[155] = "军需官米兰达·布利洛克|17|4|82,60",
	[156] = "拉尼克|39|3|62,39",
	[157] = "拉恩·火翼|24|1|36,46",
	[158] = "拉尔塔36|2|45,57",
	[159] = "雷克奇兹|35|3|28,76",
	[160] = "商人林沃斯|35|8|15,16",
	[161] = "里兹·飞矢|1|3|47,35",
	[162] = "罗纳德·伯奇|45|2|63,44",
	[163] = "鲁普·火油|40|3|34,38",
	[164] = "塞诺里奥|10|1|63,22",
	[165] = "希尔萨|42|2|44,59|Seasonal",
	[166] = "苏瓦·迷雾行者|42|2|56,48",
	[167] = "珊蒂瑞亚|3|1|50,67",
	[168] = "山吉斯|28|2|69,30",
	[169] = "希恩德拉·深草|20|2|74,43",
	[170] = "辛德拉圣职者|12|3|",
	[171] = "舍瑞·希普斯迪|15|1|76,46",
	[172] = "斯穆德·雷木|22|3|84,19",
	[173] = "苏雷·浆泡|23|1|67,55",
	[174] = "索维克|28|2|75,25",
	[175] = "斯图亚特·弗雷明|49|1|8,58",
	[176] = "苏米|28|2|82,23",
	[177] = "超级商人680型|11|3|41,79|Intermittent",
	[178] = "达玛尔|28|2|63,44",
	[179] = "坦斯·泥泡|23|1|48,6",
	[180] = "塔班·熟麦|39|2|56,32",
	[181] = "塔里查|39|2|52,31",
	[182] = "萨德乌斯·韦伯|45|2|62,61",
	[183] = "萨瑞恩·博丁|18|1|42,67",
	[184] = "提尔利·草须|23|1|61,44",
	[185] = "特鲁克·蛮鬃|40|1|14,42",
	[186] = "吞克|2|2|74,35",
	[187] = "尤萨恩|3|1|50,67",
	[188] = "尤希尔|10|1|56,24",
	[189] = "尤索克|35|2|31,28",
	[190] = "维安|10|1|58,15",
	[191] = "瓦尔达隆|9|1|38,41",
	[192] = "瓦古斯|31|5|51,39",
	[193] = "维尼克斯|33|3|58,52",
	[194] = "贸易机器人1000型|11|3|61,38|Intermittent",
	[195] = "维哈尔|35|2|32,29",
	[196] = "薇薇安娜|20|1|31,43",
	[197] = "维兹格里克|37|3|51,27",
	[198] = "温纳·银须|49|1|26,26",
	[199] = "维尔格·厚刃|43|2|83,70",
	[200] = "维克塔|3|2|12,34",
	[201] = "沃尔布|20|2|74,43",
	[202] = "瓦尔克|39|2|53,31",
	[203] = "乌兰|11|2|27,70",
	[204] = "乌莫尔特|23|1|33,67|Seasonal",
	[205] = "温纳·黑鬃26|2|46,58",
	[206] = "山达·细须|24|1|83,63",
	[207] = "克森图|28|2|57,53",
	[208] = "希兹克·古斯提|35|3|28,76",
	[209] = "希兹尔·菲兹波特|50|3|61,39",
	[210] = "犹纳达|39|2|45,60",
	[211] = "尤卡·斯库比格特|8|3|66,23",
	[212] = "萨恩·刀链22|3|84,18",
	[213] = "扎诺克|31|3|82,18",
	[214] = "詹苏尔|14|2|57,73",
	[215] = "萨瑞娜·克罗姆温德|35|3|28,75",
	[216] = "扎尔夫|39|2|53,30",
	[217] = "吉克希尔|22|3|61,21|Roving",
	[218] = "索尔宾·范达瑟|20|3|45,43|Quest",
	[219] = "红衣战斗法师|51|3",
	[220] = "鬼灵研究员|52|3",
	[221] = "通灵学院黑暗召唤师|52|3",
	[222] = "黑石军官|8|3",
	[223] = "食尸抢夺者|51|3",
-- Burning Crusade
	[224] = "德伊娜|55|2|56,50",
	[225] = "伊恩|60|3|66,68",
	[226] = "奈伊|58|1|64,68",
	[227] = "波尔图|69|1|53,72",
	[228] = "玛萨·格卡尔|69|2|55,37",
	[229] = "安迪恩·达克斯宾|60|3|66,68",
	[230] = "阿隆德|65|2|56,58",
	[231] = "纳丝玛拉·月歌|60|3|66,69",
	[232] = "金吉·斯比维尔|60|3|66,69",
	[233] = "卡拉兹|61|18|44,34",
	[234] = "纳克杜|60|22|62,69",
	[235] = "军需官恩达尔林|60|20|48,26",
	[236] = "军需官恩努利尔|60|19|61,64",
	[237] = "芬德雷·迅矛|67|12|79,64",
	[238] = "编织者姆赫鲁|67|1|41,28",
	[239] = "祖莱|67|2|85,55",
	[240] = "库雷恩|56|11|",
	[241] = "克雷格·碎岩|65|2|29,31",
	[242] = "卢尔鲁娜|67|1|69,50",
	[243] = "埃隆·霍尔曼|60|3|64,71",
	[244] = "阿尔拉斯|58|1|61,90",
	[245] = "恩里德|55|2|80,36",
	[246] = "玛里·石拳|65|1|37,55",
	[247] = "罗霍克|53|2|53,38",
	[248] = "军需官乌尔格隆|53|14|55,38",
	[249] = "后勤军需官乌瑞卡|53|15|57,63",
	[250] = "海尔伦|67|1|68,48",
	[251] = "哈尔雷恩|67|1|68,48",
	[252] = "先知亚尼迪|67|2|32,52",
	[253] = "达加·拉姆巴|59|2|51,58",
	[254] = "艾鲁尔米|37|9|64,58",
	[255] = "奥玛多尔|60|21|50,42",
	[256] = "麦卡|67|3|18,51",
	[257] = "商人纳拉苏|69|17|55,75",
	[258] = "奥泰恩|58|1|28,63",
	[259] = "梅拉瑞斯|55|2|67,20",
	[260] = "斯克雷亚|60|3|46,20",
	[261] = "炼金师格里比|53|1|54,66",
	[262] = "药剂师安东尼维奇|53|2|52,37",
	[263] = "莉莉·朗哈格|66|1|58,53",
	[264] = "布尔库|53|1|22,39",
	[265] = "阿蕾瑟拉|53|2|26,62",
	[266] = "巴柯斯特|53|2|56,41|Mobile",
	[267] = "加斯顿|53|1|54,64",
	[268] = "纳卡|67|3|79,63",
	[269] = "兰达兰尼斯|54|2|49,47",
	[270] = "大厨师莫迪尔|62|2|48,31",
	[271] = "旅店老板格里尔卡|66|2|49,45",
	[272] = "供给官米尔斯|66|1|56,53",
	[273] = "度巴|67|1|42,28",
	[274] = "加巴林卡|67|2|32,49",
	[275] = "法苏|64|1|54,56",
	[276] = "旅店老板贝莉比|66|1|57,53",
	[277] = "伦格尔|66|2|49,46",
	[278] = "屠夫努尔拉|69|2|58,36",
	[279] = "乌利库|69|1|56,73",
	[280] = "独眼曲奇|53|2|55,41",
	[281] = "希德·利巴迪|53|1|54,64",
	[282] = "阿尔雷德|58|1|45,26",
	[283] = "基兰希斯|55|2|91,74",
	[284] = "尼尔·奥雷|49|1|11,57",
	[285] = "菲利卡|28|2|51,36|Roving",
	[286] = "艾德娜·穆比34|1|58,61",
	[287] = "巴比克·齿轮|23|1|47,27",
	[288] = "菲利希亚·杜安|45|2|64,50",
	[289] = "沙迪·迷雾行者|42|2|40,64",
	[290] = "学徒达里乌斯|68|11|47,75",
	[291] = "卡莱恩|53|2|57,38",
	[292] = "塔蒂亚娜|53|1|55,64",
	[293] = "菲拉|58|1|54,91",
	[294] = "维格兹·沙斯巴克|60|3|65,69",
	[295] = "亚瑟恩|55|2|76,40",
	[296] = "达格尔·塑铁|65|1|37,54",
	[297] = "米希·法索|53|2|61,82",
	[298] = "星界商人拉斯莱|60|3|72,30",
	[299] = "莱布斯基|53|1|56,66",
	[300] = "被俘虏的侏儒|67|2|33,48",
	[301] = "补给官纳瑟拉|69|16|54,37",
	[302] = "哈弗雷特|58|1|66,75",
	[303] = "萨拉尔达|55|2|84,79",
	[304] = "克鲁·粗线|60|3|67,67",
	[305] = "托马斯·杨斯|63|3|",
	[306] = "基诺·杜弗莱|67|3|78,66",
	[307] = "沃德辛|53|1|24,38",
	[308] = "安多尔姆|37|10|58,59",
	[309] = "老迈的达拉然巫师|63|3|",
	[310] = "卢比夫人|60|3|63,70",
	[311] = "艾苟米斯|58|1|39,40",
	[312] = "琳娜|55|2|69,24",
    [313] = "欧库诺|70|23",
    [314] = "隐多米|71|10",
    [315] = "埃达拉·晨行者|72|24",
    [316] = "珊妮|72|24",
}
TradeskillInfo.vars.recipes = {
-- factionrank: 4 Neutral, 5 Friendly, 6 Honored, 7 Revered, 8 Exalted
-- [recipe] = "result|source|price|factionrank"
	[728] = "733|V92Qa|200",
	[2406] = "2307|D",
	[2407] = "2311|D",
	[2408] = "2312|D",
	[2409] = "2317|D",
	[2553] = "2457|D",
	[2555] = "2459|D",
	[2598] = "2572|D",
	[2601] = "2585|D",
	[2697] = "724|V92Qa|400",
	[2698] = "2682|V92|400",
	[2699] = "1082|V92Qa|800",
	[2700] = "2685|V92D|400",
	[2701] = "1017|V92Qa|1600",
	[2881] = "2864|D",
	[2882] = "3481|D",
	[2883] = "3490|D",
	[2889] = "2888|V92Qa|240",
	[3393] = "3384|D",
	[3394] = "3386|D",
	[3395] = "3387|D",
	[3396] = "3390|D",
	[3608] = "3492|D",
	[3609] = "3471|QaD",
	[3610] = "3474|D",
	[3611] = "3484|D",
	[3612] = "3485|D",
	[3678] = "3662|V92Qa|400",
	[3679] = "3220|V92Qa|400",
	[3680] = "3663|V92Qa|1600",
	[3681] = "3664|V92Qa|1600",
	[3682] = "3665|V92V90V142Qa|1600",
	[3683] = "3666|V92Qa|1600",
	[3734] = "3726|V187V177Qh|1600",
	[3735] = "3727|V216V194Qh|1800",
	[3736] = "3728|Qa",
	[3737] = "3729|Q",
	[3830] = "3825|D",
	[3831] = "3826|D",
	[3832] = "3828|D",
	[3866] = "3850|D",
	[3867] = "3852|D",
	[3868] = "3854|D",
	[3869] = "3856|D",
	[3870] = "3840|D",
	[3871] = "3841|D",
	[3872] = "3843|D",
	[3873] = "3845|D",
	[3874] = "3846|D",
	[3875] = "3847|D",
	[4292] = "4241|D",
	[4293] = "4244|D",
	[4294] = "4250|D",
	[4296] = "4252|D",
	[4297] = "4254|D",
	[4298] = "4258|D",
	[4299] = "4256|D",
	[4300] = "4260|D",
	[4301] = "4264|D",
	[4345] = "4313|D",
	[4346] = "4311|D",
	[4347] = "4315|D",
	[4348] = "4331|D",
	[4349] = "4317|D",
	[4350] = "4321|D",
	[4351] = "4323|D",
	[4352] = "4325|D",
	[4353] = "4328|D",
	[4354] = "4335|D",
	[4355] = "4327|V128V52|1500",
	[4356] = "4329|D",
	[4408] = "4401|D",
	[4409] = "4367|D",
	[4410] = "4373|D",
	[4411] = "4376|D",
	[4412] = "4383|D",
	[4413] = "4388|D",
	[4414] = "4403|D",
	[4415] = "4393|D",
	[4416] = "4395|D",
	[4417] = "4398|D",
	[4597] = "4596|Qh",
	[4609] = "4457|V138V177Q|1000",
	[4624] = "4623|Q",
	[5083] = "5081|Qh",
	[5482] = "5472|Qa",
	[5483] = "5473|V60|140",
	[5484] = "5474|V205|240",
	[5485] = "5476|V106|400",
	[5486] = "5477|V181QQa|440",
	[5487] = "5478|Qh",
	[5488] = "5479|V181|400",
	[5489] = "5480|V187V194|1200",
	[5528] = "5526|V67V102|800",
	[5543] = "5541|D",
	[5578] = "2869|D",
	[5640] = "5631|V35V206V61V156|100",
	[5642] = "5634|V173V188V101V194|1800",
	[5643] = "5633|V188V61V194|2000",
	[5771] = "5762|V55V191V7V118|200",
	[5772] = "5763|V6V80V157V191V19V118V129V202V210V95V217|500",
	[5773] = "5770|D",
	[5774] = "5764|D",
	[5775] = "5765|D",
	[5786] = "5780|V55V125V7D|550",
	[5787] = "5781|V55V125V7D|600",
	[5788] = "5782|V128V24V15D|650",
	[5789] = "5783|V68V15D|2800",
	[5972] = "5958|D",
	[5973] = "5963|V62V107V72V90V194D|650",
	[5974] = "5965|D",
	[6039] = "6038|V91|5000",
	[6044] = "6042|D",
	[6045] = "6043|D",
	[6046] = "6041|D",
	[6047] = "3837|V103|4400",
	[6053] = "6051|V206V70V105|800",
	[6054] = "6048|V64V24|900",
	[6055] = "6049|V136V79|1500",
	[6056] = "6050|V41V57|2000",
	[6057] = "6052|V114V22V57V3|2000",
	[6068] = "3824|V131V17|1500",
	[6211] = "3391|D",
	[6270] = "6240|V183V191V19V26V202|200",
	[6271] = "6239|D",
	[6272] = "6242|V40V42V7V202V156|300",
	[6274] = "6263|V55V4V19V119V210|400",
	[6275] = "6264|V42V80V157V171V129V156|800",
	[6325] = "6290|V23V59V93V146V183V66V122V166V113|40",
	[6326] = "787|V102V143V179V122V214|40",
	[6328] = "4592|V93V146V179V183V66V96V134V113|400",
	[6329] = "6316|V93|400",
	[6330] = "4593|V23V112V37V134V166V162V97|1200",
	[6342] = "-7443|V81V184V190V99V108V111V140V182V89|300",
	[6344] = "-7766|D",
	[6346] = "-7776|V99V111|400",
	[6347] = "-7782|D",
	[6348] = "-7786|D",
	[6349] = "-7793|V184V99V108V140|500",
	[6368] = "5095|V23V67V102V143V175V96V168V214V162V97|400",
	[6369] = "4594|V67V112V175V179V168V200V203V91V113|2200",
	[6375] = "-7859|D",
	[6377] = "-7867|V140V217|1000",
	[6390] = "6384|D",
	[6391] = "6385|D",
	[6401] = "4333|V171V119V177|1100",
	[6454] = "6453|D",
	[6474] = "6466|V88|550",
	[6475] = "6467|V88|1500",
	[6476] = "6468|Q",
	[6661] = "6657|D",
	[6663] = "6662|D",
	[6672] = "4852|D",
	[6710] = "6709|Qa",
	[6716] = "6714|D",
	[6735] = "6731|Qa",
	[6892] = "6890|V39V7|250",
	[7084] = "7059|D",
	[7085] = "7060|D",
	[7086] = "7061|D",
	[7087] = "7056|V177V208|1200",
	[7088] = "7063|V197|5000",
	[7089] = "7053|V20V85|1500",
	[7090] = "7065|D",
	[7091] = "7049|D",
	[7092] = "7047|D",
	[7114] = "4319|V198V98|1000",
	[7192] = "7189|D",
	[7288] = "7280|D",
	[7289] = "7283|V25D|650",
	[7290] = "7284|V198D|1600",
	[7360] = "4248|D",
	[7361] = "7349|V65D|1800",
	[7362] = "7352|V217|2000",
	[7363] = "7358|D",
	[7364] = "7359|D",
	[7449] = "7373|D",
	[7450] = "7375|D",
	[7451] = "7386|V153V164V74V83V194D|2800",
	[7452] = "7390|D",
	[7453] = "7391|D",
	[7560] = "7506|V49V82|1200",
	[7561] = "7148|V105V177V193V217|2000",
	[7613] = "4255|V198V50V194D|2000",
	[7742] = "4397|V212|2400",
	[7975] = "7921|D",
	[7976] = "7967|D",
	[7978] = "7913|Qh",
	[7979] = "7914|Qh",
	[7980] = "7915|Qh",
	[7981] = "7916|Qh",
	[7982] = "7917|Qh",
	[7983] = "7926|Q",
	[7984] = "7927|Q",
	[7985] = "7928|Q",
	[7989] = "7969|D",
	[7990] = "7934|D",
	[7991] = "7932|D",
	[7992] = "7942|D",
	[7993] = "7944|D",
	[7995] = "7924|V63V51|6000",
	[8028] = "7946|D",
	[8029] = "7943|D",
	[8030] = "7947|V117D|10000",
	[8384] = "8174|D",
	[8385] = "8187|V153V74|3500",
	[8386] = "8200|D",
	[8387] = "8201|D",
	[8389] = "8202|D",
	[8390] = "8216|D",
	[8395] = "8203|D",
	[8397] = "8205|D",
	[8398] = "8204|D",
	[8399] = "8209|D",
	[8400] = "8207|D",
	[8401] = "8206|D",
	[8402] = "8208|D",
	[8403] = "8210|Q",
	[8404] = "8211|Q",
	[8405] = "8214|Q",
	[8406] = "8213|Q",
	[8407] = "8212|Q",
	[8408] = "8215|Q",
	[8409] = "8192|V145V74V201D|4000",
	[9293] = "9036|D",
	[9294] = "9144|D",
	[9295] = "9172|D",
	[9296] = "9088|D",
	[9297] = "9197|D",
	[9298] = "9206|D",
	[9300] = "9224|V144V158|10000",
	[9301] = "9264|V121V5|10000",
	[9302] = "9210|V114V22|9000",
	[9303] = "9149|V3|8000",
	[9304] = "1|V3|8000",
	[9305] = "2|V3|8000",
	[9367] = "9366|Qa",
	[10300] = "10007|D",
	[10301] = "10008|D",
	[10302] = "10009|D",
	[10311] = "10052|V42V118|3000",
	[10312] = "10018|D",
	[10314] = "10054|V150V19|4000",
	[10315] = "10029|D",
	[10316] = "10048|D",
	[10317] = "10055|V150V19|4000",
	[10318] = "10030|V28|7000",
	[10320] = "10033|D",
	[10321] = "10034|V150V129|4500",
	[10323] = "10035|V150V129|4500",
	[10325] = "10040|V4V118|10000",
	[10326] = "10036|V150V129|5000",
	[10424] = "10423|D",
	[10463] = "10025|Q",
	[10601] = "10499|D",
	[10602] = "10546|V100V211|3000",
	[10603] = "10501|D",
	[10604] = "10510|D",
	[10605] = "10502|D",
	[10606] = "10518|D",
	[10607] = "10506|V84|3600",
	[10608] = "10548|D",
	[10609] = "10576|V163|4000",
	[10644] = "9061|",
	[10713] = "9060|C",
	[10728] = "4336|V139|1500",
	[10858] = "3851|V75V132V78|3000",
	[11038] = "-13380|D",
	[11039] = "-13419|V30V104|800",
	[11081] = "-13464|D",
	[11098] = "-13522|D",
	[11101] = "-13536|V30V104|2500",
	[11150] = "-13612|D",
	[11151] = "-13617|D",
	[11152] = "-13620|D",
	[11163] = "-13646|V128V90|3000",
	[11164] = "-13653|D",
	[11165] = "-13655|D",
	[11166] = "-13698|D",
	[11167] = "-13687|D",
	[11168] = "-13689|D",
	[11202] = "-13817|D",
	[11203] = "-13841|D",
	[11204] = "-13846|D",
	[11205] = "-13868|D",
	[11206] = "-13882|D",
	[11207] = "-13898|D",
	[11208] = "-13915|D",
	[11223] = "-13931|V133V13|5800",
	[11224] = "-13933|D",
	[11225] = "-13945|D",
	[11226] = "-13947|D",
	[11610] = "11608|D",
	[11611] = "11607|D",
	[11612] = "11604|D",
	[11614] = "11606|D",
	[11615] = "11605|D",
	[11813] = "-15596|D",
	[11827] = "11826|D",
	[11828] = "11825|D",
	[12162] = "3849|V87V176V86|3000",
	[12163] = "3853|V215|4400",
	[12164] = "3855|V195V76|4400",
	[12226] = "12224|V1|25",
	[12227] = "12209|V177|1600",
	[12228] = "12210|V27V62V68V90V142V147V194|5000",
	[12229] = "13851|V196V169V177|5000",
	[12231] = "12212|V27V142V194|3000",
	[12232] = "12213|V13V98V147V194|5000",
	[12233] = "12214|V68V73V177|3000",
	[12239] = "12217|V68V147V177|7000",
	[12240] = "12215|V73V98V194|7000",
	[12261] = "12260|D",
	[12682] = "12405|D",
	[12683] = "12406|D",
	[12684] = "12408|D",
	[12685] = "12416|D",
	[12687] = "12428|Q",
	[12688] = "12424|Q",
	[12689] = "12415|D",
	[12690] = "12425|Q",
	[12691] = "12624|D",
	[12692] = "12645|D",
	[12693] = "12409|D",
	[12694] = "12410|D",
	[12695] = "12418|D",
	[12696] = "12628|Q",
	[12697] = "12419|D",
	[12699] = "12631|Q",
	[12700] = "12426|Q",
	[12701] = "12427|Q",
	[12702] = "12417|D",
	[12703] = "12632|V117D|40000",
	[12704] = "12414|D",
	[12705] = "12422|Q",
	[12706] = "12610|D",
	[12707] = "12611|D",
	[12711] = "12633|D",
	[12713] = "12420|D",
	[12714] = "12612|D",
	[12715] = "12429|Q",
	[12716] = "12636|D",
	[12717] = "12640|D",
	[12718] = "12613|D",
	[12719] = "12614|D",
	[12720] = "12639|D",
	[12725] = "12620|Q",
	[12726] = "12619|Q",
	[12727] = "12618|Q",
	[12728] = "12641|D",
	[12819] = "12773|V117D|16000",
	[12821] = "12774|Q",
	[12823] = "12775|V117D|20000",
	[12824] = "12776|Q",
	[12825] = "12777|Q",
	[12827] = "12781|D",
	[12828] = "12792|D",
	[12830] = "12782|D",
	[12833] = "12796|D",
	[12834] = "12790|D",
	[12835] = "12798|D",
	[12836] = "12797|D",
	[12837] = "12794|D",
	[12838] = "12784|D",
	[12839] = "12783|D",
	[12958] = "3|V3|50000",
	[13287] = "4455|V186|2500",
	[13288] = "4456|V8D|2500",
	[13308] = "4386|V161V177|1800",
	[13309] = "4372|V46V82|1000",
	[13310] = "4407|V126V177|2000",
	[13311] = "4396|V58|10000",
	[13476] = "13442|D",
	[13477] = "13443|V188V5|12000",
	[13478] = "13445|V173V101|13000",
	[13479] = "13447|D",
	[13480] = "13446|V45|15000",
	[13481] = "13453|D",
	[13482] = "6|V9V10V155|15000|6",
	[13483] = "4|V152|15000",
	[13484] = "7|V127|15000|5",
	[13485] = "9|V117|15000",
	[13486] = "8|D",
	[13487] = "11|D",
	[13488] = "5|D",
	[13489] = "10|D",
	[13490] = "13455|D",
	[13491] = "13452|D",
	[13492] = "13462|D",
	[13493] = "13454|D",
	[13494] = "13457|D",
	[13495] = "13456|D",
	[13496] = "13458|D",
	[13497] = "13461|D",
	[13499] = "13459|D",
	[13501] = "13444|V117|30000",
	[13518] = "13506|D",
	[13519] = "13510|D",
	[13520] = "13511|D",
	[13521] = "13512|D",
	[13522] = "13513|D",
	[13939] = "6887|V54|16000",
	[13940] = "13927|V91|16000",
	[13941] = "13930|V91|16000",
	[13942] = "13928|V54|16000",
	[13943] = "13929|V91|16000",
	[13945] = "13931|V54|20000",
	[13946] = "13932|V54|20000",
	[13947] = "13933|V196V169|20000",
	[13948] = "13934|V196V169|20000",
	[13949] = "13935|V196V169|20000",
	[14466] = "13869|D",
	[14467] = "13868|D",
	[14468] = "14046|V154|12000",
	[14469] = "13858|V34|12000",
	[14470] = "13857|D",
	[14471] = "14042|D",
	[14472] = "13860|V34|12000",
	[14473] = "14143|D",
	[14474] = "13870|D",
	[14476] = "14043|D",
	[14477] = "14142|D",
	[14478] = "14100|D",
	[14479] = "14101|D",
	[14480] = "14141|D",
	[14481] = "13863|V154|16000",
	[14482] = "14044|D",
	[14483] = "14107|V116|16000",
	[14484] = "14103|D",
	[14485] = "14132|D",
	[14486] = "14134|D",
	[14488] = "13864|V34|12000",
	[14489] = "13871|D",
	[14490] = "14045|D",
	[14491] = "13865|D",
	[14492] = "14108|D",
	[14493] = "14136|D",
	[14494] = "14104|D",
	[14495] = "14144|D",
	[14496] = "14111|D",
	[14497] = "14137|D",
	[14498] = "13866|D",
	[14499] = "14155|D",
	[14500] = "14128|D",
	[14501] = "14138|D",
	[14504] = "13867|D",
	[14505] = "14130|D",
	[14506] = "14106|D",
	[14507] = "14139|D",
	[14508] = "14112|D",
	[14509] = "14140|D",
	[14510] = "14156|D",
	[14511] = "14146|D",
	[14512] = "14154|D",
	[14513] = "14152|D",
	[14514] = "14153|D",
	[14526] = "14342|V154V45|20000",
	[14627] = "4332|V32|800",
	[14630] = "4322|V177V208|1000",
	[14634] = "3829|V21|2500",
	[14635] = "4262|V159V194|3000",
	[14639] = "4381|V46V135|1500",
	[15724] = "15077|V213|12000",
	[15725] = "15083|V109V199|12000",
	[15726] = "15045|V123|12000",
	[15727] = "15076|D",
	[15728] = "15084|D",
	[15729] = "15074|V14D|12000",
	[15730] = "15047|D",
	[15731] = "15091|D",
	[15732] = "15054|D",
	[15733] = "15046|D",
	[15734] = "15061|V153V74D|14000",
	[15735] = "15067|V53D|14000",
	[15737] = "15073|D",
	[15738] = "15078|D",
	[15739] = "15092|D",
	[15740] = "15071|V154|16000",
	[15741] = "15057|V109V199D|16000",
	[15743] = "15082|D",
	[15744] = "15086|D",
	[15745] = "15093|D",
	[15746] = "15072|D",
	[15747] = "15069|D",
	[15748] = "15079|D",
	[15749] = "15053|D",
	[15751] = "15048|V14D|20000",
	[15752] = "15060|D",
	[15753] = "15056|D",
	[15755] = "15075|D",
	[15756] = "15094|V77|22000",
	[15757] = "15087|D",
	[15758] = "15063|V141|22000",
	[15759] = "15050|V152|22000",
	[15760] = "15066|D",
	[15761] = "15070|D",
	[15762] = "15080|V213|25000",
	[15763] = "15049|D",
	[15764] = "15058|D",
	[15765] = "15095|D",
	[15768] = "15088|D223",
	[15770] = "15051|D",
	[15771] = "15059|D",
	[15772] = "15062|D",
	[15773] = "15085|D220",
	[15774] = "15081|D222",
	[15775] = "15055|D",
	[15776] = "15090|D221",
	[15777] = "15096|D219",
	[15779] = "15068|D",
	[15781] = "15052|D",
	[16041] = "15993|V49V174|12000",
	[16042] = "15994|V49V174|12000",
	[16043] = "15995|D",
	[16044] = "15996|D",
	[16045] = "15999|D",
	[16046] = "16023|V209|16000",
	[16047] = "16000|V209|16000",
	[16048] = "16004|D",
	[16049] = "16005|D",
	[16050] = "16006|V209|20000",
	[16051] = "15997|D",
	[16052] = "16009|D",
	[16053] = "16008|D",
	[16054] = "16022|D",
	[16055] = "16040|D",
	[16056] = "16007|D",
	[16072] = "0|V167V203|10000",
	[16083] = "0|V148|10000",
	[16084] = "0|V36V11V52|10000",
	[16110] = "12218|V120V12V69V154|12000",
	[16111] = "12216|V102V13V189|12000",
	[16112] = "6451|V36V11V52|2200",
	[16113] = "8544|V36V11V52|5000",
	[16214] = "-20008|D",
	[16215] = "-20020|D",
	[16216] = "-20014|D",
	[16217] = "-20017|V133V31|12000",
	[16218] = "-20009|D",
	[16219] = "-20012|D",
	[16220] = "-20024|D",
	[16221] = "-20026|V154|16000",
	[16222] = "-20016|D",
	[16223] = "-20029|D",
	[16224] = "-20015|V116|20000",
	[16242] = "-20028|D",
	[16243] = "-20051|V116|22000",
	[16244] = "-20013|D",
	[16245] = "-20023|D",
	[16246] = "-20010|D",
	[16247] = "-20030|D",
	[16248] = "-20033|D",
	[16249] = "-20036|D",
	[16250] = "-20031|D",
	[16251] = "-20011|D",
	[16252] = "-20034|D",
	[16253] = "-20025|D",
	[16254] = "-20032|D",
	[16255] = "-20035|D",
	[16767] = "16766|V71|3000",
	[17017] = "16980|V115|180000|6",
	[17018] = "16979|V115|80000|5",
	[17022] = "16982|V115|150000|5",
	[17023] = "16983|V115|160000|5",
	[17025] = "16984|V115|160000|6",
	[17049] = "16989|V115|90000|6",
	[17051] = "17014|V115|70000|5",
	[17052] = "17013|V115|180000|8",
	[17053] = "16988|V115|200000|7",
	[17059] = "17015|V115|220000|6",
	[17060] = "17016|V115|220000|8",
	[17062] = "8364|V67V112V175V179V168V200V203V91V113|2200",
	[17200] = "17197|V94V204V151V165V137|25",
	[17201] = "17198|V94V204V151V165V137|240",
	[17706] = "17704|D",
	[17709] = "17708|D",
	[17720] = "17716|D",
	[17722] = "17721|D",
	[17724] = "17723|Q",
	[17725] = "-21931|D",
	[18046] = "18045|V185V38|12000",
	[18160] = "7676|V172Q|200",
	[18239] = "18238|V159|3500",
	[18252] = "18251|D",
	[18257] = "18253|D",
	[18259] = "-22749|D",
	[18260] = "-22750|D",
	[18264] = "18262|D",
	[18265] = "18263|D",
	[18267] = "18254|D",
	[18290] = "18283|D",
	[18291] = "18168|D",
	[18292] = "18282|D",
	[18414] = "18405|D",
	[18415] = "18407|D",
	[18416] = "18408|D",
	[18417] = "18409|D",
	[18418] = "18413|D",
	[18487] = "18486|V170|40000",
	[18514] = "18504|D",
	[18515] = "18506|D",
	[18516] = "18508|D",
	[18517] = "18509|D",
	[18518] = "18510|D",
	[18519] = "18511|D",
	[18592] = "17193|Q",
	[18647] = "9318|V174|1800",
	[18648] = "9313|V29V48|1800",
	[18649] = "9312|V33V49|1800",
	[18650] = "18588|V16|5000",
	[18651] = "18631|V126|12000",
	[18652] = "18634|V209|12000",
	[18653] = "18587|D",
	[18654] = "18645|D",
	[18655] = "18637|D",
	[18656] = "18594|V209|16000",
	[18657] = "18638|D",
	[18658] = "18639|D",
	[18661] = "18660|D",
	[18731] = "18662|V18V178D|2000",
	[18949] = "18948|V164V83D|2000",
	[19027] = "19026|V218|5000",
	[19202] = "19043|V127|22000|6",
	[19203] = "19051|V9V10V155|22000|6",
	[19204] = "19048|V127|40000|7",
	[19205] = "19057|V9V10V155|40000|7",
	[19206] = "19148|V115|60000|7",
	[19207] = "19164|V115|80000|7",
	[19208] = "19166|V115|70000|7",
	[19209] = "19167|V115|70000|8",
	[19210] = "19170|V115|120000|8",
	[19211] = "19168|V115|120000|8",
	[19212] = "19169|V115|120000|8",
	[19215] = "19047|V127|22000|6",
	[19216] = "19056|V9V10V155|22000|6",
	[19217] = "19059|V9V10V155|40000|7",
	[19218] = "19050|V127|40000|7",
	[19219] = "19156|V115|60000|6",
	[19220] = "19165|V115|90000|7",
	[19326] = "19044|V127|22000|6",
	[19327] = "19049|V127|40000|7",
	[19328] = "19052|V9V10V155|22000|6",
	[19329] = "19058|V9V10V155|40000|7",
	[19330] = "19149|V115|60000|7",
	[19331] = "19157|V115|90000|7",
	[19332] = "19162|V115|90000|7",
	[19333] = "19163|V115|90000|7",
	[19442] = "19440|V9V10V155|100000|6D",
	[19444] = "-23799|V115|30000|7",
	[19445] = "-23800|V127|30000|6",
	[19446] = "-23801|V9V10V155|30000|6",
	[19447] = "-23802|V9V10V155|60000|7",
	[19448] = "-23803|V115|80000|6",
	[19449] = "-23804|V115|100000|7",
	[19764] = "19682|V160|50000|7",
	[19765] = "19683|V160|50000|6",
	[19766] = "19684|V160|50000|5",
	[19769] = "19685|V160|50000|7",
	[19770] = "19686|V160|50000|6",
	[19771] = "19687|V160|50000|5",
	[19772] = "19688|V160|50000|7",
	[19773] = "19689|V160|50000|6",
	[19776] = "19690|V160|50000|7",
	[19777] = "19691|V160|50000|6",
	[19778] = "19692|V160|50000|5",
	[19779] = "19693|V160|50000|7",
	[19780] = "19694|V160|50000|6",
	[19781] = "19695|V160|50000|5",
	[20000] = "19999|V160|50000|6",
	[20001] = "19998|V160|50000|5",
	[20011] = "20007|V160|50000|7",
	[20012] = "20002|V160|50000|5",
	[20013] = "20008|V160|50000|8",
	[20014] = "20004|V160|50000|6",
	[20040] = "20039|V115|80000|8",
	[20075] = "20074|V147|2000",
	[20253] = "15064|V127|16000|5",
	[20254] = "15065|V127|20000|5",
	[20382] = "20380|V2|60000|8",
	[20506] = "20481|V2|40000|5",
	[20507] = "20480|V2|40000|6",
	[20508] = "20479|V2|40000|7",
	[20509] = "20476|V2|40000|5",
	[20510] = "20477|V2|40000|6",
	[20511] = "20478|V2|40000|7",
	[20546] = "20538|Q",
	[20547] = "20537|Q",
	[20548] = "20539|Q",
	[20553] = "20549|Q",
	[20554] = "20550|Q",
	[20555] = "20551|Q",
	[20576] = "20575|V6D|350",
	[20726] = "-25072|D",
	[20727] = "-25073|D",
	[20728] = "-25074|D",
	[20729] = "-25078|D",
	[20730] = "-25079|D",
	[20731] = "-25080|D",
	[20732] = "-25081|V89|90000|5",
	[20733] = "-25082|V89|90000|6",
	[20734] = "-25083|D",
	[20735] = "-25084|D",
	[20736] = "-25086|D",
	[20752] = "-25125|V190V89V81V108V140V182V184V99V111|3000",
	[20753] = "-25126|V140V111V184V99V182V89V190V81V108|4000",
	[20754] = "-25127|V89|10000",
	[20755] = "-25128|V89|20000",
	[20756] = "-25129|V160|40000|6",
	[20757] = "-25130|V160|40000|5",
	[20758] = "-25124|V89V190V81V108V140V182V99V184V111|500",
	[20761] = "12|V115|120000|5",
	[21025] = "21023|Q",
	[21099] = "21072|V47V203V37V128V43V207V56V44V91V146V180V149V134V162|500",
	[21219] = "21217|V47V203V37V128V43V207V56V44V91V146V180V149V134V162|5000",
	[21302] = "20844|D",
	[21358] = "21340|V197|12000",
	[21371] = "21342|D",
	[21547] = "21546|D",
	[21548] = "21278|D",
	[21722] = "21154|Q",
	[21723] = "21542|Q",
	[21724] = "21558|D",
	[21725] = "21559|D",
	[21726] = "21557|D",
	[21727] = "21589|D",
	[21728] = "21590|D",
	[21729] = "21592|D",
	[21730] = "21571|D",
	[21731] = "21574|D",
	[21732] = "21576|D",
	[21733] = "21714|D",
	[21734] = "21716|D",
	[21735] = "21718|D",
	[21737] = "21570|Q",
	[21738] = "21569|Q",
	[22209] = "22197|V192|50000|5",
	[22214] = "22195|V192|50000|6",
	[22219] = "22198|V110|50000|7",
	[22220] = "22194|D",
	[22221] = "22191|V110|80000|7",
	[22222] = "22196|D",
	[22307] = "22246|V190V81V108V140V182V99V184V111V89|6000",
	[22308] = "22248|V89|20000",
	[22309] = "22249|D",
	[22310] = "22251|V130|20000|5",
	[22312] = "22252|V130|50000|7",
	[22388] = "22385|D",
	[22389] = "22383|D",
	[22390] = "22384|D",
	[22392] = "-27837|V127|25000|5",
	[22683] = "22660|V130|90000|7",
	[22766] = "22762|V192|50000|7",
	[22767] = "22763|V192|50000|6",
	[22768] = "22764|V192|50000|5",
	[22769] = "22761|V2|50000|5",
	[22770] = "22760|V2|50000|6",
	[22771] = "22759|V2|50000|7",
	[22772] = "22758|V130|50000|5",
	[22773] = "22757|V130|50000|6",
	[22774] = "22756|V130|50000|7",
-- Burning Crusade
	[12698] = "12625|D",
	[13517] = "13503|V255|80000|7",
	[15769] = "15138|D",
	[20854] = "20830|V133V31V282V283|1800",
	[20855] = "20833|V30V156|1500",
	[20856] = "20831|V285V286V282V283|1500",
	[20970] = "20950|V72V284|1500",
	[20971] = "20954|V24V128|1500",
	[20973] = "20958|V128V98|2000",
	[20974] = "20966|D",
	[20975] = "20959|V287V288V282V283|2500",
	[20976] = "20967|D",
	[21892] = "21842|V224V225V226|40000",
	[21893] = "21843|V225V228|40000",
	[21894] = "21844|V224V226V227V228|40000",
	[21895] = "21845|V231|40000",
	[21896] = "21854|V224V225V226|40000",
	[21897] = "21855|V224V225V226|40000",
	[21898] = "21859|V238V239|60000",
	[21899] = "21860|V238V239|60000",
	[21900] = "21861|V230|60000",
	[21901] = "21862|V230|60000",
	[21902] = "21863|V227V228|80000",
	[21903] = "21864|D",
	[21904] = "21865|D",
	[21905] = "21866|D",
	[21906] = "21867|D",
	[21907] = "21868|D",
	[21908] = "21846|V232|60000",
	[21909] = "21847|V232|60000",
	[21910] = "21848|V232|60000",
	[21911] = "21858|V232|60000",
	[21912] = "21869|V229|60000",
	[21913] = "21871|V229|60000",
	[21914] = "21870|V229|60000",
	[21915] = "21872|V229|60000",
	[21916] = "21873|V231|60000",
	[21917] = "21875|V231|60000",
	[21918] = "21874|V231|60000",
	[21919] = "21876|V231|60000",
	[21940] = "21756|D",
	[21941] = "21758|V68V13|5000",
	[21942] = "20969|V62V90|6000",
	[21943] = "21760|V142V68|6000",
	[21944] = "21763|D",
	[21945] = "21754|D",
	[21947] = "21753|D",
	[21948] = "21766|V287V289V282V283|7500",
	[21949] = "21769|D",
	[21952] = "21774|V130|10000",
	[21953] = "21777|D",
	[21954] = "21778|V77|10000",
	[21955] = "21784|D",
	[21956] = "21789|D",
	[21957] = "21792|V154|10000",
	[21992] = "21990|V265V264|20000",
	[21993] = "21991|V265V264|40000",
	[22530] = "-27906|D",
	[22532] = "-27913|D",
	[22533] = "-27914|D",
	[22534] = "-27917|D",
	[22535] = "-27920|D",
	[22536] = "-27924|V234|100000|6",
	[22537] = "-27926|V255|100000|7",
	[22538] = "-27927|V234|200000|6",
	[22539] = "-27945|V309|60000",
	[22540] = "-27946|D",
	[22541] = "-27947|D",
	[22542] = "-27948|D",
	[22543] = "-27950|D",
	[22544] = "-27951|D",
	[22545] = "-27954|D",
	[22548] = "-27962|D",
	[22551] = "-27968|D",
	[22553] = "-27972|D",
	[22554] = "-27971|D",
	[22555] = "-27975|D",
	[22556] = "-27977|D",
	[22557] = "-28004|D",
	[22558] = "-28003|D",
	[22559] = "-27984|D",
	[22560] = "-27981|D",
	[22561] = "-27982|D",
	[22562] = "22521|V311V312V310|50000",
	[22563] = "22522|V311V312V310|70000",
	[22565] = "22449|V311V312V310|60000",
	[22647] = "22645|V275V270|400",
	[22729] = "22728|D",
	[22900] = "22823|V261V258V262V253V263V259|30000",
	[22901] = "22826|V263V252|30000",
	[22902] = "22827|V250V251V252|40000",
	[22903] = "22828|D",
	[22904] = "22830|D",
	[22906] = "22871|V256|0|8",
	[22907] = "22832|V250V253V251|50000",
	[22908] = "22833|V236|60000|7",
	[22909] = "22834|V250V253V251|50000",
	[22910] = "22835|V234|80000|7",
	[22911] = "22836|D",
	[22912] = "22837|D",
	[22913] = "22838|D",
	[22914] = "22839|D",
	[22915] = "21884|V255|80000|7",
	[22916] = "21885|V256|0|7",
	[22918] = "22451|V237|80000|7",
	[22919] = "22840|D",
	[22920] = "22841|D",
	[22921] = "22842|D",
	[22922] = "22844|V237|100000|8",
	[22923] = "22845|D",
	[22924] = "22846|D",
	[22925] = "22847|D",
	[22926] = "22848|D",
	[22927] = "22849|D",
	[23130] = "23094|V291V292|40000",
	[23131] = "23095|V291V292|50000",
	[23133] = "23096|V236|60000|5",
	[23134] = "23097|V233|60000|6",
	[23135] = "23098|V291V292|40000",
	[23136] = "23099|V233|50000|5",
	[23137] = "23100|V291V292|60000",
	[23138] = "23101|V234|60000|5",
	[23140] = "23103|V291V292|40000",
	[23141] = "23104|V291V292|50000",
	[23143] = "23106|V236|60000|6",
	[23144] = "23108|V291V292|40000",
	[23145] = "23109|V235|50000|6",
	[23146] = "23110|V233|60000|5",
	[23147] = "23111|V291V292|60000",
	[23148] = "23113|V291V292|40000",
	[23149] = "23114|V235|50000|5",
	[23150] = "23115|V233|60000|6",
	[23151] = "23116|V291V292|60000",
	[23152] = "23118|V291V292|40000",
	[23153] = "23119|V291V292|50000",
	[23154] = "23120|D",
	[23155] = "23121|V233|60000|6",
	[23574] = "23571|V258V259V260|80000",
	[23590] = "23502|V243V244V245|40000",
	[23591] = "23503|V243V244V245|40000",
	[23592] = "23504|V243V244V245|40000",
	[23593] = "23505|V243V244V245|40000",
	[23594] = "23506|V241V242|60000",
	[23595] = "23508|V241V242|60000",
	[23596] = "23507|V241V242|60000",
	[23597] = "23510|V236|60000|5",
	[23598] = "23511|V236|60000|6",
	[23599] = "23509|V236|60000|7",
	[23600] = "23512|V236|80000|8",
	[23601] = "23515|V235|60000|5",
	[23602] = "23516|V235|60000|8",
	[23603] = "23514|V235|60000|6",
	[23604] = "23513|V235|80000|7",
	[23605] = "23517|D",
	[23606] = "23518|D",
	[23607] = "23519|D",
	[23608] = "23524|D",
	[23609] = "23523|D",
	[23610] = "23525|D",
	[23611] = "23520|D",
	[23612] = "23521|D",
	[23613] = "23522|D",
	[23615] = "23526|D",
	[23617] = "23527|D",
	[23618] = "23529|V237|60000|6",
	[23620] = "23531|D",
	[23621] = "23532|D",
	[23622] = "23533|D",
	[23623] = "23534|D",
	[23624] = "23535|D",
	[23625] = "23536|D",
	[23626] = "23537|D",
	[23627] = "23538|D",
	[23628] = "23539|D",
	[23629] = "23540|D",
	[23630] = "23541|D",
	[23631] = "23542|D",
	[23632] = "23543|D",
	[23633] = "23544|D",
	[23634] = "23546|D",
	[23635] = "23554|D",
	[23636] = "23555|D",
	[23637] = "23556|D",
	[23638] = "23575|V246V247|60000",
	[23639] = "23576|D",
	[23799] = "23746|V293V294V295|80000",
	[23800] = "23747|D",
	[23802] = "23748|D",
	[23803] = "23758|V299V297|60000",
	[23804] = "23761|D",
	[23805] = "23762|V300V299|80000",
	[23806] = "23763|D",
	[23807] = "23764|V296V297|60000",
	[23808] = "23765|D",
	[23809] = "23766|D",
	[23810] = "23767|D",
    [23883] = "33092|D",
    [23884] = "33093|D",
	[23811] = "23768|V300V293V298V295|60000",
	[23814] = "23771|V237|60000|5",
	[23815] = "23773|V293V298V295|60000",
	[23816] = "23774|V293V298V295|40000",
	[23887] = "23824|D",
	[23888] = "23821|D",
	[24158] = "24079|D",
	[24159] = "24080|D",
	[24160] = "24082|D",
	[24161] = "24085|D",
	[24162] = "24086|D",
	[24163] = "24087|D",
	[24164] = "24088|D",
	[24165] = "24089|D",
	[24166] = "24106|D",
	[24167] = "24110|D",
	[24168] = "24114|D",
	[24169] = "24116|D",
	[24170] = "24117|D",
	[24171] = "24121|D",
	[24172] = "24122|D",
	[24173] = "24123|D",
	[24174] = "24092|V254|120000|7",
	[24175] = "24093|V234|120000|7",
	[24176] = "24095|V236|120000|7",
	[24177] = "24097|V235|120000|7",
	[24178] = "24098|V233|120000|7",
	[24179] = "24124|V234|120000|7",
	[24181] = "24126|V254|120000|7",
	[24182] = "24127|V255|120000|7",
	[24183] = "24128|V237|120000|7",
	[24192] = "24031|D",
	[24193] = "24027|D",
	[24194] = "24028|D",
	[24195] = "24029|D",
	[24196] = "24030|D",
	[24197] = "24032|D",
	[24198] = "24036|D",
	[24199] = "24033|D",
	[24200] = "24035|D",
	[24201] = "24037|D",
	[24202] = "24039|D",
	[24203] = "24047|D",
	[24204] = "24048|D",
	[24205] = "24051|D",
	[24206] = "24050|D",
	[24207] = "24052|D",
	[24209] = "24054|D",
	[24210] = "24055|D",
	[24211] = "24056|D",
	[24212] = "24057|D",
	[24213] = "24058|D",
	[24214] = "24059|D",
	[24215] = "24060|D",
	[24216] = "24061|D",
	[24217] = "24062|D",
	[24218] = "24066|D",
	[24219] = "24065|D",
	[24220] = "24067|D",
	[24292] = "24273|V236|60000|6",
	[24293] = "24275|V235|60000|6",
	[24294] = "24274|V236|360000|8",
	[24295] = "24276|V235|360000|8",
	[24296] = "24249|D",
	[24297] = "24250|D",
	[24298] = "24251|D",
	[24299] = "24252|D",
	[24300] = "24253|D",
	[24301] = "24254|D",
	[24302] = "24255|D",
	[24303] = "24256|D",
	[24304] = "24257|D",
	[24305] = "24258|D",
	[24306] = "24259|D",
	[24307] = "24260|D",
	[24308] = "24261|D",
	[24309] = "24262|D",
	[24310] = "24263|D",
	[24311] = "24264|D",
	[24312] = "24266|D",
	[24313] = "24267|D",
	[24314] = "24270|V233|40000|6",
	[24315] = "24269|V237|30000|5",
	[24316] = "24271|V232|40000",
	[25526] = "25521|V237|60000|6",
	[25720] = "23793|V304V302V303|50000",
	[25721] = "25651|V235|50000|7",
	[25722] = "25652|V236|50000|7",
	[25725] = "25653|V305|50000",
	[25726] = "25679|V302V303|10000",
	[25728] = "25680|D",
	[25729] = "25681|D",
	[25730] = "25682|D",
	[25731] = "25683|D",
	[25732] = "25685|V233|120000|5",
	[25733] = "25686|V233|140000|6",
	[25734] = "25687|V233|140000|7",
	[25735] = "25689|V237|160000|6",
	[25736] = "25690|V237|140000|6",
	[25737] = "25691|V237|140000|5",
	[25846] = "25844|V243|40000",
	[25847] = "25845|V246V247|120000",
	[25848] = "22462|V307V277|100000",
	[25849] = "22463|V310|120000",
	[25869] = "25867|V237|80000|6",
	[25887] = "25886|D",
	[25902] = "25896|D",
	[25903] = "25897|D",
	[25904] = "25901|V255|120000|5",
	[25905] = "25898|D",
	[25906] = "25899|D",
	[25907] = "25890|D",
	[25908] = "25894|V233|120000|6",
	[25909] = "25893|D",
	[25910] = "25895|V254|120000|6",
	[27684] = "27651|D",
	[27685] = "27635|V269|40",
	[27686] = "24105|D",
	[27687] = "27636|V270|400",
	[27688] = "27655|V280V281|20000",
	[27689] = "27656|V256|20000",
	[27690] = "27657|V271V272|30000",
	[27691] = "27658|V278V279|30000",
	[27692] = "27659|V271V278V272V279|30000",
	[27693] = "27660|D",
	[27694] = "27661|V273V274|20000",
	[27695] = "27662|V273V239|20000",
	[27696] = "27663|D",
	[27697] = "27664|V278V279|30000",
	[27698] = "27665|V278V279|30000",
	[27699] = "27666|V276V277|30000",
	[27700] = "27667|V276V277|30000",
	[28270] = "-33992|D",
	[28271] = "-33994|V237|80000|7",
	[28272] = "-33997|V254|80000|6",
	[28273] = "-33999|V255|60000|6",
	[28274] = "-34003|V233|40000|5",
	[28276] = "-34005|D",
	[28277] = "-34006|D",
	[28279] = "-34007|D",
	[28280] = "-34008|D",
	[28281] = "-34010|V255|60000|7",
	[28282] = "-34009|V310|40000",
	[28291] = "28290|V291V292|60000",
	[28596] = "28595|V291V292|50000",
	[28632] = "28421|V237|60000|6",
	[29669] = "29483|D",
	[29672] = "29485|D",
	[29673] = "29486|D",
	[29674] = "29487|D",
	[29675] = "29488|D",
	[29677] = "29489|V236|80000|8",
	[29682] = "29490|V236|80000|6",
	[29684] = "29491|V236|80000|7",
	[29689] = "29492|V235|80000|8",
	[29691] = "29493|V235|80000|7",
	[29693] = "29494|V235|80000|6",
	[29698] = "29495|V236|80000|8",
	[29700] = "29496|V236|80000|7",
	[29701] = "29497|V236|80000|6",
	[29702] = "29498|V235|80000|8",
	[29703] = "29499|V235|80000|7",
	[29704] = "29500|V235|80000|6",
	[29713] = "29532|V254|120000|6",
	[29714] = "29531|DV257V301|120000|6",
    [34174] = "29531|DV257V301|120000|6",
    [34175] = "29531|DV257V301|120000|6",
	[29717] = "29529|V255|120000|6",
	[29718] = "29530|V257V301D|120000|6",
    [34172] = "29530|V257V301D|120000|6",
    [34173] = "29530|V257V301D|120000|6",
	[29720] = "29534|V237|60000|6",
	[29721] = "29536|V237|120000|8",
	[29723] = "29502|D",
	[29724] = "29503|D",
	[29725] = "29504|D",
	[29726] = "29505|D",
	[29727] = "29506|D",
	[29728] = "29507|D",
	[29729] = "29508|D",
	[29730] = "29512|D",
	[29731] = "29509|D",
	[29732] = "29510|D",
	[29733] = "29511|D",
	[29734] = "29514|D",
	[30156] = "30155|V256V268|0",
	[30483] = "24272|V229|40000",
	[30826] = "30825|V255|120000|6",
	[30833] = "30831|V234|60000|6",
	[30842] = "30837|V235|60000|5",
	[30843] = "30838|V235|80000|6",
	[30844] = "30839|V235|100000|8",
	[31390] = "31364|V237|240000|8",
	[31391] = "31367|V237|240000|7",
	[31392] = "31368|V237|240000|7",
	[31393] = "31369|V240|240000|6",
	[31394] = "31370|V240|240000|7",
	[31395] = "31371|V240|240000|6",
	[31401] = "31398|V290|120000|6",
	[31402] = "31399|V237|120000|8",
	[31674] = "31673|D",
	[31675] = "31672|D",
	[31680] = "31679|D",
	[31681] = "31676|D",
	[31682] = "31677|D",
-- Honor Hold / Thrallmar
	[22531] = "-27911|V248V249|60000|5",
	[24000] = "-27911|V248V249|60000|5",
	[23142] = "23105|V248V249|60000|5",
	[31359] = "23105|V248V249|60000|5",
	[25738] = "25695|V248V249|120000|5",
	[29213] = "25695|V248V249|120000|5",
	[22905] = "22831|V248V249|50000|6",
	[24001] = "22831|V248V249|50000|6",
	[25739] = "25697|V248V249|160000|6",
	[29214] = "25697|V248V249|160000|6",
	[25740] = "25696|V248V249|160000|6",
	[29215] = "25696|V248V249|160000|6",
	[25870] = "25868|V248V249|80000|6",
	[29232] = "25868|V248V249|80000|6",
	[29719] = "29533|V248V249|60000|6",
	[31361] = "29533|V248V249|60000|6",
	[22547] = "-27960|V248V249|60000|7",
	[24003] = "-27960|V248V249|60000|7",
	[24180] = "24125|V248V249|120000|7",
	[31358] = "24125|V248V249|120000|7",
	[23619] = "23530|V248V249|60000|8",
	[24002] = "23530|V248V249|60000|8",
	[29722] = "29535|V248V249|120000|8",
	[31362] = "29535|V248V249|120000|8",
-- Kurenai / The Mag'har
	[25741] = "25694|V257V301|120000|5",
	[29217] = "25694|V257V301|120000|5",
	[25742] = "25692|V257V301|120000|6",
	[29219] = "25692|V257V301|120000|6",
	[29664] = "29540|V257V301|50000|6",
	[30444] = "29540|V257V301|50000|6",
	[25743] = "25693|V257V301|120000|7",
	[29218] = "25693|V257V301|120000|7",
	[22917] = "22452|V257V301|80000|7",
	[30443] = "22452|V257V301|80000|7",
-- New source of recipes for flasks
	[13519] = "13510|DV255|40000|8",
	[13520] = "13511|DV237|40000|8",
	[13521] = "13512|DV254|40000|8",
	[13522] = "13513|DV234|40000|8",
	[31354] = "13510|V255|40000|8",
	[31356] = "13511|V237|40000|8",
	[31355] = "13512|V254|40000|8",
	[31357] = "13513|V234|40000|8",
--New
    [7929] = "9957|Qh",
    [32429] = "32393|V313|80000|6",
    [32430] = "32399|V313|80000|6",
    [32431] = "32400|V313|80000|7",
    [32432] = "32397|V313|80000|7",
    [32436] = "32393|V313|80000|6",
    [32435] = "32396|V313|80000|6",
    [32433] = "32394|V313|80000|7",
    [32434] = "32395|V313|80000|7",
    [32447] = "32420|V313|80000|7",
    [32438] = "32392|V313|80000|6",
    [32440] = "32390|V313|80000|6",
    [32439] = "32389|V313|80000|7",
    [32437] = "32391|V313|80000|7",
    [32442] = "32403|V313|80000|6",
    [32444] = "32401|V313|80000|6",
    [32443] = "32404|V313|80000|7",
    [32441] = "32402|V313|80000|7",
    [33205] = "33204|V290|240000|8",
    [33124] = "33122|V290|50000|7",
    [33165] = "-42620|V290|30000|8",
    [33209] = "33208|V290|40000|6",
    [32299] = "32213|V314|60000|6",
    [32274] = "32193|V314|60000|5",
    [32283] = "32197|V314|60000|5",
    [32290] = "32204|V314|60000|5",
    [32311] = "32225|V314|60000|6",
    [32277] = "32194|V314|60000|5",
    [32309] = "32249|V314|60000|7",
    [32293] = "32207|V314|60000|5",
    [32306] = "32220|V314|60000|6",
    [32301] = "32215|V314|60000|6",
    [32300] = "32214|V314|60000|6",
    [32312] = "32226|V314|60000|6",
    [32305] = "32219|V314|60000|6",
    [32288] = "32202|V314|60000|5",
    [32304] = "32218|V314|60000|6",
    [32310] = "32224|V314|60000|6",
    [32292] = "32206|V314|60000|7",
    [32302] = "32216|V314|60000|7",
    [32282] = "32196|V314|60000|5",
    [32291] = "32205|V314|60000|5",
    [32286] = "32200|V314|60000|5",
    [32287] = "32201|V314|60000|5",
    [32284] = "32198|V314|60000|5",
    [32281] = "32195|V314|60000|5",
    [32294] = "32208|V314|60000|5",
    [32308] = "32222|V314|60000|7",
    [33159] = "33140|V255|120000|7",
    [33156] = "33131|V233|120000|7",
    [33305] = "33133|V233|120000|7",
    [33160] = "33144|V254|120000|6",
    [33157] = "33135|V234|120000|7",
    [33155] = "33134|V255|120000|6",
    [33158] = "33143|V254|120000|7",
    [32381] = "7191|V209V294|16000", --Fused Wiring
    [30280] = "30038|D",
    [30281] = "30036|D",
    [30282] = "30037|D",
    [32755] = "32587|D",
    [32754] = "32586|D",
    [30302] = "30040|D",
    [30301] = "30042|D",
    [30303] = "30046|D",
    [30305] = "30041|D",
    [30307] = "30045|D",
    [30308] = "30043|D",
    [30304] = "30044|D",
    [32748] = "32574|D",
    [32751] = "32579|D",
    [32745] = "32583|D",
    [32746] = "32580|D",
    [32744] = "32582|D",
    [32750] = "32577|D",
    [32745] = "32583|D",
    [32749] = "32575|D",
    [32747] = "32581|D",
    [30306] = "30039|D",
    [30321] = "30034|D",
    [30323] = "30033|D",
    [30322] = "30032|D",
    [30324] = "30031|D",
    [32739] = "32573|D",
    [32736] = "32568|D",
    [32738] = "32571|D",
    [32737] = "32570|D",
    [33174] = "33173|D",
    [33783] = '33782|D', --Steady Talasite
    [34221] = "34220|D",
    [33869] = "33867|Q",
    [33952] = "33924|Q",
    [34413] = "34411|Q",
    [33875] = "33874|Q",
    [33870] = "33825|Q",
    [33873] = "33872|Q",
    [33871] = "33866|Q",
    [34114] = "34113|D",
    [33804] = "20475|D",
    [33307] = "-42974|D",
    [33954] = "32854|D",
    [33186] = "33185|D",
    [33792] = "33185|D",
    [34200] = "34105|V234|400000|7",
    [34201] = "34106|V248V249|400000|7",
    [34218] = "34106|V248V249|400000|7",
    [34491] = "34490|D",
    [34626] = "34086|D",
    [34261] = "34807|Qh",
    [34319] = "34805|Qa",
    [30283] = "30035|D",
    [32753] = "32585|D",
    [32752] = "32584|D",
    [32411] = "32410|D",
    [32412] = "32409|V233|12000|8",
    [33622] = "32409|V233|12000|8",
    [31876] = "31863|D",
    [24192] = "24031|D",
    [24193] = "24027|D",
    [31875] = "31861|D",
    [31874] = "31869|D",
    [31877] = "31865|D",
    [24208] = "24053|D",
    [31878] = "31867|D",
    [31879] = "31868|D",
    [31871] = "31862|D",
    [31870] = "31860|D",
    [31872] = "31864|D",
    [31873] = "31866|D",
    [32307] = "32211|D",
    [32303] = "32217|D",
    [32298] = "32212|D",
    [32297] = "32221|D",
    [32296] = "32210|D",
    [32289] = "32203|D",
    [32285] = "32197|D",
    [99999] = "7929|Qh",
    [35202] = "34360|D",
    [35533] = "34360|D",
    [35200] = "34361|D",
    [35203] = "34358|D",
    [35535] = "34358|D",
    [35238] = "32213|V316|500000|6",
    [35244] = "32193|V316|500000|5",
    [35245] = "32197|V316|500000|5",
    [35255] = "32204|V316|500000|5",
    [35251] = "32225|V316|500000|6",
    [35246] = "32194|V316|500000|5",
    [35252] = "32223|V316|500000|7",
    [35247] = "32199|V316|500000|8",
    [35765] = "35759|V314|15000|6",
    [35769] = "35759|V315|500000|7",
    [35256] = "32207|V316|500000|5",
    [35266] = "32220|V316|500000|6",
    [35239] = "32215|V316|500000|6",
    [35257] = "32210|V316|500000|8",
    [35240] = "32214|V316|500000|6",
    [35267] = "32217|V316|500000|8",
    [35253] = "32226|V316|500000|6",
    [35268] = "32219|V316|500000|6",
    [35262] = "32202|V316|500000|5",
    [35258] = "32209|V316|500000|8",
    [35269] = "32218|V316|500000|6",
    [35763] = "35761|V314|15000|6",
    [35768] = "35761|V315|500000|7",
    [35254] = "32224|V316|500000|6",
    [35762] = "35760|V314|15000|6",
    [35767] = "35760|V315|500000|7",
    [35259] = "32206|V316|500000|7",
    [35241] = "32216|V316|500000|7",
    [35248] = "32196|V316|500000|5",
    [35242] = "32212|V316|500000|8",
    [35260] = "32205|V316|500000|5",
    [35263] = "32200|V316|500000|5",
    [35243] = "32211|V316|500000|8",
    [35264] = "32201|V316|500000|5",
    [35764] = "35758|V314|15000|6",
    [35766] = "35758|V315|500000|7",
    [35265] = "32203|V316|500000|8",
    [35249] = "32198|V316|500000|5",
    [35250] = "32195|V316|500000|5",
    [35261] = "32208|V316|500000|5",
    [35270] = "32221|V316|500000|8",
    [35271] = "32222|V316|500000|7",
    [35201] = "34359|D",
    [35198] = "34362|D",
    [35199] = "34363|D",
    [35538] = "34363|D",
    [35218] = "34369|D",
    [35539] = "34369|D",
    [35217] = "34373|D",
    [35213] = "34374|D",
    [35541] = "34374|D",
    [35214] = "34370|D",
    [35205] = "34367|D",
    [35544] = "34367|D",
    [35216] = "34371|D",
    [35545] = "34371|D",
    [35212] = "34372|D",
    [35546] = "34372|D",
    [35207] = "34365|D",
    [35548] = "34365|D",
    [35219] = "34375|D",
    [35215] = "34376|D",
    [35550] = "34376|D",
    [35204] = "34366|D",
    [35551] = "34366|D",
    [35206] = "34364|D",
    [35209] = "34378|D",
    [35553] = "34378|D",
    [35211] = "34377|D",
    [35210] = "34379|D",
    [35208] = "34380|D",
    [35186] = "34847|D",
    [35187] = "35185|D",
    [35189] = "35181|D",
    [35190] = "35182|D",
    [35191] = "35183|D",
    [35192] = "35184|D",
    [35193] = "34355|D",
    [35194] = "34356|D",
    [35195] = "34354|D",
    [35196] = "34357|D",
    [35197] = "34353|D",
    [34834] = "34832|Q",
    [35505] = "35503|V316|150000|7",
    [35502] = "35501|V316|150000|7",
    [34872] = "-45765|V316|150000|7",
    [35564] = "35563|V12V120|12000",
    [35566] = "35565|V12V120|12000",
    [35273] = "35128|D",
    [35708] = "35707|V316|150000|7",
    [35582] = "35581|D",
    [35550] = "-46594|V316|150000|7",
    [35755] = "35751|V316|250000|8",
    [35752] = "35748|V316|250000|8",
    [35754] = "35750|V316|250000|8",
    [35753] = "35749|V316|250000|8",
    [35697] = "35700|V316|250000|7",
    [35695] = "35693|V316|250000|7",
    [35696] = "35694|V316|250000|7",
    [35699] = "35703|V316|250000|7",
    [35698] = "35702|V316|250000|7",
    [35517] = "32574|D",
    [35518] = "32586|D",
    [35519] = "32582|D",
    [35302] = "29503|D",
    [35303] = "29506|D",
    [35520] = "32577|D",
    [35521] = "32579|D",
    [35522] = "32587|D",
    [35301] = "29511|D",
    [35523] = "32583|D",
    [35524] = "32575|D",
    [35525] = "32585|D",
    [35526] = "32584|D",
    [35527] = "32580|D",
    [35528] = "32581|D",
    [35309] = "24255|D",
    [35300] = "29509|D",
    [35531] = "32568|D",
    [35532] = "32570|D",
    [35306] = "24031|D",
    [35307] = "24051|D",
    [35305] = "24030|D",
    [35304] = "24033|D",
    [35297] = "-34008|D",
    [35299] = "-34007|D",
    [35756] = "-47051|D",
    [35308] = "24249|D",
    [35310] = "33092|D",
    [35311] = "33093|D",
    [35298] = "-27948|D",
    [35296] = "33185|D",
    [35294] = "22848|D",
    [35295] = "22838|D",
}

TradeskillInfo.vars.enchantID = {
--[id]="enchantid"
[2853]="2663",
[2852]="2662",
[10421]="12260",
[2862]="2660",
[3239]="3115",
[2844]="2737",
[2845]="2738",
[3469]="3319",
[2847]="2739",
[3470]="3320",
[7955]="9983",
[7166]="8880",
[3488]="3293",
[3471]="3321",
[2851]="2661",
[3472]="3323",
[3473]="3324",
[3474]="3325",
[2863]="2665",
[3240]="3116",
[6214]="7408",
[3489]="3294",
[2857]="2666",
[3478]="3326",
[2864]="2667",
[2854]="2664",
[3487]="3292",
[6350]="7817",
[6731]="8367",
[15869]="19666",
[29201]="34979",
[6338]="7818",
[3848]="3491",
[2865]="2668",
[2866]="2670",
[2848]="2740",
[3480]="3328",
[2849]="2741",
[2868]="2672",
[2850]="2742",
[3490]="3295",
[3481]="3330",
[7956]="9985",
[3486]="3337",
[2871]="2674",
[3241]="3117",
[3491]="3296",
[3482]="3331",
[2869]="2673",
[7957]="9986",
[3483]="3333",
[7958]="9987",
[5541]="6518",
[2870]="2675",
[3484]="3334",
[3492]="3297",
[15870]="19667",
[3485]="3336",
[3851]="3494",
[11128]="14379",
[7071]="8768",
[6042]="7221",
[7914]="9813",
[3842]="3506",
[3849]="3492",
[10423]="12259",
[7913]="9811",
[3840]="3504",
[3835]="3501",
[6043]="7222",
[3852]="3495",
[3843]="3507",
[3836]="3502",
[7915]="9814",
[3841]="3505",
[3850]="3493",
[3853]="3496",
[3844]="3508",
[7916]="9818",
[12259]="15972",
[3855]="3498",
[7917]="9820",
[3846]="3513",
[6040]="7223",
[17704]="21913",
[3837]="3503",
[12260]="15973",
[6041]="7224",
[3845]="3511",
[3854]="3497",
[3847]="3515",
[3856]="3500",
[7963]="9916",
[15871]="19668",
[29202]="34981",
[9060]="11454",
[7966]="9920",
[7964]="9918",
[7965]="9921",
[11144]="14380",
[9366]="11643",
[7919]="9928",
[7918]="9926",
[7941]="9993",
[7921]="9933",
[7920]="9931",
[7924]="9937",
[7967]="9939",
[7922]="9935",
[7942]="9995",
[7927]="9950",
[7926]="9945",
[7938]="9954",
[7928]="9952",
[7943]="9997",
[7945]="10001",
[7930]="9959",
[7931]="9961",
[7954]="10003",
[7933]="9968",
[7932]="9966",
[7969]="9964",
[7944]="10005",
[7961]="10007",
[7939]="9974",
[7934]="9970",
[7946]="10009",
[7959]="10011",
[12405]="16642",
[12406]="16643",
[12644]="16639",
[12404]="16641",
[12643]="16640",
[7947]="10013",
[12408]="16644",
[30069]="36122",
[30071]="36125",
[30073]="36128",
[30072]="36126",
[7960]="10015",
[30070]="36124",
[11606]="15293",
[12416]="16645",
[11608]="15292",
[12424]="16647",
[12428]="16646",
[12624]="16650",
[11605]="15295",
[12425]="16649",
[12415]="16648",
[11607]="15294",
[15872]="19669",
[12773]="16969",
[12645]="16651",
[16206]="20201",
[12777]="16978",
[12776]="16973",
[12775]="16971",
[12409]="16652",
[12410]="16653",
[11604]="15296",
[12628]="16667",
[12781]="16983",
[12418]="16654",
[12782]="16985",
[12631]="16655",
[19051]="23632",
[19043]="23628",
[12419]="16656",
[12792]="16984",
[17014]="20874",
[16989]="20872",
[17193]="21161",
[12632]="16661",
[12426]="16657",
[12427]="16658",
[12417]="16659",
[19166]="23638",
[22194]="27589",
[19167]="23639",
[19168]="23652",
[20039]="24399",
[19164]="23637",
[19148]="23636",
[17013]="20876",
[19170]="23650",
[16988]="20873",
[22671]="28244",
[22669]="28242",
[22670]="28243",
[12641]="16746",
[22198]="27586",
[12640]="16729",
[19169]="23653",
[22191]="27590",
[22384]="27830",
[22383]="27832",
[12639]="16741",
[22196]="27587",
[22385]="27829",
[12798]="16991",
[12790]="16990",
[12784]="16994",
[19690]="24136",
[19692]="24138",
[19691]="24137",
[17016]="20897",
[17015]="20890",
[20550]="24914",
[20549]="24912",
[20551]="24913",
[19693]="24139",
[19694]="24140",
[19695]="24141",
[12618]="16745",
[12620]="16742",
[12619]="16744",
[12797]="16992",
[19057]="23633",
[12796]="16988",
[12783]="16995",
[22197]="27585",
[19048]="23629",
[12636]="16728",
[22764]="28463",
[22762]="28461",
[22763]="28462",
[22195]="27588",
[12794]="16993",
[12633]="16724",
[18262]="22757",
[29203]="34982",
[23493]="29551",
[23482]="29545",
[12422]="16663",
[12429]="16730",
[12420]="16725",
[12613]="16731",
[12611]="16665",
[12612]="16726",
[12614]="16732",
[12610]="16664",
[12414]="16662",
[25843]="32655",
[23528]="29654",
[28420]="34607",
[23484]="29547",
[23491]="29552",
[23497]="29557",
[23494]="29553",
[23498]="29558",
[23487]="29548",
[23488]="29549",
[23490]="29556",
[23499]="29565",
[23502]="29566",
[23489]="29550",
[23559]="32284",
[30093]="36137",
[30074]="36129",
[30089]="36136",
[30088]="36135",
[30086]="36133",
[30087]="36134",
[30076]="36130",
[30077]="36131",
[23503]="29568",
[23504]="29569",
[23506]="29603",
[23508]="29605",
[23505]="29571",
[23507]="29606",
[23575]="29728",
[28483]="34533",
[28437]="34545",
[28425]="34535",
[28428]="34538",
[28434]="34543",
[23563]="34529",
[28431]="34541",
[28440]="34547",
[29204]="34983",
[23515]="29614",
[23529]="29656",
[28421]="34608",
[25844]="32656",
[25521]="32285",
[23510]="29608",
[23511]="29611",
[23516]="29615",
[23509]="29610",
[23517]="29619",
[23518]="29620",
[23514]="29616",
[23524]="29628",
[23523]="29629",
[23530]="29657",
[23537]="29669",
[23539]="29672",
[23538]="29671",
[23555]="29699",
[23554]="29698",
[23542]="29694",
[23546]="29697",
[23531]="29658",
[23540]="29692",
[23543]="29695",
[23532]="29622",
[23556]="29700",
[23535]="29664",
[23541]="29693",
[23544]="29696",
[23533]="29662",
[23534]="29663",
[23512]="29613",
[23519]="29621",
[23513]="29617",
[23525]="29630",
[23520]="29642",
[23521]="29643",
[23527]="29649",
[23522]="29645",
[23526]="29648",
[30034]="36389",
[28432]="34542",
[28427]="36258",
[28426]="34537",
[28436]="36261",
[30033]="36391",
[28484]="34534",
[28485]="36257",
[32571]="41134",
[32573]="41135",
[28441]="34548",
[28438]="34546",
[28439]="36262",
[23565]="36256",
[31369]="38477",
[31371]="38479",
[31370]="38478",
[28429]="34540",
[28430]="36259",
[28435]="34544",
[30032]="36390",
[30031]="36392",
[32403]="40034",
[32401]="40036",
[32404]="40035",
[32402]="40033",
[28442]="36263",
[32568]="41132",
[32570]="41133",
[23564]="34530",
[28433]="36260",
[31364]="38473",
[31368]="38476",
[31367]="38475",
[25845]="32657",
[23576]="29729",
[7929]="9957",
[7936]="9979",
[7935]="9972",
[7937]="9980",
[5997]="7183",
[118]="2330",
[2455]="2331",
[2456]="2332",
[4596]="4508",
[2457]="3230",
[2458]="2334",
[858]="2337",
[5631]="6617",
[2459]="2335",
[6370]="7836",
[6662]="8240",
[5996]="7179",
[3383]="3171",
[6051]="7255",
[6372]="7841",
[929]="3447",
[3384]="3172",
[3385]="3173",
[3386]="3174",
[3389]="3177",
[6371]="7837",
[6048]="7256",
[6373]="7845",
[3390]="2333",
[5634]="6624",
[1710]="7181",
[3827]="3452",
[6049]="7257",
[3823]="3448",
[3824]="3449",
[3825]="3450",
[5633]="6618",
[8949]="11449",
[17708]="21923",
[6050]="7258",
[6052]="7259",
[3828]="3453",
[8951]="11450",
[9061]="11456",
[10592]="12609",
[3829]="3454",
[6149]="11448",
[8956]="11451",
[9036]="11453",
[18294]="22808",
[4623]="4942",
[3928]="11457",
[9144]="11458",
[11552]="11452", -- Restorative Potion, Added 8/7/2007
[12190]="15833",
[9154]="11460",
[9210]="11473",
[9155]="11461",
[9179]="11465",
[9264]="11476",
[9172]="11464",
[9197]="11468",
[9187]="11467",
[9088]="11466",
[9206]="11472",
[9224]="11477",
[9233]="11478",
[21546]="26277",
[3387]="3175",
[13423]="17551",
[13442]="17552",
[13443]="17553",
[13445]="17554",
[13447]="17555",
[13453]="17557",
[20002]="24366",
[20007]="24365",
[13446]="17556",
[13452]="17571",
[13455]="17570",
[13454]="17573",
[20008]="24367",
[13462]="17572",
[9030]="11452",
[13461]="17577",
[13457]="17574",
[13456]="17575",
[13458]="17576",
[13459]="17578",
[13444]="17580",
[19931]="24266",
[13513]="17638",
[13511]="17636",
[13506]="17634",
[13512]="17637",
[13510]="17635",
[18253]="22732",
[28102]="33738",
[28100]="33732",
[22823]="28543",
[22824]="28544",
[22825]="28545",
[32062]="39636",
[28101]="33733",
[28104]="33741",
[22826]="28546",
[32063]="39637",
[32067]="39638",
[22827]="28549",
[22828]="28550",
[31080]="38070",
[22830]="28552",
[22829]="28551",
[32068]="39639",
[22831]="28553",
[31679]="38960",
[22871]="28554",
[22832]="28555",
[22834]="28557",
[22833]="28556",
[31676]="38962",
[22839]="28565",
[22835]="28558",
[22838]="28564",
[22837]="28563",
[22836]="28562",
[22840]="28570",
[31677]="38961",
[22861]="28590",
[22851]="28587",
[22853]="28588",
[22866]="28591",
[22854]="28589",
[22845]="28575",
[22841]="28571",
[22842]="28572",
[22847]="28577",
[22844]="28573",
[22846]="28576",
[22850]="28586",
[22848]="28578",
[22849]="28579",
[32839]="41458",
[32849]="41500",
[32850]="41501",
[32851]="41502",
[32852]="41503",
[6218]="7421",
[11287]="14293",
[20744]="-25124",
[11288]="-14807",
[6339]="7795",
[20745]="-25125",
[11130]="13628",
[11289]="14809",
[11290]="14810",
[20746]="-25126",
[11145]="13702",
[12810]="17181",
[12655]="-17180",
[20747]="25127",
[11811]="15596",
[20750]="25128",
[16207]="20051",
[20748]="-25130",
[20749]="-25129",
[22461]="32664",
[22521]="28016",
[22460]="28027",
[22449]="28022",
[22522]="28019",
[22459]="28028",
[22462]="32665",
[22463]="32667",
[22448]="42615",
[8067]="3920",
[4357]="3918",
[4358]="3919",
[4359]="3922",
[4360]="3923",
[4362]="3925",
[6219]="7430",
[4361]="3924",
[4405]="3977",
[4363]="3926",
[4364]="3929",
[8068]="3930",
[4401]="3928",
[4366]="3932",
[4404]="3973",
[4368]="3934",
[6712]="8334",
[4367]="3933",
[4369]="3936",
[4371]="3938",
[4406]="3978",
[4372]="3939",
[4373]="3940",
[7506]="9269",
[8069]="3947",
[4376]="3944",
[4377]="3945",
[21558]="26416",
[21559]="26417",
[21557]="26418",
[4375]="3942",
[5507]="6458",
[4381]="3952",
[4383]="3954",
[4382]="3953",
[4385]="3956",
[6533]="9271",
[9312]="23067",
[4384]="3955",
[10558]="12584",
[9313]="23068",
[9318]="23066",
[4386]="3957",
[4388]="3959",
[4387]="3958",
[7148]="9273",
[4403]="3960",
[4389]="3961",
[4391]="3963",
[21589]="26420",
[21590]="26421",
[21592]="26422",
[10505]="12585",
[10507]="12586",
[4407]="3979",
[4392]="3965",
[4852]="8243",
[4394]="3967",
[17716]="21940",
[4395]="3968",
[10559]="12589",
[4397]="3971",
[4398]="3972",
[4396]="3969",
[11590]="15255",
[10560]="12591",
[10500]="12594",
[10543]="12718",
[10542]="12717",
[10508]="12595",
[10716]="12899",
[10577]="12716",
[10646]="12760",
[11825]="15628",
[10545]="12897",
[10546]="12597",
[10721]="12903",
[10561]="12599",
[10514]="12603",
[10501]="12607",
[10724]="12905",
[7189]="8895",
[10518]="12616",
[10502]="12615",
[21571]="26423",
[21569]="26442",
[21574]="26424",
[21576]="26425",
[10506]="12617",
[10503]="12618",
[10725]="12906",
[10587]="12755",
[10726]="12907",
[10586]="12754",
[10645]="12759",
[10727]="12908",
[10548]="12620",
[10504]="12622",
[10588]="12758",
[15992]="19788",
[18641]="23070",
[10576]="12624",
[15846]="19567",
[19026]="23507",
[21277]="26011",
[18634]="23077",
[15995]="19792",
[18660]="23129",
[15993]="19790",
[15994]="19791",
[18631]="23071",
[18587]="23078",
[15996]="19793",
[15999]="19794",
[16004]="19796",
[18637]="23079",
[21570]="26443",
[7191]="39895",
[21714]="26426",
[21716]="26427",
[21718]="26428",
[16023]="19814",
[18594]="23080",
[16000]="19795",
[15997]="19800",
[16005]="19799",
[16006]="19815",
[16009]="19819",
[18282]="22795",
[18168]="22797",
[16022]="19830",
[18283]="22793",
[19999]="24356",
[19998]="24357",
[16007]="19833",
[16040]="19831",
[23781]="30303",
[23736]="30310",
[23782]="30304",
[18232]="22704",
[23783]="30305",
[23821]="30548",
[23772]="30346",
[23772]="30346",
[23742]="30312",
[23774]="30348",
[23784]="30306",
[23737]="30311",
[23841]="30568",
[23826]="30558",
[23773]="30347",
[23764]="30329",
[23771]="30344",
[32423]="39971",
[25886]="32814",
[23768]="30341",
[23758]="30316",
[23835]="30569",
[23761]="30317",
[23827]="30560",
[32478]="41317",
[32461]="40274",
[32476]="41315",
[32472]="41311",
[32475]="41316",
[32480]="41319",
[32495]="41321",
[32473]="41312",
[32479]="41318",
[23836]="30563",
[23746]="30313",
[23819]="30547",
[23787]="30309",
[23785]="30307",
[23786]="30308",
[23824]="30556",
[23747]="30314",
[23765]="30332",
[23829]="30575",
[23828]="30574",
[23748]="30315",
[23766]="30334",
[23820]="30549",
[32413]="39973",
[23769]="30342",
[20906]="25493",
[21931]="26925",
[20816]="25255",
[25498]="32259",
[21932]="26926",
[25438]="32178",
[25439]="32179",
[20821]="25283",
[21934]="26928",
[20818]="25280",
[20907]="25490",
[21933]="26927",
[20817]="25278",
[25880]="32801",
[20820]="25284",
[30804]="37818",
[20823]="25287",
[30419]="36523",
[31154]="38175",
[20827]="25317",
[20826]="25305",
[20828]="25318",
[30420]="36524",
[20830]="25339",
[20909]="25498",
[25881]="32807",
[20832]="25321",
[20950]="25610",
[20954]="25612",
[20833]="25323",
[20955]="25613",
[20958]="25617",
[20831]="25320",
[20963]="25615",
[20966]="25618",
[20960]="25620",
[20959]="25619",
[25882]="32808",
[29157]="34955",
[20961]="25621",
[20967]="25622",
[20964]="26874",
[21755]="26876",
[20969]="26878",
[25883]="32809",
[21752]="26880",
[30421]="36525",
[21764]="26883",
[21765]="26885",
[21754]="26887",
[21753]="26896",
[21766]="26897",
[21767]="26902",
[30422]="36526",
[21774]="26906",
[21768]="26903",
[29159]="34960",
[21775]="26907",
[21790]="26908",
[21778]="26910",
[21791]="26911",
[29160]="34961",
[23113]="28938",
[23108]="28925",
[23098]="28910",
[23103]="28916",
[23118]="28950",
[23094]="28903",
[21792]="26915",
[23095]="28905",
[28595]="34590",
[23114]="28944",
[23104]="28917",
[23099]="28912",
[23109]="28927",
[23119]="28953",
[21779]="26916",
[24074]="31048",
[24075]="31049",
[23105]="28918",
[23100]="28914",
[23096]="28906",
[23110]="28933",
[23120]="28955",
[23115]="28947",
[24076]="31050",
[32772]="41414",
[31079]="38068",
[23106]="28924",
[23097]="28907",
[23121]="28957",
[23101]="28915",
[32833]="41420",
[23116]="28948",
[28290]="34069",
[23111]="28936",
[32774]="41415",
[24078]="31052",
[24077]="31051",
[32508]="40514",
[24087]="31058",
[31863]="39463",
[24027]="31084",
[24031]="31089",
[24047]="31096",
[24065]="31112",
[24028]="31085",
[24062]="31110",
[24036]="31091",
[24050]="31099",
[24061]="31109",
[24056]="31104",
[31861]="39452",
[31865]="39462",
[24058]="31106",
[24067]="31113",
[24079]="31053",
[24060]="31108",
[24037]="31094",
[24053]="31101",
[24059]="31107",
[32836]="41429",
[24066]="31111",
[24051]="31098",
[24057]="31105",
[24030]="31088",
[24055]="31103",
[24048]="31097",
[24033]="31092",
[24054]="31102",
[24035]="31149",
[24039]="31095",
[24032]="31090",
[24029]="31087",
[24052]="31100",
[31867]="39470",
[31868]="39471",
[24088]="31060",
[24080]="31054",
[24082]="31055",
[24110]="31068",
[24106]="31067",
[24114]="31070",
[24116]="31071",
[24085]="31056",
[24092]="31062",
[24093]="31063",
[24098]="31066",
[24095]="31064",
[30825]="37855",
[24086]="31057",
[24089]="31061",
[25897]="32867",
[25899]="32869",
[24121]="31076",
[32776]="41418",
[25890]="32871",
[24117]="31072",
[25895]="32874",
[25901]="32870",
[25893]="32872",
[25896]="32866",
[32409]="39961",
[25894]="32873",
[25898]="32868",
[32410]="39963",
[24123]="31078",
[24122]="31077",
[32213]="39729",
[32193]="39705",
[32197]="39712",
[32204]="39719",
[32225]="39741",
[32194]="39706",
[32223]="39739",
[32199]="39714",
[32207]="39722",
[32220]="39736",
[32215]="39731",
[32210]="39725",
[32214]="39730",
[32217]="39733",
[32226]="39742",
[32219]="39735",
[32202]="39717",
[32209]="39724",
[32218]="39734",
[32224]="39740",
[32216]="39732",
[32196]="39711",
[32212]="39728",
[32205]="39720",
[32200]="39715",
[32211]="39727",
[32201]="39716",
[32203]="39718",
[32198]="39713",
[32195]="39710",
[31398]="38503",
[31399]="38504",
[32208]="39723",
[32221]="39737",
[32222]="39738",
[32206]="39721",
[31862]="39455",
[31860]="39451",
[31864]="39458",
[31866]="39466",
[31869]="39467",
[2302]="2149",
[7277]="9059",
[7276]="9058",
[5957]="7126",
[2304]="2152",
[2318]="2881",
[2303]="2153",
[4237]="3753",
[7278]="9060",
[7279]="9062",
[7280]="9064",
[4231]="3816",
[2300]="2160",
[5081]="5244",
[2309]="2161",
[4239]="3756",
[2310]="2162",
[2311]="2163",
[7281]="9065",
[4242]="3759",
[2312]="2164",
[4246]="3763",
[2308]="2159",
[4243]="3761",
[6466]="7953",
[6709]="8322",
[5780]="6702",
[2307]="2158",
[7282]="9068",
[5781]="6703",
[7283]="9070",
[20575]="24940",
[2317]="2169",
[4233]="3817",
[2315]="2167",
[2313]="2165",
[2319]="20648",
[6467]="7954",
[5958]="7133",
[2316]="2168",
[6468]="7955",
[5961]="7135",
[4248]="3765",
[7285]="9074",
[7284]="9072",
[2314]="2166",
[4249]="3766",
[4253]="3770",
[7352]="9147",
[4252]="3769",
[4255]="3772",
[7359]="9149",
[4254]="3771",
[7372]="9194",
[7371]="9193",
[4236]="3818",
[4265]="3780",
[4234]="20649",
[18662]="23190",
[18948]="23399",
[4456]="4097",
[4455]="4096",
[4257]="3774",
[5962]="7147",
[7373]="9195",
[5963]="7149",
[4258]="3775",
[5782]="6704",
[5964]="7151",
[7374]="9196",
[7375]="9197",
[4256]="3773",
[7377]="9198",
[4259]="3776",
[7378]="9201",
[5965]="7153",
[17721]="21943",
[7386]="9202",
[5783]="6705",
[5739]="6661",
[5966]="7156",
[7387]="9206",
[4260]="3777",
[18238]="22711",
[4264]="3779",
[8174]="10490",
[7390]="9207",
[7391]="9208",
[8172]="10482",
[8173]="10487",
[4304]="20650",
[8176]="10507",
[8175]="10499",
[8187]="10509",
[8192]="10516",
[8198]="10518",
[8189]="10511",
[8210]="10529",
[8200]="10520",
[8214]="10546",
[8211]="10544",
[8201]="10531",
[8205]="10533",
[8203]="10525",
[8347]="10619",
[8345]="10621",
[8217]="14930",
[8218]="14932",
[8204]="10542",
[8346]="10630",
[8193]="10548",
[8191]="10552",
[8197]="10558",
[8209]="10554",
[8185]="10556",
[8213]="10566",
[8216]="10562",
[8202]="10560",
[8207]="10564",
[8215]="10574",
[8212]="10572",
[8206]="10568",
[8349]="10647",
[8348]="10632",
[8208]="10570",
[15407]="19047",
[15564]="19058",
[8170]="22331",
[8367]="10650",
[15077]="19048",
[29964]="36074",
[29971]="36076",
[15045]="19050",
[29970]="36075",
[15083]="19049",
[15074]="19053",
[15076]="19051",
[15084]="19052",
[15046]="19060",
[15067]="19062",
[15061]="19061",
[15091]="19055",
[15054]="19059",
[15057]="19067",
[15064]="19068",
[15073]="19063",
[15071]="19066",
[15078]="19064",
[15092]="19065",
[20296]="24655",
[15072]="19073",
[15082]="19070",
[15093]="19072",
[15086]="19071",
[15048]="19077",
[15060]="19078",
[15056]="19079",
[15065]="19080",
[15069]="19074",
[15079]="19075",
[15053]="19076",
[15050]="19085",
[19052]="23705",
[15063]="19084",
[15066]="19086",
[19044]="23703",
[15075]="19081",
[15094]="19082",
[15087]="19083",
[16982]="20853",
[15049]="19089",
[15058]="19090",
[15070]="19087",
[15080]="19088",
[16984]="20855",
[18509]="22926",
[19157]="23708",
[19162]="23709",
[20380]="24703",
[18510]="22927",
[22665]="28224",
[22664]="28222",
[22666]="28223",
[19149]="23707",
[19163]="23710",
[16983]="20854",
[22663]="28221",
[22662]="28220",
[22661]="28219",
[18511]="22928",
[15052]="19107",
[15051]="19094",
[19688]="24124",
[19689]="24125",
[20295]="24654",
[22761]="28474",
[22760]="28473",
[22759]="28472",
[18251]="22727",
[15062]="19097",
[18504]="22921",
[19058]="23706",
[15059]="19095",
[18506]="22922",
[15138]="19093",
[19687]="24123",
[19686]="24122",
[19685]="24121",
[15047]="19054",
[20476]="24849",
[20478]="24851",
[20477]="24850",
[20481]="24846",
[20479]="24848",
[20480]="24847",
[21278]="26279",
[18508]="22923",
[19049]="23704",
[25654]="32462",
[15068]="19104",
[18258]="22815",
[15081]="19100",
[15090]="19102",
[15095]="19091",
[15096]="19103",
[25662]="32466",
[25669]="32470",
[15055]="19101",
[15085]="19098",
[15088]="19092",
[25673]="32478",
[25679]="32482",
[25650]="32456",
[21887]="32454",
[25655]="32463",
[25661]="32467",
[25674]="32479",
[25670]="32471",
[25656]="32464",
[25668]="32472",
[25675]="32480",
[29540]="35530",
[25660]="32468",
[23793]="32455",
[29975]="36079",
[29974]="36078",
[29973]="36077",
[25671]="32473",
[25676]="32481",
[29534]="35555",
[29533]="35549",
[25657]="32465",
[25659]="32469",
[25685]="32490",
[25694]="32501",
[25692]="32502",
[29488]="35524",
[29528]="35540",
[29485]="35521",
[29486]="35522",
[29487]="35523",
[29483]="35520",
[29530]="35544",
[29500]="35537",
[29499]="35536",
[29498]="35535",
[29497]="35534",
[29496]="35533",
[29495]="35532",
[29491]="35527",
[29490]="35526",
[29489]="35525",
[25686]="32493",
[25687]="32494",
[25695]="32498",
[29494]="35531",
[29493]="35528",
[29492]="35529",
[25693]="32503",
[25653]="32461",
[29531]="35539",
[25691]="32497",
[25690]="32496",
[25697]="32499",
[25696]="32500",
[25689]="32495",
[29503]="35559",
[29502]="35558",
[29512]="35567",
[29506]="35562",
[29505]="35561",
[29508]="35564",
[29511]="35573",
[29510]="35572",
[29514]="35574",
[29504]="35560",
[29507]="35563",
[29509]="35568",
[29529]="35543",
[29536]="35557",
[29535]="35554",
[29532]="35538",
[30040]="36351",
[30042]="36349",
[30046]="36352",
[32574]="41161",
[30041]="36355",
[32398]="39997",
[30045]="36358",
[30039]="36357",
[32582]="41156",
[32399]="40000",
[29516]="35576",
[29517]="35577",
[29515]="35575",
[32400]="40001",
[30043]="36359",
[32577]="41163",
[32579]="41164",
[30044]="36353",
[29520]="35582",
[29521]="35584",
[29519]="35580",
[29526]="35590",
[29527]="35591",
[29525]="35589",
[32393]="40006",
[32396]="40005",
[32394]="40003",
[32395]="40004",
[32583]="41157",
[32575]="41162",
[32580]="41158",
[32581]="41160",
[32397]="40002",
[29524]="35587",
[29523]="35588",
[29522]="35585",
[2996]="2963",
[4344]="3915",
[2570]="2387",
[10045]="12044",
[2576]="2393",
[2568]="2385",
[7026]="8776",
[10046]="12045",
[6238]="7623",
[6241]="7624",
[4343]="3914",
[4307]="3840",
[2572]="2389",
[2577]="2394",
[2575]="2392",
[6786]="8465",
[4238]="3755",
[6240]="7630",
[6239]="7629",
[4308]="3841",
[2580]="2397",
[2569]="2386",
[2578]="2395",
[6242]="7633",
[4309]="3842",
[2579]="2396",
[5762]="6686",
[2997]="2964",
[10047]="12046",
[2584]="2402",
[4240]="3757",
[4310]="3843",
[2582]="2399",
[4313]="3847",
[2583]="2401",
[4241]="3758",
[6263]="7639",
[4311]="3844",
[2587]="2406",
[2585]="2403",
[4316]="3850",
[4330]="3866",
[6787]="8467",
[4332]="3869",
[5763]="6688",
[10048]="12047",
[4315]="3849",
[6384]="7892",
[6385]="7893",
[4320]="3855",
[4331]="3868",
[4317]="3851",
[4305]="3839",
[4318]="3852",
[4319]="3854",
[4333]="3870",
[7046]="8758",
[4321]="3856",
[7047]="8780",
[7048]="8760",
[4324]="3859",
[5770]="6692",
[7049]="8782",
[4245]="3813",
[7050]="8762",
[7065]="8784",
[7051]="8764",
[4323]="3858",
[4334]="3871",
[7052]="8766",
[7053]="8786",
[4325]="3860",
[7055]="8772",
[4339]="3865",
[5764]="6693",
[7056]="8789",
[7057]="8774",
[4328]="3863",
[4326]="3861",
[5765]="6695",
[7058]="8791",
[4335]="3872",
[7054]="8770",
[7060]="8795",
[7059]="8793",
[17723]="21945",
[7061]="8797",
[7062]="8799",
[10052]="12064",
[4327]="3862",
[4329]="3864",
[9999]="12049",
[9998]="12048",
[7063]="8802",
[10054]="12075",
[10001]="12050",
[7064]="8804",
[10002]="12052",
[10055]="12080",
[10003]="12053",
[10009]="12060",
[10007]="12056",
[10004]="12055",
[10008]="12059",
[10056]="12061",
[10034]="12085",
[10035]="12089",
[10019]="12067",
[10021]="12070",
[10042]="12069",
[22246]="27658",
[10018]="12066",
[10023]="12071",
[10050]="12065",
[10040]="12091",
[10026]="12073",
[10024]="12072",
[10027]="12074",
[10025]="12086",
[10029]="12078",
[10028]="12076",
[10051]="12079",
[10053]="12077",
[10036]="12093",
[13868]="18404",
[10033]="12084",
[10031]="12082",
[10044]="12088",
[10041]="12092",
[14048]="18401",
[21154]="26403",
[21542]="26407",
[14342]="18560",
[13869]="18403",
[13856]="18402",
[14042]="18408",
[13858]="18406",
[13857]="18407",
[21340]="26085",
[14046]="18405",
[13870]="18411",
[14143]="18410",
[13860]="18409",
[14101]="18415",
[14100]="18414",
[14043]="18412",
[14142]="18413",
[14134]="18422",
[14103]="18420",
[22251]="27724",
[14044]="18418",
[22248]="27659",
[14107]="18419",
[14141]="18416",
[13863]="18417",
[14132]="18421",
[21341]="26086",
[14045]="18434",
[13871]="18424",
[13864]="18423",
[14140]="18452",
[18486]="22902",
[14139]="18448",
[14138]="18447",
[14136]="18436",
[14108]="18437",
[13865]="18438",
[19056]="23664",
[15802]="19435",
[14137]="18440",
[19047]="23662",
[14104]="18439",
[14111]="18442",
[14144]="18441",
[13866]="18444",
[18405]="22866",
[21342]="26087",
[16979]="20849",
[19165]="23667",
[16980]="20848",
[19156]="23666",
[18263]="22759",
[22658]="28208",
[22654]="28205",
[22652]="28207",
[22655]="28209",
[14146]="18454",
[14152]="18457",
[14153]="18458",
[14154]="18456",
[19059]="23665",
[19684]="24093",
[19683]="24092",
[19682]="24091",
[14156]="18455",
[18413]="22870",
[18407]="22867",
[18408]="22868",
[19050]="23663",
[18409]="22869",
[20539]="24902",
[20537]="24903",
[20538]="24901",
[22757]="28481",
[22758]="28482",
[22756]="28480",
[22249]="27660",
[14106]="18451",
[14112]="18453",
[18258]="22813",
[14155]="18445",
[13867]="18449",
[22252]="27725",
[14128]="18446",
[14130]="18450",
[21840]="26745",
[24268]="31460",
[21850]="26765",
[21849]="26764",
[21841]="26746",
[21851]="26770",
[21842]="26747",
[21852]="26771",
[24269]="31461",
[24273]="31430",
[24275]="31431",
[21853]="26772",
[21859]="26775",
[24270]="31459",
[21843]="26749",
[21854]="26773",
[21855]="26774",
[21844]="26750",
[21866]="26782",
[24251]="31437",
[24250]="31435",
[30831]="37873",
[24253]="31440",
[24252]="31438",
[30837]="37882",
[21860]="26776",
[21845]="26751",
[24272]="36686",
[24271]="31373",
[24249]="31434",
[24254]="31441",
[21869]="26756",
[21873]="26760",
[21863]="26779",
[21846]="26752",
[21867]="26783",
[30838]="37883",
[21861]="26777",
[21862]="26778",
[24257]="31444",
[21870]="26757",
[24256]="31443",
[24260]="31450",
[21874]="26761",
[24258]="31448",
[21864]="26780",
[21847]="26753",
[24255]="31442",
[24259]="31449",
[21868]="26784",
[30839]="37884",
[24267]="31456",
[24263]="31453",
[30038]="36315",
[30036]="36316",
[30037]="36317",
[30035]="36318",
[32586]="41205",
[21871]="26758",
[24276]="31433",
[32587]="41206",
[21875]="26762",
[24274]="31432",
[21865]="26781",
[32392]="40021",
[32390]="40024",
[32389]="40023",
[32391]="40020",
[21848]="26754",
[24266]="31455",
[24262]="31452",
[32585]="41208",
[32584]="41207",
[24264]="31454",
[24261]="31451",
[21872]="26759",
[21876]="26763",
[21858]="26755",
[30463]="36670",
[30038]="36315",
[30040]="36351",
[30042]="36339",
[30046]="36352",
[30036]="36316",
[30037]="36317",
[30041]="36355",
[30045]="36358",
[30035]="36318",
[30043]="36359",
[30044]="36353",
[30034]="36389",
[30033]="36391",
[30032]="36390",
[30031]="36392",
[32199]="39714",
[32210]="39725",
[32217]="39733",
[32209]="39724",
[32212]="39728",
[32211]="39727",
[32203]="39718",
[32221]="39737",
[32574]="41161",
[32579]="41164",
[32587]="41206",
[32583]="41157",
[32584]="41207",
[32580]="41158",
[32573]="41135",
[32568]="41132",
[32586]="41205",
[32744]="41156",
[32577]="41163",
[32587]="41206",
[32583]="41157",
[32575]="41162",
[32585]="41208",
[32747]="41160",
[32571]="41134",
[32570]="41133",
[30039]="36357",
[32398]="39997",
[32399]="40000",
[32400]="40001",
[32397]="40002",
[32393]="40006",
[32396]="40005",
[32394]="40003",
[32395]="40004",
[32420]="40060",
[32392]="40021",
[32390]="40024",
[32389]="40023",
[32391]="40020",
[32403]="40034",
[32401]="40036",
[32404]="40035",
[32402]="40033",
[33173]="42662",
[32213]="39729",
[32193]="39705",
[32197]="39712",
[32204]="39719",
[32225]="39741",
[32194]="39706",
[32223]="39739",
[32207]="39722",
[32220]="39736",
[32215]="39731",
[32214]="39730",
[32226]="39742",
[32219]="39735",
[32202]="39717",
[32218]="39734",
[32224]="39740",
[32206]="39721",
[32216]="39732",
[32916]="39711",
[32205]="39720",
[32200]="39715",
[32201]="39716",
[32198]="39713",
[32195]="39710",
[32208]="39723",
[32222]="39738",
[33140]="42592",
[33131]="42589",
[33133]="42558",
[33144]="42593",
[33135]="42590",
[33134]="42588",
[33143]="42591",
[33204]="42731", --Shadowprowler's Chestguard
[33122]="42546", -- Cloak of Darkness
[33208]="42736", --Flask of Chromatic Wonder
[33093]="30552",
[70]="42613",
}


TradeskillInfo_Translations = nil
