﻿-- $Revision: 75534 $
--[[
TODO: (Updated 10/25/2007

*Add Drum recipes to vendors
*Fix remaining Enchanting Oils to actually work
:ODOT

Specialcases = When there are several combines that yield the same itemid
[index or itemid]itemid|name

Combines
[index]skill|components|recipe|yield|itemid
index = itemid or -enchantid or specialcase
skill =
	A = Alchemy
	B = Blacksmithing
	Ba = Armorsmith
	Bw = Weaponsmith
	Bws = Master Swordsmith
	Bwh = Master Hammersmith
	Bwx = Master Axesmith
	N = Enchanting
	E = Engineering
	Eg = Gnomish Engineer
	Eb = Goblin Engineer
	J = Jewelcrafting
	L = Leatherworking
	Ld = Dragonscale Leatherworking
	Le = Elemental Leatherworking
	Lt = Tribal Leatherworking
	T = Tailoting
	C = Cooking
	F = First Aid
	P = Poisons
	M = Mining
	# = level
components =
  itemid[:num] ...
recipe = recipeid (Optional)
yield = how many the combine makes (Optional)
itemid = itemid crafted if it differs from index (Optional)

Components
[itemid]name/cost/source
Name
Cost (sell value for all except vendor, where it is buy value) per item
Source
	V = Vendor (Only items with unlimited supply)
	D = Dropped
	C = Crafted
	M = Mined
	H = Herbalism
	S = Skinned
	F = Fished
	E = Disenchanted
	G = Gathered (No skill required)
	P = Pickpocketed

Enchants
[-enchantid]name/description

Zones
[index]name

Vendors
[index]name|zone|faction|location|comment

Recipes
[recipeid]#|source|price|level
# = combine id
source
	D = Drop
	V = Vendor
	Q = Quest
	# index to table vendors
Price = Vendor sell price (Optional)
Level = faction rank needed (Optional)

]]

if GetLocale() ~= 'esES' then return end;

if not TradeskillInfo or not TradeskillInfo.vars then return end
if not TradeskillInfo_Translations then
	TradeskillInfo_Translations = {}
end

-- Local translation function
local function TT(text)
	if TradeskillInfo_Translations[text] and TradeskillInfo_Translations[text] ~= "" then
		return TradeskillInfo_Translations[text]
	end
	return text
end

local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BF = LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BTS = AceLibrary("Babble-Tradeskill-2.2")

TradeskillInfo.vars.tradeskills = {
	['A'] = TT(BTS["Alchemy"]),
	['B'] = TT(BTS["Blacksmithing"]),
	['D'] = TT(BTS["Enchanting"]),
	['E'] = TT(BTS["Engineering"]),
	['J'] = TT(BTS["Jewelcrafting"]),
	['L'] = TT(BTS["Leatherworking"]),
	['T'] = TT(BTS["Tailoring"]),
	['W'] = TT(BTS["Cooking"]),
	['X'] = TT(BTS["First Aid"]),
	['Y'] = TT(BTS["Mining"]),
	['Z'] = TT(BTS["Poisons"]),
}

TradeskillInfo.vars.skillnames = {
	[TradeskillInfo.vars.tradeskills['A']] = 'A',
	[TradeskillInfo.vars.tradeskills['B']] = 'B',
	[TradeskillInfo.vars.tradeskills['D']] = 'D',
	[TradeskillInfo.vars.tradeskills['E']] = 'E',
	[TradeskillInfo.vars.tradeskills['J']] = 'J',
	[TradeskillInfo.vars.tradeskills['L']] = 'L',
	[TradeskillInfo.vars.tradeskills['T']] = 'T',
	[TradeskillInfo.vars.tradeskills['W']] = 'W',
	[TradeskillInfo.vars.tradeskills['X']] = 'X',
	[TradeskillInfo.vars.tradeskills['Y']] = 'Y',
	[TradeskillInfo.vars.tradeskills['Z']] = 'Z',
}

TradeskillInfo.vars.specializations = {
	['a'] = BTS["Armorsmith"],
	['w'] = BTS["Weaponsmith"],
	['ws'] = BTS["Master Swordsmith"],
	['wh'] = BTS["Master Hammersmith"],
	['wx'] = BTS["Master Axesmith"],
	['d'] = BTS["Dragonscale Leatherworking"],
	['e'] = BTS["Elemental Leatherworking"],
	['t'] = BTS["Tribal Leatherworking"],
	['g'] = BTS["Gnomish Engineer"],
	['b'] = BTS["Goblin Engineer"],
	['p'] = BTS["Spellfire Tailoring"],
	['s'] = BTS["Shadoweave Tailoring"],
	['m'] = BTS["Mooncloth Tailoring"],
}
TradeskillInfo.vars.specializationnames = {
	[TradeskillInfo.vars.specializations['a']] = "a",
	[TradeskillInfo.vars.specializations['w']] = "w",
	[TradeskillInfo.vars.specializations['ws']] = "ws",
	[TradeskillInfo.vars.specializations['wh']] = "wh",
	[TradeskillInfo.vars.specializations['wx']] = "wx",
	[TradeskillInfo.vars.specializations['d']] = "d",
	[TradeskillInfo.vars.specializations['e']] = "e",
	[TradeskillInfo.vars.specializations['t']] = "t",
	[TradeskillInfo.vars.specializations['g']] = "g",
	[TradeskillInfo.vars.specializations['b']] = "b",
	[TradeskillInfo.vars.specializations['p']] = "p",
	[TradeskillInfo.vars.specializations['s']] = "s",
	[TradeskillInfo.vars.specializations['m']] = "m",
}
TradeskillInfo.vars.sources = {
	['V'] = "Vendedor",
	['Va'] = "Vendedor de la Alianza",
	['Vh'] = "Vendedor de la Orda",
	['D'] = "Soltado",
	['C'] = "Fabricado",
	['Ca'] = BTS["Alchemy"],
	['Cb'] = BTS["Blacksmithing"],
	['Cn'] = BTS["Enchanting"],
	['Ce'] = BTS["Engineering"],
	['Cj'] = BTS["Jewelcrafting"],
	['Cl'] = BTS["Leatherworking"],
	['Ct'] = BTS["Tailoring"],
	['Cc'] = BTS["Cooking"],
	['Cf'] = BTS["First Aid"],
	['Cp'] = BTS["Poisons"],
	['Cs'] = BTS["Smelting"],
	['M'] = "Minado",
	['Ma'] = "Vena de Bronce",
	['Mb'] = "Vena de Tin",
	['Mc'] = "Vena de Plata",
	['Md'] = "Vena de Oro",
	['Me'] = "Depósito de Hierro",
	['Mf'] = "Depósito de Mithril",
	['Mg'] = "Depósito de Truesilver",
	['Mh'] = "Depósito de Hierro Oscuro",
	['Mi'] = "Vena de Torio de Hakkari",
	['Mj'] = "Cualquier Vena de Torio",
	['Mk'] = "Vena Rica de Torio",
	['Ml'] = "Depósito de Hierro Fel",
	['Mm'] = "Depósito de Adamantita",
	['Mn'] = "Vena de Khorium",
	['H'] = "Hierbas",
	['S'] = "Pelado",
	['Sa'] = "Bestias nivel 1-10",
	['Sb'] = "Bestias nivel 1-20",
	['Sc'] = "Bestias nivel 20-30",
	['Sd'] = "Bestias nivel 30-40",
	['Se'] = "Bestias nivel 40-50",
	['Sf'] = "Bestias nivel 50-60",
	['Sg'] = "Panteras Sombrías. "..BZ["Stranglethorn Vale"]..", "..BZ["Swamp of Sorrows"], -- 7428
	['Sh'] = "Tortugas nivel 40-60", -- 8167
	['Si'] = "Escorpiones nivel 40-50", -- 8154
	['Sj'] = "Escorpiones nivel 50-60", -- 15408
	['Sk'] = "Dragonkins nivel 40-60+", -- 8165
	['Sl'] = "Elite Dragonkins nivel 50-60+", -- 15412, 15414, 15415, 15416,
	['Sm'] = "Frostsabers. "..BZ["Winterspring"], -- 15422
	['Sn'] = "Devilsaurs. "..BZ["Un'Goro Crater"], -- 15417
	['So'] = "Chimeras. "..BZ["Azshara"]..","..BZ["Winterspring"]..", "..BZ["Dire Maul"], -- 15423
	['Sp'] = "Lobos nivel 40-60", -- 8368
	['Sq'] = "Osos nivel 50-60", -- 15419
	['Sr'] = "Murcielagos. "..BZ["Zul'Gurub"], -- 19767
	['Ss'] = "Tigres. "..BZ["Zul'Gurub"], -- 19768
	['St'] = "Ancient Core Hound, Magmadar. "..BZ["Molten Core"], -- 17012
	['Su'] = "Silithids. "..BZ["Silithus"], -- 20501,20498
	['Sv'] = "Emeriss, Lethon, Taerar, Ysondre", -- 20381
	['Sw'] = "Onyxia. "..BZ["Onyxia's Lair"], -- 20381
	['Sy'] = "Bestias. "..BZ["Wailing Caverns"],
	['Sz'] = "Cachorros. "..BZ["Wetlands"],
	['Saa'] = "Cachorros. "..BZ["Redridge Mountains"],
	['Sab'] = "Cachorros. "..BZ["Swamp of Sorrows"],
	['Sac'] = "Rapaces nivel 30-40",
	['F'] = "Pescado",
	['E'] = "Desencantado",
	['Ea'] = "Objetos nivel 1-20",
	['Eb'] = "Objetos nivel 1-10",
	['Ec'] = "Objetos nivel 11-15",
	['Ed'] = "Objetos nivel 16-20",
	['Ee'] = "Objetos nivel 21-30",
	['Ef'] = "Objetos nivel 21-25",
	['Eg'] = "Objetos nivel 26-30",
	['Eh'] = "Objetos nivel 31-40",
	['Ei'] = "Objetos nivel 31-35",
	['Ej'] = "Objetos nivel 36-40",
	['Ek'] = "Objetos nivel 41-50",
	['El'] = "Objetos nivel 41-45",
	['Em'] = "Objetos nivel 46-50",
	['En'] = "Objetos nivel 51-60",
	['Eo'] = "Epicos nivel 51-60",
	['Ep'] = "Objetos nivel 57-63",
	['Eq'] = "Objetos nivel 64+",
	['Er'] = "Objetos nivel 57+",
	['Es'] = "Epicos nivel 57+",
	['G'] = "Recolectado",
	['P'] = "Ligado",
	['Q'] = "Misión",
	['Qa'] = "Misión de la Alianza",
	['Qh'] = "Misión de la Horda",
	['T'] = "Entrenador",
	['Ts'] = "Entrenador Especialista",
	['X'] = "Actualmente No Se Puede Obtener",
	['R'] = "Prospección",
	['U'] = "Desconocido",
}

TradeskillInfo.vars.difficulty = {
	['trivial'] = 1,
	['easy'] = 2,
	['medium'] = 3,
	['optimal'] = 4,
}

TradeskillInfo.vars.diffcolors = {
	[1] = '|cff777777',
	[2] = '|cff33bb33',
	[3] = '|cffffff00',
	[4] = '|cffff7733',
	[5] = '|cffffffff',
}

TradeskillInfo.vars.specialcases = {
	[3386] = "",
	[1] = "3386|"..BTS["Potion of Curing"],
	[3577] = "",
	[2] = "3577|"..BTS["Transmute: Iron to Gold"],
	[6037] = "",
	[3] = "6037|"..BTS["Transmute: Mithril to Truesilver"],
	[7078] = "",
	[4] = "7078|"..BTS["Transmute: Air to Fire"],
	[12360] = "",
	[5] = "12360|"..BTS["Transmute: Arcanite"],
	[12803] = "",
	[6] = "12803|"..BTS["Transmute: Earth to Life"],
	[7080] = "",
	[7] = "7080|"..BTS["Transmute: Earth to Water"],
	[7076] = "",
	[8] = "7076|"..BTS["Transmute: Fire to Earth"],
	[9] = "7076|"..BTS["Transmute: Life to Earth"],
	[10] = "7080|"..BTS["Transmute: Undeath to Water"],
	[7082] = "",
	[11] = "7082|"..BTS["Transmute: Water to Air"],
	[12808] = "",
	[12] = "12808|"..BTS["Transmute: Water to Undeath"],
	[7068] = "",
	[13] = "7068|"..BTS["Transmute: Elemental Fire"],
	[25867] = "",
	[14] = "25867|"..BTS["Transmute: Earthstorm Diamond"],
	[23571] = "",
	[15] = "23571|"..BTS["Transmute: Primal Might"],
	[25868] = "",
	[16] = "25868|"..BTS["Transmute: Skyfire Diamond"],
	[21884] = "",
	[17] = "21884|"..BTS["Transmute: Primal Air to Fire"],
	[21885] = "",
	[18] = "21885|"..BTS["Transmute: Primal Earth to Water"],
	[22452] = "",
	[19] = "22452|"..BTS["Transmute: Primal Fire to Earth"],
	[22451] = "",
	[20] = "22451|"..BTS["Transmute: Primal Water to Air"],
	[22861] = "",
	[21] = "22861|"..BTS["Flask of Blinding Light"],
	[22866] = "",
	[22] = "22866|"..BTS["Flask of Pure Death"],
	[21886] = "",
	[23] = "21886|"..BTS["Transmute: Primal Earth to Life"],
	[22457] = "",
	[24] = "22457|"..BTS["Transmute: Primal Fire to Mana"],
	[25] = "22452|"..BTS["Transmute: Primal Life to Earth"],
	[26] = "21884|"..BTS["Transmute: Primal Mana to Fire"],
	[27] = "21885|"..BTS["Transmute: Primal Shadow to Water"],
	[22456] = "",
	[28] = "22456|"..BTS["Transmute: Primal Water to Shadow"],
--	[23575] = "",
--	[29] = "23575|"..BTS["Lesser Ward of Shielding"],
--	[23576] = "",
--	[30] = "23576|"..BTS["Greater Ward of Shielding"],
--	[8364] = "",
--	[31] = "8364|"..BTS["Mithril Headed Trout"],
	--[12655] = "",
	--[32] = "12655|"..BTS["Enchanted Thorium"],
--	[4401] = "",
--	[33] = "4401|"..BTS["Mechanical Squirrel"],
	[21570] = "",
	[34] = "21570|"..BTS["Firework Cluster Launcher"],
	[32413] = "",
	[35] = "32413|"..BTS["Frost Grenades"],
	[10713] = "",
	[36] = "10713|"..BTS["Inlaid Mithril Cylinder Plans"],
	[18986] = "",
	[37] = "18986|"..BTS["Ultrasafe Transporter - Gadgetzan"],
	[18645] = "",
	[38] = "18645|"..BTS["Alarm-O-Bot"],
	[23825] = "",
	[39] = "23825|"..BTS["Nigh-Invulnerability Belt"],
	[30544] = "",
	[40] = "30544|"..BTS["Ultrasafe Transporter - Toshley's Station"],
	[10644] = "",
	[41] = "10644|"..BTS["Goblin Rocket Fuel Recipe"],
	[10577] = "",
	[42] = "10577|"..BTS["Goblin Mortar"],
	[43] = "10577|"..BTS["The Mortar: Reloaded"],
	[24122] = "",
	[44] = "24122|"..BTS["Coronet of the Verdant Flame"],
	[15078] = "",
	[45] = "15078|"..BTS["Heavy Scorpid Gauntlets"],
	[25697] = "",
	[46] = "25697|"..BTS["Felstalker Bracer"],
	[2840] = "",
	[47] = "2840|"..BTS["Smelt Copper"],
	[2841] = "",
	[48] = "2841|"..BTS["Smelt Bronze"],
	[3576] = "",
	[49] = "3576|"..BTS["Smelt Tin"],
	[2842] = "",
	[50] = "2842|"..BTS["Smelt Silver"],
	[3575] = "",
	[51] = "3575|"..BTS["Smelt Iron"],
	[52] = "3577|"..BTS["Smelt Gold"],
	[3859] = "",
	[53] = "3859|"..BTS["Smelt Steel"],
	[3860] = "",
	[54] = "3860|"..BTS["Smelt Mithril"],
	[55] = "6037|"..BTS["Smelt Truesilver"],
	[11371] = "",
	[56] = "11371|"..BTS["Smelt Dark Iron"],
	[12359] = "",
	[57] = "12359|"..BTS["Smelt Thorium"],
	[17771] = "",
	[58] = "17771|"..BTS["Smelt Elementium"],
	[22573] = "",
	[59] = "22573|"..BTS["Earth Shatter"],
	[22574] = "",
	[60] = "22574|"..BTS["Fire Sunder"],
	[23445] = "",
	[61] = "23445|"..BTS["Smelt Fel Iron"],
	[23446] = "",
	[62] = "23446|"..BTS["Smelt Adamantite"],
	[23447] = "",
	[63] = "23447|"..BTS["Smelt Eternium"],
	[23448] = "",
	[64] = "23448|"..BTS["Smelt Felsteel"],
	[23449] = "",
	[65] = "23449|"..BTS["Smelt Khorium"],
	[23573] = "",
	[66] = "23573|"..BTS["Smelt Hardened Adamantite"],
	[21542] = "",
	[67] = "21542|"..BTS["Festive Red Pant Suit"],
	[18258] = "",
	[68] = "18258|"..BTS["Gordok Ogre Suit"],
	[69] = "18258|"..BTS["Gordok Ogre Suit"],
--    [22448] = "",
--    [70] = "22448|"..BTS["Nexus Transformation"],
    }

TradeskillInfo.vars.enchantItems = {
	[-7421] = "6218",
	[-14293] = "11287",
	[-25124] = "20744",
	[-14807] = "11288",
	[-7795] = "6339",
	[-25125] = "20745",
	[-13628] = "11130",
	[-14809] = "11289",
	[-14810] = "11290",
	[-25126] = "20746",
	[-13702] = "11145",
	[-17181] = "12810",
	[-17180] = "12655",
	[-25127] = "20747",
	[-15596] = "11811",
	[-25128] = "20750",
	[-20051] = "16207",
	[-25130] = "20748",
	[-25129] = "20749",
	[-32664] = "22461",
	[-28016] = "22521",
	[-28027] = "22460",
	[-28022] = "22449",
	[-28019] = "22522",
	[-28028] = "22459",
	[-32665] = "22462",
	[-32667] = "22463",
	[-42613] = "22448",
}

TradeskillInfo.vars.combines = {
--[[ Alchemy --]]
	[2454] = "2329|A1|2449 765 3371",	-- Elixir of Lion's Strength
	[5997] = "7183|A1|765:2 3371",	-- Elixir of Minor Defense
	[118] = "2330|A1|2447 765 3371",	-- Minor Healing Potion
	[3382] = "3170|A15|2447 2449:2 3371",	-- Weak Troll's Blood Potion
	[2455] = "2331|A25|785 765 3371",	-- Minor Mana Potion
	[2456] = "2332|A40|785:2 2447 3371",	-- Minor Rejuvenation Potion
	[4596] = "4508|A50|3164 2447 3371|4597",	-- Discolored Healing Potion
	[2457] = "3230|A50|2452 765 3371|2553",	-- Elixir of Minor Agility
	[2458] = "2334|A50|2449:2 2447 3371",	-- Elixir of Minor Fortitude
	[858] = "2337|A55|118 2450",	-- Lesser Healing Potion
	[5631] = "6617|A60|5635 2450 3371|5640",	-- Rage Potion
	[2459] = "2335|A60|2452 2450 3371|2555",	-- Swiftness Potion
	[6370] = "7836|A80|6358:2 3371",	-- Blackmouth Oil
	[6662] = "8240|A90|6522 2449 3371|6663",	-- Elixir of Giant Growth
	[5996] = "7179|A90|3820 6370:2 3371",	-- Elixir of Water Breathing
	[3383] = "3171|A90|785 2450:2 3371",	-- Elixir of Wisdom
	[6051] = "7255|A100|2453 2452 3371|6053",	-- Holy Protection Potion
	[6372] = "7841|A100|2452 6370 3371",	-- Swim Speed Potion
	[929] = "3447|A110|2453 2450 3372",	-- Healing Potion
	[3384] = "3172|A110|785:3 3355 3371|3393",	-- Minor Magic Resistance Potion
	[3385] = "3173|A120|785 3820 3371",	-- Lesser Mana Potion
	[1] = "3174|A120|1288 2453 3372|3394||3386",	-- Potion of Curing
	[3388] = "3176|A125|2453:2 2450:2 3372",	-- Strong Troll's Blood Potion
	[3389] = "3177|A130|3355 3820 3372",	-- Elixir of Defense
	[6371] = "7837|A130|6359:2 3371",	-- Fire Oil
	[6048] = "7256|A135|3369 3356 3372|6054",	-- Shadow Protection Potion
	[6373] = "7845|A140|6371:2 3356 3372",	-- Elixir of Firepower
	[3390] = "2333|A140|3355 2452 3372|3396",	-- Elixir of Lesser Agility
	[3391] = "3188|A150|2449 3356 3372|6211",	-- Elixir of Ogre's Strength
	[5634] = "6624|A150|6370:2 3820 3372|5642",	-- Free Action Potion
	[1710] = "7181|A155|3357 3356 3372",	-- Greater Healing Potion
	[3827] = "3452|A160|3820 3356 3372",	-- Mana Potion
	[3824] = "3449|A160|3818:4 3369:4 3372|6068",	-- Shadow Oil
	[6049] = "7257|A165|4402 6371 3372|6055",	-- Fire Protection Potion
	[3823] = "3448|A165|3818 3355 3372",	-- Lesser Invisibility Potion
	[3826] = "3451|A170|3357 2453 3372|3831",	-- Mighty Troll's Blood Potion
	[3825] = "3450|A175|3355 3821 3372|3830",	-- Elixir of Fortitude
	[5633] = "6618|A175|5637 3356 3372|5643",	-- Great Rage Potion
	[8949] = "11449|A185|3820 3821 3372",	-- Elixir of Agility
	[17708] = "21923|A190|3819:2 3358 3372|17709",	-- Elixir of Frost Power
	[3829] = "3454|A190|3358:4 3819:2 3372|14634",	-- Frost Oil
	[6050] = "7258|A190|3819 3821 3372|6056",	-- Frost Protection Potion
	[6052] = "7259|A190|3357 3820 3372|6057",	-- Nature Protection Potion
	[3828] = "3453|A195|3358 3818 3372|3832",	-- Elixir of Detect Lesser Invisibility
	[8951] = "11450|A195|3355 3821 3372",	-- Elixir of Greater Defense
	[9061] = "11456|A195|4625 9260 3372|10644",	-- Goblin Rocket Fuel
	[10592] = "12609|A200|3821 3818 3372",	-- Catseye Elixir
	[6149] = "11448|A205|3358 3821 3372",	-- Greater Mana Potion
	[8956] = "11451|A205|4625 3821 8925",	-- Oil of Immolation
	[2] = "11479|A225|3575|9304||3577",	-- Transmute: Iron to Gold
	[3] = "11480|A225|3860|9305||6037",	-- Transmute: Mithril to Truesilver
	[9036] = "11453|A210|3358 8831 8925|9293",	-- Magic Resistance Potion
	[9149] = "11459|A210|3575:4 9262 8831:4 4625:4|9303",	-- Philosopher's Stone
	[18294] = "22808|A215|7972 8831:2 8925",	-- Elixir of Greater Water Breathing
	[4623] = "4942|A215|3858 3821 3372|4624",	-- Lesser Stoneshield Potion
	[3928] = "11457|A215|8838 3358 8925",	-- Superior Healing Potion
	[9144] = "11458|A225|8153 8831 8925|9294",	-- Wildvine Potion
    [9030] = "11522|A285|7067 3821 8925", -- Restorative Potion, added 8/7/2007
	[12190] = "15833|A230|8831:3 8925",	-- Dreamless Sleep Potion
	[9154] = "11460|A230|8836 8925",	-- Elixir of Detect Undead
	[9210] = "11473|A230|8845:2 4342 8925|9302",	-- Ghost Dye
	[9155] = "11461|A235|8839 3821 8925",	-- Arcane Elixir
	[9179] = "11465|A235|8839 3358 8925",	-- Elixir of Greater Intellect
	[9264] = "11476|A235|8845:3 8925|9301",	-- Elixir of Shadow Power
	[9172] = "11464|A235|8845 8838 8925|9295",	-- Invisibility Potion
	[9197] = "11468|A240|8831:3 8925|9297",	-- Elixir of Dream Vision
	[9187] = "11467|A240|8838 3821 8925",	-- Elixir of Greater Agility
	[9088] = "11466|A240|8836 8839 8925|9296",	-- Gift of Arthas
	[9206] = "11472|A245|8838 8846 8925|9298",	-- Elixir of Giants
	[9224] = "11477|A250|8846 8845 8925|9300",	-- Elixir of Demonslaying
	[9233] = "11478|A250|8846:2 8925",	-- Elixir of Detect Demon
	[21546] = "26277|A250|6371:3 4625:3 8925|21547",	-- Elixir of Greater Firepower
	[3387] = "3175|A250|8839:2 8845 8925|3395",	-- Limited Invulnerability Potion
	[13423] = "17551|A250|13422 3372",	-- Stonescale Oil
	[13442] = "17552|A255|8846:3 8925|13476",	-- Mighty Rage Potion
	[13443] = "17553|A260|8838:2 8839:2 8925|13477",	-- Superior Mana Potion
	[13445] = "17554|A265|13423:2 8838 8925|13478",	-- Elixir of Superior Defense
	[13447] = "17555|A270|13463 13466:2 8925|13479",	-- Elixir of the Sages
	[4] = "17559|A275|7082|13482||7078",	-- Transmute: Air to Fire
	[5] = "17187|A275|12359 12363|12958||12360",	-- Transmute: Arcanite
	[6] = "17566|A275|7076|13489||12803",	-- Transmute: Earth to Life
	[7] = "17561|A275|7076|13484||7080",	-- Transmute: Earth to Water
	[8] = "17560|A275|7078|13483||7076",	-- Transmute: Fire to Earth
	[9] = "17565|A275|12803|13488||7076",	-- Transmute: Life to Earth
	[10] = "17563|A275|12808|13486||7080",	-- Transmute: Undeath to Water
	[11] = "17562|A275|7080|13485||7082",	-- Transmute: Water to Air
	[12] = "17564|A275|7080|13487||12808",	-- Transmute: Water to Undeath
	[13453] = "17557|A275|8846:2 13466:2 8925|13481",	-- Elixir of Brute Force
	[20002] = "24366|A275|13463:2 13464 8925|20012",	-- Greater Dreamless Sleep Potion
	[20007] = "24365|A275|13463 13466:2 8925|20011",	-- Mageblood Potion
	[13446] = "17556|A275|13464:2 13465 8925|13480",	-- Major Healing Potion
	[13452] = "17571|A280|13465:2 13466:2 8925|13491",	-- Elixir of the Mongoose
	[13455] = "17570|A280|13423:2 10620 8925|13490",	-- Greater Stoneshield Potion
	[13454] = "17573|A285|13463:3 13465 8925|13493",	-- Greater Arcane Elixir
	[20008] = "24367|A285|13467:2 13465:2 10286:2 8925|20013",	-- Living Action Potion
	[13462] = "17572|A285|13467:2 13466:2 8925|13492",	-- Purification Potion
	[9030] = "11452|A285|7067 3821 8925",	-- Restorative Potion
	[13461] = "17577|A290|11176 13463 8925|13497",	-- Greater Arcane Protection Potion
	[13457] = "17574|A290|7068 13463 8925|13494",	-- Greater Fire Protection Potion
	[13456] = "17575|A290|7070 13463 8925|13495",	-- Greater Frost Protection Potion
	[13458] = "17576|A290|7067 13463 8925|13496",	-- Greater Nature Protection Potion
	[13459] = "17578|A290|3824 13463 8925|13499",	-- Greater Shadow Protection Potion
	[20004] = "24368|A290|8846 13466:2 8925|20014",	-- Major Troll's Blood Potion
	[13444] = "17580|A295|13463:3 13467:2 8925|13501",	-- Major Mana Potion
	[19931] = "24266|A300|12938 19943 12804:6 13468||3",	-- Gurubashi Mojo Madness
	[28103] = "33740|A300|13463 22785 18256",	-- Adept's Elixir
	[13513] = "17638|A300|13467:7 13465:3 13468 8925|13522",	-- Flask of Chromatic Resistance
	[13511] = "17636|A300|13463:7 13467:3 13468 8925|13520",	-- Flask of Distilled Wisdom
	[13506] = "17634|A300|13423:7 13465:3 13468 8925|13518",	-- Flask of Petrification
	[13512] = "17637|A300|13463:7 13465:3 13468 8925|13521",	-- Flask of Supreme Power
	[13510] = "17635|A300|8846:7 13423:3 13468 8925|13519",	-- Flask of the Titans
	[18253] = "22732|A300|10286 13464:4 13463:4 18256|18257",	-- Major Rejuvenation Potion
	[28102] = "33738|A300|13465 22785 18256",	-- Onslaught Elixir
	[13] = "25146|A300|7077|20761|3|7068",	-- Transmute: Elemental Fire
	[28100] = "33732|A300|13464 22785 18256",	-- Volatile Healing Potion
	[22823] = "28543|A305|22787 22785 18256|22900",	-- Elixir of Camouflage
	[22824] = "28544|A305|13465 22785 18256",	-- Elixir of Major Strength
	[22825] = "28545|A310|13464 22786 18256",	-- Elixir of Healing Power
	[32062] = "39636|A310|22787:2 22785 18256",	-- Elixir of Major Fortitude
	[28101] = "33733|A310|22787:2 22785 18256",	-- Unstable Mana Potion
	[28104] = "33741|A315|22789:3 22785 18256",	-- Elixir of Mastery
	[22826] = "28546|A315|22787:2 22785 18256|22901",	-- Sneaking Potion
    [34440] = "45061|A315|22787:2 8925", -- Mad Alchemist's Potion
	[32063] = "39637|A320|22786 22787:2 18256|32070",	-- Earthen Elixir
	[32067] = "39638|A320|22785 22789 18256",	-- Elixir of Draenic Wisdom
	[22827] = "28549|A320|22578:2 22790 18256|22902",	-- Elixir of Major Frost Power
	[22828] = "28550|A320|22789:3 18256|22903",	-- Insane Strength Potion
	[31080] = "38070|A325|22452 21886 22457",	-- Mercurial Stone
	[22830] = "28552|A325|22787:2 22789 18256|22904",	-- Elixir of the Searching Eye
	[22829] = "28551|A325|22791:2 22785 18256",	-- Super Healing Potion
	[32068] = "39639|A330|22790 22787 18256|32071",	-- Elixir of Ironskin
	[22831] = "28553|A330|22789 22785:2 18256|22905",	-- Elixir of Major Agility
	[31679] = "38960|A335|22789 22792:2 18256|31680",	-- Fel Strength Elixir
	[22871] = "28554|A335|22787:3 22791 18256|22906",	-- Shrouding Potion
	[22832] = "28555|A340|22786:2 22785 18256|22907",	-- Super Mana Potion
	[22834] = "28557|A345|22790:3 22789 18256|22909",	-- Elixir of Major Defense
	[22833] = "28556|A345|22574:2 22790 18256|22908",	-- Elixir of Major Firepower
	[31676] = "38962|A345|22785:2 22792:3 18256|31681",	-- Fel Regeneration Potion
	[13503] = "17632|A350|9149 25867 25868 22794:2 23571:5|13517",	-- Alchemist's Stone
	[14] = "32765|A350|23079:3 23107:3 23112:3 22452:2 21885:2|25869||25867",	-- Transmute: Earthstorm Diamond
	[15] = "29688|A350|22452 21885 22451 21884 22457|23574||23571",	-- Transmute: Primal Might
	[16] = "32766|A350|23077:3 21929:3 23117:3 21884:2 22451:2|29232||25868",	-- Transmute: Skyfire Diamond
	[17] = "28566|A350|22451|22915||21884",	-- Transmute: Primal Air to Fire
	[18] = "28567|A350|22452|22916||21885",	-- Transmute: Primal Earth to Water
	[19] = "28568|A350|21884|30443||22452",	-- Transmute: Primal Fire to Earth
	[20] = "28569|A350|21885|22918||22451",	-- Transmute: Primal Water to Air
	[22839] = "28565|A350|22792:2 22791 18256|22914",	-- Destruction Potion
	[22835] = "28558|A350|22790 22792 18256|22910",	-- Elixir of Major Shadow Power
	[22838] = "28564|A350|22789:2 22791 18256|22913",	-- Haste Potion -- also 35295
	[22837] = "28563|A350|22789:2 22790 18256|22912",	-- Heroic Potion
	[22836] = "28562|A350|22786 22792 18256|22911",	-- Major Dreamless Sleep Potion
	[22840] = "28570|A355|22790 22791 18256|22919",	-- Elixir of Major Mageblood
	[31677] = "38961|A360|22793 22792:2 18256|31682",	-- Fel Mana Potion
	[21] = "28590|A360|22794 22793:3 22791:7 18256|||22861",	-- Flask of Blinding Light
	[22851] = "28587|A360|22794 22793:3 22790:7 18256",	-- Flask of Fortification
	[22853] = "28588|A360|22794 22793:3 22786:7 18256",	-- Flask of Mighty Restoration
	[22] = "28591|A360|22794 22793:3 22792:7 18256|||22866",	-- Flask of Pure Death
	[22854] = "28589|A360|22794 22793:3 22789:7 18256",	-- Flask of Relentless Assault
	[22845] = "28575|A360|22457 22793:3 18256:5|22923|5",	-- Major Arcane Protection Potion
	[22841] = "28571|A360|21884 22793:3 18256:5|22920|5",	-- Major Fire Protection Potion
	[22842] = "28572|A360|21885 22793:3 18256:5|22921|5",	-- Major Frost Protection Potion
	[22847] = "28577|A360|21886 22793:3 18256:5|22925|5",	-- Major Holy Protection Potion
	[22844] = "28573|A360|21886 22793:3 18256:5|22922|5",	-- Major Nature Protection Potion
	[22846] = "28576|A360|22456 22793:3 18256:5|22924|5",	-- Major Shadow Protection Potion
	[22850] = "28586|A360|22793:2 22786 22791 18256",	-- Super Rejuvenation Potion
	[22848] = "28578|A365|22791 22793 18256|22926",	-- Elixir of Empowerment -- also 35294
	[22849] = "28579|A365|22790:2 22573:3 18256|22927",	-- Ironshield Potion
	[23] = "28585|A375|22452|||21886",	-- Transmute: Primal Earth to Life
	[24] = "28583|A375|21884|||22457",	-- Transmute: Primal Fire to Mana
	[25] = "28584|A375|21886|||22452",	-- Transmute: Primal Life to Earth
	[26] = "28582|A375|22457|||21884",	-- Transmute: Primal Mana to Fire
	[27] = "28580|A375|22456|||21885",	-- Transmute: Primal Shadow to Water
	[28] = "28581|A375|21885|||22456",	-- Transmute: Primal Water to Shadow
	[32839] = "41458|A375|22457:2 22793:7 23782",	-- Cauldron of Major Arcane Protection
	[32849] = "41500|A375|21884:2 22793:7 23782",	-- Cauldron of Major Fire Protection
	[32850] = "41501|A375|21885:2 22793:7 23782",	-- Cauldron of Major Frost Protection
	[32851] = "41502|A375|21886:2 22793:7 23782",	-- Cauldron of Major Nature Protection
	[32852] = "41503|A375|22456:2 22793:7 23782",	-- Cauldron of Major Shadow Protection
    [33208] = "42736|A375|22786:7 22791:3 22794:1 18256:1|33209", --Flask of Chromatic Wonder
--[[ Blacksmithing --]]
	[2853] = "2663|B1|2840:2",	-- Copper Bracers
	[2852] = "2662|B1|2840:4",	-- Copper Chain Pants
	[10421] = "12260|B1|2840:4",	-- Rough Copper Vest
	[2862] = "2660|B1|2835",	-- Rough Sharpening Stone
	[3239] = "3115|B1|2835 2589",	-- Rough Weightstone
	[2844] = "2737|B15|2840:6 2880 2589:2",	-- Copper Mace
	[2845] = "2738|B20|2840:6 2880 2589:2",	-- Copper Axe
	[3469] = "3319|B20|2840:8",	-- Copper Chain Boots
	[2847] = "2739|B25|2840:6 2880 2589:2",	-- Copper Shortsword
	[3470] = "3320|B25|2835:2",	-- Rough Grinding Stone
	[7955] = "9983|B30|2840:10 2880:2 3470 2318",	-- Copper Claymore
	[7166] = "8880|B30|2840:6 2880 3470 2318",	-- Copper Dagger
    [33791] = "43549|B35|2840:10 818:1 3470:2|33792", -- Heavy Copper Longsword
	[3488] = "3293|B35|2840:12 2880:2 774:2 3470:2 2318:2",	-- Copper Battle Axe
	[3471] = "3321|B35|2840:8 3470:2|3609",	-- Copper Chain Vest
	[2851] = "2661|B35|2840:6",	-- Copper Chain Belt
	[3472] = "3323|B40|2840:8 3470:2",	-- Runed Copper Gauntlets
	[3473] = "3324|B45|2840:8 2321:2 3470:3",	-- Runed Copper Pants
	[3474] = "3325|B60|2840:8 818 774|3610",	-- Gemmed Copper Gauntlets
	[2863] = "2665|B65|2836",	-- Coarse Sharpening Stone
	[3240] = "3116|B65|2836 2592",	-- Coarse Weightstone
	[6214] = "7408|B65|2840:12 2880:2 2318:2",	-- Heavy Copper Maul
	[3489] = "3294|B70|2840:10 2880:2 2842:2 3470:2 2318:2",	-- Thick War Axe
	[2857] = "2666|B70|2840:10",	-- Runed Copper Belt
	[3478] = "3326|B75|2836:2",	-- Coarse Grinding Stone
	[2864] = "2667|B80|2840:12 1210 3470:2|2881",	-- Runed Copper Breastplate
	[2854] = "2664|B90|2840:10 3470:3",	-- Runed Copper Bracers
	[3487] = "3292|B95|2840:14 2880:2 818:2 2319:2",	-- Heavy Copper Broadsword
	[6350] = "7817|B95|2841:6 3470:6",	-- Rough Bronze Boots
	[6731] = "8367|B100|2840:16 818:2 3470:3|6735",	-- Ironforge Breastplate
	[15869] = "19666|B100|2842 3470||2",	-- Silver Skeleton Key
	[29201] = "34979|B100|2841:6 3470:2 2319",	-- Thick Bronze Darts
	[6338] = "7818|B100|2842 3470:2",	-- Silver Rod
	[3848] = "3491|B105|2841:6 2880:4 3470:2 818 2319",	-- Big Bronze Knife
	[2865] = "2668|B105|2841:6",	-- Rough Bronze Leggings
	[2866] = "2670|B105|2841:7",	-- Rough Bronze Cuirass
	[2848] = "2740|B110|2841:6 2880:4 2319",	-- Bronze Mace
	[3480] = "3328|B110|2841:5 3478",	-- Rough Bronze Shoulders
	[5540] = "6517|B115|2841:6 3466 5498:2 3478:2",	-- Pearl-handled Dagger
	[2849] = "2741|B115|2841:7 2880:4 2319",	-- Bronze Axe
	[2868] = "2672|B120|2841:5 3478:2",	-- Patterned Bronze Bracers
	[2850] = "2742|B120|2841:5 2880:4 2319:2",	-- Bronze Shortsword
	[3490] = "3295|B125|2841:4 3466 2459 1210:2 3478:2 2319:2|2883",	-- Deadly Bronze Poniard
	[3481] = "3330|B125|2841:8 2842:2 3478:2|2882",	-- Silvered Bronze Shoulders
	[7956] = "9985|B125|2841:8 3466 2319",	-- Bronze Warhammer
	[3486] = "3337|B125|2838:3",	-- Heavy Grinding Stone
	[2871] = "2674|B125|2838",	-- Heavy Sharpening Stone
	[3241] = "3117|B125|2838 2592",	-- Heavy Weightstone
	[3491] = "3296|B130|2841:8 3466 1206 1210 3478:2 2319:2",	-- Heavy Bronze Mace
	[3482] = "3331|B130|2841:6 2842 3478:2",	-- Silvered Bronze Boots
	[2869] = "2673|B130|2841:10 2842:2 3478:2|5578",	-- Silvered Bronze Breastplate
	[7957] = "9986|B130|2841:12 3466:2 2319:2",	-- Bronze Greatsword
	[3483] = "3333|B135|2841:8 2842 3478:2",	-- Silvered Bronze Gauntlets
	[7958] = "9987|B135|2841:14 3466 2319:2",	-- Bronze Battle Axe
	[5541] = "6518|B140|2841:10 3466 5500 3478:2 2319:2|5543",	-- Iridescent Hammer
	[2870] = "2675|B145|2841:20 1206:2 1705:2 5500:2 2842:4",	-- Shining Silver Breastplate
	[3484] = "3334|B145|3575:6 3478:2 2605|3611",	-- Green Iron Boots
	[3492] = "3297|B145|3575:6 3466:2 3391 1705:2 3478:2 2319:2|3608",	-- Mighty Iron Hammer
	[15870] = "19667|B150|3577 3486||2",	-- Golden Skeleton Key
	[3485] = "3336|B150|3575:4 5498:2 3478:2 2605|3612",	-- Green Iron Gauntlets
	[3851] = "3494|B150|3575:8 3466:2 3486 2842:4 4234:2|10858",	-- Solid Iron Maul
	[11128] = "14379|B150|3577 3478:2",	-- Golden Rod
	[7071] = "8768|B150|3575||2",	-- Iron Buckle
	[6042] = "7221|B150|3575:6 3478:4|6044",	-- Iron Shield Spike
	[7914] = "9813|B155|3575:20 3486:4|7979",	-- Barbaric Iron Breastplate
	[3842] = "3506|B155|3575:8 3486 2605",	-- Green Iron Leggings
	[3849] = "3492|B155|3575:6 3466:2 3486 1705:2 4234:3|12162",	-- Hardened Iron Shortsword
	[10423] = "12259|B155|2841:12 2842:4 3478:2|10424",	-- Silvered Bronze Leggings
	[7913] = "9811|B160|3575:8 5635:4 3486:2|7978",	-- Barbaric Iron Shoulders
	[3840] = "3504|B160|3575:7 3486 2605|3870",	-- Green Iron Shoulders
	[3835] = "3501|B165|3575:6 2605",	-- Green Iron Bracers
	[6043] = "7222|B165|3575:4 3478:2 1705|6045",	-- Iron Counterweight
	[3852] = "3495|B170|3575:10 3577:4 1705:2 3466:2 4234:2 3486:2|3867",	-- Golden Iron Destroyer
	[3843] = "3507|B170|3575:10 3577:2 3486|3872",	-- Golden Scale Leggings
	[3836] = "3502|B170|3575:12 3864 2605",	-- Green Iron Helm
	[7915] = "9814|B175|3575:10 5637:2 5635:2|7980",	-- Barbaric Iron Helm
	[3841] = "3505|B175|3859:6 3577:2 3486|3871",	-- Golden Scale Shoulders
	[3850] = "3493|B175|3575:8 3466:2 3486:2 1529:2 4234:3|3866",	-- Jade Serpentblade
	[3853] = "3496|B175|3859:8 3466:2 3486:2 1705:3 4234:3|12163",	-- Moonsteel Broadsword
	[3844] = "3508|B180|3575:20 3486:4 1529:2 1206:2 4255",	-- Green Iron Hauberk
	[7916] = "9818|B180|3575:12 5637:4 3486:2|7981",	-- Barbaric Iron Boots
	[12259] = "15972|B180|3859:10 3466:2 1206 7067 4234",	-- Glinting Steel Dagger
	[3855] = "3498|B180|3575:14 3466:2 3486:2 3577:4 4234:2|12164",	-- Massive Iron Axe
	[7917] = "9820|B185|3575:14 3486:3 5637:2|7982",	-- Barbaric Iron Gloves
	[3846] = "3513|B185|3859:8 3864 1705 3486:2|3874",	-- Polished Steel Boots
	[6040] = "7223|B185|3859:5 3486:2",	-- Golden Scale Bracers
	[17704] = "21913|B190|3859:10 3829 7070:2 7069:2 4234:2|17706",	-- Edge of Winter
	[3837] = "3503|B190|3859:8 3577:2 3486:2|6047",	-- Golden Scale Coif
	[12260] = "15973|B190|3859:10 3577:4 7068:2 4234:2|12261",	-- Searing Golden Blade
	[6041] = "7224|B190|3859:8 3486:2 4234:4|6046",	-- Steel Weapon Chain
	[3845] = "3511|B195|3859:12 3577:2 3486:4|3873",	-- Golden Scale Cuirass
	[3854] = "3497|B200|3859:8 3466:2 3486:2 1529:2 3829 4234:4|3868",	-- Frost Tiger Blade
	[3847] = "3515|B200|3859:10 3577:4 3486:4|3875",	-- Golden Scale Boots
	[3856] = "3500|B200|3859:10 3466:2 3486:3 3864:2 3824 4234:3|3869",	-- Shadow Crescent Axe
	[7963] = "9916|B200|3859:16 3486:3",	-- Steel Breastplate
	[15871] = "19668|B200|6037 7966||2",	-- Truesilver Skeleton Key
	[29202] = "34981|B200|3859:5 7069:2 3486:2 4234",	-- Whirling Steel Axes
	[9060] = "11454|B200|3860:5 3577 6037|10713",	-- Inlaid Mithril Cylinder
	[7966] = "9920|B200|7912:4",	-- Solid Grinding Stone
	[7964] = "9918|B200|7912",	-- Solid Sharpening Stone
	[7965] = "9921|B200|7912 4306",	-- Solid Weightstone
	[11144] = "14380|B200|6037 3486",	-- Truesilver Rod
	[9366] = "11643|B205|3859:10 3577:4 3486:4|9367",	-- Golden Scale Gauntlets
	[7919] = "9928|B205|3860:6 4338:4",	-- Heavy Mithril Gauntlet
	[7918] = "9926|B205|3860:8 4234:6",	-- Heavy Mithril Shoulder
	[7941] = "9993|B210|3860:12 3864:2 7966 4234:4",	-- Heavy Mithril Axe
	[7921] = "9933|B210|3860:10|7975",	-- Heavy Mithril Pants
	[7920] = "9931|B210|3860:12",	-- Mithril Scale Pants
	[7924] = "9937|B215|3860:8|7995",	-- Mithril Scale Bracers
	[7967] = "9939|B215|3860:4 6037:2 7966:4|7976",	-- Mithril Shield Spike
	[7922] = "9935|B215|3859:14 7966",	-- Steel Plate Helm
	[7942] = "9995|B220|3860:16 7909:2 7966 4304:4|7992",	-- Blue Glittering Axe
	[7927] = "9950|B220|3860:10 4338:6 6037 7966|7984",	-- Ornate Mithril Gloves
	[7926] = "9945|B220|3860:12 6037 7966|7983",	-- Ornate Mithril Pants
	[7936] = "9979|B220|3860:14 6037:2 4304:4 7966 7909",	-- Ornate Mithril Boots
	[7935] = "9972|B220|3860:16 6037:6 7077 7966",	-- Ornate Mithril Breastplate
	[7937] = "9980|B220|3860:16 6037:2 7966",	-- Ornate Mithril Helm
	[7938] = "9954|B225|3860:10 6037:8 7909:3 3864:3 5966 7966:2",	-- Truesilver Gauntlets, removed armorsmith requirement
	[7928] = "9952|B225|3860:12 6037 4304:6|7985",	-- Ornate Mithril Shoulder
	[7943] = "9997|B225|3860:14 6037:4 7966 4304:2|8029",	-- Wicked Mithril Blade
	[7945] = "10001|B230|3860:16 7971 1210:4 7966 4304:2",	-- Big Black Mace
	[7930] = "9959|B230|3860:16",	-- Heavy Mithril Breastplate
	[7931] = "9961|B230|3860:10 4338:6",	-- Mithril Coif
	[7933] = "9968|B235|3860:14 4304:4",	-- Heavy Mithril Boots
	[7932] = "9966|B235|3860:14 4304:4|7991",	-- Mithril Scale Shoulders
	[7954] = "10003|B235|3860:24 7075:4 6037:6 3864:5 1529:5 7966:4 4304:4",	-- The Shatterer, removed weaponsmith requirement
	[7969] = "9964|B235|3860:4 7966:3|7989",	-- Mithril Spurs
	[7944] = "10005|B240|3860:14 7909 1705:2 1206:2 7966 4338:2|7993",	-- Dazzling Mithril Rapier
	[7934] = "9970|B245|3860:14 7909|7990",	-- Heavy Mithril Helm
	[7946] = "10009|B245|3860:18 7075:2 7966 4304:4|8028",	-- Runed Mithril Hammer
	[7939] = "9974|B245|3860:12 6037:12 7910:2 7971:2 7966:2",	-- Truesilver Breastplate, removed armorsmith requirement
	[7961] = "10007|B245|3860:28 7081:6 6037:8 3823:2 7909:6 7966:4 4304:2",	-- Phantom Blade, removed weaponsmith requirement
	[7959] = "10011|B250|3860:28 7972:10 6037:10 7966:6 4304:6",	-- Blight, removed weaponsmith requirement
	[12405] = "16642|B250|12359:16 12361 11188:4|12682",	-- Thorium Armor
	[12406] = "16643|B250|12359:12 11186:4|12683",	-- Thorium Belt
	[12644] = "16639|B250|12365:4",	-- Dense Grinding Stone
	[12404] = "16641|B250|12365",	-- Dense Sharpening Stone
	[12643] = "16640|B250|12365 14047",	-- Dense Weightstone
	[7947] = "10013|B255|3860:12 6037:6 7910:2 7966 4304:2|8030",	-- Ebon Shiv
	[12408] = "16644|B255|12359:12 11184:4|12684",	-- Thorium Bracers
	[11606] = "15293|B260|11371:10 7077:2|11614",	-- Dark Iron Mail
	[7960] = "10015|B260|3860:30 6037:16 7910:6 7081:4 7966:8 4304:6",	-- Truesilver Champion, removed armorsmith requirement
	[12416] = "16645|B260|12359:10 7077:2|12685",	-- Radiant Belt
	[11608] = "15292|B265|11371:18 7077:4|11610",	-- Dark Iron Pulverizer
	[12424] = "16647|B265|12359:10 8170:6|12688",	-- Imperial Plate Belt
	[12428] = "16646|B265|12359:12 8170:6|12687",	-- Imperial Plate Shoulders
	[12624] = "16650|B270|12359:40 12655:2 12803:4 8153:4 12364|12691",	-- Wildthorn Mail
	[11605] = "15295|B270|11371:6 7077|11615",	-- Dark Iron Shoulders
	[12425] = "16649|B270|12359:12|12690",	-- Imperial Plate Bracers
	[12415] = "16648|B270|12359:18 7077:2 7910|12689",	-- Radiant Breastplate
	[11607] = "15294|B275|11371:26 7077:4|11611",	-- Dark Iron Sunderer
	[12774] = "16970|B275|12359:30 12655:4 7910:4 12361:4 12644:2 8170:4|12821",	-- Dawn's Edge
	[15872] = "19669|B275|12360 12644||2",	-- Arcanite Skeleton Key
	[12773] = "16969|B275|12359:20 12799:2 12644:2 8170:4|12819",	-- Ornate Thorium Handaxe
	[12645] = "16651|B275|12359:4 12644:4 7076:2|12692",	-- Thorium Shield Spike
	[16206] = "20201|B275|12360:3 12644",	-- Arcanite Rod
	[12777] = "16978|B280|12655:10 7078:4 7077:4 12800:2 12644:2|12825",	-- Blazing Rapier
	[12776] = "16973|B280|12359:20 12655:6 12364:2 12804:4 8170:4|12824",	-- Enchanted Battlehammer
	[12775] = "16971|B280|12359:40 12644:6 8170:6|12823",	-- Huge Thorium Battleaxe
	[12409] = "16652|B280|12359:20 8170:8 11185:4|12693",	-- Thorium Boots
	[12410] = "16653|B280|12359:24 7910 11188:4|12694",	-- Thorium Helm
	[11604] = "15296|B285|11371:20 7077:8|11612",	-- Dark Iron Plate
	[12628] = "16667|B285|12359:40 12662:10 12361:4 7910:4|12696",	-- Demon Forged Breastplate
	[12781] = "16983|B285|12655:6 12360:2 12804:4 12799:2 12361:2 12364|12827",	-- Serenity
	[12418] = "16654|B285|12359:18 7077:4|12695",	-- Radiant Gloves
	[12782] = "16985|B290|12359:40 12360:2 12662:16 12808:8 12361:2 12644:2 8170:4|12830",	-- Corruption
	[12631] = "16655|B290|12359:20 12655:6 7078:2 7910:4|12699",	-- Fiery Plate Gauntlets
	[19051] = "23632|B290|12359:8 6037:6 12811|19203",	-- Girdle of the Dawn
	[19043] = "23628|B290|12359:12 7076:3 12803:3|19202",	-- Heavy Timbermaw Belt
	[12419] = "16656|B290|12359:14 7077:4|12697",	-- Radiant Boots
	[12792] = "16984|B290|12359:30 7077:4 7910:4 8170:4|12828",	-- Volcanic Hammer
	[17014] = "20874|B295|11371:4 17010:2 17011:2|17051",	-- Dark Iron Bracers
	[16989] = "20872|B295|11371:6 17010:3 17011:3|17049",	-- Fiery Chain Girdle
	[17193] = "21161|B295|17203:8 11371:20 12360:50 7078:25 11382:10 17011:10 17010:10|18592",	-- Sulfuron Hammer
	[12632] = "16661|B295|12359:20 12655:4 7080:4 12361:4|12703",	-- Storm Gauntlets
	[12426] = "16657|B295|12359:18|12700",	-- Imperial Plate Boots
	[12427] = "16658|B295|12359:18 7910|12701",	-- Imperial Plate Helm
	[12417] = "16659|B295|12359:18 7077:4|12702",	-- Radiant Circlet
	[19166] = "23638|B300|17011:3 17010:6 12360:12 11382 11371:4|19208",	-- Black Amnesty
	[22194] = "27589|B300|22203:8 22202:24 12810:8 13512|22220",	-- Black Grasp of the Destroyer
	[19167] = "23639|B300|17011:5 17010:2 12360:16 11371:6|19209",	-- Blackfury
	[19168] = "23652|B300|17011:6 17010:6 12360:10 11371:6 12809:12|19211",	-- Blackguard
	[20039] = "24399|B300|17011:3 17010:3 17012:4 11371:6|20040",	-- Dark Iron Boots
	[19164] = "23637|B300|17011:3 17010:5 17012:4 11371:4 11382:2|19207",	-- Dark Iron Gauntlets
	[19148] = "23636|B300|17011:4 17010:2 11371:4|19206",	-- Dark Iron Helm
	[17013] = "20876|B300|11371:16 17010:4 17011:6|17052",	-- Dark Iron Leggings
	[19170] = "23650|B300|17011:4 17010:7 12360:12 11371:8 12800:4|19210",	-- Ebon Hand
	[16988] = "20873|B300|11371:16 17010:4 17011:5|17053",	-- Fiery Chain Shoulders
	[22671] = "28244|B300|22682:4 12359:12 12360:2 7080:2",	-- Icebane Bracers
	[22669] = "28242|B300|22682:7 12359:16 12360:2 7080:4",	-- Icebane Breastplate
	[22670] = "28243|B300|22682:5 12359:12 12360:2 7080:2",	-- Icebane Gauntlets
	[12641] = "16746|B300|12360:30 12655:30 12364:6 12800:6|12728",	-- Invulnerable Mail
	[22198] = "27586|B300|22203:8 22202:24 12655:8 7076:4|22219",	-- Jagged Obsidian Shield
	[12640] = "16729|B300|12359:80 12360:12 8146:40 12361:10 12800:4|12717",	-- Lionheart Helm
	[19169] = "23653|B300|17011:8 17010:5 12360:10 11371:12 12364:4|19212",	-- Nightfall
	[22191] = "27590|B300|22203:15 22202:36 12810:12 12809:10 12800:4|22221",	-- Obsidian Mail Tunic
	[22384] = "27830|B300|12360:15 11371:10 12808:20 20520:20 15417:10 12753:2|22390",	-- Persuader
	[22383] = "27832|B300|12360:12 20725:2 13512:2 12810:4|22389",	-- Sageblade
	[12639] = "16741|B300|12360:15 12655:20 7076:10 12361:4 12799:4|12720",	-- Stronghold Gauntlets
	[22196] = "27587|B300|22203:18 22202:40 12655:12 7076:10 12364:4|22222",	-- Thick Obsidian Breastplate
	[22385] = "27829|B300|12360:12 12655:20 7076:10 13510:2|22388",	-- Titanic Leggings
	[12798] = "16991|B300|12359:40 12360:12 12808:10 12364:8 12644:2 12810:4|12835",	-- Annihilator
	[12790] = "16990|B300|12360:15 12800:8 12811 12799:4 12810:8 12644:2|12834",	-- Arcanite Champion
	[12784] = "16994|B300|12360:20 12810:6 12644:2|12838",	-- Arcanite Reaper
	[19690] = "24136|B300|12359:20 19774:10 19726:2 7910:2|19776",	-- Bloodsoul Breastplate
	[19692] = "24138|B300|12359:12 19774:6 19726:2 12810:4|19778",	-- Bloodsoul Gauntlets
	[19691] = "24137|B300|12359:16 19774:8 19726:2 7910|19777",	-- Bloodsoul Shoulders
	[17016] = "20897|B300|11371:18 17011:12 11382:2 12810:2|17060",	-- Dark Iron Destroyer
	[17015] = "20890|B300|11371:16 17010:12 11382:2 12810:2|17059",	-- Dark Iron Reaver
	[20550] = "24914|B300|12359:20 20520:10 6037:10|20554",	-- Darkrune Breastplate
	[20549] = "24912|B300|12359:12 20520:6 6037:6 12810:2|20553",	-- Darkrune Gauntlets
	[20551] = "24913|B300|12359:16 20520:8 6037:8 11754|20555",	-- Darkrune Helm
	[19693] = "24139|B300|12359:20 19774:14 12799:2|19779",	-- Darksoul Breastplate
	[19694] = "24140|B300|12359:18 19774:12 12799:2|19780",	-- Darksoul Leggings
	[19695] = "24141|B300|12359:16 19774:10 12799|19781",	-- Darksoul Shoulders
	[12618] = "16745|B300|12360:8 12655:24 7076:4 7080:4 12364:2 12800:2|12727",	-- Enchanted Thorium Breastplate
	[12620] = "16742|B300|12360:6 12655:16 7076:6 12799:2 12800|12725",	-- Enchanted Thorium Helm
	[12619] = "16744|B300|12360:10 12655:20 7080:6 12361:2 12364|12726",	-- Enchanted Thorium Leggings
	[12797] = "16992|B300|12360:18 12361:8 12800:8 7080:4 12644:2 12810:4|12836",	-- Frostguard
	[19057] = "23633|B300|12360:2 6037:10 12811|19205",	-- Gloves of the Dawn
	[12796] = "16988|B300|12359:50 12360:15 12809:4 12810:6 7076:10|12833",	-- Hammer of the Titans
	[12783] = "16995|B300|12360:10 12655:10 12810:2 7910:6 12800:6 12799:6 12644:4|12839",	-- Heartseeker
	[22197] = "27585|B300|22202:14 12655:4 7076:2|22209",	-- Heavy Obsidian Belt
	[19048] = "23629|B300|12360:4 7076:6 12803:6|19204",	-- Heavy Timbermaw Boots
	[12636] = "16728|B300|12359:40 12655:4 8168:60 12799:6 12364:2|12716",	-- Helm of the Great Chief
	[22764] = "28463|B300|12655:6 12803:2|22768",	-- Ironvine Belt
	[22762] = "28461|B300|12655:12 19726:2 12360:2 12803:2|22766",	-- Ironvine Breastplate
	[22763] = "28462|B300|12655:8 19726 12803:2|22767",	-- Ironvine Gloves
	[22195] = "27588|B300|22202:14 12810:4|22214",	-- Light Obsidian Belt
	[12794] = "16993|B300|12655:20 12364:8 12799:8 7076:6 12810:4|12837",	-- Masterwork Stormhammer
	[12633] = "16724|B300|12359:20 12655:4 6037:6 3577:6 12800:2|12711",	-- Whitesoul Helm
	[18262] = "22757|B300|7067:2 12365:3|18264",	-- Elemental Sharpening Stone
	[29203] = "34982|B300|12655:2 12359:6 8170",	-- Enchanted Thorium Blades
	[23493] = "29551|B300|23445:4",	-- Fel Iron Chain Coif
	[23482] = "29545|B300|23445:4",	-- Fel Iron Plate Gloves
	[12422] = "16663|B300|12359:20|12705",	-- Imperial Plate Chest
	[12429] = "16730|B300|12359:24|12715",	-- Imperial Plate Leggings
	[12420] = "16725|B300|12359:20 7077:4|12713",	-- Radiant Leggings
	[12613] = "16731|B300|12359:40 12360:2 7910|12718",	-- Runic Breastplate
	[12611] = "16665|B300|12359:20 12360:2 2842:10|12707",	-- Runic Plate Boots
	[12612] = "16726|B300|12359:30 12360:2 6037:2 12364|12714",	-- Runic Plate Helm
	[12614] = "16732|B300|12359:40 12360:2 7910|12719",	-- Runic Plate Leggings
	[12610] = "16664|B300|12359:20 12360:2 3577:6|12706",	-- Runic Plate Shoulders
	[12414] = "16662|B300|12359:26 11186:4|12704",	-- Thorium Leggings
	[25843] = "32655|B300|23445:6",	-- Fel Iron Rod
	[23528] = "29654|B300|23445 22573",	-- Fel Sharpening Stone
	[28420] = "34607|B300|23445 21877",	-- Fel Weightstone
	[23484] = "29547|B305|23445:4",	-- Fel Iron Plate Belt
	[23491] = "29552|B310|23445:5",	-- Fel Iron Chain Gloves
	[23497] = "29557|B310|23445:9",	-- Fel Iron Hatchet
	[23494] = "29553|B315|23445:6",	-- Fel Iron Chain Bracers
	[23498] = "29558|B315|23445:10",	-- Fel Iron Hammer
	[23487] = "29548|B315|23445:6",	-- Fel Iron Plate Boots
	[23488] = "29549|B315|23445:8",	-- Fel Iron Plate Pants
	[23490] = "29556|B320|23445:9",	-- Fel Iron Chain Tunic
	[23499] = "29565|B320|23445:12",	-- Fel Iron Greatsword
	[23502] = "29566|B325|23446:8|23590",	-- Adamantite Maul
	[23489] = "29550|B325|23445:10",	-- Fel Iron Breastplate
	[23559] = "32284|B325|23446",	-- Lesser Rune of Warding
	[23503] = "29568|B330|23446:8|23591",	-- Adamantite Cleaver
	[23504] = "29569|B330|23446:7 21887:2|23592",	-- Adamantite Dagger
    [33185] = "42688|B335|23573:2 23449|33186", -- Adamantite Weapon Chain -- also 35296
	[23506] = "29603|B335|23446:6 22452:2 21884:2|23594",	-- Adamantite Plate Bracers
	[23508] = "29605|B335|23446:8 21887:2 22452:3 21884:2|23595",	-- Adamantite Plate Gloves
	[23505] = "29571|B335|23446:12|23593",	-- Adamantite Rapier
	[23507] = "29606|B340|23446:12 22452:4 21884:2|23596",	-- Adamantite Breastplate
	[23575] = "29728|B340|23446|23638||23575",	-- Lesser Ward of Shielding
	[29204] = "34983|B350|23448:6 22451:2 21884:2 23793",	-- Felsteel Whisper Knives
	[23515] = "29614|B350|23445:6 21885:3 21884:2|23601",	-- Flamebane Bracers
	[23529] = "29656|B350|23446 22573:2|23618",	-- Adamantite Sharpening Stone
	[28421] = "34608|B350|23446 21877:2|28632",	-- Adamantite Weightstone
	[25844] = "32656|B350|23446:10|25846",	-- Adamantite Rod
	[25521] = "32285|B350|23449|25526",	-- Greater Rune of Warding
	[23510] = "29608|B355|23573:2 22445:8 22449:2|23597",	-- Enchanted Adamantite Belt
	[23511] = "29611|B355|23573:3 22445:12 22449:2|23598",	-- Enchanted Adamantite Boots
	[23516] = "29615|B355|23445:12 21885:5 21884:3|23602",	-- Flamebane Helm
	[23509] = "29610|B360|23573:4 22445:20 22449:4|23599",	-- Enchanted Adamantite Breastplate
	[23517] = "29619|B360|23448:6|23605",	-- Felsteel Gloves
	[23518] = "29620|B360|23448:8|23606",	-- Felsteel Leggings
	[23514] = "29616|B360|23445:8 21885:4 21884:4|23603",	-- Flamebane Gloves
	[23524] = "29628|B360|23449:3 21885:2 22457:2|23608",	-- Khorium Belt
	[23523] = "29629|B360|23449:6 21885:4 22457:4|23609",	-- Khorium Pants
	[23530] = "29657|B360|23448:4 21884:4 22452:4|24002",	-- Felsteel Shield Spike
	[23537] = "29669|B365|23448:6 22456:15 23572|23626",	-- Black Felsteel Bracers
	[23539] = "29672|B365|23573:6 23571:2 21885:15 23572|23628",	-- Blessed Bracers
	[23538] = "29671|B365|23573:6 21886:20 23572|23627",	-- Bracers of the Green Fortress
	[23555] = "29699|B365|23449:10 23448:10 23571:8 23572:2|23636",	-- Dirge
	[23554] = "29698|B365|23449:10 23573:4 23447:10 23571:8 23572:2|23635",	-- Eternium Runed Blade
	[23542] = "29694|B365|23449:10 23448:10 23571:8 23572:2|23631",	-- Fel Edged Battleaxe
	[23546] = "29697|B365|23449:10 23448:10 23571:8 23572:2|23634",	-- Fel Hardened Maul
	[23531] = "29658|B365|23448:10 23571:3 23572|23620",	-- Felfury Gauntlets
	[23540] = "29692|B365|23449:10 23448:10 23571:6 23572:2|23629",	-- Felsteel Longblade
	[23543] = "29695|B365|23449:10 23448:10 23571:8 23572:2|23632",	-- Felsteel Reaper
	[23532] = "29622|B365|23573:10 23571:2 22452:15 23572|23621",	-- Gauntlets of the Iron Tower
	[23556] = "29700|B365|23449:10 23573:4 23447:10 23571:8 23572:4|23637",	-- Hand of Eternity
	[23535] = "29664|B365|23573:8 22452:22 22457:12 23572|23624",	-- Helm of the Stalwart Defender
	[23541] = "29693|B365|23449:20 23573:2 23571:6 23572:2|23630",	-- Khorium Champion
	[23536] = "29668|B365|23573:8 23571:3 21886:18 23572|23625",	-- Oathkeeper's Helm
	[23544] = "29696|B365|23449:10 23448:10 23571:8 23572:2|23633",	-- Runic Hammer
	[23533] = "29662|B365|23448:10 23571:5 23572|23622",	-- Steelgrip Gauntlets
	[23534] = "29663|B365|23573:8 22451:16 21885:16 23572|23623",	-- Storm Helm
	[23512] = "29613|B365|23573:4 22445:24 22449:4|23600",	-- Enchanted Adamantite Leggings
	[23519] = "29621|B365|23448:8|23607",	-- Felsteel Helm
	[23513] = "29617|B365|23445:16 21885:6 21884:4|23604",	-- Flamebane Breastplate
	[23525] = "29630|B365|23449:4 21885:3 22457:3|23610",	-- Khorium Boots
	[23520] = "29642|B365|23445:8 21884:6 23449:3 22824:2|23611",	-- Ragesteel Gloves
	[23521] = "29643|B365|23445:10 21884:10 23449:4 22824:4|23612",	-- Ragesteel Helm
    [33173] = '42662|B365|23445:12 21884:2 23449:8 27503:2|33174||33173', --Ragesteel Shoulders
    [32854] = "43846|B365|23449:16 23448:12 23571:6 23572:2|33954", -- Hammer of Righteous Might
	[23527] = "29649|B370|23573:4 21886:6 22452:4|23617",	-- Earthpeace Breastplate
	[23522] = "29645|B370|23445:12 21884:10 23449:6 22824:4|23613",	-- Ragesteel Breastplate
	[31369] = "38477|B375|23449:8 21885:12 21884:12 23572|31393",	-- Iceguard Breastplate
	[31371] = "38479|B375|23449:8 21885:12 21884:12 23572|31395",	-- Iceguard Helm
	[31370] = "38478|B375|23449:8 21885:12 21884:12 23572|31394",	-- Iceguard Leggings
	[31364] = "38473|B375|23448:8 21886:12 22456:12 23572|31390",	-- Wildguard Breastplate
	[31368] = "38476|B375|23448:8 21886:12 22456:12 23572|31392",	-- Wildguard Helm
	[31367] = "38475|B375|23448:8 21886:12 22456:12 23572|31391",	-- Wildguard Leggings
	[25845] = "32657|B375|23447:4|25847",	-- Eternium Rod
	[23576] = "29729|B375|23447|23639||23576",	-- Greater Ward of Shielding
    [30034] = '36389|B375|30183:2 23573:5 21885:10 22452:5|30321', --Belt of the Guardian
    [30033] = '36391|B375|23572:2 23573:12 21885:5|30323', -- Boots of the Protector
    [30032] = '36390|B375|30183:2 23573:5 21884:10|30322', -- Red Belt of Battle
    [30031] = '36392|B375|23572:2 23573:4 21884:12|30324', -- Red Havok Boots
    [32573] = '41135|B375|23449:18 23573:2 21884:8 32428:2|32739', --Dawnsteel Shoulders -- also 35530
    [32568] = '41132|B375|23448:14 23573:2 22451:6 32428:4|32736', --Swiftsteel Bracers -- also 35531
    [32571] = '41134|B375|23449:14 23573:2 21884:2 32428:4|32738', --Dawnsteel Bracers -- also 35529
    [32570] = '41133|B375|23448:18 23573:2 22451:8 32428:2|32737', --Swiftsteel Shoulders -- also 35532
    [32403] = '40034|B375|32428:1 22450:1 21886:2 22456:2 23446:4|32442', --Shadesteel Bracers
    [32401] = '40036|B375|32428:2 22450:1 21886:3 22456:4 23446:8|32444', --Shadesteel Girdle
    [32404] = '40035|B375|32428:3 22450:1 21886:4 22456:6 23446:12|32443', --Shadesteel Greaves
    [32402] = '40033|B375|32428:2 22450:1 21886:2 22456:4 23446:4|32442', --Shadesteel Sabots
--[[ blacksmithing specialty --]]
	[30069] = "36122|Ba260|3860:16 7075:2",	-- Earthforged Leggings
	[30070] = "36124|Ba260|3860:16 7081:2",	-- Windforged Leggings
	[30074] = "36129|Ba330|23446:8 22452:4",	-- Heavy Earthforged Breastplate
	[30076] = "36130|Ba330|23446:8 21885:2 22451:2",	-- Stormforged Hauberk
	[28483] = "34533|Ba350|23571:8 23573:6 23447:6 23449:8",	-- Breastplate of Kings
	[23563] = "34529|Ba350|22456:20 22451:20 23573:6 23448:4 23449:8",	-- Nether Chain Shirt
	[28484] = "34534|Ba375|28483 23572:10 22457:10",	-- Bulwark of Kings
	[28485] = "36257|Ba375|28484 30183:2",	-- Bulwark of the Ancient Kings
	[23565] = "36256|Ba375|23564 30183:2",	-- Embrace of the Twisting Nether
	[23564] = "34530|Ba375|23563 23572:10 22457:10",	-- Twisting Nether Chain Shirt
	[30071] = "36125|Bw260|3860:12 7075:4",	-- Light Earthforged Blade
	[30073] = "36128|Bw260|3860:12 7077:4",	-- Light Emberforged Hammer
	[30072] = "36126|Bw260|3860:12 7081:4",	-- Light Skyforged Axe
	[30088] = "36135|Bwx330|23446:10 22451:6",	-- Skyforged Great Axe
	[30087] = "36134|Bwx330|23446:8 21885:3 22451:3",	-- Stormforged Axe
	[28434] = "34543|Bwx350|22451:12 22452:12 23571:4 23447:22",	-- Lunar Crescent
	[28431] = "34541|Bwx350|23571:5 22456:20 23573:2 23448:12",	-- The Planar Edge
	[28432] = "34542|Bwx375|28431 23572:8 23448:6",	-- Black Planar Edge
	[28436] = "36261|Bwx375|28435 30183:5",	-- Bloodmoon
	[28435] = "34544|Bwx375|28434 23572:8 22457:10",	-- Mooncleaver
	[28433] = "36260|Bwx375|28432 30183:5",	-- Wicked Edge of the Planes
	[30093] = "36137|Bwh330|23446:12 22452:6",	-- Great Earthforged Hammer
	[30089] = "36136|Bwh330|23446:8 21884:6",	-- Lavaforged Warhammer
	[28437] = "34545|Bwh350|21884:20 22452:20 23447:12 23449:8",	-- Drakefist Hammer
	[28440] = "34547|Bwh350|22451:20 21885:20 23573:6 23449:12",	-- Thunder
	[28441] = "34548|Bwh375|28440 23572:8 22457:10",	-- Deep Thunder
	[28438] = "34546|Bwh375|28437 23572:8 23571:2",	-- Dragonmaw
	[28439] = "36262|Bwh375|28438 30183:5",	-- Dragonstrike
	[28442] = "36263|Bwh375|28441 30183:5",	-- Stormherald
	[30086] = "36133|Bws330|23446:10 22452:6",	-- Stoneforged Claymore
	[30077] = "36131|Bws330|23446:6 22451:6",	-- Windforged Rapier
	[28425] = "34535|Bws350|22456:20 22457:20 23448:14",	-- Fireguard
	[28428] = "34538|Bws350|23571:10 23449:14 23573:6",	-- Lionheart Blade
	[28427] = "36258|Bws375|28426 30183:5",	-- Blazefury
	[28426] = "34537|Bws375|28425 23572:8 22451:10",	-- Blazeguard
	[28429] = "34540|Bws375|28428 23572:8 23571:2",	-- Lionheart Champion
	[28430] = "36259|Bws375|28429 30183:5",	-- Lionheart Executioner
--[[ Horde only blacksmithing, needs fixed --]]
	[7929] = "9957|B220|3860:12 7067|99999",	-- Orcish War Leggings
--[[ Cooking --]]
    [33924] = "43779|W1|30817:8 1179:4 2678:4 6889:8 2593:1 785:3|33925", -- Delicious Chocolate Cake
	[6290] = "7751|W1|6291|6325",	-- Brilliant Smallfish
	[2679] = "2538|W1|2672",	-- Charred Wolf Meat
	[12224] = "15935|W1|12223 2678|12226",	-- Crispy Bat Wing
	[17197] = "21143|W1|6889 17194|17200",	-- Gingerbread Cookie
	[6888] = "8604|W1|6889 2678",	-- Herb Baked Egg
	[27635] = "33276|W1|27668|27685",	-- Lynx Steak
	[2681] = "2540|W1|769",	-- Roasted Boar Meat
	[24105] = "33277|W1|23676|27686",	-- Roasted Moongraze Tenderloin
	[787] = "7752|W1|6303|6326",	-- Slitherskin Mackerel
	[30816] = "37836|W1|30817 2678",	-- Spice Bread
	[2888] = "2795|W10|2886 2894|2889",	-- Beer Basted Boar Ribs
	[5472] = "6412|W10|5465|5482",	-- Kaldorei Spider Kabob
	[2680] = "2539|W10|2672 2678",	-- Spiced Wolf Meat
	[5473] = "6413|W20|5466|5483",	-- Scorpid Surprise
	[17198] = "21144|W35|6889 1179 17196 17194|17201",	-- Egg Nog
	[5474] = "6414|W35|5467 2678|5484|2",	-- Roasted Kodo Meat
	[6890] = "8607|W40|3173|6892",	-- Smoked Bear Meat
	[27636] = "33278|W50|27669|27687",	-- Bat Bites
	[5525] = "6499|W50|5503 159",	-- Boiled Clams
	[2684] = "2541|W50|2673",	-- Coyote Steak
	[5476] = "6415|W50|5468 2678|5485|2",	-- Fillet of Frenzy
	[724] = "2542|W50|723 2678|2697",	-- Goretusk Liver Pie
	[6316] = "7754|W50|6317 2678|6329",	-- Loch Frenzy Delight
	[4592] = "7753|W50|6289|6328",	-- Longjaw Mud Snapper
	[5095] = "7827|W50|6361|6368",	-- Rainbow Fin Albacore
	[5477] = "6416|W50|5469 4536|5486|2",	-- Strider Stew
	[3220] = "3371|W60|3173 3172 3174|3679|2",	-- Blood Sausage
	[22645] = "28267|W60|22644|22647",	-- Crunchy Spider Surprise
	[7676] = "9513|W60|2452 159|18160",	-- Thistle Tea
	[2683] = "2544|W75|2674 2678",	-- Crab Cake
	[733] = "2543|W75|729 730 731|728",	-- Westfall Stew
	[3662] = "3370|W80|2924 2678|3678",	-- Crocolisk Steak
	[2687] = "2546|W80|2677 2678",	-- Dry Pork Ribs
	[21072] = "25704|W80|21071 2678|21099",	-- Smoked Sagefish
	[2682] = "2545|W85|2675 2678|2698",	-- Cooked Crab Claw
	[6657] = "8238|W85|6522 2678|6661",	-- Savory Deviate Delight
	[5526] = "6501|W90|5503 1179 2678|5528",	-- Clam Chowder
	[5478] = "6417|W90|5051|5487|2",	-- Dig Rat Stew
	[3663] = "3372|W90|1468:2 2692|3680",	-- Murloc Fin Soup
	[4593] = "7755|W100|6308|6330",	-- Bristle Whisker Catfish
	[5479] = "6418|W100|5470 2692|5488|2",	-- Crispy Lizard Tail
	[1082] = "2547|W100|1081 1080|2699",	-- Redridge Goulash
	[1017] = "2549|W100|1015:2 2665|2701|3",	-- Seasoned Wolf Kabob
	[3726] = "3397|W110|3730 2692|3734",	-- Big Bear Steak
	[3666] = "3377|W110|2251:2 2692|3683",	-- Gooey Spider Cake
	[5480] = "6419|W110|5471 2678:4|5489|2",	-- Lean Venison
	[2685] = "2548|W110|2677:2 2692|2700",	-- Succulent Pork Ribs
	[3664] = "3373|W120|3667 2692|3681",	-- Crocolisk Gumbo
	[5527] = "6500|W125|5504 2692",	-- Goblin Deviled Clams
	[3727] = "3398|W125|3731 2692|3735",	-- Hot Lion Chops
	[12209] = "15853|W125|1015 2678|12227",	-- Lean Wolf Steak
	[3665] = "3376|W130|3685 2692|3682",	-- Curiously Tasty Omelet
	[20074] = "24418|W150|3667:2 3713|20075",	-- Heavy Crocolisk Stew
	[3728] = "3399|W150|3731:2 3713|3736",	-- Tasty Lion Steak
	[4457] = "4094|W175|3404 2692|4609",	-- Barbecued Buzzard Wing
	[12213] = "15863|W175|12037 2692|12232",	-- Carrion Surprise
	[6038] = "7213|W175|4655 2692|6039",	-- Giant Clam Scorcho
	[10841] = "13028|W175|3821 159||4",	-- Goldthorn Tea
	[13851] = "15856|W175|12203 2692|12229",	-- Hot Wolf Ribs
	[12212] = "15861|W175|12202 159 4536:2|12231|2",	-- Jungle Stew
	[8364] = "20916|W175|8365|17062",	-- Mithril Headed Trout
	[12214] = "15865|W175|12037 2596|12233",	-- Mystery Stew
	[12210] = "15855|W175|12184 2692|12228",	-- Roast Raptor
	[4594] = "7828|W175|6362|6369",	-- Rockscale Cod
	[21217] = "25954|W175|21153 2692|21219",	-- Sagefish Delight
	[3729] = "3400|W175|3712 3713|3737",	-- Soothing Turtle Bisque
	[12217] = "15906|W200|12037 4402 2692|12239",	-- Dragonbreath Chili
	[12215] = "15910|W200|12204:2 3713 159|12240|2",	-- Heavy Kodo Stew
	[17222] = "21175|W200|12205:2",	-- Spider Sausage
	[13927] = "18239|W225|13754 3713|13940",	-- Cooked Glossy Mightfish
	[13930] = "18241|W225|13758|13941",	-- Filet of Redgill
	[12218] = "15933|W225|12207 3713:2|16110",	-- Monster Omelet
	[12216] = "15915|W225|12206 2692:2|16111",	-- Spiced Chili Crab
	[6887] = "18238|W225|4603|13939",	-- Spotted Yellowtail
	[18045] = "22480|W225|12208 3713|18046",	-- Tender Wolf Steak
	[16766] = "20626|W225|7974:2 2692 1179|16767|2",	-- Undermine Clam Chowder
	[13928] = "18240|W240|13755 3713|13942",	-- Grilled Squid
	[13929] = "18242|W240|13756 2692:2|13943",	-- Hot Smoked Bass
	[13931] = "18243|W250|13759 159|13945",	-- Nightfin Soup
	[13932] = "18244|W250|13760|13946",	-- Poached Sunscale Salmon
	[13935] = "18247|W275|13889 3713|13949",	-- Baked Salmon
	[13933] = "18245|W275|13888 159|13947",	-- Lobster Stew
	[13934] = "18246|W275|13893 2692 3713|13948",	-- Mightfish Steak
	[18254] = "22761|W275|18255 3713|18267",	-- Runn Tum Tuber Surprise
	[20452] = "24801|W285|20424 3713",	-- Smoked Desert Dumplings
	[27661] = "33290|W300|27422|27694",	-- Blackened Trout
	[27651] = "33279|W300|27671|27684",	-- Buzzard Bites
	[30155] = "36210|W300|24477:2 3713|30156",	-- Clam Bar
	[21023] = "25659|W300|2692 9061 8150 21024|21025|5",	-- Dirge's Kickin' Chimaerok Chops
	[27662] = "33291|W300|27425|27695",	-- Feltail Delight
	[27655] = "33284|W300|27674|27688",	-- Ravager Dog
    [33867] = "43761|W300|33823:1|33869", -- Broiled Bloodfin
    [33874] = "43772|W300|27671|33875", -- Kibler's Bits
    [33866] = "43758|W300|27678 13757|33871", -- Stormchops
	[27663] = "33292|W310|27429|27696",	-- Blackened Sporefish
	[27656] = "33285|W310|27676|27689",	-- Sporeling Snack
	[27657] = "33286|W315|27677|27690",	-- Blackened Basilisk
	[27664] = "33293|W320|27435|27697",	-- Grilled Mudfish
	[27665] = "33294|W320|27437|27698",	-- Poached Bluefish
	[27666] = "33295|W325|27438|27699",	-- Golden Fish Sticks
	[27658] = "33287|W325|27678|27691",	-- Roasted Clefthoof
	[27660] = "33289|W325|27682|27693",	-- Talbuk Steak
	[27659] = "33288|W325|27681|27692",	-- Warp Burger
    [34411] = "45022|W325|34412 17196 17194|34413|2", --Hot Apple Cider
    [33825] = "43707|W325|33824|33870", -- Skullfish Soup
    [33872] = "43765|W325|27682 2692|33873", -- Spicy Hot Talbuk
	[31673] = "38868|W335|31671|31674",	-- Crunchy Serpent
	[31672] = "38867|W335|31670|31675",	-- Mok'Nathal Shortribs
	[27667] = "33296|W350|27439|27700",	-- Spicy Crawdad
	[33048] = "42296|W325|27422 2593 3713",	-- Stewed Trout
	[33052] = "42302|W350|27515 4539:5 3713:5||6",	-- Fisherman's Feast
	[33053] = "42305|W350|27516 3713:2||2",	-- Hot Buttered Trout
--[[ Enchanting --]]
	[6218] = "7421|D1|6217 10940 10938",	-- Runed Copper Rod
	[-7428] = "D1|10938 10940",	-- Enchant Bracer - Minor Deflection
	[-7418] = "D1|10940",	-- Enchant Bracer - Minor Health
	[11287] = "14293|D10|4470 10938",	-- Lesser Magic Wand
	[-7420] = "D15|10940",	-- Enchant Chest - Minor Health
	[-7443] = "D20|10938|6342",	-- Enchant Chest - Minor Mana
	[-7426] = "D40|10940:2 10938",	-- Enchant Chest - Minor Absorption
	[20744] = "25124|D45|10940:2 17034 3371",	-- Minor Wizard Oil
	[-7454] = "D45|10940 10938:2",	-- Enchant Cloak - Minor Resistance
	[-7457] = "D50|10940:3",	-- Enchant Bracer - Minor Stamina
	[-7766] = "D60|10938:2|6344",	-- Enchant Bracer - Minor Spirit
	[-7748] = "D60|10940:2 10938:2",	-- Enchant Chest - Lesser Health
	[11288] = "14807|D70|4470 10939",	-- Greater Magic Wand
	[-7771] = "D70|10940:3 10939",	-- Enchant Cloak - Minor Protection
	[-7779] = "D80|10940:2 10939",	-- Enchant Bracer - Minor Agility
	[-7782] = "D80|10940:5|6347",	-- Enchant Bracer - Minor Strength
	[-7776] = "D80|10939 10938|6346",	-- Enchant Chest - Lesser Mana
	[-7786] = "D90|10940:4 10939:2|6348",	-- Enchant Weapon - Minor Beastslayer
	[-7788] = "D90|10940:2 10939 10978",	-- Enchant Weapon - Minor Striking
	[6339] = "7795|D100|6338 10940:6 10939:3 6218",	-- Runed Silver Rod
	[-7793] = "D100|10939:3|6349",	-- Enchant 2H Weapon - Lesser Intellect
	[-7745] = "D100|10940:4 10978",	-- Enchant 2H Weapon - Minor Impact
	[-13378] = "D105|10998 10940:2",	-- Enchant Shield - Minor Stamina
	[-13380] = "D110|10998 10940:6|11038",	-- Enchant 2H Weapon - Lesser Spirit
	[-13419] = "D110|10998|11039",	-- Enchant Cloak - Minor Agility
	[-13421] = "D115|10940:6 10978",	-- Enchant Cloak - Lesser Protection
	[-13464] = "D115|10998 10940 10978|11081",	-- Enchant Shield - Lesser Protection
	[-7859] = "D120|10998:2|6375",	-- Enchant Bracer - Lesser Spirit
	[-7857] = "D120|10940:4 10998",	-- Enchant Chest - Health
	[-7867] = "D125|10940:6 10998:2|6377",	-- Enchant Boots - Minor Agility
	[-7863] = "D125|10940:8",	-- Enchant Boots - Minor Stamina
	[-7861] = "D125|6371 10998",	-- Enchant Cloak - Lesser Fire Resistance
	[-13501] = "D130|11083:2",	-- Enchant Bracer - Lesser Stamina
	[-13485] = "D130|10998:2 10940:4",	-- Enchant Shield - Lesser Spirit
	[-13522] = "D135|11082 6048|11098",	-- Enchant Cloak - Lesser Shadow Resistance
	[-13536] = "D140|11083:2|11101",	-- Enchant Bracer - Lesser Strength
	[-13538] = "D140|10940:2 11082 11084",	-- Enchant Chest - Lesser Absorption
	[-13503] = "D140|11083:2 11084",	-- Enchant Weapon - Lesser Striking
	[-13529] = "D145|11083:3 11084",	-- Enchant 2H Weapon - Lesser Impact
	[-13607] = "D145|11082 10998:2",	-- Enchant Chest - Mana
	[-13620] = "D145|11083 6370:3|11152",	-- Enchant Gloves - Fishing
	[-13617] = "D145|11083 3356:3|11151",	-- Enchant Gloves - Herbalism
	[-13612] = "D145|11083 2772:3|11150",	-- Enchant Gloves - Mining
	[20745] = "25125|D150|11083:3 17034:2 3372|20752",	-- Minor Mana Oil
	[11130] = "13628|D150|11128 5500 11082:2 11083:2 6339",	-- Runed Golden Rod
	[-13622] = "D150|11082:2",	-- Enchant Bracer - Lesser Intellect
	[-13626] = "D150|11082 11083 11084",	-- Enchant Chest - Minor Stats
	[11289] = "14809|D155|11291 11134 11083",	-- Lesser Mystic Wand
	[-13635] = "D155|11138 11083:3",	-- Enchant Cloak - Defense
	[-13631] = "D155|11134 11083",	-- Enchant Shield - Lesser Stamina
	[-13637] = "D160|11083 11134",	-- Enchant Boots - Lesser Agility
	[-13640] = "D160|11083:3",	-- Enchant Chest - Greater Health
	[-13642] = "D165|11134",	-- Enchant Bracer - Spirit
	[-13644] = "D170|11083:4",	-- Enchant Boots - Lesser Stamina
	[-13646] = "D170|11134 11083:2|11163",	-- Enchant Bracer - Lesser Deflection
	[-13648] = "D170|11083:6",	-- Enchant Bracer - Stamina
	[11290] = "14810|D175|11291 11135 11137",	-- Greater Mystic Wand
	[-13657] = "D175|11134 7068",	-- Enchant Cloak - Fire Resistance
	[-13653] = "D175|11134 5637:2 11138|11164",	-- Enchant Weapon - Lesser Beastslayer
	[-13655] = "D175|11134 7067 11138|11165",	-- Enchant Weapon - Lesser Elemental Slayer
	[-13661] = "D180|11137",	-- Enchant Bracer - Strength
	[-13659] = "D180|11135 11137",	-- Enchant Shield - Spirit
	[-13663] = "D185|11135",	-- Enchant Chest - Greater Mana
	[-13687] = "D190|11135 11134:2|11167",	-- Enchant Boots - Lesser Spirit
	[-21931] = "D190|11135:3 11137:3 11139 3819:2|17725",	-- Enchant Weapon - Winter's Might
	[-13689] = "D195|11135:2 11137:2 11139|11168",	-- Enchant Shield - Lesser Block
	[-13693] = "D195|11135:2 11139",	-- Enchant Weapon - Striking
	[20746] = "25126|D200|11137:3 17035:2 3372",	-- Lesser Wizard Oil
	[11145] = "13702|D200|11144 7971 11135:2 11137:2 11130",	-- Runed Truesilver Rod
	[-13695] = "D200|11137:4 11139",	-- Enchant 2H Weapon - Impact
	[-13700] = "D200|11135:2 11137:2 11139",	-- Enchant Chest - Lesser Stats
	[-13698] = "D200|11137 7392:3|11166",	-- Enchant Gloves - Skinning
	[-13746] = "D205|11137:3",	-- Enchant Cloak - Greater Defense
	[-13794] = "D205|11174",	-- Enchant Cloak - Resistance
	[-13822] = "D210|11174:2",	-- Enchant Bracer - Intellect
	[-13815] = "D210|11174 11137",	-- Enchant Gloves - Agility
	[-13817] = "D210|11137:5|11202",	-- Enchant Shield - Stamina
	[-13836] = "D215|11137:5",	-- Enchant Boots - Stamina
	[-13841] = "D215|11137:3 6037:3|11203",	-- Enchant Gloves - Advanced Mining
	[-13846] = "D220|11174:3 11137|11204",	-- Enchant Bracer - Greater Spirit
	[-13858] = "D220|11137:6",	-- Enchant Chest - Superior Health
	[-13890] = "D225|11177 7909 11174",	-- Enchant Boots - Minor Speed
	[-13882] = "D225|11174:2|11206",	-- Enchant Cloak - Lesser Agility
	[-13868] = "D225|11137:3 8838:3|11205",	-- Enchant Gloves - Advanced Herbalism
	[-13887] = "D225|11174:2 11137:3",	-- Enchant Gloves - Strength
	[-13917] = "D230|11175 11174:2",	-- Enchant Chest - Superior Mana
	[-13905] = "D230|11175 11176:2",	-- Enchant Shield - Greater Spirit
	[-13915] = "D230|11177 11176:2 9224|11208",	-- Enchant Weapon - Demonslaying
	[-13935] = "D235|11175:2",	-- Enchant Boots - Agility
	[-13931] = "D235|11175 11176:2|11223",	-- Enchant Bracer - Deflection
	[-13933] = "D235|11178 3829|11224",	-- Enchant Shield - Frost Resistance
	[-13937] = "D240|11178:2 11176:2",	-- Enchant 2H Weapon - Greater Impact
	[-13939] = "D240|11176:2 11175",	-- Enchant Bracer - Greater Strength
	[-13945] = "D245|11176:5|11225",	-- Enchant Bracer - Greater Stamina
	[-13941] = "D245|11178 11176:3 11175:2",	-- Enchant Chest - Stats
	[-13943] = "D245|11178:2 11175:2",	-- Enchant Weapon - Greater Striking
	[12810] = "17181|D250|8170 16202",	-- Enchanted Leather
	[12655] = "17180|D250|12359 11176:3",	-- Enchanted Thorium
	[20747] = "25127|D250|11176:3 8831:2 8925|20754||20747",	-- Lesser Mana Oil
	[-13948] = "D250|11178:2 8153:2",	-- Enchant Gloves - Minor Haste
	[-13947] = "D250|11178:2 11176:3|11226",	-- Enchant Gloves - Riding Skill
	[-20008] = "D255|16202:3|16214",	-- Enchant Bracer - Greater Intellect
	[-20020] = "D260|11176:10|16215",	-- Enchant Boots - Greater Stamina
	[11811] = "15596|D265|11382 7078 14343:3|11813",	-- Smoking Heart of the Mountain
	[-20014] = "D265|16202:2 7077 7075 7079 7081 7972|16216",	-- Enchant Cloak - Greater Resistance
	[-20017] = "D265|11176:10|16217",	-- Enchant Shield - Greater Stamina
	[-13898] = "D265|11177:4 7078|11207",	-- Enchant Weapon - Fiery Weapon
	[-20009] = "D270|16202:3 11176:10|16218",	-- Enchant Bracer - Superior Spirit
	[-20012] = "D270|16202:3 16204:3|16219",	-- Enchant Gloves - Greater Agility
	[20750] = "25128|D275|16204:3 4625:2 8925|20755||20750",	-- Wizard Oil
	[-20024] = "D275|16203:2 16202|16220",	-- Enchant Boots - Spirit
	[-20026] = "D275|16204:6 14343|16221",	-- Enchant Chest - Major Health
	[-20016] = "D280|16203:2 16204:4|16222",	-- Enchant Shield - Superior Spirit
	[-20015] = "D285|16204:8|16224",	-- Enchant Cloak - Superior Defense
	[-20029] = "D285|14343:4 7080 7082 13467|16223",	-- Enchant Weapon - Icy Chill
	[16207] = "20051|D290|16206 13926 16204:10 16203:4 11145 14344:2|16243",	-- Runed Arcanite Rod
	[-27837] = "D290|14344:10 16203:6 16204:14 7082:4|22392",	-- Enchant 2H Weapon - Agility
	[-23801] = "D290|16204:16 16203:4 7080:2|19446",	-- Enchant Bracer - Mana Regeneration
	[-20028] = "D290|16203:3 14343|16242",	-- Enchant Chest - Major Mana
	[-23800] = "D290|14344:6 16203:6 16204:4 7082:2|19445",	-- Enchant Weapon - Agility
	[-23799] = "D290|14344:6 16203:6 16204:4 7076:2|19444",	-- Enchant Weapon - Strength
	[-20030] = "D295|14344:4 16204:10|16247",	-- Enchant 2H Weapon - Superior Impact
	[-20023] = "D295|16203:8|16245",	-- Enchant Boots - Greater Agility
	[-20010] = "D295|16204:6 16203:6|16246",	-- Enchant Bracer - Superior Strength
	[-20013] = "D295|16203:4 16204:4|16244",	-- Enchant Gloves - Greater Strength
	[-20033] = "D295|14344:4 12808:4|16248",	-- Enchant Weapon - Unholy Weapon
	[20748] = "25130|D300|14344:2 8831:3 18256|20757",	-- Brilliant Mana Oil
	[20749] = "25129|D300|14344:2 4625:3 18256|20756",	-- Brilliant Wizard Oil
	[22461] = "32664|D300|25843 16203:4 14344:6 16207",	-- Runed Fel Iron Rod
    [-42613] = "D300|20725|||22448", --Nexus Transformation 
	[-20036] = "D300|16203:12 14344:2|16249",	-- Enchant 2H Weapon - Major Intellect
	[-20035] = "D300|16203:12 14344:2|16255",	-- Enchant 2H Weapon - Major Spirit
	[-34002] = "D300|22445:6",	-- Enchant Bracer - Assault
	[-23802] = "D300|14344:2 16204:20 16203:4 12803:6|19447",	-- Enchant Bracer - Healing Power
	[-20011] = "D300|16204:15|16251",	-- Enchant Bracer - Superior Stamina
	[-20025] = "D300|14344:4 16204:15 16203:10|16253",	-- Enchant Chest - Greater Stats
	[-33991] = "D300|22447:2 22445:2",	-- Enchant Chest - Restore Mana Prime
	[-25086] = "D300|22448:3 22446:3 22452:8|20736",	-- Enchant Cloak - Dodge
	[-25081] = "D300|22448:3 22446:3 7078:4|20732",	-- Enchant Cloak - Greater Fire Resistance
	[-25082] = "D300|22448:2 22446:3 12803:4|20733",	-- Enchant Cloak - Greater Nature Resistance
	[-25083] = "D300|22448:3 22446:3 22794:2|20734",	-- Enchant Cloak - Stealth
	[-25084] = "D300|22448:4 22446:2 22456:8|20735",	-- Enchant Cloak - Subtlety
	[-25078] = "D300|20725:2 14344:10 7078:4|20729",	-- Enchant Gloves - Fire Power
	[-25074] = "D300|20725:3 14344:10 7080:4|20728",	-- Enchant Gloves - Frost Power
	[-25079] = "D300|20725:3 14344:8 12811|20730",	-- Enchant Gloves - Healing Power
	[-25073] = "D300|20725:3 14344:10 12808:6|20727",	-- Enchant Gloves - Shadow Power
	[-25080] = "D300|22448:3 22446:3 22451:2|20731",	-- Enchant Gloves - Superior Agility
	[-25072] = "D300|22448:4 22446:2 21886:8|20726",	-- Enchant Gloves - Threat
	[-20034] = "D300|14344:4 12811:2|16252",	-- Enchant Weapon - Crusader
	[-22750] = "D300|14344:4 16203:8 12803:6 7080:6 12811|18260",	-- Enchant Weapon - Healing Power
	[-20032] = "D300|14344:6 12808:6 12803:6|16254",	-- Enchant Weapon - Lifestealing
	[-23804] = "D300|14344:15 16203:12 16204:20|19449",	-- Enchant Weapon - Mighty Intellect
	[-23803] = "D300|14344:10 16203:8 16204:15|19448",	-- Enchant Weapon - Mighty Spirit
	[-22749] = "D300|14344:4 16203:12 7078:4 7080:4 7082:4 13926:2|18259",	-- Enchant Weapon - Spell Power
	[-20031] = "D300|14344:2 16203:10|16250",	-- Enchant Weapon - Superior Striking
	[-27948] = "D305|22445:6 13446:4 13444:4|22542",	-- Enchant Boots - Vitality
	[-27899] = "D305|22445:6",	-- Enchant Bracer - Brawn
	[-34001] = "D305|22447:3",	-- Enchant Bracer - Major Intellect
	[-33993] = "D305|22447 22445:4",	-- Enchant Gloves - Blasting
	[22521] = "28016|D310|22445:3 22791 18256|22562||22521",	-- Superior Mana Oil
	[-34004] = "D310|22446 22445:4 22451",	-- Enchant Cloak - Greater Agility
	[-27961] = "D310|22445:8",	-- Enchant Cloak - Major Armor
	[-33996] = "D310|22445:8",	-- Enchant Gloves - Assault
	[-27944] = "D310|22445:6 22452:10",	-- Enchant Shield - Tough Shield
	[-27905] = "D315|22445:6 22447:6",	-- Enchant Bracer - Stats
	[-27957] = "D315|22445:8 13446:4 14344:2",	-- Enchant Chest - Exceptional Health
	[-27950] = "D320|22445:12|22543",	-- Enchant Boots - Fortitude
	[-27906] = "D320|22448:2 22445:10|22530",	-- Enchant Bracer - Major Defense
	[-33990] = "D320|22446:2",	-- Enchant Chest - Major Spirit
	[22460] = "28027|D325|22449:4",	-- Prismatic Sphere
	[-27911] = "D325|22446:4 21886:4|24000",	-- Enchant Bracer - Superior Healing
	[-34003] = "D325|22446:2 22445:6 22457:2|28274",	-- Enchant Cloak - Spell Penetration
	[-27945] = "D325|22446:4|22539",	-- Enchant Shield - Intellect
	[-34009] = "D325|22445:15|28282",	-- Enchant Shield - Major Stamina
	[-27962] = "D330|22446:4 21884:4 22451:4 22452:4 21885:4|22548",	-- Enchant Cloak - Major Resistance
    [-44383] = "D330|22449 22447:4", --Enchant Shield Resilience
	[22449] = "28022|D335|22448:3|22565",	-- Large Prismatic Shard
	[-27913] = "D335|22446:8|22532",	-- Enchant Bracer - Restore Mana Prime
    [22448] = "42615|D335|22449|42615|3|22448", --Small Prismatic Shard
	[22522] = "28019|D340|22445:3 22792 18256|22563||22522",	-- Superior Wizard Oil
	[-27951] = "D340|22446:8 22445:8|22544",	-- Enchant Boots - Dexterity
	[-33995] = "D340|22445:12 22446",	-- Enchant Gloves - Major Strength
	[-27946] = "D340|22445:12 22446:4 22452:10|22540",	-- Enchant Shield - Shield Block
	[-27968] = "D340|22449:2 22446:10|22551",	-- Enchant Weapon - Major Intellect
	[-27967] = "D340|22449:2 22446:6 22445:6|22552",	-- Enchant Weapon - Major Striking
	[-27960] = "D345|22449:4 22445:4 22446:4|24003",	-- Enchant Chest - Exceptional Stats
	[-33992] = "D345|22446:4 22445:10|28270",	-- Enchant Chest - Major Resilience
	[22459] = "28028|D350|22450:2",	-- Void Sphere
	[22462] = "32665|D350|25844 22446:8 22449:8 23571 22461|25848",	-- Runed Adamantite Rod
	[-27971] = "D350|22449:4 22445:40|22554",	-- Enchant 2H Weapon - Savagery
	[-27914] = "D350|22449 22446:10 22445:20|22533",	-- Enchant Bracer - Fortitude
	[-34005] = "D350|22449:4 22457:8|28276",	-- Enchant Cloak - Greater Arcane Resistance
	[-34006] = "D350|22449:4 22456:8|28277",	-- Enchant Cloak - Greater Shadow Resistance
	[-33999] = "D350|22446:6 22449:6 21886:6|28273",	-- Enchant Gloves - Major Healing
	[-34010] = "D350|22449:8 21885:8 21886:8|28281",	-- Enchant Weapon - Major Healing
	[-27975] = "D350|22449:8 22446:8|22555",	-- Enchant Weapon - Major Spellpower
	[-27972] = "D350|22449:4 22446:5 22445:20|22553",	-- Enchant Weapon - Potency
   	[-42620] = "D350|22445:8 22446:4 22449:8 22451:2|33165",	-- Enchant Weapon - Greater Agility
	[-27977] = "D360|22449:8 22446:6 22445:20|22556",	-- Enchant 2H Weapon - Major Agility
	[-34008] = "D360|22449:8 22452:8|28280",	-- Enchant Boots - Boar's Speed
	[-34007] = "D360|22449:8 22451:8|28279",	-- Enchant Boots - Cat's Swiftness
	[-27917] = "D360|22449:6 21884:6 21885:6|22534",	-- Enchant Bracer - Spellpower
	[-33997] = "D360|22446:6 22449:6 22457:6|28272",	-- Enchant Gloves - Major Spellpower
	[-33994] = "D360|22446:8 22445:2 22449:2|28271",	-- Enchant Gloves - Spell Strike
	[-27924] = "D360|22449:2 22446:2|22536",	-- Enchant Ring - Spellpower
	[-27920] = "D360|22449:2 22445:6|22535",	-- Enchant Ring - Striking
	[-27947] = "D360|22449:6 22452:3 21884:3 22451:3 21885:3|22541",	-- Enchant Shield - Resistance
	[-28004] = "D360|22450:8 22449:8 21885:2|22557",	-- Enchant Weapon - Battlemaster
	[-28003] = "D360|22449:12 22446:10 22445:20|22558",	-- Enchant Weapon - Spellsurge
	[-27954] = "D370|22450:2 22449:4 23572|22545",	-- Enchant Boots - Surefooted
	[-27926] = "D370|22449:2 22446:3 22445:5|22537",	-- Enchant Ring - Healing Power
	[22463] = "32667|D375|25845 22446:12 22450:2 23571:4 22462|25849",	-- Runed Eternium Rod
	[-27927] = "D375|22450:2 22449:2|22538",	-- Enchant Ring - Stats
	[-27984] = "D375|22450:6 22449:10 22446:8 22445:40|22559",	-- Enchant Weapon - Mongoose
	[-27982] = "D375|22450:12 22449:10 22446:8 21885:6 22456:6|22561",	-- Enchant Weapon - Soulfrost
	[-27981] = "D375|22450:12 22449:10 22446:8 21884:6 23571:1|22560",	-- Enchant Weapon - Sunfire
    [-42974] = "D375|22450:6 22449:10 22446:6 22445:30 22824:3|33307", --Enchant Weapon: Executioner
--	[-27958] = "D375|22449 13444:4 22446:3",	-- Enchant Chest - Exceptional Mana
--[[ Engineering --]]
	[8067] = "3920|E1|4357 2840||200",	-- Crafted Light Shot
	[4357] = "3918|E1|2835",	-- Rough Blasting Powder
	[4358] = "3919|E1|4357:2 2589||2",	-- Rough Dynamite
	[4359] = "3922|E30|2840",	-- Handful of Copper Bolts
	[4360] = "3923|E30|2840 4359 4357:2 2589||2",	-- Rough Copper Bomb
	[4362] = "3925|E50|4361 4359 4399",	-- Rough Boomstick
	[6219] = "7430|E50|2840:6",	-- Arclight Spanner
	[4361] = "3924|E50|2840:2 2880",	-- Copper Tube
	[4405] = "3977|E60|4361 774 4359",	-- Crude Scope
	[4363] = "3926|E65|4359:2 2840 2589:2",	-- Copper Modulator
	[4364] = "3929|E75|2836",	-- Coarse Blasting Powder
	[4365] = "3931|E75|4364:3 2589||2",	-- Coarse Dynamite
	[8068] = "3930|E75|4364 2840||200",	-- Crafted Heavy Shot
	[4401] = "3928|E75|4363 4359 2840 774:2|4408||4401",	-- Mechanical Squirrel
	[4366] = "3932|E85|4363 4359:2 2841 2592",	-- Target Dummy
	[4404] = "3973|E90|2842||5",	-- Silver Contact
	[4368] = "3934|E100|2318:6 818:2",	-- Flying Tiger Goggles
	[6714] = "8339|E100|4364:4 2592|6716|2",	-- EZ-Thro Dynamite
	[6712] = "8334|E100|2841 4359:2 2880",	-- Practice Lock
	[4367] = "3933|E100|4364:2 4363 2318 159|4409",	-- Small Seaforium Charge
	[4369] = "3936|E105|4361:2 4359:4 4399 2319:2",	-- Deadly Blunderbuss
	[4371] = "3938|E105|2841:2 2880",	-- Bronze Tube
	[4370] = "3937|E105|2840:3 4364:4 4404||3",	-- Large Copper Bomb
	[4406] = "3978|E110|4371 1206",	-- Standard Scope
	[4372] = "3939|E115|4371:2 4359:2 4400 1206:3|13309",	-- Lovingly Crafted Boomstick
	[4373] = "3940|E120|2319:4 1210:2|4410",	-- Shadow Goggles
	[4374] = "3941|E120|4364:4 2841:2 4404 2592||2",	-- Small Bronze Bomb
	[7506] = "9269|E125|2841:6 4375 814:2 818 774|7560",	-- Gnomish Universal Remote
	[8069] = "3947|E125|4377 2841||200",	-- Crafted Solid Shot
	[4376] = "3944|E125|4375 4402|4411",	-- Flame Deflector
	[4377] = "3945|E125|2838",	-- Heavy Blasting Powder
	[4378] = "3946|E125|4377:2 2592||3",	-- Heavy Dynamite
	[21558] = "26416|E125|4364 2319|21724|3",	-- Small Blue Rocket
	[21559] = "26417|E125|4364 2319|21725|3",	-- Small Green Rocket
	[21557] = "26418|E125|4364 2319|21726|3",	-- Small Red Rocket
	[4375] = "3942|E125|2841:2 2592",	-- Whirring Bronze Gizmo
	[4379] = "3949|E130|4371:2 4375:2 4400 2842:3",	-- Silver-plated Shotgun
	[4381] = "3952|E135|4371 4375:2 2319:2 1206|14639",	-- Minor Recombobulator
	[5507] = "6458|E135|4371:2 4375:2 4363 1206",	-- Ornate Spyglass
	[4380] = "3950|E140|4377:2 2841:3 4404||3",	-- Big Bronze Bomb
	[4383] = "3954|E145|4371:3 4375:3 4400 1705:2|4412",	-- Moonsight Rifle
	[4382] = "3953|E145|2841:2 2319 2592",	-- Bronze Framework
	[4386] = "3957|E145|4375 3829|13308",	-- Ice Deflector
	[4385] = "3956|E150|2319:4 1206:2 4368",	-- Green Tinted Goggles
	[6533] = "9271|E150|2841:2 6530 4364||3",	-- Aquadynamic Fish Attractor
	[9312] = "23067|E150|4377 4234|18649|3",	-- Blue Firework
	[4388] = "3959|E150|4375:3 4306:2 1529 4371|4413",	-- Discombobulator Ray
	[4384] = "3955|E150|4382 4375 4377:2 2592:2",	-- Explosive Sheep
	[10558] = "12584|E150|3577||3",	-- Gold Power Core
	[9313] = "23068|E150|4377 4234|18648|3",	-- Green Firework
	[9318] = "23066|E150|4377 4234|18647|3",	-- Red Firework
	[4387] = "3958|E160|3575:2",	-- Iron Strut
	[7148] = "9273|E165|3575:6 4375:2 814:2 4306:2 1210:2 7191|7561",	-- Goblin Jumper Cables
	[4403] = "3960|E165|4371:4 4387 4377:4 2319:4|4414",	-- Portable Bronze Mortar
	[4407] = "3979|E170|4371 1529 3864|13310",	-- Accurate Scope
	[4389] = "3961|E170|3575 10558",	-- Gyrochronatom
	[10499] = "12587|E175|4234:6 3864:2|10601",	-- Bright-Eye Goggles
	[4391] = "3963|E175|4387:2 4382 4389:2 4234:4",	-- Compact Harvest Reaper Kit
	[10498] = "12590|E175|3859:4",	-- Gyromatic Micro-Adjustor
	[4390] = "3962|E175|3575 4377 4306||3",	-- Iron Grenade
	[21589] = "26420|E175|4377 4234|21727|3",	-- Large Blue Rocket
	[21590] = "26421|E175|4377 4234|21728|3",	-- Large Green Rocket
	[21592] = "26422|E175|4377 4234|21729|3",	-- Large Red Rocket
	[10505] = "12585|E175|7912:2",	-- Solid Blasting Powder
	[10507] = "12586|E175|10505 4306||2",	-- Solid Dynamite
	[4393] = "3966|E185|4234:6 3864:2|4415",	-- Craftsman's Monocle
	[4392] = "3965|E185|4387 4382 4389 4234:4",	-- Advanced Target Dummy
	[4852] = "8243|E185|4611 4377 4306|6672",	-- Flash Bomb
	[4394] = "3967|E190|3575:3 4377:3 4404||2",	-- Big Iron Bomb
	[4397] = "3971|E190|4389:4 1529:2 1705:2 3864:2 7191|7742",	-- Gnomish Cloaking Device
	[4396] = "3969|E190|4382 4387:4 4389:4 3864:2 7191|13311",	-- Mechanical Dragonling
	[17716] = "21940|E190|3860:8 4389:4 17202:4 3829|17720",	-- SnowMaster 9000
	[4395] = "3968|E195|4377:3 3575:2 4389|4416",	-- Goblin Land Mine
	[10559] = "12589|E195|3860:3",	-- Mithril Tube
	[18588] = "23069|E200|10505 4338:2|18650",	-- EZ-Thro Dynamite II
	[4398] = "3972|E200|10505:2 4234:2 159|4417",	-- Large Seaforium Charge
	[11590] = "15255|E200|3860 4338 10505",	-- Mechanical Repair Kit
	[10560] = "12591|E200|3860 4338 10505",	-- Unstable Trigger
	[10500] = "12594|E205|4385 3864:2 7068:2 4234:4",	-- Fire Goggles
	[10508] = "12595|E205|10559 10560 4400 3860:4 7068:2",	-- Mithril Blunderbuss
	[10512] = "12596|E210|3860 10505||200",	-- Hi-Impact Mithril Slugs
	[10546] = "12597|E210|10559 7909:2 4304:2|10602",	-- Deadly Scope
	[10721] = "12903|Eg215|7387 3860:4 6037:2 10560 7909:2",	-- Gnomish Harm Prevention Belt
	[10561] = "12599|E215|3860:3",	-- Mithril Casing
	[10514] = "12603|E215|10561 10560 10505||3",	-- Mithril Frag Bomb
	[10501] = "12607|E220|4304:4 7909:2 10592|10603",	-- Catseye Ultra Goggles
	[10510] = "12614|E220|10559:2 10560 4400 3860:6 3864:2|10604",	-- Mithril Heavy-bore Rifle
	[10518] = "12616|E225|4339:4 10285:2 10560 10505:4|10606",	-- Parachute Cloak
	[10502] = "12615|E225|4304:4 7910:2|10605",	-- Spellpower Goggles Xtreme
	[21571] = "26423|E225|10505 4304|21730|3",	-- Blue Rocket Cluster
	[21569] = "26442|E225|9060 9061 10560 10561|21738",	-- Firework Launcher
	[21574] = "26424|E225|10505 4304|21731|3",	-- Green Rocket Cluster
	[21576] = "26425|E225|10505 4304|21732|3",	-- Red Rocket Cluster
	[10506] = "12617|E230|3860:8 10561 6037 818:4 774:4|10607",	-- Deepdive Helmet
	[10503] = "12618|E230|4304:6 7910:2",	-- Rose Colored Goggles
	[10562] = "12619|E235|10561:2 10560 10505:2||4",	-- Hi-Explosive Bomb
	[10548] = "12620|E240|10559 7910 6037:2|10608",	-- Sniper Scope
	[10504] = "12622|E245|4304:8 1529:3 7909:3 10286:2 8153:2",	-- Green Lens
	[10513] = "12621|E245|3860:2 10505:2||200",	-- Mithril Gyro-Shot
	[15992] = "19788|E250|12365:2",	-- Dense Blasting Powder
	[18641] = "23070|E250|15992:2 14047:3||2",	-- Dense Dynamite
	[10576] = "12624|E250|3860:14 7077:4 6037:4 9060:2 9061:2 7910:2|10609",	-- Mithril Mechanical Dragonling
	[15846] = "19567|E250|10561 12359:6 10558 10560:4",	-- Salt Shaker
	[19026] = "23507|E250|15992:2 14047:2 8150|19027|4",	-- Snake Burst Firework
	[21277] = "26011|E250|15407 15994:4 7079:2 18631:2 10558",	-- Tranquil Mechanical Yeti
	[18634] = "23077|E260|15994:6 18631:2 12361:2 7078:4 3829:2 13467:4|18652",	-- Gyrofreeze Ice Reflector
	[15995] = "19792|E260|10559:2 10561:2 15994:2 12359:4 10546|16043",	-- Thorium Rifle
	[15993] = "19790|E260|15994 12359:3 15992:3 14047:3|16041|3",	-- Thorium Grenade
	[15994] = "19791|E260|12359:3 14047|16042",	-- Thorium Widget
	[18631] = "23071|E260|6037:2 7067:2 7069|18651",	-- Truesilver Transformer
	[15996] = "19793|E265|12803 15994:4 10558 8170|16044",	-- Lifelike Mechanical Toad
	[15999] = "19794|E270|10502 7910:4 12810:2 14047:8|16045",	-- Spellpower Goggles Xtreme Plus
	[16004] = "19796|E275|16000:2 11371:6 10546:2 12361:2 12799:2 8170:4|16048",	-- Dark Iron Rifle
	[18637] = "23079|E275|16000:2 18631 14047:2|18655",	-- Major Recombobulator
	[34] = "26443|E275|9060:4 9061:4 18631:2 10561|21737||21570",	-- Firework Cluster Launcher
	[7191] = "39895|E275|20816:3 7078:2|32381||7191",	-- Fused Wiring
	[21714] = "26426|E275|15992 8170|21733|3",	-- Large Blue Rocket Cluster
	[21716] = "26427|E275|15992 8170|21734|3",	-- Large Green Rocket Cluster
	[21718] = "26428|E275|15992 8170|21735|3",	-- Large Red Rocket Cluster
	[16023] = "19814|E275|10561 16000 15994:2 6037 8170:2 14047:4|16046",	-- Masterwork Target Dummy
	[18594] = "23080|E275|15994:2 15992:3 8170:2 159|18656",	-- Powerful Seaforium Charge
	[16000] = "19795|E275|12359:6|16047",	-- Thorium Tube
	[15997] = "19800|E285|12359:2 15992|16051|200",	-- Thorium Shells
	[16005] = "19799|E285|15994:2 11371 15992:3 14047:3|16049|3",	-- Dark Iron Bomb
	[16006] = "19815|E285|12360 14227|16050",	-- Delicate Arcanite Converter
	[18638] = "23081|E290|11371:4 18631:3 7080:6 7910:4 12800:2|18657",	-- Hyper-Radiant Flame Reflector
	[16008] = "19825|E290|10500 12364:2 12810:4|16053",	-- Master Engineer's Goggles
	[16009] = "19819|E290|16006:2 10558 15994 12799|16052",	-- Voice Amplification Modulator
	[18282] = "22795|E300|17010:4 17011:2 12360:6 16006:2 16000:2|18292",	-- Core Marksman Rifle
	[18168] = "22797|E300|12360:6 16006:2 7082:8 12803:12 7076:8|18291",	-- Force Reactive Disk
	[16022] = "19830|E300|10576 16006:8 12655:10 15994:6 10558:4 12810:6|16054",	-- Arcanite Dragonling
	[18283] = "22793|E300|17011:2 7076:2 16006:4 11371:6 16000|18290",	-- Biznicks 247x128 Accurascope
	[19999] = "24356|E300|19726:4 19774:5 16006:2 12804:8 12810:4|20000",	-- Bloodvine Goggles
	[19998] = "24357|E300|19726:5 19774:5 16006 12804:8 12810:4|20001",	-- Bloodvine Lens
	[16007] = "19833|E300|12360:10 16000:2 7078:2 7076:2 12800:2 12810:2|16056",	-- Flawless Arcanite Rifle
	[18639] = "23082|E300|11371:8 18631:4 12803:6 12808:4 12800:2 12799:2|18658",	-- Ultra-Flash Shadow Reflector
	[16040] = "19831|E300|16006 12359:3 14047|16055|3",	-- Arcane Bomb
	[23781] = "30303|E300|22574 22573:2||4",	-- Elemental Blasting Powder
	[23736] = "30310|E300|23782 23783:2 23781||4",	-- Fel Iron Bomb
	[23782] = "30304|E300|23445:3",	-- Fel Iron Casing
	[18232] = "22704|E300|12359:12 7191:2",	-- Field Repair Bot 74A (New Mats in 2.3)
	[23783] = "30305|E300|23445",	-- Handful of Fel Iron Bolts
	[23821] = "30548|E305|23782:2 23783:2 21886:4 16006|23888",	-- Zapthrottle Mote Extractor
	[23772] = "30346|E310|23445:2 23781||200",	-- Fel Iron Shells
	[23742] = "30312|E320|4400 23782:3 23783:8",	-- Fel Iron Musket
	[23774] = "30348|E325|23782 23445:5 23783:2|23816",	-- Fel Iron Toolbox
	[23784] = "30306|E325|23446:4 22452",	-- Adamantite Frame
	[23737] = "30311|E325|23446:4 23783:2 23781||3",	-- Adamantite Grenade
	[23767] = "30337|E325|23784 23782:2 10558 23783:2|23810",	-- Crashin' Thrashin' Robot
    [33092] = "30551|E330|23782 23783 21887:2 22829:20|23883", -- Healing Potion Injector, added after r45586 -- also 35310
    [33093] = "30552|E330|23782 23783 21887:2 22832:20|23884", -- Mana Potion Injector, added after r45586 -- also 35311
	[34504] = "30347|E335|23446 23781:2 4470:4|23815",	-- Adamantite Shell Machine (Changed in 2.3)
	[23764] = "30329|E335|23446:8 23112:2|23807",	-- Adamantite Scope
	[23771] = "30344|E335|23781 21877 2605|23814|3",	-- Green Smoke Flare
	[32423] = "39971|E335|21885 23781:2 21877:2||10",	-- Icy Blasting Primers
	[25886] = "32814|E335|23781 21877 4342|25887|3",	-- Purple Smoke Flare
	[23768] = "30341|E335|23781 21877|23811|3",	-- White Smoke Flare
    [20475] = "43676|E335|23446 4470 23783|33804", -- Adamantite Arrow Maker
	[23758] = "30316|E340|23793:4 23077:2 22445:8|23803",	-- Cogspinner Goggles
	[23761] = "30317|E340|23793:4 21929:2 22445:8|23804",	-- Power Amplification Goggles
	[32478] = "41317|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Deathblow X11 Goggles
	[32494] = "41320|E350|23793:6 23786 23785:2 23787:4 23572 23438:2",	-- Destruction Holo-gogs
	[32461] = "40274|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Furious Gizmatic Goggles
	[32476] = "41315|E350|23793:6 23786 23785:2 23787:4 23572 23436:2",	-- Gadgetstorm Goggles
	[32472] = "41311|E350|23793:6 23786 23785:2 23787:4 23572 23440:2",	-- Justicebringer 2000 Specs
	[32475] = "41316|E350|23793:6 23786 23785:2 23787:4 23572 23439:2",	-- Living Replicator Specs
	[32480] = "41319|E350|23793:6 23786 23785:2 23787:4 23572 23437:2",	-- Magnified Moon Specs
	[32495] = "41321|E350|23793:6 23786 23785:2 23787:4 23572 23439:2",	-- Powerheal 4000 Lens
	[32474] = "41314|E350|23793:6 23786 23785:2 23787:4 23572 23441:2",	-- Surestrike Goggles v2.0
	[32473] = "41312|E350|23793:6 23786 23785:2 23787:4 23572 23437:2",	-- Tankatronic Goggles
	[32479] = "41318|E350|23793:6 23786 23785:2 23787:4 23572 23440:2",	-- Wonderheal XT40 Shades
	[23762] = "30318|E350|23793:4 23449:2 23079:2 22448:2|23805",	-- Ultra-Spectropic Detection Goggles
	[23746] = "30313|E350|16000:2 23784:2 23783:4|23799",	-- Adamantite Rifle
	[23819] = "30547|E350|23781:2 23782 23783|23874|2",	-- Elemental Seaforium Charge
	[23787] = "30309|E350|23448:2",	-- Felsteel Stabilizer
	[23785] = "30307|E350|23573:3",	-- Hardened Adamantite Tube
	[23786] = "30308|E350|23449:3 21884",	-- Khorium Power Core
    [34060] = "44155|E350|23784:2 23445:30 23783:8 11291:8 23446:5 23819:4", -- Flying Machine Control
	[23824] = "30556|E355|23793:8 23786:2 23785:2 23787:4|23887",	-- Rocket Boots Xtreme
	[23747] = "30314|E360|23785 23787:4 23783:4|23800",	-- Felsteel Boomstick
	[23763] = "30325|E360|23793:4 23449:2 23441:2 22449:2|23806",	-- Hyper-Vision Goggles
	[23765] = "30332|E360|23785 23449:4 23440:2|23808",	-- Khorium Scope
    [34113] = "44391|E360|23446:8 23783:8 23786|34114|5", -- Field Repair Bot110g
	[32756] = "41307|E375|23785 23449:20 23787:4 21884:12 22451:12 23572",	-- Gyro-balanced Khorium Destroyer
	[23748] = "30315|E375|23785:2 23449:12 23783:4 23439:2|23802",	-- Ornate Khorium Rifle
	[23766] = "30334|E375|23785:2 23787:6 23438:2|23809",	-- Stabilized Eternium Scope
	--[23820] = "30549|E375|23784 23783:2 10558",	-- Critter Enlarger [currently not in game since TBC beta] 2.1.2
	[35] = "39973|E375|32423 23782 23783||5|32413",	-- Frost Grenades
	--[23769] = "30342|E375|23781 21877 2604||3",	-- Red Smoke Flare [currently only available at vendor] 2.1.2
--[[ Gnomish Engineering --]]
	[10716] = "12899|Eg205|10559 10560 3860:4 8151:4 1529:2",	-- Gnomish Shrink Ray
	[36] = "12895|Eg205|10648 10647|||10713",	-- Inlaid Mithril Cylinder Plans
	[11826] = "15633|Eg205|7075 4389:2 7191 3860:2 6037|11827",	-- Lil' Smoky
	[10545] = "12897|Eg210|10500 10559 10558:2 8151:2 4234:2",	-- Gnomish Goggles
	[10720] = "12902|Eg210|10559 10285:2 4337:4 10505:2 3860:4",	-- Gnomish Net-o-Matic Projector
	[10724] = "12905|Eg225|10026 10559:2 4234:4 10505:8 4389:4",	-- Gnomish Rocket Boots
	[10725] = "12906|Eg230|10561 6037:6 3860:6 9060:2 10558 1529:2",	-- Gnomish Battle Chicken
	[10726] = "12907|Eg235|3860:10 6037:4 10558 7910:2 4338:4",	-- Gnomish Mind Control Cap
	[10645] = "12759|Eg240|10559:2 10560 12808 7972:4 9060",	-- Gnomish Death Ray
	[37] = "23489|Eg260|3860:12 18631:2 7075:4 7079:2 7909:4 9060|||18986",	-- Ultrasafe Transporter - Gadgetzan
	[18660] = "23129|Eg260|10561 15994:2 10558 10560 3864|18661",	-- World Enlarger
	[38] = "23096|Eg265|12359:4 15994:2 8170:4 7910 7191|18654||18645",	-- Alarm-O-Bot
	[23841] = "30568|Eg325|23784 23783:2 21884 23782||3",	-- Gnomish Flame Turret
	[23835] = "30569|Eg340|23785:2 23786:2 22445:10 22449:2",	-- Gnomish Poultryizer
	[39] = "30570|Eg350|23793:8 23786:4 21886:10 22456:10 16006:2|||23825",	-- Nigh-Invulnerability Belt
	[40] = "36955|Eg350|23784 22451:2 23787:2 23783:4 23786|||30544",	-- Ultrasafe Transporter - Toshley's Station
	[23829] = "30575|Eg375|23793:8 22456:12 22452:12 21884:12 23436:2",	-- Gnomish Battle Goggles
	[23828] = "30574|Eg375|24271:4 21884:8 22451:8 22452:8 21885:8 23437:2",	-- Gnomish Power Goggles
--[[ Goblin Engineering --]]
	[10543] = "12718|Eb205|3860:8 3864 7068:4",	-- Goblin Construction Helmet
	[10542] = "12717|Eb205|3860:8 3864 7067:4",	-- Goblin Mining Helmet
	[41] = "12715|Eb205|10648 10647|||10644",	-- Goblin Rocket Fuel Recipe
	[10646] = "12760|Eb205|4338 10505:3 10560",	-- Goblin Sapper Charge
	[11825] = "15628|Eb205|4394 7077 7191 3860:6|11828",	-- Pet Bombling
	[42] = "12716|Eb205|10559:2 3860:4 10505:5 10558 7068|||10577",	-- Goblin Mortar
	[43] = "13240|Eb205|10577 3860 10505:3|||10577",	-- The Mortar: Reloaded
	[7189] = "8895|Eb225|10026 10559:2 4234:4 9061:2 10560",	-- Goblin Rocket Boots
	[10587] = "12755|Eb230|10561:2 10505:4 6037:6 10560 4407:2",	-- Goblin Bomb Dispenser
	[10586] = "12754|Eb235|10561 9061 10507:6 10560||2",	-- The Big One
	[10727] = "12908|Eb240|10559:2 9061:4 3860:6 6037:6 10560",	-- Goblin Dragon Gun
	[10588] = "12758|Eb245|10543 9061:4 3860:4 10560",	-- Goblin Rocket Helmet
	[18984] = "23486|Eb260|3860:10 18631 7077:4 7910:2 10586",	-- Dimensional Ripper - Everlook
	[18587] = "23078|Eb265|15994:2 18631:2 7191:2 14227:2 7910:2|18653",	-- Goblin Jumper Cables XL
	[23826] = "30558|Eb325|23782:3 23781:6 17020:3 23783:2||3",	-- The Bigger One
	[23827] = "30560|Eb340|21877:4 23781:4 22457||2",	-- Super Sapper Charge
	[23836] = "30563|Eb350|23785:2 23786 23787:2 21884:6 22452:6 16006:2",	-- Goblin Rocket Launcher
	[30542] = "36954|Eb350|23784 21884:2 23826:2 23783:4 23786",	-- Dimensional Ripper - Area 52
	[23838] = "30565|Eb375|24272:4 22457:12 22451:12",	-- Foreman's Enchanted Helmet
	[23839] = "30566|Eb375|23573:8 22452:12 21884:12",	-- Foreman's Reinforced Helmet
--[[ First Aid --]]
	[1251] = "3275|X1|2589",	-- Linen Bandage
	[2581] = "3276|X40|2589:2",	-- Heavy Linen Bandage
	[6452] = "7934|X80|1475||3",	-- Anti-Venom
	[3530] = "3277|X80|2592",	-- Wool Bandage
	[3531] = "3278|X115|2592:2",	-- Heavy Wool Bandage
	[6453] = "7935|X130|1288|6454|3",	-- Strong Anti-Venom
	[6450] = "7928|X150|4306",	-- Silk Bandage
	[6451] = "7929|X180|4306:2|16112",	-- Heavy Silk Bandage
	[8544] = "10840|X210|4338|16113",	-- Mageweave Bandage
	[8545] = "10841|X240|4338:2",	-- Heavy Mageweave Bandage
	[14529] = "18629|X260|14047",	-- Runecloth Bandage
	[14530] = "18630|X290|14047:2",	-- Heavy Runecloth Bandage
	[19440] = "23787|X300|19441|19442",	-- Powerful Anti-Venom
	[21990] = "27032|X330|21877|21992",	-- Netherweave Bandage
	[21991] = "27033|X360|21877:2|21993",	-- Heavy Netherweave Bandage
--[[ Jewelcrafting --]]
	[20906] = "25493|J1|20816:2",	-- Braided Copper Ring
	[21931] = "26925|J1|20816:2 2840",	-- Woven Copper Ring
	[20816] = "25255|J1|2840:2",	-- Delicate Copper Wire
	[25498] = "32259|J1|2835:8",	-- Rough Stone Statue
	[21932] = "26926|J5|2840:4 20816:2",	-- Heavy Copper Ring
	[25438] = "32178|J20|774 20816",	-- Malachite Pendant
	[25439] = "32179|J20|818 20816",	-- Tigerseye Band
	[20821] = "25283|J30|774:2 2840:2",	-- Inlaid Malachite Ring
	[21934] = "26928|J30|818:2 2840:2 20816",	-- Ornate Tigerseye Necklace
	[20818] = "25280|J50|2842",	-- Elegant Silver Ring
	[20907] = "25490|J50|2841:4",	-- Solid Bronze Ring
	[21933] = "26927|J50|2841:2 1210 20816",	-- Thick Bronze Necklace
	[20817] = "25278|J50|2841:2",	-- Bronze Setting
	[25880] = "32801|J50|2836:8",	-- Coarse Stone Statue
	[20820] = "25284|J60|5498 20817 2840:2",	-- Simple Pearl Ring
	[30804] = "37818|J65|2841:2 20817 774:3 818:3 1210:2",	-- Bronze Band of Force
	[20823] = "25287|J70|1210:2 20817 20816:2",	-- Gloom Band
	[30419] = "36523|J75|2841:4 20817 1206",	-- Brilliant Necklace
	[31154] = "38175|J80|2841:6 20817 1705",	-- Bronze Torc
	[20827] = "25317|J80|2842:2",	-- Ring of Silver Might
	[20826] = "25305|J90|2842:2 20817 1206 1705",	-- Heavy Silver Ring
	[20828] = "25318|J100|1210:2 2841:2",	-- Ring of Twilight Shadows
	[30420] = "36524|J105|1529 20817 3575:2",	-- Heavy Jade Ring
	[20830] = "25339|J110|1705:2 20817|20854",	-- Amulet of the Moon
	[20909] = "25498|J110|3575:8 5637:2 20817:2",	-- Barbaric Iron Collar
	[25881] = "32807|J110|2838:8",	-- Heavy Stone Statue
	[20832] = "25321|J120|1705:3 5498:3 11083:4 2842:4 3827:2",	-- Moonsoul Crown
	[20950] = "25610|J120|1206 20817|20970",	-- Pendant of the Agate Shield
	[20954] = "25612|J125|3575:8 3391:2|20971",	-- Heavy Iron Knuckles
	[20833] = "25323|J125|1705 3824 3575:4|20855",	-- Wicked Moonstone Ring
	[20955] = "25613|J135|1529 3577:2 20816:2",	-- Golden Dragon Ring
	[20958] = "25617|J150|3864 20963|20973",	-- Blazing Citrine Ring
	[20831] = "25320|J150|3577 1206:2 3391|20856",	-- Heavy Golden Necklace of Battle
	[20963] = "25615|J150|3860:2",	-- Mithril Filigree
	[20966] = "25618|J160|1529 20963:2|20974",	-- Jade Pendant of Blasting
	[20960] = "25620|J170|6037 20963:2",	-- Engraved Truesilver Ring
	[20959] = "25619|J170|1529 7067:2|20975",	-- The Jade Eye
	[25882] = "32808|J175|7912:10",	-- Solid Stone Statue
	[29157] = "34955|J180|3577:4 1705 1529 3864",	-- Golden Ring of Power
	[20961] = "25621|J180|3864 7070:2 3860:2",	-- Citrine Ring of Rapid Healing
	[20967] = "25622|J190|3864 7070:2 3577:2 20817|20976",	-- Citrine Pendant of Golden Healing
	[29158] = "34959|J200|6037:3 7910:2 3864:2",	-- Truesilver Commander's Ring
	[21756] = "26873|J200|3577:6 3864:2|21940",	-- Figurine - Golden Hare
	[21748] = "26872|J200|1529:4 6037:2 11137:4 20963:4",	-- Figurine - Jade Owl
	[20964] = "26874|J210|7909:3 8151:4",	-- Aquamarine Signet
	[21758] = "26875|J215|7971:4 8151:4|21941",	-- Figurine - Black Pearl Panther
	[21755] = "26876|J220|7909 20963:3",	-- Aquamarine Pendant of the Warrior
	[20969] = "26878|J225|7910:2 7971:2 6037:4 21752:4 6149:4|21942",	-- Ruby Crown of Restoration
	[21760] = "26881|J225|7909:2 6037:4 7075:2 7079:2 8151:4|21943",	-- Figurine - Truesilver Crab
	[25883] = "32809|J225|12365:10",	-- Dense Stone Statue
	[21752] = "26880|J225|12359",	-- Thorium Setting
	[30421] = "36525|J230|7910 21752",	-- Red Ring of Destruction
	[21763] = "26882|J235|7910:2 6037:4 7077:2 7081:2 8151:4|21944",	-- Figurine - Truesilver Boar
	[21764] = "26883|J235|7910 21752",	-- Ruby Pendant of Fire
	[21765] = "26885|J240|6037:2 10286:2",	-- Truesilver Healing Ring
	[21754] = "26887|J245|7909 21752|21945",	-- The Aquamarine Ward
	[21753] = "26896|J250|7909:2 3864:2 21752:4 6037:2|21947",	-- Gem Studded Band
	[21766] = "26897|J250|12799:2 21752:2 6037:4 11178:2 20963:2|21948",	-- Opal Necklace of Impact
	[21769] = "26900|J260|7910:2 7078:2 8152:4 6037:2|21949",	-- Figurine - Ruby Serpent
	[21767] = "26902|J260|12799 21752",	-- Simple Opal Ring
	[30422] = "36526|J265|12800 21752",	-- Diamond Focus Ring
	[21774] = "26906|J275|12364:2 12799:2 12361:2 12360:2 12359:2|21952",	-- Emerald Crown of Destruction
	[21768] = "26903|J275|12361:4 6037:2 21752",	-- Sapphire Signet
	[29159] = "34960|J280|12800:2 21752",	-- Glowing Thorium Band
	[21775] = "26907|J280|21752 12804 7076",	-- Onslaught Ring
	[21790] = "26908|J280|12361 12808 21752",	-- Sapphire Pendant of Winter Night
	[21777] = "26909|J285|12364:2 12360:2 12359:2 12804:4|21953",	-- Figurine - Emerald Owl
	[21778] = "26910|J285|12363 12808:2 12662|21954",	-- Ring of Bitter Shadows
	[21791] = "26911|J290|12364:2 12803:4 12804:4",	-- Living Emerald Pendant
	[29160] = "34961|J290|12364:2 21752",	-- Emerald Lion Ring
	[21784] = "26912|J300|18335:4 11754:4 12800:2 12360:2 12359:4|21955",	-- Figurine - Black Diamond Crab
	[21789] = "26914|J300|11371:4 12360:2 7910:2|21956",	-- Figurine - Dark Iron Scorpid
	[23113] = "28938|J300|23112|23148",	-- Brilliant Golden Draenite
	[23108] = "28925|J300|23107|23144",	-- Glowing Shadow Draenite
	[23098] = "28910|J300|21929|23135",	-- Inscribed Flame Spessarite
	[23103] = "28916|J300|23079|23140",	-- Radiant Deep Peridot
	[23118] = "28950|J300|23117|23152",	-- Solid Azure Moonstone
	[23094] = "28903|J300|23077|23130",	-- Teardrop Blood Garnet
	[21792] = "26915|J305|12800:2 21752:2 12360:2|21957",	-- Necklace of the Diamond Tower
	[23095] = "28905|J305|23077|23131",	-- Bold Blood Garnet
	[28595] = "34590|J305|23077|28596",	-- Bright Blood Garnet
	[23114] = "28944|J305|23112|23149",	-- Gleaming Golden Draenite
	[23104] = "28917|J305|23079|23141",	-- Jagged Deep Peridot
	[23099] = "28912|J305|21929|23136",	-- Luminous Flame Spessarite
	[23109] = "28927|J305|23107|23145",	-- Royal Shadow Draenite
	[23119] = "28953|J305|23117|23153",	-- Sparkling Azure Moonstone
	[21779] = "26916|J310|21929 7078:4 12803:4",	-- Band of Natural Fire
	[24074] = "31048|J310|23445 23077:2",	-- Fel Iron Blood Ring
	[24075] = "31049|J310|23445 23112:2",	-- Golden Draenite Ring
	[23105] = "28918|J315|23079|23142",	-- Enduring Deep Peridot
	[23100] = "28914|J315|21929|23137",	-- Glinting Flame Spessarite
	[23096] = "28906|J315|23077|23133",	-- Runed Blood Garnet
	[23110] = "28933|J315|23107|23146",	-- Shifting Shadow Draenite
	[23120] = "28955|J315|23117|23154",	-- Stormy Azure Moonstone
	[23115] = "28947|J315|23112|23150",	-- Thick Golden Draenite
	[24076] = "31050|J320|23445 23117:2 23079",	-- Azure Moonstone Ring
	[32772] = "41414|J325|24478:8 23447:2",	-- Brilliant Pearl Band
	[31079] = "38068|J325|24243:4 22452",	-- Mercurial Adamantite
	[23106] = "28924|J325|23079|23143",	-- Dazzling Deep Peridot
	[23097] = "28907|J325|23077|23134",	-- Delicate Blood Garnet
	[23121] = "28957|J325|23117|23155",	-- Lustrous Azure Moonstone
	[23101] = "28915|J325|21929|23138",	-- Potent Flame Spessarite
	[32833] = "41420|J325|24478 27860",	-- Purified Jaggal Pearl
	[23116] = "28948|J325|23112|23151",	-- Rigid Golden Draenite
	[28290] = "34069|J325|23112|28291",	-- Smooth Golden Draenite
	[23111] = "28936|J325|23107|23147",	-- Sovereign Shadow Draenite
	[32774] = "41415|J330|24479 31079:4",	-- The Black Pearl
	[24078] = "31052|J335|23446 31079",	-- Heavy Adamantite Ring
	[24077] = "31051|J335|23446:2 31079",	-- Thick Adamantite Necklace
	[32508] = "40514|J340|22578:3 24478:10 24479",	-- Necklace of the Deep
	[24087] = "31058|J345|23448:2 31079:4|24163",	-- Heavy Felsteel Ring
	[31863] = "39463|J350|23441|31876",	-- Balanced Nightseye, pattern added
	[24027] = "31084|J350|23436|24193",	-- Bold Living Ruby, pattern added
	[24031] = "31089|J350|23436|24192",	-- Bright Living Ruby, pattern added --also 35306
	[24047] = "31096|J350|23440|24203",	-- Brilliant Dawnstone, pattern in
	[24065] = "31112|J350|23437|24219",	-- Dazzling Talasite, pattern in
	[24028] = "31085|J350|23436|24194",	-- Delicate Living Ruby, pattern in
	[24062] = "31110|J350|23437|24217",	-- Enduring Talasite, pattern in
	[24036] = "31091|J350|23436|24198",	-- Flashing Living Ruby, pattern in
	[24050] = "31099|J350|23440|24206",	-- Gleaming Dawnstone, pattern in
	[24061] = "31109|J350|23439|24216",	-- Glinting Noble Topaz, pattern in
	[24056] = "31104|J350|23441|24211",	-- Glowing Nightseye, pattern in
	[31861] = "39452|J350|23440|31875",	-- Great Dawnstone, pattern added
	[31865] = "39462|J350|23441|31877",	-- Infused Nightseye
	[24058] = "31106|J350|23439|24213",	-- Inscribed Noble Topaz, pattern in
	[24067] = "31113|J350|23437|24220",	-- Jagged Talasite, pattern in
	[24079] = "31053|J350|23449:2 31079:3 22456:3|24158",	-- Khorium Band of Shadows, pattern in
	[24060] = "31108|J350|23439|24215",	-- Luminous Noble Topaz, pattern in
	[24037] = "31094|J350|23438|24201",	-- Lustrous Star of Elune, pattern in
	[24053] = "31101|J350|23440|24208",	-- Mystic Dawnstone
	[24059] = "31107|J350|23439|24214",	-- Potent Noble Topaz, pattern in 
	[32836] = "41429|J350|24479 27860",	-- Purified Shadow Pearl
	[24066] = "31111|J350|23437|24218",	-- Radiant Talasite, pattern in 
	[24051] = "31098|J350|23440|24205",	-- Rigid Dawnstone, pattern in -- also 35307
	[24057] = "31105|J350|23441|24212",	-- Royal Nightseye, pattern in 
	[24030] = "31088|J350|23436|24196",	-- Runed Living Ruby, pattern in  --also 35305
	[24055] = "31103|J350|23441|24210",	-- Shifting Nightseye, pattern in 
	[24048] = "31097|J350|23440|24204",	-- Smooth Dawnstone, pattern in
	[24033] = "31092|J350|23438|24199",	-- Solid Star of Elune, pattern in -- also 35304
	[24054] = "31102|J350|23441|24209",	-- Sovereign Nightseye, pattern in
	[24035] = "31149|J350|23438|24200",	-- Sparkling Star of Elune, pattern in
	[24039] = "31095|J350|23438|24202",	-- Stormy Star of Elune, pattern in
	[24032] = "31090|J350|23436|24197",	-- Subtle Living Ruby, pattern in
	[24029] = "31087|J350|23436|24195",	-- Teardrop Living Ruby, pattern in
	[24052] = "31100|J350|23440|24207",	-- Thick Dawnstone, pattern in
	[31867] = "39470|J350|23439|31878",	-- Veiled Noble Topaz
	[31868] = "39471|J350|23439|31879",	-- Wicked Noble Topaz
    [33782] = '43493|J350|23437|33783|1|33782', --Steady Talasite
	[24088] = "31060|J355|23447 31079:5|24164",	-- Delicate Eternium Ring
	[24080] = "31054|J355|23449:2 31079:4 21885:3|24159",	-- Khorium Band of Frost
	[24082] = "31055|J355|23449:2 31079:4 21884:3|24160",	-- Khorium Inferno Band
	[24110] = "31068|J355|23449:4 31079 23436|24167",	-- Living Ruby Pendant
	[24106] = "31067|J355|23448:2 31079:3|24166",	-- Thick Felsteel Necklace
	[24114] = "31070|J360|23447:2 31079:3|24168",	-- Braided Eternium Chain
	[24116] = "31071|J360|23573:2 31079:2 23441|24169",	-- Eye of the Night
	[24085] = "31056|J360|23449:2 31079:4 21886:3|24161",	-- Khorium Band of Leaves
	[24092] = "31062|J360|23448:2 21885:6 21884:4 31079|24174",	-- Pendant of Frozen Flame
	[24097] = "31065|J360|23448:2 21886:6 22456:4 31079|24177",	-- Pendant of Shadow's End
	[24093] = "31063|J360|23448:2 21884:6 21885:4 31079|24175",	-- Pendant of Thawing
	[24098] = "31066|J360|23448:2 22457:8 31079|24178",	-- Pendant of the Null Rune
	[24095] = "31064|J360|23448:2 22456:6 21886:4 31079|24176",	-- Pendant of Withering
	[30825] = "37855|J360|23447:2 22457:8|30826",	-- Ring of Arcane Shielding
	[24086] = "31057|J365|23449:2 31079:4 22457:3|24162",	-- Arcane Khorium Band
	[24089] = "31061|J365|23447:2 31079:4 21884:4|24165",	-- Blazing Eternium Band
	[25897] = "32867|J365|25867|25903",	-- Bracing Earthstorm Diamond
	[25899] = "32869|J365|25867|25906",	-- Brutal Earthstorm Diamond
	[24121] = "31076|J365|23449:2 31079:4 23117:2|24171",	-- Chain of the Twilight Owl
	[32776] = "41418|J365|23449:12 31079:4 24478:20 24479:3",	-- Crown of the Sea Witch
	[25890] = "32871|J365|25868|25907",	-- Destructive Skyfire Diamond
	[24117] = "31072|J365|23447:2 31079:4 23112:2|24170",	-- Embrace of the Dawn
	[25895] = "32874|J365|25868|25910",	-- Enigmatic Skyfire Diamond
	[25901] = "32870|J365|25867|25904",	-- Insightful Earthstorm Diamond
	[25893] = "32872|J365|25868|25909",	-- Mystical Skyfire Diamond
	[25896] = "32866|J365|25867|25902",	-- Powerful Earthstorm Diamond
	[32409] = "39961|J365|25867|32412",	-- Relentless Earthstorm Diamond
	[25894] = "32873|J365|25868|25908",	-- Swift Skyfire Diamond
	[25898] = "32868|J365|25867|25905",	-- Tenacious Earthstorm Diamond
	[32410] = "39963|J365|25868|32411",	-- Thundering Skyfire Diamond
    [33140] = '42592|J365|23440|33159|1|33140', -- Blood of Amber
    [33131] = '42589|J365|23436|33156|1|33131', -- Crimson Sun
    [33133] = '42558|J365|23436|33305|1|33133', -- Don Julio's Heart
    [33144] = '42593|J365|23440|33160|1|33144', --Facet of Eternity
    [33135] = '42590|J365|23438|33157|1|33135', --Falling Star
    [33134] = '42588|J365|23436|33155|1|33134', --Kailee's Rose
    [33143] = '42591|J365|23440|33158|1|33143', --Stone of Blades
    [34220] = "44794|J365|25868|34221", --Chaotic Skyfire Diamond
	[24123] = "31078|J370|23448:20 22457:20 23438:2 31079:5|24173",	-- Circlet of Arcane Might
	[44] = "31077|J370|23449:20 21886:20 23437:2 31079:5|24172||24122",	-- Coronet of the Verdant Flame
	[24125] = "31080|J370|23449:4 23440:2 23112:4|24180",	-- Figurine - Dawnstone Crab
	[24124] = "31079|J370|23448:8 23077:2 22452:4|24179",	-- Figurine - Felsteel Boar
	[24126] = "31081|J370|23448:2 23436:2 21884:4|24181",	-- Figurine - Living Ruby Serpent
	[24128] = "31083|J370|23573:6 23441:2 22456:2|24183",	-- Figurine - Nightseye Panther
	[24127] = "31082|J370|23447:2 23437:2 22457:4|24182",	-- Figurine - Talasite Owl
	[32213] = "39729|J375|32230|32299",	-- Balanced Shadowsong Amethyst
	[32193] = "39705|J375|32227|32274",	-- Bold Crimson Spinel
	[32197] = "39712|J375|32227|32283",	-- Bright Crimson Spinel
	[32204] = "39719|J375|32229|32290",	-- Brilliant Lionseye
	[32225] = "39741|J375|32249|32311",	-- Dazzling Seaspray Emerald
	[32194] = "39706|J375|32227|32277",	-- Delicate Crimson Spinel
	[32223] = "39739|J375|32249|32309",	-- Enduring Seaspray Emerald
	[32199] = "39714|J375|32227|32285",	-- Flashing Crimson Spinel
	[32207] = "39722|J375|32229|32293",	-- Gleaming Lionseye
	[32220] = "39736|J375|32231|32306",	-- Glinting Pyrestone
	[32215] = "39731|J375|32230|32301",	-- Glowing Shadowsong Amethyst
	[32210] = "39725|J375|32229|32296",	-- Great Lionseye
	[32214] = "39730|J375|32230|32300",	-- Infused Shadowsong Amethyst
	[32217] = "39733|J375|32231|32303",	-- Inscribed Pyrestone
	[32226] = "39742|J375|32249|32312",	-- Jagged Seaspray Emerald
	[32219] = "39735|J375|32231|32305",	-- Luminous Pyrestone
	[32202] = "39717|J375|32228|32288",	-- Lustrous Empyrean Sapphire
	[32209] = "39724|J375|32229|32295",	-- Mystic Lionseye
	[32218] = "39734|J375|32231|32304",	-- Potent Pyrestone
	[32224] = "39740|J375|32249|32310",	-- Radiant Seaspray Emerald
    [32206] = '39721|J375|32229|32292', --Rigid Lionseye
	[32216] = "39732|J375|32230|32302",	-- Royal Shadowsong Amethyst
	[32196] = "39711|J375|32227|32282",	-- Runed Crimson Spinel
	[32212] = "39728|J375|32230|32298",	-- Shifting Shadowsong Amethyst
	[32205] = "39720|J375|32229|32291",	-- Smooth Lionseye
	[32200] = "39715|J375|32228|32286",	-- Solid Empyrean Sapphire
	[32211] = "39727|J375|32230|32297",	-- Sovereign Shadowsong Amethyst
	[32201] = "39716|J375|32228|32287",	-- Sparkling Empyrean Sapphire
	[32203] = "39718|J375|32228|32289",	-- Stormy Empyrean Sapphire
	[32198] = "39713|J375|32227|32284",	-- Subtle Crimson Spinel
	[32195] = "39710|J375|32227|32281",	-- Teardrop Crimson Spinel
	[31398] = "38503|J375|31079:4 23449:2 21885:6 21884:6|31401",	-- The Frozen Eye
	[31399] = "38504|J375|31079:4 23448:2 21886:6 22456:6|31402",	-- The Natural Ward
	[32208] = "39723|J375|32229|32294",	-- Thick Lionseye
	[32221] = "39737|J375|32231|32307",	-- Veiled Pyrestone
	[32222] = "39738|J375|32231|32308",	-- Wicked Pyrestone
	[32206] = "39721|J375|32229",	-- Rigid Lionseye
	[31862] = "39455|J325|23107|31871",	-- Balanced Shadow Draenite
	[31860] = "39451|J325|23112|31870",	-- Great Golden Draenite
	[31864] = "39458|J325|23107|31872",	-- Infused Shadow Draenite
	[31866] = "39466|J325|21929|31873",	-- Veiled Flame Spessarite
	[31869] = "39467|J325|21929|31874",	-- Wicked Flame Spessarite
--[[ Leatherworking --]]
	[2302] = "2149|L1|2318:2 2320",	-- Handstitched Leather Boots
	[7277] = "9059|L1|2318:2 2320:3",	-- Handstitched Leather Bracers
	[7276] = "9058|L1|2318:2 2320",	-- Handstitched Leather Cloak
	[5957] = "7126|L1|2318:3 2320",	-- Handstitched Leather Vest
	[2304] = "2152|L1|2318",	-- Light Armor Kit
	[2318] = "2881|L1|2934:3",	-- Light Leather
	[2303] = "2153|L15|2318:4 2320",	-- Handstitched Leather Pants
	[4237] = "3753|L25|2318:6 2320",	-- Handstitched Leather Belt
	[7278] = "9060|L30|2318:4 2320:2",	-- Light Leather Quiver
	[7279] = "9062|L30|2318:3 2320:4",	-- Small Leather Ammo Pouch
	[7280] = "9064|L35|2318:5 2320:5|7288",	-- Rugged Leather Pants
	[4231] = "3816|L35|783 4289",	-- Cured Light Hide
	[2300] = "2160|L40|2318:8 2320:4",	-- Embossed Leather Vest
	[5081] = "5244|L40|5082:3 2318:4 2320|5083",	-- Kodo Hide Bag
	[2309] = "2161|L55|2318:8 2320:5",	-- Embossed Leather Boots
	[4239] = "3756|L55|2318:3 2320:2",	-- Embossed Leather Gloves
	[2310] = "2162|L60|2318:5 2320:2",	-- Embossed Leather Cloak
	[2311] = "2163|L60|2318:8 2320:2 2324|2407",	-- White Leather Jerkin
	[7281] = "9065|L70|2318:6 2320:4",	-- Light Leather Bracers
	[4242] = "3759|L75|4231 2318:6 2320:2",	-- Embossed Leather Pants
	[2312] = "2164|L75|4231 2318:4 2320:2|2408",	-- Fine Leather Gloves
	[4246] = "3763|L80|2318:6 2320:2",	-- Fine Leather Belt
	[2308] = "2159|L85|2318:10 2321:2",	-- Fine Leather Cloak
	[4243] = "3761|L85|4231:3 2318:6 2320:4",	-- Fine Leather Tunic
	[6466] = "7953|L90|6470:4 4231 2321|6474",	-- Deviate Scale Cloak
	[6709] = "8322|L90|2318:6 4231 2320:4 5498|6710",	-- Moonglow Vest
	[5780] = "6702|L90|5784:8 2318:6 2321|5786",	-- Murloc Scale Belt
	[2307] = "2158|L90|2318:7 2320:2|2406",	-- Fine Leather Boots
	[7282] = "9068|L95|2318:10 4231 2321",	-- Light Leather Pants
	[5781] = "6703|L95|5784:12 4231 2318:8 2321|5787",	-- Murloc Scale Breastplate
	[7283] = "9070|L100|7286:12 2319:4 2321|7289",	-- Black Whelp Cloak
	[20575] = "24940|L100|2319:8 7286:8 4231 2321:2|20576",	-- Black Whelp Tunic
	[2317] = "2169|L100|2319:6 2321 4340|2409",	-- Dark Leather Tunic
	[4244] = "3762|L100|4243 4231:2 2320:2|4293",	-- Hillman's Leather Vest
	[4233] = "3817|L100|4232 4289",	-- Cured Medium Hide
	[2315] = "2167|L100|2319:4 2321:2 4340",	-- Dark Leather Boots
	[2313] = "2165|L100|2319:4 2320",	-- Medium Armor Kit
	[2319] = "20648|L100|2318:4",	-- Medium Leather
	[6467] = "7954|L105|6470:5 2321:2|6475",	-- Deviate Scale Gloves
	[5958] = "7133|L105|2319:8 2997 2321|5972",	-- Fine Leather Pants
	[2316] = "2168|L110|2319:8 2321 4340",	-- Dark Leather Cloak
	[6468] = "7955|L115|6471:6 6470:4 2321:2|6476",	-- Deviate Scale Belt
	[5961] = "7135|L115|2319:12 4340 2321",	-- Dark Leather Pants
	[4248] = "3765|L120|2312 4233 2321 4340|7360",	-- Dark Leather Gloves
	[4250] = "3767|L120|2319:8 3383 2321:2|4294",	-- Hillman's Belt
	[7285] = "9074|L120|2457 2319:6 2321",	-- Nimble Leather Gloves
	[7284] = "9072|L120|7287:6 2319:4 2321|7290",	-- Red Whelp Gloves
	[2314] = "2166|L120|2319:10 4231:2 2321:2",	-- Toughened Leather Armor
	[4249] = "3766|L125|4246 4233 2321:2 4340",	-- Dark Leather Belt
	[7348] = "9145|L125|2319:8 5116:4 2321:2",	-- Fletcher's Gloves
	[4251] = "3768|L130|4233 2319:4 2321",	-- Hillman's Shoulders
	[4253] = "3770|L135|2319:4 4233:2 3389:2 3182:2 2321:2",	-- Toughened Leather Gloves
	[7352] = "9147|L135|2319:6 7067 2321:2|7362",	-- Earthen Leather Shoulders
	[7349] = "9146|L135|2319:8 3356:4 2321:2|7361",	-- Herbalist's Gloves
	[4252] = "3769|L140|2319:12 3390 4340 2321:2|4296",	-- Dark Leather Shoulders
	[7358] = "9148|L140|2319:10 5373:2 2321:2|7363",	-- Pilferer's Gloves
	[4255] = "3772|L145|4234:9 2605:2 2321:4|7613",	-- Green Leather Armor
	[7359] = "9149|L145|2319:12 7067:2 2997:2 2321:2|7364",	-- Heavy Earthen Gloves
	[4247] = "3764|L145|2319:14 2321:4",	-- Hillman's Leather Gloves
	[4254] = "3771|L150|4234:6 5637:2 2321|4297",	-- Barbaric Gloves
	[7372] = "9194|L150|4234:8 2321:2",	-- Heavy Leather Ammo Pouch
	[7371] = "9193|L150|4234:8 2321:2",	-- Heavy Quiver
	[4236] = "3818|L150|4235 4289:3",	-- Cured Heavy Hide
	[4265] = "3780|L150|4234:5 2321",	-- Heavy Armor Kit
	[4234] = "20649|L150|2319:5",	-- Heavy Leather
	[18662] = "23190|L150|4234:2 2321|18731",	-- Heavy Leather Ball
	[3719] = "3760|L150|4234:5 2321:2",	-- Hillman's Cloak
	[18948] = "23399|L155|4234:8 4236:2 5498:4 4461 5637:4|18949",	-- Barbaric Bracers
	[4456] = "4097|L155|4461:4 4234:4 2321:2|13288",	-- Raptor Hide Belt
	[4455] = "4096|L155|4461:6 4234:4 2321:2|13287",	-- Raptor Hide Harness
	[4257] = "3774|L160|4236 4234:5 2321 2605 7071",	-- Green Leather Belt
	[5962] = "7147|L160|4234:12 4305:2 2321:2",	-- Guardian Pants
	[7373] = "9195|L165|4234:10 2325 2321:2|7449",	-- Dusky Leather Leggings
	[5963] = "7149|L170|4234:10 2321:2 1206|5973",	-- Barbaric Leggings
	[4258] = "3775|L170|4236:2 4234:4 2321 7071|4298",	-- Guardian Belt
	[5782] = "6704|L170|5785:12 4236 4234:10 2321:3|5788",	-- Thick Murloc Armor
	[4262] = "3778|L175|4236:4 5500:2 1529:2 3864 2321|14635",	-- Gem-studded Leather Belt
	[5964] = "7151|L175|4234:8 4236 2321:2",	-- Barbaric Shoulders
	[7374] = "9196|L175|4234:10 3824 2321:2",	-- Dusky Leather Armor
	[7375] = "9197|L175|7392:4 4234:10 2321:2|7450",	-- Green Whelp Armor
	[4256] = "3773|L175|4236:2 4234:12 3824 2321:2|4299",	-- Guardian Armor
	[7377] = "9198|L180|4234:6 7067:2 7070:2 2321:2",	-- Frost Leather Cloak
	[4259] = "3776|L180|4236:2 4234:6 2605 2321",	-- Green Leather Bracers
	[7378] = "9201|L185|4234:16 2325 4291:2",	-- Dusky Bracers
	[5965] = "7153|L185|4234:14 4305:2 4291:2|5974",	-- Guardian Cloak
	[17721] = "21943|L190|4234:8 7067:4 4291|17722",	-- Gloves of the Greatfather
	[7386] = "9202|L190|7392:6 4234:8 4291:2|7451",	-- Green Whelp Bracers
	[5783] = "6705|L190|5785:16 4236 4234:14 4291|5789",	-- Murloc Scale Bracers
	[5739] = "6661|L190|4234:14 2321:2 7071",	-- Barbaric Harness
	[5966] = "7156|L190|4234:4 4236 4291",	-- Guardian Gloves
	[7387] = "9206|L195|4234:10 4305:2 2325:2 7071",	-- Dusky Belt
	[4260] = "3777|L195|4234:6 4236:2 4291|4300",	-- Guardian Leather Bracers
	[18238] = "22711|L200|4304:6 7428:8 7971:2 4236:2 1210:4 8343|18239",	-- Shadowskin Gloves
	[4264] = "3779|L200|4234:6 4236:2 4096:2 5633 4291 7071|4301",	-- Barbaric Belt
	[8174] = "10490|L200|4234:12 4236:2 4291:2|8384",	-- Comfortable Leather Hat
	[7390] = "9207|L200|4234:8 7428:2 3824 4291:2|7452",	-- Dusky Boots
	[7391] = "9208|L200|4234:10 2459:2 4337:2 4291|7453",	-- Swift Boots
	[8172] = "10482|L200|8169 8150",	-- Cured Thick Hide
	[8173] = "10487|L200|4304:5 4291",	-- Thick Armor Kit
	[4304] = "20650|L200|4234:6",	-- Thick Leather
	[8176] = "10507|L205|4304:5 4291:2",	-- Nightscape Headband
	[8175] = "10499|L205|4304:7 4291:2",	-- Nightscape Tunic
	[8187] = "10509|L205|4304:6 8167:8 8343|8385",	-- Turtle Scale Gloves
	[8192] = "10516|L210|4304:8 4338:6 4291:3|8409",	-- Nightscape Shoulders
	[8198] = "10518|L210|4304:8 8167:12 8343",	-- Turtle Scale Bracers
	[8189] = "10511|L210|4304:6 8167:12 8343",	-- Turtle Scale Breastplate
	[8210] = "10529|L210|4304:10 8153 8172|8403",	-- Wild Leather Shoulders
	[8200] = "10520|L215|4304:10 8151:4 8343|8386",	-- Big Voodoo Robe
	[8214] = "10546|L215|4304:10 8153:2 8172|8405",	-- Wild Leather Helmet
	[8211] = "10544|L215|4304:12 8153:2 8172|8404",	-- Wild Leather Vest
	[8201] = "10531|L220|4304:8 8151:6 8343|8387",	-- Big Voodoo Mask
	[8205] = "10533|L220|4304:10 8154:4 4291:2|8397",	-- Tough Scorpid Bracers
	[8203] = "10525|L220|4304:12 8154:12 4291:4|8395",	-- Tough Scorpid Breastplate
	[8217] = "14930|L225|4304:12 8172 8949 4291:4",	-- Quickdraw Quiver
	[8218] = "14932|L225|4304:10 8172 8951 4291:6",	-- Thick Leather Ammo Pouch
	[8204] = "10542|L225|4304:6 8154:8 4291:2|8398",	-- Tough Scorpid Gloves
	[8347] = "10619|L225|4304:24 8165:12 8343:4 8172:2",	-- Dragonscale Gauntlets
	[8367] = "10650|L255|4304:40 8165:30 8343:4 8172:4",	-- Dragonscale Breastplate
	[8345] = "10621|L225|4304:18 8368:2 8146:8 8343:4 8172:2",	-- Wolfshead Helm
	[8193] = "10548|L230|4304:14 4291:4",	-- Nightscape Pants
	[8191] = "10552|L230|4304:14 8167:24 8343",	-- Turtle Scale Helm
	[8346] = "10630|L230|4304:20 7079:8 7075:2 8172 8343:4",	-- Gauntlets of the Sea
	[8197] = "10558|L235|4304:16 8343:2",	-- Nightscape Boots
	[8209] = "10554|L235|4304:12 8154:12 4291:6|8399",	-- Tough Scorpid Boots
	[8185] = "10556|L235|4304:14 8167:28 8343",	-- Turtle Scale Leggings
	[8213] = "10566|L235|4304:14 8153:4 8172:2|8406",	-- Wild Leather Boots
	[8216] = "10562|L240|4304:14 8152:4 8343:2|8390",	-- Big Voodoo Cloak
	[8202] = "10560|L240|4304:10 8152:6 8343:2|8389",	-- Big Voodoo Pants
	[8207] = "10564|L240|4304:12 8154:16 8343:2|8400",	-- Tough Scorpid Shoulders
	[8215] = "10574|L240|4304:16 8153:6 8172:2|8408",	-- Wild Leather Cloak
	[8212] = "10572|L240|4304:16 8153:6 8172:2|8407",	-- Wild Leather Leggings
	[8206] = "10568|L245|4304:14 8154:8 8343:2|8401",	-- Tough Scorpid Leggings
	[8208] = "10570|L250|4304:10 8154:20 8343:2|8402",	-- Tough Scorpid Helm
	[8348] = "10632|L250|4304:40 7077:8 7075:4 8172:2 8343:4",	-- Helm of Fire
	[8349] = "10647|L250|4304:40 8168:40 7971:2 8172:4 8343:4",	-- Feathered Breastplate
	[15407] = "19047|L250|8171 15409",	-- Cured Rugged Hide
	[15564] = "19058|L250|8170:5",	-- Rugged Armor Kit
	[8170] = "22331|L250|4304:6",	-- Rugged Leather
	[15077] = "19048|L255|8170:4 15408:4 14341|15724",	-- Heavy Scorpid Bracers
	[15045] = "19050|L260|8170:20 15412:25 14341:2|15726",	-- Green Dragonscale Breastplate
	[15083] = "19049|L260|8170:8 2325 14341|15725",	-- Wicked Leather Gauntlets
	[15074] = "19053|L265|8170:6 15423:6 14341|15729",	-- Chimeric Gloves
	[15076] = "19051|L265|8170:6 15408:6 14341|15727",	-- Heavy Scorpid Vest
	[15084] = "19052|L265|8170:8 2325 14341|15728",	-- Wicked Leather Bracers
	[15046] = "19060|L270|8170:20 15412:25 14341|15733",	-- Green Dragonscale Leggings
	[15067] = "19062|L270|8170:24 15420:80 1529:2 14341|15735",	-- Ironfeather Shoulders
	[15061] = "19061|L270|8170:12 12803:4 14341|15734",	-- Living Shoulders
	[15091] = "19055|L270|8170:10 14047:6 14341|15731",	-- Runic Leather Gauntlets
	[15054] = "19059|L270|8170:6 7078 7075 14341|15732",	-- Volcanic Leggings
	[15057] = "19067|L275|8170:16 7080:2 7082:2 14341|15741",	-- Stormshroud Pants
	[15064] = "19068|L275|8170:28 15419:12 14341|15742",	-- Warbear Harness
	[15073] = "19063|L275|8170:4 15423:8 14341|15737",	-- Chimeric Boots
	[15071] = "19066|L275|8170:4 15422:6 14341|15740",	-- Frostsaber Boots
	[45] = "19064|L275|8170:6 15408:8 14341|15738||15078",	-- Heavy Scorpid Gauntlets
	[15092] = "19065|L275|8170:6 7971 14047:6 14341|15739",	-- Runic Leather Bracers
	[15072] = "19073|L280|8170:8 15423:8 14341|15746",	-- Chimeric Leggings
	[15082] = "19070|L280|8170:6 15408:8 14341|15743",	-- Heavy Scorpid Belt
	[15093] = "19072|L280|8170:12 14047:10 14341|15745",	-- Runic Leather Belt
	[15086] = "19071|L280|8170:12 2325 14341|15744",	-- Wicked Leather Headband
	[20296] = "24655|L280|8170:20 15412:30 15407 14341:2",	-- Green Dragonscale Gauntlets
	[15048] = "19077|L285|8170:28 15415:30 15407 14341|15751",	-- Blue Dragonscale Breastplate
	[15060] = "19078|L285|8170:16 12803:6 15407 14341|15752",	-- Living Leggings
	[15056] = "19079|L285|8170:16 7080:3 7082:3 15407 14341|15753",	-- Stormshroud Armor
	[15065] = "19080|L285|8170:24 15419:14 14341|20254",	-- Warbear Woolies
	[15069] = "19074|L285|8170:6 15422:8 14341|15747",	-- Frostsaber Leggings
	[15079] = "19075|L285|8170:8 15408:12 14341|15748",	-- Heavy Scorpid Leggings
    [34086] = "44953|L285|2840 2997 8170:4 14341|34262", -- Winter Boots
	[15053] = "19076|L285|8170:8 7078 7076 14341|15749",	-- Volcanic Breastplate
	[15050] = "19085|L290|8170:40 15416:60 15407 14341:2|15759",	-- Black Dragonscale Breastplate
	[19052] = "23705|L290|8170:30 12809:2 7080:4 15407:2 14341:2|19328",	-- Dawn Treaders
	[15063] = "19084|L290|8170:30 15417:8 14341|15758",	-- Devilsaur Gauntlets
	[15066] = "19086|L290|8170:40 15420:120 1529 15407 14341|15760",	-- Ironfeather Breastplate
	[19044] = "23703|L290|8170:30 12804:2 12803:4 15407:2 14341:2|19326",	-- Might of the Timbermaw
	[15075] = "19081|L290|8170:10 15423:10 14341|15755",	-- Chimeric Vest
	[15094] = "19082|L290|8170:14 14047:10 14341|15756",	-- Runic Leather Headband
	[15087] = "19083|L290|8170:16 15407 2325:3 14341|15757",	-- Wicked Leather Pants
	[16982] = "20853|L295|17012:20 17010:6 17011:2 14341:2|17022",	-- Corehound Boots
	[15049] = "19089|L295|8170:28 15415:30 12810:2 15407 14341|15763",	-- Blue Dragonscale Shoulders
	[15058] = "19090|L295|8170:12 7080:3 7082:3 12810:2 14341|15764",	-- Stormshroud Shoulders
	[15070] = "19087|L295|8170:6 15422:10 14341|15761",	-- Frostsaber Gloves
	[15080] = "19088|L295|8170:8 15408:12 15407 14341|15762",	-- Heavy Scorpid Helm
	[16984] = "20855|L300|12810:6 15416:30 17010:4 17011:3 14341:2|17025",	-- Black Dragonscale Boots
	[18509] = "22926|L300|8170:30 12607:12 15416:30 15414:30 15407:5 14341:8|18517",	-- Chromatic Cloak
	[19157] = "23708|L300|17010:5 17011:2 17012:4 12607:4 15407:4 14227:4|19331",	-- Chromatic Gauntlets
	[19162] = "23709|L300|17010:8 17012:12 12810:10 15407:4 14227:4|19332",	-- Corehound Belt
	[20380] = "24703|L300|12810:12 20381:6 12803:4 15407:4 14227:6|20382",	-- Dreamscale Breastplate
	[18510] = "22927|L300|8170:30 12803:12 7080:10 18512:8 15407:3 14341:8|18518",	-- Hide of the Wild
	[22665] = "28224|L300|22682:4 15408:16 7080:2 15407:2 14227:4",	-- Icy Scale Bracers
	[22664] = "28222|L300|22682:7 15408:24 7080:2 15407:4 14227:4",	-- Icy Scale Breastplate
	[22666] = "28223|L300|22682:5 15408:16 7080:2 15407:3 14227:4",	-- Icy Scale Gauntlets
	[19149] = "23707|L300|17011:5 15407:4 14227:4|19330",	-- Lava Belt
	[19163] = "23710|L300|17010:2 17011:7 7076:6 15407:4 14227:4|19333",	-- Molten Belt
	[16983] = "20854|L300|17012:15 17010:3 17011:6 14341:2|17023",	-- Molten Helm
	[22663] = "28221|L300|22682:4 12810:12 7080:2 15407:2 14227:4",	-- Polar Bracers
	[22662] = "28220|L300|22682:5 12810:12 7080:2 15407:3 14227:4",	-- Polar Gloves
	[22661] = "28219|L300|22682:7 12810:16 7080:2 15407:4 14227:4",	-- Polar Tunic
	[18511] = "22928|L300|8170:30 7082:12 12753:4 12809:8 15407:4 14341:8|18519",	-- Shifting Cloak
	[15052] = "19107|L300|8170:40 15416:60 12810:4 15407 14341:2|15781",	-- Black Dragonscale Leggings
	[15051] = "19094|L300|8170:44 15416:45 12810:2 15407 14341|15770",	-- Black Dragonscale Shoulders
	[19688] = "24124|L300|19768:35 19726:2 15407:3 14341:3|19772",	-- Blood Tiger Breastplate
	[19689] = "24125|L300|19768:25 19726:2 15407:3 14341:3|19773",	-- Blood Tiger Shoulders
	[22761] = "28474|L300|12810:4 12803:2 15407|22769",	-- Bramblewood Belt
	[22760] = "28473|L300|12810:6 18512:2 12803:2 15407:2|22770",	-- Bramblewood Boots
	[22759] = "28472|L300|12810:12 19726:2 12803:2 15407:2|22771",	-- Bramblewood Helm
	[18251] = "22727|L300|17012:3 14341:2|18252",	-- Core Armor Kit
	[15062] = "19097|L300|8170:30 15417:14 15407 14341|15772",	-- Devilsaur Leggings
	[18504] = "22921|L300|8170:12 12804:12 15407:2 14341:4|18514",	-- Girdle of Insight
	[19058] = "23706|L300|12810:8 12803:4 12809:4 15407:2 14341:2|19329",	-- Golden Mantle of the Dawn
	[15059] = "19095|L300|8170:16 12803:8 14342:2 15407 14341:2|15771",	-- Living Breastplate
	[18506] = "22922|L300|8170:12 7082:6 11754:4 15407:2 14341:4|18515",	-- Mongoose Boots
	[15138] = "19093|L300|15410 14044 14341",	-- Onyxia Scale Cloak
	[19687] = "24123|L300|19767:8 15407:3 12803:4 14341:3|19771",	-- Primal Batskin Bracers
	[19686] = "24122|L300|19767:10 15407:4 12803:4 14341:3|19770",	-- Primal Batskin Gloves
	[19685] = "24121|L300|19767:14 15407:5 12803:4 14341:4|19769",	-- Primal Batskin Jerkin
	[15047] = "19054|L300|8170:40 15414:30 14341|15730",	-- Red Dragonscale Breastplate
	[20476] = "24849|L300|20501 20498:20 18512:2|20509",	-- Sandstalker Bracers
	[20478] = "24851|L300|20501:3 20498:40 18512:2 15407:2|20511",	-- Sandstalker Breastplate
	[20477] = "24850|L300|20501:2 20498:30 18512:2 15407|20510",	-- Sandstalker Gauntlets
	[20481] = "24846|L300|20500 20498:20 7078:2|20506",	-- Spitfire Bracers
	[20479] = "24848|L300|20500:3 20498:40 7078:2 15407:2|20508",	-- Spitfire Breastplate
	[20480] = "24847|L300|20500:2 20498:30 7078:2 15407|20507",	-- Spitfire Gauntlets
	[21278] = "26279|L300|12810:6 7080:4 7082:4 15407:2 14227:2|21548",	-- Stormshroud Gloves
	[18508] = "22923|L300|8170:12 18512:8 15420:60 15407:4 14341:4|18516",	-- Swift Flight Bracers
	[19049] = "23704|L300|12810:8 12804:6 12803:6 15407:2 14227:2|19327",	-- Timbermaw Brawlers
	[25654] = "32462|L300|21887:5 25700 14341:2",	-- Felscale Gloves
	[15068] = "19104|L300|8170:12 15422:12 15407 14341:2|15779",	-- Frostsaber Tunic
	[15081] = "19100|L300|8170:14 15408:14 15407 14341:2|15774",	-- Heavy Scorpid Shoulders
	[15090] = "19102|L300|8170:22 12810:4 14047:16 15407 14341:2|15776",	-- Runic Leather Armor
	[15095] = "19091|L300|8170:18 14047:12 12810:2 14341|15765",	-- Runic Leather Pants
	[15096] = "19103|L300|8170:16 12810:4 14047:18 15407 14341:2|15777",	-- Runic Leather Shoulders
	[25662] = "32466|L300|21887:6 25700:3 14341:2",	-- Scaled Draenic Pants
	[25669] = "32470|L300|21887:6 14341:2",	-- Thick Draenic Gloves
	[15055] = "19101|L300|8170:10 7078 7076 14341:2|15775",	-- Volcanic Shoulders
	[15085] = "19098|L300|8170:20 15407:2 14256:2 2325:4 14341:2|15773",	-- Wicked Leather Armor
	[15088] = "19092|L300|8170:14 2325:2 14341:2|15768",	-- Wicked Leather Belt
	[25673] = "32478|L300|21887:6 14341:3",	-- Wild Draenish Boots
	[25679] = "32482|L300|21887:2|25726",	-- Comfortable Insoles
	[25650] = "32456|L300|21887:4",	-- Knothide Armor Kit
	[21887] = "32454|L300|25649:5",	-- Knothide Leather
	[20295] = "24654|L300|8170:28 15415:36 15407:2 14341:2",	-- Blue Dragonscale Leggings
    [34482] = "45100|L300|21887:20 25700:4 25707:3 14341:3", -- Leatherworker's Satchel
	[25655] = "32463|L310|21887:8 25700 14341:2",	-- Felscale Boots
	[25661] = "32467|L310|21887:8 25700 14341:2",	-- Scaled Draenic Gloves
	[25674] = "32479|L310|21887:9 14341:3",	-- Wild Draenish Gloves
	[25670] = "32471|L315|21887:10 14341:2",	-- Thick Draenic Pants
    [34099] = "44343|L315|21887:24 14341:4 22451:1", -- Knothide Ammo Pouch
    [34100] = "44344|L315|21887:20 25719:30 14341:2", -- Knothide Quiver
	[25656] = "32464|L320|21887:10 25700:3 14341:3",	-- Felscale Pants
	[25668] = "32472|L320|21887:10 14341:3",	-- Thick Draenic Boots
	[25675] = "32480|L320|21887:13 14341:3",	-- Wild Draenish Leggings
	[29540] = "35530|L325|23793:6 22452:4|29664",	-- Reinforced Mining Bag
	[25660] = "32468|L325|21887:12 25700:3 14341:3",	-- Scaled Draenic Vest
	[23793] = "32455|L325|21887:5|25720",	-- Heavy Knothide Leather
	[25652] = "32458|L325|23793:3 22457|25722",	-- Magister's Armor Kit
	[25651] = "32457|L325|23793:3 22452|25721",	-- Vindicator's Armor Kit
	[25671] = "32473|L330|21887:14 14341:3",	-- Thick Draenic Vest
	[25676] = "32481|L330|21887:15 14341:3",	-- Wild Draenish Vest
	[29534] = "35555|L335|23793:4 25708:8 22452:4|29720",	-- Clefthide Leg Armor
	[29533] = "35549|L335|23793:4 29539:2 22451:4|29719",	-- Cobrahide Leg Armor
	[25657] = "32465|L335|21887:14 25700:3 14341:3",	-- Felscale Breastplate
	[25659] = "32469|L335|21887:12 25700:2 14341:3",	-- Scaled Draenic Boots
	[25685] = "32490|L340|23793:6 25707:6 22456:6 14341:3|25732",	-- Fel Leather Gloves
	[25694] = "32501|L340|23793:4 25699:8 21885:3 22457:3 14341:2|25741",	-- Netherfury Belt
	[25692] = "32502|L340|23793:8 25699:12 21885:5 22457:5 14341:2|25742",	-- Netherfury Leggings
	[29488] = "35524|L340|23793:4 22457:4|29675",	-- Arcane Armor Kit
	[29528] = "35540|L340|23793:2 25700:3",	-- Drums of War (Trainer)
	[29485] = "35521|L340|23793:4 21885:4|29672",	-- Flame Armor Kit
	[29486] = "35522|L340|23793:4 21884:4|29673",	-- Frost Armor Kit
	[29487] = "35523|L340|23793:4 22456:4|29674",	-- Nature Armor Kit
	[29483] = "35520|L340|23793:4 21886:4|29669",	-- Shadow Armor Kit
	[29530] = "35544|L345|23793:6 29547:4|34172",	-- Drums of Speed ****Kurenai
	[29500] = "35537|L350|23793:4 25707:6 21884:3 21885:3|29704",	-- Blastguard Belt
	[29499] = "35536|L350|23793:4 25707:8 21884:3 21885:3|29703",	-- Blastguard Boots
	[29498] = "35535|L350|23793:6 25707:10 21884:4 21885:4|29702",	-- Blastguard Pants
	[29497] = "35534|L350|23793:4 25708:16 22457:6|29701",	-- Enchanted Clefthoof Boots
	[29496] = "35533|L350|23793:4 25708:16 22457:6|29700",	-- Enchanted Clefthoof Gloves
	[29495] = "35532|L350|23793:6 25708:24 22457:8|29698",	-- Enchanted Clefthoof Leggings
	[29491] = "35527|L350|23793:4 25700:10 22457:6|29684",	-- Enchanted Felscale Boots
	[29490] = "35526|L350|23793:4 25700:10 22457:6|29682",	-- Enchanted Felscale Gloves
	[29489] = "35525|L350|23793:6 25700:12 22457:8|29677",	-- Enchanted Felscale Leggings
	[25686] = "32493|L350|23793:10 25707:8 22456:8 14341:3|25733",	-- Fel Leather Boots
	[25687] = "32494|L350|23793:10 25707:10 22456:10 14341:3|25734",	-- Fel Leather Leggings
	[25695] = "32498|L350|23793:6 25707:4 25699:8 22451:6 14341:2|25738",	-- Felstalker Belt
	[29494] = "35531|L350|23793:4 25699:8 21884:3 21885:3|29693",	-- Flamescale Belt
	[29493] = "35528|L350|23793:4 25699:8 21884:3 21885:3|29691",	-- Flamescale Boots
	[29492] = "35529|L350|23793:6 25699:12 21884:4 21885:4|29689",	-- Flamescale Leggings
	[25693] = "32503|L350|23793:6 25699:10 21885:4 22457:4 14341:2|25743",	-- Netherfury Boots
    [34207] = "44770|L350|23793:18 22452:12 14341:1", -- Glove Reinforcements
	[25653] = "32461|L350|23793:4 23571 22445:6 22448|25725",	-- Riding Crop
	[25681] = "32487|L350|23793:6 29539:2 21886:8 2325:4 14341:3|25729",	-- Stylin' Adventure Hat
	[25683] = "32488|L350|23793:6 29539:2 21884:8 2604:4 14341:3|25731",	-- Stylin' Crimson Hat
	[25682] = "32489|L350|23793:6 29539:2 22452:8 14341:3|25730",	-- Stylin' Jungle Hat
	[25680] = "32485|L350|23793:6 29539:2 22456:8 4342:4 14341:3|25728",	-- Stylin' Purple Hat
	[29531] = "35539|L350|23793:6 29548:4|34174",	-- Drums of Restoration ---Kurenai
    [34105] = "44359|L350|23793:8 17056:9 22451:2 23572|34200", -- Quiver of a Thousand Feathers
    [34330] = "44970|L350|23793:3", -- Heavy Knothide Armor Kit
    [34106] = "44768|L350|23793:12 29548:12 22452:4 23572|34201", -- Netherscale Ammo Pouch
	[25691] = "32497|L355|23793:4 25708:20 22452:4 14341:2|25737",	-- Heavy Clefthoof Boots
	[25690] = "32496|L355|23793:6 25708:34 22452:4 14341:2|25736",	-- Heavy Clefthoof Leggings
	[46] = "32499|L360|23793:6 25707:6 25699:6 22451:4 14341:2|25739||25697",	-- Felstalker Bracer
	[25696] = "32500|L360|23793:10 25707:4 25699:8 22451:8 14341:2|25740",	-- Felstalker Breastplate
	[25689] = "32495|L360|23793:6 25708:40 22452:4 14341:2|25735",	-- Heavy Clefthoof Vest
    [33122] = "42546|L360|23793:8 21844:12 22456:12 23572:4|33124", -- Cloak of Darkness
    [34490] = "45117|L360|23793:15 29547:5 25707:5 29548:5 25708:5 14341:3|34491", -- Bag of Many Hides
	[29503] = "35559|L365|23793:4 29539:8 22451:12 22456:12 23572|29724",	-- Cobrascale Gloves -- also rid 35302******
	[29502] = "35558|L365|23793:6 29539:10 22451:15 22456:15 23572|29723",	-- Cobrascale Hood
	[29512] = "35567|L365|23793:4 29548:24 22452:22 22457:4 23572|29730",	-- Earthen Netherscale Boots
	[29506] = "35562|L365|23793:4 21886:16 22452:12 23572|29727",	-- Gloves of the Living Touch -- also rid 35303******
	[29505] = "35561|L365|23793:6 21886:20 21885:8 23572|29726",	-- Hood of Primal Life
	[29508] = "35564|L365|23793:6 29548:28 21886:12 22457:12 23572|29729",	-- Living Dragonscale Helm
	[29511] = "35573|L365|23793:4 29548:24 21884:14 22457:10 23572|29733",	-- Netherdrake Gloves -- also 35301
	[29510] = "35572|L365|23793:6 29548:28 21884:18 22457:12 23572|29732",	-- Netherdrake Helm
	[29514] = "35574|L365|23793:8 29548:32 22452:20 22451:8 23572|29734",	-- Thick Netherscale Breastplate
	[29504] = "35560|L365|23793:6 29547:20 22451:18 22457:10 23572|29725",	-- Windscale Hood
	[29507] = "35563|L365|23793:4 29547:12 22452:18 22451:8 23572|29728",	-- Windslayer Wraps
	[29509] = "35568|L365|23793:4 29547:14 22451:14 21884:10 23572|29731",	-- Windstrike Gloves -- also 35300
	[29529] = "35543|L365|23793:6 25708:4|29717",	-- Drums of Battle
	[29536] = "35557|L365|23793:4 25708:16 22452:8 23572|29721",	-- Nethercleft Leg Armor
	[29535] = "35554|L365|23793:4 29539:4 22451:8 23572|29722",	-- Nethercobra Leg Armor
	[29532] = "35538|L370|23793:6 25707:4|29713",	-- Drums of Panic
    [30040] = '36351|L375|30183:2 23793:4 22456:10 22451:10 14341:2|30302', --Belt of Deep Shadow
    [30042] = '36339|L375|30183:2 23793:4 21886:10 14341:2 22451:10|30301', --Belt of Natural Power
    [30046] = '36352|L375|30183:2 23793:4 22451:10 29457:10 14341:2|30303', --Belt of the Black Eagle
    [30041] = '36355|L375|23572:2 23793:3 21886:12 14341:2|30305', --Boots of Natural Grace
    [30045] = '36358|L375|23572:2 23793:4 22451:10 29547:6 14341:2|30307', --Boots of the Crimson Hawk
    [30043] = '36359|L375|23572:2 23793:4 21885:10 29547:6 14341:2|30308', --Hurricane Boots
    [30044] = '36353|L375|30183:2 23793:4 21885:10 29547:6 14341:2|30304', --Monsoon Belt
    [32574] = '41161|L375|23793:4 22451:4 21885:4 29547:12 32428:4|32748', -- Bindings of Lightning Reflexes - also rid 35517*****
    [32579] = '41164|L375|23793:6 22451:6 22452:6 29547:16 32428:2|32751', -- Living Earth Shoulders -- also 35521****
    [32583] = '41157|L375|23793:6 22451:8 21886:8 32428:2|32745', --Shoulderpads of Renewed Life -- also 35523
    [32580] = '41158|L375|23793:4 22451:10 32428:4|32746', --Swiftstrike Bracers
    [32582] = '41156|L375|23793:4 22451:6 21886:6 32428:4|32744', -- Bracers of Renewed Life - also rid 35519*****
    [32577] = '41163|L375|23793:4 22451:4 22452:4 29547:12 32428:4|32750', -- Living Earth Bindings - also rid 35520
    [32583] = '41157|L375|23793:4 22451:8 21886:8 32428:2|32745', -- Shoulders of Renewed Life
    [32575] = '41162|L375|23793:6 22451:6 21885:6 29547:16 32428:2|32749', -- Shoulders of Lightning Reflexes -- also 35524
    [32581] = '41160|L375|23793:6 22451:12 32428:2|32747', --Swiftstrike Shoulders -- also 35528
    [30039] = '36357|L375|23572:2 23793:4 22456:12 14341:2|30306', --Boots of Utter Darkness
    [32398] = '39997|L375|32428:2 22450:1 21886:2 22456:4 25700:4|32429', --Boots of Shackeled Souls
    [32399] = '40000|L375|32428:1 22450:1 21886:2 22456:2 25700:2|32430', --Bracers of Shackeled Souls
    [32400] = '40001|L375|32428:3 22450:1 21886:4 22456:6 25700:3|32431', --Greaves of Shackeled Souls
    [32397] = '40002|L375|32428:2 22450:1 21886:3 22456:4 25700:2|32429', --Waistguard of Shackeled Souls
    [32393] = '40006|L375|32428:2 22450:1 21886:3 22456:4 25707:2|32436', --Redeemed Cinch
    [32396] = '40005|L375|32428:3 22450:1 21886:4 22456:6 25707:3|32429', --Redeemed Legguards
    [32394] = '40003|L375|32428:2 22450:1 21886:2 22456:4 25707:4|32433', --Redeemed Moccassins
    [32395] = '40004|L375|32428:1 22450:1 21886:2 22456:2 25707:2|32434', --Redeemed Wristguards
    [33204] = "42731|L375|23793:10 21844:16 22452:12 22456:12 23572:2|33205", --Shadowprowler's Chestguard
--[[ Specialty Leatherworking --]]
	[29971] = "36076|Ld260|8170:10 8165:10 7077:2 8172:2 14341",	-- Dragonstrike Leggings
	[29975] = "36079|Ld330|21887:20 15416:8 21884:3 14341:2",	-- Golden Dragonstrike Breastplate
	[29516] = "35576|Ld375|23793:6 29548:24 21884:12 22456:12 23572",	-- Ebon Netherscale Belt
	[29517] = "35577|Ld375|23793:4 29548:18 21884:8 22456:8",	-- Ebon Netherscale Bracers
	[29515] = "35575|Ld375|23793:8 29548:30 21884:16 22456:16 23572:2",	-- Ebon Netherscale Breastplate
	[29520] = "35582|Ld375|23793:6 29548:24 22457:12 22451:12 23572",	-- Netherstrike Belt
	[29521] = "35584|Ld375|23793:4 29548:18 22457:8 22451:8",	-- Netherstrike Bracers
	[29519] = "35580|Ld375|23793:8 29548:30 22457:16 22451:16 23572:2",	-- Netherstrike Breastplate
	[29964] = "36074|Le260|8170:10 7081:8 8172:2 14341",	-- Blackstorm Leggings
	[29973] = "36077|Le330|21887:20 22451:2 22452:2 14341:2",	-- Primalstorm Breastplate
	[29526] = "35590|Le375|23793:6 23571:5 23572",	-- Primalstrike Belt
	[29527] = "35591|Le375|23793:4 23571:3",	-- Primalstrike Bracers
	[29525] = "35589|Le375|23793:8 23571:6 23572:2",	-- Primalstrike Vest
	[29970] = "36075|Lt260|8170:10 8168:40 8153:4 8172:2 14341",	-- Wildfeather Leggings
	[29974] = "36078|Lt330|21887:20 25699:12 21886:3 14341:2",	-- Living Crystal Breastplate
	[29524] = "35587|Lt375|23793:6 29547:16 22451:12 23571:2 23572",	-- Windhawk Belt
	[29523] = "35588|Lt375|23793:4 29547:12 22451:8 23571",	-- Windhawk Bracers
	[29522] = "35585|Lt375|23793:8 29547:20 22451:16 23571:3 23572:2",	-- Windhawk Hauberk
--[[ Smelting --]]
	[47] = "2657|Y1|2770|||2840",	-- Smelt Copper
	[48] = "2659|Y65|2840 3576||2|2841",	-- Smelt Bronze
	[49] = "3304|Y65|2771|||3576",	-- Smelt Tin
	[50] = "2658|Y75|2775|||2842",	-- Smelt Silver
	[51] = "3307|Y125|2772|||3575",	-- Smelt Iron
	[52] = "3308|Y155|2776|||3577",	-- Smelt Gold
	[53] = "3569|Y165|3575 3857|||3859",	-- Smelt Steel
	[54] = "10097|Y175|3858|||3860",	-- Smelt Mithril
	[55] = "10098|Y230|7911|||6037",	-- Smelt Truesilver
	[56] = "14891|Y230|11370:8|||11371",	-- Smelt Dark Iron
	[57] = "16153|Y250|10620|||12359",	-- Smelt Thorium
	[58] = "22967|Y300|18562 12360:10 17010 18567:3|||17771",	-- Smelt Elementium
	[59] = "35750|Y300|22452||10|22573",	-- Earth Shatter
	[60] = "35751|Y300|21884||10|22574",	-- Fire Sunder
	[61] = "29356|Y300|23424:2|||23445",	-- Smelt Fel Iron
	[62] = "29358|Y325|23425:2|||23446",	-- Smelt Adamantite
	[63] = "29359|Y350|23427:2|||23447",	-- Smelt Eternium
	[64] = "29360|Y350|23445:3 23447:2|||23448",	-- Smelt Felsteel
	[65] = "29361|Y375|23426:2|||23449",	-- Smelt Khorium
	[66] = "29686|Y375|23446:10|||23573",	-- Smelt Hardened Adamantite
--[[ Tailoring --]]
	[2996] = "2963|T1|2589:2",	-- Bolt of Linen Cloth
	[4344] = "3915|T1|2996 2320",	-- Brown Linen Shirt
	[2570] = "2387|T1|2996 2320",	-- Linen Cloak
	[10045] = "12044|T1|2996 2320",	-- Simple Linen Pants
	[2576] = "2393|T1|2996 2320 2324",	-- White Linen Shirt
	[2568] = "2385|T10|2996 2320",	-- Brown Linen Vest
	[7026] = "8776|T15|2996 2320",	-- Linen Belt
	[10046] = "12045|T20|2996:2 2318 2320",	-- Simple Linen Boots
	[6238] = "7623|T30|2996:3 2320",	-- Brown Linen Robe
	[6241] = "7624|T30|2996:3 2320 2324",	-- White Linen Robe
	[4343] = "3914|T30|2996:2 2320",	-- Brown Linen Pants
	[4307] = "3840|T35|2996:2 2320",	-- Heavy Linen Gloves
	[2572] = "2389|T40|2996:3 2320:2 2604:2|2598",	-- Red Linen Robe
	[2577] = "2394|T40|2996:2 2320 6260",	-- Blue Linen Shirt
	[2575] = "2392|T40|2996:2 2320 2604",	-- Red Linen Shirt
	[6786] = "8465|T40|2996:2 2320 6260 2324",	-- Simple Dress
	[4238] = "3755|T45|2996:3 2320:3",	-- Linen Bag
	[6240] = "7630|T55|2996:3 2320 6260|6270",	-- Blue Linen Vest
	[6239] = "7629|T55|2996:3 2320 2604|6271",	-- Red Linen Vest
	[4308] = "3841|T60|2996:3 2320:2 2605",	-- Green Linen Bracers
	[2580] = "2397|T60|2996:2 2320:3",	-- Reinforced Linen Cape
	[2569] = "2386|T65|2996:3 2320 2318",	-- Linen Boots
	[2578] = "2395|T70|2996:4 2318 2321",	-- Barbaric Linen Vest
	[6242] = "7633|T70|2996:4 2320:2 6260:2|6272",	-- Blue Linen Robe
	[4309] = "3842|T70|2996:4 2321:2",	-- Handstitched Linen Britches
	[2579] = "2396|T70|2996:3 2321 2605",	-- Green Linen Shirt
	[5762] = "6686|T70|2996:4 2321 2604|5771",	-- Red Linen Bag
	[2997] = "2964|T75|2592:3",	-- Bolt of Woolen Cloth
	[10047] = "12046|T75|2996:4 2321",	-- Simple Kilt
	[2584] = "2402|T75|2997 2321",	-- Woolen Cape
	[4312] = "3845|T80|2996:5 2318:2 2321",	-- Soft-soled Linen Boots
	[4240] = "3757|T80|2997:3 2321",	-- Woolen Bag
	[4310] = "3843|T85|2997:3 2321",	-- Heavy Woolen Gloves
	[2582] = "2399|T85|2997:2 2321:2 2605",	-- Green Woolen Vest
	[5542] = "6521|T90|2997:3 2321:2 5498",	-- Pearl-clasped Cloak
	[4313] = "3847|T95|2997:4 2318:2 2321 2604:2|4345",	-- Red Woolen Boots
	[2583] = "2401|T95|2997:4 2321:2 2318:2",	-- Woolen Boots
	[4241] = "3758|T95|2997:4 2605 2321|4292",	-- Green Woolen Bag
	[6263] = "7639|T100|2997:4 2321:2 6260:2|6274",	-- Blue Overalls
	[4311] = "3844|T100|2997:3 2321:2 5498:2|4346",	-- Heavy Woolen Cloak
	[2587] = "2406|T100|2997:2 2321 4340",	-- Gray Woolen Shirt
	[2585] = "2403|T105|2997:4 2321:3 4340|2601",	-- Gray Woolen Robe
	[4316] = "3850|T110|2997:5 2321:4",	-- Heavy Woolen Pants
	[4314] = "3848|T110|2997:3 2321:2",	-- Double-stitched Woolen Shoulders
	[4330] = "3866|T110|2997:3 2604:2 2321",	-- Stylish Red Shirt
	[6787] = "8467|T110|2997:3 2324:4 2321",	-- White Woolen Dress
	[6264] = "7643|T115|2997:5 2321:3 2604:3|6275",	-- Greater Adept's Robe
	[4332] = "3869|T115|4305 4341 2321|14627",	-- Bright Yellow Shirt
	[5763] = "6688|T115|2997:4 2604 2321|5772",	-- Red Woolen Bag
	[10048] = "12047|T120|2997:5 2604:3 2321|10316",	-- Colorful Kilt
	[4315] = "3849|T120|2997:6 2319:2 2321:2|4347",	-- Reinforced Woolen Shoulders
	[6384] = "7892|T120|2997:4 6260:2 4340 2321|6390",	-- Stylish Blue Shirt
	[6385] = "7893|T120|2997:4 2605:2 4340 2321|6391",	-- Stylish Green Shirt
	[4320] = "3855|T125|4305:2 2319:4 3182:4 5500:2",	-- Spidersilk Boots
	[4331] = "3868|T125|2997:4 5500 2321:4 2324:2|4348",	-- Phoenix Gloves
	[4317] = "3851|T125|2997:6 5500 2321:3|4349",	-- Phoenix Pants
	[4305] = "3839|T125|4306:4",	-- Bolt of Silk Cloth
	[4318] = "3852|T130|2997:4 2321:3 3383",	-- Gloves of Meditation
	[4319] = "3854|T135|4305:3 4234:2 6260:2 2321:2|7114",	-- Azure Silk Gloves
	[5766] = "6690|T135|4305:2 2321:2 3182:2",	-- Lesser Wizard's Robe
	[7046] = "8758|T140|4305:4 6260:2 2321:3",	-- Azure Silk Pants
	[4321] = "3856|T140|4305:3 3182 2321:2|4350",	-- Spider Silk Slippers
	[7047] = "8780|T145|4305:3 4234:2 6048:2 2321:2|7092",	-- Hands of Darkness
	[7048] = "8760|T145|4305:2 6260:2 2321",	-- Azure Silk Hood
	[4324] = "3859|T150|4305:5 6260:4",	-- Azure Silk Vest
	[5770] = "6692|T150|4305:4 2321:2 3182:2|5773",	-- Robes of Arcana
	[7049] = "8782|T150|4305:3 4234:2 929:4 2321|7091",	-- Truefaith Gloves
	[4245] = "3813|T150|4305:3 4234:2 2321:3",	-- Small Silk Pack
	[4322] = "3857|T155|4305:3 2321:2 4337:2|14630",	-- Enchanter's Cowl
	[4333] = "3870|T155|4305:2 4340:2 2321|6401",	-- Dark Silk Shirt
	[7050] = "8762|T160|4305:3 2321:2",	-- Silk Headband
	[6795] = "8483|T160|4305:3 2324:2 4291",	-- White Swashbuckler's Shirt
	[7065] = "8784|T165|4305:5 2605:2 4291|7090",	-- Green Silk Armor
	[7051] = "8764|T170|4305:3 7067 2321:2",	-- Earthen Vest
	[4323] = "3858|T170|4305:4 4291 3824|4351",	-- Shadow Hood
	[4334] = "3871|T170|4305:3 2324:2 2321",	-- Formal White Shirt
	[7052] = "8766|T175|4305:4 7070 6260:2 2321:2 7071",	-- Azure Silk Belt
	[7053] = "8786|T175|4305:3 6260:2 2321:2|7089",	-- Azure Silk Cloak
	[4325] = "3860|T175|4305:4 4291 4337:2|4352",	-- Boots of the Enchanter
	[7055] = "8772|T175|4305:4 7071 2604:2 4291",	-- Crimson Silk Belt
	[4339] = "3865|T175|4338:5",	-- Bolt of Mageweave
	[5764] = "6693|T175|4305:4 4234:3 2321:3 2605|5774",	-- Green Silk Pack
	[6796] = "8489|T175|4305:3 2604:2 4291",	-- Red Swashbuckler's Shirt
	[7056] = "8789|T180|4305:5 2604:2 6371:2 4291|7087",	-- Crimson Silk Cloak
	[7057] = "8774|T180|4305:5 4291:2",	-- Green Silken Shoulders
	[4328] = "3863|T180|4305:4 4337:2 7071|4353",	-- Spider Belt
	[4336] = "3873|T180|4305:5 2325 4291|10728",	-- Black Swashbuckler's Shirt
	[4326] = "3861|T185|4305:4 3827 4291",	-- Long Silken Cloak
	[5765] = "6695|T185|4305:5 2325 2321:4|5775",	-- Black Silk Pack
	[7058] = "8791|T185|4305:4 2604:2 2321:2",	-- Crimson Silk Vest
	[4335] = "3872|T185|4305:4 4342 4291|4354",	-- Rich Purple Silk Shirt
	[7054] = "8770|T190|4339:2 7067:2 7070:2 7068:2 7069:2 4291:2",	-- Robe of Power
	[7060] = "8795|T190|4305:6 7072:2 6260:2 4291:2|7085",	-- Azure Shoulders
	[7059] = "8793|T190|4305:5 6371:2 2604:2 4291:2|7084",	-- Crimson Silk Shoulders
	[17723] = "21945|T190|4305:5 2605:4 4291|17724",	-- Green Holiday Shirt
	[7061] = "8797|T195|4305:5 7067:4 4234:4 7071 4291:2|7086",	-- Earthen Silk Belt
	[7062] = "8799|T195|4305:4 2604:2 4291:2",	-- Crimson Silk Pantaloons
	[10052] = "12064|T195|4339:2 6261:2 8343|10311",	-- Orange Martial Shirt
	[4327] = "3862|T200|4339:3 4291:2 3829 4337:2|4355",	-- Icy Cloak
	[4329] = "3864|T200|4339:4 4234:4 3864 7071 4291|4356",	-- Star Belt
	[9999] = "12049|T205|4339:2 4291:3",	-- Black Mageweave Leggings
	[9998] = "12048|T205|4339:2 4291:3",	-- Black Mageweave Vest
	[7063] = "8802|T205|4305:8 7068:4 3827:2 2604:4 4291|7088",	-- Crimson Silk Robe
	[10054] = "12075|T235|4339:2 4342:2 8343:2|10314",	-- Lavender Mageweave Shirt
	[10001] = "12050|T210|4339:3 8343",	-- Black Mageweave Robe
	[7064] = "8804|T210|4305:6 7068:2 6371:2 4304:2 2604:4 4291:2",	-- Crimson Silk Gloves
	[10002] = "12052|T210|4339:3 10285:2 8343",	-- Shadoweave Pants
	[10055] = "12080|T235|4339:3 10290 8343|10317",	-- Pink Mageweave Shirt
	[10003] = "12053|T215|4339:2 8343:2",	-- Black Mageweave Gloves
	[10009] = "12060|T215|4339:3 2604:2 8343|10302",	-- Red Mageweave Pants
	[10007] = "12056|T215|4339:3 2604:2 8343|10300",	-- Red Mageweave Vest
	[10004] = "12055|T215|4339:3 10285:2 8343",	-- Shadoweave Robe
	[10008] = "12059|T215|4339 2324 8343|10301",	-- White Bandit Mask
	[10056] = "12061|T215|4339 6261 8343",	-- Orange Mageweave Shirt
	[10034] = "12085|T240|4339:4 8343:2|10321",	-- Tuxedo Shirt
	[10035] = "12089|T245|4339:4 8343:3|10323",	-- Tuxedo Pants
	[10019] = "12067|T225|4339:4 8153:4 10286:2 8343:2",	-- Dreamweave Gloves
	[10021] = "12070|T225|4339:6 8153:6 10286:2 8343:2",	-- Dreamweave Vest
	[10030] = "12081|T225|4339:3 4589:6 8343:2|10318",	-- Admiral's Hat
	[10042] = "12069|T225|4339:5 7077:2 8343:2",	-- Cindercloth Robe
	[22246] = "27658|T225|4339:4 11137:4 8343:2|22307",	-- Enchanted Mageweave Pouch
	[10018] = "12066|T225|4339:3 2604:2 8343:2|10312",	-- Red Mageweave Gloves
	[10023] = "12071|T225|4339:5 10285:5 8343:2",	-- Shadoweave Gloves
	[10050] = "12065|T225|4339:4 4291:2",	-- Mageweave Bag
	[10040] = "12091|T250|4339:5 8343:3 2324|10325",	-- White Wedding Dress
	[10026] = "12073|T230|4339:3 8343:2 4304:2",	-- Black Mageweave Boots
	[10024] = "12072|T230|4339:3 8343:2",	-- Black Mageweave Headband
	[10027] = "12074|T230|4339:3 8343:2",	-- Black Mageweave Shoulders
	[10025] = "12086|T230|4339:2 10285:8 8343:2|10463",	-- Shadoweave Mask
	[10029] = "12078|T235|4339:4 2604:2 8343:3|10315",	-- Red Mageweave Shoulders
	[10028] = "12076|T235|4339:5 10285:4 8343:2",	-- Shadoweave Shoulders
	[10051] = "12079|T235|4339:4 2604:2 8343:2",	-- Red Mageweave Bag
	[10053] = "12077|T235|4339:3 2325 8343 2324",	-- Simple Black Dress
	[10036] = "12093|T250|4339:5 8343:3|10326",	-- Tuxedo Jacket
	[13868] = "18404|T240|14048:5 7079:2 14341|14467",	-- Frostweave Robe
	[10033] = "12084|T240|4339:4 2604:2 8343:2|10320",	-- Red Mageweave Headband
	[10031] = "12082|T240|4339:6 10285:6 8343:3 4304:2",	-- Shadoweave Boots
	[10044] = "12088|T245|4339:5 7077 8343:3 4304:2",	-- Cindercloth Boots
	[10041] = "12092|T250|4339:8 8153:4 10286:2 8343:3 6037 1529",	-- Dreamweave Circlet
	[14048] = "18401|T250|14047:5",	-- Bolt of Runecloth
	[21154] = "26403|T250|14048:4 4625:2 2604:2 14341|21722",	-- Festival Dress
	[67] = "26407|T250|14048:4 4625:2 2604:2 14341|21723||21542",	-- Festive Red Pant Suit
	[14342] = "18560|T250|14256:2|14526",	-- Mooncloth
	[13869] = "18403|T255|14048:5 7079:2 14341|14466",	-- Frostweave Tunic
	[13856] = "18402|T255|14048:3 14341",	-- Runecloth Belt
	[14042] = "18408|T260|14048:5 7077:2 14341|14471",	-- Cindercloth Vest
	[13858] = "18406|T260|14048:5 14227 14341|14469",	-- Runecloth Robe
	[13857] = "18407|T260|14048:5 14227 14341|14470",	-- Runecloth Tunic
	[21340] = "26085|T260|14048:6 8170:4 7972:2 14341|21358",	-- Soul Pouch
	[14046] = "18405|T260|14048:5 8170:2 14341|14468",	-- Runecloth Bag
	[13870] = "18411|T265|14048:3 7080 14341|14474",	-- Frostweave Gloves
	[14143] = "18410|T265|14048:3 9210:2 14227 14341|14473",	-- Ghostweave Belt
	[13860] = "18409|T265|14048:4 14227 14341|14472",	-- Runecloth Cloak
	[14101] = "18415|T270|14048:4 3577:2 14341|14479",	-- Brightcloth Gloves
	[14100] = "18414|T270|14048:5 3577:2 14341|14478",	-- Brightcloth Robe
	[14043] = "18412|T270|14048:4 7077:2 14341|14476",	-- Cindercloth Gloves
	[14142] = "18413|T270|14048:4 9210:2 14227 14341|14477",	-- Ghostweave Gloves
	[14134] = "18422|T275|14048:6 7078:4 7077:4 7068:4 14341|14486",	-- Cloak of Fire
	[14103] = "18420|T275|14048:4 3577:2 14341|14484",	-- Brightcloth Cloak
	[22251] = "27724|T275|14048:5 8831:10 11040:8 14341:2|22310",	-- Cenarion Herb Bag
	[14044] = "18418|T275|14048:5 7078 14341|14482",	-- Cindercloth Cloak
	[22248] = "27659|T275|14048:5 16203:2 14341:2|22308",	-- Enchanted Runecloth Bag
	[14107] = "18419|T275|14048:5 14256:2 14341|14483",	-- Felcloth Pants
	[14141] = "18416|T275|14048:6 9210:4 14227 14341|14480",	-- Ghostweave Vest
	[13863] = "18417|T275|14048:4 8170:4 14341|14481",	-- Runecloth Gloves
	[14132] = "18421|T275|14048:6 11176 14341|14485",	-- Wizardweave Leggings
	[21341] = "26086|T280|14256:12 12810:6 20520:2 14227:4",	-- Felcloth Bag
	[14045] = "18434|T280|14048:6 7078 14341|14490",	-- Cindercloth Pants
	[13871] = "18424|T280|14048:6 7080 14341|14489",	-- Frostweave Pants
	[13864] = "18423|T280|14048:4 14227:2 8170:4 14341|14488",	-- Runecloth Boots
	[14140] = "18452|T285|14048:4 14342:6 12800 12810:2 14341:2|14509",	-- Mooncloth Circlet
	[18486] = "22902|T285|14048:6 14342:4 13926:2 14341:2|18487",	-- Mooncloth Robe
	[14139] = "18448|T285|14048:5 14342:5 14341|14507",	-- Mooncloth Shoulders
	[14138] = "18447|T285|14048:6 14342:4 14341|14501",	-- Mooncloth Vest
	[14136] = "18436|T285|14048:10 14256:12 12808:4 7080:4 14341|14493",	-- Robe of Winter Night
	[14108] = "18437|T285|14048:6 14256:2 8170:4 14341|14492",	-- Felcloth Boots
	[13865] = "18438|T285|14048:6 14227:2 14341|14491",	-- Runecloth Pants
	[19056] = "23664|T290|14048:6 12810:4 13926:2 12809:2 14227:2|19216",	-- Argent Boots
	[15802] = "19435|T290|14048:6 14342:4 7971:2 14341",	-- Mooncloth Boots
	[14137] = "18440|T290|14048:6 14342:4 14341|14497",	-- Mooncloth Leggings
	[19047] = "23662|T290|14048:8 7076:3 12803:3 14227:2|19215",	-- Wisdom of the Timbermaw
	[14104] = "18439|T290|14048:6 3577:4 14227 14341|14494",	-- Brightcloth Pants
	[14111] = "18442|T290|14048:5 14256:2 14341|14496",	-- Felcloth Hood
	[14144] = "18441|T290|14048:6 9210:4 14341|14495",	-- Ghostweave Pants
	[13866] = "18444|T295|14048:4 14227:2 14341|14498",	-- Runecloth Headband
	[18405] = "22866|T300|14048:16 9210:10 14342:10 7080:12 7078:12 14344:6 14341:6|18414",	-- Belt of the Archmage
	[21342] = "26087|T300|14256:20 17012:16 19726:8 7078:4 14227:4|21371",	-- Core Felcloth Bag
	[16979] = "20849|T300|14048:8 17010:6 7078:4 12810:2 14341:2|17018",	-- Flarecore Gloves
	[19165] = "23667|T300|14342:8 17010:5 17011:3 7078:10 14227:4|19220",	-- Flarecore Leggings
	[16980] = "20848|T300|14048:12 17010:4 17011:4 12810:6 14341:2|17017",	-- Flarecore Mantle
	[19156] = "23666|T300|14342:10 17010:2 17011:3 7078:6 14227:4|19219",	-- Flarecore Robe
	[18263] = "22759|T300|14342:6 17010:8 7078:2 12810:6 14341:4|18265",	-- Flarecore Wraps
	[22658] = "28208|T300|22682:5 14048:4 7080:2 14227:4",	-- Glacial Cloak
	[22654] = "28205|T300|22682:5 14048:4 7080:4 14227:4",	-- Glacial Gloves
	[22652] = "28207|T300|22682:7 14048:8 7080:6 14227:8",	-- Glacial Vest
	[22655] = "28209|T300|22682:4 14048:2 7080:2 14227:4",	-- Glacial Wrists
	[14146] = "18454|T300|14048:10 14342:10 9210:10 13926:6 12364:6 12810:8 14341:2|14511",	-- Gloves of Spell Mastery
	[14152] = "18457|T300|14048:12 7078:10 7082:10 7076:10 7080:10 14341:2|14513",	-- Robe of the Archmage
	[14153] = "18458|T300|14048:12 12662:20 14256:40 7078:12 12808:12 14341:2|14514",	-- Robe of the Void
	[14154] = "18456|T300|14048:12 14342:10 12811:4 13926:4 9210:10 14341:2|14512",	-- Truefaith Vestments
	[19059] = "23665|T300|14342:5 12809:2 14227:2|19217",	-- Argent Shoulders
	[19684] = "24093|T300|14342:3 19726:3 12810:4 14048:4 14227:4|19766",	-- Bloodvine Boots
	[19683] = "24092|T300|14342:4 19726:4 12804:4 14048:4 14227:2|19765",	-- Bloodvine Leggings
	[19682] = "24091|T300|14342:3 19726:5 12804:4 14048:4 14227:2|19764",	-- Bloodvine Vest
	[14156] = "18455|T300|14048:8 14342:12 14344:2 17012:2 14341:2|14510",	-- Bottomless Bag
	[18413] = "22870|T300|14048:12 12809:4 12360 14341:2|18418",	-- Cloak of Warding
	[18407] = "22867|T300|14048:12 14256:20 12662:6 12808:8 14341:2|18415",	-- Felcloth Gloves
	[22660] = "28210|T300|19726 14342:2 12803:4 14227:4|22683",	-- Gaea's Embrace
	[18408] = "22868|T300|14048:12 7078:10 7910:2 14341:2|18416",	-- Inferno Gloves
	[19050] = "23663|T300|14342:5 7076:5 12803:5 14227:2|19218",	-- Mantle of the Timbermaw
	[18409] = "22869|T300|14048:12 14342:6 13926:2 14341:2|18417",	-- Mooncloth Gloves
	[20539] = "24902|T300|14048:2 20520:6 14256:2 12810:2 14227:2|20548",	-- Runed Stygian Belt
	[20537] = "24903|T300|14048:4 20520:6 14256:4 12810:2 14227:2|20547",	-- Runed Stygian Boots
	[20538] = "24901|T300|14048:6 20520:8 14256:6 14227:2|20546",	-- Runed Stygian Leggings
	[22757] = "28481|T300|14048:4 14342:2 12803:2 14227:2|22773",	-- Sylvan Crown
	[22758] = "28482|T300|14048:2 12803:4 14227:2|22772",	-- Sylvan Shoulders
	[22756] = "28480|T300|14048:4 19726:2 12803:2 14227:2|22774",	-- Sylvan Vest
	[22249] = "27660|T300|14048:6 14344:4 12810:4 14227:4|22309",	-- Big Bag of Enchantment
	[14106] = "18451|T300|14048:8 14256:3 12662:2 14341:2|14506",	-- Felcloth Robe
	[14112] = "18453|T300|14048:7 14256:3 12662:2 8170:4 14341:2|14508",	-- Felcloth Shoulders
	[68] = "22815|L300|8170:4 14048:2 18240 14341|||18258",	-- Gordok Ogre Suit
	[69] = "22813|T300|14048:2 8170:4 18240 14341|||18258",	-- Gordok Ogre Suit
	[14155] = "18445|T300|14048:4 14342 14341|14499",	-- Mooncloth Bag
	[13867] = "18449|T300|14048:7 14227:2 8170:4 14341|14504",	-- Runecloth Shoulders
	[22252] = "27725|T300|14048:6 14342:2 13468 14227:4|22312",	-- Satchel of Cenarius
	[14128] = "18446|T300|14048:8 11176:2 14341|14500",	-- Wizardweave Robe
	[14130] = "18450|T300|14048:6 11176:4 7910 14341|14505",	-- Wizardweave Turban
	[21840] = "26745|T300|21877:6",	-- Bolt of Netherweave
	[24268] = "31460|T300|21877:3||2",	-- Netherweave Net
	[21850] = "26765|T310|21840:3 14341",	-- Netherweave Belt
	[21849] = "26764|T310|21840:3 14341",	-- Netherweave Bracers
	[21841] = "26746|T315|21840:4 14341",	-- Netherweave Bag
	[21851] = "26770|T320|21840:4 21887:2 14341",	-- Netherweave Gloves
	[21842] = "26747|T325|21840:3 22445:2|21892",	-- Bolt of Imbued Netherweave
	[21852] = "26771|T325|21840:6 14341",	-- Netherweave Pants
--	[24269] = "31461|T325|21877:6|24315|2",	-- Heavy Netherweave Net; Removed during TBC beta
	[24273] = "31430|T335|14341 22457:5|24292",	-- Mystic Spellthread
	[24275] = "31431|T335|14341 21886:5|24293",	-- Silver Spellthread
	[21853] = "26772|T335|21840:6 21887:2 14341",	-- Netherweave Boots
	[21859] = "26775|T340|21842:5 21881:2 14341|21898",	-- Imbued Netherweave Pants
	[24270] = "31459|T340|21842:6 21887:4|24314",	-- Bag of Jewels
	[21843] = "26749|T340|21842:4 21881:2 22446|21893",	-- Imbued Netherweave Bag
	[21854] = "26773|T340|21840:8 14341:2|21896",	-- Netherweave Robe
	[21855] = "26774|T345|21840:8 14341:2|21897",	-- Netherweave Tunic
	[21844] = "26750|T345|21840 21882:8|21894",	-- Bolt of Soulcloth
	[21866] = "26782|T350|21840:6 22445:12 14341:2|21905",	-- Arcanoweave Bracers
	[24251] = "31437|T350|21842:4 21884:8|24298",	-- Blackstrike Bracers
	[24250] = "31435|T350|21842:4 22452:4 22456:4|24297",	-- Bracers of Havok
	[30831] = "37873|T350|21842:4 22457:3 21886:3 21881:2|30833",	-- Cloak of Arcane Evasion
	[24253] = "31440|T350|21842:6 22452:6|24300",	-- Cloak of Eternity
	[24252] = "31438|T350|21842:6 22457:3 22456:3|24299",	-- Cloak of the Black Void
	[30837] = "37882|T350|21840:5 21884:5 14341:2|30842",	-- Flameheart Bracers
	[21860] = "26776|T350|21842:4 21887:6 21881:2 14341|21899",	-- Imbued Netherweave Boots
	[21845] = "26751|T350|21842 21886 21885|21895",	-- Primal Mooncloth
	[24272] = "36686|T350|21842 22456 21884|30483",	-- Shadowcloth
	[24271] = "31373|T350|21842 22457 21884|24316",	-- Spellcloth
	[24249] = "31434|T350|21842:4 22452:8|24296",	-- Unyielding Bracers -- also 35308
	[24254] = "31441|T350|21842:6 21886:6|24301",	-- White Remedy Cape
	[21863] = "26779|T355|21844:5 21887:6 14341:4|21902",	-- Soulcloth Gloves
	[21867] = "26783|T360|21840:8 22445:16 14341:2|21906",	-- Arcanoweave Boots
	[30838] = "37883|T360|21840:7 21884:7 14341:2|30843",	-- Flameheart Gloves
	[21861] = "26777|T360|21842:6 21881:2 14341|21900",	-- Imbued Netherweave Robe
	[21862] = "26778|T360|21842:6 21881:2 14341|21901",	-- Imbued Netherweave Tunic
	[24257] = "31444|T365|21842:6 22457:14 23572|24304",	-- Black Belt of Knowledge
	[24256] = "31443|T365|24272:10 21884:16 23572|24303",	-- Girdle of Ruination
	[24260] = "31450|T365|24271:10 22457:12 23572|24307",	-- Manaweave Cloak
	[24258] = "31448|T365|21845:10 22452:12 23572|24305",	-- Resolute Cape
	[21864] = "26780|T365|21844:6 14341:4|21903",	-- Soulcloth Shoulders
	[24255] = "31442|T365|21845:8 22452:16 23572|24302",	-- Unyielding Girdle -- also 35309
	[24259] = "31449|T365|24272:10 22451:14 23572|24306",	-- Vengeance Wrap
	[21868] = "26784|T370|21840:12 22445:20 14341:2|21907",	-- Arcanoweave Robe
	[30839] = "37884|T370|21840:9 21884:9 14341:2|30844",	-- Flameheart Vest
	[24267] = "31456|T375|21842:12 23571:8 23572|24313",	-- Battlecast Hood
	[24263] = "31453|T375|21842:12 23571:8 23572|24310",	-- Battlecast Pants
	[24276] = "31433|T375|14341 21886:10 23572|24295",	-- Golden Spellthread
	[24274] = "31432|T375|14341 22457:10 23572|24294",	-- Runic Spellthread
	[21865] = "26781|T375|21844:8 14341:4|21904",	-- Soulcloth Vest
	[24266] = "31455|T375|24271:10 23571:5 23572|24312",	-- Spellstrike Hood
	[24262] = "31452|T375|24271:10 23571:5 23572|24309",	-- Spellstrike Pants
	[32585] = "41208|T375|21842:4 21845:2 21886:6 32428:2|32753",	-- Swiftheal Mantle -- also 35525
	[32584] = "41207|T375|21842:3 21845:4 21886:8 32428:4|32752",	-- Swiftheal Wraps -- also 35526
	[24264] = "31454|T375|21845:10 23571:5 23572|24311",	-- Whitemend Hood
	[24261] = "31451|T375|21845:10 23571:5 23572|24308",	-- Whitemend Pants
	[21872] = "26759|T375|24272:6 21881:4|21915",	-- Ebon Shadowbag
	[21876] = "26763|T375|21845:8 21881:4|21919",	-- Primal Mooncloth Bag
	[21858] = "26755|T375|24271:6 22446:4 21881:4|21911",	-- Spellfire Bag
	[30463] = "36670|T375|21840:6 21887:4 21885:3 21886:3 21881:2",	-- Lifeblood Belt
	[30464] = "36672|T375|21840:4 21887:4 21885:2 21886:2 21881:2",	-- Lifeblood Bracers
	[30465] = "36669|T375|21840:10 21885:5 21886:5 21881:2",	-- Lifeblood Leggings
	[30460] = "36667|T375|21840:6 21887:4 21884:3 22456:4 21881:2",	-- Netherflame Belt
	[30461] = "36668|T375|21840:6 21887:4 21884:2 22456:6 21881:2",	-- Netherflame Boots
	[30459] = "36665|T375|21840:10 21884:5 22456:6 21881:2",	-- Netherflame Robe
	[21873] = "26760|Tm355|21845:4 21881:2 21886:8|21916",	-- Primal Mooncloth Belt
	[21874] = "26761|Tm365|21845:8 21881:2 21886:8|21918",	-- Primal Mooncloth Shoulders
	[21875] = "26762|Tm375|21845:14 22457:12 21881:4|21917",	-- Primal Mooncloth Robe
	[21869] = "26756|Ts355|24272:4 21885:10 21881:2|21912",	-- Frozen Shadoweave Shoulders
	[21870] = "26757|Ts365|24272:8 21885:12 21881:2|21914",	-- Frozen Shadoweave Boots
	[21871] = "26758|Ts375|24272:14 21885:16 21881:4|21913",	-- Frozen Shadoweave Robe
	[21846] = "26752|Tp355|24271:4 21884:10 21881:2|21908",	-- Spellfire Belt
	[21847] = "26753|Tp365|24271:8 21884:12 21881:4|21909",	-- Spellfire Gloves
	[21848] = "26754|Tp375|24271:14 21884:16 21881:4|21910",	-- Spellfire Robe
    [30038] = '36315|T375|30183:2 21842:4 21884:15 14341:2|30280', --Belt of Blasting
    [30036] = '36316|T375|30183:2 21842:4 21886:10 14341:2 21885:10|30281', --Belt of the Long Road
    [30037] = '36317|T375|23572:2 24272:4 24271:4 14341:2|30282', --Boots of Blasting
    [30035] = '36318|T375|23572:2 21845:4 24271:4 14341:2|30283', -- Boots of the Long Road
    [32587] = '41206|T375|21842:4 24271:2 22457:6 32428:2|32755', -- Mantle of Nimble Thought -- also rid 35522****
    [32586] = '41205|T375|21842:3 24271:4 22457:8 32428:4|32754', --Bracers of Nimble Thought - also rid35518*******
    [32420] = '40060|T375|32428:1 22450:1 21886:2 22456:2 21842:1|32447', --Night's End
    [32392] = '40021|T375|32428:1 22450:1 21886:2 22456:2 21842:1|32438', --Soulguard Bracers
    [32390] = '40024|T375|32428:2 22450:1 21886:3 22456:4 21842:1|32440', --Soulguard Girdle
    [32389] = '40023|T375|32428:3 22450:1 21886:4 22456:6 21842:2|32439', --Soulguard Leggings
    [32391] = '40020|T375|32428:2 22450:1 21886:2 22456:4 21842:1|32437', --Soulguard Slippers
    [34087] = "44950|T250|14048:8 2997 2605:2 14341|34261", -- Green Winter Clothes
    [34085] = "44958|T250|14048:8 2997 2604:2 14341|34319", -- Red Winter Clothes
--[[ poisons --]]
	[6947] = '8681|Z1|2928 3371',	-- Instant Poison
	[3775] = '3420|Z1|2930 3371',	-- Crippling Poison
	[5237] = '5763|Z100|2928 3371',	-- Mind-numbing Poison
	[6949] = '8687|Z120|2928 3372',	-- Instant Poison II
	[2892] = '2835|Z130|5173 3372',	-- Deadly Poison
	[10918] = '13220|Z140|2930 3372',	-- Wound Poison
--	[5530] = '6510|Z150|3818||3',	-- Blinding Powder
	[6950] = '8691|Z160|8924:2 3372',	-- Instant Poison III
	[2893] = '2837|Z170|5173:2 3372',	-- Deadly Poison II
	[6951] = '8694|Z170|8923 3372',	-- Mind-numbing Poison II
	[10920] = '13228|Z180|2930 5173 3372',	-- Wound Poison II
	[8926] = '11341|Z200|8924 8925',	-- Instant Poison IV
	[8984] = '11357|Z210|5173 8925',	-- Deadly Poison III
	[10921] = '13229|Z220|8923 5173:2 8925',	-- Wound Poison III
	[3776] = '3421|Z230|8923 8925',	-- Crippling Poison II
	[8927] = '11342|Z240|8924:2 8925',	-- Instant Poison V
	[9186] = '11400|Z240|8923 8923:2 8925',	-- Mind-numbing Poison III
	[8985] = '11358|Z250|5173:2 8925',	-- Deadly Poison IV
	[10922] = '13230|Z260|8923 5173:2 8925',	-- Wound Poison IV
	[8928] = '11343|Z280|2931 8925',	-- Instant Poison VI
	[20844] = '25347|Z300|5173:2 8925|21302',	-- Deadly Poison V
	[21835] = '26786|Z340|2931 5173 8925',	-- Anesthetic Poison
	[21927] = '26892|Z340|2931 8925',	-- Instant Poison VII
	[22053] = '26969|Z310|2931 8925',	-- Deadly Poison VI
	[22054] = '27282|Z350|2931 8925',	-- Deadly Poison VII
	[22055] = '27283|Z320|8923:2 8925',	-- Wound Poison V
--~ --[[ New in 2.4 --]]
    [34360] = '46126|J365|31079:6 32249:6|35205', -- Amulet of Flowing Life - also recipe 35533
    [34361] = "46124|J365|35128:4 22451:20 31079:12 34664:5|35200", -- Hard Khorium Band
    [34358] = "46127|J365|35128:6 23572:9|35203", -- Hard Khorium Choker - also 35535
    [34359] = "46125|J365|31079:12 32227:3 32228:3|35201", -- Pendant of Sunfire - also 35537
    [34362] = "46122|J365|35128:4 23571:4 31079:12 34664:5|35198", -- Loop of Forged Power
    [34363] = "46123|J365|35128:4 21886:20 31079:12 34664:5|35199", -- Ring of Flowing Life - also 35538
    [34369] = "46138|L365|23793:40 25707:24 23571:6 23572:6|35218", -- Carapace of Sun and Shadow - also 35539
    [34373] = "46137|L365|23793:40 29547:24 23571:6 23572:6|35217", -- Embrace of the Phoenix
    [34374] = "46133|L365|23793:30 29547:16 22451:18 23571:8 34664:6|35213", -- Fletcher's Gloves of the Phoenix - also 35541
    [34370] = "46134|L365|23793:30 25707:16 22456:18 23571:8 34664:6|35214", -- Gloves of Immortal Dusk
    [34367] = "46129|T365|21845:18 21886:12 21885:12 34664:6|35205", -- Hands of Eternal Light -- also 35544
    [34371] = "46136|L365|23793:40 25708:24 23571:6 23572:6|35216", -- Leather Chestguard of the Sun -- also 35545
    [34372] = "46132|L365|23793:30 25708:16 21886:18 23571:8 34664:6|35212", -- Leather Gauntlets of the Sun -- also 35546
    [34365] = "46131|T365|21845:20 23572:2|35207", -- Robe of Eternal Light -- also 35548
    [34375] = "46139|L365|23793:40 29548:24 23571:6 23572:6|35219", -- Sun-Drenched Scale Chestguard
    [34376] = "46135|L365|23793:30 29548:16 21886:18 23571:8 34664:6|35215", -- Sun-Drenched Scale Gloves -- also 35550
    [34366] = "46128|T365|24271:10 24272:10 34664:6|35204", -- Sunfire Handwraps -- also 35551
    [34364] = "46130|T365|24271:12 24272:12 34664:2|35206", -- Sunfire Robe
    [34378] = "46141|B365|35128:10 21884:12 22456:12 22451:12 34664:6|35209", -- Hard Khorium Battlefists --also 35553
    [34377] = "46144|B365|23449:20 23573:4 21884:10 22456:10 23572:6|35211", -- Hard Khorium Battleplate
    [34379] = "46142|B365|23449:20 23573:4 21886:15 21885:15 23572:6|35210", -- Sunblessed Breastplate
    [34380] = "46140|B365|35128:8 21886:20 23571:6 34664:6|35208", -- Sunblessed Gauntlets
    [34847] = "46111|E375|32494 22456:4 21884:4 22457:4 23572:4|35186", -- Annihilator Holo-Gogs (Requires Mage, Priest, Warlock)
    [34357] = "46115|E375|32473 35128:2 23571:1 23572:4|35196", -- Hard Khorium Goggles (Requires Paladin, Warrior)
    [35182] = "46109|E375|32480 21885:6 21886:12 23572:4|35190", -- Hyper-Magnified Moon Specs (Requires Druid)
    [35185] = "46107|E375|32472 21886:8 22457:8 22452:8 23572:4|35187", -- Justicebringer 3000 Specs (Requires Paladin)
    [34355] = "46112|E375|32476 23571:2 22451:2 23572:4|35193", -- Lightning Etched Specs (Requires Shaman)
    [34354] = "46114|E375|32461 21884:10 23572:4|35195", -- Mayhem Projection Goggles (Requires Warrior, Paladin)
    [35181] = "46108|E375|32495 21886:8 22457:8 23572:4|35189", -- Powerheal 9000 Lens (Requires Priest)
    [35184] = "46110|E375|32475 21886:5 22457:5 21885:5 23572:4|35192", -- Primal-Attuned Goggles (Requires Shaman)
    [34353] = "46116|E375|32478 22456:12 23572:4|35197", -- Quad Deathblow X44 Goggles (Requires Rogue, Druid)
    [34356] = "46113|E375|32474 22451:12 23572:4|35194", -- Surestrike Goggles v3.0 (Requires Hunter, Shaman)
    [35183] = "46106|E375|32479 21885:4 22457:8 23572:4|35191", -- Wonderheal XT68 Shades (Requires Druid)
    [34832] = "45695|W100|2596 2594|34834|5", -- Captain Rumsey's Lager
    [35503] = "46601|J370|25868|35505", -- Ember Skyfire Diamond, requires Shattered Sun Offensive Revered
    [35501] = "46597|J370|25867|35502", -- Eternal Earthstorm Diamond, Requires Shattered Sun Offesnive Revered
    [-45765] = "D360|22450|34872|2|22449", -- Void Shatter, Requires Shattered Sun Offensive Honored
    [35563] = "46684|W250|35562|35564", -- Charred Bear Kabobs
    [35565] = "46688|W250|35562|35566", -- Juicy Bear Burger
   	[35128] = "46353|Y375|23449:3 23573|35273",	-- Smelt Hardened Khorium
    [35759] = "47053|J375|32249|35769", --Forceful Seaspray Emerald
    [35761] = "47056|J375|32229|35768", -- Quick Lionseye
    [35760] = "47055|J375|32231|35767", -- Reckless Pyrestone
    [35758] = "47054|J375|32249|35766", -- Steady Seaspray Emerald
    [35581] = "46697|E355|21840:8 23786:2 23785:2 23787:4|35582", -- Rocket Boots Xtreme Lite
    [35700] = "46777|J375|23447:8 32227:2 21884:8|35697", -- Figurine - Crimson Serpent
    [35693] = "46775|J375|23449:8 32228:2 23440:6|35696", -- Figurine - Empyrean Tortoise
    [35694] = "46776|J375|23449:8 32231:2 22452:8|35696", -- Figurine - Khorium Boar
    [35703] = "46779|J375|23447:8 32249:2 22457:8|35699", -- Figurine - Seaspray Albatross
    [35702] = "46778|J375|23573:4 32230:2 22456:8|35698", -- Figurine - Shadowsong Panther
    [35707] = "46803|J375|23441|35708", -- Regal Nightseye
    [-46594] = "D360|22446:4 22445:8 23427:4|35500", -- Enchant Chest - Defense
    [35751] = "47050|A375|13503 22456:6 30183:2|35755", -- Assassin's Alchemist Stone
    [35748] = "47046|A375|13503 22451:6 30183:2|35752", -- Guardian's Alchemist Stone
    [35750] = "47049|A375|13503 21886:6 30183:2|35754", -- Redeemer's Alchemist Stone
    [35749] = "47048|A375|13503 21884:6 30183:2|35753", -- Sorcerer's Alchemist Stone
    [-47051] = "D375|22446:8 22452:8|35756", -- Enchant Cloak - Steelweave
    [35318] = "46405|J350|23437|35325", --Forceful Talasite
    [35315] = "46403|J350|23440|35322", --Quick Dawnstone
    [35316] = "46404|J350|23439|35323", --Reckless Noble Topaz
    }

TradeskillInfo.vars.components = {
	[2454] = BTS["Elixir of Lion's Strength"].."/20/Ca",
	[5997] = BTS["Elixir of Minor Defense"].."/5/Ca",
	[118] = BTS["Minor Healing Potion"].."/5/Ca",
	[3382] = BTS["Weak Troll's Blood Potion"].."/10/Ca",
	[2455] = BTS["Minor Mana Potion"].."/10/Ca",
	[2456] = BTS["Minor Rejuvenation Potion"].."/15/Ca",
	[4596] = BTS["Discolored Healing Potion"].."/25/Ca",
	[2457] = BTS["Elixir of Minor Agility"].."/15/Ca",
	[2458] = BTS["Elixir of Minor Fortitude"].."/15/Ca",
	[858] = BTS["Lesser Healing Potion"].."/25/Ca",
	[5631] = BTS["Rage Potion"].."/30/Ca",
	[2459] = BTS["Swiftness Potion"].."/25/Ca",
	[6370] = BTS["Blackmouth Oil"].."/10/Ca",
	[6662] = BTS["Elixir of Giant Growth"].."/95/Ca",
	[5996] = BTS["Elixir of Water Breathing"].."/95/Ca",
	[3383] = BTS["Elixir of Wisdom"].."/100/Ca",
	[6051] = BTS["Holy Protection Potion"].."/62/Ca",
	[6372] = BTS["Swim Speed Potion"].."/35/Ca",
	[929] = BTS["Healing Potion"].."/75/Ca",
	[3384] = BTS["Minor Magic Resistance Potion"].."/20/Ca",
	[3385] = BTS["Lesser Mana Potion"].."/30/Ca",
	[1] = BTS["Potion of Curing"].."/0/Ca",
	[3386] = "Elixir of Poison Resistance/35/Ca",
	[3388] = BTS["Strong Troll's Blood Potion"].."/40/Ca",
	[3389] = BTS["Elixir of Defense"].."/40/Ca",
	[6371] = BTS["Fire Oil"].."/12/Ca",
	[6048] = BTS["Shadow Protection Potion"].."/100/Ca",
	[6373] = BTS["Elixir of Firepower"].."/35/Ca",
	[3390] = BTS["Elixir of Lesser Agility"].."/35/Ca",
	[3391] = BTS["Elixir of Ogre's Strength"].."/20/Ca",
	[5634] = BTS["Free Action Potion"].."/75/Ca",
	[1710] = BTS["Greater Healing Potion"].."/125/Ca",
	[3827] = BTS["Mana Potion"].."/120/Ca",
	[3824] = BTS["Shadow Oil"].."/150/Ca",
	[6049] = BTS["Fire Protection Potion"].."/170/Ca",
	[3823] = BTS["Lesser Invisibility Potion"].."/100/Ca",
	[3826] = BTS["Mighty Troll's Blood Potion"].."/105/Ca",
	[3825] = BTS["Elixir of Fortitude"].."/110/Ca",
	[5633] = BTS["Great Rage Potion"].."/150/Ca",
	[8949] = BTS["Elixir of Agility"].."/200/Ca",
	[17708] = BTS["Elixir of Frost Power"].."/35/Ca",
	[3829] = BTS["Frost Oil"].."/150/Ca",
	[6050] = BTS["Frost Protection Potion"].."/300/Ca",
	[6052] = BTS["Nature Protection Potion"].."/300/Ca",
	[3828] = BTS["Elixir of Detect Lesser Invisibility"].."/150/Ca",
	[8951] = BTS["Elixir of Greater Defense"].."/200/Ca",
	[9061] = BTS["Goblin Rocket Fuel"].."/250/Ca",
	[10592] = BTS["Catseye Elixir"].."/150/Ca",
	[6149] = BTS["Greater Mana Potion"].."/120/Ca",
	[8956] = BTS["Oil of Immolation"].."/200/Ca",
	[2] = BTS["Transmute: Iron to Gold"].."/0/Ca",
	[3577] = "Barra de Oro/600/Cs",
	[3] = BTS["Transmute: Mithril to Truesilver"].."/0/Ca",
	[6037] = "Barra de Truesilver/1250/Cs",
	[9036] = BTS["Magic Resistance Potion"].."/20/Ca",
	[9149] = BTS["Philosopher's Stone"].."/250/Ca",
	[18294] = BTS["Elixir of Greater Water Breathing"].."/250/Ca",
	[4623] = BTS["Lesser Stoneshield Potion"].."/375/Ca",
	[3928] = BTS["Superior Healing Potion"].."/250/Ca",
	[9144] = BTS["Wildvine Potion"].."/250/Ca",
	[9030] = BTS["Restorative Potion"].."/250/Ca", -- Restorative Potion, added 8"].."/7"].."/2007
	[12190] = BTS["Dreamless Sleep Potion"].."/250/Ca",
	[9154] = BTS["Elixir of Detect Undead"].."/300/Ca",
	[9210] = BTS["Ghost Dye"].."/750/Ca",
	[9155] = BTS["Arcane Elixir"].."/400/Ca",
	[9179] = BTS["Elixir of Greater Intellect"].."/1000/Ca",
	[9264] = BTS["Elixir of Shadow Power"].."/35/Ca",
	[9172] = BTS["Invisibility Potion"].."/500/Ca",
	[9197] = BTS["Elixir of Dream Vision"].."/600/Ca",
	[9187] = BTS["Elixir of Greater Agility"].."/600/Ca",
	[9088] = BTS["Gift of Arthas"].."/250/Ca",
	[9206] = BTS["Elixir of Giants"].."/700/Ca",
	[9224] = BTS["Elixir of Demonslaying"].."/700/Ca",
	[9233] = BTS["Elixir of Detect Demon"].."/500/Ca",
	[21546] = BTS["Elixir of Greater Firepower"].."/35/Ca",
	[3387] = BTS["Limited Invulnerability Potion"].."/30/Ca",
	[13423] = BTS["Stonescale Oil"].."/125/Ca",
	[13442] = BTS["Mighty Rage Potion"].."/500/Ca",
	[13443] = BTS["Superior Mana Potion"].."/400/Ca",
	[13445] = BTS["Elixir of Superior Defense"].."/500/Ca",
	[13447] = BTS["Elixir of the Sages"].."/1250/Ca",
	[4] = BTS["Transmute: Air to Fire"].."/0/Ca",
	[7078] = "Esencia de Fuego/400/D",
	[5] = BTS["Transmute: Arcanite"].."/0/Ca",
	[12360] = "Barra de Arcanita/5000/Ca",
	[6] = BTS["Transmute: Earth to Life"].."/0/Ca",
	[12803] = "Esencia de Vida/500/D",
	[7] = BTS["Transmute: Earth to Water"].."/0/Ca",
	[7080] = "Esencia de Agua/400/D",
	[8] = BTS["Transmute: Fire to Earth"].."/0/Ca",
	[7076] = "Esencia de Tierra/400/D",
	[9] = BTS["Transmute: Life to Earth"].."/0/Ca",
	[10] = BTS["Transmute: Undeath to Water"].."/0/Ca",
	[11] = BTS["Transmute: Water to Air"].."/0/Ca",
	[7082] = "Esencia de Aire/400/D",
	[12] = BTS["Transmute: Water to Undeath"].."/0/Ca",
	[12808] = "Esencia de No-Muerto/1000/D",
	[13453] = BTS["Elixir of Brute Force"].."/1250/Ca",
	[20002] = BTS["Greater Dreamless Sleep Potion"].."/1000/Ca",
	[20007] = BTS["Mageblood Potion"].."/1000/Ca",
	[13446] = BTS["Major Healing Potion"].."/1000/Ca",
	[13452] = BTS["Elixir of the Mongoose"].."/1250/Ca",
	[13455] = BTS["Greater Stoneshield Potion"].."/750/Ca",
	[13454] = BTS["Greater Arcane Elixir"].."/750/Ca",
	[20008] = BTS["Living Action Potion"].."/600/Ca",
	[13462] = BTS["Purification Potion"].."/750/Ca",
	[9030] = BTS["Restorative Potion"].."/200/Ca",
	[13461] = BTS["Greater Arcane Protection Potion"].."/750/Ca",
	[13457] = BTS["Greater Fire Protection Potion"].."/750/Ca",
	[13456] = BTS["Greater Frost Protection Potion"].."/750/Ca",
	[13458] = BTS["Greater Nature Protection Potion"].."/750/Ca",
	[13459] = BTS["Greater Shadow Protection Potion"].."/100/Ca",
	[20004] = BTS["Major Troll's Blood Potion"].."/1000/Ca",
	[13444] = BTS["Major Mana Potion"].."/1500/Ca",
	[19931] = BTS["Gurubashi Mojo Madness"].."/0/Ca",
	[28103] = BTS["Adept's Elixir"].."/2500/Ca",
	[13513] = BTS["Flask of Chromatic Resistance"].."/5000/Ca",
	[13511] = BTS["Flask of Distilled Wisdom"].."/5000/Ca",
	[13506] = BTS["Flask of Petrification"].."/5000/Ca",
	[13512] = BTS["Flask of Supreme Power"].."/5000/Ca",
	[13510] = BTS["Flask of the Titans"].."/5000/Ca",
	[18253] = BTS["Major Rejuvenation Potion"].."/15/Ca",
	[28102] = BTS["Onslaught Elixir"].."/2500/Ca",
	[13] = BTS["Transmute: Elemental Fire"].."/0/Ca",
	[7068] = "Fuego Elemental/400/D",
	[28100] = BTS["Volatile Healing Potion"].."/1000/Ca",
	[22823] = BTS["Elixir of Camouflage"].."/2500/Ca",
	[22824] = BTS["Elixir of Major Strength"].."/2500/Ca",
	[22825] = BTS["Elixir of Healing Power"].."/2500/Ca",
	[32062] = BTS["Elixir of Major Fortitude"].."/0/Ca",
	[28101] = BTS["Unstable Mana Potion"].."/1500/Ca",
	[28104] = BTS["Elixir of Mastery"].."/2500/Ca",
	[22826] = BTS["Sneaking Potion"].."/2500/Ca",
	[32063] = BTS["Earthen Elixir"].."/0/Ca",
	[32067] = BTS["Elixir of Draenic Wisdom"].."/0/Ca",
	[22827] = BTS["Elixir of Major Frost Power"].."/2500/Ca",
	[22828] = BTS["Insane Strength Potion"].."/2500/Ca",
	[31080] = BTS["Mercurial Stone"].."/4000/Ca",
	[22830] = BTS["Elixir of the Searching Eye"].."/4000/Ca",
	[22829] = BTS["Super Healing Potion"].."/5000/Ca",
	[32068] = BTS["Elixir of Ironskin"].."/0/Ca",
	[22831] = BTS["Elixir of Major Agility"].."/4000/Ca",
	[31679] = BTS["Fel Strength Elixir"].."/3000/Ca",
	[22871] = BTS["Shrouding Potion"].."/5000/Ca",
	[22832] = BTS["Super Mana Potion"].."/5000/Ca",
	[22834] = BTS["Elixir of Major Defense"].."/4000/Ca",
	[22833] = BTS["Elixir of Major Firepower"].."/2500/Ca",
	[31676] = BTS["Fel Regeneration Potion"].."/5000/Ca",
	[13503] = BTS["Alchemist's Stone"].."/25000/Ca",
	[14] = BTS["Transmute: Earthstorm Diamond"].."/0/Ca",
	[25867] = "Diamante de Earthstorm/30000/Ca",
	[15] = BTS["Transmute: Primal Might"].."/0/Ca",
	[23571] = "Fuerza Principal/16000/Ca",
	[16] = BTS["Transmute: Skyfire Diamond"].."/0/Ca",
	[25868] = "Diamante de Skyfire/30000/Ca",
	[17] = BTS["Transmute: Primal Air to Fire"].."/0/Ca",
	[21884] = "Fuego Principal/4000/C",
	[18] = BTS["Transmute: Primal Earth to Water"].."/0/Ca",
	[21885] = "Agua Principal/4000/C",
	[19] = BTS["Transmute: Primal Fire to Earth"].."/0/Ca",
	[22452] = "Tierra Principal/4000/C",
	[20] = BTS["Transmute: Primal Water to Air"].."/0/Ca",
	[22451] = "Aire Principal/4000/C",
	[22839] = BTS["Destruction Potion"].."/5000/Ca",
	[22835] = BTS["Elixir of Major Shadow Power"].."/6000/Ca",
	[22838] = BTS["Haste Potion"].."/5000/Ca",
	[22837] = BTS["Heroic Potion"].."/5000/Ca",
	[22836] = BTS["Major Dreamless Sleep Potion"].."/5000/Ca",
	[22840] = BTS["Elixir of Major Mageblood"].."/6000/Ca",
	[31677] = BTS["Fel Mana Potion"].."/5000/Ca",
	[21] = BTS["Flask of Blinding Light"].."/0/Ca",
	[22861] = "Frasco de Fortalecimiento Arcano/20000/Ca",
	[22851] = BTS["Flask of Fortification"].."/20000/Ca",
	[22853] = BTS["Flask of Mighty Restoration"].."/20000/Ca",
	[22] = BTS["Flask of Pure Death"].."/0/Ca",
	[22866] = "Frasco de Fortalecimiento de las Sombras/20000/Ca",
	[22854] = BTS["Flask of Relentless Assault"].."/20000/Ca",
	[22845] = BTS["Major Arcane Protection Potion"].."/6000/Ca",
	[22841] = BTS["Major Fire Protection Potion"].."/6000/Ca",
	[22842] = BTS["Major Frost Protection Potion"].."/6000/Ca",
	[22847] = BTS["Major Holy Protection Potion"].."/6000/Ca",
	[22844] = BTS["Major Nature Protection Potion"].."/6000/Ca",
	[22846] = BTS["Major Shadow Protection Potion"].."/6000/Ca",
	[22850] = BTS["Super Rejuvenation Potion"].."/7000/Ca",
	[22848] = BTS["Elixir of Empowerment"].."/7000/Ca",
	[22849] = BTS["Ironshield Potion"].."/7000/Ca",
	[23] = BTS["Transmute: Primal Earth to Life"].."/0/Ca",
	[21886] = "Vida Principal/4000/C",
	[24] = BTS["Transmute: Primal Fire to Mana"].."/0/Ca",
	[22457] = "Mana Principal/4000/C",
	[25] = BTS["Transmute: Primal Life to Earth"].."/0/Ca",
	[26] = BTS["Transmute: Primal Mana to Fire"].."/0/Ca",
	[27] = BTS["Transmute: Primal Shadow to Water"].."/0/Ca",
	[28] = BTS["Transmute: Primal Water to Shadow"].."/0/Ca",
	[22456] = "Sombra Principal/4000/C",
	[32839] = BTS["Cauldron of Major Arcane Protection"].."/0/Ca",
	[32849] = BTS["Cauldron of Major Fire Protection"].."/0/Ca",
	[32850] = BTS["Cauldron of Major Frost Protection"].."/0/Ca",
	[32851] = BTS["Cauldron of Major Nature Protection"].."/0/Ca",
	[32852] = BTS["Cauldron of Major Shadow Protection"].."/0/Ca",
	[2853] = BTS["Copper Bracers"].."/17/Cb",
	[2852] = BTS["Copper Chain Pants"].."/67/Cb",
	[10421] = BTS["Rough Copper Vest"].."/32/Cb",
	[2862] = BTS["Rough Sharpening Stone"].."/3/Cb",
	[3239] = BTS["Rough Weightstone"].."/3/Cb",
	[2844] = BTS["Copper Mace"].."/106/Cb",
	[2845] = BTS["Copper Axe"].."/109/Cb",
	[3469] = BTS["Copper Chain Boots"].."/49/Cb",
	[2847] = BTS["Copper Shortsword"].."/110/Cb",
	[3470] = BTS["Rough Grinding Stone"].."/5/Cb",
	[7955] = BTS["Copper Claymore"].."/241/Cb",
	[7166] = BTS["Copper Dagger"].."/194/Cb",
	[3488] = BTS["Copper Battle Axe"].."/613/Cb",
	[3471] = BTS["Copper Chain Vest"].."/142/Cb",
	[2851] = BTS["Copper Chain Belt"].."/56/Cb",
	[3472] = BTS["Runed Copper Gauntlets"].."/71/Cb",
	[3473] = BTS["Runed Copper Pants"].."/299/Cb",
	[3474] = BTS["Gemmed Copper Gauntlets"].."/216/Cb",
	[2863] = BTS["Coarse Sharpening Stone"].."/10/Cb",
	[3240] = BTS["Coarse Weightstone"].."/10/Cb",
	[6214] = BTS["Heavy Copper Maul"].."/595/Cb",
	[3489] = BTS["Thick War Axe"].."/937/Cb",
	[2857] = BTS["Runed Copper Belt"].."/198/Cb",
	[3478] = BTS["Coarse Grinding Stone"].."/10/Cb",
	[2864] = BTS["Runed Copper Breastplate"].."/630/Cb",
	[2854] = BTS["Runed Copper Bracers"].."/225/Cb",
	[3487] = BTS["Heavy Copper Broadsword"].."/1498/Cb",
	[6350] = BTS["Rough Bronze Boots"].."/295/Cb",
	[6731] = BTS["Ironforge Breastplate"].."/871/Cb",
	[15869] = BTS["Silver Skeleton Key"].."/50/Cb",
	[29201] = BTS["Thick Bronze Darts"].."/150/Cb",
	[6338] = BTS["Silver Rod"].."/125/Cb",
	[3848] = BTS["Big Bronze Knife"].."/1426/Cb",
	[2865] = BTS["Rough Bronze Leggings"].."/962/Cb",
	[2866] = BTS["Rough Bronze Cuirass"].."/752/Cb",
	[2848] = BTS["Bronze Mace"].."/1119/Cb",
	[3480] = BTS["Rough Bronze Shoulders"].."/532/Cb",
	[5540] = BTS["Pearl-handled Dagger"].."/2107/Cb",
	[2849] = BTS["Bronze Axe"].."/1269/Cb",
	[2868] = BTS["Patterned Bronze Bracers"].."/807/Cb",
	[2850] = BTS["Bronze Shortsword"].."/1439/Cb",
	[3490] = BTS["Deadly Bronze Poniard"].."/2731/Cb",
	[3481] = BTS["Silvered Bronze Shoulders"].."/1284/Cb",
	[7956] = BTS["Bronze Warhammer"].."/1944/Cb",
	[3486] = BTS["Heavy Grinding Stone"].."/100/Cb",
	[2871] = BTS["Heavy Sharpening Stone"].."/40/Cb",
	[3241] = BTS["Heavy Weightstone"].."/40/Cb",
	[3491] = BTS["Heavy Bronze Mace"].."/2741/Cb",
	[3482] = BTS["Silvered Bronze Boots"].."/1317/Cb",
	[2869] = BTS["Silvered Bronze Breastplate"].."/1831/Cb",
	[7957] = BTS["Bronze Greatsword"].."/2205/Cb",
	[3483] = BTS["Silvered Bronze Gauntlets"].."/965/Cb",
	[7958] = BTS["Bronze Battle Axe"].."/2435/Cb",
	[5541] = BTS["Iridescent Hammer"].."/3693/Cb",
	[2870] = BTS["Shining Silver Breastplate"].."/2935/Cb",
	[3484] = BTS["Green Iron Boots"].."/1767/Cb",
	[3492] = BTS["Mighty Iron Hammer"].."/4552/Cb",
	[15870] = BTS["Golden Skeleton Key"].."/300/Cb",
	[3485] = BTS["Green Iron Gauntlets"].."/1295/Cb",
	[3851] = BTS["Solid Iron Maul"].."/6258/Cb",
	[11128] = BTS["Golden Rod"].."/500/Cb",
	[7071] = BTS["Iron Buckle"].."/100/Cb",
	[6042] = BTS["Iron Shield Spike"].."/250/Cb",
	[7914] = BTS["Barbaric Iron Breastplate"].."/3330/Cb",
	[3842] = BTS["Green Iron Leggings"].."/2906/Cb",
	[3849] = BTS["Hardened Iron Shortsword"].."/5468/Cb",
	[10423] = BTS["Silvered Bronze Leggings"].."/2842/Cb",
	[7913] = BTS["Barbaric Iron Shoulders"].."/2500/Cb",
	[3840] = BTS["Green Iron Shoulders"].."/2571/Cb",
	[3835] = BTS["Green Iron Bracers"].."/1106/Cb",
	[6043] = BTS["Iron Counterweight"].."/500/Cb",
	[3852] = BTS["Golden Iron Destroyer"].."/8360/Cb",
	[3843] = BTS["Golden Scale Leggings"].."/3882/Cb",
	[3836] = BTS["Green Iron Helm"].."/3053/Cb",
	[7915] = BTS["Barbaric Iron Helm"].."/3337/Cb",
	[3841] = BTS["Golden Scale Shoulders"].."/3106/Cb",
	[3850] = BTS["Jade Serpentblade"].."/7304/Cb",
	[3853] = BTS["Moonsteel Broadsword"].."/10153/Cb",
	[3844] = BTS["Green Iron Hauberk"].."/5658/Cb",
	[7916] = BTS["Barbaric Iron Boots"].."/3700/Cb",
	[12259] = BTS["Glinting Steel Dagger"].."/8072/Cb",
	[3855] = BTS["Massive Iron Axe"].."/11248/Cb",
	[7917] = BTS["Barbaric Iron Gloves"].."/2711/Cb",
	[3846] = BTS["Polished Steel Boots"].."/3937/Cb",
	[6040] = BTS["Golden Scale Bracers"].."/1649/Cb",
	[17704] = BTS["Edge of Winter"].."/9178/Cb",
	[3837] = BTS["Golden Scale Coif"].."/4405/Cb",
	[12260] = BTS["Searing Golden Blade"].."/10395/Cb",
	[6041] = BTS["Steel Weapon Chain"].."/1500/Cb",
	[3845] = BTS["Golden Scale Cuirass"].."/6558/Cb",
	[3854] = BTS["Frost Tiger Blade"].."/14120/Cb",
	[3847] = BTS["Golden Scale Boots"].."/4977/Cb",
	[3856] = BTS["Shadow Crescent Axe"].."/14221/Cb",
	[7963] = BTS["Steel Breastplate"].."/6488/Cb",
	[15871] = BTS["Truesilver Skeleton Key"].."/625/Cb",
	[29202] = BTS["Whirling Steel Axes"].."/600/Cb",
	[9060] = BTS["Inlaid Mithril Cylinder"].."/1000/Cb",
	[7966] = BTS["Solid Grinding Stone"].."/200/Cb",
	[7964] = BTS["Solid Sharpening Stone"].."/40/Cb",
	[7965] = BTS["Solid Weightstone"].."/40/Cb",
	[11144] = BTS["Truesilver Rod"].."/1000/Cb",
	[9366] = BTS["Golden Scale Gauntlets"].."/3689/Cb",
	[7919] = BTS["Heavy Mithril Gauntlet"].."/2476/Cb",
	[7918] = BTS["Heavy Mithril Shoulder"].."/3701/Cb",
	[7941] = BTS["Heavy Mithril Axe"].."/12520/Cb",
	[7921] = BTS["Heavy Mithril Pants"].."/5387/Cb",
	[7920] = BTS["Mithril Scale Pants"].."/8053/Cb",
	[7924] = BTS["Mithril Scale Bracers"].."/4103/Cb",
	[7967] = BTS["Mithril Shield Spike"].."/250/Cb",
	[7922] = BTS["Steel Plate Helm"].."/2377/Cb",
	[7942] = BTS["Blue Glittering Axe"].."/14659/Cb",
	[7927] = BTS["Ornate Mithril Gloves"].."/2987/Cb",
	[7926] = BTS["Ornate Mithril Pants"].."/5952/Cb",
	[7928] = BTS["Ornate Mithril Shoulder"].."/4857/Cb",
	[7943] = BTS["Wicked Mithril Blade"].."/15891/Cb",
	[7945] = BTS["Big Black Mace"].."/17291/Cb",
	[7930] = BTS["Heavy Mithril Breastplate"].."/7045/Cb",
	[7931] = BTS["Mithril Coif"].."/7955/Cb",
	[7933] = BTS["Heavy Mithril Boots"].."/5769/Cb",
	[7932] = BTS["Mithril Scale Shoulders"].."/8661/Cb",
	[7969] = BTS["Mithril Spurs"].."/250/Cb",
	[7944] = BTS["Dazzling Mithril Rapier"].."/20092/Cb",
	[7934] = BTS["Heavy Mithril Helm"].."/5790/Cb",
	[7946] = BTS["Runed Mithril Hammer"].."/21660/Cb",
	[12405] = BTS["Thorium Armor"].."/9239/Cb",
	[12406] = BTS["Thorium Belt"].."/4636/Cb",
	[12644] = BTS["Dense Grinding Stone"].."/200/Cb",
	[12404] = BTS["Dense Sharpening Stone"].."/75/Cb",
	[12643] = BTS["Dense Weightstone"].."/75/Cb",
	[7947] = BTS["Ebon Shiv"].."/24892/Cb",
	[12408] = BTS["Thorium Bracers"].."/4998/Cb",
	[11606] = BTS["Dark Iron Mail"].."/19255/Cb",
	[12416] = BTS["Radiant Belt"].."/7595/Cb",
	[11608] = BTS["Dark Iron Pulverizer"].."/45760/Cb",
	[12424] = BTS["Imperial Plate Belt"].."/5533/Cb",
	[12428] = BTS["Imperial Plate Shoulders"].."/8646/Cb",
	[12624] = BTS["Wildthorn Mail"].."/20642/Cb",
	[11605] = BTS["Dark Iron Shoulders"].."/10776/Cb",
	[12425] = BTS["Imperial Plate Bracers"].."/6044/Cb",
	[12415] = BTS["Radiant Breastplate"].."/17003/Cb",
	[11607] = BTS["Dark Iron Sunderer"].."/51225/Cb",
	[12774] = BTS["Dawn's Edge"].."/36044/Cb",
	[15872] = BTS["Arcanite Skeleton Key"].."/625/Cb",
	[12773] = BTS["Ornate Thorium Handaxe"].."/33079/Cb",
	[12645] = BTS["Thorium Shield Spike"].."/500/Cb",
	[16206] = BTS["Arcanite Rod"].."/1000/Cb",
	[12777] = BTS["Blazing Rapier"].."/38648/Cb",
	[12776] = BTS["Enchanted Battlehammer"].."/48124/Cb",
	[12775] = BTS["Huge Thorium Battleaxe"].."/39949/Cb",
	[12409] = BTS["Thorium Boots"].."/10336/Cb",
	[12410] = BTS["Thorium Helm"].."/10372/Cb",
	[11604] = BTS["Dark Iron Plate"].."/19428/Cb",
	[12628] = BTS["Demon Forged Breastplate"].."/16640/Cb",
	[12781] = BTS["Serenity"].."/42721/Cb",
	[12418] = BTS["Radiant Gloves"].."/10242/Cb",
	[12782] = BTS["Corruption"].."/56808/Cb",
	[12631] = BTS["Fiery Plate Gauntlets"].."/8919/Cb",
	[19051] = BTS["Girdle of the Dawn"].."/9365/Cb",
	[19043] = BTS["Heavy Timbermaw Belt"].."/13291/Cb",
	[12419] = BTS["Radiant Boots"].."/16421/Cb",
	[12792] = BTS["Volcanic Hammer"].."/39255/Cb",
	[17014] = BTS["Dark Iron Bracers"].."/12637/Cb",
	[16989] = BTS["Fiery Chain Girdle"].."/18610/Cb",
	[17193] = BTS["Sulfuron Hammer"].."/122310/Cb",
	[12632] = BTS["Storm Gauntlets"].."/14099/Cb",
	[12426] = BTS["Imperial Plate Boots"].."/12062/Cb",
	[12427] = BTS["Imperial Plate Helm"].."/12106/Cb",
	[12417] = BTS["Radiant Circlet"].."/17034/Cb",
	[19166] = BTS["Black Amnesty"].."/46447/Cb",
	[22194] = BTS["Black Grasp of the Destroyer"].."/33521/Cb",
	[19167] = BTS["Blackfury"].."/116531/Cb",
	[19168] = BTS["Blackguard"].."/102890/Cb",
	[20039] = BTS["Dark Iron Boots"].."/31709/Cb",
	[19164] = BTS["Dark Iron Gauntlets"].."/22425/Cb",
	[19148] = BTS["Dark Iron Helm"].."/25399/Cb",
	[17013] = BTS["Dark Iron Leggings"].."/26441/Cb",
	[19170] = BTS["Ebon Hand"].."/103689/Cb",
	[16988] = BTS["Fiery Chain Shoulders"].."/31460/Cb",
	[22671] = BTS["Icebane Bracers"].."/60635/Cb",
	[22669] = BTS["Icebane Breastplate"].."/119683/Cb",
	[22670] = BTS["Icebane Gauntlets"].."/60406/Cb",
	[12641] = BTS["Invulnerable Mail"].."/43836/Cb",
	[22198] = BTS["Jagged Obsidian Shield"].."/67440/Cb",
	[12640] = BTS["Lionheart Helm"].."/21894/Cb",
	[19169] = BTS["Nightfall"].."/129112/Cb",
	[22191] = BTS["Obsidian Mail Tunic"].."/73128/Cb",
	[22384] = BTS["Persuader"].."/80554/Cb",
	[22383] = BTS["Sageblade"].."/80019/Cb",
	[12639] = BTS["Stronghold Gauntlets"].."/15271/Cb",
	[22196] = BTS["Thick Obsidian Breastplate"].."/48043/Cb",
	[22385] = BTS["Titanic Leggings"].."/25276/Cb",
	[12798] = BTS["Annihilator"].."/57150/Cb",
	[12790] = BTS["Arcanite Champion"].."/74619/Cb",
	[12784] = BTS["Arcanite Reaper"].."/73036/Cb",
	[19690] = BTS["Bloodsoul Breastplate"].."/39683/Cb",
	[19692] = BTS["Bloodsoul Gauntlets"].."/19980/Cb",
	[19691] = BTS["Bloodsoul Shoulders"].."/29675/Cb",
	[17016] = BTS["Dark Iron Destroyer"].."/63973/Cb",
	[17015] = BTS["Dark Iron Reaver"].."/63738/Cb",
	[20550] = BTS["Darkrune Breastplate"].."/23051/Cb",
	[20549] = BTS["Darkrune Gauntlets"].."/11484/Cb",
	[20551] = BTS["Darkrune Helm"].."/17352/Cb",
	[19693] = BTS["Darksoul Breastplate"].."/24192/Cb",
	[19694] = BTS["Darksoul Leggings"].."/23555/Cb",
	[19695] = BTS["Darksoul Shoulders"].."/18285/Cb",
	[12618] = BTS["Enchanted Thorium Breastplate"].."/23972/Cb",
	[12620] = BTS["Enchanted Thorium Helm"].."/17245/Cb",
	[12619] = BTS["Enchanted Thorium Leggings"].."/24058/Cb",
	[12797] = BTS["Frostguard"].."/56943/Cb",
	[19057] = BTS["Gloves of the Dawn"].."/11606/Cb",
	[12796] = BTS["Hammer of the Titans"].."/70912/Cb",
	[12783] = BTS["Heartseeker"].."/58215/Cb",
	[22197] = BTS["Heavy Obsidian Belt"].."/14282/Cb",
	[19048] = BTS["Heavy Timbermaw Boots"].."/28061/Cb",
	[12636] = BTS["Helm of the Great Chief"].."/24285/Cb",
	[22764] = BTS["Ironvine Belt"].."/15864/Cb",
	[22762] = BTS["Ironvine Breastplate"].."/31492/Cb",
	[22763] = BTS["Ironvine Gloves"].."/15806/Cb",
	[22195] = BTS["Light Obsidian Belt"].."/22752/Cb",
	[12794] = BTS["Masterwork Stormhammer"].."/56304/Cb",
	[12633] = BTS["Whitesoul Helm"].."/14859/Cb",
	[18262] = BTS["Elemental Sharpening Stone"].."/1250/Cb",
	[29203] = BTS["Enchanted Thorium Blades"].."/10000/Cb",
	[23493] = BTS["Fel Iron Chain Coif"].."/27683/Cb",
	[23482] = BTS["Fel Iron Plate Gloves"].."/20269/Cb",
	[12422] = BTS["Imperial Plate Chest"].."/16204/Cb",
	[12429] = BTS["Imperial Plate Leggings"].."/17923/Cb",
	[12420] = BTS["Radiant Leggings"].."/25330/Cb",
	[12613] = BTS["Runic Breastplate"].."/18205/Cb",
	[12611] = BTS["Runic Plate Boots"].."/12293/Cb",
	[12612] = BTS["Runic Plate Helm"].."/12956/Cb",
	[12614] = BTS["Runic Plate Leggings"].."/18272/Cb",
	[12610] = BTS["Runic Plate Shoulders"].."/12247/Cb",
	[12414] = BTS["Thorium Leggings"].."/17376/Cb",
	[25843] = BTS["Fel Iron Rod"].."/8000/Cb",
	[23528] = BTS["Fel Sharpening Stone"].."/750/Cb",
	[28420] = BTS["Fel Weightstone"].."/750/Cb",
	[23484] = BTS["Fel Iron Plate Belt"].."/20969/Cb",
	[23491] = BTS["Fel Iron Chain Gloves"].."/18866/Cb",
	[23497] = BTS["Fel Iron Hatchet"].."/58164/Cb",
	[23494] = BTS["Fel Iron Chain Bracers"].."/19615/Cb",
	[23498] = BTS["Fel Iron Hammer"].."/8813/Cb",
	[23487] = BTS["Fel Iron Plate Boots"].."/33419/Cb",
	[23488] = BTS["Fel Iron Plate Pants"].."/44805/Cb",
	[23490] = BTS["Fel Iron Chain Tunic"].."/39760/Cb",
	[23499] = BTS["Fel Iron Greatsword"].."/795830/Cb",
	[23502] = BTS["Adamantite Maul"].."/82647/Cb",
	[23489] = BTS["Fel Iron Breastplate"].."/47475/Cb",
	[23559] = BTS["Lesser Rune of Warding"].."/750/Cb",
	[23503] = BTS["Adamantite Cleaver"].."/85143/Cb",
	[23504] = BTS["Adamantite Dagger"].."/68364/Cb",
	[23506] = BTS["Adamantite Plate Bracers"].."/28586/Cb",
	[23508] = BTS["Adamantite Plate Gloves"].."/28793/Cb",
	[23505] = BTS["Adamantite Rapier"].."/70380/Cb",
	[23507] = BTS["Adamantite Breastplate"].."/58548/Cb",
	--[29] = BTS["Lesser Rune of Warding"].."/0/Cb",
	[23575] = BTS["Lesser Ward of Shielding"].."/1500/Cb",
	[29204] = BTS["Felsteel Whisper Knives"].."/1223/Cb",
	[23515] = BTS["Flamebane Bracers"].."/29607/Cb",
	[23529] = BTS["Adamantite Sharpening Stone"].."/1000/Cb",
	[28421] = BTS["Adamantite Weightstone"].."/1000/Cb",
	[25844] = BTS["Adamantite Rod"].."/32000/Cb",
	[23576] = BTS["Greater Ward of Shielding"].."/3000/Cb",
	[23510] = BTS["Enchanted Adamantite Belt"].."/31529/Cb",
	[23511] = BTS["Enchanted Adamantite Boots"].."/47104/Cb",
	[23516] = BTS["Flamebane Helm"].."/44599/Cb",
	[23509] = BTS["Enchanted Adamantite Breastplate"].."/62984/Cb",
	[23517] = BTS["Felsteel Gloves"].."/30311/Cb",
	[23518] = BTS["Felsteel Leggings"].."/60504/Cb",
	[23514] = BTS["Flamebane Gloves"].."/32234/Cb",
	[23524] = BTS["Khorium Belt"].."/31103/Cb",
	[23523] = BTS["Khorium Pants"].."/61628/Cb",
	[23530] = BTS["Felsteel Shield Spike"].."/12000/Cb",
	[23537] = BTS["Black Felsteel Bracers"].."/35904/Cb",
	[23539] = BTS["Blessed Bracers"].."/36174/Cb",
	[23538] = BTS["Bracers of the Green Fortress"].."/5282/Cb",
	[23555] = BTS["Dirge"].."/13877/Cb",
	[23554] = BTS["Eternium Runed Blade"].."/91813/Cb",
	[23542] = BTS["Fel Edged Battleaxe"].."/103904/Cb",
	[23546] = BTS["Fel Hardened Maul"].."/5395/Cb",
	[23531] = BTS["Felfury Gauntlets"].."/29918/Cb",
	[23540] = BTS["Felsteel Longblade"].."/103139/Cb",
	[23543] = BTS["Felsteel Reaper"].."/130359/Cb",
	[23532] = BTS["Gauntlets of the Iron Tower"].."/35238/Cb",
	[23556] = BTS["Hand of Eternity"].."/101609/Cb",
	[23535] = BTS["Helm of the Stalwart Defender"].."/53053/Cb",
	[23541] = BTS["Khorium Champion"].."/129402/Cb",
	[23536] = BTS["Oathkeeper's Helm"].."/53248/Cb",
	[23544] = BTS["Runic Hammer"].."/104659/Cb",
	[23533] = BTS["Steelgrip Gauntlets"].."/35369/Cb",
	[23534] = BTS["Storm Helm"].."/45389/Cb",
	[23512] = BTS["Enchanted Adamantite Leggings"].."/64163/Cb",
	[23519] = BTS["Felsteel Helm"].."/45822/Cb",
	[23513] = BTS["Flamebane Breastplate"].."/64391/Cb",
	[23525] = BTS["Khorium Boots"].."/46837/Cb",
	[23520] = BTS["Ragesteel Gloves"].."/30896/Cb",
	[23521] = BTS["Ragesteel Helm"].."/46159/Cb",
	[23527] = BTS["Earthpeace Breastplate"].."/54020/Cb",
	[23522] = BTS["Ragesteel Breastplate"].."/61891/Cb",
	[31369] = BTS["Iceguard Breastplate"].."/73884/Cb",
	[31371] = BTS["Iceguard Helm"].."/55708/Cb",
	[31370] = BTS["Iceguard Leggings"].."/74152/Cb",
	[31364] = BTS["Wildguard Breastplate"].."/72552/Cb",
	[31368] = BTS["Wildguard Helm"].."/55107/Cb",
	[31367] = BTS["Wildguard Leggings"].."/73355/Cb",
	[25845] = BTS["Eternium Rod"].."/40000/Cb",
	[25521] = BTS["Greater Rune of Warding"].."/1250/Cb",
	[7929] = BTS["Orcish War Leggings"].."/7739/Cb",
	[7936] = BTS["Ornate Mithril Boots"].."/6739/Cb",
	[7935] = BTS["Ornate Mithril Breastplate"].."/8368/Cb",
	[7937] = BTS["Ornate Mithril Helm"].."/6763/Cb",
	[7938] = BTS["Truesilver Gauntlets"].."/4028/Cb",
	[7939] = BTS["Truesilver Breastplate"].."/10899/Cb",
	[30069] = BTS["Earthforged Leggings"].."/22391/Cb",
	[30070] = BTS["Windforged Leggings"].."/19263/Cb",
	[30074] = BTS["Heavy Earthforged Breastplate"].."/51597/Cb",
	[30076] = BTS["Stormforged Hauberk"].."/44570/Cb",
	[28483] = BTS["Breastplate of Kings"].."/71734/Cb",
	[23563] = BTS["Nether Chain Shirt"].."/67081/Cb",
	[28484] = BTS["Bulwark of Kings"].."/84902/Cb",
	[28485] = BTS["Bulwark of the Ancient Kings"].."/98174/Cb",
	[23565] = BTS["Embrace of the Twisting Nether"].."/87849/Cb",
	[23564] = BTS["Twisting Nether Chain Shirt"].."/75985/Cb",
	[7954] = BTS["The Shatterer"].."/23159/Cb",
	[7961] = BTS["Phantom Blade"].."/25508/Cb",
	[7959] = BTS["Blight"].."/33857/Cb",
	[30071] = BTS["Light Earthforged Blade"].."/32222/Cb",
	[30073] = BTS["Light Emberforged Hammer"].."/33297/Cb",
	[30072] = BTS["Light Skyforged Axe"].."/32340/Cb",
	[7960] = BTS["Truesilver Champion"].."/38548/Cb",
	[30088] = BTS["Skyforged Great Axe"].."/97120/Cb",
	[30087] = BTS["Stormforged Axe"].."/77416/Cb",
	[28434] = BTS["Lunar Crescent"].."/133370/Cb",
	[28431] = BTS["The Planar Edge"].."/102808/Cb",
	[28432] = BTS["Black Planar Edge"].."/117066/Cb",
	[28436] = BTS["Bloodmoon"].."/170435/Cb",
	[28435] = BTS["Mooncleaver"].."/151832/Cb",
	[28433] = BTS["Wicked Edge of the Planes"].."/134904/Cb",
	[30093] = BTS["Great Earthforged Hammer"].."/101472/Cb",
	[30089] = BTS["Lavaforged Warhammer"].."/80037/Cb",
	[28437] = BTS["Drakefist Hammer"].."/107834/Cb",
	[28440] = BTS["Thunder"].."/123276/Cb",
	[28441] = BTS["Deep Thunder"].."/140395/Cb",
	[28438] = BTS["Dragonmaw"].."/122767/Cb",
	[28439] = BTS["Dragonstrike"].."/124657/Cb",
	[28442] = BTS["Stormherald"].."/157642/Cb",
	[30086] = BTS["Stoneforged Claymore"].."/96412/Cb",
	[30077] = BTS["Windforged Rapier"].."/74563/Cb",
	[28425] = BTS["Fireguard"].."/100534/Cb",
	[28428] = BTS["Lionheart Blade"].."/127089/Cb",
	[28427] = BTS["Blazefury"].."/128528/Cb",
	[28426] = BTS["Blazeguard"].."/114486/Cb",
	[28429] = BTS["Lionheart Champion"].."/144720/Cb",
	[28430] = BTS["Lionheart Executioner"].."/162480/Cb",
	[6290] = BTS["Brilliant Smallfish"].."/1/Cc",
	[2679] = BTS["Charred Wolf Meat"].."/5/Cc",
	[12224] = BTS["Crispy Bat Wing"].."/10/Cc",
	[17197] = BTS["Gingerbread Cookie"].."/10/Cc",
	[6888] = BTS["Herb Baked Egg"].."/10/Cc",
	[27635] = BTS["Lynx Steak"].."/6/Cc",
	[2681] = BTS["Roasted Boar Meat"].."/6/Cc",
	[24105] = BTS["Roasted Moongraze Tenderloin"].."/6/Cc",
	[787] = BTS["Slitherskin Mackerel"].."/1/Cc",
	[30816] = BTS["Spice Bread"].."/5/Cc",
	[2888] = BTS["Beer Basted Boar Ribs"].."/10/Cc",
	[5472] = BTS["Kaldorei Spider Kabob"].."/10/Cc",
	[2680] = BTS["Spiced Wolf Meat"].."/10/Cc",
	[5473] = BTS["Scorpid Surprise"].."/10/Cc",
	[17198] = BTS["Egg Nog"].."/9/Cc",
	[5474] = BTS["Roasted Kodo Meat"].."/9/Cc",
	[6890] = BTS["Smoked Bear Meat"].."/6/Cc",
	[27636] = BTS["Bat Bites"].."/25/Cc",
	[5525] = BTS["Boiled Clams"].."/20/Cc",
	[2684] = BTS["Coyote Steak"].."/20/Cc",
	[5476] = BTS["Fillet of Frenzy"].."/3/Cc",
	[724] = BTS["Goretusk Liver Pie"].."/25/Cc",
	[6316] = BTS["Loch Frenzy Delight"].."/3/Cc",
	[4592] = BTS["Longjaw Mud Snapper"].."/1/Cc",
	[5095] = BTS["Rainbow Fin Albacore"].."/3/Cc",
	[5477] = BTS["Strider Stew"].."/18/Cc",
	[3220] = BTS["Blood Sausage"].."/40/Cc",
	[22645] = BTS["Crunchy Spider Surprise"].."/25/Cc",
	[7676] = BTS["Thistle Tea"].."/30/Cc",
	[2683] = BTS["Crab Cake"].."/25/Cc",
	[733] = BTS["Westfall Stew"].."/100/Cc",
	[3662] = BTS["Crocolisk Steak"].."/25/Cc",
	[2687] = BTS["Dry Pork Ribs"].."/25/Cc",
	[21072] = BTS["Smoked Sagefish"].."/40/Cc",
	[2682] = BTS["Cooked Crab Claw"].."/25/Cc",
	[6657] = BTS["Savory Deviate Delight"].."/5/Cc",
	[5526] = BTS["Clam Chowder"].."/75/Cc",
	[5478] = BTS["Dig Rat Stew"].."/70/Cc",
	[3663] = BTS["Murloc Fin Soup"].."/125/Cc",
	[4593] = BTS["Bristle Whisker Catfish"].."/4/Cc",
	[5479] = BTS["Crispy Lizard Tail"].."/125/Cc",
	[1082] = BTS["Redridge Goulash"].."/150/Cc",
	[1017] = BTS["Seasoned Wolf Kabob"].."/100/Cc",
	[3726] = BTS["Big Bear Steak"].."/125/Cc",
	[3666] = BTS["Gooey Spider Cake"].."/100/Cc",
	[5480] = BTS["Lean Venison"].."/95/Cc",
	[2685] = BTS["Succulent Pork Ribs"].."/75/Cc",
	[3664] = BTS["Crocolisk Gumbo"].."/100/Cc",
	[5527] = BTS["Goblin Deviled Clams"].."/95/Cc",
	[3727] = BTS["Hot Lion Chops"].."/125/Cc",
	[12209] = BTS["Lean Wolf Steak"].."/95/Cc",
	[3665] = BTS["Curiously Tasty Omelet"].."/150/Cc",
	[20074] = BTS["Heavy Crocolisk Stew"].."/300/Cc",
	[3728] = BTS["Tasty Lion Steak"].."/300/Cc",
	[4457] = BTS["Barbecued Buzzard Wing"].."/300/Cc",
	[12213] = BTS["Carrion Surprise"].."/300/Cc",
	[6038] = BTS["Giant Clam Scorcho"].."/312/Cc",
	[10841] = BTS["Goldthorn Tea"].."/85/Cc",
	[13851] = BTS["Hot Wolf Ribs"].."/312/Cc",
	[12212] = BTS["Jungle Stew"].."/300/Cc",
	[31] = BTS["Mithril Headed Trout"].."/0/Cc",
	[8364] = "Mithril Head Trout".."/6/Cc",
	[12214] = BTS["Mystery Stew"].."/300/Cc",
	[12210] = BTS["Roast Raptor"].."/300/Cc",
	[4594] = BTS["Rockscale Cod"].."/6/Cc",
	[21217] = BTS["Sagefish Delight"].."/125/Cc",
	[3729] = BTS["Soothing Turtle Bisque"].."/300/Cc",
	[12217] = BTS["Dragonbreath Chili"].."/300/Cc",
	[12215] = BTS["Heavy Kodo Stew"].."/300/Cc",
	[17222] = BTS["Spider Sausage"].."/300/Cc",
	[13927] = BTS["Cooked Glossy Mightfish"].."/8/Cc",
	[13930] = BTS["Filet of Redgill"].."/5/Cc",
	[12218] = BTS["Monster Omelet"].."/300/Cc",
	[12216] = BTS["Spiced Chili Crab"].."/300/Cc",
	[6887] = BTS["Spotted Yellowtail"].."/5/Cc",
	[18045] = BTS["Tender Wolf Steak"].."/300/Cc",
	[16766] = BTS["Undermine Clam Chowder"].."/100/Cc",
	[13928] = BTS["Grilled Squid"].."/8/Cc",
	[13929] = BTS["Hot Smoked Bass"].."/10/Cc",
	[13931] = BTS["Nightfin Soup"].."/12/Cc",
	[13932] = BTS["Poached Sunscale Salmon"].."/12/Cc",
	[13935] = BTS["Baked Salmon"].."/10/Cc",
	[13933] = BTS["Lobster Stew"].."/14/Cc",
	[13934] = BTS["Mightfish Steak"].."/18/Cc",
	[18254] = BTS["Runn Tum Tuber Surprise"].."/18/Cc",
	[20452] = BTS["Smoked Desert Dumplings"].."/250/Cc",
	[27661] = BTS["Blackened Trout"].."/150/Cc",
	[27651] = BTS["Buzzard Bites"].."/150/Cc",
	[30155] = BTS["Clam Bar"].."/150/Cc",
	[21023] = BTS["Dirge's Kickin' Chimaerok Chops"].."/250/Cc",
	[27662] = BTS["Feltail Delight"].."/150/Cc",
	[27655] = BTS["Ravager Dog"].."/150/Cc",
	[27663] = BTS["Blackened Sporefish"].."/150/Cc",
	[27656] = BTS["Sporeling Snack"].."/150/Cc",
	[27657] = BTS["Blackened Basilisk"].."/150/Cc",
	[27664] = BTS["Grilled Mudfish"].."/150/Cc",
	[27665] = BTS["Poached Bluefish"].."/150/Cc",
	[27666] = BTS["Golden Fish Sticks"].."/150/Cc",
	[27658] = BTS["Roasted Clefthoof"].."/150/Cc",
	[27660] = BTS["Talbuk Steak"].."/150/Cc",
	[27659] = BTS["Warp Burger"].."/150/Cc",
	[31673] = BTS["Crunchy Serpent"].."/150/Cc",
	[31672] = BTS["Mok'Nathal Shortribs"].."/150/Cc",
	[27667] = BTS["Spicy Crawdad"].."/150/Cc",
	[33052] = BTS["Fisherman's Feast"].."/0/Cc",
	[33053] = BTS["Hot Buttered Trout"].."/0/Cc",
	[33048] = BTS["Stewed Trout"].."/0/Cc",
	[6218] = BTS["Runed Copper Rod"].."/24/Cn",
	[11287] = BTS["Lesser Magic Wand"].."/104/Cn",
	[20744] = BTS["Minor Wizard Oil"].."/100/Cn",
	[11288] = BTS["Greater Magic Wand"].."/466/Cn",
	[6339] = BTS["Runed Silver Rod"].."/24/Cn",
	[20745] = BTS["Minor Mana Oil"].."/1000/Cn",
	[11130] = BTS["Runed Golden Rod"].."/500/Cn",
	[11289] = BTS["Lesser Mystic Wand"].."/2148/Cn",
	[11290] = BTS["Greater Mystic Wand"].."/3157/Cn",
	[20746] = BTS["Lesser Wizard Oil"].."/1000/Cn",
	[11145] = BTS["Runed Truesilver Rod"].."/1250/Cn",
	[12810] = BTS["Enchanted Leather"].."/500/Cn",
	[12655] = "Enchanted Thorium Bar".."/500/Cn",
	[20747] = BTS["Lesser Mana Oil"].."/1000/Cn",
	[11811] = BTS["Smoking Heart of the Mountain"].."/1500/Cn",
	[20750] = BTS["Wizard Oil"].."/1000/Cn",
	[16207] = BTS["Runed Arcanite Rod"].."/1250/Cn",
	[20748] = BTS["Brilliant Mana Oil"].."/800/Cn",
	[20749] = BTS["Brilliant Wizard Oil"].."/600/Cn",
	[22461] = BTS["Runed Fel Iron Rod"].."/1250/Cn",
	[22521] = BTS["Superior Mana Oil"].."/1500/Cn",
	[22460] = BTS["Prismatic Sphere"].."/0/Cn",
	[22449] = BTS["Large Prismatic Shard"].."/0/Eq",
	[22522] = BTS["Superior Wizard Oil"].."/1500/Cn",
	[22459] = BTS["Void Sphere"].."/0/Cn",
	[22462] = BTS["Runed Adamantite Rod"].."/32000/Cn",
	[22463] = BTS["Runed Eternium Rod"].."/40000/Cn",
	[8067] = BTS["Crafted Light Shot"].."/0/Ce",
	[4357] = BTS["Rough Blasting Powder"].."/4/Ce",
	[4358] = BTS["Rough Dynamite"].."/30/Ce",
	[4359] = BTS["Handful of Copper Bolts"].."/12/Ce",
	[4360] = BTS["Rough Copper Bomb"].."/60/Ce",
	[4362] = BTS["Rough Boomstick"].."/187/Ce",
	[6219] = BTS["Arclight Spanner"].."/144/Ce",
	[4361] = BTS["Copper Tube"].."/120/Ce",
	[4405] = BTS["Crude Scope"].."/125/Ce",
	[4363] = BTS["Copper Modulator"].."/50/Ce",
	[4364] = BTS["Coarse Blasting Powder"].."/12/Ce",
	[4365] = BTS["Coarse Dynamite"].."/75/Ce",
	[8068] = BTS["Crafted Heavy Shot"].."/0/Ce",
	[33] = BTS["Mechanical Squirrel"].."/0/Ce",
	[4401] = "Mechanical Squirrel Box".."/100/Ce",
	[4366] = BTS["Target Dummy"].."/75/Ce",
	[4404] = BTS["Silver Contact"].."/25/Ce",
	[4368] = BTS["Flying Tiger Goggles"].."/408/Ce",
	[6714] = BTS["EZ-Thro Dynamite"].."/75/Ce",
	[6712] = BTS["Practice Lock"].."/12/Ce",
	[4367] = BTS["Small Seaforium Charge"].."/150/Ce",
	[4369] = BTS["Deadly Blunderbuss"].."/1179/Ce",
	[4371] = BTS["Bronze Tube"].."/200/Ce",
	[4370] = BTS["Large Copper Bomb"].."/175/Ce",
	[4406] = BTS["Standard Scope"].."/600/Ce",
	[4372] = BTS["Lovingly Crafted Boomstick"].."/1800/Ce",
	[4373] = BTS["Shadow Goggles"].."/722/Ce",
	[4374] = BTS["Small Bronze Bomb"].."/200/Ce",
	[7506] = BTS["Gnomish Universal Remote"].."/500/Ce",
	[8069] = BTS["Crafted Solid Shot"].."/0/Ce",
	[4376] = BTS["Flame Deflector"].."/200/Ce",
	[4377] = BTS["Heavy Blasting Powder"].."/150/Ce",
	[4378] = BTS["Heavy Dynamite"].."/350/Ce",
	[21558] = BTS["Small Blue Rocket"].."/6/Ce",
	[21559] = BTS["Small Green Rocket"].."/6/Ce",
	[21557] = BTS["Small Red Rocket"].."/6/Ce",
	[4375] = BTS["Whirring Bronze Gizmo"].."/115/Ce",
	[4379] = BTS["Silver-plated Shotgun"].."/2357/Ce",
	[4381] = BTS["Minor Recombobulator"].."/600/Ce",
	[5507] = BTS["Ornate Spyglass"].."/600/Ce",
	[4380] = BTS["Big Bronze Bomb"].."/500/Ce",
	[4383] = BTS["Moonsight Rifle"].."/3183/Ce",
	[4382] = BTS["Bronze Framework"].."/600/Ce",
	[4386] = BTS["Ice Deflector"].."/175/Ce",
	[4385] = BTS["Green Tinted Goggles"].."/1410/Ce",
	[6533] = BTS["Aquadynamic Fish Attractor"].."/62/Ce",
	[9312] = BTS["Blue Firework"].."/12/Ce",
	[4388] = BTS["Discombobulator Ray"].."/1000/Ce",
	[4384] = BTS["Explosive Sheep"].."/1000/Ce",
	[10558] = BTS["Gold Power Core"].."/250/Ce",
	[9313] = BTS["Green Firework"].."/12/Ce",
	[9318] = BTS["Red Firework"].."/12/Ce",
	[4387] = BTS["Iron Strut"].."/400/Ce",
	[7148] = BTS["Goblin Jumper Cables"].."/21/Ce",
	[4403] = BTS["Portable Bronze Mortar"].."/2000/Ce",
	[4407] = BTS["Accurate Scope"].."/1200/Ce",
	[4389] = BTS["Gyrochronatom"].."/750/Ce",
	[10499] = BTS["Bright-Eye Goggles"].."/2105/Ce",
	[4391] = BTS["Compact Harvest Reaper Kit"].."/4000/Ce",
	[10498] = BTS["Gyromatic Micro-Adjustor"].."/16/Ce",
	[4390] = BTS["Iron Grenade"].."/500/Ce",
	[21589] = BTS["Large Blue Rocket"].."/12/Ce",
	[21590] = BTS["Large Green Rocket"].."/12/Ce",
	[21592] = BTS["Large Red Rocket"].."/12/Ce",
	[10505] = BTS["Solid Blasting Powder"].."/250/Ce",
	[10507] = BTS["Solid Dynamite"].."/350/Ce",
	[4393] = BTS["Craftsman's Monocle"].."/2632/Ce",
	[4392] = BTS["Advanced Target Dummy"].."/2500/Ce",
	[4852] = BTS["Flash Bomb"].."/300/Ce",
	[4394] = BTS["Big Iron Bomb"].."/750/Ce",
	[4397] = BTS["Gnomish Cloaking Device"].."/5000/Ce",
	[4396] = BTS["Mechanical Dragonling"].."/6000/Ce",
	[17716] = BTS["SnowMaster 9000"].."/7500/Ce",
	[4395] = BTS["Goblin Land Mine"].."/1600/Ce",
	[10559] = BTS["Mithril Tube"].."/750/Ce",
	[18588] = BTS["EZ-Thro Dynamite II"].."/200/Ce",
	[4398] = BTS["Large Seaforium Charge"].."/900/Ce",
	[11590] = BTS["Mechanical Repair Kit"].."/250/Ce",
	[10560] = BTS["Unstable Trigger"].."/1000/Ce",
	[10500] = BTS["Fire Goggles"].."/3478/Ce",
	[10508] = BTS["Mithril Blunderbuss"].."/8958/Ce",
	[10512] = BTS["Hi-Impact Mithril Slugs"].."/2/Ce",
	[10546] = BTS["Deadly Scope"].."/1500/Ce",
	[10721] = BTS["Gnomish Harm Prevention Belt"].."/3317/Ce",
	[10561] = BTS["Mithril Casing"].."/1000/Ce",
	[10514] = BTS["Mithril Frag Bomb"].."/750/Ce",
	[10501] = BTS["Catseye Ultra Goggles"].."/4398/Ce",
	[10510] = BTS["Mithril Heavy-bore Rifle"].."/11369/Ce",
	[10518] = BTS["Parachute Cloak"].."/4696/Ce",
	[10502] = BTS["Spellpower Goggles Xtreme"].."/4088/Ce",
	[21571] = BTS["Blue Rocket Cluster"].."/25/Ce",
	[21569] = BTS["Firework Launcher"].."/0/Ce",
	[21574] = BTS["Green Rocket Cluster"].."/25/Ce",
	[21576] = BTS["Red Rocket Cluster"].."/25/Ce",
	[10506] = BTS["Deepdive Helmet"].."/5227/Ce",
	[10503] = BTS["Rose Colored Goggles"].."/5169/Ce",
	[10562] = BTS["Hi-Explosive Bomb"].."/750/Ce",
	[10548] = BTS["Sniper Scope"].."/2500/Ce",
	[10504] = BTS["Green Lens"].."/7770/Ce",
	[10513] = BTS["Mithril Gyro-Shot"].."/5/Ce",
	[15992] = BTS["Dense Blasting Powder"].."/250/Ce",
	[18641] = BTS["Dense Dynamite"].."/500/Ce",
	[10576] = BTS["Mithril Mechanical Dragonling"].."/6000/Ce",
	[15846] = BTS["Salt Shaker"].."/7500/Ce",
	[19026] = BTS["Snake Burst Firework"].."/250/Ce",
	[21277] = BTS["Tranquil Mechanical Yeti"].."/1250/Ce",
	[18634] = BTS["Gyrofreeze Ice Reflector"].."/12500/Ce",
	[15995] = BTS["Thorium Rifle"].."/19739/Ce",
	[15993] = BTS["Thorium Grenade"].."/1500/Ce",
	[15994] = BTS["Thorium Widget"].."/2500/Ce",
	[18631] = BTS["Truesilver Transformer"].."/3000/Ce",
	[15996] = BTS["Lifelike Mechanical Toad"].."/2500/Ce",
	[15999] = BTS["Spellpower Goggles Xtreme Plus"].."/9002/Ce",
	[16004] = BTS["Dark Iron Rifle"].."/29152/Ce",
	[18637] = BTS["Major Recombobulator"].."/600/Ce",
	[34] = BTS["Firework Cluster Launcher"].."/0/Ce",
	[21570] = "Cluster Launcher".."/0/Ce",
	[7191] = BTS["Fused Wiring"].."/0/D",
	[21714] = BTS["Large Blue Rocket Cluster"].."/50/Ce",
	[21716] = BTS["Large Green Rocket Cluster"].."/50/Ce",
	[21718] = BTS["Large Red Rocket Cluster"].."/50/Ce",
	[16023] = BTS["Masterwork Target Dummy"].."/10000/Ce",
	[18594] = BTS["Powerful Seaforium Charge"].."/3000/Ce",
	[16000] = BTS["Thorium Tube"].."/3750/Ce",
	[15997] = BTS["Thorium Shells"].."/10/Ce",
	[16005] = BTS["Dark Iron Bomb"].."/1250/Ce",
	[16006] = BTS["Delicate Arcanite Converter"].."/10000/Ce",
	[18638] = BTS["Hyper-Radiant Flame Reflector"].."/12500/Ce",
	[16008] = BTS["Master Engineer's Goggles"].."/11739/Ce",
	[16009] = BTS["Voice Amplification Modulator"].."/5930/Ce",
	[18282] = BTS["Core Marksman Rifle"].."/66347/Ce",
	[18168] = BTS["Force Reactive Disk"].."/56416/Ce",
	[16022] = BTS["Arcanite Dragonling"].."/40000/Ce",
	[18283] = BTS["Biznicks 247x128 Accurascope"].."/25000/Ce",
	[19999] = BTS["Bloodvine Goggles"].."/18639/Ce",
	[19998] = BTS["Bloodvine Lens"].."/23211/Ce",
	[16007] = BTS["Flawless Arcanite Rifle"].."/40625/Ce",
	[18639] = BTS["Ultra-Flash Shadow Reflector"].."/12500/Ce",
	[16040] = BTS["Arcane Bomb"].."/4000/Ce",
	[23781] = BTS["Elemental Blasting Powder"].."/500/Ce",
	[23736] = BTS["Fel Iron Bomb"].."/2500/Ce",
	[23782] = BTS["Fel Iron Casing"].."/8000/Ce",
	[18232] = BTS["Field Repair Bot 74A"].."/10000/Ce",
	[23783] = BTS["Handful of Fel Iron Bolts"].."/1500/Ce",
	[23821] = BTS["Zapthrottle Mote Extractor"].."/15000/Ce",
	[23772] = BTS["Fel Iron Shells"].."/20/Ce",
	[23742] = BTS["Fel Iron Musket"].."/5538/Ce",
	[23774] = BTS["Fel Iron Toolbox"].."/30000/Ce",
	[23784] = BTS["Adamantite Frame"].."/10000/Ce",
	[23737] = BTS["Adamantite Grenade"].."/2500/Ce",
	[23767] = BTS["Crashin' Thrashin' Robot"].."/16179/Ce",
	[33092] = BTS["Healing Potion Injector"].."/0/Ce",
	[33093] = BTS["Mana Potion Injector"].."/0/Ce",
	[34504] = BTS["Adamantite Shell Machine"].."/25/Ce",
	[23764] = BTS["Adamantite Scope"].."/2500/Ce",
	[23771] = BTS["Green Smoke Flare"].."/80/Ce",
	[32423] = BTS["Icy Blasting Primers"].."/0/Ce",
	[25886] = BTS["Purple Smoke Flare"].."/0/Ce",
	[23768] = BTS["White Smoke Flare"].."/19489/Ce",
	[23758] = BTS["Cogspinner Goggles"].."/29667/Ce",
	[23761] = BTS["Power Amplification Goggles"].."/20534/Ce",
	[32478] = BTS["Deathblow X11 Goggles"].."/0/Ce",
	[32494] = BTS["Destruction Holo-gogs"].."/0/Ce",
	[32461] = BTS["Furious Gizmatic Goggles"].."/0/Ce",
	[32476] = BTS["Gadgetstorm Goggles"].."/0/Ce",
	[32472] = BTS["Justicebringer 2000 Specs"].."/0/Ce",
	[32475] = BTS["Living Replicator Specs"].."/0/Ce",
	[32480] = BTS["Magnified Moon Specs"].."/0/Ce",
	[32495] = BTS["Powerheal 4000 Lens"].."/0/Ce",
	[32474] = BTS["Surestrike Goggles v2.0"].."/0/Ce",
	[32473] = BTS["Tankatronic Goggles"].."/0/Ce",
	[32479] = BTS["Wonderheal XT40 Shades"].."/0/Ce",
	[23762] = BTS["Ultra-Spectropic Detection Goggles"].."/25324/Ce",
	[23746] = BTS["Adamantite Rifle"].."/55725/Ce",
	[23819] = BTS["Elemental Seaforium Charge"].."/0/Ce",
	[23787] = BTS["Felsteel Stabilizer"].."/12000/Ce",
	[23785] = BTS["Hardened Adamantite Tube"].."/30000/Ce",
	[23786] = BTS["Khorium Power Core"].."/12000/Ce",
	[23824] = BTS["Rocket Boots Xtreme"].."/32734/Ce",
	[23747] = BTS["Felsteel Boomstick"].."/62413/Ce",
	[23763] = BTS["Hyper-Vision Goggles"].."/31774/Ce",
	[23765] = BTS["Khorium Scope"].."/2500/Ce",
	[32756] = BTS["Gyro-balanced Khorium Destroyer"].."/0/Ce",
	[23748] = BTS["Ornate Khorium Rifle"].."/66312/Ce",
	[23766] = BTS["Stabilized Eternium Scope"].."/20000/Ce",
	[23820] = "Critter Enlarger".."/0/Ce",
	[35] = BTS["Frost Grenades"].."/0/Ce",
	[32413] = "Frost Grenade".."/0/Ce",
	[23769] = "Red Smoke Flare".."/0/Ce",
	[10716] = BTS["Gnomish Shrink Ray"].."/750/Ce",
	[36] = BTS["Inlaid Mithril Cylinder Plans"].."/0/Ce",
	[10713] = "Plans: Inlaid Mithril Cylinder".."/500/Ce",
	[11826] = BTS["Lil' Smoky"].."/2500/Ce",
	[10545] = BTS["Gnomish Goggles"].."/3929/Ce",
	[10720] = BTS["Gnomish Net-o-Matic Projector"].."/750/Ce",
	[10724] = BTS["Gnomish Rocket Boots"].."/4696/Ce",
	[10725] = BTS["Gnomish Battle Chicken"].."/1500/Ce",
	[10726] = BTS["Gnomish Mind Control Cap"].."/5520/Ce",
	[10645] = BTS["Gnomish Death Ray"].."/750/Ce",
	[37] = BTS["Ultrasafe Transporter - Gadgetzan"].."/0/Ce",
	[18986] = "Ultrasafe Transporter: Gadgetzan".."/5000/Ce",
	[18660] = BTS["World Enlarger"].."/7500/Ce",
	[38] = BTS["Alarm-O-Bot"].."/0/Ce",
	[18645] = "Gnomish Alarm-O-Bot".."/1500/Ce",
	[23841] = BTS["Gnomish Flame Turret"].."/3000/Ce",
	[23835] = BTS["Gnomish Poultryizer"].."/22500/Ce",
	[39] = BTS["Nigh-Invulnerability Belt"].."/0/Ce",
	[23825] = "Nigh Invulnerability Belt".."/11565/Ce",
	[40] = BTS["Ultrasafe Transporter - Toshley's Station"].."/0/Ce",
	[30544] = "Ultrasafe Transporter: Toshley's Station".."/5000/Ce",
	[23829] = BTS["Gnomish Battle Goggles"].."/38321/Ce",
	[23828] = BTS["Gnomish Power Goggles"].."/30547/Ce",
	[10543] = BTS["Goblin Construction Helmet"].."/3517/Ce",
	[10542] = BTS["Goblin Mining Helmet"].."/5255/Ce",
	[41] = BTS["Goblin Rocket Fuel Recipe"].."/0/Ce",
	[10644] = "Recipe: Goblin Rocket Fuel".."/500/Ce",
	[10646] = BTS["Goblin Sapper Charge"].."/500/Ce",
	[11825] = BTS["Pet Bombling"].."/2500/Ce",
	[42] = BTS["Goblin Mortar"].."/0/Ce",
	[43] = BTS["The Mortar: Reloaded"].."/0/Ce",
	[7189] = BTS["Goblin Rocket Boots"].."/4712/Ce",
	[10587] = BTS["Goblin Bomb Dispenser"].."/1500/Ce",
	[10586] = BTS["The Big One"].."/750/Ce",
	[10727] = BTS["Goblin Dragon Gun"].."/2000/Ce",
	[10588] = BTS["Goblin Rocket Helmet"].."/5834/Ce",
	[18984] = BTS["Dimensional Ripper - Everlook"].."/5000/Ce",
	[18587] = BTS["Goblin Jumper Cables XL"].."/2000/Ce",
	[23826] = BTS["The Bigger One"].."/3000/Ce",
	[23827] = BTS["Super Sapper Charge"].."/4000/Ce",
	[23836] = BTS["Goblin Rocket Launcher"].."/4000/Ce",
	[30542] = BTS["Dimensional Ripper - Area 52"].."/5000/Ce",
	[23838] = BTS["Foreman's Enchanted Helmet"].."/29454/Ce",
	[23839] = BTS["Foreman's Reinforced Helmet"].."/44345/Ce",
	[1251] = BTS["Linen Bandage"].."/10/Cf",
	[2581] = BTS["Heavy Linen Bandage"].."/20/Cf",
	[6452] = BTS["Anti-Venom"].."/28/Cf",
	[3530] = BTS["Wool Bandage"].."/28/Cf",
	[3531] = BTS["Heavy Wool Bandage"].."/57/Cf",
	[6453] = BTS["Strong Anti-Venom"].."/62/Cf",
	[6450] = BTS["Silk Bandage"].."/200/Cf",
	[6451] = BTS["Heavy Silk Bandage"].."/400/Cf",
	[8544] = BTS["Mageweave Bandage"].."/400/Cf",
	[8545] = BTS["Heavy Mageweave Bandage"].."/600/Cf",
	[14529] = BTS["Runecloth Bandage"].."/500/Cf",
	[14530] = BTS["Heavy Runecloth Bandage"].."/1000/Cf",
	[19440] = BTS["Powerful Anti-Venom"].."/500/Cf",
	[21990] = BTS["Netherweave Bandage"].."/1500/Cf",
	[21991] = BTS["Heavy Netherweave Bandage"].."/2250/Cf",
	[20906] = BTS["Braided Copper Ring"].."/250/Cj",
	[21931] = BTS["Woven Copper Ring"].."/250/Cj",
	[20816] = BTS["Delicate Copper Wire"].."/20/Cj",
	[25498] = BTS["Rough Stone Statue"].."/25/Cj",
	[21932] = BTS["Heavy Copper Ring"].."/250/Cj",
	[25438] = BTS["Malachite Pendant"].."/750/Cj",
	[25439] = BTS["Tigerseye Band"].."/250/Cj",
	[20821] = BTS["Inlaid Malachite Ring"].."/1064/Cj",
	[21934] = BTS["Ornate Tigerseye Necklace"].."/1500/Cj",
	[20818] = BTS["Elegant Silver Ring"].."/625/Cj",
	[20907] = BTS["Solid Bronze Ring"].."/300/Cj",
	[21933] = BTS["Thick Bronze Necklace"].."/750/Cj",
	[20817] = BTS["Bronze Setting"].."/100/Cj",
	[25880] = BTS["Coarse Stone Statue"].."/150/Cj",
	[20820] = BTS["Simple Pearl Ring"].."/1064/Cj",
	[30804] = BTS["Bronze Band of Force"].."/1064/Cj",
	[20823] = BTS["Gloom Band"].."/837/Cj",
	[30419] = BTS["Brilliant Necklace"].."/750/Cj",
	[31154] = BTS["Bronze Torc"].."/750/Cj",
	[20827] = BTS["Ring of Silver Might"].."/875/Cj",
	[20826] = BTS["Heavy Silver Ring"].."/2207/Cj",
	[20828] = BTS["Ring of Twilight Shadows"].."/677/Cj",
	[30420] = BTS["Heavy Jade Ring"].."/677/Cj",
	[20830] = BTS["Amulet of the Moon"].."/1535/Cj",
	[20909] = BTS["Barbaric Iron Collar"].."/1010/Cj",
	[25881] = BTS["Heavy Stone Statue"].."/25/Cj",
	[20832] = BTS["Moonsoul Crown"].."/1800/Cj",
	[20950] = BTS["Pendant of the Agate Shield"].."/1535/Cj",
	[20954] = BTS["Heavy Iron Knuckles"].."/5681/Cj",
	[20833] = BTS["Wicked Moonstone Ring"].."/54/Cj",
	[20955] = BTS["Golden Dragon Ring"].."/665/Cj",
	[20958] = BTS["Blazing Citrine Ring"].."/1130/Cj",
	[20831] = BTS["Heavy Golden Necklace of Battle"].."/1535/Cj",
	[20963] = BTS["Mithril Filigree"].."/900/Cj",
	[20966] = BTS["Jade Pendant of Blasting"].."/3482/Cj",
	[20960] = BTS["Engraved Truesilver Ring"].."/1720/Cj",
	[20959] = BTS["The Jade Eye"].."/1720/Cj",
	[25882] = BTS["Solid Stone Statue"].."/1000/Cj",
	[29157] = BTS["Golden Ring of Power"].."/1500/Cj",
	[20961] = BTS["Citrine Ring of Rapid Healing"].."/21633/Cj",
	[20967] = BTS["Citrine Pendant of Golden Healing"].."/3482/Cj",
	[29158] = BTS["Truesilver Commander's Ring"].."/1750/Cj",
	[21756] = BTS["Figurine - Golden Hare"].."/1500/Cj",
	[21748] = BTS["Figurine - Jade Owl"].."/1500/Cj",
	[20964] = BTS["Aquamarine Signet"].."/6646/Cj",
	[21758] = BTS["Figurine - Black Pearl Panther"].."/1500/Cj",
	[21755] = BTS["Aquamarine Pendant of the Warrior"].."/1230/Cj",
	[20969] = BTS["Ruby Crown of Restoration"].."/5989/Cj",
	[21760] = BTS["Figurine - Truesilver Crab"].."/1500/Cj",
	[25883] = BTS["Dense Stone Statue"].."/14087/Cj",
	[21752] = BTS["Thorium Setting"].."/1250/Cj",
	[30421] = BTS["Red Ring of Destruction"].."/2542/Cj",
	[21763] = BTS["Figurine - Truesilver Boar"].."/1500/Cj",
	[21764] = BTS["Ruby Pendant of Fire"].."/6420/Cj",
	[21765] = BTS["Truesilver Healing Ring"].."/2542/Cj",
	[21754] = BTS["The Aquamarine Ward"].."/4307/Cj",
	[21753] = BTS["Gem Studded Band"].."/5000/Cj",
	[21766] = BTS["Opal Necklace of Impact"].."/830/Cj",
	[21769] = BTS["Figurine - Ruby Serpent"].."/1500/Cj",
	[21767] = BTS["Simple Opal Ring"].."/8375/Cj",
	[30422] = BTS["Diamond Focus Ring"].."/8375/Cj",
	[21774] = BTS["Emerald Crown of Destruction"].."/1/Cj",
	[21768] = BTS["Sapphire Signet"].."/12500/Cj",
	[29159] = BTS["Glowing Thorium Band"].."/8375/Cj",
	[21775] = BTS["Onslaught Ring"].."/8375/Cj",
	[21790] = BTS["Sapphire Pendant of Winter Night"].."/7767/Cj",
	[21777] = BTS["Figurine - Emerald Owl"].."/3750/Cj",
	[21778] = BTS["Ring of Bitter Shadows"].."/18662/Cj",
	[21791] = BTS["Living Emerald Pendant"].."/14059/Cj",
	[29160] = BTS["Emerald Lion Ring"].."/9125/Cj",
	[21784] = BTS["Figurine - Black Diamond Crab"].."/15000/Cj",
	[21789] = BTS["Figurine - Dark Iron Scorpid"].."/15000/Cj",
	[23113] = BTS["Brilliant Golden Draenite"].."/10000/Cj",
	[23108] = BTS["Glowing Shadow Draenite"].."/10000/Cj",
	[23098] = BTS["Inscribed Flame Spessarite"].."/10000/Cj",
	[23103] = BTS["Radiant Deep Peridot"].."/10000/Cj",
	[23118] = BTS["Solid Azure Moonstone"].."/10000/Cj",
	[23094] = BTS["Teardrop Blood Garnet"].."/10000/Cj",
	[21792] = BTS["Necklace of the Diamond Tower"].."/25218/Cj",
	[23095] = BTS["Bold Blood Garnet"].."/10000/Cj",
	[28595] = BTS["Bright Blood Garnet"].."/10000/Cj",
	[23114] = BTS["Gleaming Golden Draenite"].."/10000/Cj",
	[23104] = BTS["Jagged Deep Peridot"].."/10000/Cj",
	[23099] = BTS["Luminous Flame Spessarite"].."/10000/Cj",
	[23109] = BTS["Royal Shadow Draenite"].."/10000/Cj",
	[23119] = BTS["Sparkling Azure Moonstone"].."/10000/Cj",
	[21779] = BTS["Band of Natural Fire"].."/21305/Cj",
	[24074] = BTS["Fel Iron Blood Ring"].."/24491/Cj",
	[24075] = BTS["Golden Draenite Ring"].."/24491/Cj",
	[23105] = BTS["Enduring Deep Peridot"].."/10000/Cj",
	[23100] = BTS["Glinting Flame Spessarite"].."/10000/Cj",
	[23096] = BTS["Runed Blood Garnet"].."/10000/Cj",
	[23110] = BTS["Shifting Shadow Draenite"].."/10000/Cj",
	[23120] = BTS["Stormy Azure Moonstone"].."/10000/Cj",
	[23115] = BTS["Thick Golden Draenite"].."/10000/Cj",
	[24076] = BTS["Azure Moonstone Ring"].."/3769/Cj",
	[32772] = BTS["Brilliant Pearl Band"].."/0/Cj",
	[31079] = BTS["Mercurial Adamantite"].."/10000/Cj",
	[23106] = BTS["Dazzling Deep Peridot"].."/20000/Cj",
	[23097] = BTS["Delicate Blood Garnet"].."/10000/Cj",
	[23121] = BTS["Lustrous Azure Moonstone"].."/10000/Cj",
	[23101] = BTS["Potent Flame Spessarite"].."/10000/Cj",
	[32833] = BTS["Purified Jaggal Pearl"].."/0/Cj",
	[23116] = BTS["Rigid Golden Draenite"].."/10000/Cj",
	[28290] = BTS["Smooth Golden Draenite"].."/10000/Cj",
	[23111] = BTS["Sovereign Shadow Draenite"].."/10000/Cj",
	[32774] = BTS["The Black Pearl"].."/0/Cj",
	[24078] = BTS["Heavy Adamantite Ring"].."/16134/Cj",
	[24077] = BTS["Thick Adamantite Necklace"].."/10715/Cj",
	[32508] = BTS["Necklace of the Deep"].."/0/Cj",
	[24087] = BTS["Heavy Felsteel Ring"].."/37037/Cj",
	[31863] = BTS["Balanced Nightseye"].."/0/Cj",
	[24027] = BTS["Bold Living Ruby"].."/30000/Cj",
	[24031] = BTS["Bright Living Ruby"].."/30000/Cj",
	[24047] = BTS["Brilliant Dawnstone"].."/30000/Cj",
	[24065] = BTS["Dazzling Talasite"].."/30000/Cj",
	[24028] = BTS["Delicate Living Ruby"].."/30000/Cj",
	[24062] = BTS["Enduring Talasite"].."/30000/Cj",
	[24036] = BTS["Flashing Living Ruby"].."/30000/Cj",
	[24050] = BTS["Gleaming Dawnstone"].."/30000/Cj",
	[24061] = BTS["Glinting Noble Topaz"].."/30000/Cj",
	[24056] = BTS["Glowing Nightseye"].."/30000/Cj",
	[31861] = BTS["Great Dawnstone"].."/0/Cj",
	[31865] = BTS["Infused Nightseye"].."/0/Cj",
	[24058] = BTS["Inscribed Noble Topaz"].."/30000/Cj",
	[24067] = BTS["Jagged Talasite"].."/30000/Cj",
	[24079] = BTS["Khorium Band of Shadows"].."/38775/Cj",
	[24060] = BTS["Luminous Noble Topaz"].."/30000/Cj",
	[24037] = BTS["Lustrous Star of Elune"].."/30000/Cj",
	[24053] = BTS["Mystic Dawnstone"].."/0/Cj",
	[24059] = BTS["Potent Noble Topaz"].."/4815/Cj",
	[32836] = BTS["Purified Shadow Pearl"].."/0/Cj",
	[24066] = BTS["Radiant Talasite"].."/1767/Cj",
	[24051] = BTS["Rigid Dawnstone"].."/500/Cj",
	[24057] = BTS["Royal Nightseye"].."/3183/Cj",
	[24030] = BTS["Runed Living Ruby"].."/30000/Cj",
	[24055] = BTS["Shifting Nightseye"].."/30000/Cj",
	[24048] = BTS["Smooth Dawnstone"].."/1433/Cj",
	[24033] = BTS["Solid Star of Elune"].."/30000/Cj",
	[24054] = BTS["Sovereign Nightseye"].."/30000/Cj",
	[24035] = BTS["Sparkling Star of Elune"].."/30000/Cj",
	[24039] = BTS["Stormy Star of Elune"].."/30000/Cj",
	[24032] = BTS["Subtle Living Ruby"].."/30000/Cj",
	[24029] = BTS["Teardrop Living Ruby"].."/30000/Cj",
	[24052] = BTS["Thick Dawnstone"].."/30000/Cj",
	[31867] = BTS["Veiled Noble Topaz"].."/0/Cj",
	[31868] = BTS["Wicked Noble Topaz"].."/0/Cj",
	[24088] = BTS["Delicate Eternium Ring"].."/39122/Cj",
	[24080] = BTS["Khorium Band of Frost"].."/39122/Cj",
	[24082] = BTS["Khorium Inferno Band"].."/39122/Cj",
	[24110] = BTS["Living Ruby Pendant"].."/39122/Cj",
	[24106] = BTS["Thick Felsteel Necklace"].."/39122/Cj",
	[24114] = BTS["Braided Eternium Chain"].."/39470/Cj",
	[24116] = BTS["Eye of the Night"].."/39470/Cj",
	[24085] = BTS["Khorium Band of Leaves"].."/39470/Cj",
	[24092] = BTS["Pendant of Frozen Flame"].."/39470/Cj",
	[24097] = BTS["Pendant of Shadow's End"].."/39470/Cj",
	[24093] = BTS["Pendant of Thawing"].."/39470/Cj",
	[24098] = BTS["Pendant of the Null Rune"].."/39470/Cj",
	[24095] = BTS["Pendant of Withering"].."/39470/Cj",
	[30825] = BTS["Ring of Arcane Shielding"].."/37037/Cj",
	[24086] = BTS["Arcane Khorium Band"].."/39818/Cj",
	[24089] = BTS["Blazing Eternium Band"].."/39818/Cj",
	[25897] = BTS["Bracing Earthstorm Diamond"].."/30000/Cj",
	[25899] = BTS["Brutal Earthstorm Diamond"].."/30000/Cj",
	[24121] = BTS["Chain of the Twilight Owl"].."/39818/Cj",
	[32776] = BTS["Crown of the Sea Witch"].."/0/Cj",
	[25890] = BTS["Destructive Skyfire Diamond"].."/30000/Cj",
	[24117] = BTS["Embrace of the Dawn"].."/39818/Cj",
	[25895] = BTS["Enigmatic Skyfire Diamond"].."/4522/Cj",
	[25901] = BTS["Insightful Earthstorm Diamond"].."/30000/Cj",
	[25893] = BTS["Mystical Skyfire Diamond"].."/30000/Cj",
	[25896] = BTS["Powerful Earthstorm Diamond"].."/30000/Cj",
	[32409] = BTS["Relentless Earthstorm Diamond"].."/0/Cj",
	[25894] = BTS["Swift Skyfire Diamond"].."/30000/Cj",
	[25898] = BTS["Tenacious Earthstorm Diamond"].."/8226/Cj",
	[32410] = BTS["Thundering Skyfire Diamond"].."/0/Cj",
	[24123] = BTS["Circlet of Arcane Might"].."/30712/Cj",
	[44] = BTS["Coronet of the Verdant Flame"].."/0/Cj",
	[24122] = "Coronet of Verdant Flame".."/30597/Cj",
	[24125] = BTS["Figurine - Dawnstone Crab"].."/15000/Cj",
	[24124] = BTS["Figurine - Felsteel Boar"].."/12000/Cj",
	[24126] = BTS["Figurine - Living Ruby Serpent"].."/2/Cj",
	[24128] = BTS["Figurine - Nightseye Panther"].."/15000/Cj",
	[24127] = BTS["Figurine - Talasite Owl"].."/15000/Cj",
	[32213] = BTS["Balanced Shadowsong Amethyst"].."/0/Cj",
	[32193] = BTS["Bold Crimson Spinel"].."/0/Cj",
	[32197] = BTS["Bright Crimson Spinel"].."/0/Cj",
	[32204] = BTS["Brilliant Lionseye"].."/0/Cj",
	[32225] = BTS["Dazzling Seaspray Emerald"].."/0/Cj",
	[32194] = BTS["Delicate Crimson Spinel"].."/0/Cj",
	[32223] = BTS["Enduring Seaspray Emerald"].."/0/Cj",
	[32199] = BTS["Flashing Crimson Spinel"].."/0/Cj",
	[32207] = BTS["Gleaming Lionseye"].."/0/Cj",
	[32220] = BTS["Glinting Pyrestone"].."/0/Cj",
	[32215] = BTS["Glowing Shadowsong Amethyst"].."/0/Cj",
	[32210] = BTS["Great Lionseye"].."/0/Cj",
	[32214] = BTS["Infused Shadowsong Amethyst"].."/0/Cj",
	[32217] = BTS["Inscribed Pyrestone"].."/0/Cj",
	[32226] = BTS["Jagged Seaspray Emerald"].."/0/Cj",
	[32219] = BTS["Luminous Pyrestone"].."/0/Cj",
	[32202] = BTS["Lustrous Empyrean Sapphire"].."/0/Cj",
	[32209] = BTS["Mystic Lionseye"].."/0/Cj",
	[32218] = BTS["Potent Pyrestone"].."/0/Cj",
	[32224] = BTS["Radiant Seaspray Emerald"].."/0/Cj",
	[32216] = BTS["Royal Shadowsong Amethyst"].."/0/Cj",
	[32196] = BTS["Runed Crimson Spinel"].."/0/Cj",
	[32212] = BTS["Shifting Shadowsong Amethyst"].."/0/Cj",
	[32205] = BTS["Smooth Lionseye"].."/0/Cj",
	[32200] = BTS["Solid Empyrean Sapphire"].."/0/Cj",
	[32211] = BTS["Sovereign Shadowsong Amethyst"].."/0/Cj",
	[32201] = BTS["Sparkling Empyrean Sapphire"].."/0/Cj",
	[32203] = BTS["Stormy Empyrean Sapphire"].."/0/Cj",
	[32198] = BTS["Subtle Crimson Spinel"].."/0/Cj",
	[32195] = BTS["Teardrop Crimson Spinel"].."/0/Cj",
	[31398] = BTS["The Frozen Eye"].."/60256/Cj",
	[31399] = BTS["The Natural Ward"].."/60256/Cj",
	[32208] = BTS["Thick Lionseye"].."/0/Cj",
	[32221] = BTS["Veiled Pyrestone"].."/0/Cj",
	[32222] = BTS["Wicked Pyrestone"].."/0/Cj",
	[32206] = BTS["Rigid Lionseye"].."/0/Cj",
	[31862] = BTS["Balanced Shadow Draenite"].."/0/Cj",
	[31860] = BTS["Great Golden Draenite"].."/0/Cj",
	[31864] = BTS["Infused Shadow Draenite"].."/0/Cj",
	[31866] = BTS["Veiled Flame Spessarite"].."/0/Cj",
	[31869] = BTS["Wicked Flame Spessarite"].."/0/Cj",
	[2302] = BTS["Handstitched Leather Boots"].."/29/Cl",
	[7277] = BTS["Handstitched Leather Bracers"].."/28/Cl",
	[7276] = BTS["Handstitched Leather Cloak"].."/34/Cl",
	[5957] = BTS["Handstitched Leather Vest"].."/40/Cl",
	[2304] = BTS["Light Armor Kit"].."/15/Cl",
	[2318] = BTS["Light Leather"].."/15/SbCl",
	[2303] = BTS["Handstitched Leather Pants"].."/71/Cl",
	[4237] = BTS["Handstitched Leather Belt"].."/34/Cl",
	[7278] = BTS["Light Leather Quiver"].."/25/Cl",
	[7279] = BTS["Small Leather Ammo Pouch"].."/25/Cl",
	[7280] = BTS["Rugged Leather Pants"].."/162/Cl",
	[4231] = BTS["Cured Light Hide"].."/110/Cl",
	[2300] = BTS["Embossed Leather Vest"].."/192/Cl",
	[5081] = BTS["Kodo Hide Bag"].."/250/Cl",
	[2309] = BTS["Embossed Leather Boots"].."/268/Cl",
	[4239] = BTS["Embossed Leather Gloves"].."/71/Cl",
	[2310] = BTS["Embossed Leather Cloak"].."/112/Cl",
	[2311] = BTS["White Leather Jerkin"].."/150/Cl",
	[7281] = BTS["Light Leather Bracers"].."/84/Cl",
	[4242] = BTS["Embossed Leather Pants"].."/347/Cl",
	[2312] = BTS["Fine Leather Gloves"].."/181/Cl",
	[4246] = BTS["Fine Leather Belt"].."/125/Cl",
	[2308] = BTS["Fine Leather Cloak"].."/267/Cl",
	[4243] = BTS["Fine Leather Tunic"].."/461/Cl",
	[6466] = BTS["Deviate Scale Cloak"].."/413/Cl",
	[6709] = BTS["Moonglow Vest"].."/545/Cl",
	[5780] = BTS["Murloc Scale Belt"].."/156/Cl",
	[2307] = BTS["Fine Leather Boots"].."/243/Cl",
	[7282] = BTS["Light Leather Pants"].."/599/Cl",
	[5781] = BTS["Murloc Scale Breastplate"].."/601/Cl",
	[7283] = BTS["Black Whelp Cloak"].."/519/Cl",
	[20575] = BTS["Black Whelp Tunic"].."/743/Cl",
	[2317] = BTS["Dark Leather Tunic"].."/689/Cl",
	[4244] = BTS["Hillman's Leather Vest"].."/723/Cl",
	[4233] = BTS["Cured Medium Hide"].."/200/Cl",
	[2315] = BTS["Dark Leather Boots"].."/307/Cl",
	[2313] = BTS["Medium Armor Kit"].."/200/Cl",
	[2319] = BTS["Medium Leather"].."/50/Sc",
	[6467] = BTS["Deviate Scale Gloves"].."/420/Cl",
	[5958] = BTS["Fine Leather Pants"].."/829/Cl",
	[2316] = BTS["Dark Leather Cloak"].."/408/Cl",
	[6468] = BTS["Deviate Scale Belt"].."/658/Cl",
	[5961] = BTS["Dark Leather Pants"].."/1089/Cl",
	[4248] = BTS["Dark Leather Gloves"].."/791/Cl",
	[4250] = BTS["Hillman's Belt"].."/705/Cl",
	[7285] = BTS["Nimble Leather Gloves"].."/588/Cl",
	[7284] = BTS["Red Whelp Gloves"].."/586/Cl",
	[2314] = BTS["Toughened Leather Armor"].."/743/Cl",
	[4249] = BTS["Dark Leather Belt"].."/703/Cl",
	[7348] = BTS["Fletcher's Gloves"].."/690/Cl",
	[4251] = BTS["Hillman's Shoulders"].."/1199/Cl",
	[4253] = BTS["Toughened Leather Gloves"].."/962/Cl",
	[7352] = BTS["Earthen Leather Shoulders"].."/1306/Cl",
	[7349] = BTS["Herbalist's Gloves"].."/861/Cl",
	[4252] = BTS["Dark Leather Shoulders"].."/1457/Cl",
	[7358] = BTS["Pilferer's Gloves"].."/885/Cl",
	[4255] = BTS["Green Leather Armor"].."/2366/Cl",
	[7359] = BTS["Heavy Earthen Gloves"].."/978/Cl",
	[4247] = BTS["Hillman's Leather Gloves"].."/1049/Cl",
	[4254] = BTS["Barbaric Gloves"].."/1071/Cl",
	[7372] = BTS["Heavy Leather Ammo Pouch"].."/500/Cl",
	[7371] = BTS["Heavy Quiver"].."/500/Cl",
	[4236] = BTS["Cured Heavy Hide"].."/225/Cl",
	[4265] = BTS["Heavy Armor Kit"].."/650/Cl",
	[4234] = BTS["Heavy Leather"].."/150/Sd",
	[18662] = BTS["Heavy Leather Ball"].."/5/Cl",
	[3719] = BTS["Hillman's Cloak"].."/1027/Cl",
	[18948] = BTS["Barbaric Bracers"].."/1589/Cl",
	[4456] = BTS["Raptor Hide Belt"].."/1553/Cl",
	[4455] = BTS["Raptor Hide Harness"].."/3096/Cl",
	[4257] = BTS["Green Leather Belt"].."/1311/Cl",
	[5962] = BTS["Guardian Pants"].."/2794/Cl",
	[7373] = BTS["Dusky Leather Leggings"].."/3097/Cl",
	[5963] = BTS["Barbaric Leggings"].."/3151/Cl",
	[4258] = BTS["Guardian Belt"].."/1592/Cl",
	[5782] = BTS["Thick Murloc Armor"].."/3211/Cl",
	[4262] = BTS["Gem-studded Leather Belt"].."/2652/Cl",
	[5964] = BTS["Barbaric Shoulders"].."/2609/Cl",
	[7374] = BTS["Dusky Leather Armor"].."/3760/Cl",
	[7375] = BTS["Green Whelp Armor"].."/3773/Cl",
	[4256] = BTS["Guardian Armor"].."/3477/Cl",
	[7377] = BTS["Frost Leather Cloak"].."/2269/Cl",
	[4259] = BTS["Green Leather Bracers"].."/1934/Cl",
	[7378] = BTS["Dusky Bracers"].."/2146/Cl",
	[5965] = BTS["Guardian Cloak"].."/2536/Cl",
	[17721] = BTS["Gloves of the Greatfather"].."/2268/Cl",
	[7386] = BTS["Green Whelp Bracers"].."/2387/Cl",
	[5783] = BTS["Murloc Scale Bracers"].."/2316/Cl",
	[5739] = BTS["Barbaric Harness"].."/2738/Cl",
	[5966] = BTS["Guardian Gloves"].."/1374/Cl",
	[7387] = BTS["Dusky Belt"].."/2587/Cl",
	[4260] = BTS["Guardian Leather Bracers"].."/2559/Cl",
	[18238] = BTS["Shadowskin Gloves"].."/3321/Cl",
	[4264] = BTS["Barbaric Belt"].."/2804/Cl",
	[8174] = BTS["Comfortable Leather Hat"].."/4131/Cl",
	[7390] = BTS["Dusky Boots"].."/4237/Cl",
	[7391] = BTS["Swift Boots"].."/4253/Cl",
	[8172] = BTS["Cured Thick Hide"].."/500/Cl",
	[8173] = BTS["Thick Armor Kit"].."/1000/Cl",
	[4304] = BTS["Thick Leather"].."/300/Se",
	[8176] = BTS["Nightscape Headband"].."/4495/Cl",
	[8175] = BTS["Nightscape Tunic"].."/5971/Cl",
	[8187] = BTS["Turtle Scale Gloves"].."/3477/Cl",
	[8192] = BTS["Nightscape Shoulders"].."/4782/Cl",
	[8198] = BTS["Turtle Scale Bracers"].."/4013/Cl",
	[8189] = BTS["Turtle Scale Breastplate"].."/7567/Cl",
	[8210] = BTS["Wild Leather Shoulders"].."/5537/Cl",
	[8200] = BTS["Big Voodoo Robe"].."/7275/Cl",
	[8214] = BTS["Wild Leather Helmet"].."/6230/Cl",
	[8211] = BTS["Wild Leather Vest"].."/8002/Cl",
	[8201] = BTS["Big Voodoo Mask"].."/5350/Cl",
	[8205] = BTS["Tough Scorpid Bracers"].."/4346/Cl",
	[8203] = BTS["Tough Scorpid Breastplate"].."/8628/Cl",
	[8217] = BTS["Quickdraw Quiver"].."/1000/Cl",
	[8218] = BTS["Thick Leather Ammo Pouch"].."/1000/Cl",
	[8204] = BTS["Tough Scorpid Gloves"].."/4676/Cl",
	[8193] = BTS["Nightscape Pants"].."/8708/Cl",
	[8191] = BTS["Turtle Scale Helm"].."/7780/Cl",
	[8197] = BTS["Nightscape Boots"].."/7158/Cl",
	[8209] = BTS["Tough Scorpid Boots"].."/8375/Cl",
	[8185] = BTS["Turtle Scale Leggings"].."/10952/Cl",
	[8213] = BTS["Wild Leather Boots"].."/8150/Cl",
	[8216] = BTS["Big Voodoo Cloak"].."/6323/Cl",
	[8202] = BTS["Big Voodoo Pants"].."/9022/Cl",
	[8207] = BTS["Tough Scorpid Shoulders"].."/8978/Cl",
	[8215] = BTS["Wild Leather Cloak"].."/9017/Cl",
	[8212] = BTS["Wild Leather Leggings"].."/11585/Cl",
	[8206] = BTS["Tough Scorpid Leggings"].."/12704/Cl",
	[8208] = BTS["Tough Scorpid Helm"].."/10272/Cl",
	[15407] = BTS["Cured Rugged Hide"].."/500/Cl",
	[15564] = BTS["Rugged Armor Kit"].."/1000/Cl",
	[8170] = BTS["Rugged Leather"].."/500/Sf",
	[15077] = BTS["Heavy Scorpid Bracers"].."/7615/Cl",
	[15045] = BTS["Green Dragonscale Breastplate"].."/19938/Cl",
	[15083] = BTS["Wicked Leather Gauntlets"].."/6872/Cl",
	[15074] = BTS["Chimeric Gloves"].."/6867/Cl",
	[15076] = BTS["Heavy Scorpid Vest"].."/16604/Cl",
	[15084] = BTS["Wicked Leather Bracers"].."/7311/Cl",
	[15046] = BTS["Green Dragonscale Leggings"].."/22482/Cl",
	[15067] = BTS["Ironfeather Shoulders"].."/12758/Cl",
	[15061] = BTS["Living Shoulders"].."/13803/Cl",
	[15091] = BTS["Runic Leather Gauntlets"].."/7195/Cl",
	[15054] = BTS["Volcanic Leggings"].."/14559/Cl",
	[15057] = BTS["Stormshroud Pants"].."/18728/Cl",
	[15064] = BTS["Warbear Harness"].."/19717/Cl",
	[15073] = BTS["Chimeric Boots"].."/11530/Cl",
	[15071] = BTS["Frostsaber Boots"].."/11443/Cl",
	[45] = BTS["Heavy Scorpid Gauntlets"].."/0/Cl",
	[15078] = "Heavy Scorpid Gauntlet".."/9649/Cl",
	[15092] = BTS["Runic Leather Bracers"].."/7656/Cl",
	[15072] = BTS["Chimeric Leggings"].."/16233/Cl",
	[15082] = BTS["Heavy Scorpid Belt"].."/10375/Cl",
	[15093] = BTS["Runic Leather Belt"].."/8368/Cl",
	[15086] = BTS["Wicked Leather Headband"].."/13154/Cl",
	[15048] = BTS["Blue Dragonscale Breastplate"].."/24409/Cl",
	[15060] = BTS["Living Leggings"].."/21277/Cl",
	[15056] = BTS["Stormshroud Armor"].."/20966/Cl",
	[15065] = BTS["Warbear Woolies"].."/22233/Cl",
	[15069] = BTS["Frostsaber Leggings"].."/17012/Cl",
	[15079] = BTS["Heavy Scorpid Leggings"].."/21760/Cl",
	[15053] = BTS["Volcanic Breastplate"].."/17275/Cl",
	[15050] = BTS["Black Dragonscale Breastplate"].."/26071/Cl",
	[19052] = BTS["Dawn Treaders"].."/17621/Cl",
	[15063] = BTS["Devilsaur Gauntlets"].."/11701/Cl",
	[15066] = BTS["Ironfeather Breastplate"].."/23650/Cl",
	[19044] = BTS["Might of the Timbermaw"].."/11116/Cl",
	[15075] = BTS["Chimeric Vest"].."/18449/Cl",
	[15094] = BTS["Runic Leather Headband"].."/14155/Cl",
	[15087] = BTS["Wicked Leather Pants"].."/17892/Cl",
	[16982] = BTS["Corehound Boots"].."/24397/Cl",
	[15049] = BTS["Blue Dragonscale Shoulders"].."/20543/Cl",
	[15058] = BTS["Stormshroud Shoulders"].."/14692/Cl",
	[15070] = BTS["Frostsaber Gloves"].."/9504/Cl",
	[15080] = BTS["Heavy Scorpid Helm"].."/18230/Cl",
	[16984] = BTS["Black Dragonscale Boots"].."/32653/Cl",
	[18509] = BTS["Chromatic Cloak"].."/23006/Cl",
	[19157] = BTS["Chromatic Gauntlets"].."/31943/Cl",
	[19162] = BTS["Corehound Belt"].."/27831/Cl",
	[20380] = BTS["Dreamscale Breastplate"].."/52455/Cl",
	[18510] = BTS["Hide of the Wild"].."/20889/Cl",
	[22665] = BTS["Icy Scale Bracers"].."/50516/Cl",
	[22664] = BTS["Icy Scale Breastplate"].."/100642/Cl",
	[22666] = BTS["Icy Scale Gauntlets"].."/50712/Cl",
	[19149] = BTS["Lava Belt"].."/21248/Cl",
	[19163] = BTS["Molten Belt"].."/27931/Cl",
	[16983] = BTS["Molten Helm"].."/25709/Cl",
	[22663] = BTS["Polar Bracers"].."/46175/Cl",
	[22662] = BTS["Polar Gloves"].."/44851/Cl",
	[22661] = BTS["Polar Tunic"].."/89377/Cl",
	[18511] = BTS["Shifting Cloak"].."/20971/Cl",
	[15052] = BTS["Black Dragonscale Leggings"].."/31933/Cl",
	[15051] = BTS["Black Dragonscale Shoulders"].."/21736/Cl",
	[19688] = BTS["Blood Tiger Breastplate"].."/31546/Cl",
	[19689] = BTS["Blood Tiger Shoulders"].."/24082/Cl",
	[22761] = BTS["Bramblewood Belt"].."/19607/Cl",
	[22760] = BTS["Bramblewood Boots"].."/29302/Cl",
	[22759] = BTS["Bramblewood Helm"].."/29190/Cl",
	[18251] = BTS["Core Armor Kit"].."/5000/Cl",
	[15062] = BTS["Devilsaur Leggings"].."/25709/Cl",
	[18504] = BTS["Girdle of Insight"].."/14126/Cl",
	[19058] = BTS["Golden Mantle of the Dawn"].."/21845/Cl",
	[15059] = BTS["Living Breastplate"].."/24776/Cl",
	[18506] = BTS["Mongoose Boots"].."/21340/Cl",
	[15138] = BTS["Onyxia Scale Cloak"].."/15198/Cl",
	[19687] = BTS["Primal Batskin Bracers"].."/15939/Cl",
	[19686] = BTS["Primal Batskin Gloves"].."/15270/Cl",
	[19685] = BTS["Primal Batskin Jerkin"].."/29288/Cl",
	[15047] = BTS["Red Dragonscale Breastplate"].."/29836/Cl",
	[20476] = BTS["Sandstalker Bracers"].."/16401/Cl",
	[20478] = BTS["Sandstalker Breastplate"].."/33917/Cl",
	[20477] = BTS["Sandstalker Gauntlets"].."/16898/Cl",
	[20481] = BTS["Spitfire Bracers"].."/17139/Cl",
	[20479] = BTS["Spitfire Breastplate"].."/34036/Cl",
	[20480] = BTS["Spitfire Gauntlets"].."/17078/Cl",
	[21278] = BTS["Stormshroud Gloves"].."/13212/Cl",
	[18508] = BTS["Swift Flight Bracers"].."/17194/Cl",
	[19049] = BTS["Timbermaw Brawlers"].."/15576/Cl",
	[25654] = BTS["Felscale Gloves"].."/17436/Cl",
	[15068] = BTS["Frostsaber Tunic"].."/21835/Cl",
	[15081] = BTS["Heavy Scorpid Shoulders"].."/20261/Cl",
	[15090] = BTS["Runic Leather Armor"].."/22002/Cl",
	[15095] = BTS["Runic Leather Pants"].."/20885/Cl",
	[15096] = BTS["Runic Leather Shoulders"].."/17332/Cl",
	[25662] = BTS["Scaled Draenic Pants"].."/32525/Cl",
	[25669] = BTS["Thick Draenic Gloves"].."/14274/Cl",
	[15055] = BTS["Volcanic Shoulders"].."/16019/Cl",
	[15085] = BTS["Wicked Leather Armor"].."/22732/Cl",
	[15088] = BTS["Wicked Leather Belt"].."/9901/Cl",
	[25673] = BTS["Wild Draenish Boots"].."/21717/Cl",
	[25679] = BTS["Comfortable Insoles"].."/466/Cl",
	[25650] = BTS["Knothide Armor Kit"].."/7500/Cl",
	[21887] = BTS["Knothide Leather"].."/1250/Cl",
	[25655] = BTS["Felscale Boots"].."/26106/Cl",
	[25661] = BTS["Scaled Draenic Gloves"].."/29461/Cl",
	[25674] = BTS["Wild Draenish Gloves"].."/15897/Cl",
	[25670] = BTS["Thick Draenic Pants"].."/32249/Cl",
	[25656] = BTS["Felscale Pants"].."/36782/Cl",
	[25668] = BTS["Thick Draenic Boots"].."/24047/Cl",
	[25675] = BTS["Wild Draenish Leggings"].."/30530/Cl",
	[29540] = BTS["Reinforced Mining Bag"].."/30000/Cl",
	[25660] = BTS["Scaled Draenic Vest"].."/38316/Cl",
	[23793] = BTS["Heavy Knothide Leather"].."/6250/SCl",
	[25652] = BTS["Magister's Armor Kit"].."/22500/Cl",
	[25651] = BTS["Vindicator's Armor Kit"].."/22500/Cl",
	[25671] = BTS["Thick Draenic Vest"].."/35070/Cl",
	[25676] = BTS["Wild Draenish Vest"].."/32311/Cl",
	[29534] = BTS["Clefthide Leg Armor"].."/20000/Cl",
	[29533] = BTS["Cobrahide Leg Armor"].."/20000/Cl",
	[25657] = BTS["Felscale Breastplate"].."/39930/Cl",
	[25659] = BTS["Scaled Draenic Boots"].."/62470/Cl",
	[25685] = BTS["Fel Leather Gloves"].."/20771/Cl",
	[25694] = BTS["Netherfury Belt"].."/25734/Cl",
	[25692] = BTS["Netherfury Leggings"].."/51110/Cl",
	[29488] = BTS["Arcane Armor Kit"].."/15000/Cl",
	[29528] = BTS["Drums of War"].."/5000/Cl",
	[29485] = BTS["Flame Armor Kit"].."/15000/Cl",
	[29486] = BTS["Frost Armor Kit"].."/15000/Cl",
	[29487] = BTS["Nature Armor Kit"].."/15000/Cl",
	[29483] = BTS["Shadow Armor Kit"].."/15000/Cl",
	[29530] = BTS["Drums of Speed"].."/5000/Cl",
	[29500] = BTS["Blastguard Belt"].."/21281/Cl",
	[29499] = BTS["Blastguard Boots"].."/31803/Cl",
	[29498] = BTS["Blastguard Pants"].."/42245/Cl",
	[29497] = BTS["Enchanted Clefthoof Boots"].."/31564/Cl",
	[29496] = BTS["Enchanted Clefthoof Gloves"].."/20965/Cl",
	[29495] = BTS["Enchanted Clefthoof Leggings"].."/41772/Cl",
	[29491] = BTS["Enchanted Felscale Boots"].."/40049/Cl",
	[29490] = BTS["Enchanted Felscale Gloves"].."/26486/Cl",
	[29489] = BTS["Enchanted Felscale Leggings"].."/52781/Cl",
	[25686] = BTS["Fel Leather Boots"].."/32862/Cl",
	[25687] = BTS["Fel Leather Leggings"].."/43976/Cl",
	[25695] = BTS["Felstalker Belt"].."/24563/Cl",
	[29494] = BTS["Flamescale Belt"].."/24968/Cl",
	[29493] = BTS["Flamescale Boots"].."/40332/Cl",
	[29492] = BTS["Flamescale Leggings"].."/53353/Cl",
	[25693] = BTS["Netherfury Boots"].."/36667/Cl",
	[25653] = BTS["Riding Crop"].."/17500/Cl",
	[25681] = BTS["Stylin' Adventure Hat"].."/66290/Cl",
	[25683] = BTS["Stylin' Crimson Hat"].."/37986/Cl",
	[25682] = BTS["Stylin' Jungle Hat"].."/31539/Cl",
	[25680] = BTS["Stylin' Purple Hat"].."/31300/Cl",
	[29531] = BTS["Drums of Restoration"].."/5000/Cl",
	[25691] = BTS["Heavy Clefthoof Boots"].."/33726/Cl",
	[25690] = BTS["Heavy Clefthoof Leggings"].."/44808/Cl",
	[46] = BTS["Felstalker Bracer"].."/0/Cl",
	[25697] = "Felstalker Bracers".."/25155/Cl",
	[25696] = BTS["Felstalker Breastplate"].."/50116/Cl",
	[25689] = BTS["Heavy Clefthoof Vest"].."/45010/Cl",
	[29503] = BTS["Cobrascale Gloves"].."/24742/Cl",
	[29502] = BTS["Cobrascale Hood"].."/533/Cl",
	[29512] = BTS["Earthen Netherscale Boots"].."/42922/Cl",
	[29506] = BTS["Gloves of the Living Touch"].."/25014/Cl",
	[29505] = BTS["Hood of Primal Life"].."/37384/Cl",
	[29508] = BTS["Living Dragonscale Helm"].."/45350/Cl",
	[29511] = BTS["Netherdrake Gloves"].."/28381/Cl",
	[29510] = BTS["Netherdrake Helm"].."/42408/Cl",
	[29514] = BTS["Thick Netherscale Breastplate"].."/57415/Cl",
	[29504] = BTS["Windscale Hood"].."/37247/Cl",
	[29507] = BTS["Windslayer Wraps"].."/34308/Cl",
	[29509] = BTS["Windstrike Gloves"].."/30343/Cl",
	[29529] = BTS["Drums of Battle"].."/5000/Cl",
	[29536] = BTS["Nethercleft Leg Armor"].."/40000/Cl",
	[29535] = BTS["Nethercobra Leg Armor"].."/40000/Cl",
	[29532] = BTS["Drums of Panic"].."/5000/Cl",
	[8347] = BTS["Dragonscale Gauntlets"].."/5979/Cl",
	[8367] = BTS["Dragonscale Breastplate"].."/18455/Cl",
	[29971] = BTS["Dragonstrike Leggings"].."/9022/Cl",
	[20296] = BTS["Green Dragonscale Gauntlets"].."/12590/Cl",
	[20295] = BTS["Blue Dragonscale Leggings"].."/31083/Cl",
	[29975] = BTS["Golden Dragonstrike Breastplate"].."/79950/Cl",
	[29516] = BTS["Ebon Netherscale Belt"].."/31638/Cl",
	[29517] = BTS["Ebon Netherscale Bracers"].."/31758/Cl",
	[29515] = BTS["Ebon Netherscale Breastplate"].."/63043/Cl",
	[29520] = BTS["Netherstrike Belt"].."/32114/Cl",
	[29521] = BTS["Netherstrike Bracers"].."/19896/Cl",
	[29519] = BTS["Netherstrike Breastplate"].."/34629/Cl",
	[8346] = BTS["Gauntlets of the Sea"].."/5363/Cl",
	[8348] = BTS["Helm of Fire"].."/10819/Cl",
	[29964] = BTS["Blackstorm Leggings"].."/15290/Cl",
	[29973] = BTS["Primalstorm Breastplate"].."/38564/Cl",
	[29526] = BTS["Primalstrike Belt"].."/28074/Cl",
	[29527] = BTS["Primalstrike Bracers"].."/28172/Cl",
	[29525] = BTS["Primalstrike Vest"].."/54518/Cl",
	[8345] = BTS["Wolfshead Helm"].."/7421/Cl",
	[8349] = BTS["Feathered Breastplate"].."/14478/Cl",
	[29970] = BTS["Wildfeather Leggings"].."/1361/Cl",
	[29974] = BTS["Living Crystal Breastplate"].."/474/Cl",
	[29524] = BTS["Windhawk Belt"].."/27169/Cl",
	[29523] = BTS["Windhawk Bracers"].."/19065/Cl",
	[29522] = BTS["Windhawk Hauberk"].."/53924/Cl",
	[47] = BTS["Smelt Copper"].."/0/Cs",
	[2840] = "Copper Bar".."/10/Cs",
	[48] = BTS["Smelt Bronze"].."/0/Cs",
	[2841] = "Bronze Bar".."/50/Cs",
	[49] = BTS["Smelt Tin"].."/0/Cs",
	[3576] = "Tin Bar".."/35/Cs",
	[50] = BTS["Smelt Silver"].."/0/Cs",
	[2842] = "Silver Bar".."/100/Cs",
	[51] = BTS["Smelt Iron"].."/0/Cs",
	[3575] = "Iron Bar".."/200/Cs",
	[52] = BTS["Smelt Gold"].."/0/Cs",
	[53] = BTS["Smelt Steel"].."/0/Cs",
	[3859] = "Steel Bar".."/60/Cs",
	[54] = BTS["Smelt Mithril"].."/0/Cs",
	[3860] = "Mithril Bar".."/400/Cs",
	[55] = BTS["Smelt Truesilver"].."/0/Cs",
	[56] = BTS["Smelt Dark Iron"].."/0/Cs",
	[11371] = "Dark Iron Bar".."/600/Cs",
	[57] = BTS["Smelt Thorium"].."/0/Cs",
	[12359] = "Thorium Bar".."/600/Cs",
	[58] = BTS["Smelt Elementium"].."/0/Cs",
	[17771] = "Elementium Bar".."/0/Cs",
	[59] = BTS["Earth Shatter"].."/0/Cs",
	[22573] = "Mote of Earth".."/400/MlMmMnD",
	[60] = BTS["Fire Sunder"].."/0/Cs",
	[22574] = "Mote of Fire".."/400/DMl",
	[61] = BTS["Smelt Fel Iron"].."/0/Cs",
	[23445] = "Fel Iron Bar".."/2000/Cs",
	[62] = BTS["Smelt Adamantite"].."/0/Cs",
	[23446] = "Adamantite Bar".."/3000/Cs",
	[63] = BTS["Smelt Eternium"].."/0/Cs",
	[23447] = "Eternium Bar".."/2500/Cs",
	[64] = BTS["Smelt Felsteel"].."/0/Cs",
	[23448] = "Felsteel Bar".."/22500/Cs",
	[65] = BTS["Smelt Khorium"].."/0/Cs",
	[23449] = "Khorium Bar".."/12500/Cs",
	[66] = BTS["Smelt Hardened Adamantite"].."/0/Cs",
	[23573] = "Barra endurecida de Adamantita/30000/Cs",
	[2996] = BTS["Bolt of Linen Cloth"].."/40/Ct",
	[4344] = BTS["Brown Linen Shirt"].."/11/Ct",
	[2570] = BTS["Linen Cloak"].."/11/Ct",
	[10045] = BTS["Simple Linen Pants"].."/23/Ct",
	[2576] = BTS["White Linen Shirt"].."/75/Ct",
	[2568] = BTS["Brown Linen Vest"].."/31/Ct",
	[7026] = BTS["Linen Belt"].."/22/Ct",
	[10046] = BTS["Simple Linen Boots"].."/32/Ct",
	[6238] = BTS["Brown Linen Robe"].."/98/Ct",
	[6241] = BTS["White Linen Robe"].."/99/Ct",
	[4343] = BTS["Brown Linen Pants"].."/60/Ct",
	[4307] = BTS["Heavy Linen Gloves"].."/29/Ct",
	[2572] = BTS["Red Linen Robe"].."/99/Ct",
	[2577] = BTS["Blue Linen Shirt"].."/75/Ct",
	[2575] = BTS["Red Linen Shirt"].."/25/Ct",
	[6786] = BTS["Simple Dress"].."/59/Ct",
	[4238] = BTS["Linen Bag"].."/200/Ct",
	[6240] = BTS["Blue Linen Vest"].."/161/Ct",
	[6239] = BTS["Red Linen Vest"].."/160/Ct",
	[4308] = BTS["Green Linen Bracers"].."/45/Ct",
	[2580] = BTS["Reinforced Linen Cape"].."/67/Ct",
	[2569] = BTS["Linen Boots"].."/87/Ct",
	[2578] = BTS["Barbaric Linen Vest"].."/224/Ct",
	[6242] = BTS["Blue Linen Robe"].."/243/Ct",
	[4309] = BTS["Handstitched Linen Britches"].."/226/Ct",
	[2579] = BTS["Green Linen Shirt"].."/37/Ct",
	[5762] = BTS["Red Linen Bag"].."/250/Ct",
	[2997] = BTS["Bolt of Woolen Cloth"].."/100/Ct",
	[10047] = BTS["Simple Kilt"].."/164/Ct",
	[2584] = BTS["Woolen Cape"].."/142/Ct",
	[4312] = BTS["Soft-soled Linen Boots"].."/237/Ct",
	[4240] = BTS["Woolen Bag"].."/300/Ct",
	[4310] = BTS["Heavy Woolen Gloves"].."/180/Ct",
	[2582] = BTS["Green Woolen Vest"].."/216/Ct",
	[5542] = BTS["Pearl-clasped Cloak"].."/370/Ct",
	[4313] = BTS["Red Woolen Boots"].."/416/Ct",
	[2583] = BTS["Woolen Boots"].."/359/Ct",
	[4241] = BTS["Green Woolen Bag"].."/450/Ct",
	[6263] = BTS["Blue Overalls"].."/589/Ct",
	[4311] = BTS["Heavy Woolen Cloak"].."/475/Ct",
	[2587] = BTS["Gray Woolen Shirt"].."/200/Ct",
	[2585] = BTS["Gray Woolen Robe"].."/638/Ct",
	[4316] = BTS["Heavy Woolen Pants"].."/743/Ct",
	[4314] = BTS["Double-stitched Woolen Shoulders"].."/331/Ct",
	[4330] = BTS["Stylish Red Shirt"].."/250/Ct",
	[6787] = BTS["White Woolen Dress"].."/466/Ct",
	[6264] = BTS["Greater Adept's Robe"].."/884/Ct",
	[4332] = BTS["Bright Yellow Shirt"].."/500/Ct",
	[5763] = BTS["Red Woolen Bag"].."/700/Ct",
	[10048] = BTS["Colorful Kilt"].."/935/Ct",
	[4315] = BTS["Reinforced Woolen Shoulders"].."/425/Ct",
	[6384] = BTS["Stylish Blue Shirt"].."/250/Ct",
	[6385] = BTS["Stylish Green Shirt"].."/250/Ct",
	[4320] = BTS["Spidersilk Boots"].."/979/Ct",
	[4331] = BTS["Phoenix Gloves"].."/526/Ct",
	[4317] = BTS["Phoenix Pants"].."/1076/Ct",
	[4305] = BTS["Bolt of Silk Cloth"].."/600/Ct",
	[4318] = BTS["Gloves of Meditation"].."/610/Ct",
	[4319] = BTS["Azure Silk Gloves"].."/815/Ct",
	[5766] = BTS["Lesser Wizard's Robe"].."/1338/Ct",
	[4333] = BTS["Dark Silk Shirt"].."/1200/Ct",
	[7046] = BTS["Azure Silk Pants"].."/1494/Ct",
	[4321] = BTS["Spider Silk Slippers"].."/1120/Ct",
	[7047] = BTS["Hands of Darkness"].."/824/Ct",
	[7048] = BTS["Azure Silk Hood"].."/745/Ct",
	[4324] = BTS["Azure Silk Vest"].."/1874/Ct",
	[5770] = BTS["Robes of Arcana"].."/1807/Ct",
	[7049] = BTS["Truefaith Gloves"].."/914/Ct",
	[4245] = BTS["Small Silk Pack"].."/2000/Ct",
	[4322] = BTS["Enchanter's Cowl"].."/1810/Ct",
	[7050] = BTS["Silk Headband"].."/999/Ct",
	[6795] = BTS["White Swashbuckler's Shirt"].."/500/Ct",
	[7065] = BTS["Green Silk Armor"].."/2398/Ct",
	[7051] = BTS["Earthen Vest"].."/2696/Ct",
	[4323] = BTS["Shadow Hood"].."/1999/Ct",
	[4334] = BTS["Formal White Shirt"].."/550/Ct",
	[7052] = BTS["Azure Silk Belt"].."/1488/Ct",
	[7053] = BTS["Azure Silk Cloak"].."/2240/Ct",
	[4325] = BTS["Boots of the Enchanter"].."/2272/Ct",
	[7055] = BTS["Crimson Silk Belt"].."/1503/Ct",
	[4339] = BTS["Bolt of Mageweave"].."/1250/Ct",
	[5764] = BTS["Green Silk Pack"].."/3000/Ct",
	[6796] = BTS["Red Swashbuckler's Shirt"].."/750/Ct",
	[7056] = BTS["Crimson Silk Cloak"].."/2314/Ct",
	[7057] = BTS["Green Silken Shoulders"].."/2323/Ct",
	[4328] = BTS["Spider Belt"].."/1524/Ct",
	[4336] = BTS["Black Swashbuckler's Shirt"].."/1500/Ct",
	[4326] = BTS["Long Silken Cloak"].."/2496/Ct",
	[5765] = BTS["Black Silk Pack"].."/4000/Ct",
	[7058] = BTS["Crimson Silk Vest"].."/2052/Ct",
	[4335] = BTS["Rich Purple Silk Shirt"].."/1500/Ct",
	[7054] = BTS["Robe of Power"].."/4700/Ct",
	[7060] = BTS["Azure Shoulders"].."/2791/Ct",
	[7059] = BTS["Crimson Silk Shoulders"].."/2781/Ct",
	[17723] = BTS["Green Holiday Shirt"].."/750/Ct",
	[7061] = BTS["Earthen Silk Belt"].."/2017/Ct",
	[7062] = BTS["Crimson Silk Pantaloons"].."/2430/Ct",
	[10052] = BTS["Orange Martial Shirt"].."/1500/Ct",
	[4327] = BTS["Icy Cloak"].."/3788/Ct",
	[4329] = BTS["Star Belt"].."/2120/Ct",
	[9999] = BTS["Black Mageweave Leggings"].."/4832/Ct",
	[9998] = BTS["Black Mageweave Vest"].."/4815/Ct",
	[7063] = BTS["Crimson Silk Robe"].."/4741/Ct",
	[10054] = BTS["Lavender Mageweave Shirt"].."/3000/Ct",
	[10001] = BTS["Black Mageweave Robe"].."/5257/Ct",
	[7064] = BTS["Crimson Silk Gloves"].."/2569/Ct",
	[10002] = BTS["Shadoweave Pants"].."/5276/Ct",
	[10055] = BTS["Pink Mageweave Shirt"].."/3000/Ct",
	[10003] = BTS["Black Mageweave Gloves"].."/2859/Ct",
	[10009] = BTS["Red Mageweave Pants"].."/5284/Ct",
	[10007] = BTS["Red Mageweave Vest"].."/5799/Ct",
	[10004] = BTS["Shadoweave Robe"].."/5738/Ct",
	[10008] = BTS["White Bandit Mask"].."/4365/Ct",
	[10056] = BTS["Orange Mageweave Shirt"].."/1500/Ct",
	[10034] = BTS["Tuxedo Shirt"].."/2000/Ct",
	[10035] = BTS["Tuxedo Pants"].."/1735/Ct",
	[10019] = BTS["Dreamweave Gloves"].."/3944/Ct",
	[10021] = BTS["Dreamweave Vest"].."/7946/Ct",
	[10030] = BTS["Admiral's Hat"].."/6007/Ct",
	[10042] = BTS["Cindercloth Robe"].."/6644/Ct",
	[22246] = BTS["Enchanted Mageweave Pouch"].."/2500/Ct",
	[10018] = BTS["Red Mageweave Gloves"].."/3275/Ct",
	[10023] = BTS["Shadoweave Gloves"].."/3334/Ct",
	[10050] = BTS["Mageweave Bag"].."/2500/Ct",
	[10040] = BTS["White Wedding Dress"].."/1767/Ct",
	[10026] = BTS["Black Mageweave Boots"].."/5459/Ct",
	[10024] = BTS["Black Mageweave Headband"].."/5421/Ct",
	[10027] = BTS["Black Mageweave Shoulders"].."/5479/Ct",
	[10025] = BTS["Shadoweave Mask"].."/6790/Ct",
	[10029] = BTS["Red Mageweave Shoulders"].."/5391/Ct",
	[10028] = BTS["Shadoweave Shoulders"].."/5938/Ct",
	[10051] = BTS["Red Mageweave Bag"].."/2500/Ct",
	[10053] = BTS["Simple Black Dress"].."/4499/Ct",
	[10036] = BTS["Tuxedo Jacket"].."/1741/Ct",
	[13868] = BTS["Frostweave Robe"].."/9665/Ct",
	[10033] = BTS["Red Mageweave Headband"].."/6075/Ct",
	[10031] = BTS["Shadoweave Boots"].."/6030/Ct",
	[10044] = BTS["Cindercloth Boots"].."/6765/Ct",
	[10041] = BTS["Dreamweave Circlet"].."/7161/Ct",
	[14048] = BTS["Bolt of Runecloth"].."/2000/Ct",
	[21154] = BTS["Festival Dress"].."/1/Ct",
	[67] = BTS["Festive Red Pant Suit"].."/0/Ct",
	[21542] = "Festival Suit".."/1/Ct",
	[14342] = BTS["Mooncloth"].."/4000/Ct",
	[13869] = BTS["Frostweave Tunic"].."/9702/Ct",
	[13856] = BTS["Runecloth Belt"].."/5112/Ct",
	[14042] = BTS["Cindercloth Vest"].."/10561/Ct",
	[13858] = BTS["Runecloth Robe"].."/10917/Ct",
	[13857] = BTS["Runecloth Tunic"].."/10878/Ct",
	[21340] = BTS["Soul Pouch"].."/5000/Ct",
	[14046] = BTS["Runecloth Bag"].."/5000/Ct",
	[13870] = BTS["Frostweave Gloves"].."/5471/Ct",
	[14143] = BTS["Ghostweave Belt"].."/5763/Ct",
	[13860] = BTS["Runecloth Cloak"].."/8741/Ct",
	[14101] = BTS["Brightcloth Gloves"].."/6066/Ct",
	[14100] = BTS["Brightcloth Robe"].."/12089/Ct",
	[14043] = BTS["Cindercloth Gloves"].."/5955/Ct",
	[14142] = BTS["Ghostweave Gloves"].."/6087/Ct",
	[14134] = BTS["Cloak of Fire"].."/11280/Ct",
	[14103] = BTS["Brightcloth Cloak"].."/9716/Ct",
	[22251] = BTS["Cenarion Herb Bag"].."/10000/Ct",
	[14044] = BTS["Cindercloth Cloak"].."/9503/Ct",
	[22248] = BTS["Enchanted Runecloth Bag"].."/10000/Ct",
	[14107] = BTS["Felcloth Pants"].."/13140/Ct",
	[14141] = BTS["Ghostweave Vest"].."/12859/Ct",
	[13863] = BTS["Runecloth Gloves"].."/6617/Ct",
	[14132] = BTS["Wizardweave Leggings"].."/12441/Ct",
	[21341] = BTS["Felcloth Bag"].."/20000/Ct",
	[14045] = BTS["Cindercloth Pants"].."/13480/Ct",
	[13871] = BTS["Frostweave Pants"].."/13436/Ct",
	[13864] = BTS["Runecloth Boots"].."/9553/Ct",
	[14140] = BTS["Mooncloth Circlet"].."/16693/Ct",
	[18486] = BTS["Mooncloth Robe"].."/21683/Ct",
	[14139] = BTS["Mooncloth Shoulders"].."/15840/Ct",
	[14138] = BTS["Mooncloth Vest"].."/20042/Ct",
	[14136] = BTS["Robe of Winter Night"].."/17025/Ct",
	[14108] = BTS["Felcloth Boots"].."/11112/Ct",
	[13865] = BTS["Runecloth Pants"].."/13555/Ct",
	[19056] = BTS["Argent Boots"].."/12941/Ct",
	[15802] = BTS["Mooncloth Boots"].."/11648/Ct",
	[14137] = BTS["Mooncloth Leggings"].."/18113/Ct",
	[19047] = BTS["Wisdom of the Timbermaw"].."/9232/Ct",
	[14104] = BTS["Brightcloth Pants"].."/15484/Ct",
	[14111] = BTS["Felcloth Hood"].."/10775/Ct",
	[14144] = BTS["Ghostweave Pants"].."/14374/Ct",
	[13866] = BTS["Runecloth Headband"].."/11358/Ct",
	[18405] = BTS["Belt of the Archmage"].."/14744/Ct",
	[21342] = BTS["Core Felcloth Bag"].."/80000/Ct",
	[16979] = BTS["Flarecore Gloves"].."/14901/Ct",
	[19165] = BTS["Flarecore Leggings"].."/45006/Ct",
	[16980] = BTS["Flarecore Mantle"].."/21365/Ct",
	[19156] = BTS["Flarecore Robe"].."/34911/Ct",
	[18263] = BTS["Flarecore Wraps"].."/16911/Ct",
	[22658] = BTS["Glacial Cloak"].."/53045/Ct",
	[22654] = BTS["Glacial Gloves"].."/34846/Ct",
	[22652] = BTS["Glacial Vest"].."/69171/Ct",
	[22655] = BTS["Glacial Wrists"].."/34973/Ct",
	[14146] = BTS["Gloves of Spell Mastery"].."/14084/Ct",
	[14152] = BTS["Robe of the Archmage"].."/28815/Ct",
	[14153] = BTS["Robe of the Void"].."/28920/Ct",
	[14154] = BTS["Truefaith Vestments"].."/29028/Ct",
	[19059] = BTS["Argent Shoulders"].."/17541/Ct",
	[19684] = BTS["Bloodvine Boots"].."/18915/Ct",
	[19683] = BTS["Bloodvine Leggings"].."/25129/Ct",
	[19682] = BTS["Bloodvine Vest"].."/24872/Ct",
	[14156] = BTS["Bottomless Bag"].."/40000/Ct",
	[18413] = BTS["Cloak of Warding"].."/17070/Ct",
	[18407] = BTS["Felcloth Gloves"].."/11139/Ct",
	[22660] = BTS["Gaea's Embrace"].."/24601/Ct",
	[18408] = BTS["Inferno Gloves"].."/11178/Ct",
	[19050] = BTS["Mantle of the Timbermaw"].."/18758/Ct",
	[18409] = BTS["Mooncloth Gloves"].."/11219/Ct",
	[20539] = BTS["Runed Stygian Belt"].."/11908/Ct",
	[20537] = BTS["Runed Stygian Boots"].."/17736/Ct",
	[20538] = BTS["Runed Stygian Leggings"].."/22703/Ct",
	[22757] = BTS["Sylvan Crown"].."/24961/Ct",
	[22758] = BTS["Sylvan Shoulders"].."/25051/Ct",
	[22756] = BTS["Sylvan Vest"].."/33164/Ct",
	[22249] = BTS["Big Bag of Enchantment"].."/30000/Ct",
	[14106] = BTS["Felcloth Robe"].."/18053/Ct",
	[14112] = BTS["Felcloth Shoulders"].."/13509/Ct",
	[68] = "Gordok Ogre Suit (LW)".."/0/Cl",
	[69] = "Gordok Ogre Suit (TA)".."/0/Ct",
	[14155] = BTS["Mooncloth Bag"].."/20000/Ct",
	[13867] = BTS["Runecloth Shoulders"].."/12570/Ct",
	[22252] = BTS["Satchel of Cenarius"].."/30000/Ct",
	[14128] = BTS["Wizardweave Robe"].."/16093/Ct",
	[14130] = BTS["Wizardweave Turban"].."/12768/Ct",
	[21840] = BTS["Bolt of Netherweave"].."/4000/Ct",
	[24268] = BTS["Netherweave Net"].."/100/Ct",
	[21850] = BTS["Netherweave Belt"].."/12306/Ct",
	[21849] = BTS["Netherweave Bracers"].."/12261/Ct",
	[21841] = BTS["Netherweave Bag"].."/10000/Ct",
	[21851] = BTS["Netherweave Gloves"].."/13059/Ct",
	[21842] = BTS["Bolt of Imbued Netherweave"].."/8000/Ct",
	[21852] = BTS["Netherweave Pants"].."/26926/Ct",
	[24269] = "Heavy Netherweave Net".."/100/Ct",
	[24273] = BTS["Mystic Spellthread"].."/20000/Ct",
	[24275] = BTS["Silver Spellthread"].."/20000/Ct",
	[21853] = BTS["Netherweave Boots"].."/21336/Ct",
	[21859] = BTS["Imbued Netherweave Pants"].."/31883/Ct",
	[24270] = BTS["Bag of Jewels"].."/30000/Ct",
	[21843] = BTS["Imbued Netherweave Bag"].."/10000/Ct",
	[21854] = BTS["Netherweave Robe"].."/29267/Ct",
	[21855] = BTS["Netherweave Tunic"].."/30091/Ct",
	[21844] = BTS["Bolt of Soulcloth"].."/8000/Ct",
	[21866] = BTS["Arcanoweave Bracers"].."/17197/Ct",
	[24251] = BTS["Blackstrike Bracers"].."/16690/Ct",
	[24250] = BTS["Bracers of Havok"].."/16626/Ct",
	[30831] = BTS["Cloak of Arcane Evasion"].."/25066/Ct",
	[24253] = BTS["Cloak of Eternity"].."/25223/Ct",
	[24252] = BTS["Cloak of the Black Void"].."/25128/Ct",
	[30837] = BTS["Flameheart Bracers"].."/17088/Ct",
	[21860] = BTS["Imbued Netherweave Boots"].."/24616/Ct",
	[21845] = BTS["Primal Mooncloth"].."/4000/Ct",
	[24272] = BTS["Shadowcloth"].."/4000/Ct",
	[24271] = BTS["Spellcloth"].."/4000/Ct",
	[24249] = BTS["Unyielding Bracers"].."/16563/Ct",
	[24254] = BTS["White Remedy Cape"].."/26001/Ct",
	[21863] = BTS["Soulcloth Gloves"].."/20474/Ct",
	[21867] = BTS["Arcanoweave Boots"].."/26309/Ct",
	[30838] = BTS["Flameheart Gloves"].."/17430/Ct",
	[21861] = BTS["Imbued Netherweave Robe"].."/34308/Ct",
	[21862] = BTS["Imbued Netherweave Tunic"].."/34437/Ct",
	[24257] = BTS["Black Belt of Knowledge"].."/21095/Ct",
	[24256] = BTS["Girdle of Ruination"].."/21018/Ct",
	[24260] = BTS["Manaweave Cloak"].."/31984/Ct",
	[24258] = BTS["Resolute Cape"].."/31757/Ct",
	[21864] = BTS["Soulcloth Shoulders"].."/30824/Ct",
	[24255] = BTS["Unyielding Girdle"].."/20942/Ct",
	[24259] = BTS["Vengeance Wrap"].."/31869/Ct",
	[21868] = BTS["Arcanoweave Robe"].."/35486/Ct",
	[30839] = BTS["Flameheart Vest"].."/35267/Ct",
	[24267] = BTS["Battlecast Hood"].."/29676/Ct",
	[24263] = BTS["Battlecast Pants"].."/43100/Ct",
	[24276] = BTS["Golden Spellthread"].."/50000/Ct",
	[24274] = BTS["Runic Spellthread"].."/50000/Ct",
	[21865] = BTS["Soulcloth Vest"].."/41251/Ct",
	[24266] = BTS["Spellstrike Hood"].."/30889/Ct",
	[24262] = BTS["Spellstrike Pants"].."/42951/Ct",
	[32585] = BTS["Swiftheal Mantle"].."/0/Ct",
	[32584] = BTS["Swiftheal Wraps"].."/0/Ct",
	[24264] = BTS["Whitemend Hood"].."/32440/Ct",
	[24261] = BTS["Whitemend Pants"].."/42798/Ct",
	[21872] = BTS["Ebon Shadowbag"].."/40000/Ct",
	[21876] = BTS["Primal Mooncloth Bag"].."/50000/Ct",
	[21858] = BTS["Spellfire Bag"].."/20000/Ct",
	[30463] = "Cinturón Lifeblood/0/Ct",
	[30464] = "Brazales Lifeblood/0/Ct",
	[30465] = "Pantalones Lifeblood/0/Ct",
	[30460] = "Cinturón Netherflame/0/Ct",
	[30461] = "Botas Netherflame/0/Ct",
	[30459] = "Ropa Netherflame/0/Ct",
	[21873] = BTS["Primal Mooncloth Belt"].."/22185/Ct",
	[21874] = BTS["Primal Mooncloth Shoulders"].."/33398/Ct",
	[21875] = BTS["Primal Mooncloth Robe"].."/41510/Ct",
	[21869] = BTS["Frozen Shadoweave Shoulders"].."/32801/Ct",
	[21870] = BTS["Frozen Shadoweave Boots"].."/32921/Ct",
	[21871] = BTS["Frozen Shadoweave Robe"].."/44055/Ct",
	[21846] = BTS["Spellfire Belt"].."/21632/Ct",
	[21847] = BTS["Spellfire Gloves"].."/21712/Ct",
	[21848] = BTS["Spellfire Robe"].."/43584/Ct",
	[2449] = "Earthroot/20/H",
	[765] = "Silverleaf/10/H",
	[3371] = "Frasco Vacío/4/V",
	[2447] = "Peacebloom/10/H",
	[785] = "Mageroyal/20/H",
	[3164] = "Discolored Worg Heart/33/D",
	[2452] = "Swiftthistle/15/H",
	[2450] = "Briarthorn/25/H",
	[5635] = "Sharp Claw/45/D",
	[6358] = "Oily Blackmouth/4/F",
	[6522] = "Deviate Fish/4/F",
	[3820] = "Stranglekelp/100/H",
	[2453] = "Bruiseweed/25/H",
	[3372] = "Frasco Plomado/40/V",
	[3355] = "Wild Steelbloom/50/H",
	[1288] = "Saco Grande de Veneno/185/D",
	[6359] = "Firefin Snapper/5/F",
	[3369] = "Grave Moss/25/H",
	[3356] = "Kingsblood/30/H",
	[3357] = "Liferoot/75/H",
	[3818] = "Fadeleaf/125/H",
	[4402] = "Saco Pequeño de Llama/250/D",
	[3821] = "Goldthorn/150/H",
	[5637] = "Colmillo Grande/75/D",
	[3819] = "Wintersbite/100/H",
	[3358] = "Khadgar's Whisker/175/H",
	[4625] = "Firebloom/250/H",
	[9260] = "Volatile Rum/400/D",
	[8925] = "Frasco de Cristal/500/V",
	[8831] = "Loto Púrpura/300/H",
	[9262] = "Black Vitriol/1000/MfMhMjR",
	[7972] = "Ichor of Undeath/400/D",
	[3858] = "Mithril Ore/250/Mf175",
	[8838] = "Sungrass/60/H",
	[8153] = "Wildvine/5/H",
	[8836] = "Arthas' Tears/95/H",
	[8845] = "Ghost Mushroom/375/H",
	[4342] = "Tinte Púrpura/2500/V",
	[8839] = "Blindweed/375/H",
	[8846] = "Gromsblood/250/H",
	[13422] = "Stonescale Eel/10/F",
	[13463] = "Dreamfoil/100/H",
	[13466] = "Plaguebloom/250/H",
	[12363] = "Cristal Arcano/2000/MiMjMn",
	[13464] = "Golden Sansam/100/H",
	[13465] = "Mountain Silversage/150/H",
	[10620] = "Thorium Ore/250/Mj250",
	[13467] = "Icecap/250/H",
	[10286] = "Corazón Salvaje/400/D",
	[7067] = "Tierra Elemental/400/D",
	[11176] = "Dream Dust/0/Ek",
	[7070] = "Elemental Water/400/D",
	[12938] = "Sangre de Héroes/0/D",
	[19943] = "Massive Mojo/2000/D",
	[12804] = "Powerful Mojo/2000/D",
	[13468] = "Loto Negra/1000/H",
	[22785] = "Felweed/500/H",
	[18256] = "Frasco Imbuido/6000/V",
	[7077] = "Corazón de Fuego/400/D",
	[22787] = "Ragveil/600/H",
	[22786] = "Dreaming Glory/500/H",
	[22789] = "Terocone/500/H",
	[22578] = "Mota de Agua/400/DF",
	[22790] = "Ancient Lichen/750/H",
	[22791] = "Netherbloom/1000/H",
	[22792] = "Nightmare Vine/1250/H",
	[22794] = "Fel Lotus/10000/H",
	[23079] = "Deep Peridot/10000/DMlMmMnR",
	[23107] = "Sombra Draenite/10000/DMlMmMnR",
	[23112] = "Draenite Dorada/10000/DMlMmMnR",
	[23077] = "Blood Garnet/10000/DMlMmMnR",
	[21929] = "Flame Spessarite/10000/DMlMmMnR",
	[23117] = "Azure Moonstone/10000/DMlMmMnR",
	[22793] = "Mana Thistle/2500/H",
	[2835] = "Piedra Aspera/2/Ma1",
	[2589] = "Paño de Lino/13/D",
	[2880] = "Flujo Débil/100/V",
	[774] = "Malachite/15/DMaR",
	[2321] = "Algodón/100/V",
	[818] = "Tigerseye/100/DMaR",
	[2836] = "Piedra Gruesa/15/Mb65",
	[2592] = "Lana/33/D",
	[1210] = "Shadowgem/250/DMaMbMcR",
	[3466] = "Flujo Fuerte/2000/V",
	[5498] = "Small Lustrous Pearl/200/DG",
	[2838] = "Piedra Pesada/60/Me125",
	[1206] = "Ágata de Musgo/400/DMbMcR",
	[5500] = "Iridescent Pearl/750/DG",
	[1705] = "Lesser Moonstone/600/DMbMcMdMeR",
	[2605] = "Tinte Verde/100/V",
	[3864] = "Citrine/800/DMdMeMfMgR",
	[1529] = "Jade/700/DMbMdMeR",
	[7069] = "Aire Elemental/400/D",
	[7912] = "Piedra Sólida/100/Mf175",
	[4306] = "Paño de Seda/150/D",
	[4338] = "Mageweave Cloth/250/D",
	[7909] = "Aquamarine/1000/DMeMfMgR",
	[7971] = "Perla Negra/1000/DG",
	[7075] = "Núcleo de la Tierra/400/D",
	[12361] = "Zafiro Azul/7000/DMjR",
	[11188] = "Cristal Amarillo de Energía/0/G",
	[11186] = "Cristal Rojo de Energía/0/G",
	[12365] = "Piedra Densa/250/Mj250",
	[14047] = "Runecloth/400/D",
	[7910] = "Rubí de la Estrella/5000/DMfMgMjR",
	[11184] = "Cristal Azul de Energía/0/G",
	[12364] = "Esmeralda Enorme/10000/DMjR",
	[12799] = "Large Opal/7000/DMjR",
	[12800] = "Diamante de Azerothian/10000/DMjR",
	[11185] = "Cristal Verde de Energía/0/G",
	[12662] = "Runa Demoniaca/600/D",
	[12811] = "Righteous Orb/20000/D",
	[17010] = "Fiery Core/2000/D",
	[17011] = "Núcleo de Lava/2000/D",
	[17203] = "Sulfuron Ingot/100000/D",
	[11382] = "Blood of the Mountain/750/DMhR",
	[22203] = "Large Obsidian Shard/5000/DM",
	[22202] = "Small Obsidian Shard/2500/DM",
	[12809] = "Guardian Stone/10000/D",
	[17012] = "Core Leather/1000/St315",
	[22682] = "Frozen Rune/20000/D",
	[8146] = "Wicked Claw/500/D",
	[20520] = "Dark Rune/2000/D",
	[15417] = "Devilsaur Leather/500/Sn",
	[12753] = "Skin of Shadow/0/D",
	[20725] = "Nexus Crystal/0/Eo",
	[19774] = "Souldarite/5000/DMiR",
	[19726] = "Bloodvine/500/H",
	[11754] = "Black Diamond/0/DMhR",
	[8168] = "Jet Black Feather/100/D",
	[21877] = "Netherweave Cloth/800/D",
	[22445] = "Arcane Dust/0/Er",
	[23572] = "Primal Nether/16000/D",
	[30183] = "Nether Vortex/20000/D",
	[32428] = "Heart of Darkness/0/D",
	[22450] = "Cristal Vacío/0/Es",
	[7081] = "Breath of Wind/400/D",
	[4470] = "Simple Wood/34/V",
	[6291] = "Raw Brilliant Smallfish/1/F",
	[2672] = "Stringy Wolf Meat/4/D",
	[12223] = "Meaty Bat Wing/4/D",
	[2678] = "Mild Spices/2/V",
	[6889] = "Huevo Pequeño/4/D",
	[17194] = "Holiday Spices/10/V",
	[27668] = "Lynx Meat/5/D",
	[769] = "Chunk of Boar Meat/3/D",
	[23676] = "Moongraze Stag Tenderloin/5/D",
	[6303] = "Raw Slitherskin Mackerel/1/F",
	[30817] = "Simple Flour/1/V",
	[2886] = "Crag Boar Rib/5/D",
	[2894] = "Rhapsody Malt/12/V",
	[5465] = "Small Spider Leg/3/D",
	[5466] = "Scorpid Stinger/8/D",
	[1179] = "Ice Cold Milk/6/VD",
	[17196] = "Holiday Spirits/12/V",
	[5467] = "Kodo Meat/7/D",
	[3173] = "Bear Meat/15/D",
	[27669] = "Bat Flesh/5/D",
	[5503] = "Clam Meat/16/DG",
	[159] = "Refreshing Spring Water/5/V",
	[2673] = "Coyote Meat/10/D",
	[5468] = "Soft Frenzy Flesh/12/D",
	[723] = "Goretusk Liver/15/D",
	[6317] = "Raw Loch Frenzy/2/F",
	[6289] = "Raw Longjaw Mud Snapper/1/F",
	[6361] = "Raw Rainbow Fin Albacore/2/F",
	[5469] = "Strider Meat/9/D",
	[4536] = "Shiny Red Apple/5/V",
	[3172] = "Boar Intestines/18/D",
	[3174] = "Spider Ichor/16/D",
	[22644] = "Crunchy Spider Leg/12/D",
	[2674] = "Crawler Meat/12/D",
	[729] = "Stringy Vulture Meat/17/D",
	[730] = "Murloc Eye/16/D",
	[731] = "Goretusk Snout/27/D",
	[2924] = "Crocolisk Meat/16/D",
	[2677] = "Boar Ribs/15/D",
	[21071] = "Raw Sagefish/25/F",
	[2675] = "Crawler Claw/11/D",
	[5051] = "Dig Rat/1/D",
	[1468] = "Murloc Fin/28/D",
	[2692] = "Hot Spices/40/V",
	[6308] = "Raw Bristle Whisker Catfish/2/F",
	[5470] = "Thunder Lizard Tail/28/D",
	[1081] = "Crisp Spider Meat/50/D",
	[1080] = "Tough Condor Meat/78/D",
	[1015] = "Lean Wolf Flank/24/D",
	[2665] = "Stormwind Seasoning Herbs/20/V",
	[3730] = "Big Bear Meat/45/D",
	[2251] = "Gooey Spider Leg/12/D",
	[5471] = "Stag Meat/30/D",
	[3667] = "Tender Crocolisk Meat/25/D",
	[5504] = "Tangy Clam Meat/22/DG",
	[3731] = "Lion Meat/55/D",
	[3685] = "Raptor Egg/71/D",
	[3713] = "Soothing Spices/160/V",
	[3404] = "Buzzard Wing/181/D",
	[12037] = "Mystery Meat/87/D",
	[4655] = "Giant Clam Meat/71/DG",
	[12203] = "Red Wolf Meat/87/D",
	[12202] = "Tiger Meat/87/D",
	[8365] = "Raw Mithril Head Trout/4/D",
	[2596] = "Skin of Dwarven Stout/120/V",
	[12184] = "Raptor Flesh/87/D",
	[6362] = "Raw Rockscale Cod/4/F",
	[21153] = "Raw Greater Sagefish/125/D",
	[3712] = "Turtle Meat/87/D",
	[12204] = "Heavy Kodo Meat/112/D",
	[12205] = "White Spider Meat/112/D",
	[13754] = "Raw Glossy Mightfish/6/F",
	[13758] = "Raw Redgill/4/F",
	[12207] = "Giant Egg/150/D",
	[12206] = "Tender Crab Meat/112/D",
	[4603] = "Raw Spotted Yellowtail/4/F",
	[12208] = "Tender Wolf Meat/150/D",
	[7974] = "Zesty Clam Meat/50/DG",
	[13755] = "Winter Squid/7/F",
	[13756] = "Raw Summer Bass/9/F",
	[13759] = "Raw Nightfin Snapper/10/F",
	[13760] = "Raw Sunscale Salmon/10/F",
	[13889] = "Raw Whitescale Salmon/5/F",
	[13888] = "Darkclaw Lobster/12/F",
	[13893] = "Large Raw Mightfish/15/F",
	[18255] = "Runn Tum Tuber/15/G",
	[20424] = "Sandworm Meat/175/D",
	[27422] = "Barbed Gill Trout/8/D",
	[27671] = "Buzzard Meat/200/D",
	[24477] = "Jaggal Clam Meat/100/D",
	[8150] = "Deeprock Salt/250/D",
	[21024] = "Chimaerok Tenderloin/0/D",
	[27425] = "Spotted Feltail/8/D",
	[27674] = "Ravager Flesh/200/D",
	[27429] = "Zangarian Sporefish/914/D",
	[27676] = "Strange Spores/200/D",
	[27677] = "Chunk o' Basilisk/200/D",
	[27435] = "Figluster's Mudfish/8/D",
	[27437] = "Icefin Bluefish/8/D",
	[27438] = "Golden Darter/8/D",
	[27678] = "Clefthoof Meat/200/D",
	[27682] = "Talbuk Venison/200/D",
	[27681] = "Warped Flesh/200/D",
	[31671] = "Serpent Flesh/200/D",
	[31670] = "Raptor Ribs/200/D",
	[27439] = "Furious Crawdad/8/D",
	[27515] = "Huge Spotted Feltail/0/D",
	[4539] = "Goldenbark Apple/0/D",
	[27516] = "Enormous Barbed Gill Trout/0/D",
	[2593] = "Flask of Port/0/D",
	[6217] = "Copper Rod/124/V",
	[10940] = "Strange Dust/0/Ea",
	[10938] = "Lesser Magic Essence/0/Eb",
	[17034] = "Maple Seed/200/V",
	[10939] = "Greater Magic Essence/0/Ec",
	[10978] = "Small Glimmering Shard/0/Ea",
	[10998] = "Lesser Astral Essence/0/Ed",
	[11083] = "Soul Dust/0/Ee",
	[11082] = "Greater Astral Essence/0/Ef",
	[11084] = "Large Glimmering Shard/0/Ef",
	[2772] = "Iron Ore/150/Me125",
	[11291] = "Star Wood/4050/V",
	[11134] = "Lesser Mystic Essence/0/Eg",
	[11138] = "Small Glowing Shard/0/Eg",
	[11135] = "Greater Mystic Essence/0/Ei",
	[11137] = "Vision Dust/0/Eh",
	[11139] = "Large Glowing Shard/0/Ei",
	[17035] = "Stranglethorn Seed/400/V",
	[7392] = "Green Whelp Scale/200/Sab",
	[11174] = "Lesser Nether Essence/0/Ej",
	[11177] = "Small Radiant Shard/0/Ej",
	[11175] = "Greater Nether Essence/0/El",
	[11178] = "Large Radiant Shard/0/El",
	[16202] = "Lesser Eternal Essence/0/Em",
	[14343] = "Small Brilliant Shard/0/Em",
	[7079] = "Globe of Water/400/D",
	[16204] = "Illusion Dust/0/En",
	[16203] = "Greater Eternal Essence/0/En",
	[13926] = "Golden Pearl/10000/DG",
	[14344] = "Large Brilliant Shard/0/En",
	[22447] = "Lesser Planar Essence/0/Ep",
	[22448] = "Small Prismatic Shard/0/EpCn",
	[22446] = "Greater Planar Essence/0/Eq",
	[4399] = "Wooden Stock/200/V",
	[4400] = "Heavy Stock/2000/V",
	[814] = "Flask of Oil/25/D",
	[6530] = "Nightcrawlers/100/VD",
	[4611] = "Blue Pearl/50/G",
	[17202] = "Snowball/0/DC",
	[10285] = "Shadow Silk/1000/D",
	[14227] = "Ironweb Spider Silk/2500/D",
	[23436] = "Living Ruby/30000/MlMmMnRD",
	[23438] = "Star of Elune/30000/MlMmMnRD",
	[23440] = "Dawnstone/30000/MlMmMnRD",
	[23439] = "Noble Topaz/30000/MlMmMnRD",
	[23437] = "Talasite/30000/MlMmRD",
	[23441] = "Nightseye/30000/MlMmMnRD",
	[2604] = "Red Dye/50/V",
	[6260] = "Blue Dye/50/V",
	[8151] = "Flask of Mojo/250/D",
	[10648] = "Blank Parchment/500/V",
	[10647] = "Engineer's Ink/2000/V",
	[4337] = "Thick Spider's Silk/750/D",
	[10577] = "Goblin Mortar/2000/Ce",
	[17020] = "Arcane Powder/250/V",
	[1475] = "Small Venom Sac/82/D",
	[19441] = "Huge Venom Sac/1500/D",
	[8152] = "Flask of Big Mojo/500/D",
	[18335] = "Pristine Black Diamond/2520/D",
	[24478] = "Jaggal Pearl/0/D",
	[24243] = "Adamantite Powder/2250/RD",
	[27860] = "Purified Draenic Water/0/D",
	[24479] = "Shadow Pearl/0/D",
	[32230] = "Shadowsong Amethyst/0/D",
	[32227] = "Crimson Spinel/0/D",
	[32229] = "Lionseye/0/D",
	[32249] = "Seaspray Emerald/0/D",
	[32231] = "Pyrestone/0/D",
	[32228] = "Empyrean Sapphire/0/D",
	[2320] = "Coarse Thread/10/V",
	[2934] = "Ruined Leather Scraps/7/Sa",
	[783] = "Light Hide/50/Sb",
	[4289] = "Salt/50/V",
	[5082] = "Thin Kodo Leather/25/D",
	[2324] = "Bleach/25/V",
	[6470] = "Deviate Scale/20/DSy",
	[5784] = "Slimy Murloc Scale/75/D",
	[7286] = "Black Whelp Scale/25/Saa",
	[4340] = "Gray Dye/350/V",
	[4232] = "Medium Hide/125/Sc",
	[6471] = "Perfect Deviate Scale/500/DSy",
	[7287] = "Red Whelp Scale/100/Sz",
	[5116] = "Long Tail Feather/303/D",
	[3182] = "Spider's Silk/387/D",
	[5373] = "Lucky Charm/72/P",
	[4235] = "Heavy Hide/200/Sd",
	[4461] = "Raptor Hide/208/Sac",
	[2325] = "Black Dye/1000/V",
	[5785] = "Thick Murloc Scale/500/D",
	[4291] = "Silken Thread/500/V",
	[7428] = "Shadowcat Hide/250/Sg",
	[8343] = "Heavy Silken Thread/2000/V",
	[4096] = "Coarse Gorilla Hair/608/D",
	[8169] = "Thick Hide/500/Se",
	[8167] = "Turtle Scale/100/Sh",
	[8154] = "Scorpid Scale/250/Si",
	[8171] = "Rugged Hide/500/Sf",
	[15409] = "Refined Deeprock Salt/1000/Cl",
	[15408] = "Heavy Scorpid Scale/500/Sj",
	[14341] = "Rune Thread/4500/V",
	[15412] = "Green Dragonscale/500/Sl",
	[15423] = "Chimera Leather/500/So",
	[15420] = "Ironfeather/100/D",
	[15419] = "Warbear Leather/600/Sq",
	[15422] = "Frostsaber Leather/500/Sm",
	[15415] = "Blue Dragonscale/500/Sl",
	[15416] = "Black Dragonscale/1000/Sl",
	[12607] = "Brilliant Chromatic Scale/8048/D",
	[15414] = "Red Dragonscale/1500/Sl",
	[20381] = "Dreamscale/5000/Sv315",
	[18512] = "Larval Acid/4000/D",
	[19768] = "Primal Tiger Leather/2000/Ss",
	[15410] = "Scale of Onyxia/5000/Sw315",
	[19767] = "Primal Bat Leather/2000/Sr",
	[20501] = "Heavy Silithid Carapace/2000/S",
	[20498] = "Silithid Chitin/1000/D",
	[20500] = "Light Silithid Carapace/2000/S",
	[25700] = "Fel Scales/1250/S",
	[18240] = "Ogre Tannin/0/S",
	[14256] = "Felcloth/2000/D",
	[25649] = "Knothide Leather Scraps/250/S",
	[25708] = "Thick Clefthoof Leather/750/S",
	[29539] = "Cobra Scales/1250/S",
	[25707] = "Fel Hide/6250/S",
	[25699] = "Crystal Infused Leather/1250/S",
	[25703] = "Zhevra Leather/100/S",
	[29548] = "Nether Dragonscales/2000/S",
	[29547] = "Wind Scales/1250/S",
	[8165] = "Worn Dragonscale/500/Sk",
	[8368] = "Thick Wolfhide/1000/Sp",
	[2770] = "Copper Ore/5/Ma1",
	[2771] = "Tin Ore/25/Mb65",
	[2775] = "Silver Ore/75/Mc75",
	[2776] = "Gold Ore/500/Md155",
	[3857] = "Coal/500/VD",
	[7911] = "Truesilver Ore/500/Mg230",
	[11370] = "Dark Iron Ore/500/Mh275",
	[18562] = "Elementium Ore/0/D",
	[18567] = "Elemental Flux/0/D",
	[23424] = "Fel Iron Ore/1000/Ml",
	[23425] = "Adamantite Ore/1500/Mm",
	[23427] = "Eternium Ore/1250/MnMmMl",
	[23426] = "Khorium Ore/2500/Mn",
	[4341] = "Yellow Dye/500/V",
	[7072] = "Naga Scale/150/D",
	[6261] = "Orange Dye/1000/V",
	[10290] = "Pink Dye/2500/V",
	[4589] = "Long Elegant Feather/530/D",
	[11040] = "Morrowgrain/1/DMH",
	[21881] = "Netherweb Spider Silk/5000/D",
	[21882] = "Soul Essence/2500/D",
	[21927] = "Instant Poison VII/125/Cp",
	[3776] = "Crippling Poison II/175/Cp",
	[22053] = "Deadly Poison VI/150/Cp",
	[12625] = "Dawnbringer Shoulders/22847/Cb",
	[8927] = "Instant Poison V/100/Cp",
--	[5530] = "Blinding Powder/125/Cp",
	[10918] = "Wound Poison/42/Cp",
	[12772] = "Inlaid Thorium Hammer/38871/Cb",
	[5173] = "Deathweed/100/V",
	[6949] = "Instant Poison II/20/Cp",
	[2928] = "Dust of Decay/20/V",
	[8928] = "Instant Poison VI/125/Cp",
	[6947] = "Instant Poison/5/Cp",
	[21835] = "Anesthetic Poison/125/Cp",
	[22055] = "Wound Poison V/175/Cp",
	[22728] = "Steam Tonk Controller/1879/Ce",
	[5237] = "Mind-numbing Poison/18/Cp",
	[2931] = "Maiden's Anguish/250/V",
	[10922] = "Wound Poison IV/175/Cp",
	[3777] = "Lethargy Root/40/V",
	[8985] = "Deadly Poison IV/150/Cp",
	[10921] = "Wound Poison III/125/Cp",
	[20844] = "Deadly Poison V/150/Cp",
	[8984] = "Deadly Poison III/100/Cp",
	[6950] = "Instant Poison III/30/Cp",
	[3775] = "Crippling Poison/13/Cp",
	[18258] = "Gordok Ogre Suit/0/Cl",
	[8923] = "Essence of Agony/180/V",
	[22054] = "Deadly Poison VII/150/Cp",
	[2930] = "Essence of Pain/50/V",
	[6951] = "Mind-numbing Poison II/75/Cp",
	[2893] = "Deadly Poison II/55/Cp",
	[9186] = "Mind-numbing Poison III/175/Cp",
	[2892] = "Deadly Poison/30/Cp",
	[8924] = "Dust of Deterioration/100/V",
	[10920] = "Wound Poison II/67/Cp",
	[8926] = "Instant Poison IV/75/Cp",
--new
    [30038] = "Belt of Blasting/0/Ct",
    [30040] = "Belt of Deep Shadow/0/Cl",
    [30042] = "Belt of Natural Power/0/Cl",
    [30046] = "Belt of the Black Eagle/0/Cl",
    [30036] = "Belt of the Long Road/0/Ct",
    [30037] = "Boots of Blasting/0/Ct",
    [30041] = "Boots of Natural Grace/0/Cl",
    [30045] = "Boots of the Crimson Hawk/0/Cl",
    [30035] = "Boots of the Long Road/0/Ct",
    [30043] = "Hurricane Boots/0/Cl",
    [30044] = "Monsoon Belt/0/Cl",
    [30034] = "Belt of the Guardian/0/Cb",
    [30033] = "Boots of the Protector/0/Cb",
    [30032] = "Red Belt of Battle/0/Cb",
    [30031] = "Red Havok Boots/0/Cb",
    [32199] = "Flashing Crimson Spinel/0/Cj",
    [32210] = "Great Lionseye/0/Cj",
    [32217] = "Inscribed Pyrestone/0/Cj",
    [32209] = "Mystic Lionseye/0/Cj",
    [32212] = "Shifting Shadowsong Amethyst/0/Cj",
    [32211] = "Sovereign Shadowsong Amethyst/0/Cj",
    [32203] = "Stormy Empyrean Sapphire/0/Cj",
    [32221] = "Veiled Pyrestone/0/Cj",
    [32574] = "Bindings of Lightning Reflexes/0/Cl",
    [32579] = "Living Earth Shoulders/0/Cl",
    [32587] = "Mantle of Nimble Thought/0/Ct",
    [32583] = "Shoulderpads of Renewed Life/0/Cl",
    [32580] = "Swiftstrike Bracers/0/Cl",
    [32573] = "Dawnsteel Shoulders/0/Cb",
    [32568] = "Swiftsteel Bracers/0/Cb",
    [32586] = "Bracers of Nimble Thought/0/Ct",
    [32582] = "Bracers of Renewed Life/0/Cl",
    [32577] = "Living Earth Bindings/0/Cl",
    [32583] = "Shoulders of Renewed Life/0/Cl",
    [32575] = "Shoulders of Lightning Reflexes/0/Cl",
    [32581] = "Swiftstrike Shoulders/0/Cl",
    [32571] = "Dawnsteel Bracers/0/Cb",
    [32570] = "Swiftsteel Shoulders/0/Cb",
    [30039] = "Boots of Utter Darkness/0/Cl",
    [32398] = "Boots of Shackeled Souls/0/Cl",
    [32399] = "Bracers of Shackeled Souls/0/Cl",
    [32400] = "Greaves of Shackeled Souls/0/Cl",
    [32397] = "Waistguard of Shackeled Souls/0/Cl",
    [32393] = "Redeemed Cinch/0/Cl",
    [32396] = "Redeemed Legguards/0/Cl",
    [32394] = "Redeemed Moccassins/0/Cl",
    [32395] = "Redeemed Wristguards/0/Cl",
    [32420] = "Night's End/0/Ct",
    [32392] = "Soulguard Bracers/0/Ct",
    [32390] = "Soulguard Girdle/0/Ct",
    [32389] = "Soulguard Leggings/0/Ct",
    [32391] = "Soulguard Slippers/0/Ct",
    [32403] = "Shadesteel Bracers/0/Cb",
    [32401] = "Shadesteel Girdle/0/Cb",
    [32404] = "Shadesteel Greaves/0/Cb",
    [32402] = "Shadesteel Sabots/0/Cb",
    [33173] = "Ragesteel Shoulders/0/Cb",
    [32213] = "Balanced Shadowsong Amethyst/0/Cj",
    [32193] = "Bold Crimson Spinel/0/Cj",
    [32197] = "Bright Crimson Spinel/0/Cj",
    [32204] = "Brilliant Lionseye/0/Cj",
    [32225] = "Dazzling Seaspray Emerald/0/Cj",
    [32194] = "Delicate Crimson Spinel/0/Cj",
    [32223] = "Enduring Seaspray Emerald/0/Cj",
    [32207] = "Gleaming Lionseye/0/Cj",
    [32220] = "Glinting Pyrestone/0/Cj",
    [32215] = "Glowing Shadowsong Amethyst/0/Cj",
    [32214] = "Infused Shadowsong Amethyst/0/Cj",
    [32226] = "Jagged Seaspray Emerald/0/Cj",
    [32219] = "Luminous Pyrestone/0/Cj",
    [32202] = "Lustrous Empyrean Sapphire/0/Cj",
    [32218] = "Potent Pyrestone/0/Cj",
    [32224] = "Radiant Seaspray Emerald/0/Cj",
    [32206] = "Rigid Lionseye/0/Cj",
    [32216] = "Royal Shadowsong Amethyst/0/Cj",
    [32196] = "Runed Crimson Spinel/0/Cj",
    [32205] = "Smooth Lionseye/0/Cj",
    [32200] = "Solid Empyrean Sapphire/0/Cj",
    [32201] = "Sparkling Empyrean Sapphire/0/Cj",
    [32198] = "Subtle Crimson Spinel/0/Cj",
    [32195] = "Teardrop Crimson Spinel/0/Cj",
    [32208] = "Thick Lionseye/0/Cj",
    [32222] = "Wicked Pyrestone/0/Cj",
    [33140] = "Blood of Amber/0/Cj",
    [33131] = "Crimson Sun/0/Cj",
    [33133] = "Don Julio's Heart/0/Cj",
    [33144] = "Facet of Eternity/0/Cj",
    [33135] = "Falling Star/0/Cj",
    [33134] = "Kailee's Rose/0/Cj",
    [33143] = "Stone of Blades/0/Cj",
   	[-42620] = "Enchant Weapon - Greater Agility/0/Cn",
    [-42613] = "Nexus Transformation/0/Cn",
    [33204] = "Shadowprowler's Chestguard/0/Cl",
    [33122] = "Cloak of Darkness/0/Cl",
    [33208] = "Flask of Chromatic Wonder/0/Ca",
    [7191] = "Fused Wiring/0/CeD",
    [33782] = "Steady Talasite/0/Cj",
    [17056] = "Light Feather/0/D",
    [25719] = "Arakkoa Feather/0/D",
    [34249] = "Hula Girl Doll/0/D",
    [27503] = "Scroll of Strength V/0/DV",    
    [34220] = "Chaotic Skyfire Diamond/0/Cj",
    [33867] = "Broiled Bloodfin/0/Cc",
    [33924] = "Delicious Chocolate Cake/0/Cc",
    [34411] = "Hot Apple Cider/0/Cc",
    [33874] = "Kibler's Bits/0/Cc",
    [33825] = "Skullfish Soup/0/Cc",
    [33872] = "Spicy Hot Talbuk/0/Cc",
    [33866] = "Stormchops/0/Cc",
    [34060] = "Flying Machine Control/0/Ce",
    [34061] = "Turbo-Charged Flying Machine Control/0/Ce",
    [34113] = "Field Repair Bot 110g/0/Ce",
    [20475] = "Adamantite Arrow Maker/0/Ce",
    [34440] = "Mad Alchemist's Potion/0/Ca",
    [-42974] = "Enchant Weapon: Executioner/0/Cn",
    [-44383] = "Enchant Shield Resilience/0/Cn",
    [32854] = "Hammer of Righteous Might/0/Cb",
    [33185] = "Adamantite Weapon Chain/0/Cb",
    [33791] = "Heavy Copper Longsword/0/Cb",
    [34207] = "Glove Reinforcements/0/Cb",
    [34099] = "Knothide Ammo Pouch/0/Cl",
    [34100] = "Knothide Quiver/0/Cl",
    [34105] = "Quiver of a Thousand Feathers/0/Cl",
    [34106] = "Netherscale Ammo Pouch/0/Cl",
    [34490] = "Bag of Many Hides/0/Cl",
    [34482] = "Leatherworker's Satchel/0/Cl",
    [34086] = "Winter Boots/0/Cl",
    [34087] = "Green Winter Clothes/0/Ct",
    [34085] = "Red Winter Clothes/0/Ct",
    [34330] = "Heavy Knothide Armor Kit/0/Cl",
    [33823] = "Bloodfin Catfish/0/F",
    [34412] = "Sparkling Apple Cider/0/Q",
    [33824] = "Crescent-Tail Skullfish/0/F",
    [13757] = "Lightning Eel/0/F",
    [34360] = "Amulet of Flowing Life/0/Cj",
    [34361] = "Hard Khorium Band/0/Cj",
    [34358] = "Hard Khorium Choker/0/Cj",
    [34359] = "Pendant of Sunfire/0/Cj",
    [34362] = "Loop of Forged Power/0/Cj",
    [34363] = "Ring of Flowing Life/0/Cj",
    [34369] = "Carapace of Sun and Shadow/0/Cl",
    [34373] = "Embrace of the Phoenix/0/Cl",
    [34374] = "Fletcher's Gloves of the Phoenix/0/Cl",
    [34370] = "Gloves of Immortal Dusk/0/Ct",
    [34367] = "Hands of Eternal Light/0/Ct",
    [34371] = "Leather Chestguard of the Sun/0/Cl",
    [34372] = "Leather Gauntlets of the Sun/0/Cl",
    [34365] = "Robe of Eternal Light/0/Ct",
    [34375] = "Sun-Drenched Scale Chestguard/0/Cl",
    [34376] = "Sun-Drenched Scale Gloves/0/Cl",
    [34366] = "Sunfire Handwraps/0/Ct",
    [34364] = "Sunfire Robe/0/Ct",
    [34378] = "Hard Khorium Battlefists/0/Cb",
    [34377] = "Hard Khorium Battleplate/0/Cb",
    [34379] = "Sunblessed Breastplate/0/Cb",
    [34380] = "Sunblessed Gauntlets/0/Cb",
    [34847] = "Annihilator Holo-Gogs/0/Ce",
    [34357] = "Hard Khorium Goggles/0/Ce",
    [35182] = "Hyper-Magnified Moon Specs/0/Ce",
    [35185] = "Justicebringer 3000 Specs/0/Ce",
    [34355] = "Lightning Etched Specs/0/Ce",
    [34354] = "Mayhem Projection Goggles/0/Ce",
    [35181] = "Powerheal 9000 Lens/0/Ce",
    [35184] = "Primal-Attuned Goggles/0/Ce",
    [34353] = "Quad Deathblow X44 Goggles/0/Ce",
    [34356] = "Surestrike Goggles v3.0/0/Ce",
    [35183] = "Wonderheal XT68 Shades/0/Ce",
    [34832] = "Captain Rumsey's Lager/0/Cc",
    [35503] = "Ember Skyfire Diamond/0/Cj",
    [35501] = "Eternal Earthstorm Diamond/0/Cj",
    [35563] = "Charred Bear Kabobs/0/Cc",
    [35565] = "Juicy Bear Burger/0/Cc",
   	[35128] = "Smelt Hardened Khorium Bar/0/Cs",
    [35759] = "Forceful Seaspray Emerald/0/Cj",
    [35761] = "Quick Lionseye/0/Cj",
    [35760] = "Reckless Pyrestone/0/Cj",
    [35758] = "Steady Seaspray Emerald/0/Cj",
    [35581] = "Rocket Boots Xtreme Lite/0/Cj",
    [35700] = "Figurine - Crimson Serpent/0/Cj",
    [35693] = "Figurine - Empyrean Tortoise/0/Cj",
    [35694] = "Figurine - Khorium Boar/0/Cj",
    [35703] = "Figurine - Seaspray Albatross/0/Cj",
    [35702] = "Figurine - Shadowsong Panther/0/Cj",
    [35707] = "Regal Nightseye/0/Cj",
    [35751] = "Assassin's Alchemist Stone/0/Cj",
    [35748] = "Guardian's Alchemist Stone/0/Cj",
    [35750] = "Redeemer's Alchemist Stone/0/Cj",
    [35749] = "Sorcerer's Alchemist Stone/0/Cj",
    [34664] = "Sunmote/0/D",
    [35562] = "Bear Flank/0/D",
    [35318] = "Forceful Talasite/0/Cj",
    [35315] = "Quick Dawnstone/0/Cj",
    [35316] = "Reckless Noble Topaz/0/Cj",

}

TradeskillInfo.vars.enchants = {
	[-7428] = BTS["Enchant Bracer - Minor Deflection"].."/Permanently enchants bracers to give +2 defense rating.",
	[-7418] = BTS["Enchant Bracer - Minor Health"].."/Permanently enchant bracers to increase the health of the wearer by 5.",
	[-7420] = BTS["Enchant Chest - Minor Health"].."/Permanently enchant a piece of chest armor so that it increases the health of the wearer by 5.",
	[-7443] = BTS["Enchant Chest - Minor Mana"].."/Permanently enchant a piece of chest armor so that it increases the mana of the wearer by 5.",
	[-7426] = BTS["Enchant Chest - Minor Absorption"].."/Enchant a piece of chest armor so it has a 2% chance per hit of giving you 10 points of damage absorption.",
	[-7454] = BTS["Enchant Cloak - Minor Resistance"].."/Permanently enchant a cloak so that it increases the resistance to all schools of magic by 1.",
	[-7457] = BTS["Enchant Bracer - Minor Stamina"].."/Permanently enchant bracers so they increase the wearer's Stamina by 1.",
	[-7766] = BTS["Enchant Bracer - Minor Spirit"].."/Permanently enchant bracers so they increase the wearer's Spirit by 1.",
	[-7748] = BTS["Enchant Chest - Lesser Health"].."/Permanently enchant a piece of chest armor so that it increases the health of the wearer by 15.",
	[-7771] = BTS["Enchant Cloak - Minor Protection"].."/Enchant a cloak to provide 10 additional points of armor.",
	[-7779] = BTS["Enchant Bracer - Minor Agility"].."/Permanently enchant bracers so they increase the wearer's Agility by 1.",
	[-7782] = BTS["Enchant Bracer - Minor Strength"].."/Permanently enchant bracers so they increase the wearer's Strength by 1.",
	[-7776] = BTS["Enchant Chest - Lesser Mana"].."/Permanently enchant a piece of chest armor so that it increases the mana of the wearer by 20.",
	[-7786] = BTS["Enchant Weapon - Minor Beastslayer"].."/Permanently enchant a Melee Weapon to do 2 additional points of damage to Beasts.",
	[-7788] = BTS["Enchant Weapon - Minor Striking"].."/Permanently enchant a Melee Weapon to do 1 additional point of damage.",
	[-7793] = BTS["Enchant 2H Weapon - Lesser Intellect"].."/Permanently enchant a Two-Handed Melee Weapon to add 3 to intellect.",
	[-7745] = BTS["Enchant 2H Weapon - Minor Impact"].."/Permanently enchant a Two-Handed Melee Weapon to do 2 additional points of damage.",
	[-13378] = BTS["Enchant Shield - Minor Stamina"].."/Permanently enchant a shield so that it increases the Stamina of the bearer by 1.",
	[-13380] = BTS["Enchant 2H Weapon - Lesser Spirit"].."/Permanently enchant a Two-Handed Melee Weapon to add 3 to Spirit.",
	[-13419] = BTS["Enchant Cloak - Minor Agility"].."/Permanently enchant a cloak to grant +1 Agility.",
	[-13421] = BTS["Enchant Cloak - Lesser Protection"].."/Permanently enchant a cloak to increase armor by 20.",
	[-13464] = BTS["Enchant Shield - Lesser Protection"].."/Permanently enchant a shield to increase its armor by 30.",
	[-7859] = BTS["Enchant Bracer - Lesser Spirit"].."/Permanently enchant a bracer so it increases the wearer's Spirit by 3.",
	[-7857] = BTS["Enchant Chest - Health"].."/Permanently enchant a piece of chest armor to increase the health of the wearer by 25.",
	[-7867] = BTS["Enchant Boots - Minor Agility"].."/Permanently enchant a pair of boots so they increase the wearer's Agility by 1.",
	[-7863] = BTS["Enchant Boots - Minor Stamina"].."/Permanently enchant a pair of boots so they increase the wearer's Stamina by 1.",
	[-7861] = BTS["Enchant Cloak - Lesser Fire Resistance"].."/Permanently enchant a cloak so that it increases resistance to fire by 5.",
	[-13501] = BTS["Enchant Bracer - Lesser Stamina"].."/Permanently enchant a bracer so it increases the wearer's Stamina by 3.",
	[-13485] = BTS["Enchant Shield - Lesser Spirit"].."/Permanently enchant a shield to give 3 spirit.",
	[-13522] = BTS["Enchant Cloak - Lesser Shadow Resistance"].."/Permanently enchant a cloak so that it increases resistance to shadow by 10.",
	[-13536] = BTS["Enchant Bracer - Lesser Strength"].."/Permanently enchant a bracer so it increases the wearer's Strength by 3.",
	[-13538] = BTS["Enchant Chest - Lesser Absorption"].."/Enchant a piece of chest armor so it has a 5% chance per hit of giving you 25 points of damage absorption.",
	[-13503] = BTS["Enchant Weapon - Lesser Striking"].."/Permanently enchant a Melee Weapon to do 2 additional points of damage.",
	[-13529] = BTS["Enchant 2H Weapon - Lesser Impact"].."/Permanently enchant a Two-handed Melee Weapon to do 3 additional points of damage.",
	[-13607] = BTS["Enchant Chest - Mana"].."/Permanently enchant a piece of chest armor to increase the mana of the wearer by 30.",
	[-13620] = BTS["Enchant Gloves - Fishing"].."/Permanently enchant gloves to grant +2 fishing skill.",
	[-13617] = BTS["Enchant Gloves - Herbalism"].."/Permanently enchant gloves to grant +2 herbalism skill.",
	[-13612] = BTS["Enchant Gloves - Mining"].."/Permanently enchant gloves to grant +2 mining skill.",
	[-13622] = BTS["Enchant Bracer - Lesser Intellect"].."/Permanently enchant a bracer so it increases the wearer's Intellect by 3.",
	[-13626] = BTS["Enchant Chest - Minor Stats"].."/Permanently enchant a piece of chest armor to grant +1 to all stats.",
	[-13635] = BTS["Enchant Cloak - Defense"].."/Permanently enchant a cloak to give 30 additional armor.",
	[-13631] = BTS["Enchant Shield - Lesser Stamina"].."/Permanently enchant a shield to give 3 Stamina.",
	[-13637] = BTS["Enchant Boots - Lesser Agility"].."/Permanently enchant boots to give +3 Agility.",
	[-13640] = BTS["Enchant Chest - Greater Health"].."/Permanently enchant a piece of chest armor to give +35 health.",
	[-13642] = BTS["Enchant Bracer - Spirit"].."/Permanently enchants bracers to give +5 Spirit.",
	[-13644] = BTS["Enchant Boots - Lesser Stamina"].."/Permanently enchant boots to give +3 Stamina.",
	[-13646] = BTS["Enchant Bracer - Lesser Deflection"].."/Permanently enchants bracers to give +3 defense rating.",
	[-13648] = BTS["Enchant Bracer - Stamina"].."/Permanently enchants bracers to give +5 Stamina.",
	[-13657] = BTS["Enchant Cloak - Fire Resistance"].."/Permanently enchant a cloak to give 7 Fire Resistance.",
	[-13653] = BTS["Enchant Weapon - Lesser Beastslayer"].."/Permanently enchant a Melee Weapon to do 6 additional points of damage to Beasts.",
	[-13655] = BTS["Enchant Weapon - Lesser Elemental Slayer"].."/Permanently enchant a Melee Weapon to do 6 additional damage against Elementals.",
	[-13661] = BTS["Enchant Bracer - Strength"].."/Permanently enchants bracers to give +5 Strength.",
	[-13659] = BTS["Enchant Shield - Spirit"].."/Permanently enchant a shield to give 5 Spirit.",
	[-13663] = BTS["Enchant Chest - Greater Mana"].."/Permanently enchant a piece of chest armor to give +50 mana.",
	[-13687] = BTS["Enchant Boots - Lesser Spirit"].."/Permanently enchant boots to give +3 Spirit.",
	[-21931] = BTS["Enchant Weapon - Winter's Might"].."/Permanently enchant a weapon to grant up to 7 additional frost damage when casting frost spells.",
	[-13689] = BTS["Enchant Shield - Lesser Block"].."/Permanently enchant a shield to give 10 block rating.",
	[-13693] = BTS["Enchant Weapon - Striking"].."/Permanently enchant a Melee Weapon to do 3 additional points of damage.",
	[-13695] = BTS["Enchant 2H Weapon - Impact"].."/Permanently enchant a Two-handed Melee Weapon to do 5 additional points of damage.",
	[-13700] = BTS["Enchant Chest - Lesser Stats"].."/Permanently enchant a piece of chest armor to grant +2 to all stats.",
	[-13698] = BTS["Enchant Gloves - Skinning"].."/Permanently enchant gloves to grant +5 skinning skill.",
	[-13746] = BTS["Enchant Cloak - Greater Defense"].."/Permanently enchant a cloak to give 50 additional armor.",
	[-13794] = BTS["Enchant Cloak - Resistance"].."/Permanently enchant a cloak to give 3 to all resistances.",
	[-13822] = BTS["Enchant Bracer - Intellect"].."/Permanently enchants bracers to give +5 Intellect.",
	[-13815] = BTS["Enchant Gloves - Agility"].."/Permanently enchant gloves to grant +5 Agility.",
	[-13817] = BTS["Enchant Shield - Stamina"].."/Permanently enchant a shield to give +5 Stamina.",
	[-13836] = BTS["Enchant Boots - Stamina"].."/Permanently enchant boots to give +5 Stamina.",
	[-13841] = BTS["Enchant Gloves - Advanced Mining"].."/Permanently enchant gloves to grant +5 mining skill.",
	[-13846] = BTS["Enchant Bracer - Greater Spirit"].."/Permanently enchants bracers to give +7 Spirit.",
	[-13858] = BTS["Enchant Chest - Superior Health"].."/Permanently enchant a piece of chest armor to grant +50 health.",
	[-13890] = BTS["Enchant Boots - Minor Speed"].."/Permanently enchant boots to give a slight movement speed increase.",
	[-13882] = BTS["Enchant Cloak - Lesser Agility"].."/Permanently enchant a cloak to give 3 Agility.",
	[-13868] = BTS["Enchant Gloves - Advanced Herbalism"].."/Permanently enchant gloves to grant +5 herbalism skill.",
	[-13887] = BTS["Enchant Gloves - Strength"].."/Permanently enchant gloves to grant +5 Strength.",
	[-13917] = BTS["Enchant Chest - Superior Mana"].."/Permanently enchant a piece of chest armor to give +65 mana.",
	[-13905] = BTS["Enchant Shield - Greater Spirit"].."/Permanently enchant a shield to give +7 Spirit.",
	[-13915] = BTS["Enchant Weapon - Demonslaying"].."/Permanently enchant a melee weapon to have a chance of stunning and doing heavy damage to demons.",
	[-13935] = BTS["Enchant Boots - Agility"].."/Permanently enchant boots to give +5 Agility.",
	[-13931] = BTS["Enchant Bracer - Deflection"].."/Permanently enchants bracers to give +5 defense rating.",
	[-13933] = BTS["Enchant Shield - Frost Resistance"].."/Permanently enchant a shield to give +8 Frost Resistance.",
	[-13937] = BTS["Enchant 2H Weapon - Greater Impact"].."/Permanently enchant a two-handed melee weapon to do +7 damage.",
	[-13939] = BTS["Enchant Bracer - Greater Strength"].."/Permanently enchants bracers to give +7 Strength.",
	[-13945] = BTS["Enchant Bracer - Greater Stamina"].."/Permanently enchants bracers to give +7 Stamina.",
	[-13941] = BTS["Enchant Chest - Stats"].."/Permanently enchant a piece of chest armor to grant +3 to all stats.",
	[-13943] = BTS["Enchant Weapon - Greater Striking"].."/Permanently enchant a Melee Weapon to do 4 additional points of damage.",
	[-13948] = BTS["Enchant Gloves - Minor Haste"].."/Permanently enchant gloves to grant a +1% attack speed bonus.",
	[-13947] = BTS["Enchant Gloves - Riding Skill"].."/Permanently enchant gloves to grant a minor movement bonus while mounted.",
	[-20008] = BTS["Enchant Bracer - Greater Intellect"].."/Permanently enchants bracers to give +7 Intellect.",
	[-20020] = BTS["Enchant Boots - Greater Stamina"].."/Permanently enchant boots to give +7 Stamina.",
	[-20014] = BTS["Enchant Cloak - Greater Resistance"].."/Permanently enchant a cloak to give 5 to all resistances.",
	[-20017] = BTS["Enchant Shield - Greater Stamina"].."/Permanently enchant a shield to give +7 Stamina.",
	[-13898] = BTS["Enchant Weapon - Fiery Weapon"].."/Permanently enchant a melee weapon to often strike for 40 additional fire damage.",
	[-20009] = BTS["Enchant Bracer - Superior Spirit"].."/Permanently enchants bracers to give +9 Spirit.",
	[-20012] = BTS["Enchant Gloves - Greater Agility"].."/Permanently enchant gloves to grant +7 Agility.",
	[-20024] = BTS["Enchant Boots - Spirit"].."/Permanently enchant boots to give +5 Spirit.",
	[-20026] = BTS["Enchant Chest - Major Health"].."/Permanently enchant a piece of chest armor to grant +100 health.",
	[-20016] = BTS["Enchant Shield - Superior Spirit"].."/Permanently enchant a shield to give +9 Spirit.",
	[-20015] = BTS["Enchant Cloak - Superior Defense"].."/Permanently enchant a cloak to give 70 additional armor.",
	[-20029] = BTS["Enchant Weapon - Icy Chill"].."/Permanently enchant a melee weapon to often chill the target reducing their movement and attack speed. Has a reduced effect for players above level 60.",
	[-27837] = BTS["Enchant 2H Weapon - Agility"].."/Permanently enchant a two-handed melee weapon to grant +25 Agility.",
	[-23801] = BTS["Enchant Bracer - Mana Regeneration"].."/Permanently enchants bracers to restore 4 mana every 5 seconds.",
	[-20028] = BTS["Enchant Chest - Major Mana"].."/Permanently enchant a piece of chest armor to give +100 mana.",
	[-23800] = BTS["Enchant Weapon - Agility"].."/Permanently enchant a melee weapon to grant +15 Agility.",
	[-23799] = BTS["Enchant Weapon - Strength"].."/Permanently enchant a melee weapon to grant +15 strength.",
	[-20030] = BTS["Enchant 2H Weapon - Superior Impact"].."/Permanently enchant a two-handed melee weapon to do +9 damage.",
	[-20023] = BTS["Enchant Boots - Greater Agility"].."/Permanently enchant boots to give +7 Agility.",
	[-20010] = BTS["Enchant Bracer - Superior Strength"].."/Permanently enchants bracers to give +9 Strength.",
	[-20013] = BTS["Enchant Gloves - Greater Strength"].."/Permanently enchant gloves to grant +7 Strength.",
	[-20033] = BTS["Enchant Weapon - Unholy Weapon"].."/Permanently enchant a melee weapon to often inflict a curse on the target reducing their melee damage.",
	[-20036] = BTS["Enchant 2H Weapon - Major Intellect"].."/Permanently enchant a Two-Handed Melee Weapon to add 9 to intellect.",
	[-20035] = BTS["Enchant 2H Weapon - Major Spirit"].."/Permanently enchant a Two-Handed Melee Weapon to add 9 to Spirit.",
	[-34002] = BTS["Enchant Bracer - Assault"].."/Permanently enchants bracers to increase attack power by 24. Requires a level 35 or higher item.",
	[-23802] = BTS["Enchant Bracer - Healing Power"].."/Permanently enchants bracers to increase the effects of your healing spells by 24.",
	[-20011] = BTS["Enchant Bracer - Superior Stamina"].."/Permanently enchants bracers to give +9 Stamina.",
	[-20025] = BTS["Enchant Chest - Greater Stats"].."/Permanently enchant a piece of chest armor to grant +4 to all stats.",
	[-33991] = BTS["Enchant Chest - Restore Mana Prime"].."/Permanently enchant a piece of chest armor to grant 6 Mana every 5 seconds. Requires a level 35 or higher item.",
	[-25086] = BTS["Enchant Cloak - Dodge"].."/Permanently enchant a cloak to give 12 dodge rating.",
	[-25081] = BTS["Enchant Cloak - Greater Fire Resistance"].."/Permanently enchant a cloak to give 15 fire resistance.",
	[-25082] = BTS["Enchant Cloak - Greater Nature Resistance"].."/Permanently enchant a cloak to give 15 nature resistance.",
	[-25083] = BTS["Enchant Cloak - Stealth"].."/Permanently enchant a cloak to give a increase to stealth.",
	[-25084] = BTS["Enchant Cloak - Subtlety"].."/Permanently enchant a cloak to decrease threat caused by the wearer by 2%.",
	[-25078] = BTS["Enchant Gloves - Fire Power"].."/Permanently enchant gloves to increase fire damage by up to 20.",
	[-25074] = BTS["Enchant Gloves - Frost Power"].."/Permanently enchant gloves to increase frost damage by up to 20.",
	[-25079] = BTS["Enchant Gloves - Healing Power"].."/Permanently enchant gloves to increase the caster's healing spells by up to 30.",
	[-25073] = BTS["Enchant Gloves - Shadow Power"].."/Permanently enchant gloves to increase shadow damage by up to 20.",
	[-25080] = BTS["Enchant Gloves - Superior Agility"].."/Permanently enchant gloves to increase agility by 15.",
	[-25072] = BTS["Enchant Gloves - Threat"].."/Permanently enchant gloves to increase threat from all attacks and spells by 2%.",
	[-20034] = BTS["Enchant Weapon - Crusader"].."/Permanently enchant a melee weapon so that often when attacking in melee it heals for 75 to 125 and increases Strength by 100 for 15 sec. Has a reduced effect for players above level 60.",
	[-22750] = BTS["Enchant Weapon - Healing Power"].."/Permanently enchant a Melee Weapon to add up to 55 points of healing to healing spells.",
	[-20032] = BTS["Enchant Weapon - Lifestealing"].."/Permanently enchant a melee weapon to often steal life from the enemy and give it to the wielder. Has a reduced effect for players above level 60.",
	[-23804] = BTS["Enchant Weapon - Mighty Intellect"].."/Permanently enchant a melee weapon to grant +22 Intellect.",
	[-23803] = BTS["Enchant Weapon - Mighty Spirit"].."/Permanently enchant a melee weapon to grant +20 Spirit.",
	[-22749] = BTS["Enchant Weapon - Spell Power"].."/Permanently enchant a Melee Weapon to add up to 30 damage and healing to all spells.",
	[-20031] = BTS["Enchant Weapon - Superior Striking"].."/Permanently enchant a Melee Weapon to do 5 additional points of damage.",
	[-27948] = BTS["Enchant Boots - Vitality"].."/Permanently enchant boots to restore 4 health and mana every 5 seconds. Requires a level 35 or higher item.",
	[-27899] = BTS["Enchant Bracer - Brawn"].."/Permanently enchants bracers to increase Strength by 12. Requires a level 35 or higher item.",
	[-34001] = BTS["Enchant Bracer - Major Intellect"].."/Permanently enchants bracers to increase Intellect by 12. Requires a level 35 or higher item.",
	[-33993] = BTS["Enchant Gloves - Blasting"].."/Permanently enchant gloves to grant 10 spell critical strike rating. Requires a level 35 or higher item.",
	[-34004] = BTS["Enchant Cloak - Greater Agility"].."/Permanently enchant a cloak to increase Agility by 12. Requires a level 35 or higher item.",
	[-27961] = BTS["Enchant Cloak - Major Armor"].."/Permanently enchant a cloak to give 120 additional armor. Requires a level 35 or higher item.",
	[-33996] = BTS["Enchant Gloves - Assault"].."/Permanently enchant gloves to grant 26 attack power. Requires a level 35 or higher item.",
	[-27944] = BTS["Enchant Shield - Tough Shield"].."/Permanently enchant a shield to give 18 additional block value. Requires a level 35 or higher item.",
	[-27905] = BTS["Enchant Bracer - Stats"].."/Permanently enchants bracers to increase all Stats by 4. Requires a level 35 or higher item.",
	[-27957] = BTS["Enchant Chest - Exceptional Health"].."/Permanently enchant a piece of chest armor to grant +150 health. Requires a level 35 or higher item.",
	[-27950] = BTS["Enchant Boots - Fortitude"].."/Permanently enchant boots to increase Stamina by 12. Requires a level 35 or higher item.",
	[-27906] = BTS["Enchant Bracer - Major Defense"].."/Permanently enchants bracers to increase your defense rating by 12. Requires a level 35 or higher item.",
	[-33990] = BTS["Enchant Chest - Major Spirit"].."/Permanently enchant a piece of chest armor to grant +15 Spirit. Requires a level 35 or higher item.",
	[-27911] = BTS["Enchant Bracer - Superior Healing"].."/Permanently enchants bracers to increase the effect of your healing spells by up to 30. Requires a level 35 or higher item.",
	[-34003] = BTS["Enchant Cloak - Spell Penetration"].."/Permanently enchant a cloak to increase Spell Penetration by 20. Requires a level 35 or higher item.",
	[-27945] = BTS["Enchant Shield - Intellect"].."/Permanently enchant a shield to give 12 intellect. Requires a level 35 or higher item.",
	[-34009] = BTS["Enchant Shield - Major Stamina"].."/Permanently enchant a shield to give 18 Stamina. Requires a level 35 or higher item.",
	[-27962] = BTS["Enchant Cloak - Major Resistance"].."/Permanently enchant a cloak to increase all Resistances by 7. Requires a level 35 or higher item.",
	[-27913] = BTS["Enchant Bracer - Restore Mana Prime"].."/Permanently enchants bracers to restore 6 mana every 5 seconds. Requires a level 35 or higher item.",
	[-27951] = BTS["Enchant Boots - Dexterity"].."/Permanently enchant boots to increase Agility by 12. Requires a level 35 or higher item.",
	[-33995] = BTS["Enchant Gloves - Major Strength"].."/Permanently enchant gloves to grant +15 Strength. Requires a level 35 or higher item.",
	[-27946] = BTS["Enchant Shield - Shield Block"].."/Permanently enchant a shield to give 15 block rating. Requires a level 35 or higher item.",
	[-27968] = BTS["Enchant Weapon - Major Intellect"].."/Permanently enchant a melee weapon to grant +30 Intellect. Requires a level 35 or higher item.",
	[-27967] = BTS["Enchant Weapon - Major Striking"].."/Permanently enchant a Melee Weapon to do 7 additional points of damage. Requires a level 35 or higher item.",
	[-27960] = BTS["Enchant Chest - Exceptional Stats"].."/Permanently enchant a piece of chest armor to add 6 to all stats. Requires a level 35 or higher item.",
	[-33992] = BTS["Enchant Chest - Major Resilience"].."/Permanently enchant a piece of chest armor to grant 15 resilience rating. Requires a level 35 or higher item.",
	[-27971] = BTS["Enchant 2H Weapon - Savagery"].."/Permanently enchant a Two Handed Melee Weapon to add 70 attack power. Requires a level 35 or higher item.",
	[-27914] = BTS["Enchant Bracer - Fortitude"].."/Permanently enchants bracers to give 12 Stamina. Requires a level 35 or higher item.",
	[-34005] = BTS["Enchant Cloak - Greater Arcane Resistance"].."/Permanently enchant a cloak to increase Arcane Resistance by 15. Requires a level 35 or higher item.",
	[-34006] = BTS["Enchant Cloak - Greater Shadow Resistance"].."/Permanently enchant a cloak to increase Shadow Resistance by 15. Requires a level 35 or higher item.",
	[-33999] = BTS["Enchant Gloves - Major Healing"].."/Permanently enchant gloves to increase Healing by 35. Requires a level 35 or higher item.",
	[-34010] = BTS["Enchant Weapon - Major Healing"].."/Permanently enchant a Melee Weapon to add +81 Healing. Requires a level 35 or higher item.",
	[-27975] = BTS["Enchant Weapon - Major Spellpower"].."/Permanently enchant a melee weapon to increase spell damage and healing by up to 40. Requires a level 35 or higher item.",
	[-27972] = BTS["Enchant Weapon - Potency"].."/Permanently enchant a Melee Weapon to add 20 Strength. Requires a level 35 or higher item.",
	[-27977] = BTS["Enchant 2H Weapon - Major Agility"].."/Permanently enchant a Two Handed Melee Weapon to add 35 Agility. Requires a level 35 or higher item.",
	[-34008] = BTS["Enchant Boots - Boar's Speed"].."/Permanently enchant boots to give a minor movement speed increase and 9 Stamina. Requires a level 35 or higher item.",
	[-34007] = BTS["Enchant Boots - Cat's Swiftness"].."/Permanently enchant boots to give a minor movement speed increase and 6 Agility. Requires a level 35 or higher item.",
	[-27917] = BTS["Enchant Bracer - Spellpower"].."/Permanently enchant bracers to increase spell damage and healing by up to 15. Requires a level 35 or higher item.",
	[-33997] = BTS["Enchant Gloves - Major Spellpower"].."/Permanently enchant gloves to increase damage and healing by up to 20. Requires a level 35 or higher item.",
	[-33994] = BTS["Enchant Gloves - Spell Strike"].."/Permanently enchant gloves to grant 15 spell hit rating. Requires a level 35 or higher item.",
	[-27924] = BTS["Enchant Ring - Spellpower"].."/Permanently enchant a ring to increase spell damage and healing by up to 12. Only the Enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound.",
	[-27920] = BTS["Enchant Ring - Striking"].."/Permanently enchant ring to increase weapon damage by 2. Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound. Requires a level 35 or higher item.",
	[-27947] = BTS["Enchant Shield - Resistance"].."/Permanently enchant a shield to increase resistance to all magic schools by 5. Requires a level 35 or higher item.",
	[-28004] = BTS["Enchant Weapon - Battlemaster"].."/Permanently enchant a Melee Weapon to occasionaly heal nearby party members of 180 to 300 health when an enemy is struck. Requires a level 35 or higher item.",
	[-28003] = BTS["Enchant Weapon - Spellsurge"].."/Permanently enchant a Melee Weapon to have a 3% chance on spellcast to restore 100 mana to all party members over 10 seconds. Requires a level 35 or higher item.",
	[-27954] = BTS["Enchant Boots - Surefooted"].."/Permanently enchant boots to increase snare and root resistance by 5% and increase hit rating by 10. Requires a level 35 or higher item.",
	[-27926] = BTS["Enchant Ring - Healing Power"].."/Permanently enchant a ring to increase healing spells by up to 20. Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound. Requires a level 35 or higher item.",
	[-27927] = BTS["Enchant Ring - Stats"].."/Permanently enchant a ring to increase all stats by 4. Only the enchanter's rings can be enchanted, and enchanting a ring will cause it to become soulbound. Requires a level 35 or higher item.",
	[-27984] = BTS["Enchant Weapon - Mongoose"].."/Permanently enchant a Melee Weapon to occasionally increase Agility by 120 and attack speed slightly. Requires a level 35 or higher item.",
	[-27982] = BTS["Enchant Weapon - Soulfrost"].."/Permanently enchant a Melee Weapon to add up to 54 damage to frost and shadow spells. Requires a level 35 or higher item.",
	[-27981] = BTS["Enchant Weapon - Sunfire"].."/Permanently enchant a Melee Weapon to add up to 50 damage to fire and arcane spells. Requires a level 35 or higher item.",
	[-27958] = "Enchant Chest - Exceptional Mana/Permanently enchant a piece of chest armor to grant +150 mana. Requires a level 35 or higher item.",
	[-42620] = BTS["Enchant Weapon - Greater Agility"].."/Permanently enchant a weapon to increase Agility by 20.  Requires a level 35 or higher item.",
	[-42613] = BTS["Nexus Transformation"].."/Transforms a Nexus Crystal into a Small Prismatic Shard.",
	[-42974] = BTS["Enchant Weapon - Executioner"].."/Permanently enchant a Melee Weapon to occasionally ignore 840 of your enemy's armor.  Requires a level 60 or higher item.",
	[-44383] = BTS["Enchant Shield - Resilience"].."/Permanently enchant a shield to increase Resilience by 12.  Requires a level 35 or higher item.",
	[-45765] = "Void Shatter/Shatters a Void Crystal into two Prismatic Shards.",
	[-46594] = BTS["Enchant Chest - Defense"].."/Permanently enchant a piece of chest armor to grant 15 defense rating.  Requires a level 35 or higher item.",
	[-47051] = "Enchant Cloak - Steelweave/Permanently enchant a cloak to grant 12 defense rating.  Requires a level 35 or higher item.",
    }

TradeskillInfo.vars.zones = {
	[1] = BZ["Alterac Mountains"],
	[2] = BZ["Arathi Highlands"],
	[3] = BZ["Ashenvale"],
	[4] = BZ["Azshara"],
	[5] = BZ["Badlands"],
	[6] = BZ["Blackrock Depths"],
	[7] = BZ["Blasted Lands"],
	[8] = BZ["Burning Steppes"],
	[9] = BZ["Darkshore"],
	[10] = BZ["Darnassus"],
	[11] = BZ["Desolace"],
	[12] = BZ["Dire Maul"],
	[13] = BZ["Dun Morogh"],
	[14] = BZ["Durotar"],
	[15] = BZ["Duskwood"],
	[16] = BZ["Dustwallow Marsh"],
	[17] = BZ["Eastern Plaguelands"],
	[18] = BZ["Elwynn Forest"],
	[19] = BZ["Felwood"],
	[20] = BZ["Feralas"],
	[21] = BZ["Gnomeregan"],
	[22] = BZ["Hillsbrad Foothills"],
	[23] = BZ["Ironforge"],
	[24] = BZ["Loch Modan"],
	[25] = BZ["Moonglade"],
	[26] = BZ["Mulgore"],
	[27] = BZ["Naxxramas"],
	[28] = BZ["Orgrimmar"],
	[29] = BZ["Redridge Mountains"],
	[30] = BZ["Ruins of Ahn'Qiraj"],
	[31] = BZ["Silithus"],
	[32] = BZ["Silverpine Forest"],
	[33] = BZ["Stonetalon Mountains"],
	[34] = BZ["Stormwind City"],
	[35] = BZ["Stranglethorn Vale"],
	[36] = BZ["Swamp of Sorrows"],
	[37] = BZ["Tanaris"],
	[38] = BZ["Teldrassil"],
	[39] = BZ["The Barrens"],
	[40] = BZ["The Hinterlands"],
	[41] = BZ["Thousand Needles"],
	[42] = BZ["Thunder Bluff"],
	[43] = BZ["Tirisfal Glades"],
	[44] = BZ["Un'Goro Crater"],
	[45] = BZ["Undercity"],
	[46] = BZ["Wailing Caverns"],
	[47] = BZ["Western Plaguelands"],
	[48] = BZ["Westfall"],
	[49] = BZ["Wetlands"],
	[50] = BZ["Winterspring"],
	[51] = BZ["Stratholme"],
	[52] = BZ["Scholomance"],
-- Burning Crusade
	[53] = BZ["Hellfire Peninsula"],
	[54] = BZ["Eversong Woods"],
	[55] = BZ["Silvermoon City"],
	[56] = BZ["Karazhan"],
	[57] = BZ["Azuremyst Isle"],
	[58] = BZ["The Exodar"],
	[59] = BZ["Blade's Edge Mountains"],
	[60] = BZ["Shattrath City"],
	[61] = BZ["Netherstorm"],
	[62] = BZ["Ghostlands"],
	[63] = BZ["Old Hillsbrad Foothills"],
	[64] = BZ["Bloodmyst Isle"],
	[65] = BZ["Shadowmoon Valley"],
	[66] = BZ["Terokkar Forest"],
	[67] = BZ["Zangarmarsh"],
	[68] = BZ["Deadwind Pass"],
	[69] = BZ["Nagrand"],
	[70] = BZ["Black Temple"],
	[71] = BZ["Hyjal Summit"],
	[72] = BZ["Isle of Quel'Danas"],
}
TradeskillInfo.vars.factions = {
	[1] = FACTION_ALLIANCE,
	[2] = FACTION_HORDE,
	[3] = "",
	[4] = BF["Argent Dawn"],
	[5] = BF["Cenarion Circle"],
	[6] = BF["Thorium Brotherhood"],
	[7] = BF["Timbermaw Hold"],
	[8] = BF["Zandalar Tribe"],
-- Burning Crusade
	[9] = BF["Keepers of Time"],
	[10] = BF["The Scale of the Sands"],
	[11] = BF["The Violet Eye"],
	[12] = BF["Cenarion Expedition"],
	[13] = BF["Sporeggar"],
	[14] = BF["Thrallmar"],
	[15] = BF["Honor Hold"],
	[16] = BF["The Mag'har"],
	[17] = BF["Kurenai"],
	[18] = BF["The Consortium"],
	[19] = BF["The Scryers"],
	[20] = BF["The Aldor"],
	[21] = BF["The Sha'tar"],
	[22] = BF["Lower City"],
	[23] = BF["Ashtongue Deathsworn"],
	[24] = BF["Shattered Sun Offensive"],
}
-- Kurenai / The Mag'har
-- Honor Hold / Thrallmar
-- The Scryers / The Aldor

TradeskillInfo.vars.vendors = {
--      "name|zone|faction|location|comment"
	[1] = "Abigail Shiel|43|2|61,52",
	[2] = "Aendel Windspear|31|5|63,50",
	[3] = "Alchemist Pestlezugg|37|3|51,27",
	[4] = "Alexandra Bolero|34|1|43,74",
	[5] = "Algernon|45|2|52,74",
	[6] = "Amy Davenport|29|1|29,47",
	[7] = "Andrew Hilbert|32|2|43,40",
	[8] = "Androd Fadran|2|1|45,47",
	[9] = "Argent Quartermaster Hasana|43|4|83,68",
	[10] = "Argent Quartermaster Lightspark|47|4|43,84",
	[11] = "Balai Lok'Wein|16|2|36,31",
	[12] = "Bale|19|2|35,53",
	[13] = "Banalash|36|2|45,57",
	[14] = "Blimo Gadgetspring|4|3|46,90",
	[15] = "Blixrez Goodstitch|35|3|28,77",
	[16] = "Blizrik Buckshot|37|3|52,28",
	[17] = "Bliztik|15|3|18,54",
	[18] = "Bombus Finespindle|23|1|40,34",
	[19] = "Borya|28|2|63,51",
	[20] = "Brienna Starglow|20|1|89,46",
	[21] = "Bro'kin|1|3|38,39",
	[22] = "Bronk|20|2|76,43",
	[23] = "Catherine Leland|34|1|46,59",
	[24] = "Christoph Jeffcoat|22|2|63,19",
	[25] = "Clyde Ranthal|29|1|89,70",
	[26] = "Constance Brisboise|43|2|52,55",
	[27] = "Corporal Bluth|35|1|38,3",
	[28] = "Cowardly Crosby|35|3|27,83",
	[29] = "Crazk Sparks|35|3|28,77",
	[30] = "Dalria|3|1|36,52",
	[31] = "Daniel Bartlett|45|2|64,38",
	[32] = "Danielle Zipstitch|15|1|76,46",
	[33] = "Darian Singh|34|1|30,68",
	[34] = "Darnall|25|3|52,33",
	[35] = "Defias Profiteer|48|1|44,68",
	[36] = "Deneb Walker|2|1|27,59",
	[37] = "Derak Nightfall|22|2|62,20",
	[38] = "Dirge Quikcleave|37|3|53,28",
	[39] = "Drac Roughcut|24|1|36,49",
	[40] = "Drake Lindgren|18|1|83,67",
	[41] = "Drovnar Strongbrew|2|1|46,47",
	[42] = "Elynna|10|1|64,22",
	[43] = "Emrul Riknussun|23|1|60,38",
	[44] = "Erika Tate|34|1|76,37",
	[45] = "Evie Whirlbrew|50|3|61,38",
	[46] = "Fradd Swiftgear|49|1|26,26",
	[47] = "Fyldan|10|1|48,21",
	[48] = "Gagsprocket|39|3|63,36",
	[49] = "Gearcutter Cogspinner|23|1|68,43",
	[50] = "George Candarte|22|2|91,39",
	[51] = "Gharash|36|2|46,52",
	[52] = "Ghok'kah|16|2|36,31",
	[53] = "Gigget Zipcoil|40|3|35,39",
	[54] = "Gikkix|37|3|67,22",
	[55] = "Gina MacGregor|48|1|57,54",
	[56] = "Gloria Femmel|29|1|27,44",
	[57] = "Glyx Brewright|35|3|28,77",
	[58] = "Gnaz Blunderflame|35|3|51,35",
	[59] = "Gretta Ganter|13|1|31,44",
	[60] = "Grimtak|14|2|51,42",
	[61] = "Hagrus|28|2|46,46",
	[62] = "Hammon Karwn|2|1|47,48",
	[63] = "Harggan|40|1|14,45",
	[64] = "Harklan Moongrove|3|1|51,67",
	[65] = "Harlown Darkweave|3|1|18,59",
	[66] = "Harn Longcast|26|2|48,55",
	[67] = "Heldan Galesong|9|1|37,56",
	[68] = "Helenia Olden|16|1|66,52",
	[69] = "Himmik|50|3|61,39",
	[70] = "Hula'mahi|39|2|52,30",
	[71] = "Jabbey|37|3|67,22",
	[72] = "Jandia|41|2|46,51",
	[73] = "Janet Hommers|11|1|66,7",
	[74] = "Jangdor Swiftstrider|20|2|74,43",
	[75] = "Jannos Ironwill|2|1|46,48",
	[76] = "Jaquilina Dramet|35|3|36,11",
	[77] = "Jase Farlane|17|3|81,58",
	[78] = "Jazzrik|5|3|42,53",
	[79] = "Jeeda|33|2|47,62",
	[80] = "Jennabink Powerseam|49|1|8,56",
	[81] = "Jessara Cordell|34|1|44,64",
	[82] = "Jinky Twizzlefixxit|41|3|77,76",
	[83] = "Joseph Moore|45|2|71,59",
	[84] = "Jubie Gadgetspring|4|3|45,91",
	[85] = "Jun'ha|2|2|73,36",
	[86] = "Jutak|35|3|27,77",
	[87] = "Kaita Deepforge|34|1|56,17",
	[88] = "Kalldan Felmoon|46|3|",
	[89] = "Kania|31|5|52,40",
	[90] = "Keena|2|2|74,33",
	[91] = "Kelsey Yance|35|3|28,74",
	[92] = "Kendor Kabonka|34|1|75,37",
	[93] = "Khara Deepwater|24|1|40,39",
	[94] = "Khole Jinglepocket|34|1|56,60|Seasonal",
	[95] = "Kiknikle|39|3|42,38",
	[96] = "Killian Sanatha|32|2|33,18",
	[97] = "Kilxx|39|3|63,38",
	[98] = "Kireena|11|2|51,54",
	[99] = "Kithas|28|2|53,37",
	[100] = "Knaz Blunderflame|35|3|51,35",
	[101] = "Kor'geld|28|2|56,34",
	[102] = "Kriggon Talsone|48|1|37,89",
	[103] = "Krinkle Goodsteel|37|3|52,29",
	[104] = "Kulwia|33|2|46,60",
	[105] = "Kzixx|15|3|81,21",
	[106] = "Laird|9|1|37,44",
	[107] = "Lardan|3|1|34,49",
	[108] = "Leo Sarn|32|2|54,82",
	[109] = "Leonard Porter|47|1|43,84",
	[110] = "Lieutenant General Andorov|30|5|",
	[111] = "Lilly|32|2|43,50",
	[112] = "Lindea Rabonne|22|1|51,61",
	[113] = "Lizbeth Cromwell|45|2|81,31",
	[114] = "Logannas|20|1|33,44",
	[115] = "Lokhtos Darkbargainer|6|6|",
	[116] = "Lorelae Wintersong|25|3|48,40",
	[117] = "Magnus Frostwake|47|3|68,77|Quest",
	[118] = "Mahu|42|2|44,45",
	[119] = "Mallen Swain|22|2|62,21",
	[120] = "Malygen|19|1|62,26",
	[121] = "Maria Lumere|34|1|46,78",
	[122] = "Martine Tramblay|43|2|66,59",
	[123] = "Masat T'andr|36|3|25,31",
	[124] = "Master Craftsman Omarion|27|3|",
	[125] = "Mavralyn|9|1|37,41",
	[126] = "Mazk Snipeshot|35|3|28,75",
	[127] = "Meilosh|19|7|66,3",
	[128] = "Micha Yance|22|1|49,55",
	[129] = "Millie Gregorian|45|2|71,30",
	[130] = "Mishta|31|5|50,36",
	[131] = "Montarr|41|2|45,50",
	[132] = "Muuran|11|2|56,56",
	[133] = "Mythrin'dir|10|1|61,18",
	[134] = "Naal Mistrunner|42|2|52,52",
	[135] = "Namdo Bizzfizzle|21|1|",
	[136] = "Nandar Branson|22|1|50,57",
	[137] = "Nardstrum Copperpinch|45|2|69,40|Seasonal",
	[138] = "Narj Deepslice|2|1|46,48",
	[139] = "Narkk|35|3|28,74",
	[140] = "Nata Dawnstrider|42|2|45,40",
	[141] = "Nergal|44|3|43,8",
	[142] = "Nerrist|35|2|32,29",
	[143] = "Nessa Shadowsong|38|1|56,92",
	[144] = "Nina Lightbrew|7|1|67,18",
	[145] = "Nioma|40|1|13,43",
	[146] = "Nyoma|38|1|57,60",
	[147] = "Ogg'marr|16|2|36,31",
	[148] = "Old Man Heming|35|3|27,77",
	[149] = "Otho Moji'ko|40|2|80,80",
	[150] = "Outfitter Eric|23|1|43,29",
	[151] = "Penney Copperpinch|28|2|53,67|Seasonal",
	[152] = "Plugger Spazzring|6|3|",
	[153] = "Pratt McGrubben|20|1|30,42",
	[154] = "Qia|50|3|61,37",
	[155] = "Quartermaster Miranda Breechlock|17|4|82,60",
	[156] = "Ranik|39|3|62,39",
	[157] = "Rann Flamespinner|24|1|36,46",
	[158] = "Rartar|36|2|45,57",
	[159] = "Rikqiz|35|3|28,76",
	[160] = "Rin'wosho the Trader|35|8|15,16",
	[161] = "Rizz Loosebolt|1|3|47,35",
	[162] = "Ronald Burch|45|2|63,44",
	[163] = "Ruppo Zipcoil|40|3|34,38",
	[164] = "Saenorion|10|1|63,22",
	[165] = "Seersa Copperpinch|42|2|44,59|Seasonal",
	[166] = "Sewa Mistrunner|42|2|56,48",
	[167] = "Shandrina|3|1|50,67",
	[168] = "Shankys|28|2|69,30",
	[169] = "Sheendra Tallgrass|20|2|74,43",
	[170] = "Shen'dralar Provisioner|12|3|",
	[171] = "Sheri Zipstitch|15|1|76,46",
	[172] = "Smudge Thunderwood|22|3|84,19",
	[173] = "Soolie Berryfizz|23|1|67,55",
	[174] = "Sovik|28|2|75,25",
	[175] = "Stuart Fleming|49|1|8,58",
	[176] = "Sumi|28|2|82,23",
	[177] = "Super-Seller 680|11|3|41,79|Intermittent",
	[178] = "Tamar|28|2|63,44",
	[179] = "Tansy Puddlefizz|23|1|48,6",
	[180] = "Tarban Hearthgrain|39|2|56,32",
	[181] = "Tari'qa|39|2|52,31",
	[182] = "Thaddeus Webb|45|2|62,61",
	[183] = "Tharynn Bouden|18|1|42,67",
	[184] = "Tilli Thistlefuzz|23|1|61,44",
	[185] = "Truk Wildbeard|40|1|14,42",
	[186] = "Tunkk|2|2|74,35",
	[187] = "Ulthaan|3|1|50,67",
	[188] = "Ulthir|10|1|56,24",
	[189] = "Uthok|35|2|31,28",
	[190] = "Vaean|10|1|58,15",
	[191] = "Valdaron|9|1|38,41",
	[192] = "Vargus|31|5|51,39",
	[193] = "Veenix|33|3|58,52",
	[194] = "Vendor-Tron 1000|11|3|61,38|Intermittent",
	[195] = "Vharr|35|2|32,29",
	[196] = "Vivianna|20|1|31,43",
	[197] = "Vizzklick|37|3|51,27",
	[198] = "Wenna Silkbeard|49|1|26,26",
	[199] = "Werg Thickblade|43|2|83,70",
	[200] = "Wik'Tar|3|2|12,34",
	[201] = "Worb Strongstitch|20|2|74,43",
	[202] = "Wrahk|39|2|53,31",
	[203] = "Wulan|11|2|27,70",
	[204] = "Wulmort Jinglepocket|23|1|33,67|Seasonal",
	[205] = "Wunna Darkmane|26|2|46,58",
	[206] = "Xandar Goodbeard|24|1|83,63",
	[207] = "Xen'to|28|2|57,53",
	[208] = "Xizk Goodstitch|35|3|28,76",
	[209] = "Xizzer Fizzbolt|50|3|61,39",
	[210] = "Yonada|39|2|45,60",
	[211] = "Yuka Screwspigot|8|3|66,23",
	[212] = "Zan Shivsproket|22|3|84,18",
	[213] = "Zannok Hidepiercer|31|3|82,18",
	[214] = "Zansoa|14|2|57,73",
	[215] = "Zarena Cromwind|35|3|28,75",
	[216] = "Zargh|39|2|53,30",
	[217] = "Zixil|22|3|61,21|Roving",
	[218] = "Zorbin Fandazzle|20|3|45,43|Quest",
	[219] = "Crimson Battle Mage|51|3",
	[220] = "Spectral Researcher|52|3",
	[221] = "Scholomance Dark Summoner|52|3",
	[222] = "Blackrock Battlemaster|8|3",
	[223] = "Ghoul Ravener|51|3",
-- Burning Crusade
	[224] = "Deynna|55|2|56,50",
	[225] = "Eiin|60|3|66,68",
	[226] = "Neii|58|1|64,68",
	[227] = "Borto|69|1|53,72",
	[228] = "Mathar G'ochar|69|2|55,37",
	[229] = "Andrion Darkspinner|60|3|66,68",
	[230] = "Arrond|65|2|56,58",
	[231] = "Nasmara Moonsong|60|3|66,69",
	[232] = "Gidge Spellweaver|60|3|66,69",
	[233] = "Karaaz|61|18|44,34",
	[234] = "Nakodu|60|22|62,69",
	[235] = "Quartermaster Endarin|60|20|48,26",
	[236] = "Quartermaster Enuril|60|19|61,64",
	[237] = "Fedryen Swiftspear|67|12|79,64",
	[238] = "Muheru the Weaver|67|1|41,28",
	[239] = "Zurai|67|2|85,55",
	[240] = "Koren|56|11|",
	[241] = "Krek Cragcrush|65|2|29,31",
	[242] = "Loolruna|67|1|69,50",
	[243] = "Aaron Hollman|60|3|64,71",
	[244] = "Arras|58|1|61,90",
	[245] = "Eriden|55|2|80,36",
	[246] = "Mari Stonehand|65|1|37,55",
	[247] = "Rohok|53|2|53,38",
	[248] = "Quartermaster Urgronn|53|14|55,38",
	[249] = "Logistics Officer Ulrike|53|15|57,63",
	[250] = "Halruun|67|1|68,48",
	[251] = "Haalrun|67|1|68,48",
	[252] = "Seer Janidi|67|2|32,52",
	[253] = "Daga Ramba|59|2|51,58",
	[254] = "Alurmi|37|9|64,58",
	[255] = "Almaador|60|21|50,42",
	[256] = "Mycah|67|3|18,51",
	[257] = "Trader Narasu|69|17|55,75",
	[258] = "Altaa|58|1|28,63",
	[259] = "Melaris|55|2|67,20",
	[260] = "Skreah|60|3|46,20",
	[261] = "Alchemist Gribble|53|1|54,66",
	[262] = "Apothecary Antonivich|53|2|52,37",
	[263] = "Leeli Longhaggle|66|1|58,53",
	[264] = "Burko|53|1|22,39",
	[265] = "Aresella|53|2|26,62",
	[266] = "Baxter|53|2|56,41|Mobile",
	[267] = "Gaston|53|1|54,64",
	[268] = "Naka|67|3|79,63",
	[269] = "Landraelanis|54|2|49,47",
	[270] = "Master Chef Mouldier|62|2|48,31",
	[271] = "Innkeeper Grilka|66|2|49,45",
	[272] = "Supply Officer Mills|66|1|56,53",
	[273] = "Doba|67|1|42,28",
	[274] = "Gambarinka|67|2|32,49",
	[275] = "Fazu|64|1|54,56",
	[276] = "Innkeeper Biribi|66|1|57,53",
	[277] = "Rungor|66|2|49,46",
	[278] = "Nula the Butcher|69|2|58,36",
	[279] = "Uriku|69|1|56,73",
	[280] = "Cookie One-Eye|53|2|55,41",
	[281] = "Sid Limbardi|53|1|54,64",
	[282] = "Arred|58|1|45,26",
	[283] = "Gelanthis|55|2|91,74",
	[284] = "Neal Allen|49|1|11,57",
	[285] = "Felika|28|2|51,36|Roving",
	[286] = "Edna Mullby|34|1|58,61",
	[287] = "Burbik Gearspanner|23|1|47,27",
	[288] = "Felicia Doan|45|2|64,50",
	[289] = "Shadi Mistrunner|42|2|40,64",
	[290] = "Apprentice Darius|68|11|47,75",
	[291] = "Kalaen|53|2|57,38",
	[292] = "Tatiana|53|1|55,64",
	[293] = "Feera|58|1|54,91",
	[294] = "Viggz Shinesparked|60|3|65,69",
	[295] = "Yatheon|55|2|76,40",
	[296] = "Daggle Ironshaper|65|1|37,54",
	[297] = "Mixie Farshot|53|2|61,82",
	[298] = "Wind Trader Lathrai|60|3|72,30",
	[299] = "Lebowski|53|1|56,66",
	[300] = "Captured Gnome|67|2|33,48",
	[301] = "Provisioner Nasela|69|16|54,37",
	[302] = "Haferet|58|1|66,75",
	[303] = "Zaralda|55|2|84,79",
	[304] = "Cro Threadstrong|60|3|67,67",
	[305] = "Thomas Yance|63|3|",
	[306] = "Juno Dufrain|67|3|78,66",
	[307] = "Vodesiin|53|1|24,38",
	[308] = "Andormu|37|10|58,59",
	[309] = "Aged Dalaran Wizard|63|3|",
	[310] = "Madame Ruby|60|3|63,70",
	[311] = "Egomis|58|1|39,40",
	[312] = "Lyna|55|2|69,24",
    [313] = "Okuno|70|23",
    [314] = "Indormi|71|10",
    [315] = "Eldara Dawnrunner|72|24",
    [316] = "Shaani|72|24",
}
TradeskillInfo.vars.recipes = {
-- factionrank: 4 Neutral, 5 Friendly, 6 Honored, 7 Revered, 8 Exalted
-- [recipe] = "result|source|price|factionrank"
	[728] = "733|V92Qa|200",
	[2406] = "2307|D",
	[2407] = "2311|D",
	[2408] = "2312|D",
	[2409] = "2317|D",
	[2553] = "2457|D",
	[2555] = "2459|D",
	[2598] = "2572|D",
	[2601] = "2585|D",
	[2697] = "724|V92Qa|400",
	[2698] = "2682|V92|400",
	[2699] = "1082|V92Qa|800",
	[2700] = "2685|V92D|400",
	[2701] = "1017|V92Qa|1600",
	[2881] = "2864|D",
	[2882] = "3481|D",
	[2883] = "3490|D",
	[2889] = "2888|V92Qa|240",
	[3393] = "3384|D",
	[3394] = "3386|D",
	[3395] = "3387|D",
	[3396] = "3390|D",
	[3608] = "3492|D",
	[3609] = "3471|QaD",
	[3610] = "3474|D",
	[3611] = "3484|D",
	[3612] = "3485|D",
	[3678] = "3662|V92Qa|400",
	[3679] = "3220|V92Qa|400",
	[3680] = "3663|V92Qa|1600",
	[3681] = "3664|V92Qa|1600",
	[3682] = "3665|V92V90V142Qa|1600",
	[3683] = "3666|V92Qa|1600",
	[3734] = "3726|V187V177Qh|1600",
	[3735] = "3727|V216V194Qh|1800",
	[3736] = "3728|Qa",
	[3737] = "3729|Q",
	[3830] = "3825|D",
	[3831] = "3826|D",
	[3832] = "3828|D",
	[3866] = "3850|D",
	[3867] = "3852|D",
	[3868] = "3854|D",
	[3869] = "3856|D",
	[3870] = "3840|D",
	[3871] = "3841|D",
	[3872] = "3843|D",
	[3873] = "3845|D",
	[3874] = "3846|D",
	[3875] = "3847|D",
	[4292] = "4241|D",
	[4293] = "4244|D",
	[4294] = "4250|D",
	[4296] = "4252|D",
	[4297] = "4254|D",
	[4298] = "4258|D",
	[4299] = "4256|D",
	[4300] = "4260|D",
	[4301] = "4264|D",
	[4345] = "4313|D",
	[4346] = "4311|D",
	[4347] = "4315|D",
	[4348] = "4331|D",
	[4349] = "4317|D",
	[4350] = "4321|D",
	[4351] = "4323|D",
	[4352] = "4325|D",
	[4353] = "4328|D",
	[4354] = "4335|D",
	[4355] = "4327|V128V52|1500",
	[4356] = "4329|D",
	[4408] = "4401|D",
	[4409] = "4367|D",
	[4410] = "4373|D",
	[4411] = "4376|D",
	[4412] = "4383|D",
	[4413] = "4388|D",
	[4414] = "4403|D",
	[4415] = "4393|D",
	[4416] = "4395|D",
	[4417] = "4398|D",
	[4597] = "4596|Qh",
	[4609] = "4457|V138V177Q|1000",
	[4624] = "4623|Q",
	[5083] = "5081|Qh",
	[5482] = "5472|Qa",
	[5483] = "5473|V60|140",
	[5484] = "5474|V205|240",
	[5485] = "5476|V106|400",
	[5486] = "5477|V181QQa|440",
	[5487] = "5478|Qh",
	[5488] = "5479|V181|400",
	[5489] = "5480|V187V194|1200",
	[5528] = "5526|V67V102|800",
	[5543] = "5541|D",
	[5578] = "2869|D",
	[5640] = "5631|V35V206V61V156|100",
	[5642] = "5634|V173V188V101V194|1800",
	[5643] = "5633|V188V61V194|2000",
	[5771] = "5762|V55V191V7V118|200",
	[5772] = "5763|V6V80V157V191V19V118V129V202V210V95V217|500",
	[5773] = "5770|D",
	[5774] = "5764|D",
	[5775] = "5765|D",
	[5786] = "5780|V55V125V7D|550",
	[5787] = "5781|V55V125V7D|600",
	[5788] = "5782|V128V24V15D|650",
	[5789] = "5783|V68V15D|2800",
	[5972] = "5958|D",
	[5973] = "5963|V62V107V72V90V194D|650",
	[5974] = "5965|D",
	[6039] = "6038|V91|5000",
	[6044] = "6042|D",
	[6045] = "6043|D",
	[6046] = "6041|D",
	[6047] = "3837|V103|4400",
	[6053] = "6051|V206V70V105|800",
	[6054] = "6048|V64V24|900",
	[6055] = "6049|V136V79|1500",
	[6056] = "6050|V41V57|2000",
	[6057] = "6052|V114V22V57V3|2000",
	[6068] = "3824|V131V17|1500",
	[6211] = "3391|D",
	[6270] = "6240|V183V191V19V26V202|200",
	[6271] = "6239|D",
	[6272] = "6242|V40V42V7V202V156|300",
	[6274] = "6263|V55V4V19V119V210|400",
	[6275] = "6264|V42V80V157V171V129V156|800",
	[6325] = "6290|V23V59V93V146V183V66V122V166V113|40",
	[6326] = "787|V102V143V179V122V214|40",
	[6328] = "4592|V93V146V179V183V66V96V134V113|400",
	[6329] = "6316|V93|400",
	[6330] = "4593|V23V112V37V134V166V162V97|1200",
	[6342] = "-7443|V81V184V190V99V108V111V140V182V89|300",
	[6344] = "-7766|D",
	[6346] = "-7776|V99V111|400",
	[6347] = "-7782|D",
	[6348] = "-7786|D",
	[6349] = "-7793|V184V99V108V140|500",
	[6368] = "5095|V23V67V102V143V175V96V168V214V162V97|400",
	[6369] = "4594|V67V112V175V179V168V200V203V91V113|2200",
	[6375] = "-7859|D",
	[6377] = "-7867|V140V217|1000",
	[6390] = "6384|D",
	[6391] = "6385|D",
	[6401] = "4333|V171V119V177|1100",
	[6454] = "6453|D",
	[6474] = "6466|V88|550",
	[6475] = "6467|V88|1500",
	[6476] = "6468|Q",
	[6661] = "6657|D",
	[6663] = "6662|D",
	[6672] = "4852|D",
	[6710] = "6709|Qa",
	[6716] = "6714|D",
	[6735] = "6731|Qa",
	[6892] = "6890|V39V7|250",
	[7084] = "7059|D",
	[7085] = "7060|D",
	[7086] = "7061|D",
	[7087] = "7056|V177V208|1200",
	[7088] = "7063|V197|5000",
	[7089] = "7053|V20V85|1500",
	[7090] = "7065|D",
	[7091] = "7049|D",
	[7092] = "7047|D",
	[7114] = "4319|V198V98|1000",
	[7192] = "7189|D",
	[7288] = "7280|D",
	[7289] = "7283|V25D|650",
	[7290] = "7284|V198D|1600",
	[7360] = "4248|D",
	[7361] = "7349|V65D|1800",
	[7362] = "7352|V217|2000",
	[7363] = "7358|D",
	[7364] = "7359|D",
	[7449] = "7373|D",
	[7450] = "7375|D",
	[7451] = "7386|V153V164V74V83V194D|2800",
	[7452] = "7390|D",
	[7453] = "7391|D",
	[7560] = "7506|V49V82|1200",
	[7561] = "7148|V105V177V193V217|2000",
	[7613] = "4255|V198V50V194D|2000",
	[7742] = "4397|V212|2400",
	[7975] = "7921|D",
	[7976] = "7967|D",
	[7978] = "7913|Qh",
	[7979] = "7914|Qh",
	[7980] = "7915|Qh",
	[7981] = "7916|Qh",
	[7982] = "7917|Qh",
	[7983] = "7926|Q",
	[7984] = "7927|Q",
	[7985] = "7928|Q",
	[7989] = "7969|D",
	[7990] = "7934|D",
	[7991] = "7932|D",
	[7992] = "7942|D",
	[7993] = "7944|D",
	[7995] = "7924|V63V51|6000",
	[8028] = "7946|D",
	[8029] = "7943|D",
	[8030] = "7947|V117D|10000",
	[8384] = "8174|D",
	[8385] = "8187|V153V74|3500",
	[8386] = "8200|D",
	[8387] = "8201|D",
	[8389] = "8202|D",
	[8390] = "8216|D",
	[8395] = "8203|D",
	[8397] = "8205|D",
	[8398] = "8204|D",
	[8399] = "8209|D",
	[8400] = "8207|D",
	[8401] = "8206|D",
	[8402] = "8208|D",
	[8403] = "8210|Q",
	[8404] = "8211|Q",
	[8405] = "8214|Q",
	[8406] = "8213|Q",
	[8407] = "8212|Q",
	[8408] = "8215|Q",
	[8409] = "8192|V145V74V201D|4000",
	[9293] = "9036|D",
	[9294] = "9144|D",
	[9295] = "9172|D",
	[9296] = "9088|D",
	[9297] = "9197|D",
	[9298] = "9206|D",
	[9300] = "9224|V144V158|10000",
	[9301] = "9264|V121V5|10000",
	[9302] = "9210|V114V22|9000",
	[9303] = "9149|V3|8000",
	[9304] = "1|V3|8000",
	[9305] = "2|V3|8000",
	[9367] = "9366|Qa",
	[10300] = "10007|D",
	[10301] = "10008|D",
	[10302] = "10009|D",
	[10311] = "10052|V42V118|3000",
	[10312] = "10018|D",
	[10314] = "10054|V150V19|4000",
	[10315] = "10029|D",
	[10316] = "10048|D",
	[10317] = "10055|V150V19|4000",
	[10318] = "10030|V28|7000",
	[10320] = "10033|D",
	[10321] = "10034|V150V129|4500",
	[10323] = "10035|V150V129|4500",
	[10325] = "10040|V4V118|10000",
	[10326] = "10036|V150V129|5000",
	[10424] = "10423|D",
	[10463] = "10025|Q",
	[10601] = "10499|D",
	[10602] = "10546|V100V211|3000",
	[10603] = "10501|D",
	[10604] = "10510|D",
	[10605] = "10502|D",
	[10606] = "10518|D",
	[10607] = "10506|V84|3600",
	[10608] = "10548|D",
	[10609] = "10576|V163|4000",
	[10644] = "9061|",
	[10713] = "9060|C",
	[10728] = "4336|V139|1500",
	[10858] = "3851|V75V132V78|3000",
	[11038] = "-13380|D",
	[11039] = "-13419|V30V104|800",
	[11081] = "-13464|D",
	[11098] = "-13522|D",
	[11101] = "-13536|V30V104|2500",
	[11150] = "-13612|D",
	[11151] = "-13617|D",
	[11152] = "-13620|D",
	[11163] = "-13646|V128V90|3000",
	[11164] = "-13653|D",
	[11165] = "-13655|D",
	[11166] = "-13698|D",
	[11167] = "-13687|D",
	[11168] = "-13689|D",
	[11202] = "-13817|D",
	[11203] = "-13841|D",
	[11204] = "-13846|D",
	[11205] = "-13868|D",
	[11206] = "-13882|D",
	[11207] = "-13898|D",
	[11208] = "-13915|D",
	[11223] = "-13931|V133V13|5800",
	[11224] = "-13933|D",
	[11225] = "-13945|D",
	[11226] = "-13947|D",
	[11610] = "11608|D",
	[11611] = "11607|D",
	[11612] = "11604|D",
	[11614] = "11606|D",
	[11615] = "11605|D",
	[11813] = "-15596|D",
	[11827] = "11826|D",
	[11828] = "11825|D",
	[12162] = "3849|V87V176V86|3000",
	[12163] = "3853|V215|4400",
	[12164] = "3855|V195V76|4400",
	[12226] = "12224|V1|25",
	[12227] = "12209|V177|1600",
	[12228] = "12210|V27V62V68V90V142V147V194|5000",
	[12229] = "13851|V196V169V177|5000",
	[12231] = "12212|V27V142V194|3000",
	[12232] = "12213|V13V98V147V194|5000",
	[12233] = "12214|V68V73V177|3000",
	[12239] = "12217|V68V147V177|7000",
	[12240] = "12215|V73V98V194|7000",
	[12261] = "12260|D",
	[12682] = "12405|D",
	[12683] = "12406|D",
	[12684] = "12408|D",
	[12685] = "12416|D",
	[12687] = "12428|Q",
	[12688] = "12424|Q",
	[12689] = "12415|D",
	[12690] = "12425|Q",
	[12691] = "12624|D",
	[12692] = "12645|D",
	[12693] = "12409|D",
	[12694] = "12410|D",
	[12695] = "12418|D",
	[12696] = "12628|Q",
	[12697] = "12419|D",
	[12699] = "12631|Q",
	[12700] = "12426|Q",
	[12701] = "12427|Q",
	[12702] = "12417|D",
	[12703] = "12632|V117D|40000",
	[12704] = "12414|D",
	[12705] = "12422|Q",
	[12706] = "12610|D",
	[12707] = "12611|D",
	[12711] = "12633|D",
	[12713] = "12420|D",
	[12714] = "12612|D",
	[12715] = "12429|Q",
	[12716] = "12636|D",
	[12717] = "12640|D",
	[12718] = "12613|D",
	[12719] = "12614|D",
	[12720] = "12639|D",
	[12725] = "12620|Q",
	[12726] = "12619|Q",
	[12727] = "12618|Q",
	[12728] = "12641|D",
	[12819] = "12773|V117D|16000",
	[12821] = "12774|Q",
	[12823] = "12775|V117D|20000",
	[12824] = "12776|Q",
	[12825] = "12777|Q",
	[12827] = "12781|D",
	[12828] = "12792|D",
	[12830] = "12782|D",
	[12833] = "12796|D",
	[12834] = "12790|D",
	[12835] = "12798|D",
	[12836] = "12797|D",
	[12837] = "12794|D",
	[12838] = "12784|D",
	[12839] = "12783|D",
	[12958] = "3|V3|50000",
	[13287] = "4455|V186|2500",
	[13288] = "4456|V8D|2500",
	[13308] = "4386|V161V177|1800",
	[13309] = "4372|V46V82|1000",
	[13310] = "4407|V126V177|2000",
	[13311] = "4396|V58|10000",
	[13476] = "13442|D",
	[13477] = "13443|V188V5|12000",
	[13478] = "13445|V173V101|13000",
	[13479] = "13447|D",
	[13480] = "13446|V45|15000",
	[13481] = "13453|D",
	[13482] = "6|V9V10V155|15000|6",
	[13483] = "4|V152|15000",
	[13484] = "7|V127|15000|5",
	[13485] = "9|V117|15000",
	[13486] = "8|D",
	[13487] = "11|D",
	[13488] = "5|D",
	[13489] = "10|D",
	[13490] = "13455|D",
	[13491] = "13452|D",
	[13492] = "13462|D",
	[13493] = "13454|D",
	[13494] = "13457|D",
	[13495] = "13456|D",
	[13496] = "13458|D",
	[13497] = "13461|D",
	[13499] = "13459|D",
	[13501] = "13444|V117|30000",
	[13518] = "13506|D",
	[13519] = "13510|D",
	[13520] = "13511|D",
	[13521] = "13512|D",
	[13522] = "13513|D",
	[13939] = "6887|V54|16000",
	[13940] = "13927|V91|16000",
	[13941] = "13930|V91|16000",
	[13942] = "13928|V54|16000",
	[13943] = "13929|V91|16000",
	[13945] = "13931|V54|20000",
	[13946] = "13932|V54|20000",
	[13947] = "13933|V196V169|20000",
	[13948] = "13934|V196V169|20000",
	[13949] = "13935|V196V169|20000",
	[14466] = "13869|D",
	[14467] = "13868|D",
	[14468] = "14046|V154|12000",
	[14469] = "13858|V34|12000",
	[14470] = "13857|D",
	[14471] = "14042|D",
	[14472] = "13860|V34|12000",
	[14473] = "14143|D",
	[14474] = "13870|D",
	[14476] = "14043|D",
	[14477] = "14142|D",
	[14478] = "14100|D",
	[14479] = "14101|D",
	[14480] = "14141|D",
	[14481] = "13863|V154|16000",
	[14482] = "14044|D",
	[14483] = "14107|V116|16000",
	[14484] = "14103|D",
	[14485] = "14132|D",
	[14486] = "14134|D",
	[14488] = "13864|V34|12000",
	[14489] = "13871|D",
	[14490] = "14045|D",
	[14491] = "13865|D",
	[14492] = "14108|D",
	[14493] = "14136|D",
	[14494] = "14104|D",
	[14495] = "14144|D",
	[14496] = "14111|D",
	[14497] = "14137|D",
	[14498] = "13866|D",
	[14499] = "14155|D",
	[14500] = "14128|D",
	[14501] = "14138|D",
	[14504] = "13867|D",
	[14505] = "14130|D",
	[14506] = "14106|D",
	[14507] = "14139|D",
	[14508] = "14112|D",
	[14509] = "14140|D",
	[14510] = "14156|D",
	[14511] = "14146|D",
	[14512] = "14154|D",
	[14513] = "14152|D",
	[14514] = "14153|D",
	[14526] = "14342|V154V45|20000",
	[14627] = "4332|V32|800",
	[14630] = "4322|V177V208|1000",
	[14634] = "3829|V21|2500",
	[14635] = "4262|V159V194|3000",
	[14639] = "4381|V46V135|1500",
	[15724] = "15077|V213|12000",
	[15725] = "15083|V109V199|12000",
	[15726] = "15045|V123|12000",
	[15727] = "15076|D",
	[15728] = "15084|D",
	[15729] = "15074|V14D|12000",
	[15730] = "15047|D",
	[15731] = "15091|D",
	[15732] = "15054|D",
	[15733] = "15046|D",
	[15734] = "15061|V153V74D|14000",
	[15735] = "15067|V53D|14000",
	[15737] = "15073|D",
	[15738] = "15078|D",
	[15739] = "15092|D",
	[15740] = "15071|V154|16000",
	[15741] = "15057|V109V199D|16000",
	[15743] = "15082|D",
	[15744] = "15086|D",
	[15745] = "15093|D",
	[15746] = "15072|D",
	[15747] = "15069|D",
	[15748] = "15079|D",
	[15749] = "15053|D",
	[15751] = "15048|V14D|20000",
	[15752] = "15060|D",
	[15753] = "15056|D",
	[15755] = "15075|D",
	[15756] = "15094|V77|22000",
	[15757] = "15087|D",
	[15758] = "15063|V141|22000",
	[15759] = "15050|V152|22000",
	[15760] = "15066|D",
	[15761] = "15070|D",
	[15762] = "15080|V213|25000",
	[15763] = "15049|D",
	[15764] = "15058|D",
	[15765] = "15095|D",
	[15768] = "15088|D223",
	[15770] = "15051|D",
	[15771] = "15059|D",
	[15772] = "15062|D",
	[15773] = "15085|D220",
	[15774] = "15081|D222",
	[15775] = "15055|D",
	[15776] = "15090|D221",
	[15777] = "15096|D219",
	[15779] = "15068|D",
	[15781] = "15052|D",
	[16041] = "15993|V49V174|12000",
	[16042] = "15994|V49V174|12000",
	[16043] = "15995|D",
	[16044] = "15996|D",
	[16045] = "15999|D",
	[16046] = "16023|V209|16000",
	[16047] = "16000|V209|16000",
	[16048] = "16004|D",
	[16049] = "16005|D",
	[16050] = "16006|V209|20000",
	[16051] = "15997|D",
	[16052] = "16009|D",
	[16053] = "16008|D",
	[16054] = "16022|D",
	[16055] = "16040|D",
	[16056] = "16007|D",
	[16072] = "0|V167V203|10000",
	[16083] = "0|V148|10000",
	[16084] = "0|V36V11V52|10000",
	[16110] = "12218|V120V12V69V154|12000",
	[16111] = "12216|V102V13V189|12000",
	[16112] = "6451|V36V11V52|2200",
	[16113] = "8544|V36V11V52|5000",
	[16214] = "-20008|D",
	[16215] = "-20020|D",
	[16216] = "-20014|D",
	[16217] = "-20017|V133V31|12000",
	[16218] = "-20009|D",
	[16219] = "-20012|D",
	[16220] = "-20024|D",
	[16221] = "-20026|V154|16000",
	[16222] = "-20016|D",
	[16223] = "-20029|D",
	[16224] = "-20015|V116|20000",
	[16242] = "-20028|D",
	[16243] = "-20051|V116|22000",
	[16244] = "-20013|D",
	[16245] = "-20023|D",
	[16246] = "-20010|D",
	[16247] = "-20030|D",
	[16248] = "-20033|D",
	[16249] = "-20036|D",
	[16250] = "-20031|D",
	[16251] = "-20011|D",
	[16252] = "-20034|D",
	[16253] = "-20025|D",
	[16254] = "-20032|D",
	[16255] = "-20035|D",
	[16767] = "16766|V71|3000",
	[17017] = "16980|V115|180000|6",
	[17018] = "16979|V115|80000|5",
	[17022] = "16982|V115|150000|5",
	[17023] = "16983|V115|160000|5",
	[17025] = "16984|V115|160000|6",
	[17049] = "16989|V115|90000|6",
	[17051] = "17014|V115|70000|5",
	[17052] = "17013|V115|180000|8",
	[17053] = "16988|V115|200000|7",
	[17059] = "17015|V115|220000|6",
	[17060] = "17016|V115|220000|8",
	[17062] = "8364|V67V112V175V179V168V200V203V91V113|2200",
	[17200] = "17197|V94V204V151V165V137|25",
	[17201] = "17198|V94V204V151V165V137|240",
	[17706] = "17704|D",
	[17709] = "17708|D",
	[17720] = "17716|D",
	[17722] = "17721|D",
	[17724] = "17723|Q",
	[17725] = "-21931|D",
	[18046] = "18045|V185V38|12000",
	[18160] = "7676|V172Q|200",
	[18239] = "18238|V159|3500",
	[18252] = "18251|D",
	[18257] = "18253|D",
	[18259] = "-22749|D",
	[18260] = "-22750|D",
	[18264] = "18262|D",
	[18265] = "18263|D",
	[18267] = "18254|D",
	[18290] = "18283|D",
	[18291] = "18168|D",
	[18292] = "18282|D",
	[18414] = "18405|D",
	[18415] = "18407|D",
	[18416] = "18408|D",
	[18417] = "18409|D",
	[18418] = "18413|D",
	[18487] = "18486|V170|40000",
	[18514] = "18504|D",
	[18515] = "18506|D",
	[18516] = "18508|D",
	[18517] = "18509|D",
	[18518] = "18510|D",
	[18519] = "18511|D",
	[18592] = "17193|Q",
	[18647] = "9318|V174|1800",
	[18648] = "9313|V29V48|1800",
	[18649] = "9312|V33V49|1800",
	[18650] = "18588|V16|5000",
	[18651] = "18631|V126|12000",
	[18652] = "18634|V209|12000",
	[18653] = "18587|D",
	[18654] = "18645|D",
	[18655] = "18637|D",
	[18656] = "18594|V209|16000",
	[18657] = "18638|D",
	[18658] = "18639|D",
	[18661] = "18660|D",
	[18731] = "18662|V18V178D|2000",
	[18949] = "18948|V164V83D|2000",
	[19027] = "19026|V218|5000",
	[19202] = "19043|V127|22000|6",
	[19203] = "19051|V9V10V155|22000|6",
	[19204] = "19048|V127|40000|7",
	[19205] = "19057|V9V10V155|40000|7",
	[19206] = "19148|V115|60000|7",
	[19207] = "19164|V115|80000|7",
	[19208] = "19166|V115|70000|7",
	[19209] = "19167|V115|70000|8",
	[19210] = "19170|V115|120000|8",
	[19211] = "19168|V115|120000|8",
	[19212] = "19169|V115|120000|8",
	[19215] = "19047|V127|22000|6",
	[19216] = "19056|V9V10V155|22000|6",
	[19217] = "19059|V9V10V155|40000|7",
	[19218] = "19050|V127|40000|7",
	[19219] = "19156|V115|60000|6",
	[19220] = "19165|V115|90000|7",
	[19326] = "19044|V127|22000|6",
	[19327] = "19049|V127|40000|7",
	[19328] = "19052|V9V10V155|22000|6",
	[19329] = "19058|V9V10V155|40000|7",
	[19330] = "19149|V115|60000|7",
	[19331] = "19157|V115|90000|7",
	[19332] = "19162|V115|90000|7",
	[19333] = "19163|V115|90000|7",
	[19442] = "19440|V9V10V155|100000|6D",
	[19444] = "-23799|V115|30000|7",
	[19445] = "-23800|V127|30000|6",
	[19446] = "-23801|V9V10V155|30000|6",
	[19447] = "-23802|V9V10V155|60000|7",
	[19448] = "-23803|V115|80000|6",
	[19449] = "-23804|V115|100000|7",
	[19764] = "19682|V160|50000|7",
	[19765] = "19683|V160|50000|6",
	[19766] = "19684|V160|50000|5",
	[19769] = "19685|V160|50000|7",
	[19770] = "19686|V160|50000|6",
	[19771] = "19687|V160|50000|5",
	[19772] = "19688|V160|50000|7",
	[19773] = "19689|V160|50000|6",
	[19776] = "19690|V160|50000|7",
	[19777] = "19691|V160|50000|6",
	[19778] = "19692|V160|50000|5",
	[19779] = "19693|V160|50000|7",
	[19780] = "19694|V160|50000|6",
	[19781] = "19695|V160|50000|5",
	[20000] = "19999|V160|50000|6",
	[20001] = "19998|V160|50000|5",
	[20011] = "20007|V160|50000|7",
	[20012] = "20002|V160|50000|5",
	[20013] = "20008|V160|50000|8",
	[20014] = "20004|V160|50000|6",
	[20040] = "20039|V115|80000|8",
	[20075] = "20074|V147|2000",
	[20253] = "15064|V127|16000|5",
	[20254] = "15065|V127|20000|5",
	[20382] = "20380|V2|60000|8",
	[20506] = "20481|V2|40000|5",
	[20507] = "20480|V2|40000|6",
	[20508] = "20479|V2|40000|7",
	[20509] = "20476|V2|40000|5",
	[20510] = "20477|V2|40000|6",
	[20511] = "20478|V2|40000|7",
	[20546] = "20538|Q",
	[20547] = "20537|Q",
	[20548] = "20539|Q",
	[20553] = "20549|Q",
	[20554] = "20550|Q",
	[20555] = "20551|Q",
	[20576] = "20575|V6D|350",
	[20726] = "-25072|D",
	[20727] = "-25073|D",
	[20728] = "-25074|D",
	[20729] = "-25078|D",
	[20730] = "-25079|D",
	[20731] = "-25080|D",
	[20732] = "-25081|V89|90000|5",
	[20733] = "-25082|V89|90000|6",
	[20734] = "-25083|D",
	[20735] = "-25084|D",
	[20736] = "-25086|D",
	[20752] = "-25125|V190V89V81V108V140V182V184V99V111|3000",
	[20753] = "-25126|V140V111V184V99V182V89V190V81V108|4000",
	[20754] = "-25127|V89|10000",
	[20755] = "-25128|V89|20000",
	[20756] = "-25129|V160|40000|6",
	[20757] = "-25130|V160|40000|5",
	[20758] = "-25124|V89V190V81V108V140V182V99V184V111|500",
	[20761] = "12|V115|120000|5",
	[21025] = "21023|Q",
	[21099] = "21072|V47V203V37V128V43V207V56V44V91V146V180V149V134V162|500",
	[21219] = "21217|V47V203V37V128V43V207V56V44V91V146V180V149V134V162|5000",
	[21302] = "20844|D",
	[21358] = "21340|V197|12000",
	[21371] = "21342|D",
	[21547] = "21546|D",
	[21548] = "21278|D",
	[21722] = "21154|Q",
	[21723] = "21542|Q",
	[21724] = "21558|D",
	[21725] = "21559|D",
	[21726] = "21557|D",
	[21727] = "21589|D",
	[21728] = "21590|D",
	[21729] = "21592|D",
	[21730] = "21571|D",
	[21731] = "21574|D",
	[21732] = "21576|D",
	[21733] = "21714|D",
	[21734] = "21716|D",
	[21735] = "21718|D",
	[21737] = "21570|Q",
	[21738] = "21569|Q",
	[22209] = "22197|V192|50000|5",
	[22214] = "22195|V192|50000|6",
	[22219] = "22198|V110|50000|7",
	[22220] = "22194|D",
	[22221] = "22191|V110|80000|7",
	[22222] = "22196|D",
	[22307] = "22246|V190V81V108V140V182V99V184V111V89|6000",
	[22308] = "22248|V89|20000",
	[22309] = "22249|D",
	[22310] = "22251|V130|20000|5",
	[22312] = "22252|V130|50000|7",
	[22388] = "22385|D",
	[22389] = "22383|D",
	[22390] = "22384|D",
	[22392] = "-27837|V127|25000|5",
	[22683] = "22660|V130|90000|7",
	[22766] = "22762|V192|50000|7",
	[22767] = "22763|V192|50000|6",
	[22768] = "22764|V192|50000|5",
	[22769] = "22761|V2|50000|5",
	[22770] = "22760|V2|50000|6",
	[22771] = "22759|V2|50000|7",
	[22772] = "22758|V130|50000|5",
	[22773] = "22757|V130|50000|6",
	[22774] = "22756|V130|50000|7",
-- Burning Crusade
	[12698] = "12625|D",
	[13517] = "13503|V255|80000|7",
	[15769] = "15138|D",
	[20854] = "20830|V133V31V282V283|1800",
	[20855] = "20833|V30V156|1500",
	[20856] = "20831|V285V286V282V283|1500",
	[20970] = "20950|V72V284|1500",
	[20971] = "20954|V24V128|1500",
	[20973] = "20958|V128V98|2000",
	[20974] = "20966|D",
	[20975] = "20959|V287V288V282V283|2500",
	[20976] = "20967|D",
	[21892] = "21842|V224V225V226|40000",
	[21893] = "21843|V225V228|40000",
	[21894] = "21844|V224V226V227V228|40000",
	[21895] = "21845|V231|40000",
	[21896] = "21854|V224V225V226|40000",
	[21897] = "21855|V224V225V226|40000",
	[21898] = "21859|V238V239|60000",
	[21899] = "21860|V238V239|60000",
	[21900] = "21861|V230|60000",
	[21901] = "21862|V230|60000",
	[21902] = "21863|V227V228|80000",
	[21903] = "21864|D",
	[21904] = "21865|D",
	[21905] = "21866|D",
	[21906] = "21867|D",
	[21907] = "21868|D",
	[21908] = "21846|V232|60000",
	[21909] = "21847|V232|60000",
	[21910] = "21848|V232|60000",
	[21911] = "21858|V232|60000",
	[21912] = "21869|V229|60000",
	[21913] = "21871|V229|60000",
	[21914] = "21870|V229|60000",
	[21915] = "21872|V229|60000",
	[21916] = "21873|V231|60000",
	[21917] = "21875|V231|60000",
	[21918] = "21874|V231|60000",
	[21919] = "21876|V231|60000",
	[21940] = "21756|D",
	[21941] = "21758|V68V13|5000",
	[21942] = "20969|V62V90|6000",
	[21943] = "21760|V142V68|6000",
	[21944] = "21763|D",
	[21945] = "21754|D",
	[21947] = "21753|D",
	[21948] = "21766|V287V289V282V283|7500",
	[21949] = "21769|D",
	[21952] = "21774|V130|10000",
	[21953] = "21777|D",
	[21954] = "21778|V77|10000",
	[21955] = "21784|D",
	[21956] = "21789|D",
	[21957] = "21792|V154|10000",
	[21992] = "21990|V265V264|20000",
	[21993] = "21991|V265V264|40000",
	[22530] = "-27906|D",
	[22532] = "-27913|D",
	[22533] = "-27914|D",
	[22534] = "-27917|D",
	[22535] = "-27920|D",
	[22536] = "-27924|V234|100000|6",
	[22537] = "-27926|V255|100000|7",
	[22538] = "-27927|V234|200000|6",
	[22539] = "-27945|V309|60000",
	[22540] = "-27946|D",
	[22541] = "-27947|D",
	[22542] = "-27948|D",
	[22543] = "-27950|D",
	[22544] = "-27951|D",
	[22545] = "-27954|D",
	[22548] = "-27962|D",
	[22551] = "-27968|D",
	[22553] = "-27972|D",
	[22554] = "-27971|D",
	[22555] = "-27975|D",
	[22556] = "-27977|D",
	[22557] = "-28004|D",
	[22558] = "-28003|D",
	[22559] = "-27984|D",
	[22560] = "-27981|D",
	[22561] = "-27982|D",
	[22562] = "22521|V311V312V310|50000",
	[22563] = "22522|V311V312V310|70000",
	[22565] = "22449|V311V312V310|60000",
	[22647] = "22645|V275V270|400",
	[22729] = "22728|D",
	[22900] = "22823|V261V258V262V253V263V259|30000",
	[22901] = "22826|V263V252|30000",
	[22902] = "22827|V250V251V252|40000",
	[22903] = "22828|D",
	[22904] = "22830|D",
	[22906] = "22871|V256|0|8",
	[22907] = "22832|V250V253V251|50000",
	[22908] = "22833|V236|60000|7",
	[22909] = "22834|V250V253V251|50000",
	[22910] = "22835|V234|80000|7",
	[22911] = "22836|D",
	[22912] = "22837|D",
	[22913] = "22838|D",
	[22914] = "22839|D",
	[22915] = "21884|V255|80000|7",
	[22916] = "21885|V256|0|7",
	[22918] = "22451|V237|80000|7",
	[22919] = "22840|D",
	[22920] = "22841|D",
	[22921] = "22842|D",
	[22922] = "22844|V237|100000|8",
	[22923] = "22845|D",
	[22924] = "22846|D",
	[22925] = "22847|D",
	[22926] = "22848|D",
	[22927] = "22849|D",
	[23130] = "23094|V291V292|40000",
	[23131] = "23095|V291V292|50000",
	[23133] = "23096|V236|60000|5",
	[23134] = "23097|V233|60000|6",
	[23135] = "23098|V291V292|40000",
	[23136] = "23099|V233|50000|5",
	[23137] = "23100|V291V292|60000",
	[23138] = "23101|V234|60000|5",
	[23140] = "23103|V291V292|40000",
	[23141] = "23104|V291V292|50000",
	[23143] = "23106|V236|60000|6",
	[23144] = "23108|V291V292|40000",
	[23145] = "23109|V235|50000|6",
	[23146] = "23110|V233|60000|5",
	[23147] = "23111|V291V292|60000",
	[23148] = "23113|V291V292|40000",
	[23149] = "23114|V235|50000|5",
	[23150] = "23115|V233|60000|6",
	[23151] = "23116|V291V292|60000",
	[23152] = "23118|V291V292|40000",
	[23153] = "23119|V291V292|50000",
	[23154] = "23120|D",
	[23155] = "23121|V233|60000|6",
	[23574] = "23571|V258V259V260|80000",
	[23590] = "23502|V243V244V245|40000",
	[23591] = "23503|V243V244V245|40000",
	[23592] = "23504|V243V244V245|40000",
	[23593] = "23505|V243V244V245|40000",
	[23594] = "23506|V241V242|60000",
	[23595] = "23508|V241V242|60000",
	[23596] = "23507|V241V242|60000",
	[23597] = "23510|V236|60000|5",
	[23598] = "23511|V236|60000|6",
	[23599] = "23509|V236|60000|7",
	[23600] = "23512|V236|80000|8",
	[23601] = "23515|V235|60000|5",
	[23602] = "23516|V235|60000|8",
	[23603] = "23514|V235|60000|6",
	[23604] = "23513|V235|80000|7",
	[23605] = "23517|D",
	[23606] = "23518|D",
	[23607] = "23519|D",
	[23608] = "23524|D",
	[23609] = "23523|D",
	[23610] = "23525|D",
	[23611] = "23520|D",
	[23612] = "23521|D",
	[23613] = "23522|D",
	[23615] = "23526|D",
	[23617] = "23527|D",
	[23618] = "23529|V237|60000|6",
	[23620] = "23531|D",
	[23621] = "23532|D",
	[23622] = "23533|D",
	[23623] = "23534|D",
	[23624] = "23535|D",
	[23625] = "23536|D",
	[23626] = "23537|D",
	[23627] = "23538|D",
	[23628] = "23539|D",
	[23629] = "23540|D",
	[23630] = "23541|D",
	[23631] = "23542|D",
	[23632] = "23543|D",
	[23633] = "23544|D",
	[23634] = "23546|D",
	[23635] = "23554|D",
	[23636] = "23555|D",
	[23637] = "23556|D",
	[23638] = "23575|V246V247|60000",
	[23639] = "23576|D",
	[23799] = "23746|V293V294V295|80000",
	[23800] = "23747|D",
	[23802] = "23748|D",
	[23803] = "23758|V299V297|60000",
	[23804] = "23761|D",
	[23805] = "23762|V300V299|80000",
	[23806] = "23763|D",
	[23807] = "23764|V296V297|60000",
	[23808] = "23765|D",
	[23809] = "23766|D",
	[23810] = "23767|D",
    [23883] = "33092|D",
    [23884] = "33093|D",
	[23811] = "23768|V300V293V298V295|60000",
	[23814] = "23771|V237|60000|5",
	[23815] = "23773|V293V298V295|60000",
	[23816] = "23774|V293V298V295|40000",
	[23887] = "23824|D",
	[23888] = "23821|D",
	[24158] = "24079|D",
	[24159] = "24080|D",
	[24160] = "24082|D",
	[24161] = "24085|D",
	[24162] = "24086|D",
	[24163] = "24087|D",
	[24164] = "24088|D",
	[24165] = "24089|D",
	[24166] = "24106|D",
	[24167] = "24110|D",
	[24168] = "24114|D",
	[24169] = "24116|D",
	[24170] = "24117|D",
	[24171] = "24121|D",
	[24172] = "24122|D",
	[24173] = "24123|D",
	[24174] = "24092|V254|120000|7",
	[24175] = "24093|V234|120000|7",
	[24176] = "24095|V236|120000|7",
	[24177] = "24097|V235|120000|7",
	[24178] = "24098|V233|120000|7",
	[24179] = "24124|V234|120000|7",
	[24181] = "24126|V254|120000|7",
	[24182] = "24127|V255|120000|7",
	[24183] = "24128|V237|120000|7",
	[24192] = "24031|D",
	[24193] = "24027|D",
	[24194] = "24028|D",
	[24195] = "24029|D",
	[24196] = "24030|D",
	[24197] = "24032|D",
	[24198] = "24036|D",
	[24199] = "24033|D",
	[24200] = "24035|D",
	[24201] = "24037|D",
	[24202] = "24039|D",
	[24203] = "24047|D",
	[24204] = "24048|D",
	[24205] = "24051|D",
	[24206] = "24050|D",
	[24207] = "24052|D",
	[24209] = "24054|D",
	[24210] = "24055|D",
	[24211] = "24056|D",
	[24212] = "24057|D",
	[24213] = "24058|D",
	[24214] = "24059|D",
	[24215] = "24060|D",
	[24216] = "24061|D",
	[24217] = "24062|D",
	[24218] = "24066|D",
	[24219] = "24065|D",
	[24220] = "24067|D",
	[24292] = "24273|V236|60000|6",
	[24293] = "24275|V235|60000|6",
	[24294] = "24274|V236|360000|8",
	[24295] = "24276|V235|360000|8",
	[24296] = "24249|D",
	[24297] = "24250|D",
	[24298] = "24251|D",
	[24299] = "24252|D",
	[24300] = "24253|D",
	[24301] = "24254|D",
	[24302] = "24255|D",
	[24303] = "24256|D",
	[24304] = "24257|D",
	[24305] = "24258|D",
	[24306] = "24259|D",
	[24307] = "24260|D",
	[24308] = "24261|D",
	[24309] = "24262|D",
	[24310] = "24263|D",
	[24311] = "24264|D",
	[24312] = "24266|D",
	[24313] = "24267|D",
	[24314] = "24270|V233|40000|6",
	[24315] = "24269|V237|30000|5",
	[24316] = "24271|V232|40000",
	[25526] = "25521|V237|60000|6",
	[25720] = "23793|V304V302V303|50000",
	[25721] = "25651|V235|50000|7",
	[25722] = "25652|V236|50000|7",
	[25725] = "25653|V305|50000",
	[25726] = "25679|V302V303|10000",
	[25728] = "25680|D",
	[25729] = "25681|D",
	[25730] = "25682|D",
	[25731] = "25683|D",
	[25732] = "25685|V233|120000|5",
	[25733] = "25686|V233|140000|6",
	[25734] = "25687|V233|140000|7",
	[25735] = "25689|V237|160000|6",
	[25736] = "25690|V237|140000|6",
	[25737] = "25691|V237|140000|5",
	[25846] = "25844|V243|40000",
	[25847] = "25845|V246V247|120000",
	[25848] = "22462|V307V277|100000",
	[25849] = "22463|V310|120000",
	[25869] = "25867|V237|80000|6",
	[25887] = "25886|D",
	[25902] = "25896|D",
	[25903] = "25897|D",
	[25904] = "25901|V255|120000|5",
	[25905] = "25898|D",
	[25906] = "25899|D",
	[25907] = "25890|D",
	[25908] = "25894|V233|120000|6",
	[25909] = "25893|D",
	[25910] = "25895|V254|120000|6",
	[27684] = "27651|D",
	[27685] = "27635|V269|40",
	[27686] = "24105|D",
	[27687] = "27636|V270|400",
	[27688] = "27655|V280V281|20000",
	[27689] = "27656|V256|20000",
	[27690] = "27657|V271V272|30000",
	[27691] = "27658|V278V279|30000",
	[27692] = "27659|V271V278V272V279|30000",
	[27693] = "27660|D",
	[27694] = "27661|V273V274|20000",
	[27695] = "27662|V273V239|20000",
	[27696] = "27663|D",
	[27697] = "27664|V278V279|30000",
	[27698] = "27665|V278V279|30000",
	[27699] = "27666|V276V277|30000",
	[27700] = "27667|V276V277|30000",
	[28270] = "-33992|D",
	[28271] = "-33994|V237|80000|7",
	[28272] = "-33997|V254|80000|6",
	[28273] = "-33999|V255|60000|6",
	[28274] = "-34003|V233|40000|5",
	[28276] = "-34005|D",
	[28277] = "-34006|D",
	[28279] = "-34007|D",
	[28280] = "-34008|D",
	[28281] = "-34010|V255|60000|7",
	[28282] = "-34009|V310|40000",
	[28291] = "28290|V291V292|60000",
	[28596] = "28595|V291V292|50000",
	[28632] = "28421|V237|60000|6",
	[29669] = "29483|D",
	[29672] = "29485|D",
	[29673] = "29486|D",
	[29674] = "29487|D",
	[29675] = "29488|D",
	[29677] = "29489|V236|80000|8",
	[29682] = "29490|V236|80000|6",
	[29684] = "29491|V236|80000|7",
	[29689] = "29492|V235|80000|8",
	[29691] = "29493|V235|80000|7",
	[29693] = "29494|V235|80000|6",
	[29698] = "29495|V236|80000|8",
	[29700] = "29496|V236|80000|7",
	[29701] = "29497|V236|80000|6",
	[29702] = "29498|V235|80000|8",
	[29703] = "29499|V235|80000|7",
	[29704] = "29500|V235|80000|6",
	[29713] = "29532|V254|120000|6",
	[29714] = "29531|DV257V301|120000|6",
    [34174] = "29531|DV257V301|120000|6",
    [34175] = "29531|DV257V301|120000|6",
	[29717] = "29529|V255|120000|6",
	[29718] = "29530|V257V301D|120000|6",
    [34172] = "29530|V257V301D|120000|6",
    [34173] = "29530|V257V301D|120000|6",
	[29720] = "29534|V237|60000|6",
	[29721] = "29536|V237|120000|8",
	[29723] = "29502|D",
	[29724] = "29503|D",
	[29725] = "29504|D",
	[29726] = "29505|D",
	[29727] = "29506|D",
	[29728] = "29507|D",
	[29729] = "29508|D",
	[29730] = "29512|D",
	[29731] = "29509|D",
	[29732] = "29510|D",
	[29733] = "29511|D",
	[29734] = "29514|D",
	[30156] = "30155|V256V268|0",
	[30483] = "24272|V229|40000",
	[30826] = "30825|V255|120000|6",
	[30833] = "30831|V234|60000|6",
	[30842] = "30837|V235|60000|5",
	[30843] = "30838|V235|80000|6",
	[30844] = "30839|V235|100000|8",
	[31390] = "31364|V237|240000|8",
	[31391] = "31367|V237|240000|7",
	[31392] = "31368|V237|240000|7",
	[31393] = "31369|V240|240000|6",
	[31394] = "31370|V240|240000|7",
	[31395] = "31371|V240|240000|6",
	[31401] = "31398|V290|120000|6",
	[31402] = "31399|V237|120000|8",
	[31674] = "31673|D",
	[31675] = "31672|D",
	[31680] = "31679|D",
	[31681] = "31676|D",
	[31682] = "31677|D",
-- Honor Hold / Thrallmar
	[22531] = "-27911|V248V249|60000|5",
	[24000] = "-27911|V248V249|60000|5",
	[23142] = "23105|V248V249|60000|5",
	[31359] = "23105|V248V249|60000|5",
	[25738] = "25695|V248V249|120000|5",
	[29213] = "25695|V248V249|120000|5",
	[22905] = "22831|V248V249|50000|6",
	[24001] = "22831|V248V249|50000|6",
	[25739] = "25697|V248V249|160000|6",
	[29214] = "25697|V248V249|160000|6",
	[25740] = "25696|V248V249|160000|6",
	[29215] = "25696|V248V249|160000|6",
	[25870] = "25868|V248V249|80000|6",
	[29232] = "25868|V248V249|80000|6",
	[29719] = "29533|V248V249|60000|6",
	[31361] = "29533|V248V249|60000|6",
	[22547] = "-27960|V248V249|60000|7",
	[24003] = "-27960|V248V249|60000|7",
	[24180] = "24125|V248V249|120000|7",
	[31358] = "24125|V248V249|120000|7",
	[23619] = "23530|V248V249|60000|8",
	[24002] = "23530|V248V249|60000|8",
	[29722] = "29535|V248V249|120000|8",
	[31362] = "29535|V248V249|120000|8",
-- Kurenai / The Mag'har
	[25741] = "25694|V257V301|120000|5",
	[29217] = "25694|V257V301|120000|5",
	[25742] = "25692|V257V301|120000|6",
	[29219] = "25692|V257V301|120000|6",
	[29664] = "29540|V257V301|50000|6",
	[30444] = "29540|V257V301|50000|6",
	[25743] = "25693|V257V301|120000|7",
	[29218] = "25693|V257V301|120000|7",
	[22917] = "22452|V257V301|80000|7",
	[30443] = "22452|V257V301|80000|7",
-- New source of recipes for flasks
	[13519] = "13510|DV255|40000|8",
	[13520] = "13511|DV237|40000|8",
	[13521] = "13512|DV254|40000|8",
	[13522] = "13513|DV234|40000|8",
	[31354] = "13510|V255|40000|8",
	[31356] = "13511|V237|40000|8",
	[31355] = "13512|V254|40000|8",
	[31357] = "13513|V234|40000|8",
--New
    [7929] = "9957|Qh",
    [32429] = "32393|V313|80000|6",
    [32430] = "32399|V313|80000|6",
    [32431] = "32400|V313|80000|7",
    [32432] = "32397|V313|80000|7",
    [32436] = "32393|V313|80000|6",
    [32435] = "32396|V313|80000|6",
    [32433] = "32394|V313|80000|7",
    [32434] = "32395|V313|80000|7",
    [32447] = "32420|V313|80000|7",
    [32438] = "32392|V313|80000|6",
    [32440] = "32390|V313|80000|6",
    [32439] = "32389|V313|80000|7",
    [32437] = "32391|V313|80000|7",
    [32442] = "32403|V313|80000|6",
    [32444] = "32401|V313|80000|6",
    [32443] = "32404|V313|80000|7",
    [32441] = "32402|V313|80000|7",
    [33205] = "33204|V290|240000|8",
    [33124] = "33122|V290|50000|7",
    [33165] = "-42620|V290|30000|8",
    [33209] = "33208|V290|40000|6",
    [32299] = "32213|V314|60000|6",
    [32274] = "32193|V314|60000|5",
    [32283] = "32197|V314|60000|5",
    [32290] = "32204|V314|60000|5",
    [32311] = "32225|V314|60000|6",
    [32277] = "32194|V314|60000|5",
    [32309] = "32249|V314|60000|7",
    [32293] = "32207|V314|60000|5",
    [32306] = "32220|V314|60000|6",
    [32301] = "32215|V314|60000|6",
    [32300] = "32214|V314|60000|6",
    [32312] = "32226|V314|60000|6",
    [32305] = "32219|V314|60000|6",
    [32288] = "32202|V314|60000|5",
    [32304] = "32218|V314|60000|6",
    [32310] = "32224|V314|60000|6",
    [32292] = "32206|V314|60000|7",
    [32302] = "32216|V314|60000|7",
    [32282] = "32196|V314|60000|5",
    [32291] = "32205|V314|60000|5",
    [32286] = "32200|V314|60000|5",
    [32287] = "32201|V314|60000|5",
    [32284] = "32198|V314|60000|5",
    [32281] = "32195|V314|60000|5",
    [32294] = "32208|V314|60000|5",
    [32308] = "32222|V314|60000|7",
    [33159] = "33140|V255|120000|7",
    [33156] = "33131|V233|120000|7",
    [33305] = "33133|V233|120000|7",
    [33160] = "33144|V254|120000|6",
    [33157] = "33135|V234|120000|7",
    [33155] = "33134|V255|120000|6",
    [33158] = "33143|V254|120000|7",
    [32381] = "7191|V209V294|16000", --Fused Wiring
    [30280] = "30038|D",
    [30281] = "30036|D",
    [30282] = "30037|D",
    [32755] = "32587|D",
    [32754] = "32586|D",
    [30302] = "30040|D",
    [30301] = "30042|D",
    [30303] = "30046|D",
    [30305] = "30041|D",
    [30307] = "30045|D",
    [30308] = "30043|D",
    [30304] = "30044|D",
    [32748] = "32574|D",
    [32751] = "32579|D",
    [32745] = "32583|D",
    [32746] = "32580|D",
    [32744] = "32582|D",
    [32750] = "32577|D",
    [32745] = "32583|D",
    [32749] = "32575|D",
    [32747] = "32581|D",
    [30306] = "30039|D",
    [30321] = "30034|D",
    [30323] = "30033|D",
    [30322] = "30032|D",
    [30324] = "30031|D",
    [32739] = "32573|D",
    [32736] = "32568|D",
    [32738] = "32571|D",
    [32737] = "32570|D",
    [33174] = "33173|D",
    [33783] = '33782|D', --Steady Talasite
    [34221] = "34220|D",
    [33869] = "33867|Q",
    [33952] = "33924|Q",
    [34413] = "34411|QV151V204",
    [33875] = "33874|Q",
    [33870] = "33825|Q",
    [33873] = "33872|Q",
    [33871] = "33866|Q",
    [34114] = "34113|D",
    [33804] = "20475|D",
    [33307] = "-42974|D",
    [33954] = "32854|D",
    [33186] = "33185|D",
    [33792] = "33185|D",
    [34200] = "34105|V234|400000|7",
    [34201] = "34106|V248V249|400000|7",
    [34218] = "34106|V248V249|400000|7",
    [34491] = "34490|D",
    [34262] = "34086|QV151V204",
    [34261] = "34807|QhV151",
    [34319] = "34805|QaV204",
    [30283] = "30035|D",
    [32753] = "32585|D",
    [32752] = "32584|D",
    [32411] = "32410|D",
    [32412] = "32409|V233|12000|8",
    [33622] = "32409|V233|12000|8",
    [31876] = "31863|D",
    [24192] = "24031|D",
    [24193] = "24027|D",
    [31875] = "31861|D",
    [31874] = "31869|D",
    [31877] = "31865|D",
    [24208] = "24053|D",
    [31878] = "31867|D",
    [31879] = "31868|D",
    [31871] = "31862|D",
    [31870] = "31860|D",
    [31872] = "31864|D",
    [31873] = "31866|D",
    [32307] = "32211|D",
    [32303] = "32217|D",
    [32298] = "32212|D",
    [32297] = "32221|D",
    [32296] = "32210|D",
    [32289] = "32203|D",
    [32285] = "32197|D",
    [99999] = "7929|Qh",
    [35202] = "34360|D",
    [35533] = "34360|D",
    [35200] = "34361|D",
    [35203] = "34358|D",
    [35535] = "34358|D",
    [35238] = "32213|V316|500000|6",
    [35244] = "32193|V316|500000|5",
    [35245] = "32197|V316|500000|5",
    [35255] = "32204|V316|500000|5",
    [35251] = "32225|V316|500000|6",
    [35246] = "32194|V316|500000|5",
    [35252] = "32223|V316|500000|7",
    [35247] = "32199|V316|500000|8",
    [35765] = "35759|V314|15000|6",
    [35769] = "35759|V315|500000|7",
    [35256] = "32207|V316|500000|5",
    [35266] = "32220|V316|500000|6",
    [35239] = "32215|V316|500000|6",
    [35257] = "32210|V316|500000|8",
    [35240] = "32214|V316|500000|6",
    [35267] = "32217|V316|500000|8",
    [35253] = "32226|V316|500000|6",
    [35268] = "32219|V316|500000|6",
    [35262] = "32202|V316|500000|5",
    [35258] = "32209|V316|500000|8",
    [35269] = "32218|V316|500000|6",
    [35763] = "35761|V314|15000|6",
    [35768] = "35761|V315|500000|7",
    [35254] = "32224|V316|500000|6",
    [35762] = "35760|V314|15000|6",
    [35767] = "35760|V315|500000|7",
    [35259] = "32206|V316|500000|7",
    [35241] = "32216|V316|500000|7",
    [35248] = "32196|V316|500000|5",
    [35242] = "32212|V316|500000|8",
    [35260] = "32205|V316|500000|5",
    [35263] = "32200|V316|500000|5",
    [35243] = "32211|V316|500000|8",
    [35264] = "32201|V316|500000|5",
    [35764] = "35758|V314|15000|6",
    [35766] = "35758|V315|500000|7",
    [35265] = "32203|V316|500000|8",
    [35249] = "32198|V316|500000|5",
    [35250] = "32195|V316|500000|5",
    [35261] = "32208|V316|500000|5",
    [35270] = "32221|V316|500000|8",
    [35271] = "32222|V316|500000|7",
    [35201] = "34359|D",
    [35198] = "34362|D",
    [35199] = "34363|D",
    [35538] = "34363|D",
    [35218] = "34369|D",
    [35539] = "34369|D",
    [35217] = "34373|D",
    [35213] = "34374|D",
    [35541] = "34374|D",
    [35214] = "34370|D",
    [35205] = "34367|D",
    [35544] = "34367|D",
    [35216] = "34371|D",
    [35545] = "34371|D",
    [35212] = "34372|D",
    [35546] = "34372|D",
    [35207] = "34365|D",
    [35548] = "34365|D",
    [35219] = "34375|D",
    [35215] = "34376|D",
    [35550] = "34376|D",
    [35204] = "34366|D",
    [35551] = "34366|D",
    [35206] = "34364|D",
    [35209] = "34378|D",
    [35553] = "34378|D",
    [35211] = "34377|D",
    [35210] = "34379|D",
    [35208] = "34380|D",
    [35186] = "34847|D",
    [35187] = "35185|D",
    [35189] = "35181|D",
    [35190] = "35182|D",
    [35191] = "35183|D",
    [35192] = "35184|D",
    [35193] = "34355|D",
    [35194] = "34356|D",
    [35195] = "34354|D",
    [35196] = "34357|D",
    [35197] = "34353|D",
    [34834] = "34832|Q",
    [35505] = "35503|V316|150000|7",
    [35502] = "35501|V316|150000|7",
    [34872] = "-45765|V316|150000|7",
    [35564] = "35563|V12V120|12000",
    [35566] = "35565|V12V120|12000",
    [35273] = "35128|D",
    [35708] = "35707|V316|150000|7",
    [35582] = "35581|D",
    [35550] = "-46594|V316|150000|7",
    [35755] = "35751|V316|250000|8",
    [35752] = "35748|V316|250000|8",
    [35754] = "35750|V316|250000|8",
    [35753] = "35749|V316|250000|8",
    [35697] = "35700|V316|250000|7",
    [35695] = "35693|V316|250000|7",
    [35696] = "35694|V316|250000|7",
    [35699] = "35703|V316|250000|7",
    [35698] = "35702|V316|250000|7",
    [35517] = "32574|D",
    [35518] = "32586|D",
    [35519] = "32582|D",
    [35302] = "29503|D",
    [35303] = "29506|D",
    [35520] = "32577|D",
    [35521] = "32579|D",
    [35522] = "32587|D",
    [35301] = "29511|D",
    [35523] = "32583|D",
    [35524] = "32575|D",
    [35525] = "32585|D",
    [35526] = "32584|D",
    [35527] = "32580|D",
    [35528] = "32581|D",
    [35309] = "24255|D",
    [35300] = "29509|D",
    [35531] = "32568|D",
    [35532] = "32570|D",
    [35306] = "24031|D",
    [35307] = "24051|D",
    [35305] = "24030|D",
    [35304] = "24033|D",
    [35297] = "-34008|D",
    [35299] = "-34007|D",
    [35756] = "-47051|D",
    [35308] = "24249|D",
    [35310] = "33092|D",
    [35311] = "33093|D",
    [35298] = "-27948|D",
    [35296] = "33185|D",
    [35294] = "22848|D",
    [35295] = "22838|D",
    [35325] = "35319|V315|250000|8",
    [35322] = "35315|V315|250000|8",
    [35323] = "35316|V315|250000|8",
}

TradeskillInfo.vars.enchantID = {
--[id]="enchantid"
[2853]="2663",
[2852]="2662",
[10421]="12260",
[2862]="2660",
[3239]="3115",
[2844]="2737",
[2845]="2738",
[3469]="3319",
[2847]="2739",
[3470]="3320",
[7955]="9983",
[7166]="8880",
[3488]="3293",
[3471]="3321",
[2851]="2661",
[3472]="3323",
[3473]="3324",
[3474]="3325",
[2863]="2665",
[3240]="3116",
[6214]="7408",
[3489]="3294",
[2857]="2666",
[3478]="3326",
[2864]="2667",
[2854]="2664",
[3487]="3292",
[6350]="7817",
[6731]="8367",
[15869]="19666",
[29201]="34979",
[6338]="7818",
[3848]="3491",
[2865]="2668",
[2866]="2670",
[2848]="2740",
[3480]="3328",
[2849]="2741",
[2868]="2672",
[2850]="2742",
[3490]="3295",
[3481]="3330",
[7956]="9985",
[3486]="3337",
[2871]="2674",
[3241]="3117",
[3491]="3296",
[3482]="3331",
[2869]="2673",
[7957]="9986",
[3483]="3333",
[7958]="9987",
[5541]="6518",
[2870]="2675",
[3484]="3334",
[3492]="3297",
[15870]="19667",
[3485]="3336",
[3851]="3494",
[11128]="14379",
[7071]="8768",
[6042]="7221",
[7914]="9813",
[3842]="3506",
[3849]="3492",
[10423]="12259",
[7913]="9811",
[3840]="3504",
[3835]="3501",
[6043]="7222",
[3852]="3495",
[3843]="3507",
[3836]="3502",
[7915]="9814",
[3841]="3505",
[3850]="3493",
[3853]="3496",
[3844]="3508",
[7916]="9818",
[12259]="15972",
[3855]="3498",
[7917]="9820",
[3846]="3513",
[6040]="7223",
[17704]="21913",
[3837]="3503",
[12260]="15973",
[6041]="7224",
[3845]="3511",
[3854]="3497",
[3847]="3515",
[3856]="3500",
[7963]="9916",
[15871]="19668",
[29202]="34981",
[9060]="11454",
[7966]="9920",
[7964]="9918",
[7965]="9921",
[11144]="14380",
[9366]="11643",
[7919]="9928",
[7918]="9926",
[7941]="9993",
[7921]="9933",
[7920]="9931",
[7924]="9937",
[7967]="9939",
[7922]="9935",
[7942]="9995",
[7927]="9950",
[7926]="9945",
[7938]="9954",
[7928]="9952",
[7943]="9997",
[7945]="10001",
[7930]="9959",
[7931]="9961",
[7954]="10003",
[7933]="9968",
[7932]="9966",
[7969]="9964",
[7944]="10005",
[7961]="10007",
[7939]="9974",
[7934]="9970",
[7946]="10009",
[7959]="10011",
[12405]="16642",
[12406]="16643",
[12644]="16639",
[12404]="16641",
[12643]="16640",
[7947]="10013",
[12408]="16644",
[30069]="36122",
[30071]="36125",
[30073]="36128",
[30072]="36126",
[7960]="10015",
[30070]="36124",
[11606]="15293",
[12416]="16645",
[11608]="15292",
[12424]="16647",
[12428]="16646",
[12624]="16650",
[11605]="15295",
[12425]="16649",
[12415]="16648",
[11607]="15294",
[15872]="19669",
[12773]="16969",
[12645]="16651",
[16206]="20201",
[12777]="16978",
[12776]="16973",
[12775]="16971",
[12409]="16652",
[12410]="16653",
[11604]="15296",
[12628]="16667",
[12781]="16983",
[12418]="16654",
[12782]="16985",
[12631]="16655",
[19051]="23632",
[19043]="23628",
[12419]="16656",
[12792]="16984",
[17014]="20874",
[16989]="20872",
[17193]="21161",
[12632]="16661",
[12426]="16657",
[12427]="16658",
[12417]="16659",
[19166]="23638",
[22194]="27589",
[19167]="23639",
[19168]="23652",
[20039]="24399",
[19164]="23637",
[19148]="23636",
[17013]="20876",
[19170]="23650",
[16988]="20873",
[22671]="28244",
[22669]="28242",
[22670]="28243",
[12641]="16746",
[22198]="27586",
[12640]="16729",
[19169]="23653",
[22191]="27590",
[22384]="27830",
[22383]="27832",
[12639]="16741",
[22196]="27587",
[22385]="27829",
[12798]="16991",
[12790]="16990",
[12784]="16994",
[19690]="24136",
[19692]="24138",
[19691]="24137",
[17016]="20897",
[17015]="20890",
[20550]="24914",
[20549]="24912",
[20551]="24913",
[19693]="24139",
[19694]="24140",
[19695]="24141",
[12618]="16745",
[12620]="16742",
[12619]="16744",
[12797]="16992",
[19057]="23633",
[12796]="16988",
[12783]="16995",
[22197]="27585",
[19048]="23629",
[12636]="16728",
[22764]="28463",
[22762]="28461",
[22763]="28462",
[22195]="27588",
[12794]="16993",
[12633]="16724",
[18262]="22757",
[29203]="34982",
[23493]="29551",
[23482]="29545",
[12422]="16663",
[12429]="16730",
[12420]="16725",
[12613]="16731",
[12611]="16665",
[12612]="16726",
[12614]="16732",
[12610]="16664",
[12414]="16662",
[25843]="32655",
[23528]="29654",
[28420]="34607",
[23484]="29547",
[23491]="29552",
[23497]="29557",
[23494]="29553",
[23498]="29558",
[23487]="29548",
[23488]="29549",
[23490]="29556",
[23499]="29565",
[23502]="29566",
[23489]="29550",
[23559]="32284",
[30093]="36137",
[30074]="36129",
[30089]="36136",
[30088]="36135",
[30086]="36133",
[30087]="36134",
[30076]="36130",
[30077]="36131",
[23503]="29568",
[23504]="29569",
[23506]="29603",
[23508]="29605",
[23505]="29571",
[23507]="29606",
[23575]="29728",
[28483]="34533",
[28437]="34545",
[28425]="34535",
[28428]="34538",
[28434]="34543",
[23563]="34529",
[28431]="34541",
[28440]="34547",
[29204]="34983",
[23515]="29614",
[23529]="29656",
[28421]="34608",
[25844]="32656",
[25521]="32285",
[23510]="29608",
[23511]="29611",
[23516]="29615",
[23509]="29610",
[23517]="29619",
[23518]="29620",
[23514]="29616",
[23524]="29628",
[23523]="29629",
[23530]="29657",
[23537]="29669",
[23539]="29672",
[23538]="29671",
[23555]="29699",
[23554]="29698",
[23542]="29694",
[23546]="29697",
[23531]="29658",
[23540]="29692",
[23543]="29695",
[23532]="29622",
[23556]="29700",
[23535]="29664",
[23541]="29693",
[23544]="29696",
[23533]="29662",
[23534]="29663",
[23512]="29613",
[23519]="29621",
[23513]="29617",
[23525]="29630",
[23520]="29642",
[23521]="29643",
[23527]="29649",
[23522]="29645",
[23526]="29648",
[30034]="36389",
[28432]="34542",
[28427]="36258",
[28426]="34537",
[28436]="36261",
[30033]="36391",
[28484]="34534",
[28485]="36257",
[32571]="41134",
[32573]="41135",
[28441]="34548",
[28438]="34546",
[28439]="36262",
[23565]="36256",
[31369]="38477",
[31371]="38479",
[31370]="38478",
[28429]="34540",
[28430]="36259",
[28435]="34544",
[30032]="36390",
[30031]="36392",
[32403]="40034",
[32401]="40036",
[32404]="40035",
[32402]="40033",
[28442]="36263",
[32568]="41132",
[32570]="41133",
[23564]="34530",
[28433]="36260",
[31364]="38473",
[31368]="38476",
[31367]="38475",
[25845]="32657",
[23576]="29729",
[7929]="9957",
[7936]="9979",
[7935]="9972",
[7937]="9980",
[5997]="7183",
[118]="2330",
[2455]="2331",
[2456]="2332",
[4596]="4508",
[2457]="3230",
[2458]="2334",
[858]="2337",
[5631]="6617",
[2459]="2335",
[6370]="7836",
[6662]="8240",
[5996]="7179",
[3383]="3171",
[6051]="7255",
[6372]="7841",
[929]="3447",
[3384]="3172",
[3385]="3173",
[3386]="3174",
[3389]="3177",
[6371]="7837",
[6048]="7256",
[6373]="7845",
[3390]="2333",
[5634]="6624",
[1710]="7181",
[3827]="3452",
[6049]="7257",
[3823]="3448",
[3824]="3449",
[3825]="3450",
[5633]="6618",
[8949]="11449",
[17708]="21923",
[6050]="7258",
[6052]="7259",
[3828]="3453",
[8951]="11450",
[9061]="11456",
[10592]="12609",
[3829]="3454",
[6149]="11448",
[8956]="11451",
[9036]="11453",
[18294]="22808",
[4623]="4942",
[3928]="11457",
[9144]="11458",
[11552]="11452", -- Restorative Potion, Added 8/7/2007
[12190]="15833",
[9154]="11460",
[9210]="11473",
[9155]="11461",
[9179]="11465",
[9264]="11476",
[9172]="11464",
[9197]="11468",
[9187]="11467",
[9088]="11466",
[9206]="11472",
[9224]="11477",
[9233]="11478",
[21546]="26277",
[3387]="3175",
[13423]="17551",
[13442]="17552",
[13443]="17553",
[13445]="17554",
[13447]="17555",
[13453]="17557",
[20002]="24366",
[20007]="24365",
[13446]="17556",
[13452]="17571",
[13455]="17570",
[13454]="17573",
[20008]="24367",
[13462]="17572",
[9030]="11452",
[13461]="17577",
[13457]="17574",
[13456]="17575",
[13458]="17576",
[13459]="17578",
[13444]="17580",
[19931]="24266",
[13513]="17638",
[13511]="17636",
[13506]="17634",
[13512]="17637",
[13510]="17635",
[18253]="22732",
[28102]="33738",
[28100]="33732",
[22823]="28543",
[22824]="28544",
[22825]="28545",
[32062]="39636",
[28101]="33733",
[28104]="33741",
[22826]="28546",
[32063]="39637",
[32067]="39638",
[22827]="28549",
[22828]="28550",
[31080]="38070",
[22830]="28552",
[22829]="28551",
[32068]="39639",
[22831]="28553",
[31679]="38960",
[22871]="28554",
[22832]="28555",
[22834]="28557",
[22833]="28556",
[31676]="38962",
[22839]="28565",
[22835]="28558",
[22838]="28564",
[22837]="28563",
[22836]="28562",
[22840]="28570",
[31677]="38961",
[22861]="28590",
[22851]="28587",
[22853]="28588",
[22866]="28591",
[22854]="28589",
[22845]="28575",
[22841]="28571",
[22842]="28572",
[22847]="28577",
[22844]="28573",
[22846]="28576",
[22850]="28586",
[22848]="28578",
[22849]="28579",
[32839]="41458",
[32849]="41500",
[32850]="41501",
[32851]="41502",
[32852]="41503",
[6218]="7421",
[11287]="14293",
[20744]="-25124",
[11288]="-14807",
[6339]="7795",
[20745]="-25125",
[11130]="13628",
[11289]="14809",
[11290]="14810",
[20746]="-25126",
[11145]="13702",
[12810]="17181",
[12655]="-17180",
[20747]="25127",
[11811]="15596",
[20750]="25128",
[16207]="20051",
[20748]="-25130",
[20749]="-25129",
[22461]="32664",
[22521]="28016",
[22460]="28027",
[22449]="28022",
[22522]="28019",
[22459]="28028",
[22462]="32665",
[22463]="32667",
[22448]="42615",
[8067]="3920",
[4357]="3918",
[4358]="3919",
[4359]="3922",
[4360]="3923",
[4362]="3925",
[6219]="7430",
[4361]="3924",
[4405]="3977",
[4363]="3926",
[4364]="3929",
[8068]="3930",
[4401]="3928",
[4366]="3932",
[4404]="3973",
[4368]="3934",
[6712]="8334",
[4367]="3933",
[4369]="3936",
[4371]="3938",
[4406]="3978",
[4372]="3939",
[4373]="3940",
[7506]="9269",
[8069]="3947",
[4376]="3944",
[4377]="3945",
[21558]="26416",
[21559]="26417",
[21557]="26418",
[4375]="3942",
[5507]="6458",
[4381]="3952",
[4383]="3954",
[4382]="3953",
[4385]="3956",
[6533]="9271",
[9312]="23067",
[4384]="3955",
[10558]="12584",
[9313]="23068",
[9318]="23066",
[4386]="3957",
[4388]="3959",
[4387]="3958",
[7148]="9273",
[4403]="3960",
[4389]="3961",
[4391]="3963",
[21589]="26420",
[21590]="26421",
[21592]="26422",
[10505]="12585",
[10507]="12586",
[4407]="3979",
[4392]="3965",
[4852]="8243",
[4394]="3967",
[17716]="21940",
[4395]="3968",
[10559]="12589",
[4397]="3971",
[4398]="3972",
[4396]="3969",
[11590]="15255",
[10560]="12591",
[10500]="12594",
[10543]="12718",
[10542]="12717",
[10508]="12595",
[10716]="12899",
[10577]="12716",
[10646]="12760",
[11825]="15628",
[10545]="12897",
[10546]="12597",
[10721]="12903",
[10561]="12599",
[10514]="12603",
[10501]="12607",
[10724]="12905",
[7189]="8895",
[10518]="12616",
[10502]="12615",
[21571]="26423",
[21569]="26442",
[21574]="26424",
[21576]="26425",
[10506]="12617",
[10503]="12618",
[10725]="12906",
[10587]="12755",
[10726]="12907",
[10586]="12754",
[10645]="12759",
[10727]="12908",
[10548]="12620",
[10504]="12622",
[10588]="12758",
[15992]="19788",
[18641]="23070",
[10576]="12624",
[15846]="19567",
[19026]="23507",
[21277]="26011",
[18634]="23077",
[15995]="19792",
[18660]="23129",
[15993]="19790",
[15994]="19791",
[18631]="23071",
[18587]="23078",
[15996]="19793",
[15999]="19794",
[16004]="19796",
[18637]="23079",
[21570]="26443",
[7191]="39895",
[21714]="26426",
[21716]="26427",
[21718]="26428",
[16023]="19814",
[18594]="23080",
[16000]="19795",
[15997]="19800",
[16005]="19799",
[16006]="19815",
[16009]="19819",
[18282]="22795",
[18168]="22797",
[16022]="19830",
[18283]="22793",
[19999]="24356",
[19998]="24357",
[16007]="19833",
[16040]="19831",
[23781]="30303",
[23736]="30310",
[23782]="30304",
[18232]="22704",
[23783]="30305",
[23821]="30548",
[23772]="30346",
[23772]="30346",
[23742]="30312",
[23774]="30348",
[23784]="30306",
[23737]="30311",
[23841]="30568",
[23826]="30558",
[23773]="30347",
[23764]="30329",
[23771]="30344",
[32423]="39971",
[25886]="32814",
[23768]="30341",
[23758]="30316",
[23835]="30569",
[23761]="30317",
[23827]="30560",
[32478]="41317",
[32461]="40274",
[32476]="41315",
[32472]="41311",
[32475]="41316",
[32480]="41319",
[32495]="41321",
[32473]="41312",
[32479]="41318",
[23836]="30563",
[23746]="30313",
[23819]="30547",
[23787]="30309",
[23785]="30307",
[23786]="30308",
[23824]="30556",
[23747]="30314",
[23765]="30332",
[23829]="30575",
[23828]="30574",
[23748]="30315",
[23766]="30334",
[23820]="30549",
[32413]="39973",
[23769]="30342",
[20906]="25493",
[21931]="26925",
[20816]="25255",
[25498]="32259",
[21932]="26926",
[25438]="32178",
[25439]="32179",
[20821]="25283",
[21934]="26928",
[20818]="25280",
[20907]="25490",
[21933]="26927",
[20817]="25278",
[25880]="32801",
[20820]="25284",
[30804]="37818",
[20823]="25287",
[30419]="36523",
[31154]="38175",
[20827]="25317",
[20826]="25305",
[20828]="25318",
[30420]="36524",
[20830]="25339",
[20909]="25498",
[25881]="32807",
[20832]="25321",
[20950]="25610",
[20954]="25612",
[20833]="25323",
[20955]="25613",
[20958]="25617",
[20831]="25320",
[20963]="25615",
[20966]="25618",
[20960]="25620",
[20959]="25619",
[25882]="32808",
[29157]="34955",
[20961]="25621",
[20967]="25622",
[20964]="26874",
[21755]="26876",
[20969]="26878",
[25883]="32809",
[21752]="26880",
[30421]="36525",
[21764]="26883",
[21765]="26885",
[21754]="26887",
[21753]="26896",
[21766]="26897",
[21767]="26902",
[30422]="36526",
[21774]="26906",
[21768]="26903",
[29159]="34960",
[21775]="26907",
[21790]="26908",
[21778]="26910",
[21791]="26911",
[29160]="34961",
[23113]="28938",
[23108]="28925",
[23098]="28910",
[23103]="28916",
[23118]="28950",
[23094]="28903",
[21792]="26915",
[23095]="28905",
[28595]="34590",
[23114]="28944",
[23104]="28917",
[23099]="28912",
[23109]="28927",
[23119]="28953",
[21779]="26916",
[24074]="31048",
[24075]="31049",
[23105]="28918",
[23100]="28914",
[23096]="28906",
[23110]="28933",
[23120]="28955",
[23115]="28947",
[24076]="31050",
[32772]="41414",
[31079]="38068",
[23106]="28924",
[23097]="28907",
[23121]="28957",
[23101]="28915",
[32833]="41420",
[23116]="28948",
[28290]="34069",
[23111]="28936",
[32774]="41415",
[24078]="31052",
[24077]="31051",
[32508]="40514",
[24087]="31058",
[31863]="39463",
[24027]="31084",
[24031]="31089",
[24047]="31096",
[24065]="31112",
[24028]="31085",
[24062]="31110",
[24036]="31091",
[24050]="31099",
[24061]="31109",
[24056]="31104",
[31861]="39452",
[31865]="39462",
[24058]="31106",
[24067]="31113",
[24079]="31053",
[24060]="31108",
[24037]="31094",
[24053]="31101",
[24059]="31107",
[32836]="41429",
[24066]="31111",
[24051]="31098",
[24057]="31105",
[24030]="31088",
[24055]="31103",
[24048]="31097",
[24033]="31092",
[24054]="31102",
[24035]="31149",
[24039]="31095",
[24032]="31090",
[24029]="31087",
[24052]="31100",
[31867]="39470",
[31868]="39471",
[24088]="31060",
[24080]="31054",
[24082]="31055",
[24110]="31068",
[24106]="31067",
[24114]="31070",
[24116]="31071",
[24085]="31056",
[24092]="31062",
[24093]="31063",
[24098]="31066",
[24095]="31064",
[30825]="37855",
[24086]="31057",
[24089]="31061",
[25897]="32867",
[25899]="32869",
[24121]="31076",
[32776]="41418",
[25890]="32871",
[24117]="31072",
[25895]="32874",
[25901]="32870",
[25893]="32872",
[25896]="32866",
[32409]="39961",
[25894]="32873",
[25898]="32868",
[32410]="39963",
[24123]="31078",
[24122]="31077",
[32213]="39729",
[32193]="39705",
[32197]="39712",
[32204]="39719",
[32225]="39741",
[32194]="39706",
[32223]="39739",
[32199]="39714",
[32207]="39722",
[32220]="39736",
[32215]="39731",
[32210]="39725",
[32214]="39730",
[32217]="39733",
[32226]="39742",
[32219]="39735",
[32202]="39717",
[32209]="39724",
[32218]="39734",
[32224]="39740",
[32216]="39732",
[32196]="39711",
[32212]="39728",
[32205]="39720",
[32200]="39715",
[32211]="39727",
[32201]="39716",
[32203]="39718",
[32198]="39713",
[32195]="39710",
[31398]="38503",
[31399]="38504",
[32208]="39723",
[32221]="39737",
[32222]="39738",
[32206]="39721",
[31862]="39455",
[31860]="39451",
[31864]="39458",
[31866]="39466",
[31869]="39467",
[2302]="2149",
[7277]="9059",
[7276]="9058",
[5957]="7126",
[2304]="2152",
[2318]="2881",
[2303]="2153",
[4237]="3753",
[7278]="9060",
[7279]="9062",
[7280]="9064",
[4231]="3816",
[2300]="2160",
[5081]="5244",
[2309]="2161",
[4239]="3756",
[2310]="2162",
[2311]="2163",
[7281]="9065",
[4242]="3759",
[2312]="2164",
[4246]="3763",
[2308]="2159",
[4243]="3761",
[6466]="7953",
[6709]="8322",
[5780]="6702",
[2307]="2158",
[7282]="9068",
[5781]="6703",
[7283]="9070",
[20575]="24940",
[2317]="2169",
[4233]="3817",
[2315]="2167",
[2313]="2165",
[2319]="20648",
[6467]="7954",
[5958]="7133",
[2316]="2168",
[6468]="7955",
[5961]="7135",
[4248]="3765",
[7285]="9074",
[7284]="9072",
[2314]="2166",
[4249]="3766",
[4253]="3770",
[7352]="9147",
[4252]="3769",
[4255]="3772",
[7359]="9149",
[4254]="3771",
[7372]="9194",
[7371]="9193",
[4236]="3818",
[4265]="3780",
[4234]="20649",
[18662]="23190",
[18948]="23399",
[4456]="4097",
[4455]="4096",
[4257]="3774",
[5962]="7147",
[7373]="9195",
[5963]="7149",
[4258]="3775",
[5782]="6704",
[5964]="7151",
[7374]="9196",
[7375]="9197",
[4256]="3773",
[7377]="9198",
[4259]="3776",
[7378]="9201",
[5965]="7153",
[17721]="21943",
[7386]="9202",
[5783]="6705",
[5739]="6661",
[5966]="7156",
[7387]="9206",
[4260]="3777",
[18238]="22711",
[4264]="3779",
[8174]="10490",
[7390]="9207",
[7391]="9208",
[8172]="10482",
[8173]="10487",
[4304]="20650",
[8176]="10507",
[8175]="10499",
[8187]="10509",
[8192]="10516",
[8198]="10518",
[8189]="10511",
[8210]="10529",
[8200]="10520",
[8214]="10546",
[8211]="10544",
[8201]="10531",
[8205]="10533",
[8203]="10525",
[8347]="10619",
[8345]="10621",
[8217]="14930",
[8218]="14932",
[8204]="10542",
[8346]="10630",
[8193]="10548",
[8191]="10552",
[8197]="10558",
[8209]="10554",
[8185]="10556",
[8213]="10566",
[8216]="10562",
[8202]="10560",
[8207]="10564",
[8215]="10574",
[8212]="10572",
[8206]="10568",
[8349]="10647",
[8348]="10632",
[8208]="10570",
[15407]="19047",
[15564]="19058",
[8170]="22331",
[8367]="10650",
[15077]="19048",
[29964]="36074",
[29971]="36076",
[15045]="19050",
[29970]="36075",
[15083]="19049",
[15074]="19053",
[15076]="19051",
[15084]="19052",
[15046]="19060",
[15067]="19062",
[15061]="19061",
[15091]="19055",
[15054]="19059",
[15057]="19067",
[15064]="19068",
[15073]="19063",
[15071]="19066",
[15078]="19064",
[15092]="19065",
[20296]="24655",
[15072]="19073",
[15082]="19070",
[15093]="19072",
[15086]="19071",
[15048]="19077",
[15060]="19078",
[15056]="19079",
[15065]="19080",
[15069]="19074",
[15079]="19075",
[15053]="19076",
[15050]="19085",
[19052]="23705",
[15063]="19084",
[15066]="19086",
[19044]="23703",
[15075]="19081",
[15094]="19082",
[15087]="19083",
[16982]="20853",
[15049]="19089",
[15058]="19090",
[15070]="19087",
[15080]="19088",
[16984]="20855",
[18509]="22926",
[19157]="23708",
[19162]="23709",
[20380]="24703",
[18510]="22927",
[22665]="28224",
[22664]="28222",
[22666]="28223",
[19149]="23707",
[19163]="23710",
[16983]="20854",
[22663]="28221",
[22662]="28220",
[22661]="28219",
[18511]="22928",
[15052]="19107",
[15051]="19094",
[19688]="24124",
[19689]="24125",
[20295]="24654",
[22761]="28474",
[22760]="28473",
[22759]="28472",
[18251]="22727",
[15062]="19097",
[18504]="22921",
[19058]="23706",
[15059]="19095",
[18506]="22922",
[15138]="19093",
[19687]="24123",
[19686]="24122",
[19685]="24121",
[15047]="19054",
[20476]="24849",
[20478]="24851",
[20477]="24850",
[20481]="24846",
[20479]="24848",
[20480]="24847",
[21278]="26279",
[18508]="22923",
[19049]="23704",
[25654]="32462",
[15068]="19104",
[18258]="22815",
[15081]="19100",
[15090]="19102",
[15095]="19091",
[15096]="19103",
[25662]="32466",
[25669]="32470",
[15055]="19101",
[15085]="19098",
[15088]="19092",
[25673]="32478",
[25679]="32482",
[25650]="32456",
[21887]="32454",
[25655]="32463",
[25661]="32467",
[25674]="32479",
[25670]="32471",
[25656]="32464",
[25668]="32472",
[25675]="32480",
[29540]="35530",
[25660]="32468",
[23793]="32455",
[29975]="36079",
[29974]="36078",
[29973]="36077",
[25671]="32473",
[25676]="32481",
[29534]="35555",
[29533]="35549",
[25657]="32465",
[25659]="32469",
[25685]="32490",
[25694]="32501",
[25692]="32502",
[29488]="35524",
[29528]="35540",
[29485]="35521",
[29486]="35522",
[29487]="35523",
[29483]="35520",
[29530]="35544",
[29500]="35537",
[29499]="35536",
[29498]="35535",
[29497]="35534",
[29496]="35533",
[29495]="35532",
[29491]="35527",
[29490]="35526",
[29489]="35525",
[25686]="32493",
[25687]="32494",
[25695]="32498",
[29494]="35531",
[29493]="35528",
[29492]="35529",
[25693]="32503",
[25653]="32461",
[29531]="35539",
[25691]="32497",
[25690]="32496",
[25697]="32499",
[25696]="32500",
[25689]="32495",
[29503]="35559",
[29502]="35558",
[29512]="35567",
[29506]="35562",
[29505]="35561",
[29508]="35564",
[29511]="35573",
[29510]="35572",
[29514]="35574",
[29504]="35560",
[29507]="35563",
[29509]="35568",
[29529]="35543",
[29536]="35557",
[29535]="35554",
[29532]="35538",
[30040]="36351",
[30042]="36349",
[30046]="36352",
[32574]="41161",
[30041]="36355",
[32398]="39997",
[30045]="36358",
[30039]="36357",
[32582]="41156",
[32399]="40000",
[29516]="35576",
[29517]="35577",
[29515]="35575",
[32400]="40001",
[30043]="36359",
[32577]="41163",
[32579]="41164",
[30044]="36353",
[29520]="35582",
[29521]="35584",
[29519]="35580",
[29526]="35590",
[29527]="35591",
[29525]="35589",
[32393]="40006",
[32396]="40005",
[32394]="40003",
[32395]="40004",
[32583]="41157",
[32575]="41162",
[32580]="41158",
[32581]="41160",
[32397]="40002",
[29524]="35587",
[29523]="35588",
[29522]="35585",
[2996]="2963",
[4344]="3915",
[2570]="2387",
[10045]="12044",
[2576]="2393",
[2568]="2385",
[7026]="8776",
[10046]="12045",
[6238]="7623",
[6241]="7624",
[4343]="3914",
[4307]="3840",
[2572]="2389",
[2577]="2394",
[2575]="2392",
[6786]="8465",
[4238]="3755",
[6240]="7630",
[6239]="7629",
[4308]="3841",
[2580]="2397",
[2569]="2386",
[2578]="2395",
[6242]="7633",
[4309]="3842",
[2579]="2396",
[5762]="6686",
[2997]="2964",
[10047]="12046",
[2584]="2402",
[4240]="3757",
[4310]="3843",
[2582]="2399",
[4313]="3847",
[2583]="2401",
[4241]="3758",
[6263]="7639",
[4311]="3844",
[2587]="2406",
[2585]="2403",
[4316]="3850",
[4330]="3866",
[6787]="8467",
[4332]="3869",
[5763]="6688",
[10048]="12047",
[4315]="3849",
[6384]="7892",
[6385]="7893",
[4320]="3855",
[4331]="3868",
[4317]="3851",
[4305]="3839",
[4318]="3852",
[4319]="3854",
[4333]="3870",
[7046]="8758",
[4321]="3856",
[7047]="8780",
[7048]="8760",
[4324]="3859",
[5770]="6692",
[7049]="8782",
[4245]="3813",
[7050]="8762",
[7065]="8784",
[7051]="8764",
[4323]="3858",
[4334]="3871",
[7052]="8766",
[7053]="8786",
[4325]="3860",
[7055]="8772",
[4339]="3865",
[5764]="6693",
[7056]="8789",
[7057]="8774",
[4328]="3863",
[4326]="3861",
[5765]="6695",
[7058]="8791",
[4335]="3872",
[7054]="8770",
[7060]="8795",
[7059]="8793",
[17723]="21945",
[7061]="8797",
[7062]="8799",
[10052]="12064",
[4327]="3862",
[4329]="3864",
[9999]="12049",
[9998]="12048",
[7063]="8802",
[10054]="12075",
[10001]="12050",
[7064]="8804",
[10002]="12052",
[10055]="12080",
[10003]="12053",
[10009]="12060",
[10007]="12056",
[10004]="12055",
[10008]="12059",
[10056]="12061",
[10034]="12085",
[10035]="12089",
[10019]="12067",
[10021]="12070",
[10042]="12069",
[22246]="27658",
[10018]="12066",
[10023]="12071",
[10050]="12065",
[10040]="12091",
[10026]="12073",
[10024]="12072",
[10027]="12074",
[10025]="12086",
[10029]="12078",
[10028]="12076",
[10051]="12079",
[10053]="12077",
[10036]="12093",
[13868]="18404",
[10033]="12084",
[10031]="12082",
[10044]="12088",
[10041]="12092",
[14048]="18401",
[21154]="26403",
[21542]="26407",
[14342]="18560",
[13869]="18403",
[13856]="18402",
[14042]="18408",
[13858]="18406",
[13857]="18407",
[21340]="26085",
[14046]="18405",
[13870]="18411",
[14143]="18410",
[13860]="18409",
[14101]="18415",
[14100]="18414",
[14043]="18412",
[14142]="18413",
[14134]="18422",
[14103]="18420",
[22251]="27724",
[14044]="18418",
[22248]="27659",
[14107]="18419",
[14141]="18416",
[13863]="18417",
[14132]="18421",
[21341]="26086",
[14045]="18434",
[13871]="18424",
[13864]="18423",
[14140]="18452",
[18486]="22902",
[14139]="18448",
[14138]="18447",
[14136]="18436",
[14108]="18437",
[13865]="18438",
[19056]="23664",
[15802]="19435",
[14137]="18440",
[19047]="23662",
[14104]="18439",
[14111]="18442",
[14144]="18441",
[13866]="18444",
[18405]="22866",
[21342]="26087",
[16979]="20849",
[19165]="23667",
[16980]="20848",
[19156]="23666",
[18263]="22759",
[22658]="28208",
[22654]="28205",
[22652]="28207",
[22655]="28209",
[14146]="18454",
[14152]="18457",
[14153]="18458",
[14154]="18456",
[19059]="23665",
[19684]="24093",
[19683]="24092",
[19682]="24091",
[14156]="18455",
[18413]="22870",
[18407]="22867",
[18408]="22868",
[19050]="23663",
[18409]="22869",
[20539]="24902",
[20537]="24903",
[20538]="24901",
[22757]="28481",
[22758]="28482",
[22756]="28480",
[22249]="27660",
[14106]="18451",
[14112]="18453",
[18258]="22813",
[14155]="18445",
[13867]="18449",
[22252]="27725",
[14128]="18446",
[14130]="18450",
[21840]="26745",
[24268]="31460",
[21850]="26765",
[21849]="26764",
[21841]="26746",
[21851]="26770",
[21842]="26747",
[21852]="26771",
[24269]="31461",
[24273]="31430",
[24275]="31431",
[21853]="26772",
[21859]="26775",
[24270]="31459",
[21843]="26749",
[21854]="26773",
[21855]="26774",
[21844]="26750",
[21866]="26782",
[24251]="31437",
[24250]="31435",
[30831]="37873",
[24253]="31440",
[24252]="31438",
[30837]="37882",
[21860]="26776",
[21845]="26751",
[24272]="36686",
[24271]="31373",
[24249]="31434",
[24254]="31441",
[21869]="26756",
[21873]="26760",
[21863]="26779",
[21846]="26752",
[21867]="26783",
[30838]="37883",
[21861]="26777",
[21862]="26778",
[24257]="31444",
[21870]="26757",
[24256]="31443",
[24260]="31450",
[21874]="26761",
[24258]="31448",
[21864]="26780",
[21847]="26753",
[24255]="31442",
[24259]="31449",
[21868]="26784",
[30839]="37884",
[24267]="31456",
[24263]="31453",
[30038]="36315",
[30036]="36316",
[30037]="36317",
[30035]="36318",
[32586]="41205",
[21871]="26758",
[24276]="31433",
[32587]="41206",
[21875]="26762",
[24274]="31432",
[21865]="26781",
[32392]="40021",
[32390]="40024",
[32389]="40023",
[32391]="40020",
[21848]="26754",
[24266]="31455",
[24262]="31452",
[32585]="41208",
[32584]="41207",
[24264]="31454",
[24261]="31451",
[21872]="26759",
[21876]="26763",
[21858]="26755",
[30463]="36670",
[30038]="36315",
[30040]="36351",
[30042]="36339",
[30046]="36352",
[30036]="36316",
[30037]="36317",
[30041]="36355",
[30045]="36358",
[30035]="36318",
[30043]="36359",
[30044]="36353",
[30034]="36389",
[30033]="36391",
[30032]="36390",
[30031]="36392",
[32199]="39714",
[32210]="39725",
[32217]="39733",
[32209]="39724",
[32212]="39728",
[32211]="39727",
[32203]="39718",
[32221]="39737",
[32574]="41161",
[32579]="41164",
[32587]="41206",
[32583]="41157",
[32584]="41207",
[32580]="41158",
[32573]="41135",
[32568]="41132",
[32586]="41205",
[32744]="41156",
[32577]="41163",
[32587]="41206",
[32583]="41157",
[32575]="41162",
[32585]="41208",
[32747]="41160",
[32571]="41134",
[32570]="41133",
[30039]="36357",
[32398]="39997",
[32399]="40000",
[32400]="40001",
[32397]="40002",
[32393]="40006",
[32396]="40005",
[32394]="40003",
[32395]="40004",
[32420]="40060",
[32392]="40021",
[32390]="40024",
[32389]="40023",
[32391]="40020",
[32403]="40034",
[32401]="40036",
[32404]="40035",
[32402]="40033",
[33173]="42662",
[32213]="39729",
[32193]="39705",
[32197]="39712",
[32204]="39719",
[32225]="39741",
[32194]="39706",
[32223]="39739",
[32207]="39722",
[32220]="39736",
[32215]="39731",
[32214]="39730",
[32226]="39742",
[32219]="39735",
[32202]="39717",
[32218]="39734",
[32224]="39740",
[32206]="39721",
[32216]="39732",
[32916]="39711",
[32205]="39720",
[32200]="39715",
[32201]="39716",
[32198]="39713",
[32195]="39710",
[32208]="39723",
[32222]="39738",
[33140]="42592",
[33131]="42589",
[33133]="42558",
[33144]="42593",
[33135]="42590",
[33134]="42588",
[33143]="42591",
[33204]="42731", --Shadowprowler's Chestguard
[33122]="42546", -- Cloak of Darkness
[33208]="42736", --Flask of Chromatic Wonder
[33093]="30552",
[70]="42613",
}


TradeskillInfo_Translations = nil
