--[[
TODO: (Updated 10/25/2007

*Add Drum recipes to vendors
*Fix remaining Enchanting Oils to actually work
:ODOT

Specialcases = When there are several combines that yield the same itemid
[index or itemid]itemid|name

Combines
[index]skill|components|recipe|yield|itemid
index = itemid or -enchantid or specialcase
skill =
	A = Alchemy
	B = Blacksmithing
	Ba = Armorsmith
	Bw = Weaponsmith
	Bws = Master Swordsmith
	Bwh = Master Hammersmith
	Bwx = Master Axesmith
	N = Enchanting
	E = Engineering
	Eg = Gnomish Engineer
	Eb = Goblin Engineer
	J = Jewelcrafting
	L = Leatherworking
	Ld = Dragonscale Leatherworking
	Le = Elemental Leatherworking
	Lt = Tribal Leatherworking
	T = Tailoting
	C = Cooking
	F = First Aid
	P = Poisons
	M = Mining
	# = level
components =
  itemid[:num] ...
recipe = recipeid (Optional)
yield = how many the combine makes (Optional)
itemid = itemid crafted if it differs from index (Optional)

Components
[itemid]name/cost/source
Name
Cost (sell value for all except vendor, where it is buy value) per item
Source
	V = Vendor (Only items with unlimited supply)
	D = Dropped
	C = Crafted
	M = Mined
	H = Herbalism
	S = Skinned
	F = Fished
	E = Disenchanted
	G = Gathered (No skill required)
	P = Pickpocketed

Enchants
[-enchantid]name/description

Zones
[index]name

Vendors
[index]name|zone|faction|location|comment

Recipes
[recipeid]#|source|price|level
# = combine id
source
	D = Drop
	V = Vendor
	Q = Quest
	# index to table vendors
Price = Vendor sell price (Optional)
Level = faction rank needed (Optional)

]]

if GetLocale() ~= 'deDE' then return end;

if not TradeskillInfo or not TradeskillInfo.vars then return end
if not TradeskillInfo_Translations then
	TradeskillInfo_Translations = {}
end

-- Local translation function
local function TT(text)
	if TradeskillInfo_Translations[text] and TradeskillInfo_Translations[text] ~= "" then
		return TradeskillInfo_Translations[text]
	end
	return text
end


TradeskillInfo.vars.tradeskills = {
	['A'] = TT("Alchimie"),
	['B'] = TT("Schmiedekunst"),
	['D'] = TT("Verzauberkunst"),
	['E'] = TT("Ingenieurskunst"),
	['J'] = TT("Juwelenschleifen"),
	['L'] = TT("Lederverarbeitung"),
	['T'] = TT("Schneiderei"),
	['W'] = TT("Kochkunst"),
	['X'] = TT("Erste Hilfe"),
	['Y'] = TT("Bergbau"),
	['Z'] = TT("Gifte"),
}

TradeskillInfo.vars.specializations = {
	['a'] = "R\195\188stungsschmied",
	['w'] = "Waffenschmied",
	['ws'] = "Schwertschmiedemeister",
	['wh'] = "Hammerschmiedemeister",
	['wx'] = "Axtschmiedemeister",
	['d'] = "Drachenlederverarbeitung",
	['e'] = "Elementarlederverarbeitung",
	['t'] = "Stammeslederverarbeitung",
	['g'] = "Gnomeningenieur",
	['b'] = "Gobliningenieur",
	['p'] = "Zauberfeuerschneiderei",
	['s'] = "Schattenzwirnschneiderei",
	['m'] = "Mondstoffschneiderei",
}

TradeskillInfo.vars.sources = {
	['V'] = "Verk\195\164ufer",
	['Va'] = "Allianzverk\195\164ufer",
	['Vh'] = "Hordenverk\195\164ufer",
	['D'] = "Loot",
	['C'] = "hergestellt",
	['Ca'] = "Alchimie",
	['Cb'] = "Schmiedekunst",
	['Cn'] = "Verzauberkunst",
	['Ce'] = "Ingenieurskunst",
	['Cj'] = "Juwelenschleifen",
	['Cl'] = "Lederverarbeitung",
	['Ct'] = "Schneiderei",
	['Cc'] = "Kochkunst",
	['Cf'] = "Erste Hilfe",
	['Cp'] = "Gifte",
	['Cs'] = "Verh\195\188ttung",
	['M'] = "Bergbau",
	['Ma'] = "Kupfervorkommen",
	['Mb'] = "Zinnvorkommen",
	['Mc'] = "Silbervorkommen",
	['Md'] = "Goldvorkommen",
	['Me'] = "Eisenvorkommen",
	['Mf'] = "Mithrilablagerung",
	['Mg'] = "Echtsilberablagerung",
	['Mh'] = "Dunkeleisenablagerung",
	['Mi'] = "Hakkari Thoriumvorkommen",
	['Mj'] = "jegliches Thoriumvorkommen",
	['Mk'] = "Reiches Thoriumvorkommen",
	['Ml'] = "Teufelseisenvorkommen",
	['Mm'] = "Adamantitablagerung",
	['Mn'] = "Khoriumvorkommen",
	['H'] = "Kr\195\164uterkunde",
	['S'] = "K\195\188rschnerei",
	['Sa'] = "Wildtiere lvl 1-10",
	['Sb'] = "Wildtiere lvl 1-20",
	['Sc'] = "Wildtiere lvl 20-30",
	['Sd'] = "Wildtiere lvl 30-40",
	['Se'] = "Wildtiere lvl 40-50",
	['Sf'] = "Wildtiere lvl 50-60",
	['Sg'] = "Schattenpanther. Schlingendorntal, S\195\188mpfe des Elends", -- 7428
	['Sh'] = "Schildkr\195\182ten lvl 40-60", -- 8167
	['Si'] = "Skorpide lvl 40-50", -- 8154
	['Sj'] = "Skorpide lvl 50-60", -- 15408
	['Sk'] = "Drachkin lvl 40-60+", -- 8165
	['Sl'] = "Elite Drachkin lvl 50-60+", -- 15412, 15414, 15415, 15416,
	['Sm'] = "Winters\195\164bler. Winterspring", -- 15422
	['Sn'] = "Teufelssaurier. Ungoro Crater", -- 15417
	['So'] = "Schim\195\164ren. Azshara, Winterquell, D\195\188sterbruch", -- 15423
	['Sp'] = "W\195\182lfe lvl 40-60", -- 8368
	['Sq'] = "B\195\164ren lvl 50-60", -- 15419
	['Sr'] = "Flederm\195\164use. Zul'Gurub", -- 19767
	['Ss'] = "Tiger. Zul'Gurub", -- 19768
	['St'] = "Uralter Kernhund, Magmadar. The Molten Core", -- 17012
	['Su'] = "Silithide. Silithus", -- 20501,20498
	['Sv'] = "Emeriss, Lethon, Taerar, Ysondre", -- 20381
	['Sw'] = "Onyxia. Onyxia's Lair", -- 20381
	['Sy'] = "Wildtiere. H\195\182hlen des Wehklagens",
	['Sz'] = "Drachenwelpen. Sumpfland",
	['Saa'] = "Drachenwelpen. Rotkammgebirge",
	['Sab'] = "Drachenwelpen. S\195\188mpfe des Elends",
	['Sac'] = "Raptoren lvl 30-40",
	['F'] = "Angeln",
	['E'] = "Entzaubert",
	['Ea'] = "Gegenst\195\164nde lvl 1-20",
	['Eb'] = "Gegenst\195\164nde lvl 1-10",
	['Ec'] = "Gegenst\195\164nde lvl 11-15",
	['Ed'] = "Gegenst\195\164nde lvl 16-20",
	['Ee'] = "Gegenst\195\164nde lvl 21-30",
	['Ef'] = "Gegenst\195\164nde lvl 21-25",
	['Eg'] = "Gegenst\195\164nde lvl 26-30",
	['Eh'] = "Gegenst\195\164nde lvl 31-40",
	['Ei'] = "Gegenst\195\164nde lvl 31-35",
	['Ej'] = "Gegenst\195\164nde lvl 36-40",
	['Ek'] = "Gegenst\195\164nde lvl 41-50",
	['El'] = "Gegenst\195\164nde lvl 41-45",
	['Em'] = "Gegenst\195\164nde lvl 46-50",
	['En'] = "Gegenst\195\164nde lvl 51-60",
	['Eo'] = "Epische Gegenst\195\164nde lvl 51-60",
	['Ep'] = "Gegenst\195\164nde lvl 57-63",
	['Eq'] = "Gegenst\195\164nde lvl 64+",
	['Er'] = "Gegenst\195\164nde lvl 57+",
	['Es'] = "Epische Gegenst\195\164nde lvl 57+",
	['G'] = "gesammelt",
	['P'] = "Taschendiebstahl",
	['Q'] = "Quest",
	['Qa'] = "Allianzquest",
	['Qh'] = "Hordenquest",
	['T'] = "Lehrer",
	['Ts'] = "Spezialisierungslehrer",
	['X'] = "nicht verf\195\188gbar",
	['R'] = "Sondieren",
	['U'] = "Unbekannt",
}

TradeskillInfo.vars.specialcases = {
	[3386] = "",
	[1] = "3386|Trank der Genesung",
	[3577] = "",
	[2] = "3577|Transmutieren: Eisen in Gold",
	[6037] = "",
	[3] = "6037|Transmutieren: Mithril in Echtsilber",
	[7078] = "",
	[4] = "7078|Transmutieren: Luft zu Feuer",
	[12360] = "",
	[5] = "12360|Transmutieren: Arkanit",
	[12803] = "",
	[6] = "12803|Transmutieren: Erde zu Leben",
	[7080] = "",
	[7] = "7080|Transmutieren: Erde zu Wasser",
	[7076] = "",
	[8] = "7076|Transmutieren: Feuer zu Erde",
	[9] = "7076|Transmutieren: Leben zu Erde",
	[10] = "7080|Transmutieren: Untod zu Wasser",
	[7082] = "",
	[11] = "7082|Transmutieren: Wasser zu Luft",
	[12808] = "",
	[12] = "12808|Transmutieren: Wasser zu Untod",
	[7068] = "",
	[13] = "7068|Elementarfeuer transmutieren",
	[25867] = "",
	[14] = "25867|Transmutieren: Erdsturmdiamant",
	[23571] = "",
	[15] = "23571|Transmutieren: Urmacht",
	[25868] = "",
	[16] = "25868|Transmutieren: Himmelsfeuerdiamant",
	[21884] = "",
	[17] = "21884|Transmutieren: Urluft zu Feuer",
	[21885] = "",
	[18] = "21885|Transmutieren: Urerde zu Wasser",
	[22452] = "",
	[19] = "22452|Transmutieren: Urfeuer  zu Erde",
	[22451] = "",
	[20] = "22451|Transmutieren: Urwasser zu Luft",
	[22861] = "",
	[21] = "22861|Fl\195\164schchen des blendenden Lichts",
	[22866] = "",
	[22] = "22866|Fl\195\164schchen des reinen Todes",
	[21886] = "",
	[23] = "21886|Transmutieren: Urerde zu Leben",
	[22457] = "",
	[24] = "22457|Transmutieren: Urfeuer zu Mana",
	[25] = "22452|Transmutieren: Urleben zu Erde",
	[26] = "21884|Transmutieren: Urmana zu Feuer",
	[27] = "21885|Transmutieren: Urschatten zu Wasser",
	[22456] = "",
	[28] = "22456|Transmutieren: Urwasser zu Schatten",
--	[23575] = "",
--	[29] = "23575|Geringer Zauberschutz der Abschirmung",
--	[23576] = "",
--	[30] = "23576| Gro\195\159er Zauberschutz der Abschirmung",
--	[8364] = "",
--	[31] = "8364|Mithrilkopfforelle",
	[12655] = "",
	[32] = "12655|Verzaubertes Thorium",
	[4401] = "",
	[33] = "4401|Mechanisches Eichh\195\182rnchen",
	[21570] = "",
	[34] = "21570|Z\195\188nder f\195\188r Raketenb\195\188ndel",
	[32413] = "",
	[35] = "32413|Frostgranaten",
	[10713] = "",
	[36] = "10713|Pl\195\164ne: Veredelter Mithrilzylinder",
	[18986] = "",
	[37] = "18986|Extrem sicherer Transporter: Gadgetzan",
	[18645] = "",
	[38] = "18645|Gnomischer Alarm-O-Bot",
	[23825] = "",
	[39] = "23825|G\195\188rtel der fast perfekten Unverwundbarkeit",
	[30544] = "",
	[40] = "30544|Extrem sicherer Transporter: Toshleys Station",
	[10644] = "",
	[41] = "10644|Rezept f\195\188r Goblinraketentreibstoff",
	[10577] = "",
	[42] = "10577|Goblinm\195\182rser",
	[43] = "10577|Der M\195\182rser: Wieder aufgeladen",
	[24122] = "",
	[44] = "24122|Kronenreif der gr\195\188nen Flamme",
	[15078] = "",
	[45] = "15078|Schwere Skorpidstulpen",
	[25697] = "",
	[46] = "25697|Armschienen des Teufelspirschers",
	[2840] = "",
	[47] = "2840|Kupfer verh\195\188tten",
	[2841] = "",
	[48] = "2841|Bronze verh\195\188tten",
	[3576] = "",
	[49] = "3576|Zinn verh\195\188tten",
	[2842] = "",
	[50] = "2842|Silber verh\195\188tten",
	[3575] = "",
	[51] = "3575|Eisen verh\195\188tten",
	[52] = "3577|Gold verh\195\188tten",
	[3859] = "",
	[53] = "3859|Stahl verh\195\188tten",
	[3860] = "",
	[54] = "3860|Mithril verh\195\188tten",
	[55] = "6037|Echtsilber verh\195\188tten",
	[11371] = "",
	[56] = "11371|Dunkeleisen verh\195\188tten",
	[12359] = "",
	[57] = "12359|Thorium verh\195\188tten",
	[17771] = "",
	[58] = "17771|Elementium verh\195\188tten",
	[22573] = "",
	[59] = "22573|Erdspaltung",
	[22574] = "",
	[60] = "22574|Feuerspaltung",
	[23445] = "",
	[61] = "23445|Teufelseisen verh\195\188tten",
	[23446] = "",
	[62] = "23446|Adamantit verh\195\188tten",
	[23447] = "",
	[63] = "23447|Eternium verh\195\188tten",
	[23448] = "",
	[64] = "23448|Teufelsstahl verh\195\188tten",
	[23449] = "",
	[65] = "23449|Khorium verh\195\188tten",
	[23573] = "",
	[66] = "23573|Geh\195\164rtetes Adamantit verh\195\188tten",
	[21542] = "",
	[67] = "21542|Festlicher roter Hosenanzug",
	[18258] = "",
	[68] = "18258|Ogeranzug der Gordok",
	[69] = "18258|Ogeranzug der Gordok",
--         [22448] = "",
--         [70] = "22448|Nexusverwandlung",
    }

TradeskillInfo.vars.components = {
	[2454] = "Elixier der L\195\182wenst\195\164rke/20/Ca",
	[5997] = "Elixier der schwachen Verteidigung/5/Ca",
	[118] = "Schwacher Heiltrank/5/Ca",
	[3382] = "Schwacher Trollbluttrank/10/Ca",
	[2455] = "Schwacher Manatrank/10/Ca",
	[2456] = "Schwacher Verj\195\188ngungstrank/15/Ca",
	[4596] = "Verf\195\164rbter Heiltrank/25/Ca",
	[2457] = "Elixier der schwachen Beweglichkeit/15/Ca",
	[2458] = "Elixier der schwachen Seelenst\195\164rke/15/Ca",
	[858] = "Geringer Heiltrank/25/Ca",
	[5631] = "Wuttrank/30/Ca",
	[2459] = "Hurtigkeitstrank/25/Ca",
	[6370] = "Schwarzmaul\195\182l/10/Ca",
	[6662] = "Elixier des Riesenwuchses/95/Ca",
	[5996] = "Elixier der Wasseratmung/95/Ca",
	[3383] = "Elixier der Weisheit/100/Ca",
	[6051] = "Heiligschutztrank/62/Ca",
	[6372] = "Schwimmtempotrank/35/Ca",
	[929] = "Heiltrank/75/Ca",
	[3384] = "Schwacher Magiewiderstandstrank/20/Ca",
	[3385] = "Geringer Manatrank/30/Ca",
	[1] = "Trank der Genesung/0/Ca",
	[3386] = "Trank der Genesung/35/Ca",
	[3388] = "Starker Trollbluttrank/40/Ca",
	[3389] = "Elixier der Verteidigung/40/Ca",
	[6371] = "Feuer\195\182l/12/Ca",
	[6048] = "Schattenschutztrank/100/Ca",
	[6373] = "Elixier der Feuermacht/35/Ca",
	[3390] = "Elixier der geringen Beweglichkeit/35/Ca",
	[3391] = "Elixier der Ogerst\195\164rke/20/Ca",
	[5634] = "Trank der freien Aktion/75/Ca",
	[1710] = "Gro\195\159er Heiltrank/125/Ca",
	[3827] = "Manatrank/120/Ca",
	[3824] = "Schatten\195\182l/150/Ca",
	[6049] = "Feuerschutztrank/170/Ca",
	[3823] = "Geringer Unsichtbarkeitstrank/100/Ca",
	[3826] = "M\195\164chtiger Trollbluttrank/105/Ca",
	[3825] = "Elixier der Seelenst\195\164rke/110/Ca",
	[5633] = "Gro\195\159er Wuttrank/150/Ca",
	[8949] = "Elixier der Beweglichkeit/200/Ca",
	[17708] = "Elixier der Frostmacht/35/Ca",
	[3829] = "Frost\195\182l/150/Ca",
	[6050] = "Frostschutztrank/300/Ca",
	[6052] = "Naturschutztrank/300/Ca",
	[3828] = "Elixier der Entd. geringer Unsichtbarkeit/150/Ca",
	[8951] = "Elixier der gro\195\159en Verteidigung/200/Ca",
	[9061] = "Goblinraketentreibstoff/250/Ca",
	[10592] = "Katzenaugenelixier/150/Ca",
	[6149] = "Gro\195\159er Manatrank/120/Ca",
	[8956] = "\195\150l des Feuerbrandes/200/Ca",
	[2] = "Transmutieren: Eisen in Gold/0/Ca",
	[3577] = "Goldbarren/600/Cs",
	[3] = "Transmutieren: Mithril in Echtsilber/0/Ca",
	[6037] = "Echtsilberbarren/1250/Cs",
	[9036] = "Magiewiderstandstrank/20/Ca",
	[9149] = "Stein der Weisen/250/Ca",
	[18294] = "Elixier der verbesserten Wasseratmung/250/Ca",
	[4623] = "Geringer Steinschildtrank/375/Ca",
	[3928] = "\195\156berragender Heiltrank/250/Ca",
	[9144] = "Wildrankentrank/250/Ca",
    [9030] = "Regenerationstrank/250/Ca", -- Restorative Potion, added 8/7/2007
	[12190] = "Trank des traumlosen Schlafs/250/Ca",
	[9154] = "Elixier der Untotenentdeckung/300/Ca",
	[9210] = "Geisterfarbstoff/750/Ca",
	[9155] = "Arkanes Elixier/400/Ca",
	[9179] = "Elixier der gro\195\159en Intelligenz/1000/Ca",
	[9264] = "Elixier der Schattenmacht/35/Ca",
	[9172] = "Unsichtbarkeitstrank/500/Ca",
	[9197] = "Elixier der Traumvision/600/Ca",
	[9187] = "Elixier der gro\195\159en Beweglichkeit/600/Ca",
	[9088] = "Arthas' Gabe/250/Ca",
	[9206] = "Elixier der Riesen/700/Ca",
	[9224] = "Elixier des D\195\164monent\195\182tens/700/Ca",
	[9233] = "Elixier der D\195\164monenentdeckung/500/Ca",
	[21546] = "Elixier der gro\195\159en Feuermacht/35/Ca",
	[3387] = "Begrenzter Unverwundbarkeitstrank/30/Ca",
	[13423] = "Steinschuppen\195\182l/125/Ca",
	[13442] = "M\195\164chtiger Wuttrank/500/Ca",
	[13443] = "\195\156berragender Manatrank/400/Ca",
	[13445] = "Elixier der \195\188berragenden Verteidigung/500/Ca",
	[13447] = "Elixier der Weisen/1250/Ca",
	[4] = "Transmutieren: Luft zu Feuer/0/Ca",
	[7078] = "Essenz des Feuers/400/D",
	[5] = "Transmutieren: Arkanit/0/Ca",
	[12360] = "Arkanitbarren/5000/Ca",
	[6] = "Transmutieren: Erde zu Leben/0/Ca",
	[12803] = "Essenz des Lebens/500/D",
	[7] = "Transmutieren: Erde zu Wasser/0/Ca",
	[7080] = "Essenz des Wassers/400/D",
	[8] = "Transmutieren: Feuer zu Erde/0/Ca",
	[7076] = "Essenz der Erde/400/D",
	[9] = "Transmutieren: Leben zu Erde/0/Ca",
	[10] = "Transmutieren: Untod zu Wasser/0/Ca",
	[11] = "Transmutieren: Wasser zu Luft/0/Ca",
	[7082] = "Essenz der Luft/400/D",
	[12] = "Transmutieren: Wasser zu Untod/0/Ca",
	[12808] = "Essenz des Untodes/1000/D",
	[13453] = "Elixier der rohen Gewalt/1250/Ca",
	[20002] = "Gro\195\159er Trank des traumlosen Schlafs/1000/Ca",
	[20007] = "Magierbluttrank/1000/Ca",
	[13446] = "Erheblicher Heiltrank/1000/Ca",
	[13452] = "Elixier des Mungos/1250/Ca",
	[13455] = "Gro\195\159er Steinschildtrank/750/Ca",
	[13454] = "Gro\195\159es Arkanelixier/750/Ca",
	[20008] = "Trank der lebhaften Aktion/600/Ca",
	[13462] = "L\195\164uterungstrank/750/Ca",
	[9030] = "Regenerationstrank/200/Ca",
	[13461] = "Gro\195\159er Arkanschutztrank/750/Ca",
	[13457] = "Gro\195\159er Feuerschutztrank/750/Ca",
	[13456] = "Gro\195\159er Frostschutztrank/750/Ca",
	[13458] = "Gro\195\159er Naturschutztrank/750/Ca",
	[13459] = "Gro\195\159er Schattenschutztrank/100/Ca",
	[20004] = "Erheblicher Trollbluttrank/1000/Ca",
	[13444] = "Erheblicher Manatrank/1500/Ca",
	[19931] = "Mojowahnsinn der Gurubashi/0/Ca",
	[28103] = "Elixier des Adepten/2500/Ca",
	[13513] = "Fl\195\164schchen des chromatischen Widerstands/5000/Ca",
	[13511] = "Fl\195\164schchen der destillierten Weisheit/5000/Ca",
	[13506] = "Fl\195\164schchen der Versteinerung/5000/Ca",
	[13512] = "Fl\195\164schchen der obersten Macht/5000/Ca",
	[13510] = "Fl\195\164schchen der Titanen/5000/Ca",
	[18253] = "Erheblicher Verj\195\188ngungstrank/15/Ca",
	[28102] = "Elixier des Ansturms/2500/Ca",
	[13] = "Elementarfeuer transmutieren/0/Ca",
	[7068] = "Elementarfeuer/400/D",
	[28100] = "Fl\195\188chtiger Heiltrank/1000/Ca",
	[22823] = "Elixier der Tarnung/2500/Ca",
	[22824] = "Elixier der erheblichen St\195\164rke/2500/Ca",
	[22825] = "Elixier der Heilkraft/2500/Ca",
	[32062] = "Elixier der erheblichen Seelenst\195\164rke/0/Ca",
	[28101] = "Instabiler Manatrank/1500/Ca",
	[28104] = "Elixier des Meisters/2500/Ca",
	[22826] = "Schleichtrank/2500/Ca",
	[32063] = "Erdelixier/0/Ca",
	[32067] = "Elixier der draenischen Weisheit/0/Ca",
	[22827] = "Elixier der erheblichen Frostmacht/2500/Ca",
	[22828] = "Trank der Wahnsinnsst\195\164rke/2500/Ca",
	[31080] = "Quecksilberstein/4000/Ca",
	[22830] = "Elixier des suchenden Auges/4000/Ca",
	[22829] = "Erstklassiger Heiltrank/5000/Ca",
	[32068] = "Elixier der Eisenhaut/0/Ca",
	[22831] = "Elixier der erheblichen Beweglichkeit/4000/Ca",
	[31679] = "Elixier der Teufelsst\195\164rke/3000/Ca",
	[22871] = "Verschleierungstrank/5000/Ca",
	[22832] = "Erstklassiger Manatrank/5000/Ca",
	[22834] = "Elixier der erheblichen Verteidigung/4000/Ca",
	[22833] = "Elixier der erheblichen Feuermacht/2500/Ca",
	[31676] = "Teufelsregenerationstrank/5000/Ca",
	[13503] = "Alchimistenstein/25000/Ca",
	[14] = "Transmutieren: Erdsturmdiamant/0/Ca",
	[25867] = "Erdsturmdiamant/30000/Ca",
	[15] = "Transmutieren: Urmacht/0/Ca",
	[23571] = "Urmacht/16000/Ca",
	[16] = "Transmutieren: Himmelsfeuerdiamant/0/Ca",
	[25868] = "Himmelsfeuerdiamant/30000/Ca",
	[17] = "Transmutieren: Urluft zu Feuer/0/Ca",
	[21884] = "Urfeuer/4000/C",
	[18] = "Transmutieren: Urerde zu Wasser/0/Ca",
	[21885] = "Urwasser/4000/C",
	[19] = "Transmutieren: Urfeuer  zu Erde/0/Ca",
	[22452] = "Urerde/4000/C",
	[20] = "Transmutieren: Urwasser zu Luft/0/Ca",
	[22451] = "Urluft/4000/C",
	[22839] = "Zerst\195\182rungstrank/5000/Ca",
	[22835] = "Elixier der erheblichen Schattenmacht/6000/Ca",
	[22838] = "Hasttrank/5000/Ca",
	[22837] = "Heldentrank/5000/Ca",
	[22836] = "Erheblicher Trank des traumlosen Schlafs/5000/Ca",
	[22840] = "Elixier des erheblichen Magierbluts/6000/Ca",
	[31677] = "Teufelsmanatrank/5000/Ca",
	[21] = "Fl\195\164schchen des blendenden Lichts/0/Ca",
	[22861] = "Fl\195\164schchen des blendenden Lichts/20000/Ca",
	[22851] = "Fl\195\164schchen der St\195\164rkung/20000/Ca",
	[22853] = "Fl\195\164schchen der m\195\164chtigen Wiederherstellung/20000/Ca",
	[22] = "Fl\195\164schchen des reinen Todes/0/Ca",
	[22866] = "Fl\195\164schchen des reinen Todes/20000/Ca",
	[22854] = "Fl\195\164schchen des unerbittlichen Angriffs/20000/Ca",
	[22845] = "Erheblicher Arkanschutztrank/6000/Ca",
	[22841] = "Erheblicher Feuerschutztrank/6000/Ca",
	[22842] = "Erheblicher Frostschutztrank/6000/Ca",
	[22847] = "Erheblicher Heiligschutztrank/6000/Ca",
	[22844] = "Erheblicher Naturschutztrank/6000/Ca",
	[22846] = "Erheblicher Schattenschutztrank/6000/Ca",
	[22850] = "Erstklassiger Verj\195\188ngungstrank/7000/Ca",
	[22848] = "Elixier der Schw\195\164chung/7000/Ca",
	[22849] = "Eisenschildtrank/7000/Ca",
	[23] = "Transmutieren: Urerde zu Leben/0/Ca",
	[21886] = "Urleben/4000/C",
	[24] = "Transmutieren: Urfeuer zu Mana/0/Ca",
	[22457] = "Urmana/4000/C",
	[25] = "Transmutieren: Urleben zu Erde/0/Ca",
	[26] = "Transmutieren: Urmana zu Feuer/0/Ca",
	[27] = "Transmutieren: Urschatten zu Wasser/0/Ca",
	[28] = "Transmutieren: Urwasser zu Schatten/0/Ca",
	[22456] = "Urschatten/4000/C",
	[32839] = "Kessel des erheblichen Arkanschutzes/0/Ca",
	[32849] = "Kessel des erheblichen Feuerschutzes/0/Ca",
	[32850] = "Kessel des erheblichen Frostschutzes/0/Ca",
	[32851] = "Kessel des erheblichen Naturschutzes/0/Ca",
	[32852] = "Kessel des erheblichen Schattenschutzes/0/Ca",
	[2853] = "Kupferarmschienen/17/Cb",
	[2852] = "Kupferne Kettenhose/67/Cb",
	[10421] = "Raue Kupferweste/32/Cb",
	[2862] = "Rauer Wetzstein/3/Cb",
	[3239] = "Rauer Gewichtsstein/3/Cb",
	[2844] = "Kupferstreitkolben/106/Cb",
	[2845] = "Kupferaxt/109/Cb",
	[3469] = "Kupferne Kettenstiefel/49/Cb",
	[2847] = "Kupferkurzschwert/110/Cb",
	[3470] = "Rauer Schleifstein/5/Cb",
	[7955] = "Kupferclaymore/241/Cb",
	[7166] = "Kupferdolch/194/Cb",
	[3488] = "Kupferstreitaxt/613/Cb",
	[3471] = "Kupferne Kettenweste/142/Cb",
	[2851] = "Kupferner Ketteng\195\188rtel/56/Cb",
	[3472] = "Runenverzierte Kupferstulpen/71/Cb",
	[3473] = "Runenverzierte Kupferhose/299/Cb",
	[3474] = "Edelsteinbesetzte Kupferstulpen/216/Cb",
	[2863] = "Grober Wetzstein/10/Cb",
	[3240] = "Grober Gewichtsstein/10/Cb",
	[6214] = "Schwerer Kupferschl\195\164gel/595/Cb",
	[3489] = "Dicke Kriegsaxt/937/Cb",
	[2857] = "Runenverzierter Kupferg\195\188rtel/198/Cb",
	[3478] = "Grober Schleifstein/10/Cb",
	[2864] = "Runenverzierte Kupferbrustplatte/630/Cb",
	[2854] = "Runenverzierte Kupferarmschienen/225/Cb",
	[3487] = "Schweres Kupferbreitschwert/1498/Cb",
	[6350] = "Raue bronzene Stiefel/295/Cb",
	[6731] = "Eisenschmiedebrustplatte/871/Cb",
	[15869] = "Silberdietrich/50/Cb",
	[29201] = "Schwere bronzene Wurfspeere/150/Cb",
	[6338] = "Silberrute/125/Cb",
	[3848] = "Gro\195\159es bronzenes Messer/1426/Cb",
	[2865] = "Raue bronzene Gamaschen/962/Cb",
	[2866] = "Rauer bronzener K\195\188rass/752/Cb",
	[2848] = "Bronzener Streitkolben/1119/Cb",
	[3480] = "Raue bronzene Schultern/532/Cb",
	[5540] = "Perlengriffdolch/2107/Cb",
	[2849] = "Bronzene Axt/1269/Cb",
	[2868] = "Gemusterte bronzene Armschienen/807/Cb",
	[2850] = "Bronzenes Kurzschwert/1439/Cb",
	[3490] = "T\195\182dlicher Bronzepoignard/2731/Cb",
	[3481] = "Bronzene Schultern mit Versilberung/1284/Cb",
	[7956] = "Bronzener Kriegshammer/1944/Cb",
	[3486] = "Schwerer Schleifstein/100/Cb",
	[2871] = "Schwerer Wetzstein/40/Cb",
	[3241] = "Schwerer Gewichtsstein/40/Cb",
	[3491] = "Schwerer bronzener Streitkolben/2741/Cb",
	[3482] = "Bronzene Stiefel mit Versilberung/1317/Cb",
	[2869] = "Bronzene Brustplatte mit Versilberung/1831/Cb",
	[7957] = "Bronzenes Gro\195\159schwert/2205/Cb",
	[3483] = "Bronzene Stulpen mit Versilberung/965/Cb",
	[7958] = "Bronzene Streitaxt/2435/Cb",
	[5541] = "Schillernder Hammer/3693/Cb",
	[2870] = "Leuchtende silberne Brustplatte/2935/Cb",
	[3484] = "Gr\195\188ne Eisenstiefel/1767/Cb",
	[3492] = "M\195\164chtiger Eisenhammer/4552/Cb",
	[15870] = "Golddietrich/300/Cb",
	[3485] = "Gr\195\188ne Eisenstulpen/1295/Cb",
	[3851] = "Robuster Eisenschl\195\164gel/6258/Cb",
	[11128] = "Goldrute/500/Cb",
	[7071] = "Eiserne G\195\188rtelschnalle/100/Cb",
	[6042] = "Eisenschildstachel/250/Cb",
	[7914] = "Barbarische Eisenbrustplatte/3330/Cb",
	[3842] = "Gr\195\188ne Eisengamaschen/2906/Cb",
	[3849] = "Geh\195\164rtetes Eisenkurzschwert/5468/Cb",
	[10423] = "Bronzene Gamaschen mit Versilberung/2842/Cb",
	[7913] = "Barbarische Eisenschultern/2500/Cb",
	[3840] = "Gr\195\188ne Eisenschultern/2571/Cb",
	[3835] = "Gr\195\188ne Eisenarmschienen/1106/Cb",
	[6043] = "Eisengegengewicht/500/Cb",
	[3852] = "Goldener Eisenzerst\195\182rer/8360/Cb",
	[3843] = "Goldene Schuppengamaschen/3882/Cb",
	[3836] = "Gr\195\188ner Eisenhelm/3053/Cb",
	[7915] = "Barbarischer Eisenhelm/3337/Cb",
	[3841] = "Goldene Schuppenschultern/3106/Cb",
	[3850] = "Jadeschlangenklinge/7304/Cb",
	[3853] = "Mondstahlbreitschwert/10153/Cb",
	[3844] = "Gr\195\188ne Eisenhalsberge/5658/Cb",
	[7916] = "Barbarische Eisenstiefel/3700/Cb",
	[12259] = "Glitzernder Stahldolch/8072/Cb",
	[3855] = "Massive Eisenaxt/11248/Cb",
	[7917] = "Barbarische Eisenhandschuhe/2711/Cb",
	[3846] = "Polierte Stahlstiefel/3937/Cb",
	[6040] = "Goldene Schuppenarmschienen/1649/Cb",
	[17704] = "Schneide des Winters/9178/Cb",
	[3837] = "Goldene Schuppenhelmkappe/4405/Cb",
	[12260] = "Sengende Goldklinge/10395/Cb",
	[6041] = "Stahlwaffenkette/1500/Cb",
	[3845] = "Goldener Schuppenk\195\188rass/6558/Cb",
	[3854] = "Frosttigerklinge/14120/Cb",
	[3847] = "Goldene Schuppenstiefel/4977/Cb",
	[3856] = "Schattensichelaxt/14221/Cb",
	[7963] = "Stahlbrustplatte/6488/Cb",
	[15871] = "Echtsilberdietrich/625/Cb",
	[29202] = "Wirbelnde Stahl\195\164xte/600/Cb",
	[9060] = "Veredelter Mithrilzylinder/1000/Cb",
	[7966] = "Robuster Schleifstein/200/Cb",
	[7964] = "Robuster Wetzstein/40/Cb",
	[7965] = "Robuster Gewichtsstein/40/Cb",
	[11144] = "Echtsilberrute/1000/Cb",
	[9366] = "Goldene Schuppenstulpen/3689/Cb",
	[7919] = "Schwere Mithrilstulpen/2476/Cb",
	[7918] = "Schwere Mithrilschulter/3701/Cb",
	[7941] = "Schwere Mithrilaxt/12520/Cb",
	[7921] = "Schwere Mithrilhose/5387/Cb",
	[7920] = "Mithrilschuppenhose/8053/Cb",
	[7924] = "Mithrilschuppenarmschienen/4103/Cb",
	[7967] = "Mithrilschildstachel/250/Cb",
	[7922] = "Stahlplattenhelm/2377/Cb",
	[7942] = "Blaue glitzernde Axt/14659/Cb",
	[7927] = "Verschn\195\182rkelte Mithrilhandschuhe/2987/Cb",
	[7926] = "Verschn\195\182rkelte Mithrilhose/5952/Cb",
	[7928] = "Verschn\195\182rkelte Mithrilschulter/4857/Cb",
	[7943] = "T\195\188ckische Mithrilklinge/15891/Cb",
	[7945] = "Gro\195\159er schwarzer Streitkolben/17291/Cb",
	[7930] = "Schwere Mithrilbrustplatte/7045/Cb",
	[7931] = "Mithrilhelmkappe/7955/Cb",
	[7933] = "Schwere Mithrilstiefel/5769/Cb",
	[7932] = "Mithrilschuppenschultern/8661/Cb",
	[7969] = "Mithrilsporen/250/Cb",
	[7944] = "Funkelndes Mithrilrapier/20092/Cb",
	[7934] = "Schwerer Mithrilhelm/5790/Cb",
	[7946] = "Runenverzierter Mithrilhammer/21660/Cb",
	[12405] = "Thoriumr\195\188stung/9239/Cb",
	[12406] = "Thoriumg\195\188rtel/4636/Cb",
	[12644] = "Verdichteter Schleifstein/200/Cb",
	[12404] = "Verdichteter Wetzstein/75/Cb",
	[12643] = "Verdichteter Gewichtsstein/75/Cb",
	[7947] = "Ebenholzmesser/24892/Cb",
	[12408] = "Thoriumarmschienen/4998/Cb",
	[11606] = "Dunkeleisenpanzer/19255/Cb",
	[12416] = "Strahlender G\195\188rtel/7595/Cb",
	[11608] = "Dunkeleisenpulverisierer/45760/Cb",
	[12424] = "Imperialer Platteng\195\188rtel/5533/Cb",
	[12428] = "Imperiale Plattenschultern/8646/Cb",
	[12624] = "Wilddornpanzerung/20642/Cb",
	[11605] = "Dunkeleisenschultern/10776/Cb",
	[12425] = "Imperiale Plattenarmschienen/6044/Cb",
	[12415] = "Strahlende Brustplatte/17003/Cb",
	[11607] = "Dunkeleisenzerrei\195\159er/51225/Cb",
	[12774] = "D\195\164mmerungsschneide/36044/Cb",
	[15872] = "Arkanitdietrich/625/Cb",
	[12773] = "Verschn\195\182rkelte Thoriumhandaxt/33079/Cb",
	[12645] = "Thoriumschildstachel/500/Cb",
	[16206] = "Arkanitrute/1000/Cb",
	[12777] = "Loderflammenrapier/38648/Cb",
	[12776] = "Verzauberter Kampfhammer/48124/Cb",
	[12775] = "Gewaltige Thoriumstreitaxt/39949/Cb",
	[12409] = "Thoriumstiefel/10336/Cb",
	[12410] = "Thoriumhelm/10372/Cb",
	[11604] = "Dunkeleisenplatte/19428/Cb",
	[12628] = "D\195\164monengeschmiedete Brustplatte/16640/Cb",
	[12781] = "Beschaulichkeit/42721/Cb",
	[12418] = "Strahlende Handschuhe/10242/Cb",
	[12782] = "Verderbnis/56808/Cb",
	[12631] = "Feurige Plattenstulpen/8919/Cb",
	[19051] = "Gurt der D\195\164mmerung/9365/Cb",
	[19043] = "Schwerer G\195\188rtel der Holzschlundfeste/13291/Cb",
	[12419] = "Strahlende Stiefel/16421/Cb",
	[12792] = "Vulkanischer Hammer/39255/Cb",
	[17014] = "Dunkeleisenarmschienen/12637/Cb",
	[16989] = "Feuriger Kettengurt/18610/Cb",
	[17193] = "Sulfuronhammer/122310/Cb",
	[12632] = "Sturmstulpen/14099/Cb",
	[12426] = "Imperiale Plattenstiefel/12062/Cb",
	[12427] = "Imperialer Plattenhelm/12106/Cb",
	[12417] = "Strahlender Reif/17034/Cb",
	[19166] = "Schwarze Amnestie/46447/Cb",
	[22194] = "Dunkler Griff des Zerst\195\182rers/33521/Cb",
	[19167] = "Schattenzorn/116531/Cb",
	[19168] = "Finsterer Streiter/102890/Cb",
	[20039] = "Dunkeleisenstiefel/31709/Cb",
	[19164] = "Dunkeleisenstulpen/22425/Cb",
	[19148] = "Dunkeleisenhelm/25399/Cb",
	[17013] = "Dunkeleisengamaschen/26441/Cb",
	[19170] = "Ebenholzhand/103689/Cb",
	[16988] = "Feurige Kettenschultern/31460/Cb",
	[22671] = "Eisflucharmschienen/60635/Cb",
	[22669] = "Eisfluchbrustplatte/119683/Cb",
	[22670] = "Eisfluchstulpen/60406/Cb",
	[12641] = "Unverwundbarer Panzer/43836/Cb",
	[22198] = "Gezackter Obsidianschild/67440/Cb",
	[12640] = "L\195\182wenherzhelm/21894/Cb",
	[19169] = "Nachtlauer/129112/Cb",
	[22191] = "Obsidianpanzertunika/73128/Cb",
	[22384] = "Willensbrecher/80554/Cb",
	[22383] = "Weisenklinge/80019/Cb",
	[12639] = "Festungsstulpen/15271/Cb",
	[22196] = "Dicke Obsidianbrustplatte/48043/Cb",
	[22385] = "Gamaschen der Titanen/25276/Cb",
	[12798] = "Vernichter/57150/Cb",
	[12790] = "Arkanitchampion/74619/Cb",
	[12784] = "Arkanitschnitter/73036/Cb",
	[19690] = "Blutseelenbrustplatte/39683/Cb",
	[19692] = "Blutseelenstulpen/19980/Cb",
	[19691] = "Blutseelenschultern/29675/Cb",
	[17016] = "Dunkeleisenzerst\195\182rer/63973/Cb",
	[17015] = "Dunkeleisenh\195\164scher/63738/Cb",
	[20550] = "Dunkelrunenbrustplatte/23051/Cb",
	[20549] = "Dunkelrunenstulpen/11484/Cb",
	[20551] = "Dunkelrunenhelm/17352/Cb",
	[19693] = "Dunkelseelenbrustplatte/24192/Cb",
	[19694] = "Dunkelseelengamaschen/23555/Cb",
	[19695] = "Dunkelseelenschultern/18285/Cb",
	[12618] = "Verzauberte Thoriumbrustplatte/23972/Cb",
	[12620] = "Verzauberter Thoriumhelm/17245/Cb",
	[12619] = "Verzauberte Thoriumgamaschen/24058/Cb",
	[12797] = "Frostwache/56943/Cb",
	[19057] = "Handschuhe der D\195\164mmerung/11606/Cb",
	[12796] = "Hammer der Titanen/70912/Cb",
	[12783] = "Herzsucher/58215/Cb",
	[22197] = "Schwerer Obsidiang\195\188rtel/14282/Cb",
	[19048] = "Schwere Stiefel der Holzschlundfeste/28061/Cb",
	[12636] = "Helm des gro\195\159en H\195\164uptlings/24285/Cb",
	[22764] = "Eisenrankeng\195\188rtel/15864/Cb",
	[22762] = "Eisenrankenbrustplatte/31492/Cb",
	[22763] = "Eisenrankenhandschuhe/15806/Cb",
	[22195] = "Leichter Obsidiang\195\188rtel/22752/Cb",
	[12794] = "Meisterlicher Sturmhammer/56304/Cb",
	[12633] = "Helm der wei\195\159en Seele/14859/Cb",
	[18262] = "Elementarwetzstein/1250/Cb",
	[29203] = "Verzauberte Thoriumklingen/10000/Cb",
	[23493] = "Teufelseisenkettenhelmkappe/27683/Cb",
	[23482] = "Teufelseisenplattenhandschuhe/20269/Cb",
	[12422] = "Imperiale Plattenr\195\188stung/16204/Cb",
	[12429] = "Imperiale Plattengamaschen/17923/Cb",
	[12420] = "Strahlende Gamaschen/25330/Cb",
	[12613] = "Runenverzierte Brustplatte/18205/Cb",
	[12611] = "Runenverzierte Plattenstiefel/12293/Cb",
	[12612] = "Runenverzierter Plattenhelm/12956/Cb",
	[12614] = "Runenverzierte Plattengamaschen/18272/Cb",
	[12610] = "Runenverzierte Plattenschultern/12247/Cb",
	[12414] = "Thoriumgamaschen/17376/Cb",
	[25843] = "Teufelseisenrute/8000/Cb",
	[23528] = "Teuflischer Wetzstein/750/Cb",
	[28420] = "Teufelsgewichtsstein/750/Cb",
	[23484] = "Teufelseisenplatteng\195\188rtel/20969/Cb",
	[23491] = "Teufelseisenkettenhandschuhe/18866/Cb",
	[23497] = "Teufelseisenkriegsbeil/58164/Cb",
	[23494] = "Teufelseisenkettenarmschienen/19615/Cb",
	[23498] = "Teufelseisenhammer/8813/Cb",
	[23487] = "Teufelseisenplattenstiefel/33419/Cb",
	[23488] = "Teufelseisenplattenhose/44805/Cb",
	[23490] = "Teufelseisenkettentunika/39760/Cb",
	[23499] = "Teufelseisengro\195\159schwert/795830/Cb",
	[23502] = "Adamantitschl\195\164gel/82647/Cb",
	[23489] = "Teufelseisenbrustplatte/47475/Cb",
	[23559] = "Geringe Rune des Schutzes/750/Cb",
	[23503] = "Adamantitbeil/85143/Cb",
	[23504] = "Adamantitdolch/68364/Cb",
	[23506] = "Adamantitarmschienen/28586/Cb",
	[23508] = "Adamantithandschuhe/28793/Cb",
	[23505] = "Adamantitrapier/70380/Cb",
	[23507] = "Adamantitbrustplatte/58548/Cb",
	[23575] = "Geringer Zauberschutz der Abschirmung/1500/Cb",
	[29204] = "Fl\195\188sternde Teufelsstahlklingen/1223/Cb",
	[23515] = "Flammenbannarmschienen/29607/Cb",
	[23529] = "Adamantitwetzstein/1000/Cb",
	[28421] = "Adamantitgewichtsstein/1000/Cb",
	[25844] = "Adamantitrute/32000/Cb",
	[23576] = "Gro\195\159er Zauberschutz der Abschirmung/3000/Cb",
	[23510] = "Verzauberter Adamantitg\195\188rtel/31529/Cb",
	[23511] = "Verzauberte Adamantitstiefel/47104/Cb",
	[23516] = "Flammenbannhelm/44599/Cb",
	[23509] = "Verzauberte Adamantitbrustplatte/62984/Cb",
	[23517] = "Teufelsstahlhandschuhe/30311/Cb",
	[23518] = "Teufelsstahlgamaschen/60504/Cb",
	[23514] = "Flammenbannhandschuhe/32234/Cb",
	[23524] = "Khoriumg\195\188rtel/31103/Cb",
	[23523] = "Khoriumhose/61628/Cb",
	[23530] = "Teufelsstahlschildstachel/12000/Cb",
	[23537] = "Schwarze Teufelsstahlarmschienen/35904/Cb",
	[23539] = "Gesegnete Armschienen/36174/Cb",
	[23538] = "Armschienen der gr\195\188nen Festung/5282/Cb",
	[23555] = "Todeslied/13877/Cb",
	[23554] = "Runenverzierte Eterniumklinge/91813/Cb",
	[23542] = "Teuflisch scharfe Kampfaxt/103904/Cb",
	[23546] = "Teufelsgeh\195\164rteter Schl\195\164gel/5395/Cb",
	[23531] = "Teufelszornstulpen/29918/Cb",
	[23540] = "Teufelsstahllangschwert/103139/Cb",
	[23543] = "Teufelsstahlschneide/130359/Cb",
	[23532] = "Stulpen des eisernen Turms/35238/Cb",
	[23556] = "Hand der Ewigkeit/101609/Cb",
	[23535] = "Helm des tapferen Verteidigers/53053/Cb",
	[23541] = "Khoriumchampion/129402/Cb",
	[23536] = "Helm der Eidestreue/53248/Cb",
	[23544] = "Runenverzierter Hammer/104659/Cb",
	[23533] = "Stahlgriffstulpen/35369/Cb",
	[23534] = "Helm des Sturms/45389/Cb",
	[23512] = "Verzauberte Adamantitgamaschen/64163/Cb",
	[23519] = "Teufelsstahlhelm/45822/Cb",
	[23513] = "Flammenbannbrustplatte/64391/Cb",
	[23525] = "Khoriumstiefel/46837/Cb",
	[23520] = "Zornstahlhandschuhe/30896/Cb",
	[23521] = "Zornstahlhelm/46159/Cb",
	[23527] = "Brustplatte des Erdfriedens/54020/Cb",
	[23522] = "Zornstahlbrustplatte/61891/Cb",
	[31369] = "Brustplatte der Eiswache/73884/Cb",
	[31371] = "Helm der Eiswache/55708/Cb",
	[31370] = "Gamaschen der Eiswache/74152/Cb",
	[31364] = "Brustplatte der Wildwacht/72552/Cb",
	[31368] = "Helm der Wildwacht/55107/Cb",
	[31367] = "Gamaschen der Wildwacht/73355/Cb",
	[25845] = "Eterniumrute/40000/Cb",
	[25521] = "Gro\195\159e Rune des Schutzes/1250/Cb",
	[7929] = "Orcische Kriegsgamaschen/7739/Cb",
	[7936] = "Verschn\195\182rkelte Mithrilstiefel/6739/Cb",
	[7935] = "Verschn\195\182rkelte Mithrilbrustplatte/8368/Cb",
	[7937] = "Verschn\195\182rkelter Mithrilhelm/6763/Cb",
	[7938] = "Echtsilberstulpen/4028/Cb",
	[7939] = "Echtsilberbrustplatte/10899/Cb",
	[30069] = "Erdgeschmiedete Gamaschen/22391/Cb",
	[30070] = "Windgeschmiedete Gamaschen/19263/Cb",
	[30074] = "Schwere erdgeschmiedete Brustplatte/51597/Cb",
	[30076] = "Sturmgeschmiedete Halsberge/44570/Cb",
	[28483] = "Brustplatte der K\195\182nige/71734/Cb",
	[23563] = "Netherkettenhemd/67081/Cb",
	[28484] = "Bollwerk der K\195\182nige/84902/Cb",
	[28485] = "Bollwerk der uralten K\195\182nige/98174/Cb",
	[23565] = "Umarmung des wirbelnden Nethers/87849/Cb",
	[23564] = "Kettenhemd des wirbelnden Nethers/75985/Cb",
	[7954] = "Der Zertr\195\188mmerer/23159/Cb",
	[7961] = "Phantomklinge/25508/Cb",
	[7959] = "Verseuchung/33857/Cb",
	[30071] = "Leichte erdgeschmiedete Klinge/32222/Cb",
	[30073] = "Leichter glutgeschmiedeter Hammer/33297/Cb",
	[30072] = "Leichte himmelsgeschmiedete Axt/32340/Cb",
	[7960] = "Echtsilberchampion/38548/Cb",
	[30088] = "Himmelsgeschmiedete Gro\195\159axt/97120/Cb",
	[30087] = "Sturmgeschmiedete Axt/77416/Cb",
	[28434] = "Mondsichel/133370/Cb",
	[28431] = "Die Planaraxt/102808/Cb",
	[28432] = "Schwarze Planaraxt/117066/Cb",
	[28436] = "Blutmond/170435/Cb",
	[28435] = "Mondspaltbeil/151832/Cb",
	[28433] = "T\195\188ckische Schneide der Ebenen/134904/Cb",
	[30093] = "Gro\195\159er erdgeschmiedeter Hammer/101472/Cb",
	[30089] = "Lavageschmiedeter Kriegshammer/80037/Cb",
	[28437] = "Drachenfaust/107834/Cb",
	[28440] = "Donner/123276/Cb",
	[28441] = "Tiefendonner/140395/Cb",
	[28438] = "Drachenmal/122767/Cb",
	[28439] = "Drachenschlag/124657/Cb",
	[28442] = "Bote des Sturms/157642/Cb",
	[30086] = "Steingeschmiedetes Claymore/96412/Cb",
	[30077] = "Windgeschmiedetes Rapier/74563/Cb",
	[28425] = "Brandwache/100534/Cb",
	[28428] = "L\195\182wenherzklinge/127089/Cb",
	[28427] = "Lodernder Zorn/128528/Cb",
	[28426] = "Lodernder W\195\164chter/114486/Cb",
	[28429] = "L\195\182wenherzchampion/144720/Cb",
	[28430] = "L\195\182wenherzrichtklinge/162480/Cb",
	[6290] = "Gl\195\164nzender Kleinfisch/1/Cc",
	[2679] = "Verkohltes Wolfsfleisch/5/Cc",
	[12224] = "Knuspriger Fledermausfl\195\188gel/10/Cc",
	[17197] = "Lebkuchen/10/Cc",
	[6888] = "Kr\195\164utergebackenes Ei/10/Cc",
	[27635] = "Luchssteak/6/Cc",
	[2681] = "Ger\195\182stetes Eberfleisch/6/Cc",
	[24105] = "Ger\195\182stete Mondweidenlenden/6/Cc",
	[787] = "Glitschhautmakrele/1/Cc",
	[30816] = "Gew\195\188rzbrot/5/Cc",
	[2888] = "Eberrippchen in Biersauce/10/Cc",
	[5472] = "Spinnenkebab der Kaldorei/10/Cc",
	[2680] = "Gew\195\188rztes Wolfsfleisch/10/Cc",
	[5473] = "Skorpid Surprise/10/Cc",
	[17198] = "Eierflip/9/Cc",
	[5474] = "Ger\195\182stetes Kodofleisch/9/Cc",
	[6890] = "Ger\195\164uchertes B\195\164renfleisch/6/Cc",
	[27636] = "Fledermausbissen/25/Cc",
	[5525] = "Gekochte Muscheln/20/Cc",
	[2684] = "Kojotensteak/20/Cc",
	[5476] = "Frenzyfilet/3/Cc",
	[724] = "Pastete aus Geiferzahnleber/25/Cc",
	[6316] = "Lochfrenzy Supreme/3/Cc",
	[4592] = "Langzahniger Matschschnapper/1/Cc",
	[5095] = "Regenbogenflossenthunfisch/3/Cc",
	[5477] = "Schreitereintopf/18/Cc",
	[3220] = "Blutwurst/40/Cc",
	[22645] = "Knusperspinne Surprise/25/Cc",
	[7676] = "Disteltee/30/Cc",
	[2683] = "Krebsk\195\188chlein/25/Cc",
	[733] = "Westfalleintopf/100/Cc",
	[3662] = "Krokiliskensteak/25/Cc",
	[2687] = "Trockene Schweinerippchen/25/Cc",
	[21072] = "Ger\195\164ucherter Weisenfisch/40/Cc",
	[2682] = "Gekochte Krebsschere/25/Cc",
	[6657] = "Pikantes Deviat Supreme/5/Cc",
	[5526] = "Muschelsuppe/75/Cc",
	[5478] = "Grubenratteneintopf/70/Cc",
	[3663] = "Murlocflossensuppe/125/Cc",
	[4593] = "Stoppelf\195\188hlerwels/4/Cc",
	[5479] = "Knuspriger Donnerechsenschwanz/125/Cc",
	[1082] = "Rotkammgulasch/150/Cc",
	[1017] = "Gew\195\188rzter Wolfskebab/100/Cc",
	[3726] = "Gro\195\159es B\195\164rensteak/125/Cc",
	[3666] = "Klebriger Spinnenkuchen/100/Cc",
	[5480] = "Mageres Wildbret/95/Cc",
	[2685] = "Saftige Schweinerippchen/75/Cc",
	[3664] = "Krokiliskengumbo/100/Cc",
	[5527] = "Scharfe Muscheln nach Goblinart/95/Cc",
	[3727] = "Scharfe L\195\182wenkoteletts/125/Cc",
	[12209] = "Mageres Wolfsteak/95/Cc",
	[3665] = "Seltsam schmeckendes Omelett/150/Cc",
	[20074] = "Schwerer Krokiliskeneintopf/300/Cc",
	[3728] = "Schmackhaftes L\195\182wensteak/300/Cc",
	[4457] = "Gegrillter Bussardfl\195\188gel/300/Cc",
	[12213] = "Aas Surprise/300/Cc",
	[6038] = "Riesenmuschelrisotto/312/Cc",
	[10841] = "Golddorntee/85/Cc",
	[13851] = "Scharfe Wolfrippchen/312/Cc",
	[12212] = "Dschungeleintopf/300/Cc",
	[31] = "Mithrilkopfforelle/0/Cc",
	[8364] = "Mithrilkopfforelle/6/Cc",
	[12214] = "Eigenartiger Eintopf/300/Cc",
	[12210] = "Ger\195\182steter Raptor/300/Cc",
	[4594] = "Steinschuppenkabeljau/6/Cc",
	[21217] = "Weisenfisch Supreme/125/Cc",
	[3729] = "Milde Schildkr\195\182tensuppe/300/Cc",
	[12217] = "Drachenodemchili/300/Cc",
	[12215] = "Schwerer Kodoeintopf/300/Cc",
	[17222] = "Spinnenwurst/300/Cc",
	[13927] = "Gekochter gl\195\164nzender Machtfisch/8/Cc",
	[13930] = "Rotkiemenfilet/5/Cc",
	[12218] = "Monsteromelett/300/Cc",
	[12216] = "Gew\195\188rzter Chilikrebs/300/Cc",
	[6887] = "T\195\188pfelgelbschwanz/5/Cc",
	[18045] = "Zartes Wolfsteak/300/Cc",
	[16766] = "Undermine-Muschelsuppe/100/Cc",
	[13928] = "Gegrillter Kalmar/8/Cc",
	[13929] = "Scharfer ger\195\164ucherter Barsch/10/Cc",
	[13931] = "Nachtflossensuppe/12/Cc",
	[13932] = "Ged\195\188nsteter Sonnenschuppenlachs/12/Cc",
	[13935] = "Gebackener Lachs/10/Cc",
	[13933] = "Hummereintopf/14/Cc",
	[13934] = "Machtfischsteak/18/Cc",
	[18254] = "Runn Tum Knolle Surprise/18/Cc",
	[20452] = "Ger\195\164ucherte W\195\188stenkn\195\182del/250/Cc",
	[27661] = "Schwarzgebratene Forelle/150/Cc",
	[27651] = "Bussardbissen/150/Cc",
	[30155] = "Muschelriegel/150/Cc",
	[21023] = "Dirges abgefahrene Chimaerokkoteletts/250/Cc",
	[27662] = "Teufelsfinne Supreme/150/Cc",
	[27655] = "Hei\195\159er Hetzer/150/Cc",
	[27663] = "Schwarzgebratener Sporenfisch/150/Cc",
	[27656] = "Sporlingschmaus/150/Cc",
	[27657] = "Schwarzgebratener Basilisk/150/Cc",
	[27664] = "Gegrillter Matschflosser/150/Cc",
	[27665] = "Ged\195\188nstete Blauflosse/150/Cc",
	[27666] = "Goldfischst\195\164bchen/150/Cc",
	[27658] = "Ger\195\182steter Grollhuf/150/Cc",
	[27660] = "Talbuksteak/150/Cc",
	[27659] = "Doppelwarper/150/Cc",
	[31673] = "Knusperschlange/150/Cc",
	[31672] = "Rippchen der Mok'Nathal/150/Cc",
	[27667] = "W\195\188rziger Flusskrebs/150/Cc",
	[33052] = "Fischerschmaus/0/Cc",
	[33053] = "Hei\195\159e Forelle in Butter/0/Cc",
	[33048] = "Ged\195\164mpfte Forelle/0/Cc",
	[6218] = "Runenverzierte Kupferrute/24/Cn",
	[11287] = "Geringer Magiezauberstab/104/Cn",
	[20744] = "Schwaches Zauber\195\182l/100/Cn",
	[11288] = "Gro\195\159er Magiezauberstab/466/Cn",
	[6339] = "Runenverzierte Silberrute/24/Cn",
	[20745] = "Schwaches Mana\195\182l/1000/Cn",
	[11130] = "Runenverzierte Goldrute/500/Cn",
	[11289] = "Geringer Mystikerzauberstab/2148/Cn",
	[11290] = "Gro\195\159er Mystikerzauberstab/3157/Cn",
	[20746] = "Geringes Zauber\195\182l/1000/Cn",
	[11145] = "Runenverzierte Echtsilberrute/1250/Cn",
	[12810] = "Verzaubertes Leder/500/Cn",
	[12655] = "Verzauberter Thoriumbarren/500/Cn",
	[20747] = "Geringes Mana\195\182l/1000/Cn",
	[11811] = "Rauchendes Herz des Berges/1500/Cn",
	[20750] = "Zauber\195\182l/1000/Cn",
	[16207] = "Runenverzierte Arkanitrute/1250/Cn",
	[20748] = "Hervorragendes Mana\195\182l/800/Cn",
	[20749] = "Hervorragendes Zauber\195\182l/600/Cn",
	[22461] = "Runenverzierte Teufelseisenrute/1250/Cn",
	[22521] = "\195\156berragendes Mana\195\182l/1500/Cn",
	[22460] = "Prismasph\195\164re/0/Cn",
	[22449] = "Gro\195\159er Prismasplitter/0/Eq",
	[22522] = "\195\156berragendes Zauber\195\182l/1500/Cn",
	[22459] = "Sph\195\164re der Leere/0/Cn",
	[22462] = "Runenverzierte Adamantitrute/32000/Cn",
	[22463] = "Runenverzierte Eterniumrute/40000/Cn",
	[8067] = "Gefertigtes leichtes Geschoss/0/Ce",
	[4357] = "Raues Sprengpulver/4/Ce",
	[4358] = "Raues Dynamit/30/Ce",
	[4359] = "Eine Hand voll Kupferbolzen/12/Ce",
	[4360] = "Raue Kupferbombe/60/Ce",
	[4362] = "Raues Schie\195\159eisen/187/Ce",
	[6219] = "Bogenlichtschraubenschl\195\188ssel/144/Ce",
	[4361] = "Kupferrohr/120/Ce",
	[4405] = "Kunstloses Zielfernrohr/125/Ce",
	[4363] = "Kupfermodulator/50/Ce",
	[4364] = "Grobes Sprengpulver/12/Ce",
	[4365] = "Grobes Dynamit/75/Ce",
	[8068] = "Gefertigtes schweres Geschoss/0/Ce",
	[33] = "Mechanisches Eichh\195\182rnchen/0/Ce",
	[4401] = "Kasten mit mechanischem Eichh\195\182rnchen/100/Ce",
	[4366] = "Zielattrappe/75/Ce",
	[4404] = "Silberkontakt/25/Ce",
	[4368] = "Fliegerbrille/408/Ce",
	[6714] = "EZ-Thro-Dynamit/75/Ce",
	[6712] = "\195\156bungsschloss/12/Ce",
	[4367] = "Kleine Zephyriumladung/150/Ce",
	[4369] = "T\195\182dliche Donnerb\195\188chse/1179/Ce",
	[4371] = "Bronzer\195\182hre/200/Ce",
	[4370] = "Gro\195\159e Kupferbombe/175/Ce",
	[4406] = "Standardzielfernrohr/600/Ce",
	[4372] = "Liebevoll hergestelltes Schie\195\159eisen/1800/Ce",
	[4373] = "Schattenschutzbrille/722/Ce",
	[4374] = "Kleine Bronzebombe/200/Ce",
	[7506] = "Gnomenuniversalfernbedienung/500/Ce",
	[8069] = "Gefertigtes robustes Geschoss/0/Ce",
	[4376] = "Flammendeflektor/200/Ce",
	[4377] = "Schweres Sprengpulver/150/Ce",
	[4378] = "Schweres Dynamit/350/Ce",
	[21558] = "Kleine blaue Rakete/6/Ce",
	[21559] = "Kleine gr\195\188ne Rakete/6/Ce",
	[21557] = "Kleine rote Rakete/6/Ce",
	[4375] = "Surrendes bronzenes Dingsda/115/Ce",
	[4379] = "Versilberte Schrotflinte/2357/Ce",
	[4381] = "Schwacher Rekombobulator/600/Ce",
	[5507] = "Verschn\195\182rkeltes Handfernrohr/600/Ce",
	[4380] = "Gro\195\159e Bronzebombe/500/Ce",
	[4383] = "Mondsichtgewehr/3183/Ce",
	[4382] = "Bronzeger\195\188st/600/Ce",
	[4386] = "Eisdeflektor/175/Ce",
	[4385] = "Schutzbrille mit gr\195\188nen Gl\195\164sern/1410/Ce",
	[6533] = "Aquadynamischer Fischanlocker/62/Ce",
	[9312] = "Blaues Feuerwerk/12/Ce",
	[4388] = "Diskombobulatorstrahl/1000/Ce",
	[4384] = "Explodierendes Schaf/1000/Ce",
	[10558] = "Goldkraftkern/250/Ce",
	[9313] = "Gr\195\188nes Feuerwerk/12/Ce",
	[9318] = "Rotes Feuerwerk/12/Ce",
	[4387] = "Eisenstrebe/400/Ce",
	[7148] = "Goblin\195\188berbr\195\188ckungskabel/21/Ce",
	[4403] = "Tragbarer bronzener M\195\182rser/2000/Ce",
	[4407] = "Genaues Zielfernrohr/1200/Ce",
	[4389] = "Gyrochronatom/750/Ce",
	[10499] = "Hellaugenschutzbrille/2105/Ce",
	[4391] = "Kompaktes Ernteschnitterset/4000/Ce",
	[10498] = "Gyromatischer Mikroregler/16/Ce",
	[4390] = "Eisengranate/500/Ce",
	[21589] = "Gro\195\159e blaue Rakete/12/Ce",
	[21590] = "Gro\195\159e gr\195\188ne Rakete/12/Ce",
	[21592] = "Gro\195\159e rote Rakete/12/Ce",
	[10505] = "Robustes Sprengpulver/250/Ce",
	[10507] = "Robustes Dynamit/350/Ce",
	[4393] = "Handwerkermonokel/2632/Ce",
	[4392] = "Hochentwickelte Zielattrappe/2500/Ce",
	[4852] = "Blitzstrahlbombe/300/Ce",
	[4394] = "Gro\195\159e Eisenbombe/750/Ce",
	[4397] = "Gnomisches Verbergungsger\195\164t/5000/Ce",
	[4396] = "Mechanischer Drachling/6000/Ce",
	[17716] = "Schneemeister 9000/7500/Ce",
	[4395] = "Goblinlandmine/1600/Ce",
	[10559] = "Mithrilrohr/750/Ce",
	[18588] = "EZ-Thro-Dynamit II/200/Ce",
	[4398] = "Gro\195\159e Zephyriumladung/900/Ce",
	[11590] = "Mechanisches Reparierset/250/Ce",
	[10560] = "Instabiler Ausl\195\182ser/1000/Ce",
	[10500] = "Feuerschutzbrille/3478/Ce",
	[10508] = "Mithrildonnerb\195\188chse/8958/Ce",
	[10512] = "Stark einschlagende Mithrilpatronen/2/Ce",
	[10546] = "T\195\182dliches Zielfernrohr/1500/Ce",
	[10721] = "Gnomenungl\195\188cksverhinderungsg\195\188rtel/3317/Ce",
	[10561] = "Mithrilgeh\195\164use/1000/Ce",
	[10514] = "Mithrilschrapnellbombe/750/Ce",
	[10501] = "Ultraschutzbrille der Katzensicht/4398/Ce",
	[10510] = "Schwerkalibriges Mithrilgewehr/11369/Ce",
	[10518] = "Fallschirmumhang/4696/Ce",
	[10502] = "Zaubermachtschutzbrille Xtrem/4088/Ce",
	[21571] = "Blaues Raketenb\195\188ndel/25/Ce",
	[21569] = "Z\195\188nder f\195\188r Feuerwerk/0/Ce",
	[21574] = "Gr\195\188nes Raketenb\195\188ndel/25/Ce",
	[21576] = "Rotes Raketenb\195\188ndel/25/Ce",
	[10506] = "Helm des Tiefseetauchers/5227/Ce",
	[10503] = "Rosarote Schutzbrille/5169/Ce",
	[10562] = "Hochexplosive Bombe/750/Ce",
	[10548] = "Heckensch\195\188tzenzielfernrohr/2500/Ce",
	[10504] = "Gr\195\188ne Linse/7770/Ce",
	[10513] = "Gyromithrilgeschoss/5/Ce",
	[15992] = "Dichtes Sprengpulver/250/Ce",
	[18641] = "Dichtes Dynamit/500/Ce",
	[10576] = "Mechanischer Mithrildrachling/6000/Ce",
	[15846] = "Salzstreuer/7500/Ce",
	[19026] = "Schlangenexplosionsfeuerwerk/250/Ce",
	[21277] = "Ruhiger mechanischer Yeti/1250/Ce",
	[18634] = "Gyrofrosteisreflektor/12500/Ce",
	[15995] = "Thoriumgewehr/19739/Ce",
	[15993] = "Thoriumgranate/1500/Ce",
	[15994] = "Thoriumapparat/2500/Ce",
	[18631] = "Echtsilberumwandler/3000/Ce",
	[15996] = "Lebensechte mechanische Kr\195\182te/2500/Ce",
	[15999] = "Zaubermachtschutzbrille Xtrem Plus/9002/Ce",
	[16004] = "Dunkeleisengewehr/29152/Ce",
	[18637] = "Gro\195\159er Rekombobulator/600/Ce",
	[34] = "Z\195\188nder f\195\188r Raketenb\195\188ndel/0/Ce",
	[21570] = "Z\195\188nder f\195\188r Raketenb\195\188ndel/0/Ce",
	[7191] = "Verschmorte Verkabelung/0/D",
	[21714] = "Gro\195\159es blaues Raketenb\195\188ndel/50/Ce",
	[21716] = "Gro\195\159es gr\195\188nes Raketenb\195\188ndel/50/Ce",
	[21718] = "Gro\195\159es rotes Raketenb\195\188ndel/50/Ce",
	[16023] = "Meisterliche Zielattrappe/10000/Ce",
	[18594] = "M\195\164chtige Zephyriumladung/3000/Ce",
	[16000] = "Thoriumr\195\182hre/3750/Ce",
	[15997] = "Thoriumpatronen/10/Ce",
	[16005] = "Dunkeleisenbombe/1250/Ce",
	[16006] = "Empfindlicher Arkanitwandler/10000/Ce",
	[18638] = "Hyperstrahlender Flammenreflektor/12500/Ce",
	[16008] = "Schutzbrille des Meisteringenieurs/11739/Ce",
	[16009] = "Modularer Stimmenverst\195\164rker/5930/Ce",
	[18282] = "Kernscharfsch\195\188tzengewehr/66347/Ce",
	[18168] = "Machtreaktive Scheibe/56416/Ce",
	[16022] = "Arkanitdrachling/40000/Ce",
	[18283] = "Biznicks 247x128 treffsicheres Zielfernrohr/25000/Ce",
	[19999] = "Blutrebenschutzbrille/18639/Ce",
	[19998] = "Blutrebenlinse/23211/Ce",
	[16007] = "Fehlerloses Arkanitgewehr/40625/Ce",
	[18639] = "Ultrablendender Schattenreflektor/12500/Ce",
	[16040] = "Arkane Bombe/4000/Ce",
	[23781] = "Elementarsprengpulver/500/Ce",
	[23736] = "Teufelseisenbombe/2500/Ce",
	[23782] = "Teufelseisengeh\195\164use/8000/Ce",
	[18232] = "Feldreparaturbot 74A/10000/Ce",
	[23783] = "Eine Hand voll Teufelseisenbolzen/1500/Ce",
	[23821] = "Schockdrosselnder Partikelextraktor/15000/Ce",
	[23772] = "Teufelseisenpatronen/20/Ce",
	[23742] = "Teufelseisenmuskete/5538/Ce",
	[23774] = "Werkzeugkasten aus Teufelseisen/30000/Ce",
	[23784] = "Adamantitrahmen/10000/Ce",
	[23737] = "Adamantitgranate/2500/Ce",
	[23767] = "Krachbummroboter/16179/Ce",
    [33092] = "Heiltrankeinspritzung/0/Ce",
    [33093] = "Manatrankeinspritzung/0/Ce",
	[34504] = "Maschine f\195\188r Adamantitpatronen/25/Ce",
	[23764] = "Adamantitzielfernrohr/2500/Ce",
	[23771] = "Gr\195\188nes Rauchsignal/80/Ce",
	[32423] = "Eisiger Sprengz\195\188nder/0/Ce",
	[25886] = "Violettes Rauchsignal/0/Ce",
	[23768] = "Wei\195\159es Rauchsignal/19489/Ce",
	[23758] = "Zahnradbrille/29667/Ce",
	[23761] = "Energieverst\195\164rkungsbrille/20534/Ce",
	[32478] = "Totmacherbrille X11/0/Ce",
	[32494] = "Holobrille der Zerst\195\182rung/0/Ce",
	[32461] = "Gizmatische Wahnsinnsbrille/0/Ce",
	[32476] = "Gadgetsturmbrille/0/Ce",
	[32472] = "Gerechtomatbrille 2000/0/Ce",
	[32475] = "Lebensreplikatorbrille/0/Ce",
	[32480] = "Mondlupenbrille/0/Ce",
	[32495] = "Superheillinse 4000/0/Ce",
	[32474] = "Volltrefferbrille v2.0/0/Ce",
	[32473] = "Panzatronikbrille/0/Ce",
	[32479] = "Wunderheilbinokel XT40/0/Ce",
	[23762] = "Ultraspektropische Enth\195\188llungsbrille/25324/Ce",
	[23746] = "Adamantitgewehr/55725/Ce",
	[23819] = "Elementare Zephyriumladung/0/Ce",
	[23787] = "Teufelsstahlstabilisator/12000/Ce",
	[23785] = "Geh\195\164rtetes Adamantitrohr/30000/Ce",
	[23786] = "Khoriumkraftkern/12000/Ce",
	[23824] = "Raketenstiefel Xtreme/32734/Ce",
	[23747] = "Teufelsstahlschie\195\159eisen/62413/Ce",
	[23763] = "Extremsichtbrille/31774/Ce",
	[23765] = "Khoriumzielfernrohr/2500/Ce",
	[32756] = "Gyrobalancierter Khoriumzerst\195\182rer/0/Ce",
	[23748] = "Verschn\195\182rkeltes Khoriumgewehr/66312/Ce",
	[23766] = "Geeichtes Eterniumzielfernrohr/20000/Ce",
	[23820] = "Tiervergr\195\182\195\159erer/0/Ce",
	[35] = "Frostgranaten/0/Ce",
	[32413] = "Frostgranate/0/Ce",
	[23769] = "Rotes Rauchsignal/0/Ce",
	[10716] = "Gnomenschrumpfstrahl/750/Ce",
	[36] = "Pl\195\164ne: Veredelter Mithrilzylinder/0/Ce",
	[10713] = "Pl\195\164ne: Veredelter Mithrilzylinder/500/Ce",
	[11826] = "Lil' Smoky/2500/Ce",
	[10545] = "Gnomenschutzbrille/3929/Ce",
	[10720] = "Gnomen-Net-o-Matik-Projektor/750/Ce",
	[10724] = "Gnomenraketenstiefel/4696/Ce",
	[10725] = "Gnomenkampfhuhn/1500/Ce",
	[10726] = "Gnomengedankenkontrollkappe/5520/Ce",
	[10645] = "Gnomentodesstrahl/750/Ce",
	[37] = "Extrem sicherer Transporter: Gadgetzan/0/Ce",
	[18986] = "Extrem sicherer Transporter: Gadgetzan/5000/Ce",
	[18660] = "Weltvergr\195\182\195\159erer/7500/Ce",
	[38] = "Gnomischer Alarm-O-Bot/0/Ce",
	[18645] = "Gnomischer Alarm-O-Bot/1500/Ce",
	[23841] = "Gnomisches Flammengesch\195\188tz/3000/Ce",
	[23835] = "Gnomischer Gefl\195\188gelisierer/22500/Ce",
	[39] = "G\195\188rtel der fast perfekten Unverwundbarkeit/0/Ce",
	[23825] = "G\195\188rtel der fast perfekten Unverwundbarkeit/11565/Ce",
	[40] = "Extrem sicherer Transporter: Toshleys Station/0/Ce",
	[30544] = "Extrem sicherer Transporter: Toshleys Station/5000/Ce",
	[23829] = "Gnomische Kampfschutzbrille/38321/Ce",
	[23828] = "Gnomische Machtschutzbrille/30547/Ce",
	[10543] = "Goblinschutzhelm/3517/Ce",
	[10542] = "Goblinbergbauhelm/5255/Ce",
	[41] = "Rezept f\195\188r Goblinraketentreibstoff/0/Ce",
	[10644] = "Rezept: Goblinraketentreibstoff/500/Ce",
	[10646] = "Goblinpioniersprengladung/500/Ce",
	[11825] = "Winzige wandelnde Bombe/2500/Ce",
	[42] = "Goblinm\195\182rser/0/Ce",
	[43] = "Der M\195\182rser: Wieder aufgeladen/0/Ce",
	[7189] = "Goblinraketenstiefel/4712/Ce",
	[10587] = "Goblinbombenspender/1500/Ce",
	[10586] = "Der Gro\195\159e/750/Ce",
	[10727] = "Goblindrachenwerfer/2000/Ce",
	[10588] = "Goblinraketenhelm/5834/Ce",
	[18984] = "Dimensionszerfetzer: Ewige Warte/5000/Ce",
	[18587] = "Goblin\195\188berbr\195\188ckungskabel XL/2000/Ce",
	[23826] = "Der Gr\195\182\195\159ere/3000/Ce",
	[23827] = "Super Pioniersprengladung/4000/Ce",
	[23836] = "Goblinraketenwerfer/4000/Ce",
	[30542] = "Dimensionszerfetzer: Area 52/5000/Ce",
	[23838] = "Verzauberter Helm des Vorarbeiters/29454/Ce",
	[23839] = "Verst\195\164rkter Helm des Vorarbeiters/44345/Ce",
	[1251] = "Leinenverband/10/Cf",
	[2581] = "Schwerer Leinenverband/20/Cf",
	[6452] = "Gegengift/28/Cf",
	[3530] = "Wollverband/28/Cf",
	[3531] = "Schwerer Wollverband/57/Cf",
	[6453] = "Starkes Gegengift/62/Cf",
	[6450] = "Seidenverband/200/Cf",
	[6451] = "Schwerer Seidenverband/400/Cf",
	[8544] = "Magiestoffverband/400/Cf",
	[8545] = "Schwerer Magiestoffverband/600/Cf",
	[14529] = "Runenstoffverband/500/Cf",
	[14530] = "Schwerer Runenstoffverband/1000/Cf",
	[19440] = "M\195\164chtiges Gegengift/500/Cf",
	[21990] = "Netherstoffverband/1500/Cf",
	[21991] = "Schwerer Netherstoffverband/2250/Cf",
	[20906] = "Umflochtener Kupferring/250/Cj",
	[21931] = "Geflochtener Kupferring/250/Cj",
	[20816] = "Feiner Kupferdraht/20/Cj",
	[25498] = "Raue Steinstatue/25/Cj",
	[21932] = "Schwerer Kupferring/250/Cj",
	[25438] = "Malachitanh\195\164nger/750/Cj",
	[25439] = "Tigeraugenband/250/Cj",
	[20821] = "Veredelter Malachitring/1064/Cj",
	[21934] = "Verzierte Tigeraugenhalskette/1500/Cj",
	[20818] = "Eleganter Silberring/625/Cj",
	[20907] = "Robuster Bronzering/300/Cj",
	[21933] = "Dicke Bronzehalskette/750/Cj",
	[20817] = "Bronzefassung/100/Cj",
	[25880] = "Grobe Steinstatue/150/Cj",
	[20820] = "Einfacher Perlenring/1064/Cj",
	[30804] = "Bronzeband der Kraft/1064/Cj",
	[20823] = "Band der Schwermut/837/Cj",
	[30419] = "Blitzende Halskette/750/Cj",
	[31154] = "Bronzehalsring/750/Cj",
	[20827] = "Ring der Silbermacht/875/Cj",
	[20826] = "Schwerer silberner Ring/2207/Cj",
	[20828] = "Ring des Zwielichts/677/Cj",
	[30420] = "Schwerer Jadering/677/Cj",
	[20830] = "Amulett des Mondes/1535/Cj",
	[20909] = "Barbarisches Eisenhalsband/1010/Cj",
	[25881] = "Schwere Steinstatue/25/Cj",
	[20832] = "Krone der Mondseele/1800/Cj",
	[20950] = "Anh\195\164nger des Achatschilds/1535/Cj",
	[20954] = "Schwerer Eisenschlagring/5681/Cj",
	[20833] = "T\195\188ckischer Mondsteinring/54/Cj",
	[20955] = "Goldener Drachenring/665/Cj",
	[20958] = "Citrinring der Loderflamme/1130/Cj",
	[20831] = "Schwere goldene Halskette des Kampfes/1535/Cj",
	[20963] = "Filigranarbeit aus Mithril/900/Cj",
	[20966] = "Jadeanh\195\164nger der Zauberwucht/3482/Cj",
	[20960] = "Gravierter Echtsilberring/1720/Cj",
	[20959] = "Das Jadeauge/1720/Cj",
	[25882] = "Robuste Steinstatue/1000/Cj",
	[29157] = "Goldring der Macht/1500/Cj",
	[20961] = "Citrinring der rapiden Heilung/21633/Cj",
	[20967] = "Citrinanh\195\164nger der goldenen Heilung/3482/Cj",
	[29158] = "Echtsilberring des Kommandanten/1750/Cj",
	[21756] = "Figur - Goldener Hase/1500/Cj",
	[21748] = "Figur - Jadeeule/1500/Cj",
	[20964] = "Aquamarinsiegel/6646/Cj",
	[21758] = "Figur - Schwarzer Perlenpanther/1500/Cj",
	[21755] = "Aquamarinanh\195\164nger des Kriegers/1230/Cj",
	[20969] = "Rubinkrone der Wiederherstellung/5989/Cj",
	[21760] = "Figur - Echtsilberkrebs/1500/Cj",
	[25883] = "Verdichtete Steinstatue/14087/Cj",
	[21752] = "Thoriumfassung/1250/Cj",
	[30421] = "Roter Ring der Zerst\195\182rung/2542/Cj",
	[21763] = "Figur - Echtsilbereber/1500/Cj",
	[21764] = "Rubinanh\195\164nger des Feuers/6420/Cj",
	[21765] = "Echtsilberring der Heilung/2542/Cj",
	[21754] = "Der Aquamarinbesch\195\188tzer/4307/Cj",
	[21753] = "Edelsteinbesetztes Band/5000/Cj",
	[21766] = "Opalhalskette des Einschlags/830/Cj",
	[21769] = "Figur - Rubinschlange/1500/Cj",
	[21767] = "Einfacher Opalring/8375/Cj",
	[30422] = "Diamantener Fokusring/8375/Cj",
	[21774] = "Smaragdkrone der Zerst\195\182rung/1/Cj",
	[21768] = "Saphirsiegel/12500/Cj",
	[29159] = "Leuchtendes Thoriumband/8375/Cj",
	[21775] = "Ring des Ansturms/8375/Cj",
	[21790] = "Saphiranh\195\164nger der Winternacht/7767/Cj",
	[21777] = "Figur - Smaragdeule/3750/Cj",
	[21778] = "Ring der qualvollen Schatten/18662/Cj",
	[21791] = "Lebendiger Smaragdanh\195\164nger/14059/Cj",
	[29160] = "Smaragdring des L\195\182wen/9125/Cj",
	[21784] = "Figur - Schwarzer Diamantkrebs/15000/Cj",
	[21789] = "Figur - Dunkeleisenskorpid/15000/Cj",
	[23113] = "Brillantierter Golddraenit/10000/Cj",
	[23108] = "Leuchtender Schattendraenit/10000/Cj",
	[23098] = "Gravierter Flammenspessarit/10000/Cj",
	[23103] = "Strahlender Tiefenperidot/10000/Cj",
	[23118] = "Gediegener Azurmondstein/10000/Cj",
	[23094] = "Tr\195\164nenf\195\182rmiger Blutgranat/10000/Cj",
	[21792] = "Halskette des Diamantturms/25218/Cj",
	[23095] = "Klobiger Blutgranat/10000/Cj",
	[28595] = "Heller Blutgranat/10000/Cj",
	[23114] = "Schimmernder Golddraenit/10000/Cj",
	[23104] = "Gezackter Tiefenperidot/10000/Cj",
	[23099] = "Gl\195\164nzender Flammenspessarit/10000/Cj",
	[23109] = "K\195\182niglicher Schattendraenit/10000/Cj",
	[23119] = "Funkelnder Azurmondstein/10000/Cj",
	[21779] = "Band des Naturfeuers/21305/Cj",
	[24074] = "Teufelseisenblutring/24491/Cj",
	[24075] = "Golddraenitring/24491/Cj",
	[23105] = "Robuster Tiefenperidot/10000/Cj",
	[23100] = "Glitzernder Flammenspessarit/10000/Cj",
	[23096] = "Runenverzierter Blutgranat/10000/Cj",
	[23110] = "Unbest\195\164ndiger Schattendraenit/10000/Cj",
	[23120] = "St\195\188rmischer Azurmondstein/10000/Cj",
	[23115] = "Kompakter Golddraenit/10000/Cj",
	[24076] = "Azurmondsteinring/3769/Cj",
	[32772] = "Blitzendes Perlenband/0/Cj",
	[31079] = "Quecksilberadamantit/10000/Cj",
	[23106] = "Schillernder Tiefenperidot/20000/Cj",
	[23097] = "Feingeschliffener Blutgranat/10000/Cj",
	[23121] = "Irisierender Azurmondstein/10000/Cj",
	[23101] = "M\195\164chtiger Flammenspessarit/10000/Cj",
	[32833] = "Gel\195\164uterte Jaggalperle/0/Cj",
	[23116] = "Massiver Golddraenit/10000/Cj",
	[28290] = "Glatter Golddraenit/10000/Cj",
	[23111] = "Stattlicher Schattendraenit/10000/Cj",
	[32774] = "Die schwarze Perle/0/Cj",
	[24078] = "Schwerer Adamantitring/16134/Cj",
	[24077] = "Dicke Adamantithalskette/10715/Cj",
	[32508] = "Halskette der Tiefen/0/Cj",
	[24087] = "Schwerer Teufelsstahlring/37037/Cj",
	[31863] = "Ausbalanciertes Nachtauge/0/Cj",
	[24027] = "Klobiger lebendiger Rubin/30000/Cj",
	[24031] = "Heller lebendiger Rubin/30000/Cj",
	[24047] = "Brillantierter D\195\164mmerstein/30000/Cj",
	[24065] = "Schillernder Talasit/30000/Cj",
	[24028] = "Feingeschliffener lebendiger Rubin/30000/Cj",
	[24062] = "Robuster Talasit/30000/Cj",
	[24036] = "Scheinender lebendiger Rubin/30000/Cj",
	[24050] = "Schimmernder D\195\164mmerstein/30000/Cj",
	[24061] = "Glitzernder Edeltopas/30000/Cj",
	[24056] = "Leuchtendes Nachtauge/30000/Cj",
	[31861] = "Gro\195\159er D\195\164mmerstein/0/Cj",
	[31865] = "Energieerf\195\188lltes Nachtauge/0/Cj",
	[24058] = "Gravierter Edeltopas/30000/Cj",
	[24067] = "Gezackter Talasit/30000/Cj",
	[24079] = "Khoriumband der Schatten/38775/Cj",
	[24060] = "Gl\195\164nzender Edeltopas/30000/Cj",
	[24037] = "Irisierender Stern der Elune/30000/Cj",
	[24053] = "Mystischer D\195\164mmerstein/0/Cj",
	[24059] = "M\195\164chtiger Edeltopas/4815/Cj",
	[32836] = "Gel\195\164uterte Schattenperle/0/Cj",
	[24066] = "Strahlender Talasit/1767/Cj",
	[24051] = "Massiver D\195\164mmerstein/500/Cj",
	[24057] = "K\195\182nigliches Nachtauge/3183/Cj",
	[24030] = "Runenverzierter lebendiger Rubin/30000/Cj",
	[24055] = "Unbest\195\164ndiges Nachtauge/30000/Cj",
	[24048] = "Glatter D\195\164mmerstein/1433/Cj",
	[24033] = "Gediegener Stern der Elune/30000/Cj",
	[24054] = "Stattliches Nachtauge/30000/Cj",
	[24035] = "Funkelnder Stern der Elune/30000/Cj",
	[24039] = "St\195\188rmischer Stern der Elune/30000/Cj",
	[24032] = "Fragiler lebendiger Rubin/30000/Cj",
	[24029] = "Tr\195\164nenf\195\182rmiger lebendiger Rubin/30000/Cj",
	[24052] = "Kompakter D\195\164mmerstein/30000/Cj",
	[31867] = "Verschleierter Edeltopas/0/Cj",
	[31868] = "T\195\188ckischer Edeltopas/0/Cj",
	[24088] = "Feiner Eterniumring/39122/Cj",
	[24080] = "Khoriumband des Frosts/39122/Cj",
	[24082] = "Khoriuminfernoband/39122/Cj",
	[24110] = "Lebendiger Rubinanh\195\164nger/39122/Cj",
	[24106] = "Dicke Teufelsstahlhalskette/39122/Cj",
	[24114] = "Geflochtene Eterniumkette/39470/Cj",
	[24116] = "Auge der Nacht/39470/Cj",
	[24085] = "Khoriumband des Laubs/39470/Cj",
	[24092] = "Anh\195\164nger der Eisflamme/39470/Cj",
	[24097] = "Anh\195\164nger der Schattenneige/39470/Cj",
	[24093] = "Anh\195\164nger des Tauens/39470/Cj",
	[24098] = "Anh\195\164nger der Nullrune/39470/Cj",
	[24095] = "Anh\195\164nger des Erl\195\182schens/39470/Cj",
	[30825] = "Ring des Arkanschutzes/37037/Cj",
	[24086] = "Arkanes Khoriumband/39818/Cj",
	[24089] = "Eterniumband der Loderflamme/39818/Cj",
	[25897] = "Starker Erdsturmdiamant/30000/Cj",
	[25899] = "Grober Erdsturmdiamant/30000/Cj",
	[24121] = "Kette der Nebeleule/39818/Cj",
	[32776] = "Krone der Meerhexe/0/Cj",
	[25890] = "Zerst\195\182rerischer Himmelsfeuerdiamant/30000/Cj",
	[24117] = "Z\195\164rtliche Morgenr\195\182te/39818/Cj",
	[25895] = "R\195\164tselhafter Himmelsfeuerdiamant/4522/Cj",
	[25901] = "Bemerkenswerter Erdsturmdiamant/30000/Cj",
	[25893] = "Mystischer Himmelsfeuerdiamant/30000/Cj",
	[25896] = "M\195\164chtiger Erdsturmdiamant/30000/Cj",
	[32409] = "Unerbittlicher Erdsturmdiamant/0/Cj",
	[25894] = "Fl\195\188chtiger Himmelsfeuerdiamant/30000/Cj",
	[25898] = "Harter Erdsturmdiamant/8226/Cj",
	[32410] = "Donnernder Himmelsfeuerdiamant/0/Cj",
	[24123] = "Reif der arkanen Macht/30712/Cj",
	[44] = "Kronenreif der gr\195\188nen Flamme/0/Cj",
	[24122] = "Kronenreif der gr\195\188nen Flamme/30597/Cj",
	[24125] = "Figur - D\195\164mmersteinkrebs/15000/Cj",
	[24124] = "Figur - Teufelsstahleber/12000/Cj",
	[24126] = "Figur - Lebendige Rubinschlange/2/Cj",
	[24128] = "Figur - Nachtaugenpanther/15000/Cj",
	[24127] = "Figur - Talasiteule/15000/Cj",
	[32213] = "Ausbalancierter Schattensangamethyst/0/Cj",
	[32193] = "Klobiger Purpurspinell/0/Cj",
	[32197] = "Heller Purpurspinell/0/Cj",
	[32204] = "Brillantiertes L\195\182wenauge/0/Cj",
	[32225] = "Schillernder Gischtsmaragd/0/Cj",
	[32194] = "Feingeschliffener Purpurspinell/0/Cj",
	[32223] = "Robuster Gischtsmaragd/0/Cj",
	[32199] = "Scheinender Purpurspinell/0/Cj",
	[32207] = "Schimmerndes L\195\182wenauge/0/Cj",
	[32220] = "Glitzernder Pyrostein/0/Cj",
	[32215] = "Leuchtender Schattensangamethyst/0/Cj",
	[32210] = "Gro\195\159es L\195\182wenauge/0/Cj",
	[32214] = "Energieerf\195\188llter Schattensangamethyst/0/Cj",
	[32217] = "Gravierter Pyrostein/0/Cj",
	[32226] = "Gezackter Gischtsmaragd/0/Cj",
	[32219] = "Gl\195\164nzender Pyrostein/0/Cj",
	[32202] = "Irisierender Engelssaphir/0/Cj",
	[32209] = "Mystisches L\195\182wenauge/0/Cj",
	[32218] = "M\195\164chtiger Pyrostein/0/Cj",
	[32224] = "Strahlender Gischtsmaragd/0/Cj",
	[32216] = "K\195\182niglicher Schattensangamethyst/0/Cj",
	[32196] = "Runenverzierter Purpurspinell/0/Cj",
	[32212] = "Unbest\195\164ndiger Schattensangamethyst/0/Cj",
	[32205] = "Glattes L\195\182wenauge/0/Cj",
	[32200] = "Gediegener Engelssaphir/0/Cj",
	[32211] = "Stattlicher Schattensangamethyst/0/Cj",
	[32201] = "Funkelnder Engelssaphir/0/Cj",
	[32203] = "St\195\188rmischer Engelssaphir/0/Cj",
	[32198] = "Fragiler Purpurspinell/0/Cj",
	[32195] = "Tr\195\164nenf\195\182rmiger Purpurspinell/0/Cj",
	[31398] = "Das gefrorene Auge/60256/Cj",
	[31399] = "Der Schutz der Natur/60256/Cj",
	[32208] = "Kompaktes L\195\182wenauge/0/Cj",
	[32221] = "Verschleierter Pyrostein/0/Cj",
	[32222] = "T\195\188ckischer Pyrostein/0/Cj",
	[32206] = "Massives L\195\182wenauge/0/Cj",
	[31862] = "Ausbalancierter Schattendraenit/0/Cj",
	[31860] = "Gro\195\159er Golddraenit/0/Cj",
	[31864] = "Energieerf\195\188llter Schattendraenit/0/Cj",
	[31866] = "Verschleierter Flammenspessarit/0/Cj",
	[31869] = "T\195\188ckischer Flammenspessarit/0/Cj",
	[2302] = "Handgen\195\164hte Lederstiefel/29/Cl",
	[7277] = "Handgen\195\164hte Armschienen/28/Cl",
	[7276] = "Handgen\195\164hter Lederumhang/34/Cl",
	[5957] = "Handgen\195\164hte Lederweste/40/Cl",
	[2304] = "Leichtes R\195\188stungsset/15/Cl",
	[2318] = "Leichtes Leder/15/SbCl",
	[2303] = "Handgen\195\164hte Lederhose/71/Cl",
	[4237] = "Handgen\195\164hter Lederg\195\188rtel/34/Cl",
	[7278] = "Leichter Lederk\195\182cher/25/Cl",
	[7279] = "Kleiner Ledermunitionsbeutel/25/Cl",
	[7280] = "Unverw\195\188stliche Lederhose/162/Cl",
	[4231] = "Geschmeidiger leichter Balg/110/Cl",
	[2300] = "Gepr\195\164gte Lederweste/192/Cl",
	[5081] = "Kodobalgtasche/250/Cl",
	[2309] = "Gepr\195\164gte Lederstiefel/268/Cl",
	[4239] = "Gepr\195\164gte Lederhandschuhe/71/Cl",
	[2310] = "Gepr\195\164gter Lederumhang/112/Cl",
	[2311] = "Wei\195\159es Lederwams/150/Cl",
	[7281] = "Leichte Lederarmschienen/84/Cl",
	[4242] = "Gepr\195\164gte Lederhose/347/Cl",
	[2312] = "Feine Lederhandschuhe/181/Cl",
	[4246] = "Feiner Lederg\195\188rtel/125/Cl",
	[2308] = "Feiner Lederumhang/267/Cl",
	[4243] = "Feine Ledertunika/461/Cl",
	[6466] = "Deviatschuppenumhang/413/Cl",
	[6709] = "Mondscheinweste/545/Cl",
	[5780] = "Murlocschuppeng\195\188rtel/156/Cl",
	[2307] = "Feine Lederstiefel/243/Cl",
	[7282] = "Leichte Lederhose/599/Cl",
	[5781] = "Murlocschuppenbrustplatte/601/Cl",
	[7283] = "Schwarzwelpenumhang/519/Cl",
	[20575] = "Schwarzwelpentunika/743/Cl",
	[2317] = "Dunkle Ledertunika/689/Cl",
	[4244] = "Lederweste des H\195\188gelw\195\164chters/723/Cl",
	[4233] = "Geschmeidiger mittlerer Balg/200/Cl",
	[2315] = "Dunkle Lederstiefel/307/Cl",
	[2313] = "Mittleres R\195\188stungsset/200/Cl",
	[2319] = "Mittleres Leder/50/Sc",
	[6467] = "Deviatschuppenhandschuhe/420/Cl",
	[5958] = "Feine Lederhose/829/Cl",
	[2316] = "Dunkler Lederumhang/408/Cl",
	[6468] = "Deviatschuppeng\195\188rtel/658/Cl",
	[5961] = "Dunkle Lederhose/1089/Cl",
	[4248] = "Dunkle Lederhandschuhe/791/Cl",
	[4250] = "G\195\188rtel des H\195\188gelw\195\164chters/705/Cl",
	[7285] = "Beh\195\164nde Lederhandschuhe/588/Cl",
	[7284] = "Rotwelpenhandschuhe/586/Cl",
	[2314] = "Gekr\195\164ftigte Lederr\195\188stung/743/Cl",
	[4249] = "Dunkler Lederg\195\188rtel/703/Cl",
	[7348] = "Pfeilmacherhandschuhe/690/Cl",
	[4251] = "Schultern des H\195\188gelw\195\164chters/1199/Cl",
	[4253] = "Gekr\195\164ftigte Lederhandschuhe/962/Cl",
	[7352] = "Irdene Lederschultern/1306/Cl",
	[7349] = "Kr\195\164uterkundigenhandschuhe/861/Cl",
	[4252] = "Dunkle Lederschultern/1457/Cl",
	[7358] = "Langfingerhandschuhe/885/Cl",
	[4255] = "Gr\195\188ne Lederr\195\188stung/2366/Cl",
	[7359] = "Schwere irdene Handschuhe/978/Cl",
	[4247] = "Lederhandschuhe des H\195\188gelw\195\164chters/1049/Cl",
	[4254] = "Barbarische Handschuhe/1071/Cl",
	[7372] = "Schwerer Ledermunitionsbeutel/500/Cl",
	[7371] = "Schwerer K\195\182cher/500/Cl",
	[4236] = "Geschmeidiger schwerer Balg/225/Cl",
	[4265] = "Schweres R\195\188stungsset/650/Cl",
	[4234] = "Schweres Leder/150/Sd",
	[18662] = "Schwerer Lederball/5/Cl",
	[3719] = "Umhang des H\195\188gelw\195\164chters/1027/Cl",
	[18948] = "Barbarische Armschienen/1589/Cl",
	[4456] = "Raptorbalgg\195\188rtel/1553/Cl",
	[4455] = "Raptorbalgharnisch/3096/Cl",
	[4257] = "Gr\195\188ner Lederg\195\188rtel/1311/Cl",
	[5962] = "W\195\164chterhose/2794/Cl",
	[7373] = "Schw\195\164rzliche Ledergamaschen/3097/Cl",
	[5963] = "Barbarische Gamaschen/3151/Cl",
	[4258] = "W\195\164chterg\195\188rtel/1592/Cl",
	[5782] = "Dicke Murlocr\195\188stung/3211/Cl",
	[4262] = "Edelsteinbesetzter Lederg\195\188rtel/2652/Cl",
	[5964] = "Barbarische Schultern/2609/Cl",
	[7374] = "Schw\195\164rzliche Lederr\195\188stung/3760/Cl",
	[7375] = "Gr\195\188nwelpenr\195\188stung/3773/Cl",
	[4256] = "W\195\164chterr\195\188stung/3477/Cl",
	[7377] = "Frostlederumhang/2269/Cl",
	[4259] = "Gr\195\188ne Lederarmschienen/1934/Cl",
	[7378] = "Schw\195\164rzliche Armschienen/2146/Cl",
	[5965] = "W\195\164chterumhang/2536/Cl",
	[17721] = "Handschuhe des Altvaters/2268/Cl",
	[7386] = "Gr\195\188nwelpenarmschienen/2387/Cl",
	[5783] = "Murlocschuppenarmschienen/2316/Cl",
	[5739] = "Barbarischer Harnisch/2738/Cl",
	[5966] = "W\195\164chterhandschuhe/1374/Cl",
	[7387] = "Schw\195\164rzlicher G\195\188rtel/2587/Cl",
	[4260] = "W\195\164chterlederarmschienen/2559/Cl",
	[18238] = "Schattenhauthandschuhe/3321/Cl",
	[4264] = "Barbarischer G\195\188rtel/2804/Cl",
	[8174] = "Bequemer Lederhut/4131/Cl",
	[7390] = "Schw\195\164rzliche Stiefel/4237/Cl",
	[7391] = "Hurtige Stiefel/4253/Cl",
	[8172] = "Geschmeidiger dicker Balg/500/Cl",
	[8173] = "Dickes R\195\188stungsset/1000/Cl",
	[4304] = "Dickes Leder/300/Se",
	[8176] = "Stirnband des Nachtschleichers/4495/Cl",
	[8175] = "Tunika des Nachtschleichers/5971/Cl",
	[8187] = "Schildkr\195\182tenschuppenhandschuhe/3477/Cl",
	[8192] = "Schultern des Nachtschleichers/4782/Cl",
	[8198] = "Schildkr\195\182tenschuppenarmschienen/4013/Cl",
	[8189] = "Schildkr\195\182tenschuppenbrustplatte/7567/Cl",
	[8210] = "Wildlederschultern/5537/Cl",
	[8200] = "Gro\195\159e Voodoorobe/7275/Cl",
	[8214] = "Wildlederhelm/6230/Cl",
	[8211] = "Wildlederweste/8002/Cl",
	[8201] = "Gro\195\159e Voodoomaske/5350/Cl",
	[8205] = "Feste Skorpidarmschienen/4346/Cl",
	[8203] = "Feste Skorpidbrustplatte/8628/Cl",
	[8217] = "Schnellziehk\195\182cher/1000/Cl",
	[8218] = "Dicker Ledermunitionsbeutel/1000/Cl",
	[8204] = "Feste Skorpidhandschuhe/4676/Cl",
	[8193] = "Hose des Nachtschleichers/8708/Cl",
	[8191] = "Schildkr\195\182tenschuppenhelm/7780/Cl",
	[8197] = "Stiefel des Nachtschleichers/7158/Cl",
	[8209] = "Feste Skorpidstiefel/8375/Cl",
	[8185] = "Schildkr\195\182tenschuppengamaschen/10952/Cl",
	[8213] = "Wildlederstiefel/8150/Cl",
	[8216] = "Gro\195\159er Voodooumhang/6323/Cl",
	[8202] = "Gro\195\159e Voodoohose/9022/Cl",
	[8207] = "Feste Skorpidschulterst\195\188cke/8978/Cl",
	[8215] = "Wildlederumhang/9017/Cl",
	[8212] = "Wildledergamaschen/11585/Cl",
	[8206] = "Feste Skorpidgamaschen/12704/Cl",
	[8208] = "Fester Skorpidhelm/10272/Cl",
	[15407] = "Geschmeidiger unverw\195\188stlicher Balg/500/Cl",
	[15564] = "Unverw\195\188stliches R\195\188stungsset/1000/Cl",
	[8170] = "Unverw\195\188stliches Leder/500/Sf",
	[15077] = "Schwere Skorpidarmschienen/7615/Cl",
	[15045] = "Gr\195\188ne Drachenschuppenbrustplatte/19938/Cl",
	[15083] = "T\195\188ckische Lederstulpen/6872/Cl",
	[15074] = "Schim\195\164renhandschuhe/6867/Cl",
	[15076] = "Schwere Skorpidweste/16604/Cl",
	[15084] = "T\195\188ckische Lederarmschienen/7311/Cl",
	[15046] = "Gr\195\188ne Drachenschuppengamaschen/22482/Cl",
	[15067] = "Eisenfederschultern/12758/Cl",
	[15061] = "Lebendige Schultern/13803/Cl",
	[15091] = "Runenverzierte Lederstulpen/7195/Cl",
	[15054] = "Vulkanische Gamaschen/14559/Cl",
	[15057] = "Sturmschleierhose/18728/Cl",
	[15064] = "Kriegsb\195\164renharnisch/19717/Cl",
	[15073] = "Schim\195\164renstiefel/11530/Cl",
	[15071] = "Frosts\195\164blerstiefel/11443/Cl",
	[45] = "Schwere Skorpidstulpen/0/Cl",
	[15078] = "Schwere Skorpidstulpen/9649/Cl",
	[15092] = "Runenverzierte Lederarmschienen/7656/Cl",
	[15072] = "Schim\195\164rengamaschen/16233/Cl",
	[15082] = "Schwerer Skorpidg\195\188rtel/10375/Cl",
	[15093] = "Runenverzierter Lederg\195\188rtel/8368/Cl",
	[15086] = "T\195\188ckisches Lederstirnband/13154/Cl",
	[15048] = "Blaue Drachenschuppenbrustplatte/24409/Cl",
	[15060] = "Lebendige Gamaschen/21277/Cl",
	[15056] = "Sturmschleierr\195\188stung/20966/Cl",
	[15065] = "Kriegsb\195\164renwollw\195\164sche/22233/Cl",
	[15069] = "Frosts\195\164blergamaschen/17012/Cl",
	[15079] = "Schwere Skorpidgamaschen/21760/Cl",
	[15053] = "Vulkanische Brustplatte/17275/Cl",
	[15050] = "Schwarze Drachenschuppenbrustplatte/26071/Cl",
	[19052] = "Stiefel der D\195\164mmerung/17621/Cl",
	[15063] = "Teufelssaurierstulpen/11701/Cl",
	[15066] = "Eisenfederbrustplatte/23650/Cl",
	[19044] = "Macht der Holzschlundfeste/11116/Cl",
	[15075] = "Schim\195\164renweste/18449/Cl",
	[15094] = "Runenverziertes Lederstirnband/14155/Cl",
	[15087] = "T\195\188ckische Lederhose/17892/Cl",
	[16982] = "Kernhundstiefel/24397/Cl",
	[15049] = "Blaue Drachenschuppenschultern/20543/Cl",
	[15058] = "Sturmschleierschultern/14692/Cl",
	[15070] = "Frosts\195\164blerhandschuhe/9504/Cl",
	[15080] = "Schwerer Skorpidhelm/18230/Cl",
	[16984] = "Schwarze Drachenschuppenstiefel/32653/Cl",
	[18509] = "Chromatischer Umhang/23006/Cl",
	[19157] = "Chromatische Stulpen/31943/Cl",
	[19162] = "Kernhundg\195\188rtel/27831/Cl",
	[20380] = "Traumschuppenbrustplatte/52455/Cl",
	[18510] = "Balg der Wildnis/20889/Cl",
	[22665] = "Eisschuppenarmschienen/50516/Cl",
	[22664] = "Eisschuppenbrustplatte/100642/Cl",
	[22666] = "Eisschuppenstulpen/50712/Cl",
	[19149] = "Lavag\195\188rtel/21248/Cl",
	[19163] = "Geschmolzener G\195\188rtel/27931/Cl",
	[16983] = "Schmelzhelm/25709/Cl",
	[22663] = "Polararmschienen/46175/Cl",
	[22662] = "Polarhandschuhe/44851/Cl",
	[22661] = "Polartunika/89377/Cl",
	[18511] = "Ver\195\164nderlicher Umhang/20971/Cl",
	[15052] = "Schwarze Drachenschuppengamaschen/31933/Cl",
	[15051] = "Schwarze Drachenschuppenschultern/21736/Cl",
	[19688] = "Bluttigerbrustplatte/31546/Cl",
	[19689] = "Bluttigerschultern/24082/Cl",
	[22761] = "Dornenholzg\195\188rtel/19607/Cl",
	[22760] = "Dornenholzstiefel/29302/Cl",
	[22759] = "Dornenholzhelm/29190/Cl",
	[18251] = "Kernr\195\188stungsset/5000/Cl",
	[15062] = "Teufelssauriergamaschen/25709/Cl",
	[18504] = "Gurt der Einsicht/14126/Cl",
	[19058] = "Goldener Mantel der D\195\164mmerung/21845/Cl",
	[15059] = "Lebendige Brustplatte/24776/Cl",
	[18506] = "Mungostiefel/21340/Cl",
	[15138] = "Onyxiaschuppenumhang/15198/Cl",
	[19687] = "Urzeitliche Fledermaushautarmschienen/15939/Cl",
	[19686] = "Urzeitliche Fledermaushauthandschuhe/15270/Cl",
	[19685] = "Urzeitliches Fledermaushautwams/29288/Cl",
	[15047] = "Rote Drachenschuppenbrustplatte/29836/Cl",
	[20476] = "Sandpirscherarmschienen/16401/Cl",
	[20478] = "Sandpirscherbrustplatte/33917/Cl",
	[20477] = "Sandpirscherstulpen/16898/Cl",
	[20481] = "Feuerspuckerarmschienen/17139/Cl",
	[20479] = "Feuerspuckerbrustplatte/34036/Cl",
	[20480] = "Feuerspuckerstulpen/17078/Cl",
	[21278] = "Sturmschleierhandschuhe/13212/Cl",
	[18508] = "Armschienen der schnellen Flucht/17194/Cl",
	[19049] = "Kampfhandschuhe der Holzschlundfeste/15576/Cl",
	[25654] = "Teufelsschuppenhandschuhe/17436/Cl",
	[15068] = "Frosts\195\164blertunika/21835/Cl",
	[15081] = "Schwere Skorpidschultern/20261/Cl",
	[15090] = "Runenverzierte Lederr\195\188stung/22002/Cl",
	[15095] = "Runenverzierte Lederhose/20885/Cl",
	[15096] = "Runenverzierte Lederschultern/17332/Cl",
	[25662] = "Geschuppte draenische Hose/32525/Cl",
	[25669] = "Dicke draenische Handschuhe/14274/Cl",
	[15055] = "Vulkanische Schultern/16019/Cl",
	[15085] = "T\195\188ckische Lederr\195\188stung/22732/Cl",
	[15088] = "T\195\188ckischer Lederg\195\188rtel/9901/Cl",
	[25673] = "Wilde draenische Stiefel/21717/Cl",
	[25679] = "Bequeme Einlegesohlen/466/Cl",
	[25650] = "Knotenhautr\195\188stungsset/7500/Cl",
	[21887] = "Knotenhautleder/1250/Cl",
	[25655] = "Teufelsschuppenstiefel/26106/Cl",
	[25661] = "Geschuppte draenische Handschuhe/29461/Cl",
	[25674] = "Wilde draenische Handschuhe/15897/Cl",
	[25670] = "Dicke draenische Hose/32249/Cl",
	[25656] = "Teufelsschuppenhose/36782/Cl",
	[25668] = "Dicke draenische Stiefel/24047/Cl",
	[25675] = "Wilde draenische Gamaschen/30530/Cl",
	[29540] = "Verst\195\164rkte Bergbautasche/30000/Cl",
	[25660] = "Geschuppte draenische Weste/38316/Cl",
	[23793] = "Schweres Knotenhautleder/6250/SCl",
	[25652] = "R\195\188stungsset des Magisters/22500/Cl",
	[25651] = "R\195\188stungsset des Verteidigers/22500/Cl",
	[25671] = "Dicke draenische Weste/35070/Cl",
	[25676] = "Wilde draenische Weste/32311/Cl",
	[29534] = "Grollbalgbeinr\195\188stung/20000/Cl",
	[29533] = "Kobrahautbeinr\195\188stung/20000/Cl",
	[25657] = "Teufelsschuppenbrustplatte/39930/Cl",
	[25659] = "Geschuppte draenische Stiefel/62470/Cl",
	[25685] = "Teufelslederhandschuhe/20771/Cl",
	[25694] = "Netherzorng\195\188rtel/25734/Cl",
	[25692] = "Netherzorngamaschen/51110/Cl",
	[29488] = "Arkanr\195\188stungsset/15000/Cl",
	[29528] = "Trommeln des Krieges/5000/Cl",
	[29485] = "Flammenr\195\188stungsset/15000/Cl",
	[29486] = "Frostr\195\188stungsset/15000/Cl",
	[29487] = "Naturr\195\188stungsset/15000/Cl",
	[29483] = "Schattenr\195\188stungsset/15000/Cl",
	[29530] = "Trommeln des Tempos/5000/Cl",
	[29500] = "Lohenschildg\195\188rtel/21281/Cl",
	[29499] = "Lohenschildstiefel/31803/Cl",
	[29498] = "Lohenschildhose/42245/Cl",
	[29497] = "Verzauberte Grollhufstiefel/31564/Cl",
	[29496] = "Verzauberte Grollhufhandschuhe/20965/Cl",
	[29495] = "Verzauberte Grollhufgamaschen/41772/Cl",
	[29491] = "Verzauberte Teufelsschuppenstiefel/40049/Cl",
	[29490] = "Verzauberte Teufelsschuppenhandschuhe/26486/Cl",
	[29489] = "Verzauberte Teufelsschuppengamaschen/52781/Cl",
	[25686] = "Teufelslederstiefel/32862/Cl",
	[25687] = "Teufelsledergamaschen/43976/Cl",
	[25695] = "G\195\188rtel des Teufelspirschers/24563/Cl",
	[29494] = "Flammenschuppeng\195\188rtel/24968/Cl",
	[29493] = "Flammenschuppenstiefel/40332/Cl",
	[29492] = "Flammenschuppengamaschen/53353/Cl",
	[25693] = "Netherzornstiefel/36667/Cl",
	[25653] = "Reitgerte/17500/Cl",
	[25681] = "Schicker Abenteurerhut/66290/Cl",
	[25683] = "Schicker purpurfarbener Hut/37986/Cl",
	[25682] = "Schicker Dschungelhut/31539/Cl",
	[25680] = "Schicker lilafarbener Hut/31300/Cl",
	[29531] = "Trommeln der Wiederherstellung/5000/Cl",
	[25691] = "Schwere Grollhufstiefel/33726/Cl",
	[25690] = "Schwere Grollhufgamaschen/44808/Cl",
	[46] = "Armschienen des Teufelspirschers/0/Cl",
	[25697] = "Armschienen des Teufelspirschers/25155/Cl",
	[25696] = "Brustplatte des Teufelspirschers/50116/Cl",
	[25689] = "Schwere Grollhufweste/45010/Cl",
	[29503] = "Kobraschuppenhandschuhe/24742/Cl",
	[29502] = "Kobraschuppenkapuze/533/Cl",
	[29512] = "Irdene Netherschuppenstiefel/42922/Cl",
	[29506] = "Handschuhe der lebendigen Ber\195\188hrung/25014/Cl",
	[29505] = "Kapuze des Urlebens/37384/Cl",
	[29508] = "Lebendiger Drachenschuppenhelm/45350/Cl",
	[29511] = "Netherdrachenhandschuhe/28381/Cl",
	[29510] = "Netherdrachenhelm/42408/Cl",
	[29514] = "Dicke Netherschuppenbrustplatte/57415/Cl",
	[29504] = "Windschuppenkapuze/37247/Cl",
	[29507] = "Windt\195\182terwickel/34308/Cl",
	[29509] = "Windsto\195\159handschuhe/30343/Cl",
	[29529] = "Trommeln der Schlacht/5000/Cl",
	[29536] = "Netherkluftbeinr\195\188stung/40000/Cl",
	[29535] = "Netherkobrabeinr\195\188stung/40000/Cl",
	[29532] = "Trommeln der Panik/5000/Cl",
	[8347] = "Drachenschuppenstulpen/5979/Cl",
	[8367] = "Drachenschuppenbrustplatte/18455/Cl",
	[29971] = "Gamaschen des Drachenschlags/9022/Cl",
	[20296] = "Gr\195\188ne Drachenschuppenstulpen/12590/Cl",
	[20295] = "Blaue Drachenschuppengamaschen/31083/Cl",
	[29975] = "Goldene Brustplatte des Drachenschlags/79950/Cl",
	[29516] = "Ebenholzfarbener Netherschuppeng\195\188rtel/31638/Cl",
	[29517] = "Ebenholzfarbene Netherschuppenarmschienen/31758/Cl",
	[29515] = "Ebenholzfarbene Netherschuppenbrustplatte/63043/Cl",
	[29520] = "Nethersto\195\159g\195\188rtel/32114/Cl",
	[29521] = "Nethersto\195\159armschienen/19896/Cl",
	[29519] = "Nethersto\195\159brustplatte/34629/Cl",
	[8346] = "Stulpen des Meeres/5363/Cl",
	[8348] = "Helm des Feuers/10819/Cl",
	[29964] = "Gamaschen des schwarzen Sturms/15290/Cl",
	[29973] = "Brustplatte des Ursturms/38564/Cl",
	[29526] = "Erstschlagg\195\188rtel/28074/Cl",
	[29527] = "Erstschlagarmschienen/28172/Cl",
	[29525] = "Erstschlagweste/54518/Cl",
	[8345] = "Wolfskopfhelm/7421/Cl",
	[8349] = "Gefiederte Brustplatte/14478/Cl",
	[29970] = "Wildfedergamaschen/1361/Cl",
	[29974] = "Lebendige Kristallbrustplatte/474/Cl",
	[29524] = "Windfalkeng\195\188rtel/27169/Cl",
	[29523] = "Windfalkenarmschienen/19065/Cl",
	[29522] = "Windfalkenhalsberge/53924/Cl",
	[47] = "Kupfer verh\195\188tten/0/Cs",
	[2840] = "Kupferbarren/10/Cs",
	[48] = "Bronze verh\195\188tten/0/Cs",
	[2841] = "Bronzebarren/50/Cs",
	[49] = "Zinn verh\195\188tten/0/Cs",
	[3576] = "Zinnbarren/35/Cs",
	[50] = "Silber verh\195\188tten/0/Cs",
	[2842] = "Silberbarren/100/Cs",
	[51] = "Eisen verh\195\188tten/0/Cs",
	[3575] = "Eisenbarren/200/Cs",
	[52] = "Gold verh\195\188tten/0/Cs",
	[53] = "Stahl verh\195\188tten/0/Cs",
	[3859] = "Stahlbarren/60/Cs",
	[54] = "Mithril verh\195\188tten/0/Cs",
	[3860] = "Mithrilbarren/400/Cs",
	[55] = "Echtsilber verh\195\188tten/0/Cs",
	[56] = "Dunkeleisen verh\195\188tten/0/Cs",
	[11371] = "Dunkeleisenbarren/600/Cs",
	[57] = "Thorium verh\195\188tten/0/Cs",
	[12359] = "Thoriumbarren/600/Cs",
	[58] = "Elementium verh\195\188tten/0/Cs",
	[17771] = "Elementiumbarren/0/Cs",
	[59] = "Erdspaltung/0/Cs",
	[22573] = "Erdpartikel/400/MlMmMnD",
	[60] = "Feuerspaltung/0/Cs",
	[22574] = "Feuerpartikel/400/DMl",
	[61] = "Teufelseisen verh\195\188tten/0/Cs",
	[23445] = "Teufelseisenbarren/2000/Cs",
	[62] = "Adamantit verh\195\188tten/0/Cs",
	[23446] = "Adamantitbarren/3000/Cs",
	[63] = "Eternium verh\195\188tten/0/Cs",
	[23447] = "Eterniumbarren/2500/Cs",
	[64] = "Teufelsstahl verh\195\188tten/0/Cs",
	[23448] = "Teufelsstahlbarren/22500/Cs",
	[65] = "Khorium verh\195\188tten/0/Cs",
	[23449] = "Khoriumbarren/12500/Cs",
	[66] = "Geh\195\164rtetes Adamantit verh\195\188tten/0/Cs",
	[23573] = "Geh\195\164rteter Adamantitbarren/30000/Cs",
	[2996] = "Leinenstoffballen/40/Ct",
	[4344] = "Braunes Leinenhemd/11/Ct",
	[2570] = "Leinenumhang/11/Ct",
	[10045] = "Einfache Leinenhose/23/Ct",
	[2576] = "Wei\195\159es Leinenhemd/75/Ct",
	[2568] = "Braune Leinenweste/31/Ct",
	[7026] = "Leineng\195\188rtel/22/Ct",
	[10046] = "Einfache Leinenstiefel/32/Ct",
	[6238] = "Braune Leinenrobe/98/Ct",
	[6241] = "Wei\195\159e Leinenrobe/99/Ct",
	[4343] = "Braune Leinenhose/60/Ct",
	[4307] = "Schwere Leinenhandschuhe/29/Ct",
	[2572] = "Rote Leinenrobe/99/Ct",
	[2577] = "Blaues Leinenhemd/75/Ct",
	[2575] = "Rotes Leinenhemd/25/Ct",
	[6786] = "Einfaches Kleid/59/Ct",
	[4238] = "Leinentasche/200/Ct",
	[6240] = "Blaue Leinenweste/161/Ct",
	[6239] = "Rote Leinenweste/160/Ct",
	[4308] = "Gr\195\188ne Leinenarmschienen/45/Ct",
	[2580] = "Verst\195\164rktes Leinencape/67/Ct",
	[2569] = "Leinenstiefel/87/Ct",
	[2578] = "Barbarische Leinenweste/224/Ct",
	[6242] = "Blaue Leinenrobe/243/Ct",
	[4309] = "Handgen\195\164hte Leinenkniehosen/226/Ct",
	[2579] = "Gr\195\188nes Leinenhemd/37/Ct",
	[5762] = "Rote Leinentasche/250/Ct",
	[2997] = "Wollstoffballen/100/Ct",
	[10047] = "Einfacher Kilt/164/Ct",
	[2584] = "Wollcape/142/Ct",
	[4312] = "Leinenschuhe mit weichen Sohlen/237/Ct",
	[4240] = "Wolltasche/300/Ct",
	[4310] = "Schwere Wollhandschuhe/180/Ct",
	[2582] = "Gr\195\188ne Wollweste/216/Ct",
	[5542] = "Perlenschnallenumhang/370/Ct",
	[4313] = "Rote Wollstiefel/416/Ct",
	[2583] = "Wollstiefel/359/Ct",
	[4241] = "Gr\195\188ne Wolltasche/450/Ct",
	[6263] = "Blauer Overall/589/Ct",
	[4311] = "Schwerer Wollumhang/475/Ct",
	[2587] = "Graues Wollhemd/200/Ct",
	[2585] = "Graue Wollrobe/638/Ct",
	[4316] = "Schwere Wollhose/743/Ct",
	[4314] = "Doppeltgen\195\164hte Wollschultern/331/Ct",
	[4330] = "Modisches rotes Hemd/250/Ct",
	[6787] = "Wei\195\159es Wollkleid/466/Ct",
	[6264] = "Gro\195\159e Adeptenrobe/884/Ct",
	[4332] = "Hellgelbes Hemd/500/Ct",
	[5763] = "Rote Wolltasche/700/Ct",
	[10048] = "Bunter Kilt/935/Ct",
	[4315] = "Verst\195\164rkte Wollschultern/425/Ct",
	[6384] = "Modisches blaues Hemd/250/Ct",
	[6385] = "Modisches gr\195\188nes Hemd/250/Ct",
	[4320] = "Spinnenseidenstiefel/979/Ct",
	[4331] = "Ph\195\182nixhandschuhe/526/Ct",
	[4317] = "Ph\195\182nixhose/1076/Ct",
	[4305] = "Seidenstoffballen/600/Ct",
	[4318] = "Handschuhe der Meditation/610/Ct",
	[4319] = "Azurblaue Seidenhandschuhe/815/Ct",
	[5766] = "Geringe Hexerrobe/1338/Ct",
	[4333] = "Dunkles Seidenhemd/1200/Ct",
	[7046] = "Azurblaue Seidenhose/1494/Ct",
	[4321] = "Spinnenseidenslipper/1120/Ct",
	[7047] = "H\195\164nde der Dunkelheit/824/Ct",
	[7048] = "Azurblaue Seidenkapuze/745/Ct",
	[4324] = "Azurblaue Seidenweste/1874/Ct",
	[5770] = "Roben von Arcana/1807/Ct",
	[7049] = "Handschuhe des wahren Glaubens/914/Ct",
	[4245] = "Kleines Seidenpack/2000/Ct",
	[4322] = "Verzauberergugel/1810/Ct",
	[7050] = "Seidenes Stirnband/999/Ct",
	[6795] = "Wei\195\159es Schwadroneurshemd/500/Ct",
	[7065] = "Gr\195\188ne Seidenr\195\188stung/2398/Ct",
	[7051] = "Irdene Weste/2696/Ct",
	[4323] = "Schattenkapuze/1999/Ct",
	[4334] = "Formelles wei\195\159es Hemd/550/Ct",
	[7052] = "Azurblauer Seideng\195\188rtel/1488/Ct",
	[7053] = "Azurblauer Seidenumhang/2240/Ct",
	[4325] = "Stiefel des Verzauberers/2272/Ct",
	[7055] = "Purpurroter Seideng\195\188rtel/1503/Ct",
	[4339] = "Magiestoffballen/1250/Ct",
	[5764] = "Gr\195\188nes Seidenpack/3000/Ct",
	[6796] = "Rotes Schwadroneurshemd/750/Ct",
	[7056] = "Purpurroter Seidenumhang/2314/Ct",
	[7057] = "Gr\195\188ne Seidenschultern/2323/Ct",
	[4328] = "Spinneng\195\188rtel/1524/Ct",
	[4336] = "Schwarzes Schwadroneurshemd/1500/Ct",
	[4326] = "Langer Seidenumhang/2496/Ct",
	[5765] = "Schwarzes Seidenpack/4000/Ct",
	[7058] = "Purpurrote Seidenweste/2052/Ct",
	[4335] = "Dunkellila Seidenhemd/1500/Ct",
	[7054] = "Robe der Macht/4700/Ct",
	[7060] = "Azurblaue Schultern/2791/Ct",
	[7059] = "Purpurrote Seidenschultern/2781/Ct",
	[17723] = "Gr\195\188nes Festtagshemd/750/Ct",
	[7061] = "Irdener Seideng\195\188rtel/2017/Ct",
	[7062] = "Purpurrote Seidenpantalons/2430/Ct",
	[10052] = "Orangefarbenes Kampfhemd/1500/Ct",
	[4327] = "Eisiger Umhang/3788/Ct",
	[4329] = "Sterneng\195\188rtel/2120/Ct",
	[9999] = "Schwarze Magiestoffgamaschen/4832/Ct",
	[9998] = "Schwarze Magiestoffweste/4815/Ct",
	[7063] = "Purpurrote Seidenrobe/4741/Ct",
	[10054] = "Lavendelfarbenes Magiestoffhemd/3000/Ct",
	[10001] = "Schwarze Magiestoffrobe/5257/Ct",
	[7064] = "Purpurrote Seidenhandschuhe/2569/Ct",
	[10002] = "Schattenzwirnhose/5276/Ct",
	[10055] = "Rosa Magiestoffhemd/3000/Ct",
	[10003] = "Schwarze Magiestoffhandschuhe/2859/Ct",
	[10009] = "Rote Magiestoffhose/5284/Ct",
	[10007] = "Rote Magiestoffweste/5799/Ct",
	[10004] = "Schattenzwirnrobe/5738/Ct",
	[10008] = "Wei\195\159e Banditenmaske/4365/Ct",
	[10056] = "Orangefarbenes Magiestoffhemd/1500/Ct",
	[10034] = "Smokinghemd/2000/Ct",
	[10035] = "Smokinghose/1735/Ct",
	[10019] = "Traumzwirnhandschuhe/3944/Ct",
	[10021] = "Traumzwirnweste/7946/Ct",
	[10030] = "Admiralshut/6007/Ct",
	[10042] = "Aschenstoffrobe/6644/Ct",
	[22246] = "Verzauberter Magiestoffbeutel/2500/Ct",
	[10018] = "Rote Magiestoffhandschuhe/3275/Ct",
	[10023] = "Schattenzwirnhandschuhe/3334/Ct",
	[10050] = "Magiestofftasche/2500/Ct",
	[10040] = "Wei\195\159es Hochzeitskleid/1767/Ct",
	[10026] = "Schwarze Magiestoffstiefel/5459/Ct",
	[10024] = "Schwarzes Magiestoffstirnband/5421/Ct",
	[10027] = "Schwarze Magiestoffschultern/5479/Ct",
	[10025] = "Schattenzwirnmaske/6790/Ct",
	[10029] = "Rote Magiestoffschultern/5391/Ct",
	[10028] = "Schattenzwirnschultern/5938/Ct",
	[10051] = "Rote Magiestofftasche/2500/Ct",
	[10053] = "Einfaches schwarzes Kleid/4499/Ct",
	[10036] = "Smokingjacke/1741/Ct",
	[13868] = "Winterzwirnrobe/9665/Ct",
	[10033] = "Rotes Magiestoffstirnband/6075/Ct",
	[10031] = "Schattenzwirnstiefel/6030/Ct",
	[10044] = "Aschenstoffstiefel/6765/Ct",
	[10041] = "Traumzwirnreif/7161/Ct",
	[14048] = "Runenstoffballen/2000/Ct",
	[21154] = "Festtagskleid/1/Ct",
	[67] = "Festlicher roter Hosenanzug/0/Ct",
	[21542] = "Festtagsanzug/1/Ct",
	[14342] = "Mondstoff/4000/Ct",
	[13869] = "Winterzwirntunika/9702/Ct",
	[13856] = "Runenstoffg\195\188rtel/5112/Ct",
	[14042] = "Aschenstoffweste/10561/Ct",
	[13858] = "Runenstoffrobe/10917/Ct",
	[13857] = "Runenstofftunika/10878/Ct",
	[21340] = "Seelenbeutel/5000/Ct",
	[14046] = "Runenstofftasche/5000/Ct",
	[13870] = "Winterzwirnhandschuhe/5471/Ct",
	[14143] = "Geisterzwirng\195\188rtel/5763/Ct",
	[13860] = "Runenstoffumhang/8741/Ct",
	[14101] = "Hellstoffhandschuhe/6066/Ct",
	[14100] = "Hellstoffrobe/12089/Ct",
	[14043] = "Aschenstoffhandschuhe/5955/Ct",
	[14142] = "Geisterzwirnhandschuhe/6087/Ct",
	[14134] = "Umhang des Feuers/11280/Ct",
	[14103] = "Hellstoffumhang/9716/Ct",
	[22251] = "Cenarische Kr\195\164utertasche/10000/Ct",
	[14044] = "Aschenstoffumhang/9503/Ct",
	[22248] = "Verzauberte Runenstofftasche/10000/Ct",
	[14107] = "Teufelsstoffhose/13140/Ct",
	[14141] = "Geisterzwirnweste/12859/Ct",
	[13863] = "Runenstoffhandschuhe/6617/Ct",
	[14132] = "Hexerzwirngamaschen/12441/Ct",
	[21341] = "Teufelsstofftasche/20000/Ct",
	[14045] = "Aschenstoffhose/13480/Ct",
	[13871] = "Winterzwirnhose/13436/Ct",
	[13864] = "Runenstoffstiefel/9553/Ct",
	[14140] = "Mondstoffreif/16693/Ct",
	[18486] = "Mondstoffrobe/21683/Ct",
	[14139] = "Mondstoffschultern/15840/Ct",
	[14138] = "Mondstoffweste/20042/Ct",
	[14136] = "Robe der Winternacht/17025/Ct",
	[14108] = "Teufelsstoffstiefel/11112/Ct",
	[13865] = "Runenstoffhose/13555/Ct",
	[19056] = "Argentumstiefel/12941/Ct",
	[15802] = "Mondstoffstiefel/11648/Ct",
	[14137] = "Mondstoffgamaschen/18113/Ct",
	[19047] = "Weisheit der Holzschlundfeste/9232/Ct",
	[14104] = "Hellstoffhose/15484/Ct",
	[14111] = "Teufelsstoffkapuze/10775/Ct",
	[14144] = "Geisterzwirnhose/14374/Ct",
	[13866] = "Runenstoffstirnband/11358/Ct",
	[18405] = "G\195\188rtel des Erzmagiers/14744/Ct",
	[21342] = "Kernteufelsstofftasche/80000/Ct",
	[16979] = "Flimmerkernhandschuhe/14901/Ct",
	[19165] = "Flimmerkerngamaschen/45006/Ct",
	[16980] = "Flimmerkernmantel/21365/Ct",
	[19156] = "Flimmerkernrobe/34911/Ct",
	[18263] = "Flimmerkernwickelt\195\188cher/16911/Ct",
	[22658] = "Gletscherumhang/53045/Ct",
	[22654] = "Gletscherhandschuhe/34846/Ct",
	[22652] = "Gletscherweste/69171/Ct",
	[22655] = "Gletscherhandschutz/34973/Ct",
	[14146] = "Handschuhe der Zauberbeherrschung/14084/Ct",
	[14152] = "Robe des Erzmagiers/28815/Ct",
	[14153] = "Robe der Leere/28920/Ct",
	[14154] = "Trachten des wahren Glaubens/29028/Ct",
	[19059] = "Argentumschultern/17541/Ct",
	[19684] = "Blutrebenstiefel/18915/Ct",
	[19683] = "Blutrebengamaschen/25129/Ct",
	[19682] = "Blutrebenweste/24872/Ct",
	[14156] = "Bodenlose Tasche/40000/Ct",
	[18413] = "Schutzumhang der Verteidigung/17070/Ct",
	[18407] = "Teufelsstoffhandschuhe/11139/Ct",
	[22660] = "Gaeas Umarmung/24601/Ct",
	[18408] = "Infernohandschuhe/11178/Ct",
	[19050] = "Mantel der Holzschlundfeste/18758/Ct",
	[18409] = "Mondstoffhandschuhe/11219/Ct",
	[20539] = "Runenverzierter stygischer G\195\188rtel/11908/Ct",
	[20537] = "Runenverzierte stygische Stiefel/17736/Ct",
	[20538] = "Runenverzierte stygische Gamaschen/22703/Ct",
	[22757] = "Sylvankrone/24961/Ct",
	[22758] = "Sylvanschultern/25051/Ct",
	[22756] = "Sylvanweste/33164/Ct",
	[22249] = "Gro\195\159e Verzauberertasche/30000/Ct",
	[14106] = "Teufelsstoffrobe/18053/Ct",
	[14112] = "Teufelsstoffschultern/13509/Ct",
	[68] = "Ogeranzug der Gordok/0/Cl",
	[69] = "Ogeranzug der Gordok/0/Ct",
	[14155] = "Mondstofftasche/20000/Ct",
	[13867] = "Runenstoffschultern/12570/Ct",
	[22252] = "Cenarischer Ranzen/30000/Ct",
	[14128] = "Hexerzwirnrobe/16093/Ct",
	[14130] = "Hexerzwirnturban/12768/Ct",
	[21840] = "Netherstoffballen/4000/Ct",
	[24268] = "Netherstoffnetz/100/Ct",
	[21850] = "Netherstoffg\195\188rtel/12306/Ct",
	[21849] = "Netherstoffarmschienen/12261/Ct",
	[21841] = "Netherstofftasche/10000/Ct",
	[21851] = "Netherstoffhandschuhe/13059/Ct",
	[21842] = "Magieerf\195\188llter Netherstoffballen/8000/Ct",
	[21852] = "Netherstoffhose/26926/Ct",
	[24269] = "Schweres Netherstoffnetz/100/Ct",
	[24273] = "Mystischer Zauberfaden/20000/Ct",
	[24275] = "Silberner Zauberfaden/20000/Ct",
	[21853] = "Netherstoffstiefel/21336/Ct",
	[21859] = "Magieerf\195\188llte Netherstoffhose/31883/Ct",
	[24270] = "Juwelenbeutel/30000/Ct",
	[21843] = "Magieerf\195\188llte Netherstofftasche/10000/Ct",
	[21854] = "Netherstoffrobe/29267/Ct",
	[21855] = "Netherstofftunika/30091/Ct",
	[21844] = "Seelenstoffballen/8000/Ct",
	[21866] = "Arkanostoffarmschienen/17197/Ct",
	[24251] = "Schwarzgestreifte Armschienen/16690/Ct",
	[24250] = "Armschienen der Verw\195\188stung/16626/Ct",
	[30831] = "Umhang der Arkanflucht/25066/Ct",
	[24253] = "Umhang der Ewigkeit/25223/Ct",
	[24252] = "Umhang der schwarzen Leere/25128/Ct",
	[30837] = "Flammenherzarmschienen/17088/Ct",
	[21860] = "Magieerf\195\188llte Netherstoffstiefel/24616/Ct",
	[21845] = "Urmondstoff/4000/Ct",
	[24272] = "Schattenstoff/4000/Ct",
	[24271] = "Zauberstoff/4000/Ct",
	[24249] = "Armschienen des Unersch\195\188tterlichen/16563/Ct",
	[24254] = "Wei\195\159er Arzneikittel/26001/Ct",
	[21863] = "Seelenstoffhandschuhe/20474/Ct",
	[21867] = "Arkanostoffstiefel/26309/Ct",
	[30838] = "Flammenherzhandschuhe/17430/Ct",
	[21861] = "Magieerf\195\188llte Netherstoffrobe/34308/Ct",
	[21862] = "Magieerf\195\188llte Netherstofftunika/34437/Ct",
	[24257] = "Schwarzer G\195\188rtel des Wissens/21095/Ct",
	[24256] = "Gurt der Zerst\195\182rung/21018/Ct",
	[24260] = "Managewirkter Umhang/31984/Ct",
	[24258] = "Cape der Entschlossenheit/31757/Ct",
	[21864] = "Seelenstoffschultern/30824/Ct",
	[24255] = "Gurt des Unersch\195\188tterlichen/20942/Ct",
	[24259] = "Wickeltuch der Vergeltung/31869/Ct",
	[21868] = "Arkanostoffrobe/35486/Ct",
	[30839] = "Flammenherzweste/35267/Ct",
	[24267] = "Kapuze des Schlachtenzaubers/29676/Ct",
	[24263] = "Hose des Schlachtenzaubers/43100/Ct",
	[24276] = "Goldener Zauberfaden/50000/Ct",
	[24274] = "Runenverzierter Zauberfaden/50000/Ct",
	[21865] = "Seelenstoffweste/41251/Ct",
	[24266] = "Kapuze des Zauberschlags/30889/Ct",
	[24262] = "Hose des Zauberschlags/42951/Ct",
	[32585] = "Flinkheilmantelung/0/Ct",
	[32584] = "Flinkheilt\195\188cher/0/Ct",
	[24264] = "Kapuze des wei\195\159en Heilers/32440/Ct",
	[24261] = "Hose des wei\195\159en Heilers/42798/Ct",
	[21872] = "Schwarzschattentasche/40000/Ct",
	[21876] = "Urmondstofftasche/50000/Ct",
	[21858] = "Zauberfeuertasche/20000/Ct",
	[30463] = "Lebensblutg\195\188rtel/0/Ct",
	[30464] = "Lebensblutarmschienen/0/Ct",
	[30465] = "Lebensblutgamaschen/0/Ct",
	[30460] = "Netherflammeng\195\188rtel/0/Ct",
	[30461] = "Netherflammenstiefel/0/Ct",
	[30459] = "Netherflammenrobe/0/Ct",
	[21873] = "Urmondstoffg\195\188rtel/22185/Ct",
	[21874] = "Urmondstoffschultern/33398/Ct",
	[21875] = "Urmondstoffrobe/41510/Ct",
	[21869] = "Eisschattenzwirnschultern/32801/Ct",
	[21870] = "Eisschattenzwirnstiefel/32921/Ct",
	[21871] = "Eisschattenzwirnrobe/44055/Ct",
	[21846] = "Zauberfeuerg\195\188rtel/21632/Ct",
	[21847] = "Zauberfeuerhandschuhe/21712/Ct",
	[21848] = "Zauberfeuerrobe/43584/Ct",
	[2449] = "Erdwurzel/20/H",
	[765] = "Silberblatt/10/H",
	[3371] = "Leere Phiole/4/V",
	[2447] = "Friedensblume/10/H",
	[785] = "Magusk\195\182nigskraut/20/H",
	[3164] = "Verf\195\164rbtes Worgherz/33/D",
	[2452] = "Flitzdistel/15/H",
	[2450] = "Wilddornrose/25/H",
	[5635] = "Scharfe Klaue/45/D",
	[6358] = "\195\150liges Schwarzmaul/4/F",
	[6522] = "Deviatfisch/4/F",
	[3820] = "W\195\188rgetang/100/H",
	[2453] = "Beulengras/25/H",
	[3372] = "Verbleite Phiole/40/V",
	[3355] = "Wildstahlblume/50/H",
	[1288] = "Gro\195\159er Giftbeutel/185/D",
	[6359] = "Feuerflossenschnapper/5/F",
	[3369] = "Grabmoos/25/H",
	[3356] = "K\195\182nigsblut/30/H",
	[3357] = "Lebenswurz/75/H",
	[3818] = "Blassblatt/125/H",
	[4402] = "Kleiner Flammenbeutel/250/D",
	[3821] = "Golddorn/150/H",
	[5637] = "Gro\195\159er Fangzahn/75/D",
	[3819] = "Winterbiss/100/H",
	[3358] = "Khadgars Schnurrbart/175/H",
	[4625] = "Feuerbl\195\188te/250/H",
	[9260] = "Fl\195\188chtiger Rum/400/D",
	[8925] = "Kristallphiole/500/V",
	[8831] = "Lila Lotus/300/H",
	[9262] = "Schwarzes Vitriol/1000/MfMhMjR",
	[7972] = "Sekret des Untodes/400/D",
	[3858] = "Mithrilerz/250/Mf175",
	[8838] = "Sonnengras/60/H",
	[8153] = "Wildranke/5/H",
	[8836] = "Arthas' Tr\195\164nen/95/H",
	[8845] = "Geisterpilz/375/H",
	[4342] = "Lila Farbstoff/2500/V",
	[8839] = "Blindkraut/375/H",
	[8846] = "Gromsblut/250/H",
	[13422] = "Steinschuppenaal/10/F",
	[13463] = "Traumblatt/100/H",
	[13466] = "Pestbl\195\188te/250/H",
	[12363] = "Arkankristall/2000/MiMjMn",
	[13464] = "Goldener Sansam/100/H",
	[13465] = "Bergsilbersalbei/150/H",
	[10620] = "Thoriumerz/250/Mj250",
	[13467] = "Eiskappe/250/H",
	[10286] = "Herz der Wildnis/400/D",
	[7067] = "Elementarerde/400/D",
	[11176] = "Traumstaub/0/Ek",
	[7070] = "Elementarwasser/400/D",
	[12938] = "Blut von Helden/0/D",
	[19943] = "Gewaltig viel Mojo/2000/D",
	[12804] = "M\195\164chtiges Mojo/2000/D",
	[13468] = "Schwarzer Lotus/1000/H",
	[22785] = "Teufelsgras/500/H",
	[18256] = "Magieerf\195\188llte Phiole/6000/V",
	[7077] = "Herz des Feuers/400/D",
	[22787] = "Zottelkappe/600/H",
	[22786] = "Traumwinde/500/H",
	[22789] = "Terozapfen/500/H",
	[22578] = "Wasserpartikel/400/DF",
	[22790] = "Urflechte/750/H",
	[22791] = "Netherbl\195\188te/1000/H",
	[22792] = "Alptraumranke/1250/H",
	[22794] = "Teufelslotus/10000/H",
	[23079] = "Tiefenperidot/10000/DMlMmMnR",
	[23107] = "Schattendraenit/10000/DMlMmMnR",
	[23112] = "Golddraenit/10000/DMlMmMnR",
	[23077] = "Blutgranat/10000/DMlMmMnR",
	[21929] = "Flammenspessarit/10000/DMlMmMnR",
	[23117] = "Azurmondstein/10000/DMlMmMnR",
	[22793] = "Manadistel/2500/H",
	[2835] = "Rauer Stein/2/Ma1",
	[2589] = "Leinenstoff/13/D",
	[2880] = "Schwacher Fluxus/100/V",
	[774] = "Malachit/15/DMaR",
	[2321] = "Feiner Faden/100/V",
	[818] = "Tigerauge/100/DMaR",
	[2836] = "Grober Stein/15/Mb65",
	[2592] = "Wollstoff/33/D",
	[1210] = "Schattenedelstein/250/DMaMbMcR",
	[3466] = "Starker Fluxus/2000/V",
	[5498] = "Kleine irisierende Perle/200/DG",
	[2838] = "Schwerer Stein/60/Me125",
	[1206] = "Moosachat/400/DMbMcR",
	[5500] = "Schillernde Perle/750/DG",
	[1705] = "Geringer Mondstein/600/DMbMcMdMeR",
	[2605] = "Gr\195\188ner Farbstoff/100/V",
	[3864] = "Citrin/800/DMdMeMfMgR",
	[1529] = "Jade/700/DMbMdMeR",
	[7069] = "Elementarluft/400/D",
	[7912] = "Robuster Stein/100/Mf175",
	[4306] = "Seidenstoff/150/D",
	[4338] = "Magiestoff/250/D",
	[7909] = "Aquamarin/1000/DMeMfMgR",
	[7971] = "Schwarze Perle/1000/DG",
	[7075] = "Erdenkern/400/D",
	[12361] = "Blauer Saphir/7000/DMjR",
	[11188] = "Gelber Machtkristall/0/G",
	[11186] = "Roter Machtkristall/0/G",
	[12365] = "Verdichteter Stein/250/Mj250",
	[14047] = "Runenstoff/400/D",
	[7910] = "Sternrubin/5000/DMfMgMjR",
	[11184] = "Blauer Machtkristall/0/G",
	[12364] = "Gewaltiger Smaragd/10000/DMjR",
	[12799] = "Gro\195\159er Opal/7000/DMjR",
	[12800] = "Azerothianischer Diamant/10000/DMjR",
	[11185] = "Gr\195\188ner Machtkristall/0/G",
	[12662] = "D\195\164monische Rune/600/D",
	[12811] = "Rechtschaffene Kugel/20000/D",
	[17010] = "Feuerkern/2000/D",
	[17011] = "Lavakern/2000/D",
	[17203] = "Sulfuronblock/100000/D",
	[11382] = "Blut des Berges/750/DMhR",
	[22203] = "Gro\195\159er Obsidiansplitter/5000/DM",
	[22202] = "Kleiner Obsidiansplitter/2500/DM",
	[12809] = "W\195\164chterstein/10000/D",
	[17012] = "Kernleder/1000/St315",
	[22682] = "Gefrorene Rune/20000/D",
	[8146] = "T\195\188ckische Klaue/500/D",
	[20520] = "Dunkelrune/2000/D",
	[15417] = "Teufelssaurierleder/500/Sn",
	[12753] = "Schattenhaut/0/D",
	[20725] = "Nexuskristall/0/Eo",
	[19774] = "Seelenit/5000/DMiR",
	[19726] = "Blutrebe/500/H",
	[11754] = "Schwarzer Diamant/0/DMhR",
	[8168] = "Pechschwarze Feder/100/D",
	[21877] = "Netherstoff/800/D",
	[22445] = "Arkaner Staub/0/Er",
	[23572] = "Urnether/16000/D",
	[30183] = "Nethervortex/20000/D",
	[32428] = "Herz der Dunkelheit/0/D",
	[22450] = "Kristall der Leere/0/Es",
	[7081] = "Odem des Windes/400/D",
	[4470] = "Einfaches Holz/34/V",
	[6291] = "Roher gl\195\164nzender Kleinfisch/1/F",
	[2672] = "Sehniges Wolfsfleisch/4/D",
	[12223] = "Fleischiger Fledermausfl\195\188gel/4/D",
	[2678] = "Milde Gew\195\188rze/2/V",
	[6889] = "Kleines Ei/4/D",
	[17194] = "Festtagsgew\195\188rze/10/V",
	[27668] = "Luchsfleisch/5/D",
	[769] = "Brocken Eberfleisch/3/D",
	[23676] = "Mondweidenhirschlenden/5/D",
	[6303] = "Rohe Glitschhautmakrele/1/F",
	[30817] = "Herk\195\182mmliches Mehl/1/V",
	[2886] = "Klippeneberrippchen/5/D",
	[2894] = "Rhapsodiemalz/12/V",
	[5465] = "Kleines Spinnenbein/3/D",
	[5466] = "Skorpidstachel/8/D",
	[1179] = "Eiskalte Milch/6/VD",
	[17196] = "Festtagsgeister/12/V",
	[5467] = "Kodofleisch/7/D",
	[3173] = "B\195\164renfleisch/15/D",
	[27669] = "Fledermausfleisch/5/D",
	[5503] = "Muschelfleisch/16/DG",
	[159] = "Erfrischendes Quellwasser/5/V",
	[2673] = "Kojotenfleisch/10/D",
	[5468] = "Weiches Frenzyfleisch/12/D",
	[723] = "Geiferzahnleber/15/D",
	[6317] = "Roher Lochfrenzy/2/F",
	[6289] = "Roher langzahniger Matschschnapper/1/F",
	[6361] = "Roher Regenbogenflossenthunfisch/2/F",
	[5469] = "Schreiterfleisch/9/D",
	[4536] = "Gl\195\164nzender roter Apfel/5/V",
	[3172] = "Eberged\195\164rme/18/D",
	[3174] = "Spinnensekret/16/D",
	[22644] = "Knuspriges Spinnenbein/12/D",
	[2674] = "Kriecherfleisch/12/D",
	[729] = "Sehniges Geierfleisch/17/D",
	[730] = "Murlocauge/16/D",
	[731] = "Geiferzahnschnauze/27/D",
	[2924] = "Krokiliskenfleisch/16/D",
	[2677] = "Eberrippchen/15/D",
	[21071] = "Roher Weisenfisch/25/F",
	[2675] = "Kriecherklaue/11/D",
	[5051] = "Grubenratte/1/D",
	[1468] = "Murlocflosse/28/D",
	[2692] = "Scharfe Gew\195\188rze/40/V",
	[6308] = "Roher Stoppelf\195\188hlerwels/2/F",
	[5470] = "Donnerechsenschwanz/28/D",
	[1081] = "Knuspriges Spinnenfleisch/50/D",
	[1080] = "Z\195\164hes Kondorfleisch/78/D",
	[1015] = "Magere Wolfflanke/24/D",
	[2665] = "W\195\188rzkr\195\164uter aus Sturmwind/20/V",
	[3730] = "Gro\195\159b\195\164renfleisch/45/D",
	[2251] = "Klebriges Spinnenbein/12/D",
	[5471] = "Hirschfleisch/30/D",
	[3667] = "Zartes Krokiliskenfleisch/25/D",
	[5504] = "W\195\188rziges Muschelfleisch/22/DG",
	[3731] = "L\195\182wenfleisch/55/D",
	[3685] = "Raptorei/71/D",
	[3713] = "Feine Gew\195\188rze/160/V",
	[3404] = "Bussardfl\195\188gel/181/D",
	[12037] = "Eigenartiges Fleisch/87/D",
	[4655] = "Riesenmuschelfleisch/71/DG",
	[12203] = "Rotes Wolfsfleisch/87/D",
	[12202] = "Tigerfleisch/87/D",
	[8365] = "Rohe Mithrilkopfforelle/4/D",
	[2596] = "Schlauch mit zwergischem Starkbier/120/V",
	[12184] = "Raptorfleisch/87/D",
	[6362] = "Roher Steinschuppenkabeljau/4/F",
	[21153] = "Roher gro\195\159er Weisenfisch/125/D",
	[3712] = "Schildkr\195\182tenfleisch/87/D",
	[12204] = "Schweres Kodofleisch/112/D",
	[12205] = "Wei\195\159es Spinnenfleisch/112/D",
	[13754] = "Roher gl\195\164nzender Machtfisch/6/F",
	[13758] = "Roher Rotkiemen/4/F",
	[12207] = "Riesenei/150/D",
	[12206] = "Zartes Krebsfleisch/112/D",
	[4603] = "Roher T\195\188pfelgelbschwanz/4/F",
	[12208] = "Zartes Wolfsfleisch/150/D",
	[7974] = "Scharfes Muschelfleisch/50/DG",
	[13755] = "Winterkalmar/7/F",
	[13756] = "Roher Sommerbarsch/9/F",
	[13759] = "Roher Nachtflossenschnapper/10/F",
	[13760] = "Roher Sonnenschuppenlachs/10/F",
	[13889] = "Roher Wei\195\159schuppenlachs/5/F",
	[13888] = "Dunkelklauenhummer/12/F",
	[13893] = "Gro\195\159er roher Machtfisch/15/F",
	[18255] = "Runn Tum Knolle/15/G",
	[20424] = "Sandwurmfleisch/175/D",
	[27422] = "Stachelkiemenforelle/8/D",
	[27671] = "Bussardfleisch/200/D",
	[24477] = "Jaggalmuschelfleisch/100/D",
	[8150] = "Tiefsteinsalz/250/D",
	[21024] = "Chimaeroklenden/0/D",
	[27425] = "T\195\188pfelteufelsfinne/8/D",
	[27674] = "Felshetzerfleisch/200/D",
	[27429] = "Zangarischer Sporenfisch/914/D",
	[27676] = "Seltsame Sporen/200/D",
	[27677] = "Basiliskbrocken/200/D",
	[27435] = "Feigenschimmers Matschflosser/8/D",
	[27437] = "Eisblauflosse/8/D",
	[27438] = "Goldener Stachelflosser/8/D",
	[27678] = "Grollhuffleisch/200/D",
	[27682] = "Talbukwildbret/200/D",
	[27681] = "Phasenverschobenes Fleisch/200/D",
	[31671] = "Schlangenfleisch/200/D",
	[31670] = "Raptorrippchen/200/D",
	[27439] = "Grimmiger Flusskrebs/8/D",
	[27515] = "Gro\195\159e T\195\188pfelteufelsfinne/0/D",
	[4539] = "Goldrindenapfel/0/D",
	[27516] = "Riesige Stachelkiemenforelle/0/D",
	[2593] = "Fl\195\164schchen Portwein/0/D",
	[6217] = "Kupferrute/124/V",
	[10940] = "Seltsamer Staub/0/Ea",
	[10938] = "Geringe Magieessenz/0/Eb",
	[17034] = "Ahornsamenkorn/200/V",
	[10939] = "Gro\195\159e Magieessenz/0/Ec",
	[10978] = "Kleiner glei\195\159ender Splitter/0/Ea",
	[10998] = "Geringe Astralessenz/0/Ed",
	[11083] = "Seelenstaub/0/Ee",
	[11082] = "Gro\195\159e Astralessenz/0/Ef",
	[11084] = "Gro\195\159er glei\195\159ender Splitter/0/Ef",
	[2772] = "Eisenerz/150/Me125",
	[11291] = "Sternenholz/4050/V",
	[11134] = "Geringe Mystikeressenz/0/Eg",
	[11138] = "Kleiner leuchtender Splitter/0/Eg",
	[11135] = "Gro\195\159e Mystikeressenz/0/Ei",
	[11137] = "Visionenstaub/0/Eh",
	[11139] = "Gro\195\159er leuchtender Splitter/0/Ei",
	[17035] = "Schlingendornsamenkorn/400/V",
	[7392] = "Gr\195\188nwelpenschuppe/200/Sab",
	[11174] = "Geringe Netheressenz/0/Ej",
	[11177] = "Kleiner strahlender Splitter/0/Ej",
	[11175] = "Gro\195\159e Netheressenz/0/El",
	[11178] = "Gro\195\159er strahlender Splitter/0/El",
	[16202] = "Geringe ewige Essenz/0/Em",
	[14343] = "Kleiner gl\195\164nzender Splitter/0/Em",
	[7079] = "Kugel des Wassers/400/D",
	[16204] = "Illusionsstaub/0/En",
	[16203] = "Gro\195\159e ewige Essenz/0/En",
	[13926] = "Goldene Perle/10000/DG",
	[14344] = "Gro\195\159er gl\195\164nzender Splitter/0/En",
	[22447] = "Geringe Planaressenz/0/Ep",
	[22448] = "Kleiner Prismasplitter/0/EpCn",
	[22446] = "Gro\195\159e Planaressenz/0/Eq",
	[4399] = "Holzgriff/200/V",
	[4400] = "Schwerer Griff/2000/V",
	[814] = "Fl\195\164schchen \195\150l/25/D",
	[6530] = "Nachtkriecher/100/VD",
	[4611] = "Blaue Perle/50/G",
	[17202] = "Schneeball/0/DC",
	[10285] = "Schattenseide/1000/D",
	[14227] = "Eisenweberseide/2500/D",
	[23436] = "Lebendiger Rubin/30000/MlMmMnRD",
	[23438] = "Stern der Elune/30000/MlMmMnRD",
	[23440] = "D\195\164mmerstein/30000/MlMmMnRD",
	[23439] = "Edeltopas/30000/MlMmMnRD",
	[23437] = "Talasit/30000/MlMmRD",
	[23441] = "Nachtauge/30000/MlMmMnRD",
	[2604] = "Roter Farbstoff/50/V",
	[6260] = "Blauer Farbstoff/50/V",
	[8151] = "Fl\195\164schchen Mojo/250/D",
	[10648] = "Leeres Pergament/500/V",
	[10647] = "Ingenieurstinte/2000/V",
	[4337] = "Dicke Spinnenseide/750/D",
	[10577] = "Goblinm\195\182rser/2000/Ce",
	[17020] = "Arkanes Pulver/250/V",
	[1475] = "Kleiner Giftbeutel/82/D",
	[19441] = "Riesiger Giftbeutel/1500/D",
	[8152] = "Fl\195\164schchen gro\195\159es Mojo/500/D",
	[18335] = "Makelloser schwarzer Diamant/2520/D",
	[24478] = "Jaggalperle/0/D",
	[24243] = "Adamantitpulver/2250/RD",
	[27860] = "Gel\195\164utertes draenisches Wasser/0/D",
	[24479] = "Schattenperle/0/D",
	[32230] = "Schattensangamethyst/0/D",
	[32227] = "Purpurspinell/0/D",
	[32229] = "L\195\182wenauge/0/D",
	[32249] = "Gischtsmaragd/0/D",
	[32231] = "Pyrostein/0/D",
	[32228] = "Engelssaphir/0/D",
	[2320] = "Grober Faden/10/V",
	[2934] = "Verdorbene Lederfetzen/7/Sa",
	[783] = "Leichter Balg/50/Sb",
	[4289] = "Salz/50/V",
	[5082] = "D\195\188nnes Kodoleder/25/D",
	[2324] = "Bleiche/25/V",
	[6470] = "Deviatschuppe/20/DSy",
	[5784] = "Schleimige Murlocschuppe/75/D",
	[7286] = "Schwarzwelpenschuppe/25/Saa",
	[4340] = "Grauer Farbstoff/350/V",
	[4232] = "Mittlerer Balg/125/Sc",
	[6471] = "Perfekte Deviatschuppe/500/DSy",
	[7287] = "Rotwelpenschuppe/100/Sz",
	[5116] = "Lange Schwanzfeder/303/D",
	[3182] = "Spinnenseide/387/D",
	[5373] = "Gl\195\188cksbringer/72/P",
	[4235] = "Schwerer Balg/200/Sd",
	[4461] = "Raptorbalg/208/Sac",
	[2325] = "Schwarzer Farbstoff/1000/V",
	[5785] = "Dicke Murlocschuppe/500/D",
	[4291] = "Seidenfaden/500/V",
	[7428] = "Schattenkatzenbalg/250/Sg",
	[8343] = "Schwerer Seidenfaden/2000/V",
	[4096] = "Grobes Gorillahaar/608/D",
	[8169] = "Dicker Balg/500/Se",
	[8167] = "Schildkr\195\182tenschuppe/100/Sh",
	[8154] = "Skorpidschuppe/250/Si",
	[8171] = "Unverw\195\188stlicher Balg/500/Sf",
	[15409] = "Raffiniertes Tiefsteinsalz/1000/Cl",
	[15408] = "Schwere Skorpidschuppe/500/Sj",
	[14341] = "Runenfaden/4500/V",
	[15412] = "Gr\195\188ne Drachenschuppe/500/Sl",
	[15423] = "Schim\195\164renleder/500/So",
	[15420] = "Eisenfeder/100/D",
	[15419] = "Kriegsb\195\164renleder/600/Sq",
	[15422] = "Frosts\195\164blerleder/500/Sm",
	[15415] = "Blaue Drachenschuppe/500/Sl",
	[15416] = "Schwarze Drachenschuppe/1000/Sl",
	[12607] = "Gl\195\164nzende chromatische Schuppe/8048/D",
	[15414] = "Rote Drachenschuppe/1500/Sl",
	[20381] = "Traumschuppe/5000/Sv315",
	[18512] = "Larvens\195\164ure/4000/D",
	[19768] = "Urzeitliches Tigerleder/2000/Ss",
	[15410] = "Schuppe von Onyxia/5000/Sw315",
	[19767] = "Urzeitliches Fledermausleder/2000/Sr",
	[20501] = "Schwerer Silithidenknochenpanzer/2000/S",
	[20498] = "Silithidenchitin/1000/D",
	[20500] = "Leichter Silithidenknochenpanzer/2000/S",
	[25700] = "Teufelsschuppen/1250/S",
	[18240] = "Ogergerbemittel/0/S",
	[14256] = "Teufelsstoff/2000/D",
	[25649] = "Knotenhautlederfetzen/250/S",
	[25708] = "Dickes Grollhufleder/750/S",
	[29539] = "Kobraschuppen/1250/S",
	[25707] = "Teufelsbalg/6250/S",
	[25699] = "Kristalldurchdrungenes Leder/1250/S",
	[25703] = "Zhevraleder/100/S",
	[29548] = "Netherdrachenschuppe/2000/S",
	[29547] = "Windschuppe/1250/S",
	[8165] = "Abgenutzte Drachenschuppe/500/Sk",
	[8368] = "Dicker Wolfsbalg/1000/Sp",
	[2770] = "Kupfererz/5/Ma1",
	[2771] = "Zinnerz/25/Mb65",
	[2775] = "Silbererz/75/Mc75",
	[2776] = "Golderz/500/Md155",
	[3857] = "Kohle/500/VD",
	[7911] = "Echtsilbererz/500/Mg230",
	[11370] = "Dunkeleisenerz/500/Mh275",
	[18562] = "Elementiumerz/0/D",
	[18567] = "Elementarfluxus/0/D",
	[23424] = "Teufelseisenerz/1000/Ml",
	[23425] = "Adamantiterz/1500/Mm",
	[23427] = "Eterniumerz/1250/MnMmMl",
	[23426] = "Khoriumerz/2500/Mn",
	[4341] = "Gelber Farbstoff/500/V",
	[7072] = "Nagaschuppe/150/D",
	[6261] = "Orangefarbener Farbstoff/1000/V",
	[10290] = "Rosa Farbstoff/2500/V",
	[4589] = "Lange elegante Feder/530/D",
	[11040] = "Morgenkorn/1/DMH",
	[21881] = "Netherweberseide/5000/D",
	[21882] = "Seelenessenz/2500/D",
	[21927] = "Sofort wirkendes Gift VII/125/Cp",
	[3776] = "Verkr\195\188ppelndes Gift II/175/Cp",
	[22053] = "T\195\182dliches Gift VI/150/Cp",
	[12625] = "Schultern der Morgenr\195\182te/22847/Cb",
	[8927] = "Sofort wirkendes Gift V/100/Cp",
	[10918] = "Wundgift/42/Cp",
	[12772] = "Veredelter Thoriumhammer/38871/Cb",
	[5173] = "Todeskraut/100/V",
	[6949] = "Sofort wirkendes Gift II/20/Cp",
	[2928] = "Staub des Verfalls/20/V",
	[8928] = "Sofort wirkendes Gift VI/125/Cp",
	[6947] = "Sofort wirkendes Gift/5/Cp",
	[21835] = "Beruhigendes Gift/125/Cp",
	[22055] = "Wundgift V/175/Cp",
	[22728] = "Dampfpanzersteuerung/1879/Ce",
	[5237] = "Gedankenbenebelndes Gift/18/Cp",
	[2931] = "Jungfernleid/250/V",
	[10922] = "Wundgift IV/175/Cp",
	[3777] = "Lethargiewurzel/40/V",
	[8985] = "T\195\182dliches Gift IV/150/Cp",
	[10921] = "Wundgift III/125/Cp",
	[20844] = "T\195\182dliches Gift V/150/Cp",
	[8984] = "T\195\182dliches Gift III/100/Cp",
	[6950] = "Sofort wirkendes Gift III/30/Cp",
	[3775] = "Verkr\195\188ppelndes Gift/13/Cp",
	[18258] = "Ogeranzug der Gordok/0/Cl",
	[8923] = "Essenz der Pein/180/V",
	[22054] = "T\195\182dliches Gift VII/150/Cp",
	[2930] = "Essenz des Schmerzes/50/V",
	[6951] = "Gedankenbenebelndes Gift II/75/Cp",
	[2893] = "T\195\182dliches Gift II/55/Cp",
	[9186] = "Gedankenbenebelndes Gift III/175/Cp",
	[2892] = "T\195\182dliches Gift/30/Cp",
	[8924] = "Staub der Verschlechterung/100/V",
	[10920] = "Wundgift II/67/Cp",
	[8926] = "Sofort wirkendes Gift IV/75/Cp",
--new
    [30038] = "G\195\188rtel der Zauberwucht/0/Ct",
    [30040] = "G\195\188rtel der tiefen Schatten/0/Cl",
    [30042] = "G\195\188rtel der naturgleichen Kraft/0/Cl",
    [30046] = "G\195\188rtel des schwarzen Adlers/0/Cl",
    [30036] = "G\195\188rtel des langen Weges/0/Ct",
    [30037] = "Stiefel der Zauberwucht/0/Ct",
    [30041] = "Stiefel der naturgleichen Anmut/0/Cl",
    [30045] = "Stiefel des Purpurfalken/0/Cl",
    [30035] = "Stiefel des langen Weges/0/Ct",
    [30043] = "Stiefel des Wirbelsturms/0/Cl",
    [30044] = "G\195\188rtel des Monsuns/0/Cl",
    [30034] = "G\195\188rtel des W\195\164chters/0/Cb",
    [30033] = "Stiefel des Besch\195\188tzers/0/Cb",
    [30032] = "Roter G\195\188rtel der Schlacht/0/Cb",
    [30031] = "Rote Stiefel der Verw\195\188stung/0/Cb",
    [32199] = "Scheinender Purpurspinell/0/Cj",
    [32210] = "Gro\195\159es L\195\182wenauge/0/Cj",
    [32217] = "Gravierter Pyrostein/0/Cj",
    [32209] = "Mystisches L\195\182wenauge/0/Cj",
    [32212] = "Unbest\195\164ndiger Schattensangamethyst/0/Cj",
    [32211] = "Stattlicher Schattensangamethyst/0/Cj",
    [32203] = "St\195\188rmischer Engelssaphir/0/Cj",
    [32221] = "Verschleierter Pyrostein/0/Cj",
    [32574] = "Bindungen der blitzartigen Reflexe/0/Cl",
    [32579] = "Lebendige Erdschultern/0/Cl",
    [32587] = "Mantelung des flinken Gedankens/0/Ct",
    [32583] = "Schulterpolster des neuen Lebens/0/Cl",
    [32580] = "Flinkschlagarmschienen/0/Cl",
    [32573] = "Morgenstahlschultern/0/Cb",
    [32568] = "Flinkstahlarmschienen/0/Cb",
    [32586] = "Armschienen des flinken Gedankens/0/Ct",
    [32582] = "Armschienen des neuen Lebens/0/Cl",
    [32577] = "Lebendige Erdbindungen/0/Cl",
    [32583] = "Schulterpolster des neuen Lebens/0/Cl",
    [32575] = "Schultern der blitzartigen Reflexe/0/Cl",
    [32581] = "Flinkschlagschultern/0/Cl",
    [32571] = "Morgenstahlarmschienen/0/Cb",
    [32570] = "Flinkstahlschultern/0/Cb",
    [30039] = "Stiefel der totalen Finsternis/0/Cl",
    [32398] = "Stiefel der gefangenen Seelen/0/Cl",
    [32399] = "Armschienen der gefangenen Seelen/0/Cl",
    [32400] = "Schienbeinsch\195\188tzer der gefangenen Seelen/0/Cl",
    [32397] = "Taillenschutz der gefangenen Seelen/0/Cl",
    [32393] = "Sattelgurt der erl\195\182sten Seele/0/Cl",
    [32396] = "Beinsch\195\188tzer der erl\195\182sten Seele/0/Cl",
    [32394] = "Mokassins der erl\195\182sten Seele/0/Cl",
    [32395] = "Handgelenkssch\195\188tzer der erl\195\182sten Seele/0/Cl",
    [32420] = "Nachtend/0/Ct",
    [32392] = "Armschienen der Seelenwache/0/Ct",
    [32390] = "Gurt der Seelenwache/0/Ct",
    [32389] = "Gamaschen der Seelenwache/0/Ct",
    [32391] = "Schuhe der Seelenwache/0/Ct",
    [32403] = "D\195\164mmerstahlarmschienen/0/Cb",
    [32401] = "D\195\164mmerstahlgurt/0/Cb",
    [32404] = "D\195\164mmerstahlbeinsch\195\188tzer/0/Cb",
    [32402] = "D\195\164mmerstahlschuhe/0/Cb",
    [33173] = "Zornstahlschultern/0/Cb",
    [32213] = "Ausbalancierter Schattensangamethyst/0/Cj",
    [32193] = "Klobiger Purpurspinell/0/Cj",
    [32197] = "Heller Purpurspinell/0/Cj",
    [32204] = "Brillantiertes L\195\182wenauge/0/Cj",
    [32225] = "Schillernder Gischtsmaragd/0/Cj",
    [32194] = "Feingeschliffener Purpurspinell/0/Cj",
    [32223] = "Robuster Gischtsmaragd/0/Cj",
    [32207] = "Schimmerndes L\195\182wenauge/0/Cj",
    [32220] = "Glitzernder Pyrostein/0/Cj",
    [32215] = "Leuchtender Schattensangamethyst/0/Cj",
    [32214] = "Energieerf\195\188llter Schattensangamethyst/0/Cj",
    [32226] = "Gezackter Gischtsmaragd/0/Cj",
    [32219] = "Gl\195\164nzender Pyrostein/0/Cj",
    [32202] = "Irisierender Engelssaphir/0/Cj",
    [32218] = "M\195\164chtiger Pyrostein/0/Cj",
    [32224] = "Strahlender Gischtsmaragd/0/Cj",
    [32206] = "Massives L\195\182wenauge/0/Cj",
    [32216] = "K\195\182niglicher Schattensangamethyst/0/Cj",
    [32196] = "Runenverzierter Purpurspinell/0/Cj",
    [32205] = "Glattes L\195\182wenauge/0/Cj",
    [32200] = "Gediegener Engelssaphir/0/Cj",
    [32201] = "Funkelnder Engelssaphir/0/Cj",
    [32198] = "Fragiler Purpurspinell/0/Cj",
    [32195] = "Tr\195\164nenf\195\182rmiger Purpurspinell/0/Cj",
    [32208] = "Kompaktes L\195\182wenauge/0/Cj",
    [32222] = "T\195\188ckischer Pyrostein/0/Cj",
    [33140] = "Bernsteinblut/0/Cj",
    [33131] = "Blutrote Sonne/0/Cj",
    [33133] = "Don Julios Herz/0/Cj",
    [33144] = "Facette der Ewigkeit/0/Cj",
    [33135] = "Sternschnuppe/0/Cj",
    [33134] = "Kailees Rose/0/Cj",
    [33143] = "Stein der Klingen/0/Cj",
    [33204] = "Brustschutz des Schattenschleichers/0/Cl",
    [33122] = "Umhang der Dunkelheit/0/Cl",
    [33208] = "Fl\195\164schchen des chromatischen Wunders/0/Ca",
    [7191] = "Verschmorte Verkabelung/0/CeD",
    [33782] = "Best\195\164ndiger Talasit/0/Cj",
    [17056] = "Leichte Feder/0/D",
    [25719] = "Arakkoafeder/0/D",
    [34249] = "Hula-Wackelpuppe/0/D",
    [27503] = "Rolle der St\195\164rke V/0/DV",
    [34220] = "Wechselhafter Himmelsfeuerdiamant/0/Cj",
    [33867] = "Gebratene Blutflosse/0/Cc",
    [33924] = "K\195\182stlicher Schokoladenkuchen/0/Cc",
    [34411] = "Hei\195\159er Apfelwein/0/Cc",
    [33874] = "Kiblers H\195\164ppchen/0/Cc",
    [33825] = "Sch\195\164delfischsuppe/0/Cc",
    [33872] = "Feuriger W\195\188rztalbuk/0/Cc",
    [33866] = "Sturmkoteletts/0/Cc",
    [34060] = "Steuerung f\195\188r eine Flugmaschine/0/Ce",
    [34061] = "Steuerung f\195\188r eine turbogetriebene Flugmaschine/0/Ce",
    [34113] = "Feldreparaturbot 110G/0/Ce",
    [20475] = "Automat f\195\188r Adamantitpfeile/0/Ce",
    [34440] = "Trank des verr\195\188ckten Alchimisten/0/Ca",
    [-42974] = "Enchant Weapon: Executioner/0/Cn",
    [-44383] = "Enchant Shield Resilience/0/Cn",
    [32854] = "Hammer der rechtschaffenen Macht/0/Cb",
    [33185] = "Adamantitwaffenkette/0/Cb",
    [33791] = "Schweres Kupferlangschwert/0/Cb",
    [34207] = "Handschuhverst\195\164rkung/0/Cb",
    [34099] = "Munitionsbeutel aus Knotenhautleder/0/Cl",
    [34100] = "K\195\182cher aus Knotenhautleder/0/Cl",
    [34105] = "K\195\182cher der tausend Federn/0/Cl",
    [34106] = "Munitionsbeutel aus Netherschuppen/0/Cl",
    [34490] = "Balgtasche/0/Cl",
    [34482] = "Ranzen des Lederers/0/Cl",
    [34086] = "Winterstiefel/0/Cl",
    [34087] = "Gr\195\188ne Winterkleidung/0/Ct",
    [34085] = "Rote Winterkleidung/0/Ct",
    [34330] = "Schweres Knotenhautlederset/0/Cl",
    [33823] = "Blutflossenwels/0/F",
    [34412] = "Prickelnder Apfelwein/0/Q",
    [33824] = "Mondsch\195\164delfisch/0/F",
    [13757] = "Zitteraal/0/F",
    [34360] = "Amulett des flie\195\159enden Lebens/0/Cj",
    [34361] = "Band aus Hartkhorium/0/Cj",
    [34358] = "Halsschmuck aus Hartkhorium/0/Cj",
    [34359] = "Anh\195\164nger aus Sonnenfeuer/0/Cj",
    [34362] = "Ring der geschmiedeten Macht/0/Cj",
    [34363] = "Ring des flie\195\159enden Lebens/0/Cj",
    [34369] = "Panzerung von Sonne und Schatten/0/Cl",
    [34373] = "Umarmung des Ph\195\182nix/0/Cl",
    [34374] = "Pfeilmacherhandschuhe des Ph\195\182nix/0/Cl",
    [34370] = "Handschuhe der unsterblichen D\195\164mmerung/0/Cl",
    [34367] = "H\195\164nde des ewigen Lichtes/0/Ct",
    [34371] = "Lederbrustschutz der Sonne/0/Cl",
    [34372] = "Lederhandschuhe der Sonne/0/Cl",
    [34365] = "Robe des ewigen Lichtes/0/Ct",
    [34375] = "Sonnengetr\195\164nkter Schuppenbrustschutz/0/Cl",
    [34376] = "Sonnengetr\195\164nkte Schuppenhandschuhe/0/Cl",
    [34366] = "Sonnenfeuerhandlappen/0/Ct",
    [34364] = "Sonnenfeuerrobe/0/Ct",
    [34378] = "Kampff\195\164uste aus Hartkhorium/0/Cb",
    [34377] = "Kampfplatte aus Hartkhorium/0/Cb",
    [34379] = "Sonnengesegnete Brustplatte/0/Cb",
    [34380] = "Sonnengesegnete Stulpen/0/Cb",
    [34847] = "Holobrille des Vernichters/0/Ce",
    [34357] = "Brille aus Hartkhorium/0/Ce",
    [35182] = "Mondmikroskopbrille/0/Ce",
    [35185] = "Gerechtomatbrille 3000/0/Ce",
    [34355] = "Blitzge\195\164tzte Brille/0/Ce",
    [34354] = "Chaosprognosebrille/0/Ce",
    [35181] = "Superheillinse 9000/0/Ce",
    [35184] = "Urgestimmte Brille/0/Ce",
    [34353] = "Vieltotmacherbrille X44/0/Ce",
    [34356] = "Volltrefferbrille v3.0/0/Ce",
    [35183] = "Wunderheilbinokel XT68/0/Ce",
    [34832] = "Kapit\195\164n Rumseys Lagerbier/0/Cc",
    [35503] = "Glimmender Himmelsfeuerdiamant/0/Cj",
    [35501] = "Ewiger Erdsturmdiamant/0/Cj",
    [35563] = "Verkohlter B\195\164renkebap/0/Cc",
    [35565] = "Saftiger B\195\164renburger/0/Cc",
    [35128] = "Geh\195\164rtetes Khorium/0/Cs",
    [35759] = "Kraftvoller Gischtsmaragd/0/Cj",
    [35761] = "Spiegelndes L\195\182wenauge/0/Cj",
    [35760] = "Tollk\195\188hner Pyrostein/0/Cj",
    [35758] = "Best\195\164ndiger Gischtsmaragd/0/Cj",
    [35581] = "Raketenstiefel Xtrem-Lite/0/Cj",
    [35700] = "Figur - Scharlachrote Schlange/0/Cj",
    [35693] = "Figur - Himmlische Schildkr\195\182te/0/Cj",
    [35694] = "Figur - Khoriumeber/0/Cj",
    [35703] = "Figur - Gischtalbatross/0/Cj",
    [35702] = "Figur - Schattensangpanther/0/Cj",
    [35707] = "Majest\195\164tisches Nachtauge/0/Cj",
    [35751] = "Alchimistenstein des Assassinen/0/Cj",
    [35748] = "Alchimistenstein des W\195\164chters/0/Cj",
    [35750] = "Alchimistenstein des Erl\195\182sers/0/Cj",
    [35749] = "Alchimistenstein des Zauberhexers/0/Cj",
    [34664] = "Sonnenpartikel/0/D",
    [35562] = "B\195\164renflanke/0/D",
    [35318] = "Kraftvoller Talasit/0/Cj",
    [35315] = "Spiegelnder D\195\164mmerstein/0/Cj",
    [35316] = "Tollk\195\188hner Edeltopas/0/Cj",}

TradeskillInfo.vars.enchants = {
	[-7428] = "Armschiene - Schwache Abwehr/Armschienen dauert so verzaubern, dass die Verteidigungswertung um 2 erh\195\182ht wird.",
	[-7418] = "Armschiene - Schwache Gesundheit/Armschienen dauerhaft verzaubern, sodass die Gesundheit des Tr\195\164gers um 5 erh\195\182ht wird.",
	[-7420] = "Brust - Schwache Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit des Tr\195\164gers um 5 erh\195\182ht wird.",
	[-7443] = "Brust - Schwaches Mana/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana des Tr\195\164gers um 5 erh\195\182ht wird.",
	[-7426] = "Brust - Schwache Absorption/Ein Teil der Brustr\195\188stung verzaubern, sodass bei jedem Treffer eine Chance von 2% besteht, Euch 10 Punkte Schadensabsorption zu geben.",
	[-7454] = "Umhang - Schwacher Widerstand/Einen Umhang dauerhaft verzaubern, sodass sich der Widerstand gegen alle Arten von Magie um 1 erh\195\182ht.",
	[-7457] = "Armschiene - Schwache Ausdauer/Armschienen dauerhaft verzaubern, sodass sich die Ausdauer des Tr\195\164gers um 1 erh\195\182ht.",
	[-7766] = "Armschiene - Schwache Willenskraft/Armschienen dauerhaft verzaubern, sodass sich die Willenskraft des Tr\195\164gers um 1 erh\195\182ht.",
	[-7748] = "Brust - Geringe Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit des Tr\195\164gers um 15 erh\195\182ht wird.",
	[-7771] = "Umhang - Schwacher Schutz/Einen Umhang verzaubern, sodass 10 zus\195\164tzliche R\195\188stungspunkte gew\195\164hrt werden.",
	[-7779] = "Armschiene - Schwache Beweglichkeit/Armschienen dauerhaft verzaubern, sodass sich die Beweglichkeit des Tr\195\164gers um 1 erh\195\182ht.",
	[-7782] = "Armschiene - Schwache St\195\164rke/Armschienen dauerhaft verzaubern, sodass sich die St\195\164rke des Tr\195\164gers um 1 erh\195\182ht.",
	[-7776] = "Brust - Geringes Mana/Einen Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana des Tr\195\164gers um 20 erh\195\182ht wird.",
	[-7786] = "Waffe - Schwacher Wildtiert\195\182ter/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit Wildtieren 2 zus\195\164tzliche Schadenspunkte zugef\195\188gt werden.",
	[-7788] = "Waffe - Schwaches Schlagen/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit 1 zus\195\164tzlicher Schadenspunkt zugef\195\188gt wird.",
	[-7793] = "Zweihandwaffe - Geringe Intelligenz/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass sie die Intelligenz um 3 erh\195\182ht.",
	[-7745] = "Zweihandwaffe - Schwacher Einschlag/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass damit 2 zus\195\164tzliche Schadenspunkte verursacht werden.",
	[-13378] = "Schild - Schwache Ausdauer/Einen Schild dauerhaft verzaubern, sodass sich die Ausdauer des Tr\195\164gers um 1 erh\195\182ht.",
	[-13380] = "Zweihandwaffe - Geringe Willenskraft/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass sie die Willenskraft um 3 erh\195\182ht.",
	[-13419] = "Umhang - Schwache Beweglichkeit/Einen Umhang dauerhaft verzaubern, sodass die Beweglichkeit um +1 erh\195\182ht wird.",
	[-13421] = "Umhang - Geringer Schutz/Einen Umhang dauerhaft verzaubern, sodass die R\195\188stung um 20 erh\195\182ht wird.",
	[-13464] = "Schild - Geringer Schutz/Einen Schild dauerhaft verzaubern, um seine R\195\188stung um 30 zu erh\195\182hen.",
	[-7859] = "Armschiene - Geringe Willenskraft/Eine Armschiene dauerhaft verzaubern, sodass sich die Willenskraft des Tr\195\164gers um 3 erh\195\182ht.",
	[-7857] = "Brust - Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit des Tr\195\164gers um 25 erh\195\182ht wird.",
	[-7867] = "Stiefel - Schwache Beweglichkeit/Ein Paar Stiefel dauerhaft verzaubern, sodass sich die Beweglichkeit des Tr\195\164gers um 1 erh\195\182ht.",
	[-7863] = "Stiefel - Schwache Ausdauer/Ein Paar Stiefel dauerhaft verzaubern, sodass sich die Ausdauer des Tr\195\164gers um 1 erh\195\182ht.",
	[-7861] = "Umhang - Geringer Feuerwiderstand/Einen Umhang dauerhaft verzaubern, sodass sich der Feuerwiderstand um 5 erh\195\182ht.",
	[-13501] = "Armschiene - Geringe Ausdauer/Eine Armschiene dauerhaft verzaubern, sodass sich die Ausdauer des Tr\195\164gers um 3 erh\195\182ht.",
	[-13485] = "Schild - Geringe Willenskraft/Einen Schild dauerhaft verzaubern, sodass die Willenskraft um 3 erh\195\182ht wird.",
	[-13522] = "Umhang - Geringer Schattenwiderstand/Einen Umhang dauerhaft verzaubern, sodass sich der Schattenwiderstand um 10 erh\195\182ht.",
	[-13536] = "Armschiene - Geringe St\195\164rke/Eine Armschiene dauerhaft verzaubern, sodass sich die St\195\164rke des Tr\195\164gers um 3 erh\195\182ht.",
	[-13538] = "Brust - Geringe Absorption/Ein Teil der Brustr\195\188stung verzaubern, sodass bei jedem Treffer eine Chance von 5% besteht, Euch 25 Punkte Schadensabsorption zu geben.",
	[-13503] = "Waffe - Geringes Schlagen/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit 2 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13529] = "Zweihandwaffe - Geringer Einschlag/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass damit 3 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13607] = "Brust - Mana/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana des Tr\195\164gers um 30 erh\195\182ht wird.",
	[-13620] = "Handschuhe - Angeln/Handschuhe dauerhaft verzaubern, sodass die Angelfertigkeit um +2 erh\195\182ht wird.",
	[-13617] = "Handschuhe - Kr\195\164uterkunde/Handschuhe dauerhaft verzaubern, sodass die Kr\195\164uterkundefertigkeit um +2 erh\195\182ht wird.",
	[-13612] = "Handschuhe - Bergbau/Handschuhe dauerhaft verzaubern, sodass die Bergbaufertigkeit um +2 erh\195\182ht wird.",
	[-13622] = "Armschiene - Geringe Intelligenz/Eine Armschiene dauerhaft verzaubern, sodass sich die Intelligenz des Tr\195\164gers um 3 erh\195\182ht.",
	[-13626] = "Brust - Schwache Werte/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass alle Werte um 1 erh\195\182ht werden.",
	[-13635] = "Umhang - Verteidigung/Einen Umhang dauerhaft verzaubern, sodass die R\195\188stung zus\195\164tzlich um 30 erh\195\182ht wird.",
	[-13631] = "Schild - Geringe Ausdauer/Einen Schild dauerhaft verzaubern, sodass die Ausdauer um 3 erh\195\182ht wird.",
	[-13637] = "Stiefel - Geringe Beweglichkeit/Stiefel dauerhaft verzaubern, sodass die Beweglichkeit um +3 erh\195\182ht wird.",
	[-13640] = "Brust - Gro\195\159e Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit um +35 erh\195\182ht wird.",
	[-13642] = "Armschiene - Willenskraft/Verzaubert Armschienen dauerhaft, sodass die Willenskraft um +5 erh\195\182ht wird.",
	[-13644] = "Stiefel - Geringe Ausdauer/Stiefel dauerhaft verzaubern, sodass die Ausdauer um +3 erh\195\182ht wird.",
	[-13646] = "Armschiene - Geringe Abwehr/Armschienen dauerhaft so verzaubern, dass die Verteidigungswertung um 3 erh\195\182ht wird.",
	[-13648] = "Armschiene - Ausdauer/Verzaubert Armschienen dauerhaft, sodass die Ausdauer um +5 erh\195\182ht wird.",
	[-13657] = "Umhang - Feuerwiderstand/Einen Umhang dauerhaft verzaubern, sodass der Feuerwiderstand um 7 erh\195\182ht wird.",
	[-13653] = "Waffe - Geringer Wildtiert\195\182ter/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit Wildtieren 6 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13655] = "Waffe - Geringer Elementart\195\182ter/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit Elementaren 6 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13661] = "Armschiene - St\195\164rke/Verzaubert Armschienen dauerhaft, sodass die St\195\164rke um +5 erh\195\182ht wird.",
	[-13659] = "Schild - Willenskraft/Einen Schild dauerhaft verzaubern, sodass die Willenskraft um 5 erh\195\182ht wird.",
	[-13663] = "Brust - Gro\195\159es Mana/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana um +50 erh\195\182ht wird.",
	[-13687] = "Stiefel - Geringe Willenskraft/Stiefel dauerhaft verzaubern, sodass die Willenskraft um +3 erh\195\182ht wird.",
	[-21931] = "Waffe - Wintermacht/Eine Waffe dauerhaft verzaubern, sodass sie beim Wirken von Frostzaubern bis zu 7 Punkte zus\195\164tzlichen Frostschaden verursacht.",
	[-13689] = "Schild - Geringes Blocken/Einen Schild dauerhaft so verzaubern, dass er die Blockwertung um 10 erh\195\182ht.",
	[-13693] = "Waffe - Schlagen/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit 3 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13695] = "Zweihandwaffe - Einschlag/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass damit 5 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13700] = "Brust - Geringe Werte/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass alle Werte um +2 erh\195\182ht werden.",
	[-13698] = "Handschuhe - K\195\188rschnerei/Handschuhe dauerhaft verzaubern, sodass die K\195\188rschnereifertigkeit um +5 erh\195\182ht wird.",
	[-13746] = "Umhang - Gro\195\159e Verteidigung/Einen Umhang dauerhaft verzaubern, sodass die R\195\188stung zus\195\164tzlich um 50 erh\195\182ht wird.",
	[-13794] = "Umhang - Widerstand/Einen Umhang dauerhaft verzaubern, sodass alle Widerst\195\164nde um 3 erh\195\182ht werden.",
	[-13822] = "Armschiene - Intelligenz/Verzaubert Armschienen dauerhaft, sodass die Intelligenz um +5 erh\195\182ht wird.",
	[-13815] = "Handschuhe - Beweglichkeit/Handschuhe dauerhaft verzaubern, sodass die Beweglichkeit um +5 erh\195\182ht wird.",
	[-13817] = "Schild - Ausdauer/Einen Schild dauerhaft verzaubern, sodass die Ausdauer um +5 erh\195\182ht wird.",
	[-13836] = "Stiefel - Ausdauer/Stiefel dauerhaft verzaubern, sodass die Ausdauer um +5 erh\195\182ht wird.",
	[-13841] = "Handschuhe - Hochentwickelter Bergbau/Handschuhe dauerhaft verzaubern, sodass die Bergbaufertigkeit um +5 erh\195\182ht wird.",
	[-13846] = "Armschiene - Gro\195\159e Willenskraft/Verzaubert Armschienen dauerhaft, sodass die Willenskraft um +7 erh\195\182ht wird.",
	[-13858] = "Brust - \195\156berragende Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit um +50 erh\195\182ht wird.",
	[-13890] = "Stiefel - Schwaches Tempo/Stiefel dauerhaft verzaubern, um eine kleine Erh\195\182hung des Bewegungstempos zu erhalten.",
	[-13882] = "Umhang - Geringe Beweglichkeit/Einen Umhang dauerhaft verzaubern, sodass die Beweglichkeit um 3 erh\195\182ht wird.",
	[-13868] = "Handschuhe - Hochentwickelte Kr\195\164uterkunde/Handschuhe dauerhaft verzaubern, sodass die Kr\195\164uterkundefertigkeit um +5 erh\195\182ht wird.",
	[-13887] = "Handschuhe - St\195\164rke/Handschuhe dauerhaft verzaubern, sodass die St\195\164rke um +5 erh\195\182ht wird.",
	[-13917] = "Brust - \195\156berragendes Mana/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana um +65 erh\195\182ht wird.",
	[-13905] = "Schild - Gro\195\159e Willenskraft/Einen Schild dauerhaft verzaubern, sodass die Willenskraft um +7 erh\195\182ht wird.",
	[-13915] = "Waffe - D\195\164monent\195\182ten/Eine Nahkampfwaffe dauerhaft verzaubern, um eine Chance zu haben, D\195\164monen zu bet\195\164uben und ihnen schweren Schaden zuzuf\195\188gen.",
	[-13935] = "Stiefel - Beweglichkeit/Stiefel dauerhaft verzaubern, sodass die Beweglichkeit um +5 erh\195\182ht wird.",
	[-13931] = "Armschiene - Abwehr/Armschienen dauerhaft so verzaubern, dass die Verteidigungswertung um 5 erh\195\182ht wird.",
	[-13933] = "Schild - Frostwiderstand/Einen Schild dauerhaft verzaubern, um +8 Frostwiderstand zu erhalten.",
	[-13937] = "Zweihandwaffe - Gro\195\159er Einschlag/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass damit +7 Schaden zugef\195\188gt wird.",
	[-13939] = "Armschiene - Gro\195\159e St\195\164rke/Verzaubert Armschienen dauerhaft, um +7 St\195\164rke zu erhalten.",
	[-13945] = "Armschiene - Gro\195\159e Ausdauer/Verzaubert Armschienen dauerhaft, sodass die Ausdauer um +7 erh\195\182ht wird.",
	[-13941] = "Brust - Werte/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass alle Werte um +3 erh\195\182ht werden.",
	[-13943] = "Waffe - Gro\195\159es Schlagen/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit 4 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-13948] = "Handschuhe - Schwache Hast/Handschuhe dauerhaft verzaubern, sodass die Distanztempowertung um 10 erh\195\182ht wird.",
	[-13947] = "Handschuhe - Reitfertigkeit/Handschuhe dauerhaft verzaubern, um einen schwachen Bewegungsbonus zu erlangen, w\195\164hrend man auf einem Reittier sitzt.",
	[-20008] = "Armschiene - Gro\195\159e Intelligenz/Verzaubert Armschienen dauerhaft, sodass die Intelligenz um +7 erh\195\182ht wird.",
	[-20020] = "Stiefel - Gro\195\159e Ausdauer/Stiefel dauerhaft verzaubern, sodass die Ausdauer um +7 erh\195\182ht wird.",
	[-20014] = "Umhang - Gro\195\159er Widerstand/Einen Umhang dauerhaft verzaubern, sodass alle Widerst\195\164nde um 5 erh\195\182ht werden.",
	[-20017] = "Schild - Gro\195\159e Ausdauer/Einen Schild dauerhaft verzaubern, sodass die Ausdauer um +7 erh\195\182ht wird.",
	[-13898] = "Waffe - Feurige Waffe/Eine Nahkampfwaffe dauerhaft verzaubern, sodass Schl\195\164ge damit oft 40 Feuerschaden zus\195\164tzlich zuf\195\188gen.",
	[-20009] = "Armschiene - \195\156berragende Willenskraft/Verzaubert Armschienen dauerhaft, sodass die Willenskraft um +9 erh\195\182ht wird.",
	[-20012] = "Handschuhe - Gro\195\159e Beweglichkeit/Handschuhe dauerhaft verzaubern, sodass die Beweglichkeit um +7 erh\195\182ht wird.",
	[-20024] = "Stiefel - Willenskraft/Stiefel dauerhaft verzaubern, sodass die Willenskraft um +5 erh\195\182ht wird.",
	[-20026] = "Brust - Erhebliche Gesundheit/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass die Gesundheit um +100 erh\195\182ht wird.",
	[-20016] = "Schild - Erhebliche Willenskraft/Einen Schild dauerhaft verzaubern, sodass die Willenskraft um +9 erh\195\182ht wird.",
	[-20015] = "Umhang - \195\156berragende Verteidigung/Einen Umhang dauerhaft verzaubern, sodass die R\195\188stung zus\195\164tzlich um 70 erh\195\182ht wird.",
	[-20029] = "Waffe - Eisiger Hauch/Eine Nahkampfwaffe dauerhaft verzaubern, sodass das Ziel oft mit K\195\164lteeffekten belegt wird und sein Bewegungstempo sowie sein Angriffstempo verringert wird. Verringerter Effekt bei Spielern über Stufe 60.",
	[-27837] = "Zweihandwaffen - Beweglichkeit/Eine Zweihandnahkampfwaffe dauerhaft verzaubern, sodass sie die Beweglichkeit um +25 erh\195\182ht.",
	[-23801] = "Armschiene - Manaregeneration/Armschienen dauerhaft verzaubern, sodass sie alle 5 Sek. 4 Mana wiederherstellen.",
	[-20028] = "Brust - Erhebliches Mana/Einen Teil der Brustr\195\188stung dauerhaft verzaubern, sodass das Mana um +100 erh\195\182ht wird.",
	[-23800] = "Waffe - Beweglichkeit/Eine Nahkampfwaffe dauerhaft verzaubern, sodass sie die Beweglichkeit um 15 erh\195\182ht.",
	[-23799] = "Waffe - St\195\164rke/Eine Nahkampfwaffe dauerhaft verzaubern, sodass sie die St\195\164rke um 15 erh\195\182ht.",
	[-20030] = "Zweihandwaffe - \195\156berragender Einschlag/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass damit +9 Schaden zugef\195\188gt wird.",
	[-20023] = "Stiefel - Gro\195\159e Beweglichkeit/Stiefel dauerhaft verzaubern, sodass die Beweglichkeit um +7 erh\195\182ht wird.",
	[-20010] = "Armschiene - \195\156berragende St\195\164rke/Verzaubert Armschienen dauerhaft, um +9 St\195\164rke zu erhalten.",
	[-20013] = "Handschuhe - Gro\195\159e St\195\164rke/Handschuhe dauerhaft verzaubern, sodass die St\195\164rke um +7 erh\195\182ht wird.",
	[-20033] = "Waffe - Unheilige Waffe/Eine Nahkampfwaffe dauerhaft verzaubern, sodass das Ziel oft mit einem Fluch belegt und der angerichtete Nahkampfschaden verringert wird.",
	[-20036] = "Zweihandwaffen - Erhebliche Intelligenz/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass sie die Intelligenz um 9 erh\195\182ht.",
	[-20035] = "Zweihandwaffe - Erhebliche Willenskraft/Eine Zweihand-Nahkampfwaffe dauerhaft verzaubern, sodass sie die Willenskraft um 9 erh\195\182ht.",
	[-34002] = "Armschiene - Sturmangriff/Armschienen dauerhaft so verzaubern, dass sie die Angriffskraft um 24 erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-23802] = "Armschiene - Heilkraft/Armschienen dauerhaft verzaubern, sodass sie den Effekt Eurer Heilzauber um 24 und Eurer Schadenszauber um bis zu 8 Punkte erh\195\182hen.",
	[-20011] = "Armschiene - \195\156berragende Ausdauer/Verzaubert Armschienen dauerhaft, sodass die Ausdauer um +9 erh\195\182ht wird.",
	[-20025] = "Brust - Gro\195\159e Werte/Ein Teil der Brustr\195\188stung dauerhaft verzaubern, sodass alle Werte um +4 erh\195\182ht werden.",
	[-33991] = "Brust - Mana wiederherstellen/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie alle 5 Sek.. 6 Mana gew\195\164hrt. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-25086] = "Umhang - Ausweichen/Umhang dauerhaft so verzaubern, dass die Ausweichwertung um 12 erh\195\182ht wird.",
	[-25081] = "Umhang - Gro\195\159er Feuerwiderstand/Umhang dauerhaft verzaubern, sodass der Feuerwiderstand um 15 erh\195\182ht wird.",
	[-25082] = "Umhang - Gro\195\159er Naturwiderstand/Umhang dauerhaft verzaubern, sodass der Naturwiderstand um 15 erh\195\182ht wird.",
	[-25083] = "Umhang - Verstohlenheit/Umhang dauerhaft verzaubern, sodass die Verstohlenheit erh\195\182ht wird.",
	[-25084] = "Umhang - Feingef\195\188hl/Umhang dauerhaft verzaubern, sodass die vom Tr\195\164ger verursachte Bedrohung um 2% verringert wird.",
	[-25078] = "Handschuhe - Feuermacht/Handschuhe dauerhaft verzaubern, sodass der Feuerschaden um +20 erh\195\182ht wird.",
	[-25074] = "Handschuhe - Frostmacht/Handschuhe dauerhaft verzaubern, sodass der Frostschaden um 20 erh\195\182ht wird.",
	[-25079] = "Handschuhe - Heilkraft/Handschuhe dauerhaft verzaubern, sodass die Heilzauber des Tr\195\164gers um 30 und die Schadenszauber um bis zu 10 erh\195\182ht werden.",
	[-25073] = "Handschuhe - Schattenmacht/Handschuhe dauerhaft verzaubern, sodass der Schattenschaden um 20 erh\195\182ht wird.",
	[-25080] = "Handschuhe - \195\156berragende Beweglichkeit/Handschuhe dauerhaft verzaubern, sodass die Beweglichkeit um 15 erh\195\182ht wird.",
	[-25072] = "Handschuhe - Bedrohung/Handschuhe dauerhaft verzaubern, sodass die Bedrohung von allen Attacken und Zaubern um 2% erh\195\182ht wird.",
	[-20034] = "Waffe - Kreuzfahrer/Eine Nahkampfwaffe dauerhaft verzaubern, sodass sie bei Nahkampfangriffen oft 75 bis 125 heilt und 15 Sek. lang die St\195\164rke um 100 erh\195\182ht. Verringerter Effekt bei Spielern über Stufe 60.",
	[-22750] = "Waffe - Heilkraft/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie die Heilwirkung von Heilzaubern um bis zu 55 Punkte und den Schaden von Schadenszaubern um bis zu 19 Punkte erh\195\182ht.",
	[-20032] = "Waffe - Lebensdiebstahl/Eine Nahkampfwaffe dauerhaft verzaubern, sodass vom Feind oft Leben gestohlen und auf den Benutzer \195\188bertragen wird. Verringerter Effekt bei Spielern über Stufe 60.",
	[-23804] = "Waffe - M\195\164chtige Intelligenz/Eine Nahkampfwaffe dauerhaft verzaubern, sodass sie die Intelligenz um 22 erh\195\182ht.",
	[-23803] = "Waffe - M\195\164chtige Willenskraft/Eine Nahkampfwaffe dauerhaft verzaubern, sodass sie die Willenskraft um 20 erh\195\182ht.",
	[-22749] = "Waffe - Zauberkraft/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie den Schaden und die Heilung aller Zauber um bis zu 30 Punkte erh\195\182ht.",
	[-20031] = "Waffe - \195\156berragendes Schlagen/Eine Nahkampfwaffe dauerhaft verzaubern, sodass damit 5 zus\195\164tzliche Punkte Schaden zugef\195\188gt werden.",
	[-27948] = "Stiefel - Vitalit\195\164t/Stiefel dauerhaft so verzaubern, dass sie alle 5 Sek. 4 Gesundheit und Mana wiederherstellen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27899] = "Armschiene - Muskelkraft/Armschienen dauerhaft so verzaubern, dass sie die St\195\164rke um 12 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34001] = "Armschiene - Erhebliche Intelligenz/Armschienen dauerhaft so verzaubern, dass sie die Intelligenz um 12 erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33993] = "Handschuhe - Sprengkraft/Handschuhe dauerhaft so verzaubern, dass sie +10 kritische Zaubertrefferwertung gew\195\164hren. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34004] = "Umhang - Gro\195\159e Beweglichkeit/Einen Umhang dauerhaft so verzaubern, dass er die Beweglichkeit um 12 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27961] = "Umhang - Erhebliche R\195\188stung/Einen Umhang dauerhaft so verzaubern, dass er die R\195\188stung um 120 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33996] = "Handschuhe - Sturmangriff/Handschuhe dauerhaft so verzaubern, dass sie +26 Angriffskraft gew\195\164hren. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27944] = "Schild - Harter Schild/Einen Schild dauerhaft so verzaubern, dass er 18 zus\195\164tzlichen Blockwert gew\195\164hrt. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27905] = "Armschiene - Werte/Armschienen dauerhaft so verzaubern, dass sie alle Attribute um 4 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27957] = "Brust - Au\195\159ergew\195\182hnliche Gesundheit/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie +150 Gesundheit gew\195\164hrt. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27950] = "Stiefel - Seelenst\195\164rke/Stiefel dauerhaft so verzaubern, dass sie die Ausdauer um 12 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27906] = "Armschiene - Erhebliche Verteidigung/Armschienen dauerhaft so verzaubern, dass die Verteidigungswertung um 12 erh\195\182ht wird. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33990] = "Brust - Erhebliche Willenskraft/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie +15 Willenskraft gew\195\164hrt. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27911] = "Armschiene - \195\156berragende Heilung/Armschienen dauerhaft so verzaubern, dass sie den Effekt von Heilzaubern um bis zu 30 und Schadenszaubern um bis zu 10 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34003] = "Umhang - Zauberdurchschlagskraft/Einen Umhang dauerhaft so verzaubern, dass er die Zauberdurchschlagskraft um 20 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27945] = "Schild - Intelligenz/Einen Schild dauerhaft so verzaubern, dass er die Intelligenz um 12 erh\195\182ht.  Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34009] = "Schild - Erhebliche Ausdauer/Einen Schild dauerhaft so verzaubern, dass er die Ausdauer um 18 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27962] = "Umhang - Erheblicher Widerstand/Einen Umhang dauerhaft so verzaubern, dass er alle Widerst\195\164nde um 7 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27913] = "Armschiene - Mana wiederherstellen/Armschienen dauerhaft so verzaubern, dass sie alle 5 Sek. 6 Mana wiederherstellen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27951] = "Stiefel - Gewandtheit/Stiefel dauerhaft so verzaubern, dass sie die Beweglichkeit um 12 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33995] = "Handschuhe - Erhebliche St\195\164rke/Handschuhe dauerhaft so verzaubern, dass sie +15 St\195\164rke gew\195\164hren. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27946] = "Schild - Schildblock/Lehrt Euch, einen Schild dauerhaft so zu verzaubern, dass er 15 Blockwertung gew\195\164hrt. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27968] = "Waffe - Erhebliche Intelligenz/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie +30 Intelligenz gew\195\164hrt. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27967] = "Waffe - Erhebliches Schlagen/Eine Nahkampfwaffe dauerhaft so verzaubern, dass deren Schaden um 7 erh\195\182ht wird.  Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27960] = "Brust - Au\195\159ergew\195\182hnliche Werte/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie alle Werte um 6 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33992] = "Brust - Erhebliche Abh\195\164rtung/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie 15 Abh\195\164rtungswertung gew\195\164hrt. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27971] = "Zweihandwaffe - Wildheit/Eine zweih\195\164ndige Nahkampfwaffe dauerhaft so verzaubern, dass sie die Angriffskraft um 70 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27914] = "Armschiene - Seelenst\195\164rke/Armschienen dauerhaft so verzaubern, dass sie die Ausdauer um 12 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34005] = "Umhang - Gro\195\159er Arkanwiderstand/Einen Umhang dauerhaft so verzaubern, dass er den Arkanwiderstand um 15 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34006] = "Umhang - Gro\195\159er Schattenwiderstand/Einen Umhang dauerhaft so verzaubern, dass er den Schattenwiderstand um 15 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33999] = "Handschuhe - Erhebliche Heilung/Handschuhe dauerhaft so verzaubern, dass sie die Heilung um 35 und den Zauberschaden um 12 erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34010] = "Waffe - Erhebliche Heilung/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie die Heilung um +81 und den Zauberschaden um +27 erh\195\182ht. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27975] = "Waffe - Erhebliche Zaubermacht/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie Zauberschaden und Heilung um bis zu 40 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27972] = "Waffe - Potenz/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie die St\195\164rke um 20 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27977] = "Zweihandwaffe - Erhebliche Beweglichkeit/Eine zweih\195\164ndige Nahkampfwaffe dauerhaft so verzaubern, dass sie die Beweglichkeit um 35 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34008] = "Stiefel - Flinkheit des Ebers/Stiefel dauerhaft so verzaubern, dass sie Ausdauer um 9 und das Bewegungstempo geringf\195\188gig erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-34007] = "Stiefel - Schnelligkeit der Katze/Stiefel dauerhaft so verzaubern, dass sie Beweglichkeit um 6 und das Bewegungstempo geringf\195\188gig erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27917] = "Armschiene - Zaubermacht/Armschienen dauerhaft so verzaubern, dass sie Zauberschadenund Heilung um bis zu 15 erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33997] = "Handschuhe - Erhebliche Zaubermacht/Handschuhe dauerhaft so verzaubern, dass sie Zauberschaden und Heilung um bis zu 20 erh\195\182hen. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-33994] = "Handschuhe - Zauberschlag/Handschuhe dauerhaft so verzaubern, dass sie +15 Zaubertrefferwertung gew\195\164hren. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27924] = "Ring - Zaubermacht/Einen Ring dauerhaft so verzaubern, dass er Zauberschaden  und Heilung um bis zu 12 erh\195\182ht. Nur Ringe des Verzauberers k\195\182nnen verzaubert werden und sind danach seelengebunden.",
	[-27920] = "Ring - Schlagen/Einen Ring dauerhaft so verzaubern, dass er Waffenschaden um 2 erh\195\182ht. Nur Ringe des Verzauberers k\195\182nnen verzaubert werden und sind danach seelengebunden. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27947] = "Schild - Widerstand/Einen Schild dauerhaft so verzaubern, dass er Widerstand gegen alle Magiearten um 5 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-28004] = "Waffe - Meister des Kampfes/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie manchmal die gesamte Gruppe um 180 bis 300 Gesundheit heilt, wenn ein Gegner getroffen wird. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-28003] = "Waffe - Zauberflut/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie beim Zauberwirken eine Chance von 3% gew\195\164hrt, bei allen Gruppenmitgliedern 10 Sekunden lang insgesamt 100 Mana wiederherzustellen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27954] = "Stiefel - Sicherer Stand/Stiefel dauerhaft so verzaubern, dass der Widerstand gegen bewegungseinschr\195\164nkende Effekte um 5% und die Trefferwertung um 10 erh\195\182ht werden. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27926] = "Ring - Heilkraft/Einen Ring dauerhaft so verzaubern, dass er Heilzauber um bis zu 20 und Schadenszauber um bis zu 7 erh\195\182ht. Nur Ringe des Verzauberers k\195\182nnen verzaubert werden und sind danach seelengebunden. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27927] = "Ring - Werte/Einen Ring dauerhaft so verzaubern, dass er alle Werte um 4 erh\195\182ht. Nur Ringe des Verzauberers k\195\182nnen verzaubert werden und sind danach seelengebunden. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27984] = "Waffe - Mungo/Eine Nahkampfwaffe dauerhaft so verzaubern, dass eine Chance besteht, die Beweglichkeit um 120 und das Angriffstempo geringf\195\188gig zu erh\195\182hen. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27982] = "Waffe - Seelenfrost/Eine Nahkampfwaffe dauerhaft so verzaubern, dass die den Schaden von Frost- und Schattenzaubern um bis zu 54 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27981] = "Waffe - Sonnenfeuer/Eine Nahkampfwaffe dauerhaft so verzaubern, dass sie den Schaden von Feuer- und Arkanzaubern um bis zu 50 erh\195\182ht. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
	[-27958] = "Brust - Au\195\159ergew\195\182hnliches Mana/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie +150 Mana gew\195\164hrt. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
    [-42620] = "Waffe - Gro\195\159e Beweglichkeit/Eine Waffe dauerhaft verzaubern, sodass die Beweglichkeit um 20 erhöht wird. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
    [-42613] = "Nexusverwandlung/Wandelt einen Nexuskristall in einen kleinen Prismasplitter um",
    [-42615] = "Kleiner Prismasplitter/Wandelt einen Nexuskristall in einen kleinen Prismasplitter um",
    [-42974] = "Waffe - Scharfrichter/Lehrt Euch, eine Nahkampfwaffe dauerhaft so zu verzaubern, dass eine Chance besteht, 840 R\195\188stung Eures Feindes zu ignorieren. Erfordert einen Gegenstand der Stufe 60 oder h\195\182her.",
    [-44383] = "Schild - Abh\195\164rtung/Einen Schild dauerhaft verzaubern, sodass die Abh\195\164rtung um 12 erh\195\182ht wird. Erfordert einen Gegenstand der Stufe 35 oder h\195\182her.",
    [-45765] = "Brechung der Leere/Zerbricht einen Kristall der Leere in zwei Prismasplitter.",
    [-46594] = "Brust - Verteidigung/Eine Brustr\195\188stung dauerhaft so verzaubern, dass sie 15 Verteidigungswertung gew\195\164hrt. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
    [-47051] = "Umhang - Stahlgewebe/Einen Umhang dauerhaft so verzaubern, sodass die Verteidigungswertung um 12 erh\195\182ht wird. Ben\195\182tigt einen Gegenstand der Stufe 35 oder h\195\182her.",
    }

TradeskillInfo.vars.zones = {
	[1] = "Alteracgebirge",
	[2] = "Arathihochland",
	[3] = "Eschental",
	[4] = "Azshara",
	[5] = "\195\150dland",
	[6] = "Schwarzfelstiefen",
	[7] = "Verw\195\188stete Lande",
	[8] = "Brennende Steppe",
	[9] = "Dunkelk\195\188ste",
	[10] = "Darnassus",
	[11] = "Desolace",
	[12] = "D\195\188sterbruch",
	[13] = "Dun Morogh",
	[14] = "Durotar",
	[15] = "D\195\164mmerwald",
	[16] = "D\195\188stermarschen",
	[17] = "\195\150stliche Pestl\195\164nder",
	[18] = "Wald von Elwynn",
	[19] = "Teufelswald",
	[20] = "Feralas",
	[21] = "Gnomeregan",
	[22] = "Vorgebirge des H\195\188gellands",
	[23] = "Eisenschmiede",
	[24] = "Loch Modan",
	[25] = "Mondlichtung",
	[26] = "Mulgore",
	[27] = "Naxxramas",
	[28] = "Orgrimmar",
	[29] = "Rotkammgebirge",
	[30] = "Ruinen von Ahn'Qiraj",
	[31] = "Silithus",
	[32] = "Silberwald",
	[33] = "Steinkrallengebirge",
	[34] = "Sturmwind",
	[35] = "Schlingendorntal",
	[36] = "S\195\188mpfe des Elends",
	[37] = "Tanaris",
	[38] = "Teldrassil",
	[39] = "Brachland",
	[40] = "The Hinterlands",
	[41] = "Tausend Nadeln",
	[42] = "Donnerfels",
	[43] = "Tirisfal",
	[44] = "Krater von Un'Goro",
	[45] = "Unterstadt",
	[46] = "H\195\182hlen des Wehklagens",
	[47] = "Westliche Pestl\195\164nder",
	[48] = "Westfall",
	[49] = "Sumpfland",
	[50] = "Winterquell",
	[51] = "Stratholme",
	[52] = "Scholomance",
-- Burning Crusade
	[53] = "H\195\182llenfeuerhalbinsel",
	[54] = "Immersangwald",
	[55] = "Silbermond",
	[56] = "Karazhan",
	[57] = "Azurmythosinsel",
	[58] = "Die Exodar",
	[59] = "Schergrat",
	[60] = "Shattrath",
	[61] = "Nethersturm",
	[62] = "Geisterlande",
	[63] = "Vorgebirge des alten H\195\188gellands",
	[64] = "Blutmythosinsel",
	[65] = "Schattenmondtal",
	[66] = "W\195\164lder von Terokkar",
	[67] = "Zangarmarschen",
	[68] = "Gebirgspass der Totenwinde",
	[69] = "Nagrand",
         [70] = "Schwarzer Tempel",
         [71] = "Hyjalgipfel",
         [72] = "Insel von Quel'Danas",
}
TradeskillInfo.vars.factions = {
	[1] = FACTION_ALLIANCE,
	[2] = FACTION_HORDE,
	[3] = "",
	[4] = "Argentumd\195\164mmerung",
	[5] = "Zirkel des Cenarius",
	[6] = "Thoriumbruderschaft",
	[7] = "Holzschlundfeste",
	[8] = "Stamm der Zandalar",
-- Burning Crusade
	[9] = "H\195\188ter der Zeit",
	[10] = "Die W\195\164chter der Sande",
	[11] = "Das Violette Auge",
	[12] = "Expedition des Cenarius",
	[13] = "Sporeggar",
	[14] = "Thrallmar",
	[15] = "Ehrenfeste",
	[16] = "Die Mag'har",
	[17] = "Kurenai",
	[18] = "Das Konsortium",
	[19] = "Die Seher",
	[20] = "Die Aldor",
	[21] = "Die Sha'tar",
	[22] = "Unteres Viertel",
         [23] = "Die Todesh\195\182rigen",
         [24] = "Offensive der Zerschmetterten Sonne",

}
-- Kurenai / The Mag'har
-- Honor Hold / Thrallmar
-- The Scryers / The Aldor

TradeskillInfo.vars.vendors = {
--      "name|zone|faction|location|comment"
	[1] = "Abigail Shiel|43|2|61,52",
	[2] = "Aendel Windspeer|31|5|63,50",
	[3] = "Alchimist St\195\182\195\159elbruch|37|3|51,27",
	[4] = "Alexandra Bolero|34|1|43,74",
	[5] = "Algernon|45|2|52,74",
	[6] = "Amy Davenport|29|1|29,47",
	[7] = "Andrew Hilbert|32|2|43,40",
	[8] = "Androd Fadran|2|1|45,47",
	[9] = "Argentumr\195\188stmeister Hasana|43|4|83,68",
	[10] = "Argentumr\195\188stmeister Funkellicht|47|4|43,84",
	[11] = "Balai Lok'Wein|16|2|36,31",
	[12] = "Bale|19|2|35,53",
	[13] = "Banalash|36|2|45,57",
	[14] = "Blimo Federdings|4|3|46,90",
	[15] = "Blixrez Gutstich|35|3|28,77",
	[16] = "Blizrik Bockschuss|37|3|52,28",
	[17] = "Bliztik|15|3|18,54",
	[18] = "Bombus Feinspindel|23|1|40,34",
	[19] = "Borya|28|2|63,51",
	[20] = "Brienna Sternenglanz|20|1|89,46",
	[21] = "Bro'kin|1|3|38,39",
	[22] = "Bronk Muffenschlinger|20|2|76,43",
	[23] = "Catherine Leland|34|1|46,59",
	[24] = "Christoph Jeffkott|22|2|63,19",
	[25] = "Clyde Ranthal|29|1|89,70",
	[26] = "Constance Brisboise|43|2|52,55",
	[27] = "Korporal Bluth|35|1|38,3",
	[28] = "Feiger Crosby|35|3|27,83",
	[29] = "Crazk Funks|35|3|28,77",
	[30] = "Dalria|3|1|36,52",
	[31] = "Daniel Bartlett|45|2|64,38",
	[32] = "Danielle Stichelnaht|15|1|76,46",
	[33] = "Darian Singh|34|1|30,68",
	[34] = "Darnall|25|3|52,33",
	[35] = "Schieber der Defias|48|1|44,68",
	[36] = "Deneb Wandler|2|1|27,59",
	[37] = "Derak Nachtlauer|22|2|62,20",
	[38] = "Dirge Schnetzelhack|37|3|53,28",
	[39] = "Drac Grobschnitt|24|1|36,49",
	[40] = "Drake Lindgren|18|1|83,67",
	[41] = "Drovnar Starkbr\195\164u|2|1|46,47",
	[42] = "Elynna|10|1|64,22",
	[43] = "Emrul Riknussun|23|1|60,38",
	[44] = "Erika Tate|34|1|76,37",
	[45] = "Evie Wirbelbr\195\164u|50|3|61,38",
	[46] = "Fradd Schnellschalt|49|1|26,26",
	[47] = "Fyldan|10|1|48,21",
	[48] = "Quietschspross|39|3|63,36",
	[49] = "Ritzelschnitt Zahnrad|23|1|68,43",
	[50] = "George Candarte|22|2|91,39",
	[51] = "Gharash|36|2|46,52",
	[52] = "Ghok'kah|16|2|36,31",
	[53] = "Gigget Rei\195\159spule|40|3|35,39",
	[54] = "Gikkix|37|3|67,22",
	[55] = "Gina MacGregor|48|1|57,54",
	[56] = "Gloria Femmel|29|1|27,44",
	[57] = "Glyx Gutbr\195\164u|35|3|28,77",
	[58] = "Gnaz Dusselflamm|35|3|51,35",
	[59] = "Gretta Ganter|13|1|31,44",
	[60] = "Grimtak|14|2|51,42",
	[61] = "Hagrus|28|2|46,46",
	[62] = "Hammon Karwn|2|1|47,48",
	[63] = "Harggan|40|1|14,45",
	[64] = "Harklan Mondhain|3|1|51,67",
	[65] = "Harlown Dunkelwirker|3|1|18,59",
	[66] = "Harn Rutenwurf|26|2|48,55",
	[67] = "Heldan Sturmgesang|9|1|37,56",
	[68] = "Helenia Olden|16|1|66,52",
	[69] = "Himmik|50|3|61,39",
	[70] = "Hula'mahi|39|2|52,30",
	[71] = "Stupser|37|3|67,22",
	[72] = "Jandia|41|2|46,51",
	[73] = "Janet Hommers|11|1|66,7",
	[74] = "Jangdor Flinkschreiter|20|2|74,43",
	[75] = "Jannos Eisenwill|2|1|46,48",
	[76] = "Jaquilina Dramet|35|3|36,11",
	[77] = "Jase Langweg|17|3|81,58",
	[78] = "Jazzrik|5|3|42,53",
	[79] = "Jeeda|33|2|47,62",
	[80] = "Jennabink Starksaum|49|1|8,56",
	[81] = "Jessara Cordell|34|1|44,64",
	[82] = "Jinky Pfuschelfix|41|3|77,76",
	[83] = "Joseph Moor|45|2|71,59",
	[84] = "Jubie Federdings|4|3|45,91",
	[85] = "Jun'ha|2|2|73,36",
	[86] = "Jutak|35|3|27,77",
	[87] = "Kaita Tiefenschmied|34|1|56,17",
	[88] = "Kalldan Teufelsmond|46|3|",
	[89] = "Kania|31|5|52,40",
	[90] = "Keena|2|2|74,33",
	[91] = "Kelsey Yance|35|3|28,74",
	[92] = "Kendor Kabonka|34|1|75,37",
	[93] = "Khara Tiefenwasser|24|1|40,39",
	[94] = "Khole Klingeltaschen|34|1|56,60|Seasonal",
	[95] = "Kiknikle|39|3|42,38",
	[96] = "Killian Sanatha|32|2|33,18",
	[97] = "Kilxx|39|3|63,38",
	[98] = "Kireena|11|2|51,54",
	[99] = "Kithas|28|2|53,37",
	[100] = "Knaz Dusselflamm|35|3|51,35",
	[101] = "Kor'geld|28|2|56,34",
	[102] = "Kriggon Talsone|48|1|37,89",
	[103] = "Krinkle Goldstahl|37|3|52,29",
	[104] = "Kulwia|33|2|46,60",
	[105] = "Kzixx|15|3|81,21",
	[106] = "Laird|9|1|37,44",
	[107] = "Lardan|3|1|34,49",
	[108] = "Leo Sarn|32|2|54,82",
	[109] = "Leonard Porter|47|1|43,84",
	[110] = "Generalleutnant Andorov|30|5|",
	[111] = "Lilly|32|2|43,50",
	[112] = "Lindea Rabonne|22|1|51,61",
	[113] = "Lizbeth Kromwell|45|2|81,31",
	[114] = "Logannas|20|1|33,44",
	[115] = "Lokhtos D\195\188sterfeilsch|6|6|",
	[116] = "Lorelae Winterklang|25|3|48,40",
	[117] = "Magnus Frostrufer|47|3|68,77|Quest",
	[118] = "Mahul|42|2|44,45",
	[119] = "Mallen Knab|22|2|62,21",
	[120] = "Malygen|19|1|62,26",
	[121] = "Maria Lumere|34|1|46,78",
	[122] = "Martine Tramblei|43|2|66,59",
	[123] = "Masat T'andr|36|3|25,31",
	[124] = "Meisterhandwerker Omarion|27|3|",
	[125] = "Mavralyn|9|1|37,41",
	[126] = "Mazk Zielschuss|35|3|28,75",
	[127] = "Meilosh|19|7|66,3",
	[128] = "Micha Yance|22|1|49,55",
	[129] = "Millie Gregorian|45|2|71,30",
	[130] = "Mishta|31|5|50,36",
	[131] = "Montarr|41|2|45,50",
	[132] = "Muuran|11|2|56,56",
	[133] = "Mythrin'dir|10|1|61,18",
	[134] = "Naal Nebell\195\164ufer|42|2|52,52",
	[135] = "Namdo Blitzzischel|21|1|",
	[136] = "Nandar Branson|22|1|50,57",
	[137] = "Nardstrum Kupferzwick|45|2|69,40|Seasonal",
	[138] = "Narj Schnitzelschnitt|2|1|46,48",
	[139] = "Narkk|35|3|28,74",
	[140] = "Nata Morgenwandler|42|2|45,40",
	[141] = "Nergal|44|3|43,8",
	[142] = "Nerrist|35|2|32,29",
	[143] = "Nessa Schattensang|38|1|56,92",
	[144] = "Nina Brauleicht|7|1|67,18",
	[145] = "Nioma|40|1|13,43",
	[146] = "Nyoma|38|1|57,60",
	[147] = "Ogg'marr|16|2|36,31",
	[148] = "Der alte Mann Heming|35|3|27,77",
	[149] = "Otho Moji'ko|40|2|80,80",
	[150] = "Ausstatter Eric|23|1|43,29",
	[151] = "Penney Kupferzwick|28|2|53,67|Seasonal",
	[152] = "St\195\182psel Zapfring|6|3|",
	[153] = "Pratt McGrubben|20|1|30,42",
	[154] = "Qiaga die Bewahrerin|50|3|61,37",
	[155] = "R\195\188stmeisterin Miranda Knackschloss|17|4|82,60",
	[156] = "Ranik|39|3|62,39",
	[157] = "Rann Flammenweber|24|1|36,46",
	[158] = "Rartar|36|2|45,57",
	[159] = "Rikqiz|35|3|28,76",
	[160] = "Rin'wosho der H\195\164ndler|35|8|15,16",
	[161] = "Rizz Wackelbolz|1|3|47,35",
	[162] = "Ronald Burch|45|2|63,44",
	[163] = "Ruppo Rei\195\159spule|40|3|34,38",
	[164] = "Saenorion|10|1|63,22",
	[165] = "Seersa Kupferzwick|42|2|44,59|Seasonal",
	[166] = "Sewa Nebell\195\164ufer|42|2|56,48",
	[167] = "Shandrina|3|1|50,67",
	[168] = "Shankys|28|2|69,30",
	[169] = "Sheendra Hochschilf|20|2|74,43",
	[170] = "Versorger der Shen'dralar|12|3|",
	[171] = "Sheri Stichelnaht|15|1|76,46",
	[172] = "Smudge Donnerholz|22|3|84,19",
	[173] = "Soolie Brausefitz|23|1|67,55",
	[174] = "Sovik|28|2|75,25",
	[175] = "Stuart Fleming|49|1|8,58",
	[176] = "Sumi|28|2|82,23",
	[177] = "Superverkaufomat 680|11|3|41,79|Intermittent",
	[178] = "Tamar|28|2|63,44",
	[179] = "Tansy Pf\195\188tzplatsch|23|1|48,6",
	[180] = "Tarban Kornb\195\164cker|39|2|56,32",
	[181] = "Tari'qa|39|2|52,31",
	[182] = "Thaddeus Webner|45|2|62,61",
	[183] = "Tharynn Bouden|18|1|42,67",
	[184] = "Tilli Distelflaum|23|1|61,44",
	[185] = "Truk Wildbart|40|1|14,42",
	[186] = "Tunkk|2|2|74,35",
	[187] = "Ulthaan|3|1|50,67",
	[188] = "Ulthir|10|1|56,24",
	[189] = "Uthok|35|2|31,28",
	[190] = "Vaean|10|1|58,15",
	[191] = "Valdaron|9|1|38,41",
	[192] = "Vargus|31|5|51,39",
	[193] = "Veenix|33|3|58,52",
	[194] = "Kaufotron 1000|11|3|61,38|Intermittent",
	[195] = "Vharr|35|2|32,29",
	[196] = "Vivianna|20|1|31,43",
	[197] = "Vizzklick|37|3|51,27",
	[198] = "Wenna Seidenbart|49|1|26,26",
	[199] = "Werg Breitklinge|43|2|83,70",
	[200] = "Wik'Tar|3|2|12,34",
	[201] = "Worb Starkahle|20|2|74,43",
	[202] = "Wrahk|39|2|53,31",
	[203] = "Wulan|11|2|27,70",
	[204] = "Wulmort Klingeltaschen|23|1|33,67|Seasonal",
	[205] = "Wunna Dunkelm\195\164hne|26|2|46,58",
	[206] = "Xandar Gutbart|24|1|83,63",
	[207] = "Xen'to|28|2|57,53",
	[208] = "Xizk Gutstich|35|3|28,76",
	[209] = "Xizzer Zischbolz|50|3|61,39",
	[210] = "Yonada|39|2|45,60",
	[211] = "Yuka Schraubstutz|8|3|66,23",
	[212] = "Zan Messerritzel|22|3|84,18",
	[213] = "Zannok Ledernaht|31|3|82,18",
	[214] = "Zansoa|14|2|57,73",
	[215] = "Zarena Stahlwind|35|3|28,75",
	[216] = "Zargh|39|2|53,30",
	[217] = "Zixil|22|3|61,21|Roving",
	[218] = "Zorbin von Schiller|20|3|45,43|Quest",
	[219] = "Purpurroter Kampfmagier|51|3",
	[220] = "Spektraler Forscher|52|3",
	[221] = "Dunkler Beschw\195\182rer aus Scholomance|52|3",
	[222] = "Kampfmeister des Schwarzfels|8|3",
	[223] = "Tobs\195\188chtiger Ghul|51|3",
-- Burning Crusade
	[224] = "Deynna|55|2|56,50",
	[225] = "Eiin|60|3|66,68",
	[226] = "Neii|58|1|64,68",
	[227] = "Borto|69|1|53,72",
	[228] = "Mathar G'ochar|69|2|55,37",
	[229] = "Andrion Dunkelweber|60|3|66,68",
	[230] = "Arrond|65|2|56,58",
	[231] = "Nasmara Mondweise|60|3|66,69",
	[232] = "Gidge Spruchwirker|60|3|66,69",
	[233] = "Karaaz|61|18|44,34",
	[234] = "Nakodu|60|22|62,69",
	[235] = "R\195\188stmeister Endarin|60|20|48,26",
	[236] = "R\195\188stmeister Enuril|60|19|61,64",
	[237] = "Fedryen Flinkspeer|67|12|79,64",
	[238] = "Muheru der Weber|67|1|41,28",
	[239] = "Zurai|67|2|85,55",
	[240] = "Koren|56|11|",
	[241] = "Krek Schmetterfels|65|2|29,31",
	[242] = "Loolruna|67|1|69,50",
	[243] = "Aaron Hollmann|60|3|64,71",
	[244] = "Arras|58|1|61,90",
	[245] = "Eriden|55|2|80,36",
	[246] = "Mari Steinhand|65|1|37,55",
	[247] = "Rohok|53|2|53,38",
	[248] = "R\195\188stmeister Urgronn|53|14|55,38",
	[249] = "Nachschuboffizier Ulrike|53|15|57,63",
	[250] = "Halruun|67|1|68,48",
	[251] = "Haalrun|67|1|68,48",
	[252] = "Seherin Janidi|67|2|32,52",
	[253] = "Daga Ramba|59|2|51,58",
	[254] = "Alurmi|37|9|64,58",
	[255] = "Almaador|60|21|50,42",
	[256] = "Mycah|67|3|18,51",
	[257] = "H\195\164ndler Narasu|69|17|55,75",
	[258] = "Altaa|58|1|28,63",
	[259] = "Melaris|55|2|67,20",
	[260] = "Skreah|60|3|46,20",
	[261] = "Alchimist Grabbel|53|1|54,66",
	[262] = "Apotheker Antonivich|53|2|52,37",
	[263] = "Leeli Langfeilsch|66|1|58,53",
	[264] = "Burko|53|1|22,39",
	[265] = "Aresella|53|2|26,62",
	[266] = "Baxter|53|2|56,41|Mobile",
	[267] = "Gaston|53|1|54,64",
	[268] = "Naka|67|3|79,63",
	[269] = "Landraelanis|54|2|49,47",
	[270] = "Meisterkoch Mouldier|62|2|48,31",
	[271] = "Gastwirtin Grilka|66|2|49,45",
	[272] = "Versorgungsoffizier M\195\188hlens|66|1|56,53",
	[273] = "Doba|67|1|42,28",
	[274] = "Gambarinka|67|2|32,49",
	[275] = "Fazu|64|1|54,56",
	[276] = "Gastwirtin Biribi|66|1|57,53",
	[277] = "Rungor|66|2|49,46",
	[278] = "Nula die Metzgerin|69|2|58,36",
	[279] = "Uriku|69|1|56,73",
	[280] = "Kr\195\164cka Einauge|53|2|55,41",
	[281] = "Sid Limbardi|53|1|54,64",
	[282] = "Arred|58|1|45,26",
	[283] = "Gelanthis|55|2|91,74",
	[284] = "Neal Allen|49|1|11,57",
	[285] = "Felika|28|2|51,36|Roving",
	[286] = "Edna Mullby|34|1|58,61",
	[287] = "Burbik Ritzelspann|23|1|47,27",
	[288] = "Felicia Doan|45|2|64,50",
	[289] = "Shadi Nebell\195\164ufer|42|2|40,64",
	[290] = "Lehrling Darius|68|11|47,75",
	[291] = "Kalaen|53|2|57,38",
	[292] = "Tatiana|53|1|55,64",
	[293] = "Feera|58|1|54,91",
	[294] = "Viggz Funkenschimmer|60|3|65,69",
	[295] = "Yatheon|55|2|76,40",
	[296] = "Daggle Eisenformer|65|1|37,54",
	[297] = "Mixie Weitschuss|53|2|61,82",
	[298] = "Windh\195\164ndler Lathrai|60|3|72,30",
	[299] = "Lebowski|53|1|56,66",
	[300] = "Gefangener Gnom|67|2|33,48",
	[301] = "Versorgerin Nasela|69|16|54,37",
	[302] = "Haferet|58|1|66,75",
	[303] = "Zaralda|55|2|84,79",
	[304] = "Cro Starkfaden|60|3|67,67",
	[305] = "Thomas Yance|63|3|",
	[306] = "Juno Dufrain|67|3|78,66",
	[307] = "Vodesiin|53|1|24,38",
	[308] = "Andormu|37|10|58,59",
	[309] = "Gealterter Hexer von Dalaran|63|3|",
	[310] = "Madame Rubin|60|3|63,70",
	[311] = "Egomis|58|1|39,40",
	[312] = "Lyna|55|2|69,24",
         [313] = "Okuno|70|23",
         [314] = "Indormi|71|10",
         [315] = "Eldara D\195\164mmerflucht|72|24",
         [316] = "Shaani|72|24",

}



TradeskillInfo_Translations = nil