
--[[

  TradesBar for WoW (World of Warcraft)
    Desc:  A row of buttons for your Trades Skills

  LIST OF AUTHORS and FIXERS
  Author 1:  Ian 'CRiSPy' Floyd  "Iling on Skywall(Nightelf)"
  Author 2:  David Carr          "Groz on Shattered Hand(Orc)"
  Author 3:  Eric Gingell        "Treader (plus many others) on Cenarion Circle (Night Elf)"
  German Tanslator1: Farook of wowinterface.com forum
  French Tanslator2: Trucifix of ui.worldofwar.net
  Chinese Translator: norova of wowinterface.com

--]]

local ver,updated = "2.11.8",'Oct 29, 2007';

--[[
 English Tranlation
 Author1: Ian "CRiSPyToWN" Floyd  "Iling on Skywall(Nightelf)"
--]]
--START  
  --trades/skills/professions
  --TradesBarData = { };
    TRADES_ALCHEMY = "Alchemy";
    TRADES_BLACKSMITHING = "Blacksmithing";
    TRADES_COOKING = "Cooking";
    TRADES_BASIC_CAMPFIRE = "Basic Campfire";
    TRADES_ENCHANTING = "Enchanting";
    TRADES_DISENCHANT = "Disenchant";
    TRADES_ENGINEERING = "Engineering";
    TRADES_GNOME_ENGINEERING = "Gnome Engineering";
    TRADES_GOBLIN_ENGINEERING = "Goblin Engineering";
    TRADES_FIRST_AID = "First Aid";
    TRADES_FISHING = "Fishing";
    TRADES_HERBALISM = "Herbalism";
    TRADES_FIND_HERBS = "Find Herbs";
    TRADES_FIND_TREASURE = "Find Treasure";
    TRADES_LEATHERWORKING = "Leatherworking";
    TRADES_DRAGONSCALE_LEATHERWORKING = "Dragonscale Leatherworking";
    TRADES_ELEMENTAL_LEATHERWORKING = "Elemental Leatherworking";
    TRADES_TRIBAL_LEATHERWORKING = "Tribal Leatherworking"; 
    TRADES_PICK_LOCK = "Pick Lock"; 
    TRADES_PICK_POCKET = "Pick Pocket";
    TRADES_FIND_MINERALS = "Find Minerals";
    TRADES_SMELTING = "Smelting";
    TRADES_SKINNING = "Skinning";
    TRADES_TAILORING = "Tailoring";
    TRADES_SHADOWEAVE_TAILORING = "Shadoweave Tailoring";
    TRADES_POISONS = "Poisons";
    TRADES_JEWELCRAFTING = "Jewelcrafting";
    TRADES_BT = "Beast Training";
    TRADES_MINING = "Mining";
    TRADES_PROSPECTING = "Prospecting";
    TRADES_DISARM = "Disarm Trap";

	TRADES_TEXT_RELOAD_NOW = "Reload Now";
	TRADES_TEXT_RELOAD_LATER = "Reload Later";
	TRADES_TEXT_ADD_SPELL = "Add a spell or ability.";
	TRADES_TEXT_SPELL_ADDED = "%s has been added, you must reload the interface for it to show up on the TradesBar";
	TRADES_TEXT_ADD_SPELL_TOOLTIP = 'Add a Spell to the TradesBar';
	TRADES_TEXT_TOGGLE = 'Toggle ';
	HELP_MESSAGE1 = "To move the bar: Hold down the control key and right click the TradesBar";
	HELP_MESSAGE2 = "To open the admin frame: Hold down the shift key and right click the TradesBar or type '/tradesbar admin'";
	HELP_MESSAGE3 = "To hide/show the bar: type '/tradesbar toggle'";
--END

--[[
 Traditional Chinese Tranlation
 Tanslator: 竹笙姬@暴風祭壇 (舒嵐 [norova@pchome.com.tw])
]]--
if (GetLocale() == "zhTW") then
--START
  --trades/skills/professions
  --TradesBarData = { };
    TRADES_ALCHEMY = "煉金術";
    TRADES_BLACKSMITHING = "鍛造";
    TRADES_COOKING = "烹飪";
    TRADES_BASIC_CAMPFIRE = "基礎營火";
    TRADES_ENCHANTING = "附魔";
    TRADES_DISENCHANT = "分解";
    TRADES_ENGINEERING = "工程學";
    TRADES_GNOME_ENGINEERING = "地精工程學";
    TRADES_GOBLIN_ENGINEERING = "哥布林工程學";
    TRADES_FIRST_AID = "急救";
    TRADES_FISHING = "釣魚";
    TRADES_HERBALISM = "草藥學";
    TRADES_FIND_HERBS = "尋找草藥";
    TRADES_FIND_TREASURE = "尋找財寶";
    TRADES_LEATHERWORKING = "製皮";
    TRADES_DRAGONSCALE_LEATHERWORKING = "龍鱗製皮";
    TRADES_ELEMENTAL_LEATHERWORKING = "元素製皮";
    TRADES_TRIBAL_LEATHERWORKING = "部族製皮"; 
    TRADES_PICK_LOCK = "開鎖"; 
    TRADES_PICK_POCKET = "偷竊";
    TRADES_FIND_MINERALS = "尋找礦物";
    TRADES_SMELTING = "熔煉";
    TRADES_SKINNING = "剝皮";
    TRADES_TAILORING = "裁縫";
    TRADES_SHADOWEAVE_TAILORING = "闇系裁縫";
    TRADES_POISONS = "毒藥";
    TRADES_JEWELCRAFTING = "珠寶設計";
    TRADES_BT = "訓練野獸";
    TRADES_MINING = "採礦";
    TRADES_PROSPECTING = "勘探";
    TRADES_DISARM = "解除陷阱";

	TRADES_TEXT_RELOAD_NOW = "現在重新載入";
	TRADES_TEXT_RELOAD_LATER = "稍候重新載入";
	TRADES_TEXT_ADD_SPELL = "增加法術或技能至TradesBar (**請正確輸入完整的法術或技能的名稱**)";
	TRADES_TEXT_SPELL_ADDED = "%s 已被加入至TradesBar, 需重新載入插件後才可以開始使用新增的法術/技能按鈕";
	TRADES_TEXT_ADD_SPELL_TOOLTIP = '增加法術或技能至TradesBar';
	TRADES_TEXT_TOGGLE = '切換 ';
	HELP_MESSAGE1 = "移動TradesBar: 按住Ctrl鍵不放並使用滑鼠右鍵拖曳";
	HELP_MESSAGE2 = "開啟設定視窗: 按住Shift鍵不放並在Bar上按下滑鼠右鍵, 或輸入快速指令'/tradesbar admin'";
	HELP_MESSAGE3 = "隱藏/顯示TradesBar: 輸入快速指令'/tradesbar toggle'";
--END
end

--[[
 German Tranlation
 Tanslator1: Farook of wowinterface.com forum
]]--
if (GetLocale() == "deDE") then
--START
  --trades/skills/professions
  --TradesBarData = { };
    TRADES_ALCHEMY = "Alchimie";
    TRADES_BLACKSMITHING = "Schmiedekunst";
    TRADES_COOKING = "Kochkunst";
    TRADES_BASIC_CAMPFIRE = "Einfaches Lagerfeuer";
    TRADES_ENCHANTING = "Verzauberkunst";
    TRADES_DISENCHANT = "Entzaubern";
    TRADES_ENGINEERING = "Ingenieurskunst";
    TRADES_GNOME_ENGINEERING = "Gnomen-Ingenieurskunst";
    TRADES_GOBLIN_ENGINEERING = "Goblin-Ingenieurskunst";
    TRADES_FIRST_AID = "Erste Hilfe";
    TRADES_FISHING = "Angeln";
    TRADES_HERBALISM = "Kr\195\164uterkunde";
    TRADES_FIND_HERBS = "Kr\195\164utersuche";
    TRADES_FIND_TREASURE = "Schatzsucher";
    TRADES_LEATHERWORKING = "Lederverarbeitung";
    TRADES_DRAGONSCALE_LEATHERWORKING = "Drachenschuppen-Lederverarbeitung";
    TRADES_ELEMENTAL_LEATHERWORKING = "Elementargeist-Lederverarbeitung";
    TRADES_TRIBAL_LEATHERWORKING = "Stammes-Lederverarbeitung";
    TRADES_PICK_LOCK = "Schloss knacken";
    TRADES_PICK_POCKET = "Taschendiebstahl";
    TRADES_FIND_MINERALS = "Mineraliensuche";
    TRADES_SMELTING = "Verh\195\188ttung";
    TRADES_SKINNING = "K\195\188rschnerei";
    TRADES_TAILORING = "Schneiderei";
    TRADES_SHADOWEAVE_TAILORING = "Schattenweberei";
    TRADES_POISONS = "Gifte";
    TRADES_JEWELCRAFTING = "Jewelcrafting";
    TRADES_BT = "Beast Training";
    TRADES_MINING = "Mining";
    TRADES_PROSPECTING = "Prospecting";
    TRADES_DISARM = "Disarm Trap";

--END
end

--[[
 French Tranlation
 Tanslator2: Trucifix of ui.worldofwar.net
]]--
if (GetLocale() == "frFR") then
--START
  --trades/skills/professions
  --TradesBarData = { };
    TRADES_ALCHEMY = "Alchimie";
    TRADES_BLACKSMITHING = "Forge";
    TRADES_COOKING = "Cuisine";
    TRADES_BASIC_CAMPFIRE = "Feu de camp basique";
    TRADES_ENCHANTING = "Enchantement";
    TRADES_DISENCHANT = "D\195\169senchanter";
    TRADES_ENGINEERING = "Ing\195\169nieur";
    TRADES_GNOME_ENGINEERING = "Ing\195\169nieur gnome";
    TRADES_GOBLIN_ENGINEERING = "Ing\195\169nieur gobelin";
    TRADES_FIRST_AID = "Premiers soins";
    TRADES_FISHING = "P\195\170che";
    TRADES_HERBALISM = "Herboriste";
    TRADES_FIND_HERBS = "D\195\169couverte d'herbes";
    TRADES_FIND_TREASURE = "D\195\169couverte de tr\195\169sors";
    TRADES_LEATHERWORKING = "Travail du cuir";
    TRADES_DRAGONSCALE_LEATHERWORKING = "Travail du cuir de dragon";
    TRADES_ELEMENTAL_LEATHERWORKING = "Travail du cuir \195\169l\195\169mentaire";
    TRADES_TRIBAL_LEATHERWORKING = "Travail du cuir tribal";
    TRADES_PICK_LOCK = "Crochetage";
    TRADES_PICK_POCKET = "Vol \195\160 la Tire";
    TRADES_FIND_MINERALS = "D\195\169couverte de gisements";
    TRADES_SMELTING = "Fondre";
    TRADES_SKINNING = "D\195\169peçage";
    TRADES_TAILORING = "Couture";
    TRADES_SHADOWEAVE_TAILORING = "Tailleur tissu-t\195\169n\195\168bres";
    TRADES_POISONS = "Poisons";
    TRADES_JEWELCRAFTING = "Jewelcrafting";
    TRADES_BT = "Beast Training";
    TRADES_MINING = "Mining";
    TRADES_PROSPECTING = "Prospecting";
    TRADES_DISARM = "Disarm Trap";

--END  
end

--[[
Spanish Tranlation
Tanslator1: Ferroginus of Zul'Jin
]]--
if (GetLocale() == "esES") then
--START
--trades/skills/professions
  --TradesBarData = { };
    TRADES_ALCHEMY = "Alquimia";
    TRADES_BLACKSMITHING = "Herrería";
    TRADES_COOKING = "Cocina";
    TRADES_BASIC_CAMPFIRE = "Hoguera básica";
    TRADES_ENCHANTING = "Encantamiento";
    TRADES_DISENCHANT = "Desencantar";
    TRADES_ENGINEERING = "Ingeniería";
    TRADES_GNOME_ENGINEERING = "Ingeniero gnomo";
    TRADES_GOBLIN_ENGINEERING = "Ingeniero goblin";
    TRADES_FIRST_AID = "Primeros auxilios";
    TRADES_FISHING = "Pesca";
    TRADES_HERBALISM = "Herboristería";
    TRADES_FIND_HERBS = "Buscar hierbas";
    TRADES_FIND_TREASURE = "Buscar tesoro";
    TRADES_LEATHERWORKING = "Peletería";
    TRADES_DRAGONSCALE_LEATHERWORKING = "Peletería dragontina";
    TRADES_ELEMENTAL_LEATHERWORKING = "Peletería elemental";
    TRADES_TRIBAL_LEATHERWORKING = "Peletería tribal";
    TRADES_PICK_LOCK = "Ganzúa";
    TRADES_PICK_POCKET = "Robar";
    TRADES_FIND_MINERALS = "Buscar minerales";
    TRADES_SMELTING = "Fundiendo";
    TRADES_SKINNING = "Desuello";
    TRADES_TAILORING = "Sastrería";
    TRADES_SHADOWEAVE_TAILORING = "Tejido de sombra";
    TRADES_POISONS = "Venenos";
    TRADES_JEWELCRAFTING = "Jewelcrafting";
    TRADES_BT = "Beast Training";
    TRADES_MINING = "Mining";
    TRADES_PROSPECTING = "Prospecting";
    TRADES_DISARM = "Disarm Trap";

--END
end

--[[
local Trades = {
	{
		name = (.*),		-- The name of the skill or item (experimental)
		panel = [45]{1},	-- The panel the admin checkbox will be attached to on the admin frame
		[type = (.*),]		-- The type of button this will be (item, spell, or action). Default: "spell"
	},
};
--]]
TradesBarData = { };
local Trades = {
	{
		name = TRADES_ALCHEMY,
		panel = 4,
	},
	{
		name = TRADES_BLACKSMITHING,
		panel = 4,
	},
	{
		name = TRADES_COOKING,
		panel = 4,
	},
	{
		name = TRADES_ENCHANTING,
		panel = 4,
	},
	{
		name = TRADES_BASIC_CAMPFIRE,
		panel = 5,
	},
	{
		name = TRADES_DISENCHANT,
		panel = 5,
	},
	{
		name = TRADES_ENGINEERING,
		panel = 4,
	},
--	{
--		name = TRADES_GNOME_ENGINEERING;
--	},
--	{
--		name = TRADES_GOBLIN_ENGINEERING;
--	},
	{
		name = TRADES_FIRST_AID,
		panel = 4,
	},
	{
		name = TRADES_FISHING,
		panel = 4,
	},
	{
		name = TRADES_HERBALISM,
		panel = 4,
	},
	{
		name = TRADES_FIND_HERBS,
		panel = 5
	},
	{
		name = TRADES_FIND_TREASURE,
		panel = 5,
	},
	{
		name = TRADES_LEATHERWORKING,
		panel = 4,
	},
--	{
--		name = TRADES_DRAGONSCALE_LEATHERWORKING;
--	},
--	{
--		name = TRADES_ELEMENTAL_LEATHERWORKING;
--	},
--	{
--		name = TRADES_TRIBAL_LEATHERWORKING;
--	},
	{
		name = TRADES_PICK_POCKET,
		panel = 5,
	},
	{
		name = TRADES_PICK_LOCK,
		panel = 5,
	},
	{
		name = TRADES_FIND_MINERALS,
		panel = 5,
	},
	{
		name = TRADES_SMELTING,
		panel = 4,
	},
	{
		name = TRADES_SKINNING,
		panel = 4,
	},
	{
		name = TRADES_TAILORING,
		panel = 4,
	},
--	{
--		name = TRADES_SHADOWEAVE_TAILORING;
--	},
	{
		name = TRADES_POISONS,
		panel = 4,
	},
	{
		name = TRADES_JEWELCRAFTING,
		panel = 4,
	},
    {
		name = TRADES_BT,
		panel = 5,
	},
    {
		name = TRADES_MINING,
		panel = 4,
	},
    {
		name = TRADES_PROSPECTING,
		panel = 5,
	},
    {
		name = TRADES_DISARM,
		panel = 5,
	},
    {
		name = 'Hearthstone',
		panel = 5,
		type = 'item',
	},
};

local TradesBar_Buttons = {};
local AdminPanels = {};

local bindings = {
  	"Bind Alchemy",
  	"Bind Blacksmithing",
  	"Bind Cooking",
  	"Bind Build Basic Campfire",
  	"Bind Enchanting",
  	"Bind Disenchant",
  	"Bind Engineering",
  	"Bind First Aid",
  	"Bind Fishing",
  	"Bind Herbalism",
  	"Bind Leatherworking",
	"Bind Pick Lock",
  	"Bind Pick Pocket",
  	"Bind Smelting",
  	"Bind Skinning",
  	"Bind Tailoring",
  	"Bind Poisons",
  	"Bind Jewelcrafting",
  	"Bind Beast Training",
}
local BoundButtons = {}
local original_heights = {}

TRADESBAR_ENABLED = true;
TradesBar_UpdateInterval = 1.0;
TradesBar_TooltipRanksText = {}

local color = {
	RED       = "ff0000"; -- current rank <= 25% of max
	ORANGE    = "ff7f00"; -- current rank <= 50% and > 25% of max
	YELLOW    = "ffff00"; -- current rank <= 75% and > 50% of max
	GREEN     = "00ff00"; -- current rank <= 100% and > 75% of max
}

local TradesBar_is_fishingbuddy = false;
local inCombat, playerName, vMounted, button;

function TradesBar_AddSpell(spell)
	--local debug = true
	local i = 1;
	while true do
		local spellName = GetSpellName(i, BOOKTYPE_SPELL);
		if (not spellName) then
			break;
		end
		if strfind(strlower(spellName), strlower(spell)) then
			if (debug) then
				DEFAULT_CHAT_FRAME:AddMessage("Found |cffffffff'"..spellName.."'|r at slot |cffffffff'"..i.."'", 0.1, 1.0, 0.0);
			end
			table.insert(TradesBarCustomSpells,
				{
					name = spellName,
					panel = 5,
				}
			);
		end
		i = i + 1;
		if (i > 250) then
			break;
		end
	end
end

TradesBarCustomSpells = {};
StaticPopupDialogs["TradesBar_AddSpell"] = {
	text = TEXT(TRADES_TEXT_ADD_SPELL),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	hasEditBox = 1,
	maxLetters = 50,
	OnAccept = function()
		local editBox = getglobal(this:GetParent():GetName().."EditBox");
		TradesBar_AddSpell(editBox:GetText());
		local dialog = StaticPopup_Show('TradesBar_ReloadNotice', editBox:GetText());
		if dialog then
			dialog.data = editBox:GetText();
		end
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	EditBoxOnEnterPressed = function()
		local editBox = getglobal(this:GetParent():GetName().."EditBox");
		TradesBar_AddSpell(editBox:GetText());
		local dialog = StaticPopup_Show('TradesBar_ReloadNotice', editBox:GetText());
		if dialog then
			dialog.data = editBox:GetText();
		end
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1
};

StaticPopupDialogs["TradesBar_ReloadNotice"] = {
	text = TEXT(TRADES_TEXT_SPELL_ADDED),
	button1 = TEXT(TRADES_TEXT_RELOAD_NOW),
	button2 = TEXT(TRADES_TEXT_RELOAD_LATER),
	OnAccept = function()
		ReloadUI();
		--TradesBar_OnEvent('VARIABLES_LOADED');
	end,
	OnCancel = function()
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1
};

TradesBar_ATSW_IsEnabled_Hook = nil;

function TradesBar_DisableATSW()
	DEFAULT_CHAT_FRAME:AddMessage('TradesBar is attempting to disable ATSW for Beast Training', 1, 1, 1, 1);
	-- Try disabling Beast Training in the OnEvent function and hook ATSW's IsEnabled function (works so far).
	if not atsw_disabled[UnitName("player")] then
		atsw_disabled[UnitName("player")] = {}
	end
	atsw_disabled[UnitName("player")]['Beast Training'] = 1;
	TradesBar_ATSW_IsEnabled_Hook = ATSW_IsEnabled;
	ATSW_IsEnabled = function()
		if atsw_selectedskill == 'Beast Training' then
			return false;
		else
			return TradesBar_ATSW_IsEnabled_Hook();
		end
	end
end

-- If the following addons loaded before this one, set the variables here.
if (IsAddOnLoaded('AdvancedTradeSkillWindow')) then
	-- Try disabling Beast Training in the OnEvent function and hook ATSW's IsEnabled function (works so far).
	TradesBar_DisableATSW();
end
if (IsAddOnLoaded('FishingBuddy')) then
	TradesBar_is_fishingbuddy = true;
end

function TradesBar_OnLoad()
	-- Hooked for debugging
	--hooksecurefunc('SecureActionButton_OnClick', function (self, button)
		--local spell = SecureButton_GetModifiedAttribute(self, "spell", button);
		--DEFAULT_CHAT_FRAME:AddMessage('Click accepted for button '..spell..'('..button..')');
	--end);
	TradesBar_TimeSinceLastUpdate = 0;
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	this:RegisterEvent('ADDON_LOADED');

	SLASH_TRADESBAR1 = "/tradesbar";
	SLASH_TRADESBAR2 = "/tbar";
	SLASH_TRADESBAR3 = "/tb";
	SlashCmdList["TRADESBAR"] = function(msg)
		TradesBar_SlashHandler(string.lower(msg));
	end
	
	-- Bindings --
	for _,command in pairs(bindings) do
		local key1, key2 = GetBindingKey(command);
		if key1 then
			SetBindingClick(key1, BoundButtons[command]);
		end
		if key2 then
			SetBindingClick(key2, BoundButtons[command]);
		end
	end
end

function TradesBar_HelpMsg()
	DEFAULT_CHAT_FRAME:AddMessage(HELP_MESSAGE1);
	DEFAULT_CHAT_FRAME:AddMessage(HELP_MESSAGE2);
	DEFAULT_CHAT_FRAME:AddMessage(HELP_MESSAGE3);
end

function TradesBar_SlashHandler(msg)
	if (string.find(msg, "help")) then
		TradesBar_HelpMsg();
	elseif (string.find(msg, "toggle")) then
		TradesBar_Hide();
	elseif (string.find(msg, "admin") or string.find(msg, "config")) then
	    if(  TradesBarConfig:IsVisible() ) then
	    	TradesBarConfig:Hide();
	    else
	    	TradesBarConfig:Show();
	    end
	else
		TradesBar_HelpMsg();
	end
	--tinsert(UISpecialFrames,"TradesBarConfig"); 
end

function StartTradesBar()
	if (not TradesBarData or not TradesBarData[playerName]) then
		TradesBarData[playerName] = {};
		TradesBarData[playerName] = {
			["hidebar"] = "false",
			["horizontal"] = "true",
			["order"] = "az",
			["scale"] = 1,
		}
	end
	for i in pairs(Trades) do
		if (not TradesBarData[playerName][Trades[i].name]) then
			TradesBarData[playerName][Trades[i].name] = "true";
		end
	end
	if (TradesBarData[playerName]["version"] ~= ver) then
		TradesBarData[playerName]["version"] = ver;
	end
	if (TradesBarData[playerName]["updated"] ~= updated) then
		TradesBarData[playerName]["updated"] = updated;
	end
	TradesBar_Update();
	TradesBar_Scale();
end

function FindPattern(text, pattern)
	return string.sub(text, string.find(text, pattern))
end

function TradesBar_InTable(haystack, needle)
	for i in ipairs(haystack) do
		if haystack[i].name == needle then
			return true;
		end
	end
	return false;
end

function TradesBar_OnEvent()
	if (event == "PLAYER_ENTERING_WORLD") then
		if (UnitName("player") ~= UNKNOWNBEING and UnitName("player") ~= UNKNOWNOBJECT and UnitName("player") and not playerName) then
			playerName = UnitName("player").." of "..GetCVar("realmName");
		end
		StartTradesBar();
	elseif (event == "SPELLS_CHANGED" or event == "PLAYER_AURAS_CHANGED") then
		TradesBar_Update();
	elseif (event == "SPELL_UPDATE_COOLDOWN") then
		TradesBar_UpdateCooldowns();
	-- If the following addons load after this one, set the variables here.
	elseif (event == 'ADDON_LOADED') then
		if arg1 == 'AdvancedTradeSkillWindow' then
			-- if player is using ATSW, disable Beast Training
			TradesBar_DisableATSW();
		end
		if arg1 == 'FishingBuddy' then
			TradesBar_is_fishingbuddy = true;
		end
	elseif ( event == 'VARIABLES_LOADED') then
		-- Add the custom buttons
		for i in pairs(TradesBarCustomSpells) do
			local id = i + getn(Trades) + 1;
			if not TradesBar_InTable(Trades, TradesBarCustomSpells[i].name) then
				table.insert(Trades,
					{
						name = TradesBarCustomSpells[i].name,
						panel = TradesBarCustomSpells[i].panel,
					}
				);
			else
				TradesBarCustomSpells[i] = nil;
			end
		end
		-- Make the buttons
		for id = 1, table.getn(Trades) do
			TradesBar_Buttons[id] = CreateFrame('Button', 'TradesBarButton'..Trades[id].name, TradesBar, 'TradesBarButtonTemplate');
			TradesBar_Buttons[id]:RegisterForClicks("LeftButtonUp");
			--TradesBar_Buttons[id]:SetScript('OnClick', TradesBar_Buttons[id]:GetScript('OnClick'));
			-- If it has a panel, then we need to tell the script to add it and where to add it to the config frame.
--			if Trades[id].panel then
			if not AdminPanels[Trades[id].panel] then
				AdminPanels[Trades[id].panel] = {};
			end
			AdminPanels[Trades[id].panel][id] = {
				name = Trades[id].name;
				panel = Trades[id].panel;
				type = Trades[id].type;
			};
--			end
			-- Required for SecureActionButtonTemplate
			if not Trades[id].type then
				Trades[id].type = 'spell'
			end
			TradesBar_Buttons[id]:SetAttribute("type*", Trades[id].type);
			TradesBar_Buttons[id]:SetAttribute(Trades[id].type.."*", Trades[id].name);
			
			-- This doesn't work, yet.
			BoundButtons['Bind '..Trades[id].name] = 'TradesBarButton'..Trades[id].name
			
			local OpenBagItems = {
				[TRADES_DISENCHANT] = true;
				['Feed Pet'] = true;
				[TRADES_PICK_LOCK] = true;
				[TRADES_PROSPECTING] = true;
			}
			
			if OpenBagItems[Trades[id].name] == true then
				TradesBar_Buttons[id]:SetScript('OnMouseUp',
					function()
						if OneBagFrame and OneBagFrame:IsShown() then
							return
						end
						OpenAllBags(true);
					end
				)
			end
			
			TradesBar_Buttons[id]:SetID(0);
			local frame, x;
			if TradesBar_Buttons[id - 1] then
				-- previous button?
				frame = TradesBar_Buttons[id - 1]:GetName();
				x = 10;
			else
				-- Relative to parent?
				frame = 'TradesBar';
				x = 1;
			end
			TradesBar_Buttons[id]:ClearAllPoints();
			TradesBar_Buttons[id]:SetPoint('LEFT', frame, 'RIGHT', x, 0);
			--DEFAULT_CHAT_FRAME:AddMessage('Button'..TradesBar_Buttons[id]:GetName());
		end
	end
end

function TradesBar_Scale()
	for i in pairs(Trades) do
		local button = TradesBar_Buttons[i];
		button:SetScale(TradesBarData[playerName]["scale"]);
	end
end

-- Convienience function
function TradesBar_HasSkill(skill)
	return TradesBar_GetSpellID(skill);
end

function TradesBar_O()
	if (TradesBarData[playerName]) then
		-- Default to horizontal
		if (not TradesBarData[playerName]["horizontal"]) then
			TradesBarData[playerName]["horizontal"] = "true"
		end
		-- Default to ascending
		if (not TradesBarData[playerName]["order"]) then
			TradesBarData[playerName]["order"] = "az"			
		end
		local prev, button, x, y, point, relative;
		for i in ipairs(Trades) do
			TradesBar_Buttons[i]:ClearAllPoints();
			-- Default to visible
			if (not TradesBarData[playerName][Trades[i].name]) then
				TradesBarData[playerName][Trades[i].name] = "true"			
			end
			if ((Trades[i].type and Trades[i].type == 'item') or (TradesBar_HasSkill(Trades[i].name) and TradesBarData[playerName][Trades[i].name] == 'true')) then
				if (button) then
					prev = button:GetName();
				else
					prev = 'TradesBar';
				end
				button = TradesBar_Buttons[i];
--				DEFAULT_CHAT_FRAME:AddMessage('Button '..button:GetName());
--				DEFAULT_CHAT_FRAME:AddMessage('PrevButton '..prev);
				if (TradesBarData[playerName]["horizontal"] == "true" and TradesBarData[playerName]["order"] == "az") then
					point, x, y, relative = "LEFT", 1, 0, "RIGHT";
				elseif (TradesBarData[playerName]["horizontal"] == "true" and TradesBarData[playerName]["order"] == "za") then
					point, x, y, relative = "RIGHT", 1, 0, "LEFT";
				elseif (TradesBarData[playerName]["horizontal"] == "false" and TradesBarData[playerName]["order"] == "az") then
					point, x, y, relative = "TOP", 0, 1, "BOTTOM";
				elseif (TradesBarData[playerName]["horizontal"] == "false" and TradesBarData[playerName]["order"] == "za") then
					point, x, y, relative = "BOTTOM", 0, 1, "TOP";
				else
					point, x, y, relative = "LEFT", 1, 0, "RIGHT";
				end
				button:SetPoint(point, prev, relative, x, y);
			end
		end
	end
end

function TradesBar_Hide()
   local frame = getglobal("TradesBar");
   if (frame) then
     if( frame:IsVisible() ) then
       frame:Hide();
     else
       frame:Show();
     end
   end
end

function TradesBar_FishingBuddy_Over()
   local frame = getglobal("FishingBuddyFrame");
   if (frame) then
     if( frame:IsVisible() ) then
       frame:Hide();
     else
       frame:Show();
     end
   end
end

function TradesBar_visableCheck(value)
	local hide_button = "yes";
	-- Special conditions
	if (value == TRADES_GNOME_ENGINEERING or value == TRADES_GOBLIN_ENGINEERING) then
		value = TRADES_ENGINEERING;
	end
	if (value == TRADES_DRAGONSCALE_LEATHERWORKING or value == TRADES_ELEMENTAL_LEATHERWORKING or value == TRADES_TRIBAL_LEATHERWORKING) then
		value = TRADES_LEATHERWORKING;
	end
	if (value == TRADES_SHADOWEAVE_TAILORING) then
		value = TRADES_TAILORING;
	end
	if (TradesBarData[playerName][value] == "true") then
		local hide_button = "no";
        return hide_button;
	end

	return hide_button;
end

function TradesBar_SpecialCheck(value)
  local i_am_special = "no";
  if (value == TRADES_LEATHERWORKING) then
    local if_Dragonscale = TradesBar_GetSpellID(TRADES_DRAGONSCALE_LEATHERWORKING);
    local if_Elemental = TradesBar_GetSpellID(TRADES_ELEMENTAL_LEATHERWORKING);
    local if_Tribal = TradesBar_GetSpellID(TRADES_TRIBAL_LEATHERWORKING);
    if (if_Dragonscale or if_Elemental or if_Tribal) then
      local i_am_special = "yes";
      return i_am_special;
    end
    return i_am_special;
  elseif (value == TRADES_ENGINEERING) then
    local if_Gnome = TradesBar_GetSpellID(TRADES_GNOME_ENGINEERING);
    local if_Goblin = TradesBar_GetSpellID(TRADES_GOBLIN_ENGINEERING);
    if (if_Gnome or if_Goblin) then
      local i_am_special = "yes";
      return i_am_special;
    end
    return i_am_special;
  elseif (value == TRADES_TAILORING) then
    local if_Shadoweave = TradesBar_GetSpellID(TRADES_SHADOWEAVE_TAILORING);
    if (if_Shadoweave) then
      local i_am_special = "yes";
      return i_am_special;
    end
    return i_am_special;
  end
  return i_am_special;
end

function TradesBar_Update()
	if (TradesBarData[playerName]) then
    if (TradesBarData[playerName]["hidebar"] == "false") then
      if InCombatLockdown() then
        return;
      end
  		TradesBar_O();
  		i = 0;
  		for key in ipairs(Trades) do
  			TradesBar_Buttons[key]:Hide();
  		end
  		TradesBar:Show();
  		for key in pairs(Trades) do
  			local id = TradesBar_GetSpellID(Trades[key].name);
  			local i_am_special2 = TradesBar_SpecialCheck(Trades[key].name);
  			local i_am_hidden = TradesBar_visableCheck(Trades[key].name);
			if (i_am_special2 == "no" and i_am_hidden == "no") then
				if (id) then
			  		--ChatFrame1:AddMessage('Found '..Trades[key].name);
					i = i + 1;
					local button = TradesBar_Buttons[key];
					local texture = GetSpellTexture(id, BOOKTYPE_SPELL);
					getglobal(button:GetName().."Icon"):SetTexture(texture);
					button.id = id;
					button.texture = texture;
					button:Show();
				else
			  		--ChatFrame1:AddMessage('Found '..Trades[key].name);
					i = i + 1;
					local button = TradesBar_Buttons[key];
					local _, _, _, _, _, _, _, _, _, texture = GetItemInfo(Trades[key].name);
					getglobal(button:GetName().."Icon"):SetTexture(texture);
					--button.id = id;
					button.texture = texture;
					button:Show();
  				end
  			end
  		end
  		if (i == 0) then
  			TradesBar:Hide();
  		end
    end
  end
end

function TradesBar_UpdateCooldowns()
	for i = 1, getn(Trades) do
		button = TradesBar_Buttons[i];
		if (button.id) then
			local cooldown = getglobal(button:GetName().."Cooldown");
			local start, duration, enable = GetSpellCooldown(button.id, SpellBookFrame.bookType);
			if (start > 0 and duration > 0) then
				CooldownFrame_SetTimer(cooldown, start, duration, enable);
			end
		end
	end
end

function TradesBar_GetSpellID(spell, rank, debug)
	local i = 1;
	local spellID;
	local highestRank;
	while true do
		local spellName, spellRank = GetSpellName(i, SpellBookFrame.bookType);
		if (not spellName) then
			break;
		end
		if (spellName == spell) then
			if (rank) then
				if (spellRank == rank) then
					if (debug) then
						DEFAULT_CHAT_FRAME:AddMessage("Found |cffffffff'"..spell.." ("..rank..")'|r at slot |cffffffff'"..i.."'", 0.1, 1.0, 0.0);
					end
					return i;
				end
			else
				spellID = i;
				highestRank = spellRank;
			end
		end
		i = i + 1;
		if (i > 200) then
			break;
		end
	end			
	if (debug) then
		DEFAULT_CHAT_FRAME:AddMessage("Could not find |cffffffff'"..spell.." ("..rank..")'", 1.0, 0.1, 0.0);
	end
	return spellID, highestRank;
end

function TradesBar_GetSkillLineID(input)
	for i=1, GetNumSkillLines() do
		local skillName, _, _, skillRank, _, _, skillMaxRank = GetSkillLineInfo(i);
		if skillName == input then
			return i;
		end
	end
	-- if we've made it this far, something must have gone horribly wrong!
	return false;
end

function TradesBar_OnEnter()
	local skillColor, skillDiffPercent = '', 0;
	if (this.id) then
		local skillName = GetSpellName(this.id, SpellBookFrame.bookType);
		tmpSkillName = TradesBar_ProperSkillName(skillName);
		if tmpSkillName ~= skillName then
			spellID = TradesBar_GetSpellID(tmpSkillName);
			skillName = tmpSkillName;
		else
			spellID = this.id;
		end
		local skillLineID, skillRank, skillMaxRank = TradesBar_GetSkillLineID(skillName), nil, nil;
		if skillLineID then
			_, _, _, skillRank, _, _, skillMaxRank = GetSkillLineInfo(skillLineID);
		end
		GameTooltip_SetDefaultAnchor(GameTooltip, this);
		GameTooltip:SetSpell(this.id, SpellBookFrame.bookType);
		if (skillRank and skillMaxRank and skillName) then
			skillDiffPercent = (skillRank / skillMaxRank) * 100;
			skillColor = '';
			if (skillDiffPercent <= 25 ) then
				skillColor = 'ff0000';
			elseif (skillDiffPercent > 25 and skillDiffPercent <= 50) then
				skillColor = 'ff7f00';
			elseif (skillDiffPercent > 50 and skillDiffPercent <= 75) then
				skillColor = 'ffff00';
			elseif (skillDiffPercent > 75) then
				skillColor = '00ff00';
			end
			if not skillColor then
				skillColor = 'ff0000';
			end
--			DEFAULT_CHAT_FRAME:AddMessage('TradesBar: skillColor = "'..tostring(skillColor)..'", spellID = "'..tostring(spellID)..'", skillName = "'..tostring(skillName)..'", skillMaxRank = "'..tostring(skillMaxRank)..'", skillRank = "'..tostring(skillRank)..'"');
			TradesBar_TooltipRanksText[skillName] = {
				left = '|cffffffffSkill Level:|r';
				right = '|cff'..tostring(skillColor)..skillRank..'|r|cffffffff/'..skillMaxRank..'|r';
			};
			GameTooltip:AddLine(" ");
--			GameTooltip:AddDoubleLine(TradesBar_TooltipRanksText[skillName].left, TradesBar_TooltipRanksText[skillName].right);
			GameTooltip:AddDoubleLine('|cffffffffSkill Level:|r', '|cff'..skillColor..skillRank..'|r|cffffffff/'..skillMaxRank..'|r');
		end
		GameTooltip:Show();
	end
end

function TradesBar_ProperSkillName(skillName)
	if (skillName == TRADES_DISENCHANT) then
		skillName = TRADES_ENCHANTING;
	elseif (skillName == TRADES_SMELTING or skillName == TRADES_FIND_MINERALS) then
		skillName = TRADES_MINING;
	elseif (skillName == TRADES_FIND_HERBS) then
		skillName = TRADES_HERBALISM;
	elseif (skillName == TRADES_BASIC_CAMPFIRE) then
		skillName = TRADES_COOKING;
	elseif (skillName == TRADES_PICK_LOCK or skillName == TRADES_PICK_POCKET) then
		skillName = "Lockpicking";
	elseif (skillName == TRADES_PROSPECTING) then
		skillName = TRADES_JEWELCRAFTING;
	end
	return skillName;
end

function TradesBar_OnBind(that_spell)
	local spellID = TradesBar_GetSpellID(that_spell);
	if (TradesBar_is_fishingbuddy and that_spell == TRADES_FISHING) then
	    --DEFAULT_CHAT_FRAME:AddMessage("[TradesBar DEBUG:]  FishingBuddy found ~ "..that_spell.." - "..TRADES_FISHING);
	    TradesBar_FishingBuddy_Over();
    elseif (spelID) then
    	local spellName = GetSpellName(spellID, BOOKTYPE_SPELL);
	    --DEFAULT_CHAT_FRAME:AddMessage("[TradesBar DEBUG:]  FishingBuddy NOT FOUND ~ "..that_spell.." - "..TRADES_FISHING);
    	CastSpell(spellID, BOOKTYPE_SPELL);
    end
end

function TradesBarGetPoint()
	local vLeft = TradesBar:GetLeft();
	local vTop = TradesBar:GetTop();
	TradesBarData[playerName]["left"] = vLeft;
	TradesBarData[playerName]["top"] = vTop;
	-- DEFAULT_CHAT_FRAME:AddMessage(vLeft.." "..vTop);
end

-- CONFIG

function TradesBarConfig_OnHide()
	if original_heights['TradesBarConfigPanel4'] and original_heights['TradesBarConfigPanel5'] and original_heights['TradesBarConfig'] then
		getglobal('TradesBarConfigPanel4'):SetHeight(original_heights['TradesBarConfigPanel4']);
		getglobal('TradesBarConfigPanel5'):SetHeight(original_heights['TradesBarConfigPanel5']);
		getglobal('TradesBarConfig'):SetHeight(original_heights['TradesBarConfig']);
	end
end

-- OnShow
function TradesBarConfig_OnShow()
	if (not TradesBarData) then
		this:Hide();
		return;
	end
	if (not TradesBarData[playerName]) then
		this:Hide();
		return;
	end
	-- Top Panel
	local order, hidebar, horizontal;
	if (TradesBarData[playerName]["order"] == 'za') then
		order = true;
	else
		order = false;
	end
	if (TradesBarData[playerName]["hidebar"] == 'true') then
		hidebar = true;
	else
		hidebar = false;
	end
	if (TradesBarData[playerName]["horizontal"] == 'true') then
		horizontal = true;
	else
		horizontal = false;
	end
	TradesBarConfigPanel1CheckButton1:SetChecked( hidebar );
	TradesBarConfigPanel1CheckButton2:SetChecked( horizontal );
	TradesBarConfigPanel1CheckButton3:SetChecked( order );

	original_heights = {
		['TradesBarConfigPanel4'] = getglobal('TradesBarConfigPanel4'):GetHeight(),
		['TradesBarConfigPanel5'] = getglobal('TradesBarConfigPanel5'):GetHeight(),
		['TradesBarConfig'] = getglobal('TradesBarConfig'):GetHeight(),
	}

	TradesBarConfigPanel1SliderScale:SetValue( TradesBarData[playerName]["scale"] );
	
	local Point = {
		[4] = {
			x = 10,
			y = 0,
			height = getglobal('TradesBarConfigPanel4'):GetHeight(),
		},
		[5] = {
			x = 10,
			y = 0,
			height = getglobal('TradesBarConfigPanel5'):GetHeight(),
		},
	}
	
	local left, right = 1, 2;
	
	for k in pairs(AdminPanels) do
		local side = 1;
		for _, skillTable in pairs(AdminPanels[k]) do
			if (skillTable.panel) then
				-- Alternate from left to right adding checkbuttons as we go,
				-- also increasing the size of the panel and its parent frame.
				if side == left then
					Point[k].x = 10;
					Point[k].y = Point[k].y - 27;
					Point[k].height = Point[k].height + 27; -- Increase the panel size
				elseif side == right then
					Point[k].x = 116;
				end
				local visible;
				if (TradesBarData[playerName][skillTable.name] == 'true') then
					visible = true;
				else
					visible = false;
				end
				local CheckButton = CreateFrame('CheckButton', 'TradesBarConfigButton'..skillTable.name, getglobal('TradesBarConfigPanel'..skillTable.panel), 'TradesBarCheckButtonTemplate');
				CheckButton:SetPoint('TOPLEFT', getglobal('TradesBarConfigPanel'..skillTable.panel), Point[k].x, Point[k].y)
				CheckButton:SetChecked(visible);
				-- Default is enabled, but if its disabled and you aquire the skill,
				-- the CheckButton will remain disabled until you relog unless you reenable it like this.
				if ((skillTable.type and skillTable.type == 'item') or TradesBar_HasSkill(skillTable.name)) then
					CheckButton:Enable();
				else
					CheckButton:Disable();
				end
				getglobal('TradesBarConfigButton'..skillTable.name..'Text'):SetText(skillTable.name);
				CheckButton:Show();
				side = 1 + mod(side, 2);
			end
		end
	end
	getglobal('TradesBarConfigPanel4'):SetHeight(Point[4].height);
	getglobal('TradesBarConfigPanel5'):SetHeight(Point[5].height);
	-- Add the current hard-coded size to the biggest panel height and make that the parent frame's height
	getglobal('TradesBarConfig'):SetHeight(getglobal('TradesBarConfig'):GetHeight() + max(Point[5].height, Point[4].height));
end

function TradesBarConfigScale_OnClick()
	TradesBarData[playerName]["scale"] = this:GetValue();
	TradesBar_Scale();
end

function TradesBarConfigCheckBoxHide_OnClick()
	if (TradesBarData[playerName]["hidebar"] == "true") then
		TradesBarData[playerName]["hidebar"] = "false";
	else
		TradesBarData[playerName]["hidebar"] = "true";
	end
	TradesBar_Hide();
	TradesBar_Update();
end

function TradesBarConfigCheckBox_OnClick()
	if (TradesBarData[playerName]["horizontal"] == "true") then
		TradesBarData[playerName]["horizontal"] = "false";
	else
		TradesBarData[playerName]["horizontal"] = "true"
	end
	TradesBar_O();
end

function TradesBarConfigCheckBoxOrder_OnClick()
	if (TradesBarData[playerName]["order"] == "az") then
		TradesBarData[playerName]["order"] = "za";
	else
		TradesBarData[playerName]["order"] = "az"
	end
	TradesBar_O();
end

function TradesBarConfigCheckBox_ToggleSkill(this)
	local skill = strmatch(this:GetName(), 'TradesBarConfigButton(.*)');
	local checked;
	--skill = 'TradesBarButton'..skill;
	--ChatFrame1:AddMessage('Toggling '..skill);
	if (TradesBarData[playerName][skill] == "true") then
		TradesBarData[playerName][skill] = "false";
		checked = false;
	else
		TradesBarData[playerName][skill] = "true";
		checked = true;
	end
	this:SetChecked(checked);
	TradesBar_Update();
end
