﻿Tracksw = LibStub("AceAddon-3.0"):NewAddon("Tracksw", "AceTimer-3.0", "AceConsole-3.0")
local Tracksw = Tracksw
local L = LibStub("AceLocale-3.0"):GetLocale("Tracksw", false)

-- setup keybinds
BINDING_HEADER_Tracksw = "Tracksw"
BINDING_NAME_TOGGLETRACKSW = L["Enable or disable Tracksw"]

local defaults = {
        profile = {
                -- user modifiable
                delay = 0.2,
                trigger = 70,
                cluster = 5,
                out = 15,
                arcrad = math.pi/3, -- 60°
                mountedonly = true,
                -- internal
                enabled = true,
                lookahead = 6, -- value derived from update interval
        },
        char = {
                trackingTypes = {
                        {spellid = 2383, gmname = "Herb Gathering", enabled = true }, -- Find Herbs
                        {spellid = 2580, gmname = "Mining", enabled = true }, -- Find Minerals
                        {spellid = 43308, gmname = "Fishing", enabled = true }, -- Find Fish
                        {spellid = 2481, gmname = "Treasure", enabled = true }, -- Find Treasure
                },
        }
}
local db
local trackingTypes

local KeybindHelper = {}
do
        local t = {}
        function KeybindHelper:MakeKeyBindingTable(...)
                for k in pairs(t) do t[k] = nil end
                for i = 1, select("#", ...) do
                        local key = select(i, ...)
                        if key ~= "" then
                                tinsert(t, key)
                        end
                end
                return t
        end
end

local options = {
        type = "group",
        name = "Tracksw",
        args={
                options_grp = {
                        type = "group",
                        name = L["OPTIONS_NAME"],
                        desc = L["OPTIONS_DESC"],
                        order = 0,
                },
                trackings_grp = {
                        type = "group",
                        name = L["TRACKINGS_NAME"],
                        desc = L["TRACKINGS_DESC"],
                        args = {
                                desc = {
                                        type = "description",
                                        name = L["TRACKINGS_NAME"],
                                        order = 0,
                                },
                        },
                        order = 10,

                },
        }
}

options.args.options_grp.args = {
        desc = {
                type = "description",
                name = L["OPTIONS_NAME"],
                order = 0,
        },
        trigger = {
                width="double",
                type="range",
                name=L["TRIGGER_NAME"],
                desc=L["TRIGGER_DESC"],
                min=10,
                max=100,
                step=5,
                isPercent = false,
                get=function() return db.trigger end,
                set=function(info, v) db.trigger = v end,
                order = 10,
        },
        cluster = {
                type="range",
                name=L["CLUSTER_NAME"],
                desc=L["CLUSTER_DESC"],
                min=0,
                max=30,
                step=1,
                isPercent = false,
                get=function() return db.cluster end,
                set=function(info, v) db.cluster = v end,
                order = 20,
        },
        out = {
                type="range",
                name=L["OUT_NAME"],
                desc=L["OUT_DESC"],
                min=10,
                max=30,
                step=5,
                isPercent = false,
                get=function() return db.out end,
                set=function(info, v) db.out = v end,
                order = 30,
        },
        arc = {
                type="range",
                name=L["ARC_NAME"],
                desc=L["ARC_DESC"],
                min=30,
                max=360,
                step=5,
                isPercent = false,
                get=function() return math.deg(db.arcrad) end,
                set=function(info, v) db.arcrad = math.rad(v) end,
                order = 40,
        },
        delay = {
                type="range",
                name=L["DELAY_NAME"],
                desc=L["DELAY_DESC"],
                min=0.1,
                max=2,
                step=0.05,
                isPercent = false,
                get=function() return db.delay end,
                set=function(info, v)
                        db.delay = v
                        db.lookahead = 20 * v * 1.5 -- 280% mount = ~20yds/s
                end,
                order = 50,
        },
        mountedonly = {
                type="toggle",
                name=L["MOUNTED_NAME"],
                desc=L["MOUNTED_DESC"],
                get=function() return db.mountedonly end,
                set=function() db.mountedonly = not db.mountedonly end,
                order = 60,
        },
        togglekey = {
                type = "keybinding",
                name = L["TOGGLE_NAME"],
                desc = L["TOGGLE_DESC"],
                get = function(info) return table.concat(KeybindHelper:MakeKeyBindingTable(GetBindingKey("TOGGLETRACKSW")), ", ") end,
                set = function(info, key)
                        if key == "" then
                                local t = KeybindHelper:MakeKeyBindingTable(GetBindingKey("TOGGLETRACKSW"))
                                for i = 1, #t do
                                        SetBinding(t[i])
                                end
                        else
                                SetBinding(key, "TOGGLETRACKSW")
                        end
                        SaveBindings(GetCurrentBindingSet())
                end,
                order = 70,
        },
}

local scheduled
local function doSwitch(ttype)
        scheduled = false
        SetTracking(ttype)
end

local playerModel
do
        local t = { Minimap:GetChildren() }
        for i = #t,1,-1 do
                local v = t[i]
                if v:GetObjectType() == "Model" and not v:GetName() then
                        playerModel = v
                        break
                end
        end
end

local math_2pi = 2*math.pi
local math_abs = math.abs
local math_atan2 = math.atan2
local math_min = math.min

local mx, my, x, y
local prad, nrad, diffrad
local zone
local update = 0
local inrange = {}
local time

local isDruid = false
local druidFF -- Flight Form
local druidSFF -- Swift Flight Form
-- support druid flight form
local function IsMounted2()
        if IsMounted() then
                return true
        elseif isDruid then
                local cnt = GetNumShapeshiftForms()
                for i=1, cnt do
                        local _, name, active = GetShapeshiftFormInfo(i)
                        if (name == druidFF or name == druidSFF) and active then
                                return true
                        end
                end
        end
        return false
end

local dummy = CreateFrame("Frame")
dummy:Hide()
dummy:SetScript("OnUpdate", function(self, elapsed)
        time = GetTime()
        if scheduled or time < update or IsResting() or IsInInstance() or UnitOnTaxi("player") or (db.mountedonly and not IsMounted2()) or (InCombatLockdown() and not IsMounted2()) then
                return
        end

        update = time + db.delay

        -- thanks GatherHud
        if (GetCVar("rotateMinimap") ~= "0") then
                prad = -MiniMapCompassRing:GetFacing();
        else
                prad = playerModel:GetFacing();
        end

        zone = GetRealZoneText()

        px, py = GetPlayerMapPosition("player")

        local cluster = db.trigger + db.cluster
        local out = db.trigger + db.out

        local tt, newtt = nil

        for ord = 1, #trackingTypes do
                tt = trackingTypes[ord]
                if tt.id and tt.enabled then
                        for id, _ in GatherMate:FindNearbyNode(zone, px, py, tt.gmname, out+db.lookahead, nil) do
                                local nx, ny = GatherMate:getXY(id)
                                local dist = GatherMate:Distance(nx, ny, px, py, zone)

                                nrad = math_atan2((px - nx), (py-ny))
                                if nrad < 0 then nrad = nrad + math_2pi end

                                diffrad = math_abs(nrad-prad)
                                diffrad = math_min(diffrad, math_2pi-diffrad)

                                if inrange[id] then
                                        if dist >= out then
                                                inrange[id] = nil
                                        end
                                elseif dist <= db.trigger and diffrad <= (db.arcrad/2) then -- new node
                                        inrange[id] = true
                                        if not newtt or tt.id < newtt.id then
                                                newtt = tt
                                        end
                                end
                        end
                end
        end

        if newtt and not select(3, GetTrackingInfo(newtt.id)) then -- ttype ~= active tracking
                local start, duration = GetSpellCooldown(newtt.name)
                if start > 0 then
                        Tracksw:ScheduleTimer(doSwitch, start - GetTime() + duration + 0.1, newtt.id)
                        scheduled = true
                else
                        doSwitch(newtt.id)
                end
        end
end)

function Tracksw:OnInitialize()
        LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("Tracksw", options)
        self:RegisterChatCommand("tsw", function() LibStub("AceConfigDialog-3.0"):Open("Tracksw") end)
        self.db = LibStub("AceDB-3.0"):New("TrackswDB", defaults)
        db = self.db.profile
        trackingTypes = self.db.char.trackingTypes
end

function Tracksw:OnEnable()
        -- get localized tracking spell names
        for _, tt in ipairs(trackingTypes) do
                tt.name = GetSpellInfo(tt.spellid)
        end

        -- build the trackingTypes table
        for i=1,GetNumTrackingTypes() do
                local name, texture = GetTrackingInfo(i)
                for ord, tt in ipairs(trackingTypes) do
                        if name == tt.name then
                                tt.id = i
                                options.args.trackings_grp.args[tt.name:gsub("%s", "_")] = {
                                        type="toggle",
                                        name=tt.name,
                                        desc=L["Enable"].." "..tt.name,
                                        get=function()
                                                return tt.enabled
                                        end,
                                        set=function()
                                                tt.enabled = not tt.enabled
                                        end,
                                        width="double",
                                }
                        end
                end
        end

        local _, className = UnitClass("player")
        isDruid = (className == "DRUID")
        druidFF = select(1, GetSpellInfo(33950)) -- Flight Form
        druidSFF = select(1, GetSpellInfo(40123)) -- Swift Flight Form

        if db.enabled then
                dummy:Show()
        end
end

function Tracksw:OnDisable()
        dummy:Hide()
end

function Tracksw:Toggle()
        db.enabled = not db.enabled

        if db.enabled then
                self:Print("|cff22ff22"..L["TOGGLE_ENABLED"])
                dummy:Show()
        else
                self:Print("|cffff2222"..L["TOGGLE_DISABLED"])
                dummy:Hide()
        end
end
