--
-- TotemTips
-- 
-- Author: Pakoro of Nathrezim
--
-- Changes;
-- 06 Oct 2007 Removed unnecessary line wrap code, and with it all user settings code, as that was only value persisted
-- 28 Dec 2006 Debugging mode change
-- 07 Dec 2006  Compatibility fix for new Lua version in WoW 2.0
-- 09 July 2006: Compatibility fix for other addons
-- 07 July 2006 : Linewrapping of tooltip, configurable with slash command
-- 30 June 2006: Initial Release

TotemTips = {}

-- Set to true to help debug missing totem data; primarily useful for gathering data on NPC totems which have no shaman equivalent
local debugOutput = false
local missingReported = { }

-- Return true if the given name appears to be the name of a totem
function TotemTips:MatchesTotemName(name)
	-- Some locales may have multiple patterns that match a totem name so have to loop over all of them
	for i = 1, #(TotemTips_Match_Patterns) do
		if (strfind(name, TotemTips_Match_Patterns[i])) then
			return true
		end
	end
	
	return false
end

-- If the totem is a Corrupted or Tainted version of a regular one, returns the description based on the regular version
function TotemTips:GetCorruptedTotemDescription(name)
  local pattern, pos, s, e
  for pattern, pos in pairs(TotemTips_Corrupted_Patterns) do
    if (pos == 'pre') then --prefix pattern
      s, e = strfind(name, pattern, 1, true)
      if (s == 1 and e < strlen(name)) then
        return TotemTips_Totems[strsub(name, e + 1)]
      end
    else -- postfix pattern
      local offset = -strlen(pattern)
      s, e = strfind(name, pattern, offset, true)
      if (s == strlen(name) + offset + 1) then
        return TotemTips_Totems[strsub(name, 1, s - 1)]
      end
    end
  end
  
  return nil
end

-- Return a description of what the totem with the given name does
function TotemTips:GetTotemDescription(name)
	local description = TotemTips_Totems[name]
	
  -- If it appears to be a totem but nothing was found
  if (not description and self:MatchesTotemName(name)) then
    -- Check if it's a Corrupted or Tainted NPC version of a regular totem
    description = self:GetCorruptedTotemDescription(name)
    
    -- If still nothing and debugging is turned on, print a message to the chat frame
    if (not description and debugOutput) then
			if (not missingReported[name]) then -- Only report missing totem once a session  to not spam with debug messages
				missingReported[name] = true
				DEFAULT_CHAT_FRAME:AddMessage('TotemTips: Missing totem data for ' .. name)
      end
    end
  end
  
	return description
end

-- Add the description of a totem to its tooltip
function TotemTips:GameTooltip_OnShow()
  if (UnitCreatureType("mouseover") == 'Totem') then
    local name = UnitName("mouseover")
    if not name then
      return
    end
    local description = self:GetTotemDescription(name)
    if description then
      GameTooltip:AddLine(description, 1, 1, 1, 1)
      GameTooltip:Show()
    end
	end
end