--[[ Variables saved to SavedVariables.lua ]]

TotemMenuVersion = "2.4.0.0"

TotemMenuOpt = {
  State = 1,     -- 0=off, 1=on, 2=locked
  Visibility = 1,    -- 0=hidden, 1=visible
  IconPos = -900,    -- angle of initial minimap icon position
  MainScale = 1,    -- scaling of main window
  XPos = 0,
  YPos = 400,
  Tooltips = "full",
  IconVisible = 1,  
}

--[[ Local Variables]]

TotemMenuVar = {
  ScalingWidth = 0,   -- width of the frame being scaled
  ScalingTime = 0,   -- time since last scaling OnUpdate
  ScalingUpdateTimer = .1 -- frequency (in seconds) of scaling OnUpdates
}

TotemIDs = {};
TotemRanks = {};

--[[ Window movement functions ]]

function TotemMenu_OnMouseDown(arg1)
  if (arg1=="LeftButton") and (TotemMenuOpt.State~=2) then
    if (IsShiftKeyDown()) then					 
      TotemMenuFrame:StartMoving();
	  end
  end
end

function TotemMenu_OnMouseUp(arg1)
  if (arg1=="LeftButton") and (TotemMenuOpt.State~=2) then
    TotemMenuFrame:StopMovingOrSizing();
    TotemMenuOpt.XPos = TotemMenuFrame:GetLeft();
    TotemMenuOpt.YPos = TotemMenuFrame:GetTop();
  end
end

function TotemMenu_ForceUI()
  TotemMenuFrame:SetScale(TotemMenuOpt.MainScale)
  TotemMenuFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT", TotemMenuOpt.XPos, TotemMenuOpt.YPos);
  TotemMenu_IconFrame:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(TotemMenuOpt.IconPos or 0)),(80*sin(TotemMenuOpt.IconPos or 0))-52);
  
  if (TotemMenuOpt.Visibility == 1) then
    TotemMenuFrame:Show();
  else
    TotemMenuFrame:Hide();
  end
  if (TotemMenuOpt.IconVisible == 1) then
    TotemMenu_IconFrame:Show();
  else
    TotemMenu_IconFrame:Hide();
  end
end

--[[ Dialog control functions ]]

function Totem_OnEnter()
  GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT");
  local id = this:GetID();
  local totemName = TOTEM_LOCS[id];
  local totemid = TotemMenu_Find(totemName);
  if (TotemIDs[totemid]) then
    if (TotemMenuOpt.Tooltips == "full" or IsShiftKeyDown()) then
      GameTooltip:SetSpell(TotemIDs[totemid],1);
    elseif (TotemMenuOpt.Tooltips == "name") then
      GameTooltip:SetText(totemName, 255,255,255,1);
    else
      return;
    end
  else
    if (totemName and not (TotemMenuOpt.Tooltips == "none")) then
      GameTooltip:SetText(totemName, 255, 0, 0, 1);
    end
  end
  GameTooltip:Show();
end

function Totem_OnLeave()
   GameTooltip:Hide();
end

function Totem_UpdateCooldown()
  local children = { TotemMenuFrame:GetChildren() };
  for _,child in ipairs(children) do
    local childname = child:GetName();
    if (childname) then
      isbutton = string.match(childname, "TotemButton%d+");
      if (isbutton) then
        local cooldown = getglobal(child:GetName().."Cooldown");
  	    local id = child:GetID();
  	    local totemName = TOTEM_LOCS[id];
			  local totemid = TotemMenu_Find(totemName)
			  if (TotemIDs[totemid]) then
          local start, duration, enable = GetSpellCooldown(TotemIDs[totemid],BOOKTYPE_SPELL);
          CooldownFrame_SetTimer(cooldown, start, duration, enable);
			  end
      end
    end
  end
end

--[[ MainFrame Scaling ]]

function TotemMenu_StartScaling(arg1)
  if arg1=="LeftButton" then
    if (IsShiftKeyDown()) then
      this:LockHighlight();
      TotemMenuVar.ScalingWidth = this:GetParent():GetWidth();
      TotemMenu_ScalingFrame:Show();
		end
  end
end

function TotemMenu_StopScaling(arg1)
  TotemMenu_ScalingFrame:Hide();
  this:UnlockHighlight();
end

function TotemMenu_ScaleFrame(scale)
  local oldscale = TotemMenuFrame:GetScale() or 1;
  local framex = (TotemMenuFrame:GetLeft() or TotemMenuOpt.XPos)* oldscale;
  local framey = (TotemMenuFrame:GetTop() or TotemMenuOpt.YPos)* oldscale;

  TotemMenuFrame:SetScale(scale);
  TotemMenuFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",framex/scale,framey/scale);
  TotemMenuFrame:StartMoving();
  TotemMenuFrame:StopMovingOrSizing();
  TotemMenuOpt.MainScale = TotemMenuFrame:GetScale();
  TotemMenuOpt.XPos = TotemMenuFrame:GetLeft();
  TotemMenuOpt.YPos = TotemMenuFrame:GetTop();
end

function TotemMenu_ScalingFrame_OnUpdate(arg1)
  local oldscale = TotemMenuFrame:GetScale();
  local framex, framey, cursorx, cursory = TotemMenuFrame:GetLeft()*oldscale, TotemMenuFrame:GetTop()*oldscale, GetCursorPosition();

  if (cursorx-framex)>32 then
    local newscale = (cursorx-framex)/TotemMenuVar.ScalingWidth;
    TotemMenu_ScaleFrame(newscale);
  end
end

--[[ Minimap Icon ]]--

function TotemMenu_IconDraggingFrame_OnUpdate(arg1)
  local xpos,ypos = GetCursorPosition()
  local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

  xpos = xmin-xpos/UIParent:GetScale()+70
  ypos = ypos/UIParent:GetScale()-ymin-70

  TotemMenuOpt.IconPos = math.deg(math.atan2(ypos,xpos))
  TotemMenu_IconFrame:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(TotemMenuOpt.IconPos or 0)),(80*sin(TotemMenuOpt.IconPos or 0))-52)
end

function TotemMenu_Toggle()
  if TotemMenuFrame:IsVisible() then
    TotemMenuFrame:Hide()
    TotemMenuOpt.Visibility = 0;
  else
    TotemMenuFrame:Show()
    TotemMenuOpt.Visibility = 1;
  end
end

function TotemMenu_IconFrame_OnClick(arg1)
  if arg1=="LeftButton" then
    TotemMenu_Toggle();
  end
end

function TotemMenu_OnEvent(event)
  if (event == "VARIABLES_LOADED") then
    TotemMenu_ReadFromSpellBook();
  end
  if event=="CVAR_UPDATE" then
    if (arg1=="USE_UISCALE" or arg1=="WINDOWED_MODE") and TotemMenuOpt.XPos then
      TotemMenu_ForceUI();
    end
  elseif event=="PLAYER_ENTERING_WORLD" then
    this:UnregisterEvent("PLAYER_ENTERING_WORLD")
    TotemMenu_CreateButtons();
    TotemMenu_ForceUI();
    TotemMenu_ReadFromSpellBook();
  elseif event=="SPELLS_CHANGED" then
    TotemMenu_ReadFromSpellBook();
  elseif (event=="ACTIONBAR_UPDATE_USABLE" or event == "ACTIONBAR_UPDATE_COOLDOWN") then
    Totem_UpdateCooldown();
  end
end

function TotemMenu_ReadFromSpellBook()
  local i;
  for i = 1, 300 do
    local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
    if (spellName) then
      if (string.find(spellName, "Totem", 1, true)) then
        for j = 1, #TOTEM_LIST do
          if (string.find(spellName, TOTEM_LIST[j], 1, true)) then
            TotemRanks[j] = spellRank;
            TotemIDs[j] = i;
	        end
	      end
      end
    else
      break
    end
  end
  TotemMenu_UpdateButtons();
end

function TotemMenu_GetSpellID(name)
	local i = 1;
	local valid = -1;
	local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
	while spellName do
		if ( spellName == name) then
			valid = i;
    elseif ( valid > -1 ) then
			return valid;
		end
		i = i + 1;
		spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
	end
	return valid;
end

function TotemMenu_UpdateButtons()
  local maxcols = 0;
  local maxrows = 0;
  local children = { TotemMenuFrame:GetChildren() };
  for _,child in ipairs(children) do
    local childname = child:GetName();
    if (childname) then 
      isbutton = string.match(childname, "TotemButton%d+");
      if (isbutton) then
        local buttonid = child:GetID();
        local totemName = TOTEM_LOCS[buttonid];
        if (totemName) then
          local totemid = TotemMenu_GetSpellID(totemName);
          local texture = getglobal(childname.."Icon");
          texture:SetTexture(TOTEM_TEXTURES[totemName]);
          child:SetAttribute("type1","spell");
          child:SetAttribute("spell1",TOTEM_LOCS[buttonid]);
          local colno = math.floor(buttonid % 10);
          if (colno > maxcols) then
            maxcols = colno;
          end
          local rowno = math.floor(buttonid / 10);
          if (rowno > maxrows) then
            maxrows = rowno;
          end
          if (totemid > -1) then
            texture:SetVertexColor(1.0,1.0,1.0);
            child:Enable();
--            child:Show();
          else
            texture:SetVertexColor(0.3,0.3,0.3);
--            child:Hide();
          end
          child:Show();
        else
          child:Hide();
        end
      end
    end
  end
  maxcols = maxcols + 1;
  maxrows = maxrows + 1;
  local width = (maxcols * 42) + 10;
  local height = (maxrows * 42) + 10;
  TotemMenuFrame:SetWidth(width); 
  TotemMenuFrame:SetHeight(height); 
end

function TotemMenu_CreateButtons()
  local lastbutton = 0;
  for i, spell in pairs(TOTEM_LOCS) do
    if (i > lastbutton) then
      lastbutton = i;
    end
  end
  for i = 0, lastbutton do
    local button = CreateFrame("Button","TotemButton"..i,TotemMenuFrame,"TotemMenuButtonTemplate");
    button:SetID(i); 
    if (i == 0) then
      button:SetPoint("TOPLEFT",TotemMenuFrame,8,-8);
    elseif (i % 10 > 0) then
      local p = i - 1;
      local pbutton = "TotemButton"..p;
      button:SetPoint("TOPLEFT",pbutton,"TOPRIGHT",5,0);
    else
      local p = i - 10;
      local pbutton = "TotemButton"..p;
      button:SetPoint("TOPLEFT",pbutton,"BOTTOMLEFT",0,-5);
    end
  end
end

function TotemMenu_Find(name)
	if (name) then
    for i = 1, #TOTEM_LIST do
      if (string.find(TOTEM_LIST[i], name, 1,  true)) then
        return i;
      end
    end
	end
  return -1
end

function TotemMenu_ChatCommandHandler(msg)
  local command, var = TotemMenu_ParseCommand(msg);
  if ((not command) and msg) then
    command = msg;
  end
  if (command) then
    command = string.lower(command);
    if (command == "show") then
      TotemMenuFrame:Show();
      TotemMenuOpt.Visibility = 1;
    elseif (command == "hide") then
      TotemMenuFrame:Hide();
      TotemMenuOpt.Visibility = 0;
    elseif (command == "reset") then
      TotemMenuOpt.State = 1;    
      TotemMenuOpt.Visibility = 1;
      TotemMenuOpt.IconPos = -900;
      TotemMenuOpt.MainScale = 1;
      TotemMenuOpt.XPos = 0;
      TotemMenuOpt.YPos = 400;
      TotemMenuOpt.IconVisible = 1;
      TotemMenu_ForceUI();
    elseif (command == "tooltips") then
      if (var == "full" or var == "name" or var == "none") then
        TotemMenuOpt.Tooltips = var;
      end
    elseif (command == "minimap") then
      if (var == "show") then
        TotemMenu_IconFrame:Show();
        TotemMenuOpt.IconVisible = 1;
      elseif (var == "hide") then
        TotemMenu_IconFrame:Hide();
        TotemMenuOpt.IconVisible = 0;
      end
    end
  end
end

function TotemMenu_ParseCommand(msg)
    firstSpace = string.find(msg, " ", 1, true);
    if (firstSpace) then
        local command = string.sub(msg, 1, firstSpace - 1);
        local var  = string.sub(msg, firstSpace + 1);
        return command, var
    else
        return msg, "";
    end
end

function TotemMenu_InitializeOptions()
  if (not TotemMenuOpt.State) then
    TotemMenuOpt.State = 1;
  end
  if (not TotemMenuOpt.Visibility) then
    TotemMenuOpt.Visibility = 1;
  end
  if (not TotemMenuOpt.IconPos) then
    TotemMenuOpt.IconPos = -900;
  end
  if (not TotemMenuOpt.MainScale) then
    TotemMenuOpt.MainScale = 1;
  end
  if (not TotemMenuOpt.XPos) then
    TotemMenuOpt.XPos = 0;
  end
  if (not TotemMenuOpt.YPos) then
    TotemMenuOpt.YPos = 400;
  end
  if (not TotemMenuOpt.Tooltips) then
    TotemMenuOpt.Tooltips = "full";
  end
  if (not TotemMenuOpt.IconVisible) then
    TotemMenuOpt.IconVisible = 1;
  end
end

function TotemMenu_OnLoad()
  -- Class-based setup, abort if not supported
  -- mallen: changed hardcoded "Shaman" to variable _CLASSNAME! This way it will work for german
  local class = UnitClass("player");
  if ( class ~= _CLASSNAME ) then
    TotemMenu_IconFrame:Hide();
    TotemMenuFrame:Hide();
    TotemMenuOpt.Visibility = 0;
    return;
  end
	
  SLASH_TOTEMCMD1 = "/totem";
  SlashCmdList["TOTEMCMD"] = function(msg)
    TotemMenu_ChatCommandHandler(msg);
 
  end

  TotemMenu_InitializeOptions();
  this:RegisterEvent("VARIABLES_LOADED");
  this:RegisterEvent("PLAYER_ENTERING_WORLD");
  this:RegisterEvent("CVAR_UPDATE");
  this:RegisterEvent("CVAR_UPDATE");
  this:RegisterEvent("ACTIONBAR_UPDATE_STATE");
  this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
  this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN");
  this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
  this:RegisterEvent("SPELLS_CHANGED");
  DEFAULT_CHAT_FRAME:AddMessage("TotemMenu Redux version "..TotemMenuVersion.." loaded.");
end
