TBOX_Scale = 100

function TotemBox_OnLoad()
	SLASH_TotemBox1 = "/totembox"  
	SLASH_TotemBox2 = "/tbox"  
	SlashCmdList["TotemBox"] = function(msg)
	TotemBox_Handler(msg)
	end
  
	if( DEFAULT_CHAT_FRAME ) then
	DEFAULT_CHAT_FRAME:AddMessage("TotemBox Loaded - Type /tbox help",1, 0, 0)
	end
	this:RegisterEvent("PLAYER_LOGIN")
	this:RegisterEvent("PLAYER_ALIVE")
	this:RegisterEvent("SPELLS_CHANGED")
	this:RegisterEvent("ACTIONBAR_UPDATE_USABLE")
	this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
end

function TotemBox_OnEvent()
	if (event == "PLAYER_LOGIN" or event == "PLAYER_ALIVE" or event == "SPELLS_CHANGED") then
		if UnitClass("player") == "Shaman" then
		TotemBoxSpells()
		TotemBoxMakeButtons()
		else TotemBox:Hide()
		end
	end
	if (event == "ACTIONBAR_UPDATE_USABLE" or event == "ACTIONBAR_UPDATE_COOLDOWN") then
		if UnitClass("player") == "Shaman" then
		TotemBox_Cooldown()
		end
	end
end

function TotemBoxSpells()
	TBOX_KnownSpells = {}
	for i = 1, 300 do
	local spellName = GetSpellName(i, BOOKTYPE_SPELL)
		if spellName ~= nil then
			if string.find(spellName, "Totem") then
			TBOX_KnownSpells[spellName] = 1
			end
		end
	end
end

function TotemBoxMakeButtons()
	for i = 1,6 do
	local button = CreateFrame("Button","TotemButton"..i,TotemBox,"TotemBoxButtonTemplate")
	button:SetID(i)
		if i == 1 then
		button:SetPoint("TOPLEFT",TotemBox,10,-9)
		else
		local nextbutton = "TotemButton"..i-1
		button:SetPoint("TOPLEFT",nextbutton,"TOPRIGHT",0,0)
		end
	end
	for i = 7, 12 do
	local button = CreateFrame("Button","TotemButton"..i,TotemBox,"TotemBoxButtonTemplate")
	button:SetID(i)
		if i == 7 then
		button:SetPoint("TOPLEFT","TotemButton1","BOTTOMLEFT", 0,0)
		else
		local nextbutton = "TotemButton"..i-1
		button:SetPoint("TOPLEFT",nextbutton,"TOPRIGHT",0,0)
		end
	end
	for i = 13, 18 do
	local button = CreateFrame("Button","TotemButton"..i,TotemBox,"TotemBoxButtonTemplate")
	button:SetID(i)
		if i == 13 then
		button:SetPoint("TOPLEFT","TotemButton7","BOTTOMLEFT", 0,0)
		else
		local nextbutton = "TotemButton"..i-1
		button:SetPoint("TOPLEFT",nextbutton,"TOPRIGHT",0,0)
		end
	end
	for i = 19, 24 do
	local button = CreateFrame("Button","TotemButton"..i,TotemBox,"TotemBoxButtonTemplate")
	button:SetID(i)
		if i == 19 then
		button:SetPoint("TOPLEFT","TotemButton13","BOTTOMLEFT", 0,0)
		else
		local nextbutton = "TotemButton"..i-1
		button:SetPoint("TOPLEFT",nextbutton,"TOPRIGHT",0,0)
		end
	end
	for i = 1, 24 do
	getglobal("TotemButton"..i.."Icon"):SetTexture(TOTEMBOX_ICONS[i])
	end
	for i = 1, 24 do
	local frame = getglobal("TotemButton"..i)
	frame:SetAttribute("spell1", TOTEMBOX_SPELLS[i])
		if TBOX_KnownSpells[TOTEMBOX_SPELLS[i]] == nil then
		getglobal("TotemButton"..i):SetAlpha(.1)
		end
	end
	TBOX_SetScale()
end

function TotemBox_Cooldown()
	for i = 1, 24 do
	local usable, nomana = IsUsableSpell(TOTEMBOX_SPELLS[i])
		if usable then -- prevents lua nil error in Cooldown
		local cooldown = getglobal("TotemButton"..i.."Cooldown")
		local start, duration, enable = GetSpellCooldown(TOTEMBOX_SPELLS[i])
		CooldownFrame_SetTimer(cooldown, start, duration, enable)
		end
	end
end

function TotemBox_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT")
	local id = this:GetID()
	local totemName = TOTEMBOX_SPELLS[id]
	GameTooltip:SetText(totemName, 1,1,1,1)
end

function TotemBox_OnLeave()
	GameTooltip:Hide()
end

function TBOX_SetScale()
	TotemBox:SetScale(TBOX_Scale/100)
end

function TBOX_InitSlider(slider)
    getglobal("TBOX_SCALE_Slider" .. "Low"):SetText("50")
	getglobal("TBOX_SCALE_Slider" .. "High"):SetText("100") 
	getglobal("TBOX_SCALE_Slider" .. "Text"):SetText(TBOX_Scale)
end

function TBOX_Change()
	getglobal(this:GetName().."Text"):SetText(getglobal(this:GetName()):GetValue())
	TBOX_Scale = getglobal(this:GetName().."Text"):GetText(getglobal(this:GetName()):GetValue())
	TotemBox:SetScale(TBOX_Scale/100)
end

function TotemBox_Handler(msg)
	if msg == "bell" then
	PlaySoundFile("Sound\\Doodad\\BellTollHorde.wav")
	elseif msg == "hide" then
	TotemBox:Hide()
	elseif msg == "show" then
	TotemBox:Show()
	elseif (msg == "scale") then
	getglobal("TBOX_SCALE_Slider" .. "Text"):SetText(TBOX_Scale)
	getglobal("TBOX_SCALE_Slider"):SetValue(TBOX_Scale)
	getglobal("TBOX_SCALE"):Show()
	elseif msg == "" or msg == "help" then
	TotemBox_Out("/tbox - list of commands")
	TotemBox_Out("/tbox help - list of commands")
	TotemBox_Out("/tbox scale - brings up a slider")
	TotemBox_Out("/tbox hide - hides the box")
	TotemBox_Out("/tbox show - shows the box")
	TotemBox_Out("To move -SHIFT/LEFT CLICK upper left corner and drag")
	end
end

function TotemBox_Out(text)
	DEFAULT_CHAT_FRAME:AddMessage(text)
end
		
TOTEMBOX_ICONS= {
"Interface\\Icons\\Spell_Fire_SearingTotem",--"Searing Totem"
"Interface\\Icons\\Spell_Fire_SelfDestruct",--"Magma Totem"
"Interface\\Icons\\Spell_Fire_SealOfFire",--"Fire Nova Totem"
"Interface\\Icons\\Spell_Nature_GuardianWard",--"Flametongue Totem"
"Interface\\Icons\\Spell_FrostResistanceTotem_01",--"Frost Resistance Totem"
"Interface\\Icons\\Spell_Fire_Elemental_Totem",--"Fire Elemental Totem"
"Interface\\Icons\\Spell_Nature_StoneskinTotem",--"Stoneskin Totem"
"Interface\\Icons\\Spell_Nature_EarthBindTotem",--"Strength of Earth Totem"
"Interface\\Icons\\Spell_Nature_Tremortotem",--"Tremor Totem"
"Interface\\Icons\\Spell_Nature_StrengthOfEarthTotem02",--"Earthbind Totem"
"Interface\\Icons\\Spell_Nature_StoneClawTotem",--"Stoneclaw Totem"
"Interface\\Icons\\Spell_Nature_EarthElemental_Totem",--"Earth Elemental Totem"
"Interface\\Icons\\INV_Spear_04",--"Healing Stream Totem"
"Interface\\Icons\\Spell_Frost_SummonWaterElemental",--"Mana Tide Totem"
"Interface\\Icons\\Spell_Nature_ManaRegenTotem",--"Mana Spring Totem"
"Interface\\Icons\\Spell_Nature_DiseaseCleansingTotem",--"Disease Cleansing Totem"
"Interface\\Icons\\Spell_Nature_PoisonCleansingTotem",--"Poison Cleansing Totem"
"Interface\\Icons\\Spell_FireResistanceTotem_01",--"Fire Resistance Totem"
"Interface\\Icons\\Spell_Nature_SlowingTotem",--"Wrath of Air Totem"
"Interface\\Icons\\Spell_Nature_InvisibilityTotem",--"Grace of Air Totem"
"Interface\\Icons\\Spell_Nature_Windfury",--"Windfury Totem"
"Interface\\Icons\\Spell_Nature_Brilliance",--"Tranquil Air Totem"
"Interface\\Icons\\Spell_Nature_NatureResistanceTotem",--"Nature Resistance Totem"
"Interface\\Icons\\Spell_Nature_GroundingTotem",--"Grounding Totem"
"Interface\\Icons\\Spell_Nature_Earthbind",--"Windwall Totem" Last 3 totems not included 
"Interface\\Icons\\Spell_Nature_RemoveCurse",--"Sentry Totem"
"Interface\\Icons\\Spell_Fire_TotemOfWrath",--"Totem of Wrath"
}

TOTEMBOX_SPELLS= {
"Searing Totem",
"Magma Totem",
"Fire Nova Totem",
"Flametongue Totem",
"Frost Resistance Totem",
"Fire Elemental Totem",
"Stoneskin Totem",
"Strength of Earth Totem",
"Tremor Totem",
"Earthbind Totem",
"Stoneclaw Totem",
"Earth Elemental Totem",
"Healing Stream Totem",
"Mana Tide Totem",
"Mana Spring Totem",
"Disease Cleansing Totem",
"Poison Cleansing Totem",
"Fire Resistance Totem",
"Wrath of Air Totem",
"Grace of Air Totem",
"Windfury Totem",
"Tranquil Air Totem",
"Nature Resistance Totem",
"Grounding Totem",
"Windwall Totem", -- the last 3 totems are not included in the totem box.
"Sentry Totem",
"Totem of Wrath",
}