function ToonsFrame_Sort( sortfunc, server )

	local t={};

	if type(TOONSTAB[server]) == "table" then

		for player,v in pairs(TOONSTAB[server]) do

			tinsert(t, player);

		end

	end

--    sort(t, function(a,b) return a<b end);

	sort(t, function(a,b)

		local c,d=TOONSTAB[server][a], TOONSTAB[server][b];

		return sortfunc(c,d);

		end

	);

	local s={};

	for i=1, getn(t) do

		tinsert(s,TOONSTAB[server][t[i]]);

	end

	return s;

end

function ToonsServer_Sort()

	local t={};

	for server, v in pairs(TOONSTAB) do

		tinsert(t,server);

	end

	sort(t);

	return t;

end

function ToonsPage_Sort()

	local t={};

	local i=1;

	for page, v in pairs(TOONSPAGES) do

		tinsert(t, min(v.id,i), page);

		i=i+1;

	end

	return t;

end

function Toons_SortNameUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.name < player2.name;

	end

end

function Toons_SortNameDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.name > player2.name;

	end

end

function Toons_SortLevelUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.level < player2.level;

	end

end

function Toons_SortLevelDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.level > player2.level;

	end

end

function Toons_SortRaceUp( player1, player2 )

	if ( player1 and player2 ) then

		return TOONS_RACES[player1.raceEn].id < TOONS_RACES[player2.raceEn].id;

	end

end

function Toons_SortRaceDown( player1, player2 )

	if ( player1 and player2 ) then

		return TOONS_RACES[player1.raceEn].id > TOONS_RACES[player2.raceEn].id;

	end

end

function Toons_SortClassUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.class < player2.class;

	end

end

function Toons_SortClassDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.class > player2.class;

	end

end

function Toons_SortZoneUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.zone < player2.zone;

	end

end

function Toons_SortZoneDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.zone > player2.zone;

	end

end

function Toons_SortTimePlayedUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.timeplayed < player2.timeplayed;

	end

end

function Toons_SortTimePlayedDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.timeplayed > player2.timeplayed;

	end

end

function Toons_SortTimeAtLevelUp( player1, player2 )

	if ( player1 and player2 ) then

		return player1.timeatlevel < player2.timeatlevel;

	end

end

function Toons_SortTimeAtLevelDown( player1, player2 )

	if ( player1 and player2 ) then

		return player1.timeatlevel > player2.timeatlevel;

	end

end

function Toons_SortGuildNameUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.guild or "") < (player2.guild or "");

	end

end

function Toons_SortGuildNameDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.guild or "") > (player2.guild or "");

	end

end

function Toons_SortGuildRankUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.guildrank or "") < (player2.guildrank or "");

	end

end

function Toons_SortGuildRankDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.guildrank or "") > (player2.guildrank or "");

	end

end

function Toons_SortGoldUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.gold or 0) < (player2.gold or 0);

	end

end

function Toons_SortGoldDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.gold or 0) > (player2.gold or 0);

	end

end

function Toons_SortBagsUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.bagsmax or 0;

		local s2= player2.bagsmax or 0;

		if ( s1 < s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.bagssize or 0;

			s2= player2.bagssize or 0;

			if ( s1 < s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortBagsDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.bagsmax or 0;

		local s2= player2.bagsmax or 0;

		if ( s1 > s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.bagssize or 0;

			s2= player2.bagssize or 0;

			if ( s1 > s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortBankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.bankmax or 0;

		local s2= player2.bankmax or 0;

		if ( s1 < s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.banksize or 0;

			s2= player2.banksize or 0;

			if ( s1 < s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortBankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.bankmax or 0;

		local s2= player2.bankmax or 0;

		if ( s1 > s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.banksize or 0;

			s2= player2.banksize or 0;

			if ( s1 > s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortXPUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xp or -1) < (player2.xp or -1);

	end

end

function Toons_SortXPDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xp or -1) > (player2.xp or -1);

	end

end

function Toons_SortRestedUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.rested or -1) < (player2.rested or -1);

	end

end

function Toons_SortRestedDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.rested or -1) > (player2.rested or -1);

	end

end

function Toons_SortXPMaxUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xpmax or -1) < (player2.xpmax or -1);

	end

end

function Toons_SortXPMaxDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xpmax or -1) > (player2.xpmax or -1);

	end

end

function Toons_SortXPPercentUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xp and player1.xp/player1.xpmax or -1) < (player2.xp and player2.xp/player2.xpmax or -1);

	end

end

function Toons_SortXPPercentDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.xp and player1.xp/player1.xpmax or -1) > (player2.xp and player2.xp/player2.xpmax or -1);

	end

end

function Toons_SortRestedPercentUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.rested and player1.rested/player1.xpmax or -1) < (player2.rested and player2.rested/player2.xpmax or -1);

	end

end

function Toons_SortRestedPercentDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.rested and player1.rested/player1.xpmax or -1) > (player2.rested and player2.rested/player2.xpmax or -1);

	end

end

function Toons_SortTradeskill1Up( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill1 and SKILL_TYPE[player1.tradeskill1].id or 99;

		local s2= player2.tradeskill1 and SKILL_TYPE[player2.tradeskill1].id or 99;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill1Down( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill1 and SKILL_TYPE[player1.tradeskill1].id or 0;

		local s2= player2.tradeskill1 and SKILL_TYPE[player2.tradeskill1].id or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill2Up( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill2 and SKILL_TYPE[player1.tradeskill2].id or 99;

		local s2= player2.tradeskill2 and SKILL_TYPE[player2.tradeskill2].id or 99;

		if ( s1 < s2 ) then

			return true;

		elseif ( s1==s2) then

			s1= player1.tradeskill1 and SKILL_TYPE[player1.tradeskill1].id or 99;

			s2= player2.tradeskill1 and SKILL_TYPE[player2.tradeskill1].id or 99;

			if ( s1 < s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortTradeskill2Down( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill2 and SKILL_TYPE[player1.tradeskill2].id or 0;

		local s2= player2.tradeskill2 and SKILL_TYPE[player2.tradeskill2].id or 0;

		if ( s1 > s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.tradeskill1 and SKILL_TYPE[player1.tradeskill1].id or 0;

			s2= player2.tradeskill1 and SKILL_TYPE[player2.tradeskill1].id or 0;

			if ( s1 > s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortTradeskill6Up( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill6 and SKILL_TYPE[player1.tradeskill6].id or 99;

		local s2= player2.tradeskill6 and SKILL_TYPE[player2.tradeskill6].id or 99;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill6Down( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill6 and SKILL_TYPE[player1.tradeskill6].id or 0;

		local s2= player2.tradeskill6 and SKILL_TYPE[player2.tradeskill6].id or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill7Up( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill7 and SKILL_TYPE[player1.tradeskill7].id or 99;

		local s2= player2.tradeskill7 and SKILL_TYPE[player2.tradeskill7].id or 99;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill7Down( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill7 and SKILL_TYPE[player1.tradeskill7].id or 0;

		local s2= player2.tradeskill7 and SKILL_TYPE[player2.tradeskill7].id or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill1RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill1rank or 999;

		local s2= player2.tradeskill1rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill1RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill1rank or 0;

		local s2= player2.tradeskill1rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill2RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill2rank or 999;

		local s2= player2.tradeskill2rank or 999;

		if ( s1 < s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.tradeskill1rank or 999;

			s2= player2.tradeskill1rank or 999;

			if ( s1 < s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortTradeskill2RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill2rank or 0;

		local s2= player2.tradeskill2rank or 0;

		if ( s1 > s2 ) then

			return true;

		elseif ( s1==s2 ) then

			s1= player1.tradeskill1rank or 0;

			s2= player2.tradeskill1rank or 0;

			if ( s1 > s2 ) then

				return true;

			end

		end

	end

end

function Toons_SortTradeskill3RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill3rank or 999;

		local s2= player2.tradeskill3rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill3RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill3rank or 0;

		local s2= player2.tradeskill3rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill4RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill4rank or 999;

		local s2= player2.tradeskill4rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill4RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill4rank or 0;

		local s2= player2.tradeskill4rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill5RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill5rank or 999;

		local s2= player2.tradeskill5rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill5RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill5rank or 0;

		local s2= player2.tradeskill5rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill6RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill6rank or 999;

		local s2= player2.tradeskill6rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill6RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill6rank or 0;

		local s2= player2.tradeskill6rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill7RankUp( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill7rank or 999;

		local s2= player2.tradeskill7rank or 999;

		if ( s1 < s2 ) then

			return true;

		end

	end

end

function Toons_SortTradeskill7RankDown( player1, player2 )

	if ( player1 and player2 ) then

		local s1= player1.tradeskill7rank or 0;

		local s2= player2.tradeskill7rank or 0;

		if ( s1 > s2 ) then

			return true;

		end

	end

end

function Toons_SortArenaUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.arenapoints or 0) < (player2.arenapoints or 0);

	end

end

function Toons_SortArenaDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.arenapoints or 0) > (player2.arenapoints or 0);

	end

end

function Toons_SortHonorUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.honorpoints or 0) < (player2.honorpoints or 0);

	end

end

function Toons_SortHonorDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.honorpoints or 0) > (player2.honorpoints or 0);

	end

end

function Toons_SortMarksUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.totalmark or 0) < (player2.totalmark or 0);

	end

end

function Toons_SortMarksDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.totalmark or 0) > (player2.totalmark or 0);

	end

end

function Toons_SortLkillUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.lifekill or 0) < (player2.lifekill or 0);

	end

end

function Toons_SortLkillDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.lifekill or 0) > (player2.lifekill or 0);

	end

end

function Toons_SortDailyUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.daily or 0) < (player2.daily or 0);

	end

end

function Toons_SortDailyDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.daily or 0) > (player2.daily or 0);

	end

end

function Toons_SortLastUp( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.ldate or 0) < (player2.ldate or 0);

	end

end

function Toons_SortLastDown( player1, player2 )

	if ( player1 and player2 ) then

		return (player1.ldate or 0) > (player2.ldate or 0);

	end

end