function FriendsFrameTab_OnLoad()

	local parent = FriendsFrame;

	local numTabs = parent.numTabs+1;

	PanelTemplates_SetNumTabs(parent, numTabs);

	PanelTemplates_EnableTab(parent, numTabs);

end



function FriendsFrameTab_CreateTab( subframe, subtext )

	local n=FriendsFrame.numTabs+1;

	local framename = "FriendsFrameTab"..n;

	frame = CreateFrame("Button", framename, FriendsFrame);

	frame:SetWidth(115);

	frame:SetHeight(32);

	frame:SetID(n);

	frame:SetPoint("LEFT", getglobal("FriendsFrameTab"..n-1), "RIGHT", -14, 0);

	frame:SetFrameLevel(FriendsFrame:GetFrameLevel() + 4);

	frame:SetScript("ONCLICK", function()

		PanelTemplates_Tab_OnClick(FriendsFrame);

		FriendsFrame_OnShow();

		GuildControlPopupFrame:Hide();

		GuildMemberDetailFrame:Hide();

		GuildInfoFrame:Hide();

		GuildFrame:Hide();

	end );

	frame:SetScript("ONSHOW", function()

		PanelTemplates_TabResize(0);

		getglobal(this:GetName().."HighlightTexture"):SetWidth(this:GetTextWidth() + 30);

	end );

	-- textures

	local texture;

	texture = frame:CreateTexture(framename.."LeftDisabled", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-ActiveTab");

	texture:SetWidth(20);

	texture:SetHeight(32);

	texture:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, 5);

	texture:SetTexCoord( 0, 0.15625, 0, 1.0 );

	texture = frame:CreateTexture(framename.."MiddleDisabled", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-ActiveTab");

	texture:SetWidth(88);

	texture:SetHeight(32);

	texture:SetPoint("LEFT", framename.."LeftDisabled", "RIGHT");

	texture:SetTexCoord( 0.15625, 0.84375, 0, 1.0 );

	texture = frame:CreateTexture(framename.."RightDisabled", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-ActiveTab");

	texture:SetWidth(20);

	texture:SetHeight(32);

	texture:SetPoint("LEFT", framename.."MiddleDisabled", "RIGHT");

	texture:SetTexCoord( 0.84375, 1.0, 0, 1.0 );

	texture = frame:CreateTexture(framename.."Left", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-InActiveTab");

	texture:SetWidth(20);

	texture:SetHeight(32);

	texture:SetPoint("TOPLEFT", frame, "TOPLEFT");

	texture:SetTexCoord( 0, 0.15625, 0, 1.0 );

	texture = frame:CreateTexture(framename.."Middle", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-InActiveTab");

	texture:SetWidth(88);

	texture:SetHeight(32);

	texture:SetPoint("LEFT", framename.."Left", "RIGHT");

	texture:SetTexCoord( 0.15625, 0.84375, 0, 1.0 );

	texture = frame:CreateTexture(framename.."Right", "BACKGROUND");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-InActiveTab");

	texture:SetWidth(20);

	texture:SetHeight(32);

	texture:SetPoint("LEFT", framename.."Middle", "RIGHT");

	texture:SetTexCoord( 0.84375, 1.0, 0, 1.0 );

	texture = frame:CreateTexture(framename.."HighlightTexture");

	texture:SetTexture("Interface\\PaperDollInfoFrame\\UI-Character-Tab-Highlight");

	texture:SetPoint("LEFT", framename, "LEFT", 10, 2);

	texture:SetPoint("RIGHT", framename, "RIGHT", -10, 2);

	texture:SetBlendMode("ADD");

	frame:SetHighlightTexture(texture);

	-- texts

	local font;

	font = frame:CreateFontString(framename.."Text");

	font:SetFontObject(GameFontNormalSmall);

	font:SetPoint("CENTER", frame, "CENTER", 0, 2);

	frame:SetTextFontObject(font:GetFontObject());

	font:SetText(subtext);

	font = frame:CreateFontString(framename.."HighlightText");

	font:SetFontObject(GameFontHighlightSmall);

	font:SetPoint("CENTER", frame, "CENTER", 0, 2);

	frame:SetHighlightFontObject(font:GetFontObject());

	font = frame:CreateFontString(framename.."DisabledText");

	font:SetFontObject(GameFontDisabledSmall);

	font:SetPoint("CENTER", frame, "CENTER", 0, 2);

	frame:SetDisabledFontObject(font:GetFontObject());

	FriendsFrameTab_OnLoad(); -- add to panel of tabs

	return frame, framename;

end



function FriendsFrameToonsTab_Initialize( frame )

	frame:SetScript("ONEVENT", FriendsFrame_Update);

	frame:SetScript("ONENTER", function()

		GameTooltip_AddNewbieTip(MicroButtonTooltipText(TEXT(T_TOONS), "TOGGLETOONSTAB"), 1.0, 1.0, 1.0, NEWBIE_TOOLTIP_TOONSTAB, 1);

	end );

	frame:SetScript("ONLEAVE", function()

		GameTooltip:Hide();

	end );

end



local oldFriendsFrame_Update = FriendsFrame_Update;

function FriendsFrame_Update()

	local frame=getglobal(ToonsTabFrame);

	if ( FriendsFrame.selectedTab == frame:GetID() ) then

		FriendsFrameTopLeft:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopLeft");

		FriendsFrameTopRight:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopRight");

		FriendsFrameBottomLeft:SetTexture("Interface\\FriendsFrame\\WhoFrame-BotLeft");

		FriendsFrameBottomRight:SetTexture("Interface\\FriendsFrame\\WhoFrame-BotRight");

		FriendsFrameTitleText:SetText(T_TOONS);

		FriendsFrame_ShowSubFrame("ToonsFrame");

		ToonsFrame_Update();

	else

		oldFriendsFrame_Update();

	end

end



function FriendsFrameToonsPlayerButton_OnClick(button)

	if ( button == "LeftButton" ) then

		ToonsFrame.selectedToon = this:GetID();

		ToonsFrame_Update();

	end

end



function ToonsFrameDeleteButton_OnClick(button)

	if ( ToonsFrame.selectedToon ) then

		local player = getglobal("ToonsFramePlayerButton"..ToonsFrame.selectedToon).player;

		local server = ToonsFrame.server;

        local i = 0;

		for k,v in pairs(TOONSTAB[server]) do

			i = i + 1;

		end

		if ( (player~=UnitName("player") or server~=GetRealmName() )and TOONSTAB[server][player] ) then

			TOONSTAB[server][player]=nil;

			if (i <= 1) then

				TOONSTAB[server]=nil;

				ToonsFrame.server=nil;

				ToonsServer = ToonsServer_Sort();

				ToonsFrameServerDropDown_Initialize();

			end

		ToonsFrame.selectedToon = nil;

		end

	end

	ToonsFrame_Update();

end



function ToonsFrameServerDropDown_OnLoad()

	UIDropDownMenu_Initialize(this, ToonsFrameServerDropDown_Initialize);

	UIDropDownMenu_SetWidth(130);

end



function ToonsFrameServerDropDown_Initialize()

	local info;

	for i=1, #(ToonsServer) do

		info = {};

		info.text = ToonsServer[i];

		if ( info.text==ToonsFrame.server ) then

			info.checked = 1;

		end

		info.owner = ToonsFrameServerDropDown;

		info.func = ToonsFrameServerButton_OnClick;

		UIDropDownMenu_AddButton(info);

	end

end



function ToonsFrameServerButton_OnClick()

	UIDropDownMenu_SetSelectedID(ToonsFrameServerDropDown, this:GetID());

	ToonsFrame_Update(this:GetText());

end



function ToonsFramePageDropDown_OnLoad()

	UIDropDownMenu_Initialize(this, ToonsFramePageDropDown_Initialize);

	UIDropDownMenu_SetWidth(80);

end



function ToonsFramePageDropDown_Initialize()

	local info;

	for i=1, #(ToonsPage) do

		info = {};

		info.text = TOONSPAGES[ToonsPage[i]].name;

		if ( info.text==ToonsFrame.page ) then

			info.checked = 1;

        end

		info.owner = ToonsFramePageDropDown;

		info.func = ToonsFramePageButton_OnClick;

		UIDropDownMenu_AddButton(info);

	end

end



function ToonsFramePageButton_OnClick(arg1, arg2)

	UIDropDownMenu_SetSelectedID(ToonsFramePageDropDown, this:GetID());

	ToonsFrame_Update(nil, ToonsPage[this:GetID()]);

end



function ToonsFrame_FormatTimePlayed( played )

	return format(TIMEPLAYEDFORMAT, ChatFrame_TimeBreakDown(played or 0) )

end



function ToonsFrame_Update( server, page )

	if ( not server ) then

		server = ToonsFrame.server;

	elseif ( TOONSTAB[server] ) then

		ToonsFrame.server = server;

	else

		server = GetRealmName();

		ToonsFrame.server = server;

	end

	if ( not page ) then

		page = ToonsFrame.page;

	elseif ( TOONSPAGES[page] ) then

		ToonsFrame.page = page;

	else

		page = "STATSFRAME";

		ToonsFrame.page = page;

	end

	ToonsTab_Update( "level", UnitLevel("player") );

	ToonsTab_Update( "zone", GetZoneText() );

--	ToonsTab_Update( "gold", GetMoney() );

	ToonsTab_Update( "homeinn", GetBindLocation() );

	local totalgold = 0;

	local totalplayed = 0;

	local sorted; -- = ToonsFrame_Sort(Toons_SortNameUp(), server );

	if (TOONSSORT[ToonsFrame.sortOrder]) then 
		sorted = ToonsFrame_Sort(TOONSSORT[ToonsFrame.sortOrder], server );
	else 
        sorted = ToonsFrame_Sort(TOONSSORT["NAME_UP"], server );
    end
    
	local index = #(sorted);

	for i=1, index do

		local stats=sorted[i];

		totalgold = totalgold + (stats.gold or 0);

		totalplayed = totalplayed + (stats.timeplayed or 0);

	end

	MoneyFrame_Update("ToonsFrameMoneyFrame", totalgold);

	ToonsFrameTotalPlayedText:SetText( ToonsFrame_FormatTimePlayed(totalplayed) );

	ToonsFramePlayedFrame:Hide();

	ToonsFrameXPFrame:Hide();

	ToonsFrameStatsFrame:Hide();

	ToonsFrameGuildFrame:Hide();

	ToonsFrameAssetsFrame:Hide();

	ToonsFrameTradeskillFrame:Hide();

    ToonsFrameSecondaryFrame:Hide();

	ToonsFrameRogueFrame:Hide();
	
	ToonsFrameHonorFrame:Hide();
	
	ToonsFrameDailyFrame:Hide();
-- staet pages
	if ( page=="STATSFRAME" ) then

		ToonsFrameStatsFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

			local color;

		--stats frame

			getglobal("ToonsFramePlayerButton"..i).player=stats.name;

			getglobal("ToonsFramePlayerButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFramePlayerButton"..i.."Level"):SetText(stats.level);

			color = {r=(stats.level)/MAX_LEVEL, g=1-(stats.level)/MAX_LEVEL, b=0 };

			getglobal("ToonsFramePlayerButton"..i.."Level"):SetTextColor(color.r, color.g, color.b);

			getglobal("ToonsFramePlayerButton"..i.."Race"):SetText(stats.race);

			color = TOONS_RACES[stats.raceEn].color;

			getglobal("ToonsFramePlayerButton"..i.."Race"):SetTextColor(color.r, color.g, color.b);

			getglobal("ToonsFramePlayerButton"..i.."Class"):SetText(stats.class);

			color = RAID_CLASS_COLORS[stats.classEn];

			getglobal("ToonsFramePlayerButton"..i.."Class"):SetTextColor(color.r, color.g, color.b);

			getglobal("ToonsFramePlayerButton"..i.."Zone"):SetText(stats.zone);

			-- Highlight the correct player

			local button = getglobal("ToonsFramePlayerButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end		

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFramePlayerButton"..i);

			getglobal("ToonsFramePlayerButton"..i.."Name"):SetText("");

			getglobal("ToonsFramePlayerButton"..i.."Level"):SetText("");

			getglobal("ToonsFramePlayerButton"..i.."Race"):SetText("");

			getglobal("ToonsFramePlayerButton"..i.."Class"):SetText("");

			getglobal("ToonsFramePlayerButton"..i.."Zone"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="XPFRAME" ) then

		ToonsFrameXPFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--experience frame

			getglobal("ToonsFrameXPButton"..i).player=stats.name;

			getglobal("ToonsFrameXPButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFrameXPButton"..i.."XP"):SetText(stats.xp);

			getglobal("ToonsFrameXPButton"..i.."XPMax"):SetText(stats.xpmax);

			getglobal("ToonsFrameXPButton"..i.."Rested"):SetText(stats.rested);

            if ( stats.xp ) then

				getglobal("ToonsFrameXPButton"..i.."XPPercent"):SetText(floor((stats.xp / stats.xpmax)*100));

			else

				getglobal("ToonsFrameXPButton"..i.."XPPercent"):SetText("");

			end

            if ( not stats.rested or stats.rested <= 0 ) then

                getglobal("ToonsFrameXPButton"..i.."Rested"):SetText("");

                getglobal("ToonsFrameXPButton"..i.."RestedPercent"):SetText("");         

            elseif (stats.rested > 0) then

                getglobal("ToonsFrameXPButton"..i.."RestedPercent"):SetText(floor(((stats.rested*100) / (stats.xpmax * 1.5))));

            end			

			-- Highlight the correct player

			local button = getglobal("ToonsFrameXPButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameXPButton"..i);

			getglobal("ToonsFrameXPButton"..i.."Name"):SetText("");

			getglobal("ToonsFrameXPButton"..i.."XP"):SetText("");

			getglobal("ToonsFrameXPButton"..i.."XPMax"):SetText("");

			getglobal("ToonsFrameXPButton"..i.."XPPercent"):SetText("");

			getglobal("ToonsFrameXPButton"..i.."Rested"):SetText("");

            getglobal("ToonsFrameXPButton"..i.."RestedPercent"):SetText("");

 			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="PLAYEDFRAME" ) then

		ToonsFramePlayedFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--time played frame

			getglobal("ToonsFramePlayedButton"..i).player=stats.name;

			getglobal("ToonsFramePlayedButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFramePlayedButton"..i.."TimePlayed"):SetText( ToonsFrame_FormatTimePlayed( stats.timeplayed) );

			getglobal("ToonsFramePlayedButton"..i.."TimeAtLevel"):SetText( ToonsFrame_FormatTimePlayed( stats.timeatlevel) );

			-- Highlight the correct player

			local button = getglobal("ToonsFramePlayedButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFramePlayedButton"..i);

			getglobal("ToonsFramePlayedButton"..i.."Name"):SetText("");

			getglobal("ToonsFramePlayedButton"..i.."TimePlayed"):SetText("");

			getglobal("ToonsFramePlayedButton"..i.."TimeAtLevel"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="GUILDFRAME" ) then

		ToonsFrameGuildFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--guild frame

			getglobal("ToonsFrameGuildButton"..i).player=stats.name;

			getglobal("ToonsFrameGuildButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFrameGuildButton"..i.."GuildName"):SetText(stats.guild);

			getglobal("ToonsFrameGuildButton"..i.."GuildRank"):SetText(stats.guildrank);

			-- Highlight the correct player

			local button = getglobal("ToonsFrameGuildButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameGuildButton"..i);

			getglobal("ToonsFrameGuildButton"..i.."Name"):SetText("");

			getglobal("ToonsFrameGuildButton"..i.."GuildName"):SetText("");

			getglobal("ToonsFrameGuildButton"..i.."GuildRank"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="ASSETSFRAME" ) then

		ToonsFrameAssetsFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--assets frame

			getglobal("ToonsFrameAssetsButton"..i).player=stats.name;

			getglobal("ToonsFrameAssetsButton"..i.."Name"):SetText(stats.name);

			MoneyFrame_Update("ToonsFrameAssetsButton"..i.."Gold", stats.gold);

			getglobal("ToonsFrameAssetsButton"..i.."Bags"):SetText((stats.bagssize or 0).."/"..(stats.bagsmax or 0));

			getglobal("ToonsFrameAssetsButton"..i.."Bank"):SetText((stats.banksize or 0).."/"..(stats.bankmax or 0));

			-- Highlight the correct player

			local button = getglobal("ToonsFrameAssetsButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameAssetsButton"..i);

			getglobal("ToonsFrameAssetsButton"..i.."Name"):SetText("");

			MoneyFrame_Update("ToonsFrameAssetsButton"..i.."Gold", 0);

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="TRADESKILLFRAME" ) then

		ToonsFrameTradeskillFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--tradeskill frame

			local color, text;

			getglobal("ToonsFrameTradeskillButton"..i).player=stats.name;

			getglobal("ToonsFrameTradeskillButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill1"):SetText(stats.tradeskill1);

			if ( not stats.tradeskill1 ) or ( stats.tradeskill1 == "") then 

				color = NORMAL_FONT_COLOR_CODE;

			else color = SKILL_TYPE[stats.tradeskill1].color;

			end

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill1"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill1rank )  and ( stats.tradeskill1rank ~= 0) then

				text = stats.tradeskill1rank.."/"..stats.tradeskill1max;

			else

				text = "";

			end

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill1Rank"):SetText(text);

			color = {r=(stats.tradeskill1rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill1rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill1rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill1Rank"):SetTextColor(color.r, color.g, color.b);

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill2"):SetText(stats.tradeskill2);

			if ( not stats.tradeskill2 )  or ( stats.tradeskill2 == "")then 

				color = NORMAL_FONT_COLOR_CODE;

			else color = SKILL_TYPE[stats.tradeskill2].color;

			end

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill2"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill2rank )  and ( stats.tradeskill2rank ~= 0)then

				text = stats.tradeskill2rank.."/"..stats.tradeskill2max;

			else

				text = "";

			end

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill2Rank"):SetText(text);

			color = {r=(stats.tradeskill2rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill2rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill2rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameTradeskillButton"..i.."Tradeskill2Rank"):SetTextColor(color.r, color.g, color.b);

			-- Highlight the correct player

			local button = getglobal("ToonsFrameTradeskillButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameTradeskillButton"..i);

			getglobal("ToonsFrameTradeskillButton"..i.."Name"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="SECONDARYFRAME" ) then

		ToonsFrameSecondaryFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--Secondary skill frame

			local color, text;

			getglobal("ToonsFrameSecondaryButton"..i).player=stats.name;

			getglobal("ToonsFrameSecondaryButton"..i.."Name"):SetText(stats.name);

			if ( stats.tradeskill3rank )   and ( stats.tradeskill3rank ~= 0)then

				text = stats.tradeskill3rank.."/"..stats.tradeskill3max;

			else

				text = "";

			end

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill3Rank"):SetText(text);

			color = {r=(stats.tradeskill3rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill3rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill3rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill3Rank"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill4rank )   and ( stats.tradeskill4rank ~= 0)then

				text = stats.tradeskill4rank.."/"..stats.tradeskill4max;

			else

				text = "";

			end

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill4Rank"):SetText(text);

			color = {r=(stats.tradeskill4rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill4rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill4rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill4Rank"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill5rank )   and ( stats.tradeskill5rank ~= 0)then

				text = stats.tradeskill5rank.."/"..stats.tradeskill5max;

			else

				text = "";

			end

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill5Rank"):SetText(text);

			color = {r=(stats.tradeskill5rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill5rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill5rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameSecondaryButton"..i.."Tradeskill5Rank"):SetTextColor(color.r, color.g, color.b);

			-- Highlight the correct player

			local button = getglobal("ToonsFrameSecondaryButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameSecondaryButton"..i);

			getglobal("ToonsFrameSecondaryButton"..i.."Name"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="ROGUEFRAME" ) then

		ToonsFrameRogueFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--rogueskill frame

			local color, text;

			getglobal("ToonsFrameRogueButton"..i).player=stats.name;

			getglobal("ToonsFrameRogueButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill6"):SetText(stats.tradeskill6 or "");

			color = SKILL_TYPE[stats.tradeskill6 or ""].color;

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill6"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill6rank ) and ( stats.tradeskill6rank ~= 0 ) then

				text = stats.tradeskill6rank.."/"..stats.tradeskill6max;

			else

				text = "";

			end

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill6Rank"):SetText(text);

			color = {r=(stats.tradeskill6rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill6rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill6rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill6Rank"):SetTextColor(color.r, color.g, color.b);

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill7"):SetText(stats.tradeskill7);

			color = SKILL_TYPE[stats.tradeskill7].color;

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill7"):SetTextColor(color.r, color.g, color.b);

			if ( stats.tradeskill7rank )  and ( stats.tradeskill7rank ~= 0 ) then

				text = stats.tradeskill7rank.."/"..stats.tradeskill7max;

			else

				text = "";

			end

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill7Rank"):SetText(text);

			color = {r=(stats.tradeskill7rank or 0)/MAX_SKILL, g=.5+(stats.tradeskill7rank or 0)/(MAX_SKILL*2), b=(stats.tradeskill7rank or 0)/MAX_SKILL };

			getglobal("ToonsFrameRogueButton"..i.."Tradeskill7Rank"):SetTextColor(color.r, color.g, color.b);

			-- Highlight the correct player

			local button = getglobal("ToonsFrameRogueButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameRogueButton"..i);

			getglobal("ToonsFrameRogueButton"..i.."Name"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end
-- new pages	
	elseif ( page=="HONORFRAME" ) then

		ToonsFrameHonorFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--honor frame

			local color, text;

			getglobal("ToonsFrameHonorButton"..i).player=stats.name;

			getglobal("ToonsFrameHonorButton"..i.."Name"):SetText(stats.name);

			getglobal("ToonsFrameHonorButton"..i.."ArenaPoints"):SetText(stats.arenapoints or 0);

			getglobal("ToonsFrameHonorButton"..i.."HonorPoints"):SetText(stats.honorpoints or 0);

			text =  stats.abmark.."/"..stats.avmark.."/"..stats.wgmark.."/"..stats.esmark;

			getglobal("ToonsFrameHonorButton"..i.."Marks"):SetText(text);

			getglobal("ToonsFrameHonorButton"..i.."LifeKill"):SetText(stats.lifekill or 0);


			-- Highlight the correct player

			local button = getglobal("ToonsFrameHonorButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameHonorButton"..i);

			getglobal("ToonsFrameHonorButton"..i.."Name"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	elseif ( page=="DAILYFRAME" ) then

		ToonsFrameDailyFrame:Show();

		for i=1, index do

			if ( i > MAX_TOONS ) then

				break;

			end

			local stats=sorted[i];

		--Daily frame
            local color, text, offline;
            
            local lday, lhour, lmin, timeerror = 0,0,0,0
            
            local now = time();
            
			getglobal("ToonsFrameDailyButton"..i).player=stats.name;

			getglobal("ToonsFrameDailyButton"..i.."Name"):SetText(stats.name);
-- find time since last logout
			if stats.ltime ~= 0 then
				
				offline = now - stats.ltime;
				
				if offline >= 86400 then
					
					lday = floor(offline/86400);
				
				elseif offline >= 3600 then
					
					lhour = floor(offline/3600);
				
				elseif offline >= 60 then
					
					lmin = floor(offline/60);
				
				else timeerror = 1;
				
				end
			
			else timeerror = 1;
			
			end
			
			if timeerror == 0 then
				if lday >= 1 then
					text = lday.."Days";
					color = { r=1, g=0, b=0};
				elseif (lhour < 23) and (lhour > 1) then
					text = lhour.."Hours"
					color = { r=1, g=1, b=0};
				elseif lmin>0 then
					text = lmin.."Minutes";
					color = { r=0, g=1, b=0};
				else text = "UNKNOWN";
					color = { r=1, g=0, b=0};
				end
				
			else text = "UNKNOWN";
				color = { r=1, g=0, b=0};
			end
				
			getglobal("ToonsFrameDailyButton"..i.."Last"):SetText(text);
			
			getglobal("ToonsFrameDailyButton"..i.."Last"):SetTextColor(color.r, color.g, color.b);


-- daily comes after last time to override color if needed
			text = stats.daily.."/"..stats.dailymax;
			
			getglobal("ToonsFrameDailyButton"..i.."Daily"):SetText(text);
			
			if stats.dailymax - stats.daily < 5 then
				
				color = { r=1, g=0, b=0};
			
			elseif  stats.dailymax - stats.daily < 15 then
				
				color = { r=1, g=1, b=0};
			
			else color = { r=0, g=1, b=0};
			
			end
			
			if lday >= 1 then
				
				color = { r=1, g=0, b=0};
			
			end
			
			getglobal("ToonsFrameDailyButton"..i.."Daily"):SetTextColor(color.r, color.g, color.b);


			-- Highlight the correct player

			local button = getglobal("ToonsFrameDailyButton"..i);

			button:Show();

			if ( ToonsFrame.selectedToon == i ) then

				button:LockHighlight();

			else

				button:UnlockHighlight();

			end

		end				

		for i=index+1, MAX_TOONS do

			local button = getglobal("ToonsFrameDailyButton"..i);

			getglobal("ToonsFrameDailyButton"..i.."Name"):SetText("");

			button:UnlockHighlight();

			button:Hide();

		end

	
	
	
	
	-- end of pages
	end

	--show individual info for selected toon

	local stats=sorted[ToonsFrame.selectedToon];

--	local color

	if ( stats ) then

        ToonsFrameIndividualGoldFrame:Hide();

		ToonsFrameIndividualFrame:Show();

		ToonsFrameIndividualGoldFrame:Hide();

		local text, font, color = "";

		-- stats

		font = ToonsFrameIndividualStatsText;

		text = NORMAL_FONT_COLOR_CODE..stats.name.."|r ";

		color = {r=(stats.level)/MAX_LEVEL, g=1-(stats.level)/MAX_LEVEL, b=0 };

		color = format("|cff%2x%2x%2x", color.r * 255, color.g *255, color.b * 255);

		text = text..", Level "..color..stats.level.."|r ";

		text = text..TOONS_RACES[stats.raceEn].fontcolor..stats.race.."|r ";

        color = RAID_CLASS_COLORS[stats.classEn];

        color = format("|cff%2x%2x%2x", color.r * 255, color.g *255, color.b * 255);

		text = text..color..stats.class.."|r ";

		text = text.." in "..stats.zone.." ";

		font:SetText(text);

		-- experience

		font = ToonsFrameIndividualXPText;

		text = NORMAL_FONT_COLOR_CODE..EXPERIENCE_COLON.."|r";

		if ( stats.xp ) then

			text = text..stats.xp.."/"..stats.xpmax.." @ "..(floor((stats.xp / stats.xpmax)*100)).."%";

	        if ( stats.rested ) and ( stats.rested ~= 0 )then

          	  text = text..NORMAL_FONT_COLOR_CODE.."  Rested:|r"..stats.rested.." @ "..(floor(((stats.rested * 100) / (stats.xpmax * 1.5)))).."% ";

			end

        end

		font:SetText(text);

		-- played

		font = ToonsFrameIndividualPlayedText;

		text = NORMAL_FONT_COLOR_CODE..T_TIMEPLAYED..":|r ";

		text = text..(ToonsFrame_FormatTimePlayed( stats.timeplayed)).." ";

		text = text..NORMAL_FONT_COLOR_CODE..T_THISLEVEL..":|r ";

		text = text..(ToonsFrame_FormatTimePlayed( stats.timeatlevel)).." ";

  		font:SetText(text);

		-- guild

        font = ToonsFrameIndividualGuildText;

		if ( stats.guild ) and (stats.guild ~= "") then

			text = NORMAL_FONT_COLOR_CODE..T_GUILD..":|r ";

			text = text..stats.guild.."   ";

			text = text..NORMAL_FONT_COLOR_CODE..T_RANK..":|r ";

			text = text..stats.guildrank.." ";

		else

			text = NORMAL_FONT_COLOR_CODE..oldGuildErrorMsg..":|r \n";

		end

		font:SetText(text);



		-- assets

		MoneyFrame_Update("ToonsFrameIndividualGoldFrame", stats.gold);

		ToonsFrameIndividualGoldFrame:Show();

		font = ToonsFrameIndividualAssetsText;

		text = NORMAL_FONT_COLOR_CODE..T_BAGS.."|r ";

		text = text..(stats.bagssize or 0).."/"..(stats.bagsmax or 0).." ";

		text = text..NORMAL_FONT_COLOR_CODE..T_BANK.."|r ";

		text = text..(stats.banksize or 0).."/"..(stats.bankmax or 0).." ";

		font:SetText(text);

		-- tradeskills

		font = ToonsFrameIndividualTradeskillText;

		if  ( not stats.tradeskill1 ) then

			text = T_NO_PROFESSIONS;

		elseif (stats.tradeskill1 == "") then

            text = T_NO_PROFESSIONS;

		else

			local color ;

			text = NORMAL_FONT_COLOR_CODE..T_TRADE_SKILL.." 1:|r ";

        	color = SKILL_TYPE[stats.tradeskill1].fontcolor;

			text = text..color..stats.tradeskill1.."|r  ";

			color=format("|cff%2x%2x%2x", stats.tradeskill1rank/MAX_SKILL*255 or 1, (.5+stats.tradeskill1rank/(MAX_SKILL*2))*255 or 1, stats.tradeskill1rank/MAX_SKILL*255 or 1);

			text = text..color..stats.tradeskill1rank.."/"..stats.tradeskill1max.." "..SKILL_RANK[stats.tradeskill1max].."|r ";

			if (stats.tradeskill2 == "") then

			elseif (stats.tradeskill2 ) then

				text = text.."\n"..NORMAL_FONT_COLOR_CODE..T_TRADE_SKILL.." 2:|r ";

                color = SKILL_TYPE[stats.tradeskill2].fontcolor;

				text = text..color..stats.tradeskill2.."|r  ";

        		color=format("|cff%2x%2x%2x", stats.tradeskill2rank/MAX_SKILL*255 or 1, (.5+stats.tradeskill2rank/(MAX_SKILL*2))*255 or 1, stats.tradeskill2rank/MAX_SKILL*255 or 1);

				text = text..color..stats.tradeskill2rank.."/"..stats.tradeskill2max.." "..SKILL_RANK[stats.tradeskill2max].."|r ";

			end

		end

  		font:SetText(text);

  		-- Hearthstone

		font = ToonsFrameIndividualHomeText;

		if ( not stats.homeinn ) or (stats.homeinn == "") then

			text = NORMAL_FONT_COLOR_CODE..T_HOME.."|r ".." unknown";

  		else

			if (stats.homeinn == "your inn") then

    			text = "You are currently homeless";

        	else text = NORMAL_FONT_COLOR_CODE..T_HOME.."|r "..(stats.homeinn);

			end

		end

        font:SetText(text);

	else

		ToonsFrameIndividualFrame:Hide();		

	end	

end