-- Show all characters on account

-- Stats to show: name, race, class, level, zone, guild, professions, gold, Xp, rested bonus, bag slots, bank slots, hearthstone

-- Bottom pane: show all relevant stats for selected character

TOONSTAB={};

TOONSVAR={};

ToonsServer={};

ToonsPage={};

TOONSVAR.ToonsVersion=T_VERSION;

MoneyTypeInfo["ASSETS"] = {

	UpdateFunc = function()

		return this.staticMoney;

	end,

	collapse = 1,

	showSmallerCoins = "Backpack",

};

tinsert(FRIENDSFRAME_SUBFRAMES, "ToonsFrame");

function ToonsFrame_OnLoad()

	this:RegisterEvent("VARIABLES_LOADED");

	this:RegisterEvent("PLAYER_ENTERING_WORLD");

	this:RegisterEvent("PLAYER_LEAVING_WORLD");

	this:RegisterEvent("PLAYER_LOGOUT");

	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");

	this:RegisterEvent("TIME_PLAYED_MSG");

	this:RegisterEvent("PLAYER_MONEY");

    FriendsFrameToonsTab, ToonsTabFrame = FriendsFrameTab_CreateTab("ToonsFrame", TOONS);

	FriendsFrameToonsTab_Initialize( getglobal(ToonsTabFrame) );

	ChatFrame_DisplayTimePlayed = Toons_ChatFrame_DisplayTimePlayed;

end

function ToonsFrame_OnShow()

	Toons_RequestTimePlayed();

	Toons_GetTradeskillInfo();

    Toons_Honor();

	Toons_Daily();

	SetPortraitTexture(ToonsFramePortrait, "player");

end

function ToonsFrame_OnHide()

	SetPortraitTexture(ToonsFramePortrait, "player");

end

function ToonsFrame_OnEvent()

	if (event=="VARIABLES_LOADED") then 

        local server = GetRealmName();

		local player = UnitName("player");

		if (not TOONSTAB) or (not TOONSTAB[server]) or (not TOONSTAB[server][player]) then

   			Toons_CreateToon();

		end

  		Toons_All_Data_Check();

		ToonsFrame.sortOrder = TOONSVAR.sortOrder;

		ToonsFrame.page = TOONSVAR.page;

		ToonsFrame.server = server;

		ToonsPage = ToonsPage_Sort();

		ToonsServer = ToonsServer_Sort();

		this:RegisterEvent("PLAYER_LEVEL_UP");

		this:RegisterEvent("PLAYER_XP_UPDATE");

 		this:RegisterEvent("PLAYER_UPDATE_RESTING");

	    this:RegisterEvent("UPDATE_EXHAUSTION");	

		this:RegisterEvent("TRADE_SKILL_UPDATE");

		this:RegisterEvent("TRADE_SKILL_CLOSE");

		this:RegisterEvent("UNIT_PORTRAIT_UPDATE");
		
		this:RegisterEvent("CHAT_MSG_COMBAT_HONOR_GAIN");

		DEFAULT_CHAT_FRAME:AddMessage("|cffff0000 Toons "..T_VERSION.." successfully loaded |r");
		
		if IsAddOnLoaded("myAddons") then
			Toonsdetails = {
			name = TOONS, version = T_VERSION, releaseDate = T_DATE, author = T_AUTNOR,
			website = 'http://www.wowinterface.com/downloads/fileinfo.php?id=8529#cmnt67322',
			category = MYADDONS_CATEGORY_OTHERS,
			};
		myAddOnsFrame_Register(Toonsdetails);
		end

	elseif (event=="PLAYER_ENTERING_WORLD") then

        oldGuildErrorMsg = ERR_GUILD_PLAYER_NOT_IN_GUILD;

		local xprested= GetXPExhaustion("");

        local homeinn = GetBindLocation ();
        
        local money = GetMoney ();

		ERR_GUILD_PLAYER_NOT_IN_GUILD = "";

		this:RegisterEvent("BAG_UPDATE");

		this:RegisterEvent("PLAYERBANKSLOTS_CHANGED");

		this:RegisterEvent("BANKFRAME_OPENED");

		this:RegisterEvent("GUILD_ROSTER_UPDATE");
		
		this:RegisterEvent("QUEST_COMPLETE");

		ToonsTab_Update("xp", UnitXP("player"));

		ToonsTab_Update("xpmax", UnitXPMax("player"));

		ToonsTab_Update( "rested", xprested );

		ToonsTab_Update( "gold", money );

        GuildRoster();

		Toons_RequestTimePlayed();

		Toons_GetTradeskillInfo();
		
		Toons_Honor();

		Toons_Daily();

	elseif (event=="PLAYER_LEAVING_WORLD") then

		this:UnregisterEvent("BAG_UPDATE");

		this:UnregisterEvent("PLAYERBANKSLOTS_CHANGED");

		this:UnregisterEvent("BANKFRAME_OPENED");

		this:UnregisterEvent("GUILD_ROSTER_UPDATE");

	elseif (event=="PLAYER_LOGOUT") then

		Toons_LastPlayed();

		TOONSVAR.sortOrder = ToonsFrame.sortOrder;

		TOONSVAR.page = ToonsFrame.page;

		TOONSVAR.memused, TOONSVAR.garbage = gcinfo();

	elseif (event=="ZONE_CHANGED_NEW_AREA") then

		ToonsTab_Update( "zone", GetZoneText() );

		ToonsFrame_Update();

	elseif (event=="BAG_UPDATE") then

		if ( arg1 <= NUM_BAG_SLOTS ) then

			Toons_BagsSizeUpdate();

		elseif ( BankFrame:IsVisible() and arg1 > NUM_BAG_SLOTS and arg1 < NUM_BAG_SLOTS+NUM_BANKBAGSLOTS ) then

			Toons_BankSizeUpdate();

		end

		Toons_Marks();

		ToonsFrame_Update();

	elseif (event=="PLAYER_MONEY") then

		local money = GetMoney ();

		ToonsTab_Update( "gold", money );

		ToonsFrame_Update();

	elseif ((event=="PLAYERBANKSLOTS_CHANGED") 

		or (event=="BANKFRAME_OPENED")) then

		Toons_BankSizeUpdate();

		Toons_Marks();

		ToonsFrame_Update();

	elseif (event=="TRADE_SKILL_UPDATE")

		or (event=="TRADE_SKILL_CLOSE") then

		Toons_GetTradeskillInfo();

		ToonsFrame_Update();

	elseif (event=="PLAYER_LEVEL_UP") then

		ToonsTab_Update( "level", arg1 );

		ToonsFrame_Update();

	elseif ((event=="PLAYER_XP_UPDATE")

        or (event=="PLAYER_UPDATE_RESTING")

        or (event=="UPDATE_EXHAUSTION")) then

		local xprested= GetXPExhaustion("");

        ToonsTab_Update( "xp", UnitXP("player") );

		ToonsTab_Update( "xpmax", UnitXPMax("player") );

		ToonsTab_Update( "rested", xprested );

        ToonsFrame_Update();

    elseif (event=="GUILD_ROSTER_UPDATE") then

		local guild, rank, index = GetGuildInfo("player");

		local server = GetRealmName();

		local player = UnitName("player");

		if ( TOONSTAB and TOONSTAB[server] and TOONSTAB[server][player] ) then

			TOONSTAB[server][player].guild = guild or "";

			TOONSTAB[server][player].guildrank = rank or "";

			TOONSTAB[server][player].guildindex = index or 0;

		end

		ToonsFrame_Update();

	elseif (event=="TIME_PLAYED_MSG") then

		ToonsTab_Update( "timeplayed", arg1 );

		ToonsTab_Update( "timeatlevel", arg2 );

		ToonsFrame_Update();

	elseif ( event == "UNIT_PORTRAIT_UPDATE" ) then

		if ( arg1 == "player" ) then

			SetPortraitTexture(ToonsFramePortrait, arg1);

		end

	elseif ( event == "CHAT_MSG_COMBAT_HONOR_GAIN" ) then
	
	    Toons_Honor();

	elseif ( event == "QUEST_COMPLETE" ) then

		Toons_Daily();

	end

end

function ToonsTab_Update( key, value )

	local server = GetRealmName();

	local player = UnitName("player");

	if ( TOONSTAB and TOONSTAB[server] and TOONSTAB[server][player] ) then

		TOONSTAB[server][player][key] = value;

		return key, value;

	end

end

function ToonsTab_UpdateAll()

	local server = GetRealmName();

	local player = UnitName("player");

	local xprested= GetXPExhaustion("");

	local guild, rank, index = GetGuildInfo("player");

	ToonsTab_Update( "name", player );

	ToonsTab_Update( "race", UnitRace("player") );

	ToonsTab_Update( "class", UnitClass("player") );

	ToonsTab_Update( "level", UnitLevel("player") );

	ToonsTab_Update( "zone", GetZoneText() );

	ToonsTab_Update( "gold", GetMoney() );

	ToonsTab_Update( "homeinn", GetBindLocation() );

	ToonsTab_Update( "xp", UnitXP("player") );

	ToonsTab_Update( "xpmax", UnitXPMax("player") );

	ToonsTab_Update( "rested", xprested );

 	ToonsTab_Update( "guild", guild );

 	ToonsTab_Update( "guildindex", index );

	ToonsTab_Update( "guildrank", rank );

    Toons_GetTradeskillInfo();

    ToonsFrame_Update();

end

function ToonsServer_GetID( server )

	for i=1, #(ToonsServer) do

		if ( ToonsServer[i]==server ) then

			return i;

		end

	end

end

function ToonsPage_GetID( page )

	for i=1, #(ToonsPage) do

		if ( ToonsPage[i]==page ) then

			return i;

		end

	end

end

function Toons_RequestTimePlayed()

	Toons_RequestTime = 1;

	RequestTimePlayed();

end

local old_ChatFrame_DisplayTimePlayed = ChatFrame_DisplayTimePlayed;

function Toons_ChatFrame_DisplayTimePlayed(totalTime, levelTime)

	if ( Toons_RequestTime ) then

		Toons_RequestTime = nil;

		return;

	else

		old_ChatFrame_DisplayTimePlayed(totalTime, levelTime);

	end

end

function Toons_BagsSizeUpdate()

	local size, max = 0, 0;

	for bag=0,4 do

		max = max+GetContainerNumSlots(bag);

		for slot=1, GetContainerNumSlots(bag) do

			local texture, itemCount = GetContainerItemInfo(bag, slot);

			if ( itemCount ) then

				size = size + 1;

			end

		end

	end

	ToonsTab_Update( "bagssize", size );

	ToonsTab_Update( "bagsmax", max );

	return size, max;

end

function Toons_BankSizeUpdate()

	local size, max = 0, 24;

	for slotId=40,63 do -- bank slots as inventory ids

		if ( GetInventoryItemLink("player", slotId) ) then

			size = size + 1;

		end

	end

	for bag=NUM_BAG_SLOTS+1, NUM_BAG_SLOTS+GetNumBankSlots() do

		max = max+GetContainerNumSlots(bag);

		for slot=1, GetContainerNumSlots(bag) do

			if ( GetContainerItemLink(bag, slot) ) then

				size = size + 1;

			end

		end

	end

	ToonsTab_Update( "banksize", size );

	ToonsTab_Update( "bankmax", max );

	return size, max;

end

function Toons_GetTradeskillInfo()

	local profIndex=0;

	local oldskill="";

    local oldrank=0;

    local oldmax=0;

    for j=5,7 do

		if ( GetSkillLineInfo(j)==TRADE_SKILLS ) then

			profIndex = j;

			break;

		end

	end

	local server, player = GetRealmName(), UnitName("player");

    local skill, header, _, curr, _, _, max = GetSkillLineInfo(1+profIndex);

    local oldskill = TOONSTAB[server][player].tradeskill1 or "";

    local oldrank = TOONSTAB[server][player].tradeskill1rank or 0;

    local oldmax = TOONSTAB[server][player].tradeskill1max or 0;

    local newskill = SKILL_TYPE[skill] and skill;

	if ( newskill and (newskill~=oldskill or oldrank== 0 or curr>oldrank or max>oldmax) ) then

        ToonsTab_Update( "tradeskill1", skill );

        ToonsTab_Update( "tradeskill1rank", curr );

        ToonsTab_Update( "tradeskill1max", max );

    end

    local skill, header, _, curr, _, _, max = GetSkillLineInfo(2+profIndex);

    local oldskill = TOONSTAB[server][player].tradeskill2 or "";

    local oldrank = TOONSTAB[server][player].tradeskill2rank or 0;

    local oldmax = TOONSTAB[server][player].tradeskill2max or 0;

    local newskill = SKILL_TYPE[skill] and skill;

	if ( newskill and (newskill~=oldskill or oldrank== 0 or curr>oldrank or max>oldmax) ) then

        ToonsTab_Update( "tradeskill2", skill );

        ToonsTab_Update( "tradeskill2rank", curr );

        ToonsTab_Update( "tradeskill2max", max );

    end

	  for s=1,15 do

        local skill, header, _, curr, _, _, max = GetSkillLineInfo(s);

        if ( skill == T_COOKING ) then

			local oldskill = TOONSTAB[server][player].tradeskill3 or "";

			local oldrank = TOONSTAB[server][player].tradeskill3rank or 0;

		    local oldmax = TOONSTAB[server][player].tradeskill3max or 0;

            local newskill = SKILL_TYPE[skill] and skill;

            if ( newskill and (newskill~=oldskill or oldrank==0 or curr>oldrank or max>oldmax) ) then

                ToonsTab_Update( "tradeskill3", skill );

                ToonsTab_Update( "tradeskill3rank", curr );

                ToonsTab_Update( "tradeskill3max", max );

            end

        elseif ( skill == T_FIRSTAID ) then

			local oldskill = TOONSTAB[server][player].tradeskill4 or "";

			local oldrank = TOONSTAB[server][player].tradeskill4rank or 0;

		    local oldmax = TOONSTAB[server][player].tradeskill4max or 0;

            local newskill = SKILL_TYPE[skill] and skill;

            if ( newskill and (newskill~=oldskill or oldrank==0 or curr>oldrank or max>oldmax) ) then

                ToonsTab_Update( "tradeskill4", skill );

                ToonsTab_Update( "tradeskill4rank", curr );

                ToonsTab_Update( "tradeskill4max", max );

            end

        elseif ( skill == T_FISHING ) then

			local oldskill = TOONSTAB[server][player].tradeskill5 or "";

			local oldrank = TOONSTAB[server][player].tradeskill5rank or 0;

		    local oldmax = TOONSTAB[server][player].tradeskill5max or 0;

            local newskill = SKILL_TYPE[skill] and skill;

            if ( newskill and (newskill~=oldskill or oldrank==0 or curr>oldrank or max>oldmax) ) then

                ToonsTab_Update( "tradeskill5", skill );

                ToonsTab_Update( "tradeskill5rank", curr );

                ToonsTab_Update( "tradeskill5max", max );

            end

        elseif ( skill == T_LOCKPICKING ) then

			local oldskill = TOONSTAB[server][player].tradeskill6 or "";

			local oldrank = TOONSTAB[server][player].tradeskill6rank or 0;

		    local oldmax = TOONSTAB[server][player].tradeskill6max or 0;

            local newskill = SKILL_TYPE[skill] and skill;

            if ( newskill and (newskill~=oldskill or oldrank==0 or curr>oldrank or max>oldmax) ) then

                ToonsTab_Update( "tradeskill6", skill );

                ToonsTab_Update( "tradeskill6rank", curr );

                ToonsTab_Update( "tradeskill6max", max );

            end

        elseif ( skill == T_POISONS ) then

			local oldskill = TOONSTAB[server][player].tradeskill7 or "";

			local oldrank = TOONSTAB[server][player].tradeskill7rank or 0;

		    local oldmax = TOONSTAB[server][player].tradeskill7max or 0;

            local newskill = SKILL_TYPE[skill] and skill;

            if ( newskill and (newskill~=oldskill or oldrank==0 or curr>oldrank or max>oldmax) ) then

                ToonsTab_Update( "tradeskill7", skill );

                ToonsTab_Update( "tradeskill7rank", curr );

                ToonsTab_Update( "tradeskill7max", max );

            end 

		end

	end

end

function Toons_CreateToon(server, player)

    -- Create saved variables that don't already exist

    local server = GetRealmName();

	local player = UnitName("player");

	local race, raceEn = UnitRace("player");

	local class, classEn = UnitClass("player");

	local level = UnitLevel("player");

	local gold = GetMoney();

	local zone = GetZoneText();

	local guild, guildrank, guildindex = GetGuildInfo("player");

	if ( not TOONSVAR ) then

		TOONSVAR = {};

	end

	if ( not TOONSVAR.sortOrder ) then

		TOONSVAR.sortOrder = "LEVEL_DOWN";

	end

	if ( not TOONSVAR.page ) then

		TOONSVAR.page = "STATSFRAME";

	end

	if ( not TOONSVAR.memused ) then

		TOONSVAR.memused = "";

	end

	if ( not TOONSVAR.garbage ) then

		TOONSVAR.garbage = "";

	end

	if ( not TOONSTAB) then

		TOONSTAB = {};

	end

	if ( not TOONSTAB[server] ) then

        TOONSTAB[server] = {} ;

	end

	if ( not TOONSTAB[server][player] ) then

        TOONSTAB[server][player] = {} ;       

	end	

	for i,v in pairs(TOONSDATA) do

		if (not TOONSTAB[server][player][i]) then

			TOONSTAB[server][player][i]= v;

		end

	end	

	TOONSTAB[server][player].name = player;

	TOONSTAB[server][player].race = race;

	TOONSTAB[server][player].raceEn = raceEn;

	TOONSTAB[server][player].class = class;

	TOONSTAB[server][player].classEn = classEn;

	TOONSTAB[server][player].level = level;

	TOONSTAB[server][player].gold = gold;

	TOONSTAB[server][player].zone = zone;

    if ( TOONSTAB and TOONSTAB[server] and TOONSTAB[server][player] ) then

		TOONSTAB[server][player].guild = guild or "";

		TOONSTAB[server][player].guildrank = rank or "";

		TOONSTAB[server][player].guildindex = index or 0;

	end

end

function Toons_All_Data_Check()

	local server,player, data;

	if ( not TOONSTAB) then

		TOONSTAB = {};

	else

	for server,data in pairs(TOONSTAB) do

		for player,data in pairs(TOONSTAB[server]) do

			for i,v in pairs(TOONSDATA) do

				if (not TOONSTAB[server][player][i]) then

					TOONSTAB[server][player][i]= v;

				elseif (TOONSTAB[server][player][i]=="") then

					TOONSTAB[server][player][i]= v;

				end

			end

		end	

	end

	end

end

function Toons_Honor()

	local hp = GetHonorCurrency();

	local ap = GetArenaCurrency();

	local lk = GetPVPLifetimeStats();

	ToonsTab_Update( "honorpoints", hp );

	ToonsTab_Update( "arenapoints", ap );

	ToonsTab_Update( "lifekill", lk );

end

function Toons_Marks()

	local ab = GetItemCount(20559, 1);

	local av = GetItemCount(20560, 1);

	local wg = GetItemCount(20588, 1);

	local es = GetItemCount(29024, 1);

	local tm = ab + av + wg + es;

	ToonsTab_Update( "abmark", ab );

	ToonsTab_Update( "avmark", av );

	ToonsTab_Update( "wgmark", wg );

	ToonsTab_Update( "esmark", es );

	ToonsTab_Update( "totalmark", tm );

end

function Toons_Daily()

	local dm = GetMaxDailyQuests();

	local dc = GetDailyQuestsCompleted();

	local dl = dm - dc;

	ToonsTab_Update( "daily", dl );

	ToonsTab_Update( "dailymax", dm );

end

function Toons_LastPlayed()

	local ltime = time();

	ToonsTab_Update( "ltime", ltime );

end